/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * The contents of this file are subject to the Netscape Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is Mozilla Communicator client code, 
 * released March 31, 1998. 
 *
 * The Initial Developer of the Original Code is Netscape Communications 
 * Corporation.  Portions created by Netscape are
 * Copyright (C) 1998-1999 Netscape Communications Corporation. All
 * Rights Reserved.
 *
 * Contributor(s): 
 *     Don Bragg <dbragg@netscape.com>
 */

#ifndef _nsPROCESSWIN_H_
#define _nsPROCESSWIN_H_

#include "nsIProcess.h"
#include "nsXPIDLString.h"
#include "prproces.h"

#define NS_PROCESS_CID \
{0x7b4eeb20, 0xd781, 0x11d4, \
   {0x8A, 0x83, 0x00, 0x10, 0xa4, 0xe0, 0xc9, 0xca}}

class nsProcess : public nsIProcess
{
public:

  NS_DECL_ISUPPORTS
  NS_DECL_NSIPROCESS

  nsProcess();
  virtual ~nsProcess();

private:
  nsCOMPtr<nsIFile> mExecutable;
  PRInt32 mExitValue;
  nsXPIDLCString mTargetPath;
  PRProcess *mProcess;

};

#endif
