#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2025 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Saints Row: The Third
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250828.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='saints-row-3'
GAME_NAME='Saints Row: The Third'

ARCHIVE_BASE_0_NAME='setup_saints_row_3_1.05_(18826).exe'
ARCHIVE_BASE_0_MD5='247920ee92146f3aa8b12e98ed581205'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_saints_row_3_1.05_(18826)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='b05253bb7d5dcd7d22fcc31037abbb8f'
ARCHIVE_BASE_0_PART2_NAME='setup_saints_row_3_1.05_(18826)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='d0d56c9f28966c4b55b8926de46b28c4'
ARCHIVE_BASE_0_PART3_NAME='setup_saints_row_3_1.05_(18826)-3.bin'
ARCHIVE_BASE_0_PART3_MD5='2f94ec5a61562e27b68eea8adf42ea10'
ARCHIVE_BASE_0_SIZE='9793983'
ARCHIVE_BASE_0_VERSION='1.05-gog18826'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/saints_row_the_third_the_full_package'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_BIN_FILES='
binkw32.dll
saintsrowthethird.exe
saintsrowthethird_dx11.exe
viewed.dat'
## steam_api.dll can not be dropped, saintsrowthethird.exe
## and saintsrowthethird_dx11.exe are linked against it.
CONTENT_GAME0_BIN_FILES='
steam_api.dll'
CONTENT_GAME1_BIN_RELATIVE_PATH='__support/app'
CONTENT_GAME1_BIN_FILES='
display.ini'
CONTENT_GAME_DATA_FILES='
packfiles
videos'
CONTENT_DOC_L10N_FR_FILES='
readme_saintsrowthethird_fr.txt'
CONTENT_DOC_L10N_EN_FILES='
readme_saintsrowthethird_en.txt'
CONTENT_DOC_DATA_FILES='
manual.pdf
changelist.txt'

USER_PERSISTENT_FILES='
viewed.dat
display.ini
gog.ini'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Local/Saints Row The Third'

APP_MAIN_EXE='saintsrowthethird_dx11.exe'

PACKAGES_LIST='
PKG_BIN
PKG_L10N_FR
PKG_L10N_EN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_L10N
PKG_DATA'

PKG_L10N_ID="${GAME_ID}-l10n"
PKG_L10N_FR_ID="${PKG_L10N_ID}-fr"
PKG_L10N_EN_ID="${PKG_L10N_ID}-en"
PKG_L10N_PROVIDES="
$PKG_L10N_ID"
PKG_L10N_FR_DESCRIPTION='French localisation'
PKG_L10N_EN_DESCRIPTION='English localisation'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'

## Set locale-specific configuration.
config_file_source="${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/__support/app/gog.ini"
config_file_destination_fr="$(package_path 'PKG_L10N_FR')$(path_game_data)/gog.ini"
config_file_destination_en="$(package_path 'PKG_L10N_EN')$(path_game_data)/gog.ini"
mkdir --parents \
	"$(dirname "$config_file_destination_fr")" \
	"$(dirname "$config_file_destination_en")"
sed --expression='s/Language=.*/Language=French/' "$config_file_source" > "$config_file_destination_fr"
sed --expression='s/Language=.*/Language=English/' "$config_file_source" > "$config_file_destination_en"

content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
case "$(messages_language)" in
	('fr')
		lang_string='version %s :'
		lang_fr='française'
		lang_en='anglaise'
	;;
	('en'|*)
		lang_string='%s version:'
		lang_fr='French'
		lang_en='English'
	;;
esac
printf '\n'
printf "$lang_string" "$lang_fr"
print_instructions 'PKG_BIN' 'PKG_DATA' 'PKG_L10N_FR'
printf "$lang_string" "$lang_en"
print_instructions 'PKG_BIN' 'PKG_DATA' 'PKG_L10N_EN'

# Clean up

working_directory_cleanup

exit 0
