/*
    msgbox.c - Provide some simple message boxes
    Copyright (c) 1998,9,2006  Joey Schulze <joey@infodrom.org>

    This file is part of the Gerstensaft package.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111, USA.
*/

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "msgbox.h"
#include "config.h"
#include "nls.h"
#include "beer.h"

gint msgbox_delete(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  return FALSE;
}

void msgbox_about(GtkWidget *widget, gpointer data)
{
  GtkWidget *dialog;
  GtkWidget *hbox, *vbox;
  GtkWidget *label;
  GtkWidget *button;
  char buf[1024];
  GdkPixmap *beer_pixmap;
  GdkBitmap *beer_mask;
  GtkStyle *style;

  dialog = gtk_dialog_new();

  gtk_window_set_title (GTK_WINDOW (dialog), _("About Gerstensaft"));
  g_signal_connect (G_OBJECT (dialog), "delete_event",
		    G_CALLBACK (msgbox_delete), (gpointer) dialog);
  g_signal_connect_swapped (G_OBJECT (dialog), "destroy",
			    G_CALLBACK (gtk_widget_destroy), (gpointer) dialog);

  /* Horizontal box with pix on the left, text on the right */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), hbox, TRUE, TRUE, 5);
  gtk_widget_show (hbox);
  gtk_widget_show (dialog);

  snprintf (buf, sizeof(buf), "%s/%s", PIXMAP_DIR, "gerstensaft.xpm");
  style = gtk_widget_get_style (dialog);
  beer_pixmap = gdk_pixmap_create_from_xpm (dialog->window, &beer_mask, &style->bg[GTK_STATE_NORMAL], buf);
  if (beer_pixmap != NULL) {
    label = gtk_pixmap_new (beer_pixmap, beer_mask);
    gtk_box_pack_start (GTK_BOX(hbox), label, FALSE, FALSE, 0);
    gtk_widget_show (label);
  }

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_border_width (GTK_CONTAINER(vbox), 5);
  gtk_box_pack_start (GTK_BOX(hbox), vbox, FALSE, FALSE, 0);

  label = gtk_label_new (" ");
  gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 5);
  gtk_widget_show (label);
  label = gtk_label_new (" ");
  gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 5);
  gtk_widget_show (label);

  snprintf(buf, sizeof(buf), "Gerstensaft %s", version);
  label = gtk_label_new (buf);
  gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 5);
  gtk_widget_show (label);

  label = gtk_label_new (_("  Graphical frontend to SAFT  "));
  gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 5);
  gtk_widget_show (label);

  label = gtk_label_new ("  Joey Schulze <joey@infodrom.org>  ");
  gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 5);
  gtk_widget_show (label);

  label = gtk_label_new ("http://www.infodrom.org/projects/gerstensaft/");
  gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 5);
  gtk_widget_show (label);
  gtk_widget_show (vbox);

  button = gtk_button_new_from_stock ("gtk-close");
  g_signal_connect_swapped (G_OBJECT (button), "clicked",
			    G_CALLBACK (gtk_widget_destroy), (gpointer) dialog);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialog)->action_area), button, TRUE, FALSE, 0);
  gtk_widget_show (button);
  gtk_widget_grab_default (button);
}

void msgbox_todo (GtkWidget *widget, gpointer data)
{
  GtkWidget *dialog;
  GtkWidget *box;
  GtkWidget *label;
  GtkWidget *button;
  char buf[1024];
  GdkPixmap *beer_pixmap;
  GdkBitmap *beer_mask;
  GtkStyle *style;

  dialog = gtk_dialog_new();

  gtk_window_set_title (GTK_WINDOW (dialog), _("Gerstensaft Todo"));
  g_signal_connect (G_OBJECT (dialog), "delete_event",
		    G_CALLBACK (msgbox_delete), (gpointer) dialog);
  g_signal_connect (G_OBJECT (dialog), "destroy",
		    G_CALLBACK (gtk_widget_destroy), NULL);

  box = gtk_vbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), box, TRUE, TRUE, 5);
  gtk_widget_show (box);
  gtk_widget_show (dialog);

  snprintf(buf, sizeof(buf), "Gerstensaft %s", version);
  label = gtk_label_new (buf);
  gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 5);
  gtk_widget_show (label);

  snprintf (buf, sizeof(buf), "%s/%s", PIXMAP_WM_DIR, "beer.xpm");
  style = gtk_widget_get_style (dialog);
  beer_pixmap = gdk_pixmap_create_from_xpm (dialog->window, &beer_mask, &style->bg[GTK_STATE_NORMAL], buf);

  if (beer_pixmap != NULL) {
    label = gtk_pixmap_new (beer_pixmap, beer_mask);
    gtk_box_pack_start (GTK_BOX(box), label, FALSE, FALSE, 0);
    gtk_widget_show (label);
  }

  label = gtk_label_new (_("  Things to do for Gerstensaft  "));
  gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 5);
  gtk_widget_show (label);

  label = gtk_label_new (_("  Select/Unselect via pattern  "));
  gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 5);
  gtk_widget_show (label);

  label = gtk_label_new (_("  Gnomification / Support for drag and drop  "));
  gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 5);
  gtk_widget_show (label);

  button = gtk_button_new_from_stock ("gtk-close");
  g_signal_connect_swapped (G_OBJECT (button), "clicked",
			    G_CALLBACK (gtk_widget_destroy), (gpointer) dialog);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialog)->action_area), button, TRUE, FALSE, 0);
  gtk_widget_show (button);
  gtk_widget_grab_default (button);
}

void msgbox (const char *title, const char *text)
{
  GtkWidget *dialog;
  GtkWidget *box;
  GtkWidget *label;
  GtkWidget *button;

  if (!title || !strlen(title) || !text || !strlen(text))
    return;

  dialog = gtk_dialog_new();
  gtk_grab_add (dialog);
  gtk_window_set_title(GTK_WINDOW (dialog), title);
  gtk_widget_set_usize (GTK_WIDGET (dialog), 400, 130);
  g_signal_connect (G_OBJECT (dialog), "delete_event",
		    G_CALLBACK (msgbox_delete), (gpointer) dialog);
  g_signal_connect (G_OBJECT (dialog), "destroy",
		    G_CALLBACK (gtk_widget_destroy), NULL);

  box = gtk_vbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), box, TRUE, TRUE, 5);
  gtk_widget_show (box);

  label = gtk_label_new (text);
  gtk_label_set_line_wrap (GTK_LABEL(label), TRUE);
  gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 5);
  gtk_widget_show (label);

  button = gtk_button_new_from_stock ("gtk-close");
  g_signal_connect_swapped (G_OBJECT (button), "clicked",
			    G_CALLBACK (gtk_widget_destroy), (gpointer) dialog);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialog)->action_area), 
		      button, TRUE, FALSE, 0);
  gtk_widget_show (button);
  gtk_widget_grab_default (button);

  gtk_widget_show (dialog);
}

/*
 * Will return one of
 *
 *    GTK_RESPONSE_DELETE_EVENT (-4)
 *    GTK_RESPONSE_OK           (-5)
 *    GTK_RESPONSE_CANCEL       (-6)
 */
gint okbox (const char *title, const char *text)
{
  GtkWidget *dialog;
  GtkWidget *label;
  gint response;

  if (!title || !strlen(title) || !text || !strlen(text))
    return FALSE;

  dialog = gtk_dialog_new_with_buttons(title, NULL, GTK_DIALOG_DESTROY_WITH_PARENT,
				       GTK_STOCK_OK, GTK_RESPONSE_OK,
				       GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				       NULL);
  gtk_widget_set_usize (GTK_WIDGET (dialog), 400, 130);

  label = gtk_label_new (text);
  gtk_label_set_line_wrap (GTK_LABEL(label), TRUE);
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dialog)->vbox), label, FALSE, FALSE, 5);
  gtk_widget_show (GTK_WIDGET(label));

  response = gtk_dialog_run (GTK_DIALOG(dialog));

#ifdef DEBUG
  printf ("okbox response: %d\n", response);
#endif

  gtk_widget_destroy (GTK_WIDGET(dialog));

  return response;
}
