//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armrecoveryservicessiterecovery

import "time"

// A2AAddDisksInput - A2A add disk(s) input.
type A2AAddDisksInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The list of vm disk details.
	VMDisks []*A2AVMDiskInputDetails `json:"vmDisks,omitempty"`

	// The list of vm managed disk details.
	VMManagedDisks []*A2AVMManagedDiskInputDetails `json:"vmManagedDisks,omitempty"`
}

// GetAddDisksProviderSpecificInput implements the AddDisksProviderSpecificInputClassification interface for type A2AAddDisksInput.
func (a *A2AAddDisksInput) GetAddDisksProviderSpecificInput() *AddDisksProviderSpecificInput {
	return &AddDisksProviderSpecificInput{
		InstanceType: a.InstanceType,
	}
}

// A2AApplyRecoveryPointInput - ApplyRecoveryPoint input specific to A2A provider.
type A2AApplyRecoveryPointInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetApplyRecoveryPointProviderSpecificInput implements the ApplyRecoveryPointProviderSpecificInputClassification interface
// for type A2AApplyRecoveryPointInput.
func (a *A2AApplyRecoveryPointInput) GetApplyRecoveryPointProviderSpecificInput() *ApplyRecoveryPointProviderSpecificInput {
	return &ApplyRecoveryPointProviderSpecificInput{
		InstanceType: a.InstanceType,
	}
}

// A2AContainerCreationInput - A2A cloud creation input.
type A2AContainerCreationInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetReplicationProviderSpecificContainerCreationInput implements the ReplicationProviderSpecificContainerCreationInputClassification
// interface for type A2AContainerCreationInput.
func (a *A2AContainerCreationInput) GetReplicationProviderSpecificContainerCreationInput() *ReplicationProviderSpecificContainerCreationInput {
	return &ReplicationProviderSpecificContainerCreationInput{
		InstanceType: a.InstanceType,
	}
}

// A2AContainerMappingInput - A2A container mapping input.
type A2AContainerMappingInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// A value indicating whether the auto update is enabled.
	AgentAutoUpdateStatus *AgentAutoUpdateStatus `json:"agentAutoUpdateStatus,omitempty"`

	// The automation account arm id.
	AutomationAccountArmID *string `json:"automationAccountArmId,omitempty"`

	// A value indicating the type authentication to use for automation Account.
	AutomationAccountAuthenticationType *AutomationAccountAuthenticationType `json:"automationAccountAuthenticationType,omitempty"`
}

// GetReplicationProviderSpecificContainerMappingInput implements the ReplicationProviderSpecificContainerMappingInputClassification
// interface for type A2AContainerMappingInput.
func (a *A2AContainerMappingInput) GetReplicationProviderSpecificContainerMappingInput() *ReplicationProviderSpecificContainerMappingInput {
	return &ReplicationProviderSpecificContainerMappingInput{
		InstanceType: a.InstanceType,
	}
}

// A2ACreateProtectionIntentInput - A2A create protection intent input.
type A2ACreateProtectionIntentInput struct {
	// REQUIRED; The fabric specific object Id of the virtual machine.
	FabricObjectID *string `json:"fabricObjectId,omitempty"`

	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; The primary location for the virtual machine.
	PrimaryLocation *string `json:"primaryLocation,omitempty"`

	// REQUIRED; The recovery availability type of the virtual machine.
	RecoveryAvailabilityType *A2ARecoveryAvailabilityType `json:"recoveryAvailabilityType,omitempty"`

	// REQUIRED; The recovery location for the virtual machine.
	RecoveryLocation *string `json:"recoveryLocation,omitempty"`

	// REQUIRED; The recovery resource group Id. Valid for V2 scenarios.
	RecoveryResourceGroupID *string `json:"recoveryResourceGroupId,omitempty"`

	// REQUIRED; The recovery subscription Id of the virtual machine.
	RecoverySubscriptionID *string `json:"recoverySubscriptionId,omitempty"`

	// A value indicating whether the auto update is enabled.
	AgentAutoUpdateStatus *AgentAutoUpdateStatus `json:"agentAutoUpdateStatus,omitempty"`

	// A value indicating whether the auto protection is enabled.
	AutoProtectionOfDataDisk *AutoProtectionOfDataDisk `json:"autoProtectionOfDataDisk,omitempty"`

	// The automation account arm id.
	AutomationAccountArmID *string `json:"automationAccountArmId,omitempty"`

	// A value indicating the authentication type for automation account. The default value is "RunAsAccount".
	AutomationAccountAuthenticationType *AutomationAccountAuthenticationType `json:"automationAccountAuthenticationType,omitempty"`

	// The recovery disk encryption information (for two pass flows).
	DiskEncryptionInfo *DiskEncryptionInfo `json:"diskEncryptionInfo,omitempty"`

	// The multi vm group id.
	MultiVMGroupID *string `json:"multiVmGroupId,omitempty"`

	// The multi vm group name.
	MultiVMGroupName *string `json:"multiVmGroupName,omitempty"`

	// The primary staging storage account input.
	PrimaryStagingStorageAccountCustomInput StorageAccountCustomDetailsClassification `json:"primaryStagingStorageAccountCustomInput,omitempty"`

	// The protection profile custom inputs.
	ProtectionProfileCustomInput ProtectionProfileCustomDetailsClassification `json:"protectionProfileCustomInput,omitempty"`

	// The recovery availability set input.
	RecoveryAvailabilitySetCustomInput RecoveryAvailabilitySetCustomDetailsClassification `json:"recoveryAvailabilitySetCustomInput,omitempty"`

	// The recovery availability zone.
	RecoveryAvailabilityZone *string `json:"recoveryAvailabilityZone,omitempty"`

	// The boot diagnostic storage account.
	RecoveryBootDiagStorageAccount StorageAccountCustomDetailsClassification `json:"recoveryBootDiagStorageAccount,omitempty"`

	// The recovery proximity placement group custom input.
	RecoveryProximityPlacementGroupCustomInput RecoveryProximityPlacementGroupCustomDetailsClassification `json:"recoveryProximityPlacementGroupCustomInput,omitempty"`

	// The recovery virtual network input.
	RecoveryVirtualNetworkCustomInput RecoveryVirtualNetworkCustomDetailsClassification `json:"recoveryVirtualNetworkCustomInput,omitempty"`

	// The list of vm disk inputs.
	VMDisks []*A2AProtectionIntentDiskInputDetails `json:"vmDisks,omitempty"`

	// The list of vm managed disk inputs.
	VMManagedDisks []*A2AProtectionIntentManagedDiskInputDetails `json:"vmManagedDisks,omitempty"`
}

// GetCreateProtectionIntentProviderSpecificDetails implements the CreateProtectionIntentProviderSpecificDetailsClassification
// interface for type A2ACreateProtectionIntentInput.
func (a *A2ACreateProtectionIntentInput) GetCreateProtectionIntentProviderSpecificDetails() *CreateProtectionIntentProviderSpecificDetails {
	return &CreateProtectionIntentProviderSpecificDetails{
		InstanceType: a.InstanceType,
	}
}

// A2ACrossClusterMigrationApplyRecoveryPointInput - ApplyRecoveryPoint input specific to A2ACrossClusterMigration provider.
type A2ACrossClusterMigrationApplyRecoveryPointInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetApplyRecoveryPointProviderSpecificInput implements the ApplyRecoveryPointProviderSpecificInputClassification interface
// for type A2ACrossClusterMigrationApplyRecoveryPointInput.
func (a *A2ACrossClusterMigrationApplyRecoveryPointInput) GetApplyRecoveryPointProviderSpecificInput() *ApplyRecoveryPointProviderSpecificInput {
	return &ApplyRecoveryPointProviderSpecificInput{
		InstanceType: a.InstanceType,
	}
}

// A2ACrossClusterMigrationContainerCreationInput - A2ACrossClusterMigration cloud creation input.
type A2ACrossClusterMigrationContainerCreationInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetReplicationProviderSpecificContainerCreationInput implements the ReplicationProviderSpecificContainerCreationInputClassification
// interface for type A2ACrossClusterMigrationContainerCreationInput.
func (a *A2ACrossClusterMigrationContainerCreationInput) GetReplicationProviderSpecificContainerCreationInput() *ReplicationProviderSpecificContainerCreationInput {
	return &ReplicationProviderSpecificContainerCreationInput{
		InstanceType: a.InstanceType,
	}
}

// A2ACrossClusterMigrationEnableProtectionInput - A2A Cross-Cluster Migration enable protection input.
type A2ACrossClusterMigrationEnableProtectionInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The fabric specific object Id of the virtual machine.
	FabricObjectID *string `json:"fabricObjectId,omitempty"`

	// The recovery container Id.
	RecoveryContainerID *string `json:"recoveryContainerId,omitempty"`
}

// GetEnableProtectionProviderSpecificInput implements the EnableProtectionProviderSpecificInputClassification interface for
// type A2ACrossClusterMigrationEnableProtectionInput.
func (a *A2ACrossClusterMigrationEnableProtectionInput) GetEnableProtectionProviderSpecificInput() *EnableProtectionProviderSpecificInput {
	return &EnableProtectionProviderSpecificInput{
		InstanceType: a.InstanceType,
	}
}

// A2ACrossClusterMigrationPolicyCreationInput - A2A Cross-Cluster Migration Policy creation input.
type A2ACrossClusterMigrationPolicyCreationInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetPolicyProviderSpecificInput implements the PolicyProviderSpecificInputClassification interface for type A2ACrossClusterMigrationPolicyCreationInput.
func (a *A2ACrossClusterMigrationPolicyCreationInput) GetPolicyProviderSpecificInput() *PolicyProviderSpecificInput {
	return &PolicyProviderSpecificInput{
		InstanceType: a.InstanceType,
	}
}

// A2ACrossClusterMigrationReplicationDetails - A2A provider specific settings.
type A2ACrossClusterMigrationReplicationDetails struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The fabric specific object Id of the virtual machine.
	FabricObjectID *string `json:"fabricObjectId,omitempty"`

	// An id associated with the PE that survives actions like switch protection which change the backing PE/CPE objects internally.The
	// lifecycle id gets carried forward to have a link/continuity in being
	// able to have an Id that denotes the "same" protected item even though other internal Ids/ARM Id might be changing.
	LifecycleID *string `json:"lifecycleId,omitempty"`

	// The type of operating system.
	OSType *string `json:"osType,omitempty"`

	// Primary fabric location.
	PrimaryFabricLocation *string `json:"primaryFabricLocation,omitempty"`

	// The protection state for the vm.
	VMProtectionState *string `json:"vmProtectionState,omitempty"`

	// The protection state description for the vm.
	VMProtectionStateDescription *string `json:"vmProtectionStateDescription,omitempty"`
}

// GetReplicationProviderSpecificSettings implements the ReplicationProviderSpecificSettingsClassification interface for type
// A2ACrossClusterMigrationReplicationDetails.
func (a *A2ACrossClusterMigrationReplicationDetails) GetReplicationProviderSpecificSettings() *ReplicationProviderSpecificSettings {
	return &ReplicationProviderSpecificSettings{
		InstanceType: a.InstanceType,
	}
}

// A2AEnableProtectionInput - A2A enable protection input.
type A2AEnableProtectionInput struct {
	// REQUIRED; The fabric specific object Id of the virtual machine.
	FabricObjectID *string `json:"fabricObjectId,omitempty"`

	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The recovery disk encryption information (for two pass flows).
	DiskEncryptionInfo *DiskEncryptionInfo `json:"diskEncryptionInfo,omitempty"`

	// The multi vm group id.
	MultiVMGroupID *string `json:"multiVmGroupId,omitempty"`

	// The multi vm group name.
	MultiVMGroupName *string `json:"multiVmGroupName,omitempty"`

	// The recovery availability set Id.
	RecoveryAvailabilitySetID *string `json:"recoveryAvailabilitySetId,omitempty"`

	// The recovery availability zone.
	RecoveryAvailabilityZone *string `json:"recoveryAvailabilityZone,omitempty"`

	// The recovery Azure virtual network ARM id.
	RecoveryAzureNetworkID *string `json:"recoveryAzureNetworkId,omitempty"`

	// The boot diagnostic storage account.
	RecoveryBootDiagStorageAccountID *string `json:"recoveryBootDiagStorageAccountId,omitempty"`

	// The recovery capacity reservation group Id.
	RecoveryCapacityReservationGroupID *string `json:"recoveryCapacityReservationGroupId,omitempty"`

	// The recovery cloud service Id. Valid for V1 scenarios.
	RecoveryCloudServiceID *string `json:"recoveryCloudServiceId,omitempty"`

	// The recovery container Id.
	RecoveryContainerID *string `json:"recoveryContainerId,omitempty"`

	// The recovery extended location.
	RecoveryExtendedLocation *ExtendedLocation `json:"recoveryExtendedLocation,omitempty"`

	// The recovery proximity placement group Id.
	RecoveryProximityPlacementGroupID *string `json:"recoveryProximityPlacementGroupId,omitempty"`

	// The recovery resource group Id. Valid for V2 scenarios.
	RecoveryResourceGroupID *string `json:"recoveryResourceGroupId,omitempty"`

	// The recovery subnet name.
	RecoverySubnetName *string `json:"recoverySubnetName,omitempty"`

	// The virtual machine scale set Id.
	RecoveryVirtualMachineScaleSetID *string `json:"recoveryVirtualMachineScaleSetId,omitempty"`

	// The list of vm disk details.
	VMDisks []*A2AVMDiskInputDetails `json:"vmDisks,omitempty"`

	// The list of vm managed disk details.
	VMManagedDisks []*A2AVMManagedDiskInputDetails `json:"vmManagedDisks,omitempty"`
}

// GetEnableProtectionProviderSpecificInput implements the EnableProtectionProviderSpecificInputClassification interface for
// type A2AEnableProtectionInput.
func (a *A2AEnableProtectionInput) GetEnableProtectionProviderSpecificInput() *EnableProtectionProviderSpecificInput {
	return &EnableProtectionProviderSpecificInput{
		InstanceType: a.InstanceType,
	}
}

// A2AEventDetails - Model class for event details of a A2A event.
type A2AEventDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// The fabric location.
	FabricLocation *string `json:"fabricLocation,omitempty"`

	// Fabric arm name.
	FabricName *string `json:"fabricName,omitempty"`

	// The azure vm arm id.
	FabricObjectID *string `json:"fabricObjectId,omitempty"`

	// The protected item arm name.
	ProtectedItemName *string `json:"protectedItemName,omitempty"`

	// Remote fabric location.
	RemoteFabricLocation *string `json:"remoteFabricLocation,omitempty"`

	// Remote fabric arm name.
	RemoteFabricName *string `json:"remoteFabricName,omitempty"`
}

// GetEventProviderSpecificDetails implements the EventProviderSpecificDetailsClassification interface for type A2AEventDetails.
func (a *A2AEventDetails) GetEventProviderSpecificDetails() *EventProviderSpecificDetails {
	return &EventProviderSpecificDetails{
		InstanceType: a.InstanceType,
	}
}

// A2APolicyCreationInput - A2A Policy creation input.
type A2APolicyCreationInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'.
	MultiVMSyncStatus *SetMultiVMSyncStatus `json:"multiVmSyncStatus,omitempty"`

	// The app consistent snapshot frequency (in minutes).
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`

	// The crash consistent snapshot frequency (in minutes).
	CrashConsistentFrequencyInMinutes *int32 `json:"crashConsistentFrequencyInMinutes,omitempty"`

	// The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32 `json:"recoveryPointHistory,omitempty"`
}

// GetPolicyProviderSpecificInput implements the PolicyProviderSpecificInputClassification interface for type A2APolicyCreationInput.
func (a *A2APolicyCreationInput) GetPolicyProviderSpecificInput() *PolicyProviderSpecificInput {
	return &PolicyProviderSpecificInput{
		InstanceType: a.InstanceType,
	}
}

// A2APolicyDetails - A2A specific policy details.
type A2APolicyDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// The app consistent snapshot frequency in minutes.
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`

	// The crash consistent snapshot frequency in minutes.
	CrashConsistentFrequencyInMinutes *int32 `json:"crashConsistentFrequencyInMinutes,omitempty"`

	// A value indicating whether multi-VM sync has to be enabled.
	MultiVMSyncStatus *string `json:"multiVmSyncStatus,omitempty"`

	// The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32 `json:"recoveryPointHistory,omitempty"`

	// The recovery point threshold in minutes.
	RecoveryPointThresholdInMinutes *int32 `json:"recoveryPointThresholdInMinutes,omitempty"`
}

// GetPolicyProviderSpecificDetails implements the PolicyProviderSpecificDetailsClassification interface for type A2APolicyDetails.
func (a *A2APolicyDetails) GetPolicyProviderSpecificDetails() *PolicyProviderSpecificDetails {
	return &PolicyProviderSpecificDetails{
		InstanceType: a.InstanceType,
	}
}

// A2AProtectedDiskDetails - A2A protected disk details.
type A2AProtectedDiskDetails struct {
	// The disk level operations list.
	AllowedDiskLevelOperation []*string `json:"allowedDiskLevelOperation,omitempty"`

	// The data pending at source virtual machine in MB.
	DataPendingAtSourceAgentInMB *float64 `json:"dataPendingAtSourceAgentInMB,omitempty"`

	// The data pending for replication in MB at staging account.
	DataPendingInStagingStorageAccountInMB *float64 `json:"dataPendingInStagingStorageAccountInMB,omitempty"`

	// The KeyVault resource id for secret (BEK).
	DekKeyVaultArmID *string `json:"dekKeyVaultArmId,omitempty"`

	// The disk capacity in bytes.
	DiskCapacityInBytes *int64 `json:"diskCapacityInBytes,omitempty"`

	// The disk name.
	DiskName *string `json:"diskName,omitempty"`

	// The disk state.
	DiskState *string `json:"diskState,omitempty"`

	// The type of disk.
	DiskType *string `json:"diskType,omitempty"`

	// The disk uri.
	DiskURI *string `json:"diskUri,omitempty"`

	// The failover name for the managed disk.
	FailoverDiskName *string `json:"failoverDiskName,omitempty"`

	// A value indicating whether vm has encrypted os disk or not.
	IsDiskEncrypted *bool `json:"isDiskEncrypted,omitempty"`

	// A value indicating whether disk key got encrypted or not.
	IsDiskKeyEncrypted *bool `json:"isDiskKeyEncrypted,omitempty"`

	// The KeyVault resource id for key (KEK).
	KekKeyVaultArmID *string `json:"kekKeyVaultArmId,omitempty"`

	// The key URL / identifier (KEK).
	KeyIdentifier *string `json:"keyIdentifier,omitempty"`

	// The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property.
	MonitoringJobType *string `json:"monitoringJobType,omitempty"`

	// The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property.
	MonitoringPercentageCompletion *int32 `json:"monitoringPercentageCompletion,omitempty"`

	// The primary disk storage account.
	PrimaryDiskAzureStorageAccountID *string `json:"primaryDiskAzureStorageAccountId,omitempty"`

	// The primary staging storage account.
	PrimaryStagingAzureStorageAccountID *string `json:"primaryStagingAzureStorageAccountId,omitempty"`

	// The recovery disk storage account.
	RecoveryAzureStorageAccountID *string `json:"recoveryAzureStorageAccountId,omitempty"`

	// Recovery disk uri.
	RecoveryDiskURI *string `json:"recoveryDiskUri,omitempty"`

	// A value indicating whether resync is required for this disk.
	ResyncRequired *bool `json:"resyncRequired,omitempty"`

	// The secret URL / identifier (BEK).
	SecretIdentifier *string `json:"secretIdentifier,omitempty"`

	// The test failover name for the managed disk.
	TfoDiskName *string `json:"tfoDiskName,omitempty"`
}

// A2AProtectedManagedDiskDetails - A2A protected managed disk details.
type A2AProtectedManagedDiskDetails struct {
	// The disk level operations list.
	AllowedDiskLevelOperation []*string `json:"allowedDiskLevelOperation,omitempty"`

	// The data pending at source virtual machine in MB.
	DataPendingAtSourceAgentInMB *float64 `json:"dataPendingAtSourceAgentInMB,omitempty"`

	// The data pending for replication in MB at staging account.
	DataPendingInStagingStorageAccountInMB *float64 `json:"dataPendingInStagingStorageAccountInMB,omitempty"`

	// The KeyVault resource id for secret (BEK).
	DekKeyVaultArmID *string `json:"dekKeyVaultArmId,omitempty"`

	// The disk capacity in bytes.
	DiskCapacityInBytes *int64 `json:"diskCapacityInBytes,omitempty"`

	// The managed disk Arm id.
	DiskID *string `json:"diskId,omitempty"`

	// The disk name.
	DiskName *string `json:"diskName,omitempty"`

	// The disk state.
	DiskState *string `json:"diskState,omitempty"`

	// The type of disk.
	DiskType *string `json:"diskType,omitempty"`

	// The failover name for the managed disk.
	FailoverDiskName *string `json:"failoverDiskName,omitempty"`

	// A value indicating whether vm has encrypted os disk or not.
	IsDiskEncrypted *bool `json:"isDiskEncrypted,omitempty"`

	// A value indicating whether disk key got encrypted or not.
	IsDiskKeyEncrypted *bool `json:"isDiskKeyEncrypted,omitempty"`

	// The KeyVault resource id for key (KEK).
	KekKeyVaultArmID *string `json:"kekKeyVaultArmId,omitempty"`

	// The key URL / identifier (KEK).
	KeyIdentifier *string `json:"keyIdentifier,omitempty"`

	// The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property.
	MonitoringJobType *string `json:"monitoringJobType,omitempty"`

	// The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property.
	MonitoringPercentageCompletion *int32 `json:"monitoringPercentageCompletion,omitempty"`

	// The primary disk encryption set Id.
	PrimaryDiskEncryptionSetID *string `json:"primaryDiskEncryptionSetId,omitempty"`

	// The primary staging storage account.
	PrimaryStagingAzureStorageAccountID *string `json:"primaryStagingAzureStorageAccountId,omitempty"`

	// The recovery disk encryption set Id.
	RecoveryDiskEncryptionSetID *string `json:"recoveryDiskEncryptionSetId,omitempty"`

	// Recovery original target disk Arm Id.
	RecoveryOrignalTargetDiskID *string `json:"recoveryOrignalTargetDiskId,omitempty"`

	// The replica disk type. Its an optional value and will be same as source disk type if not user provided.
	RecoveryReplicaDiskAccountType *string `json:"recoveryReplicaDiskAccountType,omitempty"`

	// Recovery replica disk Arm Id.
	RecoveryReplicaDiskID *string `json:"recoveryReplicaDiskId,omitempty"`

	// The recovery disk resource group Arm Id.
	RecoveryResourceGroupID *string `json:"recoveryResourceGroupId,omitempty"`

	// The target disk type after failover. Its an optional value and will be same as source disk type if not user provided.
	RecoveryTargetDiskAccountType *string `json:"recoveryTargetDiskAccountType,omitempty"`

	// Recovery target disk Arm Id.
	RecoveryTargetDiskID *string `json:"recoveryTargetDiskId,omitempty"`

	// A value indicating whether resync is required for this disk.
	ResyncRequired *bool `json:"resyncRequired,omitempty"`

	// The secret URL / identifier (BEK).
	SecretIdentifier *string `json:"secretIdentifier,omitempty"`

	// The test failover name for the managed disk.
	TfoDiskName *string `json:"tfoDiskName,omitempty"`
}

// A2AProtectionContainerMappingDetails - A2A provider specific settings.
type A2AProtectionContainerMappingDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// A value indicating whether the auto update is enabled.
	AgentAutoUpdateStatus *AgentAutoUpdateStatus `json:"agentAutoUpdateStatus,omitempty"`

	// The automation account arm id.
	AutomationAccountArmID *string `json:"automationAccountArmId,omitempty"`

	// A value indicating the type authentication to use for automation Account.
	AutomationAccountAuthenticationType *AutomationAccountAuthenticationType `json:"automationAccountAuthenticationType,omitempty"`

	// The job schedule arm name.
	JobScheduleName *string `json:"jobScheduleName,omitempty"`

	// The schedule arm name.
	ScheduleName *string `json:"scheduleName,omitempty"`
}

// GetProtectionContainerMappingProviderSpecificDetails implements the ProtectionContainerMappingProviderSpecificDetailsClassification
// interface for type A2AProtectionContainerMappingDetails.
func (a *A2AProtectionContainerMappingDetails) GetProtectionContainerMappingProviderSpecificDetails() *ProtectionContainerMappingProviderSpecificDetails {
	return &ProtectionContainerMappingProviderSpecificDetails{
		InstanceType: a.InstanceType,
	}
}

// A2AProtectionIntentDiskInputDetails - Azure VM unmanaged disk input details.
type A2AProtectionIntentDiskInputDetails struct {
	// REQUIRED; The disk Uri.
	DiskURI *string `json:"diskUri,omitempty"`

	// The primary staging storage account input.
	PrimaryStagingStorageAccountCustomInput StorageAccountCustomDetailsClassification `json:"primaryStagingStorageAccountCustomInput,omitempty"`

	// The recovery VHD storage account input.
	RecoveryAzureStorageAccountCustomInput StorageAccountCustomDetailsClassification `json:"recoveryAzureStorageAccountCustomInput,omitempty"`
}

// A2AProtectionIntentManagedDiskInputDetails - Azure VM managed disk input details.
type A2AProtectionIntentManagedDiskInputDetails struct {
	// REQUIRED; The disk Id.
	DiskID *string `json:"diskId,omitempty"`

	// The recovery disk encryption information (for one / single pass flows).
	DiskEncryptionInfo *DiskEncryptionInfo `json:"diskEncryptionInfo,omitempty"`

	// The primary staging storage account input.
	PrimaryStagingStorageAccountCustomInput StorageAccountCustomDetailsClassification `json:"primaryStagingStorageAccountCustomInput,omitempty"`

	// The recovery disk encryption set Id.
	RecoveryDiskEncryptionSetID *string `json:"recoveryDiskEncryptionSetId,omitempty"`

	// The replica disk type. Its an optional value and will be same as source disk type if not user provided.
	RecoveryReplicaDiskAccountType *string `json:"recoveryReplicaDiskAccountType,omitempty"`

	// The recovery resource group input.
	RecoveryResourceGroupCustomInput RecoveryResourceGroupCustomDetailsClassification `json:"recoveryResourceGroupCustomInput,omitempty"`

	// The target disk type after failover. Its an optional value and will be same as source disk type if not user provided.
	RecoveryTargetDiskAccountType *string `json:"recoveryTargetDiskAccountType,omitempty"`
}

// A2ARecoveryPointDetails - A2A provider specific recovery point details.
type A2ARecoveryPointDetails struct {
	// REQUIRED; Gets the provider type.
	InstanceType *string `json:"instanceType,omitempty"`

	// List of disk ids representing a recovery point.
	Disks []*string `json:"disks,omitempty"`

	// A value indicating whether the recovery point is multi VM consistent.
	RecoveryPointSyncType *RecoveryPointSyncType `json:"recoveryPointSyncType,omitempty"`
}

// GetProviderSpecificRecoveryPointDetails implements the ProviderSpecificRecoveryPointDetailsClassification interface for
// type A2ARecoveryPointDetails.
func (a *A2ARecoveryPointDetails) GetProviderSpecificRecoveryPointDetails() *ProviderSpecificRecoveryPointDetails {
	return &ProviderSpecificRecoveryPointDetails{
		InstanceType: a.InstanceType,
	}
}

// A2ARemoveDisksInput - A2A remove disk(s) input.
type A2ARemoveDisksInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The list of vm disk vhd URIs.
	VMDisksUris []*string `json:"vmDisksUris,omitempty"`

	// The list of vm managed disk Ids.
	VMManagedDisksIDs []*string `json:"vmManagedDisksIds,omitempty"`
}

// GetRemoveDisksProviderSpecificInput implements the RemoveDisksProviderSpecificInputClassification interface for type A2ARemoveDisksInput.
func (a *A2ARemoveDisksInput) GetRemoveDisksProviderSpecificInput() *RemoveDisksProviderSpecificInput {
	return &RemoveDisksProviderSpecificInput{
		InstanceType: a.InstanceType,
	}
}

// A2AReplicationDetails - A2A provider specific settings.
type A2AReplicationDetails struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string `json:"instanceType,omitempty"`

	// Agent expiry date.
	AgentExpiryDate *time.Time `json:"agentExpiryDate,omitempty"`

	// The agent version.
	AgentVersion *string `json:"agentVersion,omitempty"`

	// A value indicating whether the auto protection is enabled.
	AutoProtectionOfDataDisk *AutoProtectionOfDataDisk `json:"autoProtectionOfDataDisk,omitempty"`

	// The fabric specific object Id of the virtual machine.
	FabricObjectID *string `json:"fabricObjectId,omitempty"`

	// The initial primary extended location.
	InitialPrimaryExtendedLocation *ExtendedLocation `json:"initialPrimaryExtendedLocation,omitempty"`

	// The initial recovery extended location.
	InitialRecoveryExtendedLocation *ExtendedLocation `json:"initialRecoveryExtendedLocation,omitempty"`

	// A value indicating whether agent certificate update is required.
	IsReplicationAgentCertificateUpdateRequired *bool `json:"isReplicationAgentCertificateUpdateRequired,omitempty"`

	// A value indicating whether replication agent update is required.
	IsReplicationAgentUpdateRequired *bool `json:"isReplicationAgentUpdateRequired,omitempty"`

	// The last heartbeat received from the source server.
	LastHeartbeat *time.Time `json:"lastHeartbeat,omitempty"`

	// The time (in UTC) when the last RPO value was calculated by Protection Service.
	LastRpoCalculatedTime *time.Time `json:"lastRpoCalculatedTime,omitempty"`

	// An id associated with the PE that survives actions like switch protection which change the backing PE/CPE objects internally.The
	// lifecycle id gets carried forward to have a link/continuity in being
	// able to have an Id that denotes the "same" protected item even though other internal Ids/ARM Id might be changing.
	LifecycleID *string `json:"lifecycleId,omitempty"`

	// The management Id.
	ManagementID *string `json:"managementId,omitempty"`

	// The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property.
	MonitoringJobType *string `json:"monitoringJobType,omitempty"`

	// The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property.
	MonitoringPercentageCompletion *int32 `json:"monitoringPercentageCompletion,omitempty"`

	// Whether Multi VM group is auto created or specified by user.
	MultiVMGroupCreateOption *MultiVMGroupCreateOption `json:"multiVmGroupCreateOption,omitempty"`

	// The multi vm group Id.
	MultiVMGroupID *string `json:"multiVmGroupId,omitempty"`

	// The multi vm group name.
	MultiVMGroupName *string `json:"multiVmGroupName,omitempty"`

	// The type of operating system.
	OSType *string `json:"osType,omitempty"`

	// The primary availability zone.
	PrimaryAvailabilityZone *string `json:"primaryAvailabilityZone,omitempty"`

	// The primary Extended Location.
	PrimaryExtendedLocation *ExtendedLocation `json:"primaryExtendedLocation,omitempty"`

	// Primary fabric location.
	PrimaryFabricLocation *string `json:"primaryFabricLocation,omitempty"`

	// The list of protected disks.
	ProtectedDisks []*A2AProtectedDiskDetails `json:"protectedDisks,omitempty"`

	// The list of protected managed disks.
	ProtectedManagedDisks []*A2AProtectedManagedDiskDetails `json:"protectedManagedDisks,omitempty"`

	// The recovery availability set.
	RecoveryAvailabilitySet *string `json:"recoveryAvailabilitySet,omitempty"`

	// The recovery availability zone.
	RecoveryAvailabilityZone *string `json:"recoveryAvailabilityZone,omitempty"`

	// The recovery resource group.
	RecoveryAzureResourceGroupID *string `json:"recoveryAzureResourceGroupId,omitempty"`

	// The name of recovery virtual machine.
	RecoveryAzureVMName *string `json:"recoveryAzureVMName,omitempty"`

	// The size of recovery virtual machine.
	RecoveryAzureVMSize *string `json:"recoveryAzureVMSize,omitempty"`

	// The recovery boot diagnostic storage account Arm Id.
	RecoveryBootDiagStorageAccountID *string `json:"recoveryBootDiagStorageAccountId,omitempty"`

	// The recovery capacity reservation group Id.
	RecoveryCapacityReservationGroupID *string `json:"recoveryCapacityReservationGroupId,omitempty"`

	// The recovery cloud service.
	RecoveryCloudService *string `json:"recoveryCloudService,omitempty"`

	// The recovery Extended Location.
	RecoveryExtendedLocation *ExtendedLocation `json:"recoveryExtendedLocation,omitempty"`

	// The recovery fabric location.
	RecoveryFabricLocation *string `json:"recoveryFabricLocation,omitempty"`

	// The recovery fabric object Id.
	RecoveryFabricObjectID *string `json:"recoveryFabricObjectId,omitempty"`

	// The recovery proximity placement group Id.
	RecoveryProximityPlacementGroupID *string `json:"recoveryProximityPlacementGroupId,omitempty"`

	// The recovery virtual machine scale set id.
	RecoveryVirtualMachineScaleSetID *string `json:"recoveryVirtualMachineScaleSetId,omitempty"`

	// The last RPO value in seconds.
	RpoInSeconds *int64 `json:"rpoInSeconds,omitempty"`

	// The recovery virtual network.
	SelectedRecoveryAzureNetworkID *string `json:"selectedRecoveryAzureNetworkId,omitempty"`

	// The test failover virtual network.
	SelectedTfoAzureNetworkID *string `json:"selectedTfoAzureNetworkId,omitempty"`

	// The test failover fabric object Id.
	TestFailoverRecoveryFabricObjectID *string `json:"testFailoverRecoveryFabricObjectId,omitempty"`

	// The test failover vm name.
	TfoAzureVMName *string `json:"tfoAzureVMName,omitempty"`

	// The list of unprotected disks.
	UnprotectedDisks []*A2AUnprotectedDiskDetails `json:"unprotectedDisks,omitempty"`

	// The virtual machine nic details.
	VMNics []*VMNicDetails `json:"vmNics,omitempty"`

	// The protection state for the vm.
	VMProtectionState *string `json:"vmProtectionState,omitempty"`

	// The protection state description for the vm.
	VMProtectionStateDescription *string `json:"vmProtectionStateDescription,omitempty"`

	// The synced configuration details.
	VMSyncedConfigDetails *AzureToAzureVMSyncedConfigDetails `json:"vmSyncedConfigDetails,omitempty"`

	// READ-ONLY; Agent certificate expiry date.
	AgentCertificateExpiryDate *time.Time `json:"agentCertificateExpiryDate,omitempty" azure:"ro"`

	// READ-ONLY; The initial primary fabric location.
	InitialPrimaryFabricLocation *string `json:"initialPrimaryFabricLocation,omitempty" azure:"ro"`

	// READ-ONLY; The initial primary availability zone.
	InitialPrimaryZone *string `json:"initialPrimaryZone,omitempty" azure:"ro"`

	// READ-ONLY; The initial recovery fabric location.
	InitialRecoveryFabricLocation *string `json:"initialRecoveryFabricLocation,omitempty" azure:"ro"`

	// READ-ONLY; The initial recovery availability zone.
	InitialRecoveryZone *string `json:"initialRecoveryZone,omitempty" azure:"ro"`

	// READ-ONLY; The recovery azure generation.
	RecoveryAzureGeneration *string `json:"recoveryAzureGeneration,omitempty" azure:"ro"`

	// READ-ONLY; The encryption type of the VM.
	VMEncryptionType *VMEncryptionType `json:"vmEncryptionType,omitempty" azure:"ro"`
}

// GetReplicationProviderSpecificSettings implements the ReplicationProviderSpecificSettingsClassification interface for type
// A2AReplicationDetails.
func (a *A2AReplicationDetails) GetReplicationProviderSpecificSettings() *ReplicationProviderSpecificSettings {
	return &ReplicationProviderSpecificSettings{
		InstanceType: a.InstanceType,
	}
}

// A2AReplicationIntentDetails - A2A provider specific settings.
type A2AReplicationIntentDetails struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; The recovery availability type of the virtual machine.
	RecoveryAvailabilityType *string `json:"recoveryAvailabilityType,omitempty"`

	// A value indicating whether the auto update is enabled.
	AgentAutoUpdateStatus *AgentAutoUpdateStatus `json:"agentAutoUpdateStatus,omitempty"`

	// A value indicating whether the auto protection is enabled.
	AutoProtectionOfDataDisk *AutoProtectionOfDataDisk `json:"autoProtectionOfDataDisk,omitempty"`

	// The automation account arm id.
	AutomationAccountArmID *string `json:"automationAccountArmId,omitempty"`

	// A value indicating the type authentication to use for automation Account.
	AutomationAccountAuthenticationType *AutomationAccountAuthenticationType `json:"automationAccountAuthenticationType,omitempty"`

	// The recovery disk encryption information (for two pass flows).
	DiskEncryptionInfo *DiskEncryptionInfo `json:"diskEncryptionInfo,omitempty"`

	// The fabric specific object Id of the virtual machine.
	FabricObjectID *string `json:"fabricObjectId,omitempty"`

	// The multi vm group id.
	MultiVMGroupID *string `json:"multiVmGroupId,omitempty"`

	// The multi vm group name.
	MultiVMGroupName *string `json:"multiVmGroupName,omitempty"`

	// The primary location for the virtual machine.
	PrimaryLocation *string `json:"primaryLocation,omitempty"`

	// The primary staging storage account details.
	PrimaryStagingStorageAccount StorageAccountCustomDetailsClassification `json:"primaryStagingStorageAccount,omitempty"`

	// The protection profile custom details.
	ProtectionProfile ProtectionProfileCustomDetailsClassification `json:"protectionProfile,omitempty"`

	// The recovery availability set details.
	RecoveryAvailabilitySet RecoveryAvailabilitySetCustomDetailsClassification `json:"recoveryAvailabilitySet,omitempty"`

	// The recovery availability zone.
	RecoveryAvailabilityZone *string `json:"recoveryAvailabilityZone,omitempty"`

	// The boot diagnostic storage account.
	RecoveryBootDiagStorageAccount StorageAccountCustomDetailsClassification `json:"recoveryBootDiagStorageAccount,omitempty"`

	// The recovery location for the virtual machine.
	RecoveryLocation *string `json:"recoveryLocation,omitempty"`

	// The recovery proximity placement group custom details.
	RecoveryProximityPlacementGroup RecoveryProximityPlacementGroupCustomDetailsClassification `json:"recoveryProximityPlacementGroup,omitempty"`

	// The recovery resource group id.
	RecoveryResourceGroupID *string `json:"recoveryResourceGroupId,omitempty"`

	// The recovery subscription Id of the virtual machine.
	RecoverySubscriptionID *string `json:"recoverySubscriptionId,omitempty"`

	// The recovery virtual network details.
	RecoveryVirtualNetwork RecoveryVirtualNetworkCustomDetailsClassification `json:"recoveryVirtualNetwork,omitempty"`

	// The list of vm disk details.
	VMDisks []*A2AProtectionIntentDiskInputDetails `json:"vmDisks,omitempty"`

	// The list of vm managed disk details.
	VMManagedDisks []*A2AProtectionIntentManagedDiskInputDetails `json:"vmManagedDisks,omitempty"`
}

// GetReplicationProtectionIntentProviderSpecificSettings implements the ReplicationProtectionIntentProviderSpecificSettingsClassification
// interface for type A2AReplicationIntentDetails.
func (a *A2AReplicationIntentDetails) GetReplicationProtectionIntentProviderSpecificSettings() *ReplicationProtectionIntentProviderSpecificSettings {
	return &ReplicationProtectionIntentProviderSpecificSettings{
		InstanceType: a.InstanceType,
	}
}

// A2AReprotectInput - Azure specific reprotect input.
type A2AReprotectInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The Policy Id.
	PolicyID *string `json:"policyId,omitempty"`

	// The recovery availability set.
	RecoveryAvailabilitySetID *string `json:"recoveryAvailabilitySetId,omitempty"`

	// The recovery cloud service Id. Valid for V1 scenarios.
	RecoveryCloudServiceID *string `json:"recoveryCloudServiceId,omitempty"`

	// The recovery container Id.
	RecoveryContainerID *string `json:"recoveryContainerId,omitempty"`

	// The recovery resource group Id. Valid for V2 scenarios.
	RecoveryResourceGroupID *string `json:"recoveryResourceGroupId,omitempty"`

	// The list of vm disk details.
	VMDisks []*A2AVMDiskInputDetails `json:"vmDisks,omitempty"`
}

// GetReverseReplicationProviderSpecificInput implements the ReverseReplicationProviderSpecificInputClassification interface
// for type A2AReprotectInput.
func (a *A2AReprotectInput) GetReverseReplicationProviderSpecificInput() *ReverseReplicationProviderSpecificInput {
	return &ReverseReplicationProviderSpecificInput{
		InstanceType: a.InstanceType,
	}
}

// A2ASwitchProtectionInput - A2A specific switch protection input.
type A2ASwitchProtectionInput struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The recovery disk encryption information.
	DiskEncryptionInfo *DiskEncryptionInfo `json:"diskEncryptionInfo,omitempty"`

	// The Policy Id.
	PolicyID *string `json:"policyId,omitempty"`

	// The recovery availability set.
	RecoveryAvailabilitySetID *string `json:"recoveryAvailabilitySetId,omitempty"`

	// The recovery availability zone.
	RecoveryAvailabilityZone *string `json:"recoveryAvailabilityZone,omitempty"`

	// The boot diagnostic storage account.
	RecoveryBootDiagStorageAccountID *string `json:"recoveryBootDiagStorageAccountId,omitempty"`

	// The recovery capacity reservation group Id.
	RecoveryCapacityReservationGroupID *string `json:"recoveryCapacityReservationGroupId,omitempty"`

	// The recovery cloud service Id. Valid for V1 scenarios.
	RecoveryCloudServiceID *string `json:"recoveryCloudServiceId,omitempty"`

	// The recovery container Id.
	RecoveryContainerID *string `json:"recoveryContainerId,omitempty"`

	// The recovery proximity placement group Id.
	RecoveryProximityPlacementGroupID *string `json:"recoveryProximityPlacementGroupId,omitempty"`

	// The recovery resource group Id. Valid for V2 scenarios.
	RecoveryResourceGroupID *string `json:"recoveryResourceGroupId,omitempty"`

	// The virtual machine scale set id.
	RecoveryVirtualMachineScaleSetID *string `json:"recoveryVirtualMachineScaleSetId,omitempty"`

	// The list of vm disk details.
	VMDisks []*A2AVMDiskInputDetails `json:"vmDisks,omitempty"`

	// The list of vm managed disk details.
	VMManagedDisks []*A2AVMManagedDiskInputDetails `json:"vmManagedDisks,omitempty"`
}

// GetSwitchProtectionProviderSpecificInput implements the SwitchProtectionProviderSpecificInputClassification interface for
// type A2ASwitchProtectionInput.
func (a *A2ASwitchProtectionInput) GetSwitchProtectionProviderSpecificInput() *SwitchProtectionProviderSpecificInput {
	return &SwitchProtectionProviderSpecificInput{
		InstanceType: a.InstanceType,
	}
}

// A2ATestFailoverInput - A2A provider specific input for test failover.
type A2ATestFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// A value indicating whether to use recovery cloud service for TFO or not.
	CloudServiceCreationOption *string `json:"cloudServiceCreationOption,omitempty"`

	// The recovery point id to be passed to test failover to a particular recovery point. In case of latest recovery point, null
	// should be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
}

// GetTestFailoverProviderSpecificInput implements the TestFailoverProviderSpecificInputClassification interface for type
// A2ATestFailoverInput.
func (a *A2ATestFailoverInput) GetTestFailoverProviderSpecificInput() *TestFailoverProviderSpecificInput {
	return &TestFailoverProviderSpecificInput{
		InstanceType: a.InstanceType,
	}
}

// A2AUnplannedFailoverInput - A2A provider specific input for unplanned failover.
type A2AUnplannedFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// A value indicating whether to use recovery cloud service for failover or not.
	CloudServiceCreationOption *string `json:"cloudServiceCreationOption,omitempty"`

	// The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should
	// be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
}

// GetUnplannedFailoverProviderSpecificInput implements the UnplannedFailoverProviderSpecificInputClassification interface
// for type A2AUnplannedFailoverInput.
func (a *A2AUnplannedFailoverInput) GetUnplannedFailoverProviderSpecificInput() *UnplannedFailoverProviderSpecificInput {
	return &UnplannedFailoverProviderSpecificInput{
		InstanceType: a.InstanceType,
	}
}

// A2AUnprotectedDiskDetails - A2A unprotected disk details.
type A2AUnprotectedDiskDetails struct {
	// A value indicating whether the disk auto protection is enabled.
	DiskAutoProtectionStatus *AutoProtectionOfDataDisk `json:"diskAutoProtectionStatus,omitempty"`

	// The source lun Id for the data disk.
	DiskLunID *int32 `json:"diskLunId,omitempty"`
}

// A2AUpdateContainerMappingInput - A2A update protection container mapping.
type A2AUpdateContainerMappingInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// A value indicating whether the auto update is enabled.
	AgentAutoUpdateStatus *AgentAutoUpdateStatus `json:"agentAutoUpdateStatus,omitempty"`

	// The automation account arm id.
	AutomationAccountArmID *string `json:"automationAccountArmId,omitempty"`

	// A value indicating the type authentication to use for automation Account.
	AutomationAccountAuthenticationType *AutomationAccountAuthenticationType `json:"automationAccountAuthenticationType,omitempty"`
}

// GetReplicationProviderSpecificUpdateContainerMappingInput implements the ReplicationProviderSpecificUpdateContainerMappingInputClassification
// interface for type A2AUpdateContainerMappingInput.
func (a *A2AUpdateContainerMappingInput) GetReplicationProviderSpecificUpdateContainerMappingInput() *ReplicationProviderSpecificUpdateContainerMappingInput {
	return &ReplicationProviderSpecificUpdateContainerMappingInput{
		InstanceType: a.InstanceType,
	}
}

// A2AUpdateReplicationProtectedItemInput - InMage Azure V2 input to update replication protected item.
type A2AUpdateReplicationProtectedItemInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The recovery os disk encryption information.
	DiskEncryptionInfo *DiskEncryptionInfo `json:"diskEncryptionInfo,omitempty"`

	// Managed disk update details.
	ManagedDiskUpdateDetails []*A2AVMManagedDiskUpdateDetails `json:"managedDiskUpdateDetails,omitempty"`

	// The boot diagnostic storage account.
	RecoveryBootDiagStorageAccountID *string `json:"recoveryBootDiagStorageAccountId,omitempty"`

	// The recovery capacity reservation group Id.
	RecoveryCapacityReservationGroupID *string `json:"recoveryCapacityReservationGroupId,omitempty"`

	// The target cloud service ARM Id (for V1).
	RecoveryCloudServiceID *string `json:"recoveryCloudServiceId,omitempty"`

	// The recovery proximity placement group Id.
	RecoveryProximityPlacementGroupID *string `json:"recoveryProximityPlacementGroupId,omitempty"`

	// The target resource group ARM Id (for V2).
	RecoveryResourceGroupID *string `json:"recoveryResourceGroupId,omitempty"`

	// The recovery virtual machine scale set Id.
	RecoveryVirtualMachineScaleSetID *string `json:"recoveryVirtualMachineScaleSetId,omitempty"`

	// The user given name for Test Failover VM.
	TfoAzureVMName *string `json:"tfoAzureVMName,omitempty"`
}

// GetUpdateReplicationProtectedItemProviderInput implements the UpdateReplicationProtectedItemProviderInputClassification
// interface for type A2AUpdateReplicationProtectedItemInput.
func (a *A2AUpdateReplicationProtectedItemInput) GetUpdateReplicationProtectedItemProviderInput() *UpdateReplicationProtectedItemProviderInput {
	return &UpdateReplicationProtectedItemProviderInput{
		InstanceType: a.InstanceType,
	}
}

// A2AVMDiskInputDetails - A2A disk input details.
type A2AVMDiskInputDetails struct {
	// REQUIRED; The disk Uri.
	DiskURI *string `json:"diskUri,omitempty"`

	// REQUIRED; The primary staging storage account Id.
	PrimaryStagingAzureStorageAccountID *string `json:"primaryStagingAzureStorageAccountId,omitempty"`

	// REQUIRED; The recovery VHD storage account Id.
	RecoveryAzureStorageAccountID *string `json:"recoveryAzureStorageAccountId,omitempty"`
}

// A2AVMManagedDiskInputDetails - A2A managed disk input details.
type A2AVMManagedDiskInputDetails struct {
	// REQUIRED; The disk Id.
	DiskID *string `json:"diskId,omitempty"`

	// REQUIRED; The primary staging storage account Arm Id.
	PrimaryStagingAzureStorageAccountID *string `json:"primaryStagingAzureStorageAccountId,omitempty"`

	// REQUIRED; The target resource group Arm Id.
	RecoveryResourceGroupID *string `json:"recoveryResourceGroupId,omitempty"`

	// The recovery disk encryption information (for one / single pass flows).
	DiskEncryptionInfo *DiskEncryptionInfo `json:"diskEncryptionInfo,omitempty"`

	// The recovery disk encryption set Id.
	RecoveryDiskEncryptionSetID *string `json:"recoveryDiskEncryptionSetId,omitempty"`

	// The replica disk type. Its an optional value and will be same as source disk type if not user provided.
	RecoveryReplicaDiskAccountType *string `json:"recoveryReplicaDiskAccountType,omitempty"`

	// The target disk type after failover. Its an optional value and will be same as source disk type if not user provided.
	RecoveryTargetDiskAccountType *string `json:"recoveryTargetDiskAccountType,omitempty"`
}

// A2AVMManagedDiskUpdateDetails - A2A Vm managed disk update details.
type A2AVMManagedDiskUpdateDetails struct {
	// The recovery os disk encryption information.
	DiskEncryptionInfo *DiskEncryptionInfo `json:"diskEncryptionInfo,omitempty"`

	// The disk Id.
	DiskID *string `json:"diskId,omitempty"`

	// The target disk name for unplanned failover operation.
	FailoverDiskName *string `json:"failoverDiskName,omitempty"`

	// The replica disk type before failover.
	RecoveryReplicaDiskAccountType *string `json:"recoveryReplicaDiskAccountType,omitempty"`

	// The target disk type before failover.
	RecoveryTargetDiskAccountType *string `json:"recoveryTargetDiskAccountType,omitempty"`

	// The target disk name for test failover operation.
	TfoDiskName *string `json:"tfoDiskName,omitempty"`
}

// A2AZoneDetails - Zone details data.
type A2AZoneDetails struct {
	// Source zone info.
	Source *string `json:"source,omitempty"`

	// The target zone info.
	Target *string `json:"target,omitempty"`
}

// ASRTask - Task of the Job.
type ASRTask struct {
	// The state/actions applicable on this task.
	AllowedActions []*string `json:"allowedActions,omitempty"`

	// The custom task details based on the task type.
	CustomDetails TaskTypeDetailsClassification `json:"customDetails,omitempty"`

	// The end time.
	EndTime *time.Time `json:"endTime,omitempty"`

	// The task error details.
	Errors []*JobErrorDetails `json:"errors,omitempty"`

	// The name.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// The custom task details based on the task type, if the task type is GroupTaskDetails or one of the types derived from it.
	GroupTaskCustomDetails GroupTaskDetailsClassification `json:"groupTaskCustomDetails,omitempty"`

	// The unique Task name.
	Name *string `json:"name,omitempty"`

	// The start time.
	StartTime *time.Time `json:"startTime,omitempty"`

	// The State. It is one of these values - NotStarted, InProgress, Succeeded, Failed, Cancelled, Suspended or Other.
	State *string `json:"state,omitempty"`

	// The description of the task state. For example - For Succeeded state, description can be Completed, PartiallySucceeded,
	// CompletedWithInformation or Skipped.
	StateDescription *string `json:"stateDescription,omitempty"`

	// The Id.
	TaskID *string `json:"taskId,omitempty"`

	// The type of task. Details in CustomDetails property depend on this type.
	TaskType *string `json:"taskType,omitempty"`
}

// AddDisksInput - Input for add disk(s) operation.
type AddDisksInput struct {
	// Add disks input properties.
	Properties *AddDisksInputProperties `json:"properties,omitempty"`
}

// AddDisksInputProperties - Add Disks input properties.
type AddDisksInputProperties struct {
	// REQUIRED; The ReplicationProviderInput. For HyperVReplicaAzure provider, it will be AzureEnableProtectionInput object.
	// For San provider, it will be SanEnableProtectionInput object. For HyperVReplicaAzure
	// provider, it can be null.
	ProviderSpecificDetails AddDisksProviderSpecificInputClassification `json:"providerSpecificDetails,omitempty"`
}

// AddDisksProviderSpecificInputClassification provides polymorphic access to related types.
// Call the interface's GetAddDisksProviderSpecificInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *A2AAddDisksInput, *AddDisksProviderSpecificInput
type AddDisksProviderSpecificInputClassification interface {
	// GetAddDisksProviderSpecificInput returns the AddDisksProviderSpecificInput content of the underlying type.
	GetAddDisksProviderSpecificInput() *AddDisksProviderSpecificInput
}

// AddDisksProviderSpecificInput - Add Disks provider specific input.
type AddDisksProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetAddDisksProviderSpecificInput implements the AddDisksProviderSpecificInputClassification interface for type AddDisksProviderSpecificInput.
func (a *AddDisksProviderSpecificInput) GetAddDisksProviderSpecificInput() *AddDisksProviderSpecificInput {
	return a
}

// AddRecoveryServicesProviderInput - Input required to add a provider.
type AddRecoveryServicesProviderInput struct {
	// REQUIRED; The properties of an add provider request.
	Properties *AddRecoveryServicesProviderInputProperties `json:"properties,omitempty"`
}

// AddRecoveryServicesProviderInputProperties - The properties of an add provider request.
type AddRecoveryServicesProviderInputProperties struct {
	// REQUIRED; The identity provider input for DRA authentication.
	AuthenticationIdentityInput *IdentityProviderInput `json:"authenticationIdentityInput,omitempty"`

	// REQUIRED; The name of the machine where the provider is getting added.
	MachineName *string `json:"machineName,omitempty"`

	// REQUIRED; The identity provider input for resource access.
	ResourceAccessIdentityInput *IdentityProviderInput `json:"resourceAccessIdentityInput,omitempty"`

	// The Bios Id of the machine.
	BiosID *string `json:"biosId,omitempty"`

	// The identity provider input for data plane authentication.
	DataPlaneAuthenticationIdentityInput *IdentityProviderInput `json:"dataPlaneAuthenticationIdentityInput,omitempty"`

	// The Id of the machine where the provider is getting added.
	MachineID *string `json:"machineId,omitempty"`
}

// AddVCenterRequest - Input required to add vCenter.
type AddVCenterRequest struct {
	// The properties of an add vCenter request.
	Properties *AddVCenterRequestProperties `json:"properties,omitempty"`
}

// AddVCenterRequestProperties - The properties of an add vCenter request.
type AddVCenterRequestProperties struct {
	// The friendly name of the vCenter.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// The IP address of the vCenter to be discovered.
	IPAddress *string `json:"ipAddress,omitempty"`

	// The port number for discovery.
	Port *string `json:"port,omitempty"`

	// The process server Id from where the discovery is orchestrated.
	ProcessServerID *string `json:"processServerId,omitempty"`

	// The account Id which has privileges to discover the vCenter.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`
}

// AgentDetails - Agent details.
type AgentDetails struct {
	// READ-ONLY; The Id of the agent running on the server.
	AgentID *string `json:"agentId,omitempty" azure:"ro"`

	// READ-ONLY; The machine BIOS Id.
	BiosID *string `json:"biosId,omitempty" azure:"ro"`

	// READ-ONLY; The disks.
	Disks []*AgentDiskDetails `json:"disks,omitempty" azure:"ro"`

	// READ-ONLY; The machine FQDN.
	Fqdn *string `json:"fqdn,omitempty" azure:"ro"`

	// READ-ONLY; The Id of the machine to which the agent is registered.
	MachineID *string `json:"machineId,omitempty" azure:"ro"`
}

// AgentDiskDetails - Agent disk details.
type AgentDiskDetails struct {
	// READ-ONLY; The disk capacity in bytes.
	CapacityInBytes *int64 `json:"capacityInBytes,omitempty" azure:"ro"`

	// READ-ONLY; The disk Id.
	DiskID *string `json:"diskId,omitempty" azure:"ro"`

	// READ-ONLY; The disk name.
	DiskName *string `json:"diskName,omitempty" azure:"ro"`

	// READ-ONLY; A value indicating whether the disk is the OS disk.
	IsOSDisk *string `json:"isOSDisk,omitempty" azure:"ro"`

	// READ-ONLY; The lun of disk.
	LunID *int32 `json:"lunId,omitempty" azure:"ro"`
}

// Alert - Implements the Alert class.
type Alert struct {
	// Resource Location
	Location *string `json:"location,omitempty"`

	// Alert related data.
	Properties *AlertProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AlertCollection - Collection of alerts.
type AlertCollection struct {
	// The value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of alerts.
	Value []*Alert `json:"value,omitempty"`
}

// AlertProperties - The properties of an alert.
type AlertProperties struct {
	// The custom email address for sending emails.
	CustomEmailAddresses []*string `json:"customEmailAddresses,omitempty"`

	// The locale for the email notification.
	Locale *string `json:"locale,omitempty"`

	// A value indicating whether to send email to subscription administrator.
	SendToOwners *string `json:"sendToOwners,omitempty"`
}

// ApplianceCollection - Collection of appliance details.
type ApplianceCollection struct {
	// The value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// The appliance details.
	Value []*ReplicationAppliance `json:"value,omitempty"`
}

// ApplianceQueryParameter - Query parameter to get appliance.
type ApplianceQueryParameter struct {
	// The providerType to be used for fetching appliance details.
	ProviderType *string `json:"providerType,omitempty"`
}

// ApplianceSpecificDetailsClassification provides polymorphic access to related types.
// Call the interface's GetApplianceSpecificDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ApplianceSpecificDetails, *InMageRcmApplianceSpecificDetails
type ApplianceSpecificDetailsClassification interface {
	// GetApplianceSpecificDetails returns the ApplianceSpecificDetails content of the underlying type.
	GetApplianceSpecificDetails() *ApplianceSpecificDetails
}

// ApplianceSpecificDetails - Appliance specific details.
type ApplianceSpecificDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetApplianceSpecificDetails implements the ApplianceSpecificDetailsClassification interface for type ApplianceSpecificDetails.
func (a *ApplianceSpecificDetails) GetApplianceSpecificDetails() *ApplianceSpecificDetails { return a }

// ApplyRecoveryPointInput - Input to apply recovery point.
type ApplyRecoveryPointInput struct {
	// REQUIRED; The input properties to apply recovery point.
	Properties *ApplyRecoveryPointInputProperties `json:"properties,omitempty"`
}

// ApplyRecoveryPointInputProperties - Input properties to apply recovery point.
type ApplyRecoveryPointInputProperties struct {
	// REQUIRED; Provider specific input for applying recovery point.
	ProviderSpecificDetails ApplyRecoveryPointProviderSpecificInputClassification `json:"providerSpecificDetails,omitempty"`

	// The recovery point Id.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
}

// ApplyRecoveryPointProviderSpecificInputClassification provides polymorphic access to related types.
// Call the interface's GetApplyRecoveryPointProviderSpecificInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *A2AApplyRecoveryPointInput, *A2ACrossClusterMigrationApplyRecoveryPointInput, *ApplyRecoveryPointProviderSpecificInput,
// - *HyperVReplicaAzureApplyRecoveryPointInput, *InMageAzureV2ApplyRecoveryPointInput, *InMageRcmApplyRecoveryPointInput
type ApplyRecoveryPointProviderSpecificInputClassification interface {
	// GetApplyRecoveryPointProviderSpecificInput returns the ApplyRecoveryPointProviderSpecificInput content of the underlying type.
	GetApplyRecoveryPointProviderSpecificInput() *ApplyRecoveryPointProviderSpecificInput
}

// ApplyRecoveryPointProviderSpecificInput - Provider specific input for apply recovery point.
type ApplyRecoveryPointProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetApplyRecoveryPointProviderSpecificInput implements the ApplyRecoveryPointProviderSpecificInputClassification interface
// for type ApplyRecoveryPointProviderSpecificInput.
func (a *ApplyRecoveryPointProviderSpecificInput) GetApplyRecoveryPointProviderSpecificInput() *ApplyRecoveryPointProviderSpecificInput {
	return a
}

// AsrJobDetails - This class represents job details based on specific job type.
type AsrJobDetails struct {
	// REQUIRED; Gets the type of job details (see JobDetailsTypes enum for possible values).
	InstanceType *string `json:"instanceType,omitempty"`

	// The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow
	// object details.
	AffectedObjectDetails map[string]*string `json:"affectedObjectDetails,omitempty"`
}

// GetJobDetails implements the JobDetailsClassification interface for type AsrJobDetails.
func (a *AsrJobDetails) GetJobDetails() *JobDetails {
	return &JobDetails{
		InstanceType:          a.InstanceType,
		AffectedObjectDetails: a.AffectedObjectDetails,
	}
}

// AutomationRunbookTaskDetails - This class represents the task details for an automation runbook.
type AutomationRunbookTaskDetails struct {
	// REQUIRED; The type of task details.
	InstanceType *string `json:"instanceType,omitempty"`

	// The automation account name of the runbook.
	AccountName *string `json:"accountName,omitempty"`

	// The cloud service of the automation runbook account.
	CloudServiceName *string `json:"cloudServiceName,omitempty"`

	// A value indicating whether it is a primary side script or not.
	IsPrimarySideScript *bool `json:"isPrimarySideScript,omitempty"`

	// The job Id of the runbook execution.
	JobID *string `json:"jobId,omitempty"`

	// The execution output of the runbook.
	JobOutput *string `json:"jobOutput,omitempty"`

	// The recovery plan task name.
	Name *string `json:"name,omitempty"`

	// The runbook Id.
	RunbookID *string `json:"runbookId,omitempty"`

	// The runbook name.
	RunbookName *string `json:"runbookName,omitempty"`

	// The subscription Id of the automation runbook account.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
}

// GetTaskTypeDetails implements the TaskTypeDetailsClassification interface for type AutomationRunbookTaskDetails.
func (a *AutomationRunbookTaskDetails) GetTaskTypeDetails() *TaskTypeDetails {
	return &TaskTypeDetails{
		InstanceType: a.InstanceType,
	}
}

// AzureFabricCreationInput - Fabric provider specific settings.
type AzureFabricCreationInput struct {
	// REQUIRED; Gets the class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The Location.
	Location *string `json:"location,omitempty"`
}

// GetFabricSpecificCreationInput implements the FabricSpecificCreationInputClassification interface for type AzureFabricCreationInput.
func (a *AzureFabricCreationInput) GetFabricSpecificCreationInput() *FabricSpecificCreationInput {
	return &FabricSpecificCreationInput{
		InstanceType: a.InstanceType,
	}
}

// AzureFabricSpecificDetails - Azure Fabric Specific Details.
type AzureFabricSpecificDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// The container Ids for the Azure fabric.
	ContainerIDs []*string `json:"containerIds,omitempty"`

	// The Location for the Azure fabric.
	Location *string `json:"location,omitempty"`

	// The zones.
	Zones []*A2AZoneDetails `json:"zones,omitempty"`
}

// GetFabricSpecificDetails implements the FabricSpecificDetailsClassification interface for type AzureFabricSpecificDetails.
func (a *AzureFabricSpecificDetails) GetFabricSpecificDetails() *FabricSpecificDetails {
	return &FabricSpecificDetails{
		InstanceType: a.InstanceType,
	}
}

// AzureToAzureCreateNetworkMappingInput - Create network mappings input properties/behavior specific to Azure to Azure Network
// mapping.
type AzureToAzureCreateNetworkMappingInput struct {
	// REQUIRED; The instance type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; The primary azure vnet Id.
	PrimaryNetworkID *string `json:"primaryNetworkId,omitempty"`
}

// GetFabricSpecificCreateNetworkMappingInput implements the FabricSpecificCreateNetworkMappingInputClassification interface
// for type AzureToAzureCreateNetworkMappingInput.
func (a *AzureToAzureCreateNetworkMappingInput) GetFabricSpecificCreateNetworkMappingInput() *FabricSpecificCreateNetworkMappingInput {
	return &FabricSpecificCreateNetworkMappingInput{
		InstanceType: a.InstanceType,
	}
}

// AzureToAzureNetworkMappingSettings - A2A Network Mapping fabric specific settings.
type AzureToAzureNetworkMappingSettings struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The primary fabric location.
	PrimaryFabricLocation *string `json:"primaryFabricLocation,omitempty"`

	// The recovery fabric location.
	RecoveryFabricLocation *string `json:"recoveryFabricLocation,omitempty"`
}

// GetNetworkMappingFabricSpecificSettings implements the NetworkMappingFabricSpecificSettingsClassification interface for
// type AzureToAzureNetworkMappingSettings.
func (a *AzureToAzureNetworkMappingSettings) GetNetworkMappingFabricSpecificSettings() *NetworkMappingFabricSpecificSettings {
	return &NetworkMappingFabricSpecificSettings{
		InstanceType: a.InstanceType,
	}
}

// AzureToAzureUpdateNetworkMappingInput - Updates network mappings input.
type AzureToAzureUpdateNetworkMappingInput struct {
	// REQUIRED; The instance type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The primary azure vnet Id.
	PrimaryNetworkID *string `json:"primaryNetworkId,omitempty"`
}

// GetFabricSpecificUpdateNetworkMappingInput implements the FabricSpecificUpdateNetworkMappingInputClassification interface
// for type AzureToAzureUpdateNetworkMappingInput.
func (a *AzureToAzureUpdateNetworkMappingInput) GetFabricSpecificUpdateNetworkMappingInput() *FabricSpecificUpdateNetworkMappingInput {
	return &FabricSpecificUpdateNetworkMappingInput{
		InstanceType: a.InstanceType,
	}
}

// AzureToAzureVMSyncedConfigDetails - Azure to Azure VM synced configuration details.
type AzureToAzureVMSyncedConfigDetails struct {
	// The Azure VM input endpoints.
	InputEndpoints []*InputEndpoint `json:"inputEndpoints,omitempty"`

	// The Azure VM tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// AzureVMDiskDetails - Disk details for E2A provider.
type AzureVMDiskDetails struct {
	// The custom target Azure disk name.
	CustomTargetDiskName *string `json:"customTargetDiskName,omitempty"`

	// The DiskEncryptionSet ARM ID.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`

	// The disk resource id.
	DiskID *string `json:"diskId,omitempty"`

	// Ordinal\LunId of the disk for the Azure VM.
	LunID *string `json:"lunId,omitempty"`

	// Max side in MB.
	MaxSizeMB *string `json:"maxSizeMB,omitempty"`

	// Blob uri of the Azure disk.
	TargetDiskLocation *string `json:"targetDiskLocation,omitempty"`

	// The target Azure disk name.
	TargetDiskName *string `json:"targetDiskName,omitempty"`

	// The VHD id.
	VhdID *string `json:"vhdId,omitempty"`

	// VHD name.
	VhdName *string `json:"vhdName,omitempty"`

	// VHD type.
	VhdType *string `json:"vhdType,omitempty"`
}

// ComputeSizeErrorDetails - Represents the error used to indicate why the target compute size is not applicable.
type ComputeSizeErrorDetails struct {
	// The error message.
	Message *string `json:"message,omitempty"`

	// The severity of the error.
	Severity *string `json:"severity,omitempty"`
}

// ConfigurationSettingsClassification provides polymorphic access to related types.
// Call the interface's GetConfigurationSettings() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ConfigurationSettings, *HyperVVirtualMachineDetails, *ReplicationGroupDetails, *VMwareVirtualMachineDetails, *VmmVirtualMachineDetails
type ConfigurationSettingsClassification interface {
	// GetConfigurationSettings returns the ConfigurationSettings content of the underlying type.
	GetConfigurationSettings() *ConfigurationSettings
}

// ConfigurationSettings - Replication provider specific settings.
type ConfigurationSettings struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetConfigurationSettings implements the ConfigurationSettingsClassification interface for type ConfigurationSettings.
func (c *ConfigurationSettings) GetConfigurationSettings() *ConfigurationSettings { return c }

// ConfigureAlertRequest - Request to configure alerts for the system.
type ConfigureAlertRequest struct {
	// The properties of a configure alert request.
	Properties *ConfigureAlertRequestProperties `json:"properties,omitempty"`
}

// ConfigureAlertRequestProperties - Properties of a configure alert request.
type ConfigureAlertRequestProperties struct {
	// The custom email address for sending emails.
	CustomEmailAddresses []*string `json:"customEmailAddresses,omitempty"`

	// The locale for the email notification.
	Locale *string `json:"locale,omitempty"`

	// A value indicating whether to send email to subscription administrator.
	SendToOwners *string `json:"sendToOwners,omitempty"`
}

// ConsistencyCheckTaskDetails - This class contains monitoring details of all the inconsistent Protected Entities in Vmm.
type ConsistencyCheckTaskDetails struct {
	// REQUIRED; The type of task details.
	InstanceType *string `json:"instanceType,omitempty"`

	// The list of inconsistent Vm details.
	VMDetails []*InconsistentVMDetails `json:"vmDetails,omitempty"`
}

// GetTaskTypeDetails implements the TaskTypeDetailsClassification interface for type ConsistencyCheckTaskDetails.
func (c *ConsistencyCheckTaskDetails) GetTaskTypeDetails() *TaskTypeDetails {
	return &TaskTypeDetails{
		InstanceType: c.InstanceType,
	}
}

// CreateNetworkMappingInput - Create network mappings input.
type CreateNetworkMappingInput struct {
	// REQUIRED; Input properties for creating network mapping.
	Properties *CreateNetworkMappingInputProperties `json:"properties,omitempty"`
}

// CreateNetworkMappingInputProperties - Common input details for network mapping operation.
type CreateNetworkMappingInputProperties struct {
	// REQUIRED; Recovery network Id.
	RecoveryNetworkID *string `json:"recoveryNetworkId,omitempty"`

	// Fabric specific input properties.
	FabricSpecificDetails FabricSpecificCreateNetworkMappingInputClassification `json:"fabricSpecificDetails,omitempty"`

	// Recovery fabric Name.
	RecoveryFabricName *string `json:"recoveryFabricName,omitempty"`
}

// CreatePolicyInput - Protection Policy input.
type CreatePolicyInput struct {
	// Policy creation properties.
	Properties *CreatePolicyInputProperties `json:"properties,omitempty"`
}

// CreatePolicyInputProperties - Policy creation properties.
type CreatePolicyInputProperties struct {
	// The ReplicationProviderSettings.
	ProviderSpecificInput PolicyProviderSpecificInputClassification `json:"providerSpecificInput,omitempty"`
}

// CreateProtectionContainerInput - Create protection container input.
type CreateProtectionContainerInput struct {
	// Create protection container input properties.
	Properties *CreateProtectionContainerInputProperties `json:"properties,omitempty"`
}

// CreateProtectionContainerInputProperties - Create protection container input properties.
type CreateProtectionContainerInputProperties struct {
	// Provider specific inputs for container creation.
	ProviderSpecificInput []ReplicationProviderSpecificContainerCreationInputClassification `json:"providerSpecificInput,omitempty"`
}

// CreateProtectionContainerMappingInput - Configure pairing input.
type CreateProtectionContainerMappingInput struct {
	// Configure protection input properties.
	Properties *CreateProtectionContainerMappingInputProperties `json:"properties,omitempty"`
}

// CreateProtectionContainerMappingInputProperties - Configure pairing input properties.
type CreateProtectionContainerMappingInputProperties struct {
	// Applicable policy.
	PolicyID *string `json:"policyId,omitempty"`

	// Provider specific input for pairing.
	ProviderSpecificInput ReplicationProviderSpecificContainerMappingInputClassification `json:"providerSpecificInput,omitempty"`

	// The target unique protection container name.
	TargetProtectionContainerID *string `json:"targetProtectionContainerId,omitempty"`
}

// CreateProtectionIntentInput - Create protection intent input.
type CreateProtectionIntentInput struct {
	// Create protection intent input properties.
	Properties *CreateProtectionIntentProperties `json:"properties,omitempty"`
}

// CreateProtectionIntentProperties - Create protection intent input properties.
type CreateProtectionIntentProperties struct {
	// The ReplicationProviderInput. For A2A provider, it will be A2ACreateProtectionIntentInput object.
	ProviderSpecificDetails CreateProtectionIntentProviderSpecificDetailsClassification `json:"providerSpecificDetails,omitempty"`
}

// CreateProtectionIntentProviderSpecificDetailsClassification provides polymorphic access to related types.
// Call the interface's GetCreateProtectionIntentProviderSpecificDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *A2ACreateProtectionIntentInput, *CreateProtectionIntentProviderSpecificDetails
type CreateProtectionIntentProviderSpecificDetailsClassification interface {
	// GetCreateProtectionIntentProviderSpecificDetails returns the CreateProtectionIntentProviderSpecificDetails content of the underlying type.
	GetCreateProtectionIntentProviderSpecificDetails() *CreateProtectionIntentProviderSpecificDetails
}

// CreateProtectionIntentProviderSpecificDetails - Create protection intent provider specific input.
type CreateProtectionIntentProviderSpecificDetails struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetCreateProtectionIntentProviderSpecificDetails implements the CreateProtectionIntentProviderSpecificDetailsClassification
// interface for type CreateProtectionIntentProviderSpecificDetails.
func (c *CreateProtectionIntentProviderSpecificDetails) GetCreateProtectionIntentProviderSpecificDetails() *CreateProtectionIntentProviderSpecificDetails {
	return c
}

// CreateRecoveryPlanInput - Create recovery plan input class.
type CreateRecoveryPlanInput struct {
	// REQUIRED; Recovery plan creation properties.
	Properties *CreateRecoveryPlanInputProperties `json:"properties,omitempty"`
}

// CreateRecoveryPlanInputProperties - Recovery plan creation properties.
type CreateRecoveryPlanInputProperties struct {
	// REQUIRED; The recovery plan groups.
	Groups []*RecoveryPlanGroup `json:"groups,omitempty"`

	// REQUIRED; The primary fabric Id.
	PrimaryFabricID *string `json:"primaryFabricId,omitempty"`

	// REQUIRED; The recovery fabric Id.
	RecoveryFabricID *string `json:"recoveryFabricId,omitempty"`

	// The failover deployment model.
	FailoverDeploymentModel *FailoverDeploymentModel `json:"failoverDeploymentModel,omitempty"`

	// The provider specific input.
	ProviderSpecificInput []RecoveryPlanProviderSpecificInputClassification `json:"providerSpecificInput,omitempty"`
}

// CurrentJobDetails - Current job details of the migration item.
type CurrentJobDetails struct {
	// READ-ONLY; The ARM Id of the job being executed.
	JobID *string `json:"jobId,omitempty" azure:"ro"`

	// READ-ONLY; The job name.
	JobName *string `json:"jobName,omitempty" azure:"ro"`

	// READ-ONLY; The start time of the job.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`
}

// CurrentScenarioDetails - Current scenario details of the protected entity.
type CurrentScenarioDetails struct {
	// ARM Id of the job being executed.
	JobID *string `json:"jobId,omitempty"`

	// Scenario name.
	ScenarioName *string `json:"scenarioName,omitempty"`

	// Start time of the workflow.
	StartTime *time.Time `json:"startTime,omitempty"`
}

// DataStore - The datastore details of the MT.
type DataStore struct {
	// The capacity of data store in GBs.
	Capacity *string `json:"capacity,omitempty"`

	// The free space of data store in GBs.
	FreeSpace *string `json:"freeSpace,omitempty"`

	// The symbolic name of data store.
	SymbolicName *string `json:"symbolicName,omitempty"`

	// The type of data store.
	Type *string `json:"type,omitempty"`

	// The uuid of data store.
	UUID *string `json:"uuid,omitempty"`
}

// DisableProtectionInput - Disable protection input.
type DisableProtectionInput struct {
	// REQUIRED; Disable protection input properties.
	Properties *DisableProtectionInputProperties `json:"properties,omitempty"`
}

// DisableProtectionInputProperties - Disable protection input properties.
type DisableProtectionInputProperties struct {
	// Disable protection reason. It can have values NotSpecified/MigrationComplete.
	DisableProtectionReason *DisableProtectionReason `json:"disableProtectionReason,omitempty"`

	// Replication provider specific input.
	ReplicationProviderInput DisableProtectionProviderSpecificInputClassification `json:"replicationProviderInput,omitempty"`
}

// DisableProtectionProviderSpecificInputClassification provides polymorphic access to related types.
// Call the interface's GetDisableProtectionProviderSpecificInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *DisableProtectionProviderSpecificInput, *InMageDisableProtectionProviderSpecificInput
type DisableProtectionProviderSpecificInputClassification interface {
	// GetDisableProtectionProviderSpecificInput returns the DisableProtectionProviderSpecificInput content of the underlying type.
	GetDisableProtectionProviderSpecificInput() *DisableProtectionProviderSpecificInput
}

// DisableProtectionProviderSpecificInput - Disable protection provider specific input.
type DisableProtectionProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetDisableProtectionProviderSpecificInput implements the DisableProtectionProviderSpecificInputClassification interface
// for type DisableProtectionProviderSpecificInput.
func (d *DisableProtectionProviderSpecificInput) GetDisableProtectionProviderSpecificInput() *DisableProtectionProviderSpecificInput {
	return d
}

// DiscoverProtectableItemRequest - Request to add a physical machine as a protectable item in a container.
type DiscoverProtectableItemRequest struct {
	// The properties of a discover protectable item request.
	Properties *DiscoverProtectableItemRequestProperties `json:"properties,omitempty"`
}

// DiscoverProtectableItemRequestProperties - Discover protectable item properties.
type DiscoverProtectableItemRequestProperties struct {
	// The friendly name of the physical machine.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// The IP address of the physical machine to be discovered.
	IPAddress *string `json:"ipAddress,omitempty"`

	// The OS type on the physical machine.
	OSType *string `json:"osType,omitempty"`
}

// DiskDetails - Onprem disk details data.
type DiskDetails struct {
	// The hard disk max size in MB.
	MaxSizeMB *int64 `json:"maxSizeMB,omitempty"`

	// The VHD Id.
	VhdID *string `json:"vhdId,omitempty"`

	// The VHD name.
	VhdName *string `json:"vhdName,omitempty"`

	// The type of the volume.
	VhdType *string `json:"vhdType,omitempty"`
}

// DiskEncryptionInfo - Recovery disk encryption info (BEK and KEK).
type DiskEncryptionInfo struct {
	// The recovery KeyVault reference for secret.
	DiskEncryptionKeyInfo *DiskEncryptionKeyInfo `json:"diskEncryptionKeyInfo,omitempty"`

	// The recovery KeyVault reference for key.
	KeyEncryptionKeyInfo *KeyEncryptionKeyInfo `json:"keyEncryptionKeyInfo,omitempty"`
}

// DiskEncryptionKeyInfo - Disk Encryption Key Information (BitLocker Encryption Key (BEK) on Windows).
type DiskEncryptionKeyInfo struct {
	// The KeyVault resource ARM id for secret.
	KeyVaultResourceArmID *string `json:"keyVaultResourceArmId,omitempty"`

	// The secret url / identifier.
	SecretIdentifier *string `json:"secretIdentifier,omitempty"`
}

// DiskVolumeDetails - Volume details.
type DiskVolumeDetails struct {
	// The volume label.
	Label *string `json:"label,omitempty"`

	// The volume name.
	Name *string `json:"name,omitempty"`
}

// Display - Contains the localized display information for this particular operation / action. These value will be used by
// several clients for (1) custom role definitions for RBAC; (2) complex query filters for
// the event service; and (3) audit history / records for management operations.
type Display struct {
	// The description. The localized friendly description for the operation, as it should be shown to the user. It should be
	// thorough, yet concise - it will be used in tool tips and detailed views.
	// Prescriptive guidance for namespaces: Read any 'display.provider' resource Create or Update any 'display.provider' resource
	// Delete any 'display.provider' resource Perform any other action on any
	// 'display.provider' resource Prescriptive guidance for namespaces: Read any 'display.resource' Create or Update any 'display.resource'
	// Delete any 'display.resource' 'ActionName' any
	// 'display.resources'.
	Description *string `json:"description,omitempty"`

	// The operation. The localized friendly name for the operation, as it should be shown to the user. It should be concise (to
	// fit in drop downs) but clear (i.e. self-documenting). It should use Title
	// Casing. Prescriptive guidance: Read Create or Update Delete 'ActionName'.
	Operation *string `json:"operation,omitempty"`

	// The provider. The localized friendly form of the resource provider name - it is expected to also include the publisher/company
	// responsible. It should use Title Casing and begin with "Microsoft" for
	// 1st party services. e.g. "Microsoft Monitoring Insights" or "Microsoft Compute.".
	Provider *string `json:"provider,omitempty"`

	// The resource. The localized friendly form of the resource related to this action/operation - it should match the public
	// documentation for the resource provider. It should use Title Casing. This value
	// should be unique for a particular URL type (e.g. nested types should not reuse their parent's display.resource field).
	// e.g. "Virtual Machines" or "Scheduler Job Collections", or "Virtual Machine VM
	// Sizes" or "Scheduler Jobs".
	Resource *string `json:"resource,omitempty"`
}

// DraDetails - DRA details.
type DraDetails struct {
	// READ-ONLY; The DRA Bios Id.
	BiosID *string `json:"biosId,omitempty" azure:"ro"`

	// READ-ONLY; The count of protected items which are protected in forward direction.
	ForwardProtectedItemCount *int32 `json:"forwardProtectedItemCount,omitempty" azure:"ro"`

	// READ-ONLY; The health.
	Health *ProtectionHealth `json:"health,omitempty" azure:"ro"`

	// READ-ONLY; The health errors.
	HealthErrors []*HealthError `json:"healthErrors,omitempty" azure:"ro"`

	// READ-ONLY; The DRA Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The last heartbeat received from the DRA.
	LastHeartbeatUTC *time.Time `json:"lastHeartbeatUtc,omitempty" azure:"ro"`

	// READ-ONLY; The DRA name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The count of protected items which are protected in reverse direction.
	ReverseProtectedItemCount *int32 `json:"reverseProtectedItemCount,omitempty" azure:"ro"`

	// READ-ONLY; The version.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// EnableMigrationInput - Enable migration input.
type EnableMigrationInput struct {
	// REQUIRED; Enable migration input properties.
	Properties *EnableMigrationInputProperties `json:"properties,omitempty"`
}

// EnableMigrationInputProperties - Enable migration input properties.
type EnableMigrationInputProperties struct {
	// REQUIRED; The policy Id.
	PolicyID *string `json:"policyId,omitempty"`

	// REQUIRED; The provider specific details.
	ProviderSpecificDetails EnableMigrationProviderSpecificInputClassification `json:"providerSpecificDetails,omitempty"`
}

// EnableMigrationProviderSpecificInputClassification provides polymorphic access to related types.
// Call the interface's GetEnableMigrationProviderSpecificInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *EnableMigrationProviderSpecificInput, *VMwareCbtEnableMigrationInput
type EnableMigrationProviderSpecificInputClassification interface {
	// GetEnableMigrationProviderSpecificInput returns the EnableMigrationProviderSpecificInput content of the underlying type.
	GetEnableMigrationProviderSpecificInput() *EnableMigrationProviderSpecificInput
}

// EnableMigrationProviderSpecificInput - Enable migration provider specific input.
type EnableMigrationProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetEnableMigrationProviderSpecificInput implements the EnableMigrationProviderSpecificInputClassification interface for
// type EnableMigrationProviderSpecificInput.
func (e *EnableMigrationProviderSpecificInput) GetEnableMigrationProviderSpecificInput() *EnableMigrationProviderSpecificInput {
	return e
}

// EnableProtectionInput - Enable protection input.
type EnableProtectionInput struct {
	// Enable protection input properties.
	Properties *EnableProtectionInputProperties `json:"properties,omitempty"`
}

// EnableProtectionInputProperties - Enable protection input properties.
type EnableProtectionInputProperties struct {
	// The Policy Id.
	PolicyID *string `json:"policyId,omitempty"`

	// The protectable item Id.
	ProtectableItemID *string `json:"protectableItemId,omitempty"`

	// The ReplicationProviderInput. For HyperVReplicaAzure provider, it will be AzureEnableProtectionInput object. For San provider,
	// it will be SanEnableProtectionInput object. For HyperVReplicaAzure
	// provider, it can be null.
	ProviderSpecificDetails EnableProtectionProviderSpecificInputClassification `json:"providerSpecificDetails,omitempty"`
}

// EnableProtectionProviderSpecificInputClassification provides polymorphic access to related types.
// Call the interface's GetEnableProtectionProviderSpecificInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *A2ACrossClusterMigrationEnableProtectionInput, *A2AEnableProtectionInput, *EnableProtectionProviderSpecificInput, *HyperVReplicaAzureEnableProtectionInput,
// - *InMageAzureV2EnableProtectionInput, *InMageEnableProtectionInput, *InMageRcmEnableProtectionInput
type EnableProtectionProviderSpecificInputClassification interface {
	// GetEnableProtectionProviderSpecificInput returns the EnableProtectionProviderSpecificInput content of the underlying type.
	GetEnableProtectionProviderSpecificInput() *EnableProtectionProviderSpecificInput
}

// EnableProtectionProviderSpecificInput - Enable protection provider specific input.
type EnableProtectionProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetEnableProtectionProviderSpecificInput implements the EnableProtectionProviderSpecificInputClassification interface for
// type EnableProtectionProviderSpecificInput.
func (e *EnableProtectionProviderSpecificInput) GetEnableProtectionProviderSpecificInput() *EnableProtectionProviderSpecificInput {
	return e
}

// EncryptionDetails - Encryption details for the fabric.
type EncryptionDetails struct {
	// The key encryption key certificate expiry date.
	KekCertExpiryDate *time.Time `json:"kekCertExpiryDate,omitempty"`

	// The key encryption key certificate thumbprint.
	KekCertThumbprint *string `json:"kekCertThumbprint,omitempty"`

	// The key encryption key state for the Vmm.
	KekState *string `json:"kekState,omitempty"`
}

// Event - Implements the Event class.
type Event struct {
	// Resource Location
	Location *string `json:"location,omitempty"`

	// Event related data.
	Properties *EventProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// EventCollection - Collection of fabric details.
type EventCollection struct {
	// The value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of events.
	Value []*Event `json:"value,omitempty"`
}

// EventProperties - The properties of a monitoring event.
type EventProperties struct {
	// The affected object correlationId for the event.
	AffectedObjectCorrelationID *string `json:"affectedObjectCorrelationId,omitempty"`

	// The friendly name of the source of the event on which it is raised (for example, VM, VMM etc).
	AffectedObjectFriendlyName *string `json:"affectedObjectFriendlyName,omitempty"`

	// The event name.
	Description *string `json:"description,omitempty"`

	// The Id of the monitoring event.
	EventCode *string `json:"eventCode,omitempty"`

	// The event specific settings.
	EventSpecificDetails EventSpecificDetailsClassification `json:"eventSpecificDetails,omitempty"`

	// The type of the event. for example: VM Health, Server Health, Job Failure etc.
	EventType *string `json:"eventType,omitempty"`

	// The ARM ID of the fabric.
	FabricID *string `json:"fabricId,omitempty"`

	// The list of errors / warnings capturing details associated with the issue(s).
	HealthErrors []*HealthError `json:"healthErrors,omitempty"`

	// The provider specific settings.
	ProviderSpecificDetails EventProviderSpecificDetailsClassification `json:"providerSpecificDetails,omitempty"`

	// The severity of the event.
	Severity *string `json:"severity,omitempty"`

	// The time of occurrence of the event.
	TimeOfOccurrence *time.Time `json:"timeOfOccurrence,omitempty"`
}

// EventProviderSpecificDetailsClassification provides polymorphic access to related types.
// Call the interface's GetEventProviderSpecificDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *A2AEventDetails, *EventProviderSpecificDetails, *HyperVReplica2012EventDetails, *HyperVReplica2012R2EventDetails, *HyperVReplicaAzureEventDetails,
// - *HyperVReplicaBaseEventDetails, *InMageAzureV2EventDetails, *InMageRcmEventDetails, *InMageRcmFailbackEventDetails, *VMwareCbtEventDetails
type EventProviderSpecificDetailsClassification interface {
	// GetEventProviderSpecificDetails returns the EventProviderSpecificDetails content of the underlying type.
	GetEventProviderSpecificDetails() *EventProviderSpecificDetails
}

// EventProviderSpecificDetails - Model class for provider specific details for an event.
type EventProviderSpecificDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetEventProviderSpecificDetails implements the EventProviderSpecificDetailsClassification interface for type EventProviderSpecificDetails.
func (e *EventProviderSpecificDetails) GetEventProviderSpecificDetails() *EventProviderSpecificDetails {
	return e
}

// EventQueryParameter - Implements the event query parameter.
type EventQueryParameter struct {
	// The affected object correlationId for the events to be queried.
	AffectedObjectCorrelationID *string `json:"affectedObjectCorrelationId,omitempty"`

	// The affected object name of the events to be queried.
	AffectedObjectFriendlyName *string `json:"affectedObjectFriendlyName,omitempty"`

	// The end time of the time range within which the events are to be queried.
	EndTime *time.Time `json:"endTime,omitempty"`

	// The source id of the events to be queried.
	EventCode *string `json:"eventCode,omitempty"`

	// The type of the events to be queried.
	EventType *string `json:"eventType,omitempty"`

	// The affected object server id of the events to be queried.
	FabricName *string `json:"fabricName,omitempty"`

	// The severity of the events to be queried.
	Severity *string `json:"severity,omitempty"`

	// The start time of the time range within which the events are to be queried.
	StartTime *time.Time `json:"startTime,omitempty"`
}

// EventSpecificDetailsClassification provides polymorphic access to related types.
// Call the interface's GetEventSpecificDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *EventSpecificDetails, *JobStatusEventDetails
type EventSpecificDetailsClassification interface {
	// GetEventSpecificDetails returns the EventSpecificDetails content of the underlying type.
	GetEventSpecificDetails() *EventSpecificDetails
}

// EventSpecificDetails - Model class for event specific details for an event.
type EventSpecificDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetEventSpecificDetails implements the EventSpecificDetailsClassification interface for type EventSpecificDetails.
func (e *EventSpecificDetails) GetEventSpecificDetails() *EventSpecificDetails { return e }

// ExistingProtectionProfile - Existing storage account input.
type ExistingProtectionProfile struct {
	// REQUIRED; The protection profile Arm Id. Throw error, if resource does not exists.
	ProtectionProfileID *string `json:"protectionProfileId,omitempty"`

	// REQUIRED; The class type.
	ResourceType *string `json:"resourceType,omitempty"`
}

// GetProtectionProfileCustomDetails implements the ProtectionProfileCustomDetailsClassification interface for type ExistingProtectionProfile.
func (e *ExistingProtectionProfile) GetProtectionProfileCustomDetails() *ProtectionProfileCustomDetails {
	return &ProtectionProfileCustomDetails{
		ResourceType: e.ResourceType,
	}
}

// ExistingRecoveryAvailabilitySet - Existing recovery availability set input.
type ExistingRecoveryAvailabilitySet struct {
	// REQUIRED; The class type.
	ResourceType *string `json:"resourceType,omitempty"`

	// The recovery availability set Id. Will throw error, if resource does not exist.
	RecoveryAvailabilitySetID *string `json:"recoveryAvailabilitySetId,omitempty"`
}

// GetRecoveryAvailabilitySetCustomDetails implements the RecoveryAvailabilitySetCustomDetailsClassification interface for
// type ExistingRecoveryAvailabilitySet.
func (e *ExistingRecoveryAvailabilitySet) GetRecoveryAvailabilitySetCustomDetails() *RecoveryAvailabilitySetCustomDetails {
	return &RecoveryAvailabilitySetCustomDetails{
		ResourceType: e.ResourceType,
	}
}

// ExistingRecoveryProximityPlacementGroup - Existing recovery proximity placement group input.
type ExistingRecoveryProximityPlacementGroup struct {
	// REQUIRED; The class type.
	ResourceType *string `json:"resourceType,omitempty"`

	// The recovery proximity placement group Id. Will throw error, if resource does not exist.
	RecoveryProximityPlacementGroupID *string `json:"recoveryProximityPlacementGroupId,omitempty"`
}

// GetRecoveryProximityPlacementGroupCustomDetails implements the RecoveryProximityPlacementGroupCustomDetailsClassification
// interface for type ExistingRecoveryProximityPlacementGroup.
func (e *ExistingRecoveryProximityPlacementGroup) GetRecoveryProximityPlacementGroupCustomDetails() *RecoveryProximityPlacementGroupCustomDetails {
	return &RecoveryProximityPlacementGroupCustomDetails{
		ResourceType: e.ResourceType,
	}
}

// ExistingRecoveryResourceGroup - Existing recovery resource group input.
type ExistingRecoveryResourceGroup struct {
	// REQUIRED; The class type.
	ResourceType *string `json:"resourceType,omitempty"`

	// The recovery resource group Id. Valid for V2 scenarios.
	RecoveryResourceGroupID *string `json:"recoveryResourceGroupId,omitempty"`
}

// GetRecoveryResourceGroupCustomDetails implements the RecoveryResourceGroupCustomDetailsClassification interface for type
// ExistingRecoveryResourceGroup.
func (e *ExistingRecoveryResourceGroup) GetRecoveryResourceGroupCustomDetails() *RecoveryResourceGroupCustomDetails {
	return &RecoveryResourceGroupCustomDetails{
		ResourceType: e.ResourceType,
	}
}

// ExistingRecoveryVirtualNetwork - Existing recovery virtual network input.
type ExistingRecoveryVirtualNetwork struct {
	// REQUIRED; The recovery virtual network Id. Will throw error, if resource does not exist.
	RecoveryVirtualNetworkID *string `json:"recoveryVirtualNetworkId,omitempty"`

	// REQUIRED; The class type.
	ResourceType *string `json:"resourceType,omitempty"`

	// The recovery subnet name.
	RecoverySubnetName *string `json:"recoverySubnetName,omitempty"`
}

// GetRecoveryVirtualNetworkCustomDetails implements the RecoveryVirtualNetworkCustomDetailsClassification interface for type
// ExistingRecoveryVirtualNetwork.
func (e *ExistingRecoveryVirtualNetwork) GetRecoveryVirtualNetworkCustomDetails() *RecoveryVirtualNetworkCustomDetails {
	return &RecoveryVirtualNetworkCustomDetails{
		ResourceType: e.ResourceType,
	}
}

// ExistingStorageAccount - Existing storage account input.
type ExistingStorageAccount struct {
	// REQUIRED; The storage account Arm Id. Throw error, if resource does not exists.
	AzureStorageAccountID *string `json:"azureStorageAccountId,omitempty"`

	// REQUIRED; The class type.
	ResourceType *string `json:"resourceType,omitempty"`
}

// GetStorageAccountCustomDetails implements the StorageAccountCustomDetailsClassification interface for type ExistingStorageAccount.
func (e *ExistingStorageAccount) GetStorageAccountCustomDetails() *StorageAccountCustomDetails {
	return &StorageAccountCustomDetails{
		ResourceType: e.ResourceType,
	}
}

// ExportJobDetails - This class represents details for export jobs workflow.
type ExportJobDetails struct {
	// REQUIRED; Gets the type of job details (see JobDetailsTypes enum for possible values).
	InstanceType *string `json:"instanceType,omitempty"`

	// The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow
	// object details.
	AffectedObjectDetails map[string]*string `json:"affectedObjectDetails,omitempty"`

	// BlobUri of the exported jobs.
	BlobURI *string `json:"blobUri,omitempty"`

	// The sas token to access blob.
	SasToken *string `json:"sasToken,omitempty"`
}

// GetJobDetails implements the JobDetailsClassification interface for type ExportJobDetails.
func (e *ExportJobDetails) GetJobDetails() *JobDetails {
	return &JobDetails{
		InstanceType:          e.InstanceType,
		AffectedObjectDetails: e.AffectedObjectDetails,
	}
}

// ExtendedLocation - Extended location of the resource.
type ExtendedLocation struct {
	// REQUIRED; The name of the extended location.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The extended location type.
	Type *ExtendedLocationType `json:"type,omitempty"`
}

// Fabric definition.
type Fabric struct {
	// Resource Location
	Location *string `json:"location,omitempty"`

	// Fabric related data.
	Properties *FabricProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FabricCollection - Collection of fabric details.
type FabricCollection struct {
	// The value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// The fabric details.
	Value []*Fabric `json:"value,omitempty"`
}

// FabricCreationInput - Site details provided during the time of site creation.
type FabricCreationInput struct {
	// Fabric creation input.
	Properties *FabricCreationInputProperties `json:"properties,omitempty"`
}

// FabricCreationInputProperties - Properties of site details provided during the time of site creation.
type FabricCreationInputProperties struct {
	// Fabric provider specific creation input.
	CustomDetails FabricSpecificCreationInputClassification `json:"customDetails,omitempty"`
}

// FabricProperties - Fabric properties.
type FabricProperties struct {
	// BCDR state of the fabric.
	BcdrState *string `json:"bcdrState,omitempty"`

	// Fabric specific settings.
	CustomDetails FabricSpecificDetailsClassification `json:"customDetails,omitempty"`

	// Encryption details for the fabric.
	EncryptionDetails *EncryptionDetails `json:"encryptionDetails,omitempty"`

	// Friendly name of the fabric.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Health of fabric.
	Health *string `json:"health,omitempty"`

	// Fabric health error details.
	HealthErrorDetails []*HealthError `json:"healthErrorDetails,omitempty"`

	// Dra Registration Id.
	InternalIdentifier *string `json:"internalIdentifier,omitempty"`

	// Rollover encryption details for the fabric.
	RolloverEncryptionDetails *EncryptionDetails `json:"rolloverEncryptionDetails,omitempty"`
}

// FabricQueryParameter - Query parameter to get fabric.
type FabricQueryParameter struct {
	// The BIOS Id to be used for fetching agent details.
	BiosID *string `json:"biosId,omitempty"`

	// The type of the discovered machine to be used for fetching agent details.
	DiscoveryType *string `json:"discoveryType,omitempty"`

	// A value indicating whether the agent details are to be fetched.
	FetchAgentDetails *string `json:"fetchAgentDetails,omitempty"`

	// The FQDN to be used for fetching agent details.
	Fqdn *string `json:"fqdn,omitempty"`

	// The OS type to be used for fetching agent details.
	OSType *string `json:"osType,omitempty"`

	// A value indicating whether the zone to zone mappings are to be returned.
	ZoneToZoneMappings *string `json:"zoneToZoneMappings,omitempty"`
}

// FabricReplicationGroupTaskDetails - This class represents the fabric replication group task details.
type FabricReplicationGroupTaskDetails struct {
	// REQUIRED; The type of task details.
	InstanceType *string `json:"instanceType,omitempty"`

	// The job entity.
	JobTask *JobEntity `json:"jobTask,omitempty"`

	// The skipped reason.
	SkippedReason *string `json:"skippedReason,omitempty"`

	// The skipped reason string.
	SkippedReasonString *string `json:"skippedReasonString,omitempty"`
}

// GetJobTaskDetails implements the JobTaskDetailsClassification interface for type FabricReplicationGroupTaskDetails.
func (f *FabricReplicationGroupTaskDetails) GetJobTaskDetails() *JobTaskDetails {
	return &JobTaskDetails{
		JobTask:      f.JobTask,
		InstanceType: f.InstanceType,
	}
}

// GetTaskTypeDetails implements the TaskTypeDetailsClassification interface for type FabricReplicationGroupTaskDetails.
func (f *FabricReplicationGroupTaskDetails) GetTaskTypeDetails() *TaskTypeDetails {
	return &TaskTypeDetails{
		InstanceType: f.InstanceType,
	}
}

// FabricSpecificCreateNetworkMappingInputClassification provides polymorphic access to related types.
// Call the interface's GetFabricSpecificCreateNetworkMappingInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureToAzureCreateNetworkMappingInput, *FabricSpecificCreateNetworkMappingInput, *VmmToAzureCreateNetworkMappingInput,
// - *VmmToVmmCreateNetworkMappingInput
type FabricSpecificCreateNetworkMappingInputClassification interface {
	// GetFabricSpecificCreateNetworkMappingInput returns the FabricSpecificCreateNetworkMappingInput content of the underlying type.
	GetFabricSpecificCreateNetworkMappingInput() *FabricSpecificCreateNetworkMappingInput
}

// FabricSpecificCreateNetworkMappingInput - Input details specific to fabrics during Network Mapping.
type FabricSpecificCreateNetworkMappingInput struct {
	// REQUIRED; The instance type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetFabricSpecificCreateNetworkMappingInput implements the FabricSpecificCreateNetworkMappingInputClassification interface
// for type FabricSpecificCreateNetworkMappingInput.
func (f *FabricSpecificCreateNetworkMappingInput) GetFabricSpecificCreateNetworkMappingInput() *FabricSpecificCreateNetworkMappingInput {
	return f
}

// FabricSpecificCreationInputClassification provides polymorphic access to related types.
// Call the interface's GetFabricSpecificCreationInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureFabricCreationInput, *FabricSpecificCreationInput, *InMageRcmFabricCreationInput, *VMwareV2FabricCreationInput
type FabricSpecificCreationInputClassification interface {
	// GetFabricSpecificCreationInput returns the FabricSpecificCreationInput content of the underlying type.
	GetFabricSpecificCreationInput() *FabricSpecificCreationInput
}

// FabricSpecificCreationInput - Fabric provider specific settings.
type FabricSpecificCreationInput struct {
	// REQUIRED; Gets the class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetFabricSpecificCreationInput implements the FabricSpecificCreationInputClassification interface for type FabricSpecificCreationInput.
func (f *FabricSpecificCreationInput) GetFabricSpecificCreationInput() *FabricSpecificCreationInput {
	return f
}

// FabricSpecificDetailsClassification provides polymorphic access to related types.
// Call the interface's GetFabricSpecificDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureFabricSpecificDetails, *FabricSpecificDetails, *HyperVSiteDetails, *InMageRcmFabricSpecificDetails, *VMwareDetails,
// - *VMwareV2FabricSpecificDetails, *VmmDetails
type FabricSpecificDetailsClassification interface {
	// GetFabricSpecificDetails returns the FabricSpecificDetails content of the underlying type.
	GetFabricSpecificDetails() *FabricSpecificDetails
}

// FabricSpecificDetails - Fabric specific details.
type FabricSpecificDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetFabricSpecificDetails implements the FabricSpecificDetailsClassification interface for type FabricSpecificDetails.
func (f *FabricSpecificDetails) GetFabricSpecificDetails() *FabricSpecificDetails { return f }

// FabricSpecificUpdateNetworkMappingInputClassification provides polymorphic access to related types.
// Call the interface's GetFabricSpecificUpdateNetworkMappingInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureToAzureUpdateNetworkMappingInput, *FabricSpecificUpdateNetworkMappingInput, *VmmToAzureUpdateNetworkMappingInput,
// - *VmmToVmmUpdateNetworkMappingInput
type FabricSpecificUpdateNetworkMappingInputClassification interface {
	// GetFabricSpecificUpdateNetworkMappingInput returns the FabricSpecificUpdateNetworkMappingInput content of the underlying type.
	GetFabricSpecificUpdateNetworkMappingInput() *FabricSpecificUpdateNetworkMappingInput
}

// FabricSpecificUpdateNetworkMappingInput - Input details specific to fabrics during Network Mapping.
type FabricSpecificUpdateNetworkMappingInput struct {
	// REQUIRED; The instance type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetFabricSpecificUpdateNetworkMappingInput implements the FabricSpecificUpdateNetworkMappingInputClassification interface
// for type FabricSpecificUpdateNetworkMappingInput.
func (f *FabricSpecificUpdateNetworkMappingInput) GetFabricSpecificUpdateNetworkMappingInput() *FabricSpecificUpdateNetworkMappingInput {
	return f
}

// FailoverJobDetails - This class represents the details for a failover job.
type FailoverJobDetails struct {
	// REQUIRED; Gets the type of job details (see JobDetailsTypes enum for possible values).
	InstanceType *string `json:"instanceType,omitempty"`

	// The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow
	// object details.
	AffectedObjectDetails map[string]*string `json:"affectedObjectDetails,omitempty"`

	// The test VM details.
	ProtectedItemDetails []*FailoverReplicationProtectedItemDetails `json:"protectedItemDetails,omitempty"`
}

// GetJobDetails implements the JobDetailsClassification interface for type FailoverJobDetails.
func (f *FailoverJobDetails) GetJobDetails() *JobDetails {
	return &JobDetails{
		InstanceType:          f.InstanceType,
		AffectedObjectDetails: f.AffectedObjectDetails,
	}
}

// FailoverProcessServerRequest - Request to failover a process server.
type FailoverProcessServerRequest struct {
	// The properties of the PS Failover request.
	Properties *FailoverProcessServerRequestProperties `json:"properties,omitempty"`
}

// FailoverProcessServerRequestProperties - The properties of the Failover Process Server request.
type FailoverProcessServerRequestProperties struct {
	// The container identifier.
	ContainerName *string `json:"containerName,omitempty"`

	// The source process server.
	SourceProcessServerID *string `json:"sourceProcessServerId,omitempty"`

	// The new process server.
	TargetProcessServerID *string `json:"targetProcessServerId,omitempty"`

	// A value for failover type. It can be systemlevel/serverlevel.
	UpdateType *string `json:"updateType,omitempty"`

	// The VMS to migrate.
	VMsToMigrate []*string `json:"vmsToMigrate,omitempty"`
}

// FailoverReplicationProtectedItemDetails - Failover details for a replication protected item.
type FailoverReplicationProtectedItemDetails struct {
	// The friendly name.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// The name.
	Name *string `json:"name,omitempty"`

	// The network connection status.
	NetworkConnectionStatus *string `json:"networkConnectionStatus,omitempty"`

	// The network friendly name.
	NetworkFriendlyName *string `json:"networkFriendlyName,omitempty"`

	// The recovery point Id.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`

	// The recovery point time.
	RecoveryPointTime *time.Time `json:"recoveryPointTime,omitempty"`

	// The network subnet.
	Subnet *string `json:"subnet,omitempty"`

	// The test Vm friendly name.
	TestVMFriendlyName *string `json:"testVmFriendlyName,omitempty"`

	// The test Vm name.
	TestVMName *string `json:"testVmName,omitempty"`
}

// GroupTaskDetailsClassification provides polymorphic access to related types.
// Call the interface's GetGroupTaskDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *GroupTaskDetails, *InlineWorkflowTaskDetails, *RecoveryPlanGroupTaskDetails, *RecoveryPlanShutdownGroupTaskDetails
type GroupTaskDetailsClassification interface {
	// GetGroupTaskDetails returns the GroupTaskDetails content of the underlying type.
	GetGroupTaskDetails() *GroupTaskDetails
}

// GroupTaskDetails - This class represents the group task details when parent child relationship exists in the drill down.
type GroupTaskDetails struct {
	// REQUIRED; The type of task details.
	InstanceType *string `json:"instanceType,omitempty"`

	// The child tasks.
	ChildTasks []*ASRTask `json:"childTasks,omitempty"`
}

// GetGroupTaskDetails implements the GroupTaskDetailsClassification interface for type GroupTaskDetails.
func (g *GroupTaskDetails) GetGroupTaskDetails() *GroupTaskDetails { return g }

// HealthError - Health Error.
type HealthError struct {
	// Error creation time (UTC).
	CreationTimeUTC *time.Time `json:"creationTimeUtc,omitempty"`

	// Value indicating whether the health error is customer resolvable.
	CustomerResolvability *HealthErrorCustomerResolvability `json:"customerResolvability,omitempty"`

	// ID of the entity.
	EntityID *string `json:"entityId,omitempty"`

	// Category of error.
	ErrorCategory *string `json:"errorCategory,omitempty"`

	// Error code.
	ErrorCode *string `json:"errorCode,omitempty"`

	// The health error unique id.
	ErrorID *string `json:"errorId,omitempty"`

	// Level of error.
	ErrorLevel *string `json:"errorLevel,omitempty"`

	// Error message.
	ErrorMessage *string `json:"errorMessage,omitempty"`

	// Source of error.
	ErrorSource *string `json:"errorSource,omitempty"`

	// Type of error.
	ErrorType *string `json:"errorType,omitempty"`

	// The inner health errors. HealthError having a list of HealthError as child errors is problematic. InnerHealthError is used
	// because this will prevent an infinite loop of structures when Hydra tries to
	// auto-generate the contract. We are exposing the related health errors as inner health errors and all API consumers can
	// utilize this in the same fashion as Exception -> InnerException.
	InnerHealthErrors []*InnerHealthError `json:"innerHealthErrors,omitempty"`

	// Possible causes of error.
	PossibleCauses *string `json:"possibleCauses,omitempty"`

	// Recommended action to resolve error.
	RecommendedAction *string `json:"recommendedAction,omitempty"`

	// DRA error message.
	RecoveryProviderErrorMessage *string `json:"recoveryProviderErrorMessage,omitempty"`

	// Summary message of the entity.
	SummaryMessage *string `json:"summaryMessage,omitempty"`
}

// HealthErrorSummary - class to define the summary of the health error details.
type HealthErrorSummary struct {
	// The list of affected resource correlation Ids. This can be used to uniquely identify the count of items affected by a specific
	// category and severity as well as count of item affected by an specific
	// issue.
	AffectedResourceCorrelationIDs []*string `json:"affectedResourceCorrelationIds,omitempty"`

	// The sub type of any subcomponent within the ARM resource that this might be applicable. Value remains null if not applicable.
	AffectedResourceSubtype *string `json:"affectedResourceSubtype,omitempty"`

	// The type of affected ARM resource.
	AffectedResourceType *string `json:"affectedResourceType,omitempty"`

	// The category of the health error.
	Category *HealthErrorCategory `json:"category,omitempty"`

	// Severity of error.
	Severity *Severity `json:"severity,omitempty"`

	// The code of the health error.
	SummaryCode *string `json:"summaryCode,omitempty"`

	// The summary message of the health error.
	SummaryMessage *string `json:"summaryMessage,omitempty"`
}

// HyperVHostDetails - Hyper-V host details.
type HyperVHostDetails struct {
	// READ-ONLY; The Hyper-V host Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The Mars agent version.
	MarsAgentVersion *string `json:"marsAgentVersion,omitempty" azure:"ro"`

	// READ-ONLY; The Hyper-V host name.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// HyperVReplica2012EventDetails - Model class for event details of a HyperVReplica E2E event.
type HyperVReplica2012EventDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// The container friendly name.
	ContainerName *string `json:"containerName,omitempty"`

	// The fabric friendly name.
	FabricName *string `json:"fabricName,omitempty"`

	// The remote container name.
	RemoteContainerName *string `json:"remoteContainerName,omitempty"`

	// The remote fabric name.
	RemoteFabricName *string `json:"remoteFabricName,omitempty"`
}

// GetEventProviderSpecificDetails implements the EventProviderSpecificDetailsClassification interface for type HyperVReplica2012EventDetails.
func (h *HyperVReplica2012EventDetails) GetEventProviderSpecificDetails() *EventProviderSpecificDetails {
	return &EventProviderSpecificDetails{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplica2012R2EventDetails - Model class for event details of a HyperVReplica blue E2E event.
type HyperVReplica2012R2EventDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// The container friendly name.
	ContainerName *string `json:"containerName,omitempty"`

	// The fabric friendly name.
	FabricName *string `json:"fabricName,omitempty"`

	// The remote container name.
	RemoteContainerName *string `json:"remoteContainerName,omitempty"`

	// The remote fabric name.
	RemoteFabricName *string `json:"remoteFabricName,omitempty"`
}

// GetEventProviderSpecificDetails implements the EventProviderSpecificDetailsClassification interface for type HyperVReplica2012R2EventDetails.
func (h *HyperVReplica2012R2EventDetails) GetEventProviderSpecificDetails() *EventProviderSpecificDetails {
	return &EventProviderSpecificDetails{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaAzureApplyRecoveryPointInput - ApplyRecoveryPoint input specific to HyperVReplicaAzure provider.
type HyperVReplicaAzureApplyRecoveryPointInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The primary kek certificate pfx.
	PrimaryKekCertificatePfx *string `json:"primaryKekCertificatePfx,omitempty"`

	// The secondary kek certificate pfx.
	SecondaryKekCertificatePfx *string `json:"secondaryKekCertificatePfx,omitempty"`
}

// GetApplyRecoveryPointProviderSpecificInput implements the ApplyRecoveryPointProviderSpecificInputClassification interface
// for type HyperVReplicaAzureApplyRecoveryPointInput.
func (h *HyperVReplicaAzureApplyRecoveryPointInput) GetApplyRecoveryPointProviderSpecificInput() *ApplyRecoveryPointProviderSpecificInput {
	return &ApplyRecoveryPointProviderSpecificInput{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaAzureDiskInputDetails - Disk input details.
type HyperVReplicaAzureDiskInputDetails struct {
	// The DiskEncryptionSet ARM ID.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`

	// The DiskId.
	DiskID *string `json:"diskId,omitempty"`

	// The DiskType.
	DiskType *DiskAccountType `json:"diskType,omitempty"`

	// The LogStorageAccountId.
	LogStorageAccountID *string `json:"logStorageAccountId,omitempty"`
}

// HyperVReplicaAzureEnableProtectionInput - HyperVReplicaAzure specific enable protection input.
type HyperVReplicaAzureEnableProtectionInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The DiskEncryptionSet ARM Id.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`

	// The DiskType.
	DiskType *DiskAccountType `json:"diskType,omitempty"`

	// The list of VHD Ids of disks to be protected.
	DisksToInclude []*string `json:"disksToInclude,omitempty"`

	// The disks to include list for managed disks.
	DisksToIncludeForManagedDisks []*HyperVReplicaAzureDiskInputDetails `json:"disksToIncludeForManagedDisks,omitempty"`

	// The selected option to enable RDP\SSH on target vm after failover. String value of SrsDataContract.EnableRDPOnTargetOption
	// enum.
	EnableRdpOnTargetOption *string `json:"enableRdpOnTargetOption,omitempty"`

	// The Hyper-V host VM Id.
	HvHostVMID *string `json:"hvHostVmId,omitempty"`

	// License type.
	LicenseType *LicenseType `json:"licenseType,omitempty"`

	// The storage account to be used for logging during replication.
	LogStorageAccountID *string `json:"logStorageAccountId,omitempty"`

	// The OS type associated with VM.
	OSType *string `json:"osType,omitempty"`

	// The SQL Server license type.
	SQLServerLicenseType *SQLServerLicenseType `json:"sqlServerLicenseType,omitempty"`

	// The tags for the seed managed disks.
	SeedManagedDiskTags map[string]*string `json:"seedManagedDiskTags,omitempty"`

	// The target availability set ARM Id for resource manager deployment.
	TargetAvailabilitySetID *string `json:"targetAvailabilitySetId,omitempty"`

	// The target availability zone.
	TargetAvailabilityZone *string `json:"targetAvailabilityZone,omitempty"`

	// The selected target Azure network Id.
	TargetAzureNetworkID *string `json:"targetAzureNetworkId,omitempty"`

	// The selected target Azure subnet Id.
	TargetAzureSubnetID *string `json:"targetAzureSubnetId,omitempty"`

	// The Id of the target resource group (for classic deployment) in which the failover VM is to be created.
	TargetAzureV1ResourceGroupID *string `json:"targetAzureV1ResourceGroupId,omitempty"`

	// The Id of the target resource group (for resource manager deployment) in which the failover VM is to be created.
	TargetAzureV2ResourceGroupID *string `json:"targetAzureV2ResourceGroupId,omitempty"`

	// The target azure VM Name.
	TargetAzureVMName *string `json:"targetAzureVmName,omitempty"`

	// The tags for the target managed disks.
	TargetManagedDiskTags map[string]*string `json:"targetManagedDiskTags,omitempty"`

	// The tags for the target NICs.
	TargetNicTags map[string]*string `json:"targetNicTags,omitempty"`

	// The proximity placement group ARM Id.
	TargetProximityPlacementGroupID *string `json:"targetProximityPlacementGroupId,omitempty"`

	// The storage account Id.
	TargetStorageAccountID *string `json:"targetStorageAccountId,omitempty"`

	// The target VM size.
	TargetVMSize *string `json:"targetVmSize,omitempty"`

	// The target VM tags.
	TargetVMTags map[string]*string `json:"targetVmTags,omitempty"`

	// A value indicating whether managed disks should be used during failover.
	UseManagedDisks *string `json:"useManagedDisks,omitempty"`

	// A value indicating whether managed disks should be used during replication.
	UseManagedDisksForReplication *string `json:"useManagedDisksForReplication,omitempty"`

	// The VM Name.
	VMName *string `json:"vmName,omitempty"`

	// The OS disk VHD id associated with VM.
	VhdID *string `json:"vhdId,omitempty"`
}

// GetEnableProtectionProviderSpecificInput implements the EnableProtectionProviderSpecificInputClassification interface for
// type HyperVReplicaAzureEnableProtectionInput.
func (h *HyperVReplicaAzureEnableProtectionInput) GetEnableProtectionProviderSpecificInput() *EnableProtectionProviderSpecificInput {
	return &EnableProtectionProviderSpecificInput{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaAzureEventDetails - Model class for event details of a HyperVReplica E2A event.
type HyperVReplicaAzureEventDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// The container friendly name.
	ContainerName *string `json:"containerName,omitempty"`

	// The fabric friendly name.
	FabricName *string `json:"fabricName,omitempty"`

	// The remote container name.
	RemoteContainerName *string `json:"remoteContainerName,omitempty"`
}

// GetEventProviderSpecificDetails implements the EventProviderSpecificDetailsClassification interface for type HyperVReplicaAzureEventDetails.
func (h *HyperVReplicaAzureEventDetails) GetEventProviderSpecificDetails() *EventProviderSpecificDetails {
	return &EventProviderSpecificDetails{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaAzureFailbackProviderInput - HyperVReplicaAzureFailback specific planned failover input.
type HyperVReplicaAzureFailbackProviderInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// Data sync option.
	DataSyncOption *string `json:"dataSyncOption,omitempty"`

	// Provider Id for alternate location.
	ProviderIDForAlternateRecovery *string `json:"providerIdForAlternateRecovery,omitempty"`

	// ALR options to create alternate recovery.
	RecoveryVMCreationOption *string `json:"recoveryVmCreationOption,omitempty"`
}

// GetPlannedFailoverProviderSpecificFailoverInput implements the PlannedFailoverProviderSpecificFailoverInputClassification
// interface for type HyperVReplicaAzureFailbackProviderInput.
func (h *HyperVReplicaAzureFailbackProviderInput) GetPlannedFailoverProviderSpecificFailoverInput() *PlannedFailoverProviderSpecificFailoverInput {
	return &PlannedFailoverProviderSpecificFailoverInput{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaAzureManagedDiskDetails - Hyper-V Managed disk details.
type HyperVReplicaAzureManagedDiskDetails struct {
	// The disk encryption set ARM Id.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`

	// The disk Id.
	DiskID *string `json:"diskId,omitempty"`

	// The replica disk type.
	ReplicaDiskType *string `json:"replicaDiskType,omitempty"`

	// Seed managed disk Id.
	SeedManagedDiskID *string `json:"seedManagedDiskId,omitempty"`
}

// HyperVReplicaAzurePlannedFailoverProviderInput - HyperVReplicaAzure specific planned failover input.
type HyperVReplicaAzurePlannedFailoverProviderInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// Primary kek certificate pfx.
	PrimaryKekCertificatePfx *string `json:"primaryKekCertificatePfx,omitempty"`

	// The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should
	// be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`

	// Secondary kek certificate pfx.
	SecondaryKekCertificatePfx *string `json:"secondaryKekCertificatePfx,omitempty"`
}

// GetPlannedFailoverProviderSpecificFailoverInput implements the PlannedFailoverProviderSpecificFailoverInputClassification
// interface for type HyperVReplicaAzurePlannedFailoverProviderInput.
func (h *HyperVReplicaAzurePlannedFailoverProviderInput) GetPlannedFailoverProviderSpecificFailoverInput() *PlannedFailoverProviderSpecificFailoverInput {
	return &PlannedFailoverProviderSpecificFailoverInput{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaAzurePolicyDetails - Hyper-V Replica Azure specific protection profile details.
type HyperVReplicaAzurePolicyDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// The active storage account Id.
	ActiveStorageAccountID *string `json:"activeStorageAccountId,omitempty"`

	// The interval (in hours) at which Hyper-V Replica should create an application consistent snapshot within the VM.
	ApplicationConsistentSnapshotFrequencyInHours *int32 `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`

	// A value indicating whether encryption is enabled for virtual machines in this cloud.
	Encryption *string `json:"encryption,omitempty"`

	// The scheduled start time for the initial replication. If this parameter is Null, the initial replication starts immediately.
	OnlineReplicationStartTime *string `json:"onlineReplicationStartTime,omitempty"`

	// The duration (in hours) to which point the recovery history needs to be maintained.
	RecoveryPointHistoryDurationInHours *int32 `json:"recoveryPointHistoryDurationInHours,omitempty"`

	// The replication interval.
	ReplicationInterval *int32 `json:"replicationInterval,omitempty"`
}

// GetPolicyProviderSpecificDetails implements the PolicyProviderSpecificDetailsClassification interface for type HyperVReplicaAzurePolicyDetails.
func (h *HyperVReplicaAzurePolicyDetails) GetPolicyProviderSpecificDetails() *PolicyProviderSpecificDetails {
	return &PolicyProviderSpecificDetails{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaAzurePolicyInput - Hyper-V Replica Azure specific input for creating a protection profile.
type HyperVReplicaAzurePolicyInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The interval (in hours) at which Hyper-V Replica should create an application consistent snapshot within the VM.
	ApplicationConsistentSnapshotFrequencyInHours *int32 `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`

	// The scheduled start time for the initial replication. If this parameter is Null, the initial replication starts immediately.
	OnlineReplicationStartTime *string `json:"onlineReplicationStartTime,omitempty"`

	// The duration (in hours) to which point the recovery history needs to be maintained.
	RecoveryPointHistoryDuration *int32 `json:"recoveryPointHistoryDuration,omitempty"`

	// The replication interval.
	ReplicationInterval *int32 `json:"replicationInterval,omitempty"`

	// The list of storage accounts to which the VMs in the primary cloud can replicate to.
	StorageAccounts []*string `json:"storageAccounts,omitempty"`
}

// GetPolicyProviderSpecificInput implements the PolicyProviderSpecificInputClassification interface for type HyperVReplicaAzurePolicyInput.
func (h *HyperVReplicaAzurePolicyInput) GetPolicyProviderSpecificInput() *PolicyProviderSpecificInput {
	return &PolicyProviderSpecificInput{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaAzureReplicationDetails - Hyper V Replica Azure provider specific settings.
type HyperVReplicaAzureReplicationDetails struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string `json:"instanceType,omitempty"`

	// Azure VM Disk details.
	AzureVMDiskDetails []*AzureVMDiskDetails `json:"azureVmDiskDetails,omitempty"`

	// The selected option to enable RDP\SSH on target vm after failover. String value of SrsDataContract.EnableRDPOnTargetOption
	// enum.
	EnableRdpOnTargetOption *string `json:"enableRdpOnTargetOption,omitempty"`

	// The encryption info.
	Encryption *string `json:"encryption,omitempty"`

	// Initial replication details.
	InitialReplicationDetails *InitialReplicationDetails `json:"initialReplicationDetails,omitempty"`

	// The Last replication time.
	LastReplicatedTime *time.Time `json:"lastReplicatedTime,omitempty"`

	// The last RPO calculated time.
	LastRpoCalculatedTime *time.Time `json:"lastRpoCalculatedTime,omitempty"`

	// License Type of the VM to be used.
	LicenseType *string `json:"licenseType,omitempty"`

	// The operating system info.
	OSDetails *OSDetails `json:"oSDetails,omitempty"`

	// The list of protected managed disks.
	ProtectedManagedDisks []*HyperVReplicaAzureManagedDiskDetails `json:"protectedManagedDisks,omitempty"`

	// The recovery availability set Id.
	RecoveryAvailabilitySetID *string `json:"recoveryAvailabilitySetId,omitempty"`

	// The ARM id of the log storage account used for replication. This will be set to null if no log storage account was provided
	// during enable protection.
	RecoveryAzureLogStorageAccountID *string `json:"recoveryAzureLogStorageAccountId,omitempty"`

	// The target resource group Id.
	RecoveryAzureResourceGroupID *string `json:"recoveryAzureResourceGroupId,omitempty"`

	// The recovery Azure storage account.
	RecoveryAzureStorageAccount *string `json:"recoveryAzureStorageAccount,omitempty"`

	// Recovery Azure given name.
	RecoveryAzureVMName *string `json:"recoveryAzureVmName,omitempty"`

	// The Recovery Azure VM size.
	RecoveryAzureVMSize *string `json:"recoveryAzureVMSize,omitempty"`

	// Last RPO value.
	RpoInSeconds *int64 `json:"rpoInSeconds,omitempty"`

	// The SQL Server license type.
	SQLServerLicenseType *string `json:"sqlServerLicenseType,omitempty"`

	// The tags for the seed managed disks.
	SeedManagedDiskTags map[string]*string `json:"seedManagedDiskTags,omitempty"`

	// The selected recovery azure network Id.
	SelectedRecoveryAzureNetworkID *string `json:"selectedRecoveryAzureNetworkId,omitempty"`

	// The selected source nic Id which will be used as the primary nic during failover.
	SelectedSourceNicID *string `json:"selectedSourceNicId,omitempty"`

	// The CPU count of the VM on the primary side.
	SourceVMCPUCount *int32 `json:"sourceVmCpuCount,omitempty"`

	// The RAM size of the VM on the primary side.
	SourceVMRAMSizeInMB *int32 `json:"sourceVmRamSizeInMB,omitempty"`

	// The target availability zone.
	TargetAvailabilityZone *string `json:"targetAvailabilityZone,omitempty"`

	// The tags for the target managed disks.
	TargetManagedDiskTags map[string]*string `json:"targetManagedDiskTags,omitempty"`

	// The tags for the target NICs.
	TargetNicTags map[string]*string `json:"targetNicTags,omitempty"`

	// The target proximity placement group Id.
	TargetProximityPlacementGroupID *string `json:"targetProximityPlacementGroupId,omitempty"`

	// The target VM tags.
	TargetVMTags map[string]*string `json:"targetVmTags,omitempty"`

	// A value indicating whether managed disks should be used during failover.
	UseManagedDisks *string `json:"useManagedDisks,omitempty"`

	// The virtual machine Id.
	VMID *string `json:"vmId,omitempty"`

	// The PE Network details.
	VMNics []*VMNicDetails `json:"vmNics,omitempty"`

	// The protection state for the vm.
	VMProtectionState *string `json:"vmProtectionState,omitempty"`

	// The protection state description for the vm.
	VMProtectionStateDescription *string `json:"vmProtectionStateDescription,omitempty"`

	// READ-ONLY; The last recovery point received time.
	LastRecoveryPointReceived *time.Time `json:"lastRecoveryPointReceived,omitempty" azure:"ro"`
}

// GetReplicationProviderSpecificSettings implements the ReplicationProviderSpecificSettingsClassification interface for type
// HyperVReplicaAzureReplicationDetails.
func (h *HyperVReplicaAzureReplicationDetails) GetReplicationProviderSpecificSettings() *ReplicationProviderSpecificSettings {
	return &ReplicationProviderSpecificSettings{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaAzureReprotectInput - Azure specific reprotect input.
type HyperVReplicaAzureReprotectInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The Hyper-V host Vm Id.
	HvHostVMID *string `json:"hvHostVmId,omitempty"`

	// The storage account to be used for logging during replication.
	LogStorageAccountID *string `json:"logStorageAccountId,omitempty"`

	// The OS type associated with vm.
	OSType *string `json:"osType,omitempty"`

	// The storage account name.
	StorageAccountID *string `json:"storageAccountId,omitempty"`

	// The OS disk VHD id associated with vm.
	VHDID *string `json:"vHDId,omitempty"`

	// The Vm Name.
	VMName *string `json:"vmName,omitempty"`
}

// GetReverseReplicationProviderSpecificInput implements the ReverseReplicationProviderSpecificInputClassification interface
// for type HyperVReplicaAzureReprotectInput.
func (h *HyperVReplicaAzureReprotectInput) GetReverseReplicationProviderSpecificInput() *ReverseReplicationProviderSpecificInput {
	return &ReverseReplicationProviderSpecificInput{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaAzureTestFailoverInput - HvrA provider specific input for test failover.
type HyperVReplicaAzureTestFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// Primary kek certificate pfx.
	PrimaryKekCertificatePfx *string `json:"primaryKekCertificatePfx,omitempty"`

	// The recovery point id to be passed to test failover to a particular recovery point. In case of latest recovery point, null
	// should be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`

	// Secondary kek certificate pfx.
	SecondaryKekCertificatePfx *string `json:"secondaryKekCertificatePfx,omitempty"`
}

// GetTestFailoverProviderSpecificInput implements the TestFailoverProviderSpecificInputClassification interface for type
// HyperVReplicaAzureTestFailoverInput.
func (h *HyperVReplicaAzureTestFailoverInput) GetTestFailoverProviderSpecificInput() *TestFailoverProviderSpecificInput {
	return &TestFailoverProviderSpecificInput{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaAzureUnplannedFailoverInput - HvrA provider specific input for unplanned failover.
type HyperVReplicaAzureUnplannedFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// Primary kek certificate pfx.
	PrimaryKekCertificatePfx *string `json:"primaryKekCertificatePfx,omitempty"`

	// The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should
	// be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`

	// Secondary kek certificate pfx.
	SecondaryKekCertificatePfx *string `json:"secondaryKekCertificatePfx,omitempty"`
}

// GetUnplannedFailoverProviderSpecificInput implements the UnplannedFailoverProviderSpecificInputClassification interface
// for type HyperVReplicaAzureUnplannedFailoverInput.
func (h *HyperVReplicaAzureUnplannedFailoverInput) GetUnplannedFailoverProviderSpecificInput() *UnplannedFailoverProviderSpecificInput {
	return &UnplannedFailoverProviderSpecificInput{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaAzureUpdateReplicationProtectedItemInput - HyperV replica Azure input to update replication protected item.
type HyperVReplicaAzureUpdateReplicationProtectedItemInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The dictionary of disk resource Id to disk encryption set ARM Id.
	DiskIDToDiskEncryptionMap map[string]*string `json:"diskIdToDiskEncryptionMap,omitempty"`

	// The recovery Azure resource group Id for classic deployment.
	RecoveryAzureV1ResourceGroupID *string `json:"recoveryAzureV1ResourceGroupId,omitempty"`

	// The recovery Azure resource group Id for resource manager deployment.
	RecoveryAzureV2ResourceGroupID *string `json:"recoveryAzureV2ResourceGroupId,omitempty"`

	// The SQL Server license type.
	SQLServerLicenseType *SQLServerLicenseType `json:"sqlServerLicenseType,omitempty"`

	// The target availability zone.
	TargetAvailabilityZone *string `json:"targetAvailabilityZone,omitempty"`

	// The tags for the target managed disks.
	TargetManagedDiskTags map[string]*string `json:"targetManagedDiskTags,omitempty"`

	// The tags for the target NICs.
	TargetNicTags map[string]*string `json:"targetNicTags,omitempty"`

	// The target proximity placement group Id.
	TargetProximityPlacementGroupID *string `json:"targetProximityPlacementGroupId,omitempty"`

	// The target VM tags.
	TargetVMTags map[string]*string `json:"targetVmTags,omitempty"`

	// A value indicating whether managed disks should be used during failover.
	UseManagedDisks *string `json:"useManagedDisks,omitempty"`

	// The list of disk update properties.
	VMDisks []*UpdateDiskInput `json:"vmDisks,omitempty"`
}

// GetUpdateReplicationProtectedItemProviderInput implements the UpdateReplicationProtectedItemProviderInputClassification
// interface for type HyperVReplicaAzureUpdateReplicationProtectedItemInput.
func (h *HyperVReplicaAzureUpdateReplicationProtectedItemInput) GetUpdateReplicationProtectedItemProviderInput() *UpdateReplicationProtectedItemProviderInput {
	return &UpdateReplicationProtectedItemProviderInput{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaBaseEventDetails - Abstract model class for event details of a HyperVReplica E2E event.
type HyperVReplicaBaseEventDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// The container friendly name.
	ContainerName *string `json:"containerName,omitempty"`

	// The fabric friendly name.
	FabricName *string `json:"fabricName,omitempty"`

	// The remote container name.
	RemoteContainerName *string `json:"remoteContainerName,omitempty"`

	// The remote fabric name.
	RemoteFabricName *string `json:"remoteFabricName,omitempty"`
}

// GetEventProviderSpecificDetails implements the EventProviderSpecificDetailsClassification interface for type HyperVReplicaBaseEventDetails.
func (h *HyperVReplicaBaseEventDetails) GetEventProviderSpecificDetails() *EventProviderSpecificDetails {
	return &EventProviderSpecificDetails{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaBasePolicyDetails - Base class for HyperVReplica policy details.
type HyperVReplicaBasePolicyDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// A value indicating the authentication type.
	AllowedAuthenticationType *int32 `json:"allowedAuthenticationType,omitempty"`

	// A value indicating the application consistent frequency.
	ApplicationConsistentSnapshotFrequencyInHours *int32 `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`

	// A value indicating whether compression has to be enabled.
	Compression *string `json:"compression,omitempty"`

	// A value indicating whether IR is online.
	InitialReplicationMethod *string `json:"initialReplicationMethod,omitempty"`

	// A value indicating the offline IR export path.
	OfflineReplicationExportPath *string `json:"offlineReplicationExportPath,omitempty"`

	// A value indicating the offline IR import path.
	OfflineReplicationImportPath *string `json:"offlineReplicationImportPath,omitempty"`

	// A value indicating the online IR start time.
	OnlineReplicationStartTime *string `json:"onlineReplicationStartTime,omitempty"`

	// A value indicating the number of recovery points.
	RecoveryPoints *int32 `json:"recoveryPoints,omitempty"`

	// A value indicating whether the VM has to be auto deleted. Supported Values: String.Empty, None, OnRecoveryCloud.
	ReplicaDeletionOption *string `json:"replicaDeletionOption,omitempty"`

	// A value indicating the recovery HTTPS port.
	ReplicationPort *int32 `json:"replicationPort,omitempty"`
}

// GetPolicyProviderSpecificDetails implements the PolicyProviderSpecificDetailsClassification interface for type HyperVReplicaBasePolicyDetails.
func (h *HyperVReplicaBasePolicyDetails) GetPolicyProviderSpecificDetails() *PolicyProviderSpecificDetails {
	return &PolicyProviderSpecificDetails{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaBaseReplicationDetails - Hyper V replica provider specific settings base class.
type HyperVReplicaBaseReplicationDetails struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string `json:"instanceType,omitempty"`

	// Initial replication details.
	InitialReplicationDetails *InitialReplicationDetails `json:"initialReplicationDetails,omitempty"`

	// The Last replication time.
	LastReplicatedTime *time.Time `json:"lastReplicatedTime,omitempty"`

	// VM disk details.
	VMDiskDetails []*DiskDetails `json:"vMDiskDetails,omitempty"`

	// The virtual machine Id.
	VMID *string `json:"vmId,omitempty"`

	// The PE Network details.
	VMNics []*VMNicDetails `json:"vmNics,omitempty"`

	// The protection state for the vm.
	VMProtectionState *string `json:"vmProtectionState,omitempty"`

	// The protection state description for the vm.
	VMProtectionStateDescription *string `json:"vmProtectionStateDescription,omitempty"`
}

// GetReplicationProviderSpecificSettings implements the ReplicationProviderSpecificSettingsClassification interface for type
// HyperVReplicaBaseReplicationDetails.
func (h *HyperVReplicaBaseReplicationDetails) GetReplicationProviderSpecificSettings() *ReplicationProviderSpecificSettings {
	return &ReplicationProviderSpecificSettings{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaBluePolicyDetails - Hyper-V Replica Blue specific protection profile details.
type HyperVReplicaBluePolicyDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// A value indicating the authentication type.
	AllowedAuthenticationType *int32 `json:"allowedAuthenticationType,omitempty"`

	// A value indicating the application consistent frequency.
	ApplicationConsistentSnapshotFrequencyInHours *int32 `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`

	// A value indicating whether compression has to be enabled.
	Compression *string `json:"compression,omitempty"`

	// A value indicating whether IR is online.
	InitialReplicationMethod *string `json:"initialReplicationMethod,omitempty"`

	// A value indicating the offline IR export path.
	OfflineReplicationExportPath *string `json:"offlineReplicationExportPath,omitempty"`

	// A value indicating the offline IR import path.
	OfflineReplicationImportPath *string `json:"offlineReplicationImportPath,omitempty"`

	// A value indicating the online IR start time.
	OnlineReplicationStartTime *string `json:"onlineReplicationStartTime,omitempty"`

	// A value indicating the number of recovery points.
	RecoveryPoints *int32 `json:"recoveryPoints,omitempty"`

	// A value indicating whether the VM has to be auto deleted. Supported Values: String.Empty, None, OnRecoveryCloud
	ReplicaDeletionOption *string `json:"replicaDeletionOption,omitempty"`

	// A value indicating the replication interval.
	ReplicationFrequencyInSeconds *int32 `json:"replicationFrequencyInSeconds,omitempty"`

	// A value indicating the recovery HTTPS port.
	ReplicationPort *int32 `json:"replicationPort,omitempty"`
}

// GetPolicyProviderSpecificDetails implements the PolicyProviderSpecificDetailsClassification interface for type HyperVReplicaBluePolicyDetails.
func (h *HyperVReplicaBluePolicyDetails) GetPolicyProviderSpecificDetails() *PolicyProviderSpecificDetails {
	return &PolicyProviderSpecificDetails{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaBluePolicyInput - HyperV Replica Blue policy input.
type HyperVReplicaBluePolicyInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// A value indicating the authentication type.
	AllowedAuthenticationType *int32 `json:"allowedAuthenticationType,omitempty"`

	// A value indicating the application consistent frequency.
	ApplicationConsistentSnapshotFrequencyInHours *int32 `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`

	// A value indicating whether compression has to be enabled.
	Compression *string `json:"compression,omitempty"`

	// A value indicating whether IR is online.
	InitialReplicationMethod *string `json:"initialReplicationMethod,omitempty"`

	// A value indicating the offline IR export path.
	OfflineReplicationExportPath *string `json:"offlineReplicationExportPath,omitempty"`

	// A value indicating the offline IR import path.
	OfflineReplicationImportPath *string `json:"offlineReplicationImportPath,omitempty"`

	// A value indicating the online IR start time.
	OnlineReplicationStartTime *string `json:"onlineReplicationStartTime,omitempty"`

	// A value indicating the number of recovery points.
	RecoveryPoints *int32 `json:"recoveryPoints,omitempty"`

	// A value indicating whether the VM has to be auto deleted.
	ReplicaDeletion *string `json:"replicaDeletion,omitempty"`

	// A value indicating the replication interval.
	ReplicationFrequencyInSeconds *int32 `json:"replicationFrequencyInSeconds,omitempty"`

	// A value indicating the recovery HTTPS port.
	ReplicationPort *int32 `json:"replicationPort,omitempty"`
}

// GetHyperVReplicaPolicyInput implements the HyperVReplicaPolicyInputClassification interface for type HyperVReplicaBluePolicyInput.
func (h *HyperVReplicaBluePolicyInput) GetHyperVReplicaPolicyInput() *HyperVReplicaPolicyInput {
	return &HyperVReplicaPolicyInput{
		RecoveryPoints: h.RecoveryPoints,
		ApplicationConsistentSnapshotFrequencyInHours: h.ApplicationConsistentSnapshotFrequencyInHours,
		Compression:                  h.Compression,
		InitialReplicationMethod:     h.InitialReplicationMethod,
		OnlineReplicationStartTime:   h.OnlineReplicationStartTime,
		OfflineReplicationImportPath: h.OfflineReplicationImportPath,
		OfflineReplicationExportPath: h.OfflineReplicationExportPath,
		ReplicationPort:              h.ReplicationPort,
		AllowedAuthenticationType:    h.AllowedAuthenticationType,
		ReplicaDeletion:              h.ReplicaDeletion,
		InstanceType:                 h.InstanceType,
	}
}

// GetPolicyProviderSpecificInput implements the PolicyProviderSpecificInputClassification interface for type HyperVReplicaBluePolicyInput.
func (h *HyperVReplicaBluePolicyInput) GetPolicyProviderSpecificInput() *PolicyProviderSpecificInput {
	return &PolicyProviderSpecificInput{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaBlueReplicationDetails - HyperV replica 2012 R2 (Blue) replication details.
type HyperVReplicaBlueReplicationDetails struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string `json:"instanceType,omitempty"`

	// Initial replication details.
	InitialReplicationDetails *InitialReplicationDetails `json:"initialReplicationDetails,omitempty"`

	// The Last replication time.
	LastReplicatedTime *time.Time `json:"lastReplicatedTime,omitempty"`

	// VM disk details.
	VMDiskDetails []*DiskDetails `json:"vMDiskDetails,omitempty"`

	// The virtual machine Id.
	VMID *string `json:"vmId,omitempty"`

	// The PE Network details.
	VMNics []*VMNicDetails `json:"vmNics,omitempty"`

	// The protection state for the vm.
	VMProtectionState *string `json:"vmProtectionState,omitempty"`

	// The protection state description for the vm.
	VMProtectionStateDescription *string `json:"vmProtectionStateDescription,omitempty"`
}

// GetReplicationProviderSpecificSettings implements the ReplicationProviderSpecificSettingsClassification interface for type
// HyperVReplicaBlueReplicationDetails.
func (h *HyperVReplicaBlueReplicationDetails) GetReplicationProviderSpecificSettings() *ReplicationProviderSpecificSettings {
	return &ReplicationProviderSpecificSettings{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaPolicyDetails - Hyper-V Replica Blue specific protection profile details.
type HyperVReplicaPolicyDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// A value indicating the authentication type.
	AllowedAuthenticationType *int32 `json:"allowedAuthenticationType,omitempty"`

	// A value indicating the application consistent frequency.
	ApplicationConsistentSnapshotFrequencyInHours *int32 `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`

	// A value indicating whether compression has to be enabled.
	Compression *string `json:"compression,omitempty"`

	// A value indicating whether IR is online.
	InitialReplicationMethod *string `json:"initialReplicationMethod,omitempty"`

	// A value indicating the offline IR export path.
	OfflineReplicationExportPath *string `json:"offlineReplicationExportPath,omitempty"`

	// A value indicating the offline IR import path.
	OfflineReplicationImportPath *string `json:"offlineReplicationImportPath,omitempty"`

	// A value indicating the online IR start time.
	OnlineReplicationStartTime *string `json:"onlineReplicationStartTime,omitempty"`

	// A value indicating the number of recovery points.
	RecoveryPoints *int32 `json:"recoveryPoints,omitempty"`

	// A value indicating whether the VM has to be auto deleted. Supported Values: String.Empty, None, OnRecoveryCloud
	ReplicaDeletionOption *string `json:"replicaDeletionOption,omitempty"`

	// A value indicating the recovery HTTPS port.
	ReplicationPort *int32 `json:"replicationPort,omitempty"`
}

// GetPolicyProviderSpecificDetails implements the PolicyProviderSpecificDetailsClassification interface for type HyperVReplicaPolicyDetails.
func (h *HyperVReplicaPolicyDetails) GetPolicyProviderSpecificDetails() *PolicyProviderSpecificDetails {
	return &PolicyProviderSpecificDetails{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaPolicyInputClassification provides polymorphic access to related types.
// Call the interface's GetHyperVReplicaPolicyInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *HyperVReplicaBluePolicyInput, *HyperVReplicaPolicyInput
type HyperVReplicaPolicyInputClassification interface {
	PolicyProviderSpecificInputClassification
	// GetHyperVReplicaPolicyInput returns the HyperVReplicaPolicyInput content of the underlying type.
	GetHyperVReplicaPolicyInput() *HyperVReplicaPolicyInput
}

// HyperVReplicaPolicyInput - Hyper-V Replica specific policy Input.
type HyperVReplicaPolicyInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// A value indicating the authentication type.
	AllowedAuthenticationType *int32 `json:"allowedAuthenticationType,omitempty"`

	// A value indicating the application consistent frequency.
	ApplicationConsistentSnapshotFrequencyInHours *int32 `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`

	// A value indicating whether compression has to be enabled.
	Compression *string `json:"compression,omitempty"`

	// A value indicating whether IR is online.
	InitialReplicationMethod *string `json:"initialReplicationMethod,omitempty"`

	// A value indicating the offline IR export path.
	OfflineReplicationExportPath *string `json:"offlineReplicationExportPath,omitempty"`

	// A value indicating the offline IR import path.
	OfflineReplicationImportPath *string `json:"offlineReplicationImportPath,omitempty"`

	// A value indicating the online IR start time.
	OnlineReplicationStartTime *string `json:"onlineReplicationStartTime,omitempty"`

	// A value indicating the number of recovery points.
	RecoveryPoints *int32 `json:"recoveryPoints,omitempty"`

	// A value indicating whether the VM has to be auto deleted.
	ReplicaDeletion *string `json:"replicaDeletion,omitempty"`

	// A value indicating the recovery HTTPS port.
	ReplicationPort *int32 `json:"replicationPort,omitempty"`
}

// GetHyperVReplicaPolicyInput implements the HyperVReplicaPolicyInputClassification interface for type HyperVReplicaPolicyInput.
func (h *HyperVReplicaPolicyInput) GetHyperVReplicaPolicyInput() *HyperVReplicaPolicyInput { return h }

// GetPolicyProviderSpecificInput implements the PolicyProviderSpecificInputClassification interface for type HyperVReplicaPolicyInput.
func (h *HyperVReplicaPolicyInput) GetPolicyProviderSpecificInput() *PolicyProviderSpecificInput {
	return &PolicyProviderSpecificInput{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaReplicationDetails - HyperV replica 2012 replication details.
type HyperVReplicaReplicationDetails struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string `json:"instanceType,omitempty"`

	// Initial replication details.
	InitialReplicationDetails *InitialReplicationDetails `json:"initialReplicationDetails,omitempty"`

	// The Last replication time.
	LastReplicatedTime *time.Time `json:"lastReplicatedTime,omitempty"`

	// VM disk details.
	VMDiskDetails []*DiskDetails `json:"vMDiskDetails,omitempty"`

	// The virtual machine Id.
	VMID *string `json:"vmId,omitempty"`

	// The PE Network details.
	VMNics []*VMNicDetails `json:"vmNics,omitempty"`

	// The protection state for the vm.
	VMProtectionState *string `json:"vmProtectionState,omitempty"`

	// The protection state description for the vm.
	VMProtectionStateDescription *string `json:"vmProtectionStateDescription,omitempty"`
}

// GetReplicationProviderSpecificSettings implements the ReplicationProviderSpecificSettingsClassification interface for type
// HyperVReplicaReplicationDetails.
func (h *HyperVReplicaReplicationDetails) GetReplicationProviderSpecificSettings() *ReplicationProviderSpecificSettings {
	return &ReplicationProviderSpecificSettings{
		InstanceType: h.InstanceType,
	}
}

// HyperVSiteDetails - HyperVSite fabric specific details.
type HyperVSiteDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// The list of Hyper-V hosts associated with the fabric.
	HyperVHosts []*HyperVHostDetails `json:"hyperVHosts,omitempty"`
}

// GetFabricSpecificDetails implements the FabricSpecificDetailsClassification interface for type HyperVSiteDetails.
func (h *HyperVSiteDetails) GetFabricSpecificDetails() *FabricSpecificDetails {
	return &FabricSpecificDetails{
		InstanceType: h.InstanceType,
	}
}

// HyperVVirtualMachineDetailsClassification provides polymorphic access to related types.
// Call the interface's GetHyperVVirtualMachineDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *HyperVVirtualMachineDetails, *VmmVirtualMachineDetails
type HyperVVirtualMachineDetailsClassification interface {
	ConfigurationSettingsClassification
	// GetHyperVVirtualMachineDetails returns the HyperVVirtualMachineDetails content of the underlying type.
	GetHyperVVirtualMachineDetails() *HyperVVirtualMachineDetails
}

// HyperVVirtualMachineDetails - Single Host fabric provider specific VM settings.
type HyperVVirtualMachineDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// The Last successful failover time.
	DiskDetails []*DiskDetails `json:"diskDetails,omitempty"`

	// The id of the object in fabric.
	Generation *string `json:"generation,omitempty"`

	// A value indicating whether the VM has a fibre channel adapter attached. String value of SrsDataContract.PresenceStatus
	// enum.
	HasFibreChannelAdapter *PresenceStatus `json:"hasFibreChannelAdapter,omitempty"`

	// A value indicating whether the VM has a physical disk attached. String value of SrsDataContract.PresenceStatus enum.
	HasPhysicalDisk *PresenceStatus `json:"hasPhysicalDisk,omitempty"`

	// A value indicating whether the VM has a shared VHD attached. String value of SrsDataContract.PresenceStatus enum.
	HasSharedVhd *PresenceStatus `json:"hasSharedVhd,omitempty"`

	// The Id of the hyper-v host in fabric.
	HyperVHostID *string `json:"hyperVHostId,omitempty"`

	// The Last replication time.
	OSDetails *OSDetails `json:"osDetails,omitempty"`

	// The source id of the object.
	SourceItemID *string `json:"sourceItemId,omitempty"`
}

// GetConfigurationSettings implements the ConfigurationSettingsClassification interface for type HyperVVirtualMachineDetails.
func (h *HyperVVirtualMachineDetails) GetConfigurationSettings() *ConfigurationSettings {
	return &ConfigurationSettings{
		InstanceType: h.InstanceType,
	}
}

// GetHyperVVirtualMachineDetails implements the HyperVVirtualMachineDetailsClassification interface for type HyperVVirtualMachineDetails.
func (h *HyperVVirtualMachineDetails) GetHyperVVirtualMachineDetails() *HyperVVirtualMachineDetails {
	return h
}

type IPConfigDetails struct {
	IPAddressType                   *string   `json:"ipAddressType,omitempty"`
	IsPrimary                       *bool     `json:"isPrimary,omitempty"`
	IsSeletedForFailover            *bool     `json:"isSeletedForFailover,omitempty"`
	Name                            *string   `json:"name,omitempty"`
	RecoveryIPAddressType           *string   `json:"recoveryIPAddressType,omitempty"`
	RecoveryLBBackendAddressPoolIDs []*string `json:"recoveryLBBackendAddressPoolIds,omitempty"`
	RecoveryPublicIPAddressID       *string   `json:"recoveryPublicIPAddressId,omitempty"`
	RecoveryStaticIPAddress         *string   `json:"recoveryStaticIPAddress,omitempty"`
	RecoverySubnetName              *string   `json:"recoverySubnetName,omitempty"`
	StaticIPAddress                 *string   `json:"staticIPAddress,omitempty"`
	SubnetName                      *string   `json:"subnetName,omitempty"`
	TfoLBBackendAddressPoolIDs      []*string `json:"tfoLBBackendAddressPoolIds,omitempty"`
	TfoPublicIPAddressID            *string   `json:"tfoPublicIPAddressId,omitempty"`
	TfoStaticIPAddress              *string   `json:"tfoStaticIPAddress,omitempty"`
	TfoSubnetName                   *string   `json:"tfoSubnetName,omitempty"`
}

type IPConfigInputDetails struct {
	IPConfigName                    *string   `json:"ipConfigName,omitempty"`
	IsPrimary                       *bool     `json:"isPrimary,omitempty"`
	IsSeletedForFailover            *bool     `json:"isSeletedForFailover,omitempty"`
	RecoveryLBBackendAddressPoolIDs []*string `json:"recoveryLBBackendAddressPoolIds,omitempty"`
	RecoveryPublicIPAddressID       *string   `json:"recoveryPublicIPAddressId,omitempty"`
	RecoveryStaticIPAddress         *string   `json:"recoveryStaticIPAddress,omitempty"`
	RecoverySubnetName              *string   `json:"recoverySubnetName,omitempty"`
	TfoLBBackendAddressPoolIDs      []*string `json:"tfoLBBackendAddressPoolIds,omitempty"`
	TfoPublicIPAddressID            *string   `json:"tfoPublicIPAddressId,omitempty"`
	TfoStaticIPAddress              *string   `json:"tfoStaticIPAddress,omitempty"`
	TfoSubnetName                   *string   `json:"tfoSubnetName,omitempty"`
}

// IdentityProviderDetails - Identity provider details.
type IdentityProviderDetails struct {
	// The base authority for Azure Active Directory authentication.
	AADAuthority *string `json:"aadAuthority,omitempty"`

	// The application/client Id for the service principal with which the on-premise management/data plane components would communicate
	// with our Azure services.
	ApplicationID *string `json:"applicationId,omitempty"`

	// The intended Audience of the service principal with which the on-premise management/data plane components would communicate
	// with our Azure services.
	Audience *string `json:"audience,omitempty"`

	// The object Id of the service principal with which the on-premise management/data plane components would communicate with
	// our Azure services.
	ObjectID *string `json:"objectId,omitempty"`

	// The tenant Id for the service principal with which the on-premise management/data plane components would communicate with
	// our Azure services.
	TenantID *string `json:"tenantId,omitempty"`
}

// IdentityProviderInput - Identity provider input.
type IdentityProviderInput struct {
	// REQUIRED; The base authority for Azure Active Directory authentication.
	AADAuthority *string `json:"aadAuthority,omitempty"`

	// REQUIRED; The application/client Id for the service principal with which the on-premise management/data plane components
	// would communicate with our Azure services.
	ApplicationID *string `json:"applicationId,omitempty"`

	// REQUIRED; The intended Audience of the service principal with which the on-premise management/data plane components would
	// communicate with our Azure services.
	Audience *string `json:"audience,omitempty"`

	// REQUIRED; The object Id of the service principal with which the on-premise management/data plane components would communicate
	// with our Azure services.
	ObjectID *string `json:"objectId,omitempty"`

	// REQUIRED; The tenant Id for the service principal with which the on-premise management/data plane components would communicate
	// with our Azure services.
	TenantID *string `json:"tenantId,omitempty"`
}

// InMageAgentDetails - The details of the InMage agent.
type InMageAgentDetails struct {
	// Agent expiry date.
	AgentExpiryDate *time.Time `json:"agentExpiryDate,omitempty"`

	// A value indicating whether installed agent needs to be updated.
	AgentUpdateStatus *string `json:"agentUpdateStatus,omitempty"`

	// The agent version.
	AgentVersion *string `json:"agentVersion,omitempty"`

	// A value indicating whether reboot is required after update is applied.
	PostUpdateRebootStatus *string `json:"postUpdateRebootStatus,omitempty"`
}

// InMageAzureV2ApplyRecoveryPointInput - ApplyRecoveryPoint input specific to InMageAzureV2 provider.
type InMageAzureV2ApplyRecoveryPointInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetApplyRecoveryPointProviderSpecificInput implements the ApplyRecoveryPointProviderSpecificInputClassification interface
// for type InMageAzureV2ApplyRecoveryPointInput.
func (i *InMageAzureV2ApplyRecoveryPointInput) GetApplyRecoveryPointProviderSpecificInput() *ApplyRecoveryPointProviderSpecificInput {
	return &ApplyRecoveryPointProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageAzureV2DiskInputDetails - Disk input details.
type InMageAzureV2DiskInputDetails struct {
	// The DiskEncryptionSet ARM ID.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`

	// The DiskId.
	DiskID *string `json:"diskId,omitempty"`

	// The DiskType.
	DiskType *DiskAccountType `json:"diskType,omitempty"`

	// The LogStorageAccountId.
	LogStorageAccountID *string `json:"logStorageAccountId,omitempty"`
}

// InMageAzureV2EnableProtectionInput - VMware Azure specific enable protection input.
type InMageAzureV2EnableProtectionInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The DiskEncryptionSet ARM Id.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`

	// The DiskType.
	DiskType *DiskAccountType `json:"diskType,omitempty"`

	// The disks to include list.
	DisksToInclude []*InMageAzureV2DiskInputDetails `json:"disksToInclude,omitempty"`

	// The selected option to enable RDP\SSH on target VM after failover. String value of SrsDataContract.EnableRDPOnTargetOption
	// enum.
	EnableRdpOnTargetOption *string `json:"enableRdpOnTargetOption,omitempty"`

	// License type.
	LicenseType *LicenseType `json:"licenseType,omitempty"`

	// The storage account to be used for logging during replication.
	LogStorageAccountID *string `json:"logStorageAccountId,omitempty"`

	// The Master target Id.
	MasterTargetID *string `json:"masterTargetId,omitempty"`

	// The multi VM group Id.
	MultiVMGroupID *string `json:"multiVmGroupId,omitempty"`

	// The multi VM group name.
	MultiVMGroupName *string `json:"multiVmGroupName,omitempty"`

	// The Process Server Id.
	ProcessServerID *string `json:"processServerId,omitempty"`

	// The CS account Id.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`

	// The SQL Server license type.
	SQLServerLicenseType *SQLServerLicenseType `json:"sqlServerLicenseType,omitempty"`

	// The tags for the seed managed disks.
	SeedManagedDiskTags map[string]*string `json:"seedManagedDiskTags,omitempty"`

	// The storage account Id.
	StorageAccountID *string `json:"storageAccountId,omitempty"`

	// The target availability set ARM Id for resource manager deployment.
	TargetAvailabilitySetID *string `json:"targetAvailabilitySetId,omitempty"`

	// The target availability zone.
	TargetAvailabilityZone *string `json:"targetAvailabilityZone,omitempty"`

	// The selected target Azure network Id.
	TargetAzureNetworkID *string `json:"targetAzureNetworkId,omitempty"`

	// The selected target Azure subnet Id.
	TargetAzureSubnetID *string `json:"targetAzureSubnetId,omitempty"`

	// The Id of the target resource group (for classic deployment) in which the failover VM is to be created.
	TargetAzureV1ResourceGroupID *string `json:"targetAzureV1ResourceGroupId,omitempty"`

	// The Id of the target resource group (for resource manager deployment) in which the failover VM is to be created.
	TargetAzureV2ResourceGroupID *string `json:"targetAzureV2ResourceGroupId,omitempty"`

	// The target azure VM Name.
	TargetAzureVMName *string `json:"targetAzureVmName,omitempty"`

	// The tags for the target managed disks.
	TargetManagedDiskTags map[string]*string `json:"targetManagedDiskTags,omitempty"`

	// The tags for the target NICs.
	TargetNicTags map[string]*string `json:"targetNicTags,omitempty"`

	// The proximity placement group ARM Id.
	TargetProximityPlacementGroupID *string `json:"targetProximityPlacementGroupId,omitempty"`

	// The target VM size.
	TargetVMSize *string `json:"targetVmSize,omitempty"`

	// The target VM tags.
	TargetVMTags map[string]*string `json:"targetVmTags,omitempty"`
}

// GetEnableProtectionProviderSpecificInput implements the EnableProtectionProviderSpecificInputClassification interface for
// type InMageAzureV2EnableProtectionInput.
func (i *InMageAzureV2EnableProtectionInput) GetEnableProtectionProviderSpecificInput() *EnableProtectionProviderSpecificInput {
	return &EnableProtectionProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageAzureV2EventDetails - Model class for event details of a VMwareAzureV2 event.
type InMageAzureV2EventDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// InMage Event Category.
	Category *string `json:"category,omitempty"`

	// InMage Event Component.
	Component *string `json:"component,omitempty"`

	// Corrective Action string for the event.
	CorrectiveAction *string `json:"correctiveAction,omitempty"`

	// InMage Event Details.
	Details *string `json:"details,omitempty"`

	// InMage Event type. Takes one of the values of InMageDataContract.InMageMonitoringEventType.
	EventType *string `json:"eventType,omitempty"`

	// VMware Site name.
	SiteName *string `json:"siteName,omitempty"`

	// InMage Event Summary.
	Summary *string `json:"summary,omitempty"`
}

// GetEventProviderSpecificDetails implements the EventProviderSpecificDetailsClassification interface for type InMageAzureV2EventDetails.
func (i *InMageAzureV2EventDetails) GetEventProviderSpecificDetails() *EventProviderSpecificDetails {
	return &EventProviderSpecificDetails{
		InstanceType: i.InstanceType,
	}
}

// InMageAzureV2ManagedDiskDetails - InMageAzureV2 Managed disk details.
type InMageAzureV2ManagedDiskDetails struct {
	// The DiskEncryptionSet ARM ID.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`

	// The disk id.
	DiskID *string `json:"diskId,omitempty"`

	// The replica disk type.
	ReplicaDiskType *string `json:"replicaDiskType,omitempty"`

	// Seed managed disk Id.
	SeedManagedDiskID *string `json:"seedManagedDiskId,omitempty"`

	// The target disk name.
	TargetDiskName *string `json:"targetDiskName,omitempty"`
}

// InMageAzureV2PolicyDetails - InMage Azure v2 specific protection profile details.
type InMageAzureV2PolicyDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// The app consistent snapshot frequency in minutes.
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`

	// The crash consistent snapshot frequency in minutes.
	CrashConsistentFrequencyInMinutes *int32 `json:"crashConsistentFrequencyInMinutes,omitempty"`

	// A value indicating whether multi-VM sync has to be enabled.
	MultiVMSyncStatus *string `json:"multiVmSyncStatus,omitempty"`

	// The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32 `json:"recoveryPointHistory,omitempty"`

	// The recovery point threshold in minutes.
	RecoveryPointThresholdInMinutes *int32 `json:"recoveryPointThresholdInMinutes,omitempty"`
}

// GetPolicyProviderSpecificDetails implements the PolicyProviderSpecificDetailsClassification interface for type InMageAzureV2PolicyDetails.
func (i *InMageAzureV2PolicyDetails) GetPolicyProviderSpecificDetails() *PolicyProviderSpecificDetails {
	return &PolicyProviderSpecificDetails{
		InstanceType: i.InstanceType,
	}
}

// InMageAzureV2PolicyInput - VMWare Azure specific policy Input.
type InMageAzureV2PolicyInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'.
	MultiVMSyncStatus *SetMultiVMSyncStatus `json:"multiVmSyncStatus,omitempty"`

	// The app consistent snapshot frequency (in minutes).
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`

	// The crash consistent snapshot frequency (in minutes).
	CrashConsistentFrequencyInMinutes *int32 `json:"crashConsistentFrequencyInMinutes,omitempty"`

	// The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32 `json:"recoveryPointHistory,omitempty"`

	// The recovery point threshold in minutes.
	RecoveryPointThresholdInMinutes *int32 `json:"recoveryPointThresholdInMinutes,omitempty"`
}

// GetPolicyProviderSpecificInput implements the PolicyProviderSpecificInputClassification interface for type InMageAzureV2PolicyInput.
func (i *InMageAzureV2PolicyInput) GetPolicyProviderSpecificInput() *PolicyProviderSpecificInput {
	return &PolicyProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageAzureV2ProtectedDiskDetails - InMageAzureV2 protected disk details.
type InMageAzureV2ProtectedDiskDetails struct {
	// The disk capacity in bytes.
	DiskCapacityInBytes *int64 `json:"diskCapacityInBytes,omitempty"`

	// The disk id.
	DiskID *string `json:"diskId,omitempty"`

	// The disk name.
	DiskName *string `json:"diskName,omitempty"`

	// A value indicating whether disk is resized.
	DiskResized *string `json:"diskResized,omitempty"`

	// The disk file system capacity in bytes.
	FileSystemCapacityInBytes *int64 `json:"fileSystemCapacityInBytes,omitempty"`

	// The health error code for the disk.
	HealthErrorCode *string `json:"healthErrorCode,omitempty"`

	// The last RPO calculated time.
	LastRpoCalculatedTime *time.Time `json:"lastRpoCalculatedTime,omitempty"`

	// The Progress Health.
	ProgressHealth *string `json:"progressHealth,omitempty"`

	// The Progress Status.
	ProgressStatus *string `json:"progressStatus,omitempty"`

	// The protection stage.
	ProtectionStage *string `json:"protectionStage,omitempty"`

	// The PS data transit in MB.
	PsDataInMegaBytes *float64 `json:"psDataInMegaBytes,omitempty"`

	// The resync duration in seconds.
	ResyncDurationInSeconds *int64 `json:"resyncDurationInSeconds,omitempty"`

	// The resync last 15 minutes transferred bytes.
	ResyncLast15MinutesTransferredBytes *int64 `json:"resyncLast15MinutesTransferredBytes,omitempty"`

	// The last data transfer time in UTC.
	ResyncLastDataTransferTimeUTC *time.Time `json:"resyncLastDataTransferTimeUTC,omitempty"`

	// The resync processed bytes.
	ResyncProcessedBytes *int64 `json:"resyncProcessedBytes,omitempty"`

	// The resync progress percentage.
	ResyncProgressPercentage *int32 `json:"resyncProgressPercentage,omitempty"`

	// A value indicating whether resync is required for this disk.
	ResyncRequired *string `json:"resyncRequired,omitempty"`

	// The resync start time.
	ResyncStartTime *time.Time `json:"resyncStartTime,omitempty"`

	// The resync total transferred bytes.
	ResyncTotalTransferredBytes *int64 `json:"resyncTotalTransferredBytes,omitempty"`

	// The RPO in seconds.
	RpoInSeconds *int64 `json:"rpoInSeconds,omitempty"`

	// The seconds to take for switch provider.
	SecondsToTakeSwitchProvider *int64 `json:"secondsToTakeSwitchProvider,omitempty"`

	// The source data transit in MB.
	SourceDataInMegaBytes *float64 `json:"sourceDataInMegaBytes,omitempty"`

	// The target data transit in MB.
	TargetDataInMegaBytes *float64 `json:"targetDataInMegaBytes,omitempty"`
}

// InMageAzureV2RecoveryPointDetails - InMage Azure V2 provider specific recovery point details.
type InMageAzureV2RecoveryPointDetails struct {
	// REQUIRED; Gets the provider type.
	InstanceType *string `json:"instanceType,omitempty"`

	// A value indicating whether the recovery point is multi VM consistent.
	IsMultiVMSyncPoint *string `json:"isMultiVmSyncPoint,omitempty"`
}

// GetProviderSpecificRecoveryPointDetails implements the ProviderSpecificRecoveryPointDetailsClassification interface for
// type InMageAzureV2RecoveryPointDetails.
func (i *InMageAzureV2RecoveryPointDetails) GetProviderSpecificRecoveryPointDetails() *ProviderSpecificRecoveryPointDetails {
	return &ProviderSpecificRecoveryPointDetails{
		InstanceType: i.InstanceType,
	}
}

// InMageAzureV2ReplicationDetails - InMageAzureV2 provider specific settings.
type InMageAzureV2ReplicationDetails struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string `json:"instanceType,omitempty"`

	// Agent expiry date.
	AgentExpiryDate *time.Time `json:"agentExpiryDate,omitempty"`

	// The agent version.
	AgentVersion *string `json:"agentVersion,omitempty"`

	// Azure VM Disk details.
	AzureVMDiskDetails []*AzureVMDiskDetails `json:"azureVMDiskDetails,omitempty"`

	// The target generation for this protected item.
	AzureVMGeneration *string `json:"azureVmGeneration,omitempty"`

	// The compressed data change rate in MB.
	CompressedDataRateInMB *float64 `json:"compressedDataRateInMB,omitempty"`

	// The datastores of the on-premise machine. Value can be list of strings that contain datastore names.
	Datastores []*string `json:"datastores,omitempty"`

	// A value indicating the discovery type of the machine. Value can be vCenter or physical.
	DiscoveryType *string `json:"discoveryType,omitempty"`

	// A value indicating whether any disk is resized for this VM.
	DiskResized *string `json:"diskResized,omitempty"`

	// The selected option to enable RDP\SSH on target vm after failover. String value of SrsDataContract.EnableRDPOnTargetOption
	// enum.
	EnableRdpOnTargetOption *string `json:"enableRdpOnTargetOption,omitempty"`

	// The firmware type of this protected item.
	FirmwareType *string `json:"firmwareType,omitempty"`

	// The source IP address.
	IPAddress *string `json:"ipAddress,omitempty"`

	// The infrastructure VM Id.
	InfrastructureVMID *string `json:"infrastructureVmId,omitempty"`

	// A value indicating whether additional IR stats are available or not.
	IsAdditionalStatsAvailable *bool `json:"isAdditionalStatsAvailable,omitempty"`

	// A value indicating whether installed agent needs to be updated.
	IsAgentUpdateRequired *string `json:"isAgentUpdateRequired,omitempty"`

	// A value indicating whether the source server requires a restart after update.
	IsRebootAfterUpdateRequired *string `json:"isRebootAfterUpdateRequired,omitempty"`

	// The last heartbeat received from the source server.
	LastHeartbeat *time.Time `json:"lastHeartbeat,omitempty"`

	// The last RPO calculated time.
	LastRpoCalculatedTime *time.Time `json:"lastRpoCalculatedTime,omitempty"`

	// The last update time received from on-prem components.
	LastUpdateReceivedTime *time.Time `json:"lastUpdateReceivedTime,omitempty"`

	// License Type of the VM to be used.
	LicenseType *string `json:"licenseType,omitempty"`

	// The master target Id.
	MasterTargetID *string `json:"masterTargetId,omitempty"`

	// The multi vm group Id.
	MultiVMGroupID *string `json:"multiVmGroupId,omitempty"`

	// The multi vm group name.
	MultiVMGroupName *string `json:"multiVmGroupName,omitempty"`

	// A value indicating whether multi vm sync is enabled or disabled.
	MultiVMSyncStatus *string `json:"multiVmSyncStatus,omitempty"`

	// The id of the disk containing the OS.
	OSDiskID *string `json:"osDiskId,omitempty"`

	// The type of the OS on the VM.
	OSType *string `json:"osType,omitempty"`

	// The OS Version of the protected item.
	OSVersion *string `json:"osVersion,omitempty"`

	// The process server Id.
	ProcessServerID *string `json:"processServerId,omitempty"`

	// The process server name.
	ProcessServerName *string `json:"processServerName,omitempty"`

	// The list of protected disks.
	ProtectedDisks []*InMageAzureV2ProtectedDiskDetails `json:"protectedDisks,omitempty"`

	// The list of protected managed disks.
	ProtectedManagedDisks []*InMageAzureV2ManagedDiskDetails `json:"protectedManagedDisks,omitempty"`

	// The protection stage.
	ProtectionStage *string `json:"protectionStage,omitempty"`

	// The recovery availability set Id.
	RecoveryAvailabilitySetID *string `json:"recoveryAvailabilitySetId,omitempty"`

	// The ARM id of the log storage account used for replication. This will be set to null if no log storage account was provided
	// during enable protection.
	RecoveryAzureLogStorageAccountID *string `json:"recoveryAzureLogStorageAccountId,omitempty"`

	// The target resource group Id.
	RecoveryAzureResourceGroupID *string `json:"recoveryAzureResourceGroupId,omitempty"`

	// The recovery Azure storage account.
	RecoveryAzureStorageAccount *string `json:"recoveryAzureStorageAccount,omitempty"`

	// Recovery Azure given name.
	RecoveryAzureVMName *string `json:"recoveryAzureVMName,omitempty"`

	// The Recovery Azure VM size.
	RecoveryAzureVMSize *string `json:"recoveryAzureVMSize,omitempty"`

	// The replica id of the protected item.
	ReplicaID *string `json:"replicaId,omitempty"`

	// The resync progress percentage.
	ResyncProgressPercentage *int32 `json:"resyncProgressPercentage,omitempty"`

	// The RPO in seconds.
	RpoInSeconds *int64 `json:"rpoInSeconds,omitempty"`

	// The SQL Server license type.
	SQLServerLicenseType *string `json:"sqlServerLicenseType,omitempty"`

	// The tags for the seed managed disks.
	SeedManagedDiskTags map[string]*string `json:"seedManagedDiskTags,omitempty"`

	// The selected recovery azure network Id.
	SelectedRecoveryAzureNetworkID *string `json:"selectedRecoveryAzureNetworkId,omitempty"`

	// The selected source nic Id which will be used as the primary nic during failover.
	SelectedSourceNicID *string `json:"selectedSourceNicId,omitempty"`

	// The test failover virtual network.
	SelectedTfoAzureNetworkID *string `json:"selectedTfoAzureNetworkId,omitempty"`

	// The CPU count of the VM on the primary side.
	SourceVMCPUCount *int32 `json:"sourceVmCpuCount,omitempty"`

	// The RAM size of the VM on the primary side.
	SourceVMRAMSizeInMB *int32 `json:"sourceVmRamSizeInMB,omitempty"`

	// The switch provider blocking error information.
	SwitchProviderBlockingErrorDetails []*InMageAzureV2SwitchProviderBlockingErrorDetails `json:"switchProviderBlockingErrorDetails,omitempty"`

	// The switch provider blocking error information.
	SwitchProviderDetails *InMageAzureV2SwitchProviderDetails `json:"switchProviderDetails,omitempty"`

	// The target availability zone.
	TargetAvailabilityZone *string `json:"targetAvailabilityZone,omitempty"`

	// The tags for the target managed disks.
	TargetManagedDiskTags map[string]*string `json:"targetManagedDiskTags,omitempty"`

	// The tags for the target NICs.
	TargetNicTags map[string]*string `json:"targetNicTags,omitempty"`

	// The target proximity placement group Id.
	TargetProximityPlacementGroupID *string `json:"targetProximityPlacementGroupId,omitempty"`

	// The ARM Id of the target Azure VM. This value will be null until the VM is failed over. Only after failure it will be populated
	// with the ARM Id of the Azure VM.
	TargetVMID *string `json:"targetVmId,omitempty"`

	// The target VM tags.
	TargetVMTags map[string]*string `json:"targetVmTags,omitempty"`

	// The total transferred data in bytes.
	TotalDataTransferred *int64 `json:"totalDataTransferred,omitempty"`

	// The progress health.
	TotalProgressHealth *string `json:"totalProgressHealth,omitempty"`

	// The uncompressed data change rate in MB.
	UncompressedDataRateInMB *float64 `json:"uncompressedDataRateInMB,omitempty"`

	// A value indicating whether managed disks should be used during failover.
	UseManagedDisks *string `json:"useManagedDisks,omitempty"`

	// The vCenter infrastructure Id.
	VCenterInfrastructureID *string `json:"vCenterInfrastructureId,omitempty"`

	// The virtual machine Id.
	VMID *string `json:"vmId,omitempty"`

	// The PE Network details.
	VMNics []*VMNicDetails `json:"vmNics,omitempty"`

	// The protection state for the vm.
	VMProtectionState *string `json:"vmProtectionState,omitempty"`

	// The protection state description for the vm.
	VMProtectionStateDescription *string `json:"vmProtectionStateDescription,omitempty"`

	// The validation errors of the on-premise machine Value can be list of validation errors.
	ValidationErrors []*HealthError `json:"validationErrors,omitempty"`

	// The OS disk VHD name.
	VhdName *string `json:"vhdName,omitempty"`

	// READ-ONLY; The last recovery point received time.
	LastRecoveryPointReceived *time.Time `json:"lastRecoveryPointReceived,omitempty" azure:"ro"`
}

// GetReplicationProviderSpecificSettings implements the ReplicationProviderSpecificSettingsClassification interface for type
// InMageAzureV2ReplicationDetails.
func (i *InMageAzureV2ReplicationDetails) GetReplicationProviderSpecificSettings() *ReplicationProviderSpecificSettings {
	return &ReplicationProviderSpecificSettings{
		InstanceType: i.InstanceType,
	}
}

// InMageAzureV2ReprotectInput - InMageAzureV2 specific provider input.
type InMageAzureV2ReprotectInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The disks to include list.
	DisksToInclude []*string `json:"disksToInclude,omitempty"`

	// The storage account to be used for logging during replication.
	LogStorageAccountID *string `json:"logStorageAccountId,omitempty"`

	// The Master target Id.
	MasterTargetID *string `json:"masterTargetId,omitempty"`

	// The Policy Id.
	PolicyID *string `json:"policyId,omitempty"`

	// The Process Server Id.
	ProcessServerID *string `json:"processServerId,omitempty"`

	// The CS account Id.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`

	// The storage account id.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
}

// GetReverseReplicationProviderSpecificInput implements the ReverseReplicationProviderSpecificInputClassification interface
// for type InMageAzureV2ReprotectInput.
func (i *InMageAzureV2ReprotectInput) GetReverseReplicationProviderSpecificInput() *ReverseReplicationProviderSpecificInput {
	return &ReverseReplicationProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageAzureV2SwitchProviderBlockingErrorDetails - InMageAzureV2 switch provider blocking error details.
type InMageAzureV2SwitchProviderBlockingErrorDetails struct {
	// READ-ONLY; The error code.
	ErrorCode *string `json:"errorCode,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	ErrorMessage *string `json:"errorMessage,omitempty" azure:"ro"`

	// READ-ONLY; The error message parameters.
	ErrorMessageParameters map[string]*string `json:"errorMessageParameters,omitempty" azure:"ro"`

	// READ-ONLY; The error tags.
	ErrorTags map[string]*string `json:"errorTags,omitempty" azure:"ro"`

	// READ-ONLY; The possible causes.
	PossibleCauses *string `json:"possibleCauses,omitempty" azure:"ro"`

	// READ-ONLY; The recommended action.
	RecommendedAction *string `json:"recommendedAction,omitempty" azure:"ro"`
}

// InMageAzureV2SwitchProviderDetails - InMageAzureV2 switch provider details.
type InMageAzureV2SwitchProviderDetails struct {
	// READ-ONLY; The target appliance Id.
	TargetApplianceID *string `json:"targetApplianceId,omitempty" azure:"ro"`

	// READ-ONLY; The target fabric Id.
	TargetFabricID *string `json:"targetFabricId,omitempty" azure:"ro"`

	// READ-ONLY; The target resource Id.
	TargetResourceID *string `json:"targetResourceId,omitempty" azure:"ro"`

	// READ-ONLY; The target vault Id.
	TargetVaultID *string `json:"targetVaultId,omitempty" azure:"ro"`
}

// InMageAzureV2SwitchProviderInput - Provider specific input for InMageAzureV2 switch provider.
type InMageAzureV2SwitchProviderInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; The target appliance Id.
	TargetApplianceID *string `json:"targetApplianceID,omitempty"`

	// REQUIRED; The target fabric Id.
	TargetFabricID *string `json:"targetFabricID,omitempty"`

	// REQUIRED; The target vault Id.
	TargetVaultID *string `json:"targetVaultID,omitempty"`
}

// GetSwitchProviderSpecificInput implements the SwitchProviderSpecificInputClassification interface for type InMageAzureV2SwitchProviderInput.
func (i *InMageAzureV2SwitchProviderInput) GetSwitchProviderSpecificInput() *SwitchProviderSpecificInput {
	return &SwitchProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageAzureV2TestFailoverInput - InMageAzureV2 provider specific input for test failover.
type InMageAzureV2TestFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The recovery point id to be passed to test failover to a particular recovery point. In case of latest recovery point, null
	// should be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
}

// GetTestFailoverProviderSpecificInput implements the TestFailoverProviderSpecificInputClassification interface for type
// InMageAzureV2TestFailoverInput.
func (i *InMageAzureV2TestFailoverInput) GetTestFailoverProviderSpecificInput() *TestFailoverProviderSpecificInput {
	return &TestFailoverProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageAzureV2UnplannedFailoverInput - InMageAzureV2 provider specific input for unplanned failover.
type InMageAzureV2UnplannedFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should
	// be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
}

// GetUnplannedFailoverProviderSpecificInput implements the UnplannedFailoverProviderSpecificInputClassification interface
// for type InMageAzureV2UnplannedFailoverInput.
func (i *InMageAzureV2UnplannedFailoverInput) GetUnplannedFailoverProviderSpecificInput() *UnplannedFailoverProviderSpecificInput {
	return &UnplannedFailoverProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageAzureV2UpdateReplicationProtectedItemInput - InMage Azure V2 input to update replication protected item.
type InMageAzureV2UpdateReplicationProtectedItemInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The recovery Azure resource group Id for classic deployment.
	RecoveryAzureV1ResourceGroupID *string `json:"recoveryAzureV1ResourceGroupId,omitempty"`

	// The recovery Azure resource group Id for resource manager deployment.
	RecoveryAzureV2ResourceGroupID *string `json:"recoveryAzureV2ResourceGroupId,omitempty"`

	// The SQL Server license type.
	SQLServerLicenseType *SQLServerLicenseType `json:"sqlServerLicenseType,omitempty"`

	// The target availability zone.
	TargetAvailabilityZone *string `json:"targetAvailabilityZone,omitempty"`

	// The tags for the target managed disks.
	TargetManagedDiskTags map[string]*string `json:"targetManagedDiskTags,omitempty"`

	// The tags for the target NICs.
	TargetNicTags map[string]*string `json:"targetNicTags,omitempty"`

	// The target proximity placement group Id.
	TargetProximityPlacementGroupID *string `json:"targetProximityPlacementGroupId,omitempty"`

	// The target VM tags.
	TargetVMTags map[string]*string `json:"targetVmTags,omitempty"`

	// A value indicating whether managed disks should be used during failover.
	UseManagedDisks *string `json:"useManagedDisks,omitempty"`

	// The list of disk update properties.
	VMDisks []*UpdateDiskInput `json:"vmDisks,omitempty"`
}

// GetUpdateReplicationProtectedItemProviderInput implements the UpdateReplicationProtectedItemProviderInputClassification
// interface for type InMageAzureV2UpdateReplicationProtectedItemInput.
func (i *InMageAzureV2UpdateReplicationProtectedItemInput) GetUpdateReplicationProtectedItemProviderInput() *UpdateReplicationProtectedItemProviderInput {
	return &UpdateReplicationProtectedItemProviderInput{
		InstanceType: i.InstanceType,
	}
}

// InMageBasePolicyDetails - Base class for the policies of providers using InMage replication.
type InMageBasePolicyDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// The app consistent snapshot frequency in minutes.
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`

	// A value indicating whether multi-VM sync has to be enabled.
	MultiVMSyncStatus *string `json:"multiVmSyncStatus,omitempty"`

	// The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32 `json:"recoveryPointHistory,omitempty"`

	// The recovery point threshold in minutes.
	RecoveryPointThresholdInMinutes *int32 `json:"recoveryPointThresholdInMinutes,omitempty"`
}

// GetPolicyProviderSpecificDetails implements the PolicyProviderSpecificDetailsClassification interface for type InMageBasePolicyDetails.
func (i *InMageBasePolicyDetails) GetPolicyProviderSpecificDetails() *PolicyProviderSpecificDetails {
	return &PolicyProviderSpecificDetails{
		InstanceType: i.InstanceType,
	}
}

// InMageDisableProtectionProviderSpecificInput - InMage disable protection provider specific input.
type InMageDisableProtectionProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// A value indicating whether the replica VM should be destroyed or retained. Values from Delete and Retain.
	ReplicaVMDeletionStatus *string `json:"replicaVmDeletionStatus,omitempty"`
}

// GetDisableProtectionProviderSpecificInput implements the DisableProtectionProviderSpecificInputClassification interface
// for type InMageDisableProtectionProviderSpecificInput.
func (i *InMageDisableProtectionProviderSpecificInput) GetDisableProtectionProviderSpecificInput() *DisableProtectionProviderSpecificInput {
	return &DisableProtectionProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageDiskDetails - VMware/Physical specific Disk Details.
type InMageDiskDetails struct {
	// Whether disk is dynamic disk or basic disk.
	DiskConfiguration *string `json:"diskConfiguration,omitempty"`

	// The disk Id.
	DiskID *string `json:"diskId,omitempty"`

	// The disk name.
	DiskName *string `json:"diskName,omitempty"`

	// The disk size in MB.
	DiskSizeInMB *string `json:"diskSizeInMB,omitempty"`

	// Whether disk is system disk or data disk.
	DiskType *string `json:"diskType,omitempty"`

	// Volumes of the disk.
	VolumeList []*DiskVolumeDetails `json:"volumeList,omitempty"`
}

// InMageDiskExclusionInput - DiskExclusionInput when doing enable protection of virtual machine in InMage provider.
type InMageDiskExclusionInput struct {
	// The guest disk signature based option for disk exclusion.
	DiskSignatureOptions []*InMageDiskSignatureExclusionOptions `json:"diskSignatureOptions,omitempty"`

	// The volume label based option for disk exclusion.
	VolumeOptions []*InMageVolumeExclusionOptions `json:"volumeOptions,omitempty"`
}

// InMageDiskSignatureExclusionOptions - Guest disk signature based disk exclusion option when doing enable protection of
// virtual machine in InMage provider.
type InMageDiskSignatureExclusionOptions struct {
	// The guest signature of disk to be excluded from replication.
	DiskSignature *string `json:"diskSignature,omitempty"`
}

// InMageEnableProtectionInput - VMware Azure specific enable protection input.
type InMageEnableProtectionInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; The Master Target Id.
	MasterTargetID *string `json:"masterTargetId,omitempty"`

	// REQUIRED; The multi VM group Id.
	MultiVMGroupID *string `json:"multiVmGroupId,omitempty"`

	// REQUIRED; The multi VM group name.
	MultiVMGroupName *string `json:"multiVmGroupName,omitempty"`

	// REQUIRED; The Process Server Id.
	ProcessServerID *string `json:"processServerId,omitempty"`

	// REQUIRED; The retention drive to use on the MT.
	RetentionDrive *string `json:"retentionDrive,omitempty"`

	// The target datastore name.
	DatastoreName *string `json:"datastoreName,omitempty"`

	// The enable disk exclusion input.
	DiskExclusionInput *InMageDiskExclusionInput `json:"diskExclusionInput,omitempty"`

	// The disks to include list.
	DisksToInclude []*string `json:"disksToInclude,omitempty"`

	// The CS account Id.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`

	// The VM Name.
	VMFriendlyName *string `json:"vmFriendlyName,omitempty"`
}

// GetEnableProtectionProviderSpecificInput implements the EnableProtectionProviderSpecificInputClassification interface for
// type InMageEnableProtectionInput.
func (i *InMageEnableProtectionInput) GetEnableProtectionProviderSpecificInput() *EnableProtectionProviderSpecificInput {
	return &EnableProtectionProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageFabricSwitchProviderBlockingErrorDetails - InMageFabric switch provider blocking error details.
type InMageFabricSwitchProviderBlockingErrorDetails struct {
	// READ-ONLY; The error code.
	ErrorCode *string `json:"errorCode,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	ErrorMessage *string `json:"errorMessage,omitempty" azure:"ro"`

	// READ-ONLY; The error message parameters.
	ErrorMessageParameters map[string]*string `json:"errorMessageParameters,omitempty" azure:"ro"`

	// READ-ONLY; The error tags.
	ErrorTags map[string]*string `json:"errorTags,omitempty" azure:"ro"`

	// READ-ONLY; The possible causes.
	PossibleCauses *string `json:"possibleCauses,omitempty" azure:"ro"`

	// READ-ONLY; The recommended action.
	RecommendedAction *string `json:"recommendedAction,omitempty" azure:"ro"`
}

// InMagePolicyDetails - InMage specific protection profile details.
type InMagePolicyDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// The app consistent snapshot frequency in minutes.
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`

	// A value indicating whether multi-VM sync has to be enabled.
	MultiVMSyncStatus *string `json:"multiVmSyncStatus,omitempty"`

	// The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32 `json:"recoveryPointHistory,omitempty"`

	// The recovery point threshold in minutes.
	RecoveryPointThresholdInMinutes *int32 `json:"recoveryPointThresholdInMinutes,omitempty"`
}

// GetPolicyProviderSpecificDetails implements the PolicyProviderSpecificDetailsClassification interface for type InMagePolicyDetails.
func (i *InMagePolicyDetails) GetPolicyProviderSpecificDetails() *PolicyProviderSpecificDetails {
	return &PolicyProviderSpecificDetails{
		InstanceType: i.InstanceType,
	}
}

// InMagePolicyInput - VMWare Azure specific protection profile Input.
type InMagePolicyInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'.
	MultiVMSyncStatus *SetMultiVMSyncStatus `json:"multiVmSyncStatus,omitempty"`

	// The app consistent snapshot frequency (in minutes).
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`

	// The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32 `json:"recoveryPointHistory,omitempty"`

	// The recovery point threshold in minutes.
	RecoveryPointThresholdInMinutes *int32 `json:"recoveryPointThresholdInMinutes,omitempty"`
}

// GetPolicyProviderSpecificInput implements the PolicyProviderSpecificInputClassification interface for type InMagePolicyInput.
func (i *InMagePolicyInput) GetPolicyProviderSpecificInput() *PolicyProviderSpecificInput {
	return &PolicyProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageProtectedDiskDetails - InMage protected disk details.
type InMageProtectedDiskDetails struct {
	// The disk capacity in bytes.
	DiskCapacityInBytes *int64 `json:"diskCapacityInBytes,omitempty"`

	// The disk id.
	DiskID *string `json:"diskId,omitempty"`

	// The disk name.
	DiskName *string `json:"diskName,omitempty"`

	// A value indicating whether disk is resized.
	DiskResized *string `json:"diskResized,omitempty"`

	// The file system capacity in bytes.
	FileSystemCapacityInBytes *int64 `json:"fileSystemCapacityInBytes,omitempty"`

	// The health error code for the disk.
	HealthErrorCode *string `json:"healthErrorCode,omitempty"`

	// The last RPO calculated time.
	LastRpoCalculatedTime *time.Time `json:"lastRpoCalculatedTime,omitempty"`

	// The Progress Health.
	ProgressHealth *string `json:"progressHealth,omitempty"`

	// The Progress Status.
	ProgressStatus *string `json:"progressStatus,omitempty"`

	// The protection stage.
	ProtectionStage *string `json:"protectionStage,omitempty"`

	// The PS data transit in MB.
	PsDataInMB *float64 `json:"psDataInMB,omitempty"`

	// The resync duration in seconds.
	ResyncDurationInSeconds *int64 `json:"resyncDurationInSeconds,omitempty"`

	// The resync last 15 minutes transferred bytes.
	ResyncLast15MinutesTransferredBytes *int64 `json:"resyncLast15MinutesTransferredBytes,omitempty"`

	// The last data transfer time in UTC.
	ResyncLastDataTransferTimeUTC *time.Time `json:"resyncLastDataTransferTimeUTC,omitempty"`

	// The resync processed bytes.
	ResyncProcessedBytes *int64 `json:"resyncProcessedBytes,omitempty"`

	// The resync progress percentage.
	ResyncProgressPercentage *int32 `json:"resyncProgressPercentage,omitempty"`

	// A value indicating whether resync is required for this disk.
	ResyncRequired *string `json:"resyncRequired,omitempty"`

	// The resync start time.
	ResyncStartTime *time.Time `json:"resyncStartTime,omitempty"`

	// The resync total transferred bytes.
	ResyncTotalTransferredBytes *int64 `json:"resyncTotalTransferredBytes,omitempty"`

	// The RPO in seconds.
	RpoInSeconds *int64 `json:"rpoInSeconds,omitempty"`

	// The source data transit in MB.
	SourceDataInMB *float64 `json:"sourceDataInMB,omitempty"`

	// The target data transit in MB.
	TargetDataInMB *float64 `json:"targetDataInMB,omitempty"`
}

// InMageRcmAgentUpgradeBlockingErrorDetails - InMageRcm source agent upgrade blocking error details.
type InMageRcmAgentUpgradeBlockingErrorDetails struct {
	// READ-ONLY; The error code.
	ErrorCode *string `json:"errorCode,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	ErrorMessage *string `json:"errorMessage,omitempty" azure:"ro"`

	// READ-ONLY; The error message parameters.
	ErrorMessageParameters map[string]*string `json:"errorMessageParameters,omitempty" azure:"ro"`

	// READ-ONLY; The error tags.
	ErrorTags map[string]*string `json:"errorTags,omitempty" azure:"ro"`

	// READ-ONLY; The possible causes.
	PossibleCauses *string `json:"possibleCauses,omitempty" azure:"ro"`

	// READ-ONLY; The recommended action.
	RecommendedAction *string `json:"recommendedAction,omitempty" azure:"ro"`
}

// InMageRcmApplianceDetails - InMageRcm appliance details.
type InMageRcmApplianceDetails struct {
	// READ-ONLY; The DRA.
	Dra *DraDetails `json:"dra,omitempty" azure:"ro"`

	// READ-ONLY; The fabric ARM Id.
	FabricArmID *string `json:"fabricArmId,omitempty" azure:"ro"`

	// READ-ONLY; The appliance Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The Mars agent.
	MarsAgent *MarsAgentDetails `json:"marsAgent,omitempty" azure:"ro"`

	// READ-ONLY; The appliance name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The process server.
	ProcessServer *ProcessServerDetails `json:"processServer,omitempty" azure:"ro"`

	// READ-ONLY; The push installer.
	PushInstaller *PushInstallerDetails `json:"pushInstaller,omitempty" azure:"ro"`

	// READ-ONLY; The of RCM proxy.
	RcmProxy *RcmProxyDetails `json:"rcmProxy,omitempty" azure:"ro"`

	// READ-ONLY; The replication agent.
	ReplicationAgent *ReplicationAgentDetails `json:"replicationAgent,omitempty" azure:"ro"`

	// READ-ONLY; The reprotect agent.
	ReprotectAgent *ReprotectAgentDetails `json:"reprotectAgent,omitempty" azure:"ro"`

	// READ-ONLY; The switch provider blocking error information.
	SwitchProviderBlockingErrorDetails []*InMageRcmFabricSwitchProviderBlockingErrorDetails `json:"switchProviderBlockingErrorDetails,omitempty" azure:"ro"`
}

// InMageRcmApplianceSpecificDetails - InMageRcm appliance specific details.
type InMageRcmApplianceSpecificDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// READ-ONLY; The list of appliances.
	Appliances []*InMageRcmApplianceDetails `json:"appliances,omitempty" azure:"ro"`
}

// GetApplianceSpecificDetails implements the ApplianceSpecificDetailsClassification interface for type InMageRcmApplianceSpecificDetails.
func (i *InMageRcmApplianceSpecificDetails) GetApplianceSpecificDetails() *ApplianceSpecificDetails {
	return &ApplianceSpecificDetails{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmApplyRecoveryPointInput - ApplyRecoveryPoint input specific to InMageRcm provider.
type InMageRcmApplyRecoveryPointInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; The recovery point Id.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
}

// GetApplyRecoveryPointProviderSpecificInput implements the ApplyRecoveryPointProviderSpecificInputClassification interface
// for type InMageRcmApplyRecoveryPointInput.
func (i *InMageRcmApplyRecoveryPointInput) GetApplyRecoveryPointProviderSpecificInput() *ApplyRecoveryPointProviderSpecificInput {
	return &ApplyRecoveryPointProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmDiscoveredProtectedVMDetails - InMageRcm discovered protected VM details.
type InMageRcmDiscoveredProtectedVMDetails struct {
	// READ-ONLY; The SDS created timestamp.
	CreatedTimestamp *time.Time `json:"createdTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; The list of datastores.
	Datastores []*string `json:"datastores,omitempty" azure:"ro"`

	// READ-ONLY; The list of IP addresses.
	IPAddresses []*string `json:"ipAddresses,omitempty" azure:"ro"`

	// READ-ONLY; A value indicating whether the VM is deleted.
	IsDeleted *bool `json:"isDeleted,omitempty" azure:"ro"`

	// READ-ONLY; The last time when SDS information discovered in SRS.
	LastDiscoveryTimeInUTC *time.Time `json:"lastDiscoveryTimeInUtc,omitempty" azure:"ro"`

	// READ-ONLY; The VM's OS name.
	OSName *string `json:"osName,omitempty" azure:"ro"`

	// READ-ONLY; The VM power status.
	PowerStatus *string `json:"powerStatus,omitempty" azure:"ro"`

	// READ-ONLY; The SDS updated timestamp.
	UpdatedTimestamp *time.Time `json:"updatedTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; The VCenter fqdn.
	VCenterFqdn *string `json:"vCenterFqdn,omitempty" azure:"ro"`

	// READ-ONLY; The VCenter Id.
	VCenterID *string `json:"vCenterId,omitempty" azure:"ro"`

	// READ-ONLY; The VM fqdn.
	VMFqdn *string `json:"vmFqdn,omitempty" azure:"ro"`

	// READ-ONLY; The VMware tools status.
	VmwareToolsStatus *string `json:"vmwareToolsStatus,omitempty" azure:"ro"`
}

// InMageRcmDiskInput - InMageRcm disk input.
type InMageRcmDiskInput struct {
	// REQUIRED; The disk Id.
	DiskID *string `json:"diskId,omitempty"`

	// REQUIRED; The disk type.
	DiskType *DiskAccountType `json:"diskType,omitempty"`

	// REQUIRED; The log storage account ARM Id.
	LogStorageAccountID *string `json:"logStorageAccountId,omitempty"`

	// The DiskEncryptionSet ARM Id.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`
}

// InMageRcmDisksDefaultInput - InMageRcm disk input.
type InMageRcmDisksDefaultInput struct {
	// REQUIRED; The disk type.
	DiskType *DiskAccountType `json:"diskType,omitempty"`

	// REQUIRED; The log storage account ARM Id.
	LogStorageAccountID *string `json:"logStorageAccountId,omitempty"`

	// The DiskEncryptionSet ARM Id.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`
}

// InMageRcmEnableProtectionInput - InMageRcm specific enable protection input.
type InMageRcmEnableProtectionInput struct {
	// REQUIRED; The ARM Id of discovered machine.
	FabricDiscoveryMachineID *string `json:"fabricDiscoveryMachineId,omitempty"`

	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; The process server Id.
	ProcessServerID *string `json:"processServerId,omitempty"`

	// REQUIRED; The target resource group ARM Id.
	TargetResourceGroupID *string `json:"targetResourceGroupId,omitempty"`

	// The default disk input.
	DisksDefault *InMageRcmDisksDefaultInput `json:"disksDefault,omitempty"`

	// The disks to include list.
	DisksToInclude []*InMageRcmDiskInput `json:"disksToInclude,omitempty"`

	// The license type.
	LicenseType *LicenseType `json:"licenseType,omitempty"`

	// The multi VM group name.
	MultiVMGroupName *string `json:"multiVmGroupName,omitempty"`

	// The run-as account Id.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`

	// The target availability set ARM Id.
	TargetAvailabilitySetID *string `json:"targetAvailabilitySetId,omitempty"`

	// The target availability zone.
	TargetAvailabilityZone *string `json:"targetAvailabilityZone,omitempty"`

	// The target boot diagnostics storage account ARM Id.
	TargetBootDiagnosticsStorageAccountID *string `json:"targetBootDiagnosticsStorageAccountId,omitempty"`

	// The selected target network ARM Id.
	TargetNetworkID *string `json:"targetNetworkId,omitempty"`

	// The target proximity placement group Id.
	TargetProximityPlacementGroupID *string `json:"targetProximityPlacementGroupId,omitempty"`

	// The selected target subnet name.
	TargetSubnetName *string `json:"targetSubnetName,omitempty"`

	// The target VM name.
	TargetVMName *string `json:"targetVmName,omitempty"`

	// The target VM size.
	TargetVMSize *string `json:"targetVmSize,omitempty"`

	// The selected test network ARM Id.
	TestNetworkID *string `json:"testNetworkId,omitempty"`

	// The selected test subnet name.
	TestSubnetName *string `json:"testSubnetName,omitempty"`
}

// GetEnableProtectionProviderSpecificInput implements the EnableProtectionProviderSpecificInputClassification interface for
// type InMageRcmEnableProtectionInput.
func (i *InMageRcmEnableProtectionInput) GetEnableProtectionProviderSpecificInput() *EnableProtectionProviderSpecificInput {
	return &EnableProtectionProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmEventDetails - Event details for InMageRcm provider.
type InMageRcmEventDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// READ-ONLY; The appliance name.
	ApplianceName *string `json:"applianceName,omitempty" azure:"ro"`

	// READ-ONLY; The component display name.
	ComponentDisplayName *string `json:"componentDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; The fabric name.
	FabricName *string `json:"fabricName,omitempty" azure:"ro"`

	// READ-ONLY; The job Id.
	JobID *string `json:"jobId,omitempty" azure:"ro"`

	// READ-ONLY; The latest agent version.
	LatestAgentVersion *string `json:"latestAgentVersion,omitempty" azure:"ro"`

	// READ-ONLY; The protected item name.
	ProtectedItemName *string `json:"protectedItemName,omitempty" azure:"ro"`

	// READ-ONLY; The server type.
	ServerType *string `json:"serverType,omitempty" azure:"ro"`

	// READ-ONLY; The protected item name.
	VMName *string `json:"vmName,omitempty" azure:"ro"`
}

// GetEventProviderSpecificDetails implements the EventProviderSpecificDetailsClassification interface for type InMageRcmEventDetails.
func (i *InMageRcmEventDetails) GetEventProviderSpecificDetails() *EventProviderSpecificDetails {
	return &EventProviderSpecificDetails{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmFabricCreationInput - InMageRcm fabric provider specific settings.
type InMageRcmFabricCreationInput struct {
	// REQUIRED; Gets the class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; The ARM Id of the physical site.
	PhysicalSiteID *string `json:"physicalSiteId,omitempty"`

	// REQUIRED; The identity provider input for source agent authentication.
	SourceAgentIdentity *IdentityProviderInput `json:"sourceAgentIdentity,omitempty"`

	// REQUIRED; The ARM Id of the VMware site.
	VmwareSiteID *string `json:"vmwareSiteId,omitempty"`
}

// GetFabricSpecificCreationInput implements the FabricSpecificCreationInputClassification interface for type InMageRcmFabricCreationInput.
func (i *InMageRcmFabricCreationInput) GetFabricSpecificCreationInput() *FabricSpecificCreationInput {
	return &FabricSpecificCreationInput{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmFabricSpecificDetails - InMageRcm fabric specific details.
type InMageRcmFabricSpecificDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// The source agent identity details.
	SourceAgentIdentityDetails *IdentityProviderDetails `json:"sourceAgentIdentityDetails,omitempty"`

	// READ-ONLY; The list of agent details.
	AgentDetails []*AgentDetails `json:"agentDetails,omitempty" azure:"ro"`

	// READ-ONLY; The control plane Uri.
	ControlPlaneURI *string `json:"controlPlaneUri,omitempty" azure:"ro"`

	// READ-ONLY; The data plane Uri.
	DataPlaneURI *string `json:"dataPlaneUri,omitempty" azure:"ro"`

	// READ-ONLY; The list of DRAs.
	Dras []*DraDetails `json:"dras,omitempty" azure:"ro"`

	// READ-ONLY; The list of Mars agents.
	MarsAgents []*MarsAgentDetails `json:"marsAgents,omitempty" azure:"ro"`

	// READ-ONLY; The ARM Id of the physical site.
	PhysicalSiteID *string `json:"physicalSiteId,omitempty" azure:"ro"`

	// READ-ONLY; The list of process servers.
	ProcessServers []*ProcessServerDetails `json:"processServers,omitempty" azure:"ro"`

	// READ-ONLY; The list of push installers.
	PushInstallers []*PushInstallerDetails `json:"pushInstallers,omitempty" azure:"ro"`

	// READ-ONLY; The list of RCM proxies.
	RcmProxies []*RcmProxyDetails `json:"rcmProxies,omitempty" azure:"ro"`

	// READ-ONLY; The list of replication agents.
	ReplicationAgents []*ReplicationAgentDetails `json:"replicationAgents,omitempty" azure:"ro"`

	// READ-ONLY; The list of reprotect agents.
	ReprotectAgents []*ReprotectAgentDetails `json:"reprotectAgents,omitempty" azure:"ro"`

	// READ-ONLY; The service container Id.
	ServiceContainerID *string `json:"serviceContainerId,omitempty" azure:"ro"`

	// READ-ONLY; The service endpoint.
	ServiceEndpoint *string `json:"serviceEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; The service resource Id.
	ServiceResourceID *string `json:"serviceResourceId,omitempty" azure:"ro"`

	// READ-ONLY; The ARM Id of the VMware site.
	VmwareSiteID *string `json:"vmwareSiteId,omitempty" azure:"ro"`
}

// GetFabricSpecificDetails implements the FabricSpecificDetailsClassification interface for type InMageRcmFabricSpecificDetails.
func (i *InMageRcmFabricSpecificDetails) GetFabricSpecificDetails() *FabricSpecificDetails {
	return &FabricSpecificDetails{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmFabricSwitchProviderBlockingErrorDetails - InMageRcmFabric switch provider blocking error details.
type InMageRcmFabricSwitchProviderBlockingErrorDetails struct {
	// READ-ONLY; The error code.
	ErrorCode *string `json:"errorCode,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	ErrorMessage *string `json:"errorMessage,omitempty" azure:"ro"`

	// READ-ONLY; The error message parameters.
	ErrorMessageParameters map[string]*string `json:"errorMessageParameters,omitempty" azure:"ro"`

	// READ-ONLY; The error tags.
	ErrorTags map[string]*string `json:"errorTags,omitempty" azure:"ro"`

	// READ-ONLY; The possible causes.
	PossibleCauses *string `json:"possibleCauses,omitempty" azure:"ro"`

	// READ-ONLY; The recommended action.
	RecommendedAction *string `json:"recommendedAction,omitempty" azure:"ro"`
}

// InMageRcmFailbackDiscoveredProtectedVMDetails - InMageRcmFailback discovered VM details.
type InMageRcmFailbackDiscoveredProtectedVMDetails struct {
	// READ-ONLY; The SDS created timestamp.
	CreatedTimestamp *time.Time `json:"createdTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; The list of datastores.
	Datastores []*string `json:"datastores,omitempty" azure:"ro"`

	// READ-ONLY; The list of IP addresses.
	IPAddresses []*string `json:"ipAddresses,omitempty" azure:"ro"`

	// READ-ONLY; A value indicating whether the VM is deleted.
	IsDeleted *bool `json:"isDeleted,omitempty" azure:"ro"`

	// READ-ONLY; The last time when SDS information discovered in SRS.
	LastDiscoveryTimeInUTC *time.Time `json:"lastDiscoveryTimeInUtc,omitempty" azure:"ro"`

	// READ-ONLY; The VM's OS name.
	OSName *string `json:"osName,omitempty" azure:"ro"`

	// READ-ONLY; The VM power status.
	PowerStatus *string `json:"powerStatus,omitempty" azure:"ro"`

	// READ-ONLY; The SDS updated timestamp.
	UpdatedTimestamp *time.Time `json:"updatedTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; The VCenter fqdn.
	VCenterFqdn *string `json:"vCenterFqdn,omitempty" azure:"ro"`

	// READ-ONLY; The VCenter Id.
	VCenterID *string `json:"vCenterId,omitempty" azure:"ro"`

	// READ-ONLY; The VM fqdn.
	VMFqdn *string `json:"vmFqdn,omitempty" azure:"ro"`

	// READ-ONLY; The VMware tools status.
	VmwareToolsStatus *string `json:"vmwareToolsStatus,omitempty" azure:"ro"`
}

// InMageRcmFailbackEventDetails - Event details for InMageRcmFailback provider.
type InMageRcmFailbackEventDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// READ-ONLY; The appliance name.
	ApplianceName *string `json:"applianceName,omitempty" azure:"ro"`

	// READ-ONLY; The component display name.
	ComponentDisplayName *string `json:"componentDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; The protected item name.
	ProtectedItemName *string `json:"protectedItemName,omitempty" azure:"ro"`

	// READ-ONLY; The server type.
	ServerType *string `json:"serverType,omitempty" azure:"ro"`

	// READ-ONLY; The protected item name.
	VMName *string `json:"vmName,omitempty" azure:"ro"`
}

// GetEventProviderSpecificDetails implements the EventProviderSpecificDetailsClassification interface for type InMageRcmFailbackEventDetails.
func (i *InMageRcmFailbackEventDetails) GetEventProviderSpecificDetails() *EventProviderSpecificDetails {
	return &EventProviderSpecificDetails{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmFailbackMobilityAgentDetails - InMageRcmFailback mobility agent details.
type InMageRcmFailbackMobilityAgentDetails struct {
	// READ-ONLY; The agent version expiry date.
	AgentVersionExpiryDate *time.Time `json:"agentVersionExpiryDate,omitempty" azure:"ro"`

	// READ-ONLY; The driver version.
	DriverVersion *string `json:"driverVersion,omitempty" azure:"ro"`

	// READ-ONLY; The driver version expiry date.
	DriverVersionExpiryDate *time.Time `json:"driverVersionExpiryDate,omitempty" azure:"ro"`

	// READ-ONLY; A value indicating whether agent is upgradeable or not.
	IsUpgradeable *string `json:"isUpgradeable,omitempty" azure:"ro"`

	// READ-ONLY; The time of the last heartbeat received from the agent.
	LastHeartbeatUTC *time.Time `json:"lastHeartbeatUtc,omitempty" azure:"ro"`

	// READ-ONLY; The latest upgradeable version available without reboot.
	LatestUpgradableVersionWithoutReboot *string `json:"latestUpgradableVersionWithoutReboot,omitempty" azure:"ro"`

	// READ-ONLY; The latest agent version available.
	LatestVersion *string `json:"latestVersion,omitempty" azure:"ro"`

	// READ-ONLY; The whether update is possible or not.
	ReasonsBlockingUpgrade []*AgentUpgradeBlockedReason `json:"reasonsBlockingUpgrade,omitempty" azure:"ro"`

	// READ-ONLY; The agent version.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// InMageRcmFailbackNicDetails - InMageRcmFailback NIC details.
type InMageRcmFailbackNicDetails struct {
	// READ-ONLY; The adapter type.
	AdapterType *string `json:"adapterType,omitempty" azure:"ro"`

	// READ-ONLY; The mac address.
	MacAddress *string `json:"macAddress,omitempty" azure:"ro"`

	// READ-ONLY; The network name.
	NetworkName *string `json:"networkName,omitempty" azure:"ro"`

	// READ-ONLY; The IP address.
	SourceIPAddress *string `json:"sourceIpAddress,omitempty" azure:"ro"`
}

// InMageRcmFailbackPlannedFailoverProviderInput - Provider specific input for InMageRcmFailback failover.
type InMageRcmFailbackPlannedFailoverProviderInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; The recovery point type.
	RecoveryPointType *InMageRcmFailbackRecoveryPointType `json:"recoveryPointType,omitempty"`
}

// GetPlannedFailoverProviderSpecificFailoverInput implements the PlannedFailoverProviderSpecificFailoverInputClassification
// interface for type InMageRcmFailbackPlannedFailoverProviderInput.
func (i *InMageRcmFailbackPlannedFailoverProviderInput) GetPlannedFailoverProviderSpecificFailoverInput() *PlannedFailoverProviderSpecificFailoverInput {
	return &PlannedFailoverProviderSpecificFailoverInput{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmFailbackPolicyCreationInput - InMageRcmFailback policy creation input.
type InMageRcmFailbackPolicyCreationInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The app consistent snapshot frequency (in minutes).
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`

	// The crash consistent snapshot frequency (in minutes).
	CrashConsistentFrequencyInMinutes *int32 `json:"crashConsistentFrequencyInMinutes,omitempty"`
}

// GetPolicyProviderSpecificInput implements the PolicyProviderSpecificInputClassification interface for type InMageRcmFailbackPolicyCreationInput.
func (i *InMageRcmFailbackPolicyCreationInput) GetPolicyProviderSpecificInput() *PolicyProviderSpecificInput {
	return &PolicyProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmFailbackPolicyDetails - InMageRcm failback specific policy details.
type InMageRcmFailbackPolicyDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// The app consistent snapshot frequency in minutes.
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`

	// The crash consistent snapshot frequency in minutes.
	CrashConsistentFrequencyInMinutes *int32 `json:"crashConsistentFrequencyInMinutes,omitempty"`
}

// GetPolicyProviderSpecificDetails implements the PolicyProviderSpecificDetailsClassification interface for type InMageRcmFailbackPolicyDetails.
func (i *InMageRcmFailbackPolicyDetails) GetPolicyProviderSpecificDetails() *PolicyProviderSpecificDetails {
	return &PolicyProviderSpecificDetails{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmFailbackProtectedDiskDetails - InMageRcmFailback protected disk details.
type InMageRcmFailbackProtectedDiskDetails struct {
	// The initial replication details.
	IrDetails *InMageRcmFailbackSyncDetails `json:"irDetails,omitempty"`

	// The resync details.
	ResyncDetails *InMageRcmFailbackSyncDetails `json:"resyncDetails,omitempty"`

	// READ-ONLY; The disk capacity in bytes.
	CapacityInBytes *int64 `json:"capacityInBytes,omitempty" azure:"ro"`

	// READ-ONLY; The data pending at source agent in MB.
	DataPendingAtSourceAgentInMB *float64 `json:"dataPendingAtSourceAgentInMB,omitempty" azure:"ro"`

	// READ-ONLY; The data pending in log data store in MB.
	DataPendingInLogDataStoreInMB *float64 `json:"dataPendingInLogDataStoreInMB,omitempty" azure:"ro"`

	// READ-ONLY; The disk Id (reported by source agent).
	DiskID *string `json:"diskId,omitempty" azure:"ro"`

	// READ-ONLY; The disk name.
	DiskName *string `json:"diskName,omitempty" azure:"ro"`

	// READ-ONLY; The disk Uuid (reported by vCenter).
	DiskUUID *string `json:"diskUuid,omitempty" azure:"ro"`

	// READ-ONLY; A value indicating whether initial replication is complete or not.
	IsInitialReplicationComplete *string `json:"isInitialReplicationComplete,omitempty" azure:"ro"`

	// READ-ONLY; A value indicating whether the disk is the OS disk.
	IsOSDisk *string `json:"isOSDisk,omitempty" azure:"ro"`

	// READ-ONLY; The last sync time.
	LastSyncTime *time.Time `json:"lastSyncTime,omitempty" azure:"ro"`
}

// InMageRcmFailbackReplicationDetails - InMageRcmFailback provider specific details.
type InMageRcmFailbackReplicationDetails struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The discovered VM information.
	DiscoveredVMDetails *InMageRcmFailbackDiscoveredProtectedVMDetails `json:"discoveredVmDetails,omitempty"`

	// The mobility agent information.
	MobilityAgentDetails *InMageRcmFailbackMobilityAgentDetails `json:"mobilityAgentDetails,omitempty"`

	// The list of protected disks.
	ProtectedDisks []*InMageRcmFailbackProtectedDiskDetails `json:"protectedDisks,omitempty"`

	// The network details.
	VMNics []*InMageRcmFailbackNicDetails `json:"vmNics,omitempty"`

	// READ-ONLY; The ARM Id of the azure VM.
	AzureVirtualMachineID *string `json:"azureVirtualMachineId,omitempty" azure:"ro"`

	// READ-ONLY; The initial replication processed bytes. This includes sum of total bytes transferred and matched bytes on all
	// selected disks in source VM.
	InitialReplicationProcessedBytes *int64 `json:"initialReplicationProcessedBytes,omitempty" azure:"ro"`

	// READ-ONLY; The initial replication progress health.
	InitialReplicationProgressHealth *VMReplicationProgressHealth `json:"initialReplicationProgressHealth,omitempty" azure:"ro"`

	// READ-ONLY; The initial replication progress percentage.
	InitialReplicationProgressPercentage *int32 `json:"initialReplicationProgressPercentage,omitempty" azure:"ro"`

	// READ-ONLY; The initial replication transferred bytes from source VM to target for all selected disks on source VM.
	InitialReplicationTransferredBytes *int64 `json:"initialReplicationTransferredBytes,omitempty" azure:"ro"`

	// READ-ONLY; The virtual machine internal identifier.
	InternalIdentifier *string `json:"internalIdentifier,omitempty" azure:"ro"`

	// READ-ONLY; A value indicating whether agent registration was successful after failover.
	IsAgentRegistrationSuccessfulAfterFailover *bool `json:"isAgentRegistrationSuccessfulAfterFailover,omitempty" azure:"ro"`

	// READ-ONLY; The last planned failover start time.
	LastPlannedFailoverStartTime *time.Time `json:"lastPlannedFailoverStartTime,omitempty" azure:"ro"`

	// READ-ONLY; The last planned failover status.
	LastPlannedFailoverStatus *PlannedFailoverStatus `json:"lastPlannedFailoverStatus,omitempty" azure:"ro"`

	// READ-ONLY; The policy friendly name used by the forward replication.
	LastUsedPolicyFriendlyName *string `json:"lastUsedPolicyFriendlyName,omitempty" azure:"ro"`

	// READ-ONLY; The policy Id used by the forward replication.
	LastUsedPolicyID *string `json:"lastUsedPolicyId,omitempty" azure:"ro"`

	// READ-ONLY; The log storage account ARM Id.
	LogStorageAccountID *string `json:"logStorageAccountId,omitempty" azure:"ro"`

	// READ-ONLY; The multi VM group name.
	MultiVMGroupName *string `json:"multiVmGroupName,omitempty" azure:"ro"`

	// READ-ONLY; The type of the OS on the VM.
	OSType *string `json:"osType,omitempty" azure:"ro"`

	// READ-ONLY; The reprotect agent Id.
	ReprotectAgentID *string `json:"reprotectAgentId,omitempty" azure:"ro"`

	// READ-ONLY; The reprotect agent name.
	ReprotectAgentName *string `json:"reprotectAgentName,omitempty" azure:"ro"`

	// READ-ONLY; The resync processed bytes. This includes sum of total bytes transferred and matched bytes on all selected disks
	// in source VM.
	ResyncProcessedBytes *int64 `json:"resyncProcessedBytes,omitempty" azure:"ro"`

	// READ-ONLY; The resync progress health.
	ResyncProgressHealth *VMReplicationProgressHealth `json:"resyncProgressHealth,omitempty" azure:"ro"`

	// READ-ONLY; The resync progress percentage.
	ResyncProgressPercentage *int32 `json:"resyncProgressPercentage,omitempty" azure:"ro"`

	// READ-ONLY; A value indicating whether resync is required.
	ResyncRequired *string `json:"resyncRequired,omitempty" azure:"ro"`

	// READ-ONLY; The resync state.
	ResyncState *ResyncState `json:"resyncState,omitempty" azure:"ro"`

	// READ-ONLY; The resync transferred bytes from source VM to target for all selected disks on source VM.
	ResyncTransferredBytes *int64 `json:"resyncTransferredBytes,omitempty" azure:"ro"`

	// READ-ONLY; The target datastore name.
	TargetDataStoreName *string `json:"targetDataStoreName,omitempty" azure:"ro"`

	// READ-ONLY; The target VM name.
	TargetVMName *string `json:"targetVmName,omitempty" azure:"ro"`

	// READ-ONLY; The target vCenter Id.
	TargetvCenterID *string `json:"targetvCenterId,omitempty" azure:"ro"`
}

// GetReplicationProviderSpecificSettings implements the ReplicationProviderSpecificSettingsClassification interface for type
// InMageRcmFailbackReplicationDetails.
func (i *InMageRcmFailbackReplicationDetails) GetReplicationProviderSpecificSettings() *ReplicationProviderSpecificSettings {
	return &ReplicationProviderSpecificSettings{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmFailbackReprotectInput - InMageRcmFailback specific provider input.
type InMageRcmFailbackReprotectInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; The Policy Id.
	PolicyID *string `json:"policyId,omitempty"`

	// REQUIRED; The process server Id.
	ProcessServerID *string `json:"processServerId,omitempty"`

	// The run as account Id.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`
}

// GetReverseReplicationProviderSpecificInput implements the ReverseReplicationProviderSpecificInputClassification interface
// for type InMageRcmFailbackReprotectInput.
func (i *InMageRcmFailbackReprotectInput) GetReverseReplicationProviderSpecificInput() *ReverseReplicationProviderSpecificInput {
	return &ReverseReplicationProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmFailbackSyncDetails - InMageRcmFailback disk level sync details.
type InMageRcmFailbackSyncDetails struct {
	// READ-ONLY; The bytes transferred in last 15 minutes from source VM to target.
	Last15MinutesTransferredBytes *int64 `json:"last15MinutesTransferredBytes,omitempty" azure:"ro"`

	// READ-ONLY; The time of the last data transfer from source VM to target.
	LastDataTransferTimeUTC *string `json:"lastDataTransferTimeUtc,omitempty" azure:"ro"`

	// READ-ONLY; The last refresh time.
	LastRefreshTime *string `json:"lastRefreshTime,omitempty" azure:"ro"`

	// READ-ONLY; The total processed bytes. This includes bytes that are transferred from source VM to target and matched bytes.
	ProcessedBytes *int64 `json:"processedBytes,omitempty" azure:"ro"`

	// READ-ONLY; The progress health.
	ProgressHealth *DiskReplicationProgressHealth `json:"progressHealth,omitempty" azure:"ro"`

	// READ-ONLY; Progress in percentage. Progress percentage is calculated based on processed bytes.
	ProgressPercentage *int32 `json:"progressPercentage,omitempty" azure:"ro"`

	// READ-ONLY; The start time.
	StartTime *string `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The transferred bytes from source VM to azure for the disk.
	TransferredBytes *int64 `json:"transferredBytes,omitempty" azure:"ro"`
}

// InMageRcmLastAgentUpgradeErrorDetails - InMageRcm last source agent upgrade error details.
type InMageRcmLastAgentUpgradeErrorDetails struct {
	// READ-ONLY; The error code.
	ErrorCode *string `json:"errorCode,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	ErrorMessage *string `json:"errorMessage,omitempty" azure:"ro"`

	// READ-ONLY; The error message parameters.
	ErrorMessageParameters map[string]*string `json:"errorMessageParameters,omitempty" azure:"ro"`

	// READ-ONLY; The error tags.
	ErrorTags map[string]*string `json:"errorTags,omitempty" azure:"ro"`

	// READ-ONLY; The possible causes.
	PossibleCauses *string `json:"possibleCauses,omitempty" azure:"ro"`

	// READ-ONLY; The recommended action.
	RecommendedAction *string `json:"recommendedAction,omitempty" azure:"ro"`
}

// InMageRcmMobilityAgentDetails - InMageRcm mobility agent details.
type InMageRcmMobilityAgentDetails struct {
	// READ-ONLY; The agent version expiry date.
	AgentVersionExpiryDate *time.Time `json:"agentVersionExpiryDate,omitempty" azure:"ro"`

	// READ-ONLY; The driver version.
	DriverVersion *string `json:"driverVersion,omitempty" azure:"ro"`

	// READ-ONLY; The driver version expiry date.
	DriverVersionExpiryDate *time.Time `json:"driverVersionExpiryDate,omitempty" azure:"ro"`

	// READ-ONLY; A value indicating whether agent is upgradeable or not.
	IsUpgradeable *string `json:"isUpgradeable,omitempty" azure:"ro"`

	// READ-ONLY; The time of the last heartbeat received from the agent.
	LastHeartbeatUTC *time.Time `json:"lastHeartbeatUtc,omitempty" azure:"ro"`

	// READ-ONLY; The latest agent version release date.
	LatestAgentReleaseDate *string `json:"latestAgentReleaseDate,omitempty" azure:"ro"`

	// READ-ONLY; The latest upgradeable version available without reboot.
	LatestUpgradableVersionWithoutReboot *string `json:"latestUpgradableVersionWithoutReboot,omitempty" azure:"ro"`

	// READ-ONLY; The latest agent version available.
	LatestVersion *string `json:"latestVersion,omitempty" azure:"ro"`

	// READ-ONLY; The whether update is possible or not.
	ReasonsBlockingUpgrade []*AgentUpgradeBlockedReason `json:"reasonsBlockingUpgrade,omitempty" azure:"ro"`

	// READ-ONLY; The agent version.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// InMageRcmNicDetails - InMageRcm NIC details.
type InMageRcmNicDetails struct {
	// A value indicating whether this is the primary NIC.
	IsPrimaryNic *string `json:"isPrimaryNic,omitempty"`

	// A value indicating whether this NIC is selected for failover.
	IsSelectedForFailover *string `json:"isSelectedForFailover,omitempty"`

	// The target IP address.
	TargetIPAddress *string `json:"targetIPAddress,omitempty"`

	// The target IP address type.
	TargetIPAddressType *EthernetAddressType `json:"targetIPAddressType,omitempty"`

	// Target subnet name.
	TargetSubnetName *string `json:"targetSubnetName,omitempty"`

	// The test IP address.
	TestIPAddress *string `json:"testIPAddress,omitempty"`

	// The test IP address type.
	TestIPAddressType *EthernetAddressType `json:"testIPAddressType,omitempty"`

	// Test subnet name.
	TestSubnetName *string `json:"testSubnetName,omitempty"`

	// READ-ONLY; The NIC Id.
	NicID *string `json:"nicId,omitempty" azure:"ro"`

	// READ-ONLY; The source IP address.
	SourceIPAddress *string `json:"sourceIPAddress,omitempty" azure:"ro"`

	// READ-ONLY; The source IP address type.
	SourceIPAddressType *EthernetAddressType `json:"sourceIPAddressType,omitempty" azure:"ro"`

	// READ-ONLY; Source network Id.
	SourceNetworkID *string `json:"sourceNetworkId,omitempty" azure:"ro"`

	// READ-ONLY; Source subnet name.
	SourceSubnetName *string `json:"sourceSubnetName,omitempty" azure:"ro"`
}

// InMageRcmNicInput - InMageRcm NIC input.
type InMageRcmNicInput struct {
	// REQUIRED; A value indicating whether this is the primary NIC.
	IsPrimaryNic *string `json:"isPrimaryNic,omitempty"`

	// REQUIRED; The NIC Id.
	NicID *string `json:"nicId,omitempty"`

	// A value indicating whether this NIC is selected for failover.
	IsSelectedForFailover *string `json:"isSelectedForFailover,omitempty"`

	// The target static IP address.
	TargetStaticIPAddress *string `json:"targetStaticIPAddress,omitempty"`

	// Target subnet name.
	TargetSubnetName *string `json:"targetSubnetName,omitempty"`

	// The test static IP address.
	TestStaticIPAddress *string `json:"testStaticIPAddress,omitempty"`

	// The test subnet name.
	TestSubnetName *string `json:"testSubnetName,omitempty"`
}

// InMageRcmPolicyCreationInput - InMageRcm policy creation input.
type InMageRcmPolicyCreationInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The app consistent snapshot frequency (in minutes).
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`

	// The crash consistent snapshot frequency (in minutes).
	CrashConsistentFrequencyInMinutes *int32 `json:"crashConsistentFrequencyInMinutes,omitempty"`

	// A value indicating whether multi-VM sync has to be enabled.
	EnableMultiVMSync *string `json:"enableMultiVmSync,omitempty"`

	// The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistoryInMinutes *int32 `json:"recoveryPointHistoryInMinutes,omitempty"`
}

// GetPolicyProviderSpecificInput implements the PolicyProviderSpecificInputClassification interface for type InMageRcmPolicyCreationInput.
func (i *InMageRcmPolicyCreationInput) GetPolicyProviderSpecificInput() *PolicyProviderSpecificInput {
	return &PolicyProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmPolicyDetails - InMageRcm specific policy details.
type InMageRcmPolicyDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// The app consistent snapshot frequency in minutes.
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`

	// The crash consistent snapshot frequency in minutes.
	CrashConsistentFrequencyInMinutes *int32 `json:"crashConsistentFrequencyInMinutes,omitempty"`

	// A value indicating whether multi-VM sync has to be enabled.
	EnableMultiVMSync *string `json:"enableMultiVmSync,omitempty"`

	// The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistoryInMinutes *int32 `json:"recoveryPointHistoryInMinutes,omitempty"`
}

// GetPolicyProviderSpecificDetails implements the PolicyProviderSpecificDetailsClassification interface for type InMageRcmPolicyDetails.
func (i *InMageRcmPolicyDetails) GetPolicyProviderSpecificDetails() *PolicyProviderSpecificDetails {
	return &PolicyProviderSpecificDetails{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmProtectedDiskDetails - InMageRcm protected disk details.
type InMageRcmProtectedDiskDetails struct {
	// The disk type.
	DiskType *DiskAccountType `json:"diskType,omitempty"`

	// The initial replication details.
	IrDetails *InMageRcmSyncDetails `json:"irDetails,omitempty"`

	// The resync details.
	ResyncDetails *InMageRcmSyncDetails `json:"resyncDetails,omitempty"`

	// READ-ONLY; The disk capacity in bytes.
	CapacityInBytes *int64 `json:"capacityInBytes,omitempty" azure:"ro"`

	// READ-ONLY; The data pending at source agent in MB.
	DataPendingAtSourceAgentInMB *float64 `json:"dataPendingAtSourceAgentInMB,omitempty" azure:"ro"`

	// READ-ONLY; The data pending in log data store in MB.
	DataPendingInLogDataStoreInMB *float64 `json:"dataPendingInLogDataStoreInMB,omitempty" azure:"ro"`

	// READ-ONLY; The DiskEncryptionSet ARM Id.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty" azure:"ro"`

	// READ-ONLY; The disk Id.
	DiskID *string `json:"diskId,omitempty" azure:"ro"`

	// READ-ONLY; The disk name.
	DiskName *string `json:"diskName,omitempty" azure:"ro"`

	// READ-ONLY; A value indicating whether initial replication is complete or not.
	IsInitialReplicationComplete *string `json:"isInitialReplicationComplete,omitempty" azure:"ro"`

	// READ-ONLY; A value indicating whether the disk is the OS disk.
	IsOSDisk *string `json:"isOSDisk,omitempty" azure:"ro"`

	// READ-ONLY; The log storage account ARM Id.
	LogStorageAccountID *string `json:"logStorageAccountId,omitempty" azure:"ro"`

	// READ-ONLY; The ARM Id of the seed managed disk.
	SeedManagedDiskID *string `json:"seedManagedDiskId,omitempty" azure:"ro"`

	// READ-ONLY; The ARM Id of the target managed disk.
	TargetManagedDiskID *string `json:"targetManagedDiskId,omitempty" azure:"ro"`
}

// InMageRcmProtectionContainerMappingDetails - InMageRcm provider specific container mapping details.
type InMageRcmProtectionContainerMappingDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// READ-ONLY; A value indicating whether the flag for enable agent auto upgrade.
	EnableAgentAutoUpgrade *string `json:"enableAgentAutoUpgrade,omitempty" azure:"ro"`
}

// GetProtectionContainerMappingProviderSpecificDetails implements the ProtectionContainerMappingProviderSpecificDetailsClassification
// interface for type InMageRcmProtectionContainerMappingDetails.
func (i *InMageRcmProtectionContainerMappingDetails) GetProtectionContainerMappingProviderSpecificDetails() *ProtectionContainerMappingProviderSpecificDetails {
	return &ProtectionContainerMappingProviderSpecificDetails{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmRecoveryPointDetails - InMageRcm provider specific recovery point details.
type InMageRcmRecoveryPointDetails struct {
	// REQUIRED; Gets the provider type.
	InstanceType *string `json:"instanceType,omitempty"`

	// READ-ONLY; A value indicating whether the recovery point is multi VM consistent.
	IsMultiVMSyncPoint *string `json:"isMultiVmSyncPoint,omitempty" azure:"ro"`
}

// GetProviderSpecificRecoveryPointDetails implements the ProviderSpecificRecoveryPointDetailsClassification interface for
// type InMageRcmRecoveryPointDetails.
func (i *InMageRcmRecoveryPointDetails) GetProviderSpecificRecoveryPointDetails() *ProviderSpecificRecoveryPointDetails {
	return &ProviderSpecificRecoveryPointDetails{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmReplicationDetails - InMageRcm provider specific details.
type InMageRcmReplicationDetails struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The agent upgrade blocking error information.
	AgentUpgradeBlockingErrorDetails []*InMageRcmAgentUpgradeBlockingErrorDetails `json:"agentUpgradeBlockingErrorDetails,omitempty"`

	// The discovered VM details.
	DiscoveredVMDetails *InMageRcmDiscoveredProtectedVMDetails `json:"discoveredVmDetails,omitempty"`

	// The last agent upgrade error information.
	LastAgentUpgradeErrorDetails []*InMageRcmLastAgentUpgradeErrorDetails `json:"lastAgentUpgradeErrorDetails,omitempty"`

	// License Type of the VM to be used.
	LicenseType *string `json:"licenseType,omitempty"`

	// The mobility agent information.
	MobilityAgentDetails *InMageRcmMobilityAgentDetails `json:"mobilityAgentDetails,omitempty"`

	// The list of protected disks.
	ProtectedDisks []*InMageRcmProtectedDiskDetails `json:"protectedDisks,omitempty"`

	// The target availability set Id.
	TargetAvailabilitySetID *string `json:"targetAvailabilitySetId,omitempty"`

	// The target availability zone.
	TargetAvailabilityZone *string `json:"targetAvailabilityZone,omitempty"`

	// The target boot diagnostics storage account ARM Id.
	TargetBootDiagnosticsStorageAccountID *string `json:"targetBootDiagnosticsStorageAccountId,omitempty"`

	// The target location.
	TargetLocation *string `json:"targetLocation,omitempty"`

	// The target network Id.
	TargetNetworkID *string `json:"targetNetworkId,omitempty"`

	// The target proximity placement group Id.
	TargetProximityPlacementGroupID *string `json:"targetProximityPlacementGroupId,omitempty"`

	// The target resource group Id.
	TargetResourceGroupID *string `json:"targetResourceGroupId,omitempty"`

	// Target VM name.
	TargetVMName *string `json:"targetVmName,omitempty"`

	// The target VM size.
	TargetVMSize *string `json:"targetVmSize,omitempty"`

	// The test network Id.
	TestNetworkID *string `json:"testNetworkId,omitempty"`

	// The network details.
	VMNics []*InMageRcmNicDetails `json:"vmNics,omitempty"`

	// READ-ONLY; The agent version to which last agent upgrade was attempted.
	AgentUpgradeAttemptToVersion *string `json:"agentUpgradeAttemptToVersion,omitempty" azure:"ro"`

	// READ-ONLY; The agent upgrade job Id.
	AgentUpgradeJobID *string `json:"agentUpgradeJobId,omitempty" azure:"ro"`

	// READ-ONLY; The agent auto upgrade state.
	AgentUpgradeState *MobilityAgentUpgradeState `json:"agentUpgradeState,omitempty" azure:"ro"`

	// READ-ONLY; The allocated memory in MB.
	AllocatedMemoryInMB *float64 `json:"allocatedMemoryInMB,omitempty" azure:"ro"`

	// READ-ONLY; The type of the discovered VM.
	DiscoveryType *string `json:"discoveryType,omitempty" azure:"ro"`

	// READ-ONLY; The ARM Id of the discovered VM.
	FabricDiscoveryMachineID *string `json:"fabricDiscoveryMachineId,omitempty" azure:"ro"`

	// READ-ONLY; The recovery point Id to which the VM was failed over.
	FailoverRecoveryPointID *string `json:"failoverRecoveryPointId,omitempty" azure:"ro"`

	// READ-ONLY; The firmware type.
	FirmwareType *string `json:"firmwareType,omitempty" azure:"ro"`

	// READ-ONLY; The initial replication processed bytes. This includes sum of total bytes transferred and matched bytes on all
	// selected disks in source VM.
	InitialReplicationProcessedBytes *int64 `json:"initialReplicationProcessedBytes,omitempty" azure:"ro"`

	// READ-ONLY; The initial replication progress health.
	InitialReplicationProgressHealth *VMReplicationProgressHealth `json:"initialReplicationProgressHealth,omitempty" azure:"ro"`

	// READ-ONLY; The initial replication progress percentage. This is calculated based on total bytes processed for all disks
	// in the source VM.
	InitialReplicationProgressPercentage *int32 `json:"initialReplicationProgressPercentage,omitempty" azure:"ro"`

	// READ-ONLY; The initial replication transferred bytes from source VM to azure for all selected disks on source VM.
	InitialReplicationTransferredBytes *int64 `json:"initialReplicationTransferredBytes,omitempty" azure:"ro"`

	// READ-ONLY; The virtual machine internal identifier.
	InternalIdentifier *string `json:"internalIdentifier,omitempty" azure:"ro"`

	// READ-ONLY; A value indicating whether agent registration was successful after failover.
	IsAgentRegistrationSuccessfulAfterFailover *bool `json:"isAgentRegistrationSuccessfulAfterFailover,omitempty" azure:"ro"`

	// READ-ONLY; A value indicating whether last agent upgrade was successful or not.
	IsLastUpgradeSuccessful *string `json:"isLastUpgradeSuccessful,omitempty" azure:"ro"`

	// READ-ONLY; The last agent upgrade type.
	LastAgentUpgradeType *string `json:"lastAgentUpgradeType,omitempty" azure:"ro"`

	// READ-ONLY; The last recovery point Id.
	LastRecoveryPointID *string `json:"lastRecoveryPointId,omitempty" azure:"ro"`

	// READ-ONLY; The last recovery point received time.
	LastRecoveryPointReceived *time.Time `json:"lastRecoveryPointReceived,omitempty" azure:"ro"`

	// READ-ONLY; The last recovery point objective calculated time.
	LastRpoCalculatedTime *time.Time `json:"lastRpoCalculatedTime,omitempty" azure:"ro"`

	// READ-ONLY; The last recovery point objective value.
	LastRpoInSeconds *int64 `json:"lastRpoInSeconds,omitempty" azure:"ro"`

	// READ-ONLY; The multi VM group name.
	MultiVMGroupName *string `json:"multiVmGroupName,omitempty" azure:"ro"`

	// READ-ONLY; The type of the OS on the VM.
	OSType *string `json:"osType,omitempty" azure:"ro"`

	// READ-ONLY; The IP address of the primary network interface.
	PrimaryNicIPAddress *string `json:"primaryNicIpAddress,omitempty" azure:"ro"`

	// READ-ONLY; The process server Id.
	ProcessServerID *string `json:"processServerId,omitempty" azure:"ro"`

	// READ-ONLY; The process server name.
	ProcessServerName *string `json:"processServerName,omitempty" azure:"ro"`

	// READ-ONLY; The processor core count.
	ProcessorCoreCount *int32 `json:"processorCoreCount,omitempty" azure:"ro"`

	// READ-ONLY; The resync processed bytes. This includes sum of total bytes transferred and matched bytes on all selected disks
	// in source VM.
	ResyncProcessedBytes *int64 `json:"resyncProcessedBytes,omitempty" azure:"ro"`

	// READ-ONLY; The resync progress health.
	ResyncProgressHealth *VMReplicationProgressHealth `json:"resyncProgressHealth,omitempty" azure:"ro"`

	// READ-ONLY; The resync progress percentage. This is calculated based on total bytes processed for all disks in the source
	// VM.
	ResyncProgressPercentage *int32 `json:"resyncProgressPercentage,omitempty" azure:"ro"`

	// READ-ONLY; A value indicating whether resync is required.
	ResyncRequired *string `json:"resyncRequired,omitempty" azure:"ro"`

	// READ-ONLY; The resync state.
	ResyncState *ResyncState `json:"resyncState,omitempty" azure:"ro"`

	// READ-ONLY; The resync transferred bytes from source VM to azure for all selected disks on source VM.
	ResyncTransferredBytes *int64 `json:"resyncTransferredBytes,omitempty" azure:"ro"`

	// READ-ONLY; The run-as account Id.
	RunAsAccountID *string `json:"runAsAccountId,omitempty" azure:"ro"`

	// READ-ONLY; The target generation.
	TargetGeneration *string `json:"targetGeneration,omitempty" azure:"ro"`
}

// GetReplicationProviderSpecificSettings implements the ReplicationProviderSpecificSettingsClassification interface for type
// InMageRcmReplicationDetails.
func (i *InMageRcmReplicationDetails) GetReplicationProviderSpecificSettings() *ReplicationProviderSpecificSettings {
	return &ReplicationProviderSpecificSettings{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmReprotectInput - InMageRcm specific provider input.
type InMageRcmReprotectInput struct {
	// REQUIRED; The target datastore name.
	DatastoreName *string `json:"datastoreName,omitempty"`

	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; The log storage account ARM Id.
	LogStorageAccountID *string `json:"logStorageAccountId,omitempty"`

	// REQUIRED; The reprotect agent Id.
	ReprotectAgentID *string `json:"reprotectAgentId,omitempty"`

	// The Policy Id.
	PolicyID *string `json:"policyId,omitempty"`
}

// GetReverseReplicationProviderSpecificInput implements the ReverseReplicationProviderSpecificInputClassification interface
// for type InMageRcmReprotectInput.
func (i *InMageRcmReprotectInput) GetReverseReplicationProviderSpecificInput() *ReverseReplicationProviderSpecificInput {
	return &ReverseReplicationProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmSyncDetails - InMageRcm disk level sync details.
type InMageRcmSyncDetails struct {
	// READ-ONLY; The bytes transferred in last 15 minutes from source VM to azure.
	Last15MinutesTransferredBytes *int64 `json:"last15MinutesTransferredBytes,omitempty" azure:"ro"`

	// READ-ONLY; The time of the last data transfer from source VM to azure.
	LastDataTransferTimeUTC *string `json:"lastDataTransferTimeUtc,omitempty" azure:"ro"`

	// READ-ONLY; The last refresh time.
	LastRefreshTime *string `json:"lastRefreshTime,omitempty" azure:"ro"`

	// READ-ONLY; The total processed bytes. This includes bytes that are transferred from source VM to azure and matched bytes.
	ProcessedBytes *int64 `json:"processedBytes,omitempty" azure:"ro"`

	// READ-ONLY; The progress health.
	ProgressHealth *DiskReplicationProgressHealth `json:"progressHealth,omitempty" azure:"ro"`

	// READ-ONLY; Progress in percentage. Progress percentage is calculated based on processed bytes.
	ProgressPercentage *int32 `json:"progressPercentage,omitempty" azure:"ro"`

	// READ-ONLY; The start time.
	StartTime *string `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The transferred bytes from source VM to azure for the disk.
	TransferredBytes *int64 `json:"transferredBytes,omitempty" azure:"ro"`
}

// InMageRcmTestFailoverInput - InMageRcm provider specific input for test failover.
type InMageRcmTestFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The test network Id.
	NetworkID *string `json:"networkId,omitempty"`

	// The recovery point id to be passed to test failover to a particular recovery point. In case of latest recovery point, null
	// should be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
}

// GetTestFailoverProviderSpecificInput implements the TestFailoverProviderSpecificInputClassification interface for type
// InMageRcmTestFailoverInput.
func (i *InMageRcmTestFailoverInput) GetTestFailoverProviderSpecificInput() *TestFailoverProviderSpecificInput {
	return &TestFailoverProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmUnplannedFailoverInput - InMageRcm provider specific input for unplanned failover.
type InMageRcmUnplannedFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; A value indicating whether VM is to be shutdown.
	PerformShutdown *string `json:"performShutdown,omitempty"`

	// The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should
	// be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
}

// GetUnplannedFailoverProviderSpecificInput implements the UnplannedFailoverProviderSpecificInputClassification interface
// for type InMageRcmUnplannedFailoverInput.
func (i *InMageRcmUnplannedFailoverInput) GetUnplannedFailoverProviderSpecificInput() *UnplannedFailoverProviderSpecificInput {
	return &UnplannedFailoverProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmUpdateApplianceForReplicationProtectedItemInput - InMageRcm provider specific input to update appliance for replication
// protected item.
type InMageRcmUpdateApplianceForReplicationProtectedItemInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The run as account Id.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`
}

// GetUpdateApplianceForReplicationProtectedItemProviderSpecificInput implements the UpdateApplianceForReplicationProtectedItemProviderSpecificInputClassification
// interface for type InMageRcmUpdateApplianceForReplicationProtectedItemInput.
func (i *InMageRcmUpdateApplianceForReplicationProtectedItemInput) GetUpdateApplianceForReplicationProtectedItemProviderSpecificInput() *UpdateApplianceForReplicationProtectedItemProviderSpecificInput {
	return &UpdateApplianceForReplicationProtectedItemProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmUpdateContainerMappingInput - InMageRcm update protection container mapping.
type InMageRcmUpdateContainerMappingInput struct {
	// REQUIRED; A value indicating whether agent auto upgrade has to be enabled.
	EnableAgentAutoUpgrade *string `json:"enableAgentAutoUpgrade,omitempty"`

	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetReplicationProviderSpecificUpdateContainerMappingInput implements the ReplicationProviderSpecificUpdateContainerMappingInputClassification
// interface for type InMageRcmUpdateContainerMappingInput.
func (i *InMageRcmUpdateContainerMappingInput) GetReplicationProviderSpecificUpdateContainerMappingInput() *ReplicationProviderSpecificUpdateContainerMappingInput {
	return &ReplicationProviderSpecificUpdateContainerMappingInput{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmUpdateReplicationProtectedItemInput - InMageRcm provider specific input to update replication protected item.
type InMageRcmUpdateReplicationProtectedItemInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The license type.
	LicenseType *LicenseType `json:"licenseType,omitempty"`

	// The target availability set ARM Id.
	TargetAvailabilitySetID *string `json:"targetAvailabilitySetId,omitempty"`

	// The target availability zone.
	TargetAvailabilityZone *string `json:"targetAvailabilityZone,omitempty"`

	// The target boot diagnostics storage account ARM Id.
	TargetBootDiagnosticsStorageAccountID *string `json:"targetBootDiagnosticsStorageAccountId,omitempty"`

	// The target network ARM Id.
	TargetNetworkID *string `json:"targetNetworkId,omitempty"`

	// The target proximity placement group Id.
	TargetProximityPlacementGroupID *string `json:"targetProximityPlacementGroupId,omitempty"`

	// The target resource group ARM Id.
	TargetResourceGroupID *string `json:"targetResourceGroupId,omitempty"`

	// The target VM name.
	TargetVMName *string `json:"targetVmName,omitempty"`

	// The target VM size.
	TargetVMSize *string `json:"targetVmSize,omitempty"`

	// The test network ARM Id.
	TestNetworkID *string `json:"testNetworkId,omitempty"`

	// The list of NIC details.
	VMNics []*InMageRcmNicInput `json:"vmNics,omitempty"`
}

// GetUpdateReplicationProtectedItemProviderInput implements the UpdateReplicationProtectedItemProviderInputClassification
// interface for type InMageRcmUpdateReplicationProtectedItemInput.
func (i *InMageRcmUpdateReplicationProtectedItemInput) GetUpdateReplicationProtectedItemProviderInput() *UpdateReplicationProtectedItemProviderInput {
	return &UpdateReplicationProtectedItemProviderInput{
		InstanceType: i.InstanceType,
	}
}

// InMageReplicationDetails - InMage provider specific settings.
type InMageReplicationDetails struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The active location of the VM. If the VM is being protected from Azure, this field will take values from { Azure, OnPrem
	// }. If the VM is being protected between two data-centers, this field will be
	// OnPrem always.
	ActiveSiteType *string `json:"activeSiteType,omitempty"`

	// The agent details.
	AgentDetails *InMageAgentDetails `json:"agentDetails,omitempty"`

	// A value indicating the underlying Azure storage account. If the VM is not running in Azure, this value shall be set to
	// null.
	AzureStorageAccountID *string `json:"azureStorageAccountId,omitempty"`

	// The compressed data change rate in MB.
	CompressedDataRateInMB *float64 `json:"compressedDataRateInMB,omitempty"`

	// The collection of Consistency points.
	ConsistencyPoints map[string]*time.Time `json:"consistencyPoints,omitempty"`

	// The datastores of the on-premise machine Value can be list of strings that contain datastore names.
	Datastores []*string `json:"datastores,omitempty"`

	// A value indicating the discovery type of the machine.
	DiscoveryType *string `json:"discoveryType,omitempty"`

	// A value indicating whether any disk is resized for this VM.
	DiskResized *string `json:"diskResized,omitempty"`

	// The source IP address.
	IPAddress *string `json:"ipAddress,omitempty"`

	// The infrastructure VM Id.
	InfrastructureVMID *string `json:"infrastructureVmId,omitempty"`

	// A value indicating whether additional IR stats are available or not.
	IsAdditionalStatsAvailable *bool `json:"isAdditionalStatsAvailable,omitempty"`

	// The last heartbeat received from the source server.
	LastHeartbeat *time.Time `json:"lastHeartbeat,omitempty"`

	// The last RPO calculated time.
	LastRpoCalculatedTime *time.Time `json:"lastRpoCalculatedTime,omitempty"`

	// The last update time received from on-prem components.
	LastUpdateReceivedTime *time.Time `json:"lastUpdateReceivedTime,omitempty"`

	// The master target Id.
	MasterTargetID *string `json:"masterTargetId,omitempty"`

	// The multi vm group Id, if any.
	MultiVMGroupID *string `json:"multiVmGroupId,omitempty"`

	// The multi vm group name, if any.
	MultiVMGroupName *string `json:"multiVmGroupName,omitempty"`

	// A value indicating whether the multi vm sync is enabled or disabled.
	MultiVMSyncStatus *string `json:"multiVmSyncStatus,omitempty"`

	// The OS details.
	OSDetails *OSDiskDetails `json:"osDetails,omitempty"`

	// The OS Version of the protected item.
	OSVersion *string `json:"osVersion,omitempty"`

	// The process server Id.
	ProcessServerID *string `json:"processServerId,omitempty"`

	// The list of protected disks.
	ProtectedDisks []*InMageProtectedDiskDetails `json:"protectedDisks,omitempty"`

	// The protection stage.
	ProtectionStage *string `json:"protectionStage,omitempty"`

	// A value indicating whether the source server requires a restart after update.
	RebootAfterUpdateStatus *string `json:"rebootAfterUpdateStatus,omitempty"`

	// The replica id of the protected item.
	ReplicaID *string `json:"replicaId,omitempty"`

	// The resync details of the machine.
	ResyncDetails *InitialReplicationDetails `json:"resyncDetails,omitempty"`

	// The retention window end time.
	RetentionWindowEnd *time.Time `json:"retentionWindowEnd,omitempty"`

	// The retention window start time.
	RetentionWindowStart *time.Time `json:"retentionWindowStart,omitempty"`

	// The RPO in seconds.
	RpoInSeconds *int64 `json:"rpoInSeconds,omitempty"`

	// The CPU count of the VM on the primary side.
	SourceVMCPUCount *int32 `json:"sourceVmCpuCount,omitempty"`

	// The RAM size of the VM on the primary side.
	SourceVMRAMSizeInMB *int32 `json:"sourceVmRamSizeInMB,omitempty"`

	// The total transferred data in bytes.
	TotalDataTransferred *int64 `json:"totalDataTransferred,omitempty"`

	// The progress health.
	TotalProgressHealth *string `json:"totalProgressHealth,omitempty"`

	// The uncompressed data change rate in MB.
	UncompressedDataRateInMB *float64 `json:"uncompressedDataRateInMB,omitempty"`

	// The vCenter infrastructure Id.
	VCenterInfrastructureID *string `json:"vCenterInfrastructureId,omitempty"`

	// The virtual machine Id.
	VMID *string `json:"vmId,omitempty"`

	// The PE Network details.
	VMNics []*VMNicDetails `json:"vmNics,omitempty"`

	// The protection state for the vm.
	VMProtectionState *string `json:"vmProtectionState,omitempty"`

	// The protection state description for the vm.
	VMProtectionStateDescription *string `json:"vmProtectionStateDescription,omitempty"`

	// The validation errors of the on-premise machine Value can be list of validation errors.
	ValidationErrors []*HealthError `json:"validationErrors,omitempty"`
}

// GetReplicationProviderSpecificSettings implements the ReplicationProviderSpecificSettingsClassification interface for type
// InMageReplicationDetails.
func (i *InMageReplicationDetails) GetReplicationProviderSpecificSettings() *ReplicationProviderSpecificSettings {
	return &ReplicationProviderSpecificSettings{
		InstanceType: i.InstanceType,
	}
}

// InMageReprotectInput - InMageAzureV2 specific provider input.
type InMageReprotectInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; The Master Target Id.
	MasterTargetID *string `json:"masterTargetId,omitempty"`

	// REQUIRED; The Process Server Id.
	ProcessServerID *string `json:"processServerId,omitempty"`

	// REQUIRED; The Policy Id.
	ProfileID *string `json:"profileId,omitempty"`

	// REQUIRED; The retention drive to use on the MT.
	RetentionDrive *string `json:"retentionDrive,omitempty"`

	// The target datastore name.
	DatastoreName *string `json:"datastoreName,omitempty"`

	// The enable disk exclusion input.
	DiskExclusionInput *InMageDiskExclusionInput `json:"diskExclusionInput,omitempty"`

	// The disks to include list.
	DisksToInclude []*string `json:"disksToInclude,omitempty"`

	// The CS account Id.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`
}

// GetReverseReplicationProviderSpecificInput implements the ReverseReplicationProviderSpecificInputClassification interface
// for type InMageReprotectInput.
func (i *InMageReprotectInput) GetReverseReplicationProviderSpecificInput() *ReverseReplicationProviderSpecificInput {
	return &ReverseReplicationProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageTestFailoverInput - Provider specific input for InMage test failover.
type InMageTestFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The recovery point id to be passed to test failover to a particular recovery point. In case of latest recovery point, null
	// should be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`

	// The recovery point type. Values from LatestTime, LatestTag or Custom. In the case of custom, the recovery point provided
	// by RecoveryPointId will be used. In the other two cases, recovery point id will
	// be ignored.
	RecoveryPointType *RecoveryPointType `json:"recoveryPointType,omitempty"`
}

// GetTestFailoverProviderSpecificInput implements the TestFailoverProviderSpecificInputClassification interface for type
// InMageTestFailoverInput.
func (i *InMageTestFailoverInput) GetTestFailoverProviderSpecificInput() *TestFailoverProviderSpecificInput {
	return &TestFailoverProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageUnplannedFailoverInput - Provider specific input for InMage unplanned failover.
type InMageUnplannedFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should
	// be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`

	// The recovery point type. Values from LatestTime, LatestTag or Custom. In the case of custom, the recovery point provided
	// by RecoveryPointId will be used. In the other two cases, recovery point id will
	// be ignored.
	RecoveryPointType *RecoveryPointType `json:"recoveryPointType,omitempty"`
}

// GetUnplannedFailoverProviderSpecificInput implements the UnplannedFailoverProviderSpecificInputClassification interface
// for type InMageUnplannedFailoverInput.
func (i *InMageUnplannedFailoverInput) GetUnplannedFailoverProviderSpecificInput() *UnplannedFailoverProviderSpecificInput {
	return &UnplannedFailoverProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageVolumeExclusionOptions - Guest disk signature based disk exclusion option when doing enable protection of virtual
// machine in InMage provider.
type InMageVolumeExclusionOptions struct {
	// The value indicating whether to exclude multi volume disk or not. If a disk has multiple volumes and one of the volume
	// has label matching with VolumeLabel this disk will be excluded from replication
	// if OnlyExcludeIfSingleVolume is false.
	OnlyExcludeIfSingleVolume *string `json:"onlyExcludeIfSingleVolume,omitempty"`

	// The volume label. The disk having any volume with this label will be excluded from replication.
	VolumeLabel *string `json:"volumeLabel,omitempty"`
}

// InconsistentVMDetails - This class stores the monitoring details for consistency check of inconsistent Protected Entity.
type InconsistentVMDetails struct {
	// The Cloud name.
	CloudName *string `json:"cloudName,omitempty"`

	// The list of details regarding state of the Protected Entity in SRS and On prem.
	Details []*string `json:"details,omitempty"`

	// The list of error ids.
	ErrorIDs []*string `json:"errorIds,omitempty"`

	// The Vm name.
	VMName *string `json:"vmName,omitempty"`
}

// InitialReplicationDetails - Initial replication details.
type InitialReplicationDetails struct {
	// The initial replication progress percentage.
	InitialReplicationProgressPercentage *string `json:"initialReplicationProgressPercentage,omitempty"`

	// Initial replication type.
	InitialReplicationType *string `json:"initialReplicationType,omitempty"`
}

// InlineWorkflowTaskDetails - This class represents the inline workflow task details.
type InlineWorkflowTaskDetails struct {
	// REQUIRED; The type of task details.
	InstanceType *string `json:"instanceType,omitempty"`

	// The child tasks.
	ChildTasks []*ASRTask `json:"childTasks,omitempty"`

	// The list of child workflow ids.
	WorkflowIDs []*string `json:"workflowIds,omitempty"`
}

// GetGroupTaskDetails implements the GroupTaskDetailsClassification interface for type InlineWorkflowTaskDetails.
func (i *InlineWorkflowTaskDetails) GetGroupTaskDetails() *GroupTaskDetails {
	return &GroupTaskDetails{
		InstanceType: i.InstanceType,
		ChildTasks:   i.ChildTasks,
	}
}

// InnerHealthError - Implements InnerHealthError class. HealthError object has a list of InnerHealthErrors as child errors.
// InnerHealthError is used because this will prevent an infinite loop of structures when Hydra
// tries to auto-generate the contract. We are exposing the related health errors as inner health errors and all API consumers
// can utilize this in the same fashion as Exception -> InnerException.
type InnerHealthError struct {
	// Error creation time (UTC).
	CreationTimeUTC *time.Time `json:"creationTimeUtc,omitempty"`

	// Value indicating whether the health error is customer resolvable.
	CustomerResolvability *HealthErrorCustomerResolvability `json:"customerResolvability,omitempty"`

	// ID of the entity.
	EntityID *string `json:"entityId,omitempty"`

	// Category of error.
	ErrorCategory *string `json:"errorCategory,omitempty"`

	// Error code.
	ErrorCode *string `json:"errorCode,omitempty"`

	// The health error unique id.
	ErrorID *string `json:"errorId,omitempty"`

	// Level of error.
	ErrorLevel *string `json:"errorLevel,omitempty"`

	// Error message.
	ErrorMessage *string `json:"errorMessage,omitempty"`

	// Source of error.
	ErrorSource *string `json:"errorSource,omitempty"`

	// Type of error.
	ErrorType *string `json:"errorType,omitempty"`

	// Possible causes of error.
	PossibleCauses *string `json:"possibleCauses,omitempty"`

	// Recommended action to resolve error.
	RecommendedAction *string `json:"recommendedAction,omitempty"`

	// DRA error message.
	RecoveryProviderErrorMessage *string `json:"recoveryProviderErrorMessage,omitempty"`

	// Summary message of the entity.
	SummaryMessage *string `json:"summaryMessage,omitempty"`
}

type InputEndpoint struct {
	EndpointName *string `json:"endpointName,omitempty"`
	PrivatePort  *int32  `json:"privatePort,omitempty"`
	Protocol     *string `json:"protocol,omitempty"`
	PublicPort   *int32  `json:"publicPort,omitempty"`
}

// Job details.
type Job struct {
	// Resource Location
	Location *string `json:"location,omitempty"`

	// The custom data.
	Properties *JobProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// JobCollection - Collection of jobs.
type JobCollection struct {
	// The value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of jobs.
	Value []*Job `json:"value,omitempty"`
}

// JobDetailsClassification provides polymorphic access to related types.
// Call the interface's GetJobDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AsrJobDetails, *ExportJobDetails, *FailoverJobDetails, *JobDetails, *SwitchProtectionJobDetails, *TestFailoverJobDetails
type JobDetailsClassification interface {
	// GetJobDetails returns the JobDetails content of the underlying type.
	GetJobDetails() *JobDetails
}

// JobDetails - Job details based on specific job type.
type JobDetails struct {
	// REQUIRED; Gets the type of job details (see JobDetailsTypes enum for possible values).
	InstanceType *string `json:"instanceType,omitempty"`

	// The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow
	// object details.
	AffectedObjectDetails map[string]*string `json:"affectedObjectDetails,omitempty"`
}

// GetJobDetails implements the JobDetailsClassification interface for type JobDetails.
func (j *JobDetails) GetJobDetails() *JobDetails { return j }

// JobEntity - This class contains the minimal job details required to navigate to the desired drill down.
type JobEntity struct {
	// The job display name.
	JobFriendlyName *string `json:"jobFriendlyName,omitempty"`

	// The job id.
	JobID *string `json:"jobId,omitempty"`

	// The job name. Enum type ScenarioName.
	JobScenarioName *string `json:"jobScenarioName,omitempty"`

	// The workflow affected object type.
	TargetInstanceType *string `json:"targetInstanceType,omitempty"`

	// The object id.
	TargetObjectID *string `json:"targetObjectId,omitempty"`

	// The object name.
	TargetObjectName *string `json:"targetObjectName,omitempty"`
}

// JobErrorDetails - This class contains the error details per object.
type JobErrorDetails struct {
	// The creation time of job error.
	CreationTime *time.Time `json:"creationTime,omitempty"`

	// Error level of error.
	ErrorLevel *string `json:"errorLevel,omitempty"`

	// The Provider error details.
	ProviderErrorDetails *ProviderError `json:"providerErrorDetails,omitempty"`

	// The Service error details.
	ServiceErrorDetails *ServiceError `json:"serviceErrorDetails,omitempty"`

	// The Id of the task.
	TaskID *string `json:"taskId,omitempty"`
}

// JobProperties - Job custom data details.
type JobProperties struct {
	// The activity id.
	ActivityID *string `json:"activityId,omitempty"`

	// The Allowed action the job.
	AllowedActions []*string `json:"allowedActions,omitempty"`

	// The custom job details like test failover job details.
	CustomDetails JobDetailsClassification `json:"customDetails,omitempty"`

	// The end time.
	EndTime *time.Time `json:"endTime,omitempty"`

	// The errors.
	Errors []*JobErrorDetails `json:"errors,omitempty"`

	// The DisplayName.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// The ScenarioName.
	ScenarioName *string `json:"scenarioName,omitempty"`

	// The start time.
	StartTime *time.Time `json:"startTime,omitempty"`

	// The status of the Job. It is one of these values - NotStarted, InProgress, Succeeded, Failed, Cancelled, Suspended or Other.
	State *string `json:"state,omitempty"`

	// The description of the state of the Job. For e.g. - For Succeeded state, description can be Completed, PartiallySucceeded,
	// CompletedWithInformation or Skipped.
	StateDescription *string `json:"stateDescription,omitempty"`

	// The type of the affected object which is of Microsoft.Azure.SiteRecovery.V20151110.AffectedObjectType class.
	TargetInstanceType *string `json:"targetInstanceType,omitempty"`

	// The affected Object Id.
	TargetObjectID *string `json:"targetObjectId,omitempty"`

	// The name of the affected object.
	TargetObjectName *string `json:"targetObjectName,omitempty"`

	// The tasks.
	Tasks []*ASRTask `json:"tasks,omitempty"`
}

// JobQueryParameter - Query parameter to enumerate jobs.
type JobQueryParameter struct {
	// The type of objects.
	AffectedObjectTypes *string `json:"affectedObjectTypes,omitempty"`

	// Date time to get jobs upto.
	EndTime *string `json:"endTime,omitempty"`

	// The Id of the fabric to search jobs under.
	FabricID *string `json:"fabricId,omitempty"`

	// The job Name.
	JobName *string `json:"jobName,omitempty"`

	// The output type of the jobs.
	JobOutputType *ExportJobOutputSerializationType `json:"jobOutputType,omitempty"`

	// The states of the job to be filtered can be in.
	JobStatus *string `json:"jobStatus,omitempty"`

	// Date time to get jobs from.
	StartTime *string `json:"startTime,omitempty"`

	// The timezone offset for the location of the request (in minutes).
	TimezoneOffset *float64 `json:"timezoneOffset,omitempty"`
}

// JobStatusEventDetails - Model class for event details of a job status event.
type JobStatusEventDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// AffectedObjectType for the event.
	AffectedObjectType *string `json:"affectedObjectType,omitempty"`

	// JobName for the Event.
	JobFriendlyName *string `json:"jobFriendlyName,omitempty"`

	// Job arm id for the event.
	JobID *string `json:"jobId,omitempty"`

	// JobStatus for the Event.
	JobStatus *string `json:"jobStatus,omitempty"`
}

// GetEventSpecificDetails implements the EventSpecificDetailsClassification interface for type JobStatusEventDetails.
func (j *JobStatusEventDetails) GetEventSpecificDetails() *EventSpecificDetails {
	return &EventSpecificDetails{
		InstanceType: j.InstanceType,
	}
}

// JobTaskDetailsClassification provides polymorphic access to related types.
// Call the interface's GetJobTaskDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *FabricReplicationGroupTaskDetails, *JobTaskDetails, *VirtualMachineTaskDetails
type JobTaskDetailsClassification interface {
	TaskTypeDetailsClassification
	// GetJobTaskDetails returns the JobTaskDetails content of the underlying type.
	GetJobTaskDetails() *JobTaskDetails
}

// JobTaskDetails - This class represents a task which is actually a workflow so that one can navigate to its individual drill
// down.
type JobTaskDetails struct {
	// REQUIRED; The type of task details.
	InstanceType *string `json:"instanceType,omitempty"`

	// The job entity.
	JobTask *JobEntity `json:"jobTask,omitempty"`
}

// GetJobTaskDetails implements the JobTaskDetailsClassification interface for type JobTaskDetails.
func (j *JobTaskDetails) GetJobTaskDetails() *JobTaskDetails { return j }

// GetTaskTypeDetails implements the TaskTypeDetailsClassification interface for type JobTaskDetails.
func (j *JobTaskDetails) GetTaskTypeDetails() *TaskTypeDetails {
	return &TaskTypeDetails{
		InstanceType: j.InstanceType,
	}
}

// KeyEncryptionKeyInfo - Key Encryption Key (KEK) information.
type KeyEncryptionKeyInfo struct {
	// The key URL / identifier.
	KeyIdentifier *string `json:"keyIdentifier,omitempty"`

	// The KeyVault resource ARM Id for key.
	KeyVaultResourceArmID *string `json:"keyVaultResourceArmId,omitempty"`
}

// LogicalNetwork - Logical network data model.
type LogicalNetwork struct {
	// Resource Location
	Location *string `json:"location,omitempty"`

	// The Logical Network Properties.
	Properties *LogicalNetworkProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LogicalNetworkCollection - List of logical networks.
type LogicalNetworkCollection struct {
	// The value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// The Logical Networks list details.
	Value []*LogicalNetwork `json:"value,omitempty"`
}

// LogicalNetworkProperties - Logical Network Properties.
type LogicalNetworkProperties struct {
	// The Friendly Name.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// A value indicating whether logical network definitions are isolated.
	LogicalNetworkDefinitionsStatus *string `json:"logicalNetworkDefinitionsStatus,omitempty"`

	// A value indicating whether logical network is used as private test network by test failover.
	LogicalNetworkUsage *string `json:"logicalNetworkUsage,omitempty"`

	// A value indicating whether Network Virtualization is enabled for the logical network.
	NetworkVirtualizationStatus *string `json:"networkVirtualizationStatus,omitempty"`
}

// ManualActionTaskDetails - This class represents the manual action task details.
type ManualActionTaskDetails struct {
	// REQUIRED; The type of task details.
	InstanceType *string `json:"instanceType,omitempty"`

	// The instructions.
	Instructions *string `json:"instructions,omitempty"`

	// The name.
	Name *string `json:"name,omitempty"`

	// The observation.
	Observation *string `json:"observation,omitempty"`
}

// GetTaskTypeDetails implements the TaskTypeDetailsClassification interface for type ManualActionTaskDetails.
func (m *ManualActionTaskDetails) GetTaskTypeDetails() *TaskTypeDetails {
	return &TaskTypeDetails{
		InstanceType: m.InstanceType,
	}
}

// MarsAgentDetails - Mars agent details.
type MarsAgentDetails struct {
	// READ-ONLY; The Mars agent Bios Id.
	BiosID *string `json:"biosId,omitempty" azure:"ro"`

	// READ-ONLY; The fabric object Id.
	FabricObjectID *string `json:"fabricObjectId,omitempty" azure:"ro"`

	// READ-ONLY; The Mars agent Fqdn.
	Fqdn *string `json:"fqdn,omitempty" azure:"ro"`

	// READ-ONLY; The health of the Mars agent.
	Health *ProtectionHealth `json:"health,omitempty" azure:"ro"`

	// READ-ONLY; The health errors.
	HealthErrors []*HealthError `json:"healthErrors,omitempty" azure:"ro"`

	// READ-ONLY; The Mars agent Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The last heartbeat received from the Mars agent.
	LastHeartbeatUTC *time.Time `json:"lastHeartbeatUtc,omitempty" azure:"ro"`

	// READ-ONLY; The Mars agent name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The version.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// MasterTargetServer - Details of a Master Target Server.
type MasterTargetServer struct {
	// Agent expiry date.
	AgentExpiryDate *time.Time `json:"agentExpiryDate,omitempty"`

	// The version of the scout component on the server.
	AgentVersion *string `json:"agentVersion,omitempty"`

	// Agent version details.
	AgentVersionDetails *VersionDetails `json:"agentVersionDetails,omitempty"`

	// The list of data stores in the fabric.
	DataStores []*DataStore `json:"dataStores,omitempty"`

	// Disk count of the master target.
	DiskCount *int32 `json:"diskCount,omitempty"`

	// Health errors.
	HealthErrors []*HealthError `json:"healthErrors,omitempty"`

	// The server Id.
	ID *string `json:"id,omitempty"`

	// The IP address of the server.
	IPAddress *string `json:"ipAddress,omitempty"`

	// The last heartbeat received from the server.
	LastHeartbeat *time.Time `json:"lastHeartbeat,omitempty"`

	// MARS agent expiry date.
	MarsAgentExpiryDate *time.Time `json:"marsAgentExpiryDate,omitempty"`

	// MARS agent version.
	MarsAgentVersion *string `json:"marsAgentVersion,omitempty"`

	// Mars agent version details.
	MarsAgentVersionDetails *VersionDetails `json:"marsAgentVersionDetails,omitempty"`

	// The server name.
	Name *string `json:"name,omitempty"`

	// The OS type of the server.
	OSType *string `json:"osType,omitempty"`

	// OS Version of the master target.
	OSVersion *string `json:"osVersion,omitempty"`

	// The retention volumes of Master target Server.
	RetentionVolumes []*RetentionVolume `json:"retentionVolumes,omitempty"`

	// Validation errors.
	ValidationErrors []*HealthError `json:"validationErrors,omitempty"`

	// Version status.
	VersionStatus *string `json:"versionStatus,omitempty"`
}

// MigrateInput - Input for migrate.
type MigrateInput struct {
	// REQUIRED; Migrate input properties.
	Properties *MigrateInputProperties `json:"properties,omitempty"`
}

// MigrateInputProperties - Migrate input properties.
type MigrateInputProperties struct {
	// REQUIRED; The provider specific details.
	ProviderSpecificDetails MigrateProviderSpecificInputClassification `json:"providerSpecificDetails,omitempty"`
}

// MigrateProviderSpecificInputClassification provides polymorphic access to related types.
// Call the interface's GetMigrateProviderSpecificInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *MigrateProviderSpecificInput, *VMwareCbtMigrateInput
type MigrateProviderSpecificInputClassification interface {
	// GetMigrateProviderSpecificInput returns the MigrateProviderSpecificInput content of the underlying type.
	GetMigrateProviderSpecificInput() *MigrateProviderSpecificInput
}

// MigrateProviderSpecificInput - Migrate provider specific input.
type MigrateProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetMigrateProviderSpecificInput implements the MigrateProviderSpecificInputClassification interface for type MigrateProviderSpecificInput.
func (m *MigrateProviderSpecificInput) GetMigrateProviderSpecificInput() *MigrateProviderSpecificInput {
	return m
}

// MigrationItem - Migration item.
type MigrationItem struct {
	// Resource Location
	Location *string `json:"location,omitempty"`

	// The migration item properties.
	Properties *MigrationItemProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MigrationItemCollection - Migration item collection.
type MigrationItemCollection struct {
	// The value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of migration items.
	Value []*MigrationItem `json:"value,omitempty"`
}

// MigrationItemProperties - Migration item properties.
type MigrationItemProperties struct {
	// The migration provider custom settings.
	ProviderSpecificDetails MigrationProviderSpecificSettingsClassification `json:"providerSpecificDetails,omitempty"`

	// READ-ONLY; The allowed operations on the migration item based on the current migration state of the item.
	AllowedOperations []*MigrationItemOperation `json:"allowedOperations,omitempty" azure:"ro"`

	// READ-ONLY; The current job details.
	CurrentJob *CurrentJobDetails `json:"currentJob,omitempty" azure:"ro"`

	// READ-ONLY; The correlation Id for events associated with this migration item.
	EventCorrelationID *string `json:"eventCorrelationId,omitempty" azure:"ro"`

	// READ-ONLY; The consolidated health.
	Health *ProtectionHealth `json:"health,omitempty" azure:"ro"`

	// READ-ONLY; The list of health errors.
	HealthErrors []*HealthError `json:"healthErrors,omitempty" azure:"ro"`

	// READ-ONLY; The status of the last test migration.
	LastTestMigrationStatus *string `json:"lastTestMigrationStatus,omitempty" azure:"ro"`

	// READ-ONLY; The last test migration time.
	LastTestMigrationTime *time.Time `json:"lastTestMigrationTime,omitempty" azure:"ro"`

	// READ-ONLY; The on-premise virtual machine name.
	MachineName *string `json:"machineName,omitempty" azure:"ro"`

	// READ-ONLY; The migration status.
	MigrationState *MigrationState `json:"migrationState,omitempty" azure:"ro"`

	// READ-ONLY; The migration state description.
	MigrationStateDescription *string `json:"migrationStateDescription,omitempty" azure:"ro"`

	// READ-ONLY; The name of policy governing this item.
	PolicyFriendlyName *string `json:"policyFriendlyName,omitempty" azure:"ro"`

	// READ-ONLY; The ARM Id of policy governing this item.
	PolicyID *string `json:"policyId,omitempty" azure:"ro"`

	// READ-ONLY; The test migrate state.
	TestMigrateState *TestMigrationState `json:"testMigrateState,omitempty" azure:"ro"`

	// READ-ONLY; The test migrate state description.
	TestMigrateStateDescription *string `json:"testMigrateStateDescription,omitempty" azure:"ro"`
}

// MigrationItemsQueryParameter - Query parameter to enumerate migration items.
type MigrationItemsQueryParameter struct {
	// The replication provider type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The source container name filter.
	SourceContainerName *string `json:"sourceContainerName,omitempty"`

	// The source fabric name filter.
	SourceFabricName *string `json:"sourceFabricName,omitempty"`
}

// MigrationProviderSpecificSettingsClassification provides polymorphic access to related types.
// Call the interface's GetMigrationProviderSpecificSettings() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *MigrationProviderSpecificSettings, *VMwareCbtMigrationDetails
type MigrationProviderSpecificSettingsClassification interface {
	// GetMigrationProviderSpecificSettings returns the MigrationProviderSpecificSettings content of the underlying type.
	GetMigrationProviderSpecificSettings() *MigrationProviderSpecificSettings
}

// MigrationProviderSpecificSettings - Migration provider specific settings.
type MigrationProviderSpecificSettings struct {
	// REQUIRED; Gets the instance type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetMigrationProviderSpecificSettings implements the MigrationProviderSpecificSettingsClassification interface for type
// MigrationProviderSpecificSettings.
func (m *MigrationProviderSpecificSettings) GetMigrationProviderSpecificSettings() *MigrationProviderSpecificSettings {
	return m
}

// MigrationRecoveryPoint - Recovery point for a migration item.
type MigrationRecoveryPoint struct {
	// Resource Location
	Location *string `json:"location,omitempty"`

	// Recovery point properties.
	Properties *MigrationRecoveryPointProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MigrationRecoveryPointCollection - Collection of migration recovery points.
type MigrationRecoveryPointCollection struct {
	// The value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// The migration recovery point details.
	Value []*MigrationRecoveryPoint `json:"value,omitempty"`
}

// MigrationRecoveryPointProperties - Migration item recovery point properties.
type MigrationRecoveryPointProperties struct {
	// READ-ONLY; The recovery point time.
	RecoveryPointTime *time.Time `json:"recoveryPointTime,omitempty" azure:"ro"`

	// READ-ONLY; The recovery point type.
	RecoveryPointType *MigrationRecoveryPointType `json:"recoveryPointType,omitempty" azure:"ro"`
}

// MigrationRecoveryPointsClientGetOptions contains the optional parameters for the MigrationRecoveryPointsClient.Get method.
type MigrationRecoveryPointsClientGetOptions struct {
	// placeholder for future optional parameters
}

// MigrationRecoveryPointsClientListByReplicationMigrationItemsOptions contains the optional parameters for the MigrationRecoveryPointsClient.ListByReplicationMigrationItems
// method.
type MigrationRecoveryPointsClientListByReplicationMigrationItemsOptions struct {
	// placeholder for future optional parameters
}

// MobilityServiceUpdate - The Mobility Service update details.
type MobilityServiceUpdate struct {
	// The OS type.
	OSType *string `json:"osType,omitempty"`

	// The reboot status of the update - whether it is required or not.
	RebootStatus *string `json:"rebootStatus,omitempty"`

	// The version of the latest update.
	Version *string `json:"version,omitempty"`
}

// Network model.
type Network struct {
	// Resource Location
	Location *string `json:"location,omitempty"`

	// The Network Properties.
	Properties *NetworkProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NetworkCollection - List of networks.
type NetworkCollection struct {
	// The value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// The Networks list details.
	Value []*Network `json:"value,omitempty"`
}

// NetworkMapping - Network Mapping model. Ideally it should have been possible to inherit this class from prev version in
// InheritedModels as long as there is no difference in structure or method signature. Since there
// were no base Models for certain fields and methods viz NetworkMappingProperties and Load with required return type, the
// class has been introduced in its entirety with references to base models to
// facilitate extensions in subsequent versions.
type NetworkMapping struct {
	// Resource Location
	Location *string `json:"location,omitempty"`

	// The Network Mapping Properties.
	Properties *NetworkMappingProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NetworkMappingCollection - List of network mappings. As with NetworkMapping, it should be possible to reuse a prev version
// of this class. It doesn't seem likely this class could be anything more than a slightly bespoke
// collection of NetworkMapping. Hence it makes sense to override Load with Base.NetworkMapping instead of existing CurrentVersion.NetworkMapping.
type NetworkMappingCollection struct {
	// The value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// The Network Mappings list.
	Value []*NetworkMapping `json:"value,omitempty"`
}

// NetworkMappingFabricSpecificSettingsClassification provides polymorphic access to related types.
// Call the interface's GetNetworkMappingFabricSpecificSettings() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureToAzureNetworkMappingSettings, *NetworkMappingFabricSpecificSettings, *VmmToAzureNetworkMappingSettings, *VmmToVmmNetworkMappingSettings
type NetworkMappingFabricSpecificSettingsClassification interface {
	// GetNetworkMappingFabricSpecificSettings returns the NetworkMappingFabricSpecificSettings content of the underlying type.
	GetNetworkMappingFabricSpecificSettings() *NetworkMappingFabricSpecificSettings
}

// NetworkMappingFabricSpecificSettings - Network Mapping fabric specific settings.
type NetworkMappingFabricSpecificSettings struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetNetworkMappingFabricSpecificSettings implements the NetworkMappingFabricSpecificSettingsClassification interface for
// type NetworkMappingFabricSpecificSettings.
func (n *NetworkMappingFabricSpecificSettings) GetNetworkMappingFabricSpecificSettings() *NetworkMappingFabricSpecificSettings {
	return n
}

// NetworkMappingProperties - Network Mapping Properties.
type NetworkMappingProperties struct {
	// The fabric specific settings.
	FabricSpecificSettings NetworkMappingFabricSpecificSettingsClassification `json:"fabricSpecificSettings,omitempty"`

	// The primary fabric friendly name.
	PrimaryFabricFriendlyName *string `json:"primaryFabricFriendlyName,omitempty"`

	// The primary network friendly name.
	PrimaryNetworkFriendlyName *string `json:"primaryNetworkFriendlyName,omitempty"`

	// The primary network id for network mapping.
	PrimaryNetworkID *string `json:"primaryNetworkId,omitempty"`

	// The recovery fabric ARM id.
	RecoveryFabricArmID *string `json:"recoveryFabricArmId,omitempty"`

	// The recovery fabric friendly name.
	RecoveryFabricFriendlyName *string `json:"recoveryFabricFriendlyName,omitempty"`

	// The recovery network friendly name.
	RecoveryNetworkFriendlyName *string `json:"recoveryNetworkFriendlyName,omitempty"`

	// The recovery network id for network mapping.
	RecoveryNetworkID *string `json:"recoveryNetworkId,omitempty"`

	// The pairing state for network mapping.
	State *string `json:"state,omitempty"`
}

// NetworkProperties - Network Properties.
type NetworkProperties struct {
	// The Fabric Type.
	FabricType *string `json:"fabricType,omitempty"`

	// The Friendly Name.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// The Network Type.
	NetworkType *string `json:"networkType,omitempty"`

	// The List of subnets.
	Subnets []*Subnet `json:"subnets,omitempty"`
}

// NewProtectionProfile - New Protection profile input.
type NewProtectionProfile struct {
	// REQUIRED; A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'.
	MultiVMSyncStatus *SetMultiVMSyncStatus `json:"multiVmSyncStatus,omitempty"`

	// REQUIRED; The protection profile input.
	PolicyName *string `json:"policyName,omitempty"`

	// REQUIRED; The class type.
	ResourceType *string `json:"resourceType,omitempty"`

	// The app consistent snapshot frequency (in minutes).
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`

	// The crash consistent snapshot frequency (in minutes).
	CrashConsistentFrequencyInMinutes *int32 `json:"crashConsistentFrequencyInMinutes,omitempty"`

	// The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32 `json:"recoveryPointHistory,omitempty"`
}

// GetProtectionProfileCustomDetails implements the ProtectionProfileCustomDetailsClassification interface for type NewProtectionProfile.
func (n *NewProtectionProfile) GetProtectionProfileCustomDetails() *ProtectionProfileCustomDetails {
	return &ProtectionProfileCustomDetails{
		ResourceType: n.ResourceType,
	}
}

// NewRecoveryVirtualNetwork - Recovery virtual network input to create new virtual network from given source network.
type NewRecoveryVirtualNetwork struct {
	// REQUIRED; The class type.
	ResourceType *string `json:"resourceType,omitempty"`

	// The recovery virtual network name.
	RecoveryVirtualNetworkName *string `json:"recoveryVirtualNetworkName,omitempty"`

	// The name of the resource group to be used to create the recovery virtual network. If absent, target network would be created
	// in the same resource group as target VM.
	RecoveryVirtualNetworkResourceGroupName *string `json:"recoveryVirtualNetworkResourceGroupName,omitempty"`
}

// GetRecoveryVirtualNetworkCustomDetails implements the RecoveryVirtualNetworkCustomDetailsClassification interface for type
// NewRecoveryVirtualNetwork.
func (n *NewRecoveryVirtualNetwork) GetRecoveryVirtualNetworkCustomDetails() *RecoveryVirtualNetworkCustomDetails {
	return &RecoveryVirtualNetworkCustomDetails{
		ResourceType: n.ResourceType,
	}
}

// OSDetails - Disk Details.
type OSDetails struct {
	// The OSEdition.
	OSEdition *string `json:"osEdition,omitempty"`

	// The OS Major Version.
	OSMajorVersion *string `json:"oSMajorVersion,omitempty"`

	// The OS Minor Version.
	OSMinorVersion *string `json:"oSMinorVersion,omitempty"`

	// VM Disk details.
	OSType *string `json:"osType,omitempty"`

	// The OS Version.
	OSVersion *string `json:"oSVersion,omitempty"`

	// Product type.
	ProductType *string `json:"productType,omitempty"`
}

// OSDiskDetails - Details of the OS Disk.
type OSDiskDetails struct {
	// The type of the OS on the VM.
	OSType *string `json:"osType,omitempty"`

	// The id of the disk containing the OS.
	OSVhdID *string `json:"osVhdId,omitempty"`

	// The OS disk VHD name.
	VhdName *string `json:"vhdName,omitempty"`
}

// OSVersionWrapper - Wrapper model for OSVersion to include version and service pack info.
type OSVersionWrapper struct {
	// The service pack.
	ServicePack *string `json:"servicePack,omitempty"`

	// The version.
	Version *string `json:"version,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OperationsDiscovery - Operations discovery class.
type OperationsDiscovery struct {
	// Object type.
	Display *Display `json:"display,omitempty"`

	// Name of the API. The name of the operation being performed on this particular object. It should match the action name that
	// appears in RBAC / the event service. Examples of operations include: *
	// Microsoft.Compute/virtualMachine/capture/action * Microsoft.Compute/virtualMachine/restart/action * Microsoft.Compute/virtualMachine/write
	// * Microsoft.Compute/virtualMachine/read *
	// Microsoft.Compute/virtualMachine/delete Each action should include, in order: (1) Resource Provider Namespace (2) Type
	// hierarchy for which the action applies (e.g. server/databases for a SQL Azure
	// database) (3) Read, Write, Action or Delete indicating which type applies. If it is a PUT/PATCH on a collection or named
	// value, Write should be used. If it is a GET, Read should be used. If it is a
	// DELETE, Delete should be used. If it is a POST, Action should be used. As a note: all resource providers would need to
	// include the "{Resource Provider Namespace}/register/action" operation in their
	// response. This API is used to register for their service, and should include details about the operation (e.g. a localized
	// name for the resource provider + any special considerations like PII
	// release).
	Name *string `json:"name,omitempty"`

	// Origin. The intended executor of the operation; governs the display of the operation in the RBAC UX and the audit logs
	// UX. Default value is "user,system".
	Origin *string `json:"origin,omitempty"`

	// Properties. Reserved for future use.
	Properties interface{} `json:"properties,omitempty"`
}

// OperationsDiscoveryCollection - Collection of ClientDiscovery details.
type OperationsDiscoveryCollection struct {
	// The value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// The ClientDiscovery details.
	Value []*OperationsDiscovery `json:"value,omitempty"`
}

// PlannedFailoverInput - Input definition for planned failover.
type PlannedFailoverInput struct {
	// Planned failover input properties.
	Properties *PlannedFailoverInputProperties `json:"properties,omitempty"`
}

// PlannedFailoverInputProperties - Input definition for planned failover input properties.
type PlannedFailoverInputProperties struct {
	// Failover direction.
	FailoverDirection *string `json:"failoverDirection,omitempty"`

	// Provider specific settings.
	ProviderSpecificDetails PlannedFailoverProviderSpecificFailoverInputClassification `json:"providerSpecificDetails,omitempty"`
}

// PlannedFailoverProviderSpecificFailoverInputClassification provides polymorphic access to related types.
// Call the interface's GetPlannedFailoverProviderSpecificFailoverInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *HyperVReplicaAzureFailbackProviderInput, *HyperVReplicaAzurePlannedFailoverProviderInput, *InMageRcmFailbackPlannedFailoverProviderInput,
// - *PlannedFailoverProviderSpecificFailoverInput
type PlannedFailoverProviderSpecificFailoverInputClassification interface {
	// GetPlannedFailoverProviderSpecificFailoverInput returns the PlannedFailoverProviderSpecificFailoverInput content of the underlying type.
	GetPlannedFailoverProviderSpecificFailoverInput() *PlannedFailoverProviderSpecificFailoverInput
}

// PlannedFailoverProviderSpecificFailoverInput - Provider specific failover input.
type PlannedFailoverProviderSpecificFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetPlannedFailoverProviderSpecificFailoverInput implements the PlannedFailoverProviderSpecificFailoverInputClassification
// interface for type PlannedFailoverProviderSpecificFailoverInput.
func (p *PlannedFailoverProviderSpecificFailoverInput) GetPlannedFailoverProviderSpecificFailoverInput() *PlannedFailoverProviderSpecificFailoverInput {
	return p
}

// Policy - Protection profile details.
type Policy struct {
	// Resource Location
	Location *string `json:"location,omitempty"`

	// The custom data.
	Properties *PolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PolicyCollection - Protection Profile Collection details.
type PolicyCollection struct {
	// The value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// The policy details.
	Value []*Policy `json:"value,omitempty"`
}

// PolicyProperties - Protection profile custom data details.
type PolicyProperties struct {
	// The FriendlyName.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// The ReplicationChannelSetting.
	ProviderSpecificDetails PolicyProviderSpecificDetailsClassification `json:"providerSpecificDetails,omitempty"`
}

// PolicyProviderSpecificDetailsClassification provides polymorphic access to related types.
// Call the interface's GetPolicyProviderSpecificDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *A2APolicyDetails, *HyperVReplicaAzurePolicyDetails, *HyperVReplicaBasePolicyDetails, *HyperVReplicaBluePolicyDetails,
// - *HyperVReplicaPolicyDetails, *InMageAzureV2PolicyDetails, *InMageBasePolicyDetails, *InMagePolicyDetails, *InMageRcmFailbackPolicyDetails,
// - *InMageRcmPolicyDetails, *PolicyProviderSpecificDetails, *VmwareCbtPolicyDetails
type PolicyProviderSpecificDetailsClassification interface {
	// GetPolicyProviderSpecificDetails returns the PolicyProviderSpecificDetails content of the underlying type.
	GetPolicyProviderSpecificDetails() *PolicyProviderSpecificDetails
}

// PolicyProviderSpecificDetails - Base class for Provider specific details for policies.
type PolicyProviderSpecificDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetPolicyProviderSpecificDetails implements the PolicyProviderSpecificDetailsClassification interface for type PolicyProviderSpecificDetails.
func (p *PolicyProviderSpecificDetails) GetPolicyProviderSpecificDetails() *PolicyProviderSpecificDetails {
	return p
}

// PolicyProviderSpecificInputClassification provides polymorphic access to related types.
// Call the interface's GetPolicyProviderSpecificInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *A2ACrossClusterMigrationPolicyCreationInput, *A2APolicyCreationInput, *HyperVReplicaAzurePolicyInput, *HyperVReplicaBluePolicyInput,
// - *HyperVReplicaPolicyInput, *InMageAzureV2PolicyInput, *InMagePolicyInput, *InMageRcmFailbackPolicyCreationInput, *InMageRcmPolicyCreationInput,
// - *PolicyProviderSpecificInput, *VMwareCbtPolicyCreationInput
type PolicyProviderSpecificInputClassification interface {
	// GetPolicyProviderSpecificInput returns the PolicyProviderSpecificInput content of the underlying type.
	GetPolicyProviderSpecificInput() *PolicyProviderSpecificInput
}

// PolicyProviderSpecificInput - Base class for provider specific input.
type PolicyProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetPolicyProviderSpecificInput implements the PolicyProviderSpecificInputClassification interface for type PolicyProviderSpecificInput.
func (p *PolicyProviderSpecificInput) GetPolicyProviderSpecificInput() *PolicyProviderSpecificInput {
	return p
}

// ProcessServer - Details of the Process Server.
type ProcessServer struct {
	// Agent expiry date.
	AgentExpiryDate *time.Time `json:"agentExpiryDate,omitempty"`

	// The version of the scout component on the server.
	AgentVersion *string `json:"agentVersion,omitempty"`

	// The agent version details.
	AgentVersionDetails *VersionDetails `json:"agentVersionDetails,omitempty"`

	// The available memory.
	AvailableMemoryInBytes *int64 `json:"availableMemoryInBytes,omitempty"`

	// The available space.
	AvailableSpaceInBytes *int64 `json:"availableSpaceInBytes,omitempty"`

	// The percentage of the CPU load.
	CPULoad *string `json:"cpuLoad,omitempty"`

	// The CPU load status.
	CPULoadStatus *string `json:"cpuLoadStatus,omitempty"`

	// The Process Server's friendly name.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Health errors.
	HealthErrors []*HealthError `json:"healthErrors,omitempty"`

	// The agent generated Id.
	HostID *string `json:"hostId,omitempty"`

	// The Process Server Id.
	ID *string `json:"id,omitempty"`

	// The IP address of the server.
	IPAddress *string `json:"ipAddress,omitempty"`

	// The last heartbeat received from the server.
	LastHeartbeat *time.Time `json:"lastHeartbeat,omitempty"`

	// The servers configured with this PS.
	MachineCount *string `json:"machineCount,omitempty"`

	// The memory usage status.
	MemoryUsageStatus *string `json:"memoryUsageStatus,omitempty"`

	// The list of the mobility service updates available on the Process Server.
	MobilityServiceUpdates []*MobilityServiceUpdate `json:"mobilityServiceUpdates,omitempty"`

	// The OS type of the server.
	OSType *string `json:"osType,omitempty"`

	// OS Version of the process server. Note: This will get populated if user has CS version greater than 9.12.0.0.
	OSVersion *string `json:"osVersion,omitempty"`

	// The PS service status.
	PsServiceStatus *string `json:"psServiceStatus,omitempty"`

	// The number of replication pairs configured in this PS.
	ReplicationPairCount *string `json:"replicationPairCount,omitempty"`

	// The PS SSL cert expiry date.
	SSLCertExpiryDate *time.Time `json:"sslCertExpiryDate,omitempty"`

	// CS SSL cert expiry date.
	SSLCertExpiryRemainingDays *int32 `json:"sslCertExpiryRemainingDays,omitempty"`

	// The space usage status.
	SpaceUsageStatus *string `json:"spaceUsageStatus,omitempty"`

	// The percentage of the system load.
	SystemLoad *string `json:"systemLoad,omitempty"`

	// The system load status.
	SystemLoadStatus *string `json:"systemLoadStatus,omitempty"`

	// The total memory.
	TotalMemoryInBytes *int64 `json:"totalMemoryInBytes,omitempty"`

	// The total space.
	TotalSpaceInBytes *int64 `json:"totalSpaceInBytes,omitempty"`

	// Version status.
	VersionStatus *string `json:"versionStatus,omitempty"`

	// READ-ONLY; The health of Process Server.
	Health *ProtectionHealth `json:"health,omitempty" azure:"ro"`

	// READ-ONLY; The MARS communication status.
	MarsCommunicationStatus *string `json:"marsCommunicationStatus,omitempty" azure:"ro"`

	// READ-ONLY; The MARS registration status.
	MarsRegistrationStatus *string `json:"marsRegistrationStatus,omitempty" azure:"ro"`

	// READ-ONLY; The process server stats refresh time.
	PsStatsRefreshTime *time.Time `json:"psStatsRefreshTime,omitempty" azure:"ro"`

	// READ-ONLY; The throughput in bytes.
	ThroughputInBytes *int64 `json:"throughputInBytes,omitempty" azure:"ro"`

	// READ-ONLY; The throughput in MBps.
	ThroughputInMBps *int64 `json:"throughputInMBps,omitempty" azure:"ro"`

	// READ-ONLY; The throughput status.
	ThroughputStatus *string `json:"throughputStatus,omitempty" azure:"ro"`

	// READ-ONLY; The uploading pending data in bytes.
	ThroughputUploadPendingDataInBytes *int64 `json:"throughputUploadPendingDataInBytes,omitempty" azure:"ro"`
}

// ProcessServerDetails - Process server details.
type ProcessServerDetails struct {
	// READ-ONLY; The available memory.
	AvailableMemoryInBytes *int64 `json:"availableMemoryInBytes,omitempty" azure:"ro"`

	// READ-ONLY; The available disk space.
	AvailableSpaceInBytes *int64 `json:"availableSpaceInBytes,omitempty" azure:"ro"`

	// READ-ONLY; The process server Bios Id.
	BiosID *string `json:"biosId,omitempty" azure:"ro"`

	// READ-ONLY; The disk usage status.
	DiskUsageStatus *RcmComponentStatus `json:"diskUsageStatus,omitempty" azure:"ro"`

	// READ-ONLY; The fabric object Id.
	FabricObjectID *string `json:"fabricObjectId,omitempty" azure:"ro"`

	// READ-ONLY; The process server Fqdn.
	Fqdn *string `json:"fqdn,omitempty" azure:"ro"`

	// READ-ONLY; The free disk space percentage.
	FreeSpacePercentage *float64 `json:"freeSpacePercentage,omitempty" azure:"ro"`

	// READ-ONLY; The health of the process server.
	Health *ProtectionHealth `json:"health,omitempty" azure:"ro"`

	// READ-ONLY; The health errors.
	HealthErrors []*HealthError `json:"healthErrors,omitempty" azure:"ro"`

	// READ-ONLY; The historic health of the process server based on the health in last 24 hours.
	HistoricHealth *ProtectionHealth `json:"historicHealth,omitempty" azure:"ro"`

	// READ-ONLY; The process server Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The list of IP addresses for communicating with the RCM component.
	IPAddresses []*string `json:"ipAddresses,omitempty" azure:"ro"`

	// READ-ONLY; The last heartbeat received from the process server.
	LastHeartbeatUTC *time.Time `json:"lastHeartbeatUtc,omitempty" azure:"ro"`

	// READ-ONLY; The memory usage percentage.
	MemoryUsagePercentage *float64 `json:"memoryUsagePercentage,omitempty" azure:"ro"`

	// READ-ONLY; The memory usage status.
	MemoryUsageStatus *RcmComponentStatus `json:"memoryUsageStatus,omitempty" azure:"ro"`

	// READ-ONLY; The process server name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The processor usage percentage.
	ProcessorUsagePercentage *float64 `json:"processorUsagePercentage,omitempty" azure:"ro"`

	// READ-ONLY; The processor usage status.
	ProcessorUsageStatus *RcmComponentStatus `json:"processorUsageStatus,omitempty" azure:"ro"`

	// READ-ONLY; The protected item count.
	ProtectedItemCount *int32 `json:"protectedItemCount,omitempty" azure:"ro"`

	// READ-ONLY; The system load.
	SystemLoad *int64 `json:"systemLoad,omitempty" azure:"ro"`

	// READ-ONLY; The system load status.
	SystemLoadStatus *RcmComponentStatus `json:"systemLoadStatus,omitempty" azure:"ro"`

	// READ-ONLY; The throughput in bytes.
	ThroughputInBytes *int64 `json:"throughputInBytes,omitempty" azure:"ro"`

	// READ-ONLY; The throughput status.
	ThroughputStatus *RcmComponentStatus `json:"throughputStatus,omitempty" azure:"ro"`

	// READ-ONLY; The uploading pending data in bytes.
	ThroughputUploadPendingDataInBytes *int64 `json:"throughputUploadPendingDataInBytes,omitempty" azure:"ro"`

	// READ-ONLY; The total memory.
	TotalMemoryInBytes *int64 `json:"totalMemoryInBytes,omitempty" azure:"ro"`

	// READ-ONLY; The total disk space.
	TotalSpaceInBytes *int64 `json:"totalSpaceInBytes,omitempty" azure:"ro"`

	// READ-ONLY; The used memory.
	UsedMemoryInBytes *int64 `json:"usedMemoryInBytes,omitempty" azure:"ro"`

	// READ-ONLY; The used disk space.
	UsedSpaceInBytes *int64 `json:"usedSpaceInBytes,omitempty" azure:"ro"`

	// READ-ONLY; The version.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// ProtectableItem - Replication protected item.
type ProtectableItem struct {
	// Resource Location
	Location *string `json:"location,omitempty"`

	// The custom data.
	Properties *ProtectableItemProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProtectableItemCollection - Protectable item collection.
type ProtectableItemCollection struct {
	// The value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// The Protectable item details.
	Value []*ProtectableItem `json:"value,omitempty"`
}

// ProtectableItemProperties - Replication protected item custom data details.
type ProtectableItemProperties struct {
	// The Replication provider custom settings.
	CustomDetails ConfigurationSettingsClassification `json:"customDetails,omitempty"`

	// The name.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// The Current protection readiness errors.
	ProtectionReadinessErrors []*string `json:"protectionReadinessErrors,omitempty"`

	// The protection status.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`

	// The recovery provider ARM Id.
	RecoveryServicesProviderID *string `json:"recoveryServicesProviderId,omitempty"`

	// The ARM resource of protected items.
	ReplicationProtectedItemID *string `json:"replicationProtectedItemId,omitempty"`

	// The list of replication providers supported for the protectable item.
	SupportedReplicationProviders []*string `json:"supportedReplicationProviders,omitempty"`
}

// ProtectableItemQueryParameter - Query parameter to enumerate Protectable items.
type ProtectableItemQueryParameter struct {
	// State of the Protectable item query filter.
	State *string `json:"state,omitempty"`
}

// ProtectedItemsQueryParameter - Query parameter to enumerate protected items.
type ProtectedItemsQueryParameter struct {
	// The fabric object Id filter.
	FabricObjectID *string `json:"fabricObjectId,omitempty"`

	// The replication provider type.
	InstanceType *string `json:"instanceType,omitempty"`

	// Whether Multi VM group is auto created or specified by user.
	MultiVMGroupCreateOption *MultiVMGroupCreateOption `json:"multiVmGroupCreateOption,omitempty"`

	// The process server Id filter.
	ProcessServerID *string `json:"processServerId,omitempty"`

	// The recovery plan filter.
	RecoveryPlanName *string `json:"recoveryPlanName,omitempty"`

	// The source fabric location filter.
	SourceFabricLocation *string `json:"sourceFabricLocation,omitempty"`

	// The source fabric name filter.
	SourceFabricName *string `json:"sourceFabricName,omitempty"`

	// The vCenter name filter.
	VCenterName *string `json:"vCenterName,omitempty"`
}

// ProtectionContainer - Protection container details.
type ProtectionContainer struct {
	// Resource Location
	Location *string `json:"location,omitempty"`

	// The custom data.
	Properties *ProtectionContainerProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProtectionContainerCollection - Protection Container collection.
type ProtectionContainerCollection struct {
	// The value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// The Protection Container details.
	Value []*ProtectionContainer `json:"value,omitempty"`
}

// ProtectionContainerFabricSpecificDetails - Base class for fabric specific details of container.
type ProtectionContainerFabricSpecificDetails struct {
	// READ-ONLY; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty" azure:"ro"`
}

// ProtectionContainerMapping - Protection container mapping object.
type ProtectionContainerMapping struct {
	// Resource Location
	Location *string `json:"location,omitempty"`

	// The custom data.
	Properties *ProtectionContainerMappingProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProtectionContainerMappingCollection - Protection container mapping collection class.
type ProtectionContainerMappingCollection struct {
	// Link to fetch rest of the data.
	NextLink *string `json:"nextLink,omitempty"`

	// List of container mappings.
	Value []*ProtectionContainerMapping `json:"value,omitempty"`
}

// ProtectionContainerMappingProperties - Protection container mapping properties.
type ProtectionContainerMappingProperties struct {
	// Health of pairing.
	Health *string `json:"health,omitempty"`

	// Health error.
	HealthErrorDetails []*HealthError `json:"healthErrorDetails,omitempty"`

	// Friendly name of replication policy.
	PolicyFriendlyName *string `json:"policyFriendlyName,omitempty"`

	// Policy ARM Id.
	PolicyID *string `json:"policyId,omitempty"`

	// Provider specific provider details.
	ProviderSpecificDetails ProtectionContainerMappingProviderSpecificDetailsClassification `json:"providerSpecificDetails,omitempty"`

	// Friendly name of source fabric.
	SourceFabricFriendlyName *string `json:"sourceFabricFriendlyName,omitempty"`

	// Friendly name of source protection container.
	SourceProtectionContainerFriendlyName *string `json:"sourceProtectionContainerFriendlyName,omitempty"`

	// Association Status.
	State *string `json:"state,omitempty"`

	// Friendly name of target fabric.
	TargetFabricFriendlyName *string `json:"targetFabricFriendlyName,omitempty"`

	// Friendly name of paired container.
	TargetProtectionContainerFriendlyName *string `json:"targetProtectionContainerFriendlyName,omitempty"`

	// Paired protection container ARM ID.
	TargetProtectionContainerID *string `json:"targetProtectionContainerId,omitempty"`
}

// ProtectionContainerMappingProviderSpecificDetailsClassification provides polymorphic access to related types.
// Call the interface's GetProtectionContainerMappingProviderSpecificDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *A2AProtectionContainerMappingDetails, *InMageRcmProtectionContainerMappingDetails, *ProtectionContainerMappingProviderSpecificDetails,
// - *VMwareCbtProtectionContainerMappingDetails
type ProtectionContainerMappingProviderSpecificDetailsClassification interface {
	// GetProtectionContainerMappingProviderSpecificDetails returns the ProtectionContainerMappingProviderSpecificDetails content of the underlying type.
	GetProtectionContainerMappingProviderSpecificDetails() *ProtectionContainerMappingProviderSpecificDetails
}

// ProtectionContainerMappingProviderSpecificDetails - Container mapping provider specific details.
type ProtectionContainerMappingProviderSpecificDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetProtectionContainerMappingProviderSpecificDetails implements the ProtectionContainerMappingProviderSpecificDetailsClassification
// interface for type ProtectionContainerMappingProviderSpecificDetails.
func (p *ProtectionContainerMappingProviderSpecificDetails) GetProtectionContainerMappingProviderSpecificDetails() *ProtectionContainerMappingProviderSpecificDetails {
	return p
}

// ProtectionContainerProperties - Protection profile custom data details.
type ProtectionContainerProperties struct {
	// Fabric friendly name.
	FabricFriendlyName *string `json:"fabricFriendlyName,omitempty"`

	// Fabric specific details.
	FabricSpecificDetails *ProtectionContainerFabricSpecificDetails `json:"fabricSpecificDetails,omitempty"`

	// The fabric type.
	FabricType *string `json:"fabricType,omitempty"`

	// The name.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// The pairing status of this cloud.
	PairingStatus *string `json:"pairingStatus,omitempty"`

	// Number of protected PEs.
	ProtectedItemCount *int32 `json:"protectedItemCount,omitempty"`

	// The role of this cloud.
	Role *string `json:"role,omitempty"`
}

// ProtectionProfileCustomDetailsClassification provides polymorphic access to related types.
// Call the interface's GetProtectionProfileCustomDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ExistingProtectionProfile, *NewProtectionProfile, *ProtectionProfileCustomDetails
type ProtectionProfileCustomDetailsClassification interface {
	// GetProtectionProfileCustomDetails returns the ProtectionProfileCustomDetails content of the underlying type.
	GetProtectionProfileCustomDetails() *ProtectionProfileCustomDetails
}

// ProtectionProfileCustomDetails - Protection Profile custom input.
type ProtectionProfileCustomDetails struct {
	// REQUIRED; The class type.
	ResourceType *string `json:"resourceType,omitempty"`
}

// GetProtectionProfileCustomDetails implements the ProtectionProfileCustomDetailsClassification interface for type ProtectionProfileCustomDetails.
func (p *ProtectionProfileCustomDetails) GetProtectionProfileCustomDetails() *ProtectionProfileCustomDetails {
	return p
}

// ProviderError - This class contains the error details per object.
type ProviderError struct {
	// The Error code.
	ErrorCode *int32 `json:"errorCode,omitempty"`

	// The Provider error Id.
	ErrorID *string `json:"errorId,omitempty"`

	// The Error message.
	ErrorMessage *string `json:"errorMessage,omitempty"`

	// The possible causes for the error.
	PossibleCauses *string `json:"possibleCauses,omitempty"`

	// The recommended action to resolve the error.
	RecommendedAction *string `json:"recommendedAction,omitempty"`
}

// ProviderSpecificRecoveryPointDetailsClassification provides polymorphic access to related types.
// Call the interface's GetProviderSpecificRecoveryPointDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *A2ARecoveryPointDetails, *InMageAzureV2RecoveryPointDetails, *InMageRcmRecoveryPointDetails, *ProviderSpecificRecoveryPointDetails
type ProviderSpecificRecoveryPointDetailsClassification interface {
	// GetProviderSpecificRecoveryPointDetails returns the ProviderSpecificRecoveryPointDetails content of the underlying type.
	GetProviderSpecificRecoveryPointDetails() *ProviderSpecificRecoveryPointDetails
}

// ProviderSpecificRecoveryPointDetails - Replication provider specific recovery point details.
type ProviderSpecificRecoveryPointDetails struct {
	// REQUIRED; Gets the provider type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetProviderSpecificRecoveryPointDetails implements the ProviderSpecificRecoveryPointDetailsClassification interface for
// type ProviderSpecificRecoveryPointDetails.
func (p *ProviderSpecificRecoveryPointDetails) GetProviderSpecificRecoveryPointDetails() *ProviderSpecificRecoveryPointDetails {
	return p
}

// PushInstallerDetails - Push installer details.
type PushInstallerDetails struct {
	// READ-ONLY; The push installer Bios Id.
	BiosID *string `json:"biosId,omitempty" azure:"ro"`

	// READ-ONLY; The fabric object Id.
	FabricObjectID *string `json:"fabricObjectId,omitempty" azure:"ro"`

	// READ-ONLY; The push installer Fqdn.
	Fqdn *string `json:"fqdn,omitempty" azure:"ro"`

	// READ-ONLY; The health of the push installer.
	Health *ProtectionHealth `json:"health,omitempty" azure:"ro"`

	// READ-ONLY; The health errors.
	HealthErrors []*HealthError `json:"healthErrors,omitempty" azure:"ro"`

	// READ-ONLY; The push installer Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The last heartbeat received from the push installer.
	LastHeartbeatUTC *time.Time `json:"lastHeartbeatUtc,omitempty" azure:"ro"`

	// READ-ONLY; The push installer name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The version.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// RcmProxyDetails - RCM proxy details.
type RcmProxyDetails struct {
	// READ-ONLY; The RCM proxy Bios Id.
	BiosID *string `json:"biosId,omitempty" azure:"ro"`

	// READ-ONLY; The client authentication type.
	ClientAuthenticationType *string `json:"clientAuthenticationType,omitempty" azure:"ro"`

	// READ-ONLY; The fabric object Id.
	FabricObjectID *string `json:"fabricObjectId,omitempty" azure:"ro"`

	// READ-ONLY; The RCM proxy Fqdn.
	Fqdn *string `json:"fqdn,omitempty" azure:"ro"`

	// READ-ONLY; The health of the RCM proxy.
	Health *ProtectionHealth `json:"health,omitempty" azure:"ro"`

	// READ-ONLY; The health errors.
	HealthErrors []*HealthError `json:"healthErrors,omitempty" azure:"ro"`

	// READ-ONLY; The RCM proxy Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The last heartbeat received from the RCM proxy.
	LastHeartbeatUTC *time.Time `json:"lastHeartbeatUtc,omitempty" azure:"ro"`

	// READ-ONLY; The RCM proxy name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The version.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// RecoveryAvailabilitySetCustomDetailsClassification provides polymorphic access to related types.
// Call the interface's GetRecoveryAvailabilitySetCustomDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ExistingRecoveryAvailabilitySet, *RecoveryAvailabilitySetCustomDetails
type RecoveryAvailabilitySetCustomDetailsClassification interface {
	// GetRecoveryAvailabilitySetCustomDetails returns the RecoveryAvailabilitySetCustomDetails content of the underlying type.
	GetRecoveryAvailabilitySetCustomDetails() *RecoveryAvailabilitySetCustomDetails
}

// RecoveryAvailabilitySetCustomDetails - Recovery Availability Set custom input.
type RecoveryAvailabilitySetCustomDetails struct {
	// REQUIRED; The class type.
	ResourceType *string `json:"resourceType,omitempty"`
}

// GetRecoveryAvailabilitySetCustomDetails implements the RecoveryAvailabilitySetCustomDetailsClassification interface for
// type RecoveryAvailabilitySetCustomDetails.
func (r *RecoveryAvailabilitySetCustomDetails) GetRecoveryAvailabilitySetCustomDetails() *RecoveryAvailabilitySetCustomDetails {
	return r
}

// RecoveryPlan - Recovery plan details.
type RecoveryPlan struct {
	// Resource Location
	Location *string `json:"location,omitempty"`

	// The custom details.
	Properties *RecoveryPlanProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RecoveryPlanA2ADetails - Recovery plan A2A specific details.
type RecoveryPlanA2ADetails struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The primary zone.
	PrimaryZone *string `json:"primaryZone,omitempty"`

	// The recovery zone.
	RecoveryZone *string `json:"recoveryZone,omitempty"`
}

// GetRecoveryPlanProviderSpecificDetails implements the RecoveryPlanProviderSpecificDetailsClassification interface for type
// RecoveryPlanA2ADetails.
func (r *RecoveryPlanA2ADetails) GetRecoveryPlanProviderSpecificDetails() *RecoveryPlanProviderSpecificDetails {
	return &RecoveryPlanProviderSpecificDetails{
		InstanceType: r.InstanceType,
	}
}

// RecoveryPlanA2AFailoverInput - Recovery plan A2A failover input.
type RecoveryPlanA2AFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; The recovery point type.
	RecoveryPointType *A2ARpRecoveryPointType `json:"recoveryPointType,omitempty"`

	// A value indicating whether to use recovery cloud service for TFO or not.
	CloudServiceCreationOption *string `json:"cloudServiceCreationOption,omitempty"`

	// A value indicating whether multi VM sync enabled VMs should use multi VM sync points for failover.
	MultiVMSyncPointOption *MultiVMSyncPointOption `json:"multiVmSyncPointOption,omitempty"`
}

// GetRecoveryPlanProviderSpecificFailoverInput implements the RecoveryPlanProviderSpecificFailoverInputClassification interface
// for type RecoveryPlanA2AFailoverInput.
func (r *RecoveryPlanA2AFailoverInput) GetRecoveryPlanProviderSpecificFailoverInput() *RecoveryPlanProviderSpecificFailoverInput {
	return &RecoveryPlanProviderSpecificFailoverInput{
		InstanceType: r.InstanceType,
	}
}

// RecoveryPlanA2AInput - Recovery plan A2A input.
type RecoveryPlanA2AInput struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The primary extended location.
	PrimaryExtendedLocation *ExtendedLocation `json:"primaryExtendedLocation,omitempty"`

	// The primary zone.
	PrimaryZone *string `json:"primaryZone,omitempty"`

	// The recovery extended location.
	RecoveryExtendedLocation *ExtendedLocation `json:"recoveryExtendedLocation,omitempty"`

	// The recovery zone.
	RecoveryZone *string `json:"recoveryZone,omitempty"`
}

// GetRecoveryPlanProviderSpecificInput implements the RecoveryPlanProviderSpecificInputClassification interface for type
// RecoveryPlanA2AInput.
func (r *RecoveryPlanA2AInput) GetRecoveryPlanProviderSpecificInput() *RecoveryPlanProviderSpecificInput {
	return &RecoveryPlanProviderSpecificInput{
		InstanceType: r.InstanceType,
	}
}

// RecoveryPlanAction - Recovery plan action details.
type RecoveryPlanAction struct {
	// REQUIRED; The action name.
	ActionName *string `json:"actionName,omitempty"`

	// REQUIRED; The custom details.
	CustomDetails RecoveryPlanActionDetailsClassification `json:"customDetails,omitempty"`

	// REQUIRED; The list of failover directions.
	FailoverDirections []*PossibleOperationsDirections `json:"failoverDirections,omitempty"`

	// REQUIRED; The list of failover types.
	FailoverTypes []*ReplicationProtectedItemOperation `json:"failoverTypes,omitempty"`
}

// RecoveryPlanActionDetailsClassification provides polymorphic access to related types.
// Call the interface's GetRecoveryPlanActionDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *RecoveryPlanActionDetails, *RecoveryPlanAutomationRunbookActionDetails, *RecoveryPlanManualActionDetails, *RecoveryPlanScriptActionDetails
type RecoveryPlanActionDetailsClassification interface {
	// GetRecoveryPlanActionDetails returns the RecoveryPlanActionDetails content of the underlying type.
	GetRecoveryPlanActionDetails() *RecoveryPlanActionDetails
}

// RecoveryPlanActionDetails - Recovery plan action custom details.
type RecoveryPlanActionDetails struct {
	// REQUIRED; Gets the type of action details (see RecoveryPlanActionDetailsTypes enum for possible values).
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetRecoveryPlanActionDetails implements the RecoveryPlanActionDetailsClassification interface for type RecoveryPlanActionDetails.
func (r *RecoveryPlanActionDetails) GetRecoveryPlanActionDetails() *RecoveryPlanActionDetails {
	return r
}

// RecoveryPlanAutomationRunbookActionDetails - Recovery plan Automation runbook action details.
type RecoveryPlanAutomationRunbookActionDetails struct {
	// REQUIRED; The fabric location.
	FabricLocation *RecoveryPlanActionLocation `json:"fabricLocation,omitempty"`

	// REQUIRED; Gets the type of action details (see RecoveryPlanActionDetailsTypes enum for possible values).
	InstanceType *string `json:"instanceType,omitempty"`

	// The runbook ARM Id.
	RunbookID *string `json:"runbookId,omitempty"`

	// The runbook timeout.
	Timeout *string `json:"timeout,omitempty"`
}

// GetRecoveryPlanActionDetails implements the RecoveryPlanActionDetailsClassification interface for type RecoveryPlanAutomationRunbookActionDetails.
func (r *RecoveryPlanAutomationRunbookActionDetails) GetRecoveryPlanActionDetails() *RecoveryPlanActionDetails {
	return &RecoveryPlanActionDetails{
		InstanceType: r.InstanceType,
	}
}

// RecoveryPlanCollection - Recovery plan collection details.
type RecoveryPlanCollection struct {
	// The value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of recovery plans.
	Value []*RecoveryPlan `json:"value,omitempty"`
}

// RecoveryPlanGroup - Recovery plan group details.
type RecoveryPlanGroup struct {
	// REQUIRED; The group type.
	GroupType *RecoveryPlanGroupType `json:"groupType,omitempty"`

	// The end group actions.
	EndGroupActions []*RecoveryPlanAction `json:"endGroupActions,omitempty"`

	// The list of protected items.
	ReplicationProtectedItems []*RecoveryPlanProtectedItem `json:"replicationProtectedItems,omitempty"`

	// The start group actions.
	StartGroupActions []*RecoveryPlanAction `json:"startGroupActions,omitempty"`
}

// RecoveryPlanGroupTaskDetailsClassification provides polymorphic access to related types.
// Call the interface's GetRecoveryPlanGroupTaskDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *RecoveryPlanGroupTaskDetails, *RecoveryPlanShutdownGroupTaskDetails
type RecoveryPlanGroupTaskDetailsClassification interface {
	GroupTaskDetailsClassification
	// GetRecoveryPlanGroupTaskDetails returns the RecoveryPlanGroupTaskDetails content of the underlying type.
	GetRecoveryPlanGroupTaskDetails() *RecoveryPlanGroupTaskDetails
}

// RecoveryPlanGroupTaskDetails - This class represents the recovery plan group task.
type RecoveryPlanGroupTaskDetails struct {
	// REQUIRED; The type of task details.
	InstanceType *string `json:"instanceType,omitempty"`

	// The child tasks.
	ChildTasks []*ASRTask `json:"childTasks,omitempty"`

	// The group identifier.
	GroupID *string `json:"groupId,omitempty"`

	// The name.
	Name *string `json:"name,omitempty"`

	// The group type.
	RpGroupType *string `json:"rpGroupType,omitempty"`
}

// GetGroupTaskDetails implements the GroupTaskDetailsClassification interface for type RecoveryPlanGroupTaskDetails.
func (r *RecoveryPlanGroupTaskDetails) GetGroupTaskDetails() *GroupTaskDetails {
	return &GroupTaskDetails{
		InstanceType: r.InstanceType,
		ChildTasks:   r.ChildTasks,
	}
}

// GetRecoveryPlanGroupTaskDetails implements the RecoveryPlanGroupTaskDetailsClassification interface for type RecoveryPlanGroupTaskDetails.
func (r *RecoveryPlanGroupTaskDetails) GetRecoveryPlanGroupTaskDetails() *RecoveryPlanGroupTaskDetails {
	return r
}

// RecoveryPlanHyperVReplicaAzureFailbackInput - Recovery plan HVR Azure failback input.
type RecoveryPlanHyperVReplicaAzureFailbackInput struct {
	// REQUIRED; The data sync option.
	DataSyncOption *DataSyncStatus `json:"dataSyncOption,omitempty"`

	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; The ALR option.
	RecoveryVMCreationOption *AlternateLocationRecoveryOption `json:"recoveryVmCreationOption,omitempty"`
}

// GetRecoveryPlanProviderSpecificFailoverInput implements the RecoveryPlanProviderSpecificFailoverInputClassification interface
// for type RecoveryPlanHyperVReplicaAzureFailbackInput.
func (r *RecoveryPlanHyperVReplicaAzureFailbackInput) GetRecoveryPlanProviderSpecificFailoverInput() *RecoveryPlanProviderSpecificFailoverInput {
	return &RecoveryPlanProviderSpecificFailoverInput{
		InstanceType: r.InstanceType,
	}
}

// RecoveryPlanHyperVReplicaAzureFailoverInput - Recovery plan HVR Azure failover input.
type RecoveryPlanHyperVReplicaAzureFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The primary KEK certificate PFX.
	PrimaryKekCertificatePfx *string `json:"primaryKekCertificatePfx,omitempty"`

	// The recovery point type.
	RecoveryPointType *HyperVReplicaAzureRpRecoveryPointType `json:"recoveryPointType,omitempty"`

	// The secondary KEK certificate PFX.
	SecondaryKekCertificatePfx *string `json:"secondaryKekCertificatePfx,omitempty"`
}

// GetRecoveryPlanProviderSpecificFailoverInput implements the RecoveryPlanProviderSpecificFailoverInputClassification interface
// for type RecoveryPlanHyperVReplicaAzureFailoverInput.
func (r *RecoveryPlanHyperVReplicaAzureFailoverInput) GetRecoveryPlanProviderSpecificFailoverInput() *RecoveryPlanProviderSpecificFailoverInput {
	return &RecoveryPlanProviderSpecificFailoverInput{
		InstanceType: r.InstanceType,
	}
}

// RecoveryPlanInMageAzureV2FailoverInput - Recovery plan InMageAzureV2 failover input.
type RecoveryPlanInMageAzureV2FailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; The recovery point type.
	RecoveryPointType *InMageV2RpRecoveryPointType `json:"recoveryPointType,omitempty"`

	// A value indicating whether multi VM sync enabled VMs should use multi VM sync points for failover.
	UseMultiVMSyncPoint *string `json:"useMultiVmSyncPoint,omitempty"`
}

// GetRecoveryPlanProviderSpecificFailoverInput implements the RecoveryPlanProviderSpecificFailoverInputClassification interface
// for type RecoveryPlanInMageAzureV2FailoverInput.
func (r *RecoveryPlanInMageAzureV2FailoverInput) GetRecoveryPlanProviderSpecificFailoverInput() *RecoveryPlanProviderSpecificFailoverInput {
	return &RecoveryPlanProviderSpecificFailoverInput{
		InstanceType: r.InstanceType,
	}
}

// RecoveryPlanInMageFailoverInput - Recovery plan InMage failover input.
type RecoveryPlanInMageFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; The recovery point type.
	RecoveryPointType *RpInMageRecoveryPointType `json:"recoveryPointType,omitempty"`
}

// GetRecoveryPlanProviderSpecificFailoverInput implements the RecoveryPlanProviderSpecificFailoverInputClassification interface
// for type RecoveryPlanInMageFailoverInput.
func (r *RecoveryPlanInMageFailoverInput) GetRecoveryPlanProviderSpecificFailoverInput() *RecoveryPlanProviderSpecificFailoverInput {
	return &RecoveryPlanProviderSpecificFailoverInput{
		InstanceType: r.InstanceType,
	}
}

// RecoveryPlanInMageRcmFailbackFailoverInput - Recovery plan InMageRcmFailback failover input.
type RecoveryPlanInMageRcmFailbackFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; The recovery point type.
	RecoveryPointType *InMageRcmFailbackRecoveryPointType `json:"recoveryPointType,omitempty"`

	// A value indicating whether multi VM sync enabled VMs should use multi VM sync points for failover.
	UseMultiVMSyncPoint *string `json:"useMultiVmSyncPoint,omitempty"`
}

// GetRecoveryPlanProviderSpecificFailoverInput implements the RecoveryPlanProviderSpecificFailoverInputClassification interface
// for type RecoveryPlanInMageRcmFailbackFailoverInput.
func (r *RecoveryPlanInMageRcmFailbackFailoverInput) GetRecoveryPlanProviderSpecificFailoverInput() *RecoveryPlanProviderSpecificFailoverInput {
	return &RecoveryPlanProviderSpecificFailoverInput{
		InstanceType: r.InstanceType,
	}
}

// RecoveryPlanInMageRcmFailoverInput - Recovery plan InMageRcm failover input.
type RecoveryPlanInMageRcmFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; The recovery point type.
	RecoveryPointType *RecoveryPlanPointType `json:"recoveryPointType,omitempty"`

	// A value indicating whether multi VM sync enabled VMs should use multi VM sync points for failover.
	UseMultiVMSyncPoint *string `json:"useMultiVmSyncPoint,omitempty"`
}

// GetRecoveryPlanProviderSpecificFailoverInput implements the RecoveryPlanProviderSpecificFailoverInputClassification interface
// for type RecoveryPlanInMageRcmFailoverInput.
func (r *RecoveryPlanInMageRcmFailoverInput) GetRecoveryPlanProviderSpecificFailoverInput() *RecoveryPlanProviderSpecificFailoverInput {
	return &RecoveryPlanProviderSpecificFailoverInput{
		InstanceType: r.InstanceType,
	}
}

// RecoveryPlanManualActionDetails - Recovery plan manual action details.
type RecoveryPlanManualActionDetails struct {
	// REQUIRED; Gets the type of action details (see RecoveryPlanActionDetailsTypes enum for possible values).
	InstanceType *string `json:"instanceType,omitempty"`

	// The manual action description.
	Description *string `json:"description,omitempty"`
}

// GetRecoveryPlanActionDetails implements the RecoveryPlanActionDetailsClassification interface for type RecoveryPlanManualActionDetails.
func (r *RecoveryPlanManualActionDetails) GetRecoveryPlanActionDetails() *RecoveryPlanActionDetails {
	return &RecoveryPlanActionDetails{
		InstanceType: r.InstanceType,
	}
}

// RecoveryPlanPlannedFailoverInput - Recovery plan planned failover input.
type RecoveryPlanPlannedFailoverInput struct {
	// REQUIRED; The recovery plan planned failover input properties.
	Properties *RecoveryPlanPlannedFailoverInputProperties `json:"properties,omitempty"`
}

// RecoveryPlanPlannedFailoverInputProperties - Recovery plan planned failover input properties.
type RecoveryPlanPlannedFailoverInputProperties struct {
	// REQUIRED; The failover direction.
	FailoverDirection *PossibleOperationsDirections `json:"failoverDirection,omitempty"`

	// The provider specific properties.
	ProviderSpecificDetails []RecoveryPlanProviderSpecificFailoverInputClassification `json:"providerSpecificDetails,omitempty"`
}

// RecoveryPlanProperties - Recovery plan properties.
type RecoveryPlanProperties struct {
	// The list of allowed operations.
	AllowedOperations []*string `json:"allowedOperations,omitempty"`

	// The current scenario details.
	CurrentScenario *CurrentScenarioDetails `json:"currentScenario,omitempty"`

	// The recovery plan status.
	CurrentScenarioStatus *string `json:"currentScenarioStatus,omitempty"`

	// The recovery plan status description.
	CurrentScenarioStatusDescription *string `json:"currentScenarioStatusDescription,omitempty"`

	// The failover deployment model.
	FailoverDeploymentModel *string `json:"failoverDeploymentModel,omitempty"`

	// The friendly name.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// The recovery plan groups.
	Groups []*RecoveryPlanGroup `json:"groups,omitempty"`

	// The start time of the last planned failover.
	LastPlannedFailoverTime *time.Time `json:"lastPlannedFailoverTime,omitempty"`

	// The start time of the last test failover.
	LastTestFailoverTime *time.Time `json:"lastTestFailoverTime,omitempty"`

	// The start time of the last unplanned failover.
	LastUnplannedFailoverTime *time.Time `json:"lastUnplannedFailoverTime,omitempty"`

	// The primary fabric friendly name.
	PrimaryFabricFriendlyName *string `json:"primaryFabricFriendlyName,omitempty"`

	// The primary fabric Id.
	PrimaryFabricID *string `json:"primaryFabricId,omitempty"`

	// The provider id and provider specific details.
	ProviderSpecificDetails []RecoveryPlanProviderSpecificDetailsClassification `json:"providerSpecificDetails,omitempty"`

	// The recovery fabric friendly name.
	RecoveryFabricFriendlyName *string `json:"recoveryFabricFriendlyName,omitempty"`

	// The recovery fabric Id.
	RecoveryFabricID *string `json:"recoveryFabricId,omitempty"`

	// The list of replication providers.
	ReplicationProviders []*string `json:"replicationProviders,omitempty"`
}

// RecoveryPlanProtectedItem - Recovery plan protected item.
type RecoveryPlanProtectedItem struct {
	// The ARM Id of the recovery plan protected item.
	ID *string `json:"id,omitempty"`

	// The virtual machine Id.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
}

// RecoveryPlanProviderSpecificDetailsClassification provides polymorphic access to related types.
// Call the interface's GetRecoveryPlanProviderSpecificDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *RecoveryPlanA2ADetails, *RecoveryPlanProviderSpecificDetails
type RecoveryPlanProviderSpecificDetailsClassification interface {
	// GetRecoveryPlanProviderSpecificDetails returns the RecoveryPlanProviderSpecificDetails content of the underlying type.
	GetRecoveryPlanProviderSpecificDetails() *RecoveryPlanProviderSpecificDetails
}

// RecoveryPlanProviderSpecificDetails - Recovery plan provider specific details.
type RecoveryPlanProviderSpecificDetails struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetRecoveryPlanProviderSpecificDetails implements the RecoveryPlanProviderSpecificDetailsClassification interface for type
// RecoveryPlanProviderSpecificDetails.
func (r *RecoveryPlanProviderSpecificDetails) GetRecoveryPlanProviderSpecificDetails() *RecoveryPlanProviderSpecificDetails {
	return r
}

// RecoveryPlanProviderSpecificFailoverInputClassification provides polymorphic access to related types.
// Call the interface's GetRecoveryPlanProviderSpecificFailoverInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *RecoveryPlanA2AFailoverInput, *RecoveryPlanHyperVReplicaAzureFailbackInput, *RecoveryPlanHyperVReplicaAzureFailoverInput,
// - *RecoveryPlanInMageAzureV2FailoverInput, *RecoveryPlanInMageFailoverInput, *RecoveryPlanInMageRcmFailbackFailoverInput,
// - *RecoveryPlanInMageRcmFailoverInput, *RecoveryPlanProviderSpecificFailoverInput
type RecoveryPlanProviderSpecificFailoverInputClassification interface {
	// GetRecoveryPlanProviderSpecificFailoverInput returns the RecoveryPlanProviderSpecificFailoverInput content of the underlying type.
	GetRecoveryPlanProviderSpecificFailoverInput() *RecoveryPlanProviderSpecificFailoverInput
}

// RecoveryPlanProviderSpecificFailoverInput - Recovery plan provider specific failover input.
type RecoveryPlanProviderSpecificFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetRecoveryPlanProviderSpecificFailoverInput implements the RecoveryPlanProviderSpecificFailoverInputClassification interface
// for type RecoveryPlanProviderSpecificFailoverInput.
func (r *RecoveryPlanProviderSpecificFailoverInput) GetRecoveryPlanProviderSpecificFailoverInput() *RecoveryPlanProviderSpecificFailoverInput {
	return r
}

// RecoveryPlanProviderSpecificInputClassification provides polymorphic access to related types.
// Call the interface's GetRecoveryPlanProviderSpecificInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *RecoveryPlanA2AInput, *RecoveryPlanProviderSpecificInput
type RecoveryPlanProviderSpecificInputClassification interface {
	// GetRecoveryPlanProviderSpecificInput returns the RecoveryPlanProviderSpecificInput content of the underlying type.
	GetRecoveryPlanProviderSpecificInput() *RecoveryPlanProviderSpecificInput
}

// RecoveryPlanProviderSpecificInput - Recovery plan provider specific input base class.
type RecoveryPlanProviderSpecificInput struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetRecoveryPlanProviderSpecificInput implements the RecoveryPlanProviderSpecificInputClassification interface for type
// RecoveryPlanProviderSpecificInput.
func (r *RecoveryPlanProviderSpecificInput) GetRecoveryPlanProviderSpecificInput() *RecoveryPlanProviderSpecificInput {
	return r
}

// RecoveryPlanScriptActionDetails - Recovery plan script action details.
type RecoveryPlanScriptActionDetails struct {
	// REQUIRED; The fabric location.
	FabricLocation *RecoveryPlanActionLocation `json:"fabricLocation,omitempty"`

	// REQUIRED; Gets the type of action details (see RecoveryPlanActionDetailsTypes enum for possible values).
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; The script path.
	Path *string `json:"path,omitempty"`

	// The script timeout.
	Timeout *string `json:"timeout,omitempty"`
}

// GetRecoveryPlanActionDetails implements the RecoveryPlanActionDetailsClassification interface for type RecoveryPlanScriptActionDetails.
func (r *RecoveryPlanScriptActionDetails) GetRecoveryPlanActionDetails() *RecoveryPlanActionDetails {
	return &RecoveryPlanActionDetails{
		InstanceType: r.InstanceType,
	}
}

// RecoveryPlanShutdownGroupTaskDetails - This class represents the recovery plan shutdown group task details.
type RecoveryPlanShutdownGroupTaskDetails struct {
	// REQUIRED; The type of task details.
	InstanceType *string `json:"instanceType,omitempty"`

	// The child tasks.
	ChildTasks []*ASRTask `json:"childTasks,omitempty"`

	// The group identifier.
	GroupID *string `json:"groupId,omitempty"`

	// The name.
	Name *string `json:"name,omitempty"`

	// The group type.
	RpGroupType *string `json:"rpGroupType,omitempty"`
}

// GetGroupTaskDetails implements the GroupTaskDetailsClassification interface for type RecoveryPlanShutdownGroupTaskDetails.
func (r *RecoveryPlanShutdownGroupTaskDetails) GetGroupTaskDetails() *GroupTaskDetails {
	return &GroupTaskDetails{
		InstanceType: r.InstanceType,
		ChildTasks:   r.ChildTasks,
	}
}

// GetRecoveryPlanGroupTaskDetails implements the RecoveryPlanGroupTaskDetailsClassification interface for type RecoveryPlanShutdownGroupTaskDetails.
func (r *RecoveryPlanShutdownGroupTaskDetails) GetRecoveryPlanGroupTaskDetails() *RecoveryPlanGroupTaskDetails {
	return &RecoveryPlanGroupTaskDetails{
		Name:         r.Name,
		GroupID:      r.GroupID,
		RpGroupType:  r.RpGroupType,
		InstanceType: r.InstanceType,
		ChildTasks:   r.ChildTasks,
	}
}

// RecoveryPlanTestFailoverCleanupInput - Recovery plan test failover cleanup input.
type RecoveryPlanTestFailoverCleanupInput struct {
	// REQUIRED; The recovery plan test failover cleanup input properties.
	Properties *RecoveryPlanTestFailoverCleanupInputProperties `json:"properties,omitempty"`
}

// RecoveryPlanTestFailoverCleanupInputProperties - Recovery plan test failover cleanup input properties.
type RecoveryPlanTestFailoverCleanupInputProperties struct {
	// The test failover cleanup comments.
	Comments *string `json:"comments,omitempty"`
}

// RecoveryPlanTestFailoverInput - Recovery plan test failover input.
type RecoveryPlanTestFailoverInput struct {
	// REQUIRED; The recovery plan test failover input properties.
	Properties *RecoveryPlanTestFailoverInputProperties `json:"properties,omitempty"`
}

// RecoveryPlanTestFailoverInputProperties - Recovery plan test failover input properties.
type RecoveryPlanTestFailoverInputProperties struct {
	// REQUIRED; The failover direction.
	FailoverDirection *PossibleOperationsDirections `json:"failoverDirection,omitempty"`

	// REQUIRED; The network type to be used for test failover.
	NetworkType *string `json:"networkType,omitempty"`

	// The Id of the network to be used for test failover.
	NetworkID *string `json:"networkId,omitempty"`

	// The provider specific properties.
	ProviderSpecificDetails []RecoveryPlanProviderSpecificFailoverInputClassification `json:"providerSpecificDetails,omitempty"`
}

// RecoveryPlanUnplannedFailoverInput - Recovery plan unplanned failover input.
type RecoveryPlanUnplannedFailoverInput struct {
	// REQUIRED; The recovery plan unplanned failover input properties.
	Properties *RecoveryPlanUnplannedFailoverInputProperties `json:"properties,omitempty"`
}

// RecoveryPlanUnplannedFailoverInputProperties - Recovery plan unplanned failover input properties.
type RecoveryPlanUnplannedFailoverInputProperties struct {
	// REQUIRED; The failover direction.
	FailoverDirection *PossibleOperationsDirections `json:"failoverDirection,omitempty"`

	// REQUIRED; A value indicating whether source site operations are required.
	SourceSiteOperations *SourceSiteOperations `json:"sourceSiteOperations,omitempty"`

	// The provider specific properties.
	ProviderSpecificDetails []RecoveryPlanProviderSpecificFailoverInputClassification `json:"providerSpecificDetails,omitempty"`
}

// RecoveryPoint - Recovery point.
type RecoveryPoint struct {
	// Resource Location
	Location *string `json:"location,omitempty"`

	// The recovery point properties.
	Properties *RecoveryPointProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RecoveryPointCollection - Collection of recovery point details.
type RecoveryPointCollection struct {
	// The value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// The recovery point details.
	Value []*RecoveryPoint `json:"value,omitempty"`
}

// RecoveryPointProperties - Recovery point properties.
type RecoveryPointProperties struct {
	// The provider specific details for the recovery point.
	ProviderSpecificDetails ProviderSpecificRecoveryPointDetailsClassification `json:"providerSpecificDetails,omitempty"`

	// The recovery point time.
	RecoveryPointTime *time.Time `json:"recoveryPointTime,omitempty"`

	// The recovery point type: ApplicationConsistent, CrashConsistent.
	RecoveryPointType *string `json:"recoveryPointType,omitempty"`
}

// RecoveryPointsClientGetOptions contains the optional parameters for the RecoveryPointsClient.Get method.
type RecoveryPointsClientGetOptions struct {
	// placeholder for future optional parameters
}

// RecoveryPointsClientListByReplicationProtectedItemsOptions contains the optional parameters for the RecoveryPointsClient.ListByReplicationProtectedItems
// method.
type RecoveryPointsClientListByReplicationProtectedItemsOptions struct {
	// placeholder for future optional parameters
}

// RecoveryProximityPlacementGroupCustomDetailsClassification provides polymorphic access to related types.
// Call the interface's GetRecoveryProximityPlacementGroupCustomDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ExistingRecoveryProximityPlacementGroup, *RecoveryProximityPlacementGroupCustomDetails
type RecoveryProximityPlacementGroupCustomDetailsClassification interface {
	// GetRecoveryProximityPlacementGroupCustomDetails returns the RecoveryProximityPlacementGroupCustomDetails content of the underlying type.
	GetRecoveryProximityPlacementGroupCustomDetails() *RecoveryProximityPlacementGroupCustomDetails
}

// RecoveryProximityPlacementGroupCustomDetails - Recovery Proximity placement group custom input.
type RecoveryProximityPlacementGroupCustomDetails struct {
	// REQUIRED; The class type.
	ResourceType *string `json:"resourceType,omitempty"`
}

// GetRecoveryProximityPlacementGroupCustomDetails implements the RecoveryProximityPlacementGroupCustomDetailsClassification
// interface for type RecoveryProximityPlacementGroupCustomDetails.
func (r *RecoveryProximityPlacementGroupCustomDetails) GetRecoveryProximityPlacementGroupCustomDetails() *RecoveryProximityPlacementGroupCustomDetails {
	return r
}

// RecoveryResourceGroupCustomDetailsClassification provides polymorphic access to related types.
// Call the interface's GetRecoveryResourceGroupCustomDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ExistingRecoveryResourceGroup, *RecoveryResourceGroupCustomDetails
type RecoveryResourceGroupCustomDetailsClassification interface {
	// GetRecoveryResourceGroupCustomDetails returns the RecoveryResourceGroupCustomDetails content of the underlying type.
	GetRecoveryResourceGroupCustomDetails() *RecoveryResourceGroupCustomDetails
}

// RecoveryResourceGroupCustomDetails - Recovery Resource Group custom input.
type RecoveryResourceGroupCustomDetails struct {
	// REQUIRED; The class type.
	ResourceType *string `json:"resourceType,omitempty"`
}

// GetRecoveryResourceGroupCustomDetails implements the RecoveryResourceGroupCustomDetailsClassification interface for type
// RecoveryResourceGroupCustomDetails.
func (r *RecoveryResourceGroupCustomDetails) GetRecoveryResourceGroupCustomDetails() *RecoveryResourceGroupCustomDetails {
	return r
}

// RecoveryServicesProvider - Provider details.
type RecoveryServicesProvider struct {
	// Resource Location
	Location *string `json:"location,omitempty"`

	// Provider properties.
	Properties *RecoveryServicesProviderProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RecoveryServicesProviderCollection - Collection of providers.
type RecoveryServicesProviderCollection struct {
	// The value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// The Servers details.
	Value []*RecoveryServicesProvider `json:"value,omitempty"`
}

// RecoveryServicesProviderProperties - Recovery services provider properties.
type RecoveryServicesProviderProperties struct {
	// The scenarios allowed on this provider.
	AllowedScenarios []*string `json:"allowedScenarios,omitempty"`

	// The authentication identity details.
	AuthenticationIdentityDetails *IdentityProviderDetails `json:"authenticationIdentityDetails,omitempty"`

	// The Bios Id.
	BiosID *string `json:"biosId,omitempty"`

	// A value indicating whether DRA is responsive.
	ConnectionStatus *string `json:"connectionStatus,omitempty"`

	// The data plane authentication identity details.
	DataPlaneAuthenticationIdentityDetails *IdentityProviderDetails `json:"dataPlaneAuthenticationIdentityDetails,omitempty"`

	// The DRA Id.
	DraIdentifier *string `json:"draIdentifier,omitempty"`

	// The fabric friendly name.
	FabricFriendlyName *string `json:"fabricFriendlyName,omitempty"`

	// Type of the site.
	FabricType *string `json:"fabricType,omitempty"`

	// Friendly name of the DRA.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// The recovery services provider health error details.
	HealthErrorDetails []*HealthError `json:"healthErrorDetails,omitempty"`

	// Time when last heartbeat was sent by the DRA.
	LastHeartBeat *time.Time `json:"lastHeartBeat,omitempty"`

	// The machine Id.
	MachineID *string `json:"machineId,omitempty"`

	// The machine name.
	MachineName *string `json:"machineName,omitempty"`

	// Number of protected VMs currently managed by the DRA.
	ProtectedItemCount *int32 `json:"protectedItemCount,omitempty"`

	// The provider version.
	ProviderVersion *string `json:"providerVersion,omitempty"`

	// The provider version details.
	ProviderVersionDetails *VersionDetails `json:"providerVersionDetails,omitempty"`

	// Expiry date of the version.
	ProviderVersionExpiryDate *time.Time `json:"providerVersionExpiryDate,omitempty"`

	// DRA version status.
	ProviderVersionState *string `json:"providerVersionState,omitempty"`

	// The resource access identity details.
	ResourceAccessIdentityDetails *IdentityProviderDetails `json:"resourceAccessIdentityDetails,omitempty"`

	// The fabric provider.
	ServerVersion *string `json:"serverVersion,omitempty"`
}

// RecoveryVirtualNetworkCustomDetailsClassification provides polymorphic access to related types.
// Call the interface's GetRecoveryVirtualNetworkCustomDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ExistingRecoveryVirtualNetwork, *NewRecoveryVirtualNetwork, *RecoveryVirtualNetworkCustomDetails
type RecoveryVirtualNetworkCustomDetailsClassification interface {
	// GetRecoveryVirtualNetworkCustomDetails returns the RecoveryVirtualNetworkCustomDetails content of the underlying type.
	GetRecoveryVirtualNetworkCustomDetails() *RecoveryVirtualNetworkCustomDetails
}

// RecoveryVirtualNetworkCustomDetails - Recovery Virtual network custom input.
type RecoveryVirtualNetworkCustomDetails struct {
	// REQUIRED; The class type.
	ResourceType *string `json:"resourceType,omitempty"`
}

// GetRecoveryVirtualNetworkCustomDetails implements the RecoveryVirtualNetworkCustomDetailsClassification interface for type
// RecoveryVirtualNetworkCustomDetails.
func (r *RecoveryVirtualNetworkCustomDetails) GetRecoveryVirtualNetworkCustomDetails() *RecoveryVirtualNetworkCustomDetails {
	return r
}

// RemoveDisksInput - Input for remove disk(s) operation.
type RemoveDisksInput struct {
	// Remove disk input properties.
	Properties *RemoveDisksInputProperties `json:"properties,omitempty"`
}

// RemoveDisksInputProperties - Remove Disk input properties.
type RemoveDisksInputProperties struct {
	// The ReplicationProviderInput. For HyperVReplicaAzure provider, it will be AzureEnableProtectionInput object. For San provider,
	// it will be SanEnableProtectionInput object. For HyperVReplicaAzure
	// provider, it can be null.
	ProviderSpecificDetails RemoveDisksProviderSpecificInputClassification `json:"providerSpecificDetails,omitempty"`
}

// RemoveDisksProviderSpecificInputClassification provides polymorphic access to related types.
// Call the interface's GetRemoveDisksProviderSpecificInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *A2ARemoveDisksInput, *RemoveDisksProviderSpecificInput
type RemoveDisksProviderSpecificInputClassification interface {
	// GetRemoveDisksProviderSpecificInput returns the RemoveDisksProviderSpecificInput content of the underlying type.
	GetRemoveDisksProviderSpecificInput() *RemoveDisksProviderSpecificInput
}

// RemoveDisksProviderSpecificInput - Remove Disk provider specific input.
type RemoveDisksProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetRemoveDisksProviderSpecificInput implements the RemoveDisksProviderSpecificInputClassification interface for type RemoveDisksProviderSpecificInput.
func (r *RemoveDisksProviderSpecificInput) GetRemoveDisksProviderSpecificInput() *RemoveDisksProviderSpecificInput {
	return r
}

// RemoveProtectionContainerMappingInput - Container unpairing input.
type RemoveProtectionContainerMappingInput struct {
	// Configure protection input properties.
	Properties *RemoveProtectionContainerMappingInputProperties `json:"properties,omitempty"`
}

// RemoveProtectionContainerMappingInputProperties - Unpairing input properties.
type RemoveProtectionContainerMappingInputProperties struct {
	// Provider specific input for unpairing.
	ProviderSpecificInput *ReplicationProviderContainerUnmappingInput `json:"providerSpecificInput,omitempty"`
}

// RenewCertificateInput - Certificate renewal input.
type RenewCertificateInput struct {
	// Renew certificate input properties.
	Properties *RenewCertificateInputProperties `json:"properties,omitempty"`
}

// RenewCertificateInputProperties - Renew Certificate input properties.
type RenewCertificateInputProperties struct {
	// Renew certificate type.
	RenewCertificateType *string `json:"renewCertificateType,omitempty"`
}

// ReplicationAgentDetails - Replication agent details.
type ReplicationAgentDetails struct {
	// READ-ONLY; The replication agent Bios Id.
	BiosID *string `json:"biosId,omitempty" azure:"ro"`

	// READ-ONLY; The fabric object Id.
	FabricObjectID *string `json:"fabricObjectId,omitempty" azure:"ro"`

	// READ-ONLY; The replication agent Fqdn.
	Fqdn *string `json:"fqdn,omitempty" azure:"ro"`

	// READ-ONLY; The health of the replication agent.
	Health *ProtectionHealth `json:"health,omitempty" azure:"ro"`

	// READ-ONLY; The health errors.
	HealthErrors []*HealthError `json:"healthErrors,omitempty" azure:"ro"`

	// READ-ONLY; The replication agent Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The last heartbeat received from the replication agent.
	LastHeartbeatUTC *time.Time `json:"lastHeartbeatUtc,omitempty" azure:"ro"`

	// READ-ONLY; The replication agent name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The version.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// ReplicationAlertSettingsClientCreateOptions contains the optional parameters for the ReplicationAlertSettingsClient.Create
// method.
type ReplicationAlertSettingsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// ReplicationAlertSettingsClientGetOptions contains the optional parameters for the ReplicationAlertSettingsClient.Get method.
type ReplicationAlertSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ReplicationAlertSettingsClientListOptions contains the optional parameters for the ReplicationAlertSettingsClient.List
// method.
type ReplicationAlertSettingsClientListOptions struct {
	// placeholder for future optional parameters
}

// ReplicationAppliance - Replication appliance definition.
type ReplicationAppliance struct {
	// Appliance related data.
	Properties *ReplicationApplianceProperties `json:"properties,omitempty"`
}

// ReplicationApplianceProperties - Replication appliance properties.
type ReplicationApplianceProperties struct {
	// Provider specific settings.
	ProviderSpecificDetails ApplianceSpecificDetailsClassification `json:"providerSpecificDetails,omitempty"`
}

// ReplicationAppliancesClientListOptions contains the optional parameters for the ReplicationAppliancesClient.List method.
type ReplicationAppliancesClientListOptions struct {
	// OData filter options.
	Filter *string
}

// ReplicationEligibilityResults - Replication eligibility results response model.
type ReplicationEligibilityResults struct {
	// READ-ONLY; Gets Unique ARM identifier for this object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the name of this object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets properties model for replication eligibility results API.
	Properties *ReplicationEligibilityResultsProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; Gets the object type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ReplicationEligibilityResultsClientGetOptions contains the optional parameters for the ReplicationEligibilityResultsClient.Get
// method.
type ReplicationEligibilityResultsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ReplicationEligibilityResultsClientListOptions contains the optional parameters for the ReplicationEligibilityResultsClient.List
// method.
type ReplicationEligibilityResultsClientListOptions struct {
	// placeholder for future optional parameters
}

// ReplicationEligibilityResultsCollection - Replication eligibility results collection response model.
type ReplicationEligibilityResultsCollection struct {
	// The replication eligibility results details.
	Value []*ReplicationEligibilityResults `json:"value,omitempty"`
}

// ReplicationEligibilityResultsErrorInfo - Error model that can be exposed to the user.
type ReplicationEligibilityResultsErrorInfo struct {
	// The error code.
	Code *string `json:"code,omitempty"`

	// The error message.
	Message *string `json:"message,omitempty"`

	// The possible causes.
	PossibleCauses *string `json:"possibleCauses,omitempty"`

	// The recommended action.
	RecommendedAction *string `json:"recommendedAction,omitempty"`

	// READ-ONLY; The error status.
	Status *string `json:"status,omitempty" azure:"ro"`
}

// ReplicationEligibilityResultsProperties - Properties model for replication eligibility results API.
type ReplicationEligibilityResultsProperties struct {
	// The error details.
	Errors []*ReplicationEligibilityResultsErrorInfo `json:"errors,omitempty"`

	// READ-ONLY; The client request Id.
	ClientRequestID *string `json:"clientRequestId,omitempty" azure:"ro"`
}

// ReplicationEventsClientGetOptions contains the optional parameters for the ReplicationEventsClient.Get method.
type ReplicationEventsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ReplicationEventsClientListOptions contains the optional parameters for the ReplicationEventsClient.List method.
type ReplicationEventsClientListOptions struct {
	// OData filter options.
	Filter *string
}

// ReplicationFabricsClientBeginCheckConsistencyOptions contains the optional parameters for the ReplicationFabricsClient.BeginCheckConsistency
// method.
type ReplicationFabricsClientBeginCheckConsistencyOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationFabricsClientBeginCreateOptions contains the optional parameters for the ReplicationFabricsClient.BeginCreate
// method.
type ReplicationFabricsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationFabricsClientBeginDeleteOptions contains the optional parameters for the ReplicationFabricsClient.BeginDelete
// method.
type ReplicationFabricsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationFabricsClientBeginMigrateToAADOptions contains the optional parameters for the ReplicationFabricsClient.BeginMigrateToAAD
// method.
type ReplicationFabricsClientBeginMigrateToAADOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationFabricsClientBeginPurgeOptions contains the optional parameters for the ReplicationFabricsClient.BeginPurge
// method.
type ReplicationFabricsClientBeginPurgeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationFabricsClientBeginReassociateGatewayOptions contains the optional parameters for the ReplicationFabricsClient.BeginReassociateGateway
// method.
type ReplicationFabricsClientBeginReassociateGatewayOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationFabricsClientBeginRenewCertificateOptions contains the optional parameters for the ReplicationFabricsClient.BeginRenewCertificate
// method.
type ReplicationFabricsClientBeginRenewCertificateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationFabricsClientGetOptions contains the optional parameters for the ReplicationFabricsClient.Get method.
type ReplicationFabricsClientGetOptions struct {
	// OData filter options.
	Filter *string
}

// ReplicationFabricsClientListOptions contains the optional parameters for the ReplicationFabricsClient.List method.
type ReplicationFabricsClientListOptions struct {
	// placeholder for future optional parameters
}

// ReplicationGroupDetails - Replication group details. This will be used in case of San.
type ReplicationGroupDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetConfigurationSettings implements the ConfigurationSettingsClassification interface for type ReplicationGroupDetails.
func (r *ReplicationGroupDetails) GetConfigurationSettings() *ConfigurationSettings {
	return &ConfigurationSettings{
		InstanceType: r.InstanceType,
	}
}

// ReplicationJobsClientBeginCancelOptions contains the optional parameters for the ReplicationJobsClient.BeginCancel method.
type ReplicationJobsClientBeginCancelOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationJobsClientBeginExportOptions contains the optional parameters for the ReplicationJobsClient.BeginExport method.
type ReplicationJobsClientBeginExportOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationJobsClientBeginRestartOptions contains the optional parameters for the ReplicationJobsClient.BeginRestart method.
type ReplicationJobsClientBeginRestartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationJobsClientBeginResumeOptions contains the optional parameters for the ReplicationJobsClient.BeginResume method.
type ReplicationJobsClientBeginResumeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationJobsClientGetOptions contains the optional parameters for the ReplicationJobsClient.Get method.
type ReplicationJobsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ReplicationJobsClientListOptions contains the optional parameters for the ReplicationJobsClient.List method.
type ReplicationJobsClientListOptions struct {
	// OData filter options.
	Filter *string
}

// ReplicationLogicalNetworksClientGetOptions contains the optional parameters for the ReplicationLogicalNetworksClient.Get
// method.
type ReplicationLogicalNetworksClientGetOptions struct {
	// placeholder for future optional parameters
}

// ReplicationLogicalNetworksClientListByReplicationFabricsOptions contains the optional parameters for the ReplicationLogicalNetworksClient.ListByReplicationFabrics
// method.
type ReplicationLogicalNetworksClientListByReplicationFabricsOptions struct {
	// placeholder for future optional parameters
}

// ReplicationMigrationItemsClientBeginCreateOptions contains the optional parameters for the ReplicationMigrationItemsClient.BeginCreate
// method.
type ReplicationMigrationItemsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationMigrationItemsClientBeginDeleteOptions contains the optional parameters for the ReplicationMigrationItemsClient.BeginDelete
// method.
type ReplicationMigrationItemsClientBeginDeleteOptions struct {
	// The delete option.
	DeleteOption *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationMigrationItemsClientBeginMigrateOptions contains the optional parameters for the ReplicationMigrationItemsClient.BeginMigrate
// method.
type ReplicationMigrationItemsClientBeginMigrateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationMigrationItemsClientBeginResyncOptions contains the optional parameters for the ReplicationMigrationItemsClient.BeginResync
// method.
type ReplicationMigrationItemsClientBeginResyncOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationMigrationItemsClientBeginTestMigrateCleanupOptions contains the optional parameters for the ReplicationMigrationItemsClient.BeginTestMigrateCleanup
// method.
type ReplicationMigrationItemsClientBeginTestMigrateCleanupOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationMigrationItemsClientBeginTestMigrateOptions contains the optional parameters for the ReplicationMigrationItemsClient.BeginTestMigrate
// method.
type ReplicationMigrationItemsClientBeginTestMigrateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationMigrationItemsClientBeginUpdateOptions contains the optional parameters for the ReplicationMigrationItemsClient.BeginUpdate
// method.
type ReplicationMigrationItemsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationMigrationItemsClientGetOptions contains the optional parameters for the ReplicationMigrationItemsClient.Get
// method.
type ReplicationMigrationItemsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ReplicationMigrationItemsClientListByReplicationProtectionContainersOptions contains the optional parameters for the ReplicationMigrationItemsClient.ListByReplicationProtectionContainers
// method.
type ReplicationMigrationItemsClientListByReplicationProtectionContainersOptions struct {
	// OData filter options.
	Filter *string
	// The pagination token.
	SkipToken *string
	// The page size.
	TakeToken *string
}

// ReplicationMigrationItemsClientListOptions contains the optional parameters for the ReplicationMigrationItemsClient.List
// method.
type ReplicationMigrationItemsClientListOptions struct {
	// OData filter options.
	Filter *string
	// The pagination token.
	SkipToken *string
	// The page size.
	TakeToken *string
}

// ReplicationNetworkMappingsClientBeginCreateOptions contains the optional parameters for the ReplicationNetworkMappingsClient.BeginCreate
// method.
type ReplicationNetworkMappingsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationNetworkMappingsClientBeginDeleteOptions contains the optional parameters for the ReplicationNetworkMappingsClient.BeginDelete
// method.
type ReplicationNetworkMappingsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationNetworkMappingsClientBeginUpdateOptions contains the optional parameters for the ReplicationNetworkMappingsClient.BeginUpdate
// method.
type ReplicationNetworkMappingsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationNetworkMappingsClientGetOptions contains the optional parameters for the ReplicationNetworkMappingsClient.Get
// method.
type ReplicationNetworkMappingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ReplicationNetworkMappingsClientListByReplicationNetworksOptions contains the optional parameters for the ReplicationNetworkMappingsClient.ListByReplicationNetworks
// method.
type ReplicationNetworkMappingsClientListByReplicationNetworksOptions struct {
	// placeholder for future optional parameters
}

// ReplicationNetworkMappingsClientListOptions contains the optional parameters for the ReplicationNetworkMappingsClient.List
// method.
type ReplicationNetworkMappingsClientListOptions struct {
	// placeholder for future optional parameters
}

// ReplicationNetworksClientGetOptions contains the optional parameters for the ReplicationNetworksClient.Get method.
type ReplicationNetworksClientGetOptions struct {
	// placeholder for future optional parameters
}

// ReplicationNetworksClientListByReplicationFabricsOptions contains the optional parameters for the ReplicationNetworksClient.ListByReplicationFabrics
// method.
type ReplicationNetworksClientListByReplicationFabricsOptions struct {
	// placeholder for future optional parameters
}

// ReplicationNetworksClientListOptions contains the optional parameters for the ReplicationNetworksClient.List method.
type ReplicationNetworksClientListOptions struct {
	// placeholder for future optional parameters
}

// ReplicationPoliciesClientBeginCreateOptions contains the optional parameters for the ReplicationPoliciesClient.BeginCreate
// method.
type ReplicationPoliciesClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationPoliciesClientBeginDeleteOptions contains the optional parameters for the ReplicationPoliciesClient.BeginDelete
// method.
type ReplicationPoliciesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationPoliciesClientBeginUpdateOptions contains the optional parameters for the ReplicationPoliciesClient.BeginUpdate
// method.
type ReplicationPoliciesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationPoliciesClientGetOptions contains the optional parameters for the ReplicationPoliciesClient.Get method.
type ReplicationPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ReplicationPoliciesClientListOptions contains the optional parameters for the ReplicationPoliciesClient.List method.
type ReplicationPoliciesClientListOptions struct {
	// placeholder for future optional parameters
}

// ReplicationProtectableItemsClientGetOptions contains the optional parameters for the ReplicationProtectableItemsClient.Get
// method.
type ReplicationProtectableItemsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ReplicationProtectableItemsClientListByReplicationProtectionContainersOptions contains the optional parameters for the
// ReplicationProtectableItemsClient.ListByReplicationProtectionContainers method.
type ReplicationProtectableItemsClientListByReplicationProtectionContainersOptions struct {
	// OData filter options.
	Filter *string
	// skipToken OData query parameter.
	SkipToken *string
	// take OData query parameter.
	Take *string
}

// ReplicationProtectedItem - Replication protected item.
type ReplicationProtectedItem struct {
	// Resource Location
	Location *string `json:"location,omitempty"`

	// The custom data.
	Properties *ReplicationProtectedItemProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ReplicationProtectedItemCollection - Replication protected item collection.
type ReplicationProtectedItemCollection struct {
	// The value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// The Replication protected item details.
	Value []*ReplicationProtectedItem `json:"value,omitempty"`
}

// ReplicationProtectedItemProperties - Replication protected item custom data details.
type ReplicationProtectedItemProperties struct {
	// The Current active location of the PE.
	ActiveLocation *string `json:"activeLocation,omitempty"`

	// The allowed operations on the Replication protected item.
	AllowedOperations []*string `json:"allowedOperations,omitempty"`

	// The current scenario.
	CurrentScenario *CurrentScenarioDetails `json:"currentScenario,omitempty"`

	// The correlation Id for events associated with this protected item.
	EventCorrelationID *string `json:"eventCorrelationId,omitempty"`

	// The consolidated failover health for the VM.
	FailoverHealth *string `json:"failoverHealth,omitempty"`

	// The recovery point ARM Id to which the Vm was failed over.
	FailoverRecoveryPointID *string `json:"failoverRecoveryPointId,omitempty"`

	// The name.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// List of health errors.
	HealthErrors []*HealthError `json:"healthErrors,omitempty"`

	// The Last successful failover time.
	LastSuccessfulFailoverTime *time.Time `json:"lastSuccessfulFailoverTime,omitempty"`

	// The Last successful test failover time.
	LastSuccessfulTestFailoverTime *time.Time `json:"lastSuccessfulTestFailoverTime,omitempty"`

	// The name of Policy governing this PE.
	PolicyFriendlyName *string `json:"policyFriendlyName,omitempty"`

	// The ID of Policy governing this PE.
	PolicyID *string `json:"policyId,omitempty"`

	// The friendly name of the primary fabric.
	PrimaryFabricFriendlyName *string `json:"primaryFabricFriendlyName,omitempty"`

	// The fabric provider of the primary fabric.
	PrimaryFabricProvider *string `json:"primaryFabricProvider,omitempty"`

	// The name of primary protection container friendly name.
	PrimaryProtectionContainerFriendlyName *string `json:"primaryProtectionContainerFriendlyName,omitempty"`

	// The protected item ARM Id.
	ProtectableItemID *string `json:"protectableItemId,omitempty"`

	// The type of protected item type.
	ProtectedItemType *string `json:"protectedItemType,omitempty"`

	// The protection status.
	ProtectionState *string `json:"protectionState,omitempty"`

	// The protection state description.
	ProtectionStateDescription *string `json:"protectionStateDescription,omitempty"`

	// The Replication provider custom settings.
	ProviderSpecificDetails ReplicationProviderSpecificSettingsClassification `json:"providerSpecificDetails,omitempty"`

	// The recovery container Id.
	RecoveryContainerID *string `json:"recoveryContainerId,omitempty"`

	// The friendly name of recovery fabric.
	RecoveryFabricFriendlyName *string `json:"recoveryFabricFriendlyName,omitempty"`

	// The Arm Id of recovery fabric.
	RecoveryFabricID *string `json:"recoveryFabricId,omitempty"`

	// The name of recovery container friendly name.
	RecoveryProtectionContainerFriendlyName *string `json:"recoveryProtectionContainerFriendlyName,omitempty"`

	// The recovery provider ARM Id.
	RecoveryServicesProviderID *string `json:"recoveryServicesProviderId,omitempty"`

	// The consolidated protection health for the VM taking any issues with SRS as well as all the replication units associated
	// with the VM's replication group into account. This is a string representation
	// of the ProtectionHealth enumeration.
	ReplicationHealth *string `json:"replicationHealth,omitempty"`

	// The switch provider state.
	SwitchProviderState *string `json:"switchProviderState,omitempty"`

	// The switch provider state description.
	SwitchProviderStateDescription *string `json:"switchProviderStateDescription,omitempty"`

	// The Test failover state.
	TestFailoverState *string `json:"testFailoverState,omitempty"`

	// The Test failover state description.
	TestFailoverStateDescription *string `json:"testFailoverStateDescription,omitempty"`
}

// ReplicationProtectedItemsClientBeginAddDisksOptions contains the optional parameters for the ReplicationProtectedItemsClient.BeginAddDisks
// method.
type ReplicationProtectedItemsClientBeginAddDisksOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationProtectedItemsClientBeginApplyRecoveryPointOptions contains the optional parameters for the ReplicationProtectedItemsClient.BeginApplyRecoveryPoint
// method.
type ReplicationProtectedItemsClientBeginApplyRecoveryPointOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationProtectedItemsClientBeginCreateOptions contains the optional parameters for the ReplicationProtectedItemsClient.BeginCreate
// method.
type ReplicationProtectedItemsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationProtectedItemsClientBeginDeleteOptions contains the optional parameters for the ReplicationProtectedItemsClient.BeginDelete
// method.
type ReplicationProtectedItemsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationProtectedItemsClientBeginFailoverCancelOptions contains the optional parameters for the ReplicationProtectedItemsClient.BeginFailoverCancel
// method.
type ReplicationProtectedItemsClientBeginFailoverCancelOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationProtectedItemsClientBeginFailoverCommitOptions contains the optional parameters for the ReplicationProtectedItemsClient.BeginFailoverCommit
// method.
type ReplicationProtectedItemsClientBeginFailoverCommitOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationProtectedItemsClientBeginPlannedFailoverOptions contains the optional parameters for the ReplicationProtectedItemsClient.BeginPlannedFailover
// method.
type ReplicationProtectedItemsClientBeginPlannedFailoverOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationProtectedItemsClientBeginPurgeOptions contains the optional parameters for the ReplicationProtectedItemsClient.BeginPurge
// method.
type ReplicationProtectedItemsClientBeginPurgeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationProtectedItemsClientBeginRemoveDisksOptions contains the optional parameters for the ReplicationProtectedItemsClient.BeginRemoveDisks
// method.
type ReplicationProtectedItemsClientBeginRemoveDisksOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationProtectedItemsClientBeginRepairReplicationOptions contains the optional parameters for the ReplicationProtectedItemsClient.BeginRepairReplication
// method.
type ReplicationProtectedItemsClientBeginRepairReplicationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationProtectedItemsClientBeginReprotectOptions contains the optional parameters for the ReplicationProtectedItemsClient.BeginReprotect
// method.
type ReplicationProtectedItemsClientBeginReprotectOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationProtectedItemsClientBeginResolveHealthErrorsOptions contains the optional parameters for the ReplicationProtectedItemsClient.BeginResolveHealthErrors
// method.
type ReplicationProtectedItemsClientBeginResolveHealthErrorsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationProtectedItemsClientBeginSwitchProviderOptions contains the optional parameters for the ReplicationProtectedItemsClient.BeginSwitchProvider
// method.
type ReplicationProtectedItemsClientBeginSwitchProviderOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationProtectedItemsClientBeginTestFailoverCleanupOptions contains the optional parameters for the ReplicationProtectedItemsClient.BeginTestFailoverCleanup
// method.
type ReplicationProtectedItemsClientBeginTestFailoverCleanupOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationProtectedItemsClientBeginTestFailoverOptions contains the optional parameters for the ReplicationProtectedItemsClient.BeginTestFailover
// method.
type ReplicationProtectedItemsClientBeginTestFailoverOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationProtectedItemsClientBeginUnplannedFailoverOptions contains the optional parameters for the ReplicationProtectedItemsClient.BeginUnplannedFailover
// method.
type ReplicationProtectedItemsClientBeginUnplannedFailoverOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationProtectedItemsClientBeginUpdateApplianceOptions contains the optional parameters for the ReplicationProtectedItemsClient.BeginUpdateAppliance
// method.
type ReplicationProtectedItemsClientBeginUpdateApplianceOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationProtectedItemsClientBeginUpdateMobilityServiceOptions contains the optional parameters for the ReplicationProtectedItemsClient.BeginUpdateMobilityService
// method.
type ReplicationProtectedItemsClientBeginUpdateMobilityServiceOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationProtectedItemsClientBeginUpdateOptions contains the optional parameters for the ReplicationProtectedItemsClient.BeginUpdate
// method.
type ReplicationProtectedItemsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationProtectedItemsClientGetOptions contains the optional parameters for the ReplicationProtectedItemsClient.Get
// method.
type ReplicationProtectedItemsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ReplicationProtectedItemsClientListByReplicationProtectionContainersOptions contains the optional parameters for the ReplicationProtectedItemsClient.ListByReplicationProtectionContainers
// method.
type ReplicationProtectedItemsClientListByReplicationProtectionContainersOptions struct {
	// placeholder for future optional parameters
}

// ReplicationProtectedItemsClientListOptions contains the optional parameters for the ReplicationProtectedItemsClient.List
// method.
type ReplicationProtectedItemsClientListOptions struct {
	// OData filter options.
	Filter *string
	// The pagination token. Possible values: "FabricId" or "FabricId_CloudId" or null.
	SkipToken *string
}

// ReplicationProtectionContainerMappingsClientBeginCreateOptions contains the optional parameters for the ReplicationProtectionContainerMappingsClient.BeginCreate
// method.
type ReplicationProtectionContainerMappingsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationProtectionContainerMappingsClientBeginDeleteOptions contains the optional parameters for the ReplicationProtectionContainerMappingsClient.BeginDelete
// method.
type ReplicationProtectionContainerMappingsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationProtectionContainerMappingsClientBeginPurgeOptions contains the optional parameters for the ReplicationProtectionContainerMappingsClient.BeginPurge
// method.
type ReplicationProtectionContainerMappingsClientBeginPurgeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationProtectionContainerMappingsClientBeginUpdateOptions contains the optional parameters for the ReplicationProtectionContainerMappingsClient.BeginUpdate
// method.
type ReplicationProtectionContainerMappingsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationProtectionContainerMappingsClientGetOptions contains the optional parameters for the ReplicationProtectionContainerMappingsClient.Get
// method.
type ReplicationProtectionContainerMappingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ReplicationProtectionContainerMappingsClientListByReplicationProtectionContainersOptions contains the optional parameters
// for the ReplicationProtectionContainerMappingsClient.ListByReplicationProtectionContainers method.
type ReplicationProtectionContainerMappingsClientListByReplicationProtectionContainersOptions struct {
	// placeholder for future optional parameters
}

// ReplicationProtectionContainerMappingsClientListOptions contains the optional parameters for the ReplicationProtectionContainerMappingsClient.List
// method.
type ReplicationProtectionContainerMappingsClientListOptions struct {
	// placeholder for future optional parameters
}

// ReplicationProtectionContainersClientBeginCreateOptions contains the optional parameters for the ReplicationProtectionContainersClient.BeginCreate
// method.
type ReplicationProtectionContainersClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationProtectionContainersClientBeginDeleteOptions contains the optional parameters for the ReplicationProtectionContainersClient.BeginDelete
// method.
type ReplicationProtectionContainersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationProtectionContainersClientBeginDiscoverProtectableItemOptions contains the optional parameters for the ReplicationProtectionContainersClient.BeginDiscoverProtectableItem
// method.
type ReplicationProtectionContainersClientBeginDiscoverProtectableItemOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationProtectionContainersClientBeginSwitchProtectionOptions contains the optional parameters for the ReplicationProtectionContainersClient.BeginSwitchProtection
// method.
type ReplicationProtectionContainersClientBeginSwitchProtectionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationProtectionContainersClientGetOptions contains the optional parameters for the ReplicationProtectionContainersClient.Get
// method.
type ReplicationProtectionContainersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ReplicationProtectionContainersClientListByReplicationFabricsOptions contains the optional parameters for the ReplicationProtectionContainersClient.ListByReplicationFabrics
// method.
type ReplicationProtectionContainersClientListByReplicationFabricsOptions struct {
	// placeholder for future optional parameters
}

// ReplicationProtectionContainersClientListOptions contains the optional parameters for the ReplicationProtectionContainersClient.List
// method.
type ReplicationProtectionContainersClientListOptions struct {
	// placeholder for future optional parameters
}

// ReplicationProtectionIntent - Replication protection intent.
type ReplicationProtectionIntent struct {
	// Resource Location
	Location *string `json:"location,omitempty"`

	// The custom data.
	Properties *ReplicationProtectionIntentProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ReplicationProtectionIntentCollection - Replication protection intent objects collection.
type ReplicationProtectionIntentCollection struct {
	// The value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// The Replication protection intent details.
	Value []*ReplicationProtectionIntent `json:"value,omitempty"`
}

// ReplicationProtectionIntentProperties - Replication protection intent custom data details.
type ReplicationProtectionIntentProperties struct {
	// The name.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// The Replication provider custom settings.
	ProviderSpecificDetails ReplicationProtectionIntentProviderSpecificSettingsClassification `json:"providerSpecificDetails,omitempty"`

	// READ-ONLY; The creation time in UTC.
	CreationTimeUTC *string `json:"creationTimeUTC,omitempty" azure:"ro"`

	// READ-ONLY; A value indicating whether the intent object is active.
	IsActive *bool `json:"isActive,omitempty" azure:"ro"`

	// READ-ONLY; The job Id.
	JobID *string `json:"jobId,omitempty" azure:"ro"`

	// READ-ONLY; The job state.
	JobState *string `json:"jobState,omitempty" azure:"ro"`
}

// ReplicationProtectionIntentProviderSpecificSettingsClassification provides polymorphic access to related types.
// Call the interface's GetReplicationProtectionIntentProviderSpecificSettings() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *A2AReplicationIntentDetails, *ReplicationProtectionIntentProviderSpecificSettings
type ReplicationProtectionIntentProviderSpecificSettingsClassification interface {
	// GetReplicationProtectionIntentProviderSpecificSettings returns the ReplicationProtectionIntentProviderSpecificSettings content of the underlying type.
	GetReplicationProtectionIntentProviderSpecificSettings() *ReplicationProtectionIntentProviderSpecificSettings
}

// ReplicationProtectionIntentProviderSpecificSettings - Replication provider specific settings.
type ReplicationProtectionIntentProviderSpecificSettings struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetReplicationProtectionIntentProviderSpecificSettings implements the ReplicationProtectionIntentProviderSpecificSettingsClassification
// interface for type ReplicationProtectionIntentProviderSpecificSettings.
func (r *ReplicationProtectionIntentProviderSpecificSettings) GetReplicationProtectionIntentProviderSpecificSettings() *ReplicationProtectionIntentProviderSpecificSettings {
	return r
}

// ReplicationProtectionIntentsClientCreateOptions contains the optional parameters for the ReplicationProtectionIntentsClient.Create
// method.
type ReplicationProtectionIntentsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// ReplicationProtectionIntentsClientGetOptions contains the optional parameters for the ReplicationProtectionIntentsClient.Get
// method.
type ReplicationProtectionIntentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ReplicationProtectionIntentsClientListOptions contains the optional parameters for the ReplicationProtectionIntentsClient.List
// method.
type ReplicationProtectionIntentsClientListOptions struct {
	// The pagination token.
	SkipToken *string
	// The page size.
	TakeToken *string
}

// ReplicationProviderContainerUnmappingInput - Provider specific input for unpairing operations.
type ReplicationProviderContainerUnmappingInput struct {
	// The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// ReplicationProviderSpecificContainerCreationInputClassification provides polymorphic access to related types.
// Call the interface's GetReplicationProviderSpecificContainerCreationInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *A2AContainerCreationInput, *A2ACrossClusterMigrationContainerCreationInput, *ReplicationProviderSpecificContainerCreationInput,
// - *VMwareCbtContainerCreationInput
type ReplicationProviderSpecificContainerCreationInputClassification interface {
	// GetReplicationProviderSpecificContainerCreationInput returns the ReplicationProviderSpecificContainerCreationInput content of the underlying type.
	GetReplicationProviderSpecificContainerCreationInput() *ReplicationProviderSpecificContainerCreationInput
}

// ReplicationProviderSpecificContainerCreationInput - Provider specific input for container creation operation.
type ReplicationProviderSpecificContainerCreationInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetReplicationProviderSpecificContainerCreationInput implements the ReplicationProviderSpecificContainerCreationInputClassification
// interface for type ReplicationProviderSpecificContainerCreationInput.
func (r *ReplicationProviderSpecificContainerCreationInput) GetReplicationProviderSpecificContainerCreationInput() *ReplicationProviderSpecificContainerCreationInput {
	return r
}

// ReplicationProviderSpecificContainerMappingInputClassification provides polymorphic access to related types.
// Call the interface's GetReplicationProviderSpecificContainerMappingInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *A2AContainerMappingInput, *ReplicationProviderSpecificContainerMappingInput, *VMwareCbtContainerMappingInput
type ReplicationProviderSpecificContainerMappingInputClassification interface {
	// GetReplicationProviderSpecificContainerMappingInput returns the ReplicationProviderSpecificContainerMappingInput content of the underlying type.
	GetReplicationProviderSpecificContainerMappingInput() *ReplicationProviderSpecificContainerMappingInput
}

// ReplicationProviderSpecificContainerMappingInput - Provider specific input for pairing operations.
type ReplicationProviderSpecificContainerMappingInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetReplicationProviderSpecificContainerMappingInput implements the ReplicationProviderSpecificContainerMappingInputClassification
// interface for type ReplicationProviderSpecificContainerMappingInput.
func (r *ReplicationProviderSpecificContainerMappingInput) GetReplicationProviderSpecificContainerMappingInput() *ReplicationProviderSpecificContainerMappingInput {
	return r
}

// ReplicationProviderSpecificSettingsClassification provides polymorphic access to related types.
// Call the interface's GetReplicationProviderSpecificSettings() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *A2ACrossClusterMigrationReplicationDetails, *A2AReplicationDetails, *HyperVReplicaAzureReplicationDetails, *HyperVReplicaBaseReplicationDetails,
// - *HyperVReplicaBlueReplicationDetails, *HyperVReplicaReplicationDetails, *InMageAzureV2ReplicationDetails, *InMageRcmFailbackReplicationDetails,
// - *InMageRcmReplicationDetails, *InMageReplicationDetails, *ReplicationProviderSpecificSettings
type ReplicationProviderSpecificSettingsClassification interface {
	// GetReplicationProviderSpecificSettings returns the ReplicationProviderSpecificSettings content of the underlying type.
	GetReplicationProviderSpecificSettings() *ReplicationProviderSpecificSettings
}

// ReplicationProviderSpecificSettings - Replication provider specific settings.
type ReplicationProviderSpecificSettings struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetReplicationProviderSpecificSettings implements the ReplicationProviderSpecificSettingsClassification interface for type
// ReplicationProviderSpecificSettings.
func (r *ReplicationProviderSpecificSettings) GetReplicationProviderSpecificSettings() *ReplicationProviderSpecificSettings {
	return r
}

// ReplicationProviderSpecificUpdateContainerMappingInputClassification provides polymorphic access to related types.
// Call the interface's GetReplicationProviderSpecificUpdateContainerMappingInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *A2AUpdateContainerMappingInput, *InMageRcmUpdateContainerMappingInput, *ReplicationProviderSpecificUpdateContainerMappingInput
type ReplicationProviderSpecificUpdateContainerMappingInputClassification interface {
	// GetReplicationProviderSpecificUpdateContainerMappingInput returns the ReplicationProviderSpecificUpdateContainerMappingInput content of the underlying type.
	GetReplicationProviderSpecificUpdateContainerMappingInput() *ReplicationProviderSpecificUpdateContainerMappingInput
}

// ReplicationProviderSpecificUpdateContainerMappingInput - Provider specific input for update pairing operations.
type ReplicationProviderSpecificUpdateContainerMappingInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetReplicationProviderSpecificUpdateContainerMappingInput implements the ReplicationProviderSpecificUpdateContainerMappingInputClassification
// interface for type ReplicationProviderSpecificUpdateContainerMappingInput.
func (r *ReplicationProviderSpecificUpdateContainerMappingInput) GetReplicationProviderSpecificUpdateContainerMappingInput() *ReplicationProviderSpecificUpdateContainerMappingInput {
	return r
}

// ReplicationRecoveryPlansClientBeginCreateOptions contains the optional parameters for the ReplicationRecoveryPlansClient.BeginCreate
// method.
type ReplicationRecoveryPlansClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationRecoveryPlansClientBeginDeleteOptions contains the optional parameters for the ReplicationRecoveryPlansClient.BeginDelete
// method.
type ReplicationRecoveryPlansClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationRecoveryPlansClientBeginFailoverCancelOptions contains the optional parameters for the ReplicationRecoveryPlansClient.BeginFailoverCancel
// method.
type ReplicationRecoveryPlansClientBeginFailoverCancelOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationRecoveryPlansClientBeginFailoverCommitOptions contains the optional parameters for the ReplicationRecoveryPlansClient.BeginFailoverCommit
// method.
type ReplicationRecoveryPlansClientBeginFailoverCommitOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationRecoveryPlansClientBeginPlannedFailoverOptions contains the optional parameters for the ReplicationRecoveryPlansClient.BeginPlannedFailover
// method.
type ReplicationRecoveryPlansClientBeginPlannedFailoverOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationRecoveryPlansClientBeginReprotectOptions contains the optional parameters for the ReplicationRecoveryPlansClient.BeginReprotect
// method.
type ReplicationRecoveryPlansClientBeginReprotectOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationRecoveryPlansClientBeginTestFailoverCleanupOptions contains the optional parameters for the ReplicationRecoveryPlansClient.BeginTestFailoverCleanup
// method.
type ReplicationRecoveryPlansClientBeginTestFailoverCleanupOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationRecoveryPlansClientBeginTestFailoverOptions contains the optional parameters for the ReplicationRecoveryPlansClient.BeginTestFailover
// method.
type ReplicationRecoveryPlansClientBeginTestFailoverOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationRecoveryPlansClientBeginUnplannedFailoverOptions contains the optional parameters for the ReplicationRecoveryPlansClient.BeginUnplannedFailover
// method.
type ReplicationRecoveryPlansClientBeginUnplannedFailoverOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationRecoveryPlansClientBeginUpdateOptions contains the optional parameters for the ReplicationRecoveryPlansClient.BeginUpdate
// method.
type ReplicationRecoveryPlansClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationRecoveryPlansClientGetOptions contains the optional parameters for the ReplicationRecoveryPlansClient.Get method.
type ReplicationRecoveryPlansClientGetOptions struct {
	// placeholder for future optional parameters
}

// ReplicationRecoveryPlansClientListOptions contains the optional parameters for the ReplicationRecoveryPlansClient.List
// method.
type ReplicationRecoveryPlansClientListOptions struct {
	// placeholder for future optional parameters
}

// ReplicationRecoveryServicesProvidersClientBeginCreateOptions contains the optional parameters for the ReplicationRecoveryServicesProvidersClient.BeginCreate
// method.
type ReplicationRecoveryServicesProvidersClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationRecoveryServicesProvidersClientBeginDeleteOptions contains the optional parameters for the ReplicationRecoveryServicesProvidersClient.BeginDelete
// method.
type ReplicationRecoveryServicesProvidersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationRecoveryServicesProvidersClientBeginPurgeOptions contains the optional parameters for the ReplicationRecoveryServicesProvidersClient.BeginPurge
// method.
type ReplicationRecoveryServicesProvidersClientBeginPurgeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationRecoveryServicesProvidersClientBeginRefreshProviderOptions contains the optional parameters for the ReplicationRecoveryServicesProvidersClient.BeginRefreshProvider
// method.
type ReplicationRecoveryServicesProvidersClientBeginRefreshProviderOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationRecoveryServicesProvidersClientGetOptions contains the optional parameters for the ReplicationRecoveryServicesProvidersClient.Get
// method.
type ReplicationRecoveryServicesProvidersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ReplicationRecoveryServicesProvidersClientListByReplicationFabricsOptions contains the optional parameters for the ReplicationRecoveryServicesProvidersClient.ListByReplicationFabrics
// method.
type ReplicationRecoveryServicesProvidersClientListByReplicationFabricsOptions struct {
	// placeholder for future optional parameters
}

// ReplicationRecoveryServicesProvidersClientListOptions contains the optional parameters for the ReplicationRecoveryServicesProvidersClient.List
// method.
type ReplicationRecoveryServicesProvidersClientListOptions struct {
	// placeholder for future optional parameters
}

// ReplicationStorageClassificationMappingsClientBeginCreateOptions contains the optional parameters for the ReplicationStorageClassificationMappingsClient.BeginCreate
// method.
type ReplicationStorageClassificationMappingsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationStorageClassificationMappingsClientBeginDeleteOptions contains the optional parameters for the ReplicationStorageClassificationMappingsClient.BeginDelete
// method.
type ReplicationStorageClassificationMappingsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationStorageClassificationMappingsClientGetOptions contains the optional parameters for the ReplicationStorageClassificationMappingsClient.Get
// method.
type ReplicationStorageClassificationMappingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ReplicationStorageClassificationMappingsClientListByReplicationStorageClassificationsOptions contains the optional parameters
// for the ReplicationStorageClassificationMappingsClient.ListByReplicationStorageClassifications method.
type ReplicationStorageClassificationMappingsClientListByReplicationStorageClassificationsOptions struct {
	// placeholder for future optional parameters
}

// ReplicationStorageClassificationMappingsClientListOptions contains the optional parameters for the ReplicationStorageClassificationMappingsClient.List
// method.
type ReplicationStorageClassificationMappingsClientListOptions struct {
	// placeholder for future optional parameters
}

// ReplicationStorageClassificationsClientGetOptions contains the optional parameters for the ReplicationStorageClassificationsClient.Get
// method.
type ReplicationStorageClassificationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ReplicationStorageClassificationsClientListByReplicationFabricsOptions contains the optional parameters for the ReplicationStorageClassificationsClient.ListByReplicationFabrics
// method.
type ReplicationStorageClassificationsClientListByReplicationFabricsOptions struct {
	// placeholder for future optional parameters
}

// ReplicationStorageClassificationsClientListOptions contains the optional parameters for the ReplicationStorageClassificationsClient.List
// method.
type ReplicationStorageClassificationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ReplicationVaultHealthClientBeginRefreshOptions contains the optional parameters for the ReplicationVaultHealthClient.BeginRefresh
// method.
type ReplicationVaultHealthClientBeginRefreshOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationVaultHealthClientGetOptions contains the optional parameters for the ReplicationVaultHealthClient.Get method.
type ReplicationVaultHealthClientGetOptions struct {
	// placeholder for future optional parameters
}

// ReplicationVaultSettingClientBeginCreateOptions contains the optional parameters for the ReplicationVaultSettingClient.BeginCreate
// method.
type ReplicationVaultSettingClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationVaultSettingClientGetOptions contains the optional parameters for the ReplicationVaultSettingClient.Get method.
type ReplicationVaultSettingClientGetOptions struct {
	// placeholder for future optional parameters
}

// ReplicationVaultSettingClientListOptions contains the optional parameters for the ReplicationVaultSettingClient.List method.
type ReplicationVaultSettingClientListOptions struct {
	// placeholder for future optional parameters
}

// ReplicationvCentersClientBeginCreateOptions contains the optional parameters for the ReplicationvCentersClient.BeginCreate
// method.
type ReplicationvCentersClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationvCentersClientBeginDeleteOptions contains the optional parameters for the ReplicationvCentersClient.BeginDelete
// method.
type ReplicationvCentersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationvCentersClientBeginUpdateOptions contains the optional parameters for the ReplicationvCentersClient.BeginUpdate
// method.
type ReplicationvCentersClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationvCentersClientGetOptions contains the optional parameters for the ReplicationvCentersClient.Get method.
type ReplicationvCentersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ReplicationvCentersClientListByReplicationFabricsOptions contains the optional parameters for the ReplicationvCentersClient.ListByReplicationFabrics
// method.
type ReplicationvCentersClientListByReplicationFabricsOptions struct {
	// placeholder for future optional parameters
}

// ReplicationvCentersClientListOptions contains the optional parameters for the ReplicationvCentersClient.List method.
type ReplicationvCentersClientListOptions struct {
	// placeholder for future optional parameters
}

// ReprotectAgentDetails - Reprotect agent details.
type ReprotectAgentDetails struct {
	// READ-ONLY; The list of accessible datastores fetched from discovery.
	AccessibleDatastores []*string `json:"accessibleDatastores,omitempty" azure:"ro"`

	// READ-ONLY; The reprotect agent Bios Id.
	BiosID *string `json:"biosId,omitempty" azure:"ro"`

	// READ-ONLY; The fabric object Id.
	FabricObjectID *string `json:"fabricObjectId,omitempty" azure:"ro"`

	// READ-ONLY; The reprotect agent Fqdn.
	Fqdn *string `json:"fqdn,omitempty" azure:"ro"`

	// READ-ONLY; The health of the reprotect agent.
	Health *ProtectionHealth `json:"health,omitempty" azure:"ro"`

	// READ-ONLY; The health errors.
	HealthErrors []*HealthError `json:"healthErrors,omitempty" azure:"ro"`

	// READ-ONLY; The reprotect agent Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The last time when SDS information discovered in SRS.
	LastDiscoveryInUTC *time.Time `json:"lastDiscoveryInUtc,omitempty" azure:"ro"`

	// READ-ONLY; The last heartbeat received from the reprotect agent.
	LastHeartbeatUTC *time.Time `json:"lastHeartbeatUtc,omitempty" azure:"ro"`

	// READ-ONLY; The reprotect agent name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The protected item count.
	ProtectedItemCount *int32 `json:"protectedItemCount,omitempty" azure:"ro"`

	// READ-ONLY; The Vcenter Id.
	VcenterID *string `json:"vcenterId,omitempty" azure:"ro"`

	// READ-ONLY; The version.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// ResolveHealthError - Resolve health errors input properties.
type ResolveHealthError struct {
	// Health error id.
	HealthErrorID *string `json:"healthErrorId,omitempty"`
}

// ResolveHealthInput - Resolve health input.
type ResolveHealthInput struct {
	// Disable resolve health input properties.
	Properties *ResolveHealthInputProperties `json:"properties,omitempty"`
}

// ResolveHealthInputProperties - Resolve health input properties.
type ResolveHealthInputProperties struct {
	// Health errors.
	HealthErrors []*ResolveHealthError `json:"healthErrors,omitempty"`
}

// Resource - Azure resource.
type Resource struct {
	// Resource Location
	Location *string `json:"location,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceHealthSummary - Base class to define the health summary of the resources contained under an Arm resource.
type ResourceHealthSummary struct {
	// The categorized resource counts.
	CategorizedResourceCounts map[string]*int32 `json:"categorizedResourceCounts,omitempty"`

	// The list of summary of health errors across the resources under the container.
	Issues []*HealthErrorSummary `json:"issues,omitempty"`

	// The count of total resources under the container.
	ResourceCount *int32 `json:"resourceCount,omitempty"`
}

// ResumeJobParams - Resume job params.
type ResumeJobParams struct {
	// Resume job properties.
	Properties *ResumeJobParamsProperties `json:"properties,omitempty"`
}

// ResumeJobParamsProperties - Resume job properties.
type ResumeJobParamsProperties struct {
	// Resume job comments.
	Comments *string `json:"comments,omitempty"`
}

// ResyncInput - Resync input.
type ResyncInput struct {
	// REQUIRED; Resync input properties.
	Properties *ResyncInputProperties `json:"properties,omitempty"`
}

// ResyncInputProperties - Resync input properties.
type ResyncInputProperties struct {
	// REQUIRED; The provider specific details.
	ProviderSpecificDetails ResyncProviderSpecificInputClassification `json:"providerSpecificDetails,omitempty"`
}

// ResyncProviderSpecificInputClassification provides polymorphic access to related types.
// Call the interface's GetResyncProviderSpecificInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ResyncProviderSpecificInput, *VMwareCbtResyncInput
type ResyncProviderSpecificInputClassification interface {
	// GetResyncProviderSpecificInput returns the ResyncProviderSpecificInput content of the underlying type.
	GetResyncProviderSpecificInput() *ResyncProviderSpecificInput
}

// ResyncProviderSpecificInput - Resync provider specific input.
type ResyncProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetResyncProviderSpecificInput implements the ResyncProviderSpecificInputClassification interface for type ResyncProviderSpecificInput.
func (r *ResyncProviderSpecificInput) GetResyncProviderSpecificInput() *ResyncProviderSpecificInput {
	return r
}

// RetentionVolume - The retention details of the MT.
type RetentionVolume struct {
	// The volume capacity.
	CapacityInBytes *int64 `json:"capacityInBytes,omitempty"`

	// The free space available in this volume.
	FreeSpaceInBytes *int64 `json:"freeSpaceInBytes,omitempty"`

	// The threshold percentage.
	ThresholdPercentage *int32 `json:"thresholdPercentage,omitempty"`

	// The volume name.
	VolumeName *string `json:"volumeName,omitempty"`
}

// ReverseReplicationInput - Reverse replication input.
type ReverseReplicationInput struct {
	// Reverse replication properties.
	Properties *ReverseReplicationInputProperties `json:"properties,omitempty"`
}

// ReverseReplicationInputProperties - Reverse replication input properties.
type ReverseReplicationInputProperties struct {
	// Failover direction.
	FailoverDirection *string `json:"failoverDirection,omitempty"`

	// Provider specific reverse replication input.
	ProviderSpecificDetails ReverseReplicationProviderSpecificInputClassification `json:"providerSpecificDetails,omitempty"`
}

// ReverseReplicationProviderSpecificInputClassification provides polymorphic access to related types.
// Call the interface's GetReverseReplicationProviderSpecificInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *A2AReprotectInput, *HyperVReplicaAzureReprotectInput, *InMageAzureV2ReprotectInput, *InMageRcmFailbackReprotectInput,
// - *InMageRcmReprotectInput, *InMageReprotectInput, *ReverseReplicationProviderSpecificInput
type ReverseReplicationProviderSpecificInputClassification interface {
	// GetReverseReplicationProviderSpecificInput returns the ReverseReplicationProviderSpecificInput content of the underlying type.
	GetReverseReplicationProviderSpecificInput() *ReverseReplicationProviderSpecificInput
}

// ReverseReplicationProviderSpecificInput - Provider specific reverse replication input.
type ReverseReplicationProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetReverseReplicationProviderSpecificInput implements the ReverseReplicationProviderSpecificInputClassification interface
// for type ReverseReplicationProviderSpecificInput.
func (r *ReverseReplicationProviderSpecificInput) GetReverseReplicationProviderSpecificInput() *ReverseReplicationProviderSpecificInput {
	return r
}

// RoleAssignment - Azure role assignment details.
type RoleAssignment struct {
	// The ARM Id of the role assignment.
	ID *string `json:"id,omitempty"`

	// The name of the role assignment.
	Name *string `json:"name,omitempty"`

	// Principal Id.
	PrincipalID *string `json:"principalId,omitempty"`

	// Role definition id.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`

	// Role assignment scope.
	Scope *string `json:"scope,omitempty"`
}

// RunAsAccount - CS Accounts Details.
type RunAsAccount struct {
	// The CS RunAs account Id.
	AccountID *string `json:"accountId,omitempty"`

	// The CS RunAs account name.
	AccountName *string `json:"accountName,omitempty"`
}

// ScriptActionTaskDetails - This class represents the script action task details.
type ScriptActionTaskDetails struct {
	// REQUIRED; The type of task details.
	InstanceType *string `json:"instanceType,omitempty"`

	// A value indicating whether it is a primary side script or not.
	IsPrimarySideScript *bool `json:"isPrimarySideScript,omitempty"`

	// The name.
	Name *string `json:"name,omitempty"`

	// The output.
	Output *string `json:"output,omitempty"`

	// The path.
	Path *string `json:"path,omitempty"`
}

// GetTaskTypeDetails implements the TaskTypeDetailsClassification interface for type ScriptActionTaskDetails.
func (s *ScriptActionTaskDetails) GetTaskTypeDetails() *TaskTypeDetails {
	return &TaskTypeDetails{
		InstanceType: s.InstanceType,
	}
}

// ServiceError - ASR error model.
type ServiceError struct {
	// Activity Id.
	ActivityID *string `json:"activityId,omitempty"`

	// Error code.
	Code *string `json:"code,omitempty"`

	// Error message.
	Message *string `json:"message,omitempty"`

	// Possible causes of error.
	PossibleCauses *string `json:"possibleCauses,omitempty"`

	// Recommended action to resolve error.
	RecommendedAction *string `json:"recommendedAction,omitempty"`
}

// StorageAccountCustomDetailsClassification provides polymorphic access to related types.
// Call the interface's GetStorageAccountCustomDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ExistingStorageAccount, *StorageAccountCustomDetails
type StorageAccountCustomDetailsClassification interface {
	// GetStorageAccountCustomDetails returns the StorageAccountCustomDetails content of the underlying type.
	GetStorageAccountCustomDetails() *StorageAccountCustomDetails
}

// StorageAccountCustomDetails - Storage account custom input.
type StorageAccountCustomDetails struct {
	// REQUIRED; The class type.
	ResourceType *string `json:"resourceType,omitempty"`
}

// GetStorageAccountCustomDetails implements the StorageAccountCustomDetailsClassification interface for type StorageAccountCustomDetails.
func (s *StorageAccountCustomDetails) GetStorageAccountCustomDetails() *StorageAccountCustomDetails {
	return s
}

// StorageClassification - Storage object definition.
type StorageClassification struct {
	// Resource Location
	Location *string `json:"location,omitempty"`

	// Properties of the storage object.
	Properties *StorageClassificationProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StorageClassificationCollection - Collection of storage details.
type StorageClassificationCollection struct {
	// The value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// The storage details.
	Value []*StorageClassification `json:"value,omitempty"`
}

// StorageClassificationMapping - Storage mapping object.
type StorageClassificationMapping struct {
	// Resource Location
	Location *string `json:"location,omitempty"`

	// Properties of the storage mapping object.
	Properties *StorageClassificationMappingProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StorageClassificationMappingCollection - Collection of storage mapping details.
type StorageClassificationMappingCollection struct {
	// The value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// The storage details.
	Value []*StorageClassificationMapping `json:"value,omitempty"`
}

// StorageClassificationMappingInput - Storage mapping input.
type StorageClassificationMappingInput struct {
	// Storage mapping input properties.
	Properties *StorageMappingInputProperties `json:"properties,omitempty"`
}

// StorageClassificationMappingProperties - Storage mapping properties.
type StorageClassificationMappingProperties struct {
	// Target storage object Id.
	TargetStorageClassificationID *string `json:"targetStorageClassificationId,omitempty"`
}

// StorageClassificationProperties - Storage object properties.
type StorageClassificationProperties struct {
	// Friendly name of the Storage classification.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// StorageMappingInputProperties - Storage mapping input properties.
type StorageMappingInputProperties struct {
	// The ID of the storage object.
	TargetStorageClassificationID *string `json:"targetStorageClassificationId,omitempty"`
}

// Subnets of the network.
type Subnet struct {
	// The list of addresses for the subnet.
	AddressList []*string `json:"addressList,omitempty"`

	// The subnet friendly name.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// The subnet name.
	Name *string `json:"name,omitempty"`
}

// SupportedOSDetails - Supported operating system details.
type SupportedOSDetails struct {
	// The name.
	OSName *string `json:"osName,omitempty"`

	// The type.
	OSType *string `json:"osType,omitempty"`

	// The list of version for operating system.
	OSVersions []*OSVersionWrapper `json:"osVersions,omitempty"`
}

// SupportedOSProperties - Supported operating systems properties.
type SupportedOSProperties struct {
	// The supported operating systems property list.
	SupportedOsList []*SupportedOSProperty `json:"supportedOsList,omitempty"`
}

// SupportedOSProperty - Supported operating systems property.
type SupportedOSProperty struct {
	// The replication provider type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The list of supported operating systems.
	SupportedOs []*SupportedOSDetails `json:"supportedOs,omitempty"`
}

// SupportedOperatingSystems - Supported operating systems.
type SupportedOperatingSystems struct {
	// Resource Location
	Location *string `json:"location,omitempty"`

	// The supported operating systems properties.
	Properties *SupportedOSProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SupportedOperatingSystemsClientGetOptions contains the optional parameters for the SupportedOperatingSystemsClient.Get
// method.
type SupportedOperatingSystemsClientGetOptions struct {
	// The instance type.
	InstanceType *string
}

// SwitchProtectionInput - Switch protection input.
type SwitchProtectionInput struct {
	// Switch protection properties.
	Properties *SwitchProtectionInputProperties `json:"properties,omitempty"`
}

// SwitchProtectionInputProperties - Switch protection input properties.
type SwitchProtectionInputProperties struct {
	// Provider specific switch protection input.
	ProviderSpecificDetails SwitchProtectionProviderSpecificInputClassification `json:"providerSpecificDetails,omitempty"`

	// The unique replication protected item name.
	ReplicationProtectedItemName *string `json:"replicationProtectedItemName,omitempty"`
}

// SwitchProtectionJobDetails - This class represents details for switch protection job.
type SwitchProtectionJobDetails struct {
	// REQUIRED; Gets the type of job details (see JobDetailsTypes enum for possible values).
	InstanceType *string `json:"instanceType,omitempty"`

	// The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow
	// object details.
	AffectedObjectDetails map[string]*string `json:"affectedObjectDetails,omitempty"`

	// ARM Id of the new replication protected item.
	NewReplicationProtectedItemID *string `json:"newReplicationProtectedItemId,omitempty"`
}

// GetJobDetails implements the JobDetailsClassification interface for type SwitchProtectionJobDetails.
func (s *SwitchProtectionJobDetails) GetJobDetails() *JobDetails {
	return &JobDetails{
		InstanceType:          s.InstanceType,
		AffectedObjectDetails: s.AffectedObjectDetails,
	}
}

// SwitchProtectionProviderSpecificInputClassification provides polymorphic access to related types.
// Call the interface's GetSwitchProtectionProviderSpecificInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *A2ASwitchProtectionInput, *SwitchProtectionProviderSpecificInput
type SwitchProtectionProviderSpecificInputClassification interface {
	// GetSwitchProtectionProviderSpecificInput returns the SwitchProtectionProviderSpecificInput content of the underlying type.
	GetSwitchProtectionProviderSpecificInput() *SwitchProtectionProviderSpecificInput
}

// SwitchProtectionProviderSpecificInput - Provider specific switch protection input.
type SwitchProtectionProviderSpecificInput struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetSwitchProtectionProviderSpecificInput implements the SwitchProtectionProviderSpecificInputClassification interface for
// type SwitchProtectionProviderSpecificInput.
func (s *SwitchProtectionProviderSpecificInput) GetSwitchProtectionProviderSpecificInput() *SwitchProtectionProviderSpecificInput {
	return s
}

// SwitchProviderInput - Input definition for switch provider.
type SwitchProviderInput struct {
	// Switch provider input properties.
	Properties *SwitchProviderInputProperties `json:"properties,omitempty"`
}

// SwitchProviderInputProperties - Input definition for switch provider input properties.
type SwitchProviderInputProperties struct {
	// Provider specific settings.
	ProviderSpecificDetails SwitchProviderSpecificInputClassification `json:"providerSpecificDetails,omitempty"`

	// Target provider type.
	TargetInstanceType *string `json:"targetInstanceType,omitempty"`
}

// SwitchProviderSpecificInputClassification provides polymorphic access to related types.
// Call the interface's GetSwitchProviderSpecificInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *InMageAzureV2SwitchProviderInput, *SwitchProviderSpecificInput
type SwitchProviderSpecificInputClassification interface {
	// GetSwitchProviderSpecificInput returns the SwitchProviderSpecificInput content of the underlying type.
	GetSwitchProviderSpecificInput() *SwitchProviderSpecificInput
}

// SwitchProviderSpecificInput - Provider specific switch provider input.
type SwitchProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetSwitchProviderSpecificInput implements the SwitchProviderSpecificInputClassification interface for type SwitchProviderSpecificInput.
func (s *SwitchProviderSpecificInput) GetSwitchProviderSpecificInput() *SwitchProviderSpecificInput {
	return s
}

// TargetComputeSize - Represents applicable recovery vm sizes.
type TargetComputeSize struct {
	// The Id.
	ID *string `json:"id,omitempty"`

	// The name.
	Name *string `json:"name,omitempty"`

	// The custom data.
	Properties *TargetComputeSizeProperties `json:"properties,omitempty"`

	// The Type of the object.
	Type *string `json:"type,omitempty"`
}

// TargetComputeSizeCollection - Target compute size collection.
type TargetComputeSizeCollection struct {
	// The value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of target compute sizes.
	Value []*TargetComputeSize `json:"value,omitempty"`
}

// TargetComputeSizeProperties - Represents applicable recovery vm sizes properties.
type TargetComputeSizeProperties struct {
	// The maximum cpu cores count supported by target compute size.
	CPUCoresCount *int32 `json:"cpuCoresCount,omitempty"`

	// The reasons why the target compute size is not applicable for the protected item.
	Errors []*ComputeSizeErrorDetails `json:"errors,omitempty"`

	// Target compute size display name.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// The value indicating whether the target compute size supports high Iops.
	HighIopsSupported *string `json:"highIopsSupported,omitempty"`

	// The supported HyperV Generations.
	HyperVGenerations []*string `json:"hyperVGenerations,omitempty"`

	// The maximum data disks count supported by target compute size.
	MaxDataDiskCount *int32 `json:"maxDataDiskCount,omitempty"`

	// The maximum Nics count supported by target compute size.
	MaxNicsCount *int32 `json:"maxNicsCount,omitempty"`

	// The maximum memory in GB supported by target compute size.
	MemoryInGB *float64 `json:"memoryInGB,omitempty"`

	// Target compute size name.
	Name *string `json:"name,omitempty"`

	// READ-ONLY; The Available vCPUs supported by target compute size.
	VCPUsAvailable *int32 `json:"vCPUsAvailable,omitempty" azure:"ro"`
}

// TargetComputeSizesClientListByReplicationProtectedItemsOptions contains the optional parameters for the TargetComputeSizesClient.ListByReplicationProtectedItems
// method.
type TargetComputeSizesClientListByReplicationProtectedItemsOptions struct {
	// placeholder for future optional parameters
}

// TaskTypeDetailsClassification provides polymorphic access to related types.
// Call the interface's GetTaskTypeDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AutomationRunbookTaskDetails, *ConsistencyCheckTaskDetails, *FabricReplicationGroupTaskDetails, *JobTaskDetails, *ManualActionTaskDetails,
// - *ScriptActionTaskDetails, *TaskTypeDetails, *VMNicUpdatesTaskDetails, *VirtualMachineTaskDetails
type TaskTypeDetailsClassification interface {
	// GetTaskTypeDetails returns the TaskTypeDetails content of the underlying type.
	GetTaskTypeDetails() *TaskTypeDetails
}

// TaskTypeDetails - Task details based on specific task type.
type TaskTypeDetails struct {
	// REQUIRED; The type of task details.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetTaskTypeDetails implements the TaskTypeDetailsClassification interface for type TaskTypeDetails.
func (t *TaskTypeDetails) GetTaskTypeDetails() *TaskTypeDetails { return t }

// TestFailoverCleanupInput - Input definition for test failover cleanup.
type TestFailoverCleanupInput struct {
	// REQUIRED; Test failover cleanup input properties.
	Properties *TestFailoverCleanupInputProperties `json:"properties,omitempty"`
}

// TestFailoverCleanupInputProperties - Input definition for test failover cleanup input properties.
type TestFailoverCleanupInputProperties struct {
	// Test failover cleanup comments.
	Comments *string `json:"comments,omitempty"`
}

// TestFailoverInput - Input definition for test failover.
type TestFailoverInput struct {
	// REQUIRED; Test failover input properties.
	Properties *TestFailoverInputProperties `json:"properties,omitempty"`
}

// TestFailoverInputProperties - Input definition for test failover input properties.
type TestFailoverInputProperties struct {
	// Test failover direction.
	FailoverDirection *string `json:"failoverDirection,omitempty"`

	// The id of the network to be used for test failover.
	NetworkID *string `json:"networkId,omitempty"`

	// Network type to be used for test failover.
	NetworkType *string `json:"networkType,omitempty"`

	// Provider specific settings.
	ProviderSpecificDetails TestFailoverProviderSpecificInputClassification `json:"providerSpecificDetails,omitempty"`
}

// TestFailoverJobDetails - This class represents the details for a test failover job.
type TestFailoverJobDetails struct {
	// REQUIRED; Gets the type of job details (see JobDetailsTypes enum for possible values).
	InstanceType *string `json:"instanceType,omitempty"`

	// The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow
	// object details.
	AffectedObjectDetails map[string]*string `json:"affectedObjectDetails,omitempty"`

	// The test failover comments.
	Comments *string `json:"comments,omitempty"`

	// The test network friendly name.
	NetworkFriendlyName *string `json:"networkFriendlyName,omitempty"`

	// The test network name.
	NetworkName *string `json:"networkName,omitempty"`

	// The test network type (see TestFailoverInput enum for possible values).
	NetworkType *string `json:"networkType,omitempty"`

	// The test VM details.
	ProtectedItemDetails []*FailoverReplicationProtectedItemDetails `json:"protectedItemDetails,omitempty"`

	// The test failover status.
	TestFailoverStatus *string `json:"testFailoverStatus,omitempty"`
}

// GetJobDetails implements the JobDetailsClassification interface for type TestFailoverJobDetails.
func (t *TestFailoverJobDetails) GetJobDetails() *JobDetails {
	return &JobDetails{
		InstanceType:          t.InstanceType,
		AffectedObjectDetails: t.AffectedObjectDetails,
	}
}

// TestFailoverProviderSpecificInputClassification provides polymorphic access to related types.
// Call the interface's GetTestFailoverProviderSpecificInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *A2ATestFailoverInput, *HyperVReplicaAzureTestFailoverInput, *InMageAzureV2TestFailoverInput, *InMageRcmTestFailoverInput,
// - *InMageTestFailoverInput, *TestFailoverProviderSpecificInput
type TestFailoverProviderSpecificInputClassification interface {
	// GetTestFailoverProviderSpecificInput returns the TestFailoverProviderSpecificInput content of the underlying type.
	GetTestFailoverProviderSpecificInput() *TestFailoverProviderSpecificInput
}

// TestFailoverProviderSpecificInput - Provider specific test failover input.
type TestFailoverProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetTestFailoverProviderSpecificInput implements the TestFailoverProviderSpecificInputClassification interface for type
// TestFailoverProviderSpecificInput.
func (t *TestFailoverProviderSpecificInput) GetTestFailoverProviderSpecificInput() *TestFailoverProviderSpecificInput {
	return t
}

// TestMigrateCleanupInput - Input for test migrate cleanup.
type TestMigrateCleanupInput struct {
	// REQUIRED; Test migrate cleanup input properties.
	Properties *TestMigrateCleanupInputProperties `json:"properties,omitempty"`
}

// TestMigrateCleanupInputProperties - Test migrate cleanup input properties.
type TestMigrateCleanupInputProperties struct {
	// Test migrate cleanup comments.
	Comments *string `json:"comments,omitempty"`
}

// TestMigrateInput - Input for test migrate.
type TestMigrateInput struct {
	// REQUIRED; Test migrate input properties.
	Properties *TestMigrateInputProperties `json:"properties,omitempty"`
}

// TestMigrateInputProperties - Test migrate input properties.
type TestMigrateInputProperties struct {
	// REQUIRED; The provider specific details.
	ProviderSpecificDetails TestMigrateProviderSpecificInputClassification `json:"providerSpecificDetails,omitempty"`
}

// TestMigrateProviderSpecificInputClassification provides polymorphic access to related types.
// Call the interface's GetTestMigrateProviderSpecificInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *TestMigrateProviderSpecificInput, *VMwareCbtTestMigrateInput
type TestMigrateProviderSpecificInputClassification interface {
	// GetTestMigrateProviderSpecificInput returns the TestMigrateProviderSpecificInput content of the underlying type.
	GetTestMigrateProviderSpecificInput() *TestMigrateProviderSpecificInput
}

// TestMigrateProviderSpecificInput - Test migrate provider specific input.
type TestMigrateProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetTestMigrateProviderSpecificInput implements the TestMigrateProviderSpecificInputClassification interface for type TestMigrateProviderSpecificInput.
func (t *TestMigrateProviderSpecificInput) GetTestMigrateProviderSpecificInput() *TestMigrateProviderSpecificInput {
	return t
}

// UnplannedFailoverInput - Input definition for unplanned failover.
type UnplannedFailoverInput struct {
	// REQUIRED; Unplanned failover input properties.
	Properties *UnplannedFailoverInputProperties `json:"properties,omitempty"`
}

// UnplannedFailoverInputProperties - Input definition for unplanned failover input properties.
type UnplannedFailoverInputProperties struct {
	// Failover direction.
	FailoverDirection *string `json:"failoverDirection,omitempty"`

	// Provider specific settings.
	ProviderSpecificDetails UnplannedFailoverProviderSpecificInputClassification `json:"providerSpecificDetails,omitempty"`

	// Source site operations status.
	SourceSiteOperations *string `json:"sourceSiteOperations,omitempty"`
}

// UnplannedFailoverProviderSpecificInputClassification provides polymorphic access to related types.
// Call the interface's GetUnplannedFailoverProviderSpecificInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *A2AUnplannedFailoverInput, *HyperVReplicaAzureUnplannedFailoverInput, *InMageAzureV2UnplannedFailoverInput, *InMageRcmUnplannedFailoverInput,
// - *InMageUnplannedFailoverInput, *UnplannedFailoverProviderSpecificInput
type UnplannedFailoverProviderSpecificInputClassification interface {
	// GetUnplannedFailoverProviderSpecificInput returns the UnplannedFailoverProviderSpecificInput content of the underlying type.
	GetUnplannedFailoverProviderSpecificInput() *UnplannedFailoverProviderSpecificInput
}

// UnplannedFailoverProviderSpecificInput - Provider specific unplanned failover input.
type UnplannedFailoverProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetUnplannedFailoverProviderSpecificInput implements the UnplannedFailoverProviderSpecificInputClassification interface
// for type UnplannedFailoverProviderSpecificInput.
func (u *UnplannedFailoverProviderSpecificInput) GetUnplannedFailoverProviderSpecificInput() *UnplannedFailoverProviderSpecificInput {
	return u
}

// UpdateApplianceForReplicationProtectedItemInput - Update appliance for replication protected item input.
type UpdateApplianceForReplicationProtectedItemInput struct {
	// REQUIRED; Update appliance replication protected item properties.
	Properties *UpdateApplianceForReplicationProtectedItemInputProperties `json:"properties,omitempty"`
}

// UpdateApplianceForReplicationProtectedItemInputProperties - Update appliance for protected item input properties.
type UpdateApplianceForReplicationProtectedItemInputProperties struct {
	// REQUIRED; The provider specific input to update replication protected item.
	ProviderSpecificDetails UpdateApplianceForReplicationProtectedItemProviderSpecificInputClassification `json:"providerSpecificDetails,omitempty"`

	// REQUIRED; The target appliance Id.
	TargetApplianceID *string `json:"targetApplianceId,omitempty"`
}

// UpdateApplianceForReplicationProtectedItemProviderSpecificInputClassification provides polymorphic access to related types.
// Call the interface's GetUpdateApplianceForReplicationProtectedItemProviderSpecificInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *InMageRcmUpdateApplianceForReplicationProtectedItemInput, *UpdateApplianceForReplicationProtectedItemProviderSpecificInput
type UpdateApplianceForReplicationProtectedItemProviderSpecificInputClassification interface {
	// GetUpdateApplianceForReplicationProtectedItemProviderSpecificInput returns the UpdateApplianceForReplicationProtectedItemProviderSpecificInput content of the underlying type.
	GetUpdateApplianceForReplicationProtectedItemProviderSpecificInput() *UpdateApplianceForReplicationProtectedItemProviderSpecificInput
}

// UpdateApplianceForReplicationProtectedItemProviderSpecificInput - Update replication protected item provider specific input.
type UpdateApplianceForReplicationProtectedItemProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetUpdateApplianceForReplicationProtectedItemProviderSpecificInput implements the UpdateApplianceForReplicationProtectedItemProviderSpecificInputClassification
// interface for type UpdateApplianceForReplicationProtectedItemProviderSpecificInput.
func (u *UpdateApplianceForReplicationProtectedItemProviderSpecificInput) GetUpdateApplianceForReplicationProtectedItemProviderSpecificInput() *UpdateApplianceForReplicationProtectedItemProviderSpecificInput {
	return u
}

// UpdateDiskInput - Disk input for update.
type UpdateDiskInput struct {
	// REQUIRED; The disk Id.
	DiskID *string `json:"diskId,omitempty"`

	// The target disk name.
	TargetDiskName *string `json:"targetDiskName,omitempty"`
}

// UpdateMigrationItemInput - Update migration item input.
type UpdateMigrationItemInput struct {
	// Update migration item input properties.
	Properties *UpdateMigrationItemInputProperties `json:"properties,omitempty"`
}

// UpdateMigrationItemInputProperties - Update migration item input properties.
type UpdateMigrationItemInputProperties struct {
	// REQUIRED; The provider specific input to update migration item.
	ProviderSpecificDetails UpdateMigrationItemProviderSpecificInputClassification `json:"providerSpecificDetails,omitempty"`
}

// UpdateMigrationItemProviderSpecificInputClassification provides polymorphic access to related types.
// Call the interface's GetUpdateMigrationItemProviderSpecificInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *UpdateMigrationItemProviderSpecificInput, *VMwareCbtUpdateMigrationItemInput
type UpdateMigrationItemProviderSpecificInputClassification interface {
	// GetUpdateMigrationItemProviderSpecificInput returns the UpdateMigrationItemProviderSpecificInput content of the underlying type.
	GetUpdateMigrationItemProviderSpecificInput() *UpdateMigrationItemProviderSpecificInput
}

// UpdateMigrationItemProviderSpecificInput - Update migration item provider specific input.
type UpdateMigrationItemProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetUpdateMigrationItemProviderSpecificInput implements the UpdateMigrationItemProviderSpecificInputClassification interface
// for type UpdateMigrationItemProviderSpecificInput.
func (u *UpdateMigrationItemProviderSpecificInput) GetUpdateMigrationItemProviderSpecificInput() *UpdateMigrationItemProviderSpecificInput {
	return u
}

// UpdateMobilityServiceRequest - Request to update the mobility service on a protected item.
type UpdateMobilityServiceRequest struct {
	// The properties of the update mobility service request.
	Properties *UpdateMobilityServiceRequestProperties `json:"properties,omitempty"`
}

// UpdateMobilityServiceRequestProperties - The properties of an update mobility service request.
type UpdateMobilityServiceRequestProperties struct {
	// The CS run as account Id.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`
}

// UpdateNetworkMappingInput - Update network mapping input.
type UpdateNetworkMappingInput struct {
	// The input properties needed to update network mapping.
	Properties *UpdateNetworkMappingInputProperties `json:"properties,omitempty"`
}

// UpdateNetworkMappingInputProperties - Common input details for network mapping operation.
type UpdateNetworkMappingInputProperties struct {
	// Fabrics specific input network Id.
	FabricSpecificDetails FabricSpecificUpdateNetworkMappingInputClassification `json:"fabricSpecificDetails,omitempty"`

	// Recovery fabric name.
	RecoveryFabricName *string `json:"recoveryFabricName,omitempty"`

	// Recovery network Id.
	RecoveryNetworkID *string `json:"recoveryNetworkId,omitempty"`
}

// UpdatePolicyInput - Update policy input.
type UpdatePolicyInput struct {
	// The ReplicationProviderSettings.
	Properties *UpdatePolicyInputProperties `json:"properties,omitempty"`
}

// UpdatePolicyInputProperties - Policy update properties.
type UpdatePolicyInputProperties struct {
	// The ReplicationProviderSettings.
	ReplicationProviderSettings PolicyProviderSpecificInputClassification `json:"replicationProviderSettings,omitempty"`
}

// UpdateProtectionContainerMappingInput - Container pairing update input.
type UpdateProtectionContainerMappingInput struct {
	// Update protection container mapping input properties.
	Properties *UpdateProtectionContainerMappingInputProperties `json:"properties,omitempty"`
}

// UpdateProtectionContainerMappingInputProperties - Container pairing update input.
type UpdateProtectionContainerMappingInputProperties struct {
	// Provider specific input for updating protection container mapping.
	ProviderSpecificInput ReplicationProviderSpecificUpdateContainerMappingInputClassification `json:"providerSpecificInput,omitempty"`
}

// UpdateRecoveryPlanInput - Update recovery plan input class.
type UpdateRecoveryPlanInput struct {
	// Recovery plan update properties.
	Properties *UpdateRecoveryPlanInputProperties `json:"properties,omitempty"`
}

// UpdateRecoveryPlanInputProperties - Recovery plan update properties.
type UpdateRecoveryPlanInputProperties struct {
	// The recovery plan groups.
	Groups []*RecoveryPlanGroup `json:"groups,omitempty"`
}

// UpdateReplicationProtectedItemInput - Update replication protected item input.
type UpdateReplicationProtectedItemInput struct {
	// Update replication protected item properties.
	Properties *UpdateReplicationProtectedItemInputProperties `json:"properties,omitempty"`
}

// UpdateReplicationProtectedItemInputProperties - Update protected item input properties.
type UpdateReplicationProtectedItemInputProperties struct {
	// The selected option to enable RDP\SSH on target vm after failover. String value of SrsDataContract.EnableRDPOnTargetOption
	// enum.
	EnableRdpOnTargetOption *string `json:"enableRdpOnTargetOption,omitempty"`

	// License type.
	LicenseType *LicenseType `json:"licenseType,omitempty"`

	// The provider specific input to update replication protected item.
	ProviderSpecificDetails UpdateReplicationProtectedItemProviderInputClassification `json:"providerSpecificDetails,omitempty"`

	// The target availability set Id.
	RecoveryAvailabilitySetID *string `json:"recoveryAvailabilitySetId,omitempty"`

	// Target Azure VM name given by the user.
	RecoveryAzureVMName *string `json:"recoveryAzureVMName,omitempty"`

	// Target Azure VM size.
	RecoveryAzureVMSize *string `json:"recoveryAzureVMSize,omitempty"`

	// Target Azure Network Id.
	SelectedRecoveryAzureNetworkID *string `json:"selectedRecoveryAzureNetworkId,omitempty"`

	// The selected source nic Id which will be used as the primary nic during failover.
	SelectedSourceNicID *string `json:"selectedSourceNicId,omitempty"`

	// The Azure Network Id for test failover.
	SelectedTfoAzureNetworkID *string `json:"selectedTfoAzureNetworkId,omitempty"`

	// The list of VM nic details.
	VMNics []*VMNicInputDetails `json:"vmNics,omitempty"`
}

// UpdateReplicationProtectedItemProviderInputClassification provides polymorphic access to related types.
// Call the interface's GetUpdateReplicationProtectedItemProviderInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *A2AUpdateReplicationProtectedItemInput, *HyperVReplicaAzureUpdateReplicationProtectedItemInput, *InMageAzureV2UpdateReplicationProtectedItemInput,
// - *InMageRcmUpdateReplicationProtectedItemInput, *UpdateReplicationProtectedItemProviderInput
type UpdateReplicationProtectedItemProviderInputClassification interface {
	// GetUpdateReplicationProtectedItemProviderInput returns the UpdateReplicationProtectedItemProviderInput content of the underlying type.
	GetUpdateReplicationProtectedItemProviderInput() *UpdateReplicationProtectedItemProviderInput
}

// UpdateReplicationProtectedItemProviderInput - Update replication protected item provider specific input.
type UpdateReplicationProtectedItemProviderInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetUpdateReplicationProtectedItemProviderInput implements the UpdateReplicationProtectedItemProviderInputClassification
// interface for type UpdateReplicationProtectedItemProviderInput.
func (u *UpdateReplicationProtectedItemProviderInput) GetUpdateReplicationProtectedItemProviderInput() *UpdateReplicationProtectedItemProviderInput {
	return u
}

// UpdateVCenterRequest - Input required to update vCenter.
type UpdateVCenterRequest struct {
	// The update VCenter Request Properties.
	Properties *UpdateVCenterRequestProperties `json:"properties,omitempty"`
}

// UpdateVCenterRequestProperties - The properties of an update vCenter request.
type UpdateVCenterRequestProperties struct {
	// The friendly name of the vCenter.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// The IP address of the vCenter to be discovered.
	IPAddress *string `json:"ipAddress,omitempty"`

	// The port number for discovery.
	Port *string `json:"port,omitempty"`

	// The process server Id from where the update can be orchestrated.
	ProcessServerID *string `json:"processServerId,omitempty"`

	// The CS account Id which has privileges to update the vCenter.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`
}

// VCenter - vCenter definition.
type VCenter struct {
	// Resource Location
	Location *string `json:"location,omitempty"`

	// VCenter related data.
	Properties *VCenterProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VCenterCollection - Collection of vCenter details.
type VCenterCollection struct {
	// The value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// The vCenter details.
	Value []*VCenter `json:"value,omitempty"`
}

// VCenterProperties - vCenter properties.
type VCenterProperties struct {
	// The VCenter discovery status.
	DiscoveryStatus *string `json:"discoveryStatus,omitempty"`

	// The ARM resource name of the fabric containing this VCenter.
	FabricArmResourceName *string `json:"fabricArmResourceName,omitempty"`

	// Friendly name of the vCenter.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// The health errors for this VCenter.
	HealthErrors []*HealthError `json:"healthErrors,omitempty"`

	// The IP address of the vCenter.
	IPAddress *string `json:"ipAddress,omitempty"`

	// The infrastructure Id of vCenter.
	InfrastructureID *string `json:"infrastructureId,omitempty"`

	// VCenter internal ID.
	InternalID *string `json:"internalId,omitempty"`

	// The time when the last heartbeat was received by vCenter.
	LastHeartbeat *time.Time `json:"lastHeartbeat,omitempty"`

	// The port number for discovery.
	Port *string `json:"port,omitempty"`

	// The process server Id.
	ProcessServerID *string `json:"processServerId,omitempty"`

	// The account Id which has privileges to discover the vCenter.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`
}

// VMNicDetails - Hyper V VM network details.
type VMNicDetails struct {
	// A value indicating whether the NIC has accelerated networking enabled.
	EnableAcceleratedNetworkingOnRecovery *bool `json:"enableAcceleratedNetworkingOnRecovery,omitempty"`

	// Whether the TFO NIC has accelerated networking enabled.
	EnableAcceleratedNetworkingOnTfo *bool `json:"enableAcceleratedNetworkingOnTfo,omitempty"`

	// The IP configurations of the NIC.
	IPConfigs []*IPConfigDetails `json:"ipConfigs,omitempty"`

	// The nic Id.
	NicID *string `json:"nicId,omitempty"`

	// The id of the NSG associated with the NIC.
	RecoveryNetworkSecurityGroupID *string `json:"recoveryNetworkSecurityGroupId,omitempty"`

	// The name of the NIC to be used when creating target NICs.
	RecoveryNicName *string `json:"recoveryNicName,omitempty"`

	// The resource group of the NIC to be used when creating target NICs.
	RecoveryNicResourceGroupName *string `json:"recoveryNicResourceGroupName,omitempty"`

	// Recovery VM network Id.
	RecoveryVMNetworkID *string `json:"recoveryVMNetworkId,omitempty"`

	// The replica nic Id.
	ReplicaNicID *string `json:"replicaNicId,omitempty"`

	// A value indicating whether an existing NIC is allowed to be reused during failover subject to availability.
	ReuseExistingNic *bool `json:"reuseExistingNic,omitempty"`

	// Selection type for failover.
	SelectionType *string `json:"selectionType,omitempty"`

	// The source nic ARM Id.
	SourceNicArmID *string `json:"sourceNicArmId,omitempty"`

	// Target NIC name.
	TargetNicName *string `json:"targetNicName,omitempty"`

	// The NSG to be used by NIC during test failover.
	TfoNetworkSecurityGroupID *string `json:"tfoNetworkSecurityGroupId,omitempty"`

	// The name of the NIC to be used when creating target NICs in TFO.
	TfoRecoveryNicName *string `json:"tfoRecoveryNicName,omitempty"`

	// The resource group of the NIC to be used when creating target NICs in TFO.
	TfoRecoveryNicResourceGroupName *string `json:"tfoRecoveryNicResourceGroupName,omitempty"`

	// A value indicating whether an existing NIC is allowed to be reused during test failover subject to availability.
	TfoReuseExistingNic *bool `json:"tfoReuseExistingNic,omitempty"`

	// The network to be used by NIC during test failover.
	TfoVMNetworkID *string `json:"tfoVMNetworkId,omitempty"`

	// VM network name.
	VMNetworkName *string `json:"vMNetworkName,omitempty"`
}

// VMNicInputDetails - Hyper V VM network input details.
type VMNicInputDetails struct {
	// Whether the NIC has accelerated networking enabled.
	EnableAcceleratedNetworkingOnRecovery *bool `json:"enableAcceleratedNetworkingOnRecovery,omitempty"`

	// Whether the test NIC has accelerated networking enabled.
	EnableAcceleratedNetworkingOnTfo *bool `json:"enableAcceleratedNetworkingOnTfo,omitempty"`

	// The IP configurations to be used by NIC during test failover and failover.
	IPConfigs []*IPConfigInputDetails `json:"ipConfigs,omitempty"`

	// The nic Id.
	NicID *string `json:"nicId,omitempty"`

	// The id of the NSG associated with the NIC.
	RecoveryNetworkSecurityGroupID *string `json:"recoveryNetworkSecurityGroupId,omitempty"`

	// The name of the NIC to be used when creating target NICs.
	RecoveryNicName *string `json:"recoveryNicName,omitempty"`

	// The resource group of the NIC to be used when creating target NICs.
	RecoveryNicResourceGroupName *string `json:"recoveryNicResourceGroupName,omitempty"`

	// A value indicating whether an existing NIC is allowed to be reused during failover subject to availability.
	ReuseExistingNic *bool `json:"reuseExistingNic,omitempty"`

	// Selection type for failover.
	SelectionType *string `json:"selectionType,omitempty"`

	// Target NIC name.
	TargetNicName *string `json:"targetNicName,omitempty"`

	// The NSG to be used by NIC during test failover.
	TfoNetworkSecurityGroupID *string `json:"tfoNetworkSecurityGroupId,omitempty"`

	// The name of the NIC to be used when creating target NICs in TFO.
	TfoNicName *string `json:"tfoNicName,omitempty"`

	// The resource group of the NIC to be used when creating target NICs in TFO.
	TfoNicResourceGroupName *string `json:"tfoNicResourceGroupName,omitempty"`

	// A value indicating whether an existing NIC is allowed to be reused during test failover subject to availability.
	TfoReuseExistingNic *bool `json:"tfoReuseExistingNic,omitempty"`
}

// VMNicUpdatesTaskDetails - This class represents the vm NicUpdates task details.
type VMNicUpdatesTaskDetails struct {
	// REQUIRED; The type of task details.
	InstanceType *string `json:"instanceType,omitempty"`

	// Name of the Nic.
	Name *string `json:"name,omitempty"`

	// Nic Id.
	NicID *string `json:"nicId,omitempty"`

	// Virtual machine Id.
	VMID *string `json:"vmId,omitempty"`
}

// GetTaskTypeDetails implements the TaskTypeDetailsClassification interface for type VMNicUpdatesTaskDetails.
func (v *VMNicUpdatesTaskDetails) GetTaskTypeDetails() *TaskTypeDetails {
	return &TaskTypeDetails{
		InstanceType: v.InstanceType,
	}
}

// VMwareCbtContainerCreationInput - VMwareCbt container creation input.
type VMwareCbtContainerCreationInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetReplicationProviderSpecificContainerCreationInput implements the ReplicationProviderSpecificContainerCreationInputClassification
// interface for type VMwareCbtContainerCreationInput.
func (v *VMwareCbtContainerCreationInput) GetReplicationProviderSpecificContainerCreationInput() *ReplicationProviderSpecificContainerCreationInput {
	return &ReplicationProviderSpecificContainerCreationInput{
		InstanceType: v.InstanceType,
	}
}

// VMwareCbtContainerMappingInput - VMwareCbt container mapping input.
type VMwareCbtContainerMappingInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; The storage account ARM Id.
	StorageAccountID *string `json:"storageAccountId,omitempty"`

	// REQUIRED; The target location.
	TargetLocation *string `json:"targetLocation,omitempty"`

	// The target key vault ARM Id.
	KeyVaultID *string `json:"keyVaultId,omitempty"`

	// The target key vault URL.
	KeyVaultURI *string `json:"keyVaultUri,omitempty"`

	// The secret name of the service bus connection string.
	ServiceBusConnectionStringSecretName *string `json:"serviceBusConnectionStringSecretName,omitempty"`

	// The secret name of the storage account.
	StorageAccountSasSecretName *string `json:"storageAccountSasSecretName,omitempty"`
}

// GetReplicationProviderSpecificContainerMappingInput implements the ReplicationProviderSpecificContainerMappingInputClassification
// interface for type VMwareCbtContainerMappingInput.
func (v *VMwareCbtContainerMappingInput) GetReplicationProviderSpecificContainerMappingInput() *ReplicationProviderSpecificContainerMappingInput {
	return &ReplicationProviderSpecificContainerMappingInput{
		InstanceType: v.InstanceType,
	}
}

// VMwareCbtDiskInput - VMwareCbt disk input.
type VMwareCbtDiskInput struct {
	// REQUIRED; The disk Id.
	DiskID *string `json:"diskId,omitempty"`

	// REQUIRED; A value indicating whether the disk is the OS disk.
	IsOSDisk *string `json:"isOSDisk,omitempty"`

	// REQUIRED; The log storage account ARM Id.
	LogStorageAccountID *string `json:"logStorageAccountId,omitempty"`

	// REQUIRED; The key vault secret name of the log storage account.
	LogStorageAccountSasSecretName *string `json:"logStorageAccountSasSecretName,omitempty"`

	// The DiskEncryptionSet ARM Id.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`

	// The disk type.
	DiskType *DiskAccountType `json:"diskType,omitempty"`
}

// VMwareCbtEnableMigrationInput - VMwareCbt specific enable migration input.
type VMwareCbtEnableMigrationInput struct {
	// REQUIRED; The data mover run as account Id.
	DataMoverRunAsAccountID *string `json:"dataMoverRunAsAccountId,omitempty"`

	// REQUIRED; The disks to include list.
	DisksToInclude []*VMwareCbtDiskInput `json:"disksToInclude,omitempty"`

	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; The snapshot run as account Id.
	SnapshotRunAsAccountID *string `json:"snapshotRunAsAccountId,omitempty"`

	// REQUIRED; The target network ARM Id.
	TargetNetworkID *string `json:"targetNetworkId,omitempty"`

	// REQUIRED; The target resource group ARM Id.
	TargetResourceGroupID *string `json:"targetResourceGroupId,omitempty"`

	// REQUIRED; The ARM Id of the VM discovered in VMware.
	VmwareMachineID *string `json:"vmwareMachineId,omitempty"`

	// License type.
	LicenseType *LicenseType `json:"licenseType,omitempty"`

	// A value indicating whether auto resync is to be done.
	PerformAutoResync *string `json:"performAutoResync,omitempty"`

	// The SQL Server license type.
	SQLServerLicenseType *SQLServerLicenseType `json:"sqlServerLicenseType,omitempty"`

	// The tags for the seed disks.
	SeedDiskTags map[string]*string `json:"seedDiskTags,omitempty"`

	// The target availability set ARM Id.
	TargetAvailabilitySetID *string `json:"targetAvailabilitySetId,omitempty"`

	// The target availability zone.
	TargetAvailabilityZone *string `json:"targetAvailabilityZone,omitempty"`

	// The target boot diagnostics storage account ARM Id.
	TargetBootDiagnosticsStorageAccountID *string `json:"targetBootDiagnosticsStorageAccountId,omitempty"`

	// The tags for the target disks.
	TargetDiskTags map[string]*string `json:"targetDiskTags,omitempty"`

	// The tags for the target NICs.
	TargetNicTags map[string]*string `json:"targetNicTags,omitempty"`

	// The target proximity placement group ARM Id.
	TargetProximityPlacementGroupID *string `json:"targetProximityPlacementGroupId,omitempty"`

	// The target subnet name.
	TargetSubnetName *string `json:"targetSubnetName,omitempty"`

	// The target VM name.
	TargetVMName *string `json:"targetVmName,omitempty"`

	// The target VM size.
	TargetVMSize *string `json:"targetVmSize,omitempty"`

	// The target VM tags.
	TargetVMTags map[string]*string `json:"targetVmTags,omitempty"`

	// The selected test network ARM Id.
	TestNetworkID *string `json:"testNetworkId,omitempty"`

	// The selected test subnet name.
	TestSubnetName *string `json:"testSubnetName,omitempty"`
}

// GetEnableMigrationProviderSpecificInput implements the EnableMigrationProviderSpecificInputClassification interface for
// type VMwareCbtEnableMigrationInput.
func (v *VMwareCbtEnableMigrationInput) GetEnableMigrationProviderSpecificInput() *EnableMigrationProviderSpecificInput {
	return &EnableMigrationProviderSpecificInput{
		InstanceType: v.InstanceType,
	}
}

// VMwareCbtEventDetails - Event details for VMwareCbt provider.
type VMwareCbtEventDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// READ-ONLY; The migration item name.
	MigrationItemName *string `json:"migrationItemName,omitempty" azure:"ro"`
}

// GetEventProviderSpecificDetails implements the EventProviderSpecificDetailsClassification interface for type VMwareCbtEventDetails.
func (v *VMwareCbtEventDetails) GetEventProviderSpecificDetails() *EventProviderSpecificDetails {
	return &EventProviderSpecificDetails{
		InstanceType: v.InstanceType,
	}
}

// VMwareCbtMigrateInput - VMwareCbt specific migrate input.
type VMwareCbtMigrateInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; A value indicating whether VM is to be shutdown.
	PerformShutdown *string `json:"performShutdown,omitempty"`
}

// GetMigrateProviderSpecificInput implements the MigrateProviderSpecificInputClassification interface for type VMwareCbtMigrateInput.
func (v *VMwareCbtMigrateInput) GetMigrateProviderSpecificInput() *MigrateProviderSpecificInput {
	return &MigrateProviderSpecificInput{
		InstanceType: v.InstanceType,
	}
}

// VMwareCbtMigrationDetails - VMwareCbt provider specific settings.
type VMwareCbtMigrationDetails struct {
	// REQUIRED; Gets the instance type.
	InstanceType *string `json:"instanceType,omitempty"`

	// License Type of the VM to be used.
	LicenseType *string `json:"licenseType,omitempty"`

	// A value indicating whether auto resync is to be done.
	PerformAutoResync *string `json:"performAutoResync,omitempty"`

	// The list of protected disks.
	ProtectedDisks []*VMwareCbtProtectedDiskDetails `json:"protectedDisks,omitempty"`

	// The SQL Server license type.
	SQLServerLicenseType *string `json:"sqlServerLicenseType,omitempty"`

	// The tags for the seed disks.
	SeedDiskTags map[string]*string `json:"seedDiskTags,omitempty"`

	// The target availability set Id.
	TargetAvailabilitySetID *string `json:"targetAvailabilitySetId,omitempty"`

	// The target availability zone.
	TargetAvailabilityZone *string `json:"targetAvailabilityZone,omitempty"`

	// The target boot diagnostics storage account ARM Id.
	TargetBootDiagnosticsStorageAccountID *string `json:"targetBootDiagnosticsStorageAccountId,omitempty"`

	// The tags for the target disks.
	TargetDiskTags map[string]*string `json:"targetDiskTags,omitempty"`

	// The target network Id.
	TargetNetworkID *string `json:"targetNetworkId,omitempty"`

	// The tags for the target NICs.
	TargetNicTags map[string]*string `json:"targetNicTags,omitempty"`

	// The target proximity placement group Id.
	TargetProximityPlacementGroupID *string `json:"targetProximityPlacementGroupId,omitempty"`

	// The target resource group Id.
	TargetResourceGroupID *string `json:"targetResourceGroupId,omitempty"`

	// Target VM name.
	TargetVMName *string `json:"targetVmName,omitempty"`

	// The target VM size.
	TargetVMSize *string `json:"targetVmSize,omitempty"`

	// The target VM tags.
	TargetVMTags map[string]*string `json:"targetVmTags,omitempty"`

	// The network details.
	VMNics []*VMwareCbtNicDetails `json:"vmNics,omitempty"`

	// READ-ONLY; The data mover run as account Id.
	DataMoverRunAsAccountID *string `json:"dataMoverRunAsAccountId,omitempty" azure:"ro"`

	// READ-ONLY; The firmware type.
	FirmwareType *string `json:"firmwareType,omitempty" azure:"ro"`

	// READ-ONLY; The initial seeding progress percentage.
	InitialSeedingProgressPercentage *int32 `json:"initialSeedingProgressPercentage,omitempty" azure:"ro"`

	// READ-ONLY; The initial seeding retry count.
	InitialSeedingRetryCount *int64 `json:"initialSeedingRetryCount,omitempty" azure:"ro"`

	// READ-ONLY; The last recovery point Id.
	LastRecoveryPointID *string `json:"lastRecoveryPointId,omitempty" azure:"ro"`

	// READ-ONLY; The last recovery point received time.
	LastRecoveryPointReceived *time.Time `json:"lastRecoveryPointReceived,omitempty" azure:"ro"`

	// READ-ONLY; The migration progress percentage.
	MigrationProgressPercentage *int32 `json:"migrationProgressPercentage,omitempty" azure:"ro"`

	// READ-ONLY; The recovery point Id to which the VM was migrated.
	MigrationRecoveryPointID *string `json:"migrationRecoveryPointId,omitempty" azure:"ro"`

	// READ-ONLY; The type of the OS on the VM.
	OSType *string `json:"osType,omitempty" azure:"ro"`

	// READ-ONLY; The resync progress percentage.
	ResyncProgressPercentage *int32 `json:"resyncProgressPercentage,omitempty" azure:"ro"`

	// READ-ONLY; A value indicating whether resync is required.
	ResyncRequired *string `json:"resyncRequired,omitempty" azure:"ro"`

	// READ-ONLY; The resync retry count.
	ResyncRetryCount *int64 `json:"resyncRetryCount,omitempty" azure:"ro"`

	// READ-ONLY; The resync state.
	ResyncState *ResyncState `json:"resyncState,omitempty" azure:"ro"`

	// READ-ONLY; The snapshot run as account Id.
	SnapshotRunAsAccountID *string `json:"snapshotRunAsAccountId,omitempty" azure:"ro"`

	// READ-ONLY; The target generation.
	TargetGeneration *string `json:"targetGeneration,omitempty" azure:"ro"`

	// READ-ONLY; The target location.
	TargetLocation *string `json:"targetLocation,omitempty" azure:"ro"`

	// READ-ONLY; The ARM Id of the VM discovered in VMware.
	VmwareMachineID *string `json:"vmwareMachineId,omitempty" azure:"ro"`
}

// GetMigrationProviderSpecificSettings implements the MigrationProviderSpecificSettingsClassification interface for type
// VMwareCbtMigrationDetails.
func (v *VMwareCbtMigrationDetails) GetMigrationProviderSpecificSettings() *MigrationProviderSpecificSettings {
	return &MigrationProviderSpecificSettings{
		InstanceType: v.InstanceType,
	}
}

// VMwareCbtNicDetails - VMwareCbt NIC details.
type VMwareCbtNicDetails struct {
	// A value indicating whether this is the primary NIC.
	IsPrimaryNic *string `json:"isPrimaryNic,omitempty"`

	// A value indicating whether this NIC is selected for migration.
	IsSelectedForMigration *string `json:"isSelectedForMigration,omitempty"`

	// The target IP address.
	TargetIPAddress *string `json:"targetIPAddress,omitempty"`

	// The target IP address type.
	TargetIPAddressType *EthernetAddressType `json:"targetIPAddressType,omitempty"`

	// Target NIC name.
	TargetNicName *string `json:"targetNicName,omitempty"`

	// Target subnet name.
	TargetSubnetName *string `json:"targetSubnetName,omitempty"`

	// The test IP address.
	TestIPAddress *string `json:"testIPAddress,omitempty"`

	// The test IP address type.
	TestIPAddressType *EthernetAddressType `json:"testIPAddressType,omitempty"`

	// Source network Id.
	TestNetworkID *string `json:"testNetworkId,omitempty"`

	// Test subnet name.
	TestSubnetName *string `json:"testSubnetName,omitempty"`

	// READ-ONLY; The NIC Id.
	NicID *string `json:"nicId,omitempty" azure:"ro"`

	// READ-ONLY; The source IP address.
	SourceIPAddress *string `json:"sourceIPAddress,omitempty" azure:"ro"`

	// READ-ONLY; The source IP address type.
	SourceIPAddressType *EthernetAddressType `json:"sourceIPAddressType,omitempty" azure:"ro"`

	// READ-ONLY; Source network Id.
	SourceNetworkID *string `json:"sourceNetworkId,omitempty" azure:"ro"`
}

// VMwareCbtNicInput - VMwareCbt NIC input.
type VMwareCbtNicInput struct {
	// REQUIRED; A value indicating whether this is the primary NIC.
	IsPrimaryNic *string `json:"isPrimaryNic,omitempty"`

	// REQUIRED; The NIC Id.
	NicID *string `json:"nicId,omitempty"`

	// A value indicating whether this NIC is selected for migration.
	IsSelectedForMigration *string `json:"isSelectedForMigration,omitempty"`

	// Target NIC name.
	TargetNicName *string `json:"targetNicName,omitempty"`

	// The static IP address.
	TargetStaticIPAddress *string `json:"targetStaticIPAddress,omitempty"`

	// Target subnet name.
	TargetSubnetName *string `json:"targetSubnetName,omitempty"`

	// The test static IP address.
	TestStaticIPAddress *string `json:"testStaticIPAddress,omitempty"`

	// The test subnet name.
	TestSubnetName *string `json:"testSubnetName,omitempty"`
}

// VMwareCbtPolicyCreationInput - VMware Cbt policy creation input.
type VMwareCbtPolicyCreationInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The app consistent snapshot frequency (in minutes).
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`

	// The crash consistent snapshot frequency (in minutes).
	CrashConsistentFrequencyInMinutes *int32 `json:"crashConsistentFrequencyInMinutes,omitempty"`

	// The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistoryInMinutes *int32 `json:"recoveryPointHistoryInMinutes,omitempty"`
}

// GetPolicyProviderSpecificInput implements the PolicyProviderSpecificInputClassification interface for type VMwareCbtPolicyCreationInput.
func (v *VMwareCbtPolicyCreationInput) GetPolicyProviderSpecificInput() *PolicyProviderSpecificInput {
	return &PolicyProviderSpecificInput{
		InstanceType: v.InstanceType,
	}
}

// VMwareCbtProtectedDiskDetails - VMwareCbt protected disk details.
type VMwareCbtProtectedDiskDetails struct {
	// The disk type.
	DiskType *DiskAccountType `json:"diskType,omitempty"`

	// The name for the target managed disk.
	TargetDiskName *string `json:"targetDiskName,omitempty"`

	// READ-ONLY; The disk capacity in bytes.
	CapacityInBytes *int64 `json:"capacityInBytes,omitempty" azure:"ro"`

	// READ-ONLY; The DiskEncryptionSet ARM Id.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty" azure:"ro"`

	// READ-ONLY; The disk id.
	DiskID *string `json:"diskId,omitempty" azure:"ro"`

	// READ-ONLY; The disk name.
	DiskName *string `json:"diskName,omitempty" azure:"ro"`

	// READ-ONLY; The disk path.
	DiskPath *string `json:"diskPath,omitempty" azure:"ro"`

	// READ-ONLY; A value indicating whether the disk is the OS disk.
	IsOSDisk *string `json:"isOSDisk,omitempty" azure:"ro"`

	// READ-ONLY; The log storage account ARM Id.
	LogStorageAccountID *string `json:"logStorageAccountId,omitempty" azure:"ro"`

	// READ-ONLY; The key vault secret name of the log storage account.
	LogStorageAccountSasSecretName *string `json:"logStorageAccountSasSecretName,omitempty" azure:"ro"`

	// READ-ONLY; The ARM Id of the seed managed disk.
	SeedManagedDiskID *string `json:"seedManagedDiskId,omitempty" azure:"ro"`

	// READ-ONLY; The ARM Id of the target managed disk.
	TargetManagedDiskID *string `json:"targetManagedDiskId,omitempty" azure:"ro"`
}

// VMwareCbtProtectionContainerMappingDetails - VMwareCbt provider specific container mapping details.
type VMwareCbtProtectionContainerMappingDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// READ-ONLY; The target key vault ARM Id.
	KeyVaultID *string `json:"keyVaultId,omitempty" azure:"ro"`

	// READ-ONLY; The target key vault URI.
	KeyVaultURI *string `json:"keyVaultUri,omitempty" azure:"ro"`

	// READ-ONLY; The secret name of the service bus connection string.
	ServiceBusConnectionStringSecretName *string `json:"serviceBusConnectionStringSecretName,omitempty" azure:"ro"`

	// READ-ONLY; The storage account ARM Id.
	StorageAccountID *string `json:"storageAccountId,omitempty" azure:"ro"`

	// READ-ONLY; The secret name of the storage account.
	StorageAccountSasSecretName *string `json:"storageAccountSasSecretName,omitempty" azure:"ro"`

	// READ-ONLY; The target location.
	TargetLocation *string `json:"targetLocation,omitempty" azure:"ro"`
}

// GetProtectionContainerMappingProviderSpecificDetails implements the ProtectionContainerMappingProviderSpecificDetailsClassification
// interface for type VMwareCbtProtectionContainerMappingDetails.
func (v *VMwareCbtProtectionContainerMappingDetails) GetProtectionContainerMappingProviderSpecificDetails() *ProtectionContainerMappingProviderSpecificDetails {
	return &ProtectionContainerMappingProviderSpecificDetails{
		InstanceType: v.InstanceType,
	}
}

// VMwareCbtResyncInput - VMwareCbt specific resync input.
type VMwareCbtResyncInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; A value indicating whether CBT is to be reset.
	SkipCbtReset *string `json:"skipCbtReset,omitempty"`
}

// GetResyncProviderSpecificInput implements the ResyncProviderSpecificInputClassification interface for type VMwareCbtResyncInput.
func (v *VMwareCbtResyncInput) GetResyncProviderSpecificInput() *ResyncProviderSpecificInput {
	return &ResyncProviderSpecificInput{
		InstanceType: v.InstanceType,
	}
}

// VMwareCbtTestMigrateInput - VMwareCbt specific test migrate input.
type VMwareCbtTestMigrateInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; The test network Id.
	NetworkID *string `json:"networkId,omitempty"`

	// REQUIRED; The recovery point Id.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`

	// The list of NIC details.
	VMNics []*VMwareCbtNicInput `json:"vmNics,omitempty"`
}

// GetTestMigrateProviderSpecificInput implements the TestMigrateProviderSpecificInputClassification interface for type VMwareCbtTestMigrateInput.
func (v *VMwareCbtTestMigrateInput) GetTestMigrateProviderSpecificInput() *TestMigrateProviderSpecificInput {
	return &TestMigrateProviderSpecificInput{
		InstanceType: v.InstanceType,
	}
}

// VMwareCbtUpdateDiskInput - VMwareCbt disk input for update.
type VMwareCbtUpdateDiskInput struct {
	// REQUIRED; The disk Id.
	DiskID *string `json:"diskId,omitempty"`

	// A value indicating whether the disk is the OS disk.
	IsOSDisk *string `json:"isOSDisk,omitempty"`

	// The target disk name.
	TargetDiskName *string `json:"targetDiskName,omitempty"`
}

// VMwareCbtUpdateMigrationItemInput - VMwareCbt specific update migration item input.
type VMwareCbtUpdateMigrationItemInput struct {
	// REQUIRED; The class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// The license type.
	LicenseType *LicenseType `json:"licenseType,omitempty"`

	// A value indicating whether auto resync is to be done.
	PerformAutoResync *string `json:"performAutoResync,omitempty"`

	// The SQL Server license type.
	SQLServerLicenseType *SQLServerLicenseType `json:"sqlServerLicenseType,omitempty"`

	// The target availability set ARM Id.
	TargetAvailabilitySetID *string `json:"targetAvailabilitySetId,omitempty"`

	// The target availability zone.
	TargetAvailabilityZone *string `json:"targetAvailabilityZone,omitempty"`

	// The target boot diagnostics storage account ARM Id.
	TargetBootDiagnosticsStorageAccountID *string `json:"targetBootDiagnosticsStorageAccountId,omitempty"`

	// The tags for the target disks.
	TargetDiskTags map[string]*string `json:"targetDiskTags,omitempty"`

	// The target network ARM Id.
	TargetNetworkID *string `json:"targetNetworkId,omitempty"`

	// The tags for the target NICs.
	TargetNicTags map[string]*string `json:"targetNicTags,omitempty"`

	// The target proximity placement group ARM Id.
	TargetProximityPlacementGroupID *string `json:"targetProximityPlacementGroupId,omitempty"`

	// The target resource group ARM Id.
	TargetResourceGroupID *string `json:"targetResourceGroupId,omitempty"`

	// The target VM name.
	TargetVMName *string `json:"targetVmName,omitempty"`

	// The target VM size.
	TargetVMSize *string `json:"targetVmSize,omitempty"`

	// The target VM tags.
	TargetVMTags map[string]*string `json:"targetVmTags,omitempty"`

	// The test network ARM Id.
	TestNetworkID *string `json:"testNetworkId,omitempty"`

	// The list of disk update properties.
	VMDisks []*VMwareCbtUpdateDiskInput `json:"vmDisks,omitempty"`

	// The list of NIC details.
	VMNics []*VMwareCbtNicInput `json:"vmNics,omitempty"`
}

// GetUpdateMigrationItemProviderSpecificInput implements the UpdateMigrationItemProviderSpecificInputClassification interface
// for type VMwareCbtUpdateMigrationItemInput.
func (v *VMwareCbtUpdateMigrationItemInput) GetUpdateMigrationItemProviderSpecificInput() *UpdateMigrationItemProviderSpecificInput {
	return &UpdateMigrationItemProviderSpecificInput{
		InstanceType: v.InstanceType,
	}
}

// VMwareDetails - Store the fabric details specific to the VMware fabric.
type VMwareDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// The number of source and target servers configured to talk to this CS.
	AgentCount *string `json:"agentCount,omitempty"`

	// Agent expiry date.
	AgentExpiryDate *time.Time `json:"agentExpiryDate,omitempty"`

	// The agent Version.
	AgentVersion *string `json:"agentVersion,omitempty"`

	// The agent version details.
	AgentVersionDetails *VersionDetails `json:"agentVersionDetails,omitempty"`

	// The available memory.
	AvailableMemoryInBytes *int64 `json:"availableMemoryInBytes,omitempty"`

	// The available space.
	AvailableSpaceInBytes *int64 `json:"availableSpaceInBytes,omitempty"`

	// The percentage of the CPU load.
	CPULoad *string `json:"cpuLoad,omitempty"`

	// The CPU load status.
	CPULoadStatus *string `json:"cpuLoadStatus,omitempty"`

	// The CS service status.
	CsServiceStatus *string `json:"csServiceStatus,omitempty"`

	// The database server load.
	DatabaseServerLoad *string `json:"databaseServerLoad,omitempty"`

	// The database server load status.
	DatabaseServerLoadStatus *string `json:"databaseServerLoadStatus,omitempty"`

	// The host name.
	HostName *string `json:"hostName,omitempty"`

	// The IP address.
	IPAddress *string `json:"ipAddress,omitempty"`

	// The last heartbeat received from CS server.
	LastHeartbeat *time.Time `json:"lastHeartbeat,omitempty"`

	// The list of Master Target servers associated with the fabric.
	MasterTargetServers []*MasterTargetServer `json:"masterTargetServers,omitempty"`

	// The memory usage status.
	MemoryUsageStatus *string `json:"memoryUsageStatus,omitempty"`

	// The number of process servers.
	ProcessServerCount *string `json:"processServerCount,omitempty"`

	// The list of Process Servers associated with the fabric.
	ProcessServers []*ProcessServer `json:"processServers,omitempty"`

	// The number of protected servers.
	ProtectedServers *string `json:"protectedServers,omitempty"`

	// PS template version.
	PsTemplateVersion *string `json:"psTemplateVersion,omitempty"`

	// The number of replication pairs configured in this CS.
	ReplicationPairCount *string `json:"replicationPairCount,omitempty"`

	// The list of run as accounts created on the server.
	RunAsAccounts []*RunAsAccount `json:"runAsAccounts,omitempty"`

	// CS SSL cert expiry date.
	SSLCertExpiryDate *time.Time `json:"sslCertExpiryDate,omitempty"`

	// CS SSL cert expiry date.
	SSLCertExpiryRemainingDays *int32 `json:"sslCertExpiryRemainingDays,omitempty"`

	// The space usage status.
	SpaceUsageStatus *string `json:"spaceUsageStatus,omitempty"`

	// The switch provider blocking error information.
	SwitchProviderBlockingErrorDetails []*InMageFabricSwitchProviderBlockingErrorDetails `json:"switchProviderBlockingErrorDetails,omitempty"`

	// The percentage of the system load.
	SystemLoad *string `json:"systemLoad,omitempty"`

	// The system load status.
	SystemLoadStatus *string `json:"systemLoadStatus,omitempty"`

	// The total memory.
	TotalMemoryInBytes *int64 `json:"totalMemoryInBytes,omitempty"`

	// The total space.
	TotalSpaceInBytes *int64 `json:"totalSpaceInBytes,omitempty"`

	// Version status.
	VersionStatus *string `json:"versionStatus,omitempty"`

	// The web load.
	WebLoad *string `json:"webLoad,omitempty"`

	// The web load status.
	WebLoadStatus *string `json:"webLoadStatus,omitempty"`
}

// GetFabricSpecificDetails implements the FabricSpecificDetailsClassification interface for type VMwareDetails.
func (v *VMwareDetails) GetFabricSpecificDetails() *FabricSpecificDetails {
	return &FabricSpecificDetails{
		InstanceType: v.InstanceType,
	}
}

// VMwareV2FabricCreationInput - VMwareV2 fabric provider specific settings.
type VMwareV2FabricCreationInput struct {
	// REQUIRED; Gets the class type.
	InstanceType *string `json:"instanceType,omitempty"`

	// REQUIRED; The ARM Id of the migration solution.
	MigrationSolutionID *string `json:"migrationSolutionId,omitempty"`

	// The ARM Id of the physical site.
	PhysicalSiteID *string `json:"physicalSiteId,omitempty"`

	// The ARM Id of the VMware site.
	VmwareSiteID *string `json:"vmwareSiteId,omitempty"`
}

// GetFabricSpecificCreationInput implements the FabricSpecificCreationInputClassification interface for type VMwareV2FabricCreationInput.
func (v *VMwareV2FabricCreationInput) GetFabricSpecificCreationInput() *FabricSpecificCreationInput {
	return &FabricSpecificCreationInput{
		InstanceType: v.InstanceType,
	}
}

// VMwareV2FabricSpecificDetails - VMwareV2 fabric specific details.
type VMwareV2FabricSpecificDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// READ-ONLY; The Migration solution ARM Id.
	MigrationSolutionID *string `json:"migrationSolutionId,omitempty" azure:"ro"`

	// READ-ONLY; The ARM Id of the physical site.
	PhysicalSiteID *string `json:"physicalSiteId,omitempty" azure:"ro"`

	// READ-ONLY; The list of process servers.
	ProcessServers []*ProcessServerDetails `json:"processServers,omitempty" azure:"ro"`

	// READ-ONLY; The service container Id.
	ServiceContainerID *string `json:"serviceContainerId,omitempty" azure:"ro"`

	// READ-ONLY; The service endpoint.
	ServiceEndpoint *string `json:"serviceEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; The service resource Id.
	ServiceResourceID *string `json:"serviceResourceId,omitempty" azure:"ro"`

	// READ-ONLY; The ARM Id of the VMware site.
	VmwareSiteID *string `json:"vmwareSiteId,omitempty" azure:"ro"`
}

// GetFabricSpecificDetails implements the FabricSpecificDetailsClassification interface for type VMwareV2FabricSpecificDetails.
func (v *VMwareV2FabricSpecificDetails) GetFabricSpecificDetails() *FabricSpecificDetails {
	return &FabricSpecificDetails{
		InstanceType: v.InstanceType,
	}
}

// VMwareVirtualMachineDetails - VMware provider specific settings.
type VMwareVirtualMachineDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// The ID generated by the InMage agent after it gets installed on guest. This is the ID to be used during InMage CreateProtection.
	AgentGeneratedID *string `json:"agentGeneratedId,omitempty"`

	// The value indicating if InMage scout agent is installed on guest.
	AgentInstalled *string `json:"agentInstalled,omitempty"`

	// The agent version.
	AgentVersion *string `json:"agentVersion,omitempty"`

	// A value indicating the discovery type of the machine. Value can be vCenter or physical.
	DiscoveryType *string `json:"discoveryType,omitempty"`

	// The disk details.
	DiskDetails []*InMageDiskDetails `json:"diskDetails,omitempty"`

	// The IP address.
	IPAddress *string `json:"ipAddress,omitempty"`

	// The OsType installed on VM.
	OSType *string `json:"osType,omitempty"`

	// The value indicating whether VM is powered on.
	PoweredOn *string `json:"poweredOn,omitempty"`

	// The VCenter infrastructure Id.
	VCenterInfrastructureID *string `json:"vCenterInfrastructureId,omitempty"`

	// The validation errors.
	ValidationErrors []*HealthError `json:"validationErrors,omitempty"`
}

// GetConfigurationSettings implements the ConfigurationSettingsClassification interface for type VMwareVirtualMachineDetails.
func (v *VMwareVirtualMachineDetails) GetConfigurationSettings() *ConfigurationSettings {
	return &ConfigurationSettings{
		InstanceType: v.InstanceType,
	}
}

// VaultHealthDetails - Vault health details definition.
type VaultHealthDetails struct {
	// Resource Location
	Location *string `json:"location,omitempty"`

	// The vault health related data.
	Properties *VaultHealthProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VaultHealthProperties - class to define the health summary of the Vault.
type VaultHealthProperties struct {
	// The list of the health detail of the containers in the vault.
	ContainersHealth *ResourceHealthSummary `json:"containersHealth,omitempty"`

	// The list of the health detail of the fabrics in the vault.
	FabricsHealth *ResourceHealthSummary `json:"fabricsHealth,omitempty"`

	// The list of the health detail of the protected items in the vault.
	ProtectedItemsHealth *ResourceHealthSummary `json:"protectedItemsHealth,omitempty"`

	// The list of errors on the vault.
	VaultErrors []*HealthError `json:"vaultErrors,omitempty"`
}

// VaultSetting - Vault setting.
type VaultSetting struct {
	// Resource Location
	Location *string `json:"location,omitempty"`

	// The vault setting properties.
	Properties *VaultSettingProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VaultSettingCollection - Vault setting collection.
type VaultSettingCollection struct {
	// The value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of vault setting.
	Value []*VaultSetting `json:"value,omitempty"`
}

// VaultSettingCreationInput - Input to create vault setting.
type VaultSettingCreationInput struct {
	// REQUIRED; Vault setting creation input properties.
	Properties *VaultSettingCreationInputProperties `json:"properties,omitempty"`
}

// VaultSettingCreationInputProperties - Input to create vault setting.
type VaultSettingCreationInputProperties struct {
	// The migration solution Id.
	MigrationSolutionID *string `json:"migrationSolutionId,omitempty"`

	// VMware to Azure provider type.
	VmwareToAzureProviderType *string `json:"vmwareToAzureProviderType,omitempty"`
}

// VaultSettingProperties - Vault setting properties.
type VaultSettingProperties struct {
	// The migration solution ARM Id.
	MigrationSolutionID *string `json:"migrationSolutionId,omitempty"`

	// VMware to Azure provider type.
	VmwareToAzureProviderType *string `json:"vmwareToAzureProviderType,omitempty"`
}

// VersionDetails - Version related details.
type VersionDetails struct {
	// Version expiry date.
	ExpiryDate *time.Time `json:"expiryDate,omitempty"`

	// A value indicating whether security update required.
	Status *AgentVersionStatus `json:"status,omitempty"`

	// The agent version.
	Version *string `json:"version,omitempty"`
}

// VirtualMachineTaskDetails - This class represents the virtual machine task details.
type VirtualMachineTaskDetails struct {
	// REQUIRED; The type of task details.
	InstanceType *string `json:"instanceType,omitempty"`

	// The job entity.
	JobTask *JobEntity `json:"jobTask,omitempty"`

	// The skipped reason.
	SkippedReason *string `json:"skippedReason,omitempty"`

	// The skipped reason string.
	SkippedReasonString *string `json:"skippedReasonString,omitempty"`
}

// GetJobTaskDetails implements the JobTaskDetailsClassification interface for type VirtualMachineTaskDetails.
func (v *VirtualMachineTaskDetails) GetJobTaskDetails() *JobTaskDetails {
	return &JobTaskDetails{
		JobTask:      v.JobTask,
		InstanceType: v.InstanceType,
	}
}

// GetTaskTypeDetails implements the TaskTypeDetailsClassification interface for type VirtualMachineTaskDetails.
func (v *VirtualMachineTaskDetails) GetTaskTypeDetails() *TaskTypeDetails {
	return &TaskTypeDetails{
		InstanceType: v.InstanceType,
	}
}

// VmmDetails - VMM fabric specific details.
type VmmDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetFabricSpecificDetails implements the FabricSpecificDetailsClassification interface for type VmmDetails.
func (v *VmmDetails) GetFabricSpecificDetails() *FabricSpecificDetails {
	return &FabricSpecificDetails{
		InstanceType: v.InstanceType,
	}
}

// VmmToAzureCreateNetworkMappingInput - Create network mappings input properties/behavior specific to Vmm to Azure Network
// mapping.
type VmmToAzureCreateNetworkMappingInput struct {
	// REQUIRED; The instance type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetFabricSpecificCreateNetworkMappingInput implements the FabricSpecificCreateNetworkMappingInputClassification interface
// for type VmmToAzureCreateNetworkMappingInput.
func (v *VmmToAzureCreateNetworkMappingInput) GetFabricSpecificCreateNetworkMappingInput() *FabricSpecificCreateNetworkMappingInput {
	return &FabricSpecificCreateNetworkMappingInput{
		InstanceType: v.InstanceType,
	}
}

// VmmToAzureNetworkMappingSettings - E2A Network Mapping fabric specific settings.
type VmmToAzureNetworkMappingSettings struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetNetworkMappingFabricSpecificSettings implements the NetworkMappingFabricSpecificSettingsClassification interface for
// type VmmToAzureNetworkMappingSettings.
func (v *VmmToAzureNetworkMappingSettings) GetNetworkMappingFabricSpecificSettings() *NetworkMappingFabricSpecificSettings {
	return &NetworkMappingFabricSpecificSettings{
		InstanceType: v.InstanceType,
	}
}

// VmmToAzureUpdateNetworkMappingInput - Update network mappings input properties/behavior specific to vmm to azure.
type VmmToAzureUpdateNetworkMappingInput struct {
	// REQUIRED; The instance type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetFabricSpecificUpdateNetworkMappingInput implements the FabricSpecificUpdateNetworkMappingInputClassification interface
// for type VmmToAzureUpdateNetworkMappingInput.
func (v *VmmToAzureUpdateNetworkMappingInput) GetFabricSpecificUpdateNetworkMappingInput() *FabricSpecificUpdateNetworkMappingInput {
	return &FabricSpecificUpdateNetworkMappingInput{
		InstanceType: v.InstanceType,
	}
}

// VmmToVmmCreateNetworkMappingInput - Create network mappings input properties/behavior specific to vmm to vmm Network mapping.
type VmmToVmmCreateNetworkMappingInput struct {
	// REQUIRED; The instance type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetFabricSpecificCreateNetworkMappingInput implements the FabricSpecificCreateNetworkMappingInputClassification interface
// for type VmmToVmmCreateNetworkMappingInput.
func (v *VmmToVmmCreateNetworkMappingInput) GetFabricSpecificCreateNetworkMappingInput() *FabricSpecificCreateNetworkMappingInput {
	return &FabricSpecificCreateNetworkMappingInput{
		InstanceType: v.InstanceType,
	}
}

// VmmToVmmNetworkMappingSettings - E2E Network Mapping fabric specific settings.
type VmmToVmmNetworkMappingSettings struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetNetworkMappingFabricSpecificSettings implements the NetworkMappingFabricSpecificSettingsClassification interface for
// type VmmToVmmNetworkMappingSettings.
func (v *VmmToVmmNetworkMappingSettings) GetNetworkMappingFabricSpecificSettings() *NetworkMappingFabricSpecificSettings {
	return &NetworkMappingFabricSpecificSettings{
		InstanceType: v.InstanceType,
	}
}

// VmmToVmmUpdateNetworkMappingInput - Update network mappings input properties/behavior specific to vmm to vmm.
type VmmToVmmUpdateNetworkMappingInput struct {
	// REQUIRED; The instance type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// GetFabricSpecificUpdateNetworkMappingInput implements the FabricSpecificUpdateNetworkMappingInputClassification interface
// for type VmmToVmmUpdateNetworkMappingInput.
func (v *VmmToVmmUpdateNetworkMappingInput) GetFabricSpecificUpdateNetworkMappingInput() *FabricSpecificUpdateNetworkMappingInput {
	return &FabricSpecificUpdateNetworkMappingInput{
		InstanceType: v.InstanceType,
	}
}

// VmmVirtualMachineDetails - VMM fabric provider specific VM settings.
type VmmVirtualMachineDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// The Last successful failover time.
	DiskDetails []*DiskDetails `json:"diskDetails,omitempty"`

	// The id of the object in fabric.
	Generation *string `json:"generation,omitempty"`

	// A value indicating whether the VM has a fibre channel adapter attached. String value of SrsDataContract.PresenceStatus
	// enum.
	HasFibreChannelAdapter *PresenceStatus `json:"hasFibreChannelAdapter,omitempty"`

	// A value indicating whether the VM has a physical disk attached. String value of SrsDataContract.PresenceStatus enum.
	HasPhysicalDisk *PresenceStatus `json:"hasPhysicalDisk,omitempty"`

	// A value indicating whether the VM has a shared VHD attached. String value of SrsDataContract.PresenceStatus enum.
	HasSharedVhd *PresenceStatus `json:"hasSharedVhd,omitempty"`

	// The Id of the hyper-v host in fabric.
	HyperVHostID *string `json:"hyperVHostId,omitempty"`

	// The Last replication time.
	OSDetails *OSDetails `json:"osDetails,omitempty"`

	// The source id of the object.
	SourceItemID *string `json:"sourceItemId,omitempty"`
}

// GetConfigurationSettings implements the ConfigurationSettingsClassification interface for type VmmVirtualMachineDetails.
func (v *VmmVirtualMachineDetails) GetConfigurationSettings() *ConfigurationSettings {
	return &ConfigurationSettings{
		InstanceType: v.InstanceType,
	}
}

// GetHyperVVirtualMachineDetails implements the HyperVVirtualMachineDetailsClassification interface for type VmmVirtualMachineDetails.
func (v *VmmVirtualMachineDetails) GetHyperVVirtualMachineDetails() *HyperVVirtualMachineDetails {
	return &HyperVVirtualMachineDetails{
		SourceItemID:           v.SourceItemID,
		Generation:             v.Generation,
		OSDetails:              v.OSDetails,
		DiskDetails:            v.DiskDetails,
		HasPhysicalDisk:        v.HasPhysicalDisk,
		HasFibreChannelAdapter: v.HasFibreChannelAdapter,
		HasSharedVhd:           v.HasSharedVhd,
		HyperVHostID:           v.HyperVHostID,
		InstanceType:           v.InstanceType,
	}
}

// VmwareCbtPolicyDetails - VMware Cbt specific policy details.
type VmwareCbtPolicyDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`

	// The app consistent snapshot frequency in minutes.
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`

	// The crash consistent snapshot frequency in minutes.
	CrashConsistentFrequencyInMinutes *int32 `json:"crashConsistentFrequencyInMinutes,omitempty"`

	// The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistoryInMinutes *int32 `json:"recoveryPointHistoryInMinutes,omitempty"`
}

// GetPolicyProviderSpecificDetails implements the PolicyProviderSpecificDetailsClassification interface for type VmwareCbtPolicyDetails.
func (v *VmwareCbtPolicyDetails) GetPolicyProviderSpecificDetails() *PolicyProviderSpecificDetails {
	return &PolicyProviderSpecificDetails{
		InstanceType: v.InstanceType,
	}
}
