//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armscvmm

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// VmmServersClient contains the methods for the VmmServers group.
// Don't use this type directly, use NewVmmServersClient() instead.
type VmmServersClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewVmmServersClient creates a new instance of VmmServersClient with the specified values.
// subscriptionID - The Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewVmmServersClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*VmmServersClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &VmmServersClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginCreateOrUpdate - Onboards the SCVMM fabric as an Azure VmmServer resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-06-05-preview
// resourceGroupName - The name of the resource group.
// vmmServerName - Name of the VMMServer.
// body - Request payload.
// options - VmmServersClientBeginCreateOrUpdateOptions contains the optional parameters for the VmmServersClient.BeginCreateOrUpdate
// method.
func (client *VmmServersClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, vmmServerName string, body VMMServer, options *VmmServersClientBeginCreateOrUpdateOptions) (*runtime.Poller[VmmServersClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, resourceGroupName, vmmServerName, body, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller(resp, client.pl, &runtime.NewPollerOptions[VmmServersClientCreateOrUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
		})
	} else {
		return runtime.NewPollerFromResumeToken[VmmServersClientCreateOrUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrUpdate - Onboards the SCVMM fabric as an Azure VmmServer resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-06-05-preview
func (client *VmmServersClient) createOrUpdate(ctx context.Context, resourceGroupName string, vmmServerName string, body VMMServer, options *VmmServersClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, vmmServerName, body, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *VmmServersClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, vmmServerName string, body VMMServer, options *VmmServersClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/vmmServers/{vmmServerName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if vmmServerName == "" {
		return nil, errors.New("parameter vmmServerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vmmServerName}", url.PathEscape(vmmServerName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-06-05-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, body)
}

// BeginDelete - Deboards the SCVMM fabric from Azure.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-06-05-preview
// resourceGroupName - The name of the resource group.
// vmmServerName - Name of the VMMServer.
// options - VmmServersClientBeginDeleteOptions contains the optional parameters for the VmmServersClient.BeginDelete method.
func (client *VmmServersClient) BeginDelete(ctx context.Context, resourceGroupName string, vmmServerName string, options *VmmServersClientBeginDeleteOptions) (*runtime.Poller[VmmServersClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, vmmServerName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller(resp, client.pl, &runtime.NewPollerOptions[VmmServersClientDeleteResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
		})
	} else {
		return runtime.NewPollerFromResumeToken[VmmServersClientDeleteResponse](options.ResumeToken, client.pl, nil)
	}
}

// Delete - Deboards the SCVMM fabric from Azure.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-06-05-preview
func (client *VmmServersClient) deleteOperation(ctx context.Context, resourceGroupName string, vmmServerName string, options *VmmServersClientBeginDeleteOptions) (*http.Response, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, vmmServerName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *VmmServersClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, vmmServerName string, options *VmmServersClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/vmmServers/{vmmServerName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if vmmServerName == "" {
		return nil, errors.New("parameter vmmServerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vmmServerName}", url.PathEscape(vmmServerName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-06-05-preview")
	if options != nil && options.Force != nil {
		reqQP.Set("force", strconv.FormatBool(*options.Force))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Implements VMMServer GET method.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-06-05-preview
// resourceGroupName - The name of the resource group.
// vmmServerName - Name of the VMMServer.
// options - VmmServersClientGetOptions contains the optional parameters for the VmmServersClient.Get method.
func (client *VmmServersClient) Get(ctx context.Context, resourceGroupName string, vmmServerName string, options *VmmServersClientGetOptions) (VmmServersClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, vmmServerName, options)
	if err != nil {
		return VmmServersClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return VmmServersClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return VmmServersClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *VmmServersClient) getCreateRequest(ctx context.Context, resourceGroupName string, vmmServerName string, options *VmmServersClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/vmmServers/{vmmServerName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if vmmServerName == "" {
		return nil, errors.New("parameter vmmServerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vmmServerName}", url.PathEscape(vmmServerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-06-05-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *VmmServersClient) getHandleResponse(resp *http.Response) (VmmServersClientGetResponse, error) {
	result := VmmServersClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VMMServer); err != nil {
		return VmmServersClientGetResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - List of VmmServers in a resource group.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-06-05-preview
// resourceGroupName - The name of the resource group.
// options - VmmServersClientListByResourceGroupOptions contains the optional parameters for the VmmServersClient.ListByResourceGroup
// method.
func (client *VmmServersClient) NewListByResourceGroupPager(resourceGroupName string, options *VmmServersClientListByResourceGroupOptions) *runtime.Pager[VmmServersClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[VmmServersClientListByResourceGroupResponse]{
		More: func(page VmmServersClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *VmmServersClientListByResourceGroupResponse) (VmmServersClientListByResourceGroupResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return VmmServersClientListByResourceGroupResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return VmmServersClientListByResourceGroupResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return VmmServersClientListByResourceGroupResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *VmmServersClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *VmmServersClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/vmmServers"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-06-05-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *VmmServersClient) listByResourceGroupHandleResponse(resp *http.Response) (VmmServersClientListByResourceGroupResponse, error) {
	result := VmmServersClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VMMServerListResult); err != nil {
		return VmmServersClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListBySubscriptionPager - List of VmmServers in a subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-06-05-preview
// options - VmmServersClientListBySubscriptionOptions contains the optional parameters for the VmmServersClient.ListBySubscription
// method.
func (client *VmmServersClient) NewListBySubscriptionPager(options *VmmServersClientListBySubscriptionOptions) *runtime.Pager[VmmServersClientListBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[VmmServersClientListBySubscriptionResponse]{
		More: func(page VmmServersClientListBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *VmmServersClientListBySubscriptionResponse) (VmmServersClientListBySubscriptionResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listBySubscriptionCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return VmmServersClientListBySubscriptionResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return VmmServersClientListBySubscriptionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return VmmServersClientListBySubscriptionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listBySubscriptionHandleResponse(resp)
		},
	})
}

// listBySubscriptionCreateRequest creates the ListBySubscription request.
func (client *VmmServersClient) listBySubscriptionCreateRequest(ctx context.Context, options *VmmServersClientListBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ScVmm/vmmServers"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-06-05-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionHandleResponse handles the ListBySubscription response.
func (client *VmmServersClient) listBySubscriptionHandleResponse(resp *http.Response) (VmmServersClientListBySubscriptionResponse, error) {
	result := VmmServersClientListBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VMMServerListResult); err != nil {
		return VmmServersClientListBySubscriptionResponse{}, err
	}
	return result, nil
}

// BeginUpdate - Updates the VmmServers resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-06-05-preview
// resourceGroupName - The name of the resource group.
// vmmServerName - Name of the VMMServer.
// body - VmmServers patch payload.
// options - VmmServersClientBeginUpdateOptions contains the optional parameters for the VmmServersClient.BeginUpdate method.
func (client *VmmServersClient) BeginUpdate(ctx context.Context, resourceGroupName string, vmmServerName string, body ResourcePatch, options *VmmServersClientBeginUpdateOptions) (*runtime.Poller[VmmServersClientUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.update(ctx, resourceGroupName, vmmServerName, body, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller(resp, client.pl, &runtime.NewPollerOptions[VmmServersClientUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
		})
	} else {
		return runtime.NewPollerFromResumeToken[VmmServersClientUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// Update - Updates the VmmServers resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-06-05-preview
func (client *VmmServersClient) update(ctx context.Context, resourceGroupName string, vmmServerName string, body ResourcePatch, options *VmmServersClientBeginUpdateOptions) (*http.Response, error) {
	req, err := client.updateCreateRequest(ctx, resourceGroupName, vmmServerName, body, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// updateCreateRequest creates the Update request.
func (client *VmmServersClient) updateCreateRequest(ctx context.Context, resourceGroupName string, vmmServerName string, body ResourcePatch, options *VmmServersClientBeginUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/vmmServers/{vmmServerName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if vmmServerName == "" {
		return nil, errors.New("parameter vmmServerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vmmServerName}", url.PathEscape(vmmServerName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-06-05-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, body)
}
