//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armworkloads

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// PhpWorkloadsClient contains the methods for the PhpWorkloads group.
// Don't use this type directly, use NewPhpWorkloadsClient() instead.
type PhpWorkloadsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewPhpWorkloadsClient creates a new instance of PhpWorkloadsClient with the specified values.
// subscriptionID - The ID of the target subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewPhpWorkloadsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*PhpWorkloadsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &PhpWorkloadsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginCreateOrUpdate - Create or updated PHP workload resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// phpWorkloadName - Php workload name
// phpWorkloadResource - Resource create or update request payload
// options - PhpWorkloadsClientBeginCreateOrUpdateOptions contains the optional parameters for the PhpWorkloadsClient.BeginCreateOrUpdate
// method.
func (client *PhpWorkloadsClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, phpWorkloadName string, phpWorkloadResource PhpWorkloadResource, options *PhpWorkloadsClientBeginCreateOrUpdateOptions) (*runtime.Poller[PhpWorkloadsClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, resourceGroupName, phpWorkloadName, phpWorkloadResource, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller(resp, client.pl, &runtime.NewPollerOptions[PhpWorkloadsClientCreateOrUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
		})
	} else {
		return runtime.NewPollerFromResumeToken[PhpWorkloadsClientCreateOrUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrUpdate - Create or updated PHP workload resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01-preview
func (client *PhpWorkloadsClient) createOrUpdate(ctx context.Context, resourceGroupName string, phpWorkloadName string, phpWorkloadResource PhpWorkloadResource, options *PhpWorkloadsClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, phpWorkloadName, phpWorkloadResource, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *PhpWorkloadsClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, phpWorkloadName string, phpWorkloadResource PhpWorkloadResource, options *PhpWorkloadsClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/phpWorkloads/{phpWorkloadName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if phpWorkloadName == "" {
		return nil, errors.New("parameter phpWorkloadName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{phpWorkloadName}", url.PathEscape(phpWorkloadName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, phpWorkloadResource)
}

// BeginDelete - Delete PHP workload resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// phpWorkloadName - Php workload name
// options - PhpWorkloadsClientBeginDeleteOptions contains the optional parameters for the PhpWorkloadsClient.BeginDelete
// method.
func (client *PhpWorkloadsClient) BeginDelete(ctx context.Context, resourceGroupName string, phpWorkloadName string, options *PhpWorkloadsClientBeginDeleteOptions) (*runtime.Poller[PhpWorkloadsClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, phpWorkloadName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller(resp, client.pl, &runtime.NewPollerOptions[PhpWorkloadsClientDeleteResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
		})
	} else {
		return runtime.NewPollerFromResumeToken[PhpWorkloadsClientDeleteResponse](options.ResumeToken, client.pl, nil)
	}
}

// Delete - Delete PHP workload resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01-preview
func (client *PhpWorkloadsClient) deleteOperation(ctx context.Context, resourceGroupName string, phpWorkloadName string, options *PhpWorkloadsClientBeginDeleteOptions) (*http.Response, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, phpWorkloadName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *PhpWorkloadsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, phpWorkloadName string, options *PhpWorkloadsClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/phpWorkloads/{phpWorkloadName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if phpWorkloadName == "" {
		return nil, errors.New("parameter phpWorkloadName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{phpWorkloadName}", url.PathEscape(phpWorkloadName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01-preview")
	if options != nil && options.DeleteInfra != nil {
		reqQP.Set("delete-infra", *options.DeleteInfra)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Gets the PHP workload resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// phpWorkloadName - Php workload name
// options - PhpWorkloadsClientGetOptions contains the optional parameters for the PhpWorkloadsClient.Get method.
func (client *PhpWorkloadsClient) Get(ctx context.Context, resourceGroupName string, phpWorkloadName string, options *PhpWorkloadsClientGetOptions) (PhpWorkloadsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, phpWorkloadName, options)
	if err != nil {
		return PhpWorkloadsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PhpWorkloadsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PhpWorkloadsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *PhpWorkloadsClient) getCreateRequest(ctx context.Context, resourceGroupName string, phpWorkloadName string, options *PhpWorkloadsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/phpWorkloads/{phpWorkloadName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if phpWorkloadName == "" {
		return nil, errors.New("parameter phpWorkloadName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{phpWorkloadName}", url.PathEscape(phpWorkloadName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *PhpWorkloadsClient) getHandleResponse(resp *http.Response) (PhpWorkloadsClientGetResponse, error) {
	result := PhpWorkloadsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PhpWorkloadResource); err != nil {
		return PhpWorkloadsClientGetResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - Lists PHP workload resources in a resource group.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// options - PhpWorkloadsClientListByResourceGroupOptions contains the optional parameters for the PhpWorkloadsClient.ListByResourceGroup
// method.
func (client *PhpWorkloadsClient) NewListByResourceGroupPager(resourceGroupName string, options *PhpWorkloadsClientListByResourceGroupOptions) *runtime.Pager[PhpWorkloadsClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[PhpWorkloadsClientListByResourceGroupResponse]{
		More: func(page PhpWorkloadsClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PhpWorkloadsClientListByResourceGroupResponse) (PhpWorkloadsClientListByResourceGroupResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return PhpWorkloadsClientListByResourceGroupResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return PhpWorkloadsClientListByResourceGroupResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return PhpWorkloadsClientListByResourceGroupResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *PhpWorkloadsClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *PhpWorkloadsClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/phpWorkloads"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *PhpWorkloadsClient) listByResourceGroupHandleResponse(resp *http.Response) (PhpWorkloadsClientListByResourceGroupResponse, error) {
	result := PhpWorkloadsClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PhpWorkloadResourceList); err != nil {
		return PhpWorkloadsClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListBySubscriptionPager - Lists PHP workload resources for a subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01-preview
// options - PhpWorkloadsClientListBySubscriptionOptions contains the optional parameters for the PhpWorkloadsClient.ListBySubscription
// method.
func (client *PhpWorkloadsClient) NewListBySubscriptionPager(options *PhpWorkloadsClientListBySubscriptionOptions) *runtime.Pager[PhpWorkloadsClientListBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[PhpWorkloadsClientListBySubscriptionResponse]{
		More: func(page PhpWorkloadsClientListBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PhpWorkloadsClientListBySubscriptionResponse) (PhpWorkloadsClientListBySubscriptionResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listBySubscriptionCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return PhpWorkloadsClientListBySubscriptionResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return PhpWorkloadsClientListBySubscriptionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return PhpWorkloadsClientListBySubscriptionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listBySubscriptionHandleResponse(resp)
		},
	})
}

// listBySubscriptionCreateRequest creates the ListBySubscription request.
func (client *PhpWorkloadsClient) listBySubscriptionCreateRequest(ctx context.Context, options *PhpWorkloadsClientListBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Workloads/phpWorkloads"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionHandleResponse handles the ListBySubscription response.
func (client *PhpWorkloadsClient) listBySubscriptionHandleResponse(resp *http.Response) (PhpWorkloadsClientListBySubscriptionResponse, error) {
	result := PhpWorkloadsClientListBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PhpWorkloadResourceList); err != nil {
		return PhpWorkloadsClientListBySubscriptionResponse{}, err
	}
	return result, nil
}

// Update - Update PHP workload resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// phpWorkloadName - Php workload name
// resourcePatchRequestBody - Workload resource update data
// options - PhpWorkloadsClientUpdateOptions contains the optional parameters for the PhpWorkloadsClient.Update method.
func (client *PhpWorkloadsClient) Update(ctx context.Context, resourceGroupName string, phpWorkloadName string, resourcePatchRequestBody PatchResourceRequestBody, options *PhpWorkloadsClientUpdateOptions) (PhpWorkloadsClientUpdateResponse, error) {
	req, err := client.updateCreateRequest(ctx, resourceGroupName, phpWorkloadName, resourcePatchRequestBody, options)
	if err != nil {
		return PhpWorkloadsClientUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PhpWorkloadsClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PhpWorkloadsClientUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateHandleResponse(resp)
}

// updateCreateRequest creates the Update request.
func (client *PhpWorkloadsClient) updateCreateRequest(ctx context.Context, resourceGroupName string, phpWorkloadName string, resourcePatchRequestBody PatchResourceRequestBody, options *PhpWorkloadsClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/phpWorkloads/{phpWorkloadName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if phpWorkloadName == "" {
		return nil, errors.New("parameter phpWorkloadName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{phpWorkloadName}", url.PathEscape(phpWorkloadName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, resourcePatchRequestBody)
}

// updateHandleResponse handles the Update response.
func (client *PhpWorkloadsClient) updateHandleResponse(resp *http.Response) (PhpWorkloadsClientUpdateResponse, error) {
	result := PhpWorkloadsClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PhpWorkloadResource); err != nil {
		return PhpWorkloadsClientUpdateResponse{}, err
	}
	return result, nil
}
