// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudwatchlogs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates an existing log anomaly detector.
func (c *Client) UpdateLogAnomalyDetector(ctx context.Context, params *UpdateLogAnomalyDetectorInput, optFns ...func(*Options)) (*UpdateLogAnomalyDetectorOutput, error) {
	if params == nil {
		params = &UpdateLogAnomalyDetectorInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateLogAnomalyDetector", params, optFns, c.addOperationUpdateLogAnomalyDetectorMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateLogAnomalyDetectorOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateLogAnomalyDetectorInput struct {

	// The ARN of the anomaly detector that you want to update.
	//
	// This member is required.
	AnomalyDetectorArn *string

	// Use this parameter to pause or restart the anomaly detector.
	//
	// This member is required.
	Enabled *bool

	// The number of days to use as the life cycle of anomalies. After this time,
	// anomalies are automatically baselined and the anomaly detector model will treat
	// new occurrences of similar event as normal. Therefore, if you do not correct the
	// cause of an anomaly during this time, it will be considered normal going forward
	// and will not be detected.
	AnomalyVisibilityTime *int64

	// Specifies how often the anomaly detector runs and look for anomalies. Set this
	// value according to the frequency that the log group receives new logs. For
	// example, if the log group receives new log events every 10 minutes, then setting
	// evaluationFrequency to FIFTEEN_MIN might be appropriate.
	EvaluationFrequency types.EvaluationFrequency

	// A symbolic description of how CloudWatch Logs should interpret the data in each
	// log event. For example, a log event can contain timestamps, IP addresses,
	// strings, and so on. You use the filter pattern to specify what to look for in
	// the log event message.
	FilterPattern *string

	noSmithyDocumentSerde
}

type UpdateLogAnomalyDetectorOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateLogAnomalyDetectorMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateLogAnomalyDetector{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateLogAnomalyDetector{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateLogAnomalyDetector"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateLogAnomalyDetectorValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateLogAnomalyDetector(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateLogAnomalyDetector(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateLogAnomalyDetector",
	}
}
