// Code generated by smithy-go-codegen DO NOT EDIT.

package quicksight

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/quicksight/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the SPICE capacity configuration for a Amazon QuickSight account.
func (c *Client) UpdateSPICECapacityConfiguration(ctx context.Context, params *UpdateSPICECapacityConfigurationInput, optFns ...func(*Options)) (*UpdateSPICECapacityConfigurationOutput, error) {
	if params == nil {
		params = &UpdateSPICECapacityConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateSPICECapacityConfiguration", params, optFns, c.addOperationUpdateSPICECapacityConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateSPICECapacityConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateSPICECapacityConfigurationInput struct {

	// The ID of the Amazon Web Services account that contains the SPICE configuration
	// that you want to update.
	//
	// This member is required.
	AwsAccountId *string

	// Determines how SPICE capacity can be purchased. The following options are
	// available.
	//
	//   - MANUAL : SPICE capacity can only be purchased manually.
	//
	//   - AUTO_PURCHASE : Extra SPICE capacity is automatically purchased on your
	//   behalf as needed. SPICE capacity can also be purchased manually with this
	//   option.
	//
	// This member is required.
	PurchaseMode types.PurchaseMode

	noSmithyDocumentSerde
}

type UpdateSPICECapacityConfigurationOutput struct {

	// The Amazon Web Services request ID for this operation.
	RequestId *string

	// The HTTP status of the request.
	Status int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateSPICECapacityConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateSPICECapacityConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateSPICECapacityConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateSPICECapacityConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateSPICECapacityConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateSPICECapacityConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateSPICECapacityConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateSPICECapacityConfiguration",
	}
}
