# frozen_string_literal: true

class RemoveIssuesVulnerabilityFeedbackIssueIdFk < Gitlab::Database::Migration[2.2]
  milestone '17.6'
  disable_ddl_transaction!

  FOREIGN_KEY_NAME = "fk_rails_8c77e5891a"

  def up
    with_lock_retries do
      remove_foreign_key_if_exists(:vulnerability_feedback, :issues,
        name: FOREIGN_KEY_NAME, reverse_lock_order: true)
    end
  end

  def down
    add_concurrent_foreign_key(:vulnerability_feedback, :issues,
      name: FOREIGN_KEY_NAME, column: :issue_id,
      target_column: :id, on_delete: :nullify)
  end
end
