// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package f3

import (
	"io"
	"time"
)

type DownloadFuncType func() io.ReadCloser

type Attachment struct {
	Common
	Name          string           `json:"name"`
	ContentType   string           `json:"content_type"`
	Size          int64            `json:"size"`
	DownloadCount int64            `json:"download_count"`
	Created       time.Time        `json:"created"`
	SHA256        string           `json:"sha256"`
	DownloadURL   string           `json:"download_url"`
	DownloadFunc  DownloadFuncType `json:"-"`
}

func (o Attachment) Equal(other Attachment) bool {
	return o.Common.Equal(other.Common) &&
		o.Name == other.Name &&
		o.ContentType == other.ContentType &&
		o.Size == other.Size &&
		o.SHA256 == other.SHA256
}

func (o *Attachment) Clone() Interface {
	clone := &Attachment{}
	*clone = *o
	return clone
}
