// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package f3

import (
	"fmt"

	"code.forgejo.org/f3/gof3/v3/f3"
)

func NewLabelPathString[T any](projectPath string, id T) string {
	return fmt.Sprintf("%s/labels/%v", projectPath, id)
}

func NewLabelReference[T any](projectPath string, id T) *f3.Reference {
	return f3.NewReference(NewLabelPathString(projectPath, id))
}

func NewIssueLabelReference[T any](id T) *f3.Reference {
	return f3.NewReference(NewLabelPathString("../..", id))
}

func NewPullRequestLabelReference[T any](id T) *f3.Reference {
	return f3.NewReference(NewLabelPathString("../..", id))
}
