---
date: 2026-02-19
section: 1
title: GO-VERSION
header: Go programming tools and commands
footer: Go 1.26
---

# NAME

go-version - print Go version

# SYNOPSIS

**go version** \[**-m**\] \[**-v**\] \[**-json**\] \[*file ...*\]

# DESCRIPTION

Version prints the build information for Go binary files.

Go version reports the Go version used to build each of the named files.

If no files are named on the command line, go version prints its own
version information.

If a directory is named, go version walks that directory, recursively,
looking for recognized Go binaries and reporting their versions. By
default, go version does not report unrecognized files found during a
directory scan. The **-v** flag causes it to report unrecognized files.

The **-m** flag causes go version to print each file's embedded module
version information, when available. In the output, the module
information consists of multiple lines following the version line, each
indented by a leading tab character.

The **-json** flag is similar to **-m** but outputs the
runtime/debug.BuildInfo in JSON format. If flag **-json** is specified
without **-m**, go version reports an error.

# SEE ALSO

**go doc runtime/debug.BuildInfo**.

# AUTHOR

This manual page was created using help2man and afterwards updating the
output. It is maintained by the Debian Go Compiler Team
\<team+go-compiler@tracker.debian.org\> for the Debian project (and may
be used by others).
