// Code generated by smithy-go-codegen DO NOT EDIT.

package pinpointsmsvoicev2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a new opt-out list. If the opt-out list name already exists, an Error is
// returned. An opt-out list is a list of phone numbers that are opted out, meaning
// you can't send SMS or voice messages to them. If end user replies with the
// keyword "STOP," an entry for the phone number is added to the opt-out list. In
// addition to STOP, your recipients can use any supported opt-out keyword, such as
// CANCEL or OPTOUT. For a list of supported opt-out keywords, see  SMS opt out
// (https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-manage.html#channels-sms-manage-optout)
// in the Amazon Pinpoint User Guide.
func (c *Client) CreateOptOutList(ctx context.Context, params *CreateOptOutListInput, optFns ...func(*Options)) (*CreateOptOutListOutput, error) {
	if params == nil {
		params = &CreateOptOutListInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateOptOutList", params, optFns, c.addOperationCreateOptOutListMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateOptOutListOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateOptOutListInput struct {

	// The name of the new OptOutList.
	//
	// This member is required.
	OptOutListName *string

	// Unique, case-sensitive identifier that you provide to ensure the idempotency of
	// the request. If you don't specify a client token, a randomly generated token is
	// used for the request to ensure idempotency.
	ClientToken *string

	// An array of tags (key and value pairs) to associate with the new OptOutList.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateOptOutListOutput struct {

	// The time when the pool was created, in UNIX epoch time
	// (https://www.epochconverter.com/) format.
	CreatedTimestamp *time.Time

	// The Amazon Resource Name (ARN) for the OptOutList.
	OptOutListArn *string

	// The name of the new OptOutList.
	OptOutListName *string

	// An array of tags (key and value pairs) associated with the new OptOutList.
	Tags []types.Tag

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateOptOutListMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateOptOutList{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateOptOutList{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateOptOutListMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateOptOutListValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateOptOutList(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateOptOutList struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateOptOutList) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateOptOutList) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateOptOutListInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateOptOutListInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateOptOutListMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateOptOutList{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateOptOutList(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "sms-voice",
		OperationName: "CreateOptOutList",
	}
}
