// Code generated by smithy-go-codegen DO NOT EDIT.

package macie2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/macie2/types"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	smithywaiter "github.com/aws/smithy-go/waiter"
	"github.com/jmespath/go-jmespath"
	"time"
)

// Retrieves occurrences of sensitive data reported by a finding.
func (c *Client) GetSensitiveDataOccurrences(ctx context.Context, params *GetSensitiveDataOccurrencesInput, optFns ...func(*Options)) (*GetSensitiveDataOccurrencesOutput, error) {
	if params == nil {
		params = &GetSensitiveDataOccurrencesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetSensitiveDataOccurrences", params, optFns, c.addOperationGetSensitiveDataOccurrencesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetSensitiveDataOccurrencesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetSensitiveDataOccurrencesInput struct {

	// The unique identifier for the finding.
	//
	// This member is required.
	FindingId *string

	noSmithyDocumentSerde
}

type GetSensitiveDataOccurrencesOutput struct {

	// If an error occurred when Amazon Macie attempted to retrieve occurrences of
	// sensitive data reported by the finding, a description of the error that
	// occurred. This value is null if the status (status) of the request is PROCESSING
	// or SUCCESS.
	Error *string

	// A map that specifies 1-100 types of sensitive data reported by the finding and,
	// for each type, 1-10 occurrences of sensitive data.
	SensitiveDataOccurrences map[string][]types.DetectedDataDetails

	// The status of the request to retrieve occurrences of sensitive data reported by
	// the finding. Possible values are:
	//   - ERROR - An error occurred when Amazon Macie attempted to locate, retrieve,
	//   or encrypt the sensitive data. The error value indicates the nature of the error
	//   that occurred.
	//   - PROCESSING - Macie is processing the request.
	//   - SUCCESS - Macie successfully located, retrieved, and encrypted the
	//   sensitive data.
	Status types.RevealRequestStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetSensitiveDataOccurrencesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetSensitiveDataOccurrences{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetSensitiveDataOccurrences{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetSensitiveDataOccurrences"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetSensitiveDataOccurrencesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetSensitiveDataOccurrences(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// GetSensitiveDataOccurrencesAPIClient is a client that implements the
// GetSensitiveDataOccurrences operation.
type GetSensitiveDataOccurrencesAPIClient interface {
	GetSensitiveDataOccurrences(context.Context, *GetSensitiveDataOccurrencesInput, ...func(*Options)) (*GetSensitiveDataOccurrencesOutput, error)
}

var _ GetSensitiveDataOccurrencesAPIClient = (*Client)(nil)

// FindingRevealedWaiterOptions are waiter options for FindingRevealedWaiter
type FindingRevealedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	APIOptions []func(*middleware.Stack) error

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// FindingRevealedWaiter will use default minimum delay of 2 seconds. Note that
	// MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, FindingRevealedWaiter will use default max delay of 120 seconds.
	// Note that MaxDelay must resolve to value greater than or equal to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state. By
	// default service-modeled logic will populate this option. This option can thus be
	// used to define a custom waiter state with fall-back to service-modeled waiter
	// state mutators.The function returns an error in case of a failure state. In case
	// of retry state, this function returns a bool value of true and nil error, while
	// in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *GetSensitiveDataOccurrencesInput, *GetSensitiveDataOccurrencesOutput, error) (bool, error)
}

// FindingRevealedWaiter defines the waiters for FindingRevealed
type FindingRevealedWaiter struct {
	client GetSensitiveDataOccurrencesAPIClient

	options FindingRevealedWaiterOptions
}

// NewFindingRevealedWaiter constructs a FindingRevealedWaiter.
func NewFindingRevealedWaiter(client GetSensitiveDataOccurrencesAPIClient, optFns ...func(*FindingRevealedWaiterOptions)) *FindingRevealedWaiter {
	options := FindingRevealedWaiterOptions{}
	options.MinDelay = 2 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = findingRevealedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &FindingRevealedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for FindingRevealed waiter. The maxWaitDur is
// the maximum wait duration the waiter will wait. The maxWaitDur is required and
// must be greater than zero.
func (w *FindingRevealedWaiter) Wait(ctx context.Context, params *GetSensitiveDataOccurrencesInput, maxWaitDur time.Duration, optFns ...func(*FindingRevealedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for FindingRevealed waiter and returns
// the output of the successful operation. The maxWaitDur is the maximum wait
// duration the waiter will wait. The maxWaitDur is required and must be greater
// than zero.
func (w *FindingRevealedWaiter) WaitForOutput(ctx context.Context, params *GetSensitiveDataOccurrencesInput, maxWaitDur time.Duration, optFns ...func(*FindingRevealedWaiterOptions)) (*GetSensitiveDataOccurrencesOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.GetSensitiveDataOccurrences(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for FindingRevealed waiter")
}

func findingRevealedStateRetryable(ctx context.Context, input *GetSensitiveDataOccurrencesInput, output *GetSensitiveDataOccurrencesOutput, err error) (bool, error) {

	if err == nil {
		pathValue, err := jmespath.Search("status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "SUCCESS"
		value, ok := pathValue.(types.RevealRequestStatus)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected types.RevealRequestStatus value, got %T", pathValue)
		}

		if string(value) == expectedValue {
			return false, nil
		}
	}

	if err == nil {
		pathValue, err := jmespath.Search("status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "ERROR"
		value, ok := pathValue.(types.RevealRequestStatus)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected types.RevealRequestStatus value, got %T", pathValue)
		}

		if string(value) == expectedValue {
			return false, nil
		}
	}

	return true, nil
}

func newServiceMetadataMiddleware_opGetSensitiveDataOccurrences(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetSensitiveDataOccurrences",
	}
}
