// Code generated by smithy-go-codegen DO NOT EDIT.

package sfn

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/sfn/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Accepts the definition of a single state and executes it. You can test a state
// without creating a state machine or updating an existing state machine. Using
// this API, you can test the following:
//   - A state's input and output processing (https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-input-output-dataflow)
//     data flow
//   - An Amazon Web Services service integration (https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-services.html)
//     request and response
//   - An HTTP Task (https://docs.aws.amazon.com/step-functions/latest/dg/connect-third-party-apis.html)
//     request and response
//
// You can call this API on only one state at a time. The states that you can test
// include the following:
//   - All Task types (https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-task-state.html#task-types)
//     except Activity (https://docs.aws.amazon.com/step-functions/latest/dg/concepts-activities.html)
//   - Pass (https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-pass-state.html)
//   - Wait (https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-wait-state.html)
//   - Choice (https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-choice-state.html)
//   - Succeed (https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-succeed-state.html)
//   - Fail (https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-fail-state.html)
//
// The TestState API assumes an IAM role which must contain the required IAM
// permissions for the resources your state is accessing. For information about the
// permissions a state might need, see IAM permissions to test a state (https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-permissions)
// . The TestState API can run for up to five minutes. If the execution of a state
// exceeds this duration, it fails with the States.Timeout error. TestState
// doesn't support Activity tasks (https://docs.aws.amazon.com/step-functions/latest/dg/concepts-activities.html)
// , .sync or .waitForTaskToken service integration patterns (https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html)
// , Parallel (https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-parallel-state.html)
// , or Map (https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html)
// states.
func (c *Client) TestState(ctx context.Context, params *TestStateInput, optFns ...func(*Options)) (*TestStateOutput, error) {
	if params == nil {
		params = &TestStateInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "TestState", params, optFns, c.addOperationTestStateMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*TestStateOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type TestStateInput struct {

	// The Amazon States Language (https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html)
	// (ASL) definition of the state.
	//
	// This member is required.
	Definition *string

	// The Amazon Resource Name (ARN) of the execution role with the required IAM
	// permissions for the state.
	//
	// This member is required.
	RoleArn *string

	// A string that contains the JSON input data for the state.
	Input *string

	// Determines the values to return when a state is tested. You can specify one of
	// the following types:
	//   - INFO : Shows the final state output. By default, Step Functions sets
	//   inspectionLevel to INFO if you don't specify a level.
	//   - DEBUG : Shows the final state output along with the input and output data
	//   processing result.
	//   - TRACE : Shows the HTTP request and response for an HTTP Task. This level
	//   also shows the final state output along with the input and output data
	//   processing result.
	// Each of these levels also provide information about the status of the state
	// execution and the next state to transition to.
	InspectionLevel types.InspectionLevel

	// Specifies whether or not to include secret information in the test result. For
	// HTTP Tasks, a secret includes the data that an EventBridge connection adds to
	// modify the HTTP request headers, query parameters, and body. Step Functions
	// doesn't omit any information included in the state definition or the HTTP
	// response. If you set revealSecrets to true , you must make sure that the IAM
	// user that calls the TestState API has permission for the states:RevealSecrets
	// action. For an example of IAM policy that sets the states:RevealSecrets
	// permission, see IAM permissions to test a state (https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-permissions)
	// . Without this permission, Step Functions throws an access denied error. By
	// default, revealSecrets is set to false .
	RevealSecrets bool

	noSmithyDocumentSerde
}

type TestStateOutput struct {

	// A detailed explanation of the cause for the error when the execution of a state
	// fails.
	Cause *string

	// The error returned when the execution of a state fails.
	Error *string

	// Returns additional details about the state's execution, including its input and
	// output data processing flow, and HTTP request and response information. The
	// inspectionLevel request parameter specifies which details are returned.
	InspectionData *types.InspectionData

	// The name of the next state to transition to. If you haven't defined a next
	// state in your definition or if the execution of the state fails, this ﬁeld
	// doesn't contain a value.
	NextState *string

	// The JSON output data of the state. Length constraints apply to the payload
	// size, and are expressed as bytes in UTF-8 encoding.
	Output *string

	// The execution status of the state.
	Status types.TestExecutionStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationTestStateMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpTestState{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpTestState{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "TestState"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addEndpointPrefix_opTestStateMiddleware(stack); err != nil {
		return err
	}
	if err = addOpTestStateValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opTestState(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opTestStateMiddleware struct {
}

func (*endpointPrefix_opTestStateMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opTestStateMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "sync-" + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opTestStateMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opTestStateMiddleware{}, "ResolveEndpointV2", middleware.After)
}

func newServiceMetadataMiddleware_opTestState(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "TestState",
	}
}
