// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package s3outpostsiface provides an interface to enable mocking the Amazon S3 on Outposts service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package s3outpostsiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/s3outposts"
)

// S3OutpostsAPI provides an interface to enable mocking the
// s3outposts.S3Outposts service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon S3 on Outposts.
//	func myFunc(svc s3outpostsiface.S3OutpostsAPI) bool {
//	    // Make svc.CreateEndpoint request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := s3outposts.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockS3OutpostsClient struct {
//	    s3outpostsiface.S3OutpostsAPI
//	}
//	func (m *mockS3OutpostsClient) CreateEndpoint(input *s3outposts.CreateEndpointInput) (*s3outposts.CreateEndpointOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockS3OutpostsClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type S3OutpostsAPI interface {
	CreateEndpoint(*s3outposts.CreateEndpointInput) (*s3outposts.CreateEndpointOutput, error)
	CreateEndpointWithContext(aws.Context, *s3outposts.CreateEndpointInput, ...request.Option) (*s3outposts.CreateEndpointOutput, error)
	CreateEndpointRequest(*s3outposts.CreateEndpointInput) (*request.Request, *s3outposts.CreateEndpointOutput)

	DeleteEndpoint(*s3outposts.DeleteEndpointInput) (*s3outposts.DeleteEndpointOutput, error)
	DeleteEndpointWithContext(aws.Context, *s3outposts.DeleteEndpointInput, ...request.Option) (*s3outposts.DeleteEndpointOutput, error)
	DeleteEndpointRequest(*s3outposts.DeleteEndpointInput) (*request.Request, *s3outposts.DeleteEndpointOutput)

	ListEndpoints(*s3outposts.ListEndpointsInput) (*s3outposts.ListEndpointsOutput, error)
	ListEndpointsWithContext(aws.Context, *s3outposts.ListEndpointsInput, ...request.Option) (*s3outposts.ListEndpointsOutput, error)
	ListEndpointsRequest(*s3outposts.ListEndpointsInput) (*request.Request, *s3outposts.ListEndpointsOutput)

	ListEndpointsPages(*s3outposts.ListEndpointsInput, func(*s3outposts.ListEndpointsOutput, bool) bool) error
	ListEndpointsPagesWithContext(aws.Context, *s3outposts.ListEndpointsInput, func(*s3outposts.ListEndpointsOutput, bool) bool, ...request.Option) error

	ListSharedEndpoints(*s3outposts.ListSharedEndpointsInput) (*s3outposts.ListSharedEndpointsOutput, error)
	ListSharedEndpointsWithContext(aws.Context, *s3outposts.ListSharedEndpointsInput, ...request.Option) (*s3outposts.ListSharedEndpointsOutput, error)
	ListSharedEndpointsRequest(*s3outposts.ListSharedEndpointsInput) (*request.Request, *s3outposts.ListSharedEndpointsOutput)

	ListSharedEndpointsPages(*s3outposts.ListSharedEndpointsInput, func(*s3outposts.ListSharedEndpointsOutput, bool) bool) error
	ListSharedEndpointsPagesWithContext(aws.Context, *s3outposts.ListSharedEndpointsInput, func(*s3outposts.ListSharedEndpointsOutput, bool) bool, ...request.Option) error
}

var _ S3OutpostsAPI = (*s3outposts.S3Outposts)(nil)
