//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armkeyvault

type AccessPolicyUpdateKind string

const (
	AccessPolicyUpdateKindAdd     AccessPolicyUpdateKind = "add"
	AccessPolicyUpdateKindReplace AccessPolicyUpdateKind = "replace"
	AccessPolicyUpdateKindRemove  AccessPolicyUpdateKind = "remove"
)

// PossibleAccessPolicyUpdateKindValues returns the possible values for the AccessPolicyUpdateKind const type.
func PossibleAccessPolicyUpdateKindValues() []AccessPolicyUpdateKind {
	return []AccessPolicyUpdateKind{
		AccessPolicyUpdateKindAdd,
		AccessPolicyUpdateKindReplace,
		AccessPolicyUpdateKindRemove,
	}
}

type CertificatePermissions string

const (
	CertificatePermissionsAll            CertificatePermissions = "all"
	CertificatePermissionsBackup         CertificatePermissions = "backup"
	CertificatePermissionsCreate         CertificatePermissions = "create"
	CertificatePermissionsDelete         CertificatePermissions = "delete"
	CertificatePermissionsDeleteissuers  CertificatePermissions = "deleteissuers"
	CertificatePermissionsGet            CertificatePermissions = "get"
	CertificatePermissionsGetissuers     CertificatePermissions = "getissuers"
	CertificatePermissionsImport         CertificatePermissions = "import"
	CertificatePermissionsList           CertificatePermissions = "list"
	CertificatePermissionsListissuers    CertificatePermissions = "listissuers"
	CertificatePermissionsManagecontacts CertificatePermissions = "managecontacts"
	CertificatePermissionsManageissuers  CertificatePermissions = "manageissuers"
	CertificatePermissionsPurge          CertificatePermissions = "purge"
	CertificatePermissionsRecover        CertificatePermissions = "recover"
	CertificatePermissionsRestore        CertificatePermissions = "restore"
	CertificatePermissionsSetissuers     CertificatePermissions = "setissuers"
	CertificatePermissionsUpdate         CertificatePermissions = "update"
)

// PossibleCertificatePermissionsValues returns the possible values for the CertificatePermissions const type.
func PossibleCertificatePermissionsValues() []CertificatePermissions {
	return []CertificatePermissions{
		CertificatePermissionsAll,
		CertificatePermissionsBackup,
		CertificatePermissionsCreate,
		CertificatePermissionsDelete,
		CertificatePermissionsDeleteissuers,
		CertificatePermissionsGet,
		CertificatePermissionsGetissuers,
		CertificatePermissionsImport,
		CertificatePermissionsList,
		CertificatePermissionsListissuers,
		CertificatePermissionsManagecontacts,
		CertificatePermissionsManageissuers,
		CertificatePermissionsPurge,
		CertificatePermissionsRecover,
		CertificatePermissionsRestore,
		CertificatePermissionsSetissuers,
		CertificatePermissionsUpdate,
	}
}

// CreateMode - The vault's create mode to indicate whether the vault need to be recovered or not.
type CreateMode string

const (
	CreateModeRecover CreateMode = "recover"
	CreateModeDefault CreateMode = "default"
)

// PossibleCreateModeValues returns the possible values for the CreateMode const type.
func PossibleCreateModeValues() []CreateMode {
	return []CreateMode{
		CreateModeRecover,
		CreateModeDefault,
	}
}

type Enum10 string

const (
	Enum10ResourceTypeEqMicrosoftKeyVaultVaults Enum10 = "resourceType eq 'Microsoft.KeyVault/vaults'"
)

// PossibleEnum10Values returns the possible values for the Enum10 const type.
func PossibleEnum10Values() []Enum10 {
	return []Enum10{
		Enum10ResourceTypeEqMicrosoftKeyVaultVaults,
	}
}

type Enum11 string

const (
	Enum11TwoThousandFifteen1101 Enum11 = "2015-11-01"
)

// PossibleEnum11Values returns the possible values for the Enum11 const type.
func PossibleEnum11Values() []Enum11 {
	return []Enum11{
		Enum11TwoThousandFifteen1101,
	}
}

type KeyPermissions string

const (
	KeyPermissionsAll       KeyPermissions = "all"
	KeyPermissionsBackup    KeyPermissions = "backup"
	KeyPermissionsCreate    KeyPermissions = "create"
	KeyPermissionsDecrypt   KeyPermissions = "decrypt"
	KeyPermissionsDelete    KeyPermissions = "delete"
	KeyPermissionsEncrypt   KeyPermissions = "encrypt"
	KeyPermissionsGet       KeyPermissions = "get"
	KeyPermissionsImport    KeyPermissions = "import"
	KeyPermissionsList      KeyPermissions = "list"
	KeyPermissionsPurge     KeyPermissions = "purge"
	KeyPermissionsRecover   KeyPermissions = "recover"
	KeyPermissionsRestore   KeyPermissions = "restore"
	KeyPermissionsSign      KeyPermissions = "sign"
	KeyPermissionsUnwrapKey KeyPermissions = "unwrapKey"
	KeyPermissionsUpdate    KeyPermissions = "update"
	KeyPermissionsVerify    KeyPermissions = "verify"
	KeyPermissionsWrapKey   KeyPermissions = "wrapKey"
)

// PossibleKeyPermissionsValues returns the possible values for the KeyPermissions const type.
func PossibleKeyPermissionsValues() []KeyPermissions {
	return []KeyPermissions{
		KeyPermissionsAll,
		KeyPermissionsBackup,
		KeyPermissionsCreate,
		KeyPermissionsDecrypt,
		KeyPermissionsDelete,
		KeyPermissionsEncrypt,
		KeyPermissionsGet,
		KeyPermissionsImport,
		KeyPermissionsList,
		KeyPermissionsPurge,
		KeyPermissionsRecover,
		KeyPermissionsRestore,
		KeyPermissionsSign,
		KeyPermissionsUnwrapKey,
		KeyPermissionsUpdate,
		KeyPermissionsVerify,
		KeyPermissionsWrapKey,
	}
}

// NetworkRuleAction - The default action when no rule from ipRules and from virtualNetworkRules match. This is only used
// after the bypass property has been evaluated.
type NetworkRuleAction string

const (
	NetworkRuleActionAllow NetworkRuleAction = "Allow"
	NetworkRuleActionDeny  NetworkRuleAction = "Deny"
)

// PossibleNetworkRuleActionValues returns the possible values for the NetworkRuleAction const type.
func PossibleNetworkRuleActionValues() []NetworkRuleAction {
	return []NetworkRuleAction{
		NetworkRuleActionAllow,
		NetworkRuleActionDeny,
	}
}

// NetworkRuleBypassOptions - Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'. If not specified
// the default is 'AzureServices'.
type NetworkRuleBypassOptions string

const (
	NetworkRuleBypassOptionsAzureServices NetworkRuleBypassOptions = "AzureServices"
	NetworkRuleBypassOptionsNone          NetworkRuleBypassOptions = "None"
)

// PossibleNetworkRuleBypassOptionsValues returns the possible values for the NetworkRuleBypassOptions const type.
func PossibleNetworkRuleBypassOptionsValues() []NetworkRuleBypassOptions {
	return []NetworkRuleBypassOptions{
		NetworkRuleBypassOptionsAzureServices,
		NetworkRuleBypassOptionsNone,
	}
}

// PrivateEndpointConnectionProvisioningState - The current provisioning state.
type PrivateEndpointConnectionProvisioningState string

const (
	PrivateEndpointConnectionProvisioningStateCreating     PrivateEndpointConnectionProvisioningState = "Creating"
	PrivateEndpointConnectionProvisioningStateDeleting     PrivateEndpointConnectionProvisioningState = "Deleting"
	PrivateEndpointConnectionProvisioningStateDisconnected PrivateEndpointConnectionProvisioningState = "Disconnected"
	PrivateEndpointConnectionProvisioningStateFailed       PrivateEndpointConnectionProvisioningState = "Failed"
	PrivateEndpointConnectionProvisioningStateSucceeded    PrivateEndpointConnectionProvisioningState = "Succeeded"
	PrivateEndpointConnectionProvisioningStateUpdating     PrivateEndpointConnectionProvisioningState = "Updating"
)

// PossiblePrivateEndpointConnectionProvisioningStateValues returns the possible values for the PrivateEndpointConnectionProvisioningState const type.
func PossiblePrivateEndpointConnectionProvisioningStateValues() []PrivateEndpointConnectionProvisioningState {
	return []PrivateEndpointConnectionProvisioningState{
		PrivateEndpointConnectionProvisioningStateCreating,
		PrivateEndpointConnectionProvisioningStateDeleting,
		PrivateEndpointConnectionProvisioningStateDisconnected,
		PrivateEndpointConnectionProvisioningStateFailed,
		PrivateEndpointConnectionProvisioningStateSucceeded,
		PrivateEndpointConnectionProvisioningStateUpdating,
	}
}

// PrivateEndpointServiceConnectionStatus - The private endpoint connection status.
type PrivateEndpointServiceConnectionStatus string

const (
	PrivateEndpointServiceConnectionStatusApproved     PrivateEndpointServiceConnectionStatus = "Approved"
	PrivateEndpointServiceConnectionStatusDisconnected PrivateEndpointServiceConnectionStatus = "Disconnected"
	PrivateEndpointServiceConnectionStatusPending      PrivateEndpointServiceConnectionStatus = "Pending"
	PrivateEndpointServiceConnectionStatusRejected     PrivateEndpointServiceConnectionStatus = "Rejected"
)

// PossiblePrivateEndpointServiceConnectionStatusValues returns the possible values for the PrivateEndpointServiceConnectionStatus const type.
func PossiblePrivateEndpointServiceConnectionStatusValues() []PrivateEndpointServiceConnectionStatus {
	return []PrivateEndpointServiceConnectionStatus{
		PrivateEndpointServiceConnectionStatusApproved,
		PrivateEndpointServiceConnectionStatusDisconnected,
		PrivateEndpointServiceConnectionStatusPending,
		PrivateEndpointServiceConnectionStatusRejected,
	}
}

// Reason - The reason that a vault name could not be used. The Reason element is only returned if NameAvailable is false.
type Reason string

const (
	ReasonAccountNameInvalid Reason = "AccountNameInvalid"
	ReasonAlreadyExists      Reason = "AlreadyExists"
)

// PossibleReasonValues returns the possible values for the Reason const type.
func PossibleReasonValues() []Reason {
	return []Reason{
		ReasonAccountNameInvalid,
		ReasonAlreadyExists,
	}
}

// SKUFamily - SKU family name
type SKUFamily string

const (
	SKUFamilyA SKUFamily = "A"
)

// PossibleSKUFamilyValues returns the possible values for the SKUFamily const type.
func PossibleSKUFamilyValues() []SKUFamily {
	return []SKUFamily{
		SKUFamilyA,
	}
}

// SKUName - SKU name to specify whether the key vault is a standard vault or a premium vault.
type SKUName string

const (
	SKUNameStandard SKUName = "standard"
	SKUNamePremium  SKUName = "premium"
)

// PossibleSKUNameValues returns the possible values for the SKUName const type.
func PossibleSKUNameValues() []SKUName {
	return []SKUName{
		SKUNameStandard,
		SKUNamePremium,
	}
}

type SecretPermissions string

const (
	SecretPermissionsAll     SecretPermissions = "all"
	SecretPermissionsBackup  SecretPermissions = "backup"
	SecretPermissionsDelete  SecretPermissions = "delete"
	SecretPermissionsGet     SecretPermissions = "get"
	SecretPermissionsList    SecretPermissions = "list"
	SecretPermissionsPurge   SecretPermissions = "purge"
	SecretPermissionsRecover SecretPermissions = "recover"
	SecretPermissionsRestore SecretPermissions = "restore"
	SecretPermissionsSet     SecretPermissions = "set"
)

// PossibleSecretPermissionsValues returns the possible values for the SecretPermissions const type.
func PossibleSecretPermissionsValues() []SecretPermissions {
	return []SecretPermissions{
		SecretPermissionsAll,
		SecretPermissionsBackup,
		SecretPermissionsDelete,
		SecretPermissionsGet,
		SecretPermissionsList,
		SecretPermissionsPurge,
		SecretPermissionsRecover,
		SecretPermissionsRestore,
		SecretPermissionsSet,
	}
}

type StoragePermissions string

const (
	StoragePermissionsAll           StoragePermissions = "all"
	StoragePermissionsBackup        StoragePermissions = "backup"
	StoragePermissionsDelete        StoragePermissions = "delete"
	StoragePermissionsDeletesas     StoragePermissions = "deletesas"
	StoragePermissionsGet           StoragePermissions = "get"
	StoragePermissionsGetsas        StoragePermissions = "getsas"
	StoragePermissionsList          StoragePermissions = "list"
	StoragePermissionsListsas       StoragePermissions = "listsas"
	StoragePermissionsPurge         StoragePermissions = "purge"
	StoragePermissionsRecover       StoragePermissions = "recover"
	StoragePermissionsRegeneratekey StoragePermissions = "regeneratekey"
	StoragePermissionsRestore       StoragePermissions = "restore"
	StoragePermissionsSet           StoragePermissions = "set"
	StoragePermissionsSetsas        StoragePermissions = "setsas"
	StoragePermissionsUpdate        StoragePermissions = "update"
)

// PossibleStoragePermissionsValues returns the possible values for the StoragePermissions const type.
func PossibleStoragePermissionsValues() []StoragePermissions {
	return []StoragePermissions{
		StoragePermissionsAll,
		StoragePermissionsBackup,
		StoragePermissionsDelete,
		StoragePermissionsDeletesas,
		StoragePermissionsGet,
		StoragePermissionsGetsas,
		StoragePermissionsList,
		StoragePermissionsListsas,
		StoragePermissionsPurge,
		StoragePermissionsRecover,
		StoragePermissionsRegeneratekey,
		StoragePermissionsRestore,
		StoragePermissionsSet,
		StoragePermissionsSetsas,
		StoragePermissionsUpdate,
	}
}

// VaultProvisioningState - Provisioning state of the vault.
type VaultProvisioningState string

const (
	VaultProvisioningStateRegisteringDNS VaultProvisioningState = "RegisteringDns"
	VaultProvisioningStateSucceeded      VaultProvisioningState = "Succeeded"
)

// PossibleVaultProvisioningStateValues returns the possible values for the VaultProvisioningState const type.
func PossibleVaultProvisioningStateValues() []VaultProvisioningState {
	return []VaultProvisioningState{
		VaultProvisioningStateRegisteringDNS,
		VaultProvisioningStateSucceeded,
	}
}
