//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armappservice

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type APIDefinitionInfo.
func (a APIDefinitionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "url", a.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIDefinitionInfo.
func (a *APIDefinitionInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "url":
			err = unpopulate(val, "URL", &a.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIKVReference.
func (a APIKVReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "kind", a.Kind)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIKVReference.
func (a *APIKVReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIKVReferenceCollection.
func (a APIKVReferenceCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIKVReferenceCollection.
func (a *APIKVReferenceCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIKVReferenceProperties.
func (a APIKVReferenceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activeVersion", a.ActiveVersion)
	populate(objectMap, "details", a.Details)
	populate(objectMap, "identityType", a.IdentityType)
	populate(objectMap, "reference", a.Reference)
	populate(objectMap, "secretName", a.SecretName)
	populate(objectMap, "secretVersion", a.SecretVersion)
	objectMap["source"] = "KeyVault"
	populate(objectMap, "status", a.Status)
	populate(objectMap, "vaultName", a.VaultName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIKVReferenceProperties.
func (a *APIKVReferenceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activeVersion":
			err = unpopulate(val, "ActiveVersion", &a.ActiveVersion)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &a.Details)
			delete(rawMsg, key)
		case "identityType":
			err = unpopulate(val, "IdentityType", &a.IdentityType)
			delete(rawMsg, key)
		case "reference":
			err = unpopulate(val, "Reference", &a.Reference)
			delete(rawMsg, key)
		case "secretName":
			err = unpopulate(val, "SecretName", &a.SecretName)
			delete(rawMsg, key)
		case "secretVersion":
			err = unpopulate(val, "SecretVersion", &a.SecretVersion)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &a.Source)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "vaultName":
			err = unpopulate(val, "VaultName", &a.VaultName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIManagementConfig.
func (a APIManagementConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIManagementConfig.
func (a *APIManagementConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AbnormalTimePeriod.
func (a AbnormalTimePeriod) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "endTime", a.EndTime)
	populate(objectMap, "events", a.Events)
	populate(objectMap, "solutions", a.Solutions)
	populateDateTimeRFC3339(objectMap, "startTime", a.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AbnormalTimePeriod.
func (a *AbnormalTimePeriod) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &a.EndTime)
			delete(rawMsg, key)
		case "events":
			err = unpopulate(val, "Events", &a.Events)
			delete(rawMsg, key)
		case "solutions":
			err = unpopulate(val, "Solutions", &a.Solutions)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &a.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Address.
func (a Address) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address1", a.Address1)
	populate(objectMap, "address2", a.Address2)
	populate(objectMap, "city", a.City)
	populate(objectMap, "country", a.Country)
	populate(objectMap, "postalCode", a.PostalCode)
	populate(objectMap, "state", a.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Address.
func (a *Address) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address1":
			err = unpopulate(val, "Address1", &a.Address1)
			delete(rawMsg, key)
		case "address2":
			err = unpopulate(val, "Address2", &a.Address2)
			delete(rawMsg, key)
		case "city":
			err = unpopulate(val, "City", &a.City)
			delete(rawMsg, key)
		case "country":
			err = unpopulate(val, "Country", &a.Country)
			delete(rawMsg, key)
		case "postalCode":
			err = unpopulate(val, "PostalCode", &a.PostalCode)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &a.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AddressResponse.
func (a AddressResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "kind", a.Kind)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddressResponse.
func (a *AddressResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AddressResponseProperties.
func (a AddressResponseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "internalIpAddress", a.InternalIPAddress)
	populate(objectMap, "outboundIpAddresses", a.OutboundIPAddresses)
	populate(objectMap, "serviceIpAddress", a.ServiceIPAddress)
	populate(objectMap, "vipMappings", a.VipMappings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddressResponseProperties.
func (a *AddressResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "internalIpAddress":
			err = unpopulate(val, "InternalIPAddress", &a.InternalIPAddress)
			delete(rawMsg, key)
		case "outboundIpAddresses":
			err = unpopulate(val, "OutboundIPAddresses", &a.OutboundIPAddresses)
			delete(rawMsg, key)
		case "serviceIpAddress":
			err = unpopulate(val, "ServiceIPAddress", &a.ServiceIPAddress)
			delete(rawMsg, key)
		case "vipMappings":
			err = unpopulate(val, "VipMappings", &a.VipMappings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AllowedAudiencesValidation.
func (a AllowedAudiencesValidation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedAudiences", a.AllowedAudiences)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AllowedAudiencesValidation.
func (a *AllowedAudiencesValidation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedAudiences":
			err = unpopulate(val, "AllowedAudiences", &a.AllowedAudiences)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AllowedPrincipals.
func (a AllowedPrincipals) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groups", a.Groups)
	populate(objectMap, "identities", a.Identities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AllowedPrincipals.
func (a *AllowedPrincipals) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groups":
			err = unpopulate(val, "Groups", &a.Groups)
			delete(rawMsg, key)
		case "identities":
			err = unpopulate(val, "Identities", &a.Identities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AnalysisData.
func (a AnalysisData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "data", a.Data)
	populate(objectMap, "detectorDefinition", a.DetectorDefinition)
	populate(objectMap, "detectorMetaData", a.DetectorMetaData)
	populate(objectMap, "metrics", a.Metrics)
	populate(objectMap, "source", a.Source)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AnalysisData.
func (a *AnalysisData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "data":
			err = unpopulate(val, "Data", &a.Data)
			delete(rawMsg, key)
		case "detectorDefinition":
			err = unpopulate(val, "DetectorDefinition", &a.DetectorDefinition)
			delete(rawMsg, key)
		case "detectorMetaData":
			err = unpopulate(val, "DetectorMetaData", &a.DetectorMetaData)
			delete(rawMsg, key)
		case "metrics":
			err = unpopulate(val, "Metrics", &a.Metrics)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &a.Source)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AnalysisDefinition.
func (a AnalysisDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "kind", a.Kind)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AnalysisDefinition.
func (a *AnalysisDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AnalysisDefinitionProperties.
func (a AnalysisDefinitionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AnalysisDefinitionProperties.
func (a *AnalysisDefinitionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppCertificate.
func (a AppCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "kind", a.Kind)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppCertificate.
func (a *AppCertificate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppCertificateCollection.
func (a AppCertificateCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppCertificateCollection.
func (a *AppCertificateCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppCertificatePatchResource.
func (a AppCertificatePatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "kind", a.Kind)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppCertificatePatchResource.
func (a *AppCertificatePatchResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppCertificatePatchResourceProperties.
func (a AppCertificatePatchResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "canonicalName", a.CanonicalName)
	populateByteArray(objectMap, "cerBlob", a.CerBlob, runtime.Base64StdFormat)
	populate(objectMap, "domainValidationMethod", a.DomainValidationMethod)
	populateDateTimeRFC3339(objectMap, "expirationDate", a.ExpirationDate)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "hostNames", a.HostNames)
	populate(objectMap, "hostingEnvironmentProfile", a.HostingEnvironmentProfile)
	populateDateTimeRFC3339(objectMap, "issueDate", a.IssueDate)
	populate(objectMap, "issuer", a.Issuer)
	populate(objectMap, "keyVaultId", a.KeyVaultID)
	populate(objectMap, "keyVaultSecretName", a.KeyVaultSecretName)
	populate(objectMap, "keyVaultSecretStatus", a.KeyVaultSecretStatus)
	populate(objectMap, "password", a.Password)
	populateByteArray(objectMap, "pfxBlob", a.PfxBlob, runtime.Base64StdFormat)
	populate(objectMap, "publicKeyHash", a.PublicKeyHash)
	populate(objectMap, "selfLink", a.SelfLink)
	populate(objectMap, "serverFarmId", a.ServerFarmID)
	populate(objectMap, "siteName", a.SiteName)
	populate(objectMap, "subjectName", a.SubjectName)
	populate(objectMap, "thumbprint", a.Thumbprint)
	populate(objectMap, "valid", a.Valid)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppCertificatePatchResourceProperties.
func (a *AppCertificatePatchResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "canonicalName":
			err = unpopulate(val, "CanonicalName", &a.CanonicalName)
			delete(rawMsg, key)
		case "cerBlob":
			err = runtime.DecodeByteArray(string(val), &a.CerBlob, runtime.Base64StdFormat)
			delete(rawMsg, key)
		case "domainValidationMethod":
			err = unpopulate(val, "DomainValidationMethod", &a.DomainValidationMethod)
			delete(rawMsg, key)
		case "expirationDate":
			err = unpopulateDateTimeRFC3339(val, "ExpirationDate", &a.ExpirationDate)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "hostNames":
			err = unpopulate(val, "HostNames", &a.HostNames)
			delete(rawMsg, key)
		case "hostingEnvironmentProfile":
			err = unpopulate(val, "HostingEnvironmentProfile", &a.HostingEnvironmentProfile)
			delete(rawMsg, key)
		case "issueDate":
			err = unpopulateDateTimeRFC3339(val, "IssueDate", &a.IssueDate)
			delete(rawMsg, key)
		case "issuer":
			err = unpopulate(val, "Issuer", &a.Issuer)
			delete(rawMsg, key)
		case "keyVaultId":
			err = unpopulate(val, "KeyVaultID", &a.KeyVaultID)
			delete(rawMsg, key)
		case "keyVaultSecretName":
			err = unpopulate(val, "KeyVaultSecretName", &a.KeyVaultSecretName)
			delete(rawMsg, key)
		case "keyVaultSecretStatus":
			err = unpopulate(val, "KeyVaultSecretStatus", &a.KeyVaultSecretStatus)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &a.Password)
			delete(rawMsg, key)
		case "pfxBlob":
			err = runtime.DecodeByteArray(string(val), &a.PfxBlob, runtime.Base64StdFormat)
			delete(rawMsg, key)
		case "publicKeyHash":
			err = unpopulate(val, "PublicKeyHash", &a.PublicKeyHash)
			delete(rawMsg, key)
		case "selfLink":
			err = unpopulate(val, "SelfLink", &a.SelfLink)
			delete(rawMsg, key)
		case "serverFarmId":
			err = unpopulate(val, "ServerFarmID", &a.ServerFarmID)
			delete(rawMsg, key)
		case "siteName":
			err = unpopulate(val, "SiteName", &a.SiteName)
			delete(rawMsg, key)
		case "subjectName":
			err = unpopulate(val, "SubjectName", &a.SubjectName)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &a.Thumbprint)
			delete(rawMsg, key)
		case "valid":
			err = unpopulate(val, "Valid", &a.Valid)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppCertificateProperties.
func (a AppCertificateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "canonicalName", a.CanonicalName)
	populateByteArray(objectMap, "cerBlob", a.CerBlob, runtime.Base64StdFormat)
	populate(objectMap, "domainValidationMethod", a.DomainValidationMethod)
	populateDateTimeRFC3339(objectMap, "expirationDate", a.ExpirationDate)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "hostNames", a.HostNames)
	populate(objectMap, "hostingEnvironmentProfile", a.HostingEnvironmentProfile)
	populateDateTimeRFC3339(objectMap, "issueDate", a.IssueDate)
	populate(objectMap, "issuer", a.Issuer)
	populate(objectMap, "keyVaultId", a.KeyVaultID)
	populate(objectMap, "keyVaultSecretName", a.KeyVaultSecretName)
	populate(objectMap, "keyVaultSecretStatus", a.KeyVaultSecretStatus)
	populate(objectMap, "password", a.Password)
	populateByteArray(objectMap, "pfxBlob", a.PfxBlob, runtime.Base64StdFormat)
	populate(objectMap, "publicKeyHash", a.PublicKeyHash)
	populate(objectMap, "selfLink", a.SelfLink)
	populate(objectMap, "serverFarmId", a.ServerFarmID)
	populate(objectMap, "siteName", a.SiteName)
	populate(objectMap, "subjectName", a.SubjectName)
	populate(objectMap, "thumbprint", a.Thumbprint)
	populate(objectMap, "valid", a.Valid)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppCertificateProperties.
func (a *AppCertificateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "canonicalName":
			err = unpopulate(val, "CanonicalName", &a.CanonicalName)
			delete(rawMsg, key)
		case "cerBlob":
			err = runtime.DecodeByteArray(string(val), &a.CerBlob, runtime.Base64StdFormat)
			delete(rawMsg, key)
		case "domainValidationMethod":
			err = unpopulate(val, "DomainValidationMethod", &a.DomainValidationMethod)
			delete(rawMsg, key)
		case "expirationDate":
			err = unpopulateDateTimeRFC3339(val, "ExpirationDate", &a.ExpirationDate)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "hostNames":
			err = unpopulate(val, "HostNames", &a.HostNames)
			delete(rawMsg, key)
		case "hostingEnvironmentProfile":
			err = unpopulate(val, "HostingEnvironmentProfile", &a.HostingEnvironmentProfile)
			delete(rawMsg, key)
		case "issueDate":
			err = unpopulateDateTimeRFC3339(val, "IssueDate", &a.IssueDate)
			delete(rawMsg, key)
		case "issuer":
			err = unpopulate(val, "Issuer", &a.Issuer)
			delete(rawMsg, key)
		case "keyVaultId":
			err = unpopulate(val, "KeyVaultID", &a.KeyVaultID)
			delete(rawMsg, key)
		case "keyVaultSecretName":
			err = unpopulate(val, "KeyVaultSecretName", &a.KeyVaultSecretName)
			delete(rawMsg, key)
		case "keyVaultSecretStatus":
			err = unpopulate(val, "KeyVaultSecretStatus", &a.KeyVaultSecretStatus)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &a.Password)
			delete(rawMsg, key)
		case "pfxBlob":
			err = runtime.DecodeByteArray(string(val), &a.PfxBlob, runtime.Base64StdFormat)
			delete(rawMsg, key)
		case "publicKeyHash":
			err = unpopulate(val, "PublicKeyHash", &a.PublicKeyHash)
			delete(rawMsg, key)
		case "selfLink":
			err = unpopulate(val, "SelfLink", &a.SelfLink)
			delete(rawMsg, key)
		case "serverFarmId":
			err = unpopulate(val, "ServerFarmID", &a.ServerFarmID)
			delete(rawMsg, key)
		case "siteName":
			err = unpopulate(val, "SiteName", &a.SiteName)
			delete(rawMsg, key)
		case "subjectName":
			err = unpopulate(val, "SubjectName", &a.SubjectName)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &a.Thumbprint)
			delete(rawMsg, key)
		case "valid":
			err = unpopulate(val, "Valid", &a.Valid)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppInsightsWebAppStackSettings.
func (a AppInsightsWebAppStackSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isDefaultOff", a.IsDefaultOff)
	populate(objectMap, "isSupported", a.IsSupported)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppInsightsWebAppStackSettings.
func (a *AppInsightsWebAppStackSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isDefaultOff":
			err = unpopulate(val, "IsDefaultOff", &a.IsDefaultOff)
			delete(rawMsg, key)
		case "isSupported":
			err = unpopulate(val, "IsSupported", &a.IsSupported)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppLogsConfiguration.
func (a AppLogsConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destination", a.Destination)
	populate(objectMap, "logAnalyticsConfiguration", a.LogAnalyticsConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppLogsConfiguration.
func (a *AppLogsConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destination":
			err = unpopulate(val, "Destination", &a.Destination)
			delete(rawMsg, key)
		case "logAnalyticsConfiguration":
			err = unpopulate(val, "LogAnalyticsConfiguration", &a.LogAnalyticsConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppRegistration.
func (a AppRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appId", a.AppID)
	populate(objectMap, "appSecretSettingName", a.AppSecretSettingName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppRegistration.
func (a *AppRegistration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appId":
			err = unpopulate(val, "AppID", &a.AppID)
			delete(rawMsg, key)
		case "appSecretSettingName":
			err = unpopulate(val, "AppSecretSettingName", &a.AppSecretSettingName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Apple.
func (a Apple) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", a.Enabled)
	populate(objectMap, "login", a.Login)
	populate(objectMap, "registration", a.Registration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Apple.
func (a *Apple) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		case "login":
			err = unpopulate(val, "Login", &a.Login)
			delete(rawMsg, key)
		case "registration":
			err = unpopulate(val, "Registration", &a.Registration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppleRegistration.
func (a AppleRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", a.ClientID)
	populate(objectMap, "clientSecretSettingName", a.ClientSecretSettingName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppleRegistration.
func (a *AppleRegistration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &a.ClientID)
			delete(rawMsg, key)
		case "clientSecretSettingName":
			err = unpopulate(val, "ClientSecretSettingName", &a.ClientSecretSettingName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationLogsConfig.
func (a ApplicationLogsConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureBlobStorage", a.AzureBlobStorage)
	populate(objectMap, "azureTableStorage", a.AzureTableStorage)
	populate(objectMap, "fileSystem", a.FileSystem)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationLogsConfig.
func (a *ApplicationLogsConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureBlobStorage":
			err = unpopulate(val, "AzureBlobStorage", &a.AzureBlobStorage)
			delete(rawMsg, key)
		case "azureTableStorage":
			err = unpopulate(val, "AzureTableStorage", &a.AzureTableStorage)
			delete(rawMsg, key)
		case "fileSystem":
			err = unpopulate(val, "FileSystem", &a.FileSystem)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationStack.
func (a ApplicationStack) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependency", a.Dependency)
	populate(objectMap, "display", a.Display)
	populate(objectMap, "frameworks", a.Frameworks)
	populate(objectMap, "isDeprecated", a.IsDeprecated)
	populate(objectMap, "majorVersions", a.MajorVersions)
	populate(objectMap, "name", a.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationStack.
func (a *ApplicationStack) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependency":
			err = unpopulate(val, "Dependency", &a.Dependency)
			delete(rawMsg, key)
		case "display":
			err = unpopulate(val, "Display", &a.Display)
			delete(rawMsg, key)
		case "frameworks":
			err = unpopulate(val, "Frameworks", &a.Frameworks)
			delete(rawMsg, key)
		case "isDeprecated":
			err = unpopulate(val, "IsDeprecated", &a.IsDeprecated)
			delete(rawMsg, key)
		case "majorVersions":
			err = unpopulate(val, "MajorVersions", &a.MajorVersions)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationStackCollection.
func (a ApplicationStackCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationStackCollection.
func (a *ApplicationStackCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationStackResource.
func (a ApplicationStackResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "kind", a.Kind)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationStackResource.
func (a *ApplicationStackResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArcConfiguration.
func (a ArcConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactStorageAccessMode", a.ArtifactStorageAccessMode)
	populate(objectMap, "artifactStorageClassName", a.ArtifactStorageClassName)
	populate(objectMap, "artifactStorageMountPath", a.ArtifactStorageMountPath)
	populate(objectMap, "artifactStorageNodeName", a.ArtifactStorageNodeName)
	populate(objectMap, "artifactsStorageType", a.ArtifactsStorageType)
	populate(objectMap, "frontEndServiceConfiguration", a.FrontEndServiceConfiguration)
	populate(objectMap, "kubeConfig", a.KubeConfig)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArcConfiguration.
func (a *ArcConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactStorageAccessMode":
			err = unpopulate(val, "ArtifactStorageAccessMode", &a.ArtifactStorageAccessMode)
			delete(rawMsg, key)
		case "artifactStorageClassName":
			err = unpopulate(val, "ArtifactStorageClassName", &a.ArtifactStorageClassName)
			delete(rawMsg, key)
		case "artifactStorageMountPath":
			err = unpopulate(val, "ArtifactStorageMountPath", &a.ArtifactStorageMountPath)
			delete(rawMsg, key)
		case "artifactStorageNodeName":
			err = unpopulate(val, "ArtifactStorageNodeName", &a.ArtifactStorageNodeName)
			delete(rawMsg, key)
		case "artifactsStorageType":
			err = unpopulate(val, "ArtifactsStorageType", &a.ArtifactsStorageType)
			delete(rawMsg, key)
		case "frontEndServiceConfiguration":
			err = unpopulate(val, "FrontEndServiceConfiguration", &a.FrontEndServiceConfiguration)
			delete(rawMsg, key)
		case "kubeConfig":
			err = unpopulate(val, "KubeConfig", &a.KubeConfig)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArmIDWrapper.
func (a ArmIDWrapper) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArmIDWrapper.
func (a *ArmIDWrapper) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArmPlan.
func (a ArmPlan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "product", a.Product)
	populate(objectMap, "promotionCode", a.PromotionCode)
	populate(objectMap, "publisher", a.Publisher)
	populate(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArmPlan.
func (a *ArmPlan) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "product":
			err = unpopulate(val, "Product", &a.Product)
			delete(rawMsg, key)
		case "promotionCode":
			err = unpopulate(val, "PromotionCode", &a.PromotionCode)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &a.Publisher)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AseRegion.
func (a AseRegion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "kind", a.Kind)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AseRegion.
func (a *AseRegion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AseRegionCollection.
func (a AseRegionCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AseRegionCollection.
func (a *AseRegionCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AseRegionProperties.
func (a AseRegionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availableOS", a.AvailableOS)
	populate(objectMap, "availableSku", a.AvailableSKU)
	populate(objectMap, "dedicatedHost", a.DedicatedHost)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "standard", a.Standard)
	populate(objectMap, "zoneRedundant", a.ZoneRedundant)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AseRegionProperties.
func (a *AseRegionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availableOS":
			err = unpopulate(val, "AvailableOS", &a.AvailableOS)
			delete(rawMsg, key)
		case "availableSku":
			err = unpopulate(val, "AvailableSKU", &a.AvailableSKU)
			delete(rawMsg, key)
		case "dedicatedHost":
			err = unpopulate(val, "DedicatedHost", &a.DedicatedHost)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "standard":
			err = unpopulate(val, "Standard", &a.Standard)
			delete(rawMsg, key)
		case "zoneRedundant":
			err = unpopulate(val, "ZoneRedundant", &a.ZoneRedundant)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AseV3NetworkingConfiguration.
func (a AseV3NetworkingConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "kind", a.Kind)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AseV3NetworkingConfiguration.
func (a *AseV3NetworkingConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AseV3NetworkingConfigurationProperties.
func (a AseV3NetworkingConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowNewPrivateEndpointConnections", a.AllowNewPrivateEndpointConnections)
	populate(objectMap, "externalInboundIpAddresses", a.ExternalInboundIPAddresses)
	populate(objectMap, "ftpEnabled", a.FtpEnabled)
	populate(objectMap, "inboundIpAddressOverride", a.InboundIPAddressOverride)
	populate(objectMap, "internalInboundIpAddresses", a.InternalInboundIPAddresses)
	populate(objectMap, "linuxOutboundIpAddresses", a.LinuxOutboundIPAddresses)
	populate(objectMap, "remoteDebugEnabled", a.RemoteDebugEnabled)
	populate(objectMap, "windowsOutboundIpAddresses", a.WindowsOutboundIPAddresses)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AseV3NetworkingConfigurationProperties.
func (a *AseV3NetworkingConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowNewPrivateEndpointConnections":
			err = unpopulate(val, "AllowNewPrivateEndpointConnections", &a.AllowNewPrivateEndpointConnections)
			delete(rawMsg, key)
		case "externalInboundIpAddresses":
			err = unpopulate(val, "ExternalInboundIPAddresses", &a.ExternalInboundIPAddresses)
			delete(rawMsg, key)
		case "ftpEnabled":
			err = unpopulate(val, "FtpEnabled", &a.FtpEnabled)
			delete(rawMsg, key)
		case "inboundIpAddressOverride":
			err = unpopulate(val, "InboundIPAddressOverride", &a.InboundIPAddressOverride)
			delete(rawMsg, key)
		case "internalInboundIpAddresses":
			err = unpopulate(val, "InternalInboundIPAddresses", &a.InternalInboundIPAddresses)
			delete(rawMsg, key)
		case "linuxOutboundIpAddresses":
			err = unpopulate(val, "LinuxOutboundIPAddresses", &a.LinuxOutboundIPAddresses)
			delete(rawMsg, key)
		case "remoteDebugEnabled":
			err = unpopulate(val, "RemoteDebugEnabled", &a.RemoteDebugEnabled)
			delete(rawMsg, key)
		case "windowsOutboundIpAddresses":
			err = unpopulate(val, "WindowsOutboundIPAddresses", &a.WindowsOutboundIPAddresses)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthPlatform.
func (a AuthPlatform) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configFilePath", a.ConfigFilePath)
	populate(objectMap, "enabled", a.Enabled)
	populate(objectMap, "runtimeVersion", a.RuntimeVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthPlatform.
func (a *AuthPlatform) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configFilePath":
			err = unpopulate(val, "ConfigFilePath", &a.ConfigFilePath)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		case "runtimeVersion":
			err = unpopulate(val, "RuntimeVersion", &a.RuntimeVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoHealActions.
func (a AutoHealActions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionType", a.ActionType)
	populate(objectMap, "customAction", a.CustomAction)
	populate(objectMap, "minProcessExecutionTime", a.MinProcessExecutionTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoHealActions.
func (a *AutoHealActions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &a.ActionType)
			delete(rawMsg, key)
		case "customAction":
			err = unpopulate(val, "CustomAction", &a.CustomAction)
			delete(rawMsg, key)
		case "minProcessExecutionTime":
			err = unpopulate(val, "MinProcessExecutionTime", &a.MinProcessExecutionTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoHealCustomAction.
func (a AutoHealCustomAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "exe", a.Exe)
	populate(objectMap, "parameters", a.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoHealCustomAction.
func (a *AutoHealCustomAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exe":
			err = unpopulate(val, "Exe", &a.Exe)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoHealRules.
func (a AutoHealRules) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actions", a.Actions)
	populate(objectMap, "triggers", a.Triggers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoHealRules.
func (a *AutoHealRules) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, "Actions", &a.Actions)
			delete(rawMsg, key)
		case "triggers":
			err = unpopulate(val, "Triggers", &a.Triggers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoHealTriggers.
func (a AutoHealTriggers) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateBytesInKB", a.PrivateBytesInKB)
	populate(objectMap, "requests", a.Requests)
	populate(objectMap, "slowRequests", a.SlowRequests)
	populate(objectMap, "slowRequestsWithPath", a.SlowRequestsWithPath)
	populate(objectMap, "statusCodes", a.StatusCodes)
	populate(objectMap, "statusCodesRange", a.StatusCodesRange)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoHealTriggers.
func (a *AutoHealTriggers) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateBytesInKB":
			err = unpopulate(val, "PrivateBytesInKB", &a.PrivateBytesInKB)
			delete(rawMsg, key)
		case "requests":
			err = unpopulate(val, "Requests", &a.Requests)
			delete(rawMsg, key)
		case "slowRequests":
			err = unpopulate(val, "SlowRequests", &a.SlowRequests)
			delete(rawMsg, key)
		case "slowRequestsWithPath":
			err = unpopulate(val, "SlowRequestsWithPath", &a.SlowRequestsWithPath)
			delete(rawMsg, key)
		case "statusCodes":
			err = unpopulate(val, "StatusCodes", &a.StatusCodes)
			delete(rawMsg, key)
		case "statusCodesRange":
			err = unpopulate(val, "StatusCodesRange", &a.StatusCodesRange)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureActiveDirectory.
func (a AzureActiveDirectory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", a.Enabled)
	populate(objectMap, "isAutoProvisioned", a.IsAutoProvisioned)
	populate(objectMap, "login", a.Login)
	populate(objectMap, "registration", a.Registration)
	populate(objectMap, "validation", a.Validation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureActiveDirectory.
func (a *AzureActiveDirectory) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		case "isAutoProvisioned":
			err = unpopulate(val, "IsAutoProvisioned", &a.IsAutoProvisioned)
			delete(rawMsg, key)
		case "login":
			err = unpopulate(val, "Login", &a.Login)
			delete(rawMsg, key)
		case "registration":
			err = unpopulate(val, "Registration", &a.Registration)
			delete(rawMsg, key)
		case "validation":
			err = unpopulate(val, "Validation", &a.Validation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureActiveDirectoryLogin.
func (a AzureActiveDirectoryLogin) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "disableWWWAuthenticate", a.DisableWWWAuthenticate)
	populate(objectMap, "loginParameters", a.LoginParameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureActiveDirectoryLogin.
func (a *AzureActiveDirectoryLogin) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableWWWAuthenticate":
			err = unpopulate(val, "DisableWWWAuthenticate", &a.DisableWWWAuthenticate)
			delete(rawMsg, key)
		case "loginParameters":
			err = unpopulate(val, "LoginParameters", &a.LoginParameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureActiveDirectoryRegistration.
func (a AzureActiveDirectoryRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", a.ClientID)
	populate(objectMap, "clientSecretCertificateIssuer", a.ClientSecretCertificateIssuer)
	populate(objectMap, "clientSecretCertificateSubjectAlternativeName", a.ClientSecretCertificateSubjectAlternativeName)
	populate(objectMap, "clientSecretCertificateThumbprint", a.ClientSecretCertificateThumbprint)
	populate(objectMap, "clientSecretSettingName", a.ClientSecretSettingName)
	populate(objectMap, "openIdIssuer", a.OpenIDIssuer)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureActiveDirectoryRegistration.
func (a *AzureActiveDirectoryRegistration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &a.ClientID)
			delete(rawMsg, key)
		case "clientSecretCertificateIssuer":
			err = unpopulate(val, "ClientSecretCertificateIssuer", &a.ClientSecretCertificateIssuer)
			delete(rawMsg, key)
		case "clientSecretCertificateSubjectAlternativeName":
			err = unpopulate(val, "ClientSecretCertificateSubjectAlternativeName", &a.ClientSecretCertificateSubjectAlternativeName)
			delete(rawMsg, key)
		case "clientSecretCertificateThumbprint":
			err = unpopulate(val, "ClientSecretCertificateThumbprint", &a.ClientSecretCertificateThumbprint)
			delete(rawMsg, key)
		case "clientSecretSettingName":
			err = unpopulate(val, "ClientSecretSettingName", &a.ClientSecretSettingName)
			delete(rawMsg, key)
		case "openIdIssuer":
			err = unpopulate(val, "OpenIDIssuer", &a.OpenIDIssuer)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureActiveDirectoryValidation.
func (a AzureActiveDirectoryValidation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedAudiences", a.AllowedAudiences)
	populate(objectMap, "defaultAuthorizationPolicy", a.DefaultAuthorizationPolicy)
	populate(objectMap, "jwtClaimChecks", a.JwtClaimChecks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureActiveDirectoryValidation.
func (a *AzureActiveDirectoryValidation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedAudiences":
			err = unpopulate(val, "AllowedAudiences", &a.AllowedAudiences)
			delete(rawMsg, key)
		case "defaultAuthorizationPolicy":
			err = unpopulate(val, "DefaultAuthorizationPolicy", &a.DefaultAuthorizationPolicy)
			delete(rawMsg, key)
		case "jwtClaimChecks":
			err = unpopulate(val, "JwtClaimChecks", &a.JwtClaimChecks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBlobStorageApplicationLogsConfig.
func (a AzureBlobStorageApplicationLogsConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "level", a.Level)
	populate(objectMap, "retentionInDays", a.RetentionInDays)
	populate(objectMap, "sasUrl", a.SasURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBlobStorageApplicationLogsConfig.
func (a *AzureBlobStorageApplicationLogsConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "level":
			err = unpopulate(val, "Level", &a.Level)
			delete(rawMsg, key)
		case "retentionInDays":
			err = unpopulate(val, "RetentionInDays", &a.RetentionInDays)
			delete(rawMsg, key)
		case "sasUrl":
			err = unpopulate(val, "SasURL", &a.SasURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBlobStorageHTTPLogsConfig.
func (a AzureBlobStorageHTTPLogsConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", a.Enabled)
	populate(objectMap, "retentionInDays", a.RetentionInDays)
	populate(objectMap, "sasUrl", a.SasURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBlobStorageHTTPLogsConfig.
func (a *AzureBlobStorageHTTPLogsConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		case "retentionInDays":
			err = unpopulate(val, "RetentionInDays", &a.RetentionInDays)
			delete(rawMsg, key)
		case "sasUrl":
			err = unpopulate(val, "SasURL", &a.SasURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureResourceErrorInfo.
func (a AzureResourceErrorInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", a.Code)
	populate(objectMap, "details", a.Details)
	populate(objectMap, "message", a.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureResourceErrorInfo.
func (a *AzureResourceErrorInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &a.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &a.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &a.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureStaticWebApps.
func (a AzureStaticWebApps) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", a.Enabled)
	populate(objectMap, "registration", a.Registration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureStaticWebApps.
func (a *AzureStaticWebApps) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		case "registration":
			err = unpopulate(val, "Registration", &a.Registration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureStaticWebAppsRegistration.
func (a AzureStaticWebAppsRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", a.ClientID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureStaticWebAppsRegistration.
func (a *AzureStaticWebAppsRegistration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &a.ClientID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureStorageInfoValue.
func (a AzureStorageInfoValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessKey", a.AccessKey)
	populate(objectMap, "accountName", a.AccountName)
	populate(objectMap, "mountPath", a.MountPath)
	populate(objectMap, "shareName", a.ShareName)
	populate(objectMap, "state", a.State)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureStorageInfoValue.
func (a *AzureStorageInfoValue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessKey":
			err = unpopulate(val, "AccessKey", &a.AccessKey)
			delete(rawMsg, key)
		case "accountName":
			err = unpopulate(val, "AccountName", &a.AccountName)
			delete(rawMsg, key)
		case "mountPath":
			err = unpopulate(val, "MountPath", &a.MountPath)
			delete(rawMsg, key)
		case "shareName":
			err = unpopulate(val, "ShareName", &a.ShareName)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &a.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureStoragePropertyDictionaryResource.
func (a AzureStoragePropertyDictionaryResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "kind", a.Kind)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureStoragePropertyDictionaryResource.
func (a *AzureStoragePropertyDictionaryResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureTableStorageApplicationLogsConfig.
func (a AzureTableStorageApplicationLogsConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "level", a.Level)
	populate(objectMap, "sasUrl", a.SasURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureTableStorageApplicationLogsConfig.
func (a *AzureTableStorageApplicationLogsConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "level":
			err = unpopulate(val, "Level", &a.Level)
			delete(rawMsg, key)
		case "sasUrl":
			err = unpopulate(val, "SasURL", &a.SasURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupItem.
func (b BackupItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "kind", b.Kind)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupItem.
func (b *BackupItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &b.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupItemCollection.
func (b BackupItemCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupItemCollection.
func (b *BackupItemCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupItemProperties.
func (b BackupItemProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.BackupID)
	populate(objectMap, "blobName", b.BlobName)
	populate(objectMap, "correlationId", b.CorrelationID)
	populateDateTimeRFC3339(objectMap, "created", b.Created)
	populate(objectMap, "databases", b.Databases)
	populateDateTimeRFC3339(objectMap, "finishedTimeStamp", b.FinishedTimeStamp)
	populateDateTimeRFC3339(objectMap, "lastRestoreTimeStamp", b.LastRestoreTimeStamp)
	populate(objectMap, "log", b.Log)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "scheduled", b.Scheduled)
	populate(objectMap, "sizeInBytes", b.SizeInBytes)
	populate(objectMap, "status", b.Status)
	populate(objectMap, "storageAccountUrl", b.StorageAccountURL)
	populate(objectMap, "websiteSizeInBytes", b.WebsiteSizeInBytes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupItemProperties.
func (b *BackupItemProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "BackupID", &b.BackupID)
			delete(rawMsg, key)
		case "blobName":
			err = unpopulate(val, "BlobName", &b.BlobName)
			delete(rawMsg, key)
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &b.CorrelationID)
			delete(rawMsg, key)
		case "created":
			err = unpopulateDateTimeRFC3339(val, "Created", &b.Created)
			delete(rawMsg, key)
		case "databases":
			err = unpopulate(val, "Databases", &b.Databases)
			delete(rawMsg, key)
		case "finishedTimeStamp":
			err = unpopulateDateTimeRFC3339(val, "FinishedTimeStamp", &b.FinishedTimeStamp)
			delete(rawMsg, key)
		case "lastRestoreTimeStamp":
			err = unpopulateDateTimeRFC3339(val, "LastRestoreTimeStamp", &b.LastRestoreTimeStamp)
			delete(rawMsg, key)
		case "log":
			err = unpopulate(val, "Log", &b.Log)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "scheduled":
			err = unpopulate(val, "Scheduled", &b.Scheduled)
			delete(rawMsg, key)
		case "sizeInBytes":
			err = unpopulate(val, "SizeInBytes", &b.SizeInBytes)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &b.Status)
			delete(rawMsg, key)
		case "storageAccountUrl":
			err = unpopulate(val, "StorageAccountURL", &b.StorageAccountURL)
			delete(rawMsg, key)
		case "websiteSizeInBytes":
			err = unpopulate(val, "WebsiteSizeInBytes", &b.WebsiteSizeInBytes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupRequest.
func (b BackupRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "kind", b.Kind)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupRequest.
func (b *BackupRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &b.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupRequestProperties.
func (b BackupRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backupName", b.BackupName)
	populate(objectMap, "backupSchedule", b.BackupSchedule)
	populate(objectMap, "databases", b.Databases)
	populate(objectMap, "enabled", b.Enabled)
	populate(objectMap, "storageAccountUrl", b.StorageAccountURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupRequestProperties.
func (b *BackupRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupName":
			err = unpopulate(val, "BackupName", &b.BackupName)
			delete(rawMsg, key)
		case "backupSchedule":
			err = unpopulate(val, "BackupSchedule", &b.BackupSchedule)
			delete(rawMsg, key)
		case "databases":
			err = unpopulate(val, "Databases", &b.Databases)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &b.Enabled)
			delete(rawMsg, key)
		case "storageAccountUrl":
			err = unpopulate(val, "StorageAccountURL", &b.StorageAccountURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupSchedule.
func (b BackupSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "frequencyInterval", b.FrequencyInterval)
	populate(objectMap, "frequencyUnit", b.FrequencyUnit)
	populate(objectMap, "keepAtLeastOneBackup", b.KeepAtLeastOneBackup)
	populateDateTimeRFC3339(objectMap, "lastExecutionTime", b.LastExecutionTime)
	populate(objectMap, "retentionPeriodInDays", b.RetentionPeriodInDays)
	populateDateTimeRFC3339(objectMap, "startTime", b.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupSchedule.
func (b *BackupSchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "frequencyInterval":
			err = unpopulate(val, "FrequencyInterval", &b.FrequencyInterval)
			delete(rawMsg, key)
		case "frequencyUnit":
			err = unpopulate(val, "FrequencyUnit", &b.FrequencyUnit)
			delete(rawMsg, key)
		case "keepAtLeastOneBackup":
			err = unpopulate(val, "KeepAtLeastOneBackup", &b.KeepAtLeastOneBackup)
			delete(rawMsg, key)
		case "lastExecutionTime":
			err = unpopulateDateTimeRFC3339(val, "LastExecutionTime", &b.LastExecutionTime)
			delete(rawMsg, key)
		case "retentionPeriodInDays":
			err = unpopulate(val, "RetentionPeriodInDays", &b.RetentionPeriodInDays)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &b.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BillingMeter.
func (b BillingMeter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "kind", b.Kind)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BillingMeter.
func (b *BillingMeter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &b.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BillingMeterCollection.
func (b BillingMeterCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BillingMeterCollection.
func (b *BillingMeterCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BillingMeterProperties.
func (b BillingMeterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingLocation", b.BillingLocation)
	populate(objectMap, "friendlyName", b.FriendlyName)
	populate(objectMap, "meterId", b.MeterID)
	populate(objectMap, "multiplier", b.Multiplier)
	populate(objectMap, "osType", b.OSType)
	populate(objectMap, "resourceType", b.ResourceType)
	populate(objectMap, "shortName", b.ShortName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BillingMeterProperties.
func (b *BillingMeterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingLocation":
			err = unpopulate(val, "BillingLocation", &b.BillingLocation)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &b.FriendlyName)
			delete(rawMsg, key)
		case "meterId":
			err = unpopulate(val, "MeterID", &b.MeterID)
			delete(rawMsg, key)
		case "multiplier":
			err = unpopulate(val, "Multiplier", &b.Multiplier)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &b.OSType)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &b.ResourceType)
			delete(rawMsg, key)
		case "shortName":
			err = unpopulate(val, "ShortName", &b.ShortName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobStorageTokenStore.
func (b BlobStorageTokenStore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sasUrlSettingName", b.SasURLSettingName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobStorageTokenStore.
func (b *BlobStorageTokenStore) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sasUrlSettingName":
			err = unpopulate(val, "SasURLSettingName", &b.SasURLSettingName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Capability.
func (c Capability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "reason", c.Reason)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Capability.
func (c *Capability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &c.Reason)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Certificate.
func (c Certificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyVaultId", c.KeyVaultID)
	populate(objectMap, "keyVaultSecretName", c.KeyVaultSecretName)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Certificate.
func (c *Certificate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyVaultId":
			err = unpopulate(val, "KeyVaultID", &c.KeyVaultID)
			delete(rawMsg, key)
		case "keyVaultSecretName":
			err = unpopulate(val, "KeyVaultSecretName", &c.KeyVaultSecretName)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateCollection.
func (c CertificateCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateCollection.
func (c *CertificateCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateDetails.
func (c CertificateDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "issuer", c.Issuer)
	populateDateTimeRFC3339(objectMap, "notAfter", c.NotAfter)
	populateDateTimeRFC3339(objectMap, "notBefore", c.NotBefore)
	populate(objectMap, "rawData", c.RawData)
	populate(objectMap, "serialNumber", c.SerialNumber)
	populate(objectMap, "signatureAlgorithm", c.SignatureAlgorithm)
	populate(objectMap, "subject", c.Subject)
	populate(objectMap, "thumbprint", c.Thumbprint)
	populate(objectMap, "version", c.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateDetails.
func (c *CertificateDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "issuer":
			err = unpopulate(val, "Issuer", &c.Issuer)
			delete(rawMsg, key)
		case "notAfter":
			err = unpopulateDateTimeRFC3339(val, "NotAfter", &c.NotAfter)
			delete(rawMsg, key)
		case "notBefore":
			err = unpopulateDateTimeRFC3339(val, "NotBefore", &c.NotBefore)
			delete(rawMsg, key)
		case "rawData":
			err = unpopulate(val, "RawData", &c.RawData)
			delete(rawMsg, key)
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &c.SerialNumber)
			delete(rawMsg, key)
		case "signatureAlgorithm":
			err = unpopulate(val, "SignatureAlgorithm", &c.SignatureAlgorithm)
			delete(rawMsg, key)
		case "subject":
			err = unpopulate(val, "Subject", &c.Subject)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &c.Thumbprint)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &c.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateEmail.
func (c CertificateEmail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "emailId", c.EmailID)
	populateDateTimeRFC3339(objectMap, "timeStamp", c.TimeStamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateEmail.
func (c *CertificateEmail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "emailId":
			err = unpopulate(val, "EmailID", &c.EmailID)
			delete(rawMsg, key)
		case "timeStamp":
			err = unpopulateDateTimeRFC3339(val, "TimeStamp", &c.TimeStamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateOrder.
func (c CertificateOrder) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "kind", c.Kind)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateOrder.
func (c *CertificateOrder) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateOrderAction.
func (c CertificateOrderAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionType", c.ActionType)
	populateDateTimeRFC3339(objectMap, "createdAt", c.CreatedAt)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateOrderAction.
func (c *CertificateOrderAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &c.ActionType)
			delete(rawMsg, key)
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &c.CreatedAt)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateOrderCollection.
func (c CertificateOrderCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateOrderCollection.
func (c *CertificateOrderCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateOrderContact.
func (c CertificateOrderContact) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "email", c.Email)
	populate(objectMap, "nameFirst", c.NameFirst)
	populate(objectMap, "nameLast", c.NameLast)
	populate(objectMap, "phone", c.Phone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateOrderContact.
func (c *CertificateOrderContact) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "email":
			err = unpopulate(val, "Email", &c.Email)
			delete(rawMsg, key)
		case "nameFirst":
			err = unpopulate(val, "NameFirst", &c.NameFirst)
			delete(rawMsg, key)
		case "nameLast":
			err = unpopulate(val, "NameLast", &c.NameLast)
			delete(rawMsg, key)
		case "phone":
			err = unpopulate(val, "Phone", &c.Phone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateOrderPatchResource.
func (c CertificateOrderPatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "kind", c.Kind)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateOrderPatchResource.
func (c *CertificateOrderPatchResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateOrderPatchResourceProperties.
func (c CertificateOrderPatchResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appServiceCertificateNotRenewableReasons", c.AppServiceCertificateNotRenewableReasons)
	populate(objectMap, "autoRenew", c.AutoRenew)
	populate(objectMap, "certificates", c.Certificates)
	populate(objectMap, "contact", c.Contact)
	populate(objectMap, "csr", c.Csr)
	populate(objectMap, "distinguishedName", c.DistinguishedName)
	populate(objectMap, "domainVerificationToken", c.DomainVerificationToken)
	populateDateTimeRFC3339(objectMap, "expirationTime", c.ExpirationTime)
	populate(objectMap, "intermediate", c.Intermediate)
	populate(objectMap, "isPrivateKeyExternal", c.IsPrivateKeyExternal)
	populate(objectMap, "keySize", c.KeySize)
	populateDateTimeRFC3339(objectMap, "lastCertificateIssuanceTime", c.LastCertificateIssuanceTime)
	populateDateTimeRFC3339(objectMap, "nextAutoRenewalTimeStamp", c.NextAutoRenewalTimeStamp)
	populate(objectMap, "productType", c.ProductType)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "root", c.Root)
	populate(objectMap, "serialNumber", c.SerialNumber)
	populate(objectMap, "signedCertificate", c.SignedCertificate)
	populate(objectMap, "status", c.Status)
	populate(objectMap, "validityInYears", c.ValidityInYears)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateOrderPatchResourceProperties.
func (c *CertificateOrderPatchResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appServiceCertificateNotRenewableReasons":
			err = unpopulate(val, "AppServiceCertificateNotRenewableReasons", &c.AppServiceCertificateNotRenewableReasons)
			delete(rawMsg, key)
		case "autoRenew":
			err = unpopulate(val, "AutoRenew", &c.AutoRenew)
			delete(rawMsg, key)
		case "certificates":
			err = unpopulate(val, "Certificates", &c.Certificates)
			delete(rawMsg, key)
		case "contact":
			err = unpopulate(val, "Contact", &c.Contact)
			delete(rawMsg, key)
		case "csr":
			err = unpopulate(val, "Csr", &c.Csr)
			delete(rawMsg, key)
		case "distinguishedName":
			err = unpopulate(val, "DistinguishedName", &c.DistinguishedName)
			delete(rawMsg, key)
		case "domainVerificationToken":
			err = unpopulate(val, "DomainVerificationToken", &c.DomainVerificationToken)
			delete(rawMsg, key)
		case "expirationTime":
			err = unpopulateDateTimeRFC3339(val, "ExpirationTime", &c.ExpirationTime)
			delete(rawMsg, key)
		case "intermediate":
			err = unpopulate(val, "Intermediate", &c.Intermediate)
			delete(rawMsg, key)
		case "isPrivateKeyExternal":
			err = unpopulate(val, "IsPrivateKeyExternal", &c.IsPrivateKeyExternal)
			delete(rawMsg, key)
		case "keySize":
			err = unpopulate(val, "KeySize", &c.KeySize)
			delete(rawMsg, key)
		case "lastCertificateIssuanceTime":
			err = unpopulateDateTimeRFC3339(val, "LastCertificateIssuanceTime", &c.LastCertificateIssuanceTime)
			delete(rawMsg, key)
		case "nextAutoRenewalTimeStamp":
			err = unpopulateDateTimeRFC3339(val, "NextAutoRenewalTimeStamp", &c.NextAutoRenewalTimeStamp)
			delete(rawMsg, key)
		case "productType":
			err = unpopulate(val, "ProductType", &c.ProductType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "root":
			err = unpopulate(val, "Root", &c.Root)
			delete(rawMsg, key)
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &c.SerialNumber)
			delete(rawMsg, key)
		case "signedCertificate":
			err = unpopulate(val, "SignedCertificate", &c.SignedCertificate)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		case "validityInYears":
			err = unpopulate(val, "ValidityInYears", &c.ValidityInYears)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateOrderProperties.
func (c CertificateOrderProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appServiceCertificateNotRenewableReasons", c.AppServiceCertificateNotRenewableReasons)
	populate(objectMap, "autoRenew", c.AutoRenew)
	populate(objectMap, "certificates", c.Certificates)
	populate(objectMap, "contact", c.Contact)
	populate(objectMap, "csr", c.Csr)
	populate(objectMap, "distinguishedName", c.DistinguishedName)
	populate(objectMap, "domainVerificationToken", c.DomainVerificationToken)
	populateDateTimeRFC3339(objectMap, "expirationTime", c.ExpirationTime)
	populate(objectMap, "intermediate", c.Intermediate)
	populate(objectMap, "isPrivateKeyExternal", c.IsPrivateKeyExternal)
	populate(objectMap, "keySize", c.KeySize)
	populateDateTimeRFC3339(objectMap, "lastCertificateIssuanceTime", c.LastCertificateIssuanceTime)
	populateDateTimeRFC3339(objectMap, "nextAutoRenewalTimeStamp", c.NextAutoRenewalTimeStamp)
	populate(objectMap, "productType", c.ProductType)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "root", c.Root)
	populate(objectMap, "serialNumber", c.SerialNumber)
	populate(objectMap, "signedCertificate", c.SignedCertificate)
	populate(objectMap, "status", c.Status)
	populate(objectMap, "validityInYears", c.ValidityInYears)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateOrderProperties.
func (c *CertificateOrderProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appServiceCertificateNotRenewableReasons":
			err = unpopulate(val, "AppServiceCertificateNotRenewableReasons", &c.AppServiceCertificateNotRenewableReasons)
			delete(rawMsg, key)
		case "autoRenew":
			err = unpopulate(val, "AutoRenew", &c.AutoRenew)
			delete(rawMsg, key)
		case "certificates":
			err = unpopulate(val, "Certificates", &c.Certificates)
			delete(rawMsg, key)
		case "contact":
			err = unpopulate(val, "Contact", &c.Contact)
			delete(rawMsg, key)
		case "csr":
			err = unpopulate(val, "Csr", &c.Csr)
			delete(rawMsg, key)
		case "distinguishedName":
			err = unpopulate(val, "DistinguishedName", &c.DistinguishedName)
			delete(rawMsg, key)
		case "domainVerificationToken":
			err = unpopulate(val, "DomainVerificationToken", &c.DomainVerificationToken)
			delete(rawMsg, key)
		case "expirationTime":
			err = unpopulateDateTimeRFC3339(val, "ExpirationTime", &c.ExpirationTime)
			delete(rawMsg, key)
		case "intermediate":
			err = unpopulate(val, "Intermediate", &c.Intermediate)
			delete(rawMsg, key)
		case "isPrivateKeyExternal":
			err = unpopulate(val, "IsPrivateKeyExternal", &c.IsPrivateKeyExternal)
			delete(rawMsg, key)
		case "keySize":
			err = unpopulate(val, "KeySize", &c.KeySize)
			delete(rawMsg, key)
		case "lastCertificateIssuanceTime":
			err = unpopulateDateTimeRFC3339(val, "LastCertificateIssuanceTime", &c.LastCertificateIssuanceTime)
			delete(rawMsg, key)
		case "nextAutoRenewalTimeStamp":
			err = unpopulateDateTimeRFC3339(val, "NextAutoRenewalTimeStamp", &c.NextAutoRenewalTimeStamp)
			delete(rawMsg, key)
		case "productType":
			err = unpopulate(val, "ProductType", &c.ProductType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "root":
			err = unpopulate(val, "Root", &c.Root)
			delete(rawMsg, key)
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &c.SerialNumber)
			delete(rawMsg, key)
		case "signedCertificate":
			err = unpopulate(val, "SignedCertificate", &c.SignedCertificate)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		case "validityInYears":
			err = unpopulate(val, "ValidityInYears", &c.ValidityInYears)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificatePatchResource.
func (c CertificatePatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "kind", c.Kind)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificatePatchResource.
func (c *CertificatePatchResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateResource.
func (c CertificateResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "kind", c.Kind)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateResource.
func (c *CertificateResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClientRegistration.
func (c ClientRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", c.ClientID)
	populate(objectMap, "clientSecretSettingName", c.ClientSecretSettingName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClientRegistration.
func (c *ClientRegistration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &c.ClientID)
			delete(rawMsg, key)
		case "clientSecretSettingName":
			err = unpopulate(val, "ClientSecretSettingName", &c.ClientSecretSettingName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloningInfo.
func (c CloningInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appSettingsOverrides", c.AppSettingsOverrides)
	populate(objectMap, "cloneCustomHostNames", c.CloneCustomHostNames)
	populate(objectMap, "cloneSourceControl", c.CloneSourceControl)
	populate(objectMap, "configureLoadBalancing", c.ConfigureLoadBalancing)
	populate(objectMap, "correlationId", c.CorrelationID)
	populate(objectMap, "hostingEnvironment", c.HostingEnvironment)
	populate(objectMap, "overwrite", c.Overwrite)
	populate(objectMap, "sourceWebAppId", c.SourceWebAppID)
	populate(objectMap, "sourceWebAppLocation", c.SourceWebAppLocation)
	populate(objectMap, "trafficManagerProfileId", c.TrafficManagerProfileID)
	populate(objectMap, "trafficManagerProfileName", c.TrafficManagerProfileName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloningInfo.
func (c *CloningInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appSettingsOverrides":
			err = unpopulate(val, "AppSettingsOverrides", &c.AppSettingsOverrides)
			delete(rawMsg, key)
		case "cloneCustomHostNames":
			err = unpopulate(val, "CloneCustomHostNames", &c.CloneCustomHostNames)
			delete(rawMsg, key)
		case "cloneSourceControl":
			err = unpopulate(val, "CloneSourceControl", &c.CloneSourceControl)
			delete(rawMsg, key)
		case "configureLoadBalancing":
			err = unpopulate(val, "ConfigureLoadBalancing", &c.ConfigureLoadBalancing)
			delete(rawMsg, key)
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &c.CorrelationID)
			delete(rawMsg, key)
		case "hostingEnvironment":
			err = unpopulate(val, "HostingEnvironment", &c.HostingEnvironment)
			delete(rawMsg, key)
		case "overwrite":
			err = unpopulate(val, "Overwrite", &c.Overwrite)
			delete(rawMsg, key)
		case "sourceWebAppId":
			err = unpopulate(val, "SourceWebAppID", &c.SourceWebAppID)
			delete(rawMsg, key)
		case "sourceWebAppLocation":
			err = unpopulate(val, "SourceWebAppLocation", &c.SourceWebAppLocation)
			delete(rawMsg, key)
		case "trafficManagerProfileId":
			err = unpopulate(val, "TrafficManagerProfileID", &c.TrafficManagerProfileID)
			delete(rawMsg, key)
		case "trafficManagerProfileName":
			err = unpopulate(val, "TrafficManagerProfileName", &c.TrafficManagerProfileName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Configuration.
func (c Configuration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activeRevisionsMode", c.ActiveRevisionsMode)
	populate(objectMap, "ingress", c.Ingress)
	populate(objectMap, "registries", c.Registries)
	populate(objectMap, "secrets", c.Secrets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Configuration.
func (c *Configuration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activeRevisionsMode":
			err = unpopulate(val, "ActiveRevisionsMode", &c.ActiveRevisionsMode)
			delete(rawMsg, key)
		case "ingress":
			err = unpopulate(val, "Ingress", &c.Ingress)
			delete(rawMsg, key)
		case "registries":
			err = unpopulate(val, "Registries", &c.Registries)
			delete(rawMsg, key)
		case "secrets":
			err = unpopulate(val, "Secrets", &c.Secrets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnStringInfo.
func (c ConnStringInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionString", c.ConnectionString)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnStringInfo.
func (c *ConnStringInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &c.ConnectionString)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnStringValueTypePair.
func (c ConnStringValueTypePair) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "type", c.Type)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnStringValueTypePair.
func (c *ConnStringValueTypePair) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionStringDictionary.
func (c ConnectionStringDictionary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "kind", c.Kind)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionStringDictionary.
func (c *ConnectionStringDictionary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Contact.
func (c Contact) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressMailing", c.AddressMailing)
	populate(objectMap, "email", c.Email)
	populate(objectMap, "fax", c.Fax)
	populate(objectMap, "jobTitle", c.JobTitle)
	populate(objectMap, "nameFirst", c.NameFirst)
	populate(objectMap, "nameLast", c.NameLast)
	populate(objectMap, "nameMiddle", c.NameMiddle)
	populate(objectMap, "organization", c.Organization)
	populate(objectMap, "phone", c.Phone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Contact.
func (c *Contact) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressMailing":
			err = unpopulate(val, "AddressMailing", &c.AddressMailing)
			delete(rawMsg, key)
		case "email":
			err = unpopulate(val, "Email", &c.Email)
			delete(rawMsg, key)
		case "fax":
			err = unpopulate(val, "Fax", &c.Fax)
			delete(rawMsg, key)
		case "jobTitle":
			err = unpopulate(val, "JobTitle", &c.JobTitle)
			delete(rawMsg, key)
		case "nameFirst":
			err = unpopulate(val, "NameFirst", &c.NameFirst)
			delete(rawMsg, key)
		case "nameLast":
			err = unpopulate(val, "NameLast", &c.NameLast)
			delete(rawMsg, key)
		case "nameMiddle":
			err = unpopulate(val, "NameMiddle", &c.NameMiddle)
			delete(rawMsg, key)
		case "organization":
			err = unpopulate(val, "Organization", &c.Organization)
			delete(rawMsg, key)
		case "phone":
			err = unpopulate(val, "Phone", &c.Phone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Container.
func (c Container) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "args", c.Args)
	populate(objectMap, "command", c.Command)
	populate(objectMap, "env", c.Env)
	populate(objectMap, "image", c.Image)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "resources", c.Resources)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Container.
func (c *Container) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "args":
			err = unpopulate(val, "Args", &c.Args)
			delete(rawMsg, key)
		case "command":
			err = unpopulate(val, "Command", &c.Command)
			delete(rawMsg, key)
		case "env":
			err = unpopulate(val, "Env", &c.Env)
			delete(rawMsg, key)
		case "image":
			err = unpopulate(val, "Image", &c.Image)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "resources":
			err = unpopulate(val, "Resources", &c.Resources)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerApp.
func (c ContainerApp) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "kind", c.Kind)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerApp.
func (c *ContainerApp) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerAppCollection.
func (c ContainerAppCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerAppCollection.
func (c *ContainerAppCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerAppProperties.
func (c ContainerAppProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configuration", c.Configuration)
	populate(objectMap, "kubeEnvironmentId", c.KubeEnvironmentID)
	populate(objectMap, "latestRevisionFqdn", c.LatestRevisionFqdn)
	populate(objectMap, "latestRevisionName", c.LatestRevisionName)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "template", c.Template)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerAppProperties.
func (c *ContainerAppProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configuration":
			err = unpopulate(val, "Configuration", &c.Configuration)
			delete(rawMsg, key)
		case "kubeEnvironmentId":
			err = unpopulate(val, "KubeEnvironmentID", &c.KubeEnvironmentID)
			delete(rawMsg, key)
		case "latestRevisionFqdn":
			err = unpopulate(val, "LatestRevisionFqdn", &c.LatestRevisionFqdn)
			delete(rawMsg, key)
		case "latestRevisionName":
			err = unpopulate(val, "LatestRevisionName", &c.LatestRevisionName)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "template":
			err = unpopulate(val, "Template", &c.Template)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerAppSecret.
func (c ContainerAppSecret) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerAppSecret.
func (c *ContainerAppSecret) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerAppsConfiguration.
func (c ContainerAppsConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appSubnetResourceId", c.AppSubnetResourceID)
	populate(objectMap, "controlPlaneSubnetResourceId", c.ControlPlaneSubnetResourceID)
	populate(objectMap, "daprAIInstrumentationKey", c.DaprAIInstrumentationKey)
	populate(objectMap, "dockerBridgeCidr", c.DockerBridgeCidr)
	populate(objectMap, "platformReservedCidr", c.PlatformReservedCidr)
	populate(objectMap, "platformReservedDnsIP", c.PlatformReservedDNSIP)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerAppsConfiguration.
func (c *ContainerAppsConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appSubnetResourceId":
			err = unpopulate(val, "AppSubnetResourceID", &c.AppSubnetResourceID)
			delete(rawMsg, key)
		case "controlPlaneSubnetResourceId":
			err = unpopulate(val, "ControlPlaneSubnetResourceID", &c.ControlPlaneSubnetResourceID)
			delete(rawMsg, key)
		case "daprAIInstrumentationKey":
			err = unpopulate(val, "DaprAIInstrumentationKey", &c.DaprAIInstrumentationKey)
			delete(rawMsg, key)
		case "dockerBridgeCidr":
			err = unpopulate(val, "DockerBridgeCidr", &c.DockerBridgeCidr)
			delete(rawMsg, key)
		case "platformReservedCidr":
			err = unpopulate(val, "PlatformReservedCidr", &c.PlatformReservedCidr)
			delete(rawMsg, key)
		case "platformReservedDnsIP":
			err = unpopulate(val, "PlatformReservedDNSIP", &c.PlatformReservedDNSIP)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerCPUStatistics.
func (c ContainerCPUStatistics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cpuUsage", c.CPUUsage)
	populate(objectMap, "onlineCpuCount", c.OnlineCPUCount)
	populate(objectMap, "systemCpuUsage", c.SystemCPUUsage)
	populate(objectMap, "throttlingData", c.ThrottlingData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerCPUStatistics.
func (c *ContainerCPUStatistics) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cpuUsage":
			err = unpopulate(val, "CPUUsage", &c.CPUUsage)
			delete(rawMsg, key)
		case "onlineCpuCount":
			err = unpopulate(val, "OnlineCPUCount", &c.OnlineCPUCount)
			delete(rawMsg, key)
		case "systemCpuUsage":
			err = unpopulate(val, "SystemCPUUsage", &c.SystemCPUUsage)
			delete(rawMsg, key)
		case "throttlingData":
			err = unpopulate(val, "ThrottlingData", &c.ThrottlingData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerCPUUsage.
func (c ContainerCPUUsage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "kernelModeUsage", c.KernelModeUsage)
	populate(objectMap, "perCpuUsage", c.PerCPUUsage)
	populate(objectMap, "totalUsage", c.TotalUsage)
	populate(objectMap, "userModeUsage", c.UserModeUsage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerCPUUsage.
func (c *ContainerCPUUsage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kernelModeUsage":
			err = unpopulate(val, "KernelModeUsage", &c.KernelModeUsage)
			delete(rawMsg, key)
		case "perCpuUsage":
			err = unpopulate(val, "PerCPUUsage", &c.PerCPUUsage)
			delete(rawMsg, key)
		case "totalUsage":
			err = unpopulate(val, "TotalUsage", &c.TotalUsage)
			delete(rawMsg, key)
		case "userModeUsage":
			err = unpopulate(val, "UserModeUsage", &c.UserModeUsage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerInfo.
func (c ContainerInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentCpuStats", c.CurrentCPUStats)
	populateDateTimeRFC3339(objectMap, "currentTimeStamp", c.CurrentTimeStamp)
	populate(objectMap, "eth0", c.Eth0)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "memoryStats", c.MemoryStats)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "previousCpuStats", c.PreviousCPUStats)
	populateDateTimeRFC3339(objectMap, "previousTimeStamp", c.PreviousTimeStamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerInfo.
func (c *ContainerInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentCpuStats":
			err = unpopulate(val, "CurrentCPUStats", &c.CurrentCPUStats)
			delete(rawMsg, key)
		case "currentTimeStamp":
			err = unpopulateDateTimeRFC3339(val, "CurrentTimeStamp", &c.CurrentTimeStamp)
			delete(rawMsg, key)
		case "eth0":
			err = unpopulate(val, "Eth0", &c.Eth0)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "memoryStats":
			err = unpopulate(val, "MemoryStats", &c.MemoryStats)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "previousCpuStats":
			err = unpopulate(val, "PreviousCPUStats", &c.PreviousCPUStats)
			delete(rawMsg, key)
		case "previousTimeStamp":
			err = unpopulateDateTimeRFC3339(val, "PreviousTimeStamp", &c.PreviousTimeStamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerMemoryStatistics.
func (c ContainerMemoryStatistics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "limit", c.Limit)
	populate(objectMap, "maxUsage", c.MaxUsage)
	populate(objectMap, "usage", c.Usage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerMemoryStatistics.
func (c *ContainerMemoryStatistics) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "limit":
			err = unpopulate(val, "Limit", &c.Limit)
			delete(rawMsg, key)
		case "maxUsage":
			err = unpopulate(val, "MaxUsage", &c.MaxUsage)
			delete(rawMsg, key)
		case "usage":
			err = unpopulate(val, "Usage", &c.Usage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerNetworkInterfaceStatistics.
func (c ContainerNetworkInterfaceStatistics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "rxBytes", c.RxBytes)
	populate(objectMap, "rxDropped", c.RxDropped)
	populate(objectMap, "rxErrors", c.RxErrors)
	populate(objectMap, "rxPackets", c.RxPackets)
	populate(objectMap, "txBytes", c.TxBytes)
	populate(objectMap, "txDropped", c.TxDropped)
	populate(objectMap, "txErrors", c.TxErrors)
	populate(objectMap, "txPackets", c.TxPackets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerNetworkInterfaceStatistics.
func (c *ContainerNetworkInterfaceStatistics) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "rxBytes":
			err = unpopulate(val, "RxBytes", &c.RxBytes)
			delete(rawMsg, key)
		case "rxDropped":
			err = unpopulate(val, "RxDropped", &c.RxDropped)
			delete(rawMsg, key)
		case "rxErrors":
			err = unpopulate(val, "RxErrors", &c.RxErrors)
			delete(rawMsg, key)
		case "rxPackets":
			err = unpopulate(val, "RxPackets", &c.RxPackets)
			delete(rawMsg, key)
		case "txBytes":
			err = unpopulate(val, "TxBytes", &c.TxBytes)
			delete(rawMsg, key)
		case "txDropped":
			err = unpopulate(val, "TxDropped", &c.TxDropped)
			delete(rawMsg, key)
		case "txErrors":
			err = unpopulate(val, "TxErrors", &c.TxErrors)
			delete(rawMsg, key)
		case "txPackets":
			err = unpopulate(val, "TxPackets", &c.TxPackets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerResources.
func (c ContainerResources) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cpu", c.CPU)
	populate(objectMap, "memory", c.Memory)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerResources.
func (c *ContainerResources) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cpu":
			err = unpopulate(val, "CPU", &c.CPU)
			delete(rawMsg, key)
		case "memory":
			err = unpopulate(val, "Memory", &c.Memory)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerThrottlingData.
func (c ContainerThrottlingData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "periods", c.Periods)
	populate(objectMap, "throttledPeriods", c.ThrottledPeriods)
	populate(objectMap, "throttledTime", c.ThrottledTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerThrottlingData.
func (c *ContainerThrottlingData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "periods":
			err = unpopulate(val, "Periods", &c.Periods)
			delete(rawMsg, key)
		case "throttledPeriods":
			err = unpopulate(val, "ThrottledPeriods", &c.ThrottledPeriods)
			delete(rawMsg, key)
		case "throttledTime":
			err = unpopulate(val, "ThrottledTime", &c.ThrottledTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentHash.
func (c ContentHash) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "algorithm", c.Algorithm)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentHash.
func (c *ContentHash) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "algorithm":
			err = unpopulate(val, "Algorithm", &c.Algorithm)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentLink.
func (c ContentLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contentHash", c.ContentHash)
	populate(objectMap, "contentSize", c.ContentSize)
	populate(objectMap, "contentVersion", c.ContentVersion)
	populateAny(objectMap, "metadata", c.Metadata)
	populate(objectMap, "uri", c.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentLink.
func (c *ContentLink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentHash":
			err = unpopulate(val, "ContentHash", &c.ContentHash)
			delete(rawMsg, key)
		case "contentSize":
			err = unpopulate(val, "ContentSize", &c.ContentSize)
			delete(rawMsg, key)
		case "contentVersion":
			err = unpopulate(val, "ContentVersion", &c.ContentVersion)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &c.Metadata)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &c.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContinuousWebJob.
func (c ContinuousWebJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "kind", c.Kind)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContinuousWebJob.
func (c *ContinuousWebJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContinuousWebJobCollection.
func (c ContinuousWebJobCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContinuousWebJobCollection.
func (c *ContinuousWebJobCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContinuousWebJobProperties.
func (c ContinuousWebJobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "detailed_status", c.DetailedStatus)
	populate(objectMap, "error", c.Error)
	populate(objectMap, "extra_info_url", c.ExtraInfoURL)
	populate(objectMap, "log_url", c.LogURL)
	populate(objectMap, "run_command", c.RunCommand)
	populate(objectMap, "settings", c.Settings)
	populate(objectMap, "status", c.Status)
	populate(objectMap, "url", c.URL)
	populate(objectMap, "using_sdk", c.UsingSdk)
	populate(objectMap, "web_job_type", c.WebJobType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContinuousWebJobProperties.
func (c *ContinuousWebJobProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "detailed_status":
			err = unpopulate(val, "DetailedStatus", &c.DetailedStatus)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &c.Error)
			delete(rawMsg, key)
		case "extra_info_url":
			err = unpopulate(val, "ExtraInfoURL", &c.ExtraInfoURL)
			delete(rawMsg, key)
		case "log_url":
			err = unpopulate(val, "LogURL", &c.LogURL)
			delete(rawMsg, key)
		case "run_command":
			err = unpopulate(val, "RunCommand", &c.RunCommand)
			delete(rawMsg, key)
		case "settings":
			err = unpopulate(val, "Settings", &c.Settings)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &c.URL)
			delete(rawMsg, key)
		case "using_sdk":
			err = unpopulate(val, "UsingSdk", &c.UsingSdk)
			delete(rawMsg, key)
		case "web_job_type":
			err = unpopulate(val, "WebJobType", &c.WebJobType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CookieExpiration.
func (c CookieExpiration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "convention", c.Convention)
	populate(objectMap, "timeToExpiration", c.TimeToExpiration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CookieExpiration.
func (c *CookieExpiration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "convention":
			err = unpopulate(val, "Convention", &c.Convention)
			delete(rawMsg, key)
		case "timeToExpiration":
			err = unpopulate(val, "TimeToExpiration", &c.TimeToExpiration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Correlation.
func (c Correlation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientTrackingId", c.ClientTrackingID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Correlation.
func (c *Correlation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientTrackingId":
			err = unpopulate(val, "ClientTrackingID", &c.ClientTrackingID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CorsSettings.
func (c CorsSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedOrigins", c.AllowedOrigins)
	populate(objectMap, "supportCredentials", c.SupportCredentials)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CorsSettings.
func (c *CorsSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedOrigins":
			err = unpopulate(val, "AllowedOrigins", &c.AllowedOrigins)
			delete(rawMsg, key)
		case "supportCredentials":
			err = unpopulate(val, "SupportCredentials", &c.SupportCredentials)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CsmDeploymentStatus.
func (c CsmDeploymentStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "kind", c.Kind)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CsmDeploymentStatus.
func (c *CsmDeploymentStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CsmDeploymentStatusCollection.
func (c CsmDeploymentStatusCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CsmDeploymentStatusCollection.
func (c *CsmDeploymentStatusCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CsmDeploymentStatusProperties.
func (c CsmDeploymentStatusProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deploymentId", c.DeploymentID)
	populate(objectMap, "errors", c.Errors)
	populate(objectMap, "failedInstancesLogs", c.FailedInstancesLogs)
	populate(objectMap, "numberOfInstancesFailed", c.NumberOfInstancesFailed)
	populate(objectMap, "numberOfInstancesInProgress", c.NumberOfInstancesInProgress)
	populate(objectMap, "numberOfInstancesSuccessful", c.NumberOfInstancesSuccessful)
	populate(objectMap, "status", c.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CsmDeploymentStatusProperties.
func (c *CsmDeploymentStatusProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deploymentId":
			err = unpopulate(val, "DeploymentID", &c.DeploymentID)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &c.Errors)
			delete(rawMsg, key)
		case "failedInstancesLogs":
			err = unpopulate(val, "FailedInstancesLogs", &c.FailedInstancesLogs)
			delete(rawMsg, key)
		case "numberOfInstancesFailed":
			err = unpopulate(val, "NumberOfInstancesFailed", &c.NumberOfInstancesFailed)
			delete(rawMsg, key)
		case "numberOfInstancesInProgress":
			err = unpopulate(val, "NumberOfInstancesInProgress", &c.NumberOfInstancesInProgress)
			delete(rawMsg, key)
		case "numberOfInstancesSuccessful":
			err = unpopulate(val, "NumberOfInstancesSuccessful", &c.NumberOfInstancesSuccessful)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CsmMoveResourceEnvelope.
func (c CsmMoveResourceEnvelope) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resources", c.Resources)
	populate(objectMap, "targetResourceGroup", c.TargetResourceGroup)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CsmMoveResourceEnvelope.
func (c *CsmMoveResourceEnvelope) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resources":
			err = unpopulate(val, "Resources", &c.Resources)
			delete(rawMsg, key)
		case "targetResourceGroup":
			err = unpopulate(val, "TargetResourceGroup", &c.TargetResourceGroup)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CsmOperationCollection.
func (c CsmOperationCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CsmOperationCollection.
func (c *CsmOperationCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CsmOperationDescription.
func (c CsmOperationDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", c.Display)
	populate(objectMap, "isDataAction", c.IsDataAction)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "origin", c.Origin)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CsmOperationDescription.
func (c *CsmOperationDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &c.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &c.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &c.Origin)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CsmOperationDescriptionProperties.
func (c CsmOperationDescriptionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "serviceSpecification", c.ServiceSpecification)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CsmOperationDescriptionProperties.
func (c *CsmOperationDescriptionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serviceSpecification":
			err = unpopulate(val, "ServiceSpecification", &c.ServiceSpecification)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CsmOperationDisplay.
func (c CsmOperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "operation", c.Operation)
	populate(objectMap, "provider", c.Provider)
	populate(objectMap, "resource", c.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CsmOperationDisplay.
func (c *CsmOperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &c.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &c.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &c.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CsmPublishingCredentialsPoliciesEntity.
func (c CsmPublishingCredentialsPoliciesEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "kind", c.Kind)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CsmPublishingCredentialsPoliciesEntity.
func (c *CsmPublishingCredentialsPoliciesEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CsmPublishingCredentialsPoliciesEntityProperties.
func (c CsmPublishingCredentialsPoliciesEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allow", c.Allow)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CsmPublishingCredentialsPoliciesEntityProperties.
func (c *CsmPublishingCredentialsPoliciesEntityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allow":
			err = unpopulate(val, "Allow", &c.Allow)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CsmPublishingProfileOptions.
func (c CsmPublishingProfileOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "format", c.Format)
	populate(objectMap, "includeDisasterRecoveryEndpoints", c.IncludeDisasterRecoveryEndpoints)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CsmPublishingProfileOptions.
func (c *CsmPublishingProfileOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "format":
			err = unpopulate(val, "Format", &c.Format)
			delete(rawMsg, key)
		case "includeDisasterRecoveryEndpoints":
			err = unpopulate(val, "IncludeDisasterRecoveryEndpoints", &c.IncludeDisasterRecoveryEndpoints)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CsmSlotEntity.
func (c CsmSlotEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "preserveVnet", c.PreserveVnet)
	populate(objectMap, "targetSlot", c.TargetSlot)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CsmSlotEntity.
func (c *CsmSlotEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "preserveVnet":
			err = unpopulate(val, "PreserveVnet", &c.PreserveVnet)
			delete(rawMsg, key)
		case "targetSlot":
			err = unpopulate(val, "TargetSlot", &c.TargetSlot)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CsmUsageQuota.
func (c CsmUsageQuota) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentValue", c.CurrentValue)
	populate(objectMap, "limit", c.Limit)
	populate(objectMap, "name", c.Name)
	populateDateTimeRFC3339(objectMap, "nextResetTime", c.NextResetTime)
	populate(objectMap, "unit", c.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CsmUsageQuota.
func (c *CsmUsageQuota) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentValue":
			err = unpopulate(val, "CurrentValue", &c.CurrentValue)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &c.Limit)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "nextResetTime":
			err = unpopulateDateTimeRFC3339(val, "NextResetTime", &c.NextResetTime)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &c.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CsmUsageQuotaCollection.
func (c CsmUsageQuotaCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CsmUsageQuotaCollection.
func (c *CsmUsageQuotaCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomDNSSuffixConfiguration.
func (c CustomDNSSuffixConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "kind", c.Kind)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomDNSSuffixConfiguration.
func (c *CustomDNSSuffixConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomDNSSuffixConfigurationProperties.
func (c CustomDNSSuffixConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificateUrl", c.CertificateURL)
	populate(objectMap, "dnsSuffix", c.DNSSuffix)
	populate(objectMap, "keyVaultReferenceIdentity", c.KeyVaultReferenceIdentity)
	populate(objectMap, "provisioningDetails", c.ProvisioningDetails)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomDNSSuffixConfigurationProperties.
func (c *CustomDNSSuffixConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateUrl":
			err = unpopulate(val, "CertificateURL", &c.CertificateURL)
			delete(rawMsg, key)
		case "dnsSuffix":
			err = unpopulate(val, "DNSSuffix", &c.DNSSuffix)
			delete(rawMsg, key)
		case "keyVaultReferenceIdentity":
			err = unpopulate(val, "KeyVaultReferenceIdentity", &c.KeyVaultReferenceIdentity)
			delete(rawMsg, key)
		case "provisioningDetails":
			err = unpopulate(val, "ProvisioningDetails", &c.ProvisioningDetails)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomHostnameAnalysisResult.
func (c CustomHostnameAnalysisResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "kind", c.Kind)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomHostnameAnalysisResult.
func (c *CustomHostnameAnalysisResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomHostnameAnalysisResultProperties.
func (c CustomHostnameAnalysisResultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aRecords", c.ARecords)
	populate(objectMap, "alternateCNameRecords", c.AlternateCNameRecords)
	populate(objectMap, "alternateTxtRecords", c.AlternateTxtRecords)
	populate(objectMap, "cNameRecords", c.CNameRecords)
	populate(objectMap, "conflictingAppResourceId", c.ConflictingAppResourceID)
	populate(objectMap, "customDomainVerificationFailureInfo", c.CustomDomainVerificationFailureInfo)
	populate(objectMap, "customDomainVerificationTest", c.CustomDomainVerificationTest)
	populate(objectMap, "hasConflictAcrossSubscription", c.HasConflictAcrossSubscription)
	populate(objectMap, "hasConflictOnScaleUnit", c.HasConflictOnScaleUnit)
	populate(objectMap, "isHostnameAlreadyVerified", c.IsHostnameAlreadyVerified)
	populate(objectMap, "txtRecords", c.TxtRecords)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomHostnameAnalysisResultProperties.
func (c *CustomHostnameAnalysisResultProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aRecords":
			err = unpopulate(val, "ARecords", &c.ARecords)
			delete(rawMsg, key)
		case "alternateCNameRecords":
			err = unpopulate(val, "AlternateCNameRecords", &c.AlternateCNameRecords)
			delete(rawMsg, key)
		case "alternateTxtRecords":
			err = unpopulate(val, "AlternateTxtRecords", &c.AlternateTxtRecords)
			delete(rawMsg, key)
		case "cNameRecords":
			err = unpopulate(val, "CNameRecords", &c.CNameRecords)
			delete(rawMsg, key)
		case "conflictingAppResourceId":
			err = unpopulate(val, "ConflictingAppResourceID", &c.ConflictingAppResourceID)
			delete(rawMsg, key)
		case "customDomainVerificationFailureInfo":
			err = unpopulate(val, "CustomDomainVerificationFailureInfo", &c.CustomDomainVerificationFailureInfo)
			delete(rawMsg, key)
		case "customDomainVerificationTest":
			err = unpopulate(val, "CustomDomainVerificationTest", &c.CustomDomainVerificationTest)
			delete(rawMsg, key)
		case "hasConflictAcrossSubscription":
			err = unpopulate(val, "HasConflictAcrossSubscription", &c.HasConflictAcrossSubscription)
			delete(rawMsg, key)
		case "hasConflictOnScaleUnit":
			err = unpopulate(val, "HasConflictOnScaleUnit", &c.HasConflictOnScaleUnit)
			delete(rawMsg, key)
		case "isHostnameAlreadyVerified":
			err = unpopulate(val, "IsHostnameAlreadyVerified", &c.IsHostnameAlreadyVerified)
			delete(rawMsg, key)
		case "txtRecords":
			err = unpopulate(val, "TxtRecords", &c.TxtRecords)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomHostnameSites.
func (c CustomHostnameSites) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "kind", c.Kind)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomHostnameSites.
func (c *CustomHostnameSites) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomHostnameSitesCollection.
func (c CustomHostnameSitesCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomHostnameSitesCollection.
func (c *CustomHostnameSitesCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomHostnameSitesProperties.
func (c CustomHostnameSitesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customHostname", c.CustomHostname)
	populate(objectMap, "region", c.Region)
	populate(objectMap, "siteResourceIds", c.SiteResourceIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomHostnameSitesProperties.
func (c *CustomHostnameSitesProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customHostname":
			err = unpopulate(val, "CustomHostname", &c.CustomHostname)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &c.Region)
			delete(rawMsg, key)
		case "siteResourceIds":
			err = unpopulate(val, "SiteResourceIDs", &c.SiteResourceIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomOpenIDConnectProvider.
func (c CustomOpenIDConnectProvider) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", c.Enabled)
	populate(objectMap, "login", c.Login)
	populate(objectMap, "registration", c.Registration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomOpenIDConnectProvider.
func (c *CustomOpenIDConnectProvider) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &c.Enabled)
			delete(rawMsg, key)
		case "login":
			err = unpopulate(val, "Login", &c.Login)
			delete(rawMsg, key)
		case "registration":
			err = unpopulate(val, "Registration", &c.Registration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomScaleRule.
func (c CustomScaleRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "auth", c.Auth)
	populate(objectMap, "metadata", c.Metadata)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomScaleRule.
func (c *CustomScaleRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "auth":
			err = unpopulate(val, "Auth", &c.Auth)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &c.Metadata)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Dapr.
func (d Dapr) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appId", d.AppID)
	populate(objectMap, "appPort", d.AppPort)
	populate(objectMap, "components", d.Components)
	populate(objectMap, "enabled", d.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Dapr.
func (d *Dapr) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appId":
			err = unpopulate(val, "AppID", &d.AppID)
			delete(rawMsg, key)
		case "appPort":
			err = unpopulate(val, "AppPort", &d.AppPort)
			delete(rawMsg, key)
		case "components":
			err = unpopulate(val, "Components", &d.Components)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &d.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DaprComponent.
func (d DaprComponent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "metadata", d.Metadata)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "type", d.Type)
	populate(objectMap, "version", d.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DaprComponent.
func (d *DaprComponent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "metadata":
			err = unpopulate(val, "Metadata", &d.Metadata)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &d.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DaprConfig.
func (d DaprConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appId", d.AppID)
	populate(objectMap, "appPort", d.AppPort)
	populate(objectMap, "enableApiLogging", d.EnableAPILogging)
	populate(objectMap, "enabled", d.Enabled)
	populate(objectMap, "httpMaxRequestSize", d.HTTPMaxRequestSize)
	populate(objectMap, "httpReadBufferSize", d.HTTPReadBufferSize)
	populate(objectMap, "logLevel", d.LogLevel)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DaprConfig.
func (d *DaprConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appId":
			err = unpopulate(val, "AppID", &d.AppID)
			delete(rawMsg, key)
		case "appPort":
			err = unpopulate(val, "AppPort", &d.AppPort)
			delete(rawMsg, key)
		case "enableApiLogging":
			err = unpopulate(val, "EnableAPILogging", &d.EnableAPILogging)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &d.Enabled)
			delete(rawMsg, key)
		case "httpMaxRequestSize":
			err = unpopulate(val, "HTTPMaxRequestSize", &d.HTTPMaxRequestSize)
			delete(rawMsg, key)
		case "httpReadBufferSize":
			err = unpopulate(val, "HTTPReadBufferSize", &d.HTTPReadBufferSize)
			delete(rawMsg, key)
		case "logLevel":
			err = unpopulate(val, "LogLevel", &d.LogLevel)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DaprMetadata.
func (d DaprMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "secretRef", d.SecretRef)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DaprMetadata.
func (d *DaprMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "secretRef":
			err = unpopulate(val, "SecretRef", &d.SecretRef)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataProviderMetadata.
func (d DataProviderMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "propertyBag", d.PropertyBag)
	populate(objectMap, "providerName", d.ProviderName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataProviderMetadata.
func (d *DataProviderMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "propertyBag":
			err = unpopulate(val, "PropertyBag", &d.PropertyBag)
			delete(rawMsg, key)
		case "providerName":
			err = unpopulate(val, "ProviderName", &d.ProviderName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataSource.
func (d DataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataSourceUri", d.DataSourceURI)
	populate(objectMap, "instructions", d.Instructions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataSource.
func (d *DataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataSourceUri":
			err = unpopulate(val, "DataSourceURI", &d.DataSourceURI)
			delete(rawMsg, key)
		case "instructions":
			err = unpopulate(val, "Instructions", &d.Instructions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataTableResponseColumn.
func (d DataTableResponseColumn) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "columnName", d.ColumnName)
	populate(objectMap, "columnType", d.ColumnType)
	populate(objectMap, "dataType", d.DataType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataTableResponseColumn.
func (d *DataTableResponseColumn) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "columnName":
			err = unpopulate(val, "ColumnName", &d.ColumnName)
			delete(rawMsg, key)
		case "columnType":
			err = unpopulate(val, "ColumnType", &d.ColumnType)
			delete(rawMsg, key)
		case "dataType":
			err = unpopulate(val, "DataType", &d.DataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataTableResponseObject.
func (d DataTableResponseObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "columns", d.Columns)
	populate(objectMap, "rows", d.Rows)
	populate(objectMap, "tableName", d.TableName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataTableResponseObject.
func (d *DataTableResponseObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "columns":
			err = unpopulate(val, "Columns", &d.Columns)
			delete(rawMsg, key)
		case "rows":
			err = unpopulate(val, "Rows", &d.Rows)
			delete(rawMsg, key)
		case "tableName":
			err = unpopulate(val, "TableName", &d.TableName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabaseBackupSetting.
func (d DatabaseBackupSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionString", d.ConnectionString)
	populate(objectMap, "connectionStringName", d.ConnectionStringName)
	populate(objectMap, "databaseType", d.DatabaseType)
	populate(objectMap, "name", d.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabaseBackupSetting.
func (d *DatabaseBackupSetting) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &d.ConnectionString)
			delete(rawMsg, key)
		case "connectionStringName":
			err = unpopulate(val, "ConnectionStringName", &d.ConnectionStringName)
			delete(rawMsg, key)
		case "databaseType":
			err = unpopulate(val, "DatabaseType", &d.DatabaseType)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabaseConnection.
func (d DatabaseConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "kind", d.Kind)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabaseConnection.
func (d *DatabaseConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &d.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabaseConnectionCollection.
func (d DatabaseConnectionCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabaseConnectionCollection.
func (d *DatabaseConnectionCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabaseConnectionOverview.
func (d DatabaseConnectionOverview) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configurationFiles", d.ConfigurationFiles)
	populate(objectMap, "connectionIdentity", d.ConnectionIdentity)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "region", d.Region)
	populate(objectMap, "resourceId", d.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabaseConnectionOverview.
func (d *DatabaseConnectionOverview) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configurationFiles":
			err = unpopulate(val, "ConfigurationFiles", &d.ConfigurationFiles)
			delete(rawMsg, key)
		case "connectionIdentity":
			err = unpopulate(val, "ConnectionIdentity", &d.ConnectionIdentity)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &d.Region)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &d.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabaseConnectionPatchRequest.
func (d DatabaseConnectionPatchRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", d.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabaseConnectionPatchRequest.
func (d *DatabaseConnectionPatchRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabaseConnectionPatchRequestProperties.
func (d DatabaseConnectionPatchRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionIdentity", d.ConnectionIdentity)
	populate(objectMap, "connectionString", d.ConnectionString)
	populate(objectMap, "region", d.Region)
	populate(objectMap, "resourceId", d.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabaseConnectionPatchRequestProperties.
func (d *DatabaseConnectionPatchRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionIdentity":
			err = unpopulate(val, "ConnectionIdentity", &d.ConnectionIdentity)
			delete(rawMsg, key)
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &d.ConnectionString)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &d.Region)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &d.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabaseConnectionProperties.
func (d DatabaseConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configurationFiles", d.ConfigurationFiles)
	populate(objectMap, "connectionIdentity", d.ConnectionIdentity)
	populate(objectMap, "connectionString", d.ConnectionString)
	populate(objectMap, "region", d.Region)
	populate(objectMap, "resourceId", d.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabaseConnectionProperties.
func (d *DatabaseConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configurationFiles":
			err = unpopulate(val, "ConfigurationFiles", &d.ConfigurationFiles)
			delete(rawMsg, key)
		case "connectionIdentity":
			err = unpopulate(val, "ConnectionIdentity", &d.ConnectionIdentity)
			delete(rawMsg, key)
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &d.ConnectionString)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &d.Region)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &d.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultAuthorizationPolicy.
func (d DefaultAuthorizationPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedApplications", d.AllowedApplications)
	populate(objectMap, "allowedPrincipals", d.AllowedPrincipals)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultAuthorizationPolicy.
func (d *DefaultAuthorizationPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedApplications":
			err = unpopulate(val, "AllowedApplications", &d.AllowedApplications)
			delete(rawMsg, key)
		case "allowedPrincipals":
			err = unpopulate(val, "AllowedPrincipals", &d.AllowedPrincipals)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultErrorResponse.
func (d DefaultErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", d.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultErrorResponse.
func (d *DefaultErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &d.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultErrorResponseError.
func (d DefaultErrorResponseError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", d.Code)
	populate(objectMap, "details", d.Details)
	populate(objectMap, "innererror", d.Innererror)
	populate(objectMap, "message", d.Message)
	populate(objectMap, "target", d.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultErrorResponseError.
func (d *DefaultErrorResponseError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &d.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &d.Details)
			delete(rawMsg, key)
		case "innererror":
			err = unpopulate(val, "Innererror", &d.Innererror)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &d.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &d.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultErrorResponseErrorDetailsItem.
func (d DefaultErrorResponseErrorDetailsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", d.Code)
	populate(objectMap, "message", d.Message)
	populate(objectMap, "target", d.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultErrorResponseErrorDetailsItem.
func (d *DefaultErrorResponseErrorDetailsItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &d.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &d.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &d.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeletedAppRestoreRequest.
func (d DeletedAppRestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "kind", d.Kind)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedAppRestoreRequest.
func (d *DeletedAppRestoreRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &d.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeletedAppRestoreRequestProperties.
func (d DeletedAppRestoreRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deletedSiteId", d.DeletedSiteID)
	populate(objectMap, "recoverConfiguration", d.RecoverConfiguration)
	populate(objectMap, "snapshotTime", d.SnapshotTime)
	populate(objectMap, "useDRSecondary", d.UseDRSecondary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedAppRestoreRequestProperties.
func (d *DeletedAppRestoreRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deletedSiteId":
			err = unpopulate(val, "DeletedSiteID", &d.DeletedSiteID)
			delete(rawMsg, key)
		case "recoverConfiguration":
			err = unpopulate(val, "RecoverConfiguration", &d.RecoverConfiguration)
			delete(rawMsg, key)
		case "snapshotTime":
			err = unpopulate(val, "SnapshotTime", &d.SnapshotTime)
			delete(rawMsg, key)
		case "useDRSecondary":
			err = unpopulate(val, "UseDRSecondary", &d.UseDRSecondary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeletedSite.
func (d DeletedSite) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "kind", d.Kind)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedSite.
func (d *DeletedSite) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &d.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeletedSiteProperties.
func (d DeletedSiteProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deletedSiteId", d.DeletedSiteID)
	populate(objectMap, "deletedSiteName", d.DeletedSiteName)
	populate(objectMap, "deletedTimestamp", d.DeletedTimestamp)
	populate(objectMap, "geoRegionName", d.GeoRegionName)
	populate(objectMap, "kind", d.Kind)
	populate(objectMap, "resourceGroup", d.ResourceGroup)
	populate(objectMap, "slot", d.Slot)
	populate(objectMap, "subscription", d.Subscription)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedSiteProperties.
func (d *DeletedSiteProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deletedSiteId":
			err = unpopulate(val, "DeletedSiteID", &d.DeletedSiteID)
			delete(rawMsg, key)
		case "deletedSiteName":
			err = unpopulate(val, "DeletedSiteName", &d.DeletedSiteName)
			delete(rawMsg, key)
		case "deletedTimestamp":
			err = unpopulate(val, "DeletedTimestamp", &d.DeletedTimestamp)
			delete(rawMsg, key)
		case "geoRegionName":
			err = unpopulate(val, "GeoRegionName", &d.GeoRegionName)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &d.Kind)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &d.ResourceGroup)
			delete(rawMsg, key)
		case "slot":
			err = unpopulate(val, "Slot", &d.Slot)
			delete(rawMsg, key)
		case "subscription":
			err = unpopulate(val, "Subscription", &d.Subscription)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeletedWebAppCollection.
func (d DeletedWebAppCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedWebAppCollection.
func (d *DeletedWebAppCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Deployment.
func (d Deployment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "kind", d.Kind)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Deployment.
func (d *Deployment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &d.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeploymentCollection.
func (d DeploymentCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeploymentCollection.
func (d *DeploymentCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeploymentLocations.
func (d DeploymentLocations) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hostingEnvironmentDeploymentInfos", d.HostingEnvironmentDeploymentInfos)
	populate(objectMap, "hostingEnvironments", d.HostingEnvironments)
	populate(objectMap, "locations", d.Locations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeploymentLocations.
func (d *DeploymentLocations) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hostingEnvironmentDeploymentInfos":
			err = unpopulate(val, "HostingEnvironmentDeploymentInfos", &d.HostingEnvironmentDeploymentInfos)
			delete(rawMsg, key)
		case "hostingEnvironments":
			err = unpopulate(val, "HostingEnvironments", &d.HostingEnvironments)
			delete(rawMsg, key)
		case "locations":
			err = unpopulate(val, "Locations", &d.Locations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeploymentProperties.
func (d DeploymentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "active", d.Active)
	populate(objectMap, "author", d.Author)
	populate(objectMap, "author_email", d.AuthorEmail)
	populate(objectMap, "deployer", d.Deployer)
	populate(objectMap, "details", d.Details)
	populateDateTimeRFC3339(objectMap, "end_time", d.EndTime)
	populate(objectMap, "message", d.Message)
	populateDateTimeRFC3339(objectMap, "start_time", d.StartTime)
	populate(objectMap, "status", d.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeploymentProperties.
func (d *DeploymentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "active":
			err = unpopulate(val, "Active", &d.Active)
			delete(rawMsg, key)
		case "author":
			err = unpopulate(val, "Author", &d.Author)
			delete(rawMsg, key)
		case "author_email":
			err = unpopulate(val, "AuthorEmail", &d.AuthorEmail)
			delete(rawMsg, key)
		case "deployer":
			err = unpopulate(val, "Deployer", &d.Deployer)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &d.Details)
			delete(rawMsg, key)
		case "end_time":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &d.EndTime)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &d.Message)
			delete(rawMsg, key)
		case "start_time":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &d.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DetectorAbnormalTimePeriod.
func (d DetectorAbnormalTimePeriod) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "endTime", d.EndTime)
	populate(objectMap, "message", d.Message)
	populate(objectMap, "metaData", d.MetaData)
	populate(objectMap, "priority", d.Priority)
	populate(objectMap, "solutions", d.Solutions)
	populate(objectMap, "source", d.Source)
	populateDateTimeRFC3339(objectMap, "startTime", d.StartTime)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DetectorAbnormalTimePeriod.
func (d *DetectorAbnormalTimePeriod) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &d.EndTime)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &d.Message)
			delete(rawMsg, key)
		case "metaData":
			err = unpopulate(val, "MetaData", &d.MetaData)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &d.Priority)
			delete(rawMsg, key)
		case "solutions":
			err = unpopulate(val, "Solutions", &d.Solutions)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &d.Source)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &d.StartTime)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DetectorDefinition.
func (d DetectorDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "displayName", d.DisplayName)
	populate(objectMap, "isEnabled", d.IsEnabled)
	populate(objectMap, "rank", d.Rank)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DetectorDefinition.
func (d *DetectorDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &d.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &d.IsEnabled)
			delete(rawMsg, key)
		case "rank":
			err = unpopulate(val, "Rank", &d.Rank)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DetectorDefinitionResource.
func (d DetectorDefinitionResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "kind", d.Kind)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DetectorDefinitionResource.
func (d *DetectorDefinitionResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &d.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DetectorInfo.
func (d DetectorInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "analysisType", d.AnalysisType)
	populate(objectMap, "author", d.Author)
	populate(objectMap, "category", d.Category)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "score", d.Score)
	populate(objectMap, "supportTopicList", d.SupportTopicList)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DetectorInfo.
func (d *DetectorInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "analysisType":
			err = unpopulate(val, "AnalysisType", &d.AnalysisType)
			delete(rawMsg, key)
		case "author":
			err = unpopulate(val, "Author", &d.Author)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &d.Category)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "score":
			err = unpopulate(val, "Score", &d.Score)
			delete(rawMsg, key)
		case "supportTopicList":
			err = unpopulate(val, "SupportTopicList", &d.SupportTopicList)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DetectorResponse.
func (d DetectorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "kind", d.Kind)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DetectorResponse.
func (d *DetectorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &d.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DetectorResponseCollection.
func (d DetectorResponseCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DetectorResponseCollection.
func (d *DetectorResponseCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DetectorResponseProperties.
func (d DetectorResponseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataProvidersMetadata", d.DataProvidersMetadata)
	populate(objectMap, "dataset", d.Dataset)
	populate(objectMap, "metadata", d.Metadata)
	populate(objectMap, "status", d.Status)
	populate(objectMap, "suggestedUtterances", d.SuggestedUtterances)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DetectorResponseProperties.
func (d *DetectorResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataProvidersMetadata":
			err = unpopulate(val, "DataProvidersMetadata", &d.DataProvidersMetadata)
			delete(rawMsg, key)
		case "dataset":
			err = unpopulate(val, "Dataset", &d.Dataset)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &d.Metadata)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		case "suggestedUtterances":
			err = unpopulate(val, "SuggestedUtterances", &d.SuggestedUtterances)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticAnalysis.
func (d DiagnosticAnalysis) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "kind", d.Kind)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticAnalysis.
func (d *DiagnosticAnalysis) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &d.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticAnalysisCollection.
func (d DiagnosticAnalysisCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticAnalysisCollection.
func (d *DiagnosticAnalysisCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticAnalysisProperties.
func (d DiagnosticAnalysisProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "abnormalTimePeriods", d.AbnormalTimePeriods)
	populateDateTimeRFC3339(objectMap, "endTime", d.EndTime)
	populate(objectMap, "nonCorrelatedDetectors", d.NonCorrelatedDetectors)
	populate(objectMap, "payload", d.Payload)
	populateDateTimeRFC3339(objectMap, "startTime", d.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticAnalysisProperties.
func (d *DiagnosticAnalysisProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "abnormalTimePeriods":
			err = unpopulate(val, "AbnormalTimePeriods", &d.AbnormalTimePeriods)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &d.EndTime)
			delete(rawMsg, key)
		case "nonCorrelatedDetectors":
			err = unpopulate(val, "NonCorrelatedDetectors", &d.NonCorrelatedDetectors)
			delete(rawMsg, key)
		case "payload":
			err = unpopulate(val, "Payload", &d.Payload)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &d.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticCategory.
func (d DiagnosticCategory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "kind", d.Kind)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticCategory.
func (d *DiagnosticCategory) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &d.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticCategoryCollection.
func (d DiagnosticCategoryCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticCategoryCollection.
func (d *DiagnosticCategoryCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticCategoryProperties.
func (d DiagnosticCategoryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", d.Description)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticCategoryProperties.
func (d *DiagnosticCategoryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticData.
func (d DiagnosticData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "renderingProperties", d.RenderingProperties)
	populate(objectMap, "table", d.Table)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticData.
func (d *DiagnosticData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "renderingProperties":
			err = unpopulate(val, "RenderingProperties", &d.RenderingProperties)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &d.Table)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticDetectorCollection.
func (d DiagnosticDetectorCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticDetectorCollection.
func (d *DiagnosticDetectorCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticDetectorResponse.
func (d DiagnosticDetectorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "kind", d.Kind)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticDetectorResponse.
func (d *DiagnosticDetectorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &d.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticDetectorResponseProperties.
func (d DiagnosticDetectorResponseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "abnormalTimePeriods", d.AbnormalTimePeriods)
	populate(objectMap, "data", d.Data)
	populate(objectMap, "detectorDefinition", d.DetectorDefinition)
	populateDateTimeRFC3339(objectMap, "endTime", d.EndTime)
	populate(objectMap, "issueDetected", d.IssueDetected)
	populate(objectMap, "metrics", d.Metrics)
	populate(objectMap, "responseMetaData", d.ResponseMetaData)
	populateDateTimeRFC3339(objectMap, "startTime", d.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticDetectorResponseProperties.
func (d *DiagnosticDetectorResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "abnormalTimePeriods":
			err = unpopulate(val, "AbnormalTimePeriods", &d.AbnormalTimePeriods)
			delete(rawMsg, key)
		case "data":
			err = unpopulate(val, "Data", &d.Data)
			delete(rawMsg, key)
		case "detectorDefinition":
			err = unpopulate(val, "DetectorDefinition", &d.DetectorDefinition)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &d.EndTime)
			delete(rawMsg, key)
		case "issueDetected":
			err = unpopulate(val, "IssueDetected", &d.IssueDetected)
			delete(rawMsg, key)
		case "metrics":
			err = unpopulate(val, "Metrics", &d.Metrics)
			delete(rawMsg, key)
		case "responseMetaData":
			err = unpopulate(val, "ResponseMetaData", &d.ResponseMetaData)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &d.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticMetricSample.
func (d DiagnosticMetricSample) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isAggregated", d.IsAggregated)
	populate(objectMap, "maximum", d.Maximum)
	populate(objectMap, "minimum", d.Minimum)
	populate(objectMap, "roleInstance", d.RoleInstance)
	populateDateTimeRFC3339(objectMap, "timestamp", d.Timestamp)
	populate(objectMap, "total", d.Total)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticMetricSample.
func (d *DiagnosticMetricSample) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isAggregated":
			err = unpopulate(val, "IsAggregated", &d.IsAggregated)
			delete(rawMsg, key)
		case "maximum":
			err = unpopulate(val, "Maximum", &d.Maximum)
			delete(rawMsg, key)
		case "minimum":
			err = unpopulate(val, "Minimum", &d.Minimum)
			delete(rawMsg, key)
		case "roleInstance":
			err = unpopulate(val, "RoleInstance", &d.RoleInstance)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &d.Timestamp)
			delete(rawMsg, key)
		case "total":
			err = unpopulate(val, "Total", &d.Total)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticMetricSet.
func (d DiagnosticMetricSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "endTime", d.EndTime)
	populate(objectMap, "name", d.Name)
	populateDateTimeRFC3339(objectMap, "startTime", d.StartTime)
	populate(objectMap, "timeGrain", d.TimeGrain)
	populate(objectMap, "unit", d.Unit)
	populate(objectMap, "values", d.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticMetricSet.
func (d *DiagnosticMetricSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &d.EndTime)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &d.StartTime)
			delete(rawMsg, key)
		case "timeGrain":
			err = unpopulate(val, "TimeGrain", &d.TimeGrain)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &d.Unit)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &d.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Dimension.
func (d Dimension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", d.DisplayName)
	populate(objectMap, "internalName", d.InternalName)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "toBeExportedForShoebox", d.ToBeExportedForShoebox)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Dimension.
func (d *Dimension) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &d.DisplayName)
			delete(rawMsg, key)
		case "internalName":
			err = unpopulate(val, "InternalName", &d.InternalName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "toBeExportedForShoebox":
			err = unpopulate(val, "ToBeExportedForShoebox", &d.ToBeExportedForShoebox)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Domain.
func (d Domain) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "kind", d.Kind)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Domain.
func (d *Domain) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &d.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DomainAvailabilityCheckResult.
func (d DomainAvailabilityCheckResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "available", d.Available)
	populate(objectMap, "domainType", d.DomainType)
	populate(objectMap, "name", d.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DomainAvailabilityCheckResult.
func (d *DomainAvailabilityCheckResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "available":
			err = unpopulate(val, "Available", &d.Available)
			delete(rawMsg, key)
		case "domainType":
			err = unpopulate(val, "DomainType", &d.DomainType)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DomainCollection.
func (d DomainCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DomainCollection.
func (d *DomainCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DomainControlCenterSsoRequest.
func (d DomainControlCenterSsoRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "postParameterKey", d.PostParameterKey)
	populate(objectMap, "postParameterValue", d.PostParameterValue)
	populate(objectMap, "url", d.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DomainControlCenterSsoRequest.
func (d *DomainControlCenterSsoRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "postParameterKey":
			err = unpopulate(val, "PostParameterKey", &d.PostParameterKey)
			delete(rawMsg, key)
		case "postParameterValue":
			err = unpopulate(val, "PostParameterValue", &d.PostParameterValue)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &d.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DomainOwnershipIdentifier.
func (d DomainOwnershipIdentifier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "kind", d.Kind)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DomainOwnershipIdentifier.
func (d *DomainOwnershipIdentifier) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &d.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DomainOwnershipIdentifierCollection.
func (d DomainOwnershipIdentifierCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DomainOwnershipIdentifierCollection.
func (d *DomainOwnershipIdentifierCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DomainOwnershipIdentifierProperties.
func (d DomainOwnershipIdentifierProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ownershipId", d.OwnershipID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DomainOwnershipIdentifierProperties.
func (d *DomainOwnershipIdentifierProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ownershipId":
			err = unpopulate(val, "OwnershipID", &d.OwnershipID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DomainPatchResource.
func (d DomainPatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "kind", d.Kind)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DomainPatchResource.
func (d *DomainPatchResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &d.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DomainPatchResourceProperties.
func (d DomainPatchResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authCode", d.AuthCode)
	populate(objectMap, "autoRenew", d.AutoRenew)
	populate(objectMap, "consent", d.Consent)
	populate(objectMap, "contactAdmin", d.ContactAdmin)
	populate(objectMap, "contactBilling", d.ContactBilling)
	populate(objectMap, "contactRegistrant", d.ContactRegistrant)
	populate(objectMap, "contactTech", d.ContactTech)
	populateDateTimeRFC3339(objectMap, "createdTime", d.CreatedTime)
	populate(objectMap, "dnsType", d.DNSType)
	populate(objectMap, "dnsZoneId", d.DNSZoneID)
	populate(objectMap, "domainNotRenewableReasons", d.DomainNotRenewableReasons)
	populateDateTimeRFC3339(objectMap, "expirationTime", d.ExpirationTime)
	populateDateTimeRFC3339(objectMap, "lastRenewedTime", d.LastRenewedTime)
	populate(objectMap, "managedHostNames", d.ManagedHostNames)
	populate(objectMap, "nameServers", d.NameServers)
	populate(objectMap, "privacy", d.Privacy)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "readyForDnsRecordManagement", d.ReadyForDNSRecordManagement)
	populate(objectMap, "registrationStatus", d.RegistrationStatus)
	populate(objectMap, "targetDnsType", d.TargetDNSType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DomainPatchResourceProperties.
func (d *DomainPatchResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authCode":
			err = unpopulate(val, "AuthCode", &d.AuthCode)
			delete(rawMsg, key)
		case "autoRenew":
			err = unpopulate(val, "AutoRenew", &d.AutoRenew)
			delete(rawMsg, key)
		case "consent":
			err = unpopulate(val, "Consent", &d.Consent)
			delete(rawMsg, key)
		case "contactAdmin":
			err = unpopulate(val, "ContactAdmin", &d.ContactAdmin)
			delete(rawMsg, key)
		case "contactBilling":
			err = unpopulate(val, "ContactBilling", &d.ContactBilling)
			delete(rawMsg, key)
		case "contactRegistrant":
			err = unpopulate(val, "ContactRegistrant", &d.ContactRegistrant)
			delete(rawMsg, key)
		case "contactTech":
			err = unpopulate(val, "ContactTech", &d.ContactTech)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedTime", &d.CreatedTime)
			delete(rawMsg, key)
		case "dnsType":
			err = unpopulate(val, "DNSType", &d.DNSType)
			delete(rawMsg, key)
		case "dnsZoneId":
			err = unpopulate(val, "DNSZoneID", &d.DNSZoneID)
			delete(rawMsg, key)
		case "domainNotRenewableReasons":
			err = unpopulate(val, "DomainNotRenewableReasons", &d.DomainNotRenewableReasons)
			delete(rawMsg, key)
		case "expirationTime":
			err = unpopulateDateTimeRFC3339(val, "ExpirationTime", &d.ExpirationTime)
			delete(rawMsg, key)
		case "lastRenewedTime":
			err = unpopulateDateTimeRFC3339(val, "LastRenewedTime", &d.LastRenewedTime)
			delete(rawMsg, key)
		case "managedHostNames":
			err = unpopulate(val, "ManagedHostNames", &d.ManagedHostNames)
			delete(rawMsg, key)
		case "nameServers":
			err = unpopulate(val, "NameServers", &d.NameServers)
			delete(rawMsg, key)
		case "privacy":
			err = unpopulate(val, "Privacy", &d.Privacy)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "readyForDnsRecordManagement":
			err = unpopulate(val, "ReadyForDNSRecordManagement", &d.ReadyForDNSRecordManagement)
			delete(rawMsg, key)
		case "registrationStatus":
			err = unpopulate(val, "RegistrationStatus", &d.RegistrationStatus)
			delete(rawMsg, key)
		case "targetDnsType":
			err = unpopulate(val, "TargetDNSType", &d.TargetDNSType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DomainProperties.
func (d DomainProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authCode", d.AuthCode)
	populate(objectMap, "autoRenew", d.AutoRenew)
	populate(objectMap, "consent", d.Consent)
	populate(objectMap, "contactAdmin", d.ContactAdmin)
	populate(objectMap, "contactBilling", d.ContactBilling)
	populate(objectMap, "contactRegistrant", d.ContactRegistrant)
	populate(objectMap, "contactTech", d.ContactTech)
	populateDateTimeRFC3339(objectMap, "createdTime", d.CreatedTime)
	populate(objectMap, "dnsType", d.DNSType)
	populate(objectMap, "dnsZoneId", d.DNSZoneID)
	populate(objectMap, "domainNotRenewableReasons", d.DomainNotRenewableReasons)
	populateDateTimeRFC3339(objectMap, "expirationTime", d.ExpirationTime)
	populateDateTimeRFC3339(objectMap, "lastRenewedTime", d.LastRenewedTime)
	populate(objectMap, "managedHostNames", d.ManagedHostNames)
	populate(objectMap, "nameServers", d.NameServers)
	populate(objectMap, "privacy", d.Privacy)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "readyForDnsRecordManagement", d.ReadyForDNSRecordManagement)
	populate(objectMap, "registrationStatus", d.RegistrationStatus)
	populate(objectMap, "targetDnsType", d.TargetDNSType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DomainProperties.
func (d *DomainProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authCode":
			err = unpopulate(val, "AuthCode", &d.AuthCode)
			delete(rawMsg, key)
		case "autoRenew":
			err = unpopulate(val, "AutoRenew", &d.AutoRenew)
			delete(rawMsg, key)
		case "consent":
			err = unpopulate(val, "Consent", &d.Consent)
			delete(rawMsg, key)
		case "contactAdmin":
			err = unpopulate(val, "ContactAdmin", &d.ContactAdmin)
			delete(rawMsg, key)
		case "contactBilling":
			err = unpopulate(val, "ContactBilling", &d.ContactBilling)
			delete(rawMsg, key)
		case "contactRegistrant":
			err = unpopulate(val, "ContactRegistrant", &d.ContactRegistrant)
			delete(rawMsg, key)
		case "contactTech":
			err = unpopulate(val, "ContactTech", &d.ContactTech)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedTime", &d.CreatedTime)
			delete(rawMsg, key)
		case "dnsType":
			err = unpopulate(val, "DNSType", &d.DNSType)
			delete(rawMsg, key)
		case "dnsZoneId":
			err = unpopulate(val, "DNSZoneID", &d.DNSZoneID)
			delete(rawMsg, key)
		case "domainNotRenewableReasons":
			err = unpopulate(val, "DomainNotRenewableReasons", &d.DomainNotRenewableReasons)
			delete(rawMsg, key)
		case "expirationTime":
			err = unpopulateDateTimeRFC3339(val, "ExpirationTime", &d.ExpirationTime)
			delete(rawMsg, key)
		case "lastRenewedTime":
			err = unpopulateDateTimeRFC3339(val, "LastRenewedTime", &d.LastRenewedTime)
			delete(rawMsg, key)
		case "managedHostNames":
			err = unpopulate(val, "ManagedHostNames", &d.ManagedHostNames)
			delete(rawMsg, key)
		case "nameServers":
			err = unpopulate(val, "NameServers", &d.NameServers)
			delete(rawMsg, key)
		case "privacy":
			err = unpopulate(val, "Privacy", &d.Privacy)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "readyForDnsRecordManagement":
			err = unpopulate(val, "ReadyForDNSRecordManagement", &d.ReadyForDNSRecordManagement)
			delete(rawMsg, key)
		case "registrationStatus":
			err = unpopulate(val, "RegistrationStatus", &d.RegistrationStatus)
			delete(rawMsg, key)
		case "targetDnsType":
			err = unpopulate(val, "TargetDNSType", &d.TargetDNSType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DomainPurchaseConsent.
func (d DomainPurchaseConsent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "agreedAt", d.AgreedAt)
	populate(objectMap, "agreedBy", d.AgreedBy)
	populate(objectMap, "agreementKeys", d.AgreementKeys)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DomainPurchaseConsent.
func (d *DomainPurchaseConsent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agreedAt":
			err = unpopulateDateTimeRFC3339(val, "AgreedAt", &d.AgreedAt)
			delete(rawMsg, key)
		case "agreedBy":
			err = unpopulate(val, "AgreedBy", &d.AgreedBy)
			delete(rawMsg, key)
		case "agreementKeys":
			err = unpopulate(val, "AgreementKeys", &d.AgreementKeys)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DomainRecommendationSearchParameters.
func (d DomainRecommendationSearchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keywords", d.Keywords)
	populate(objectMap, "maxDomainRecommendations", d.MaxDomainRecommendations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DomainRecommendationSearchParameters.
func (d *DomainRecommendationSearchParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keywords":
			err = unpopulate(val, "Keywords", &d.Keywords)
			delete(rawMsg, key)
		case "maxDomainRecommendations":
			err = unpopulate(val, "MaxDomainRecommendations", &d.MaxDomainRecommendations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnabledConfig.
func (e EnabledConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", e.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnabledConfig.
func (e *EnabledConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &e.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointDependency.
func (e EndpointDependency) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "domainName", e.DomainName)
	populate(objectMap, "endpointDetails", e.EndpointDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointDependency.
func (e *EndpointDependency) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "domainName":
			err = unpopulate(val, "DomainName", &e.DomainName)
			delete(rawMsg, key)
		case "endpointDetails":
			err = unpopulate(val, "EndpointDetails", &e.EndpointDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointDetail.
func (e EndpointDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipAddress", e.IPAddress)
	populate(objectMap, "isAccessible", e.IsAccessible)
	populate(objectMap, "latency", e.Latency)
	populate(objectMap, "port", e.Port)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointDetail.
func (e *EndpointDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &e.IPAddress)
			delete(rawMsg, key)
		case "isAccessible":
			err = unpopulate(val, "IsAccessible", &e.IsAccessible)
			delete(rawMsg, key)
		case "latency":
			err = unpopulate(val, "Latency", &e.Latency)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &e.Port)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Environment.
func (e Environment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clusterSettings", e.ClusterSettings)
	populate(objectMap, "customDnsSuffixConfiguration", e.CustomDNSSuffixConfiguration)
	populate(objectMap, "dnsSuffix", e.DNSSuffix)
	populate(objectMap, "dedicatedHostCount", e.DedicatedHostCount)
	populate(objectMap, "frontEndScaleFactor", e.FrontEndScaleFactor)
	populate(objectMap, "hasLinuxWorkers", e.HasLinuxWorkers)
	populate(objectMap, "internalLoadBalancingMode", e.InternalLoadBalancingMode)
	populate(objectMap, "ipsslAddressCount", e.IpsslAddressCount)
	populate(objectMap, "maximumNumberOfMachines", e.MaximumNumberOfMachines)
	populate(objectMap, "multiRoleCount", e.MultiRoleCount)
	populate(objectMap, "multiSize", e.MultiSize)
	populate(objectMap, "networkingConfiguration", e.NetworkingConfiguration)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "status", e.Status)
	populate(objectMap, "suspended", e.Suspended)
	populate(objectMap, "upgradeAvailability", e.UpgradeAvailability)
	populate(objectMap, "upgradePreference", e.UpgradePreference)
	populate(objectMap, "userWhitelistedIpRanges", e.UserWhitelistedIPRanges)
	populate(objectMap, "virtualNetwork", e.VirtualNetwork)
	populate(objectMap, "zoneRedundant", e.ZoneRedundant)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Environment.
func (e *Environment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clusterSettings":
			err = unpopulate(val, "ClusterSettings", &e.ClusterSettings)
			delete(rawMsg, key)
		case "customDnsSuffixConfiguration":
			err = unpopulate(val, "CustomDNSSuffixConfiguration", &e.CustomDNSSuffixConfiguration)
			delete(rawMsg, key)
		case "dnsSuffix":
			err = unpopulate(val, "DNSSuffix", &e.DNSSuffix)
			delete(rawMsg, key)
		case "dedicatedHostCount":
			err = unpopulate(val, "DedicatedHostCount", &e.DedicatedHostCount)
			delete(rawMsg, key)
		case "frontEndScaleFactor":
			err = unpopulate(val, "FrontEndScaleFactor", &e.FrontEndScaleFactor)
			delete(rawMsg, key)
		case "hasLinuxWorkers":
			err = unpopulate(val, "HasLinuxWorkers", &e.HasLinuxWorkers)
			delete(rawMsg, key)
		case "internalLoadBalancingMode":
			err = unpopulate(val, "InternalLoadBalancingMode", &e.InternalLoadBalancingMode)
			delete(rawMsg, key)
		case "ipsslAddressCount":
			err = unpopulate(val, "IpsslAddressCount", &e.IpsslAddressCount)
			delete(rawMsg, key)
		case "maximumNumberOfMachines":
			err = unpopulate(val, "MaximumNumberOfMachines", &e.MaximumNumberOfMachines)
			delete(rawMsg, key)
		case "multiRoleCount":
			err = unpopulate(val, "MultiRoleCount", &e.MultiRoleCount)
			delete(rawMsg, key)
		case "multiSize":
			err = unpopulate(val, "MultiSize", &e.MultiSize)
			delete(rawMsg, key)
		case "networkingConfiguration":
			err = unpopulate(val, "NetworkingConfiguration", &e.NetworkingConfiguration)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &e.Status)
			delete(rawMsg, key)
		case "suspended":
			err = unpopulate(val, "Suspended", &e.Suspended)
			delete(rawMsg, key)
		case "upgradeAvailability":
			err = unpopulate(val, "UpgradeAvailability", &e.UpgradeAvailability)
			delete(rawMsg, key)
		case "upgradePreference":
			err = unpopulate(val, "UpgradePreference", &e.UpgradePreference)
			delete(rawMsg, key)
		case "userWhitelistedIpRanges":
			err = unpopulate(val, "UserWhitelistedIPRanges", &e.UserWhitelistedIPRanges)
			delete(rawMsg, key)
		case "virtualNetwork":
			err = unpopulate(val, "VirtualNetwork", &e.VirtualNetwork)
			delete(rawMsg, key)
		case "zoneRedundant":
			err = unpopulate(val, "ZoneRedundant", &e.ZoneRedundant)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentCollection.
func (e EnvironmentCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentCollection.
func (e *EnvironmentCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentPatchResource.
func (e EnvironmentPatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "kind", e.Kind)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentPatchResource.
func (e *EnvironmentPatchResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &e.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentResource.
func (e EnvironmentResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "kind", e.Kind)
	populate(objectMap, "location", e.Location)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "tags", e.Tags)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentResource.
func (e *EnvironmentResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &e.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &e.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentVar.
func (e EnvironmentVar) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "secretRef", e.SecretRef)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentVar.
func (e *EnvironmentVar) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "secretRef":
			err = unpopulate(val, "SecretRef", &e.SecretRef)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorEntity.
func (e ErrorEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "extendedCode", e.ExtendedCode)
	populate(objectMap, "innerErrors", e.InnerErrors)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "messageTemplate", e.MessageTemplate)
	populate(objectMap, "parameters", e.Parameters)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorEntity.
func (e *ErrorEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "extendedCode":
			err = unpopulate(val, "ExtendedCode", &e.ExtendedCode)
			delete(rawMsg, key)
		case "innerErrors":
			err = unpopulate(val, "InnerErrors", &e.InnerErrors)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "messageTemplate":
			err = unpopulate(val, "MessageTemplate", &e.MessageTemplate)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &e.Parameters)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorInfo.
func (e ErrorInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorInfo.
func (e *ErrorInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorProperties.
func (e ErrorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorProperties.
func (e *ErrorProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Experiments.
func (e Experiments) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "rampUpRules", e.RampUpRules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Experiments.
func (e *Experiments) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "rampUpRules":
			err = unpopulate(val, "RampUpRules", &e.RampUpRules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Expression.
func (e Expression) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	populate(objectMap, "subexpressions", e.Subexpressions)
	populate(objectMap, "text", e.Text)
	populateAny(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Expression.
func (e *Expression) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		case "subexpressions":
			err = unpopulate(val, "Subexpressions", &e.Subexpressions)
			delete(rawMsg, key)
		case "text":
			err = unpopulate(val, "Text", &e.Text)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressionRoot.
func (e ExpressionRoot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	populate(objectMap, "path", e.Path)
	populate(objectMap, "subexpressions", e.Subexpressions)
	populate(objectMap, "text", e.Text)
	populateAny(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressionRoot.
func (e *ExpressionRoot) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &e.Path)
			delete(rawMsg, key)
		case "subexpressions":
			err = unpopulate(val, "Subexpressions", &e.Subexpressions)
			delete(rawMsg, key)
		case "text":
			err = unpopulate(val, "Text", &e.Text)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressionTraces.
func (e ExpressionTraces) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "inputs", e.Inputs)
	populate(objectMap, "nextLink", e.NextLink)
	populateAny(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressionTraces.
func (e *ExpressionTraces) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inputs":
			err = unpopulate(val, "Inputs", &e.Inputs)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedLocation.
func (e ExtendedLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtendedLocation.
func (e *ExtendedLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Facebook.
func (f Facebook) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", f.Enabled)
	populate(objectMap, "graphApiVersion", f.GraphAPIVersion)
	populate(objectMap, "login", f.Login)
	populate(objectMap, "registration", f.Registration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Facebook.
func (f *Facebook) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &f.Enabled)
			delete(rawMsg, key)
		case "graphApiVersion":
			err = unpopulate(val, "GraphAPIVersion", &f.GraphAPIVersion)
			delete(rawMsg, key)
		case "login":
			err = unpopulate(val, "Login", &f.Login)
			delete(rawMsg, key)
		case "registration":
			err = unpopulate(val, "Registration", &f.Registration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileSystemApplicationLogsConfig.
func (f FileSystemApplicationLogsConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "level", f.Level)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileSystemApplicationLogsConfig.
func (f *FileSystemApplicationLogsConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "level":
			err = unpopulate(val, "Level", &f.Level)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileSystemHTTPLogsConfig.
func (f FileSystemHTTPLogsConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", f.Enabled)
	populate(objectMap, "retentionInDays", f.RetentionInDays)
	populate(objectMap, "retentionInMb", f.RetentionInMb)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileSystemHTTPLogsConfig.
func (f *FileSystemHTTPLogsConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &f.Enabled)
			delete(rawMsg, key)
		case "retentionInDays":
			err = unpopulate(val, "RetentionInDays", &f.RetentionInDays)
			delete(rawMsg, key)
		case "retentionInMb":
			err = unpopulate(val, "RetentionInMb", &f.RetentionInMb)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileSystemTokenStore.
func (f FileSystemTokenStore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "directory", f.Directory)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileSystemTokenStore.
func (f *FileSystemTokenStore) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "directory":
			err = unpopulate(val, "Directory", &f.Directory)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FlowAccessControlConfiguration.
func (f FlowAccessControlConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actions", f.Actions)
	populate(objectMap, "contents", f.Contents)
	populate(objectMap, "triggers", f.Triggers)
	populate(objectMap, "workflowManagement", f.WorkflowManagement)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FlowAccessControlConfiguration.
func (f *FlowAccessControlConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, "Actions", &f.Actions)
			delete(rawMsg, key)
		case "contents":
			err = unpopulate(val, "Contents", &f.Contents)
			delete(rawMsg, key)
		case "triggers":
			err = unpopulate(val, "Triggers", &f.Triggers)
			delete(rawMsg, key)
		case "workflowManagement":
			err = unpopulate(val, "WorkflowManagement", &f.WorkflowManagement)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FlowAccessControlConfigurationPolicy.
func (f FlowAccessControlConfigurationPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedCallerIpAddresses", f.AllowedCallerIPAddresses)
	populate(objectMap, "openAuthenticationPolicies", f.OpenAuthenticationPolicies)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FlowAccessControlConfigurationPolicy.
func (f *FlowAccessControlConfigurationPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedCallerIpAddresses":
			err = unpopulate(val, "AllowedCallerIPAddresses", &f.AllowedCallerIPAddresses)
			delete(rawMsg, key)
		case "openAuthenticationPolicies":
			err = unpopulate(val, "OpenAuthenticationPolicies", &f.OpenAuthenticationPolicies)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FlowEndpoints.
func (f FlowEndpoints) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessEndpointIpAddresses", f.AccessEndpointIPAddresses)
	populate(objectMap, "outgoingIpAddresses", f.OutgoingIPAddresses)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FlowEndpoints.
func (f *FlowEndpoints) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessEndpointIpAddresses":
			err = unpopulate(val, "AccessEndpointIPAddresses", &f.AccessEndpointIPAddresses)
			delete(rawMsg, key)
		case "outgoingIpAddresses":
			err = unpopulate(val, "OutgoingIPAddresses", &f.OutgoingIPAddresses)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FlowEndpointsConfiguration.
func (f FlowEndpointsConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connector", f.Connector)
	populate(objectMap, "workflow", f.Workflow)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FlowEndpointsConfiguration.
func (f *FlowEndpointsConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connector":
			err = unpopulate(val, "Connector", &f.Connector)
			delete(rawMsg, key)
		case "workflow":
			err = unpopulate(val, "Workflow", &f.Workflow)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ForwardProxy.
func (f ForwardProxy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "convention", f.Convention)
	populate(objectMap, "customHostHeaderName", f.CustomHostHeaderName)
	populate(objectMap, "customProtoHeaderName", f.CustomProtoHeaderName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ForwardProxy.
func (f *ForwardProxy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "convention":
			err = unpopulate(val, "Convention", &f.Convention)
			delete(rawMsg, key)
		case "customHostHeaderName":
			err = unpopulate(val, "CustomHostHeaderName", &f.CustomHostHeaderName)
			delete(rawMsg, key)
		case "customProtoHeaderName":
			err = unpopulate(val, "CustomProtoHeaderName", &f.CustomProtoHeaderName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FrontEndConfiguration.
func (f FrontEndConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "kind", f.Kind)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FrontEndConfiguration.
func (f *FrontEndConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &f.Kind)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionAppMajorVersion.
func (f FunctionAppMajorVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayText", f.DisplayText)
	populate(objectMap, "minorVersions", f.MinorVersions)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionAppMajorVersion.
func (f *FunctionAppMajorVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayText":
			err = unpopulate(val, "DisplayText", &f.DisplayText)
			delete(rawMsg, key)
		case "minorVersions":
			err = unpopulate(val, "MinorVersions", &f.MinorVersions)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionAppMinorVersion.
func (f FunctionAppMinorVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayText", f.DisplayText)
	populate(objectMap, "stackSettings", f.StackSettings)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionAppMinorVersion.
func (f *FunctionAppMinorVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayText":
			err = unpopulate(val, "DisplayText", &f.DisplayText)
			delete(rawMsg, key)
		case "stackSettings":
			err = unpopulate(val, "StackSettings", &f.StackSettings)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionAppRuntimeSettings.
func (f FunctionAppRuntimeSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appInsightsSettings", f.AppInsightsSettings)
	populate(objectMap, "appSettingsDictionary", f.AppSettingsDictionary)
	populateDateTimeRFC3339(objectMap, "endOfLifeDate", f.EndOfLifeDate)
	populate(objectMap, "gitHubActionSettings", f.GitHubActionSettings)
	populate(objectMap, "isAutoUpdate", f.IsAutoUpdate)
	populate(objectMap, "isDefault", f.IsDefault)
	populate(objectMap, "isDeprecated", f.IsDeprecated)
	populate(objectMap, "isEarlyAccess", f.IsEarlyAccess)
	populate(objectMap, "isHidden", f.IsHidden)
	populate(objectMap, "isPreview", f.IsPreview)
	populate(objectMap, "remoteDebuggingSupported", f.RemoteDebuggingSupported)
	populate(objectMap, "runtimeVersion", f.RuntimeVersion)
	populate(objectMap, "siteConfigPropertiesDictionary", f.SiteConfigPropertiesDictionary)
	populate(objectMap, "supportedFunctionsExtensionVersions", f.SupportedFunctionsExtensionVersions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionAppRuntimeSettings.
func (f *FunctionAppRuntimeSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appInsightsSettings":
			err = unpopulate(val, "AppInsightsSettings", &f.AppInsightsSettings)
			delete(rawMsg, key)
		case "appSettingsDictionary":
			err = unpopulate(val, "AppSettingsDictionary", &f.AppSettingsDictionary)
			delete(rawMsg, key)
		case "endOfLifeDate":
			err = unpopulateDateTimeRFC3339(val, "EndOfLifeDate", &f.EndOfLifeDate)
			delete(rawMsg, key)
		case "gitHubActionSettings":
			err = unpopulate(val, "GitHubActionSettings", &f.GitHubActionSettings)
			delete(rawMsg, key)
		case "isAutoUpdate":
			err = unpopulate(val, "IsAutoUpdate", &f.IsAutoUpdate)
			delete(rawMsg, key)
		case "isDefault":
			err = unpopulate(val, "IsDefault", &f.IsDefault)
			delete(rawMsg, key)
		case "isDeprecated":
			err = unpopulate(val, "IsDeprecated", &f.IsDeprecated)
			delete(rawMsg, key)
		case "isEarlyAccess":
			err = unpopulate(val, "IsEarlyAccess", &f.IsEarlyAccess)
			delete(rawMsg, key)
		case "isHidden":
			err = unpopulate(val, "IsHidden", &f.IsHidden)
			delete(rawMsg, key)
		case "isPreview":
			err = unpopulate(val, "IsPreview", &f.IsPreview)
			delete(rawMsg, key)
		case "remoteDebuggingSupported":
			err = unpopulate(val, "RemoteDebuggingSupported", &f.RemoteDebuggingSupported)
			delete(rawMsg, key)
		case "runtimeVersion":
			err = unpopulate(val, "RuntimeVersion", &f.RuntimeVersion)
			delete(rawMsg, key)
		case "siteConfigPropertiesDictionary":
			err = unpopulate(val, "SiteConfigPropertiesDictionary", &f.SiteConfigPropertiesDictionary)
			delete(rawMsg, key)
		case "supportedFunctionsExtensionVersions":
			err = unpopulate(val, "SupportedFunctionsExtensionVersions", &f.SupportedFunctionsExtensionVersions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionAppRuntimes.
func (f FunctionAppRuntimes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "linuxRuntimeSettings", f.LinuxRuntimeSettings)
	populate(objectMap, "windowsRuntimeSettings", f.WindowsRuntimeSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionAppRuntimes.
func (f *FunctionAppRuntimes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "linuxRuntimeSettings":
			err = unpopulate(val, "LinuxRuntimeSettings", &f.LinuxRuntimeSettings)
			delete(rawMsg, key)
		case "windowsRuntimeSettings":
			err = unpopulate(val, "WindowsRuntimeSettings", &f.WindowsRuntimeSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionAppStack.
func (f FunctionAppStack) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "kind", f.Kind)
	populate(objectMap, "location", f.Location)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionAppStack.
func (f *FunctionAppStack) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &f.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &f.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionAppStackCollection.
func (f FunctionAppStackCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", f.NextLink)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionAppStackCollection.
func (f *FunctionAppStackCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &f.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionAppStackProperties.
func (f FunctionAppStackProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayText", f.DisplayText)
	populate(objectMap, "majorVersions", f.MajorVersions)
	populate(objectMap, "preferredOs", f.PreferredOs)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionAppStackProperties.
func (f *FunctionAppStackProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayText":
			err = unpopulate(val, "DisplayText", &f.DisplayText)
			delete(rawMsg, key)
		case "majorVersions":
			err = unpopulate(val, "MajorVersions", &f.MajorVersions)
			delete(rawMsg, key)
		case "preferredOs":
			err = unpopulate(val, "PreferredOs", &f.PreferredOs)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionEnvelope.
func (f FunctionEnvelope) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "kind", f.Kind)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionEnvelope.
func (f *FunctionEnvelope) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &f.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionEnvelopeCollection.
func (f FunctionEnvelopeCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", f.NextLink)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionEnvelopeCollection.
func (f *FunctionEnvelopeCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &f.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionEnvelopeProperties.
func (f FunctionEnvelopeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "config", f.Config)
	populate(objectMap, "config_href", f.ConfigHref)
	populate(objectMap, "files", f.Files)
	populate(objectMap, "function_app_id", f.FunctionAppID)
	populate(objectMap, "href", f.Href)
	populate(objectMap, "invoke_url_template", f.InvokeURLTemplate)
	populate(objectMap, "isDisabled", f.IsDisabled)
	populate(objectMap, "language", f.Language)
	populate(objectMap, "script_href", f.ScriptHref)
	populate(objectMap, "script_root_path_href", f.ScriptRootPathHref)
	populate(objectMap, "secrets_file_href", f.SecretsFileHref)
	populate(objectMap, "test_data", f.TestData)
	populate(objectMap, "test_data_href", f.TestDataHref)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionEnvelopeProperties.
func (f *FunctionEnvelopeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "config":
			err = unpopulate(val, "Config", &f.Config)
			delete(rawMsg, key)
		case "config_href":
			err = unpopulate(val, "ConfigHref", &f.ConfigHref)
			delete(rawMsg, key)
		case "files":
			err = unpopulate(val, "Files", &f.Files)
			delete(rawMsg, key)
		case "function_app_id":
			err = unpopulate(val, "FunctionAppID", &f.FunctionAppID)
			delete(rawMsg, key)
		case "href":
			err = unpopulate(val, "Href", &f.Href)
			delete(rawMsg, key)
		case "invoke_url_template":
			err = unpopulate(val, "InvokeURLTemplate", &f.InvokeURLTemplate)
			delete(rawMsg, key)
		case "isDisabled":
			err = unpopulate(val, "IsDisabled", &f.IsDisabled)
			delete(rawMsg, key)
		case "language":
			err = unpopulate(val, "Language", &f.Language)
			delete(rawMsg, key)
		case "script_href":
			err = unpopulate(val, "ScriptHref", &f.ScriptHref)
			delete(rawMsg, key)
		case "script_root_path_href":
			err = unpopulate(val, "ScriptRootPathHref", &f.ScriptRootPathHref)
			delete(rawMsg, key)
		case "secrets_file_href":
			err = unpopulate(val, "SecretsFileHref", &f.SecretsFileHref)
			delete(rawMsg, key)
		case "test_data":
			err = unpopulate(val, "TestData", &f.TestData)
			delete(rawMsg, key)
		case "test_data_href":
			err = unpopulate(val, "TestDataHref", &f.TestDataHref)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionSecrets.
func (f FunctionSecrets) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "key", f.Key)
	populate(objectMap, "trigger_url", f.TriggerURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionSecrets.
func (f *FunctionSecrets) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &f.Key)
			delete(rawMsg, key)
		case "trigger_url":
			err = unpopulate(val, "TriggerURL", &f.TriggerURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GeoRegion.
func (g GeoRegion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "kind", g.Kind)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GeoRegion.
func (g *GeoRegion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &g.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GeoRegionCollection.
func (g GeoRegionCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", g.NextLink)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GeoRegionCollection.
func (g *GeoRegionCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &g.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GeoRegionProperties.
func (g GeoRegionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", g.Description)
	populate(objectMap, "displayName", g.DisplayName)
	populate(objectMap, "orgDomain", g.OrgDomain)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GeoRegionProperties.
func (g *GeoRegionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &g.DisplayName)
			delete(rawMsg, key)
		case "orgDomain":
			err = unpopulate(val, "OrgDomain", &g.OrgDomain)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GitHub.
func (g GitHub) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", g.Enabled)
	populate(objectMap, "login", g.Login)
	populate(objectMap, "registration", g.Registration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GitHub.
func (g *GitHub) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &g.Enabled)
			delete(rawMsg, key)
		case "login":
			err = unpopulate(val, "Login", &g.Login)
			delete(rawMsg, key)
		case "registration":
			err = unpopulate(val, "Registration", &g.Registration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GitHubActionCodeConfiguration.
func (g GitHubActionCodeConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "runtimeStack", g.RuntimeStack)
	populate(objectMap, "runtimeVersion", g.RuntimeVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GitHubActionCodeConfiguration.
func (g *GitHubActionCodeConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "runtimeStack":
			err = unpopulate(val, "RuntimeStack", &g.RuntimeStack)
			delete(rawMsg, key)
		case "runtimeVersion":
			err = unpopulate(val, "RuntimeVersion", &g.RuntimeVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GitHubActionConfiguration.
func (g GitHubActionConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "codeConfiguration", g.CodeConfiguration)
	populate(objectMap, "containerConfiguration", g.ContainerConfiguration)
	populate(objectMap, "generateWorkflowFile", g.GenerateWorkflowFile)
	populate(objectMap, "isLinux", g.IsLinux)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GitHubActionConfiguration.
func (g *GitHubActionConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "codeConfiguration":
			err = unpopulate(val, "CodeConfiguration", &g.CodeConfiguration)
			delete(rawMsg, key)
		case "containerConfiguration":
			err = unpopulate(val, "ContainerConfiguration", &g.ContainerConfiguration)
			delete(rawMsg, key)
		case "generateWorkflowFile":
			err = unpopulate(val, "GenerateWorkflowFile", &g.GenerateWorkflowFile)
			delete(rawMsg, key)
		case "isLinux":
			err = unpopulate(val, "IsLinux", &g.IsLinux)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GitHubActionContainerConfiguration.
func (g GitHubActionContainerConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "imageName", g.ImageName)
	populate(objectMap, "password", g.Password)
	populate(objectMap, "serverUrl", g.ServerURL)
	populate(objectMap, "username", g.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GitHubActionContainerConfiguration.
func (g *GitHubActionContainerConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "imageName":
			err = unpopulate(val, "ImageName", &g.ImageName)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &g.Password)
			delete(rawMsg, key)
		case "serverUrl":
			err = unpopulate(val, "ServerURL", &g.ServerURL)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &g.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GitHubActionWebAppStackSettings.
func (g GitHubActionWebAppStackSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isSupported", g.IsSupported)
	populate(objectMap, "supportedVersion", g.SupportedVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GitHubActionWebAppStackSettings.
func (g *GitHubActionWebAppStackSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isSupported":
			err = unpopulate(val, "IsSupported", &g.IsSupported)
			delete(rawMsg, key)
		case "supportedVersion":
			err = unpopulate(val, "SupportedVersion", &g.SupportedVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GithubToken.
func (g GithubToken) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessToken", g.AccessToken)
	populate(objectMap, "errorMessage", g.ErrorMessage)
	populate(objectMap, "gotToken", g.GotToken)
	populate(objectMap, "scope", g.Scope)
	populate(objectMap, "tokenType", g.TokenType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GithubToken.
func (g *GithubToken) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessToken":
			err = unpopulate(val, "AccessToken", &g.AccessToken)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &g.ErrorMessage)
			delete(rawMsg, key)
		case "gotToken":
			err = unpopulate(val, "GotToken", &g.GotToken)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &g.Scope)
			delete(rawMsg, key)
		case "tokenType":
			err = unpopulate(val, "TokenType", &g.TokenType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GithubTokenRequest.
func (g GithubTokenRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", g.Code)
	populate(objectMap, "state", g.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GithubTokenRequest.
func (g *GithubTokenRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &g.Code)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &g.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GlobalCsmSKUDescription.
func (g GlobalCsmSKUDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capabilities", g.Capabilities)
	populate(objectMap, "capacity", g.Capacity)
	populate(objectMap, "family", g.Family)
	populate(objectMap, "locations", g.Locations)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "size", g.Size)
	populate(objectMap, "tier", g.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GlobalCsmSKUDescription.
func (g *GlobalCsmSKUDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capabilities":
			err = unpopulate(val, "Capabilities", &g.Capabilities)
			delete(rawMsg, key)
		case "capacity":
			err = unpopulate(val, "Capacity", &g.Capacity)
			delete(rawMsg, key)
		case "family":
			err = unpopulate(val, "Family", &g.Family)
			delete(rawMsg, key)
		case "locations":
			err = unpopulate(val, "Locations", &g.Locations)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &g.Size)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &g.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GlobalValidation.
func (g GlobalValidation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "excludedPaths", g.ExcludedPaths)
	populate(objectMap, "redirectToProvider", g.RedirectToProvider)
	populate(objectMap, "requireAuthentication", g.RequireAuthentication)
	populate(objectMap, "unauthenticatedClientAction", g.UnauthenticatedClientAction)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GlobalValidation.
func (g *GlobalValidation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "excludedPaths":
			err = unpopulate(val, "ExcludedPaths", &g.ExcludedPaths)
			delete(rawMsg, key)
		case "redirectToProvider":
			err = unpopulate(val, "RedirectToProvider", &g.RedirectToProvider)
			delete(rawMsg, key)
		case "requireAuthentication":
			err = unpopulate(val, "RequireAuthentication", &g.RequireAuthentication)
			delete(rawMsg, key)
		case "unauthenticatedClientAction":
			err = unpopulate(val, "UnauthenticatedClientAction", &g.UnauthenticatedClientAction)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Google.
func (g Google) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", g.Enabled)
	populate(objectMap, "login", g.Login)
	populate(objectMap, "registration", g.Registration)
	populate(objectMap, "validation", g.Validation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Google.
func (g *Google) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &g.Enabled)
			delete(rawMsg, key)
		case "login":
			err = unpopulate(val, "Login", &g.Login)
			delete(rawMsg, key)
		case "registration":
			err = unpopulate(val, "Registration", &g.Registration)
			delete(rawMsg, key)
		case "validation":
			err = unpopulate(val, "Validation", &g.Validation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPLogsConfig.
func (h HTTPLogsConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureBlobStorage", h.AzureBlobStorage)
	populate(objectMap, "fileSystem", h.FileSystem)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPLogsConfig.
func (h *HTTPLogsConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureBlobStorage":
			err = unpopulate(val, "AzureBlobStorage", &h.AzureBlobStorage)
			delete(rawMsg, key)
		case "fileSystem":
			err = unpopulate(val, "FileSystem", &h.FileSystem)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPScaleRule.
func (h HTTPScaleRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "auth", h.Auth)
	populate(objectMap, "metadata", h.Metadata)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPScaleRule.
func (h *HTTPScaleRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "auth":
			err = unpopulate(val, "Auth", &h.Auth)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &h.Metadata)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPSettings.
func (h HTTPSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "forwardProxy", h.ForwardProxy)
	populate(objectMap, "requireHttps", h.RequireHTTPS)
	populate(objectMap, "routes", h.Routes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPSettings.
func (h *HTTPSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "forwardProxy":
			err = unpopulate(val, "ForwardProxy", &h.ForwardProxy)
			delete(rawMsg, key)
		case "requireHttps":
			err = unpopulate(val, "RequireHTTPS", &h.RequireHTTPS)
			delete(rawMsg, key)
		case "routes":
			err = unpopulate(val, "Routes", &h.Routes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPSettingsRoutes.
func (h HTTPSettingsRoutes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiPrefix", h.APIPrefix)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPSettingsRoutes.
func (h *HTTPSettingsRoutes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiPrefix":
			err = unpopulate(val, "APIPrefix", &h.APIPrefix)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HandlerMapping.
func (h HandlerMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "arguments", h.Arguments)
	populate(objectMap, "extension", h.Extension)
	populate(objectMap, "scriptProcessor", h.ScriptProcessor)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HandlerMapping.
func (h *HandlerMapping) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "arguments":
			err = unpopulate(val, "Arguments", &h.Arguments)
			delete(rawMsg, key)
		case "extension":
			err = unpopulate(val, "Extension", &h.Extension)
			delete(rawMsg, key)
		case "scriptProcessor":
			err = unpopulate(val, "ScriptProcessor", &h.ScriptProcessor)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostKeys.
func (h HostKeys) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "functionKeys", h.FunctionKeys)
	populate(objectMap, "masterKey", h.MasterKey)
	populate(objectMap, "systemKeys", h.SystemKeys)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostKeys.
func (h *HostKeys) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "functionKeys":
			err = unpopulate(val, "FunctionKeys", &h.FunctionKeys)
			delete(rawMsg, key)
		case "masterKey":
			err = unpopulate(val, "MasterKey", &h.MasterKey)
			delete(rawMsg, key)
		case "systemKeys":
			err = unpopulate(val, "SystemKeys", &h.SystemKeys)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostName.
func (h HostName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureResourceName", h.AzureResourceName)
	populate(objectMap, "azureResourceType", h.AzureResourceType)
	populate(objectMap, "customHostNameDnsRecordType", h.CustomHostNameDNSRecordType)
	populate(objectMap, "hostNameType", h.HostNameType)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "siteNames", h.SiteNames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostName.
func (h *HostName) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureResourceName":
			err = unpopulate(val, "AzureResourceName", &h.AzureResourceName)
			delete(rawMsg, key)
		case "azureResourceType":
			err = unpopulate(val, "AzureResourceType", &h.AzureResourceType)
			delete(rawMsg, key)
		case "customHostNameDnsRecordType":
			err = unpopulate(val, "CustomHostNameDNSRecordType", &h.CustomHostNameDNSRecordType)
			delete(rawMsg, key)
		case "hostNameType":
			err = unpopulate(val, "HostNameType", &h.HostNameType)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "siteNames":
			err = unpopulate(val, "SiteNames", &h.SiteNames)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostNameBinding.
func (h HostNameBinding) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", h.ID)
	populate(objectMap, "kind", h.Kind)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "properties", h.Properties)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostNameBinding.
func (h *HostNameBinding) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &h.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostNameBindingCollection.
func (h HostNameBindingCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", h.NextLink)
	populate(objectMap, "value", h.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostNameBindingCollection.
func (h *HostNameBindingCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &h.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &h.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostNameBindingProperties.
func (h HostNameBindingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureResourceName", h.AzureResourceName)
	populate(objectMap, "azureResourceType", h.AzureResourceType)
	populate(objectMap, "customHostNameDnsRecordType", h.CustomHostNameDNSRecordType)
	populate(objectMap, "domainId", h.DomainID)
	populate(objectMap, "hostNameType", h.HostNameType)
	populate(objectMap, "sslState", h.SSLState)
	populate(objectMap, "siteName", h.SiteName)
	populate(objectMap, "thumbprint", h.Thumbprint)
	populate(objectMap, "virtualIP", h.VirtualIP)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostNameBindingProperties.
func (h *HostNameBindingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureResourceName":
			err = unpopulate(val, "AzureResourceName", &h.AzureResourceName)
			delete(rawMsg, key)
		case "azureResourceType":
			err = unpopulate(val, "AzureResourceType", &h.AzureResourceType)
			delete(rawMsg, key)
		case "customHostNameDnsRecordType":
			err = unpopulate(val, "CustomHostNameDNSRecordType", &h.CustomHostNameDNSRecordType)
			delete(rawMsg, key)
		case "domainId":
			err = unpopulate(val, "DomainID", &h.DomainID)
			delete(rawMsg, key)
		case "hostNameType":
			err = unpopulate(val, "HostNameType", &h.HostNameType)
			delete(rawMsg, key)
		case "sslState":
			err = unpopulate(val, "SSLState", &h.SSLState)
			delete(rawMsg, key)
		case "siteName":
			err = unpopulate(val, "SiteName", &h.SiteName)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &h.Thumbprint)
			delete(rawMsg, key)
		case "virtualIP":
			err = unpopulate(val, "VirtualIP", &h.VirtualIP)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostNameSSLState.
func (h HostNameSSLState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hostType", h.HostType)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "sslState", h.SSLState)
	populate(objectMap, "thumbprint", h.Thumbprint)
	populate(objectMap, "toUpdate", h.ToUpdate)
	populate(objectMap, "virtualIP", h.VirtualIP)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostNameSSLState.
func (h *HostNameSSLState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hostType":
			err = unpopulate(val, "HostType", &h.HostType)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "sslState":
			err = unpopulate(val, "SSLState", &h.SSLState)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &h.Thumbprint)
			delete(rawMsg, key)
		case "toUpdate":
			err = unpopulate(val, "ToUpdate", &h.ToUpdate)
			delete(rawMsg, key)
		case "virtualIP":
			err = unpopulate(val, "VirtualIP", &h.VirtualIP)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostingEnvironmentDeploymentInfo.
func (h HostingEnvironmentDeploymentInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", h.Location)
	populate(objectMap, "name", h.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostingEnvironmentDeploymentInfo.
func (h *HostingEnvironmentDeploymentInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &h.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostingEnvironmentDiagnostics.
func (h HostingEnvironmentDiagnostics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diagnosticsOutput", h.DiagnosticsOutput)
	populate(objectMap, "name", h.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostingEnvironmentDiagnostics.
func (h *HostingEnvironmentDiagnostics) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diagnosticsOutput":
			err = unpopulate(val, "DiagnosticsOutput", &h.DiagnosticsOutput)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostingEnvironmentProfile.
func (h HostingEnvironmentProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", h.ID)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostingEnvironmentProfile.
func (h *HostingEnvironmentProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridConnection.
func (h HybridConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", h.ID)
	populate(objectMap, "kind", h.Kind)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "properties", h.Properties)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridConnection.
func (h *HybridConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &h.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridConnectionCollection.
func (h HybridConnectionCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", h.NextLink)
	populate(objectMap, "value", h.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridConnectionCollection.
func (h *HybridConnectionCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &h.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &h.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridConnectionKey.
func (h HybridConnectionKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", h.ID)
	populate(objectMap, "kind", h.Kind)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "properties", h.Properties)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridConnectionKey.
func (h *HybridConnectionKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &h.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridConnectionKeyProperties.
func (h HybridConnectionKeyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sendKeyName", h.SendKeyName)
	populate(objectMap, "sendKeyValue", h.SendKeyValue)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridConnectionKeyProperties.
func (h *HybridConnectionKeyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sendKeyName":
			err = unpopulate(val, "SendKeyName", &h.SendKeyName)
			delete(rawMsg, key)
		case "sendKeyValue":
			err = unpopulate(val, "SendKeyValue", &h.SendKeyValue)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridConnectionLimits.
func (h HybridConnectionLimits) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", h.ID)
	populate(objectMap, "kind", h.Kind)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "properties", h.Properties)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridConnectionLimits.
func (h *HybridConnectionLimits) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &h.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridConnectionLimitsProperties.
func (h HybridConnectionLimitsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "current", h.Current)
	populate(objectMap, "maximum", h.Maximum)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridConnectionLimitsProperties.
func (h *HybridConnectionLimitsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "current":
			err = unpopulate(val, "Current", &h.Current)
			delete(rawMsg, key)
		case "maximum":
			err = unpopulate(val, "Maximum", &h.Maximum)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridConnectionProperties.
func (h HybridConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hostname", h.Hostname)
	populate(objectMap, "port", h.Port)
	populate(objectMap, "relayArmUri", h.RelayArmURI)
	populate(objectMap, "relayName", h.RelayName)
	populate(objectMap, "sendKeyName", h.SendKeyName)
	populate(objectMap, "sendKeyValue", h.SendKeyValue)
	populate(objectMap, "serviceBusNamespace", h.ServiceBusNamespace)
	populate(objectMap, "serviceBusSuffix", h.ServiceBusSuffix)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridConnectionProperties.
func (h *HybridConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hostname":
			err = unpopulate(val, "Hostname", &h.Hostname)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &h.Port)
			delete(rawMsg, key)
		case "relayArmUri":
			err = unpopulate(val, "RelayArmURI", &h.RelayArmURI)
			delete(rawMsg, key)
		case "relayName":
			err = unpopulate(val, "RelayName", &h.RelayName)
			delete(rawMsg, key)
		case "sendKeyName":
			err = unpopulate(val, "SendKeyName", &h.SendKeyName)
			delete(rawMsg, key)
		case "sendKeyValue":
			err = unpopulate(val, "SendKeyValue", &h.SendKeyValue)
			delete(rawMsg, key)
		case "serviceBusNamespace":
			err = unpopulate(val, "ServiceBusNamespace", &h.ServiceBusNamespace)
			delete(rawMsg, key)
		case "serviceBusSuffix":
			err = unpopulate(val, "ServiceBusSuffix", &h.ServiceBusSuffix)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPAddress.
func (i IPAddress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", i.Address)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPAddress.
func (i *IPAddress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &i.Address)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPAddressRange.
func (i IPAddressRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressRange", i.AddressRange)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPAddressRange.
func (i *IPAddressRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressRange":
			err = unpopulate(val, "AddressRange", &i.AddressRange)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPSecurityRestriction.
func (i IPSecurityRestriction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", i.Action)
	populate(objectMap, "description", i.Description)
	populate(objectMap, "headers", i.Headers)
	populate(objectMap, "ipAddress", i.IPAddress)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "priority", i.Priority)
	populate(objectMap, "subnetMask", i.SubnetMask)
	populate(objectMap, "subnetTrafficTag", i.SubnetTrafficTag)
	populate(objectMap, "tag", i.Tag)
	populate(objectMap, "vnetSubnetResourceId", i.VnetSubnetResourceID)
	populate(objectMap, "vnetTrafficTag", i.VnetTrafficTag)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPSecurityRestriction.
func (i *IPSecurityRestriction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &i.Action)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &i.Description)
			delete(rawMsg, key)
		case "headers":
			err = unpopulate(val, "Headers", &i.Headers)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &i.IPAddress)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &i.Priority)
			delete(rawMsg, key)
		case "subnetMask":
			err = unpopulate(val, "SubnetMask", &i.SubnetMask)
			delete(rawMsg, key)
		case "subnetTrafficTag":
			err = unpopulate(val, "SubnetTrafficTag", &i.SubnetTrafficTag)
			delete(rawMsg, key)
		case "tag":
			err = unpopulate(val, "Tag", &i.Tag)
			delete(rawMsg, key)
		case "vnetSubnetResourceId":
			err = unpopulate(val, "VnetSubnetResourceID", &i.VnetSubnetResourceID)
			delete(rawMsg, key)
		case "vnetTrafficTag":
			err = unpopulate(val, "VnetTrafficTag", &i.VnetTrafficTag)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Identifier.
func (i Identifier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "kind", i.Kind)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Identifier.
func (i *Identifier) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &i.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentifierCollection.
func (i IdentifierCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IdentifierCollection.
func (i *IdentifierCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentifierProperties.
func (i IdentifierProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IdentifierProperties.
func (i *IdentifierProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentityProviders.
func (i IdentityProviders) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apple", i.Apple)
	populate(objectMap, "azureActiveDirectory", i.AzureActiveDirectory)
	populate(objectMap, "azureStaticWebApps", i.AzureStaticWebApps)
	populate(objectMap, "customOpenIdConnectProviders", i.CustomOpenIDConnectProviders)
	populate(objectMap, "facebook", i.Facebook)
	populate(objectMap, "gitHub", i.GitHub)
	populate(objectMap, "google", i.Google)
	populate(objectMap, "legacyMicrosoftAccount", i.LegacyMicrosoftAccount)
	populate(objectMap, "twitter", i.Twitter)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IdentityProviders.
func (i *IdentityProviders) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apple":
			err = unpopulate(val, "Apple", &i.Apple)
			delete(rawMsg, key)
		case "azureActiveDirectory":
			err = unpopulate(val, "AzureActiveDirectory", &i.AzureActiveDirectory)
			delete(rawMsg, key)
		case "azureStaticWebApps":
			err = unpopulate(val, "AzureStaticWebApps", &i.AzureStaticWebApps)
			delete(rawMsg, key)
		case "customOpenIdConnectProviders":
			err = unpopulate(val, "CustomOpenIDConnectProviders", &i.CustomOpenIDConnectProviders)
			delete(rawMsg, key)
		case "facebook":
			err = unpopulate(val, "Facebook", &i.Facebook)
			delete(rawMsg, key)
		case "gitHub":
			err = unpopulate(val, "GitHub", &i.GitHub)
			delete(rawMsg, key)
		case "google":
			err = unpopulate(val, "Google", &i.Google)
			delete(rawMsg, key)
		case "legacyMicrosoftAccount":
			err = unpopulate(val, "LegacyMicrosoftAccount", &i.LegacyMicrosoftAccount)
			delete(rawMsg, key)
		case "twitter":
			err = unpopulate(val, "Twitter", &i.Twitter)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InboundEnvironmentEndpoint.
func (i InboundEnvironmentEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", i.Description)
	populate(objectMap, "endpoints", i.Endpoints)
	populate(objectMap, "ports", i.Ports)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InboundEnvironmentEndpoint.
func (i *InboundEnvironmentEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &i.Description)
			delete(rawMsg, key)
		case "endpoints":
			err = unpopulate(val, "Endpoints", &i.Endpoints)
			delete(rawMsg, key)
		case "ports":
			err = unpopulate(val, "Ports", &i.Ports)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InboundEnvironmentEndpointCollection.
func (i InboundEnvironmentEndpointCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InboundEnvironmentEndpointCollection.
func (i *InboundEnvironmentEndpointCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Ingress.
func (i Ingress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowInsecure", i.AllowInsecure)
	populate(objectMap, "external", i.External)
	populate(objectMap, "fqdn", i.Fqdn)
	populate(objectMap, "targetPort", i.TargetPort)
	populate(objectMap, "traffic", i.Traffic)
	populate(objectMap, "transport", i.Transport)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Ingress.
func (i *Ingress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowInsecure":
			err = unpopulate(val, "AllowInsecure", &i.AllowInsecure)
			delete(rawMsg, key)
		case "external":
			err = unpopulate(val, "External", &i.External)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &i.Fqdn)
			delete(rawMsg, key)
		case "targetPort":
			err = unpopulate(val, "TargetPort", &i.TargetPort)
			delete(rawMsg, key)
		case "traffic":
			err = unpopulate(val, "Traffic", &i.Traffic)
			delete(rawMsg, key)
		case "transport":
			err = unpopulate(val, "Transport", &i.Transport)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JSONSchema.
func (j JSONSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content", j.Content)
	populate(objectMap, "title", j.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JSONSchema.
func (j *JSONSchema) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content":
			err = unpopulate(val, "Content", &j.Content)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &j.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JwtClaimChecks.
func (j JwtClaimChecks) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedClientApplications", j.AllowedClientApplications)
	populate(objectMap, "allowedGroups", j.AllowedGroups)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JwtClaimChecks.
func (j *JwtClaimChecks) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedClientApplications":
			err = unpopulate(val, "AllowedClientApplications", &j.AllowedClientApplications)
			delete(rawMsg, key)
		case "allowedGroups":
			err = unpopulate(val, "AllowedGroups", &j.AllowedGroups)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyInfo.
func (k KeyInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", k.Name)
	populate(objectMap, "value", k.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyInfo.
func (k *KeyInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &k.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &k.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyValuePairStringObject.
func (k KeyValuePairStringObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "key", k.Key)
	populateAny(objectMap, "value", k.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyValuePairStringObject.
func (k *KeyValuePairStringObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &k.Key)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &k.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubeEnvironment.
func (k KubeEnvironment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", k.ExtendedLocation)
	populate(objectMap, "id", k.ID)
	populate(objectMap, "kind", k.Kind)
	populate(objectMap, "location", k.Location)
	populate(objectMap, "name", k.Name)
	populate(objectMap, "properties", k.Properties)
	populate(objectMap, "tags", k.Tags)
	populate(objectMap, "type", k.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubeEnvironment.
func (k *KubeEnvironment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &k.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &k.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &k.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &k.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &k.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &k.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &k.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &k.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubeEnvironmentCollection.
func (k KubeEnvironmentCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", k.NextLink)
	populate(objectMap, "value", k.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubeEnvironmentCollection.
func (k *KubeEnvironmentCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &k.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &k.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubeEnvironmentPatchResource.
func (k KubeEnvironmentPatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", k.ID)
	populate(objectMap, "kind", k.Kind)
	populate(objectMap, "name", k.Name)
	populate(objectMap, "properties", k.Properties)
	populate(objectMap, "type", k.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubeEnvironmentPatchResource.
func (k *KubeEnvironmentPatchResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &k.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &k.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &k.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &k.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &k.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubeEnvironmentPatchResourceProperties.
func (k KubeEnvironmentPatchResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aksResourceID", k.AksResourceID)
	populate(objectMap, "appLogsConfiguration", k.AppLogsConfiguration)
	populate(objectMap, "arcConfiguration", k.ArcConfiguration)
	populate(objectMap, "containerAppsConfiguration", k.ContainerAppsConfiguration)
	populate(objectMap, "defaultDomain", k.DefaultDomain)
	populate(objectMap, "deploymentErrors", k.DeploymentErrors)
	populate(objectMap, "internalLoadBalancerEnabled", k.InternalLoadBalancerEnabled)
	populate(objectMap, "provisioningState", k.ProvisioningState)
	populate(objectMap, "staticIp", k.StaticIP)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubeEnvironmentPatchResourceProperties.
func (k *KubeEnvironmentPatchResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aksResourceID":
			err = unpopulate(val, "AksResourceID", &k.AksResourceID)
			delete(rawMsg, key)
		case "appLogsConfiguration":
			err = unpopulate(val, "AppLogsConfiguration", &k.AppLogsConfiguration)
			delete(rawMsg, key)
		case "arcConfiguration":
			err = unpopulate(val, "ArcConfiguration", &k.ArcConfiguration)
			delete(rawMsg, key)
		case "containerAppsConfiguration":
			err = unpopulate(val, "ContainerAppsConfiguration", &k.ContainerAppsConfiguration)
			delete(rawMsg, key)
		case "defaultDomain":
			err = unpopulate(val, "DefaultDomain", &k.DefaultDomain)
			delete(rawMsg, key)
		case "deploymentErrors":
			err = unpopulate(val, "DeploymentErrors", &k.DeploymentErrors)
			delete(rawMsg, key)
		case "internalLoadBalancerEnabled":
			err = unpopulate(val, "InternalLoadBalancerEnabled", &k.InternalLoadBalancerEnabled)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &k.ProvisioningState)
			delete(rawMsg, key)
		case "staticIp":
			err = unpopulate(val, "StaticIP", &k.StaticIP)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubeEnvironmentProfile.
func (k KubeEnvironmentProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", k.ID)
	populate(objectMap, "name", k.Name)
	populate(objectMap, "type", k.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubeEnvironmentProfile.
func (k *KubeEnvironmentProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &k.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &k.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &k.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubeEnvironmentProperties.
func (k KubeEnvironmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aksResourceID", k.AksResourceID)
	populate(objectMap, "appLogsConfiguration", k.AppLogsConfiguration)
	populate(objectMap, "arcConfiguration", k.ArcConfiguration)
	populate(objectMap, "containerAppsConfiguration", k.ContainerAppsConfiguration)
	populate(objectMap, "defaultDomain", k.DefaultDomain)
	populate(objectMap, "deploymentErrors", k.DeploymentErrors)
	populate(objectMap, "environmentType", k.EnvironmentType)
	populate(objectMap, "internalLoadBalancerEnabled", k.InternalLoadBalancerEnabled)
	populate(objectMap, "provisioningState", k.ProvisioningState)
	populate(objectMap, "staticIp", k.StaticIP)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubeEnvironmentProperties.
func (k *KubeEnvironmentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aksResourceID":
			err = unpopulate(val, "AksResourceID", &k.AksResourceID)
			delete(rawMsg, key)
		case "appLogsConfiguration":
			err = unpopulate(val, "AppLogsConfiguration", &k.AppLogsConfiguration)
			delete(rawMsg, key)
		case "arcConfiguration":
			err = unpopulate(val, "ArcConfiguration", &k.ArcConfiguration)
			delete(rawMsg, key)
		case "containerAppsConfiguration":
			err = unpopulate(val, "ContainerAppsConfiguration", &k.ContainerAppsConfiguration)
			delete(rawMsg, key)
		case "defaultDomain":
			err = unpopulate(val, "DefaultDomain", &k.DefaultDomain)
			delete(rawMsg, key)
		case "deploymentErrors":
			err = unpopulate(val, "DeploymentErrors", &k.DeploymentErrors)
			delete(rawMsg, key)
		case "environmentType":
			err = unpopulate(val, "EnvironmentType", &k.EnvironmentType)
			delete(rawMsg, key)
		case "internalLoadBalancerEnabled":
			err = unpopulate(val, "InternalLoadBalancerEnabled", &k.InternalLoadBalancerEnabled)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &k.ProvisioningState)
			delete(rawMsg, key)
		case "staticIp":
			err = unpopulate(val, "StaticIP", &k.StaticIP)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LegacyMicrosoftAccount.
func (l LegacyMicrosoftAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", l.Enabled)
	populate(objectMap, "login", l.Login)
	populate(objectMap, "registration", l.Registration)
	populate(objectMap, "validation", l.Validation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LegacyMicrosoftAccount.
func (l *LegacyMicrosoftAccount) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &l.Enabled)
			delete(rawMsg, key)
		case "login":
			err = unpopulate(val, "Login", &l.Login)
			delete(rawMsg, key)
		case "registration":
			err = unpopulate(val, "Registration", &l.Registration)
			delete(rawMsg, key)
		case "validation":
			err = unpopulate(val, "Validation", &l.Validation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinuxJavaContainerSettings.
func (l LinuxJavaContainerSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "endOfLifeDate", l.EndOfLifeDate)
	populate(objectMap, "isAutoUpdate", l.IsAutoUpdate)
	populate(objectMap, "isDeprecated", l.IsDeprecated)
	populate(objectMap, "isEarlyAccess", l.IsEarlyAccess)
	populate(objectMap, "isHidden", l.IsHidden)
	populate(objectMap, "isPreview", l.IsPreview)
	populate(objectMap, "java11Runtime", l.Java11Runtime)
	populate(objectMap, "java8Runtime", l.Java8Runtime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinuxJavaContainerSettings.
func (l *LinuxJavaContainerSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endOfLifeDate":
			err = unpopulateDateTimeRFC3339(val, "EndOfLifeDate", &l.EndOfLifeDate)
			delete(rawMsg, key)
		case "isAutoUpdate":
			err = unpopulate(val, "IsAutoUpdate", &l.IsAutoUpdate)
			delete(rawMsg, key)
		case "isDeprecated":
			err = unpopulate(val, "IsDeprecated", &l.IsDeprecated)
			delete(rawMsg, key)
		case "isEarlyAccess":
			err = unpopulate(val, "IsEarlyAccess", &l.IsEarlyAccess)
			delete(rawMsg, key)
		case "isHidden":
			err = unpopulate(val, "IsHidden", &l.IsHidden)
			delete(rawMsg, key)
		case "isPreview":
			err = unpopulate(val, "IsPreview", &l.IsPreview)
			delete(rawMsg, key)
		case "java11Runtime":
			err = unpopulate(val, "Java11Runtime", &l.Java11Runtime)
			delete(rawMsg, key)
		case "java8Runtime":
			err = unpopulate(val, "Java8Runtime", &l.Java8Runtime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LocalizableString.
func (l LocalizableString) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "localizedValue", l.LocalizedValue)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocalizableString.
func (l *LocalizableString) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localizedValue":
			err = unpopulate(val, "LocalizedValue", &l.LocalizedValue)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogAnalyticsConfiguration.
func (l LogAnalyticsConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customerId", l.CustomerID)
	populate(objectMap, "sharedKey", l.SharedKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogAnalyticsConfiguration.
func (l *LogAnalyticsConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customerId":
			err = unpopulate(val, "CustomerID", &l.CustomerID)
			delete(rawMsg, key)
		case "sharedKey":
			err = unpopulate(val, "SharedKey", &l.SharedKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogSpecification.
func (l LogSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobDuration", l.BlobDuration)
	populate(objectMap, "displayName", l.DisplayName)
	populate(objectMap, "logFilterPattern", l.LogFilterPattern)
	populate(objectMap, "name", l.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogSpecification.
func (l *LogSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobDuration":
			err = unpopulate(val, "BlobDuration", &l.BlobDuration)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &l.DisplayName)
			delete(rawMsg, key)
		case "logFilterPattern":
			err = unpopulate(val, "LogFilterPattern", &l.LogFilterPattern)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Login.
func (l Login) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedExternalRedirectUrls", l.AllowedExternalRedirectUrls)
	populate(objectMap, "cookieExpiration", l.CookieExpiration)
	populate(objectMap, "nonce", l.Nonce)
	populate(objectMap, "preserveUrlFragmentsForLogins", l.PreserveURLFragmentsForLogins)
	populate(objectMap, "routes", l.Routes)
	populate(objectMap, "tokenStore", l.TokenStore)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Login.
func (l *Login) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedExternalRedirectUrls":
			err = unpopulate(val, "AllowedExternalRedirectUrls", &l.AllowedExternalRedirectUrls)
			delete(rawMsg, key)
		case "cookieExpiration":
			err = unpopulate(val, "CookieExpiration", &l.CookieExpiration)
			delete(rawMsg, key)
		case "nonce":
			err = unpopulate(val, "Nonce", &l.Nonce)
			delete(rawMsg, key)
		case "preserveUrlFragmentsForLogins":
			err = unpopulate(val, "PreserveURLFragmentsForLogins", &l.PreserveURLFragmentsForLogins)
			delete(rawMsg, key)
		case "routes":
			err = unpopulate(val, "Routes", &l.Routes)
			delete(rawMsg, key)
		case "tokenStore":
			err = unpopulate(val, "TokenStore", &l.TokenStore)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoginRoutes.
func (l LoginRoutes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "logoutEndpoint", l.LogoutEndpoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoginRoutes.
func (l *LoginRoutes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "logoutEndpoint":
			err = unpopulate(val, "LogoutEndpoint", &l.LogoutEndpoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoginScopes.
func (l LoginScopes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "scopes", l.Scopes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoginScopes.
func (l *LoginScopes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "scopes":
			err = unpopulate(val, "Scopes", &l.Scopes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MSDeploy.
func (m MSDeploy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "kind", m.Kind)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MSDeploy.
func (m *MSDeploy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MSDeployCore.
func (m MSDeployCore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appOffline", m.AppOffline)
	populate(objectMap, "connectionString", m.ConnectionString)
	populate(objectMap, "dbType", m.DbType)
	populate(objectMap, "packageUri", m.PackageURI)
	populate(objectMap, "setParameters", m.SetParameters)
	populate(objectMap, "setParametersXmlFileUri", m.SetParametersXMLFileURI)
	populate(objectMap, "skipAppData", m.SkipAppData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MSDeployCore.
func (m *MSDeployCore) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appOffline":
			err = unpopulate(val, "AppOffline", &m.AppOffline)
			delete(rawMsg, key)
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &m.ConnectionString)
			delete(rawMsg, key)
		case "dbType":
			err = unpopulate(val, "DbType", &m.DbType)
			delete(rawMsg, key)
		case "packageUri":
			err = unpopulate(val, "PackageURI", &m.PackageURI)
			delete(rawMsg, key)
		case "setParameters":
			err = unpopulate(val, "SetParameters", &m.SetParameters)
			delete(rawMsg, key)
		case "setParametersXmlFileUri":
			err = unpopulate(val, "SetParametersXMLFileURI", &m.SetParametersXMLFileURI)
			delete(rawMsg, key)
		case "skipAppData":
			err = unpopulate(val, "SkipAppData", &m.SkipAppData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MSDeployLog.
func (m MSDeployLog) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "kind", m.Kind)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MSDeployLog.
func (m *MSDeployLog) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MSDeployLogEntry.
func (m MSDeployLogEntry) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", m.Message)
	populateDateTimeRFC3339(objectMap, "time", m.Time)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MSDeployLogEntry.
func (m *MSDeployLogEntry) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &m.Message)
			delete(rawMsg, key)
		case "time":
			err = unpopulateDateTimeRFC3339(val, "Time", &m.Time)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MSDeployLogProperties.
func (m MSDeployLogProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "entries", m.Entries)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MSDeployLogProperties.
func (m *MSDeployLogProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "entries":
			err = unpopulate(val, "Entries", &m.Entries)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MSDeployStatus.
func (m MSDeployStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "kind", m.Kind)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MSDeployStatus.
func (m *MSDeployStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MSDeployStatusProperties.
func (m MSDeployStatusProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "complete", m.Complete)
	populate(objectMap, "deployer", m.Deployer)
	populateDateTimeRFC3339(objectMap, "endTime", m.EndTime)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	populateDateTimeRFC3339(objectMap, "startTime", m.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MSDeployStatusProperties.
func (m *MSDeployStatusProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "complete":
			err = unpopulate(val, "Complete", &m.Complete)
			delete(rawMsg, key)
		case "deployer":
			err = unpopulate(val, "Deployer", &m.Deployer)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &m.EndTime)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &m.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedServiceIdentity.
func (m ManagedServiceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", m.PrincipalID)
	populate(objectMap, "tenantId", m.TenantID)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "userAssignedIdentities", m.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedServiceIdentity.
func (m *ManagedServiceIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &m.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &m.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &m.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricAvailability.
func (m MetricAvailability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobDuration", m.BlobDuration)
	populate(objectMap, "timeGrain", m.TimeGrain)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricAvailability.
func (m *MetricAvailability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobDuration":
			err = unpopulate(val, "BlobDuration", &m.BlobDuration)
			delete(rawMsg, key)
		case "timeGrain":
			err = unpopulate(val, "TimeGrain", &m.TimeGrain)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricSpecification.
func (m MetricSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aggregationType", m.AggregationType)
	populate(objectMap, "availabilities", m.Availabilities)
	populate(objectMap, "category", m.Category)
	populate(objectMap, "dimensions", m.Dimensions)
	populate(objectMap, "displayDescription", m.DisplayDescription)
	populate(objectMap, "displayName", m.DisplayName)
	populate(objectMap, "enableRegionalMdmAccount", m.EnableRegionalMdmAccount)
	populate(objectMap, "fillGapWithZero", m.FillGapWithZero)
	populate(objectMap, "isInternal", m.IsInternal)
	populate(objectMap, "metricFilterPattern", m.MetricFilterPattern)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "sourceMdmAccount", m.SourceMdmAccount)
	populate(objectMap, "sourceMdmNamespace", m.SourceMdmNamespace)
	populate(objectMap, "supportedAggregationTypes", m.SupportedAggregationTypes)
	populate(objectMap, "supportedTimeGrainTypes", m.SupportedTimeGrainTypes)
	populate(objectMap, "supportsInstanceLevelAggregation", m.SupportsInstanceLevelAggregation)
	populate(objectMap, "unit", m.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricSpecification.
func (m *MetricSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregationType":
			err = unpopulate(val, "AggregationType", &m.AggregationType)
			delete(rawMsg, key)
		case "availabilities":
			err = unpopulate(val, "Availabilities", &m.Availabilities)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &m.Category)
			delete(rawMsg, key)
		case "dimensions":
			err = unpopulate(val, "Dimensions", &m.Dimensions)
			delete(rawMsg, key)
		case "displayDescription":
			err = unpopulate(val, "DisplayDescription", &m.DisplayDescription)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &m.DisplayName)
			delete(rawMsg, key)
		case "enableRegionalMdmAccount":
			err = unpopulate(val, "EnableRegionalMdmAccount", &m.EnableRegionalMdmAccount)
			delete(rawMsg, key)
		case "fillGapWithZero":
			err = unpopulate(val, "FillGapWithZero", &m.FillGapWithZero)
			delete(rawMsg, key)
		case "isInternal":
			err = unpopulate(val, "IsInternal", &m.IsInternal)
			delete(rawMsg, key)
		case "metricFilterPattern":
			err = unpopulate(val, "MetricFilterPattern", &m.MetricFilterPattern)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "sourceMdmAccount":
			err = unpopulate(val, "SourceMdmAccount", &m.SourceMdmAccount)
			delete(rawMsg, key)
		case "sourceMdmNamespace":
			err = unpopulate(val, "SourceMdmNamespace", &m.SourceMdmNamespace)
			delete(rawMsg, key)
		case "supportedAggregationTypes":
			err = unpopulate(val, "SupportedAggregationTypes", &m.SupportedAggregationTypes)
			delete(rawMsg, key)
		case "supportedTimeGrainTypes":
			err = unpopulate(val, "SupportedTimeGrainTypes", &m.SupportedTimeGrainTypes)
			delete(rawMsg, key)
		case "supportsInstanceLevelAggregation":
			err = unpopulate(val, "SupportsInstanceLevelAggregation", &m.SupportsInstanceLevelAggregation)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &m.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateMySQLRequest.
func (m MigrateMySQLRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "kind", m.Kind)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateMySQLRequest.
func (m *MigrateMySQLRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateMySQLRequestProperties.
func (m MigrateMySQLRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionString", m.ConnectionString)
	populate(objectMap, "migrationType", m.MigrationType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateMySQLRequestProperties.
func (m *MigrateMySQLRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &m.ConnectionString)
			delete(rawMsg, key)
		case "migrationType":
			err = unpopulate(val, "MigrationType", &m.MigrationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateMySQLStatus.
func (m MigrateMySQLStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "kind", m.Kind)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateMySQLStatus.
func (m *MigrateMySQLStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateMySQLStatusProperties.
func (m MigrateMySQLStatusProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "localMySqlEnabled", m.LocalMySQLEnabled)
	populate(objectMap, "migrationOperationStatus", m.MigrationOperationStatus)
	populate(objectMap, "operationId", m.OperationID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateMySQLStatusProperties.
func (m *MigrateMySQLStatusProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localMySqlEnabled":
			err = unpopulate(val, "LocalMySQLEnabled", &m.LocalMySQLEnabled)
			delete(rawMsg, key)
		case "migrationOperationStatus":
			err = unpopulate(val, "MigrationOperationStatus", &m.MigrationOperationStatus)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &m.OperationID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NameIdentifier.
func (n NameIdentifier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", n.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NameIdentifier.
func (n *NameIdentifier) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NameIdentifierCollection.
func (n NameIdentifierCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", n.NextLink)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NameIdentifierCollection.
func (n *NameIdentifierCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &n.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NameValuePair.
func (n NameValuePair) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NameValuePair.
func (n *NameValuePair) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFeatures.
func (n NetworkFeatures) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "kind", n.Kind)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFeatures.
func (n *NetworkFeatures) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &n.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFeaturesProperties.
func (n NetworkFeaturesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hybridConnections", n.HybridConnections)
	populate(objectMap, "hybridConnectionsV2", n.HybridConnectionsV2)
	populate(objectMap, "virtualNetworkConnection", n.VirtualNetworkConnection)
	populate(objectMap, "virtualNetworkName", n.VirtualNetworkName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFeaturesProperties.
func (n *NetworkFeaturesProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hybridConnections":
			err = unpopulate(val, "HybridConnections", &n.HybridConnections)
			delete(rawMsg, key)
		case "hybridConnectionsV2":
			err = unpopulate(val, "HybridConnectionsV2", &n.HybridConnectionsV2)
			delete(rawMsg, key)
		case "virtualNetworkConnection":
			err = unpopulate(val, "VirtualNetworkConnection", &n.VirtualNetworkConnection)
			delete(rawMsg, key)
		case "virtualNetworkName":
			err = unpopulate(val, "VirtualNetworkName", &n.VirtualNetworkName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkTrace.
func (n NetworkTrace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", n.Message)
	populate(objectMap, "path", n.Path)
	populate(objectMap, "status", n.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkTrace.
func (n *NetworkTrace) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &n.Message)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &n.Path)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &n.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Nonce.
func (n Nonce) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nonceExpirationInterval", n.NonceExpirationInterval)
	populate(objectMap, "validateNonce", n.ValidateNonce)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Nonce.
func (n *Nonce) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nonceExpirationInterval":
			err = unpopulate(val, "NonceExpirationInterval", &n.NonceExpirationInterval)
			delete(rawMsg, key)
		case "validateNonce":
			err = unpopulate(val, "ValidateNonce", &n.ValidateNonce)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OpenAuthenticationAccessPolicies.
func (o OpenAuthenticationAccessPolicies) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "policies", o.Policies)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OpenAuthenticationAccessPolicies.
func (o *OpenAuthenticationAccessPolicies) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "policies":
			err = unpopulate(val, "Policies", &o.Policies)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OpenAuthenticationAccessPolicy.
func (o OpenAuthenticationAccessPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "claims", o.Claims)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OpenAuthenticationAccessPolicy.
func (o *OpenAuthenticationAccessPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "claims":
			err = unpopulate(val, "Claims", &o.Claims)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OpenAuthenticationPolicyClaim.
func (o OpenAuthenticationPolicyClaim) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OpenAuthenticationPolicyClaim.
func (o *OpenAuthenticationPolicyClaim) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OpenIDConnectClientCredential.
func (o OpenIDConnectClientCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientSecretSettingName", o.ClientSecretSettingName)
	objectMap["method"] = "ClientSecretPost"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OpenIDConnectClientCredential.
func (o *OpenIDConnectClientCredential) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientSecretSettingName":
			err = unpopulate(val, "ClientSecretSettingName", &o.ClientSecretSettingName)
			delete(rawMsg, key)
		case "method":
			err = unpopulate(val, "Method", &o.Method)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OpenIDConnectConfig.
func (o OpenIDConnectConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorizationEndpoint", o.AuthorizationEndpoint)
	populate(objectMap, "certificationUri", o.CertificationURI)
	populate(objectMap, "issuer", o.Issuer)
	populate(objectMap, "tokenEndpoint", o.TokenEndpoint)
	populate(objectMap, "wellKnownOpenIdConfiguration", o.WellKnownOpenIDConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OpenIDConnectConfig.
func (o *OpenIDConnectConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizationEndpoint":
			err = unpopulate(val, "AuthorizationEndpoint", &o.AuthorizationEndpoint)
			delete(rawMsg, key)
		case "certificationUri":
			err = unpopulate(val, "CertificationURI", &o.CertificationURI)
			delete(rawMsg, key)
		case "issuer":
			err = unpopulate(val, "Issuer", &o.Issuer)
			delete(rawMsg, key)
		case "tokenEndpoint":
			err = unpopulate(val, "TokenEndpoint", &o.TokenEndpoint)
			delete(rawMsg, key)
		case "wellKnownOpenIdConfiguration":
			err = unpopulate(val, "WellKnownOpenIDConfiguration", &o.WellKnownOpenIDConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OpenIDConnectLogin.
func (o OpenIDConnectLogin) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nameClaimType", o.NameClaimType)
	populate(objectMap, "scopes", o.Scopes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OpenIDConnectLogin.
func (o *OpenIDConnectLogin) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nameClaimType":
			err = unpopulate(val, "NameClaimType", &o.NameClaimType)
			delete(rawMsg, key)
		case "scopes":
			err = unpopulate(val, "Scopes", &o.Scopes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OpenIDConnectRegistration.
func (o OpenIDConnectRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientCredential", o.ClientCredential)
	populate(objectMap, "clientId", o.ClientID)
	populate(objectMap, "openIdConnectConfiguration", o.OpenIDConnectConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OpenIDConnectRegistration.
func (o *OpenIDConnectRegistration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientCredential":
			err = unpopulate(val, "ClientCredential", &o.ClientCredential)
			delete(rawMsg, key)
		case "clientId":
			err = unpopulate(val, "ClientID", &o.ClientID)
			delete(rawMsg, key)
		case "openIdConnectConfiguration":
			err = unpopulate(val, "OpenIDConnectConfiguration", &o.OpenIDConnectConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdTime", o.CreatedTime)
	populate(objectMap, "errors", o.Errors)
	populateDateTimeRFC3339(objectMap, "expirationTime", o.ExpirationTime)
	populate(objectMap, "geoMasterOperationId", o.GeoMasterOperationID)
	populate(objectMap, "id", o.ID)
	populateDateTimeRFC3339(objectMap, "modifiedTime", o.ModifiedTime)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "status", o.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedTime", &o.CreatedTime)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &o.Errors)
			delete(rawMsg, key)
		case "expirationTime":
			err = unpopulateDateTimeRFC3339(val, "ExpirationTime", &o.ExpirationTime)
			delete(rawMsg, key)
		case "geoMasterOperationId":
			err = unpopulate(val, "GeoMasterOperationID", &o.GeoMasterOperationID)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "modifiedTime":
			err = unpopulateDateTimeRFC3339(val, "ModifiedTime", &o.ModifiedTime)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationResult.
func (o OperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", o.Code)
	populate(objectMap, "correlation", o.Correlation)
	populateDateTimeRFC3339(objectMap, "endTime", o.EndTime)
	populateAny(objectMap, "error", o.Error)
	populateAny(objectMap, "inputs", o.Inputs)
	populate(objectMap, "inputsLink", o.InputsLink)
	populate(objectMap, "iterationCount", o.IterationCount)
	populateAny(objectMap, "outputs", o.Outputs)
	populate(objectMap, "outputsLink", o.OutputsLink)
	populate(objectMap, "retryHistory", o.RetryHistory)
	populateDateTimeRFC3339(objectMap, "startTime", o.StartTime)
	populate(objectMap, "status", o.Status)
	populateAny(objectMap, "trackedProperties", o.TrackedProperties)
	populate(objectMap, "trackingId", o.TrackingID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResult.
func (o *OperationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &o.Code)
			delete(rawMsg, key)
		case "correlation":
			err = unpopulate(val, "Correlation", &o.Correlation)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &o.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &o.Error)
			delete(rawMsg, key)
		case "inputs":
			err = unpopulate(val, "Inputs", &o.Inputs)
			delete(rawMsg, key)
		case "inputsLink":
			err = unpopulate(val, "InputsLink", &o.InputsLink)
			delete(rawMsg, key)
		case "iterationCount":
			err = unpopulate(val, "IterationCount", &o.IterationCount)
			delete(rawMsg, key)
		case "outputs":
			err = unpopulate(val, "Outputs", &o.Outputs)
			delete(rawMsg, key)
		case "outputsLink":
			err = unpopulate(val, "OutputsLink", &o.OutputsLink)
			delete(rawMsg, key)
		case "retryHistory":
			err = unpopulate(val, "RetryHistory", &o.RetryHistory)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &o.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		case "trackedProperties":
			err = unpopulate(val, "TrackedProperties", &o.TrackedProperties)
			delete(rawMsg, key)
		case "trackingId":
			err = unpopulate(val, "TrackingID", &o.TrackingID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationResultProperties.
func (o OperationResultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", o.Code)
	populate(objectMap, "correlation", o.Correlation)
	populateDateTimeRFC3339(objectMap, "endTime", o.EndTime)
	populateAny(objectMap, "error", o.Error)
	populateDateTimeRFC3339(objectMap, "startTime", o.StartTime)
	populate(objectMap, "status", o.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResultProperties.
func (o *OperationResultProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &o.Code)
			delete(rawMsg, key)
		case "correlation":
			err = unpopulate(val, "Correlation", &o.Correlation)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &o.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &o.Error)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &o.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OutboundEnvironmentEndpoint.
func (o OutboundEnvironmentEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "category", o.Category)
	populate(objectMap, "endpoints", o.Endpoints)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OutboundEnvironmentEndpoint.
func (o *OutboundEnvironmentEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &o.Category)
			delete(rawMsg, key)
		case "endpoints":
			err = unpopulate(val, "Endpoints", &o.Endpoints)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OutboundEnvironmentEndpointCollection.
func (o OutboundEnvironmentEndpointCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OutboundEnvironmentEndpointCollection.
func (o *OutboundEnvironmentEndpointCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PerfMonCounterCollection.
func (p PerfMonCounterCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PerfMonCounterCollection.
func (p *PerfMonCounterCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PerfMonResponse.
func (p PerfMonResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", p.Code)
	populate(objectMap, "data", p.Data)
	populate(objectMap, "message", p.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PerfMonResponse.
func (p *PerfMonResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &p.Code)
			delete(rawMsg, key)
		case "data":
			err = unpopulate(val, "Data", &p.Data)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &p.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PerfMonSample.
func (p PerfMonSample) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "instanceName", p.InstanceName)
	populateDateTimeRFC3339(objectMap, "time", p.Time)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PerfMonSample.
func (p *PerfMonSample) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceName":
			err = unpopulate(val, "InstanceName", &p.InstanceName)
			delete(rawMsg, key)
		case "time":
			err = unpopulateDateTimeRFC3339(val, "Time", &p.Time)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PerfMonSet.
func (p PerfMonSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "endTime", p.EndTime)
	populate(objectMap, "name", p.Name)
	populateDateTimeRFC3339(objectMap, "startTime", p.StartTime)
	populate(objectMap, "timeGrain", p.TimeGrain)
	populate(objectMap, "values", p.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PerfMonSet.
func (p *PerfMonSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &p.EndTime)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &p.StartTime)
			delete(rawMsg, key)
		case "timeGrain":
			err = unpopulate(val, "TimeGrain", &p.TimeGrain)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &p.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Plan.
func (p Plan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", p.ExtendedLocation)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "sku", p.SKU)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Plan.
func (p *Plan) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &p.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &p.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PlanCollection.
func (p PlanCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PlanCollection.
func (p *PlanCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PlanPatchResource.
func (p PlanPatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PlanPatchResource.
func (p *PlanPatchResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PlanPatchResourceProperties.
func (p PlanPatchResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "elasticScaleEnabled", p.ElasticScaleEnabled)
	populateDateTimeRFC3339(objectMap, "freeOfferExpirationTime", p.FreeOfferExpirationTime)
	populate(objectMap, "geoRegion", p.GeoRegion)
	populate(objectMap, "hostingEnvironmentProfile", p.HostingEnvironmentProfile)
	populate(objectMap, "hyperV", p.HyperV)
	populate(objectMap, "isSpot", p.IsSpot)
	populate(objectMap, "isXenon", p.IsXenon)
	populate(objectMap, "kubeEnvironmentProfile", p.KubeEnvironmentProfile)
	populate(objectMap, "maximumElasticWorkerCount", p.MaximumElasticWorkerCount)
	populate(objectMap, "maximumNumberOfWorkers", p.MaximumNumberOfWorkers)
	populate(objectMap, "numberOfSites", p.NumberOfSites)
	populate(objectMap, "numberOfWorkers", p.NumberOfWorkers)
	populate(objectMap, "perSiteScaling", p.PerSiteScaling)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "reserved", p.Reserved)
	populate(objectMap, "resourceGroup", p.ResourceGroup)
	populateDateTimeRFC3339(objectMap, "spotExpirationTime", p.SpotExpirationTime)
	populate(objectMap, "status", p.Status)
	populate(objectMap, "subscription", p.Subscription)
	populate(objectMap, "targetWorkerCount", p.TargetWorkerCount)
	populate(objectMap, "targetWorkerSizeId", p.TargetWorkerSizeID)
	populate(objectMap, "workerTierName", p.WorkerTierName)
	populate(objectMap, "zoneRedundant", p.ZoneRedundant)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PlanPatchResourceProperties.
func (p *PlanPatchResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "elasticScaleEnabled":
			err = unpopulate(val, "ElasticScaleEnabled", &p.ElasticScaleEnabled)
			delete(rawMsg, key)
		case "freeOfferExpirationTime":
			err = unpopulateDateTimeRFC3339(val, "FreeOfferExpirationTime", &p.FreeOfferExpirationTime)
			delete(rawMsg, key)
		case "geoRegion":
			err = unpopulate(val, "GeoRegion", &p.GeoRegion)
			delete(rawMsg, key)
		case "hostingEnvironmentProfile":
			err = unpopulate(val, "HostingEnvironmentProfile", &p.HostingEnvironmentProfile)
			delete(rawMsg, key)
		case "hyperV":
			err = unpopulate(val, "HyperV", &p.HyperV)
			delete(rawMsg, key)
		case "isSpot":
			err = unpopulate(val, "IsSpot", &p.IsSpot)
			delete(rawMsg, key)
		case "isXenon":
			err = unpopulate(val, "IsXenon", &p.IsXenon)
			delete(rawMsg, key)
		case "kubeEnvironmentProfile":
			err = unpopulate(val, "KubeEnvironmentProfile", &p.KubeEnvironmentProfile)
			delete(rawMsg, key)
		case "maximumElasticWorkerCount":
			err = unpopulate(val, "MaximumElasticWorkerCount", &p.MaximumElasticWorkerCount)
			delete(rawMsg, key)
		case "maximumNumberOfWorkers":
			err = unpopulate(val, "MaximumNumberOfWorkers", &p.MaximumNumberOfWorkers)
			delete(rawMsg, key)
		case "numberOfSites":
			err = unpopulate(val, "NumberOfSites", &p.NumberOfSites)
			delete(rawMsg, key)
		case "numberOfWorkers":
			err = unpopulate(val, "NumberOfWorkers", &p.NumberOfWorkers)
			delete(rawMsg, key)
		case "perSiteScaling":
			err = unpopulate(val, "PerSiteScaling", &p.PerSiteScaling)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "reserved":
			err = unpopulate(val, "Reserved", &p.Reserved)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &p.ResourceGroup)
			delete(rawMsg, key)
		case "spotExpirationTime":
			err = unpopulateDateTimeRFC3339(val, "SpotExpirationTime", &p.SpotExpirationTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		case "subscription":
			err = unpopulate(val, "Subscription", &p.Subscription)
			delete(rawMsg, key)
		case "targetWorkerCount":
			err = unpopulate(val, "TargetWorkerCount", &p.TargetWorkerCount)
			delete(rawMsg, key)
		case "targetWorkerSizeId":
			err = unpopulate(val, "TargetWorkerSizeID", &p.TargetWorkerSizeID)
			delete(rawMsg, key)
		case "workerTierName":
			err = unpopulate(val, "WorkerTierName", &p.WorkerTierName)
			delete(rawMsg, key)
		case "zoneRedundant":
			err = unpopulate(val, "ZoneRedundant", &p.ZoneRedundant)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PlanProperties.
func (p PlanProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "elasticScaleEnabled", p.ElasticScaleEnabled)
	populateDateTimeRFC3339(objectMap, "freeOfferExpirationTime", p.FreeOfferExpirationTime)
	populate(objectMap, "geoRegion", p.GeoRegion)
	populate(objectMap, "hostingEnvironmentProfile", p.HostingEnvironmentProfile)
	populate(objectMap, "hyperV", p.HyperV)
	populate(objectMap, "isSpot", p.IsSpot)
	populate(objectMap, "isXenon", p.IsXenon)
	populate(objectMap, "kubeEnvironmentProfile", p.KubeEnvironmentProfile)
	populate(objectMap, "maximumElasticWorkerCount", p.MaximumElasticWorkerCount)
	populate(objectMap, "maximumNumberOfWorkers", p.MaximumNumberOfWorkers)
	populate(objectMap, "numberOfSites", p.NumberOfSites)
	populate(objectMap, "numberOfWorkers", p.NumberOfWorkers)
	populate(objectMap, "perSiteScaling", p.PerSiteScaling)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "reserved", p.Reserved)
	populate(objectMap, "resourceGroup", p.ResourceGroup)
	populateDateTimeRFC3339(objectMap, "spotExpirationTime", p.SpotExpirationTime)
	populate(objectMap, "status", p.Status)
	populate(objectMap, "subscription", p.Subscription)
	populate(objectMap, "targetWorkerCount", p.TargetWorkerCount)
	populate(objectMap, "targetWorkerSizeId", p.TargetWorkerSizeID)
	populate(objectMap, "workerTierName", p.WorkerTierName)
	populate(objectMap, "zoneRedundant", p.ZoneRedundant)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PlanProperties.
func (p *PlanProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "elasticScaleEnabled":
			err = unpopulate(val, "ElasticScaleEnabled", &p.ElasticScaleEnabled)
			delete(rawMsg, key)
		case "freeOfferExpirationTime":
			err = unpopulateDateTimeRFC3339(val, "FreeOfferExpirationTime", &p.FreeOfferExpirationTime)
			delete(rawMsg, key)
		case "geoRegion":
			err = unpopulate(val, "GeoRegion", &p.GeoRegion)
			delete(rawMsg, key)
		case "hostingEnvironmentProfile":
			err = unpopulate(val, "HostingEnvironmentProfile", &p.HostingEnvironmentProfile)
			delete(rawMsg, key)
		case "hyperV":
			err = unpopulate(val, "HyperV", &p.HyperV)
			delete(rawMsg, key)
		case "isSpot":
			err = unpopulate(val, "IsSpot", &p.IsSpot)
			delete(rawMsg, key)
		case "isXenon":
			err = unpopulate(val, "IsXenon", &p.IsXenon)
			delete(rawMsg, key)
		case "kubeEnvironmentProfile":
			err = unpopulate(val, "KubeEnvironmentProfile", &p.KubeEnvironmentProfile)
			delete(rawMsg, key)
		case "maximumElasticWorkerCount":
			err = unpopulate(val, "MaximumElasticWorkerCount", &p.MaximumElasticWorkerCount)
			delete(rawMsg, key)
		case "maximumNumberOfWorkers":
			err = unpopulate(val, "MaximumNumberOfWorkers", &p.MaximumNumberOfWorkers)
			delete(rawMsg, key)
		case "numberOfSites":
			err = unpopulate(val, "NumberOfSites", &p.NumberOfSites)
			delete(rawMsg, key)
		case "numberOfWorkers":
			err = unpopulate(val, "NumberOfWorkers", &p.NumberOfWorkers)
			delete(rawMsg, key)
		case "perSiteScaling":
			err = unpopulate(val, "PerSiteScaling", &p.PerSiteScaling)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "reserved":
			err = unpopulate(val, "Reserved", &p.Reserved)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &p.ResourceGroup)
			delete(rawMsg, key)
		case "spotExpirationTime":
			err = unpopulateDateTimeRFC3339(val, "SpotExpirationTime", &p.SpotExpirationTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		case "subscription":
			err = unpopulate(val, "Subscription", &p.Subscription)
			delete(rawMsg, key)
		case "targetWorkerCount":
			err = unpopulate(val, "TargetWorkerCount", &p.TargetWorkerCount)
			delete(rawMsg, key)
		case "targetWorkerSizeId":
			err = unpopulate(val, "TargetWorkerSizeID", &p.TargetWorkerSizeID)
			delete(rawMsg, key)
		case "workerTierName":
			err = unpopulate(val, "WorkerTierName", &p.WorkerTierName)
			delete(rawMsg, key)
		case "zoneRedundant":
			err = unpopulate(val, "ZoneRedundant", &p.ZoneRedundant)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PremierAddOn.
func (p PremierAddOn) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PremierAddOn.
func (p *PremierAddOn) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PremierAddOnOffer.
func (p PremierAddOnOffer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PremierAddOnOffer.
func (p *PremierAddOnOffer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PremierAddOnOfferCollection.
func (p PremierAddOnOfferCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PremierAddOnOfferCollection.
func (p *PremierAddOnOfferCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PremierAddOnOfferProperties.
func (p PremierAddOnOfferProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "legalTermsUrl", p.LegalTermsURL)
	populate(objectMap, "marketplaceOffer", p.MarketplaceOffer)
	populate(objectMap, "marketplacePublisher", p.MarketplacePublisher)
	populate(objectMap, "privacyPolicyUrl", p.PrivacyPolicyURL)
	populate(objectMap, "product", p.Product)
	populate(objectMap, "promoCodeRequired", p.PromoCodeRequired)
	populate(objectMap, "quota", p.Quota)
	populate(objectMap, "sku", p.SKU)
	populate(objectMap, "vendor", p.Vendor)
	populate(objectMap, "webHostingPlanRestrictions", p.WebHostingPlanRestrictions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PremierAddOnOfferProperties.
func (p *PremierAddOnOfferProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "legalTermsUrl":
			err = unpopulate(val, "LegalTermsURL", &p.LegalTermsURL)
			delete(rawMsg, key)
		case "marketplaceOffer":
			err = unpopulate(val, "MarketplaceOffer", &p.MarketplaceOffer)
			delete(rawMsg, key)
		case "marketplacePublisher":
			err = unpopulate(val, "MarketplacePublisher", &p.MarketplacePublisher)
			delete(rawMsg, key)
		case "privacyPolicyUrl":
			err = unpopulate(val, "PrivacyPolicyURL", &p.PrivacyPolicyURL)
			delete(rawMsg, key)
		case "product":
			err = unpopulate(val, "Product", &p.Product)
			delete(rawMsg, key)
		case "promoCodeRequired":
			err = unpopulate(val, "PromoCodeRequired", &p.PromoCodeRequired)
			delete(rawMsg, key)
		case "quota":
			err = unpopulate(val, "Quota", &p.Quota)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &p.SKU)
			delete(rawMsg, key)
		case "vendor":
			err = unpopulate(val, "Vendor", &p.Vendor)
			delete(rawMsg, key)
		case "webHostingPlanRestrictions":
			err = unpopulate(val, "WebHostingPlanRestrictions", &p.WebHostingPlanRestrictions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PremierAddOnPatchResource.
func (p PremierAddOnPatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PremierAddOnPatchResource.
func (p *PremierAddOnPatchResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PremierAddOnPatchResourceProperties.
func (p PremierAddOnPatchResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "marketplaceOffer", p.MarketplaceOffer)
	populate(objectMap, "marketplacePublisher", p.MarketplacePublisher)
	populate(objectMap, "product", p.Product)
	populate(objectMap, "sku", p.SKU)
	populate(objectMap, "vendor", p.Vendor)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PremierAddOnPatchResourceProperties.
func (p *PremierAddOnPatchResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "marketplaceOffer":
			err = unpopulate(val, "MarketplaceOffer", &p.MarketplaceOffer)
			delete(rawMsg, key)
		case "marketplacePublisher":
			err = unpopulate(val, "MarketplacePublisher", &p.MarketplacePublisher)
			delete(rawMsg, key)
		case "product":
			err = unpopulate(val, "Product", &p.Product)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &p.SKU)
			delete(rawMsg, key)
		case "vendor":
			err = unpopulate(val, "Vendor", &p.Vendor)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PremierAddOnProperties.
func (p PremierAddOnProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "marketplaceOffer", p.MarketplaceOffer)
	populate(objectMap, "marketplacePublisher", p.MarketplacePublisher)
	populate(objectMap, "product", p.Product)
	populate(objectMap, "sku", p.SKU)
	populate(objectMap, "vendor", p.Vendor)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PremierAddOnProperties.
func (p *PremierAddOnProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "marketplaceOffer":
			err = unpopulate(val, "MarketplaceOffer", &p.MarketplaceOffer)
			delete(rawMsg, key)
		case "marketplacePublisher":
			err = unpopulate(val, "MarketplacePublisher", &p.MarketplacePublisher)
			delete(rawMsg, key)
		case "product":
			err = unpopulate(val, "Product", &p.Product)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &p.SKU)
			delete(rawMsg, key)
		case "vendor":
			err = unpopulate(val, "Vendor", &p.Vendor)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateAccess.
func (p PrivateAccess) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateAccess.
func (p *PrivateAccess) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateAccessProperties.
func (p PrivateAccessProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", p.Enabled)
	populate(objectMap, "virtualNetworks", p.VirtualNetworks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateAccessProperties.
func (p *PrivateAccessProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &p.Enabled)
			delete(rawMsg, key)
		case "virtualNetworks":
			err = unpopulate(val, "VirtualNetworks", &p.VirtualNetworks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateAccessSubnet.
func (p PrivateAccessSubnet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "key", p.Key)
	populate(objectMap, "name", p.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateAccessSubnet.
func (p *PrivateAccessSubnet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &p.Key)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateAccessVirtualNetwork.
func (p PrivateAccessVirtualNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "key", p.Key)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "resourceId", p.ResourceID)
	populate(objectMap, "subnets", p.Subnets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateAccessVirtualNetwork.
func (p *PrivateAccessVirtualNetwork) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &p.Key)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &p.ResourceID)
			delete(rawMsg, key)
		case "subnets":
			err = unpopulate(val, "Subnets", &p.Subnets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionCollection.
func (p PrivateEndpointConnectionCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionCollection.
func (p *PrivateEndpointConnectionCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkConnectionApprovalRequest.
func (p PrivateLinkConnectionApprovalRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateLinkServiceConnectionState", p.PrivateLinkServiceConnectionState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkConnectionApprovalRequest.
func (p *PrivateLinkConnectionApprovalRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateLinkServiceConnectionState":
			err = unpopulate(val, "PrivateLinkServiceConnectionState", &p.PrivateLinkServiceConnectionState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkConnectionApprovalRequestResource.
func (p PrivateLinkConnectionApprovalRequestResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkConnectionApprovalRequestResource.
func (p *PrivateLinkConnectionApprovalRequestResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkConnectionState.
func (p PrivateLinkConnectionState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionsRequired", p.ActionsRequired)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkConnectionState.
func (p *PrivateLinkConnectionState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionsRequired":
			err = unpopulate(val, "ActionsRequired", &p.ActionsRequired)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResource.
func (p PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResource.
func (p *PrivateLinkResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceProperties.
func (p PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "requiredMembers", p.RequiredMembers)
	populate(objectMap, "requiredZoneNames", p.RequiredZoneNames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceProperties.
func (p *PrivateLinkResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupId":
			err = unpopulate(val, "GroupID", &p.GroupID)
			delete(rawMsg, key)
		case "requiredMembers":
			err = unpopulate(val, "RequiredMembers", &p.RequiredMembers)
			delete(rawMsg, key)
		case "requiredZoneNames":
			err = unpopulate(val, "RequiredZoneNames", &p.RequiredZoneNames)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourcesWrapper.
func (p PrivateLinkResourcesWrapper) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourcesWrapper.
func (p *PrivateLinkResourcesWrapper) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProcessInfo.
func (p ProcessInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProcessInfo.
func (p *ProcessInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProcessInfoCollection.
func (p ProcessInfoCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProcessInfoCollection.
func (p *ProcessInfoCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProcessInfoProperties.
func (p ProcessInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "children", p.Children)
	populate(objectMap, "command_line", p.CommandLine)
	populate(objectMap, "deployment_name", p.DeploymentName)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "environment_variables", p.EnvironmentVariables)
	populate(objectMap, "file_name", p.FileName)
	populate(objectMap, "handle_count", p.HandleCount)
	populate(objectMap, "href", p.Href)
	populate(objectMap, "identifier", p.Identifier)
	populate(objectMap, "iis_profile_timeout_in_seconds", p.IisProfileTimeoutInSeconds)
	populate(objectMap, "is_iis_profile_running", p.IsIisProfileRunning)
	populate(objectMap, "is_profile_running", p.IsProfileRunning)
	populate(objectMap, "is_scm_site", p.IsScmSite)
	populate(objectMap, "is_webjob", p.IsWebjob)
	populate(objectMap, "minidump", p.Minidump)
	populate(objectMap, "module_count", p.ModuleCount)
	populate(objectMap, "modules", p.Modules)
	populate(objectMap, "non_paged_system_memory", p.NonPagedSystemMemory)
	populate(objectMap, "open_file_handles", p.OpenFileHandles)
	populate(objectMap, "paged_memory", p.PagedMemory)
	populate(objectMap, "paged_system_memory", p.PagedSystemMemory)
	populate(objectMap, "parent", p.Parent)
	populate(objectMap, "peak_paged_memory", p.PeakPagedMemory)
	populate(objectMap, "peak_virtual_memory", p.PeakVirtualMemory)
	populate(objectMap, "peak_working_set", p.PeakWorkingSet)
	populate(objectMap, "private_memory", p.PrivateMemory)
	populate(objectMap, "privileged_cpu_time", p.PrivilegedCPUTime)
	populateDateTimeRFC3339(objectMap, "start_time", p.StartTime)
	populate(objectMap, "thread_count", p.ThreadCount)
	populate(objectMap, "threads", p.Threads)
	populateDateTimeRFC3339(objectMap, "time_stamp", p.TimeStamp)
	populate(objectMap, "total_cpu_time", p.TotalCPUTime)
	populate(objectMap, "user_cpu_time", p.UserCPUTime)
	populate(objectMap, "user_name", p.UserName)
	populate(objectMap, "virtual_memory", p.VirtualMemory)
	populate(objectMap, "working_set", p.WorkingSet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProcessInfoProperties.
func (p *ProcessInfoProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "children":
			err = unpopulate(val, "Children", &p.Children)
			delete(rawMsg, key)
		case "command_line":
			err = unpopulate(val, "CommandLine", &p.CommandLine)
			delete(rawMsg, key)
		case "deployment_name":
			err = unpopulate(val, "DeploymentName", &p.DeploymentName)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "environment_variables":
			err = unpopulate(val, "EnvironmentVariables", &p.EnvironmentVariables)
			delete(rawMsg, key)
		case "file_name":
			err = unpopulate(val, "FileName", &p.FileName)
			delete(rawMsg, key)
		case "handle_count":
			err = unpopulate(val, "HandleCount", &p.HandleCount)
			delete(rawMsg, key)
		case "href":
			err = unpopulate(val, "Href", &p.Href)
			delete(rawMsg, key)
		case "identifier":
			err = unpopulate(val, "Identifier", &p.Identifier)
			delete(rawMsg, key)
		case "iis_profile_timeout_in_seconds":
			err = unpopulate(val, "IisProfileTimeoutInSeconds", &p.IisProfileTimeoutInSeconds)
			delete(rawMsg, key)
		case "is_iis_profile_running":
			err = unpopulate(val, "IsIisProfileRunning", &p.IsIisProfileRunning)
			delete(rawMsg, key)
		case "is_profile_running":
			err = unpopulate(val, "IsProfileRunning", &p.IsProfileRunning)
			delete(rawMsg, key)
		case "is_scm_site":
			err = unpopulate(val, "IsScmSite", &p.IsScmSite)
			delete(rawMsg, key)
		case "is_webjob":
			err = unpopulate(val, "IsWebjob", &p.IsWebjob)
			delete(rawMsg, key)
		case "minidump":
			err = unpopulate(val, "Minidump", &p.Minidump)
			delete(rawMsg, key)
		case "module_count":
			err = unpopulate(val, "ModuleCount", &p.ModuleCount)
			delete(rawMsg, key)
		case "modules":
			err = unpopulate(val, "Modules", &p.Modules)
			delete(rawMsg, key)
		case "non_paged_system_memory":
			err = unpopulate(val, "NonPagedSystemMemory", &p.NonPagedSystemMemory)
			delete(rawMsg, key)
		case "open_file_handles":
			err = unpopulate(val, "OpenFileHandles", &p.OpenFileHandles)
			delete(rawMsg, key)
		case "paged_memory":
			err = unpopulate(val, "PagedMemory", &p.PagedMemory)
			delete(rawMsg, key)
		case "paged_system_memory":
			err = unpopulate(val, "PagedSystemMemory", &p.PagedSystemMemory)
			delete(rawMsg, key)
		case "parent":
			err = unpopulate(val, "Parent", &p.Parent)
			delete(rawMsg, key)
		case "peak_paged_memory":
			err = unpopulate(val, "PeakPagedMemory", &p.PeakPagedMemory)
			delete(rawMsg, key)
		case "peak_virtual_memory":
			err = unpopulate(val, "PeakVirtualMemory", &p.PeakVirtualMemory)
			delete(rawMsg, key)
		case "peak_working_set":
			err = unpopulate(val, "PeakWorkingSet", &p.PeakWorkingSet)
			delete(rawMsg, key)
		case "private_memory":
			err = unpopulate(val, "PrivateMemory", &p.PrivateMemory)
			delete(rawMsg, key)
		case "privileged_cpu_time":
			err = unpopulate(val, "PrivilegedCPUTime", &p.PrivilegedCPUTime)
			delete(rawMsg, key)
		case "start_time":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &p.StartTime)
			delete(rawMsg, key)
		case "thread_count":
			err = unpopulate(val, "ThreadCount", &p.ThreadCount)
			delete(rawMsg, key)
		case "threads":
			err = unpopulate(val, "Threads", &p.Threads)
			delete(rawMsg, key)
		case "time_stamp":
			err = unpopulateDateTimeRFC3339(val, "TimeStamp", &p.TimeStamp)
			delete(rawMsg, key)
		case "total_cpu_time":
			err = unpopulate(val, "TotalCPUTime", &p.TotalCPUTime)
			delete(rawMsg, key)
		case "user_cpu_time":
			err = unpopulate(val, "UserCPUTime", &p.UserCPUTime)
			delete(rawMsg, key)
		case "user_name":
			err = unpopulate(val, "UserName", &p.UserName)
			delete(rawMsg, key)
		case "virtual_memory":
			err = unpopulate(val, "VirtualMemory", &p.VirtualMemory)
			delete(rawMsg, key)
		case "working_set":
			err = unpopulate(val, "WorkingSet", &p.WorkingSet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProcessModuleInfo.
func (p ProcessModuleInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProcessModuleInfo.
func (p *ProcessModuleInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProcessModuleInfoCollection.
func (p ProcessModuleInfoCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProcessModuleInfoCollection.
func (p *ProcessModuleInfoCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProcessModuleInfoProperties.
func (p ProcessModuleInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "base_address", p.BaseAddress)
	populate(objectMap, "file_description", p.FileDescription)
	populate(objectMap, "file_name", p.FileName)
	populate(objectMap, "file_path", p.FilePath)
	populate(objectMap, "file_version", p.FileVersion)
	populate(objectMap, "href", p.Href)
	populate(objectMap, "is_debug", p.IsDebug)
	populate(objectMap, "language", p.Language)
	populate(objectMap, "module_memory_size", p.ModuleMemorySize)
	populate(objectMap, "product", p.Product)
	populate(objectMap, "product_version", p.ProductVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProcessModuleInfoProperties.
func (p *ProcessModuleInfoProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "base_address":
			err = unpopulate(val, "BaseAddress", &p.BaseAddress)
			delete(rawMsg, key)
		case "file_description":
			err = unpopulate(val, "FileDescription", &p.FileDescription)
			delete(rawMsg, key)
		case "file_name":
			err = unpopulate(val, "FileName", &p.FileName)
			delete(rawMsg, key)
		case "file_path":
			err = unpopulate(val, "FilePath", &p.FilePath)
			delete(rawMsg, key)
		case "file_version":
			err = unpopulate(val, "FileVersion", &p.FileVersion)
			delete(rawMsg, key)
		case "href":
			err = unpopulate(val, "Href", &p.Href)
			delete(rawMsg, key)
		case "is_debug":
			err = unpopulate(val, "IsDebug", &p.IsDebug)
			delete(rawMsg, key)
		case "language":
			err = unpopulate(val, "Language", &p.Language)
			delete(rawMsg, key)
		case "module_memory_size":
			err = unpopulate(val, "ModuleMemorySize", &p.ModuleMemorySize)
			delete(rawMsg, key)
		case "product":
			err = unpopulate(val, "Product", &p.Product)
			delete(rawMsg, key)
		case "product_version":
			err = unpopulate(val, "ProductVersion", &p.ProductVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProcessThreadInfo.
func (p ProcessThreadInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProcessThreadInfo.
func (p *ProcessThreadInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProcessThreadInfoCollection.
func (p ProcessThreadInfoCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProcessThreadInfoCollection.
func (p *ProcessThreadInfoCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProcessThreadInfoProperties.
func (p ProcessThreadInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "base_priority", p.BasePriority)
	populate(objectMap, "current_priority", p.CurrentPriority)
	populate(objectMap, "href", p.Href)
	populate(objectMap, "identifier", p.Identifier)
	populate(objectMap, "priority_level", p.PriorityLevel)
	populate(objectMap, "process", p.Process)
	populate(objectMap, "start_address", p.StartAddress)
	populateDateTimeRFC3339(objectMap, "start_time", p.StartTime)
	populate(objectMap, "state", p.State)
	populate(objectMap, "total_processor_time", p.TotalProcessorTime)
	populate(objectMap, "user_processor_time", p.UserProcessorTime)
	populate(objectMap, "wait_reason", p.WaitReason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProcessThreadInfoProperties.
func (p *ProcessThreadInfoProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "base_priority":
			err = unpopulate(val, "BasePriority", &p.BasePriority)
			delete(rawMsg, key)
		case "current_priority":
			err = unpopulate(val, "CurrentPriority", &p.CurrentPriority)
			delete(rawMsg, key)
		case "href":
			err = unpopulate(val, "Href", &p.Href)
			delete(rawMsg, key)
		case "identifier":
			err = unpopulate(val, "Identifier", &p.Identifier)
			delete(rawMsg, key)
		case "priority_level":
			err = unpopulate(val, "PriorityLevel", &p.PriorityLevel)
			delete(rawMsg, key)
		case "process":
			err = unpopulate(val, "Process", &p.Process)
			delete(rawMsg, key)
		case "start_address":
			err = unpopulate(val, "StartAddress", &p.StartAddress)
			delete(rawMsg, key)
		case "start_time":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &p.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &p.State)
			delete(rawMsg, key)
		case "total_processor_time":
			err = unpopulate(val, "TotalProcessorTime", &p.TotalProcessorTime)
			delete(rawMsg, key)
		case "user_processor_time":
			err = unpopulate(val, "UserProcessorTime", &p.UserProcessorTime)
			delete(rawMsg, key)
		case "wait_reason":
			err = unpopulate(val, "WaitReason", &p.WaitReason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyOnlyResource.
func (p ProxyOnlyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyOnlyResource.
func (p *ProxyOnlyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublicCertificate.
func (p PublicCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublicCertificate.
func (p *PublicCertificate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublicCertificateCollection.
func (p PublicCertificateCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublicCertificateCollection.
func (p *PublicCertificateCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublicCertificateProperties.
func (p PublicCertificateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateByteArray(objectMap, "blob", p.Blob, runtime.Base64StdFormat)
	populate(objectMap, "publicCertificateLocation", p.PublicCertificateLocation)
	populate(objectMap, "thumbprint", p.Thumbprint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublicCertificateProperties.
func (p *PublicCertificateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blob":
			err = runtime.DecodeByteArray(string(val), &p.Blob, runtime.Base64StdFormat)
			delete(rawMsg, key)
		case "publicCertificateLocation":
			err = unpopulate(val, "PublicCertificateLocation", &p.PublicCertificateLocation)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &p.Thumbprint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublishingCredentialsPoliciesCollection.
func (p PublishingCredentialsPoliciesCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublishingCredentialsPoliciesCollection.
func (p *PublishingCredentialsPoliciesCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PushSettings.
func (p PushSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PushSettings.
func (p *PushSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PushSettingsProperties.
func (p PushSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dynamicTagsJson", p.DynamicTagsJSON)
	populate(objectMap, "isPushEnabled", p.IsPushEnabled)
	populate(objectMap, "tagWhitelistJson", p.TagWhitelistJSON)
	populate(objectMap, "tagsRequiringAuth", p.TagsRequiringAuth)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PushSettingsProperties.
func (p *PushSettingsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dynamicTagsJson":
			err = unpopulate(val, "DynamicTagsJSON", &p.DynamicTagsJSON)
			delete(rawMsg, key)
		case "isPushEnabled":
			err = unpopulate(val, "IsPushEnabled", &p.IsPushEnabled)
			delete(rawMsg, key)
		case "tagWhitelistJson":
			err = unpopulate(val, "TagWhitelistJSON", &p.TagWhitelistJSON)
			delete(rawMsg, key)
		case "tagsRequiringAuth":
			err = unpopulate(val, "TagsRequiringAuth", &p.TagsRequiringAuth)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryUtterancesResult.
func (q QueryUtterancesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sampleUtterance", q.SampleUtterance)
	populate(objectMap, "score", q.Score)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryUtterancesResult.
func (q *QueryUtterancesResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sampleUtterance":
			err = unpopulate(val, "SampleUtterance", &q.SampleUtterance)
			delete(rawMsg, key)
		case "score":
			err = unpopulate(val, "Score", &q.Score)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryUtterancesResults.
func (q QueryUtterancesResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "query", q.Query)
	populate(objectMap, "results", q.Results)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryUtterancesResults.
func (q *QueryUtterancesResults) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "query":
			err = unpopulate(val, "Query", &q.Query)
			delete(rawMsg, key)
		case "results":
			err = unpopulate(val, "Results", &q.Results)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueueScaleRule.
func (q QueueScaleRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "auth", q.Auth)
	populate(objectMap, "queueLength", q.QueueLength)
	populate(objectMap, "queueName", q.QueueName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueueScaleRule.
func (q *QueueScaleRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "auth":
			err = unpopulate(val, "Auth", &q.Auth)
			delete(rawMsg, key)
		case "queueLength":
			err = unpopulate(val, "QueueLength", &q.QueueLength)
			delete(rawMsg, key)
		case "queueName":
			err = unpopulate(val, "QueueName", &q.QueueName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RampUpRule.
func (r RampUpRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionHostName", r.ActionHostName)
	populate(objectMap, "changeDecisionCallbackUrl", r.ChangeDecisionCallbackURL)
	populate(objectMap, "changeIntervalInMinutes", r.ChangeIntervalInMinutes)
	populate(objectMap, "changeStep", r.ChangeStep)
	populate(objectMap, "maxReroutePercentage", r.MaxReroutePercentage)
	populate(objectMap, "minReroutePercentage", r.MinReroutePercentage)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "reroutePercentage", r.ReroutePercentage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RampUpRule.
func (r *RampUpRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionHostName":
			err = unpopulate(val, "ActionHostName", &r.ActionHostName)
			delete(rawMsg, key)
		case "changeDecisionCallbackUrl":
			err = unpopulate(val, "ChangeDecisionCallbackURL", &r.ChangeDecisionCallbackURL)
			delete(rawMsg, key)
		case "changeIntervalInMinutes":
			err = unpopulate(val, "ChangeIntervalInMinutes", &r.ChangeIntervalInMinutes)
			delete(rawMsg, key)
		case "changeStep":
			err = unpopulate(val, "ChangeStep", &r.ChangeStep)
			delete(rawMsg, key)
		case "maxReroutePercentage":
			err = unpopulate(val, "MaxReroutePercentage", &r.MaxReroutePercentage)
			delete(rawMsg, key)
		case "minReroutePercentage":
			err = unpopulate(val, "MinReroutePercentage", &r.MinReroutePercentage)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "reroutePercentage":
			err = unpopulate(val, "ReroutePercentage", &r.ReroutePercentage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Recommendation.
func (r Recommendation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "kind", r.Kind)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Recommendation.
func (r *Recommendation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecommendationCollection.
func (r RecommendationCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecommendationCollection.
func (r *RecommendationCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecommendationProperties.
func (r RecommendationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionName", r.ActionName)
	populate(objectMap, "bladeName", r.BladeName)
	populate(objectMap, "categoryTags", r.CategoryTags)
	populate(objectMap, "channels", r.Channels)
	populateDateTimeRFC3339(objectMap, "creationTime", r.CreationTime)
	populate(objectMap, "displayName", r.DisplayName)
	populate(objectMap, "enabled", r.Enabled)
	populateDateTimeRFC3339(objectMap, "endTime", r.EndTime)
	populate(objectMap, "extensionName", r.ExtensionName)
	populate(objectMap, "forwardLink", r.ForwardLink)
	populate(objectMap, "isDynamic", r.IsDynamic)
	populate(objectMap, "level", r.Level)
	populate(objectMap, "message", r.Message)
	populateDateTimeRFC3339(objectMap, "nextNotificationTime", r.NextNotificationTime)
	populateDateTimeRFC3339(objectMap, "notificationExpirationTime", r.NotificationExpirationTime)
	populateDateTimeRFC3339(objectMap, "notifiedTime", r.NotifiedTime)
	populate(objectMap, "recommendationId", r.RecommendationID)
	populate(objectMap, "resourceId", r.ResourceID)
	populate(objectMap, "resourceScope", r.ResourceScope)
	populate(objectMap, "ruleName", r.RuleName)
	populate(objectMap, "score", r.Score)
	populateDateTimeRFC3339(objectMap, "startTime", r.StartTime)
	populate(objectMap, "states", r.States)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecommendationProperties.
func (r *RecommendationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionName":
			err = unpopulate(val, "ActionName", &r.ActionName)
			delete(rawMsg, key)
		case "bladeName":
			err = unpopulate(val, "BladeName", &r.BladeName)
			delete(rawMsg, key)
		case "categoryTags":
			err = unpopulate(val, "CategoryTags", &r.CategoryTags)
			delete(rawMsg, key)
		case "channels":
			err = unpopulate(val, "Channels", &r.Channels)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateDateTimeRFC3339(val, "CreationTime", &r.CreationTime)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &r.DisplayName)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &r.Enabled)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &r.EndTime)
			delete(rawMsg, key)
		case "extensionName":
			err = unpopulate(val, "ExtensionName", &r.ExtensionName)
			delete(rawMsg, key)
		case "forwardLink":
			err = unpopulate(val, "ForwardLink", &r.ForwardLink)
			delete(rawMsg, key)
		case "isDynamic":
			err = unpopulate(val, "IsDynamic", &r.IsDynamic)
			delete(rawMsg, key)
		case "level":
			err = unpopulate(val, "Level", &r.Level)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &r.Message)
			delete(rawMsg, key)
		case "nextNotificationTime":
			err = unpopulateDateTimeRFC3339(val, "NextNotificationTime", &r.NextNotificationTime)
			delete(rawMsg, key)
		case "notificationExpirationTime":
			err = unpopulateDateTimeRFC3339(val, "NotificationExpirationTime", &r.NotificationExpirationTime)
			delete(rawMsg, key)
		case "notifiedTime":
			err = unpopulateDateTimeRFC3339(val, "NotifiedTime", &r.NotifiedTime)
			delete(rawMsg, key)
		case "recommendationId":
			err = unpopulate(val, "RecommendationID", &r.RecommendationID)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &r.ResourceID)
			delete(rawMsg, key)
		case "resourceScope":
			err = unpopulate(val, "ResourceScope", &r.ResourceScope)
			delete(rawMsg, key)
		case "ruleName":
			err = unpopulate(val, "RuleName", &r.RuleName)
			delete(rawMsg, key)
		case "score":
			err = unpopulate(val, "Score", &r.Score)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &r.StartTime)
			delete(rawMsg, key)
		case "states":
			err = unpopulate(val, "States", &r.States)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecommendationRule.
func (r RecommendationRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "kind", r.Kind)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecommendationRule.
func (r *RecommendationRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecommendationRuleProperties.
func (r RecommendationRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionName", r.ActionName)
	populate(objectMap, "bladeName", r.BladeName)
	populate(objectMap, "categoryTags", r.CategoryTags)
	populate(objectMap, "channels", r.Channels)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "displayName", r.DisplayName)
	populate(objectMap, "extensionName", r.ExtensionName)
	populate(objectMap, "forwardLink", r.ForwardLink)
	populate(objectMap, "isDynamic", r.IsDynamic)
	populate(objectMap, "level", r.Level)
	populate(objectMap, "message", r.Message)
	populate(objectMap, "recommendationId", r.RecommendationID)
	populate(objectMap, "recommendationName", r.RecommendationName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecommendationRuleProperties.
func (r *RecommendationRuleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionName":
			err = unpopulate(val, "ActionName", &r.ActionName)
			delete(rawMsg, key)
		case "bladeName":
			err = unpopulate(val, "BladeName", &r.BladeName)
			delete(rawMsg, key)
		case "categoryTags":
			err = unpopulate(val, "CategoryTags", &r.CategoryTags)
			delete(rawMsg, key)
		case "channels":
			err = unpopulate(val, "Channels", &r.Channels)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &r.DisplayName)
			delete(rawMsg, key)
		case "extensionName":
			err = unpopulate(val, "ExtensionName", &r.ExtensionName)
			delete(rawMsg, key)
		case "forwardLink":
			err = unpopulate(val, "ForwardLink", &r.ForwardLink)
			delete(rawMsg, key)
		case "isDynamic":
			err = unpopulate(val, "IsDynamic", &r.IsDynamic)
			delete(rawMsg, key)
		case "level":
			err = unpopulate(val, "Level", &r.Level)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &r.Message)
			delete(rawMsg, key)
		case "recommendationId":
			err = unpopulate(val, "RecommendationID", &r.RecommendationID)
			delete(rawMsg, key)
		case "recommendationName":
			err = unpopulate(val, "RecommendationName", &r.RecommendationName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecurrenceSchedule.
func (r RecurrenceSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hours", r.Hours)
	populate(objectMap, "minutes", r.Minutes)
	populate(objectMap, "monthDays", r.MonthDays)
	populate(objectMap, "monthlyOccurrences", r.MonthlyOccurrences)
	populate(objectMap, "weekDays", r.WeekDays)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecurrenceSchedule.
func (r *RecurrenceSchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hours":
			err = unpopulate(val, "Hours", &r.Hours)
			delete(rawMsg, key)
		case "minutes":
			err = unpopulate(val, "Minutes", &r.Minutes)
			delete(rawMsg, key)
		case "monthDays":
			err = unpopulate(val, "MonthDays", &r.MonthDays)
			delete(rawMsg, key)
		case "monthlyOccurrences":
			err = unpopulate(val, "MonthlyOccurrences", &r.MonthlyOccurrences)
			delete(rawMsg, key)
		case "weekDays":
			err = unpopulate(val, "WeekDays", &r.WeekDays)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecurrenceScheduleOccurrence.
func (r RecurrenceScheduleOccurrence) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "day", r.Day)
	populate(objectMap, "occurrence", r.Occurrence)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecurrenceScheduleOccurrence.
func (r *RecurrenceScheduleOccurrence) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "day":
			err = unpopulate(val, "Day", &r.Day)
			delete(rawMsg, key)
		case "occurrence":
			err = unpopulate(val, "Occurrence", &r.Occurrence)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegenerateActionParameter.
func (r RegenerateActionParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyType", r.KeyType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegenerateActionParameter.
func (r *RegenerateActionParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyType":
			err = unpopulate(val, "KeyType", &r.KeyType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegistryCredentials.
func (r RegistryCredentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "passwordSecretRef", r.PasswordSecretRef)
	populate(objectMap, "server", r.Server)
	populate(objectMap, "username", r.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegistryCredentials.
func (r *RegistryCredentials) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "passwordSecretRef":
			err = unpopulate(val, "PasswordSecretRef", &r.PasswordSecretRef)
			delete(rawMsg, key)
		case "server":
			err = unpopulate(val, "Server", &r.Server)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &r.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReissueCertificateOrderRequest.
func (r ReissueCertificateOrderRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "kind", r.Kind)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReissueCertificateOrderRequest.
func (r *ReissueCertificateOrderRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReissueCertificateOrderRequestProperties.
func (r ReissueCertificateOrderRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "csr", r.Csr)
	populate(objectMap, "delayExistingRevokeInHours", r.DelayExistingRevokeInHours)
	populate(objectMap, "isPrivateKeyExternal", r.IsPrivateKeyExternal)
	populate(objectMap, "keySize", r.KeySize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReissueCertificateOrderRequestProperties.
func (r *ReissueCertificateOrderRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "csr":
			err = unpopulate(val, "Csr", &r.Csr)
			delete(rawMsg, key)
		case "delayExistingRevokeInHours":
			err = unpopulate(val, "DelayExistingRevokeInHours", &r.DelayExistingRevokeInHours)
			delete(rawMsg, key)
		case "isPrivateKeyExternal":
			err = unpopulate(val, "IsPrivateKeyExternal", &r.IsPrivateKeyExternal)
			delete(rawMsg, key)
		case "keySize":
			err = unpopulate(val, "KeySize", &r.KeySize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RelayServiceConnectionEntity.
func (r RelayServiceConnectionEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "kind", r.Kind)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RelayServiceConnectionEntity.
func (r *RelayServiceConnectionEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RelayServiceConnectionEntityProperties.
func (r RelayServiceConnectionEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "biztalkUri", r.BiztalkURI)
	populate(objectMap, "entityConnectionString", r.EntityConnectionString)
	populate(objectMap, "entityName", r.EntityName)
	populate(objectMap, "hostname", r.Hostname)
	populate(objectMap, "port", r.Port)
	populate(objectMap, "resourceConnectionString", r.ResourceConnectionString)
	populate(objectMap, "resourceType", r.ResourceType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RelayServiceConnectionEntityProperties.
func (r *RelayServiceConnectionEntityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "biztalkUri":
			err = unpopulate(val, "BiztalkURI", &r.BiztalkURI)
			delete(rawMsg, key)
		case "entityConnectionString":
			err = unpopulate(val, "EntityConnectionString", &r.EntityConnectionString)
			delete(rawMsg, key)
		case "entityName":
			err = unpopulate(val, "EntityName", &r.EntityName)
			delete(rawMsg, key)
		case "hostname":
			err = unpopulate(val, "Hostname", &r.Hostname)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &r.Port)
			delete(rawMsg, key)
		case "resourceConnectionString":
			err = unpopulate(val, "ResourceConnectionString", &r.ResourceConnectionString)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &r.ResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RemotePrivateEndpointConnection.
func (r RemotePrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "kind", r.Kind)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RemotePrivateEndpointConnection.
func (r *RemotePrivateEndpointConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RemotePrivateEndpointConnectionARMResource.
func (r RemotePrivateEndpointConnectionARMResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "kind", r.Kind)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RemotePrivateEndpointConnectionARMResource.
func (r *RemotePrivateEndpointConnectionARMResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RemotePrivateEndpointConnectionARMResourceProperties.
func (r RemotePrivateEndpointConnectionARMResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipAddresses", r.IPAddresses)
	populate(objectMap, "privateEndpoint", r.PrivateEndpoint)
	populate(objectMap, "privateLinkServiceConnectionState", r.PrivateLinkServiceConnectionState)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RemotePrivateEndpointConnectionARMResourceProperties.
func (r *RemotePrivateEndpointConnectionARMResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipAddresses":
			err = unpopulate(val, "IPAddresses", &r.IPAddresses)
			delete(rawMsg, key)
		case "privateEndpoint":
			err = unpopulate(val, "PrivateEndpoint", &r.PrivateEndpoint)
			delete(rawMsg, key)
		case "privateLinkServiceConnectionState":
			err = unpopulate(val, "PrivateLinkServiceConnectionState", &r.PrivateLinkServiceConnectionState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RemotePrivateEndpointConnectionProperties.
func (r RemotePrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipAddresses", r.IPAddresses)
	populate(objectMap, "privateEndpoint", r.PrivateEndpoint)
	populate(objectMap, "privateLinkServiceConnectionState", r.PrivateLinkServiceConnectionState)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RemotePrivateEndpointConnectionProperties.
func (r *RemotePrivateEndpointConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipAddresses":
			err = unpopulate(val, "IPAddresses", &r.IPAddresses)
			delete(rawMsg, key)
		case "privateEndpoint":
			err = unpopulate(val, "PrivateEndpoint", &r.PrivateEndpoint)
			delete(rawMsg, key)
		case "privateLinkServiceConnectionState":
			err = unpopulate(val, "PrivateLinkServiceConnectionState", &r.PrivateLinkServiceConnectionState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Rendering.
func (r Rendering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "title", r.Title)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Rendering.
func (r *Rendering) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &r.Title)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RenewCertificateOrderRequest.
func (r RenewCertificateOrderRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "kind", r.Kind)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RenewCertificateOrderRequest.
func (r *RenewCertificateOrderRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RenewCertificateOrderRequestProperties.
func (r RenewCertificateOrderRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "csr", r.Csr)
	populate(objectMap, "isPrivateKeyExternal", r.IsPrivateKeyExternal)
	populate(objectMap, "keySize", r.KeySize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RenewCertificateOrderRequestProperties.
func (r *RenewCertificateOrderRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "csr":
			err = unpopulate(val, "Csr", &r.Csr)
			delete(rawMsg, key)
		case "isPrivateKeyExternal":
			err = unpopulate(val, "IsPrivateKeyExternal", &r.IsPrivateKeyExternal)
			delete(rawMsg, key)
		case "keySize":
			err = unpopulate(val, "KeySize", &r.KeySize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RepetitionIndex.
func (r RepetitionIndex) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "itemIndex", r.ItemIndex)
	populate(objectMap, "scopeName", r.ScopeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RepetitionIndex.
func (r *RepetitionIndex) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "itemIndex":
			err = unpopulate(val, "ItemIndex", &r.ItemIndex)
			delete(rawMsg, key)
		case "scopeName":
			err = unpopulate(val, "ScopeName", &r.ScopeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Request.
func (r Request) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "headers", r.Headers)
	populate(objectMap, "method", r.Method)
	populate(objectMap, "uri", r.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Request.
func (r *Request) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "headers":
			err = unpopulate(val, "Headers", &r.Headers)
			delete(rawMsg, key)
		case "method":
			err = unpopulate(val, "Method", &r.Method)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &r.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequestHistory.
func (r RequestHistory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestHistory.
func (r *RequestHistory) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequestHistoryListResult.
func (r RequestHistoryListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestHistoryListResult.
func (r *RequestHistoryListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequestHistoryProperties.
func (r RequestHistoryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "endTime", r.EndTime)
	populate(objectMap, "request", r.Request)
	populate(objectMap, "response", r.Response)
	populateDateTimeRFC3339(objectMap, "startTime", r.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestHistoryProperties.
func (r *RequestHistoryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &r.EndTime)
			delete(rawMsg, key)
		case "request":
			err = unpopulate(val, "Request", &r.Request)
			delete(rawMsg, key)
		case "response":
			err = unpopulate(val, "Response", &r.Response)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &r.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequestsBasedTrigger.
func (r RequestsBasedTrigger) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", r.Count)
	populate(objectMap, "timeInterval", r.TimeInterval)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestsBasedTrigger.
func (r *RequestsBasedTrigger) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &r.Count)
			delete(rawMsg, key)
		case "timeInterval":
			err = unpopulate(val, "TimeInterval", &r.TimeInterval)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "kind", r.Kind)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceCollection.
func (r ResourceCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceCollection.
func (r *ResourceCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceConfig.
func (r ResourceConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cpu", r.CPU)
	populate(objectMap, "memory", r.Memory)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceConfig.
func (r *ResourceConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cpu":
			err = unpopulate(val, "CPU", &r.CPU)
			delete(rawMsg, key)
		case "memory":
			err = unpopulate(val, "Memory", &r.Memory)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceHealthMetadata.
func (r ResourceHealthMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "kind", r.Kind)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceHealthMetadata.
func (r *ResourceHealthMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceHealthMetadataCollection.
func (r ResourceHealthMetadataCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceHealthMetadataCollection.
func (r *ResourceHealthMetadataCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceHealthMetadataProperties.
func (r ResourceHealthMetadataProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "category", r.Category)
	populate(objectMap, "signalAvailability", r.SignalAvailability)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceHealthMetadataProperties.
func (r *ResourceHealthMetadataProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &r.Category)
			delete(rawMsg, key)
		case "signalAvailability":
			err = unpopulate(val, "SignalAvailability", &r.SignalAvailability)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceMetricAvailability.
func (r ResourceMetricAvailability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "retention", r.Retention)
	populate(objectMap, "timeGrain", r.TimeGrain)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceMetricAvailability.
func (r *ResourceMetricAvailability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "retention":
			err = unpopulate(val, "Retention", &r.Retention)
			delete(rawMsg, key)
		case "timeGrain":
			err = unpopulate(val, "TimeGrain", &r.TimeGrain)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceMetricDefinition.
func (r ResourceMetricDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "kind", r.Kind)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceMetricDefinition.
func (r *ResourceMetricDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceMetricDefinitionCollection.
func (r ResourceMetricDefinitionCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceMetricDefinitionCollection.
func (r *ResourceMetricDefinitionCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceMetricDefinitionProperties.
func (r ResourceMetricDefinitionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "metricAvailabilities", r.MetricAvailabilities)
	populate(objectMap, "primaryAggregationType", r.PrimaryAggregationType)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "resourceUri", r.ResourceURI)
	populate(objectMap, "unit", r.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceMetricDefinitionProperties.
func (r *ResourceMetricDefinitionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "metricAvailabilities":
			err = unpopulate(val, "MetricAvailabilities", &r.MetricAvailabilities)
			delete(rawMsg, key)
		case "primaryAggregationType":
			err = unpopulate(val, "PrimaryAggregationType", &r.PrimaryAggregationType)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &r.ResourceURI)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &r.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceNameAvailability.
func (r ResourceNameAvailability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", r.Message)
	populate(objectMap, "nameAvailable", r.NameAvailable)
	populate(objectMap, "reason", r.Reason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceNameAvailability.
func (r *ResourceNameAvailability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &r.Message)
			delete(rawMsg, key)
		case "nameAvailable":
			err = unpopulate(val, "NameAvailable", &r.NameAvailable)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &r.Reason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceNameAvailabilityRequest.
func (r ResourceNameAvailabilityRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "environmentId", r.EnvironmentID)
	populate(objectMap, "isFqdn", r.IsFqdn)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceNameAvailabilityRequest.
func (r *ResourceNameAvailabilityRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "environmentId":
			err = unpopulate(val, "EnvironmentID", &r.EnvironmentID)
			delete(rawMsg, key)
		case "isFqdn":
			err = unpopulate(val, "IsFqdn", &r.IsFqdn)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceReference.
func (r ResourceReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceReference.
func (r *ResourceReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Response.
func (r Response) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bodyLink", r.BodyLink)
	populateAny(objectMap, "headers", r.Headers)
	populate(objectMap, "statusCode", r.StatusCode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Response.
func (r *Response) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bodyLink":
			err = unpopulate(val, "BodyLink", &r.BodyLink)
			delete(rawMsg, key)
		case "headers":
			err = unpopulate(val, "Headers", &r.Headers)
			delete(rawMsg, key)
		case "statusCode":
			err = unpopulate(val, "StatusCode", &r.StatusCode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResponseMessageEnvelopeRemotePrivateEndpointConnection.
func (r ResponseMessageEnvelopeRemotePrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", r.Error)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "identity", r.Identity)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "plan", r.Plan)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "sku", r.SKU)
	populate(objectMap, "status", r.Status)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	populate(objectMap, "zones", r.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResponseMessageEnvelopeRemotePrivateEndpointConnection.
func (r *ResponseMessageEnvelopeRemotePrivateEndpointConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &r.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &r.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "plan":
			err = unpopulate(val, "Plan", &r.Plan)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &r.SKU)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &r.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResponseMetaData.
func (r ResponseMetaData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataSource", r.DataSource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResponseMetaData.
func (r *ResponseMetaData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataSource":
			err = unpopulate(val, "DataSource", &r.DataSource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestoreRequest.
func (r RestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "kind", r.Kind)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestoreRequest.
func (r *RestoreRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestoreRequestProperties.
func (r RestoreRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adjustConnectionStrings", r.AdjustConnectionStrings)
	populate(objectMap, "appServicePlan", r.AppServicePlan)
	populate(objectMap, "blobName", r.BlobName)
	populate(objectMap, "databases", r.Databases)
	populate(objectMap, "hostingEnvironment", r.HostingEnvironment)
	populate(objectMap, "ignoreConflictingHostNames", r.IgnoreConflictingHostNames)
	populate(objectMap, "ignoreDatabases", r.IgnoreDatabases)
	populate(objectMap, "operationType", r.OperationType)
	populate(objectMap, "overwrite", r.Overwrite)
	populate(objectMap, "siteName", r.SiteName)
	populate(objectMap, "storageAccountUrl", r.StorageAccountURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestoreRequestProperties.
func (r *RestoreRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adjustConnectionStrings":
			err = unpopulate(val, "AdjustConnectionStrings", &r.AdjustConnectionStrings)
			delete(rawMsg, key)
		case "appServicePlan":
			err = unpopulate(val, "AppServicePlan", &r.AppServicePlan)
			delete(rawMsg, key)
		case "blobName":
			err = unpopulate(val, "BlobName", &r.BlobName)
			delete(rawMsg, key)
		case "databases":
			err = unpopulate(val, "Databases", &r.Databases)
			delete(rawMsg, key)
		case "hostingEnvironment":
			err = unpopulate(val, "HostingEnvironment", &r.HostingEnvironment)
			delete(rawMsg, key)
		case "ignoreConflictingHostNames":
			err = unpopulate(val, "IgnoreConflictingHostNames", &r.IgnoreConflictingHostNames)
			delete(rawMsg, key)
		case "ignoreDatabases":
			err = unpopulate(val, "IgnoreDatabases", &r.IgnoreDatabases)
			delete(rawMsg, key)
		case "operationType":
			err = unpopulate(val, "OperationType", &r.OperationType)
			delete(rawMsg, key)
		case "overwrite":
			err = unpopulate(val, "Overwrite", &r.Overwrite)
			delete(rawMsg, key)
		case "siteName":
			err = unpopulate(val, "SiteName", &r.SiteName)
			delete(rawMsg, key)
		case "storageAccountUrl":
			err = unpopulate(val, "StorageAccountURL", &r.StorageAccountURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RetryHistory.
func (r RetryHistory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientRequestId", r.ClientRequestID)
	populate(objectMap, "code", r.Code)
	populateDateTimeRFC3339(objectMap, "endTime", r.EndTime)
	populate(objectMap, "error", r.Error)
	populate(objectMap, "serviceRequestId", r.ServiceRequestID)
	populateDateTimeRFC3339(objectMap, "startTime", r.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RetryHistory.
func (r *RetryHistory) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientRequestId":
			err = unpopulate(val, "ClientRequestID", &r.ClientRequestID)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &r.Code)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &r.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &r.Error)
			delete(rawMsg, key)
		case "serviceRequestId":
			err = unpopulate(val, "ServiceRequestID", &r.ServiceRequestID)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &r.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Revision.
func (r Revision) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "kind", r.Kind)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Revision.
func (r *Revision) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RevisionCollection.
func (r RevisionCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RevisionCollection.
func (r *RevisionCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RevisionProperties.
func (r RevisionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "active", r.Active)
	populateDateTimeRFC3339(objectMap, "createdTime", r.CreatedTime)
	populate(objectMap, "fqdn", r.Fqdn)
	populate(objectMap, "healthState", r.HealthState)
	populate(objectMap, "provisioningError", r.ProvisioningError)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "replicas", r.Replicas)
	populate(objectMap, "template", r.Template)
	populate(objectMap, "trafficWeight", r.TrafficWeight)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RevisionProperties.
func (r *RevisionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "active":
			err = unpopulate(val, "Active", &r.Active)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedTime", &r.CreatedTime)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &r.Fqdn)
			delete(rawMsg, key)
		case "healthState":
			err = unpopulate(val, "HealthState", &r.HealthState)
			delete(rawMsg, key)
		case "provisioningError":
			err = unpopulate(val, "ProvisioningError", &r.ProvisioningError)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "replicas":
			err = unpopulate(val, "Replicas", &r.Replicas)
			delete(rawMsg, key)
		case "template":
			err = unpopulate(val, "Template", &r.Template)
			delete(rawMsg, key)
		case "trafficWeight":
			err = unpopulate(val, "TrafficWeight", &r.TrafficWeight)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunActionCorrelation.
func (r RunActionCorrelation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionTrackingId", r.ActionTrackingID)
	populate(objectMap, "clientKeywords", r.ClientKeywords)
	populate(objectMap, "clientTrackingId", r.ClientTrackingID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunActionCorrelation.
func (r *RunActionCorrelation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionTrackingId":
			err = unpopulate(val, "ActionTrackingID", &r.ActionTrackingID)
			delete(rawMsg, key)
		case "clientKeywords":
			err = unpopulate(val, "ClientKeywords", &r.ClientKeywords)
			delete(rawMsg, key)
		case "clientTrackingId":
			err = unpopulate(val, "ClientTrackingID", &r.ClientTrackingID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunCorrelation.
func (r RunCorrelation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientKeywords", r.ClientKeywords)
	populate(objectMap, "clientTrackingId", r.ClientTrackingID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunCorrelation.
func (r *RunCorrelation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientKeywords":
			err = unpopulate(val, "ClientKeywords", &r.ClientKeywords)
			delete(rawMsg, key)
		case "clientTrackingId":
			err = unpopulate(val, "ClientTrackingID", &r.ClientTrackingID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUCapacity.
func (s SKUCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "default", s.Default)
	populate(objectMap, "elasticMaximum", s.ElasticMaximum)
	populate(objectMap, "maximum", s.Maximum)
	populate(objectMap, "minimum", s.Minimum)
	populate(objectMap, "scaleType", s.ScaleType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUCapacity.
func (s *SKUCapacity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "default":
			err = unpopulate(val, "Default", &s.Default)
			delete(rawMsg, key)
		case "elasticMaximum":
			err = unpopulate(val, "ElasticMaximum", &s.ElasticMaximum)
			delete(rawMsg, key)
		case "maximum":
			err = unpopulate(val, "Maximum", &s.Maximum)
			delete(rawMsg, key)
		case "minimum":
			err = unpopulate(val, "Minimum", &s.Minimum)
			delete(rawMsg, key)
		case "scaleType":
			err = unpopulate(val, "ScaleType", &s.ScaleType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUDescription.
func (s SKUDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capabilities", s.Capabilities)
	populate(objectMap, "capacity", s.Capacity)
	populate(objectMap, "family", s.Family)
	populate(objectMap, "locations", s.Locations)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "skuCapacity", s.SKUCapacity)
	populate(objectMap, "size", s.Size)
	populate(objectMap, "tier", s.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUDescription.
func (s *SKUDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capabilities":
			err = unpopulate(val, "Capabilities", &s.Capabilities)
			delete(rawMsg, key)
		case "capacity":
			err = unpopulate(val, "Capacity", &s.Capacity)
			delete(rawMsg, key)
		case "family":
			err = unpopulate(val, "Family", &s.Family)
			delete(rawMsg, key)
		case "locations":
			err = unpopulate(val, "Locations", &s.Locations)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "skuCapacity":
			err = unpopulate(val, "SKUCapacity", &s.SKUCapacity)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &s.Size)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &s.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUInfo.
func (s SKUInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", s.Capacity)
	populate(objectMap, "resourceType", s.ResourceType)
	populate(objectMap, "sku", s.SKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUInfo.
func (s *SKUInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &s.Capacity)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &s.ResourceType)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &s.SKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUInfoCollection.
func (s SKUInfoCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUInfoCollection.
func (s *SKUInfoCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUInfos.
func (s SKUInfos) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceType", s.ResourceType)
	populate(objectMap, "skus", s.SKUs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUInfos.
func (s *SKUInfos) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceType":
			err = unpopulate(val, "ResourceType", &s.ResourceType)
			delete(rawMsg, key)
		case "skus":
			err = unpopulate(val, "SKUs", &s.SKUs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SampleUtterance.
func (s SampleUtterance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "links", s.Links)
	populate(objectMap, "qid", s.Qid)
	populate(objectMap, "text", s.Text)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SampleUtterance.
func (s *SampleUtterance) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "links":
			err = unpopulate(val, "Links", &s.Links)
			delete(rawMsg, key)
		case "qid":
			err = unpopulate(val, "Qid", &s.Qid)
			delete(rawMsg, key)
		case "text":
			err = unpopulate(val, "Text", &s.Text)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Scale.
func (s Scale) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxReplicas", s.MaxReplicas)
	populate(objectMap, "minReplicas", s.MinReplicas)
	populate(objectMap, "rules", s.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Scale.
func (s *Scale) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxReplicas":
			err = unpopulate(val, "MaxReplicas", &s.MaxReplicas)
			delete(rawMsg, key)
		case "minReplicas":
			err = unpopulate(val, "MinReplicas", &s.MinReplicas)
			delete(rawMsg, key)
		case "rules":
			err = unpopulate(val, "Rules", &s.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScaleRule.
func (s ScaleRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureQueue", s.AzureQueue)
	populate(objectMap, "custom", s.Custom)
	populate(objectMap, "http", s.HTTP)
	populate(objectMap, "name", s.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScaleRule.
func (s *ScaleRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureQueue":
			err = unpopulate(val, "AzureQueue", &s.AzureQueue)
			delete(rawMsg, key)
		case "custom":
			err = unpopulate(val, "Custom", &s.Custom)
			delete(rawMsg, key)
		case "http":
			err = unpopulate(val, "HTTP", &s.HTTP)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScaleRuleAuth.
func (s ScaleRuleAuth) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "secretRef", s.SecretRef)
	populate(objectMap, "triggerParameter", s.TriggerParameter)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScaleRuleAuth.
func (s *ScaleRuleAuth) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "secretRef":
			err = unpopulate(val, "SecretRef", &s.SecretRef)
			delete(rawMsg, key)
		case "triggerParameter":
			err = unpopulate(val, "TriggerParameter", &s.TriggerParameter)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Secret.
func (s Secret) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Secret.
func (s *Secret) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretsCollection.
func (s SecretsCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretsCollection.
func (s *SecretsCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceSpecification.
func (s ServiceSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "logSpecifications", s.LogSpecifications)
	populate(objectMap, "metricSpecifications", s.MetricSpecifications)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceSpecification.
func (s *ServiceSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "logSpecifications":
			err = unpopulate(val, "LogSpecifications", &s.LogSpecifications)
			delete(rawMsg, key)
		case "metricSpecifications":
			err = unpopulate(val, "MetricSpecifications", &s.MetricSpecifications)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Site.
func (s Site) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", s.ExtendedLocation)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Site.
func (s *Site) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &s.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &s.Identity)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteAuthSettings.
func (s SiteAuthSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteAuthSettings.
func (s *SiteAuthSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteAuthSettingsProperties.
func (s SiteAuthSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aadClaimsAuthorization", s.AADClaimsAuthorization)
	populate(objectMap, "additionalLoginParams", s.AdditionalLoginParams)
	populate(objectMap, "allowedAudiences", s.AllowedAudiences)
	populate(objectMap, "allowedExternalRedirectUrls", s.AllowedExternalRedirectUrls)
	populate(objectMap, "authFilePath", s.AuthFilePath)
	populate(objectMap, "clientId", s.ClientID)
	populate(objectMap, "clientSecret", s.ClientSecret)
	populate(objectMap, "clientSecretCertificateThumbprint", s.ClientSecretCertificateThumbprint)
	populate(objectMap, "clientSecretSettingName", s.ClientSecretSettingName)
	populate(objectMap, "configVersion", s.ConfigVersion)
	populate(objectMap, "defaultProvider", s.DefaultProvider)
	populate(objectMap, "enabled", s.Enabled)
	populate(objectMap, "facebookAppId", s.FacebookAppID)
	populate(objectMap, "facebookAppSecret", s.FacebookAppSecret)
	populate(objectMap, "facebookAppSecretSettingName", s.FacebookAppSecretSettingName)
	populate(objectMap, "facebookOAuthScopes", s.FacebookOAuthScopes)
	populate(objectMap, "gitHubClientId", s.GitHubClientID)
	populate(objectMap, "gitHubClientSecret", s.GitHubClientSecret)
	populate(objectMap, "gitHubClientSecretSettingName", s.GitHubClientSecretSettingName)
	populate(objectMap, "gitHubOAuthScopes", s.GitHubOAuthScopes)
	populate(objectMap, "googleClientId", s.GoogleClientID)
	populate(objectMap, "googleClientSecret", s.GoogleClientSecret)
	populate(objectMap, "googleClientSecretSettingName", s.GoogleClientSecretSettingName)
	populate(objectMap, "googleOAuthScopes", s.GoogleOAuthScopes)
	populate(objectMap, "isAuthFromFile", s.IsAuthFromFile)
	populate(objectMap, "issuer", s.Issuer)
	populate(objectMap, "microsoftAccountClientId", s.MicrosoftAccountClientID)
	populate(objectMap, "microsoftAccountClientSecret", s.MicrosoftAccountClientSecret)
	populate(objectMap, "microsoftAccountClientSecretSettingName", s.MicrosoftAccountClientSecretSettingName)
	populate(objectMap, "microsoftAccountOAuthScopes", s.MicrosoftAccountOAuthScopes)
	populate(objectMap, "runtimeVersion", s.RuntimeVersion)
	populate(objectMap, "tokenRefreshExtensionHours", s.TokenRefreshExtensionHours)
	populate(objectMap, "tokenStoreEnabled", s.TokenStoreEnabled)
	populate(objectMap, "twitterConsumerKey", s.TwitterConsumerKey)
	populate(objectMap, "twitterConsumerSecret", s.TwitterConsumerSecret)
	populate(objectMap, "twitterConsumerSecretSettingName", s.TwitterConsumerSecretSettingName)
	populate(objectMap, "unauthenticatedClientAction", s.UnauthenticatedClientAction)
	populate(objectMap, "validateIssuer", s.ValidateIssuer)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteAuthSettingsProperties.
func (s *SiteAuthSettingsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aadClaimsAuthorization":
			err = unpopulate(val, "AADClaimsAuthorization", &s.AADClaimsAuthorization)
			delete(rawMsg, key)
		case "additionalLoginParams":
			err = unpopulate(val, "AdditionalLoginParams", &s.AdditionalLoginParams)
			delete(rawMsg, key)
		case "allowedAudiences":
			err = unpopulate(val, "AllowedAudiences", &s.AllowedAudiences)
			delete(rawMsg, key)
		case "allowedExternalRedirectUrls":
			err = unpopulate(val, "AllowedExternalRedirectUrls", &s.AllowedExternalRedirectUrls)
			delete(rawMsg, key)
		case "authFilePath":
			err = unpopulate(val, "AuthFilePath", &s.AuthFilePath)
			delete(rawMsg, key)
		case "clientId":
			err = unpopulate(val, "ClientID", &s.ClientID)
			delete(rawMsg, key)
		case "clientSecret":
			err = unpopulate(val, "ClientSecret", &s.ClientSecret)
			delete(rawMsg, key)
		case "clientSecretCertificateThumbprint":
			err = unpopulate(val, "ClientSecretCertificateThumbprint", &s.ClientSecretCertificateThumbprint)
			delete(rawMsg, key)
		case "clientSecretSettingName":
			err = unpopulate(val, "ClientSecretSettingName", &s.ClientSecretSettingName)
			delete(rawMsg, key)
		case "configVersion":
			err = unpopulate(val, "ConfigVersion", &s.ConfigVersion)
			delete(rawMsg, key)
		case "defaultProvider":
			err = unpopulate(val, "DefaultProvider", &s.DefaultProvider)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &s.Enabled)
			delete(rawMsg, key)
		case "facebookAppId":
			err = unpopulate(val, "FacebookAppID", &s.FacebookAppID)
			delete(rawMsg, key)
		case "facebookAppSecret":
			err = unpopulate(val, "FacebookAppSecret", &s.FacebookAppSecret)
			delete(rawMsg, key)
		case "facebookAppSecretSettingName":
			err = unpopulate(val, "FacebookAppSecretSettingName", &s.FacebookAppSecretSettingName)
			delete(rawMsg, key)
		case "facebookOAuthScopes":
			err = unpopulate(val, "FacebookOAuthScopes", &s.FacebookOAuthScopes)
			delete(rawMsg, key)
		case "gitHubClientId":
			err = unpopulate(val, "GitHubClientID", &s.GitHubClientID)
			delete(rawMsg, key)
		case "gitHubClientSecret":
			err = unpopulate(val, "GitHubClientSecret", &s.GitHubClientSecret)
			delete(rawMsg, key)
		case "gitHubClientSecretSettingName":
			err = unpopulate(val, "GitHubClientSecretSettingName", &s.GitHubClientSecretSettingName)
			delete(rawMsg, key)
		case "gitHubOAuthScopes":
			err = unpopulate(val, "GitHubOAuthScopes", &s.GitHubOAuthScopes)
			delete(rawMsg, key)
		case "googleClientId":
			err = unpopulate(val, "GoogleClientID", &s.GoogleClientID)
			delete(rawMsg, key)
		case "googleClientSecret":
			err = unpopulate(val, "GoogleClientSecret", &s.GoogleClientSecret)
			delete(rawMsg, key)
		case "googleClientSecretSettingName":
			err = unpopulate(val, "GoogleClientSecretSettingName", &s.GoogleClientSecretSettingName)
			delete(rawMsg, key)
		case "googleOAuthScopes":
			err = unpopulate(val, "GoogleOAuthScopes", &s.GoogleOAuthScopes)
			delete(rawMsg, key)
		case "isAuthFromFile":
			err = unpopulate(val, "IsAuthFromFile", &s.IsAuthFromFile)
			delete(rawMsg, key)
		case "issuer":
			err = unpopulate(val, "Issuer", &s.Issuer)
			delete(rawMsg, key)
		case "microsoftAccountClientId":
			err = unpopulate(val, "MicrosoftAccountClientID", &s.MicrosoftAccountClientID)
			delete(rawMsg, key)
		case "microsoftAccountClientSecret":
			err = unpopulate(val, "MicrosoftAccountClientSecret", &s.MicrosoftAccountClientSecret)
			delete(rawMsg, key)
		case "microsoftAccountClientSecretSettingName":
			err = unpopulate(val, "MicrosoftAccountClientSecretSettingName", &s.MicrosoftAccountClientSecretSettingName)
			delete(rawMsg, key)
		case "microsoftAccountOAuthScopes":
			err = unpopulate(val, "MicrosoftAccountOAuthScopes", &s.MicrosoftAccountOAuthScopes)
			delete(rawMsg, key)
		case "runtimeVersion":
			err = unpopulate(val, "RuntimeVersion", &s.RuntimeVersion)
			delete(rawMsg, key)
		case "tokenRefreshExtensionHours":
			err = unpopulate(val, "TokenRefreshExtensionHours", &s.TokenRefreshExtensionHours)
			delete(rawMsg, key)
		case "tokenStoreEnabled":
			err = unpopulate(val, "TokenStoreEnabled", &s.TokenStoreEnabled)
			delete(rawMsg, key)
		case "twitterConsumerKey":
			err = unpopulate(val, "TwitterConsumerKey", &s.TwitterConsumerKey)
			delete(rawMsg, key)
		case "twitterConsumerSecret":
			err = unpopulate(val, "TwitterConsumerSecret", &s.TwitterConsumerSecret)
			delete(rawMsg, key)
		case "twitterConsumerSecretSettingName":
			err = unpopulate(val, "TwitterConsumerSecretSettingName", &s.TwitterConsumerSecretSettingName)
			delete(rawMsg, key)
		case "unauthenticatedClientAction":
			err = unpopulate(val, "UnauthenticatedClientAction", &s.UnauthenticatedClientAction)
			delete(rawMsg, key)
		case "validateIssuer":
			err = unpopulate(val, "ValidateIssuer", &s.ValidateIssuer)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteAuthSettingsV2.
func (s SiteAuthSettingsV2) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteAuthSettingsV2.
func (s *SiteAuthSettingsV2) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteAuthSettingsV2Properties.
func (s SiteAuthSettingsV2Properties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "globalValidation", s.GlobalValidation)
	populate(objectMap, "httpSettings", s.HTTPSettings)
	populate(objectMap, "identityProviders", s.IdentityProviders)
	populate(objectMap, "login", s.Login)
	populate(objectMap, "platform", s.Platform)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteAuthSettingsV2Properties.
func (s *SiteAuthSettingsV2Properties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "globalValidation":
			err = unpopulate(val, "GlobalValidation", &s.GlobalValidation)
			delete(rawMsg, key)
		case "httpSettings":
			err = unpopulate(val, "HTTPSettings", &s.HTTPSettings)
			delete(rawMsg, key)
		case "identityProviders":
			err = unpopulate(val, "IdentityProviders", &s.IdentityProviders)
			delete(rawMsg, key)
		case "login":
			err = unpopulate(val, "Login", &s.Login)
			delete(rawMsg, key)
		case "platform":
			err = unpopulate(val, "Platform", &s.Platform)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteCloneability.
func (s SiteCloneability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blockingCharacteristics", s.BlockingCharacteristics)
	populate(objectMap, "blockingFeatures", s.BlockingFeatures)
	populate(objectMap, "result", s.Result)
	populate(objectMap, "unsupportedFeatures", s.UnsupportedFeatures)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteCloneability.
func (s *SiteCloneability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blockingCharacteristics":
			err = unpopulate(val, "BlockingCharacteristics", &s.BlockingCharacteristics)
			delete(rawMsg, key)
		case "blockingFeatures":
			err = unpopulate(val, "BlockingFeatures", &s.BlockingFeatures)
			delete(rawMsg, key)
		case "result":
			err = unpopulate(val, "Result", &s.Result)
			delete(rawMsg, key)
		case "unsupportedFeatures":
			err = unpopulate(val, "UnsupportedFeatures", &s.UnsupportedFeatures)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteCloneabilityCriterion.
func (s SiteCloneabilityCriterion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "name", s.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteCloneabilityCriterion.
func (s *SiteCloneabilityCriterion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteConfig.
func (s SiteConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiDefinition", s.APIDefinition)
	populate(objectMap, "apiManagementConfig", s.APIManagementConfig)
	populate(objectMap, "acrUseManagedIdentityCreds", s.AcrUseManagedIdentityCreds)
	populate(objectMap, "acrUserManagedIdentityID", s.AcrUserManagedIdentityID)
	populate(objectMap, "alwaysOn", s.AlwaysOn)
	populate(objectMap, "appCommandLine", s.AppCommandLine)
	populate(objectMap, "appSettings", s.AppSettings)
	populate(objectMap, "autoHealEnabled", s.AutoHealEnabled)
	populate(objectMap, "autoHealRules", s.AutoHealRules)
	populate(objectMap, "autoSwapSlotName", s.AutoSwapSlotName)
	populate(objectMap, "azureStorageAccounts", s.AzureStorageAccounts)
	populate(objectMap, "connectionStrings", s.ConnectionStrings)
	populate(objectMap, "cors", s.Cors)
	populate(objectMap, "defaultDocuments", s.DefaultDocuments)
	populate(objectMap, "detailedErrorLoggingEnabled", s.DetailedErrorLoggingEnabled)
	populate(objectMap, "documentRoot", s.DocumentRoot)
	populate(objectMap, "elasticWebAppScaleLimit", s.ElasticWebAppScaleLimit)
	populate(objectMap, "experiments", s.Experiments)
	populate(objectMap, "ftpsState", s.FtpsState)
	populate(objectMap, "functionAppScaleLimit", s.FunctionAppScaleLimit)
	populate(objectMap, "functionsRuntimeScaleMonitoringEnabled", s.FunctionsRuntimeScaleMonitoringEnabled)
	populate(objectMap, "httpLoggingEnabled", s.HTTPLoggingEnabled)
	populate(objectMap, "handlerMappings", s.HandlerMappings)
	populate(objectMap, "healthCheckPath", s.HealthCheckPath)
	populate(objectMap, "http20Enabled", s.Http20Enabled)
	populate(objectMap, "ipSecurityRestrictions", s.IPSecurityRestrictions)
	populate(objectMap, "ipSecurityRestrictionsDefaultAction", s.IPSecurityRestrictionsDefaultAction)
	populate(objectMap, "javaContainer", s.JavaContainer)
	populate(objectMap, "javaContainerVersion", s.JavaContainerVersion)
	populate(objectMap, "javaVersion", s.JavaVersion)
	populate(objectMap, "keyVaultReferenceIdentity", s.KeyVaultReferenceIdentity)
	populate(objectMap, "limits", s.Limits)
	populate(objectMap, "linuxFxVersion", s.LinuxFxVersion)
	populate(objectMap, "loadBalancing", s.LoadBalancing)
	populate(objectMap, "localMySqlEnabled", s.LocalMySQLEnabled)
	populate(objectMap, "logsDirectorySizeLimit", s.LogsDirectorySizeLimit)
	populate(objectMap, "machineKey", s.MachineKey)
	populate(objectMap, "managedPipelineMode", s.ManagedPipelineMode)
	populate(objectMap, "managedServiceIdentityId", s.ManagedServiceIdentityID)
	populate(objectMap, "metadata", s.Metadata)
	populate(objectMap, "minTlsCipherSuite", s.MinTLSCipherSuite)
	populate(objectMap, "minTlsVersion", s.MinTLSVersion)
	populate(objectMap, "minimumElasticInstanceCount", s.MinimumElasticInstanceCount)
	populate(objectMap, "netFrameworkVersion", s.NetFrameworkVersion)
	populate(objectMap, "nodeVersion", s.NodeVersion)
	populate(objectMap, "numberOfWorkers", s.NumberOfWorkers)
	populate(objectMap, "phpVersion", s.PhpVersion)
	populate(objectMap, "powerShellVersion", s.PowerShellVersion)
	populate(objectMap, "preWarmedInstanceCount", s.PreWarmedInstanceCount)
	populate(objectMap, "publicNetworkAccess", s.PublicNetworkAccess)
	populate(objectMap, "publishingUsername", s.PublishingUsername)
	populate(objectMap, "push", s.Push)
	populate(objectMap, "pythonVersion", s.PythonVersion)
	populate(objectMap, "remoteDebuggingEnabled", s.RemoteDebuggingEnabled)
	populate(objectMap, "remoteDebuggingVersion", s.RemoteDebuggingVersion)
	populate(objectMap, "requestTracingEnabled", s.RequestTracingEnabled)
	populateDateTimeRFC3339(objectMap, "requestTracingExpirationTime", s.RequestTracingExpirationTime)
	populate(objectMap, "scmIpSecurityRestrictions", s.ScmIPSecurityRestrictions)
	populate(objectMap, "scmIpSecurityRestrictionsDefaultAction", s.ScmIPSecurityRestrictionsDefaultAction)
	populate(objectMap, "scmIpSecurityRestrictionsUseMain", s.ScmIPSecurityRestrictionsUseMain)
	populate(objectMap, "scmMinTlsVersion", s.ScmMinTLSVersion)
	populate(objectMap, "scmType", s.ScmType)
	populate(objectMap, "tracingOptions", s.TracingOptions)
	populate(objectMap, "use32BitWorkerProcess", s.Use32BitWorkerProcess)
	populate(objectMap, "virtualApplications", s.VirtualApplications)
	populate(objectMap, "vnetName", s.VnetName)
	populate(objectMap, "vnetPrivatePortsCount", s.VnetPrivatePortsCount)
	populate(objectMap, "vnetRouteAllEnabled", s.VnetRouteAllEnabled)
	populate(objectMap, "webSocketsEnabled", s.WebSocketsEnabled)
	populate(objectMap, "websiteTimeZone", s.WebsiteTimeZone)
	populate(objectMap, "windowsFxVersion", s.WindowsFxVersion)
	populate(objectMap, "xManagedServiceIdentityId", s.XManagedServiceIdentityID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteConfig.
func (s *SiteConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiDefinition":
			err = unpopulate(val, "APIDefinition", &s.APIDefinition)
			delete(rawMsg, key)
		case "apiManagementConfig":
			err = unpopulate(val, "APIManagementConfig", &s.APIManagementConfig)
			delete(rawMsg, key)
		case "acrUseManagedIdentityCreds":
			err = unpopulate(val, "AcrUseManagedIdentityCreds", &s.AcrUseManagedIdentityCreds)
			delete(rawMsg, key)
		case "acrUserManagedIdentityID":
			err = unpopulate(val, "AcrUserManagedIdentityID", &s.AcrUserManagedIdentityID)
			delete(rawMsg, key)
		case "alwaysOn":
			err = unpopulate(val, "AlwaysOn", &s.AlwaysOn)
			delete(rawMsg, key)
		case "appCommandLine":
			err = unpopulate(val, "AppCommandLine", &s.AppCommandLine)
			delete(rawMsg, key)
		case "appSettings":
			err = unpopulate(val, "AppSettings", &s.AppSettings)
			delete(rawMsg, key)
		case "autoHealEnabled":
			err = unpopulate(val, "AutoHealEnabled", &s.AutoHealEnabled)
			delete(rawMsg, key)
		case "autoHealRules":
			err = unpopulate(val, "AutoHealRules", &s.AutoHealRules)
			delete(rawMsg, key)
		case "autoSwapSlotName":
			err = unpopulate(val, "AutoSwapSlotName", &s.AutoSwapSlotName)
			delete(rawMsg, key)
		case "azureStorageAccounts":
			err = unpopulate(val, "AzureStorageAccounts", &s.AzureStorageAccounts)
			delete(rawMsg, key)
		case "connectionStrings":
			err = unpopulate(val, "ConnectionStrings", &s.ConnectionStrings)
			delete(rawMsg, key)
		case "cors":
			err = unpopulate(val, "Cors", &s.Cors)
			delete(rawMsg, key)
		case "defaultDocuments":
			err = unpopulate(val, "DefaultDocuments", &s.DefaultDocuments)
			delete(rawMsg, key)
		case "detailedErrorLoggingEnabled":
			err = unpopulate(val, "DetailedErrorLoggingEnabled", &s.DetailedErrorLoggingEnabled)
			delete(rawMsg, key)
		case "documentRoot":
			err = unpopulate(val, "DocumentRoot", &s.DocumentRoot)
			delete(rawMsg, key)
		case "elasticWebAppScaleLimit":
			err = unpopulate(val, "ElasticWebAppScaleLimit", &s.ElasticWebAppScaleLimit)
			delete(rawMsg, key)
		case "experiments":
			err = unpopulate(val, "Experiments", &s.Experiments)
			delete(rawMsg, key)
		case "ftpsState":
			err = unpopulate(val, "FtpsState", &s.FtpsState)
			delete(rawMsg, key)
		case "functionAppScaleLimit":
			err = unpopulate(val, "FunctionAppScaleLimit", &s.FunctionAppScaleLimit)
			delete(rawMsg, key)
		case "functionsRuntimeScaleMonitoringEnabled":
			err = unpopulate(val, "FunctionsRuntimeScaleMonitoringEnabled", &s.FunctionsRuntimeScaleMonitoringEnabled)
			delete(rawMsg, key)
		case "httpLoggingEnabled":
			err = unpopulate(val, "HTTPLoggingEnabled", &s.HTTPLoggingEnabled)
			delete(rawMsg, key)
		case "handlerMappings":
			err = unpopulate(val, "HandlerMappings", &s.HandlerMappings)
			delete(rawMsg, key)
		case "healthCheckPath":
			err = unpopulate(val, "HealthCheckPath", &s.HealthCheckPath)
			delete(rawMsg, key)
		case "http20Enabled":
			err = unpopulate(val, "Http20Enabled", &s.Http20Enabled)
			delete(rawMsg, key)
		case "ipSecurityRestrictions":
			err = unpopulate(val, "IPSecurityRestrictions", &s.IPSecurityRestrictions)
			delete(rawMsg, key)
		case "ipSecurityRestrictionsDefaultAction":
			err = unpopulate(val, "IPSecurityRestrictionsDefaultAction", &s.IPSecurityRestrictionsDefaultAction)
			delete(rawMsg, key)
		case "javaContainer":
			err = unpopulate(val, "JavaContainer", &s.JavaContainer)
			delete(rawMsg, key)
		case "javaContainerVersion":
			err = unpopulate(val, "JavaContainerVersion", &s.JavaContainerVersion)
			delete(rawMsg, key)
		case "javaVersion":
			err = unpopulate(val, "JavaVersion", &s.JavaVersion)
			delete(rawMsg, key)
		case "keyVaultReferenceIdentity":
			err = unpopulate(val, "KeyVaultReferenceIdentity", &s.KeyVaultReferenceIdentity)
			delete(rawMsg, key)
		case "limits":
			err = unpopulate(val, "Limits", &s.Limits)
			delete(rawMsg, key)
		case "linuxFxVersion":
			err = unpopulate(val, "LinuxFxVersion", &s.LinuxFxVersion)
			delete(rawMsg, key)
		case "loadBalancing":
			err = unpopulate(val, "LoadBalancing", &s.LoadBalancing)
			delete(rawMsg, key)
		case "localMySqlEnabled":
			err = unpopulate(val, "LocalMySQLEnabled", &s.LocalMySQLEnabled)
			delete(rawMsg, key)
		case "logsDirectorySizeLimit":
			err = unpopulate(val, "LogsDirectorySizeLimit", &s.LogsDirectorySizeLimit)
			delete(rawMsg, key)
		case "machineKey":
			err = unpopulate(val, "MachineKey", &s.MachineKey)
			delete(rawMsg, key)
		case "managedPipelineMode":
			err = unpopulate(val, "ManagedPipelineMode", &s.ManagedPipelineMode)
			delete(rawMsg, key)
		case "managedServiceIdentityId":
			err = unpopulate(val, "ManagedServiceIdentityID", &s.ManagedServiceIdentityID)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &s.Metadata)
			delete(rawMsg, key)
		case "minTlsCipherSuite":
			err = unpopulate(val, "MinTLSCipherSuite", &s.MinTLSCipherSuite)
			delete(rawMsg, key)
		case "minTlsVersion":
			err = unpopulate(val, "MinTLSVersion", &s.MinTLSVersion)
			delete(rawMsg, key)
		case "minimumElasticInstanceCount":
			err = unpopulate(val, "MinimumElasticInstanceCount", &s.MinimumElasticInstanceCount)
			delete(rawMsg, key)
		case "netFrameworkVersion":
			err = unpopulate(val, "NetFrameworkVersion", &s.NetFrameworkVersion)
			delete(rawMsg, key)
		case "nodeVersion":
			err = unpopulate(val, "NodeVersion", &s.NodeVersion)
			delete(rawMsg, key)
		case "numberOfWorkers":
			err = unpopulate(val, "NumberOfWorkers", &s.NumberOfWorkers)
			delete(rawMsg, key)
		case "phpVersion":
			err = unpopulate(val, "PhpVersion", &s.PhpVersion)
			delete(rawMsg, key)
		case "powerShellVersion":
			err = unpopulate(val, "PowerShellVersion", &s.PowerShellVersion)
			delete(rawMsg, key)
		case "preWarmedInstanceCount":
			err = unpopulate(val, "PreWarmedInstanceCount", &s.PreWarmedInstanceCount)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &s.PublicNetworkAccess)
			delete(rawMsg, key)
		case "publishingUsername":
			err = unpopulate(val, "PublishingUsername", &s.PublishingUsername)
			delete(rawMsg, key)
		case "push":
			err = unpopulate(val, "Push", &s.Push)
			delete(rawMsg, key)
		case "pythonVersion":
			err = unpopulate(val, "PythonVersion", &s.PythonVersion)
			delete(rawMsg, key)
		case "remoteDebuggingEnabled":
			err = unpopulate(val, "RemoteDebuggingEnabled", &s.RemoteDebuggingEnabled)
			delete(rawMsg, key)
		case "remoteDebuggingVersion":
			err = unpopulate(val, "RemoteDebuggingVersion", &s.RemoteDebuggingVersion)
			delete(rawMsg, key)
		case "requestTracingEnabled":
			err = unpopulate(val, "RequestTracingEnabled", &s.RequestTracingEnabled)
			delete(rawMsg, key)
		case "requestTracingExpirationTime":
			err = unpopulateDateTimeRFC3339(val, "RequestTracingExpirationTime", &s.RequestTracingExpirationTime)
			delete(rawMsg, key)
		case "scmIpSecurityRestrictions":
			err = unpopulate(val, "ScmIPSecurityRestrictions", &s.ScmIPSecurityRestrictions)
			delete(rawMsg, key)
		case "scmIpSecurityRestrictionsDefaultAction":
			err = unpopulate(val, "ScmIPSecurityRestrictionsDefaultAction", &s.ScmIPSecurityRestrictionsDefaultAction)
			delete(rawMsg, key)
		case "scmIpSecurityRestrictionsUseMain":
			err = unpopulate(val, "ScmIPSecurityRestrictionsUseMain", &s.ScmIPSecurityRestrictionsUseMain)
			delete(rawMsg, key)
		case "scmMinTlsVersion":
			err = unpopulate(val, "ScmMinTLSVersion", &s.ScmMinTLSVersion)
			delete(rawMsg, key)
		case "scmType":
			err = unpopulate(val, "ScmType", &s.ScmType)
			delete(rawMsg, key)
		case "tracingOptions":
			err = unpopulate(val, "TracingOptions", &s.TracingOptions)
			delete(rawMsg, key)
		case "use32BitWorkerProcess":
			err = unpopulate(val, "Use32BitWorkerProcess", &s.Use32BitWorkerProcess)
			delete(rawMsg, key)
		case "virtualApplications":
			err = unpopulate(val, "VirtualApplications", &s.VirtualApplications)
			delete(rawMsg, key)
		case "vnetName":
			err = unpopulate(val, "VnetName", &s.VnetName)
			delete(rawMsg, key)
		case "vnetPrivatePortsCount":
			err = unpopulate(val, "VnetPrivatePortsCount", &s.VnetPrivatePortsCount)
			delete(rawMsg, key)
		case "vnetRouteAllEnabled":
			err = unpopulate(val, "VnetRouteAllEnabled", &s.VnetRouteAllEnabled)
			delete(rawMsg, key)
		case "webSocketsEnabled":
			err = unpopulate(val, "WebSocketsEnabled", &s.WebSocketsEnabled)
			delete(rawMsg, key)
		case "websiteTimeZone":
			err = unpopulate(val, "WebsiteTimeZone", &s.WebsiteTimeZone)
			delete(rawMsg, key)
		case "windowsFxVersion":
			err = unpopulate(val, "WindowsFxVersion", &s.WindowsFxVersion)
			delete(rawMsg, key)
		case "xManagedServiceIdentityId":
			err = unpopulate(val, "XManagedServiceIdentityID", &s.XManagedServiceIdentityID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteConfigPropertiesDictionary.
func (s SiteConfigPropertiesDictionary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "javaVersion", s.JavaVersion)
	populate(objectMap, "linuxFxVersion", s.LinuxFxVersion)
	populate(objectMap, "powerShellVersion", s.PowerShellVersion)
	populate(objectMap, "use32BitWorkerProcess", s.Use32BitWorkerProcess)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteConfigPropertiesDictionary.
func (s *SiteConfigPropertiesDictionary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "javaVersion":
			err = unpopulate(val, "JavaVersion", &s.JavaVersion)
			delete(rawMsg, key)
		case "linuxFxVersion":
			err = unpopulate(val, "LinuxFxVersion", &s.LinuxFxVersion)
			delete(rawMsg, key)
		case "powerShellVersion":
			err = unpopulate(val, "PowerShellVersion", &s.PowerShellVersion)
			delete(rawMsg, key)
		case "use32BitWorkerProcess":
			err = unpopulate(val, "Use32BitWorkerProcess", &s.Use32BitWorkerProcess)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteConfigResource.
func (s SiteConfigResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteConfigResource.
func (s *SiteConfigResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteConfigResourceCollection.
func (s SiteConfigResourceCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteConfigResourceCollection.
func (s *SiteConfigResourceCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteConfigurationSnapshotInfo.
func (s SiteConfigurationSnapshotInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteConfigurationSnapshotInfo.
func (s *SiteConfigurationSnapshotInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteConfigurationSnapshotInfoCollection.
func (s SiteConfigurationSnapshotInfoCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteConfigurationSnapshotInfoCollection.
func (s *SiteConfigurationSnapshotInfoCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteConfigurationSnapshotInfoProperties.
func (s SiteConfigurationSnapshotInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "snapshotId", s.SnapshotID)
	populateDateTimeRFC3339(objectMap, "time", s.Time)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteConfigurationSnapshotInfoProperties.
func (s *SiteConfigurationSnapshotInfoProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "snapshotId":
			err = unpopulate(val, "SnapshotID", &s.SnapshotID)
			delete(rawMsg, key)
		case "time":
			err = unpopulateDateTimeRFC3339(val, "Time", &s.Time)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteExtensionInfo.
func (s SiteExtensionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteExtensionInfo.
func (s *SiteExtensionInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteExtensionInfoCollection.
func (s SiteExtensionInfoCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteExtensionInfoCollection.
func (s *SiteExtensionInfoCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteExtensionInfoProperties.
func (s SiteExtensionInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authors", s.Authors)
	populate(objectMap, "comment", s.Comment)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "download_count", s.DownloadCount)
	populate(objectMap, "extension_id", s.ExtensionID)
	populate(objectMap, "extension_type", s.ExtensionType)
	populate(objectMap, "extension_url", s.ExtensionURL)
	populate(objectMap, "feed_url", s.FeedURL)
	populate(objectMap, "icon_url", s.IconURL)
	populateDateTimeRFC3339(objectMap, "installed_date_time", s.InstalledDateTime)
	populate(objectMap, "installer_command_line_params", s.InstallerCommandLineParams)
	populate(objectMap, "license_url", s.LicenseURL)
	populate(objectMap, "local_is_latest_version", s.LocalIsLatestVersion)
	populate(objectMap, "local_path", s.LocalPath)
	populate(objectMap, "project_url", s.ProjectURL)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populateDateTimeRFC3339(objectMap, "published_date_time", s.PublishedDateTime)
	populate(objectMap, "summary", s.Summary)
	populate(objectMap, "title", s.Title)
	populate(objectMap, "version", s.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteExtensionInfoProperties.
func (s *SiteExtensionInfoProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authors":
			err = unpopulate(val, "Authors", &s.Authors)
			delete(rawMsg, key)
		case "comment":
			err = unpopulate(val, "Comment", &s.Comment)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "download_count":
			err = unpopulate(val, "DownloadCount", &s.DownloadCount)
			delete(rawMsg, key)
		case "extension_id":
			err = unpopulate(val, "ExtensionID", &s.ExtensionID)
			delete(rawMsg, key)
		case "extension_type":
			err = unpopulate(val, "ExtensionType", &s.ExtensionType)
			delete(rawMsg, key)
		case "extension_url":
			err = unpopulate(val, "ExtensionURL", &s.ExtensionURL)
			delete(rawMsg, key)
		case "feed_url":
			err = unpopulate(val, "FeedURL", &s.FeedURL)
			delete(rawMsg, key)
		case "icon_url":
			err = unpopulate(val, "IconURL", &s.IconURL)
			delete(rawMsg, key)
		case "installed_date_time":
			err = unpopulateDateTimeRFC3339(val, "InstalledDateTime", &s.InstalledDateTime)
			delete(rawMsg, key)
		case "installer_command_line_params":
			err = unpopulate(val, "InstallerCommandLineParams", &s.InstallerCommandLineParams)
			delete(rawMsg, key)
		case "license_url":
			err = unpopulate(val, "LicenseURL", &s.LicenseURL)
			delete(rawMsg, key)
		case "local_is_latest_version":
			err = unpopulate(val, "LocalIsLatestVersion", &s.LocalIsLatestVersion)
			delete(rawMsg, key)
		case "local_path":
			err = unpopulate(val, "LocalPath", &s.LocalPath)
			delete(rawMsg, key)
		case "project_url":
			err = unpopulate(val, "ProjectURL", &s.ProjectURL)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "published_date_time":
			err = unpopulateDateTimeRFC3339(val, "PublishedDateTime", &s.PublishedDateTime)
			delete(rawMsg, key)
		case "summary":
			err = unpopulate(val, "Summary", &s.Summary)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &s.Title)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &s.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteLimits.
func (s SiteLimits) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxDiskSizeInMb", s.MaxDiskSizeInMb)
	populate(objectMap, "maxMemoryInMb", s.MaxMemoryInMb)
	populate(objectMap, "maxPercentageCpu", s.MaxPercentageCPU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteLimits.
func (s *SiteLimits) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxDiskSizeInMb":
			err = unpopulate(val, "MaxDiskSizeInMb", &s.MaxDiskSizeInMb)
			delete(rawMsg, key)
		case "maxMemoryInMb":
			err = unpopulate(val, "MaxMemoryInMb", &s.MaxMemoryInMb)
			delete(rawMsg, key)
		case "maxPercentageCpu":
			err = unpopulate(val, "MaxPercentageCPU", &s.MaxPercentageCPU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteLogsConfig.
func (s SiteLogsConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteLogsConfig.
func (s *SiteLogsConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteLogsConfigProperties.
func (s SiteLogsConfigProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationLogs", s.ApplicationLogs)
	populate(objectMap, "detailedErrorMessages", s.DetailedErrorMessages)
	populate(objectMap, "failedRequestsTracing", s.FailedRequestsTracing)
	populate(objectMap, "httpLogs", s.HTTPLogs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteLogsConfigProperties.
func (s *SiteLogsConfigProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationLogs":
			err = unpopulate(val, "ApplicationLogs", &s.ApplicationLogs)
			delete(rawMsg, key)
		case "detailedErrorMessages":
			err = unpopulate(val, "DetailedErrorMessages", &s.DetailedErrorMessages)
			delete(rawMsg, key)
		case "failedRequestsTracing":
			err = unpopulate(val, "FailedRequestsTracing", &s.FailedRequestsTracing)
			delete(rawMsg, key)
		case "httpLogs":
			err = unpopulate(val, "HTTPLogs", &s.HTTPLogs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteMachineKey.
func (s SiteMachineKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "decryption", s.Decryption)
	populate(objectMap, "decryptionKey", s.DecryptionKey)
	populate(objectMap, "validation", s.Validation)
	populate(objectMap, "validationKey", s.ValidationKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteMachineKey.
func (s *SiteMachineKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "decryption":
			err = unpopulate(val, "Decryption", &s.Decryption)
			delete(rawMsg, key)
		case "decryptionKey":
			err = unpopulate(val, "DecryptionKey", &s.DecryptionKey)
			delete(rawMsg, key)
		case "validation":
			err = unpopulate(val, "Validation", &s.Validation)
			delete(rawMsg, key)
		case "validationKey":
			err = unpopulate(val, "ValidationKey", &s.ValidationKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SitePatchResource.
func (s SitePatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SitePatchResource.
func (s *SitePatchResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &s.Identity)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SitePatchResourceProperties.
func (s SitePatchResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilityState", s.AvailabilityState)
	populate(objectMap, "clientAffinityEnabled", s.ClientAffinityEnabled)
	populate(objectMap, "clientCertEnabled", s.ClientCertEnabled)
	populate(objectMap, "clientCertExclusionPaths", s.ClientCertExclusionPaths)
	populate(objectMap, "clientCertMode", s.ClientCertMode)
	populate(objectMap, "cloningInfo", s.CloningInfo)
	populate(objectMap, "containerSize", s.ContainerSize)
	populate(objectMap, "customDomainVerificationId", s.CustomDomainVerificationID)
	populate(objectMap, "dailyMemoryTimeQuota", s.DailyMemoryTimeQuota)
	populate(objectMap, "defaultHostName", s.DefaultHostName)
	populate(objectMap, "enabled", s.Enabled)
	populate(objectMap, "enabledHostNames", s.EnabledHostNames)
	populate(objectMap, "httpsOnly", s.HTTPSOnly)
	populate(objectMap, "hostNameSslStates", s.HostNameSSLStates)
	populate(objectMap, "hostNames", s.HostNames)
	populate(objectMap, "hostNamesDisabled", s.HostNamesDisabled)
	populate(objectMap, "hostingEnvironmentProfile", s.HostingEnvironmentProfile)
	populate(objectMap, "hyperV", s.HyperV)
	populate(objectMap, "inProgressOperationId", s.InProgressOperationID)
	populate(objectMap, "isDefaultContainer", s.IsDefaultContainer)
	populate(objectMap, "isXenon", s.IsXenon)
	populate(objectMap, "keyVaultReferenceIdentity", s.KeyVaultReferenceIdentity)
	populateDateTimeRFC3339(objectMap, "lastModifiedTimeUtc", s.LastModifiedTimeUTC)
	populate(objectMap, "maxNumberOfWorkers", s.MaxNumberOfWorkers)
	populate(objectMap, "outboundIpAddresses", s.OutboundIPAddresses)
	populate(objectMap, "possibleOutboundIpAddresses", s.PossibleOutboundIPAddresses)
	populate(objectMap, "redundancyMode", s.RedundancyMode)
	populate(objectMap, "repositorySiteName", s.RepositorySiteName)
	populate(objectMap, "reserved", s.Reserved)
	populate(objectMap, "resourceGroup", s.ResourceGroup)
	populate(objectMap, "scmSiteAlsoStopped", s.ScmSiteAlsoStopped)
	populate(objectMap, "serverFarmId", s.ServerFarmID)
	populate(objectMap, "siteConfig", s.SiteConfig)
	populate(objectMap, "slotSwapStatus", s.SlotSwapStatus)
	populate(objectMap, "state", s.State)
	populate(objectMap, "storageAccountRequired", s.StorageAccountRequired)
	populateDateTimeRFC3339(objectMap, "suspendedTill", s.SuspendedTill)
	populate(objectMap, "targetSwapSlot", s.TargetSwapSlot)
	populate(objectMap, "trafficManagerHostNames", s.TrafficManagerHostNames)
	populate(objectMap, "usageState", s.UsageState)
	populate(objectMap, "virtualNetworkSubnetId", s.VirtualNetworkSubnetID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SitePatchResourceProperties.
func (s *SitePatchResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityState":
			err = unpopulate(val, "AvailabilityState", &s.AvailabilityState)
			delete(rawMsg, key)
		case "clientAffinityEnabled":
			err = unpopulate(val, "ClientAffinityEnabled", &s.ClientAffinityEnabled)
			delete(rawMsg, key)
		case "clientCertEnabled":
			err = unpopulate(val, "ClientCertEnabled", &s.ClientCertEnabled)
			delete(rawMsg, key)
		case "clientCertExclusionPaths":
			err = unpopulate(val, "ClientCertExclusionPaths", &s.ClientCertExclusionPaths)
			delete(rawMsg, key)
		case "clientCertMode":
			err = unpopulate(val, "ClientCertMode", &s.ClientCertMode)
			delete(rawMsg, key)
		case "cloningInfo":
			err = unpopulate(val, "CloningInfo", &s.CloningInfo)
			delete(rawMsg, key)
		case "containerSize":
			err = unpopulate(val, "ContainerSize", &s.ContainerSize)
			delete(rawMsg, key)
		case "customDomainVerificationId":
			err = unpopulate(val, "CustomDomainVerificationID", &s.CustomDomainVerificationID)
			delete(rawMsg, key)
		case "dailyMemoryTimeQuota":
			err = unpopulate(val, "DailyMemoryTimeQuota", &s.DailyMemoryTimeQuota)
			delete(rawMsg, key)
		case "defaultHostName":
			err = unpopulate(val, "DefaultHostName", &s.DefaultHostName)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &s.Enabled)
			delete(rawMsg, key)
		case "enabledHostNames":
			err = unpopulate(val, "EnabledHostNames", &s.EnabledHostNames)
			delete(rawMsg, key)
		case "httpsOnly":
			err = unpopulate(val, "HTTPSOnly", &s.HTTPSOnly)
			delete(rawMsg, key)
		case "hostNameSslStates":
			err = unpopulate(val, "HostNameSSLStates", &s.HostNameSSLStates)
			delete(rawMsg, key)
		case "hostNames":
			err = unpopulate(val, "HostNames", &s.HostNames)
			delete(rawMsg, key)
		case "hostNamesDisabled":
			err = unpopulate(val, "HostNamesDisabled", &s.HostNamesDisabled)
			delete(rawMsg, key)
		case "hostingEnvironmentProfile":
			err = unpopulate(val, "HostingEnvironmentProfile", &s.HostingEnvironmentProfile)
			delete(rawMsg, key)
		case "hyperV":
			err = unpopulate(val, "HyperV", &s.HyperV)
			delete(rawMsg, key)
		case "inProgressOperationId":
			err = unpopulate(val, "InProgressOperationID", &s.InProgressOperationID)
			delete(rawMsg, key)
		case "isDefaultContainer":
			err = unpopulate(val, "IsDefaultContainer", &s.IsDefaultContainer)
			delete(rawMsg, key)
		case "isXenon":
			err = unpopulate(val, "IsXenon", &s.IsXenon)
			delete(rawMsg, key)
		case "keyVaultReferenceIdentity":
			err = unpopulate(val, "KeyVaultReferenceIdentity", &s.KeyVaultReferenceIdentity)
			delete(rawMsg, key)
		case "lastModifiedTimeUtc":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedTimeUTC", &s.LastModifiedTimeUTC)
			delete(rawMsg, key)
		case "maxNumberOfWorkers":
			err = unpopulate(val, "MaxNumberOfWorkers", &s.MaxNumberOfWorkers)
			delete(rawMsg, key)
		case "outboundIpAddresses":
			err = unpopulate(val, "OutboundIPAddresses", &s.OutboundIPAddresses)
			delete(rawMsg, key)
		case "possibleOutboundIpAddresses":
			err = unpopulate(val, "PossibleOutboundIPAddresses", &s.PossibleOutboundIPAddresses)
			delete(rawMsg, key)
		case "redundancyMode":
			err = unpopulate(val, "RedundancyMode", &s.RedundancyMode)
			delete(rawMsg, key)
		case "repositorySiteName":
			err = unpopulate(val, "RepositorySiteName", &s.RepositorySiteName)
			delete(rawMsg, key)
		case "reserved":
			err = unpopulate(val, "Reserved", &s.Reserved)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &s.ResourceGroup)
			delete(rawMsg, key)
		case "scmSiteAlsoStopped":
			err = unpopulate(val, "ScmSiteAlsoStopped", &s.ScmSiteAlsoStopped)
			delete(rawMsg, key)
		case "serverFarmId":
			err = unpopulate(val, "ServerFarmID", &s.ServerFarmID)
			delete(rawMsg, key)
		case "siteConfig":
			err = unpopulate(val, "SiteConfig", &s.SiteConfig)
			delete(rawMsg, key)
		case "slotSwapStatus":
			err = unpopulate(val, "SlotSwapStatus", &s.SlotSwapStatus)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		case "storageAccountRequired":
			err = unpopulate(val, "StorageAccountRequired", &s.StorageAccountRequired)
			delete(rawMsg, key)
		case "suspendedTill":
			err = unpopulateDateTimeRFC3339(val, "SuspendedTill", &s.SuspendedTill)
			delete(rawMsg, key)
		case "targetSwapSlot":
			err = unpopulate(val, "TargetSwapSlot", &s.TargetSwapSlot)
			delete(rawMsg, key)
		case "trafficManagerHostNames":
			err = unpopulate(val, "TrafficManagerHostNames", &s.TrafficManagerHostNames)
			delete(rawMsg, key)
		case "usageState":
			err = unpopulate(val, "UsageState", &s.UsageState)
			delete(rawMsg, key)
		case "virtualNetworkSubnetId":
			err = unpopulate(val, "VirtualNetworkSubnetID", &s.VirtualNetworkSubnetID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SitePhpErrorLogFlag.
func (s SitePhpErrorLogFlag) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SitePhpErrorLogFlag.
func (s *SitePhpErrorLogFlag) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SitePhpErrorLogFlagProperties.
func (s SitePhpErrorLogFlagProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "localLogErrors", s.LocalLogErrors)
	populate(objectMap, "localLogErrorsMaxLength", s.LocalLogErrorsMaxLength)
	populate(objectMap, "masterLogErrors", s.MasterLogErrors)
	populate(objectMap, "masterLogErrorsMaxLength", s.MasterLogErrorsMaxLength)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SitePhpErrorLogFlagProperties.
func (s *SitePhpErrorLogFlagProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localLogErrors":
			err = unpopulate(val, "LocalLogErrors", &s.LocalLogErrors)
			delete(rawMsg, key)
		case "localLogErrorsMaxLength":
			err = unpopulate(val, "LocalLogErrorsMaxLength", &s.LocalLogErrorsMaxLength)
			delete(rawMsg, key)
		case "masterLogErrors":
			err = unpopulate(val, "MasterLogErrors", &s.MasterLogErrors)
			delete(rawMsg, key)
		case "masterLogErrorsMaxLength":
			err = unpopulate(val, "MasterLogErrorsMaxLength", &s.MasterLogErrorsMaxLength)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteProperties.
func (s SiteProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilityState", s.AvailabilityState)
	populate(objectMap, "clientAffinityEnabled", s.ClientAffinityEnabled)
	populate(objectMap, "clientCertEnabled", s.ClientCertEnabled)
	populate(objectMap, "clientCertExclusionPaths", s.ClientCertExclusionPaths)
	populate(objectMap, "clientCertMode", s.ClientCertMode)
	populate(objectMap, "cloningInfo", s.CloningInfo)
	populate(objectMap, "containerSize", s.ContainerSize)
	populate(objectMap, "customDomainVerificationId", s.CustomDomainVerificationID)
	populate(objectMap, "dailyMemoryTimeQuota", s.DailyMemoryTimeQuota)
	populate(objectMap, "daprConfig", s.DaprConfig)
	populate(objectMap, "defaultHostName", s.DefaultHostName)
	populate(objectMap, "enabled", s.Enabled)
	populate(objectMap, "enabledHostNames", s.EnabledHostNames)
	populate(objectMap, "httpsOnly", s.HTTPSOnly)
	populate(objectMap, "hostNameSslStates", s.HostNameSSLStates)
	populate(objectMap, "hostNames", s.HostNames)
	populate(objectMap, "hostNamesDisabled", s.HostNamesDisabled)
	populate(objectMap, "hostingEnvironmentProfile", s.HostingEnvironmentProfile)
	populate(objectMap, "hyperV", s.HyperV)
	populate(objectMap, "inProgressOperationId", s.InProgressOperationID)
	populate(objectMap, "isDefaultContainer", s.IsDefaultContainer)
	populate(objectMap, "isXenon", s.IsXenon)
	populate(objectMap, "keyVaultReferenceIdentity", s.KeyVaultReferenceIdentity)
	populateDateTimeRFC3339(objectMap, "lastModifiedTimeUtc", s.LastModifiedTimeUTC)
	populate(objectMap, "managedEnvironmentId", s.ManagedEnvironmentID)
	populate(objectMap, "maxNumberOfWorkers", s.MaxNumberOfWorkers)
	populate(objectMap, "outboundIpAddresses", s.OutboundIPAddresses)
	populate(objectMap, "possibleOutboundIpAddresses", s.PossibleOutboundIPAddresses)
	populate(objectMap, "publicNetworkAccess", s.PublicNetworkAccess)
	populate(objectMap, "redundancyMode", s.RedundancyMode)
	populate(objectMap, "repositorySiteName", s.RepositorySiteName)
	populate(objectMap, "reserved", s.Reserved)
	populate(objectMap, "resourceConfig", s.ResourceConfig)
	populate(objectMap, "resourceGroup", s.ResourceGroup)
	populate(objectMap, "scmSiteAlsoStopped", s.ScmSiteAlsoStopped)
	populate(objectMap, "serverFarmId", s.ServerFarmID)
	populate(objectMap, "siteConfig", s.SiteConfig)
	populate(objectMap, "slotSwapStatus", s.SlotSwapStatus)
	populate(objectMap, "state", s.State)
	populate(objectMap, "storageAccountRequired", s.StorageAccountRequired)
	populateDateTimeRFC3339(objectMap, "suspendedTill", s.SuspendedTill)
	populate(objectMap, "targetSwapSlot", s.TargetSwapSlot)
	populate(objectMap, "trafficManagerHostNames", s.TrafficManagerHostNames)
	populate(objectMap, "usageState", s.UsageState)
	populate(objectMap, "virtualNetworkSubnetId", s.VirtualNetworkSubnetID)
	populate(objectMap, "vnetContentShareEnabled", s.VnetContentShareEnabled)
	populate(objectMap, "vnetImagePullEnabled", s.VnetImagePullEnabled)
	populate(objectMap, "vnetRouteAllEnabled", s.VnetRouteAllEnabled)
	populate(objectMap, "workloadProfileName", s.WorkloadProfileName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteProperties.
func (s *SiteProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityState":
			err = unpopulate(val, "AvailabilityState", &s.AvailabilityState)
			delete(rawMsg, key)
		case "clientAffinityEnabled":
			err = unpopulate(val, "ClientAffinityEnabled", &s.ClientAffinityEnabled)
			delete(rawMsg, key)
		case "clientCertEnabled":
			err = unpopulate(val, "ClientCertEnabled", &s.ClientCertEnabled)
			delete(rawMsg, key)
		case "clientCertExclusionPaths":
			err = unpopulate(val, "ClientCertExclusionPaths", &s.ClientCertExclusionPaths)
			delete(rawMsg, key)
		case "clientCertMode":
			err = unpopulate(val, "ClientCertMode", &s.ClientCertMode)
			delete(rawMsg, key)
		case "cloningInfo":
			err = unpopulate(val, "CloningInfo", &s.CloningInfo)
			delete(rawMsg, key)
		case "containerSize":
			err = unpopulate(val, "ContainerSize", &s.ContainerSize)
			delete(rawMsg, key)
		case "customDomainVerificationId":
			err = unpopulate(val, "CustomDomainVerificationID", &s.CustomDomainVerificationID)
			delete(rawMsg, key)
		case "dailyMemoryTimeQuota":
			err = unpopulate(val, "DailyMemoryTimeQuota", &s.DailyMemoryTimeQuota)
			delete(rawMsg, key)
		case "daprConfig":
			err = unpopulate(val, "DaprConfig", &s.DaprConfig)
			delete(rawMsg, key)
		case "defaultHostName":
			err = unpopulate(val, "DefaultHostName", &s.DefaultHostName)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &s.Enabled)
			delete(rawMsg, key)
		case "enabledHostNames":
			err = unpopulate(val, "EnabledHostNames", &s.EnabledHostNames)
			delete(rawMsg, key)
		case "httpsOnly":
			err = unpopulate(val, "HTTPSOnly", &s.HTTPSOnly)
			delete(rawMsg, key)
		case "hostNameSslStates":
			err = unpopulate(val, "HostNameSSLStates", &s.HostNameSSLStates)
			delete(rawMsg, key)
		case "hostNames":
			err = unpopulate(val, "HostNames", &s.HostNames)
			delete(rawMsg, key)
		case "hostNamesDisabled":
			err = unpopulate(val, "HostNamesDisabled", &s.HostNamesDisabled)
			delete(rawMsg, key)
		case "hostingEnvironmentProfile":
			err = unpopulate(val, "HostingEnvironmentProfile", &s.HostingEnvironmentProfile)
			delete(rawMsg, key)
		case "hyperV":
			err = unpopulate(val, "HyperV", &s.HyperV)
			delete(rawMsg, key)
		case "inProgressOperationId":
			err = unpopulate(val, "InProgressOperationID", &s.InProgressOperationID)
			delete(rawMsg, key)
		case "isDefaultContainer":
			err = unpopulate(val, "IsDefaultContainer", &s.IsDefaultContainer)
			delete(rawMsg, key)
		case "isXenon":
			err = unpopulate(val, "IsXenon", &s.IsXenon)
			delete(rawMsg, key)
		case "keyVaultReferenceIdentity":
			err = unpopulate(val, "KeyVaultReferenceIdentity", &s.KeyVaultReferenceIdentity)
			delete(rawMsg, key)
		case "lastModifiedTimeUtc":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedTimeUTC", &s.LastModifiedTimeUTC)
			delete(rawMsg, key)
		case "managedEnvironmentId":
			err = unpopulate(val, "ManagedEnvironmentID", &s.ManagedEnvironmentID)
			delete(rawMsg, key)
		case "maxNumberOfWorkers":
			err = unpopulate(val, "MaxNumberOfWorkers", &s.MaxNumberOfWorkers)
			delete(rawMsg, key)
		case "outboundIpAddresses":
			err = unpopulate(val, "OutboundIPAddresses", &s.OutboundIPAddresses)
			delete(rawMsg, key)
		case "possibleOutboundIpAddresses":
			err = unpopulate(val, "PossibleOutboundIPAddresses", &s.PossibleOutboundIPAddresses)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &s.PublicNetworkAccess)
			delete(rawMsg, key)
		case "redundancyMode":
			err = unpopulate(val, "RedundancyMode", &s.RedundancyMode)
			delete(rawMsg, key)
		case "repositorySiteName":
			err = unpopulate(val, "RepositorySiteName", &s.RepositorySiteName)
			delete(rawMsg, key)
		case "reserved":
			err = unpopulate(val, "Reserved", &s.Reserved)
			delete(rawMsg, key)
		case "resourceConfig":
			err = unpopulate(val, "ResourceConfig", &s.ResourceConfig)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &s.ResourceGroup)
			delete(rawMsg, key)
		case "scmSiteAlsoStopped":
			err = unpopulate(val, "ScmSiteAlsoStopped", &s.ScmSiteAlsoStopped)
			delete(rawMsg, key)
		case "serverFarmId":
			err = unpopulate(val, "ServerFarmID", &s.ServerFarmID)
			delete(rawMsg, key)
		case "siteConfig":
			err = unpopulate(val, "SiteConfig", &s.SiteConfig)
			delete(rawMsg, key)
		case "slotSwapStatus":
			err = unpopulate(val, "SlotSwapStatus", &s.SlotSwapStatus)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		case "storageAccountRequired":
			err = unpopulate(val, "StorageAccountRequired", &s.StorageAccountRequired)
			delete(rawMsg, key)
		case "suspendedTill":
			err = unpopulateDateTimeRFC3339(val, "SuspendedTill", &s.SuspendedTill)
			delete(rawMsg, key)
		case "targetSwapSlot":
			err = unpopulate(val, "TargetSwapSlot", &s.TargetSwapSlot)
			delete(rawMsg, key)
		case "trafficManagerHostNames":
			err = unpopulate(val, "TrafficManagerHostNames", &s.TrafficManagerHostNames)
			delete(rawMsg, key)
		case "usageState":
			err = unpopulate(val, "UsageState", &s.UsageState)
			delete(rawMsg, key)
		case "virtualNetworkSubnetId":
			err = unpopulate(val, "VirtualNetworkSubnetID", &s.VirtualNetworkSubnetID)
			delete(rawMsg, key)
		case "vnetContentShareEnabled":
			err = unpopulate(val, "VnetContentShareEnabled", &s.VnetContentShareEnabled)
			delete(rawMsg, key)
		case "vnetImagePullEnabled":
			err = unpopulate(val, "VnetImagePullEnabled", &s.VnetImagePullEnabled)
			delete(rawMsg, key)
		case "vnetRouteAllEnabled":
			err = unpopulate(val, "VnetRouteAllEnabled", &s.VnetRouteAllEnabled)
			delete(rawMsg, key)
		case "workloadProfileName":
			err = unpopulate(val, "WorkloadProfileName", &s.WorkloadProfileName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteSeal.
func (s SiteSeal) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "html", s.HTML)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteSeal.
func (s *SiteSeal) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "html":
			err = unpopulate(val, "HTML", &s.HTML)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteSealRequest.
func (s SiteSealRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "lightTheme", s.LightTheme)
	populate(objectMap, "locale", s.Locale)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteSealRequest.
func (s *SiteSealRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lightTheme":
			err = unpopulate(val, "LightTheme", &s.LightTheme)
			delete(rawMsg, key)
		case "locale":
			err = unpopulate(val, "Locale", &s.Locale)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteSourceControl.
func (s SiteSourceControl) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteSourceControl.
func (s *SiteSourceControl) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteSourceControlProperties.
func (s SiteSourceControlProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "branch", s.Branch)
	populate(objectMap, "deploymentRollbackEnabled", s.DeploymentRollbackEnabled)
	populate(objectMap, "gitHubActionConfiguration", s.GitHubActionConfiguration)
	populate(objectMap, "isGitHubAction", s.IsGitHubAction)
	populate(objectMap, "isManualIntegration", s.IsManualIntegration)
	populate(objectMap, "isMercurial", s.IsMercurial)
	populate(objectMap, "repoUrl", s.RepoURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteSourceControlProperties.
func (s *SiteSourceControlProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "branch":
			err = unpopulate(val, "Branch", &s.Branch)
			delete(rawMsg, key)
		case "deploymentRollbackEnabled":
			err = unpopulate(val, "DeploymentRollbackEnabled", &s.DeploymentRollbackEnabled)
			delete(rawMsg, key)
		case "gitHubActionConfiguration":
			err = unpopulate(val, "GitHubActionConfiguration", &s.GitHubActionConfiguration)
			delete(rawMsg, key)
		case "isGitHubAction":
			err = unpopulate(val, "IsGitHubAction", &s.IsGitHubAction)
			delete(rawMsg, key)
		case "isManualIntegration":
			err = unpopulate(val, "IsManualIntegration", &s.IsManualIntegration)
			delete(rawMsg, key)
		case "isMercurial":
			err = unpopulate(val, "IsMercurial", &s.IsMercurial)
			delete(rawMsg, key)
		case "repoUrl":
			err = unpopulate(val, "RepoURL", &s.RepoURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SlotConfigNames.
func (s SlotConfigNames) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appSettingNames", s.AppSettingNames)
	populate(objectMap, "azureStorageConfigNames", s.AzureStorageConfigNames)
	populate(objectMap, "connectionStringNames", s.ConnectionStringNames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SlotConfigNames.
func (s *SlotConfigNames) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appSettingNames":
			err = unpopulate(val, "AppSettingNames", &s.AppSettingNames)
			delete(rawMsg, key)
		case "azureStorageConfigNames":
			err = unpopulate(val, "AzureStorageConfigNames", &s.AzureStorageConfigNames)
			delete(rawMsg, key)
		case "connectionStringNames":
			err = unpopulate(val, "ConnectionStringNames", &s.ConnectionStringNames)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SlotConfigNamesResource.
func (s SlotConfigNamesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SlotConfigNamesResource.
func (s *SlotConfigNamesResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SlotDifference.
func (s SlotDifference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SlotDifference.
func (s *SlotDifference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SlotDifferenceCollection.
func (s SlotDifferenceCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SlotDifferenceCollection.
func (s *SlotDifferenceCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SlotDifferenceProperties.
func (s SlotDifferenceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "diffRule", s.DiffRule)
	populate(objectMap, "level", s.Level)
	populate(objectMap, "settingName", s.SettingName)
	populate(objectMap, "settingType", s.SettingType)
	populate(objectMap, "valueInCurrentSlot", s.ValueInCurrentSlot)
	populate(objectMap, "valueInTargetSlot", s.ValueInTargetSlot)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SlotDifferenceProperties.
func (s *SlotDifferenceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "diffRule":
			err = unpopulate(val, "DiffRule", &s.DiffRule)
			delete(rawMsg, key)
		case "level":
			err = unpopulate(val, "Level", &s.Level)
			delete(rawMsg, key)
		case "settingName":
			err = unpopulate(val, "SettingName", &s.SettingName)
			delete(rawMsg, key)
		case "settingType":
			err = unpopulate(val, "SettingType", &s.SettingType)
			delete(rawMsg, key)
		case "valueInCurrentSlot":
			err = unpopulate(val, "ValueInCurrentSlot", &s.ValueInCurrentSlot)
			delete(rawMsg, key)
		case "valueInTargetSlot":
			err = unpopulate(val, "ValueInTargetSlot", &s.ValueInTargetSlot)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SlotSwapStatus.
func (s SlotSwapStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinationSlotName", s.DestinationSlotName)
	populate(objectMap, "sourceSlotName", s.SourceSlotName)
	populateDateTimeRFC3339(objectMap, "timestampUtc", s.TimestampUTC)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SlotSwapStatus.
func (s *SlotSwapStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinationSlotName":
			err = unpopulate(val, "DestinationSlotName", &s.DestinationSlotName)
			delete(rawMsg, key)
		case "sourceSlotName":
			err = unpopulate(val, "SourceSlotName", &s.SourceSlotName)
			delete(rawMsg, key)
		case "timestampUtc":
			err = unpopulateDateTimeRFC3339(val, "TimestampUTC", &s.TimestampUTC)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SlowRequestsBasedTrigger.
func (s SlowRequestsBasedTrigger) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", s.Count)
	populate(objectMap, "path", s.Path)
	populate(objectMap, "timeInterval", s.TimeInterval)
	populate(objectMap, "timeTaken", s.TimeTaken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SlowRequestsBasedTrigger.
func (s *SlowRequestsBasedTrigger) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &s.Count)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &s.Path)
			delete(rawMsg, key)
		case "timeInterval":
			err = unpopulate(val, "TimeInterval", &s.TimeInterval)
			delete(rawMsg, key)
		case "timeTaken":
			err = unpopulate(val, "TimeTaken", &s.TimeTaken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Snapshot.
func (s Snapshot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Snapshot.
func (s *Snapshot) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotCollection.
func (s SnapshotCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotCollection.
func (s *SnapshotCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotProperties.
func (s SnapshotProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "time", s.Time)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotProperties.
func (s *SnapshotProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "time":
			err = unpopulate(val, "Time", &s.Time)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotRecoverySource.
func (s SnapshotRecoverySource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotRecoverySource.
func (s *SnapshotRecoverySource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotRestoreRequest.
func (s SnapshotRestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotRestoreRequest.
func (s *SnapshotRestoreRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotRestoreRequestProperties.
func (s SnapshotRestoreRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ignoreConflictingHostNames", s.IgnoreConflictingHostNames)
	populate(objectMap, "overwrite", s.Overwrite)
	populate(objectMap, "recoverConfiguration", s.RecoverConfiguration)
	populate(objectMap, "recoverySource", s.RecoverySource)
	populate(objectMap, "snapshotTime", s.SnapshotTime)
	populate(objectMap, "useDRSecondary", s.UseDRSecondary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotRestoreRequestProperties.
func (s *SnapshotRestoreRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ignoreConflictingHostNames":
			err = unpopulate(val, "IgnoreConflictingHostNames", &s.IgnoreConflictingHostNames)
			delete(rawMsg, key)
		case "overwrite":
			err = unpopulate(val, "Overwrite", &s.Overwrite)
			delete(rawMsg, key)
		case "recoverConfiguration":
			err = unpopulate(val, "RecoverConfiguration", &s.RecoverConfiguration)
			delete(rawMsg, key)
		case "recoverySource":
			err = unpopulate(val, "RecoverySource", &s.RecoverySource)
			delete(rawMsg, key)
		case "snapshotTime":
			err = unpopulate(val, "SnapshotTime", &s.SnapshotTime)
			delete(rawMsg, key)
		case "useDRSecondary":
			err = unpopulate(val, "UseDRSecondary", &s.UseDRSecondary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Solution.
func (s Solution) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "data", s.Data)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "metadata", s.Metadata)
	populate(objectMap, "order", s.Order)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Solution.
func (s *Solution) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "data":
			err = unpopulate(val, "Data", &s.Data)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &s.Metadata)
			delete(rawMsg, key)
		case "order":
			err = unpopulate(val, "Order", &s.Order)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControl.
func (s SourceControl) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControl.
func (s *SourceControl) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlCollection.
func (s SourceControlCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlCollection.
func (s *SourceControlCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlProperties.
func (s SourceControlProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "expirationTime", s.ExpirationTime)
	populate(objectMap, "refreshToken", s.RefreshToken)
	populate(objectMap, "token", s.Token)
	populate(objectMap, "tokenSecret", s.TokenSecret)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlProperties.
func (s *SourceControlProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expirationTime":
			err = unpopulateDateTimeRFC3339(val, "ExpirationTime", &s.ExpirationTime)
			delete(rawMsg, key)
		case "refreshToken":
			err = unpopulate(val, "RefreshToken", &s.RefreshToken)
			delete(rawMsg, key)
		case "token":
			err = unpopulate(val, "Token", &s.Token)
			delete(rawMsg, key)
		case "tokenSecret":
			err = unpopulate(val, "TokenSecret", &s.TokenSecret)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StackMajorVersion.
func (s StackMajorVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appSettingsDictionary", s.AppSettingsDictionary)
	populate(objectMap, "applicationInsights", s.ApplicationInsights)
	populate(objectMap, "displayVersion", s.DisplayVersion)
	populate(objectMap, "isDefault", s.IsDefault)
	populate(objectMap, "isDeprecated", s.IsDeprecated)
	populate(objectMap, "isHidden", s.IsHidden)
	populate(objectMap, "isPreview", s.IsPreview)
	populate(objectMap, "minorVersions", s.MinorVersions)
	populate(objectMap, "runtimeVersion", s.RuntimeVersion)
	populate(objectMap, "siteConfigPropertiesDictionary", s.SiteConfigPropertiesDictionary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StackMajorVersion.
func (s *StackMajorVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appSettingsDictionary":
			err = unpopulate(val, "AppSettingsDictionary", &s.AppSettingsDictionary)
			delete(rawMsg, key)
		case "applicationInsights":
			err = unpopulate(val, "ApplicationInsights", &s.ApplicationInsights)
			delete(rawMsg, key)
		case "displayVersion":
			err = unpopulate(val, "DisplayVersion", &s.DisplayVersion)
			delete(rawMsg, key)
		case "isDefault":
			err = unpopulate(val, "IsDefault", &s.IsDefault)
			delete(rawMsg, key)
		case "isDeprecated":
			err = unpopulate(val, "IsDeprecated", &s.IsDeprecated)
			delete(rawMsg, key)
		case "isHidden":
			err = unpopulate(val, "IsHidden", &s.IsHidden)
			delete(rawMsg, key)
		case "isPreview":
			err = unpopulate(val, "IsPreview", &s.IsPreview)
			delete(rawMsg, key)
		case "minorVersions":
			err = unpopulate(val, "MinorVersions", &s.MinorVersions)
			delete(rawMsg, key)
		case "runtimeVersion":
			err = unpopulate(val, "RuntimeVersion", &s.RuntimeVersion)
			delete(rawMsg, key)
		case "siteConfigPropertiesDictionary":
			err = unpopulate(val, "SiteConfigPropertiesDictionary", &s.SiteConfigPropertiesDictionary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StackMinorVersion.
func (s StackMinorVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayVersion", s.DisplayVersion)
	populate(objectMap, "isDefault", s.IsDefault)
	populate(objectMap, "isRemoteDebuggingEnabled", s.IsRemoteDebuggingEnabled)
	populate(objectMap, "runtimeVersion", s.RuntimeVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StackMinorVersion.
func (s *StackMinorVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayVersion":
			err = unpopulate(val, "DisplayVersion", &s.DisplayVersion)
			delete(rawMsg, key)
		case "isDefault":
			err = unpopulate(val, "IsDefault", &s.IsDefault)
			delete(rawMsg, key)
		case "isRemoteDebuggingEnabled":
			err = unpopulate(val, "IsRemoteDebuggingEnabled", &s.IsRemoteDebuggingEnabled)
			delete(rawMsg, key)
		case "runtimeVersion":
			err = unpopulate(val, "RuntimeVersion", &s.RuntimeVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StampCapacity.
func (s StampCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availableCapacity", s.AvailableCapacity)
	populate(objectMap, "computeMode", s.ComputeMode)
	populate(objectMap, "excludeFromCapacityAllocation", s.ExcludeFromCapacityAllocation)
	populate(objectMap, "isApplicableForAllComputeModes", s.IsApplicableForAllComputeModes)
	populate(objectMap, "isLinux", s.IsLinux)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "siteMode", s.SiteMode)
	populate(objectMap, "totalCapacity", s.TotalCapacity)
	populate(objectMap, "unit", s.Unit)
	populate(objectMap, "workerSize", s.WorkerSize)
	populate(objectMap, "workerSizeId", s.WorkerSizeID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StampCapacity.
func (s *StampCapacity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availableCapacity":
			err = unpopulate(val, "AvailableCapacity", &s.AvailableCapacity)
			delete(rawMsg, key)
		case "computeMode":
			err = unpopulate(val, "ComputeMode", &s.ComputeMode)
			delete(rawMsg, key)
		case "excludeFromCapacityAllocation":
			err = unpopulate(val, "ExcludeFromCapacityAllocation", &s.ExcludeFromCapacityAllocation)
			delete(rawMsg, key)
		case "isApplicableForAllComputeModes":
			err = unpopulate(val, "IsApplicableForAllComputeModes", &s.IsApplicableForAllComputeModes)
			delete(rawMsg, key)
		case "isLinux":
			err = unpopulate(val, "IsLinux", &s.IsLinux)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "siteMode":
			err = unpopulate(val, "SiteMode", &s.SiteMode)
			delete(rawMsg, key)
		case "totalCapacity":
			err = unpopulate(val, "TotalCapacity", &s.TotalCapacity)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &s.Unit)
			delete(rawMsg, key)
		case "workerSize":
			err = unpopulate(val, "WorkerSize", &s.WorkerSize)
			delete(rawMsg, key)
		case "workerSizeId":
			err = unpopulate(val, "WorkerSizeID", &s.WorkerSizeID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StampCapacityCollection.
func (s StampCapacityCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StampCapacityCollection.
func (s *StampCapacityCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSite.
func (s StaticSite) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowConfigFileUpdates", s.AllowConfigFileUpdates)
	populate(objectMap, "branch", s.Branch)
	populate(objectMap, "buildProperties", s.BuildProperties)
	populate(objectMap, "contentDistributionEndpoint", s.ContentDistributionEndpoint)
	populate(objectMap, "customDomains", s.CustomDomains)
	populate(objectMap, "databaseConnections", s.DatabaseConnections)
	populate(objectMap, "defaultHostname", s.DefaultHostname)
	populate(objectMap, "enterpriseGradeCdnStatus", s.EnterpriseGradeCdnStatus)
	populate(objectMap, "keyVaultReferenceIdentity", s.KeyVaultReferenceIdentity)
	populate(objectMap, "linkedBackends", s.LinkedBackends)
	populate(objectMap, "privateEndpointConnections", s.PrivateEndpointConnections)
	populate(objectMap, "provider", s.Provider)
	populate(objectMap, "publicNetworkAccess", s.PublicNetworkAccess)
	populate(objectMap, "repositoryToken", s.RepositoryToken)
	populate(objectMap, "repositoryUrl", s.RepositoryURL)
	populate(objectMap, "stagingEnvironmentPolicy", s.StagingEnvironmentPolicy)
	populate(objectMap, "templateProperties", s.TemplateProperties)
	populate(objectMap, "userProvidedFunctionApps", s.UserProvidedFunctionApps)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSite.
func (s *StaticSite) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowConfigFileUpdates":
			err = unpopulate(val, "AllowConfigFileUpdates", &s.AllowConfigFileUpdates)
			delete(rawMsg, key)
		case "branch":
			err = unpopulate(val, "Branch", &s.Branch)
			delete(rawMsg, key)
		case "buildProperties":
			err = unpopulate(val, "BuildProperties", &s.BuildProperties)
			delete(rawMsg, key)
		case "contentDistributionEndpoint":
			err = unpopulate(val, "ContentDistributionEndpoint", &s.ContentDistributionEndpoint)
			delete(rawMsg, key)
		case "customDomains":
			err = unpopulate(val, "CustomDomains", &s.CustomDomains)
			delete(rawMsg, key)
		case "databaseConnections":
			err = unpopulate(val, "DatabaseConnections", &s.DatabaseConnections)
			delete(rawMsg, key)
		case "defaultHostname":
			err = unpopulate(val, "DefaultHostname", &s.DefaultHostname)
			delete(rawMsg, key)
		case "enterpriseGradeCdnStatus":
			err = unpopulate(val, "EnterpriseGradeCdnStatus", &s.EnterpriseGradeCdnStatus)
			delete(rawMsg, key)
		case "keyVaultReferenceIdentity":
			err = unpopulate(val, "KeyVaultReferenceIdentity", &s.KeyVaultReferenceIdentity)
			delete(rawMsg, key)
		case "linkedBackends":
			err = unpopulate(val, "LinkedBackends", &s.LinkedBackends)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &s.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &s.Provider)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &s.PublicNetworkAccess)
			delete(rawMsg, key)
		case "repositoryToken":
			err = unpopulate(val, "RepositoryToken", &s.RepositoryToken)
			delete(rawMsg, key)
		case "repositoryUrl":
			err = unpopulate(val, "RepositoryURL", &s.RepositoryURL)
			delete(rawMsg, key)
		case "stagingEnvironmentPolicy":
			err = unpopulate(val, "StagingEnvironmentPolicy", &s.StagingEnvironmentPolicy)
			delete(rawMsg, key)
		case "templateProperties":
			err = unpopulate(val, "TemplateProperties", &s.TemplateProperties)
			delete(rawMsg, key)
		case "userProvidedFunctionApps":
			err = unpopulate(val, "UserProvidedFunctionApps", &s.UserProvidedFunctionApps)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteARMResource.
func (s StaticSiteARMResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteARMResource.
func (s *StaticSiteARMResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &s.Identity)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &s.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteBasicAuthPropertiesARMResource.
func (s StaticSiteBasicAuthPropertiesARMResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteBasicAuthPropertiesARMResource.
func (s *StaticSiteBasicAuthPropertiesARMResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteBasicAuthPropertiesARMResourceProperties.
func (s StaticSiteBasicAuthPropertiesARMResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicableEnvironmentsMode", s.ApplicableEnvironmentsMode)
	populate(objectMap, "environments", s.Environments)
	populate(objectMap, "password", s.Password)
	populate(objectMap, "secretState", s.SecretState)
	populate(objectMap, "secretUrl", s.SecretURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteBasicAuthPropertiesARMResourceProperties.
func (s *StaticSiteBasicAuthPropertiesARMResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicableEnvironmentsMode":
			err = unpopulate(val, "ApplicableEnvironmentsMode", &s.ApplicableEnvironmentsMode)
			delete(rawMsg, key)
		case "environments":
			err = unpopulate(val, "Environments", &s.Environments)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &s.Password)
			delete(rawMsg, key)
		case "secretState":
			err = unpopulate(val, "SecretState", &s.SecretState)
			delete(rawMsg, key)
		case "secretUrl":
			err = unpopulate(val, "SecretURL", &s.SecretURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteBasicAuthPropertiesCollection.
func (s StaticSiteBasicAuthPropertiesCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteBasicAuthPropertiesCollection.
func (s *StaticSiteBasicAuthPropertiesCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteBuildARMResource.
func (s StaticSiteBuildARMResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteBuildARMResource.
func (s *StaticSiteBuildARMResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteBuildARMResourceProperties.
func (s StaticSiteBuildARMResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "buildId", s.BuildID)
	populateDateTimeRFC3339(objectMap, "createdTimeUtc", s.CreatedTimeUTC)
	populate(objectMap, "databaseConnections", s.DatabaseConnections)
	populate(objectMap, "hostname", s.Hostname)
	populateDateTimeRFC3339(objectMap, "lastUpdatedOn", s.LastUpdatedOn)
	populate(objectMap, "linkedBackends", s.LinkedBackends)
	populate(objectMap, "pullRequestTitle", s.PullRequestTitle)
	populate(objectMap, "sourceBranch", s.SourceBranch)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "userProvidedFunctionApps", s.UserProvidedFunctionApps)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteBuildARMResourceProperties.
func (s *StaticSiteBuildARMResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "buildId":
			err = unpopulate(val, "BuildID", &s.BuildID)
			delete(rawMsg, key)
		case "createdTimeUtc":
			err = unpopulateDateTimeRFC3339(val, "CreatedTimeUTC", &s.CreatedTimeUTC)
			delete(rawMsg, key)
		case "databaseConnections":
			err = unpopulate(val, "DatabaseConnections", &s.DatabaseConnections)
			delete(rawMsg, key)
		case "hostname":
			err = unpopulate(val, "Hostname", &s.Hostname)
			delete(rawMsg, key)
		case "lastUpdatedOn":
			err = unpopulateDateTimeRFC3339(val, "LastUpdatedOn", &s.LastUpdatedOn)
			delete(rawMsg, key)
		case "linkedBackends":
			err = unpopulate(val, "LinkedBackends", &s.LinkedBackends)
			delete(rawMsg, key)
		case "pullRequestTitle":
			err = unpopulate(val, "PullRequestTitle", &s.PullRequestTitle)
			delete(rawMsg, key)
		case "sourceBranch":
			err = unpopulate(val, "SourceBranch", &s.SourceBranch)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "userProvidedFunctionApps":
			err = unpopulate(val, "UserProvidedFunctionApps", &s.UserProvidedFunctionApps)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteBuildCollection.
func (s StaticSiteBuildCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteBuildCollection.
func (s *StaticSiteBuildCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteBuildProperties.
func (s StaticSiteBuildProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiBuildCommand", s.APIBuildCommand)
	populate(objectMap, "apiLocation", s.APILocation)
	populate(objectMap, "appArtifactLocation", s.AppArtifactLocation)
	populate(objectMap, "appBuildCommand", s.AppBuildCommand)
	populate(objectMap, "appLocation", s.AppLocation)
	populate(objectMap, "githubActionSecretNameOverride", s.GithubActionSecretNameOverride)
	populate(objectMap, "outputLocation", s.OutputLocation)
	populate(objectMap, "skipGithubActionWorkflowGeneration", s.SkipGithubActionWorkflowGeneration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteBuildProperties.
func (s *StaticSiteBuildProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiBuildCommand":
			err = unpopulate(val, "APIBuildCommand", &s.APIBuildCommand)
			delete(rawMsg, key)
		case "apiLocation":
			err = unpopulate(val, "APILocation", &s.APILocation)
			delete(rawMsg, key)
		case "appArtifactLocation":
			err = unpopulate(val, "AppArtifactLocation", &s.AppArtifactLocation)
			delete(rawMsg, key)
		case "appBuildCommand":
			err = unpopulate(val, "AppBuildCommand", &s.AppBuildCommand)
			delete(rawMsg, key)
		case "appLocation":
			err = unpopulate(val, "AppLocation", &s.AppLocation)
			delete(rawMsg, key)
		case "githubActionSecretNameOverride":
			err = unpopulate(val, "GithubActionSecretNameOverride", &s.GithubActionSecretNameOverride)
			delete(rawMsg, key)
		case "outputLocation":
			err = unpopulate(val, "OutputLocation", &s.OutputLocation)
			delete(rawMsg, key)
		case "skipGithubActionWorkflowGeneration":
			err = unpopulate(val, "SkipGithubActionWorkflowGeneration", &s.SkipGithubActionWorkflowGeneration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteCollection.
func (s StaticSiteCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteCollection.
func (s *StaticSiteCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteCustomDomainOverviewARMResource.
func (s StaticSiteCustomDomainOverviewARMResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteCustomDomainOverviewARMResource.
func (s *StaticSiteCustomDomainOverviewARMResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteCustomDomainOverviewARMResourceProperties.
func (s StaticSiteCustomDomainOverviewARMResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdOn", s.CreatedOn)
	populate(objectMap, "domainName", s.DomainName)
	populate(objectMap, "errorMessage", s.ErrorMessage)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "validationToken", s.ValidationToken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteCustomDomainOverviewARMResourceProperties.
func (s *StaticSiteCustomDomainOverviewARMResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &s.CreatedOn)
			delete(rawMsg, key)
		case "domainName":
			err = unpopulate(val, "DomainName", &s.DomainName)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &s.ErrorMessage)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "validationToken":
			err = unpopulate(val, "ValidationToken", &s.ValidationToken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteCustomDomainOverviewCollection.
func (s StaticSiteCustomDomainOverviewCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteCustomDomainOverviewCollection.
func (s *StaticSiteCustomDomainOverviewCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteCustomDomainRequestPropertiesARMResource.
func (s StaticSiteCustomDomainRequestPropertiesARMResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteCustomDomainRequestPropertiesARMResource.
func (s *StaticSiteCustomDomainRequestPropertiesARMResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteCustomDomainRequestPropertiesARMResourceProperties.
func (s StaticSiteCustomDomainRequestPropertiesARMResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "validationMethod", s.ValidationMethod)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteCustomDomainRequestPropertiesARMResourceProperties.
func (s *StaticSiteCustomDomainRequestPropertiesARMResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "validationMethod":
			err = unpopulate(val, "ValidationMethod", &s.ValidationMethod)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteDatabaseConnectionConfigurationFileOverview.
func (s StaticSiteDatabaseConnectionConfigurationFileOverview) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contents", s.Contents)
	populate(objectMap, "fileName", s.FileName)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteDatabaseConnectionConfigurationFileOverview.
func (s *StaticSiteDatabaseConnectionConfigurationFileOverview) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contents":
			err = unpopulate(val, "Contents", &s.Contents)
			delete(rawMsg, key)
		case "fileName":
			err = unpopulate(val, "FileName", &s.FileName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteFunctionOverviewARMResource.
func (s StaticSiteFunctionOverviewARMResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteFunctionOverviewARMResource.
func (s *StaticSiteFunctionOverviewARMResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteFunctionOverviewARMResourceProperties.
func (s StaticSiteFunctionOverviewARMResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "functionName", s.FunctionName)
	populate(objectMap, "triggerType", s.TriggerType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteFunctionOverviewARMResourceProperties.
func (s *StaticSiteFunctionOverviewARMResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "functionName":
			err = unpopulate(val, "FunctionName", &s.FunctionName)
			delete(rawMsg, key)
		case "triggerType":
			err = unpopulate(val, "TriggerType", &s.TriggerType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteFunctionOverviewCollection.
func (s StaticSiteFunctionOverviewCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteFunctionOverviewCollection.
func (s *StaticSiteFunctionOverviewCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteLinkedBackend.
func (s StaticSiteLinkedBackend) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendResourceId", s.BackendResourceID)
	populateDateTimeRFC3339(objectMap, "createdOn", s.CreatedOn)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "region", s.Region)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteLinkedBackend.
func (s *StaticSiteLinkedBackend) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendResourceId":
			err = unpopulate(val, "BackendResourceID", &s.BackendResourceID)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &s.CreatedOn)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &s.Region)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteLinkedBackendARMResource.
func (s StaticSiteLinkedBackendARMResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteLinkedBackendARMResource.
func (s *StaticSiteLinkedBackendARMResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteLinkedBackendARMResourceProperties.
func (s StaticSiteLinkedBackendARMResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendResourceId", s.BackendResourceID)
	populateDateTimeRFC3339(objectMap, "createdOn", s.CreatedOn)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "region", s.Region)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteLinkedBackendARMResourceProperties.
func (s *StaticSiteLinkedBackendARMResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendResourceId":
			err = unpopulate(val, "BackendResourceID", &s.BackendResourceID)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &s.CreatedOn)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &s.Region)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteLinkedBackendsCollection.
func (s StaticSiteLinkedBackendsCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteLinkedBackendsCollection.
func (s *StaticSiteLinkedBackendsCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSitePatchResource.
func (s StaticSitePatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSitePatchResource.
func (s *StaticSitePatchResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteResetPropertiesARMResource.
func (s StaticSiteResetPropertiesARMResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteResetPropertiesARMResource.
func (s *StaticSiteResetPropertiesARMResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteResetPropertiesARMResourceProperties.
func (s StaticSiteResetPropertiesARMResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "repositoryToken", s.RepositoryToken)
	populate(objectMap, "shouldUpdateRepository", s.ShouldUpdateRepository)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteResetPropertiesARMResourceProperties.
func (s *StaticSiteResetPropertiesARMResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "repositoryToken":
			err = unpopulate(val, "RepositoryToken", &s.RepositoryToken)
			delete(rawMsg, key)
		case "shouldUpdateRepository":
			err = unpopulate(val, "ShouldUpdateRepository", &s.ShouldUpdateRepository)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteTemplateOptions.
func (s StaticSiteTemplateOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "isPrivate", s.IsPrivate)
	populate(objectMap, "owner", s.Owner)
	populate(objectMap, "repositoryName", s.RepositoryName)
	populate(objectMap, "templateRepositoryUrl", s.TemplateRepositoryURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteTemplateOptions.
func (s *StaticSiteTemplateOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "isPrivate":
			err = unpopulate(val, "IsPrivate", &s.IsPrivate)
			delete(rawMsg, key)
		case "owner":
			err = unpopulate(val, "Owner", &s.Owner)
			delete(rawMsg, key)
		case "repositoryName":
			err = unpopulate(val, "RepositoryName", &s.RepositoryName)
			delete(rawMsg, key)
		case "templateRepositoryUrl":
			err = unpopulate(val, "TemplateRepositoryURL", &s.TemplateRepositoryURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteUserARMResource.
func (s StaticSiteUserARMResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteUserARMResource.
func (s *StaticSiteUserARMResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteUserARMResourceProperties.
func (s StaticSiteUserARMResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "provider", s.Provider)
	populate(objectMap, "roles", s.Roles)
	populate(objectMap, "userId", s.UserID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteUserARMResourceProperties.
func (s *StaticSiteUserARMResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &s.Provider)
			delete(rawMsg, key)
		case "roles":
			err = unpopulate(val, "Roles", &s.Roles)
			delete(rawMsg, key)
		case "userId":
			err = unpopulate(val, "UserID", &s.UserID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteUserCollection.
func (s StaticSiteUserCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteUserCollection.
func (s *StaticSiteUserCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteUserInvitationRequestResource.
func (s StaticSiteUserInvitationRequestResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteUserInvitationRequestResource.
func (s *StaticSiteUserInvitationRequestResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteUserInvitationRequestResourceProperties.
func (s StaticSiteUserInvitationRequestResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "domain", s.Domain)
	populate(objectMap, "numHoursToExpiration", s.NumHoursToExpiration)
	populate(objectMap, "provider", s.Provider)
	populate(objectMap, "roles", s.Roles)
	populate(objectMap, "userDetails", s.UserDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteUserInvitationRequestResourceProperties.
func (s *StaticSiteUserInvitationRequestResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "domain":
			err = unpopulate(val, "Domain", &s.Domain)
			delete(rawMsg, key)
		case "numHoursToExpiration":
			err = unpopulate(val, "NumHoursToExpiration", &s.NumHoursToExpiration)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &s.Provider)
			delete(rawMsg, key)
		case "roles":
			err = unpopulate(val, "Roles", &s.Roles)
			delete(rawMsg, key)
		case "userDetails":
			err = unpopulate(val, "UserDetails", &s.UserDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteUserInvitationResponseResource.
func (s StaticSiteUserInvitationResponseResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteUserInvitationResponseResource.
func (s *StaticSiteUserInvitationResponseResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteUserInvitationResponseResourceProperties.
func (s StaticSiteUserInvitationResponseResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "expiresOn", s.ExpiresOn)
	populate(objectMap, "invitationUrl", s.InvitationURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteUserInvitationResponseResourceProperties.
func (s *StaticSiteUserInvitationResponseResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expiresOn":
			err = unpopulateDateTimeRFC3339(val, "ExpiresOn", &s.ExpiresOn)
			delete(rawMsg, key)
		case "invitationUrl":
			err = unpopulate(val, "InvitationURL", &s.InvitationURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteUserProvidedFunctionApp.
func (s StaticSiteUserProvidedFunctionApp) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteUserProvidedFunctionApp.
func (s *StaticSiteUserProvidedFunctionApp) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteUserProvidedFunctionAppARMResource.
func (s StaticSiteUserProvidedFunctionAppARMResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteUserProvidedFunctionAppARMResource.
func (s *StaticSiteUserProvidedFunctionAppARMResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteUserProvidedFunctionAppARMResourceProperties.
func (s StaticSiteUserProvidedFunctionAppARMResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdOn", s.CreatedOn)
	populate(objectMap, "functionAppRegion", s.FunctionAppRegion)
	populate(objectMap, "functionAppResourceId", s.FunctionAppResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteUserProvidedFunctionAppARMResourceProperties.
func (s *StaticSiteUserProvidedFunctionAppARMResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &s.CreatedOn)
			delete(rawMsg, key)
		case "functionAppRegion":
			err = unpopulate(val, "FunctionAppRegion", &s.FunctionAppRegion)
			delete(rawMsg, key)
		case "functionAppResourceId":
			err = unpopulate(val, "FunctionAppResourceID", &s.FunctionAppResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteUserProvidedFunctionAppProperties.
func (s StaticSiteUserProvidedFunctionAppProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdOn", s.CreatedOn)
	populate(objectMap, "functionAppRegion", s.FunctionAppRegion)
	populate(objectMap, "functionAppResourceId", s.FunctionAppResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteUserProvidedFunctionAppProperties.
func (s *StaticSiteUserProvidedFunctionAppProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &s.CreatedOn)
			delete(rawMsg, key)
		case "functionAppRegion":
			err = unpopulate(val, "FunctionAppRegion", &s.FunctionAppRegion)
			delete(rawMsg, key)
		case "functionAppResourceId":
			err = unpopulate(val, "FunctionAppResourceID", &s.FunctionAppResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteUserProvidedFunctionAppsCollection.
func (s StaticSiteUserProvidedFunctionAppsCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteUserProvidedFunctionAppsCollection.
func (s *StaticSiteUserProvidedFunctionAppsCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteZipDeployment.
func (s StaticSiteZipDeployment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiZipUrl", s.APIZipURL)
	populate(objectMap, "appZipUrl", s.AppZipURL)
	populate(objectMap, "deploymentTitle", s.DeploymentTitle)
	populate(objectMap, "functionLanguage", s.FunctionLanguage)
	populate(objectMap, "provider", s.Provider)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteZipDeployment.
func (s *StaticSiteZipDeployment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiZipUrl":
			err = unpopulate(val, "APIZipURL", &s.APIZipURL)
			delete(rawMsg, key)
		case "appZipUrl":
			err = unpopulate(val, "AppZipURL", &s.AppZipURL)
			delete(rawMsg, key)
		case "deploymentTitle":
			err = unpopulate(val, "DeploymentTitle", &s.DeploymentTitle)
			delete(rawMsg, key)
		case "functionLanguage":
			err = unpopulate(val, "FunctionLanguage", &s.FunctionLanguage)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &s.Provider)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSiteZipDeploymentARMResource.
func (s StaticSiteZipDeploymentARMResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSiteZipDeploymentARMResource.
func (s *StaticSiteZipDeploymentARMResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSitesWorkflowPreview.
func (s StaticSitesWorkflowPreview) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSitesWorkflowPreview.
func (s *StaticSitesWorkflowPreview) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSitesWorkflowPreviewProperties.
func (s StaticSitesWorkflowPreviewProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contents", s.Contents)
	populate(objectMap, "path", s.Path)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSitesWorkflowPreviewProperties.
func (s *StaticSitesWorkflowPreviewProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contents":
			err = unpopulate(val, "Contents", &s.Contents)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &s.Path)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSitesWorkflowPreviewRequest.
func (s StaticSitesWorkflowPreviewRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSitesWorkflowPreviewRequest.
func (s *StaticSitesWorkflowPreviewRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticSitesWorkflowPreviewRequestProperties.
func (s StaticSitesWorkflowPreviewRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "branch", s.Branch)
	populate(objectMap, "buildProperties", s.BuildProperties)
	populate(objectMap, "repositoryUrl", s.RepositoryURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSitesWorkflowPreviewRequestProperties.
func (s *StaticSitesWorkflowPreviewRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "branch":
			err = unpopulate(val, "Branch", &s.Branch)
			delete(rawMsg, key)
		case "buildProperties":
			err = unpopulate(val, "BuildProperties", &s.BuildProperties)
			delete(rawMsg, key)
		case "repositoryUrl":
			err = unpopulate(val, "RepositoryURL", &s.RepositoryURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Status.
func (s Status) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", s.Message)
	populate(objectMap, "statusId", s.StatusID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Status.
func (s *Status) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &s.Message)
			delete(rawMsg, key)
		case "statusId":
			err = unpopulate(val, "StatusID", &s.StatusID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StatusCodesBasedTrigger.
func (s StatusCodesBasedTrigger) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", s.Count)
	populate(objectMap, "path", s.Path)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "subStatus", s.SubStatus)
	populate(objectMap, "timeInterval", s.TimeInterval)
	populate(objectMap, "win32Status", s.Win32Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StatusCodesBasedTrigger.
func (s *StatusCodesBasedTrigger) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &s.Count)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &s.Path)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "subStatus":
			err = unpopulate(val, "SubStatus", &s.SubStatus)
			delete(rawMsg, key)
		case "timeInterval":
			err = unpopulate(val, "TimeInterval", &s.TimeInterval)
			delete(rawMsg, key)
		case "win32Status":
			err = unpopulate(val, "Win32Status", &s.Win32Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StatusCodesRangeBasedTrigger.
func (s StatusCodesRangeBasedTrigger) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", s.Count)
	populate(objectMap, "path", s.Path)
	populate(objectMap, "statusCodes", s.StatusCodes)
	populate(objectMap, "timeInterval", s.TimeInterval)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StatusCodesRangeBasedTrigger.
func (s *StatusCodesRangeBasedTrigger) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &s.Count)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &s.Path)
			delete(rawMsg, key)
		case "statusCodes":
			err = unpopulate(val, "StatusCodes", &s.StatusCodes)
			delete(rawMsg, key)
		case "timeInterval":
			err = unpopulate(val, "TimeInterval", &s.TimeInterval)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageMigrationOptions.
func (s StorageMigrationOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageMigrationOptions.
func (s *StorageMigrationOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageMigrationOptionsProperties.
func (s StorageMigrationOptionsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azurefilesConnectionString", s.AzurefilesConnectionString)
	populate(objectMap, "azurefilesShare", s.AzurefilesShare)
	populate(objectMap, "blockWriteAccessToSite", s.BlockWriteAccessToSite)
	populate(objectMap, "switchSiteAfterMigration", s.SwitchSiteAfterMigration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageMigrationOptionsProperties.
func (s *StorageMigrationOptionsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azurefilesConnectionString":
			err = unpopulate(val, "AzurefilesConnectionString", &s.AzurefilesConnectionString)
			delete(rawMsg, key)
		case "azurefilesShare":
			err = unpopulate(val, "AzurefilesShare", &s.AzurefilesShare)
			delete(rawMsg, key)
		case "blockWriteAccessToSite":
			err = unpopulate(val, "BlockWriteAccessToSite", &s.BlockWriteAccessToSite)
			delete(rawMsg, key)
		case "switchSiteAfterMigration":
			err = unpopulate(val, "SwitchSiteAfterMigration", &s.SwitchSiteAfterMigration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageMigrationResponse.
func (s StorageMigrationResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageMigrationResponse.
func (s *StorageMigrationResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageMigrationResponseProperties.
func (s StorageMigrationResponseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "operationId", s.OperationID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageMigrationResponseProperties.
func (s *StorageMigrationResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operationId":
			err = unpopulate(val, "OperationID", &s.OperationID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StringDictionary.
func (s StringDictionary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StringDictionary.
func (s *StringDictionary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StringList.
func (s StringList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StringList.
func (s *StringList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubResource.
func (s SubResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubResource.
func (s *SubResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SupportTopic.
func (s SupportTopic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "pesId", s.PesID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SupportTopic.
func (s *SupportTopic) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "pesId":
			err = unpopulate(val, "PesID", &s.PesID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SwiftVirtualNetwork.
func (s SwiftVirtualNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwiftVirtualNetwork.
func (s *SwiftVirtualNetwork) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SwiftVirtualNetworkProperties.
func (s SwiftVirtualNetworkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "subnetResourceId", s.SubnetResourceID)
	populate(objectMap, "swiftSupported", s.SwiftSupported)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwiftVirtualNetworkProperties.
func (s *SwiftVirtualNetworkProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "subnetResourceId":
			err = unpopulate(val, "SubnetResourceID", &s.SubnetResourceID)
			delete(rawMsg, key)
		case "swiftSupported":
			err = unpopulate(val, "SwiftSupported", &s.SwiftSupported)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Template.
func (t Template) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "containers", t.Containers)
	populate(objectMap, "dapr", t.Dapr)
	populate(objectMap, "revisionSuffix", t.RevisionSuffix)
	populate(objectMap, "scale", t.Scale)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Template.
func (t *Template) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containers":
			err = unpopulate(val, "Containers", &t.Containers)
			delete(rawMsg, key)
		case "dapr":
			err = unpopulate(val, "Dapr", &t.Dapr)
			delete(rawMsg, key)
		case "revisionSuffix":
			err = unpopulate(val, "RevisionSuffix", &t.RevisionSuffix)
			delete(rawMsg, key)
		case "scale":
			err = unpopulate(val, "Scale", &t.Scale)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TldLegalAgreement.
func (t TldLegalAgreement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agreementKey", t.AgreementKey)
	populate(objectMap, "content", t.Content)
	populate(objectMap, "title", t.Title)
	populate(objectMap, "url", t.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TldLegalAgreement.
func (t *TldLegalAgreement) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agreementKey":
			err = unpopulate(val, "AgreementKey", &t.AgreementKey)
			delete(rawMsg, key)
		case "content":
			err = unpopulate(val, "Content", &t.Content)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &t.Title)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &t.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TldLegalAgreementCollection.
func (t TldLegalAgreementCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", t.NextLink)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TldLegalAgreementCollection.
func (t *TldLegalAgreementCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &t.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TokenStore.
func (t TokenStore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureBlobStorage", t.AzureBlobStorage)
	populate(objectMap, "enabled", t.Enabled)
	populate(objectMap, "fileSystem", t.FileSystem)
	populate(objectMap, "tokenRefreshExtensionHours", t.TokenRefreshExtensionHours)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TokenStore.
func (t *TokenStore) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureBlobStorage":
			err = unpopulate(val, "AzureBlobStorage", &t.AzureBlobStorage)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &t.Enabled)
			delete(rawMsg, key)
		case "fileSystem":
			err = unpopulate(val, "FileSystem", &t.FileSystem)
			delete(rawMsg, key)
		case "tokenRefreshExtensionHours":
			err = unpopulate(val, "TokenRefreshExtensionHours", &t.TokenRefreshExtensionHours)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TopLevelDomain.
func (t TopLevelDomain) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "kind", t.Kind)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TopLevelDomain.
func (t *TopLevelDomain) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &t.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TopLevelDomainAgreementOption.
func (t TopLevelDomainAgreementOption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "forTransfer", t.ForTransfer)
	populate(objectMap, "includePrivacy", t.IncludePrivacy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TopLevelDomainAgreementOption.
func (t *TopLevelDomainAgreementOption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "forTransfer":
			err = unpopulate(val, "ForTransfer", &t.ForTransfer)
			delete(rawMsg, key)
		case "includePrivacy":
			err = unpopulate(val, "IncludePrivacy", &t.IncludePrivacy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TopLevelDomainCollection.
func (t TopLevelDomainCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", t.NextLink)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TopLevelDomainCollection.
func (t *TopLevelDomainCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &t.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TopLevelDomainProperties.
func (t TopLevelDomainProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privacy", t.Privacy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TopLevelDomainProperties.
func (t *TopLevelDomainProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privacy":
			err = unpopulate(val, "Privacy", &t.Privacy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrafficWeight.
func (t TrafficWeight) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "latestRevision", t.LatestRevision)
	populate(objectMap, "revisionName", t.RevisionName)
	populate(objectMap, "weight", t.Weight)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrafficWeight.
func (t *TrafficWeight) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "latestRevision":
			err = unpopulate(val, "LatestRevision", &t.LatestRevision)
			delete(rawMsg, key)
		case "revisionName":
			err = unpopulate(val, "RevisionName", &t.RevisionName)
			delete(rawMsg, key)
		case "weight":
			err = unpopulate(val, "Weight", &t.Weight)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TriggeredJobHistory.
func (t TriggeredJobHistory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "kind", t.Kind)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TriggeredJobHistory.
func (t *TriggeredJobHistory) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &t.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TriggeredJobHistoryCollection.
func (t TriggeredJobHistoryCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", t.NextLink)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TriggeredJobHistoryCollection.
func (t *TriggeredJobHistoryCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &t.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TriggeredJobHistoryProperties.
func (t TriggeredJobHistoryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "runs", t.Runs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TriggeredJobHistoryProperties.
func (t *TriggeredJobHistoryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "runs":
			err = unpopulate(val, "Runs", &t.Runs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TriggeredJobRun.
func (t TriggeredJobRun) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "duration", t.Duration)
	populateDateTimeRFC3339(objectMap, "end_time", t.EndTime)
	populate(objectMap, "error_url", t.ErrorURL)
	populate(objectMap, "job_name", t.JobName)
	populate(objectMap, "output_url", t.OutputURL)
	populateDateTimeRFC3339(objectMap, "start_time", t.StartTime)
	populate(objectMap, "status", t.Status)
	populate(objectMap, "trigger", t.Trigger)
	populate(objectMap, "url", t.URL)
	populate(objectMap, "web_job_id", t.WebJobID)
	populate(objectMap, "web_job_name", t.WebJobName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TriggeredJobRun.
func (t *TriggeredJobRun) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "duration":
			err = unpopulate(val, "Duration", &t.Duration)
			delete(rawMsg, key)
		case "end_time":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &t.EndTime)
			delete(rawMsg, key)
		case "error_url":
			err = unpopulate(val, "ErrorURL", &t.ErrorURL)
			delete(rawMsg, key)
		case "job_name":
			err = unpopulate(val, "JobName", &t.JobName)
			delete(rawMsg, key)
		case "output_url":
			err = unpopulate(val, "OutputURL", &t.OutputURL)
			delete(rawMsg, key)
		case "start_time":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &t.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &t.Status)
			delete(rawMsg, key)
		case "trigger":
			err = unpopulate(val, "Trigger", &t.Trigger)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &t.URL)
			delete(rawMsg, key)
		case "web_job_id":
			err = unpopulate(val, "WebJobID", &t.WebJobID)
			delete(rawMsg, key)
		case "web_job_name":
			err = unpopulate(val, "WebJobName", &t.WebJobName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TriggeredWebJob.
func (t TriggeredWebJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "kind", t.Kind)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TriggeredWebJob.
func (t *TriggeredWebJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &t.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TriggeredWebJobCollection.
func (t TriggeredWebJobCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", t.NextLink)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TriggeredWebJobCollection.
func (t *TriggeredWebJobCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &t.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TriggeredWebJobProperties.
func (t TriggeredWebJobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", t.Error)
	populate(objectMap, "extra_info_url", t.ExtraInfoURL)
	populate(objectMap, "history_url", t.HistoryURL)
	populate(objectMap, "latest_run", t.LatestRun)
	populate(objectMap, "publicNetworkAccess", t.PublicNetworkAccess)
	populate(objectMap, "run_command", t.RunCommand)
	populate(objectMap, "scheduler_logs_url", t.SchedulerLogsURL)
	populate(objectMap, "settings", t.Settings)
	populate(objectMap, "storageAccountRequired", t.StorageAccountRequired)
	populate(objectMap, "url", t.URL)
	populate(objectMap, "using_sdk", t.UsingSdk)
	populate(objectMap, "web_job_type", t.WebJobType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TriggeredWebJobProperties.
func (t *TriggeredWebJobProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &t.Error)
			delete(rawMsg, key)
		case "extra_info_url":
			err = unpopulate(val, "ExtraInfoURL", &t.ExtraInfoURL)
			delete(rawMsg, key)
		case "history_url":
			err = unpopulate(val, "HistoryURL", &t.HistoryURL)
			delete(rawMsg, key)
		case "latest_run":
			err = unpopulate(val, "LatestRun", &t.LatestRun)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &t.PublicNetworkAccess)
			delete(rawMsg, key)
		case "run_command":
			err = unpopulate(val, "RunCommand", &t.RunCommand)
			delete(rawMsg, key)
		case "scheduler_logs_url":
			err = unpopulate(val, "SchedulerLogsURL", &t.SchedulerLogsURL)
			delete(rawMsg, key)
		case "settings":
			err = unpopulate(val, "Settings", &t.Settings)
			delete(rawMsg, key)
		case "storageAccountRequired":
			err = unpopulate(val, "StorageAccountRequired", &t.StorageAccountRequired)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &t.URL)
			delete(rawMsg, key)
		case "using_sdk":
			err = unpopulate(val, "UsingSdk", &t.UsingSdk)
			delete(rawMsg, key)
		case "web_job_type":
			err = unpopulate(val, "WebJobType", &t.WebJobType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Twitter.
func (t Twitter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", t.Enabled)
	populate(objectMap, "registration", t.Registration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Twitter.
func (t *Twitter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &t.Enabled)
			delete(rawMsg, key)
		case "registration":
			err = unpopulate(val, "Registration", &t.Registration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TwitterRegistration.
func (t TwitterRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "consumerKey", t.ConsumerKey)
	populate(objectMap, "consumerSecretSettingName", t.ConsumerSecretSettingName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TwitterRegistration.
func (t *TwitterRegistration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consumerKey":
			err = unpopulate(val, "ConsumerKey", &t.ConsumerKey)
			delete(rawMsg, key)
		case "consumerSecretSettingName":
			err = unpopulate(val, "ConsumerSecretSettingName", &t.ConsumerSecretSettingName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Usage.
func (u Usage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", u.ID)
	populate(objectMap, "kind", u.Kind)
	populate(objectMap, "name", u.Name)
	populate(objectMap, "properties", u.Properties)
	populate(objectMap, "type", u.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Usage.
func (u *Usage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &u.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &u.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &u.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UsageCollection.
func (u UsageCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", u.NextLink)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UsageCollection.
func (u *UsageCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &u.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UsageProperties.
func (u UsageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "computeMode", u.ComputeMode)
	populate(objectMap, "currentValue", u.CurrentValue)
	populate(objectMap, "displayName", u.DisplayName)
	populate(objectMap, "limit", u.Limit)
	populateDateTimeRFC3339(objectMap, "nextResetTime", u.NextResetTime)
	populate(objectMap, "resourceName", u.ResourceName)
	populate(objectMap, "siteMode", u.SiteMode)
	populate(objectMap, "unit", u.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UsageProperties.
func (u *UsageProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeMode":
			err = unpopulate(val, "ComputeMode", &u.ComputeMode)
			delete(rawMsg, key)
		case "currentValue":
			err = unpopulate(val, "CurrentValue", &u.CurrentValue)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &u.DisplayName)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &u.Limit)
			delete(rawMsg, key)
		case "nextResetTime":
			err = unpopulateDateTimeRFC3339(val, "NextResetTime", &u.NextResetTime)
			delete(rawMsg, key)
		case "resourceName":
			err = unpopulate(val, "ResourceName", &u.ResourceName)
			delete(rawMsg, key)
		case "siteMode":
			err = unpopulate(val, "SiteMode", &u.SiteMode)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &u.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type User.
func (u User) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", u.ID)
	populate(objectMap, "kind", u.Kind)
	populate(objectMap, "name", u.Name)
	populate(objectMap, "properties", u.Properties)
	populate(objectMap, "type", u.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type User.
func (u *User) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &u.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &u.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &u.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserAssignedIdentity.
func (u UserAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", u.ClientID)
	populate(objectMap, "principalId", u.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserAssignedIdentity.
func (u *UserAssignedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &u.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &u.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserProperties.
func (u UserProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "publishingPassword", u.PublishingPassword)
	populate(objectMap, "publishingPasswordHash", u.PublishingPasswordHash)
	populate(objectMap, "publishingPasswordHashSalt", u.PublishingPasswordHashSalt)
	populate(objectMap, "publishingUserName", u.PublishingUserName)
	populate(objectMap, "scmUri", u.ScmURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserProperties.
func (u *UserProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "publishingPassword":
			err = unpopulate(val, "PublishingPassword", &u.PublishingPassword)
			delete(rawMsg, key)
		case "publishingPasswordHash":
			err = unpopulate(val, "PublishingPasswordHash", &u.PublishingPasswordHash)
			delete(rawMsg, key)
		case "publishingPasswordHashSalt":
			err = unpopulate(val, "PublishingPasswordHashSalt", &u.PublishingPasswordHashSalt)
			delete(rawMsg, key)
		case "publishingUserName":
			err = unpopulate(val, "PublishingUserName", &u.PublishingUserName)
			delete(rawMsg, key)
		case "scmUri":
			err = unpopulate(val, "ScmURI", &u.ScmURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateProperties.
func (v ValidateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appServiceEnvironment", v.AppServiceEnvironment)
	populate(objectMap, "capacity", v.Capacity)
	populate(objectMap, "containerImagePlatform", v.ContainerImagePlatform)
	populate(objectMap, "containerImageRepository", v.ContainerImageRepository)
	populate(objectMap, "containerImageTag", v.ContainerImageTag)
	populate(objectMap, "containerRegistryBaseUrl", v.ContainerRegistryBaseURL)
	populate(objectMap, "containerRegistryPassword", v.ContainerRegistryPassword)
	populate(objectMap, "containerRegistryUsername", v.ContainerRegistryUsername)
	populate(objectMap, "hostingEnvironment", v.HostingEnvironment)
	populate(objectMap, "isSpot", v.IsSpot)
	populate(objectMap, "isXenon", v.IsXenon)
	populate(objectMap, "needLinuxWorkers", v.NeedLinuxWorkers)
	populate(objectMap, "skuName", v.SKUName)
	populate(objectMap, "serverFarmId", v.ServerFarmID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateProperties.
func (v *ValidateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appServiceEnvironment":
			err = unpopulate(val, "AppServiceEnvironment", &v.AppServiceEnvironment)
			delete(rawMsg, key)
		case "capacity":
			err = unpopulate(val, "Capacity", &v.Capacity)
			delete(rawMsg, key)
		case "containerImagePlatform":
			err = unpopulate(val, "ContainerImagePlatform", &v.ContainerImagePlatform)
			delete(rawMsg, key)
		case "containerImageRepository":
			err = unpopulate(val, "ContainerImageRepository", &v.ContainerImageRepository)
			delete(rawMsg, key)
		case "containerImageTag":
			err = unpopulate(val, "ContainerImageTag", &v.ContainerImageTag)
			delete(rawMsg, key)
		case "containerRegistryBaseUrl":
			err = unpopulate(val, "ContainerRegistryBaseURL", &v.ContainerRegistryBaseURL)
			delete(rawMsg, key)
		case "containerRegistryPassword":
			err = unpopulate(val, "ContainerRegistryPassword", &v.ContainerRegistryPassword)
			delete(rawMsg, key)
		case "containerRegistryUsername":
			err = unpopulate(val, "ContainerRegistryUsername", &v.ContainerRegistryUsername)
			delete(rawMsg, key)
		case "hostingEnvironment":
			err = unpopulate(val, "HostingEnvironment", &v.HostingEnvironment)
			delete(rawMsg, key)
		case "isSpot":
			err = unpopulate(val, "IsSpot", &v.IsSpot)
			delete(rawMsg, key)
		case "isXenon":
			err = unpopulate(val, "IsXenon", &v.IsXenon)
			delete(rawMsg, key)
		case "needLinuxWorkers":
			err = unpopulate(val, "NeedLinuxWorkers", &v.NeedLinuxWorkers)
			delete(rawMsg, key)
		case "skuName":
			err = unpopulate(val, "SKUName", &v.SKUName)
			delete(rawMsg, key)
		case "serverFarmId":
			err = unpopulate(val, "ServerFarmID", &v.ServerFarmID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateRequest.
func (v ValidateRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateRequest.
func (v *ValidateRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateResponse.
func (v ValidateResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", v.Error)
	populate(objectMap, "status", v.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateResponse.
func (v *ValidateResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &v.Error)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &v.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateResponseError.
func (v ValidateResponseError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", v.Code)
	populate(objectMap, "message", v.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateResponseError.
func (v *ValidateResponseError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &v.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &v.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualApplication.
func (v VirtualApplication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "physicalPath", v.PhysicalPath)
	populate(objectMap, "preloadEnabled", v.PreloadEnabled)
	populate(objectMap, "virtualDirectories", v.VirtualDirectories)
	populate(objectMap, "virtualPath", v.VirtualPath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualApplication.
func (v *VirtualApplication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "physicalPath":
			err = unpopulate(val, "PhysicalPath", &v.PhysicalPath)
			delete(rawMsg, key)
		case "preloadEnabled":
			err = unpopulate(val, "PreloadEnabled", &v.PreloadEnabled)
			delete(rawMsg, key)
		case "virtualDirectories":
			err = unpopulate(val, "VirtualDirectories", &v.VirtualDirectories)
			delete(rawMsg, key)
		case "virtualPath":
			err = unpopulate(val, "VirtualPath", &v.VirtualPath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualDirectory.
func (v VirtualDirectory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "physicalPath", v.PhysicalPath)
	populate(objectMap, "virtualPath", v.VirtualPath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualDirectory.
func (v *VirtualDirectory) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "physicalPath":
			err = unpopulate(val, "PhysicalPath", &v.PhysicalPath)
			delete(rawMsg, key)
		case "virtualPath":
			err = unpopulate(val, "VirtualPath", &v.VirtualPath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualIPMapping.
func (v VirtualIPMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "inUse", v.InUse)
	populate(objectMap, "internalHttpPort", v.InternalHTTPPort)
	populate(objectMap, "internalHttpsPort", v.InternalHTTPSPort)
	populate(objectMap, "serviceName", v.ServiceName)
	populate(objectMap, "virtualIP", v.VirtualIP)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualIPMapping.
func (v *VirtualIPMapping) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inUse":
			err = unpopulate(val, "InUse", &v.InUse)
			delete(rawMsg, key)
		case "internalHttpPort":
			err = unpopulate(val, "InternalHTTPPort", &v.InternalHTTPPort)
			delete(rawMsg, key)
		case "internalHttpsPort":
			err = unpopulate(val, "InternalHTTPSPort", &v.InternalHTTPSPort)
			delete(rawMsg, key)
		case "serviceName":
			err = unpopulate(val, "ServiceName", &v.ServiceName)
			delete(rawMsg, key)
		case "virtualIP":
			err = unpopulate(val, "VirtualIP", &v.VirtualIP)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkProfile.
func (v VirtualNetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "subnet", v.Subnet)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkProfile.
func (v *VirtualNetworkProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &v.Subnet)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VnetGateway.
func (v VnetGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "kind", v.Kind)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VnetGateway.
func (v *VnetGateway) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &v.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VnetGatewayProperties.
func (v VnetGatewayProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "vpnPackageUri", v.VPNPackageURI)
	populate(objectMap, "vnetName", v.VnetName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VnetGatewayProperties.
func (v *VnetGatewayProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "vpnPackageUri":
			err = unpopulate(val, "VPNPackageURI", &v.VPNPackageURI)
			delete(rawMsg, key)
		case "vnetName":
			err = unpopulate(val, "VnetName", &v.VnetName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VnetInfo.
func (v VnetInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certBlob", v.CertBlob)
	populate(objectMap, "certThumbprint", v.CertThumbprint)
	populate(objectMap, "dnsServers", v.DNSServers)
	populate(objectMap, "isSwift", v.IsSwift)
	populate(objectMap, "resyncRequired", v.ResyncRequired)
	populate(objectMap, "routes", v.Routes)
	populate(objectMap, "vnetResourceId", v.VnetResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VnetInfo.
func (v *VnetInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certBlob":
			err = unpopulate(val, "CertBlob", &v.CertBlob)
			delete(rawMsg, key)
		case "certThumbprint":
			err = unpopulate(val, "CertThumbprint", &v.CertThumbprint)
			delete(rawMsg, key)
		case "dnsServers":
			err = unpopulate(val, "DNSServers", &v.DNSServers)
			delete(rawMsg, key)
		case "isSwift":
			err = unpopulate(val, "IsSwift", &v.IsSwift)
			delete(rawMsg, key)
		case "resyncRequired":
			err = unpopulate(val, "ResyncRequired", &v.ResyncRequired)
			delete(rawMsg, key)
		case "routes":
			err = unpopulate(val, "Routes", &v.Routes)
			delete(rawMsg, key)
		case "vnetResourceId":
			err = unpopulate(val, "VnetResourceID", &v.VnetResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VnetInfoResource.
func (v VnetInfoResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "kind", v.Kind)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VnetInfoResource.
func (v *VnetInfoResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &v.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VnetParameters.
func (v VnetParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "kind", v.Kind)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VnetParameters.
func (v *VnetParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &v.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VnetParametersProperties.
func (v VnetParametersProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "subnetResourceId", v.SubnetResourceID)
	populate(objectMap, "vnetName", v.VnetName)
	populate(objectMap, "vnetResourceGroup", v.VnetResourceGroup)
	populate(objectMap, "vnetSubnetName", v.VnetSubnetName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VnetParametersProperties.
func (v *VnetParametersProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "subnetResourceId":
			err = unpopulate(val, "SubnetResourceID", &v.SubnetResourceID)
			delete(rawMsg, key)
		case "vnetName":
			err = unpopulate(val, "VnetName", &v.VnetName)
			delete(rawMsg, key)
		case "vnetResourceGroup":
			err = unpopulate(val, "VnetResourceGroup", &v.VnetResourceGroup)
			delete(rawMsg, key)
		case "vnetSubnetName":
			err = unpopulate(val, "VnetSubnetName", &v.VnetSubnetName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VnetRoute.
func (v VnetRoute) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "kind", v.Kind)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VnetRoute.
func (v *VnetRoute) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &v.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VnetRouteProperties.
func (v VnetRouteProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endAddress", v.EndAddress)
	populate(objectMap, "routeType", v.RouteType)
	populate(objectMap, "startAddress", v.StartAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VnetRouteProperties.
func (v *VnetRouteProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endAddress":
			err = unpopulate(val, "EndAddress", &v.EndAddress)
			delete(rawMsg, key)
		case "routeType":
			err = unpopulate(val, "RouteType", &v.RouteType)
			delete(rawMsg, key)
		case "startAddress":
			err = unpopulate(val, "StartAddress", &v.StartAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VnetValidationFailureDetails.
func (v VnetValidationFailureDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "kind", v.Kind)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VnetValidationFailureDetails.
func (v *VnetValidationFailureDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &v.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VnetValidationFailureDetailsProperties.
func (v VnetValidationFailureDetailsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "failed", v.Failed)
	populate(objectMap, "failedTests", v.FailedTests)
	populate(objectMap, "message", v.Message)
	populate(objectMap, "warnings", v.Warnings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VnetValidationFailureDetailsProperties.
func (v *VnetValidationFailureDetailsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failed":
			err = unpopulate(val, "Failed", &v.Failed)
			delete(rawMsg, key)
		case "failedTests":
			err = unpopulate(val, "FailedTests", &v.FailedTests)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &v.Message)
			delete(rawMsg, key)
		case "warnings":
			err = unpopulate(val, "Warnings", &v.Warnings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VnetValidationTestFailure.
func (v VnetValidationTestFailure) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "kind", v.Kind)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VnetValidationTestFailure.
func (v *VnetValidationTestFailure) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &v.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VnetValidationTestFailureProperties.
func (v VnetValidationTestFailureProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "details", v.Details)
	populate(objectMap, "testName", v.TestName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VnetValidationTestFailureProperties.
func (v *VnetValidationTestFailureProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "details":
			err = unpopulate(val, "Details", &v.Details)
			delete(rawMsg, key)
		case "testName":
			err = unpopulate(val, "TestName", &v.TestName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebAppCollection.
func (w WebAppCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebAppCollection.
func (w *WebAppCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebAppInstanceStatusCollection.
func (w WebAppInstanceStatusCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebAppInstanceStatusCollection.
func (w *WebAppInstanceStatusCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebAppMajorVersion.
func (w WebAppMajorVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayText", w.DisplayText)
	populate(objectMap, "minorVersions", w.MinorVersions)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebAppMajorVersion.
func (w *WebAppMajorVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayText":
			err = unpopulate(val, "DisplayText", &w.DisplayText)
			delete(rawMsg, key)
		case "minorVersions":
			err = unpopulate(val, "MinorVersions", &w.MinorVersions)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebAppMinorVersion.
func (w WebAppMinorVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayText", w.DisplayText)
	populate(objectMap, "stackSettings", w.StackSettings)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebAppMinorVersion.
func (w *WebAppMinorVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayText":
			err = unpopulate(val, "DisplayText", &w.DisplayText)
			delete(rawMsg, key)
		case "stackSettings":
			err = unpopulate(val, "StackSettings", &w.StackSettings)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebAppRuntimeSettings.
func (w WebAppRuntimeSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appInsightsSettings", w.AppInsightsSettings)
	populateDateTimeRFC3339(objectMap, "endOfLifeDate", w.EndOfLifeDate)
	populate(objectMap, "gitHubActionSettings", w.GitHubActionSettings)
	populate(objectMap, "isAutoUpdate", w.IsAutoUpdate)
	populate(objectMap, "isDeprecated", w.IsDeprecated)
	populate(objectMap, "isEarlyAccess", w.IsEarlyAccess)
	populate(objectMap, "isHidden", w.IsHidden)
	populate(objectMap, "isPreview", w.IsPreview)
	populate(objectMap, "remoteDebuggingSupported", w.RemoteDebuggingSupported)
	populate(objectMap, "runtimeVersion", w.RuntimeVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebAppRuntimeSettings.
func (w *WebAppRuntimeSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appInsightsSettings":
			err = unpopulate(val, "AppInsightsSettings", &w.AppInsightsSettings)
			delete(rawMsg, key)
		case "endOfLifeDate":
			err = unpopulateDateTimeRFC3339(val, "EndOfLifeDate", &w.EndOfLifeDate)
			delete(rawMsg, key)
		case "gitHubActionSettings":
			err = unpopulate(val, "GitHubActionSettings", &w.GitHubActionSettings)
			delete(rawMsg, key)
		case "isAutoUpdate":
			err = unpopulate(val, "IsAutoUpdate", &w.IsAutoUpdate)
			delete(rawMsg, key)
		case "isDeprecated":
			err = unpopulate(val, "IsDeprecated", &w.IsDeprecated)
			delete(rawMsg, key)
		case "isEarlyAccess":
			err = unpopulate(val, "IsEarlyAccess", &w.IsEarlyAccess)
			delete(rawMsg, key)
		case "isHidden":
			err = unpopulate(val, "IsHidden", &w.IsHidden)
			delete(rawMsg, key)
		case "isPreview":
			err = unpopulate(val, "IsPreview", &w.IsPreview)
			delete(rawMsg, key)
		case "remoteDebuggingSupported":
			err = unpopulate(val, "RemoteDebuggingSupported", &w.RemoteDebuggingSupported)
			delete(rawMsg, key)
		case "runtimeVersion":
			err = unpopulate(val, "RuntimeVersion", &w.RuntimeVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebAppRuntimes.
func (w WebAppRuntimes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "linuxContainerSettings", w.LinuxContainerSettings)
	populate(objectMap, "linuxRuntimeSettings", w.LinuxRuntimeSettings)
	populate(objectMap, "windowsContainerSettings", w.WindowsContainerSettings)
	populate(objectMap, "windowsRuntimeSettings", w.WindowsRuntimeSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebAppRuntimes.
func (w *WebAppRuntimes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "linuxContainerSettings":
			err = unpopulate(val, "LinuxContainerSettings", &w.LinuxContainerSettings)
			delete(rawMsg, key)
		case "linuxRuntimeSettings":
			err = unpopulate(val, "LinuxRuntimeSettings", &w.LinuxRuntimeSettings)
			delete(rawMsg, key)
		case "windowsContainerSettings":
			err = unpopulate(val, "WindowsContainerSettings", &w.WindowsContainerSettings)
			delete(rawMsg, key)
		case "windowsRuntimeSettings":
			err = unpopulate(val, "WindowsRuntimeSettings", &w.WindowsRuntimeSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebAppStack.
func (w WebAppStack) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "kind", w.Kind)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebAppStack.
func (w *WebAppStack) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &w.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &w.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebAppStackCollection.
func (w WebAppStackCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebAppStackCollection.
func (w *WebAppStackCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebAppStackProperties.
func (w WebAppStackProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayText", w.DisplayText)
	populate(objectMap, "majorVersions", w.MajorVersions)
	populate(objectMap, "preferredOs", w.PreferredOs)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebAppStackProperties.
func (w *WebAppStackProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayText":
			err = unpopulate(val, "DisplayText", &w.DisplayText)
			delete(rawMsg, key)
		case "majorVersions":
			err = unpopulate(val, "MajorVersions", &w.MajorVersions)
			delete(rawMsg, key)
		case "preferredOs":
			err = unpopulate(val, "PreferredOs", &w.PreferredOs)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebJob.
func (w WebJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "kind", w.Kind)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebJob.
func (w *WebJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &w.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebJobCollection.
func (w WebJobCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebJobCollection.
func (w *WebJobCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebJobProperties.
func (w WebJobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", w.Error)
	populate(objectMap, "extra_info_url", w.ExtraInfoURL)
	populate(objectMap, "run_command", w.RunCommand)
	populate(objectMap, "settings", w.Settings)
	populate(objectMap, "url", w.URL)
	populate(objectMap, "using_sdk", w.UsingSdk)
	populate(objectMap, "web_job_type", w.WebJobType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebJobProperties.
func (w *WebJobProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &w.Error)
			delete(rawMsg, key)
		case "extra_info_url":
			err = unpopulate(val, "ExtraInfoURL", &w.ExtraInfoURL)
			delete(rawMsg, key)
		case "run_command":
			err = unpopulate(val, "RunCommand", &w.RunCommand)
			delete(rawMsg, key)
		case "settings":
			err = unpopulate(val, "Settings", &w.Settings)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &w.URL)
			delete(rawMsg, key)
		case "using_sdk":
			err = unpopulate(val, "UsingSdk", &w.UsingSdk)
			delete(rawMsg, key)
		case "web_job_type":
			err = unpopulate(val, "WebJobType", &w.WebJobType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebSiteInstanceStatus.
func (w WebSiteInstanceStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "kind", w.Kind)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebSiteInstanceStatus.
func (w *WebSiteInstanceStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &w.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebSiteInstanceStatusProperties.
func (w WebSiteInstanceStatusProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "consoleUrl", w.ConsoleURL)
	populate(objectMap, "containers", w.Containers)
	populate(objectMap, "detectorUrl", w.DetectorURL)
	populate(objectMap, "healthCheckUrl", w.HealthCheckURL)
	populate(objectMap, "state", w.State)
	populate(objectMap, "statusUrl", w.StatusURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebSiteInstanceStatusProperties.
func (w *WebSiteInstanceStatusProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consoleUrl":
			err = unpopulate(val, "ConsoleURL", &w.ConsoleURL)
			delete(rawMsg, key)
		case "containers":
			err = unpopulate(val, "Containers", &w.Containers)
			delete(rawMsg, key)
		case "detectorUrl":
			err = unpopulate(val, "DetectorURL", &w.DetectorURL)
			delete(rawMsg, key)
		case "healthCheckUrl":
			err = unpopulate(val, "HealthCheckURL", &w.HealthCheckURL)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &w.State)
			delete(rawMsg, key)
		case "statusUrl":
			err = unpopulate(val, "StatusURL", &w.StatusURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WindowsJavaContainerSettings.
func (w WindowsJavaContainerSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "endOfLifeDate", w.EndOfLifeDate)
	populate(objectMap, "isAutoUpdate", w.IsAutoUpdate)
	populate(objectMap, "isDeprecated", w.IsDeprecated)
	populate(objectMap, "isEarlyAccess", w.IsEarlyAccess)
	populate(objectMap, "isHidden", w.IsHidden)
	populate(objectMap, "isPreview", w.IsPreview)
	populate(objectMap, "javaContainer", w.JavaContainer)
	populate(objectMap, "javaContainerVersion", w.JavaContainerVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WindowsJavaContainerSettings.
func (w *WindowsJavaContainerSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endOfLifeDate":
			err = unpopulateDateTimeRFC3339(val, "EndOfLifeDate", &w.EndOfLifeDate)
			delete(rawMsg, key)
		case "isAutoUpdate":
			err = unpopulate(val, "IsAutoUpdate", &w.IsAutoUpdate)
			delete(rawMsg, key)
		case "isDeprecated":
			err = unpopulate(val, "IsDeprecated", &w.IsDeprecated)
			delete(rawMsg, key)
		case "isEarlyAccess":
			err = unpopulate(val, "IsEarlyAccess", &w.IsEarlyAccess)
			delete(rawMsg, key)
		case "isHidden":
			err = unpopulate(val, "IsHidden", &w.IsHidden)
			delete(rawMsg, key)
		case "isPreview":
			err = unpopulate(val, "IsPreview", &w.IsPreview)
			delete(rawMsg, key)
		case "javaContainer":
			err = unpopulate(val, "JavaContainer", &w.JavaContainer)
			delete(rawMsg, key)
		case "javaContainerVersion":
			err = unpopulate(val, "JavaContainerVersion", &w.JavaContainerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkerPool.
func (w WorkerPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "computeMode", w.ComputeMode)
	populate(objectMap, "instanceNames", w.InstanceNames)
	populate(objectMap, "workerCount", w.WorkerCount)
	populate(objectMap, "workerSize", w.WorkerSize)
	populate(objectMap, "workerSizeId", w.WorkerSizeID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkerPool.
func (w *WorkerPool) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeMode":
			err = unpopulate(val, "ComputeMode", &w.ComputeMode)
			delete(rawMsg, key)
		case "instanceNames":
			err = unpopulate(val, "InstanceNames", &w.InstanceNames)
			delete(rawMsg, key)
		case "workerCount":
			err = unpopulate(val, "WorkerCount", &w.WorkerCount)
			delete(rawMsg, key)
		case "workerSize":
			err = unpopulate(val, "WorkerSize", &w.WorkerSize)
			delete(rawMsg, key)
		case "workerSizeId":
			err = unpopulate(val, "WorkerSizeID", &w.WorkerSizeID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkerPoolCollection.
func (w WorkerPoolCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkerPoolCollection.
func (w *WorkerPoolCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkerPoolResource.
func (w WorkerPoolResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "kind", w.Kind)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "sku", w.SKU)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkerPoolResource.
func (w *WorkerPoolResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &w.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &w.SKU)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Workflow.
func (w Workflow) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "identity", w.Identity)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Workflow.
func (w *Workflow) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &w.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &w.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &w.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowArtifacts.
func (w WorkflowArtifacts) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "appSettings", w.AppSettings)
	populate(objectMap, "files", w.Files)
	populate(objectMap, "filesToDelete", w.FilesToDelete)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowArtifacts.
func (w *WorkflowArtifacts) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appSettings":
			err = unpopulate(val, "AppSettings", &w.AppSettings)
			delete(rawMsg, key)
		case "files":
			err = unpopulate(val, "Files", &w.Files)
			delete(rawMsg, key)
		case "filesToDelete":
			err = unpopulate(val, "FilesToDelete", &w.FilesToDelete)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowEnvelope.
func (w WorkflowEnvelope) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "kind", w.Kind)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowEnvelope.
func (w *WorkflowEnvelope) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &w.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &w.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowEnvelopeCollection.
func (w WorkflowEnvelopeCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowEnvelopeCollection.
func (w *WorkflowEnvelopeCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowEnvelopeProperties.
func (w WorkflowEnvelopeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "files", w.Files)
	populate(objectMap, "flowState", w.FlowState)
	populate(objectMap, "health", w.Health)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowEnvelopeProperties.
func (w *WorkflowEnvelopeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "files":
			err = unpopulate(val, "Files", &w.Files)
			delete(rawMsg, key)
		case "flowState":
			err = unpopulate(val, "FlowState", &w.FlowState)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &w.Health)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowFilter.
func (w WorkflowFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "state", w.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowFilter.
func (w *WorkflowFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "state":
			err = unpopulate(val, "State", &w.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowHealth.
func (w WorkflowHealth) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", w.Error)
	populate(objectMap, "state", w.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowHealth.
func (w *WorkflowHealth) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &w.Error)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &w.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowListResult.
func (w WorkflowListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowListResult.
func (w *WorkflowListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowOutputParameter.
func (w WorkflowOutputParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", w.Description)
	populateAny(objectMap, "error", w.Error)
	populateAny(objectMap, "metadata", w.Metadata)
	populate(objectMap, "type", w.Type)
	populateAny(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowOutputParameter.
func (w *WorkflowOutputParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &w.Description)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &w.Error)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &w.Metadata)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowParameter.
func (w WorkflowParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", w.Description)
	populateAny(objectMap, "metadata", w.Metadata)
	populate(objectMap, "type", w.Type)
	populateAny(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowParameter.
func (w *WorkflowParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &w.Description)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &w.Metadata)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowProperties.
func (w WorkflowProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessControl", w.AccessControl)
	populate(objectMap, "accessEndpoint", w.AccessEndpoint)
	populateDateTimeRFC3339(objectMap, "changedTime", w.ChangedTime)
	populateDateTimeRFC3339(objectMap, "createdTime", w.CreatedTime)
	populateAny(objectMap, "definition", w.Definition)
	populate(objectMap, "endpointsConfiguration", w.EndpointsConfiguration)
	populate(objectMap, "integrationAccount", w.IntegrationAccount)
	populate(objectMap, "integrationServiceEnvironment", w.IntegrationServiceEnvironment)
	populate(objectMap, "kind", w.Kind)
	populate(objectMap, "parameters", w.Parameters)
	populate(objectMap, "provisioningState", w.ProvisioningState)
	populate(objectMap, "sku", w.SKU)
	populate(objectMap, "state", w.State)
	populate(objectMap, "version", w.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowProperties.
func (w *WorkflowProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessControl":
			err = unpopulate(val, "AccessControl", &w.AccessControl)
			delete(rawMsg, key)
		case "accessEndpoint":
			err = unpopulate(val, "AccessEndpoint", &w.AccessEndpoint)
			delete(rawMsg, key)
		case "changedTime":
			err = unpopulateDateTimeRFC3339(val, "ChangedTime", &w.ChangedTime)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedTime", &w.CreatedTime)
			delete(rawMsg, key)
		case "definition":
			err = unpopulate(val, "Definition", &w.Definition)
			delete(rawMsg, key)
		case "endpointsConfiguration":
			err = unpopulate(val, "EndpointsConfiguration", &w.EndpointsConfiguration)
			delete(rawMsg, key)
		case "integrationAccount":
			err = unpopulate(val, "IntegrationAccount", &w.IntegrationAccount)
			delete(rawMsg, key)
		case "integrationServiceEnvironment":
			err = unpopulate(val, "IntegrationServiceEnvironment", &w.IntegrationServiceEnvironment)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &w.Kind)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &w.Parameters)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &w.ProvisioningState)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &w.SKU)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &w.State)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &w.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowResource.
func (w WorkflowResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowResource.
func (w *WorkflowResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &w.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &w.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowRun.
func (w WorkflowRun) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRun.
func (w *WorkflowRun) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowRunAction.
func (w WorkflowRunAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRunAction.
func (w *WorkflowRunAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowRunActionFilter.
func (w WorkflowRunActionFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "status", w.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRunActionFilter.
func (w *WorkflowRunActionFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "status":
			err = unpopulate(val, "Status", &w.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowRunActionListResult.
func (w WorkflowRunActionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRunActionListResult.
func (w *WorkflowRunActionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowRunActionProperties.
func (w WorkflowRunActionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", w.Code)
	populate(objectMap, "correlation", w.Correlation)
	populateDateTimeRFC3339(objectMap, "endTime", w.EndTime)
	populateAny(objectMap, "error", w.Error)
	populate(objectMap, "inputsLink", w.InputsLink)
	populate(objectMap, "outputsLink", w.OutputsLink)
	populate(objectMap, "retryHistory", w.RetryHistory)
	populateDateTimeRFC3339(objectMap, "startTime", w.StartTime)
	populate(objectMap, "status", w.Status)
	populateAny(objectMap, "trackedProperties", w.TrackedProperties)
	populate(objectMap, "trackingId", w.TrackingID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRunActionProperties.
func (w *WorkflowRunActionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &w.Code)
			delete(rawMsg, key)
		case "correlation":
			err = unpopulate(val, "Correlation", &w.Correlation)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &w.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &w.Error)
			delete(rawMsg, key)
		case "inputsLink":
			err = unpopulate(val, "InputsLink", &w.InputsLink)
			delete(rawMsg, key)
		case "outputsLink":
			err = unpopulate(val, "OutputsLink", &w.OutputsLink)
			delete(rawMsg, key)
		case "retryHistory":
			err = unpopulate(val, "RetryHistory", &w.RetryHistory)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &w.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &w.Status)
			delete(rawMsg, key)
		case "trackedProperties":
			err = unpopulate(val, "TrackedProperties", &w.TrackedProperties)
			delete(rawMsg, key)
		case "trackingId":
			err = unpopulate(val, "TrackingID", &w.TrackingID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowRunActionRepetitionDefinition.
func (w WorkflowRunActionRepetitionDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRunActionRepetitionDefinition.
func (w *WorkflowRunActionRepetitionDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &w.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &w.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowRunActionRepetitionDefinitionCollection.
func (w WorkflowRunActionRepetitionDefinitionCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRunActionRepetitionDefinitionCollection.
func (w *WorkflowRunActionRepetitionDefinitionCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowRunActionRepetitionProperties.
func (w WorkflowRunActionRepetitionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", w.Code)
	populate(objectMap, "correlation", w.Correlation)
	populateDateTimeRFC3339(objectMap, "endTime", w.EndTime)
	populateAny(objectMap, "error", w.Error)
	populateAny(objectMap, "inputs", w.Inputs)
	populate(objectMap, "inputsLink", w.InputsLink)
	populate(objectMap, "iterationCount", w.IterationCount)
	populateAny(objectMap, "outputs", w.Outputs)
	populate(objectMap, "outputsLink", w.OutputsLink)
	populate(objectMap, "repetitionIndexes", w.RepetitionIndexes)
	populate(objectMap, "retryHistory", w.RetryHistory)
	populateDateTimeRFC3339(objectMap, "startTime", w.StartTime)
	populate(objectMap, "status", w.Status)
	populateAny(objectMap, "trackedProperties", w.TrackedProperties)
	populate(objectMap, "trackingId", w.TrackingID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRunActionRepetitionProperties.
func (w *WorkflowRunActionRepetitionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &w.Code)
			delete(rawMsg, key)
		case "correlation":
			err = unpopulate(val, "Correlation", &w.Correlation)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &w.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &w.Error)
			delete(rawMsg, key)
		case "inputs":
			err = unpopulate(val, "Inputs", &w.Inputs)
			delete(rawMsg, key)
		case "inputsLink":
			err = unpopulate(val, "InputsLink", &w.InputsLink)
			delete(rawMsg, key)
		case "iterationCount":
			err = unpopulate(val, "IterationCount", &w.IterationCount)
			delete(rawMsg, key)
		case "outputs":
			err = unpopulate(val, "Outputs", &w.Outputs)
			delete(rawMsg, key)
		case "outputsLink":
			err = unpopulate(val, "OutputsLink", &w.OutputsLink)
			delete(rawMsg, key)
		case "repetitionIndexes":
			err = unpopulate(val, "RepetitionIndexes", &w.RepetitionIndexes)
			delete(rawMsg, key)
		case "retryHistory":
			err = unpopulate(val, "RetryHistory", &w.RetryHistory)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &w.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &w.Status)
			delete(rawMsg, key)
		case "trackedProperties":
			err = unpopulate(val, "TrackedProperties", &w.TrackedProperties)
			delete(rawMsg, key)
		case "trackingId":
			err = unpopulate(val, "TrackingID", &w.TrackingID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowRunFilter.
func (w WorkflowRunFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "status", w.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRunFilter.
func (w *WorkflowRunFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "status":
			err = unpopulate(val, "Status", &w.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowRunListResult.
func (w WorkflowRunListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRunListResult.
func (w *WorkflowRunListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowRunProperties.
func (w WorkflowRunProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", w.Code)
	populate(objectMap, "correlation", w.Correlation)
	populate(objectMap, "correlationId", w.CorrelationID)
	populateDateTimeRFC3339(objectMap, "endTime", w.EndTime)
	populateAny(objectMap, "error", w.Error)
	populate(objectMap, "outputs", w.Outputs)
	populate(objectMap, "response", w.Response)
	populateDateTimeRFC3339(objectMap, "startTime", w.StartTime)
	populate(objectMap, "status", w.Status)
	populate(objectMap, "trigger", w.Trigger)
	populateDateTimeRFC3339(objectMap, "waitEndTime", w.WaitEndTime)
	populate(objectMap, "workflow", w.Workflow)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRunProperties.
func (w *WorkflowRunProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &w.Code)
			delete(rawMsg, key)
		case "correlation":
			err = unpopulate(val, "Correlation", &w.Correlation)
			delete(rawMsg, key)
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &w.CorrelationID)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &w.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &w.Error)
			delete(rawMsg, key)
		case "outputs":
			err = unpopulate(val, "Outputs", &w.Outputs)
			delete(rawMsg, key)
		case "response":
			err = unpopulate(val, "Response", &w.Response)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &w.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &w.Status)
			delete(rawMsg, key)
		case "trigger":
			err = unpopulate(val, "Trigger", &w.Trigger)
			delete(rawMsg, key)
		case "waitEndTime":
			err = unpopulateDateTimeRFC3339(val, "WaitEndTime", &w.WaitEndTime)
			delete(rawMsg, key)
		case "workflow":
			err = unpopulate(val, "Workflow", &w.Workflow)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowRunTrigger.
func (w WorkflowRunTrigger) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", w.Code)
	populate(objectMap, "correlation", w.Correlation)
	populateDateTimeRFC3339(objectMap, "endTime", w.EndTime)
	populateAny(objectMap, "error", w.Error)
	populateAny(objectMap, "inputs", w.Inputs)
	populate(objectMap, "inputsLink", w.InputsLink)
	populate(objectMap, "name", w.Name)
	populateAny(objectMap, "outputs", w.Outputs)
	populate(objectMap, "outputsLink", w.OutputsLink)
	populateDateTimeRFC3339(objectMap, "scheduledTime", w.ScheduledTime)
	populateDateTimeRFC3339(objectMap, "startTime", w.StartTime)
	populate(objectMap, "status", w.Status)
	populateAny(objectMap, "trackedProperties", w.TrackedProperties)
	populate(objectMap, "trackingId", w.TrackingID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRunTrigger.
func (w *WorkflowRunTrigger) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &w.Code)
			delete(rawMsg, key)
		case "correlation":
			err = unpopulate(val, "Correlation", &w.Correlation)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &w.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &w.Error)
			delete(rawMsg, key)
		case "inputs":
			err = unpopulate(val, "Inputs", &w.Inputs)
			delete(rawMsg, key)
		case "inputsLink":
			err = unpopulate(val, "InputsLink", &w.InputsLink)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "outputs":
			err = unpopulate(val, "Outputs", &w.Outputs)
			delete(rawMsg, key)
		case "outputsLink":
			err = unpopulate(val, "OutputsLink", &w.OutputsLink)
			delete(rawMsg, key)
		case "scheduledTime":
			err = unpopulateDateTimeRFC3339(val, "ScheduledTime", &w.ScheduledTime)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &w.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &w.Status)
			delete(rawMsg, key)
		case "trackedProperties":
			err = unpopulate(val, "TrackedProperties", &w.TrackedProperties)
			delete(rawMsg, key)
		case "trackingId":
			err = unpopulate(val, "TrackingID", &w.TrackingID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowSKU.
func (w WorkflowSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "plan", w.Plan)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowSKU.
func (w *WorkflowSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "plan":
			err = unpopulate(val, "Plan", &w.Plan)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowTrigger.
func (w WorkflowTrigger) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowTrigger.
func (w *WorkflowTrigger) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowTriggerCallbackURL.
func (w WorkflowTriggerCallbackURL) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "basePath", w.BasePath)
	populate(objectMap, "method", w.Method)
	populate(objectMap, "queries", w.Queries)
	populate(objectMap, "relativePath", w.RelativePath)
	populate(objectMap, "relativePathParameters", w.RelativePathParameters)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowTriggerCallbackURL.
func (w *WorkflowTriggerCallbackURL) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "basePath":
			err = unpopulate(val, "BasePath", &w.BasePath)
			delete(rawMsg, key)
		case "method":
			err = unpopulate(val, "Method", &w.Method)
			delete(rawMsg, key)
		case "queries":
			err = unpopulate(val, "Queries", &w.Queries)
			delete(rawMsg, key)
		case "relativePath":
			err = unpopulate(val, "RelativePath", &w.RelativePath)
			delete(rawMsg, key)
		case "relativePathParameters":
			err = unpopulate(val, "RelativePathParameters", &w.RelativePathParameters)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowTriggerFilter.
func (w WorkflowTriggerFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "state", w.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowTriggerFilter.
func (w *WorkflowTriggerFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "state":
			err = unpopulate(val, "State", &w.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowTriggerHistory.
func (w WorkflowTriggerHistory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowTriggerHistory.
func (w *WorkflowTriggerHistory) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowTriggerHistoryFilter.
func (w WorkflowTriggerHistoryFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "status", w.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowTriggerHistoryFilter.
func (w *WorkflowTriggerHistoryFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "status":
			err = unpopulate(val, "Status", &w.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowTriggerHistoryListResult.
func (w WorkflowTriggerHistoryListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowTriggerHistoryListResult.
func (w *WorkflowTriggerHistoryListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowTriggerHistoryProperties.
func (w WorkflowTriggerHistoryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", w.Code)
	populate(objectMap, "correlation", w.Correlation)
	populateDateTimeRFC3339(objectMap, "endTime", w.EndTime)
	populateAny(objectMap, "error", w.Error)
	populate(objectMap, "fired", w.Fired)
	populate(objectMap, "inputsLink", w.InputsLink)
	populate(objectMap, "outputsLink", w.OutputsLink)
	populate(objectMap, "run", w.Run)
	populateDateTimeRFC3339(objectMap, "scheduledTime", w.ScheduledTime)
	populateDateTimeRFC3339(objectMap, "startTime", w.StartTime)
	populate(objectMap, "status", w.Status)
	populate(objectMap, "trackingId", w.TrackingID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowTriggerHistoryProperties.
func (w *WorkflowTriggerHistoryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &w.Code)
			delete(rawMsg, key)
		case "correlation":
			err = unpopulate(val, "Correlation", &w.Correlation)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &w.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &w.Error)
			delete(rawMsg, key)
		case "fired":
			err = unpopulate(val, "Fired", &w.Fired)
			delete(rawMsg, key)
		case "inputsLink":
			err = unpopulate(val, "InputsLink", &w.InputsLink)
			delete(rawMsg, key)
		case "outputsLink":
			err = unpopulate(val, "OutputsLink", &w.OutputsLink)
			delete(rawMsg, key)
		case "run":
			err = unpopulate(val, "Run", &w.Run)
			delete(rawMsg, key)
		case "scheduledTime":
			err = unpopulateDateTimeRFC3339(val, "ScheduledTime", &w.ScheduledTime)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &w.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &w.Status)
			delete(rawMsg, key)
		case "trackingId":
			err = unpopulate(val, "TrackingID", &w.TrackingID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowTriggerListCallbackURLQueries.
func (w WorkflowTriggerListCallbackURLQueries) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "api-version", w.APIVersion)
	populate(objectMap, "se", w.Se)
	populate(objectMap, "sig", w.Sig)
	populate(objectMap, "sp", w.Sp)
	populate(objectMap, "sv", w.Sv)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowTriggerListCallbackURLQueries.
func (w *WorkflowTriggerListCallbackURLQueries) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "api-version":
			err = unpopulate(val, "APIVersion", &w.APIVersion)
			delete(rawMsg, key)
		case "se":
			err = unpopulate(val, "Se", &w.Se)
			delete(rawMsg, key)
		case "sig":
			err = unpopulate(val, "Sig", &w.Sig)
			delete(rawMsg, key)
		case "sp":
			err = unpopulate(val, "Sp", &w.Sp)
			delete(rawMsg, key)
		case "sv":
			err = unpopulate(val, "Sv", &w.Sv)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowTriggerListResult.
func (w WorkflowTriggerListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowTriggerListResult.
func (w *WorkflowTriggerListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowTriggerProperties.
func (w WorkflowTriggerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "changedTime", w.ChangedTime)
	populateDateTimeRFC3339(objectMap, "createdTime", w.CreatedTime)
	populateDateTimeRFC3339(objectMap, "lastExecutionTime", w.LastExecutionTime)
	populateDateTimeRFC3339(objectMap, "nextExecutionTime", w.NextExecutionTime)
	populate(objectMap, "provisioningState", w.ProvisioningState)
	populate(objectMap, "recurrence", w.Recurrence)
	populate(objectMap, "state", w.State)
	populate(objectMap, "status", w.Status)
	populate(objectMap, "workflow", w.Workflow)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowTriggerProperties.
func (w *WorkflowTriggerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changedTime":
			err = unpopulateDateTimeRFC3339(val, "ChangedTime", &w.ChangedTime)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedTime", &w.CreatedTime)
			delete(rawMsg, key)
		case "lastExecutionTime":
			err = unpopulateDateTimeRFC3339(val, "LastExecutionTime", &w.LastExecutionTime)
			delete(rawMsg, key)
		case "nextExecutionTime":
			err = unpopulateDateTimeRFC3339(val, "NextExecutionTime", &w.NextExecutionTime)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &w.ProvisioningState)
			delete(rawMsg, key)
		case "recurrence":
			err = unpopulate(val, "Recurrence", &w.Recurrence)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &w.State)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &w.Status)
			delete(rawMsg, key)
		case "workflow":
			err = unpopulate(val, "Workflow", &w.Workflow)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowTriggerRecurrence.
func (w WorkflowTriggerRecurrence) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endTime", w.EndTime)
	populate(objectMap, "frequency", w.Frequency)
	populate(objectMap, "interval", w.Interval)
	populate(objectMap, "schedule", w.Schedule)
	populate(objectMap, "startTime", w.StartTime)
	populate(objectMap, "timeZone", w.TimeZone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowTriggerRecurrence.
func (w *WorkflowTriggerRecurrence) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulate(val, "EndTime", &w.EndTime)
			delete(rawMsg, key)
		case "frequency":
			err = unpopulate(val, "Frequency", &w.Frequency)
			delete(rawMsg, key)
		case "interval":
			err = unpopulate(val, "Interval", &w.Interval)
			delete(rawMsg, key)
		case "schedule":
			err = unpopulate(val, "Schedule", &w.Schedule)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulate(val, "StartTime", &w.StartTime)
			delete(rawMsg, key)
		case "timeZone":
			err = unpopulate(val, "TimeZone", &w.TimeZone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowVersion.
func (w WorkflowVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowVersion.
func (w *WorkflowVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &w.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &w.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowVersionListResult.
func (w WorkflowVersionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowVersionListResult.
func (w *WorkflowVersionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowVersionProperties.
func (w WorkflowVersionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessControl", w.AccessControl)
	populate(objectMap, "accessEndpoint", w.AccessEndpoint)
	populateDateTimeRFC3339(objectMap, "changedTime", w.ChangedTime)
	populateDateTimeRFC3339(objectMap, "createdTime", w.CreatedTime)
	populateAny(objectMap, "definition", w.Definition)
	populate(objectMap, "endpointsConfiguration", w.EndpointsConfiguration)
	populate(objectMap, "integrationAccount", w.IntegrationAccount)
	populate(objectMap, "parameters", w.Parameters)
	populate(objectMap, "provisioningState", w.ProvisioningState)
	populate(objectMap, "sku", w.SKU)
	populate(objectMap, "state", w.State)
	populate(objectMap, "version", w.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowVersionProperties.
func (w *WorkflowVersionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessControl":
			err = unpopulate(val, "AccessControl", &w.AccessControl)
			delete(rawMsg, key)
		case "accessEndpoint":
			err = unpopulate(val, "AccessEndpoint", &w.AccessEndpoint)
			delete(rawMsg, key)
		case "changedTime":
			err = unpopulateDateTimeRFC3339(val, "ChangedTime", &w.ChangedTime)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedTime", &w.CreatedTime)
			delete(rawMsg, key)
		case "definition":
			err = unpopulate(val, "Definition", &w.Definition)
			delete(rawMsg, key)
		case "endpointsConfiguration":
			err = unpopulate(val, "EndpointsConfiguration", &w.EndpointsConfiguration)
			delete(rawMsg, key)
		case "integrationAccount":
			err = unpopulate(val, "IntegrationAccount", &w.IntegrationAccount)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &w.Parameters)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &w.ProvisioningState)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &w.SKU)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &w.State)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &w.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func populateByteArray(m map[string]any, k string, b []byte, f runtime.Base64Encoding) {
	if azcore.IsNullValue(b) {
		m[k] = nil
	} else if len(b) == 0 {
		return
	} else {
		m[k] = runtime.EncodeByteArray(b, f)
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
