//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdataboxedge_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/databoxedge/armdataboxedge"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/DataBoxEdgeDeviceGetBySubscription.json
func ExampleDevicesClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdataboxedge.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDevicesClient().NewListBySubscriptionPager(&armdataboxedge.DevicesClientListBySubscriptionOptions{Expand: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DeviceList = armdataboxedge.DeviceList{
		// 	Value: []*armdataboxedge.Device{
		// 		{
		// 			Name: to.Ptr("linksub01"),
		// 			Type: to.Ptr("Microsoft.DataBoxEdge/dataBoxEdgeDevices"),
		// 			ID: to.Ptr("/subscriptions/0d44739e-0563-474f-97e7-24a0cdb23b29/resourcegroups/abhudeda-rg/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/linksub01"),
		// 			Etag: to.Ptr("W/\"datetime'2020-11-19T01%3A39%3A55.1270082Z'\"_W/\"datetime'2020-11-19T01%3A39%3A55.1320118Z'\""),
		// 			Identity: &armdataboxedge.ResourceIdentity{
		// 				Type: to.Ptr(armdataboxedge.MsiIdentityTypeSystemAssigned),
		// 				PrincipalID: to.Ptr("083df009-06d9-4e3c-ae72-f9249a814334"),
		// 				TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
		// 			},
		// 			Kind: to.Ptr(armdataboxedge.DataBoxEdgeDeviceKindAzureDataBoxGateway),
		// 			Location: to.Ptr("eastus2euap"),
		// 			SKU: &armdataboxedge.SKUInfo{
		// 				Name: to.Ptr(armdataboxedge.SKUNameGateway),
		// 				Tier: to.Ptr(armdataboxedge.SKUTierStandard),
		// 			},
		// 			Tags: map[string]*string{
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mergeazstest"),
		// 			Type: to.Ptr("Microsoft.DataBoxEdge/dataBoxEdgeDevices"),
		// 			ID: to.Ptr("/subscriptions/0d44739e-0563-474f-97e7-24a0cdb23b29/resourcegroups/abhudeda-rg/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/mergeazstest"),
		// 			Etag: to.Ptr("W/\"datetime'2020-11-19T01%3A40%3A05.9246966Z'\"_W/\"datetime'2020-11-19T01%3A40%3A05.9317011Z'\""),
		// 			Identity: &armdataboxedge.ResourceIdentity{
		// 				Type: to.Ptr(armdataboxedge.MsiIdentityTypeSystemAssigned),
		// 				PrincipalID: to.Ptr("8536db30-78d2-4759-95b7-896a66e14c24"),
		// 				TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
		// 			},
		// 			Kind: to.Ptr(armdataboxedge.DataBoxEdgeDeviceKindAzureDataBoxGateway),
		// 			Location: to.Ptr("eastus2euap"),
		// 			SKU: &armdataboxedge.SKUInfo{
		// 				Name: to.Ptr(armdataboxedge.SKUNameGateway),
		// 				Tier: to.Ptr(armdataboxedge.SKUTierStandard),
		// 			},
		// 			Tags: map[string]*string{
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mergeazstest2"),
		// 			Type: to.Ptr("Microsoft.DataBoxEdge/dataBoxEdgeDevices"),
		// 			ID: to.Ptr("/subscriptions/0d44739e-0563-474f-97e7-24a0cdb23b29/resourcegroups/abhudeda-rg/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/mergeazstest2"),
		// 			Etag: to.Ptr("W/\"datetime'2020-11-19T01%3A40%3A06.496102Z'\"_W/\"datetime'2020-11-19T01%3A40%3A06.503107Z'\""),
		// 			Identity: &armdataboxedge.ResourceIdentity{
		// 				Type: to.Ptr(armdataboxedge.MsiIdentityTypeSystemAssigned),
		// 				PrincipalID: to.Ptr("fc4c1205-35c8-4f35-abc7-f5a78945f676"),
		// 				TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
		// 			},
		// 			Kind: to.Ptr(armdataboxedge.DataBoxEdgeDeviceKindAzureDataBoxGateway),
		// 			Location: to.Ptr("eastus2euap"),
		// 			SKU: &armdataboxedge.SKUInfo{
		// 				Name: to.Ptr(armdataboxedge.SKUNameGateway),
		// 				Tier: to.Ptr(armdataboxedge.SKUTierStandard),
		// 			},
		// 			Tags: map[string]*string{
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/DataBoxEdgeDeviceGetByResourceGroup.json
func ExampleDevicesClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdataboxedge.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDevicesClient().NewListByResourceGroupPager("GroupForEdgeAutomation", &armdataboxedge.DevicesClientListByResourceGroupOptions{Expand: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DeviceList = armdataboxedge.DeviceList{
		// 	Value: []*armdataboxedge.Device{
		// 		{
		// 			Name: to.Ptr("EdgeTestPassResource"),
		// 			Type: to.Ptr("Microsoft.DataBoxEdge/dataBoxEdgeDevices"),
		// 			ID: to.Ptr("/subscriptions/0d44739e-0563-474f-97e7-24a0cdb23b29/resourcegroups/VmMgmtTestPass/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/EdgeTestPassResource"),
		// 			Etag: to.Ptr("W/\"datetime'2020-09-29T18%3A50%3A31.1203818Z'\"_W/\"datetime'2020-09-29T18%3A50%3A31.1343914Z'\""),
		// 			Identity: &armdataboxedge.ResourceIdentity{
		// 				Type: to.Ptr(armdataboxedge.MsiIdentityTypeSystemAssigned),
		// 				PrincipalID: to.Ptr("b3e34fcc-ab02-4ca4-9d22-5de115419091"),
		// 				TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
		// 			},
		// 			Kind: to.Ptr(armdataboxedge.DataBoxEdgeDeviceKindAzureStackEdge),
		// 			Location: to.Ptr("eastus2euap"),
		// 			SKU: &armdataboxedge.SKUInfo{
		// 				Name: to.Ptr(armdataboxedge.SKUNameEdge),
		// 				Tier: to.Ptr(armdataboxedge.SKUTierStandard),
		// 			},
		// 			Tags: map[string]*string{
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("FPGAResource"),
		// 			Type: to.Ptr("Microsoft.DataBoxEdge/dataBoxEdgeDevices"),
		// 			ID: to.Ptr("/subscriptions/0d44739e-0563-474f-97e7-24a0cdb23b29/resourcegroups/VmMgmtTestPass/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/FPGAResource"),
		// 			Etag: to.Ptr("W/\"datetime'2020-11-18T23%3A31%3A30.3266766Z'\"_W/\"datetime'2020-11-18T23%3A31%3A30.3326804Z'\""),
		// 			Identity: &armdataboxedge.ResourceIdentity{
		// 				Type: to.Ptr(armdataboxedge.MsiIdentityTypeSystemAssigned),
		// 				PrincipalID: to.Ptr("d97a6de5-f5c0-485a-8f5e-b7f705d2dbc4"),
		// 				TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
		// 			},
		// 			Kind: to.Ptr(armdataboxedge.DataBoxEdgeDeviceKindAzureStackEdge),
		// 			Location: to.Ptr("centraluseuap"),
		// 			SKU: &armdataboxedge.SKUInfo{
		// 				Name: to.Ptr(armdataboxedge.SKUNameEdge),
		// 				Tier: to.Ptr(armdataboxedge.SKUTierStandard),
		// 			},
		// 			Tags: map[string]*string{
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("TestVMEdgeResource"),
		// 			Type: to.Ptr("Microsoft.DataBoxEdge/dataBoxEdgeDevices"),
		// 			ID: to.Ptr("/subscriptions/0d44739e-0563-474f-97e7-24a0cdb23b29/resourcegroups/VmMgmtTestPass/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/TestVMEdgeResource"),
		// 			Etag: to.Ptr("W/\"datetime'2020-11-18T23%3A31%3A23.1715672Z'\"_W/\"datetime'2020-11-18T23%3A31%3A23.2396152Z'\""),
		// 			Identity: &armdataboxedge.ResourceIdentity{
		// 				Type: to.Ptr(armdataboxedge.MsiIdentityTypeSystemAssigned),
		// 				PrincipalID: to.Ptr("6f2b341b-aded-4ec2-a1bd-d09438d6cc8f"),
		// 				TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
		// 			},
		// 			Kind: to.Ptr(armdataboxedge.DataBoxEdgeDeviceKindAzureStackEdge),
		// 			Location: to.Ptr("centraluseuap"),
		// 			SKU: &armdataboxedge.SKUInfo{
		// 				Name: to.Ptr(armdataboxedge.SKUNameEdge),
		// 				Tier: to.Ptr(armdataboxedge.SKUTierStandard),
		// 			},
		// 			Tags: map[string]*string{
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/DataBoxEdgeDeviceGetByName.json
func ExampleDevicesClient_Get_dataBoxEdgeDeviceGetByName() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdataboxedge.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDevicesClient().Get(ctx, "testedgedevice", "GroupForEdgeAutomation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Device = armdataboxedge.Device{
	// 	Name: to.Ptr("EdgeTestPassResource"),
	// 	Type: to.Ptr("Microsoft.DataBoxEdge/dataBoxEdgeDevices"),
	// 	ID: to.Ptr("/subscriptions/0d44739e-0563-474f-97e7-24a0cdb23b29/resourcegroups/VmMgmtTestPass/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/EdgeTestPassResource"),
	// 	Etag: to.Ptr("W/\"datetime'2020-09-29T18%3A50%3A31.1203818Z'\"_W/\"datetime'2020-09-29T18%3A50%3A31.1343914Z'\""),
	// 	Identity: &armdataboxedge.ResourceIdentity{
	// 		Type: to.Ptr(armdataboxedge.MsiIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("b3e34fcc-ab02-4ca4-9d22-5de115419091"),
	// 		TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
	// 	},
	// 	Kind: to.Ptr(armdataboxedge.DataBoxEdgeDeviceKindAzureStackEdge),
	// 	Location: to.Ptr("eastus2euap"),
	// 	Properties: &armdataboxedge.DeviceProperties{
	// 		ConfiguredRoleTypes: []*armdataboxedge.RoleTypes{
	// 			to.Ptr(armdataboxedge.RoleTypesCloudEdgeManagement)},
	// 			DataBoxEdgeDeviceStatus: to.Ptr(armdataboxedge.DataBoxEdgeDeviceStatusOffline),
	// 			DeviceHcsVersion: to.Ptr("2.1.1361.23408"),
	// 			DeviceLocalCapacity: to.Ptr[int64](8042259),
	// 			DeviceModel: to.Ptr("Physical"),
	// 			DeviceSoftwareVersion: to.Ptr("Azure Stack Edge 2009"),
	// 			DeviceType: to.Ptr(armdataboxedge.DeviceTypeDataBoxEdgeDevice),
	// 			EdgeProfile: &armdataboxedge.EdgeProfile{
	// 				Subscription: &armdataboxedge.EdgeProfileSubscription{
	// 					ID: to.Ptr("/subscriptions/0d44739e-0563-474f-97e7-24a0cdb23b29/resourceGroups/VmMgmtTestPass/providers/Microsoft.AzureStack/edgeSubscriptions/daaac4b0-35c4-4008-bdc6-b72ca5890f16"),
	// 					RegistrationID: to.Ptr("91d8753b-af42-4908-9a5e-2a61f08b20de"),
	// 					State: to.Ptr(armdataboxedge.SubscriptionStateRegistered),
	// 				},
	// 			},
	// 			FriendlyName: to.Ptr("DBE-1D6QHQ2"),
	// 			NodeCount: to.Ptr[int32](1),
	// 			SerialNumber: to.Ptr("1D6QHQ2"),
	// 			TimeZone: to.Ptr("Pacific Standard Time"),
	// 		},
	// 		SKU: &armdataboxedge.SKUInfo{
	// 			Name: to.Ptr(armdataboxedge.SKUNameEdge),
	// 			Tier: to.Ptr(armdataboxedge.SKUTierStandard),
	// 		},
	// 		Tags: map[string]*string{
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/DataBoxEdgeDeviceGetByNameWithDataResidency.json
func ExampleDevicesClient_Get_dataBoxEdgeDeviceGetByNameWithDataResidency() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdataboxedge.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDevicesClient().Get(ctx, "testedgedevice", "GroupForEdgeAutomation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Device = armdataboxedge.Device{
	// 	Name: to.Ptr("EdgeTestPassResource"),
	// 	Type: to.Ptr("Microsoft.DataBoxEdge/dataBoxEdgeDevices"),
	// 	ID: to.Ptr("/subscriptions/0d44739e-0563-474f-97e7-24a0cdb23b29/resourcegroups/VmMgmtTestPass/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/EdgeTestPassResource"),
	// 	Etag: to.Ptr("W/\"datetime'2020-09-29T18%3A50%3A31.1203818Z'\"_W/\"datetime'2020-09-29T18%3A50%3A31.1343914Z'\""),
	// 	Identity: &armdataboxedge.ResourceIdentity{
	// 		Type: to.Ptr(armdataboxedge.MsiIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("b3e34fcc-ab02-4ca4-9d22-5de115419091"),
	// 		TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
	// 	},
	// 	Kind: to.Ptr(armdataboxedge.DataBoxEdgeDeviceKindAzureStackEdge),
	// 	Location: to.Ptr("eastus2euap"),
	// 	Properties: &armdataboxedge.DeviceProperties{
	// 		ConfiguredRoleTypes: []*armdataboxedge.RoleTypes{
	// 			to.Ptr(armdataboxedge.RoleTypesCloudEdgeManagement)},
	// 			DataBoxEdgeDeviceStatus: to.Ptr(armdataboxedge.DataBoxEdgeDeviceStatusOffline),
	// 			DataResidency: &armdataboxedge.DataResidency{
	// 				Type: to.Ptr(armdataboxedge.DataResidencyTypeZoneReplication),
	// 			},
	// 			DeviceHcsVersion: to.Ptr("2.1.1361.23408"),
	// 			DeviceLocalCapacity: to.Ptr[int64](8042259),
	// 			DeviceModel: to.Ptr("Physical"),
	// 			DeviceSoftwareVersion: to.Ptr("Azure Stack Edge 2009"),
	// 			DeviceType: to.Ptr(armdataboxedge.DeviceTypeDataBoxEdgeDevice),
	// 			EdgeProfile: &armdataboxedge.EdgeProfile{
	// 				Subscription: &armdataboxedge.EdgeProfileSubscription{
	// 					ID: to.Ptr("/subscriptions/0d44739e-0563-474f-97e7-24a0cdb23b29/resourceGroups/VmMgmtTestPass/providers/Microsoft.AzureStack/edgeSubscriptions/daaac4b0-35c4-4008-bdc6-b72ca5890f16"),
	// 					RegistrationID: to.Ptr("91d8753b-af42-4908-9a5e-2a61f08b20de"),
	// 					State: to.Ptr(armdataboxedge.SubscriptionStateRegistered),
	// 				},
	// 			},
	// 			FriendlyName: to.Ptr("DBE-1D6QHQ2"),
	// 			NodeCount: to.Ptr[int32](1),
	// 			SerialNumber: to.Ptr("1D6QHQ2"),
	// 			TimeZone: to.Ptr("Pacific Standard Time"),
	// 		},
	// 		SKU: &armdataboxedge.SKUInfo{
	// 			Name: to.Ptr(armdataboxedge.SKUNameEdge),
	// 			Tier: to.Ptr(armdataboxedge.SKUTierStandard),
	// 		},
	// 		Tags: map[string]*string{
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/DataBoxEdgeDevicePut.json
func ExampleDevicesClient_CreateOrUpdate_dataBoxEdgeDevicePut() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdataboxedge.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDevicesClient().CreateOrUpdate(ctx, "testedgedevice", "GroupForEdgeAutomation", armdataboxedge.Device{
		Location: to.Ptr("WUS"),
		SKU: &armdataboxedge.SKUInfo{
			Name: to.Ptr(armdataboxedge.SKUNameEdge),
			Tier: to.Ptr(armdataboxedge.SKUTierStandard),
		},
		Tags: map[string]*string{},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Device = armdataboxedge.Device{
	// 	Name: to.Ptr("testedgedevice"),
	// 	Location: to.Ptr("WUS"),
	// 	SKU: &armdataboxedge.SKUInfo{
	// 		Name: to.Ptr(armdataboxedge.SKUNameEdge),
	// 		Tier: to.Ptr(armdataboxedge.SKUTierStandard),
	// 	},
	// 	Tags: map[string]*string{
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/DataBoxEdgeDevicePutWithDataResidency.json
func ExampleDevicesClient_CreateOrUpdate_dataBoxEdgeDevicePutWithDataResidency() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdataboxedge.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDevicesClient().CreateOrUpdate(ctx, "testedgedevice", "GroupForEdgeAutomation", armdataboxedge.Device{
		Location: to.Ptr("WUS"),
		Properties: &armdataboxedge.DeviceProperties{
			DataResidency: &armdataboxedge.DataResidency{
				Type: to.Ptr(armdataboxedge.DataResidencyTypeZoneReplication),
			},
		},
		SKU: &armdataboxedge.SKUInfo{
			Name: to.Ptr(armdataboxedge.SKUNameEdge),
			Tier: to.Ptr(armdataboxedge.SKUTierStandard),
		},
		Tags: map[string]*string{},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Device = armdataboxedge.Device{
	// 	Name: to.Ptr("testedgedevice"),
	// 	Location: to.Ptr("WUS"),
	// 	Properties: &armdataboxedge.DeviceProperties{
	// 		DataResidency: &armdataboxedge.DataResidency{
	// 			Type: to.Ptr(armdataboxedge.DataResidencyTypeZoneReplication),
	// 		},
	// 	},
	// 	SKU: &armdataboxedge.SKUInfo{
	// 		Name: to.Ptr(armdataboxedge.SKUNameEdge),
	// 		Tier: to.Ptr(armdataboxedge.SKUTierStandard),
	// 	},
	// 	Tags: map[string]*string{
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/DataBoxEdgeDeviceDelete.json
func ExampleDevicesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdataboxedge.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDevicesClient().BeginDelete(ctx, "testedgedevice", "GroupForEdgeAutomation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/DataBoxEdgeDevicePatch.json
func ExampleDevicesClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdataboxedge.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDevicesClient().Update(ctx, "testedgedevice", "GroupForEdgeAutomation", armdataboxedge.DevicePatch{
		Properties: &armdataboxedge.DevicePropertiesPatch{
			EdgeProfile: &armdataboxedge.EdgeProfilePatch{
				Subscription: &armdataboxedge.EdgeProfileSubscriptionPatch{
					ID: to.Ptr("/subscriptions/0d44739e-0563-474f-97e7-24a0cdb23b29/resourceGroups/rapvs-rg/providers/Microsoft.AzureStack/linkedSubscriptions/ca014ddc-5cf2-45f8-b390-e901e4a0ae87"),
				},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Device = armdataboxedge.Device{
	// 	Name: to.Ptr("testedgedevice"),
	// 	Type: to.Ptr("Microsoft.DataBoxEdge/dataBoxEdgeDevices"),
	// 	ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourcegroups/VmMgmtTestPass/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice"),
	// 	Etag: to.Ptr("W/\"datetime'2020-11-19T04%3A43%3A38.6457308Z'\"_W/\"datetime'2020-11-19T04%3A43%3A38.6507339Z'\""),
	// 	Identity: &armdataboxedge.ResourceIdentity{
	// 		Type: to.Ptr(armdataboxedge.MsiIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("b3e34fcc-ab02-4ca4-9d22-5de115419091"),
	// 		TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
	// 	},
	// 	Kind: to.Ptr(armdataboxedge.DataBoxEdgeDeviceKindAzureStackEdge),
	// 	Location: to.Ptr("eastus2euap"),
	// 	Properties: &armdataboxedge.DeviceProperties{
	// 		DataBoxEdgeDeviceStatus: to.Ptr(armdataboxedge.DataBoxEdgeDeviceStatusReadyToSetup),
	// 		DeviceLocalCapacity: to.Ptr[int64](0),
	// 		DeviceType: to.Ptr(armdataboxedge.DeviceTypeDataBoxEdgeDevice),
	// 		EdgeProfile: &armdataboxedge.EdgeProfile{
	// 			Subscription: &armdataboxedge.EdgeProfileSubscription{
	// 				ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/VmMgmtTestPass/providers/Microsoft.AzureStack/edgeSubscriptions/daaac4b0-35c4-4008-bdc6-b72ca5890f16"),
	// 				RegistrationID: to.Ptr("91d8753b-af42-4908-9a5e-2a61f08b20de"),
	// 				State: to.Ptr(armdataboxedge.SubscriptionStateRegistered),
	// 			},
	// 		},
	// 		NodeCount: to.Ptr[int32](0),
	// 		ResourceMoveDetails: &armdataboxedge.ResourceMoveDetails{
	// 			OperationInProgress: to.Ptr(armdataboxedge.ResourceMoveStatusNone),
	// 		},
	// 		TimeZone: to.Ptr("Pacific Standard Time"),
	// 	},
	// 	SKU: &armdataboxedge.SKUInfo{
	// 		Name: to.Ptr(armdataboxedge.SKUNameEdge),
	// 		Tier: to.Ptr(armdataboxedge.SKUTierStandard),
	// 	},
	// 	Tags: map[string]*string{
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/DownloadUpdatesPost.json
func ExampleDevicesClient_BeginDownloadUpdates() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdataboxedge.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDevicesClient().BeginDownloadUpdates(ctx, "testedgedevice", "GroupForEdgeAutomation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/GenerateCertificate.json
func ExampleDevicesClient_GenerateCertificate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdataboxedge.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDevicesClient().GenerateCertificate(ctx, "testedgedevice", "GroupForEdgeAutomation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.GenerateCertResponse = armdataboxedge.GenerateCertResponse{
	// 	ExpiryTimeInUTC: to.Ptr("2020-11-22T05:06:20.000Z"),
	// 	PublicKey: to.Ptr("MIIEDjCCAnagAwIBAgIQEW4wrxj9+JdA4kFLDgegTTANBgkqhkiG9w0BAQUFADBDMUEwPwYDVQQDHjgAQwBCAF8AUABvAHIAdABhAGwAXwA2ADMANwA0ADEAMwA1ADkAMQA4ADAAMAA3ADAAOQAxADcANTAeFw0yMDExMTkwNDU2MjBaFw0yMDExMjIwNTA2MjBaMEMxQTA/BgNVBAMeOABDAEIAXwBQAG8AcgB0AGEAbABfADYAMwA3ADQAMQAzADUAOQAxADgAMAAwADcAMAA5ADEANwA1MIIBojANBgkqhkiG9w0BAQEFAAOCAY8AMIIBigKCAYEAqG617KAUc4gOoht527o6FGE/c97W/wZIXqKbx4G8vifljXWw3NGDDuSQfidE3MqSMMJ/AAlDhBH/Deo/PAgUWuWB2WgM+KFWrDS0oDBvLVeIIeiMx4LOsbz4J8IbcKrGWf+ulQyum7dE/yBLzPXcPTjhJP0oMfhGOMlVVWbiKaP78/WZk2PmBQaVv7PxAQnJAPqETH2qAyuc9bd0TaMlIER56WhX9+nzsoI0u7RmBEs8+BaudVroiiK/GpEczy73TCRlpVXGChdBHg+NvYRYz91ltCV9Ijo1bdvcUjdgDJZ4Tz7G8XVCQmxbd9ml6OBLgxQUpd9HSGTcIfFiv+rTUwHR7YkY+1UGHsDPOYnBVDTXs3RFm+c5uNnCKvtyTExDJgabT+FTNb3eyD/BSYsy6b/YZBRqPiO8BRFUsIhWhXtPaUjWOEx6XMeZRnGeF4Hi8iH8TR79kEJhfYy3piSPAc3JrhgoglpyyfZOgyPOje+8tAWS9FHUNyVXKKeksDoZAgMBAAEwDQYJKoZIhvcNAQEFBQADggGBACpfQt34mgr+WlFtY0tqaPAoF6XnVzyKB6XsVAoj1uKFTSCQnr0mWvUMWKSRFTu1bV1VdDokV5I+h92kBcO4ddtHhWtkt16j9XFDsGdDvoUWJeqecZVr9fBPC69wF/9R/2E6iJporR46Pui7gcilYGqb3IjJlh8RT/XBPamQrfDbS7G8eTe91ST5cHr89R6EtDwfyhyTZr2sRrvQrxY2AjEmdH5Zcl9q2Xf8DholZhZ9vwnuYBFfl6VCXWaDAzQWiPdxo1wgXxEpNNDstGFWJKnsnz9UCohNAiPf47B+csPqxjcTLVMhcGLdU/lwpzzkEOciijpYILscvPoU3IM6DmFROgU2z6CForpgwHPDJktyWU1MC7lFdfrSzwu/5b3ZAEQhnJf7rvrybULoYBQWJEuj26Is1S6kXpNUaHAc5HIyIoc2V2eRjasbPIqsU0smjPLS/1egjHxtw9u+v4qDDvDuOjhFJtC3NkPl06TfNgO9+5LgiB1JppXnkLyCQ9RQgw=="),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/ExtendedInfoPost.json
func ExampleDevicesClient_GetExtendedInformation() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdataboxedge.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDevicesClient().GetExtendedInformation(ctx, "testedgedevice", "GroupForEdgeAutomation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeviceExtendedInfo = armdataboxedge.DeviceExtendedInfo{
	// 	Name: to.Ptr("testedgedevice"),
	// 	Type: to.Ptr("Microsoft.DataBoxEdge/dataBoxEdgeDevices"),
	// 	ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice"),
	// 	Properties: &armdataboxedge.DeviceExtendedInfoProperties{
	// 		EncryptionKey: to.Ptr("<encryptionkey>"),
	// 		EncryptionKeyThumbprint: to.Ptr("<encryptionthumbprint>"),
	// 		ResourceKey: to.Ptr("3482840729935603111"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/InstallUpdatesPost.json
func ExampleDevicesClient_BeginInstallUpdates() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdataboxedge.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDevicesClient().BeginInstallUpdates(ctx, "testedgedevice", "GroupForEdgeAutomation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/NetworkSettingsGet.json
func ExampleDevicesClient_GetNetworkSettings() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdataboxedge.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDevicesClient().GetNetworkSettings(ctx, "testedgedevice", "GroupForEdgeAutomation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NetworkSettings = armdataboxedge.NetworkSettings{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.DataBoxEdge/dataBoxEdgeDevices/networkSettings"),
	// 	ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/networkSettings/default"),
	// 	Properties: &armdataboxedge.NetworkSettingsProperties{
	// 		NetworkAdapters: []*armdataboxedge.NetworkAdapter{
	// 			{
	// 				AdapterID: to.Ptr("{47D0D0EC-AA8A-4221-AA2A-355B58082BA5}"),
	// 				AdapterPosition: &armdataboxedge.NetworkAdapterPosition{
	// 					NetworkGroup: to.Ptr(armdataboxedge.NetworkGroupNonRDMA),
	// 					Port: to.Ptr[int32](0),
	// 				},
	// 				DhcpStatus: to.Ptr(armdataboxedge.NetworkAdapterDHCPStatusDisabled),
	// 				DNSServers: []*string{
	// 					to.Ptr("10.50.50.50"),
	// 					to.Ptr("10.50.10.50")},
	// 					Index: to.Ptr[int32](1),
	// 					IPv4Configuration: &armdataboxedge.IPv4Config{
	// 						Gateway: to.Ptr("10.150.76.1"),
	// 						IPAddress: to.Ptr("10.150.78.56"),
	// 						Subnet: to.Ptr("255.255.252.0"),
	// 					},
	// 					IPv6Configuration: &armdataboxedge.IPv6Config{
	// 						Gateway: to.Ptr("fe80::12f3:11ff:fe36:994b%5"),
	// 						IPAddress: to.Ptr("2404:f801:4800:1e:d5c6:50a1:465b:1bbf"),
	// 						PrefixLength: to.Ptr[int32](64),
	// 					},
	// 					IPv6LinkLocalAddress: to.Ptr("fe80::d5c6:50a1:465b:1bbf%5"),
	// 					Label: to.Ptr("DATA1"),
	// 					LinkSpeed: to.Ptr[int64](10000000000),
	// 					MacAddress: to.Ptr("00155D4E265B"),
	// 					NetworkAdapterName: to.Ptr("DATA1"),
	// 					NodeID: to.Ptr("3fd54d9e-f7a0-45bf-bdf1-39b0977d1984"),
	// 					RdmaStatus: to.Ptr(armdataboxedge.NetworkAdapterRDMAStatusIncapable),
	// 					Status: to.Ptr(armdataboxedge.NetworkAdapterStatusInactive),
	// 			}},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/ScanForUpdatesPost.json
func ExampleDevicesClient_BeginScanForUpdates() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdataboxedge.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDevicesClient().BeginScanForUpdates(ctx, "testedgedevice", "GroupForEdgeAutomation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/SecuritySettingsUpdatePost.json
func ExampleDevicesClient_BeginCreateOrUpdateSecuritySettings() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdataboxedge.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDevicesClient().BeginCreateOrUpdateSecuritySettings(ctx, "testedgedevice", "AzureVM", armdataboxedge.SecuritySettings{
		Properties: &armdataboxedge.SecuritySettingsProperties{
			DeviceAdminPassword: &armdataboxedge.AsymmetricEncryptedSecret{
				EncryptionAlgorithm:      to.Ptr(armdataboxedge.EncryptionAlgorithmAES256),
				EncryptionCertThumbprint: to.Ptr("<encryptionThumprint>"),
				Value:                    to.Ptr("<deviceAdminPassword>"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/GetUpdateExtendedInfo.json
func ExampleDevicesClient_UpdateExtendedInformation() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdataboxedge.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDevicesClient().UpdateExtendedInformation(ctx, "testedgedevice", "GroupForEdgeAutomation", armdataboxedge.DeviceExtendedInfoPatch{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeviceExtendedInfo = armdataboxedge.DeviceExtendedInfo{
	// 	Properties: &armdataboxedge.DeviceExtendedInfoProperties{
	// 		ChannelIntegrityKeyName: to.Ptr("ase-cik-ab861822-21ea-4d31-96ec-89aa066f9a59"),
	// 		ChannelIntegrityKeyVersion: to.Ptr("95e9b619e65f433d82c9e1ead48214b9"),
	// 		ClientSecretStoreID: to.Ptr("/subscriptions/0d44739e-0563-474f-97e7-24a0cdb23b29/resourceGroups/arja-rg/providers/Microsoft.KeyVault/vaults/test-keyvault-ccy-523"),
	// 		ClientSecretStoreURL: to.Ptr("https://test-keyvault-ccy-523.vault.azure.net"),
	// 		DeviceSecrets: map[string]*armdataboxedge.Secret{
	// 			"BMCDefaultUserPassword": &armdataboxedge.Secret{
	// 			},
	// 			"HcsDataVolumeBitLockerExternalKey": &armdataboxedge.Secret{
	// 				KeyVaultID: to.Ptr("Id"),
	// 			},
	// 			"HcsInternalVolumeBitLockerExternalKey": &armdataboxedge.Secret{
	// 				KeyVaultID: to.Ptr("Id"),
	// 			},
	// 			"RotateKeyForDataVolumeBitlocker": &armdataboxedge.Secret{
	// 			},
	// 			"RotateKeysForSedDrivesSerialized": &armdataboxedge.Secret{
	// 			},
	// 			"SEDEncryptionExternalKey": &armdataboxedge.Secret{
	// 			},
	// 			"SEDEncryptionExternalKeyId": &armdataboxedge.Secret{
	// 			},
	// 			"SystemVolumeBitLockerRecoveryKey": &armdataboxedge.Secret{
	// 				KeyVaultID: to.Ptr("Id"),
	// 			},
	// 		},
	// 		KeyVaultSyncStatus: to.Ptr(armdataboxedge.KeyVaultSyncStatusKeyVaultSynced),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/UpdateSummaryGet.json
func ExampleDevicesClient_GetUpdateSummary() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdataboxedge.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDevicesClient().GetUpdateSummary(ctx, "testedgedevice", "GroupForEdgeAutomation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.UpdateSummary = armdataboxedge.UpdateSummary{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.DataBoxEdge/dataBoxEdgeDevices/updateSummary"),
	// 	ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/updateSummary/default"),
	// 	Properties: &armdataboxedge.UpdateSummaryProperties{
	// 		DeviceLastScannedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-17T19:51:51.786Z"); return t}()),
	// 		DeviceVersionNumber: to.Ptr("2.1.1377.2170"),
	// 		FriendlyDeviceVersionName: to.Ptr("Azure Stack Edge 2010"),
	// 		LastCompletedScanJobDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-17T19:47:46.159Z"); return t}()),
	// 		LastDownloadJobStatus: to.Ptr(armdataboxedge.JobStatusInvalid),
	// 		LastInstallJobStatus: to.Ptr(armdataboxedge.JobStatusInvalid),
	// 		OngoingUpdateOperation: to.Ptr(armdataboxedge.UpdateOperationInstall),
	// 		RebootBehavior: to.Ptr(armdataboxedge.InstallRebootBehaviorNeverReboots),
	// 		TotalNumberOfUpdatesAvailable: to.Ptr[int32](1),
	// 		TotalNumberOfUpdatesPendingDownload: to.Ptr[int32](1),
	// 		TotalNumberOfUpdatesPendingInstall: to.Ptr[int32](1),
	// 		TotalUpdateSizeInBytes: to.Ptr[float64](4260898192),
	// 		UpdateTitles: []*string{
	// 			to.Ptr("Azure Stack Edge Update 2101 Package 1 of 2 for Pro-GPU, Pro R, Mini R")},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/UploadCertificatePost.json
func ExampleDevicesClient_UploadCertificate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdataboxedge.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDevicesClient().UploadCertificate(ctx, "testedgedevice", "GroupForEdgeAutomation", armdataboxedge.UploadCertificateRequest{
		Properties: &armdataboxedge.RawCertificateData{
			Certificate: to.Ptr("MIIC9DCCAdygAwIBAgIQWJae7GNjiI9Mcv/gJyrOPTANBgkqhkiG9w0BAQUFADASMRAwDgYDVQQDDAdXaW5kb3dzMB4XDTE4MTEyNzAwMTA0NVoXDTIxMTEyODAwMTA0NVowEjEQMA4GA1UEAwwHV2luZG93czCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKxkRExqxf0qH1avnyORptIbRC2yQwqe3EIbJ2FPKr5jtAppGeX/dGKrFSnX+7/0HFr77aJHafdpEAtOiLyJ4zCAVs0obZCCIq4qJdmjYUTU0UXH/w/YzXfQA0d9Zh9AN+NJBX9xj05NzgsT24fkgsK2v6mWJQXT7YcWAsl5sEYPnx1e+MrupNyVSL/RUJmrS+etJSysHtFeWRhsUhVAs1DD5ExJvBLU3WH0IsojEvpXcjrutB5/MDQNrd/StGI6WovoSSPH7FyT9tgERx+q+Yg3YUGzfaIPCctlrRGehcdtzdNoKd0rsX62yCq0U6POoSfwe22NJu41oAUMd7e6R8cCAwEAAaNGMEQwEwYDVR0lBAwwCgYIKwYBBQUHAwIwHQYDVR0OBBYEFDd0VxnS3LnMIfwc7xW4b4IZWG5GMA4GA1UdDwEB/wQEAwIFIDANBgkqhkiG9w0BAQUFAAOCAQEAPQRby2u9celvtvL/DLEb5Vt3/tPStRQC5MyTD62L5RT/q8E6EMCXVZNkXF5WlWucLJi/18tY+9PNgP9xWLJh7kpSWlWdi9KPtwMqKDlEH8L2TnQdjimt9XuiCrTnoFy/1X2BGLY/rCaUJNSd15QCkz2xeW+Z+YSk2GwAc/A/4YfNpqSIMfNuPrT76o02VdD9WmJUA3fS/HY0sU9qgQRS/3F5/0EPS+HYQ0SvXCK9tggcCd4O050ytNBMJC9qMOJ7yE0iOrFfOJSCfDAuPhn/rHFh79Kn1moF+/CE+nc0/2RPiLC8r54/rt5dYyyxJDfXg0a3VrrX39W69WZGW5OXiw=="),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.UploadCertificateResponse = armdataboxedge.UploadCertificateResponse{
	// 	AADAuthority: to.Ptr("https://login.windows.net"),
	// 	AADTenantID: to.Ptr("100b019d-4626-4a9e-a83c-9cff8fe41909"),
	// 	AuthType: to.Ptr(armdataboxedge.AuthenticationTypeAzureActiveDirectory),
	// 	AzureManagementEndpointAudience: to.Ptr("https://wus-bvtgateway.ext.trafficmanager.net/"),
	// 	ResourceID: to.Ptr("392799901267771"),
	// 	ServicePrincipalClientID: to.Ptr("ffd8a688-82b1-4e5a-a4c1-7ede8c928e68"),
	// 	ServicePrincipalObjectID: to.Ptr("cef6d40c-24e6-4a6f-bb9e-3ec60b4adec4"),
	// }
}
