//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armlogic_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/logic/armlogic"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationServiceEnvironments_Skus.json
func ExampleIntegrationServiceEnvironmentSKUsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewIntegrationServiceEnvironmentSKUsClient().NewListPager("testResourceGroup", "testIntegrationServiceEnvironment", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.IntegrationServiceEnvironmentSKUList = armlogic.IntegrationServiceEnvironmentSKUList{
		// 	Value: []*armlogic.IntegrationServiceEnvironmentSKUDefinition{
		// 		{
		// 			Capacity: &armlogic.IntegrationServiceEnvironmentSKUCapacity{
		// 				Default: to.Ptr[int32](0),
		// 				Maximum: to.Ptr[int32](10),
		// 				Minimum: to.Ptr[int32](0),
		// 				ScaleType: to.Ptr(armlogic.IntegrationServiceEnvironmentSKUScaleTypeAutomatic),
		// 			},
		// 			ResourceType: to.Ptr("Microsoft.Logic/integrationServiceEnvironments"),
		// 			SKU: &armlogic.IntegrationServiceEnvironmentSKUDefinitionSKU{
		// 				Name: to.Ptr(armlogic.IntegrationServiceEnvironmentSKUNamePremium),
		// 			},
		// 		},
		// 		{
		// 			Capacity: &armlogic.IntegrationServiceEnvironmentSKUCapacity{
		// 				Default: to.Ptr[int32](0),
		// 				Maximum: to.Ptr[int32](0),
		// 				Minimum: to.Ptr[int32](0),
		// 				ScaleType: to.Ptr(armlogic.IntegrationServiceEnvironmentSKUScaleTypeNone),
		// 			},
		// 			ResourceType: to.Ptr("Microsoft.Logic/integrationServiceEnvironments"),
		// 			SKU: &armlogic.IntegrationServiceEnvironmentSKUDefinitionSKU{
		// 				Name: to.Ptr(armlogic.IntegrationServiceEnvironmentSKUNameDeveloper),
		// 			},
		// 	}},
		// }
	}
}
