//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armrecoveryservicessiterecovery

import "time"

// A2AAddDisksInput - A2A add disk(s) input.
type A2AAddDisksInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// The list of vm disk details.
	VMDisks []*A2AVMDiskInputDetails

	// The list of vm managed disk details.
	VMManagedDisks []*A2AVMManagedDiskInputDetails
}

// GetAddDisksProviderSpecificInput implements the AddDisksProviderSpecificInputClassification interface for type A2AAddDisksInput.
func (a *A2AAddDisksInput) GetAddDisksProviderSpecificInput() *AddDisksProviderSpecificInput {
	return &AddDisksProviderSpecificInput{
		InstanceType: a.InstanceType,
	}
}

// A2AApplyRecoveryPointInput - ApplyRecoveryPoint input specific to A2A provider.
type A2AApplyRecoveryPointInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetApplyRecoveryPointProviderSpecificInput implements the ApplyRecoveryPointProviderSpecificInputClassification interface
// for type A2AApplyRecoveryPointInput.
func (a *A2AApplyRecoveryPointInput) GetApplyRecoveryPointProviderSpecificInput() *ApplyRecoveryPointProviderSpecificInput {
	return &ApplyRecoveryPointProviderSpecificInput{
		InstanceType: a.InstanceType,
	}
}

// A2AContainerCreationInput - A2A cloud creation input.
type A2AContainerCreationInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetReplicationProviderSpecificContainerCreationInput implements the ReplicationProviderSpecificContainerCreationInputClassification
// interface for type A2AContainerCreationInput.
func (a *A2AContainerCreationInput) GetReplicationProviderSpecificContainerCreationInput() *ReplicationProviderSpecificContainerCreationInput {
	return &ReplicationProviderSpecificContainerCreationInput{
		InstanceType: a.InstanceType,
	}
}

// A2AContainerMappingInput - A2A container mapping input.
type A2AContainerMappingInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// A value indicating whether the auto update is enabled.
	AgentAutoUpdateStatus *AgentAutoUpdateStatus

	// The automation account arm id.
	AutomationAccountArmID *string

	// A value indicating the type authentication to use for automation Account.
	AutomationAccountAuthenticationType *AutomationAccountAuthenticationType
}

// GetReplicationProviderSpecificContainerMappingInput implements the ReplicationProviderSpecificContainerMappingInputClassification
// interface for type A2AContainerMappingInput.
func (a *A2AContainerMappingInput) GetReplicationProviderSpecificContainerMappingInput() *ReplicationProviderSpecificContainerMappingInput {
	return &ReplicationProviderSpecificContainerMappingInput{
		InstanceType: a.InstanceType,
	}
}

// A2ACreateProtectionIntentInput - A2A create protection intent input.
type A2ACreateProtectionIntentInput struct {
	// REQUIRED; The fabric specific object Id of the virtual machine.
	FabricObjectID *string

	// REQUIRED; The class type.
	InstanceType *string

	// REQUIRED; The primary location for the virtual machine.
	PrimaryLocation *string

	// REQUIRED; The recovery availability type of the virtual machine.
	RecoveryAvailabilityType *A2ARecoveryAvailabilityType

	// REQUIRED; The recovery location for the virtual machine.
	RecoveryLocation *string

	// REQUIRED; The recovery resource group Id. Valid for V2 scenarios.
	RecoveryResourceGroupID *string

	// REQUIRED; The recovery subscription Id of the virtual machine.
	RecoverySubscriptionID *string

	// A value indicating whether the auto update is enabled.
	AgentAutoUpdateStatus *AgentAutoUpdateStatus

	// A value indicating whether the auto protection is enabled.
	AutoProtectionOfDataDisk *AutoProtectionOfDataDisk

	// The automation account arm id.
	AutomationAccountArmID *string

	// A value indicating the authentication type for automation account. The default value is "RunAsAccount".
	AutomationAccountAuthenticationType *AutomationAccountAuthenticationType

	// The recovery disk encryption information (for two pass flows).
	DiskEncryptionInfo *DiskEncryptionInfo

	// The multi vm group id.
	MultiVMGroupID *string

	// The multi vm group name.
	MultiVMGroupName *string

	// The primary staging storage account input.
	PrimaryStagingStorageAccountCustomInput StorageAccountCustomDetailsClassification

	// The protection profile custom inputs.
	ProtectionProfileCustomInput ProtectionProfileCustomDetailsClassification

	// The recovery availability set input.
	RecoveryAvailabilitySetCustomInput RecoveryAvailabilitySetCustomDetailsClassification

	// The recovery availability zone.
	RecoveryAvailabilityZone *string

	// The boot diagnostic storage account.
	RecoveryBootDiagStorageAccount StorageAccountCustomDetailsClassification

	// The recovery proximity placement group custom input.
	RecoveryProximityPlacementGroupCustomInput RecoveryProximityPlacementGroupCustomDetailsClassification

	// The recovery virtual network input.
	RecoveryVirtualNetworkCustomInput RecoveryVirtualNetworkCustomDetailsClassification

	// The list of vm disk inputs.
	VMDisks []*A2AProtectionIntentDiskInputDetails

	// The list of vm managed disk inputs.
	VMManagedDisks []*A2AProtectionIntentManagedDiskInputDetails
}

// GetCreateProtectionIntentProviderSpecificDetails implements the CreateProtectionIntentProviderSpecificDetailsClassification
// interface for type A2ACreateProtectionIntentInput.
func (a *A2ACreateProtectionIntentInput) GetCreateProtectionIntentProviderSpecificDetails() *CreateProtectionIntentProviderSpecificDetails {
	return &CreateProtectionIntentProviderSpecificDetails{
		InstanceType: a.InstanceType,
	}
}

// A2ACrossClusterMigrationApplyRecoveryPointInput - ApplyRecoveryPoint input specific to A2ACrossClusterMigration provider.
type A2ACrossClusterMigrationApplyRecoveryPointInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetApplyRecoveryPointProviderSpecificInput implements the ApplyRecoveryPointProviderSpecificInputClassification interface
// for type A2ACrossClusterMigrationApplyRecoveryPointInput.
func (a *A2ACrossClusterMigrationApplyRecoveryPointInput) GetApplyRecoveryPointProviderSpecificInput() *ApplyRecoveryPointProviderSpecificInput {
	return &ApplyRecoveryPointProviderSpecificInput{
		InstanceType: a.InstanceType,
	}
}

// A2ACrossClusterMigrationContainerCreationInput - A2ACrossClusterMigration cloud creation input.
type A2ACrossClusterMigrationContainerCreationInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetReplicationProviderSpecificContainerCreationInput implements the ReplicationProviderSpecificContainerCreationInputClassification
// interface for type A2ACrossClusterMigrationContainerCreationInput.
func (a *A2ACrossClusterMigrationContainerCreationInput) GetReplicationProviderSpecificContainerCreationInput() *ReplicationProviderSpecificContainerCreationInput {
	return &ReplicationProviderSpecificContainerCreationInput{
		InstanceType: a.InstanceType,
	}
}

// A2ACrossClusterMigrationEnableProtectionInput - A2A Cross-Cluster Migration enable protection input.
type A2ACrossClusterMigrationEnableProtectionInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// The fabric specific object Id of the virtual machine.
	FabricObjectID *string

	// The recovery container Id.
	RecoveryContainerID *string
}

// GetEnableProtectionProviderSpecificInput implements the EnableProtectionProviderSpecificInputClassification interface for
// type A2ACrossClusterMigrationEnableProtectionInput.
func (a *A2ACrossClusterMigrationEnableProtectionInput) GetEnableProtectionProviderSpecificInput() *EnableProtectionProviderSpecificInput {
	return &EnableProtectionProviderSpecificInput{
		InstanceType: a.InstanceType,
	}
}

// A2ACrossClusterMigrationPolicyCreationInput - A2A Cross-Cluster Migration Policy creation input.
type A2ACrossClusterMigrationPolicyCreationInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetPolicyProviderSpecificInput implements the PolicyProviderSpecificInputClassification interface for type A2ACrossClusterMigrationPolicyCreationInput.
func (a *A2ACrossClusterMigrationPolicyCreationInput) GetPolicyProviderSpecificInput() *PolicyProviderSpecificInput {
	return &PolicyProviderSpecificInput{
		InstanceType: a.InstanceType,
	}
}

// A2ACrossClusterMigrationReplicationDetails - A2A provider specific settings.
type A2ACrossClusterMigrationReplicationDetails struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string

	// The fabric specific object Id of the virtual machine.
	FabricObjectID *string

	// An id associated with the PE that survives actions like switch protection which change the backing PE/CPE objects internally.The
	// lifecycle id gets carried forward to have a link/continuity in being
	// able to have an Id that denotes the "same" protected item even though other internal Ids/ARM Id might be changing.
	LifecycleID *string

	// The type of operating system.
	OSType *string

	// Primary fabric location.
	PrimaryFabricLocation *string

	// The protection state for the vm.
	VMProtectionState *string

	// The protection state description for the vm.
	VMProtectionStateDescription *string
}

// GetReplicationProviderSpecificSettings implements the ReplicationProviderSpecificSettingsClassification interface for type
// A2ACrossClusterMigrationReplicationDetails.
func (a *A2ACrossClusterMigrationReplicationDetails) GetReplicationProviderSpecificSettings() *ReplicationProviderSpecificSettings {
	return &ReplicationProviderSpecificSettings{
		InstanceType: a.InstanceType,
	}
}

// A2AEnableProtectionInput - A2A enable protection input.
type A2AEnableProtectionInput struct {
	// REQUIRED; The fabric specific object Id of the virtual machine.
	FabricObjectID *string

	// REQUIRED; The class type.
	InstanceType *string

	// The recovery disk encryption information (for two pass flows).
	DiskEncryptionInfo *DiskEncryptionInfo

	// The multi vm group id.
	MultiVMGroupID *string

	// The multi vm group name.
	MultiVMGroupName *string

	// The recovery availability set Id.
	RecoveryAvailabilitySetID *string

	// The recovery availability zone.
	RecoveryAvailabilityZone *string

	// The recovery Azure virtual network ARM id.
	RecoveryAzureNetworkID *string

	// The boot diagnostic storage account.
	RecoveryBootDiagStorageAccountID *string

	// The recovery capacity reservation group Id.
	RecoveryCapacityReservationGroupID *string

	// The recovery cloud service Id. Valid for V1 scenarios.
	RecoveryCloudServiceID *string

	// The recovery container Id.
	RecoveryContainerID *string

	// The recovery extended location.
	RecoveryExtendedLocation *ExtendedLocation

	// The recovery proximity placement group Id.
	RecoveryProximityPlacementGroupID *string

	// The recovery resource group Id. Valid for V2 scenarios.
	RecoveryResourceGroupID *string

	// The recovery subnet name.
	RecoverySubnetName *string

	// The virtual machine scale set Id.
	RecoveryVirtualMachineScaleSetID *string

	// The list of vm disk details.
	VMDisks []*A2AVMDiskInputDetails

	// The list of vm managed disk details.
	VMManagedDisks []*A2AVMManagedDiskInputDetails
}

// GetEnableProtectionProviderSpecificInput implements the EnableProtectionProviderSpecificInputClassification interface for
// type A2AEnableProtectionInput.
func (a *A2AEnableProtectionInput) GetEnableProtectionProviderSpecificInput() *EnableProtectionProviderSpecificInput {
	return &EnableProtectionProviderSpecificInput{
		InstanceType: a.InstanceType,
	}
}

// A2AEventDetails - Model class for event details of a A2A event.
type A2AEventDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// The fabric location.
	FabricLocation *string

	// Fabric arm name.
	FabricName *string

	// The azure vm arm id.
	FabricObjectID *string

	// The protected item arm name.
	ProtectedItemName *string

	// Remote fabric location.
	RemoteFabricLocation *string

	// Remote fabric arm name.
	RemoteFabricName *string
}

// GetEventProviderSpecificDetails implements the EventProviderSpecificDetailsClassification interface for type A2AEventDetails.
func (a *A2AEventDetails) GetEventProviderSpecificDetails() *EventProviderSpecificDetails {
	return &EventProviderSpecificDetails{
		InstanceType: a.InstanceType,
	}
}

// A2AExtendedLocationDetails - ExtendedLocation details data.
type A2AExtendedLocationDetails struct {
	// The primary ExtendedLocation.
	PrimaryExtendedLocation *ExtendedLocation

	// The recovery ExtendedLocation.
	RecoveryExtendedLocation *ExtendedLocation
}

// A2AFabricSpecificLocationDetails - ExtendedLocation details data.
type A2AFabricSpecificLocationDetails struct {
	// The initial primary ExtendedLocation.
	InitialPrimaryExtendedLocation *ExtendedLocation

	// Initial primary fabric location info.
	InitialPrimaryFabricLocation *string

	// The initial source zone info.
	InitialPrimaryZone *string

	// The initial recovery ExtendedLocation.
	InitialRecoveryExtendedLocation *ExtendedLocation

	// The initial recovery fabric location info.
	InitialRecoveryFabricLocation *string

	// The initial target zone info.
	InitialRecoveryZone *string

	// The primary ExtendedLocation.
	PrimaryExtendedLocation *ExtendedLocation

	// Primary fabric location info.
	PrimaryFabricLocation *string

	// Source zone info.
	PrimaryZone *string

	// The recovery ExtendedLocation.
	RecoveryExtendedLocation *ExtendedLocation

	// The recovery fabric location info.
	RecoveryFabricLocation *string

	// The target zone info.
	RecoveryZone *string
}

// A2APolicyCreationInput - A2A Policy creation input.
type A2APolicyCreationInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// REQUIRED; A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'.
	MultiVMSyncStatus *SetMultiVMSyncStatus

	// The app consistent snapshot frequency (in minutes).
	AppConsistentFrequencyInMinutes *int32

	// The crash consistent snapshot frequency (in minutes).
	CrashConsistentFrequencyInMinutes *int32

	// The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32
}

// GetPolicyProviderSpecificInput implements the PolicyProviderSpecificInputClassification interface for type A2APolicyCreationInput.
func (a *A2APolicyCreationInput) GetPolicyProviderSpecificInput() *PolicyProviderSpecificInput {
	return &PolicyProviderSpecificInput{
		InstanceType: a.InstanceType,
	}
}

// A2APolicyDetails - A2A specific policy details.
type A2APolicyDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// The app consistent snapshot frequency in minutes.
	AppConsistentFrequencyInMinutes *int32

	// The crash consistent snapshot frequency in minutes.
	CrashConsistentFrequencyInMinutes *int32

	// A value indicating whether multi-VM sync has to be enabled.
	MultiVMSyncStatus *string

	// The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32

	// The recovery point threshold in minutes.
	RecoveryPointThresholdInMinutes *int32
}

// GetPolicyProviderSpecificDetails implements the PolicyProviderSpecificDetailsClassification interface for type A2APolicyDetails.
func (a *A2APolicyDetails) GetPolicyProviderSpecificDetails() *PolicyProviderSpecificDetails {
	return &PolicyProviderSpecificDetails{
		InstanceType: a.InstanceType,
	}
}

// A2AProtectedDiskDetails - A2A protected disk details.
type A2AProtectedDiskDetails struct {
	// The disk level operations list.
	AllowedDiskLevelOperation []*string

	// The data pending at source virtual machine in MB.
	DataPendingAtSourceAgentInMB *float64

	// The data pending for replication in MB at staging account.
	DataPendingInStagingStorageAccountInMB *float64

	// The KeyVault resource id for secret (BEK).
	DekKeyVaultArmID *string

	// The disk capacity in bytes.
	DiskCapacityInBytes *int64

	// The disk name.
	DiskName *string

	// The disk state.
	DiskState *string

	// The type of disk.
	DiskType *string

	// The disk uri.
	DiskURI *string

	// The failover name for the managed disk.
	FailoverDiskName *string

	// A value indicating whether vm has encrypted os disk or not.
	IsDiskEncrypted *bool

	// A value indicating whether disk key got encrypted or not.
	IsDiskKeyEncrypted *bool

	// The KeyVault resource id for key (KEK).
	KekKeyVaultArmID *string

	// The key URL / identifier (KEK).
	KeyIdentifier *string

	// The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property.
	MonitoringJobType *string

	// The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property.
	MonitoringPercentageCompletion *int32

	// The primary disk storage account.
	PrimaryDiskAzureStorageAccountID *string

	// The primary staging storage account.
	PrimaryStagingAzureStorageAccountID *string

	// The recovery disk storage account.
	RecoveryAzureStorageAccountID *string

	// Recovery disk uri.
	RecoveryDiskURI *string

	// A value indicating whether resync is required for this disk.
	ResyncRequired *bool

	// The secret URL / identifier (BEK).
	SecretIdentifier *string

	// The test failover name for the managed disk.
	TfoDiskName *string
}

// A2AProtectedManagedDiskDetails - A2A protected managed disk details.
type A2AProtectedManagedDiskDetails struct {
	// The disk level operations list.
	AllowedDiskLevelOperation []*string

	// The data pending at source virtual machine in MB.
	DataPendingAtSourceAgentInMB *float64

	// The data pending for replication in MB at staging account.
	DataPendingInStagingStorageAccountInMB *float64

	// The KeyVault resource id for secret (BEK).
	DekKeyVaultArmID *string

	// The disk capacity in bytes.
	DiskCapacityInBytes *int64

	// The managed disk Arm id.
	DiskID *string

	// The disk name.
	DiskName *string

	// The disk state.
	DiskState *string

	// The type of disk.
	DiskType *string

	// The failover name for the managed disk.
	FailoverDiskName *string

	// A value indicating whether vm has encrypted os disk or not.
	IsDiskEncrypted *bool

	// A value indicating whether disk key got encrypted or not.
	IsDiskKeyEncrypted *bool

	// The KeyVault resource id for key (KEK).
	KekKeyVaultArmID *string

	// The key URL / identifier (KEK).
	KeyIdentifier *string

	// The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property.
	MonitoringJobType *string

	// The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property.
	MonitoringPercentageCompletion *int32

	// The primary disk encryption set Id.
	PrimaryDiskEncryptionSetID *string

	// The primary staging storage account.
	PrimaryStagingAzureStorageAccountID *string

	// The recovery disk encryption set Id.
	RecoveryDiskEncryptionSetID *string

	// Recovery original target disk Arm Id.
	RecoveryOrignalTargetDiskID *string

	// The replica disk type. Its an optional value and will be same as source disk type if not user provided.
	RecoveryReplicaDiskAccountType *string

	// Recovery replica disk Arm Id.
	RecoveryReplicaDiskID *string

	// The recovery disk resource group Arm Id.
	RecoveryResourceGroupID *string

	// The target disk type after failover. Its an optional value and will be same as source disk type if not user provided.
	RecoveryTargetDiskAccountType *string

	// Recovery target disk Arm Id.
	RecoveryTargetDiskID *string

	// A value indicating whether resync is required for this disk.
	ResyncRequired *bool

	// The secret URL / identifier (BEK).
	SecretIdentifier *string

	// The test failover name for the managed disk.
	TfoDiskName *string
}

// A2AProtectionContainerMappingDetails - A2A provider specific settings.
type A2AProtectionContainerMappingDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// A value indicating whether the auto update is enabled.
	AgentAutoUpdateStatus *AgentAutoUpdateStatus

	// The automation account arm id.
	AutomationAccountArmID *string

	// A value indicating the type authentication to use for automation Account.
	AutomationAccountAuthenticationType *AutomationAccountAuthenticationType

	// The job schedule arm name.
	JobScheduleName *string

	// The schedule arm name.
	ScheduleName *string
}

// GetProtectionContainerMappingProviderSpecificDetails implements the ProtectionContainerMappingProviderSpecificDetailsClassification
// interface for type A2AProtectionContainerMappingDetails.
func (a *A2AProtectionContainerMappingDetails) GetProtectionContainerMappingProviderSpecificDetails() *ProtectionContainerMappingProviderSpecificDetails {
	return &ProtectionContainerMappingProviderSpecificDetails{
		InstanceType: a.InstanceType,
	}
}

// A2AProtectionIntentDiskInputDetails - Azure VM unmanaged disk input details.
type A2AProtectionIntentDiskInputDetails struct {
	// REQUIRED; The disk Uri.
	DiskURI *string

	// The primary staging storage account input.
	PrimaryStagingStorageAccountCustomInput StorageAccountCustomDetailsClassification

	// The recovery VHD storage account input.
	RecoveryAzureStorageAccountCustomInput StorageAccountCustomDetailsClassification
}

// A2AProtectionIntentManagedDiskInputDetails - Azure VM managed disk input details.
type A2AProtectionIntentManagedDiskInputDetails struct {
	// REQUIRED; The disk Id.
	DiskID *string

	// The recovery disk encryption information (for one / single pass flows).
	DiskEncryptionInfo *DiskEncryptionInfo

	// The primary staging storage account input.
	PrimaryStagingStorageAccountCustomInput StorageAccountCustomDetailsClassification

	// The recovery disk encryption set Id.
	RecoveryDiskEncryptionSetID *string

	// The replica disk type. Its an optional value and will be same as source disk type if not user provided.
	RecoveryReplicaDiskAccountType *string

	// The recovery resource group input.
	RecoveryResourceGroupCustomInput RecoveryResourceGroupCustomDetailsClassification

	// The target disk type after failover. Its an optional value and will be same as source disk type if not user provided.
	RecoveryTargetDiskAccountType *string
}

// A2ARecoveryPointDetails - A2A provider specific recovery point details.
type A2ARecoveryPointDetails struct {
	// REQUIRED; Gets the provider type.
	InstanceType *string

	// List of disk ids representing a recovery point.
	Disks []*string

	// A value indicating whether the recovery point is multi VM consistent.
	RecoveryPointSyncType *RecoveryPointSyncType
}

// GetProviderSpecificRecoveryPointDetails implements the ProviderSpecificRecoveryPointDetailsClassification interface for
// type A2ARecoveryPointDetails.
func (a *A2ARecoveryPointDetails) GetProviderSpecificRecoveryPointDetails() *ProviderSpecificRecoveryPointDetails {
	return &ProviderSpecificRecoveryPointDetails{
		InstanceType: a.InstanceType,
	}
}

// A2ARemoveDisksInput - A2A remove disk(s) input.
type A2ARemoveDisksInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// The list of vm disk vhd URIs.
	VMDisksUris []*string

	// The list of vm managed disk Ids.
	VMManagedDisksIDs []*string
}

// GetRemoveDisksProviderSpecificInput implements the RemoveDisksProviderSpecificInputClassification interface for type A2ARemoveDisksInput.
func (a *A2ARemoveDisksInput) GetRemoveDisksProviderSpecificInput() *RemoveDisksProviderSpecificInput {
	return &RemoveDisksProviderSpecificInput{
		InstanceType: a.InstanceType,
	}
}

// A2AReplicationDetails - A2A provider specific settings.
type A2AReplicationDetails struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string

	// Agent expiry date.
	AgentExpiryDate *time.Time

	// The agent version.
	AgentVersion *string

	// A value indicating whether the auto protection is enabled.
	AutoProtectionOfDataDisk *AutoProtectionOfDataDisk

	// The fabric specific object Id of the virtual machine.
	FabricObjectID *string

	// The initial primary extended location.
	InitialPrimaryExtendedLocation *ExtendedLocation

	// The initial recovery extended location.
	InitialRecoveryExtendedLocation *ExtendedLocation

	// A value indicating whether agent certificate update is required.
	IsReplicationAgentCertificateUpdateRequired *bool

	// A value indicating whether replication agent update is required.
	IsReplicationAgentUpdateRequired *bool

	// The last heartbeat received from the source server.
	LastHeartbeat *time.Time

	// The time (in UTC) when the last RPO value was calculated by Protection Service.
	LastRpoCalculatedTime *time.Time

	// An id associated with the PE that survives actions like switch protection which change the backing PE/CPE objects internally.The
	// lifecycle id gets carried forward to have a link/continuity in being
	// able to have an Id that denotes the "same" protected item even though other internal Ids/ARM Id might be changing.
	LifecycleID *string

	// The management Id.
	ManagementID *string

	// The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property.
	MonitoringJobType *string

	// The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property.
	MonitoringPercentageCompletion *int32

	// Whether Multi VM group is auto created or specified by user.
	MultiVMGroupCreateOption *MultiVMGroupCreateOption

	// The multi vm group Id.
	MultiVMGroupID *string

	// The multi vm group name.
	MultiVMGroupName *string

	// The type of operating system.
	OSType *string

	// The primary availability zone.
	PrimaryAvailabilityZone *string

	// The primary Extended Location.
	PrimaryExtendedLocation *ExtendedLocation

	// Primary fabric location.
	PrimaryFabricLocation *string

	// The list of protected disks.
	ProtectedDisks []*A2AProtectedDiskDetails

	// The list of protected managed disks.
	ProtectedManagedDisks []*A2AProtectedManagedDiskDetails

	// The recovery availability set.
	RecoveryAvailabilitySet *string

	// The recovery availability zone.
	RecoveryAvailabilityZone *string

	// The recovery resource group.
	RecoveryAzureResourceGroupID *string

	// The name of recovery virtual machine.
	RecoveryAzureVMName *string

	// The size of recovery virtual machine.
	RecoveryAzureVMSize *string

	// The recovery boot diagnostic storage account Arm Id.
	RecoveryBootDiagStorageAccountID *string

	// The recovery capacity reservation group Id.
	RecoveryCapacityReservationGroupID *string

	// The recovery cloud service.
	RecoveryCloudService *string

	// The recovery Extended Location.
	RecoveryExtendedLocation *ExtendedLocation

	// The recovery fabric location.
	RecoveryFabricLocation *string

	// The recovery fabric object Id.
	RecoveryFabricObjectID *string

	// The recovery proximity placement group Id.
	RecoveryProximityPlacementGroupID *string

	// The recovery virtual machine scale set id.
	RecoveryVirtualMachineScaleSetID *string

	// The last RPO value in seconds.
	RpoInSeconds *int64

	// The recovery virtual network.
	SelectedRecoveryAzureNetworkID *string

	// The test failover virtual network.
	SelectedTfoAzureNetworkID *string

	// The test failover fabric object Id.
	TestFailoverRecoveryFabricObjectID *string

	// The test failover vm name.
	TfoAzureVMName *string

	// The list of unprotected disks.
	UnprotectedDisks []*A2AUnprotectedDiskDetails

	// The virtual machine nic details.
	VMNics []*VMNicDetails

	// The protection state for the vm.
	VMProtectionState *string

	// The protection state description for the vm.
	VMProtectionStateDescription *string

	// The synced configuration details.
	VMSyncedConfigDetails *AzureToAzureVMSyncedConfigDetails

	// READ-ONLY; Agent certificate expiry date.
	AgentCertificateExpiryDate *time.Time

	// READ-ONLY; A value indicating the churn option selected by user.
	ChurnOptionSelected *ChurnOptionSelected

	// READ-ONLY; The initial primary fabric location.
	InitialPrimaryFabricLocation *string

	// READ-ONLY; The initial primary availability zone.
	InitialPrimaryZone *string

	// READ-ONLY; The initial recovery fabric location.
	InitialRecoveryFabricLocation *string

	// READ-ONLY; The initial recovery availability zone.
	InitialRecoveryZone *string

	// READ-ONLY; The recovery azure generation.
	RecoveryAzureGeneration *string

	// READ-ONLY; The encryption type of the VM.
	VMEncryptionType *VMEncryptionType
}

// GetReplicationProviderSpecificSettings implements the ReplicationProviderSpecificSettingsClassification interface for type
// A2AReplicationDetails.
func (a *A2AReplicationDetails) GetReplicationProviderSpecificSettings() *ReplicationProviderSpecificSettings {
	return &ReplicationProviderSpecificSettings{
		InstanceType: a.InstanceType,
	}
}

// A2AReplicationIntentDetails - A2A provider specific settings.
type A2AReplicationIntentDetails struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string

	// REQUIRED; The recovery availability type of the virtual machine.
	RecoveryAvailabilityType *string

	// A value indicating whether the auto update is enabled.
	AgentAutoUpdateStatus *AgentAutoUpdateStatus

	// A value indicating whether the auto protection is enabled.
	AutoProtectionOfDataDisk *AutoProtectionOfDataDisk

	// The automation account arm id.
	AutomationAccountArmID *string

	// A value indicating the type authentication to use for automation Account.
	AutomationAccountAuthenticationType *AutomationAccountAuthenticationType

	// The recovery disk encryption information (for two pass flows).
	DiskEncryptionInfo *DiskEncryptionInfo

	// The fabric specific object Id of the virtual machine.
	FabricObjectID *string

	// The multi vm group id.
	MultiVMGroupID *string

	// The multi vm group name.
	MultiVMGroupName *string

	// The primary location for the virtual machine.
	PrimaryLocation *string

	// The primary staging storage account details.
	PrimaryStagingStorageAccount StorageAccountCustomDetailsClassification

	// The protection profile custom details.
	ProtectionProfile ProtectionProfileCustomDetailsClassification

	// The recovery availability set details.
	RecoveryAvailabilitySet RecoveryAvailabilitySetCustomDetailsClassification

	// The recovery availability zone.
	RecoveryAvailabilityZone *string

	// The boot diagnostic storage account.
	RecoveryBootDiagStorageAccount StorageAccountCustomDetailsClassification

	// The recovery location for the virtual machine.
	RecoveryLocation *string

	// The recovery proximity placement group custom details.
	RecoveryProximityPlacementGroup RecoveryProximityPlacementGroupCustomDetailsClassification

	// The recovery resource group id.
	RecoveryResourceGroupID *string

	// The recovery subscription Id of the virtual machine.
	RecoverySubscriptionID *string

	// The recovery virtual network details.
	RecoveryVirtualNetwork RecoveryVirtualNetworkCustomDetailsClassification

	// The list of vm disk details.
	VMDisks []*A2AProtectionIntentDiskInputDetails

	// The list of vm managed disk details.
	VMManagedDisks []*A2AProtectionIntentManagedDiskInputDetails
}

// GetReplicationProtectionIntentProviderSpecificSettings implements the ReplicationProtectionIntentProviderSpecificSettingsClassification
// interface for type A2AReplicationIntentDetails.
func (a *A2AReplicationIntentDetails) GetReplicationProtectionIntentProviderSpecificSettings() *ReplicationProtectionIntentProviderSpecificSettings {
	return &ReplicationProtectionIntentProviderSpecificSettings{
		InstanceType: a.InstanceType,
	}
}

// A2AReprotectInput - Azure specific reprotect input.
type A2AReprotectInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// The Policy Id.
	PolicyID *string

	// The recovery availability set.
	RecoveryAvailabilitySetID *string

	// The recovery cloud service Id. Valid for V1 scenarios.
	RecoveryCloudServiceID *string

	// The recovery container Id.
	RecoveryContainerID *string

	// The recovery resource group Id. Valid for V2 scenarios.
	RecoveryResourceGroupID *string

	// The list of vm disk details.
	VMDisks []*A2AVMDiskInputDetails
}

// GetReverseReplicationProviderSpecificInput implements the ReverseReplicationProviderSpecificInputClassification interface
// for type A2AReprotectInput.
func (a *A2AReprotectInput) GetReverseReplicationProviderSpecificInput() *ReverseReplicationProviderSpecificInput {
	return &ReverseReplicationProviderSpecificInput{
		InstanceType: a.InstanceType,
	}
}

// A2ASwitchProtectionInput - A2A specific switch protection input.
type A2ASwitchProtectionInput struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string

	// The recovery disk encryption information.
	DiskEncryptionInfo *DiskEncryptionInfo

	// The Policy Id.
	PolicyID *string

	// The recovery availability set.
	RecoveryAvailabilitySetID *string

	// The recovery availability zone.
	RecoveryAvailabilityZone *string

	// The boot diagnostic storage account.
	RecoveryBootDiagStorageAccountID *string

	// The recovery capacity reservation group Id.
	RecoveryCapacityReservationGroupID *string

	// The recovery cloud service Id. Valid for V1 scenarios.
	RecoveryCloudServiceID *string

	// The recovery container Id.
	RecoveryContainerID *string

	// The recovery proximity placement group Id.
	RecoveryProximityPlacementGroupID *string

	// The recovery resource group Id. Valid for V2 scenarios.
	RecoveryResourceGroupID *string

	// The virtual machine scale set id.
	RecoveryVirtualMachineScaleSetID *string

	// The list of vm disk details.
	VMDisks []*A2AVMDiskInputDetails

	// The list of vm managed disk details.
	VMManagedDisks []*A2AVMManagedDiskInputDetails
}

// GetSwitchProtectionProviderSpecificInput implements the SwitchProtectionProviderSpecificInputClassification interface for
// type A2ASwitchProtectionInput.
func (a *A2ASwitchProtectionInput) GetSwitchProtectionProviderSpecificInput() *SwitchProtectionProviderSpecificInput {
	return &SwitchProtectionProviderSpecificInput{
		InstanceType: a.InstanceType,
	}
}

// A2ATestFailoverInput - A2A provider specific input for test failover.
type A2ATestFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// A value indicating whether to use recovery cloud service for TFO or not.
	CloudServiceCreationOption *string

	// The recovery point id to be passed to test failover to a particular recovery point. In case of latest recovery point, null
	// should be passed.
	RecoveryPointID *string
}

// GetTestFailoverProviderSpecificInput implements the TestFailoverProviderSpecificInputClassification interface for type
// A2ATestFailoverInput.
func (a *A2ATestFailoverInput) GetTestFailoverProviderSpecificInput() *TestFailoverProviderSpecificInput {
	return &TestFailoverProviderSpecificInput{
		InstanceType: a.InstanceType,
	}
}

// A2AUnplannedFailoverInput - A2A provider specific input for unplanned failover.
type A2AUnplannedFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// A value indicating whether to use recovery cloud service for failover or not.
	CloudServiceCreationOption *string

	// The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should
	// be passed.
	RecoveryPointID *string
}

// GetUnplannedFailoverProviderSpecificInput implements the UnplannedFailoverProviderSpecificInputClassification interface
// for type A2AUnplannedFailoverInput.
func (a *A2AUnplannedFailoverInput) GetUnplannedFailoverProviderSpecificInput() *UnplannedFailoverProviderSpecificInput {
	return &UnplannedFailoverProviderSpecificInput{
		InstanceType: a.InstanceType,
	}
}

// A2AUnprotectedDiskDetails - A2A unprotected disk details.
type A2AUnprotectedDiskDetails struct {
	// A value indicating whether the disk auto protection is enabled.
	DiskAutoProtectionStatus *AutoProtectionOfDataDisk

	// The source lun Id for the data disk.
	DiskLunID *int32
}

// A2AUpdateContainerMappingInput - A2A update protection container mapping.
type A2AUpdateContainerMappingInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// A value indicating whether the auto update is enabled.
	AgentAutoUpdateStatus *AgentAutoUpdateStatus

	// The automation account arm id.
	AutomationAccountArmID *string

	// A value indicating the type authentication to use for automation Account.
	AutomationAccountAuthenticationType *AutomationAccountAuthenticationType
}

// GetReplicationProviderSpecificUpdateContainerMappingInput implements the ReplicationProviderSpecificUpdateContainerMappingInputClassification
// interface for type A2AUpdateContainerMappingInput.
func (a *A2AUpdateContainerMappingInput) GetReplicationProviderSpecificUpdateContainerMappingInput() *ReplicationProviderSpecificUpdateContainerMappingInput {
	return &ReplicationProviderSpecificUpdateContainerMappingInput{
		InstanceType: a.InstanceType,
	}
}

// A2AUpdateReplicationProtectedItemInput - InMage Azure V2 input to update replication protected item.
type A2AUpdateReplicationProtectedItemInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// The recovery os disk encryption information.
	DiskEncryptionInfo *DiskEncryptionInfo

	// Managed disk update details.
	ManagedDiskUpdateDetails []*A2AVMManagedDiskUpdateDetails

	// The boot diagnostic storage account.
	RecoveryBootDiagStorageAccountID *string

	// The recovery capacity reservation group Id.
	RecoveryCapacityReservationGroupID *string

	// The target cloud service ARM Id (for V1).
	RecoveryCloudServiceID *string

	// The recovery proximity placement group Id.
	RecoveryProximityPlacementGroupID *string

	// The target resource group ARM Id (for V2).
	RecoveryResourceGroupID *string

	// The recovery virtual machine scale set Id.
	RecoveryVirtualMachineScaleSetID *string

	// The user given name for Test Failover VM.
	TfoAzureVMName *string
}

// GetUpdateReplicationProtectedItemProviderInput implements the UpdateReplicationProtectedItemProviderInputClassification
// interface for type A2AUpdateReplicationProtectedItemInput.
func (a *A2AUpdateReplicationProtectedItemInput) GetUpdateReplicationProtectedItemProviderInput() *UpdateReplicationProtectedItemProviderInput {
	return &UpdateReplicationProtectedItemProviderInput{
		InstanceType: a.InstanceType,
	}
}

// A2AVMDiskInputDetails - A2A disk input details.
type A2AVMDiskInputDetails struct {
	// REQUIRED; The disk Uri.
	DiskURI *string

	// REQUIRED; The primary staging storage account Id.
	PrimaryStagingAzureStorageAccountID *string

	// REQUIRED; The recovery VHD storage account Id.
	RecoveryAzureStorageAccountID *string
}

// A2AVMManagedDiskInputDetails - A2A managed disk input details.
type A2AVMManagedDiskInputDetails struct {
	// REQUIRED; The disk Id.
	DiskID *string

	// REQUIRED; The primary staging storage account Arm Id.
	PrimaryStagingAzureStorageAccountID *string

	// REQUIRED; The target resource group Arm Id.
	RecoveryResourceGroupID *string

	// The recovery disk encryption information (for one / single pass flows).
	DiskEncryptionInfo *DiskEncryptionInfo

	// The recovery disk encryption set Id.
	RecoveryDiskEncryptionSetID *string

	// The replica disk type. Its an optional value and will be same as source disk type if not user provided.
	RecoveryReplicaDiskAccountType *string

	// The target disk type after failover. Its an optional value and will be same as source disk type if not user provided.
	RecoveryTargetDiskAccountType *string
}

// A2AVMManagedDiskUpdateDetails - A2A Vm managed disk update details.
type A2AVMManagedDiskUpdateDetails struct {
	// The recovery os disk encryption information.
	DiskEncryptionInfo *DiskEncryptionInfo

	// The disk Id.
	DiskID *string

	// The target disk name for unplanned failover operation.
	FailoverDiskName *string

	// The replica disk type before failover.
	RecoveryReplicaDiskAccountType *string

	// The target disk type before failover.
	RecoveryTargetDiskAccountType *string

	// The target disk name for test failover operation.
	TfoDiskName *string
}

// A2AZoneDetails - Zone details data.
type A2AZoneDetails struct {
	// Source zone info.
	Source *string

	// The target zone info.
	Target *string
}

// ASRTask - Task of the Job.
type ASRTask struct {
	// The state/actions applicable on this task.
	AllowedActions []*string

	// The custom task details based on the task type.
	CustomDetails TaskTypeDetailsClassification

	// The end time.
	EndTime *time.Time

	// The task error details.
	Errors []*JobErrorDetails

	// The name.
	FriendlyName *string

	// The custom task details based on the task type, if the task type is GroupTaskDetails or one of the types derived from it.
	GroupTaskCustomDetails GroupTaskDetailsClassification

	// The unique Task name.
	Name *string

	// The start time.
	StartTime *time.Time

	// The State. It is one of these values - NotStarted, InProgress, Succeeded, Failed, Cancelled, Suspended or Other.
	State *string

	// The description of the task state. For example - For Succeeded state, description can be Completed, PartiallySucceeded,
	// CompletedWithInformation or Skipped.
	StateDescription *string

	// The Id.
	TaskID *string

	// The type of task. Details in CustomDetails property depend on this type.
	TaskType *string
}

// AddDisksInput - Input for add disk(s) operation.
type AddDisksInput struct {
	// Add disks input properties.
	Properties *AddDisksInputProperties
}

// AddDisksInputProperties - Add Disks input properties.
type AddDisksInputProperties struct {
	// REQUIRED; The ReplicationProviderInput. For HyperVReplicaAzure provider, it will be AzureEnableProtectionInput object.
	// For San provider, it will be SanEnableProtectionInput object. For HyperVReplicaAzure
	// provider, it can be null.
	ProviderSpecificDetails AddDisksProviderSpecificInputClassification
}

// AddDisksProviderSpecificInput - Add Disks provider specific input.
type AddDisksProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetAddDisksProviderSpecificInput implements the AddDisksProviderSpecificInputClassification interface for type AddDisksProviderSpecificInput.
func (a *AddDisksProviderSpecificInput) GetAddDisksProviderSpecificInput() *AddDisksProviderSpecificInput {
	return a
}

// AddRecoveryServicesProviderInput - Input required to add a provider.
type AddRecoveryServicesProviderInput struct {
	// REQUIRED; The properties of an add provider request.
	Properties *AddRecoveryServicesProviderInputProperties
}

// AddRecoveryServicesProviderInputProperties - The properties of an add provider request.
type AddRecoveryServicesProviderInputProperties struct {
	// REQUIRED; The identity provider input for DRA authentication.
	AuthenticationIdentityInput *IdentityProviderInput

	// REQUIRED; The name of the machine where the provider is getting added.
	MachineName *string

	// REQUIRED; The identity provider input for resource access.
	ResourceAccessIdentityInput *IdentityProviderInput

	// The Bios Id of the machine.
	BiosID *string

	// The identity provider input for data plane authentication.
	DataPlaneAuthenticationIdentityInput *IdentityProviderInput

	// The Id of the machine where the provider is getting added.
	MachineID *string
}

// AddVCenterRequest - Input required to add vCenter.
type AddVCenterRequest struct {
	// The properties of an add vCenter request.
	Properties *AddVCenterRequestProperties
}

// AddVCenterRequestProperties - The properties of an add vCenter request.
type AddVCenterRequestProperties struct {
	// The friendly name of the vCenter.
	FriendlyName *string

	// The IP address of the vCenter to be discovered.
	IPAddress *string

	// The port number for discovery.
	Port *string

	// The process server Id from where the discovery is orchestrated.
	ProcessServerID *string

	// The account Id which has privileges to discover the vCenter.
	RunAsAccountID *string
}

// AgentDetails - Agent details.
type AgentDetails struct {
	// READ-ONLY; The Id of the agent running on the server.
	AgentID *string

	// READ-ONLY; The machine BIOS Id.
	BiosID *string

	// READ-ONLY; The disks.
	Disks []*AgentDiskDetails

	// READ-ONLY; The machine FQDN.
	Fqdn *string

	// READ-ONLY; The Id of the machine to which the agent is registered.
	MachineID *string
}

// AgentDiskDetails - Agent disk details.
type AgentDiskDetails struct {
	// READ-ONLY; The disk capacity in bytes.
	CapacityInBytes *int64

	// READ-ONLY; The disk Id.
	DiskID *string

	// READ-ONLY; The disk name.
	DiskName *string

	// READ-ONLY; A value indicating whether the disk is the OS disk.
	IsOSDisk *string

	// READ-ONLY; The lun of disk.
	LunID *int32
}

// Alert - Implements the Alert class.
type Alert struct {
	// Resource Location
	Location *string

	// Alert related data.
	Properties *AlertProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource Name
	Name *string

	// READ-ONLY; Resource Type
	Type *string
}

// AlertCollection - Collection of alerts.
type AlertCollection struct {
	// The value of next link.
	NextLink *string

	// The list of alerts.
	Value []*Alert
}

// AlertProperties - The properties of an alert.
type AlertProperties struct {
	// The custom email address for sending emails.
	CustomEmailAddresses []*string

	// The locale for the email notification.
	Locale *string

	// A value indicating whether to send email to subscription administrator.
	SendToOwners *string
}

// ApplianceCollection - Collection of appliance details.
type ApplianceCollection struct {
	// The value of next link.
	NextLink *string

	// The appliance details.
	Value []*ReplicationAppliance
}

// ApplianceMonitoringDetails - Appliance details of the migration item.
type ApplianceMonitoringDetails struct {
	// READ-ONLY; The appliance CPU details.
	CPUDetails *ApplianceResourceDetails

	// READ-ONLY; The appliance datastore snapshot details.
	DatastoreSnapshot []*DataStoreUtilizationDetails

	// READ-ONLY; The disk replication details.
	DisksReplicationDetails *ApplianceResourceDetails

	// READ-ONLY; The ESXi NFC buffer details.
	EsxiNfcBuffer *ApplianceResourceDetails

	// READ-ONLY; The appliance network bandwidth details.
	NetworkBandwidth *ApplianceResourceDetails

	// READ-ONLY; The appliance RAM details.
	RAMDetails *ApplianceResourceDetails
}

// ApplianceQueryParameter - Query parameter to get appliance.
type ApplianceQueryParameter struct {
	// The providerType to be used for fetching appliance details.
	ProviderType *string
}

// ApplianceResourceDetails - Details of the appliance resource.
type ApplianceResourceDetails struct {
	// READ-ONLY; A value indicating the total capacity of appliance resource.
	Capacity *int64

	// READ-ONLY; A value indicating the utilization percentage by gateway agent on appliance.
	ProcessUtilization *float64

	// READ-ONLY; A value indicating the status of appliance resource.
	Status *string

	// READ-ONLY; A value indicating the total utilization percentage for all processes on the appliance.
	TotalUtilization *float64
}

// ApplianceSpecificDetails - Appliance specific details.
type ApplianceSpecificDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string
}

// GetApplianceSpecificDetails implements the ApplianceSpecificDetailsClassification interface for type ApplianceSpecificDetails.
func (a *ApplianceSpecificDetails) GetApplianceSpecificDetails() *ApplianceSpecificDetails { return a }

// ApplyRecoveryPointInput - Input to apply recovery point.
type ApplyRecoveryPointInput struct {
	// REQUIRED; The input properties to apply recovery point.
	Properties *ApplyRecoveryPointInputProperties
}

// ApplyRecoveryPointInputProperties - Input properties to apply recovery point.
type ApplyRecoveryPointInputProperties struct {
	// REQUIRED; Provider specific input for applying recovery point.
	ProviderSpecificDetails ApplyRecoveryPointProviderSpecificInputClassification

	// The recovery point Id.
	RecoveryPointID *string
}

// ApplyRecoveryPointProviderSpecificInput - Provider specific input for apply recovery point.
type ApplyRecoveryPointProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetApplyRecoveryPointProviderSpecificInput implements the ApplyRecoveryPointProviderSpecificInputClassification interface
// for type ApplyRecoveryPointProviderSpecificInput.
func (a *ApplyRecoveryPointProviderSpecificInput) GetApplyRecoveryPointProviderSpecificInput() *ApplyRecoveryPointProviderSpecificInput {
	return a
}

// AsrJobDetails - This class represents job details based on specific job type.
type AsrJobDetails struct {
	// REQUIRED; Gets the type of job details (see JobDetailsTypes enum for possible values).
	InstanceType *string

	// The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow
	// object details.
	AffectedObjectDetails map[string]*string
}

// GetJobDetails implements the JobDetailsClassification interface for type AsrJobDetails.
func (a *AsrJobDetails) GetJobDetails() *JobDetails {
	return &JobDetails{
		AffectedObjectDetails: a.AffectedObjectDetails,
		InstanceType:          a.InstanceType,
	}
}

// AutomationRunbookTaskDetails - This class represents the task details for an automation runbook.
type AutomationRunbookTaskDetails struct {
	// REQUIRED; The type of task details.
	InstanceType *string

	// The automation account name of the runbook.
	AccountName *string

	// The cloud service of the automation runbook account.
	CloudServiceName *string

	// A value indicating whether it is a primary side script or not.
	IsPrimarySideScript *bool

	// The job Id of the runbook execution.
	JobID *string

	// The execution output of the runbook.
	JobOutput *string

	// The recovery plan task name.
	Name *string

	// The runbook Id.
	RunbookID *string

	// The runbook name.
	RunbookName *string

	// The subscription Id of the automation runbook account.
	SubscriptionID *string
}

// GetTaskTypeDetails implements the TaskTypeDetailsClassification interface for type AutomationRunbookTaskDetails.
func (a *AutomationRunbookTaskDetails) GetTaskTypeDetails() *TaskTypeDetails {
	return &TaskTypeDetails{
		InstanceType: a.InstanceType,
	}
}

// AzureFabricCreationInput - Fabric provider specific settings.
type AzureFabricCreationInput struct {
	// REQUIRED; Gets the class type.
	InstanceType *string

	// The Location.
	Location *string
}

// GetFabricSpecificCreationInput implements the FabricSpecificCreationInputClassification interface for type AzureFabricCreationInput.
func (a *AzureFabricCreationInput) GetFabricSpecificCreationInput() *FabricSpecificCreationInput {
	return &FabricSpecificCreationInput{
		InstanceType: a.InstanceType,
	}
}

// AzureFabricSpecificDetails - Azure Fabric Specific Details.
type AzureFabricSpecificDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// The container Ids for the Azure fabric.
	ContainerIDs []*string

	// The ExtendedLocations.
	ExtendedLocations []*A2AExtendedLocationDetails

	// The Location for the Azure fabric.
	Location *string

	// The location details.
	LocationDetails []*A2AFabricSpecificLocationDetails

	// The zones.
	Zones []*A2AZoneDetails
}

// GetFabricSpecificDetails implements the FabricSpecificDetailsClassification interface for type AzureFabricSpecificDetails.
func (a *AzureFabricSpecificDetails) GetFabricSpecificDetails() *FabricSpecificDetails {
	return &FabricSpecificDetails{
		InstanceType: a.InstanceType,
	}
}

// AzureToAzureCreateNetworkMappingInput - Create network mappings input properties/behavior specific to Azure to Azure Network
// mapping.
type AzureToAzureCreateNetworkMappingInput struct {
	// REQUIRED; The instance type.
	InstanceType *string

	// REQUIRED; The primary azure vnet Id.
	PrimaryNetworkID *string
}

// GetFabricSpecificCreateNetworkMappingInput implements the FabricSpecificCreateNetworkMappingInputClassification interface
// for type AzureToAzureCreateNetworkMappingInput.
func (a *AzureToAzureCreateNetworkMappingInput) GetFabricSpecificCreateNetworkMappingInput() *FabricSpecificCreateNetworkMappingInput {
	return &FabricSpecificCreateNetworkMappingInput{
		InstanceType: a.InstanceType,
	}
}

// AzureToAzureNetworkMappingSettings - A2A Network Mapping fabric specific settings.
type AzureToAzureNetworkMappingSettings struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string

	// The primary fabric location.
	PrimaryFabricLocation *string

	// The recovery fabric location.
	RecoveryFabricLocation *string
}

// GetNetworkMappingFabricSpecificSettings implements the NetworkMappingFabricSpecificSettingsClassification interface for
// type AzureToAzureNetworkMappingSettings.
func (a *AzureToAzureNetworkMappingSettings) GetNetworkMappingFabricSpecificSettings() *NetworkMappingFabricSpecificSettings {
	return &NetworkMappingFabricSpecificSettings{
		InstanceType: a.InstanceType,
	}
}

// AzureToAzureUpdateNetworkMappingInput - Updates network mappings input.
type AzureToAzureUpdateNetworkMappingInput struct {
	// REQUIRED; The instance type.
	InstanceType *string

	// The primary azure vnet Id.
	PrimaryNetworkID *string
}

// GetFabricSpecificUpdateNetworkMappingInput implements the FabricSpecificUpdateNetworkMappingInputClassification interface
// for type AzureToAzureUpdateNetworkMappingInput.
func (a *AzureToAzureUpdateNetworkMappingInput) GetFabricSpecificUpdateNetworkMappingInput() *FabricSpecificUpdateNetworkMappingInput {
	return &FabricSpecificUpdateNetworkMappingInput{
		InstanceType: a.InstanceType,
	}
}

// AzureToAzureVMSyncedConfigDetails - Azure to Azure VM synced configuration details.
type AzureToAzureVMSyncedConfigDetails struct {
	// The Azure VM input endpoints.
	InputEndpoints []*InputEndpoint

	// The Azure VM tags.
	Tags map[string]*string
}

// AzureVMDiskDetails - Disk details for E2A provider.
type AzureVMDiskDetails struct {
	// The custom target Azure disk name.
	CustomTargetDiskName *string

	// The DiskEncryptionSet ARM ID.
	DiskEncryptionSetID *string

	// The disk resource id.
	DiskID *string

	// Ordinal\LunId of the disk for the Azure VM.
	LunID *string

	// Max side in MB.
	MaxSizeMB *string

	// Blob uri of the Azure disk.
	TargetDiskLocation *string

	// The target Azure disk name.
	TargetDiskName *string

	// The VHD id.
	VhdID *string

	// VHD name.
	VhdName *string

	// VHD type.
	VhdType *string
}

// ComputeSizeErrorDetails - Represents the error used to indicate why the target compute size is not applicable.
type ComputeSizeErrorDetails struct {
	// The error message.
	Message *string

	// The severity of the error.
	Severity *string
}

// ConfigurationSettings - Replication provider specific settings.
type ConfigurationSettings struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string
}

// GetConfigurationSettings implements the ConfigurationSettingsClassification interface for type ConfigurationSettings.
func (c *ConfigurationSettings) GetConfigurationSettings() *ConfigurationSettings { return c }

// ConfigureAlertRequest - Request to configure alerts for the system.
type ConfigureAlertRequest struct {
	// The properties of a configure alert request.
	Properties *ConfigureAlertRequestProperties
}

// ConfigureAlertRequestProperties - Properties of a configure alert request.
type ConfigureAlertRequestProperties struct {
	// The custom email address for sending emails.
	CustomEmailAddresses []*string

	// The locale for the email notification.
	Locale *string

	// A value indicating whether to send email to subscription administrator.
	SendToOwners *string
}

// ConsistencyCheckTaskDetails - This class contains monitoring details of all the inconsistent Protected Entities in Vmm.
type ConsistencyCheckTaskDetails struct {
	// REQUIRED; The type of task details.
	InstanceType *string

	// The list of inconsistent Vm details.
	VMDetails []*InconsistentVMDetails
}

// GetTaskTypeDetails implements the TaskTypeDetailsClassification interface for type ConsistencyCheckTaskDetails.
func (c *ConsistencyCheckTaskDetails) GetTaskTypeDetails() *TaskTypeDetails {
	return &TaskTypeDetails{
		InstanceType: c.InstanceType,
	}
}

// CreateNetworkMappingInput - Create network mappings input.
type CreateNetworkMappingInput struct {
	// REQUIRED; Input properties for creating network mapping.
	Properties *CreateNetworkMappingInputProperties
}

// CreateNetworkMappingInputProperties - Common input details for network mapping operation.
type CreateNetworkMappingInputProperties struct {
	// REQUIRED; Recovery network Id.
	RecoveryNetworkID *string

	// Fabric specific input properties.
	FabricSpecificDetails FabricSpecificCreateNetworkMappingInputClassification

	// Recovery fabric Name.
	RecoveryFabricName *string
}

// CreatePolicyInput - Protection Policy input.
type CreatePolicyInput struct {
	// Policy creation properties.
	Properties *CreatePolicyInputProperties
}

// CreatePolicyInputProperties - Policy creation properties.
type CreatePolicyInputProperties struct {
	// The ReplicationProviderSettings.
	ProviderSpecificInput PolicyProviderSpecificInputClassification
}

// CreateProtectionContainerInput - Create protection container input.
type CreateProtectionContainerInput struct {
	// Create protection container input properties.
	Properties *CreateProtectionContainerInputProperties
}

// CreateProtectionContainerInputProperties - Create protection container input properties.
type CreateProtectionContainerInputProperties struct {
	// Provider specific inputs for container creation.
	ProviderSpecificInput []ReplicationProviderSpecificContainerCreationInputClassification
}

// CreateProtectionContainerMappingInput - Configure pairing input.
type CreateProtectionContainerMappingInput struct {
	// Configure protection input properties.
	Properties *CreateProtectionContainerMappingInputProperties
}

// CreateProtectionContainerMappingInputProperties - Configure pairing input properties.
type CreateProtectionContainerMappingInputProperties struct {
	// Applicable policy.
	PolicyID *string

	// Provider specific input for pairing.
	ProviderSpecificInput ReplicationProviderSpecificContainerMappingInputClassification

	// The target unique protection container name.
	TargetProtectionContainerID *string
}

// CreateProtectionIntentInput - Create protection intent input.
type CreateProtectionIntentInput struct {
	// Create protection intent input properties.
	Properties *CreateProtectionIntentProperties
}

// CreateProtectionIntentProperties - Create protection intent input properties.
type CreateProtectionIntentProperties struct {
	// The ReplicationProviderInput. For A2A provider, it will be A2ACreateProtectionIntentInput object.
	ProviderSpecificDetails CreateProtectionIntentProviderSpecificDetailsClassification
}

// CreateProtectionIntentProviderSpecificDetails - Create protection intent provider specific input.
type CreateProtectionIntentProviderSpecificDetails struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetCreateProtectionIntentProviderSpecificDetails implements the CreateProtectionIntentProviderSpecificDetailsClassification
// interface for type CreateProtectionIntentProviderSpecificDetails.
func (c *CreateProtectionIntentProviderSpecificDetails) GetCreateProtectionIntentProviderSpecificDetails() *CreateProtectionIntentProviderSpecificDetails {
	return c
}

// CreateRecoveryPlanInput - Create recovery plan input class.
type CreateRecoveryPlanInput struct {
	// REQUIRED; Recovery plan creation properties.
	Properties *CreateRecoveryPlanInputProperties
}

// CreateRecoveryPlanInputProperties - Recovery plan creation properties.
type CreateRecoveryPlanInputProperties struct {
	// REQUIRED; The recovery plan groups.
	Groups []*RecoveryPlanGroup

	// REQUIRED; The primary fabric Id.
	PrimaryFabricID *string

	// REQUIRED; The recovery fabric Id.
	RecoveryFabricID *string

	// The failover deployment model.
	FailoverDeploymentModel *FailoverDeploymentModel

	// The provider specific input.
	ProviderSpecificInput []RecoveryPlanProviderSpecificInputClassification
}

// CriticalJobHistoryDetails - Critical past job details of the migration item.
type CriticalJobHistoryDetails struct {
	// READ-ONLY; The ARM Id of the job being executed.
	JobID *string

	// READ-ONLY; The job name.
	JobName *string

	// READ-ONLY; The job state.
	JobStatus *string

	// READ-ONLY; The start time of the job.
	StartTime *time.Time
}

// CurrentJobDetails - Current job details of the migration item.
type CurrentJobDetails struct {
	// READ-ONLY; The ARM Id of the job being executed.
	JobID *string

	// READ-ONLY; The job name.
	JobName *string

	// READ-ONLY; The start time of the job.
	StartTime *time.Time
}

// CurrentScenarioDetails - Current scenario details of the protected entity.
type CurrentScenarioDetails struct {
	// ARM Id of the job being executed.
	JobID *string

	// Scenario name.
	ScenarioName *string

	// Start time of the workflow.
	StartTime *time.Time
}

// DataStore - The datastore details of the MT.
type DataStore struct {
	// The capacity of data store in GBs.
	Capacity *string

	// The free space of data store in GBs.
	FreeSpace *string

	// The symbolic name of data store.
	SymbolicName *string

	// The type of data store.
	Type *string

	// The uuid of data store.
	UUID *string
}

// DataStoreUtilizationDetails - Details of the appliance resource.
type DataStoreUtilizationDetails struct {
	// READ-ONLY; The datastore name.
	DataStoreName *string

	// READ-ONLY; The total snapshots created for server migration in the datastore.
	TotalSnapshotsCreated *int64

	// READ-ONLY; The total count of snapshots supported by the datastore.
	TotalSnapshotsSupported *int64
}

// DisableProtectionInput - Disable protection input.
type DisableProtectionInput struct {
	// REQUIRED; Disable protection input properties.
	Properties *DisableProtectionInputProperties
}

// DisableProtectionInputProperties - Disable protection input properties.
type DisableProtectionInputProperties struct {
	// Disable protection reason. It can have values NotSpecified/MigrationComplete.
	DisableProtectionReason *DisableProtectionReason

	// Replication provider specific input.
	ReplicationProviderInput DisableProtectionProviderSpecificInputClassification
}

// DisableProtectionProviderSpecificInput - Disable protection provider specific input.
type DisableProtectionProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetDisableProtectionProviderSpecificInput implements the DisableProtectionProviderSpecificInputClassification interface
// for type DisableProtectionProviderSpecificInput.
func (d *DisableProtectionProviderSpecificInput) GetDisableProtectionProviderSpecificInput() *DisableProtectionProviderSpecificInput {
	return d
}

// DiscoverProtectableItemRequest - Request to add a physical machine as a protectable item in a container.
type DiscoverProtectableItemRequest struct {
	// The properties of a discover protectable item request.
	Properties *DiscoverProtectableItemRequestProperties
}

// DiscoverProtectableItemRequestProperties - Discover protectable item properties.
type DiscoverProtectableItemRequestProperties struct {
	// The friendly name of the physical machine.
	FriendlyName *string

	// The IP address of the physical machine to be discovered.
	IPAddress *string

	// The OS type on the physical machine.
	OSType *string
}

// DiskDetails - Onprem disk details data.
type DiskDetails struct {
	// The hard disk max size in MB.
	MaxSizeMB *int64

	// The VHD Id.
	VhdID *string

	// The VHD name.
	VhdName *string

	// The type of the volume.
	VhdType *string
}

// DiskEncryptionInfo - Recovery disk encryption info (BEK and KEK).
type DiskEncryptionInfo struct {
	// The recovery KeyVault reference for secret.
	DiskEncryptionKeyInfo *DiskEncryptionKeyInfo

	// The recovery KeyVault reference for key.
	KeyEncryptionKeyInfo *KeyEncryptionKeyInfo
}

// DiskEncryptionKeyInfo - Disk Encryption Key Information (BitLocker Encryption Key (BEK) on Windows).
type DiskEncryptionKeyInfo struct {
	// The KeyVault resource ARM id for secret.
	KeyVaultResourceArmID *string

	// The secret url / identifier.
	SecretIdentifier *string
}

// DiskVolumeDetails - Volume details.
type DiskVolumeDetails struct {
	// The volume label.
	Label *string

	// The volume name.
	Name *string
}

// Display - Contains the localized display information for this particular operation / action. These value will be used by
// several clients for (1) custom role definitions for RBAC; (2) complex query filters for
// the event service; and (3) audit history / records for management operations.
type Display struct {
	// The description. The localized friendly description for the operation, as it should be shown to the user. It should be
	// thorough, yet concise - it will be used in tool tips and detailed views.
	// Prescriptive guidance for namespaces: Read any 'display.provider' resource Create or Update any 'display.provider' resource
	// Delete any 'display.provider' resource Perform any other action on any
	// 'display.provider' resource Prescriptive guidance for namespaces: Read any 'display.resource' Create or Update any 'display.resource'
	// Delete any 'display.resource' 'ActionName' any
	// 'display.resources'.
	Description *string

	// The operation. The localized friendly name for the operation, as it should be shown to the user. It should be concise (to
	// fit in drop downs) but clear (i.e. self-documenting). It should use Title
	// Casing. Prescriptive guidance: Read Create or Update Delete 'ActionName'.
	Operation *string

	// The provider. The localized friendly form of the resource provider name - it is expected to also include the publisher/company
	// responsible. It should use Title Casing and begin with "Microsoft" for
	// 1st party services. e.g. "Microsoft Monitoring Insights" or "Microsoft Compute.".
	Provider *string

	// The resource. The localized friendly form of the resource related to this action/operation - it should match the public
	// documentation for the resource provider. It should use Title Casing. This value
	// should be unique for a particular URL type (e.g. nested types should not reuse their parent's display.resource field).
	// e.g. "Virtual Machines" or "Scheduler Job Collections", or "Virtual Machine VM
	// Sizes" or "Scheduler Jobs".
	Resource *string
}

// DraDetails - DRA details.
type DraDetails struct {
	// READ-ONLY; The DRA Bios Id.
	BiosID *string

	// READ-ONLY; The count of protected items which are protected in forward direction.
	ForwardProtectedItemCount *int32

	// READ-ONLY; The health.
	Health *ProtectionHealth

	// READ-ONLY; The health errors.
	HealthErrors []*HealthError

	// READ-ONLY; The DRA Id.
	ID *string

	// READ-ONLY; The last heartbeat received from the DRA.
	LastHeartbeatUTC *time.Time

	// READ-ONLY; The DRA name.
	Name *string

	// READ-ONLY; The count of protected items which are protected in reverse direction.
	ReverseProtectedItemCount *int32

	// READ-ONLY; The version.
	Version *string
}

// EnableMigrationInput - Enable migration input.
type EnableMigrationInput struct {
	// REQUIRED; Enable migration input properties.
	Properties *EnableMigrationInputProperties
}

// EnableMigrationInputProperties - Enable migration input properties.
type EnableMigrationInputProperties struct {
	// REQUIRED; The policy Id.
	PolicyID *string

	// REQUIRED; The provider specific details.
	ProviderSpecificDetails EnableMigrationProviderSpecificInputClassification
}

// EnableMigrationProviderSpecificInput - Enable migration provider specific input.
type EnableMigrationProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetEnableMigrationProviderSpecificInput implements the EnableMigrationProviderSpecificInputClassification interface for
// type EnableMigrationProviderSpecificInput.
func (e *EnableMigrationProviderSpecificInput) GetEnableMigrationProviderSpecificInput() *EnableMigrationProviderSpecificInput {
	return e
}

// EnableProtectionInput - Enable protection input.
type EnableProtectionInput struct {
	// Enable protection input properties.
	Properties *EnableProtectionInputProperties
}

// EnableProtectionInputProperties - Enable protection input properties.
type EnableProtectionInputProperties struct {
	// The Policy Id.
	PolicyID *string

	// The protectable item Id.
	ProtectableItemID *string

	// The ReplicationProviderInput. For HyperVReplicaAzure provider, it will be AzureEnableProtectionInput object. For San provider,
	// it will be SanEnableProtectionInput object. For HyperVReplicaAzure
	// provider, it can be null.
	ProviderSpecificDetails EnableProtectionProviderSpecificInputClassification
}

// EnableProtectionProviderSpecificInput - Enable protection provider specific input.
type EnableProtectionProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetEnableProtectionProviderSpecificInput implements the EnableProtectionProviderSpecificInputClassification interface for
// type EnableProtectionProviderSpecificInput.
func (e *EnableProtectionProviderSpecificInput) GetEnableProtectionProviderSpecificInput() *EnableProtectionProviderSpecificInput {
	return e
}

// EncryptionDetails - Encryption details for the fabric.
type EncryptionDetails struct {
	// The key encryption key certificate expiry date.
	KekCertExpiryDate *time.Time

	// The key encryption key certificate thumbprint.
	KekCertThumbprint *string

	// The key encryption key state for the Vmm.
	KekState *string
}

// Event - Implements the Event class.
type Event struct {
	// Resource Location
	Location *string

	// Event related data.
	Properties *EventProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource Name
	Name *string

	// READ-ONLY; Resource Type
	Type *string
}

// EventCollection - Collection of fabric details.
type EventCollection struct {
	// The value of next link.
	NextLink *string

	// The list of events.
	Value []*Event
}

// EventProperties - The properties of a monitoring event.
type EventProperties struct {
	// The affected object correlationId for the event.
	AffectedObjectCorrelationID *string

	// The friendly name of the source of the event on which it is raised (for example, VM, VMM etc).
	AffectedObjectFriendlyName *string

	// The event name.
	Description *string

	// The Id of the monitoring event.
	EventCode *string

	// The event specific settings.
	EventSpecificDetails EventSpecificDetailsClassification

	// The type of the event. for example: VM Health, Server Health, Job Failure etc.
	EventType *string

	// The ARM ID of the fabric.
	FabricID *string

	// The list of errors / warnings capturing details associated with the issue(s).
	HealthErrors []*HealthError

	// The provider specific settings.
	ProviderSpecificDetails EventProviderSpecificDetailsClassification

	// The severity of the event.
	Severity *string

	// The time of occurrence of the event.
	TimeOfOccurrence *time.Time
}

// EventProviderSpecificDetails - Model class for provider specific details for an event.
type EventProviderSpecificDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string
}

// GetEventProviderSpecificDetails implements the EventProviderSpecificDetailsClassification interface for type EventProviderSpecificDetails.
func (e *EventProviderSpecificDetails) GetEventProviderSpecificDetails() *EventProviderSpecificDetails {
	return e
}

// EventQueryParameter - Implements the event query parameter.
type EventQueryParameter struct {
	// The affected object correlationId for the events to be queried.
	AffectedObjectCorrelationID *string

	// The affected object name of the events to be queried.
	AffectedObjectFriendlyName *string

	// The end time of the time range within which the events are to be queried.
	EndTime *time.Time

	// The source id of the events to be queried.
	EventCode *string

	// The type of the events to be queried.
	EventType *string

	// The affected object server id of the events to be queried.
	FabricName *string

	// The severity of the events to be queried.
	Severity *string

	// The start time of the time range within which the events are to be queried.
	StartTime *time.Time
}

// EventSpecificDetails - Model class for event specific details for an event.
type EventSpecificDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string
}

// GetEventSpecificDetails implements the EventSpecificDetailsClassification interface for type EventSpecificDetails.
func (e *EventSpecificDetails) GetEventSpecificDetails() *EventSpecificDetails { return e }

// ExistingProtectionProfile - Existing storage account input.
type ExistingProtectionProfile struct {
	// REQUIRED; The protection profile Arm Id. Throw error, if resource does not exists.
	ProtectionProfileID *string

	// REQUIRED; The class type.
	ResourceType *string
}

// GetProtectionProfileCustomDetails implements the ProtectionProfileCustomDetailsClassification interface for type ExistingProtectionProfile.
func (e *ExistingProtectionProfile) GetProtectionProfileCustomDetails() *ProtectionProfileCustomDetails {
	return &ProtectionProfileCustomDetails{
		ResourceType: e.ResourceType,
	}
}

// ExistingRecoveryAvailabilitySet - Existing recovery availability set input.
type ExistingRecoveryAvailabilitySet struct {
	// REQUIRED; The class type.
	ResourceType *string

	// The recovery availability set Id. Will throw error, if resource does not exist.
	RecoveryAvailabilitySetID *string
}

// GetRecoveryAvailabilitySetCustomDetails implements the RecoveryAvailabilitySetCustomDetailsClassification interface for
// type ExistingRecoveryAvailabilitySet.
func (e *ExistingRecoveryAvailabilitySet) GetRecoveryAvailabilitySetCustomDetails() *RecoveryAvailabilitySetCustomDetails {
	return &RecoveryAvailabilitySetCustomDetails{
		ResourceType: e.ResourceType,
	}
}

// ExistingRecoveryProximityPlacementGroup - Existing recovery proximity placement group input.
type ExistingRecoveryProximityPlacementGroup struct {
	// REQUIRED; The class type.
	ResourceType *string

	// The recovery proximity placement group Id. Will throw error, if resource does not exist.
	RecoveryProximityPlacementGroupID *string
}

// GetRecoveryProximityPlacementGroupCustomDetails implements the RecoveryProximityPlacementGroupCustomDetailsClassification
// interface for type ExistingRecoveryProximityPlacementGroup.
func (e *ExistingRecoveryProximityPlacementGroup) GetRecoveryProximityPlacementGroupCustomDetails() *RecoveryProximityPlacementGroupCustomDetails {
	return &RecoveryProximityPlacementGroupCustomDetails{
		ResourceType: e.ResourceType,
	}
}

// ExistingRecoveryResourceGroup - Existing recovery resource group input.
type ExistingRecoveryResourceGroup struct {
	// REQUIRED; The class type.
	ResourceType *string

	// The recovery resource group Id. Valid for V2 scenarios.
	RecoveryResourceGroupID *string
}

// GetRecoveryResourceGroupCustomDetails implements the RecoveryResourceGroupCustomDetailsClassification interface for type
// ExistingRecoveryResourceGroup.
func (e *ExistingRecoveryResourceGroup) GetRecoveryResourceGroupCustomDetails() *RecoveryResourceGroupCustomDetails {
	return &RecoveryResourceGroupCustomDetails{
		ResourceType: e.ResourceType,
	}
}

// ExistingRecoveryVirtualNetwork - Existing recovery virtual network input.
type ExistingRecoveryVirtualNetwork struct {
	// REQUIRED; The recovery virtual network Id. Will throw error, if resource does not exist.
	RecoveryVirtualNetworkID *string

	// REQUIRED; The class type.
	ResourceType *string

	// The recovery subnet name.
	RecoverySubnetName *string
}

// GetRecoveryVirtualNetworkCustomDetails implements the RecoveryVirtualNetworkCustomDetailsClassification interface for type
// ExistingRecoveryVirtualNetwork.
func (e *ExistingRecoveryVirtualNetwork) GetRecoveryVirtualNetworkCustomDetails() *RecoveryVirtualNetworkCustomDetails {
	return &RecoveryVirtualNetworkCustomDetails{
		ResourceType: e.ResourceType,
	}
}

// ExistingStorageAccount - Existing storage account input.
type ExistingStorageAccount struct {
	// REQUIRED; The storage account Arm Id. Throw error, if resource does not exists.
	AzureStorageAccountID *string

	// REQUIRED; The class type.
	ResourceType *string
}

// GetStorageAccountCustomDetails implements the StorageAccountCustomDetailsClassification interface for type ExistingStorageAccount.
func (e *ExistingStorageAccount) GetStorageAccountCustomDetails() *StorageAccountCustomDetails {
	return &StorageAccountCustomDetails{
		ResourceType: e.ResourceType,
	}
}

// ExportJobDetails - This class represents details for export jobs workflow.
type ExportJobDetails struct {
	// REQUIRED; Gets the type of job details (see JobDetailsTypes enum for possible values).
	InstanceType *string

	// The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow
	// object details.
	AffectedObjectDetails map[string]*string

	// BlobUri of the exported jobs.
	BlobURI *string

	// The sas token to access blob.
	SasToken *string
}

// GetJobDetails implements the JobDetailsClassification interface for type ExportJobDetails.
func (e *ExportJobDetails) GetJobDetails() *JobDetails {
	return &JobDetails{
		AffectedObjectDetails: e.AffectedObjectDetails,
		InstanceType:          e.InstanceType,
	}
}

// ExtendedLocation - Extended location of the resource.
type ExtendedLocation struct {
	// REQUIRED; The name of the extended location.
	Name *string

	// REQUIRED; The extended location type.
	Type *ExtendedLocationType
}

// Fabric definition.
type Fabric struct {
	// Resource Location
	Location *string

	// Fabric related data.
	Properties *FabricProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource Name
	Name *string

	// READ-ONLY; Resource Type
	Type *string
}

// FabricCollection - Collection of fabric details.
type FabricCollection struct {
	// The value of next link.
	NextLink *string

	// The fabric details.
	Value []*Fabric
}

// FabricCreationInput - Site details provided during the time of site creation.
type FabricCreationInput struct {
	// Fabric creation input.
	Properties *FabricCreationInputProperties
}

// FabricCreationInputProperties - Properties of site details provided during the time of site creation.
type FabricCreationInputProperties struct {
	// Fabric provider specific creation input.
	CustomDetails FabricSpecificCreationInputClassification
}

// FabricProperties - Fabric properties.
type FabricProperties struct {
	// BCDR state of the fabric.
	BcdrState *string

	// Fabric specific settings.
	CustomDetails FabricSpecificDetailsClassification

	// Encryption details for the fabric.
	EncryptionDetails *EncryptionDetails

	// Friendly name of the fabric.
	FriendlyName *string

	// Health of fabric.
	Health *string

	// Fabric health error details.
	HealthErrorDetails []*HealthError

	// Dra Registration Id.
	InternalIdentifier *string

	// Rollover encryption details for the fabric.
	RolloverEncryptionDetails *EncryptionDetails
}

// FabricQueryParameter - Query parameter to get fabric.
type FabricQueryParameter struct {
	// The BIOS Id to be used for fetching agent details.
	BiosID *string

	// The type of the discovered machine to be used for fetching agent details.
	DiscoveryType *string

	// A value indicating whether the Extended Location mappings are to be returned.
	ExtendedLocationMappings *string

	// A value indicating whether the agent details are to be fetched.
	FetchAgentDetails *string

	// The FQDN to be used for fetching agent details.
	Fqdn *string

	// A value indicating whether the location details are to be returned.
	LocationDetails *string

	// The OS type to be used for fetching agent details.
	OSType *string

	// A value indicating whether the zone to zone mappings are to be returned.
	ZoneToZoneMappings *string
}

// FabricReplicationGroupTaskDetails - This class represents the fabric replication group task details.
type FabricReplicationGroupTaskDetails struct {
	// REQUIRED; The type of task details.
	InstanceType *string

	// The job entity.
	JobTask *JobEntity

	// The skipped reason.
	SkippedReason *string

	// The skipped reason string.
	SkippedReasonString *string
}

// GetJobTaskDetails implements the JobTaskDetailsClassification interface for type FabricReplicationGroupTaskDetails.
func (f *FabricReplicationGroupTaskDetails) GetJobTaskDetails() *JobTaskDetails {
	return &JobTaskDetails{
		InstanceType: f.InstanceType,
		JobTask:      f.JobTask,
	}
}

// GetTaskTypeDetails implements the TaskTypeDetailsClassification interface for type FabricReplicationGroupTaskDetails.
func (f *FabricReplicationGroupTaskDetails) GetTaskTypeDetails() *TaskTypeDetails {
	return &TaskTypeDetails{
		InstanceType: f.InstanceType,
	}
}

// FabricSpecificCreateNetworkMappingInput - Input details specific to fabrics during Network Mapping.
type FabricSpecificCreateNetworkMappingInput struct {
	// REQUIRED; The instance type.
	InstanceType *string
}

// GetFabricSpecificCreateNetworkMappingInput implements the FabricSpecificCreateNetworkMappingInputClassification interface
// for type FabricSpecificCreateNetworkMappingInput.
func (f *FabricSpecificCreateNetworkMappingInput) GetFabricSpecificCreateNetworkMappingInput() *FabricSpecificCreateNetworkMappingInput {
	return f
}

// FabricSpecificCreationInput - Fabric provider specific settings.
type FabricSpecificCreationInput struct {
	// REQUIRED; Gets the class type.
	InstanceType *string
}

// GetFabricSpecificCreationInput implements the FabricSpecificCreationInputClassification interface for type FabricSpecificCreationInput.
func (f *FabricSpecificCreationInput) GetFabricSpecificCreationInput() *FabricSpecificCreationInput {
	return f
}

// FabricSpecificDetails - Fabric specific details.
type FabricSpecificDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string
}

// GetFabricSpecificDetails implements the FabricSpecificDetailsClassification interface for type FabricSpecificDetails.
func (f *FabricSpecificDetails) GetFabricSpecificDetails() *FabricSpecificDetails { return f }

// FabricSpecificUpdateNetworkMappingInput - Input details specific to fabrics during Network Mapping.
type FabricSpecificUpdateNetworkMappingInput struct {
	// REQUIRED; The instance type.
	InstanceType *string
}

// GetFabricSpecificUpdateNetworkMappingInput implements the FabricSpecificUpdateNetworkMappingInputClassification interface
// for type FabricSpecificUpdateNetworkMappingInput.
func (f *FabricSpecificUpdateNetworkMappingInput) GetFabricSpecificUpdateNetworkMappingInput() *FabricSpecificUpdateNetworkMappingInput {
	return f
}

// FailoverJobDetails - This class represents the details for a failover job.
type FailoverJobDetails struct {
	// REQUIRED; Gets the type of job details (see JobDetailsTypes enum for possible values).
	InstanceType *string

	// The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow
	// object details.
	AffectedObjectDetails map[string]*string

	// The test VM details.
	ProtectedItemDetails []*FailoverReplicationProtectedItemDetails
}

// GetJobDetails implements the JobDetailsClassification interface for type FailoverJobDetails.
func (f *FailoverJobDetails) GetJobDetails() *JobDetails {
	return &JobDetails{
		AffectedObjectDetails: f.AffectedObjectDetails,
		InstanceType:          f.InstanceType,
	}
}

// FailoverProcessServerRequest - Request to failover a process server.
type FailoverProcessServerRequest struct {
	// The properties of the PS Failover request.
	Properties *FailoverProcessServerRequestProperties
}

// FailoverProcessServerRequestProperties - The properties of the Failover Process Server request.
type FailoverProcessServerRequestProperties struct {
	// The container identifier.
	ContainerName *string

	// The source process server.
	SourceProcessServerID *string

	// The new process server.
	TargetProcessServerID *string

	// A value for failover type. It can be systemlevel/serverlevel.
	UpdateType *string

	// The VMS to migrate.
	VMsToMigrate []*string
}

// FailoverReplicationProtectedItemDetails - Failover details for a replication protected item.
type FailoverReplicationProtectedItemDetails struct {
	// The friendly name.
	FriendlyName *string

	// The name.
	Name *string

	// The network connection status.
	NetworkConnectionStatus *string

	// The network friendly name.
	NetworkFriendlyName *string

	// The recovery point Id.
	RecoveryPointID *string

	// The recovery point time.
	RecoveryPointTime *time.Time

	// The network subnet.
	Subnet *string

	// The test Vm friendly name.
	TestVMFriendlyName *string

	// The test Vm name.
	TestVMName *string
}

// GatewayOperationDetails - Details of the gateway operation.
type GatewayOperationDetails struct {
	// READ-ONLY; A value indicating the datastore collection.
	DataStores []*string

	// READ-ONLY; A value indicating the ESXi host name.
	HostName *string

	// READ-ONLY; A value indicating the progress percentage of gateway operation.
	ProgressPercentage *int32

	// READ-ONLY; A value indicating the state of gateway operation.
	State *string

	// READ-ONLY; A value indicating the time elapsed for the operation in milliseconds.
	TimeElapsed *int64

	// READ-ONLY; A value indicating the time remaining for the operation in milliseconds.
	TimeRemaining *int64

	// READ-ONLY; A value indicating the upload speed in bytes per second.
	UploadSpeed *int64

	// READ-ONLY; A value indicating the VMware read throughput in bytes per second.
	VmwareReadThroughput *int64
}

// GroupTaskDetails - This class represents the group task details when parent child relationship exists in the drill down.
type GroupTaskDetails struct {
	// REQUIRED; The type of task details.
	InstanceType *string

	// The child tasks.
	ChildTasks []*ASRTask
}

// GetGroupTaskDetails implements the GroupTaskDetailsClassification interface for type GroupTaskDetails.
func (g *GroupTaskDetails) GetGroupTaskDetails() *GroupTaskDetails { return g }

// HealthError - Health Error.
type HealthError struct {
	// Error creation time (UTC).
	CreationTimeUTC *time.Time

	// Value indicating whether the health error is customer resolvable.
	CustomerResolvability *HealthErrorCustomerResolvability

	// ID of the entity.
	EntityID *string

	// Category of error.
	ErrorCategory *string

	// Error code.
	ErrorCode *string

	// The health error unique id.
	ErrorID *string

	// Level of error.
	ErrorLevel *string

	// Error message.
	ErrorMessage *string

	// Source of error.
	ErrorSource *string

	// Type of error.
	ErrorType *string

	// The inner health errors. HealthError having a list of HealthError as child errors is problematic. InnerHealthError is used
	// because this will prevent an infinite loop of structures when Hydra tries to
	// auto-generate the contract. We are exposing the related health errors as inner health errors and all API consumers can
	// utilize this in the same fashion as Exception -> InnerException.
	InnerHealthErrors []*InnerHealthError

	// Possible causes of error.
	PossibleCauses *string

	// Recommended action to resolve error.
	RecommendedAction *string

	// DRA error message.
	RecoveryProviderErrorMessage *string

	// Summary message of the entity.
	SummaryMessage *string
}

// HealthErrorSummary - class to define the summary of the health error details.
type HealthErrorSummary struct {
	// The list of affected resource correlation Ids. This can be used to uniquely identify the count of items affected by a specific
	// category and severity as well as count of item affected by an specific
	// issue.
	AffectedResourceCorrelationIDs []*string

	// The sub type of any subcomponent within the ARM resource that this might be applicable. Value remains null if not applicable.
	AffectedResourceSubtype *string

	// The type of affected ARM resource.
	AffectedResourceType *string

	// The category of the health error.
	Category *HealthErrorCategory

	// Severity of error.
	Severity *Severity

	// The code of the health error.
	SummaryCode *string

	// The summary message of the health error.
	SummaryMessage *string
}

// HyperVHostDetails - Hyper-V host details.
type HyperVHostDetails struct {
	// READ-ONLY; The Hyper-V host Id.
	ID *string

	// READ-ONLY; The Mars agent version.
	MarsAgentVersion *string

	// READ-ONLY; The Hyper-V host name.
	Name *string
}

// HyperVReplica2012EventDetails - Model class for event details of a HyperVReplica E2E event.
type HyperVReplica2012EventDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// The container friendly name.
	ContainerName *string

	// The fabric friendly name.
	FabricName *string

	// The remote container name.
	RemoteContainerName *string

	// The remote fabric name.
	RemoteFabricName *string
}

// GetEventProviderSpecificDetails implements the EventProviderSpecificDetailsClassification interface for type HyperVReplica2012EventDetails.
func (h *HyperVReplica2012EventDetails) GetEventProviderSpecificDetails() *EventProviderSpecificDetails {
	return &EventProviderSpecificDetails{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplica2012R2EventDetails - Model class for event details of a HyperVReplica blue E2E event.
type HyperVReplica2012R2EventDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// The container friendly name.
	ContainerName *string

	// The fabric friendly name.
	FabricName *string

	// The remote container name.
	RemoteContainerName *string

	// The remote fabric name.
	RemoteFabricName *string
}

// GetEventProviderSpecificDetails implements the EventProviderSpecificDetailsClassification interface for type HyperVReplica2012R2EventDetails.
func (h *HyperVReplica2012R2EventDetails) GetEventProviderSpecificDetails() *EventProviderSpecificDetails {
	return &EventProviderSpecificDetails{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaAzureApplyRecoveryPointInput - ApplyRecoveryPoint input specific to HyperVReplicaAzure provider.
type HyperVReplicaAzureApplyRecoveryPointInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// The primary kek certificate pfx.
	PrimaryKekCertificatePfx *string

	// The secondary kek certificate pfx.
	SecondaryKekCertificatePfx *string
}

// GetApplyRecoveryPointProviderSpecificInput implements the ApplyRecoveryPointProviderSpecificInputClassification interface
// for type HyperVReplicaAzureApplyRecoveryPointInput.
func (h *HyperVReplicaAzureApplyRecoveryPointInput) GetApplyRecoveryPointProviderSpecificInput() *ApplyRecoveryPointProviderSpecificInput {
	return &ApplyRecoveryPointProviderSpecificInput{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaAzureDiskInputDetails - Disk input details.
type HyperVReplicaAzureDiskInputDetails struct {
	// The DiskEncryptionSet ARM ID.
	DiskEncryptionSetID *string

	// The DiskId.
	DiskID *string

	// The DiskType.
	DiskType *DiskAccountType

	// The LogStorageAccountId.
	LogStorageAccountID *string
}

// HyperVReplicaAzureEnableProtectionInput - HyperVReplicaAzure specific enable protection input.
type HyperVReplicaAzureEnableProtectionInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// The DiskEncryptionSet ARM Id.
	DiskEncryptionSetID *string

	// The DiskType.
	DiskType *DiskAccountType

	// The list of VHD Ids of disks to be protected.
	DisksToInclude []*string

	// The disks to include list for managed disks.
	DisksToIncludeForManagedDisks []*HyperVReplicaAzureDiskInputDetails

	// The selected option to enable RDP\SSH on target vm after failover. String value of SrsDataContract.EnableRDPOnTargetOption
	// enum.
	EnableRdpOnTargetOption *string

	// The Hyper-V host VM Id.
	HvHostVMID *string

	// License type.
	LicenseType *LicenseType

	// The storage account to be used for logging during replication.
	LogStorageAccountID *string

	// The OS type associated with VM.
	OSType *string

	// The SQL Server license type.
	SQLServerLicenseType *SQLServerLicenseType

	// The tags for the seed managed disks.
	SeedManagedDiskTags map[string]*string

	// The target availability set ARM Id for resource manager deployment.
	TargetAvailabilitySetID *string

	// The target availability zone.
	TargetAvailabilityZone *string

	// The selected target Azure network Id.
	TargetAzureNetworkID *string

	// The selected target Azure subnet Id.
	TargetAzureSubnetID *string

	// The Id of the target resource group (for classic deployment) in which the failover VM is to be created.
	TargetAzureV1ResourceGroupID *string

	// The Id of the target resource group (for resource manager deployment) in which the failover VM is to be created.
	TargetAzureV2ResourceGroupID *string

	// The target azure VM Name.
	TargetAzureVMName *string

	// The tags for the target managed disks.
	TargetManagedDiskTags map[string]*string

	// The tags for the target NICs.
	TargetNicTags map[string]*string

	// The proximity placement group ARM Id.
	TargetProximityPlacementGroupID *string

	// The storage account Id.
	TargetStorageAccountID *string

	// The target VM size.
	TargetVMSize *string

	// The target VM tags.
	TargetVMTags map[string]*string

	// A value indicating whether managed disks should be used during failover.
	UseManagedDisks *string

	// A value indicating whether managed disks should be used during replication.
	UseManagedDisksForReplication *string

	// The VM Name.
	VMName *string

	// The OS disk VHD id associated with VM.
	VhdID *string
}

// GetEnableProtectionProviderSpecificInput implements the EnableProtectionProviderSpecificInputClassification interface for
// type HyperVReplicaAzureEnableProtectionInput.
func (h *HyperVReplicaAzureEnableProtectionInput) GetEnableProtectionProviderSpecificInput() *EnableProtectionProviderSpecificInput {
	return &EnableProtectionProviderSpecificInput{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaAzureEventDetails - Model class for event details of a HyperVReplica E2A event.
type HyperVReplicaAzureEventDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// The container friendly name.
	ContainerName *string

	// The fabric friendly name.
	FabricName *string

	// The remote container name.
	RemoteContainerName *string
}

// GetEventProviderSpecificDetails implements the EventProviderSpecificDetailsClassification interface for type HyperVReplicaAzureEventDetails.
func (h *HyperVReplicaAzureEventDetails) GetEventProviderSpecificDetails() *EventProviderSpecificDetails {
	return &EventProviderSpecificDetails{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaAzureFailbackProviderInput - HyperVReplicaAzureFailback specific planned failover input.
type HyperVReplicaAzureFailbackProviderInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// Data sync option.
	DataSyncOption *string

	// Provider Id for alternate location.
	ProviderIDForAlternateRecovery *string

	// ALR options to create alternate recovery.
	RecoveryVMCreationOption *string
}

// GetPlannedFailoverProviderSpecificFailoverInput implements the PlannedFailoverProviderSpecificFailoverInputClassification
// interface for type HyperVReplicaAzureFailbackProviderInput.
func (h *HyperVReplicaAzureFailbackProviderInput) GetPlannedFailoverProviderSpecificFailoverInput() *PlannedFailoverProviderSpecificFailoverInput {
	return &PlannedFailoverProviderSpecificFailoverInput{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaAzureManagedDiskDetails - Hyper-V Managed disk details.
type HyperVReplicaAzureManagedDiskDetails struct {
	// The disk encryption set ARM Id.
	DiskEncryptionSetID *string

	// The disk Id.
	DiskID *string

	// The replica disk type.
	ReplicaDiskType *string

	// Seed managed disk Id.
	SeedManagedDiskID *string
}

// HyperVReplicaAzurePlannedFailoverProviderInput - HyperVReplicaAzure specific planned failover input.
type HyperVReplicaAzurePlannedFailoverProviderInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// A value indicating the inplace OS Upgrade version.
	OSUpgradeVersion *string

	// Primary kek certificate pfx.
	PrimaryKekCertificatePfx *string

	// The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should
	// be passed.
	RecoveryPointID *string

	// Secondary kek certificate pfx.
	SecondaryKekCertificatePfx *string
}

// GetPlannedFailoverProviderSpecificFailoverInput implements the PlannedFailoverProviderSpecificFailoverInputClassification
// interface for type HyperVReplicaAzurePlannedFailoverProviderInput.
func (h *HyperVReplicaAzurePlannedFailoverProviderInput) GetPlannedFailoverProviderSpecificFailoverInput() *PlannedFailoverProviderSpecificFailoverInput {
	return &PlannedFailoverProviderSpecificFailoverInput{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaAzurePolicyDetails - Hyper-V Replica Azure specific protection profile details.
type HyperVReplicaAzurePolicyDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// The active storage account Id.
	ActiveStorageAccountID *string

	// The interval (in hours) at which Hyper-V Replica should create an application consistent snapshot within the VM.
	ApplicationConsistentSnapshotFrequencyInHours *int32

	// A value indicating whether encryption is enabled for virtual machines in this cloud.
	Encryption *string

	// The scheduled start time for the initial replication. If this parameter is Null, the initial replication starts immediately.
	OnlineReplicationStartTime *string

	// The duration (in hours) to which point the recovery history needs to be maintained.
	RecoveryPointHistoryDurationInHours *int32

	// The replication interval.
	ReplicationInterval *int32
}

// GetPolicyProviderSpecificDetails implements the PolicyProviderSpecificDetailsClassification interface for type HyperVReplicaAzurePolicyDetails.
func (h *HyperVReplicaAzurePolicyDetails) GetPolicyProviderSpecificDetails() *PolicyProviderSpecificDetails {
	return &PolicyProviderSpecificDetails{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaAzurePolicyInput - Hyper-V Replica Azure specific input for creating a protection profile.
type HyperVReplicaAzurePolicyInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// The interval (in hours) at which Hyper-V Replica should create an application consistent snapshot within the VM.
	ApplicationConsistentSnapshotFrequencyInHours *int32

	// The scheduled start time for the initial replication. If this parameter is Null, the initial replication starts immediately.
	OnlineReplicationStartTime *string

	// The duration (in hours) to which point the recovery history needs to be maintained.
	RecoveryPointHistoryDuration *int32

	// The replication interval.
	ReplicationInterval *int32

	// The list of storage accounts to which the VMs in the primary cloud can replicate to.
	StorageAccounts []*string
}

// GetPolicyProviderSpecificInput implements the PolicyProviderSpecificInputClassification interface for type HyperVReplicaAzurePolicyInput.
func (h *HyperVReplicaAzurePolicyInput) GetPolicyProviderSpecificInput() *PolicyProviderSpecificInput {
	return &PolicyProviderSpecificInput{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaAzureReplicationDetails - Hyper V Replica Azure provider specific settings.
type HyperVReplicaAzureReplicationDetails struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string

	// A value indicating all available inplace OS Upgrade configurations.
	AllAvailableOSUpgradeConfigurations []*OSUpgradeSupportedVersions

	// Azure VM Disk details.
	AzureVMDiskDetails []*AzureVMDiskDetails

	// The selected option to enable RDP\SSH on target vm after failover. String value of SrsDataContract.EnableRDPOnTargetOption
	// enum.
	EnableRdpOnTargetOption *string

	// The encryption info.
	Encryption *string

	// Initial replication details.
	InitialReplicationDetails *InitialReplicationDetails

	// The Last replication time.
	LastReplicatedTime *time.Time

	// The last RPO calculated time.
	LastRpoCalculatedTime *time.Time

	// License Type of the VM to be used.
	LicenseType *string

	// The operating system info.
	OSDetails *OSDetails

	// The list of protected managed disks.
	ProtectedManagedDisks []*HyperVReplicaAzureManagedDiskDetails

	// The recovery availability set Id.
	RecoveryAvailabilitySetID *string

	// The ARM id of the log storage account used for replication. This will be set to null if no log storage account was provided
	// during enable protection.
	RecoveryAzureLogStorageAccountID *string

	// The target resource group Id.
	RecoveryAzureResourceGroupID *string

	// The recovery Azure storage account.
	RecoveryAzureStorageAccount *string

	// Recovery Azure given name.
	RecoveryAzureVMName *string

	// The Recovery Azure VM size.
	RecoveryAzureVMSize *string

	// Last RPO value.
	RpoInSeconds *int64

	// The SQL Server license type.
	SQLServerLicenseType *string

	// The tags for the seed managed disks.
	SeedManagedDiskTags map[string]*string

	// The selected recovery azure network Id.
	SelectedRecoveryAzureNetworkID *string

	// The selected source nic Id which will be used as the primary nic during failover.
	SelectedSourceNicID *string

	// The CPU count of the VM on the primary side.
	SourceVMCPUCount *int32

	// The RAM size of the VM on the primary side.
	SourceVMRAMSizeInMB *int32

	// The target availability zone.
	TargetAvailabilityZone *string

	// The tags for the target managed disks.
	TargetManagedDiskTags map[string]*string

	// The tags for the target NICs.
	TargetNicTags map[string]*string

	// The target proximity placement group Id.
	TargetProximityPlacementGroupID *string

	// The target VM tags.
	TargetVMTags map[string]*string

	// A value indicating whether managed disks should be used during failover.
	UseManagedDisks *string

	// The virtual machine Id.
	VMID *string

	// The PE Network details.
	VMNics []*VMNicDetails

	// The protection state for the vm.
	VMProtectionState *string

	// The protection state description for the vm.
	VMProtectionStateDescription *string

	// READ-ONLY; The last recovery point received time.
	LastRecoveryPointReceived *time.Time
}

// GetReplicationProviderSpecificSettings implements the ReplicationProviderSpecificSettingsClassification interface for type
// HyperVReplicaAzureReplicationDetails.
func (h *HyperVReplicaAzureReplicationDetails) GetReplicationProviderSpecificSettings() *ReplicationProviderSpecificSettings {
	return &ReplicationProviderSpecificSettings{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaAzureReprotectInput - Azure specific reprotect input.
type HyperVReplicaAzureReprotectInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// The Hyper-V host Vm Id.
	HvHostVMID *string

	// The storage account to be used for logging during replication.
	LogStorageAccountID *string

	// The OS type associated with vm.
	OSType *string

	// The storage account name.
	StorageAccountID *string

	// The OS disk VHD id associated with vm.
	VHDID *string

	// The Vm Name.
	VMName *string
}

// GetReverseReplicationProviderSpecificInput implements the ReverseReplicationProviderSpecificInputClassification interface
// for type HyperVReplicaAzureReprotectInput.
func (h *HyperVReplicaAzureReprotectInput) GetReverseReplicationProviderSpecificInput() *ReverseReplicationProviderSpecificInput {
	return &ReverseReplicationProviderSpecificInput{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaAzureTestFailoverInput - HvrA provider specific input for test failover.
type HyperVReplicaAzureTestFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// A value indicating the inplace OS Upgrade version.
	OSUpgradeVersion *string

	// Primary kek certificate pfx.
	PrimaryKekCertificatePfx *string

	// The recovery point id to be passed to test failover to a particular recovery point. In case of latest recovery point, null
	// should be passed.
	RecoveryPointID *string

	// Secondary kek certificate pfx.
	SecondaryKekCertificatePfx *string
}

// GetTestFailoverProviderSpecificInput implements the TestFailoverProviderSpecificInputClassification interface for type
// HyperVReplicaAzureTestFailoverInput.
func (h *HyperVReplicaAzureTestFailoverInput) GetTestFailoverProviderSpecificInput() *TestFailoverProviderSpecificInput {
	return &TestFailoverProviderSpecificInput{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaAzureUnplannedFailoverInput - HvrA provider specific input for unplanned failover.
type HyperVReplicaAzureUnplannedFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// Primary kek certificate pfx.
	PrimaryKekCertificatePfx *string

	// The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should
	// be passed.
	RecoveryPointID *string

	// Secondary kek certificate pfx.
	SecondaryKekCertificatePfx *string
}

// GetUnplannedFailoverProviderSpecificInput implements the UnplannedFailoverProviderSpecificInputClassification interface
// for type HyperVReplicaAzureUnplannedFailoverInput.
func (h *HyperVReplicaAzureUnplannedFailoverInput) GetUnplannedFailoverProviderSpecificInput() *UnplannedFailoverProviderSpecificInput {
	return &UnplannedFailoverProviderSpecificInput{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaAzureUpdateReplicationProtectedItemInput - HyperV replica Azure input to update replication protected item.
type HyperVReplicaAzureUpdateReplicationProtectedItemInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// The dictionary of disk resource Id to disk encryption set ARM Id.
	DiskIDToDiskEncryptionMap map[string]*string

	// The recovery Azure resource group Id for classic deployment.
	RecoveryAzureV1ResourceGroupID *string

	// The recovery Azure resource group Id for resource manager deployment.
	RecoveryAzureV2ResourceGroupID *string

	// The SQL Server license type.
	SQLServerLicenseType *SQLServerLicenseType

	// The target availability zone.
	TargetAvailabilityZone *string

	// The tags for the target managed disks.
	TargetManagedDiskTags map[string]*string

	// The tags for the target NICs.
	TargetNicTags map[string]*string

	// The target proximity placement group Id.
	TargetProximityPlacementGroupID *string

	// The target VM tags.
	TargetVMTags map[string]*string

	// A value indicating whether managed disks should be used during failover.
	UseManagedDisks *string

	// The list of disk update properties.
	VMDisks []*UpdateDiskInput
}

// GetUpdateReplicationProtectedItemProviderInput implements the UpdateReplicationProtectedItemProviderInputClassification
// interface for type HyperVReplicaAzureUpdateReplicationProtectedItemInput.
func (h *HyperVReplicaAzureUpdateReplicationProtectedItemInput) GetUpdateReplicationProtectedItemProviderInput() *UpdateReplicationProtectedItemProviderInput {
	return &UpdateReplicationProtectedItemProviderInput{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaBaseEventDetails - Abstract model class for event details of a HyperVReplica E2E event.
type HyperVReplicaBaseEventDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// The container friendly name.
	ContainerName *string

	// The fabric friendly name.
	FabricName *string

	// The remote container name.
	RemoteContainerName *string

	// The remote fabric name.
	RemoteFabricName *string
}

// GetEventProviderSpecificDetails implements the EventProviderSpecificDetailsClassification interface for type HyperVReplicaBaseEventDetails.
func (h *HyperVReplicaBaseEventDetails) GetEventProviderSpecificDetails() *EventProviderSpecificDetails {
	return &EventProviderSpecificDetails{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaBasePolicyDetails - Base class for HyperVReplica policy details.
type HyperVReplicaBasePolicyDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// A value indicating the authentication type.
	AllowedAuthenticationType *int32

	// A value indicating the application consistent frequency.
	ApplicationConsistentSnapshotFrequencyInHours *int32

	// A value indicating whether compression has to be enabled.
	Compression *string

	// A value indicating whether IR is online.
	InitialReplicationMethod *string

	// A value indicating the offline IR export path.
	OfflineReplicationExportPath *string

	// A value indicating the offline IR import path.
	OfflineReplicationImportPath *string

	// A value indicating the online IR start time.
	OnlineReplicationStartTime *string

	// A value indicating the number of recovery points.
	RecoveryPoints *int32

	// A value indicating whether the VM has to be auto deleted. Supported Values: String.Empty, None, OnRecoveryCloud.
	ReplicaDeletionOption *string

	// A value indicating the recovery HTTPS port.
	ReplicationPort *int32
}

// GetPolicyProviderSpecificDetails implements the PolicyProviderSpecificDetailsClassification interface for type HyperVReplicaBasePolicyDetails.
func (h *HyperVReplicaBasePolicyDetails) GetPolicyProviderSpecificDetails() *PolicyProviderSpecificDetails {
	return &PolicyProviderSpecificDetails{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaBaseReplicationDetails - Hyper V replica provider specific settings base class.
type HyperVReplicaBaseReplicationDetails struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string

	// Initial replication details.
	InitialReplicationDetails *InitialReplicationDetails

	// The Last replication time.
	LastReplicatedTime *time.Time

	// VM disk details.
	VMDiskDetails []*DiskDetails

	// The virtual machine Id.
	VMID *string

	// The PE Network details.
	VMNics []*VMNicDetails

	// The protection state for the vm.
	VMProtectionState *string

	// The protection state description for the vm.
	VMProtectionStateDescription *string
}

// GetReplicationProviderSpecificSettings implements the ReplicationProviderSpecificSettingsClassification interface for type
// HyperVReplicaBaseReplicationDetails.
func (h *HyperVReplicaBaseReplicationDetails) GetReplicationProviderSpecificSettings() *ReplicationProviderSpecificSettings {
	return &ReplicationProviderSpecificSettings{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaBluePolicyDetails - Hyper-V Replica Blue specific protection profile details.
type HyperVReplicaBluePolicyDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// A value indicating the authentication type.
	AllowedAuthenticationType *int32

	// A value indicating the application consistent frequency.
	ApplicationConsistentSnapshotFrequencyInHours *int32

	// A value indicating whether compression has to be enabled.
	Compression *string

	// A value indicating whether IR is online.
	InitialReplicationMethod *string

	// A value indicating the offline IR export path.
	OfflineReplicationExportPath *string

	// A value indicating the offline IR import path.
	OfflineReplicationImportPath *string

	// A value indicating the online IR start time.
	OnlineReplicationStartTime *string

	// A value indicating the number of recovery points.
	RecoveryPoints *int32

	// A value indicating whether the VM has to be auto deleted. Supported Values: String.Empty, None, OnRecoveryCloud
	ReplicaDeletionOption *string

	// A value indicating the replication interval.
	ReplicationFrequencyInSeconds *int32

	// A value indicating the recovery HTTPS port.
	ReplicationPort *int32
}

// GetPolicyProviderSpecificDetails implements the PolicyProviderSpecificDetailsClassification interface for type HyperVReplicaBluePolicyDetails.
func (h *HyperVReplicaBluePolicyDetails) GetPolicyProviderSpecificDetails() *PolicyProviderSpecificDetails {
	return &PolicyProviderSpecificDetails{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaBluePolicyInput - HyperV Replica Blue policy input.
type HyperVReplicaBluePolicyInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// A value indicating the authentication type.
	AllowedAuthenticationType *int32

	// A value indicating the application consistent frequency.
	ApplicationConsistentSnapshotFrequencyInHours *int32

	// A value indicating whether compression has to be enabled.
	Compression *string

	// A value indicating whether IR is online.
	InitialReplicationMethod *string

	// A value indicating the offline IR export path.
	OfflineReplicationExportPath *string

	// A value indicating the offline IR import path.
	OfflineReplicationImportPath *string

	// A value indicating the online IR start time.
	OnlineReplicationStartTime *string

	// A value indicating the number of recovery points.
	RecoveryPoints *int32

	// A value indicating whether the VM has to be auto deleted.
	ReplicaDeletion *string

	// A value indicating the replication interval.
	ReplicationFrequencyInSeconds *int32

	// A value indicating the recovery HTTPS port.
	ReplicationPort *int32
}

// GetHyperVReplicaPolicyInput implements the HyperVReplicaPolicyInputClassification interface for type HyperVReplicaBluePolicyInput.
func (h *HyperVReplicaBluePolicyInput) GetHyperVReplicaPolicyInput() *HyperVReplicaPolicyInput {
	return &HyperVReplicaPolicyInput{
		AllowedAuthenticationType:                     h.AllowedAuthenticationType,
		ApplicationConsistentSnapshotFrequencyInHours: h.ApplicationConsistentSnapshotFrequencyInHours,
		Compression:                  h.Compression,
		InitialReplicationMethod:     h.InitialReplicationMethod,
		InstanceType:                 h.InstanceType,
		OfflineReplicationExportPath: h.OfflineReplicationExportPath,
		OfflineReplicationImportPath: h.OfflineReplicationImportPath,
		OnlineReplicationStartTime:   h.OnlineReplicationStartTime,
		RecoveryPoints:               h.RecoveryPoints,
		ReplicaDeletion:              h.ReplicaDeletion,
		ReplicationPort:              h.ReplicationPort,
	}
}

// GetPolicyProviderSpecificInput implements the PolicyProviderSpecificInputClassification interface for type HyperVReplicaBluePolicyInput.
func (h *HyperVReplicaBluePolicyInput) GetPolicyProviderSpecificInput() *PolicyProviderSpecificInput {
	return &PolicyProviderSpecificInput{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaBlueReplicationDetails - HyperV replica 2012 R2 (Blue) replication details.
type HyperVReplicaBlueReplicationDetails struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string

	// Initial replication details.
	InitialReplicationDetails *InitialReplicationDetails

	// The Last replication time.
	LastReplicatedTime *time.Time

	// VM disk details.
	VMDiskDetails []*DiskDetails

	// The virtual machine Id.
	VMID *string

	// The PE Network details.
	VMNics []*VMNicDetails

	// The protection state for the vm.
	VMProtectionState *string

	// The protection state description for the vm.
	VMProtectionStateDescription *string
}

// GetReplicationProviderSpecificSettings implements the ReplicationProviderSpecificSettingsClassification interface for type
// HyperVReplicaBlueReplicationDetails.
func (h *HyperVReplicaBlueReplicationDetails) GetReplicationProviderSpecificSettings() *ReplicationProviderSpecificSettings {
	return &ReplicationProviderSpecificSettings{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaPolicyDetails - Hyper-V Replica Blue specific protection profile details.
type HyperVReplicaPolicyDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// A value indicating the authentication type.
	AllowedAuthenticationType *int32

	// A value indicating the application consistent frequency.
	ApplicationConsistentSnapshotFrequencyInHours *int32

	// A value indicating whether compression has to be enabled.
	Compression *string

	// A value indicating whether IR is online.
	InitialReplicationMethod *string

	// A value indicating the offline IR export path.
	OfflineReplicationExportPath *string

	// A value indicating the offline IR import path.
	OfflineReplicationImportPath *string

	// A value indicating the online IR start time.
	OnlineReplicationStartTime *string

	// A value indicating the number of recovery points.
	RecoveryPoints *int32

	// A value indicating whether the VM has to be auto deleted. Supported Values: String.Empty, None, OnRecoveryCloud
	ReplicaDeletionOption *string

	// A value indicating the recovery HTTPS port.
	ReplicationPort *int32
}

// GetPolicyProviderSpecificDetails implements the PolicyProviderSpecificDetailsClassification interface for type HyperVReplicaPolicyDetails.
func (h *HyperVReplicaPolicyDetails) GetPolicyProviderSpecificDetails() *PolicyProviderSpecificDetails {
	return &PolicyProviderSpecificDetails{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaPolicyInput - Hyper-V Replica specific policy Input.
type HyperVReplicaPolicyInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// A value indicating the authentication type.
	AllowedAuthenticationType *int32

	// A value indicating the application consistent frequency.
	ApplicationConsistentSnapshotFrequencyInHours *int32

	// A value indicating whether compression has to be enabled.
	Compression *string

	// A value indicating whether IR is online.
	InitialReplicationMethod *string

	// A value indicating the offline IR export path.
	OfflineReplicationExportPath *string

	// A value indicating the offline IR import path.
	OfflineReplicationImportPath *string

	// A value indicating the online IR start time.
	OnlineReplicationStartTime *string

	// A value indicating the number of recovery points.
	RecoveryPoints *int32

	// A value indicating whether the VM has to be auto deleted.
	ReplicaDeletion *string

	// A value indicating the recovery HTTPS port.
	ReplicationPort *int32
}

// GetHyperVReplicaPolicyInput implements the HyperVReplicaPolicyInputClassification interface for type HyperVReplicaPolicyInput.
func (h *HyperVReplicaPolicyInput) GetHyperVReplicaPolicyInput() *HyperVReplicaPolicyInput { return h }

// GetPolicyProviderSpecificInput implements the PolicyProviderSpecificInputClassification interface for type HyperVReplicaPolicyInput.
func (h *HyperVReplicaPolicyInput) GetPolicyProviderSpecificInput() *PolicyProviderSpecificInput {
	return &PolicyProviderSpecificInput{
		InstanceType: h.InstanceType,
	}
}

// HyperVReplicaReplicationDetails - HyperV replica 2012 replication details.
type HyperVReplicaReplicationDetails struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string

	// Initial replication details.
	InitialReplicationDetails *InitialReplicationDetails

	// The Last replication time.
	LastReplicatedTime *time.Time

	// VM disk details.
	VMDiskDetails []*DiskDetails

	// The virtual machine Id.
	VMID *string

	// The PE Network details.
	VMNics []*VMNicDetails

	// The protection state for the vm.
	VMProtectionState *string

	// The protection state description for the vm.
	VMProtectionStateDescription *string
}

// GetReplicationProviderSpecificSettings implements the ReplicationProviderSpecificSettingsClassification interface for type
// HyperVReplicaReplicationDetails.
func (h *HyperVReplicaReplicationDetails) GetReplicationProviderSpecificSettings() *ReplicationProviderSpecificSettings {
	return &ReplicationProviderSpecificSettings{
		InstanceType: h.InstanceType,
	}
}

// HyperVSiteDetails - HyperVSite fabric specific details.
type HyperVSiteDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// The list of Hyper-V hosts associated with the fabric.
	HyperVHosts []*HyperVHostDetails
}

// GetFabricSpecificDetails implements the FabricSpecificDetailsClassification interface for type HyperVSiteDetails.
func (h *HyperVSiteDetails) GetFabricSpecificDetails() *FabricSpecificDetails {
	return &FabricSpecificDetails{
		InstanceType: h.InstanceType,
	}
}

// HyperVVirtualMachineDetails - Single Host fabric provider specific VM settings.
type HyperVVirtualMachineDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// The Last successful failover time.
	DiskDetails []*DiskDetails

	// The id of the object in fabric.
	Generation *string

	// A value indicating whether the VM has a fibre channel adapter attached. String value of SrsDataContract.PresenceStatus
	// enum.
	HasFibreChannelAdapter *PresenceStatus

	// A value indicating whether the VM has a physical disk attached. String value of SrsDataContract.PresenceStatus enum.
	HasPhysicalDisk *PresenceStatus

	// A value indicating whether the VM has a shared VHD attached. String value of SrsDataContract.PresenceStatus enum.
	HasSharedVhd *PresenceStatus

	// The Id of the hyper-v host in fabric.
	HyperVHostID *string

	// The Last replication time.
	OSDetails *OSDetails

	// The source id of the object.
	SourceItemID *string
}

// GetConfigurationSettings implements the ConfigurationSettingsClassification interface for type HyperVVirtualMachineDetails.
func (h *HyperVVirtualMachineDetails) GetConfigurationSettings() *ConfigurationSettings {
	return &ConfigurationSettings{
		InstanceType: h.InstanceType,
	}
}

// GetHyperVVirtualMachineDetails implements the HyperVVirtualMachineDetailsClassification interface for type HyperVVirtualMachineDetails.
func (h *HyperVVirtualMachineDetails) GetHyperVVirtualMachineDetails() *HyperVVirtualMachineDetails {
	return h
}

type IPConfigDetails struct {
	IPAddressType                   *string
	IsPrimary                       *bool
	IsSeletedForFailover            *bool
	Name                            *string
	RecoveryIPAddressType           *string
	RecoveryLBBackendAddressPoolIDs []*string
	RecoveryPublicIPAddressID       *string
	RecoveryStaticIPAddress         *string
	RecoverySubnetName              *string
	StaticIPAddress                 *string
	SubnetName                      *string
	TfoLBBackendAddressPoolIDs      []*string
	TfoPublicIPAddressID            *string
	TfoStaticIPAddress              *string
	TfoSubnetName                   *string
}

type IPConfigInputDetails struct {
	IPConfigName                    *string
	IsPrimary                       *bool
	IsSeletedForFailover            *bool
	RecoveryLBBackendAddressPoolIDs []*string
	RecoveryPublicIPAddressID       *string
	RecoveryStaticIPAddress         *string
	RecoverySubnetName              *string
	TfoLBBackendAddressPoolIDs      []*string
	TfoPublicIPAddressID            *string
	TfoStaticIPAddress              *string
	TfoSubnetName                   *string
}

// IdentityProviderDetails - Identity provider details.
type IdentityProviderDetails struct {
	// The base authority for Azure Active Directory authentication.
	AADAuthority *string

	// The application/client Id for the service principal with which the on-premise management/data plane components would communicate
	// with our Azure services.
	ApplicationID *string

	// The intended Audience of the service principal with which the on-premise management/data plane components would communicate
	// with our Azure services.
	Audience *string

	// The object Id of the service principal with which the on-premise management/data plane components would communicate with
	// our Azure services.
	ObjectID *string

	// The tenant Id for the service principal with which the on-premise management/data plane components would communicate with
	// our Azure services.
	TenantID *string
}

// IdentityProviderInput - Identity provider input.
type IdentityProviderInput struct {
	// REQUIRED; The base authority for Azure Active Directory authentication.
	AADAuthority *string

	// REQUIRED; The application/client Id for the service principal with which the on-premise management/data plane components
	// would communicate with our Azure services.
	ApplicationID *string

	// REQUIRED; The intended Audience of the service principal with which the on-premise management/data plane components would
	// communicate with our Azure services.
	Audience *string

	// REQUIRED; The object Id of the service principal with which the on-premise management/data plane components would communicate
	// with our Azure services.
	ObjectID *string

	// REQUIRED; The tenant Id for the service principal with which the on-premise management/data plane components would communicate
	// with our Azure services.
	TenantID *string
}

// InMageAgentDetails - The details of the InMage agent.
type InMageAgentDetails struct {
	// Agent expiry date.
	AgentExpiryDate *time.Time

	// A value indicating whether installed agent needs to be updated.
	AgentUpdateStatus *string

	// The agent version.
	AgentVersion *string

	// A value indicating whether reboot is required after update is applied.
	PostUpdateRebootStatus *string
}

// InMageAzureV2ApplyRecoveryPointInput - ApplyRecoveryPoint input specific to InMageAzureV2 provider.
type InMageAzureV2ApplyRecoveryPointInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetApplyRecoveryPointProviderSpecificInput implements the ApplyRecoveryPointProviderSpecificInputClassification interface
// for type InMageAzureV2ApplyRecoveryPointInput.
func (i *InMageAzureV2ApplyRecoveryPointInput) GetApplyRecoveryPointProviderSpecificInput() *ApplyRecoveryPointProviderSpecificInput {
	return &ApplyRecoveryPointProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageAzureV2DiskInputDetails - Disk input details.
type InMageAzureV2DiskInputDetails struct {
	// The DiskEncryptionSet ARM ID.
	DiskEncryptionSetID *string

	// The DiskId.
	DiskID *string

	// The DiskType.
	DiskType *DiskAccountType

	// The LogStorageAccountId.
	LogStorageAccountID *string
}

// InMageAzureV2EnableProtectionInput - VMware Azure specific enable protection input.
type InMageAzureV2EnableProtectionInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// The DiskEncryptionSet ARM Id.
	DiskEncryptionSetID *string

	// The DiskType.
	DiskType *DiskAccountType

	// The disks to include list.
	DisksToInclude []*InMageAzureV2DiskInputDetails

	// The selected option to enable RDP\SSH on target VM after failover. String value of SrsDataContract.EnableRDPOnTargetOption
	// enum.
	EnableRdpOnTargetOption *string

	// License type.
	LicenseType *LicenseType

	// The storage account to be used for logging during replication.
	LogStorageAccountID *string

	// The Master target Id.
	MasterTargetID *string

	// The multi VM group Id.
	MultiVMGroupID *string

	// The multi VM group name.
	MultiVMGroupName *string

	// The Process Server Id.
	ProcessServerID *string

	// The CS account Id.
	RunAsAccountID *string

	// The SQL Server license type.
	SQLServerLicenseType *SQLServerLicenseType

	// The tags for the seed managed disks.
	SeedManagedDiskTags map[string]*string

	// The storage account Id.
	StorageAccountID *string

	// The target availability set ARM Id for resource manager deployment.
	TargetAvailabilitySetID *string

	// The target availability zone.
	TargetAvailabilityZone *string

	// The selected target Azure network Id.
	TargetAzureNetworkID *string

	// The selected target Azure subnet Id.
	TargetAzureSubnetID *string

	// The Id of the target resource group (for classic deployment) in which the failover VM is to be created.
	TargetAzureV1ResourceGroupID *string

	// The Id of the target resource group (for resource manager deployment) in which the failover VM is to be created.
	TargetAzureV2ResourceGroupID *string

	// The target azure VM Name.
	TargetAzureVMName *string

	// The tags for the target managed disks.
	TargetManagedDiskTags map[string]*string

	// The tags for the target NICs.
	TargetNicTags map[string]*string

	// The proximity placement group ARM Id.
	TargetProximityPlacementGroupID *string

	// The target VM size.
	TargetVMSize *string

	// The target VM tags.
	TargetVMTags map[string]*string
}

// GetEnableProtectionProviderSpecificInput implements the EnableProtectionProviderSpecificInputClassification interface for
// type InMageAzureV2EnableProtectionInput.
func (i *InMageAzureV2EnableProtectionInput) GetEnableProtectionProviderSpecificInput() *EnableProtectionProviderSpecificInput {
	return &EnableProtectionProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageAzureV2EventDetails - Model class for event details of a VMwareAzureV2 event.
type InMageAzureV2EventDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// InMage Event Category.
	Category *string

	// InMage Event Component.
	Component *string

	// Corrective Action string for the event.
	CorrectiveAction *string

	// InMage Event Details.
	Details *string

	// InMage Event type. Takes one of the values of InMageDataContract.InMageMonitoringEventType.
	EventType *string

	// VMware Site name.
	SiteName *string

	// InMage Event Summary.
	Summary *string
}

// GetEventProviderSpecificDetails implements the EventProviderSpecificDetailsClassification interface for type InMageAzureV2EventDetails.
func (i *InMageAzureV2EventDetails) GetEventProviderSpecificDetails() *EventProviderSpecificDetails {
	return &EventProviderSpecificDetails{
		InstanceType: i.InstanceType,
	}
}

// InMageAzureV2ManagedDiskDetails - InMageAzureV2 Managed disk details.
type InMageAzureV2ManagedDiskDetails struct {
	// The DiskEncryptionSet ARM ID.
	DiskEncryptionSetID *string

	// The disk id.
	DiskID *string

	// The replica disk type.
	ReplicaDiskType *string

	// Seed managed disk Id.
	SeedManagedDiskID *string

	// The target disk name.
	TargetDiskName *string
}

// InMageAzureV2PolicyDetails - InMage Azure v2 specific protection profile details.
type InMageAzureV2PolicyDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// The app consistent snapshot frequency in minutes.
	AppConsistentFrequencyInMinutes *int32

	// The crash consistent snapshot frequency in minutes.
	CrashConsistentFrequencyInMinutes *int32

	// A value indicating whether multi-VM sync has to be enabled.
	MultiVMSyncStatus *string

	// The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32

	// The recovery point threshold in minutes.
	RecoveryPointThresholdInMinutes *int32
}

// GetPolicyProviderSpecificDetails implements the PolicyProviderSpecificDetailsClassification interface for type InMageAzureV2PolicyDetails.
func (i *InMageAzureV2PolicyDetails) GetPolicyProviderSpecificDetails() *PolicyProviderSpecificDetails {
	return &PolicyProviderSpecificDetails{
		InstanceType: i.InstanceType,
	}
}

// InMageAzureV2PolicyInput - VMWare Azure specific policy Input.
type InMageAzureV2PolicyInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// REQUIRED; A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'.
	MultiVMSyncStatus *SetMultiVMSyncStatus

	// The app consistent snapshot frequency (in minutes).
	AppConsistentFrequencyInMinutes *int32

	// The crash consistent snapshot frequency (in minutes).
	CrashConsistentFrequencyInMinutes *int32

	// The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32

	// The recovery point threshold in minutes.
	RecoveryPointThresholdInMinutes *int32
}

// GetPolicyProviderSpecificInput implements the PolicyProviderSpecificInputClassification interface for type InMageAzureV2PolicyInput.
func (i *InMageAzureV2PolicyInput) GetPolicyProviderSpecificInput() *PolicyProviderSpecificInput {
	return &PolicyProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageAzureV2ProtectedDiskDetails - InMageAzureV2 protected disk details.
type InMageAzureV2ProtectedDiskDetails struct {
	// The disk capacity in bytes.
	DiskCapacityInBytes *int64

	// The disk id.
	DiskID *string

	// The disk name.
	DiskName *string

	// A value indicating whether disk is resized.
	DiskResized *string

	// The disk file system capacity in bytes.
	FileSystemCapacityInBytes *int64

	// The health error code for the disk.
	HealthErrorCode *string

	// The last RPO calculated time.
	LastRpoCalculatedTime *time.Time

	// The Progress Health.
	ProgressHealth *string

	// The Progress Status.
	ProgressStatus *string

	// The protection stage.
	ProtectionStage *string

	// The PS data transit in MB.
	PsDataInMegaBytes *float64

	// The resync duration in seconds.
	ResyncDurationInSeconds *int64

	// The resync last 15 minutes transferred bytes.
	ResyncLast15MinutesTransferredBytes *int64

	// The last data transfer time in UTC.
	ResyncLastDataTransferTimeUTC *time.Time

	// The resync processed bytes.
	ResyncProcessedBytes *int64

	// The resync progress percentage.
	ResyncProgressPercentage *int32

	// A value indicating whether resync is required for this disk.
	ResyncRequired *string

	// The resync start time.
	ResyncStartTime *time.Time

	// The resync total transferred bytes.
	ResyncTotalTransferredBytes *int64

	// The RPO in seconds.
	RpoInSeconds *int64

	// The seconds to take for switch provider.
	SecondsToTakeSwitchProvider *int64

	// The source data transit in MB.
	SourceDataInMegaBytes *float64

	// The target data transit in MB.
	TargetDataInMegaBytes *float64
}

// InMageAzureV2RecoveryPointDetails - InMage Azure V2 provider specific recovery point details.
type InMageAzureV2RecoveryPointDetails struct {
	// REQUIRED; Gets the provider type.
	InstanceType *string

	// A value indicating whether the recovery point is multi VM consistent.
	IsMultiVMSyncPoint *string
}

// GetProviderSpecificRecoveryPointDetails implements the ProviderSpecificRecoveryPointDetailsClassification interface for
// type InMageAzureV2RecoveryPointDetails.
func (i *InMageAzureV2RecoveryPointDetails) GetProviderSpecificRecoveryPointDetails() *ProviderSpecificRecoveryPointDetails {
	return &ProviderSpecificRecoveryPointDetails{
		InstanceType: i.InstanceType,
	}
}

// InMageAzureV2ReplicationDetails - InMageAzureV2 provider specific settings.
type InMageAzureV2ReplicationDetails struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string

	// Agent expiry date.
	AgentExpiryDate *time.Time

	// The agent version.
	AgentVersion *string

	// A value indicating all available inplace OS Upgrade configurations.
	AllAvailableOSUpgradeConfigurations []*OSUpgradeSupportedVersions

	// Azure VM Disk details.
	AzureVMDiskDetails []*AzureVMDiskDetails

	// The target generation for this protected item.
	AzureVMGeneration *string

	// The compressed data change rate in MB.
	CompressedDataRateInMB *float64

	// The datastores of the on-premise machine. Value can be list of strings that contain datastore names.
	Datastores []*string

	// A value indicating the discovery type of the machine. Value can be vCenter or physical.
	DiscoveryType *string

	// A value indicating whether any disk is resized for this VM.
	DiskResized *string

	// The selected option to enable RDP\SSH on target vm after failover. String value of SrsDataContract.EnableRDPOnTargetOption
	// enum.
	EnableRdpOnTargetOption *string

	// The firmware type of this protected item.
	FirmwareType *string

	// The source IP address.
	IPAddress *string

	// The infrastructure VM Id.
	InfrastructureVMID *string

	// A value indicating whether additional IR stats are available or not.
	IsAdditionalStatsAvailable *bool

	// A value indicating whether installed agent needs to be updated.
	IsAgentUpdateRequired *string

	// A value indicating whether the source server requires a restart after update.
	IsRebootAfterUpdateRequired *string

	// The last heartbeat received from the source server.
	LastHeartbeat *time.Time

	// The last RPO calculated time.
	LastRpoCalculatedTime *time.Time

	// The last update time received from on-prem components.
	LastUpdateReceivedTime *time.Time

	// License Type of the VM to be used.
	LicenseType *string

	// The master target Id.
	MasterTargetID *string

	// The multi vm group Id.
	MultiVMGroupID *string

	// The multi vm group name.
	MultiVMGroupName *string

	// A value indicating whether multi vm sync is enabled or disabled.
	MultiVMSyncStatus *string

	// The id of the disk containing the OS.
	OSDiskID *string

	// The type of the OS on the VM.
	OSType *string

	// The OS Version of the protected item.
	OSVersion *string

	// The process server Id.
	ProcessServerID *string

	// The process server name.
	ProcessServerName *string

	// The list of protected disks.
	ProtectedDisks []*InMageAzureV2ProtectedDiskDetails

	// The list of protected managed disks.
	ProtectedManagedDisks []*InMageAzureV2ManagedDiskDetails

	// The protection stage.
	ProtectionStage *string

	// The recovery availability set Id.
	RecoveryAvailabilitySetID *string

	// The ARM id of the log storage account used for replication. This will be set to null if no log storage account was provided
	// during enable protection.
	RecoveryAzureLogStorageAccountID *string

	// The target resource group Id.
	RecoveryAzureResourceGroupID *string

	// The recovery Azure storage account.
	RecoveryAzureStorageAccount *string

	// Recovery Azure given name.
	RecoveryAzureVMName *string

	// The Recovery Azure VM size.
	RecoveryAzureVMSize *string

	// The replica id of the protected item.
	ReplicaID *string

	// The resync progress percentage.
	ResyncProgressPercentage *int32

	// The RPO in seconds.
	RpoInSeconds *int64

	// The SQL Server license type.
	SQLServerLicenseType *string

	// The tags for the seed managed disks.
	SeedManagedDiskTags map[string]*string

	// The selected recovery azure network Id.
	SelectedRecoveryAzureNetworkID *string

	// The selected source nic Id which will be used as the primary nic during failover.
	SelectedSourceNicID *string

	// The test failover virtual network.
	SelectedTfoAzureNetworkID *string

	// The CPU count of the VM on the primary side.
	SourceVMCPUCount *int32

	// The RAM size of the VM on the primary side.
	SourceVMRAMSizeInMB *int32

	// A value indicating the inplace OS Upgrade version.
	SupportedOSVersions []*string

	// The switch provider blocking error information.
	SwitchProviderBlockingErrorDetails []*InMageAzureV2SwitchProviderBlockingErrorDetails

	// The switch provider blocking error information.
	SwitchProviderDetails *InMageAzureV2SwitchProviderDetails

	// The target availability zone.
	TargetAvailabilityZone *string

	// The tags for the target managed disks.
	TargetManagedDiskTags map[string]*string

	// The tags for the target NICs.
	TargetNicTags map[string]*string

	// The target proximity placement group Id.
	TargetProximityPlacementGroupID *string

	// The ARM Id of the target Azure VM. This value will be null until the VM is failed over. Only after failure it will be populated
	// with the ARM Id of the Azure VM.
	TargetVMID *string

	// The target VM tags.
	TargetVMTags map[string]*string

	// The total transferred data in bytes.
	TotalDataTransferred *int64

	// The progress health.
	TotalProgressHealth *string

	// The uncompressed data change rate in MB.
	UncompressedDataRateInMB *float64

	// A value indicating whether managed disks should be used during failover.
	UseManagedDisks *string

	// The vCenter infrastructure Id.
	VCenterInfrastructureID *string

	// The virtual machine Id.
	VMID *string

	// The PE Network details.
	VMNics []*VMNicDetails

	// The protection state for the vm.
	VMProtectionState *string

	// The protection state description for the vm.
	VMProtectionStateDescription *string

	// The validation errors of the on-premise machine Value can be list of validation errors.
	ValidationErrors []*HealthError

	// The OS disk VHD name.
	VhdName *string

	// READ-ONLY; The last recovery point received time.
	LastRecoveryPointReceived *time.Time

	// READ-ONLY; The name of the OS on the VM.
	OSName *string
}

// GetReplicationProviderSpecificSettings implements the ReplicationProviderSpecificSettingsClassification interface for type
// InMageAzureV2ReplicationDetails.
func (i *InMageAzureV2ReplicationDetails) GetReplicationProviderSpecificSettings() *ReplicationProviderSpecificSettings {
	return &ReplicationProviderSpecificSettings{
		InstanceType: i.InstanceType,
	}
}

// InMageAzureV2ReprotectInput - InMageAzureV2 specific provider input.
type InMageAzureV2ReprotectInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// The disks to include list.
	DisksToInclude []*string

	// The storage account to be used for logging during replication.
	LogStorageAccountID *string

	// The Master target Id.
	MasterTargetID *string

	// The Policy Id.
	PolicyID *string

	// The Process Server Id.
	ProcessServerID *string

	// The CS account Id.
	RunAsAccountID *string

	// The storage account id.
	StorageAccountID *string
}

// GetReverseReplicationProviderSpecificInput implements the ReverseReplicationProviderSpecificInputClassification interface
// for type InMageAzureV2ReprotectInput.
func (i *InMageAzureV2ReprotectInput) GetReverseReplicationProviderSpecificInput() *ReverseReplicationProviderSpecificInput {
	return &ReverseReplicationProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageAzureV2SwitchProviderBlockingErrorDetails - InMageAzureV2 switch provider blocking error details.
type InMageAzureV2SwitchProviderBlockingErrorDetails struct {
	// READ-ONLY; The error code.
	ErrorCode *string

	// READ-ONLY; The error message.
	ErrorMessage *string

	// READ-ONLY; The error message parameters.
	ErrorMessageParameters map[string]*string

	// READ-ONLY; The error tags.
	ErrorTags map[string]*string

	// READ-ONLY; The possible causes.
	PossibleCauses *string

	// READ-ONLY; The recommended action.
	RecommendedAction *string
}

// InMageAzureV2SwitchProviderDetails - InMageAzureV2 switch provider details.
type InMageAzureV2SwitchProviderDetails struct {
	// READ-ONLY; The target appliance Id.
	TargetApplianceID *string

	// READ-ONLY; The target fabric Id.
	TargetFabricID *string

	// READ-ONLY; The target resource Id.
	TargetResourceID *string

	// READ-ONLY; The target vault Id.
	TargetVaultID *string
}

// InMageAzureV2SwitchProviderInput - Provider specific input for InMageAzureV2 switch provider.
type InMageAzureV2SwitchProviderInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// REQUIRED; The target appliance Id.
	TargetApplianceID *string

	// REQUIRED; The target fabric Id.
	TargetFabricID *string

	// REQUIRED; The target vault Id.
	TargetVaultID *string
}

// GetSwitchProviderSpecificInput implements the SwitchProviderSpecificInputClassification interface for type InMageAzureV2SwitchProviderInput.
func (i *InMageAzureV2SwitchProviderInput) GetSwitchProviderSpecificInput() *SwitchProviderSpecificInput {
	return &SwitchProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageAzureV2TestFailoverInput - InMageAzureV2 provider specific input for test failover.
type InMageAzureV2TestFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// A value indicating the inplace OS Upgrade version.
	OSUpgradeVersion *string

	// The recovery point id to be passed to test failover to a particular recovery point. In case of latest recovery point, null
	// should be passed.
	RecoveryPointID *string
}

// GetTestFailoverProviderSpecificInput implements the TestFailoverProviderSpecificInputClassification interface for type
// InMageAzureV2TestFailoverInput.
func (i *InMageAzureV2TestFailoverInput) GetTestFailoverProviderSpecificInput() *TestFailoverProviderSpecificInput {
	return &TestFailoverProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageAzureV2UnplannedFailoverInput - InMageAzureV2 provider specific input for unplanned failover.
type InMageAzureV2UnplannedFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// A value indicating the inplace OS Upgrade version.
	OSUpgradeVersion *string

	// The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should
	// be passed.
	RecoveryPointID *string
}

// GetUnplannedFailoverProviderSpecificInput implements the UnplannedFailoverProviderSpecificInputClassification interface
// for type InMageAzureV2UnplannedFailoverInput.
func (i *InMageAzureV2UnplannedFailoverInput) GetUnplannedFailoverProviderSpecificInput() *UnplannedFailoverProviderSpecificInput {
	return &UnplannedFailoverProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageAzureV2UpdateReplicationProtectedItemInput - InMage Azure V2 input to update replication protected item.
type InMageAzureV2UpdateReplicationProtectedItemInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// The recovery Azure resource group Id for classic deployment.
	RecoveryAzureV1ResourceGroupID *string

	// The recovery Azure resource group Id for resource manager deployment.
	RecoveryAzureV2ResourceGroupID *string

	// The SQL Server license type.
	SQLServerLicenseType *SQLServerLicenseType

	// The target availability zone.
	TargetAvailabilityZone *string

	// The tags for the target managed disks.
	TargetManagedDiskTags map[string]*string

	// The tags for the target NICs.
	TargetNicTags map[string]*string

	// The target proximity placement group Id.
	TargetProximityPlacementGroupID *string

	// The target VM tags.
	TargetVMTags map[string]*string

	// A value indicating whether managed disks should be used during failover.
	UseManagedDisks *string

	// The list of disk update properties.
	VMDisks []*UpdateDiskInput
}

// GetUpdateReplicationProtectedItemProviderInput implements the UpdateReplicationProtectedItemProviderInputClassification
// interface for type InMageAzureV2UpdateReplicationProtectedItemInput.
func (i *InMageAzureV2UpdateReplicationProtectedItemInput) GetUpdateReplicationProtectedItemProviderInput() *UpdateReplicationProtectedItemProviderInput {
	return &UpdateReplicationProtectedItemProviderInput{
		InstanceType: i.InstanceType,
	}
}

// InMageBasePolicyDetails - Base class for the policies of providers using InMage replication.
type InMageBasePolicyDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// The app consistent snapshot frequency in minutes.
	AppConsistentFrequencyInMinutes *int32

	// A value indicating whether multi-VM sync has to be enabled.
	MultiVMSyncStatus *string

	// The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32

	// The recovery point threshold in minutes.
	RecoveryPointThresholdInMinutes *int32
}

// GetPolicyProviderSpecificDetails implements the PolicyProviderSpecificDetailsClassification interface for type InMageBasePolicyDetails.
func (i *InMageBasePolicyDetails) GetPolicyProviderSpecificDetails() *PolicyProviderSpecificDetails {
	return &PolicyProviderSpecificDetails{
		InstanceType: i.InstanceType,
	}
}

// InMageDisableProtectionProviderSpecificInput - InMage disable protection provider specific input.
type InMageDisableProtectionProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// A value indicating whether the replica VM should be destroyed or retained. Values from Delete and Retain.
	ReplicaVMDeletionStatus *string
}

// GetDisableProtectionProviderSpecificInput implements the DisableProtectionProviderSpecificInputClassification interface
// for type InMageDisableProtectionProviderSpecificInput.
func (i *InMageDisableProtectionProviderSpecificInput) GetDisableProtectionProviderSpecificInput() *DisableProtectionProviderSpecificInput {
	return &DisableProtectionProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageDiskDetails - VMware/Physical specific Disk Details.
type InMageDiskDetails struct {
	// Whether disk is dynamic disk or basic disk.
	DiskConfiguration *string

	// The disk Id.
	DiskID *string

	// The disk name.
	DiskName *string

	// The disk size in MB.
	DiskSizeInMB *string

	// Whether disk is system disk or data disk.
	DiskType *string

	// Volumes of the disk.
	VolumeList []*DiskVolumeDetails
}

// InMageDiskExclusionInput - DiskExclusionInput when doing enable protection of virtual machine in InMage provider.
type InMageDiskExclusionInput struct {
	// The guest disk signature based option for disk exclusion.
	DiskSignatureOptions []*InMageDiskSignatureExclusionOptions

	// The volume label based option for disk exclusion.
	VolumeOptions []*InMageVolumeExclusionOptions
}

// InMageDiskSignatureExclusionOptions - Guest disk signature based disk exclusion option when doing enable protection of
// virtual machine in InMage provider.
type InMageDiskSignatureExclusionOptions struct {
	// The guest signature of disk to be excluded from replication.
	DiskSignature *string
}

// InMageEnableProtectionInput - VMware Azure specific enable protection input.
type InMageEnableProtectionInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// REQUIRED; The Master Target Id.
	MasterTargetID *string

	// REQUIRED; The multi VM group Id.
	MultiVMGroupID *string

	// REQUIRED; The multi VM group name.
	MultiVMGroupName *string

	// REQUIRED; The Process Server Id.
	ProcessServerID *string

	// REQUIRED; The retention drive to use on the MT.
	RetentionDrive *string

	// The target datastore name.
	DatastoreName *string

	// The enable disk exclusion input.
	DiskExclusionInput *InMageDiskExclusionInput

	// The disks to include list.
	DisksToInclude []*string

	// The CS account Id.
	RunAsAccountID *string

	// The VM Name.
	VMFriendlyName *string
}

// GetEnableProtectionProviderSpecificInput implements the EnableProtectionProviderSpecificInputClassification interface for
// type InMageEnableProtectionInput.
func (i *InMageEnableProtectionInput) GetEnableProtectionProviderSpecificInput() *EnableProtectionProviderSpecificInput {
	return &EnableProtectionProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageFabricSwitchProviderBlockingErrorDetails - InMageFabric switch provider blocking error details.
type InMageFabricSwitchProviderBlockingErrorDetails struct {
	// READ-ONLY; The error code.
	ErrorCode *string

	// READ-ONLY; The error message.
	ErrorMessage *string

	// READ-ONLY; The error message parameters.
	ErrorMessageParameters map[string]*string

	// READ-ONLY; The error tags.
	ErrorTags map[string]*string

	// READ-ONLY; The possible causes.
	PossibleCauses *string

	// READ-ONLY; The recommended action.
	RecommendedAction *string
}

// InMagePolicyDetails - InMage specific protection profile details.
type InMagePolicyDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// The app consistent snapshot frequency in minutes.
	AppConsistentFrequencyInMinutes *int32

	// A value indicating whether multi-VM sync has to be enabled.
	MultiVMSyncStatus *string

	// The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32

	// The recovery point threshold in minutes.
	RecoveryPointThresholdInMinutes *int32
}

// GetPolicyProviderSpecificDetails implements the PolicyProviderSpecificDetailsClassification interface for type InMagePolicyDetails.
func (i *InMagePolicyDetails) GetPolicyProviderSpecificDetails() *PolicyProviderSpecificDetails {
	return &PolicyProviderSpecificDetails{
		InstanceType: i.InstanceType,
	}
}

// InMagePolicyInput - VMWare Azure specific protection profile Input.
type InMagePolicyInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// REQUIRED; A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'.
	MultiVMSyncStatus *SetMultiVMSyncStatus

	// The app consistent snapshot frequency (in minutes).
	AppConsistentFrequencyInMinutes *int32

	// The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32

	// The recovery point threshold in minutes.
	RecoveryPointThresholdInMinutes *int32
}

// GetPolicyProviderSpecificInput implements the PolicyProviderSpecificInputClassification interface for type InMagePolicyInput.
func (i *InMagePolicyInput) GetPolicyProviderSpecificInput() *PolicyProviderSpecificInput {
	return &PolicyProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageProtectedDiskDetails - InMage protected disk details.
type InMageProtectedDiskDetails struct {
	// The disk capacity in bytes.
	DiskCapacityInBytes *int64

	// The disk id.
	DiskID *string

	// The disk name.
	DiskName *string

	// A value indicating whether disk is resized.
	DiskResized *string

	// The file system capacity in bytes.
	FileSystemCapacityInBytes *int64

	// The health error code for the disk.
	HealthErrorCode *string

	// The last RPO calculated time.
	LastRpoCalculatedTime *time.Time

	// The Progress Health.
	ProgressHealth *string

	// The Progress Status.
	ProgressStatus *string

	// The protection stage.
	ProtectionStage *string

	// The PS data transit in MB.
	PsDataInMB *float64

	// The resync duration in seconds.
	ResyncDurationInSeconds *int64

	// The resync last 15 minutes transferred bytes.
	ResyncLast15MinutesTransferredBytes *int64

	// The last data transfer time in UTC.
	ResyncLastDataTransferTimeUTC *time.Time

	// The resync processed bytes.
	ResyncProcessedBytes *int64

	// The resync progress percentage.
	ResyncProgressPercentage *int32

	// A value indicating whether resync is required for this disk.
	ResyncRequired *string

	// The resync start time.
	ResyncStartTime *time.Time

	// The resync total transferred bytes.
	ResyncTotalTransferredBytes *int64

	// The RPO in seconds.
	RpoInSeconds *int64

	// The source data transit in MB.
	SourceDataInMB *float64

	// The target data transit in MB.
	TargetDataInMB *float64
}

// InMageRcmAgentUpgradeBlockingErrorDetails - InMageRcm source agent upgrade blocking error details.
type InMageRcmAgentUpgradeBlockingErrorDetails struct {
	// READ-ONLY; The error code.
	ErrorCode *string

	// READ-ONLY; The error message.
	ErrorMessage *string

	// READ-ONLY; The error message parameters.
	ErrorMessageParameters map[string]*string

	// READ-ONLY; The error tags.
	ErrorTags map[string]*string

	// READ-ONLY; The possible causes.
	PossibleCauses *string

	// READ-ONLY; The recommended action.
	RecommendedAction *string
}

// InMageRcmApplianceDetails - InMageRcm appliance details.
type InMageRcmApplianceDetails struct {
	// READ-ONLY; The DRA.
	Dra *DraDetails

	// READ-ONLY; The fabric ARM Id.
	FabricArmID *string

	// READ-ONLY; The appliance Id.
	ID *string

	// READ-ONLY; The Mars agent.
	MarsAgent *MarsAgentDetails

	// READ-ONLY; The appliance name.
	Name *string

	// READ-ONLY; The process server.
	ProcessServer *ProcessServerDetails

	// READ-ONLY; The push installer.
	PushInstaller *PushInstallerDetails

	// READ-ONLY; The of RCM proxy.
	RcmProxy *RcmProxyDetails

	// READ-ONLY; The replication agent.
	ReplicationAgent *ReplicationAgentDetails

	// READ-ONLY; The reprotect agent.
	ReprotectAgent *ReprotectAgentDetails

	// READ-ONLY; The switch provider blocking error information.
	SwitchProviderBlockingErrorDetails []*InMageRcmFabricSwitchProviderBlockingErrorDetails
}

// InMageRcmApplianceSpecificDetails - InMageRcm appliance specific details.
type InMageRcmApplianceSpecificDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// READ-ONLY; The list of appliances.
	Appliances []*InMageRcmApplianceDetails
}

// GetApplianceSpecificDetails implements the ApplianceSpecificDetailsClassification interface for type InMageRcmApplianceSpecificDetails.
func (i *InMageRcmApplianceSpecificDetails) GetApplianceSpecificDetails() *ApplianceSpecificDetails {
	return &ApplianceSpecificDetails{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmApplyRecoveryPointInput - ApplyRecoveryPoint input specific to InMageRcm provider.
type InMageRcmApplyRecoveryPointInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// REQUIRED; The recovery point Id.
	RecoveryPointID *string
}

// GetApplyRecoveryPointProviderSpecificInput implements the ApplyRecoveryPointProviderSpecificInputClassification interface
// for type InMageRcmApplyRecoveryPointInput.
func (i *InMageRcmApplyRecoveryPointInput) GetApplyRecoveryPointProviderSpecificInput() *ApplyRecoveryPointProviderSpecificInput {
	return &ApplyRecoveryPointProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmDiscoveredProtectedVMDetails - InMageRcm discovered protected VM details.
type InMageRcmDiscoveredProtectedVMDetails struct {
	// READ-ONLY; The SDS created timestamp.
	CreatedTimestamp *time.Time

	// READ-ONLY; The list of datastores.
	Datastores []*string

	// READ-ONLY; The list of IP addresses.
	IPAddresses []*string

	// READ-ONLY; A value indicating whether the VM is deleted.
	IsDeleted *bool

	// READ-ONLY; The last time when SDS information discovered in SRS.
	LastDiscoveryTimeInUTC *time.Time

	// READ-ONLY; The VM's OS name.
	OSName *string

	// READ-ONLY; The VM power status.
	PowerStatus *string

	// READ-ONLY; The SDS updated timestamp.
	UpdatedTimestamp *time.Time

	// READ-ONLY; The VCenter fqdn.
	VCenterFqdn *string

	// READ-ONLY; The VCenter Id.
	VCenterID *string

	// READ-ONLY; The VM fqdn.
	VMFqdn *string

	// READ-ONLY; The VMware tools status.
	VmwareToolsStatus *string
}

// InMageRcmDiskInput - InMageRcm disk input.
type InMageRcmDiskInput struct {
	// REQUIRED; The disk Id.
	DiskID *string

	// REQUIRED; The disk type.
	DiskType *DiskAccountType

	// REQUIRED; The log storage account ARM Id.
	LogStorageAccountID *string

	// The DiskEncryptionSet ARM Id.
	DiskEncryptionSetID *string
}

// InMageRcmDisksDefaultInput - InMageRcm disk input.
type InMageRcmDisksDefaultInput struct {
	// REQUIRED; The disk type.
	DiskType *DiskAccountType

	// REQUIRED; The log storage account ARM Id.
	LogStorageAccountID *string

	// The DiskEncryptionSet ARM Id.
	DiskEncryptionSetID *string
}

// InMageRcmEnableProtectionInput - InMageRcm specific enable protection input.
type InMageRcmEnableProtectionInput struct {
	// REQUIRED; The ARM Id of discovered machine.
	FabricDiscoveryMachineID *string

	// REQUIRED; The class type.
	InstanceType *string

	// REQUIRED; The process server Id.
	ProcessServerID *string

	// REQUIRED; The target resource group ARM Id.
	TargetResourceGroupID *string

	// The default disk input.
	DisksDefault *InMageRcmDisksDefaultInput

	// The disks to include list.
	DisksToInclude []*InMageRcmDiskInput

	// The license type.
	LicenseType *LicenseType

	// The multi VM group name.
	MultiVMGroupName *string

	// The run-as account Id.
	RunAsAccountID *string

	// The target availability set ARM Id.
	TargetAvailabilitySetID *string

	// The target availability zone.
	TargetAvailabilityZone *string

	// The target boot diagnostics storage account ARM Id.
	TargetBootDiagnosticsStorageAccountID *string

	// The selected target network ARM Id.
	TargetNetworkID *string

	// The target proximity placement group Id.
	TargetProximityPlacementGroupID *string

	// The selected target subnet name.
	TargetSubnetName *string

	// The target VM name.
	TargetVMName *string

	// The target VM size.
	TargetVMSize *string

	// The selected test network ARM Id.
	TestNetworkID *string

	// The selected test subnet name.
	TestSubnetName *string
}

// GetEnableProtectionProviderSpecificInput implements the EnableProtectionProviderSpecificInputClassification interface for
// type InMageRcmEnableProtectionInput.
func (i *InMageRcmEnableProtectionInput) GetEnableProtectionProviderSpecificInput() *EnableProtectionProviderSpecificInput {
	return &EnableProtectionProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmEventDetails - Event details for InMageRcm provider.
type InMageRcmEventDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// READ-ONLY; The appliance name.
	ApplianceName *string

	// READ-ONLY; The component display name.
	ComponentDisplayName *string

	// READ-ONLY; The fabric name.
	FabricName *string

	// READ-ONLY; The job Id.
	JobID *string

	// READ-ONLY; The latest agent version.
	LatestAgentVersion *string

	// READ-ONLY; The protected item name.
	ProtectedItemName *string

	// READ-ONLY; The server type.
	ServerType *string

	// READ-ONLY; The protected item name.
	VMName *string
}

// GetEventProviderSpecificDetails implements the EventProviderSpecificDetailsClassification interface for type InMageRcmEventDetails.
func (i *InMageRcmEventDetails) GetEventProviderSpecificDetails() *EventProviderSpecificDetails {
	return &EventProviderSpecificDetails{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmFabricCreationInput - InMageRcm fabric provider specific settings.
type InMageRcmFabricCreationInput struct {
	// REQUIRED; Gets the class type.
	InstanceType *string

	// REQUIRED; The ARM Id of the physical site.
	PhysicalSiteID *string

	// REQUIRED; The identity provider input for source agent authentication.
	SourceAgentIdentity *IdentityProviderInput

	// REQUIRED; The ARM Id of the VMware site.
	VmwareSiteID *string
}

// GetFabricSpecificCreationInput implements the FabricSpecificCreationInputClassification interface for type InMageRcmFabricCreationInput.
func (i *InMageRcmFabricCreationInput) GetFabricSpecificCreationInput() *FabricSpecificCreationInput {
	return &FabricSpecificCreationInput{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmFabricSpecificDetails - InMageRcm fabric specific details.
type InMageRcmFabricSpecificDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// The source agent identity details.
	SourceAgentIdentityDetails *IdentityProviderDetails

	// READ-ONLY; The list of agent details.
	AgentDetails []*AgentDetails

	// READ-ONLY; The control plane Uri.
	ControlPlaneURI *string

	// READ-ONLY; The data plane Uri.
	DataPlaneURI *string

	// READ-ONLY; The list of DRAs.
	Dras []*DraDetails

	// READ-ONLY; The list of Mars agents.
	MarsAgents []*MarsAgentDetails

	// READ-ONLY; The ARM Id of the physical site.
	PhysicalSiteID *string

	// READ-ONLY; The list of process servers.
	ProcessServers []*ProcessServerDetails

	// READ-ONLY; The list of push installers.
	PushInstallers []*PushInstallerDetails

	// READ-ONLY; The list of RCM proxies.
	RcmProxies []*RcmProxyDetails

	// READ-ONLY; The list of replication agents.
	ReplicationAgents []*ReplicationAgentDetails

	// READ-ONLY; The list of reprotect agents.
	ReprotectAgents []*ReprotectAgentDetails

	// READ-ONLY; The service container Id.
	ServiceContainerID *string

	// READ-ONLY; The service endpoint.
	ServiceEndpoint *string

	// READ-ONLY; The service resource Id.
	ServiceResourceID *string

	// READ-ONLY; The ARM Id of the VMware site.
	VmwareSiteID *string
}

// GetFabricSpecificDetails implements the FabricSpecificDetailsClassification interface for type InMageRcmFabricSpecificDetails.
func (i *InMageRcmFabricSpecificDetails) GetFabricSpecificDetails() *FabricSpecificDetails {
	return &FabricSpecificDetails{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmFabricSwitchProviderBlockingErrorDetails - InMageRcmFabric switch provider blocking error details.
type InMageRcmFabricSwitchProviderBlockingErrorDetails struct {
	// READ-ONLY; The error code.
	ErrorCode *string

	// READ-ONLY; The error message.
	ErrorMessage *string

	// READ-ONLY; The error message parameters.
	ErrorMessageParameters map[string]*string

	// READ-ONLY; The error tags.
	ErrorTags map[string]*string

	// READ-ONLY; The possible causes.
	PossibleCauses *string

	// READ-ONLY; The recommended action.
	RecommendedAction *string
}

// InMageRcmFailbackDiscoveredProtectedVMDetails - InMageRcmFailback discovered VM details.
type InMageRcmFailbackDiscoveredProtectedVMDetails struct {
	// READ-ONLY; The SDS created timestamp.
	CreatedTimestamp *time.Time

	// READ-ONLY; The list of datastores.
	Datastores []*string

	// READ-ONLY; The list of IP addresses.
	IPAddresses []*string

	// READ-ONLY; A value indicating whether the VM is deleted.
	IsDeleted *bool

	// READ-ONLY; The last time when SDS information discovered in SRS.
	LastDiscoveryTimeInUTC *time.Time

	// READ-ONLY; The VM's OS name.
	OSName *string

	// READ-ONLY; The VM power status.
	PowerStatus *string

	// READ-ONLY; The SDS updated timestamp.
	UpdatedTimestamp *time.Time

	// READ-ONLY; The VCenter fqdn.
	VCenterFqdn *string

	// READ-ONLY; The VCenter Id.
	VCenterID *string

	// READ-ONLY; The VM fqdn.
	VMFqdn *string

	// READ-ONLY; The VMware tools status.
	VmwareToolsStatus *string
}

// InMageRcmFailbackEventDetails - Event details for InMageRcmFailback provider.
type InMageRcmFailbackEventDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// READ-ONLY; The appliance name.
	ApplianceName *string

	// READ-ONLY; The component display name.
	ComponentDisplayName *string

	// READ-ONLY; The protected item name.
	ProtectedItemName *string

	// READ-ONLY; The server type.
	ServerType *string

	// READ-ONLY; The protected item name.
	VMName *string
}

// GetEventProviderSpecificDetails implements the EventProviderSpecificDetailsClassification interface for type InMageRcmFailbackEventDetails.
func (i *InMageRcmFailbackEventDetails) GetEventProviderSpecificDetails() *EventProviderSpecificDetails {
	return &EventProviderSpecificDetails{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmFailbackMobilityAgentDetails - InMageRcmFailback mobility agent details.
type InMageRcmFailbackMobilityAgentDetails struct {
	// READ-ONLY; The agent version expiry date.
	AgentVersionExpiryDate *time.Time

	// READ-ONLY; The driver version.
	DriverVersion *string

	// READ-ONLY; The driver version expiry date.
	DriverVersionExpiryDate *time.Time

	// READ-ONLY; A value indicating whether agent is upgradeable or not.
	IsUpgradeable *string

	// READ-ONLY; The time of the last heartbeat received from the agent.
	LastHeartbeatUTC *time.Time

	// READ-ONLY; The latest upgradeable version available without reboot.
	LatestUpgradableVersionWithoutReboot *string

	// READ-ONLY; The latest agent version available.
	LatestVersion *string

	// READ-ONLY; The whether update is possible or not.
	ReasonsBlockingUpgrade []*AgentUpgradeBlockedReason

	// READ-ONLY; The agent version.
	Version *string
}

// InMageRcmFailbackNicDetails - InMageRcmFailback NIC details.
type InMageRcmFailbackNicDetails struct {
	// READ-ONLY; The adapter type.
	AdapterType *string

	// READ-ONLY; The mac address.
	MacAddress *string

	// READ-ONLY; The network name.
	NetworkName *string

	// READ-ONLY; The IP address.
	SourceIPAddress *string
}

// InMageRcmFailbackPlannedFailoverProviderInput - Provider specific input for InMageRcmFailback failover.
type InMageRcmFailbackPlannedFailoverProviderInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// REQUIRED; The recovery point type.
	RecoveryPointType *InMageRcmFailbackRecoveryPointType
}

// GetPlannedFailoverProviderSpecificFailoverInput implements the PlannedFailoverProviderSpecificFailoverInputClassification
// interface for type InMageRcmFailbackPlannedFailoverProviderInput.
func (i *InMageRcmFailbackPlannedFailoverProviderInput) GetPlannedFailoverProviderSpecificFailoverInput() *PlannedFailoverProviderSpecificFailoverInput {
	return &PlannedFailoverProviderSpecificFailoverInput{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmFailbackPolicyCreationInput - InMageRcmFailback policy creation input.
type InMageRcmFailbackPolicyCreationInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// The app consistent snapshot frequency (in minutes).
	AppConsistentFrequencyInMinutes *int32

	// The crash consistent snapshot frequency (in minutes).
	CrashConsistentFrequencyInMinutes *int32
}

// GetPolicyProviderSpecificInput implements the PolicyProviderSpecificInputClassification interface for type InMageRcmFailbackPolicyCreationInput.
func (i *InMageRcmFailbackPolicyCreationInput) GetPolicyProviderSpecificInput() *PolicyProviderSpecificInput {
	return &PolicyProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmFailbackPolicyDetails - InMageRcm failback specific policy details.
type InMageRcmFailbackPolicyDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// The app consistent snapshot frequency in minutes.
	AppConsistentFrequencyInMinutes *int32

	// The crash consistent snapshot frequency in minutes.
	CrashConsistentFrequencyInMinutes *int32
}

// GetPolicyProviderSpecificDetails implements the PolicyProviderSpecificDetailsClassification interface for type InMageRcmFailbackPolicyDetails.
func (i *InMageRcmFailbackPolicyDetails) GetPolicyProviderSpecificDetails() *PolicyProviderSpecificDetails {
	return &PolicyProviderSpecificDetails{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmFailbackProtectedDiskDetails - InMageRcmFailback protected disk details.
type InMageRcmFailbackProtectedDiskDetails struct {
	// The initial replication details.
	IrDetails *InMageRcmFailbackSyncDetails

	// The resync details.
	ResyncDetails *InMageRcmFailbackSyncDetails

	// READ-ONLY; The disk capacity in bytes.
	CapacityInBytes *int64

	// READ-ONLY; The data pending at source agent in MB.
	DataPendingAtSourceAgentInMB *float64

	// READ-ONLY; The data pending in log data store in MB.
	DataPendingInLogDataStoreInMB *float64

	// READ-ONLY; The disk Id (reported by source agent).
	DiskID *string

	// READ-ONLY; The disk name.
	DiskName *string

	// READ-ONLY; The disk Uuid (reported by vCenter).
	DiskUUID *string

	// READ-ONLY; A value indicating whether initial replication is complete or not.
	IsInitialReplicationComplete *string

	// READ-ONLY; A value indicating whether the disk is the OS disk.
	IsOSDisk *string

	// READ-ONLY; The last sync time.
	LastSyncTime *time.Time
}

// InMageRcmFailbackReplicationDetails - InMageRcmFailback provider specific details.
type InMageRcmFailbackReplicationDetails struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string

	// The discovered VM information.
	DiscoveredVMDetails *InMageRcmFailbackDiscoveredProtectedVMDetails

	// The mobility agent information.
	MobilityAgentDetails *InMageRcmFailbackMobilityAgentDetails

	// The list of protected disks.
	ProtectedDisks []*InMageRcmFailbackProtectedDiskDetails

	// The network details.
	VMNics []*InMageRcmFailbackNicDetails

	// READ-ONLY; The ARM Id of the azure VM.
	AzureVirtualMachineID *string

	// READ-ONLY; The initial replication processed bytes. This includes sum of total bytes transferred and matched bytes on all
	// selected disks in source VM.
	InitialReplicationProcessedBytes *int64

	// READ-ONLY; The initial replication progress health.
	InitialReplicationProgressHealth *VMReplicationProgressHealth

	// READ-ONLY; The initial replication progress percentage.
	InitialReplicationProgressPercentage *int32

	// READ-ONLY; The initial replication transferred bytes from source VM to target for all selected disks on source VM.
	InitialReplicationTransferredBytes *int64

	// READ-ONLY; The virtual machine internal identifier.
	InternalIdentifier *string

	// READ-ONLY; A value indicating whether agent registration was successful after failover.
	IsAgentRegistrationSuccessfulAfterFailover *bool

	// READ-ONLY; The last planned failover start time.
	LastPlannedFailoverStartTime *time.Time

	// READ-ONLY; The last planned failover status.
	LastPlannedFailoverStatus *PlannedFailoverStatus

	// READ-ONLY; The policy friendly name used by the forward replication.
	LastUsedPolicyFriendlyName *string

	// READ-ONLY; The policy Id used by the forward replication.
	LastUsedPolicyID *string

	// READ-ONLY; The log storage account ARM Id.
	LogStorageAccountID *string

	// READ-ONLY; The multi VM group name.
	MultiVMGroupName *string

	// READ-ONLY; The type of the OS on the VM.
	OSType *string

	// READ-ONLY; The reprotect agent Id.
	ReprotectAgentID *string

	// READ-ONLY; The reprotect agent name.
	ReprotectAgentName *string

	// READ-ONLY; The resync processed bytes. This includes sum of total bytes transferred and matched bytes on all selected disks
	// in source VM.
	ResyncProcessedBytes *int64

	// READ-ONLY; The resync progress health.
	ResyncProgressHealth *VMReplicationProgressHealth

	// READ-ONLY; The resync progress percentage.
	ResyncProgressPercentage *int32

	// READ-ONLY; A value indicating whether resync is required.
	ResyncRequired *string

	// READ-ONLY; The resync state.
	ResyncState *ResyncState

	// READ-ONLY; The resync transferred bytes from source VM to target for all selected disks on source VM.
	ResyncTransferredBytes *int64

	// READ-ONLY; The target datastore name.
	TargetDataStoreName *string

	// READ-ONLY; The target VM name.
	TargetVMName *string

	// READ-ONLY; The target vCenter Id.
	TargetvCenterID *string
}

// GetReplicationProviderSpecificSettings implements the ReplicationProviderSpecificSettingsClassification interface for type
// InMageRcmFailbackReplicationDetails.
func (i *InMageRcmFailbackReplicationDetails) GetReplicationProviderSpecificSettings() *ReplicationProviderSpecificSettings {
	return &ReplicationProviderSpecificSettings{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmFailbackReprotectInput - InMageRcmFailback specific provider input.
type InMageRcmFailbackReprotectInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// REQUIRED; The Policy Id.
	PolicyID *string

	// REQUIRED; The process server Id.
	ProcessServerID *string

	// The run as account Id.
	RunAsAccountID *string
}

// GetReverseReplicationProviderSpecificInput implements the ReverseReplicationProviderSpecificInputClassification interface
// for type InMageRcmFailbackReprotectInput.
func (i *InMageRcmFailbackReprotectInput) GetReverseReplicationProviderSpecificInput() *ReverseReplicationProviderSpecificInput {
	return &ReverseReplicationProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmFailbackSyncDetails - InMageRcmFailback disk level sync details.
type InMageRcmFailbackSyncDetails struct {
	// READ-ONLY; The bytes transferred in last 15 minutes from source VM to target.
	Last15MinutesTransferredBytes *int64

	// READ-ONLY; The time of the last data transfer from source VM to target.
	LastDataTransferTimeUTC *string

	// READ-ONLY; The last refresh time.
	LastRefreshTime *string

	// READ-ONLY; The total processed bytes. This includes bytes that are transferred from source VM to target and matched bytes.
	ProcessedBytes *int64

	// READ-ONLY; The progress health.
	ProgressHealth *DiskReplicationProgressHealth

	// READ-ONLY; Progress in percentage. Progress percentage is calculated based on processed bytes.
	ProgressPercentage *int32

	// READ-ONLY; The start time.
	StartTime *string

	// READ-ONLY; The transferred bytes from source VM to azure for the disk.
	TransferredBytes *int64
}

// InMageRcmLastAgentUpgradeErrorDetails - InMageRcm last source agent upgrade error details.
type InMageRcmLastAgentUpgradeErrorDetails struct {
	// READ-ONLY; The error code.
	ErrorCode *string

	// READ-ONLY; The error message.
	ErrorMessage *string

	// READ-ONLY; The error message parameters.
	ErrorMessageParameters map[string]*string

	// READ-ONLY; The error tags.
	ErrorTags map[string]*string

	// READ-ONLY; The possible causes.
	PossibleCauses *string

	// READ-ONLY; The recommended action.
	RecommendedAction *string
}

// InMageRcmMobilityAgentDetails - InMageRcm mobility agent details.
type InMageRcmMobilityAgentDetails struct {
	// READ-ONLY; The agent version expiry date.
	AgentVersionExpiryDate *time.Time

	// READ-ONLY; The driver version.
	DriverVersion *string

	// READ-ONLY; The driver version expiry date.
	DriverVersionExpiryDate *time.Time

	// READ-ONLY; A value indicating whether agent is upgradeable or not.
	IsUpgradeable *string

	// READ-ONLY; The time of the last heartbeat received from the agent.
	LastHeartbeatUTC *time.Time

	// READ-ONLY; The latest agent version release date.
	LatestAgentReleaseDate *string

	// READ-ONLY; The latest upgradeable version available without reboot.
	LatestUpgradableVersionWithoutReboot *string

	// READ-ONLY; The latest agent version available.
	LatestVersion *string

	// READ-ONLY; The whether update is possible or not.
	ReasonsBlockingUpgrade []*AgentUpgradeBlockedReason

	// READ-ONLY; The agent version.
	Version *string
}

// InMageRcmNicDetails - InMageRcm NIC details.
type InMageRcmNicDetails struct {
	// A value indicating whether this is the primary NIC.
	IsPrimaryNic *string

	// A value indicating whether this NIC is selected for failover.
	IsSelectedForFailover *string

	// The target IP address.
	TargetIPAddress *string

	// The target IP address type.
	TargetIPAddressType *EthernetAddressType

	// Target subnet name.
	TargetSubnetName *string

	// The test IP address.
	TestIPAddress *string

	// The test IP address type.
	TestIPAddressType *EthernetAddressType

	// Test subnet name.
	TestSubnetName *string

	// READ-ONLY; The NIC Id.
	NicID *string

	// READ-ONLY; The source IP address.
	SourceIPAddress *string

	// READ-ONLY; The source IP address type.
	SourceIPAddressType *EthernetAddressType

	// READ-ONLY; Source network Id.
	SourceNetworkID *string

	// READ-ONLY; Source subnet name.
	SourceSubnetName *string
}

// InMageRcmNicInput - InMageRcm NIC input.
type InMageRcmNicInput struct {
	// REQUIRED; A value indicating whether this is the primary NIC.
	IsPrimaryNic *string

	// REQUIRED; The NIC Id.
	NicID *string

	// A value indicating whether this NIC is selected for failover.
	IsSelectedForFailover *string

	// The target static IP address.
	TargetStaticIPAddress *string

	// Target subnet name.
	TargetSubnetName *string

	// The test static IP address.
	TestStaticIPAddress *string

	// The test subnet name.
	TestSubnetName *string
}

// InMageRcmPolicyCreationInput - InMageRcm policy creation input.
type InMageRcmPolicyCreationInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// The app consistent snapshot frequency (in minutes).
	AppConsistentFrequencyInMinutes *int32

	// The crash consistent snapshot frequency (in minutes).
	CrashConsistentFrequencyInMinutes *int32

	// A value indicating whether multi-VM sync has to be enabled.
	EnableMultiVMSync *string

	// The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistoryInMinutes *int32
}

// GetPolicyProviderSpecificInput implements the PolicyProviderSpecificInputClassification interface for type InMageRcmPolicyCreationInput.
func (i *InMageRcmPolicyCreationInput) GetPolicyProviderSpecificInput() *PolicyProviderSpecificInput {
	return &PolicyProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmPolicyDetails - InMageRcm specific policy details.
type InMageRcmPolicyDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// The app consistent snapshot frequency in minutes.
	AppConsistentFrequencyInMinutes *int32

	// The crash consistent snapshot frequency in minutes.
	CrashConsistentFrequencyInMinutes *int32

	// A value indicating whether multi-VM sync has to be enabled.
	EnableMultiVMSync *string

	// The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistoryInMinutes *int32
}

// GetPolicyProviderSpecificDetails implements the PolicyProviderSpecificDetailsClassification interface for type InMageRcmPolicyDetails.
func (i *InMageRcmPolicyDetails) GetPolicyProviderSpecificDetails() *PolicyProviderSpecificDetails {
	return &PolicyProviderSpecificDetails{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmProtectedDiskDetails - InMageRcm protected disk details.
type InMageRcmProtectedDiskDetails struct {
	// The disk type.
	DiskType *DiskAccountType

	// The initial replication details.
	IrDetails *InMageRcmSyncDetails

	// The resync details.
	ResyncDetails *InMageRcmSyncDetails

	// READ-ONLY; The disk capacity in bytes.
	CapacityInBytes *int64

	// READ-ONLY; The data pending at source agent in MB.
	DataPendingAtSourceAgentInMB *float64

	// READ-ONLY; The data pending in log data store in MB.
	DataPendingInLogDataStoreInMB *float64

	// READ-ONLY; The DiskEncryptionSet ARM Id.
	DiskEncryptionSetID *string

	// READ-ONLY; The disk Id.
	DiskID *string

	// READ-ONLY; The disk name.
	DiskName *string

	// READ-ONLY; A value indicating whether initial replication is complete or not.
	IsInitialReplicationComplete *string

	// READ-ONLY; A value indicating whether the disk is the OS disk.
	IsOSDisk *string

	// READ-ONLY; The log storage account ARM Id.
	LogStorageAccountID *string

	// READ-ONLY; The uri of the seed blob.
	SeedBlobURI *string

	// READ-ONLY; The ARM Id of the seed managed disk.
	SeedManagedDiskID *string

	// READ-ONLY; The ARM Id of the target managed disk.
	TargetManagedDiskID *string
}

// InMageRcmProtectionContainerMappingDetails - InMageRcm provider specific container mapping details.
type InMageRcmProtectionContainerMappingDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// READ-ONLY; A value indicating whether the flag for enable agent auto upgrade.
	EnableAgentAutoUpgrade *string
}

// GetProtectionContainerMappingProviderSpecificDetails implements the ProtectionContainerMappingProviderSpecificDetailsClassification
// interface for type InMageRcmProtectionContainerMappingDetails.
func (i *InMageRcmProtectionContainerMappingDetails) GetProtectionContainerMappingProviderSpecificDetails() *ProtectionContainerMappingProviderSpecificDetails {
	return &ProtectionContainerMappingProviderSpecificDetails{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmRecoveryPointDetails - InMageRcm provider specific recovery point details.
type InMageRcmRecoveryPointDetails struct {
	// REQUIRED; Gets the provider type.
	InstanceType *string

	// READ-ONLY; A value indicating whether the recovery point is multi VM consistent.
	IsMultiVMSyncPoint *string
}

// GetProviderSpecificRecoveryPointDetails implements the ProviderSpecificRecoveryPointDetailsClassification interface for
// type InMageRcmRecoveryPointDetails.
func (i *InMageRcmRecoveryPointDetails) GetProviderSpecificRecoveryPointDetails() *ProviderSpecificRecoveryPointDetails {
	return &ProviderSpecificRecoveryPointDetails{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmReplicationDetails - InMageRcm provider specific details.
type InMageRcmReplicationDetails struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string

	// The agent upgrade blocking error information.
	AgentUpgradeBlockingErrorDetails []*InMageRcmAgentUpgradeBlockingErrorDetails

	// The discovered VM details.
	DiscoveredVMDetails *InMageRcmDiscoveredProtectedVMDetails

	// The last agent upgrade error information.
	LastAgentUpgradeErrorDetails []*InMageRcmLastAgentUpgradeErrorDetails

	// License Type of the VM to be used.
	LicenseType *string

	// The mobility agent information.
	MobilityAgentDetails *InMageRcmMobilityAgentDetails

	// The list of protected disks.
	ProtectedDisks []*InMageRcmProtectedDiskDetails

	// The target availability set Id.
	TargetAvailabilitySetID *string

	// The target availability zone.
	TargetAvailabilityZone *string

	// The target boot diagnostics storage account ARM Id.
	TargetBootDiagnosticsStorageAccountID *string

	// The target location.
	TargetLocation *string

	// The target network Id.
	TargetNetworkID *string

	// The target proximity placement group Id.
	TargetProximityPlacementGroupID *string

	// The target resource group Id.
	TargetResourceGroupID *string

	// Target VM name.
	TargetVMName *string

	// The target VM size.
	TargetVMSize *string

	// The test network Id.
	TestNetworkID *string

	// The network details.
	VMNics []*InMageRcmNicDetails

	// READ-ONLY; The agent version to which last agent upgrade was attempted.
	AgentUpgradeAttemptToVersion *string

	// READ-ONLY; The agent upgrade job Id.
	AgentUpgradeJobID *string

	// READ-ONLY; The agent auto upgrade state.
	AgentUpgradeState *MobilityAgentUpgradeState

	// READ-ONLY; The allocated memory in MB.
	AllocatedMemoryInMB *float64

	// READ-ONLY; The type of the discovered VM.
	DiscoveryType *string

	// READ-ONLY; The ARM Id of the discovered VM.
	FabricDiscoveryMachineID *string

	// READ-ONLY; The recovery point Id to which the VM was failed over.
	FailoverRecoveryPointID *string

	// READ-ONLY; The firmware type.
	FirmwareType *string

	// READ-ONLY; The initial replication processed bytes. This includes sum of total bytes transferred and matched bytes on all
	// selected disks in source VM.
	InitialReplicationProcessedBytes *int64

	// READ-ONLY; The initial replication progress health.
	InitialReplicationProgressHealth *VMReplicationProgressHealth

	// READ-ONLY; The initial replication progress percentage. This is calculated based on total bytes processed for all disks
	// in the source VM.
	InitialReplicationProgressPercentage *int32

	// READ-ONLY; The initial replication transferred bytes from source VM to azure for all selected disks on source VM.
	InitialReplicationTransferredBytes *int64

	// READ-ONLY; The virtual machine internal identifier.
	InternalIdentifier *string

	// READ-ONLY; A value indicating whether agent registration was successful after failover.
	IsAgentRegistrationSuccessfulAfterFailover *bool

	// READ-ONLY; A value indicating whether last agent upgrade was successful or not.
	IsLastUpgradeSuccessful *string

	// READ-ONLY; The last agent upgrade type.
	LastAgentUpgradeType *string

	// READ-ONLY; The last recovery point Id.
	LastRecoveryPointID *string

	// READ-ONLY; The last recovery point received time.
	LastRecoveryPointReceived *time.Time

	// READ-ONLY; The last recovery point objective calculated time.
	LastRpoCalculatedTime *time.Time

	// READ-ONLY; The last recovery point objective value.
	LastRpoInSeconds *int64

	// READ-ONLY; The multi VM group name.
	MultiVMGroupName *string

	// READ-ONLY; The type of the OS on the VM.
	OSType *string

	// READ-ONLY; The IP address of the primary network interface.
	PrimaryNicIPAddress *string

	// READ-ONLY; The process server Id.
	ProcessServerID *string

	// READ-ONLY; The process server name.
	ProcessServerName *string

	// READ-ONLY; The processor core count.
	ProcessorCoreCount *int32

	// READ-ONLY; The resync processed bytes. This includes sum of total bytes transferred and matched bytes on all selected disks
	// in source VM.
	ResyncProcessedBytes *int64

	// READ-ONLY; The resync progress health.
	ResyncProgressHealth *VMReplicationProgressHealth

	// READ-ONLY; The resync progress percentage. This is calculated based on total bytes processed for all disks in the source
	// VM.
	ResyncProgressPercentage *int32

	// READ-ONLY; A value indicating whether resync is required.
	ResyncRequired *string

	// READ-ONLY; The resync state.
	ResyncState *ResyncState

	// READ-ONLY; The resync transferred bytes from source VM to azure for all selected disks on source VM.
	ResyncTransferredBytes *int64

	// READ-ONLY; The run-as account Id.
	RunAsAccountID *string

	// READ-ONLY; The replication storage account ARM Id. This is applicable only for the blob based replication test hook.
	StorageAccountID *string

	// READ-ONLY; The target generation.
	TargetGeneration *string
}

// GetReplicationProviderSpecificSettings implements the ReplicationProviderSpecificSettingsClassification interface for type
// InMageRcmReplicationDetails.
func (i *InMageRcmReplicationDetails) GetReplicationProviderSpecificSettings() *ReplicationProviderSpecificSettings {
	return &ReplicationProviderSpecificSettings{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmReprotectInput - InMageRcm specific provider input.
type InMageRcmReprotectInput struct {
	// REQUIRED; The target datastore name.
	DatastoreName *string

	// REQUIRED; The class type.
	InstanceType *string

	// REQUIRED; The log storage account ARM Id.
	LogStorageAccountID *string

	// REQUIRED; The reprotect agent Id.
	ReprotectAgentID *string

	// The Policy Id.
	PolicyID *string
}

// GetReverseReplicationProviderSpecificInput implements the ReverseReplicationProviderSpecificInputClassification interface
// for type InMageRcmReprotectInput.
func (i *InMageRcmReprotectInput) GetReverseReplicationProviderSpecificInput() *ReverseReplicationProviderSpecificInput {
	return &ReverseReplicationProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmSyncDetails - InMageRcm disk level sync details.
type InMageRcmSyncDetails struct {
	// READ-ONLY; The bytes transferred in last 15 minutes from source VM to azure.
	Last15MinutesTransferredBytes *int64

	// READ-ONLY; The time of the last data transfer from source VM to azure.
	LastDataTransferTimeUTC *string

	// READ-ONLY; The last refresh time.
	LastRefreshTime *string

	// READ-ONLY; The total processed bytes. This includes bytes that are transferred from source VM to azure and matched bytes.
	ProcessedBytes *int64

	// READ-ONLY; The progress health.
	ProgressHealth *DiskReplicationProgressHealth

	// READ-ONLY; Progress in percentage. Progress percentage is calculated based on processed bytes.
	ProgressPercentage *int32

	// READ-ONLY; The start time.
	StartTime *string

	// READ-ONLY; The transferred bytes from source VM to azure for the disk.
	TransferredBytes *int64
}

// InMageRcmTestFailoverInput - InMageRcm provider specific input for test failover.
type InMageRcmTestFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// The test network Id.
	NetworkID *string

	// The recovery point id to be passed to test failover to a particular recovery point. In case of latest recovery point, null
	// should be passed.
	RecoveryPointID *string
}

// GetTestFailoverProviderSpecificInput implements the TestFailoverProviderSpecificInputClassification interface for type
// InMageRcmTestFailoverInput.
func (i *InMageRcmTestFailoverInput) GetTestFailoverProviderSpecificInput() *TestFailoverProviderSpecificInput {
	return &TestFailoverProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmUnplannedFailoverInput - InMageRcm provider specific input for unplanned failover.
type InMageRcmUnplannedFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// REQUIRED; A value indicating whether VM is to be shutdown.
	PerformShutdown *string

	// The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should
	// be passed.
	RecoveryPointID *string
}

// GetUnplannedFailoverProviderSpecificInput implements the UnplannedFailoverProviderSpecificInputClassification interface
// for type InMageRcmUnplannedFailoverInput.
func (i *InMageRcmUnplannedFailoverInput) GetUnplannedFailoverProviderSpecificInput() *UnplannedFailoverProviderSpecificInput {
	return &UnplannedFailoverProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmUpdateApplianceForReplicationProtectedItemInput - InMageRcm provider specific input to update appliance for replication
// protected item.
type InMageRcmUpdateApplianceForReplicationProtectedItemInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// The run as account Id.
	RunAsAccountID *string
}

// GetUpdateApplianceForReplicationProtectedItemProviderSpecificInput implements the UpdateApplianceForReplicationProtectedItemProviderSpecificInputClassification
// interface for type InMageRcmUpdateApplianceForReplicationProtectedItemInput.
func (i *InMageRcmUpdateApplianceForReplicationProtectedItemInput) GetUpdateApplianceForReplicationProtectedItemProviderSpecificInput() *UpdateApplianceForReplicationProtectedItemProviderSpecificInput {
	return &UpdateApplianceForReplicationProtectedItemProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmUpdateContainerMappingInput - InMageRcm update protection container mapping.
type InMageRcmUpdateContainerMappingInput struct {
	// REQUIRED; A value indicating whether agent auto upgrade has to be enabled.
	EnableAgentAutoUpgrade *string

	// REQUIRED; The class type.
	InstanceType *string
}

// GetReplicationProviderSpecificUpdateContainerMappingInput implements the ReplicationProviderSpecificUpdateContainerMappingInputClassification
// interface for type InMageRcmUpdateContainerMappingInput.
func (i *InMageRcmUpdateContainerMappingInput) GetReplicationProviderSpecificUpdateContainerMappingInput() *ReplicationProviderSpecificUpdateContainerMappingInput {
	return &ReplicationProviderSpecificUpdateContainerMappingInput{
		InstanceType: i.InstanceType,
	}
}

// InMageRcmUpdateReplicationProtectedItemInput - InMageRcm provider specific input to update replication protected item.
type InMageRcmUpdateReplicationProtectedItemInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// The license type.
	LicenseType *LicenseType

	// The target availability set ARM Id.
	TargetAvailabilitySetID *string

	// The target availability zone.
	TargetAvailabilityZone *string

	// The target boot diagnostics storage account ARM Id.
	TargetBootDiagnosticsStorageAccountID *string

	// The target network ARM Id.
	TargetNetworkID *string

	// The target proximity placement group Id.
	TargetProximityPlacementGroupID *string

	// The target resource group ARM Id.
	TargetResourceGroupID *string

	// The target VM name.
	TargetVMName *string

	// The target VM size.
	TargetVMSize *string

	// The test network ARM Id.
	TestNetworkID *string

	// The list of NIC details.
	VMNics []*InMageRcmNicInput
}

// GetUpdateReplicationProtectedItemProviderInput implements the UpdateReplicationProtectedItemProviderInputClassification
// interface for type InMageRcmUpdateReplicationProtectedItemInput.
func (i *InMageRcmUpdateReplicationProtectedItemInput) GetUpdateReplicationProtectedItemProviderInput() *UpdateReplicationProtectedItemProviderInput {
	return &UpdateReplicationProtectedItemProviderInput{
		InstanceType: i.InstanceType,
	}
}

// InMageReplicationDetails - InMage provider specific settings.
type InMageReplicationDetails struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string

	// The active location of the VM. If the VM is being protected from Azure, this field will take values from { Azure, OnPrem
	// }. If the VM is being protected between two data-centers, this field will be
	// OnPrem always.
	ActiveSiteType *string

	// The agent details.
	AgentDetails *InMageAgentDetails

	// A value indicating the underlying Azure storage account. If the VM is not running in Azure, this value shall be set to
	// null.
	AzureStorageAccountID *string

	// The compressed data change rate in MB.
	CompressedDataRateInMB *float64

	// The collection of Consistency points.
	ConsistencyPoints map[string]*time.Time

	// The datastores of the on-premise machine Value can be list of strings that contain datastore names.
	Datastores []*string

	// A value indicating the discovery type of the machine.
	DiscoveryType *string

	// A value indicating whether any disk is resized for this VM.
	DiskResized *string

	// The source IP address.
	IPAddress *string

	// The infrastructure VM Id.
	InfrastructureVMID *string

	// A value indicating whether additional IR stats are available or not.
	IsAdditionalStatsAvailable *bool

	// The last heartbeat received from the source server.
	LastHeartbeat *time.Time

	// The last RPO calculated time.
	LastRpoCalculatedTime *time.Time

	// The last update time received from on-prem components.
	LastUpdateReceivedTime *time.Time

	// The master target Id.
	MasterTargetID *string

	// The multi vm group Id, if any.
	MultiVMGroupID *string

	// The multi vm group name, if any.
	MultiVMGroupName *string

	// A value indicating whether the multi vm sync is enabled or disabled.
	MultiVMSyncStatus *string

	// The OS details.
	OSDetails *OSDiskDetails

	// The OS Version of the protected item.
	OSVersion *string

	// The process server Id.
	ProcessServerID *string

	// The list of protected disks.
	ProtectedDisks []*InMageProtectedDiskDetails

	// The protection stage.
	ProtectionStage *string

	// A value indicating whether the source server requires a restart after update.
	RebootAfterUpdateStatus *string

	// The replica id of the protected item.
	ReplicaID *string

	// The resync details of the machine.
	ResyncDetails *InitialReplicationDetails

	// The retention window end time.
	RetentionWindowEnd *time.Time

	// The retention window start time.
	RetentionWindowStart *time.Time

	// The RPO in seconds.
	RpoInSeconds *int64

	// The CPU count of the VM on the primary side.
	SourceVMCPUCount *int32

	// The RAM size of the VM on the primary side.
	SourceVMRAMSizeInMB *int32

	// The total transferred data in bytes.
	TotalDataTransferred *int64

	// The progress health.
	TotalProgressHealth *string

	// The uncompressed data change rate in MB.
	UncompressedDataRateInMB *float64

	// The vCenter infrastructure Id.
	VCenterInfrastructureID *string

	// The virtual machine Id.
	VMID *string

	// The PE Network details.
	VMNics []*VMNicDetails

	// The protection state for the vm.
	VMProtectionState *string

	// The protection state description for the vm.
	VMProtectionStateDescription *string

	// The validation errors of the on-premise machine Value can be list of validation errors.
	ValidationErrors []*HealthError
}

// GetReplicationProviderSpecificSettings implements the ReplicationProviderSpecificSettingsClassification interface for type
// InMageReplicationDetails.
func (i *InMageReplicationDetails) GetReplicationProviderSpecificSettings() *ReplicationProviderSpecificSettings {
	return &ReplicationProviderSpecificSettings{
		InstanceType: i.InstanceType,
	}
}

// InMageReprotectInput - InMageAzureV2 specific provider input.
type InMageReprotectInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// REQUIRED; The Master Target Id.
	MasterTargetID *string

	// REQUIRED; The Process Server Id.
	ProcessServerID *string

	// REQUIRED; The Policy Id.
	ProfileID *string

	// REQUIRED; The retention drive to use on the MT.
	RetentionDrive *string

	// The target datastore name.
	DatastoreName *string

	// The enable disk exclusion input.
	DiskExclusionInput *InMageDiskExclusionInput

	// The disks to include list.
	DisksToInclude []*string

	// The CS account Id.
	RunAsAccountID *string
}

// GetReverseReplicationProviderSpecificInput implements the ReverseReplicationProviderSpecificInputClassification interface
// for type InMageReprotectInput.
func (i *InMageReprotectInput) GetReverseReplicationProviderSpecificInput() *ReverseReplicationProviderSpecificInput {
	return &ReverseReplicationProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageTestFailoverInput - Provider specific input for InMage test failover.
type InMageTestFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// The recovery point id to be passed to test failover to a particular recovery point. In case of latest recovery point, null
	// should be passed.
	RecoveryPointID *string

	// The recovery point type. Values from LatestTime, LatestTag or Custom. In the case of custom, the recovery point provided
	// by RecoveryPointId will be used. In the other two cases, recovery point id will
	// be ignored.
	RecoveryPointType *RecoveryPointType
}

// GetTestFailoverProviderSpecificInput implements the TestFailoverProviderSpecificInputClassification interface for type
// InMageTestFailoverInput.
func (i *InMageTestFailoverInput) GetTestFailoverProviderSpecificInput() *TestFailoverProviderSpecificInput {
	return &TestFailoverProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageUnplannedFailoverInput - Provider specific input for InMage unplanned failover.
type InMageUnplannedFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should
	// be passed.
	RecoveryPointID *string

	// The recovery point type. Values from LatestTime, LatestTag or Custom. In the case of custom, the recovery point provided
	// by RecoveryPointId will be used. In the other two cases, recovery point id will
	// be ignored.
	RecoveryPointType *RecoveryPointType
}

// GetUnplannedFailoverProviderSpecificInput implements the UnplannedFailoverProviderSpecificInputClassification interface
// for type InMageUnplannedFailoverInput.
func (i *InMageUnplannedFailoverInput) GetUnplannedFailoverProviderSpecificInput() *UnplannedFailoverProviderSpecificInput {
	return &UnplannedFailoverProviderSpecificInput{
		InstanceType: i.InstanceType,
	}
}

// InMageVolumeExclusionOptions - Guest disk signature based disk exclusion option when doing enable protection of virtual
// machine in InMage provider.
type InMageVolumeExclusionOptions struct {
	// The value indicating whether to exclude multi volume disk or not. If a disk has multiple volumes and one of the volume
	// has label matching with VolumeLabel this disk will be excluded from replication
	// if OnlyExcludeIfSingleVolume is false.
	OnlyExcludeIfSingleVolume *string

	// The volume label. The disk having any volume with this label will be excluded from replication.
	VolumeLabel *string
}

// InconsistentVMDetails - This class stores the monitoring details for consistency check of inconsistent Protected Entity.
type InconsistentVMDetails struct {
	// The Cloud name.
	CloudName *string

	// The list of details regarding state of the Protected Entity in SRS and On prem.
	Details []*string

	// The list of error ids.
	ErrorIDs []*string

	// The Vm name.
	VMName *string
}

// InitialReplicationDetails - Initial replication details.
type InitialReplicationDetails struct {
	// The initial replication progress percentage.
	InitialReplicationProgressPercentage *string

	// Initial replication type.
	InitialReplicationType *string
}

// InlineWorkflowTaskDetails - This class represents the inline workflow task details.
type InlineWorkflowTaskDetails struct {
	// REQUIRED; The type of task details.
	InstanceType *string

	// The child tasks.
	ChildTasks []*ASRTask

	// The list of child workflow ids.
	WorkflowIDs []*string
}

// GetGroupTaskDetails implements the GroupTaskDetailsClassification interface for type InlineWorkflowTaskDetails.
func (i *InlineWorkflowTaskDetails) GetGroupTaskDetails() *GroupTaskDetails {
	return &GroupTaskDetails{
		ChildTasks:   i.ChildTasks,
		InstanceType: i.InstanceType,
	}
}

// InnerHealthError - Implements InnerHealthError class. HealthError object has a list of InnerHealthErrors as child errors.
// InnerHealthError is used because this will prevent an infinite loop of structures when Hydra
// tries to auto-generate the contract. We are exposing the related health errors as inner health errors and all API consumers
// can utilize this in the same fashion as Exception -> InnerException.
type InnerHealthError struct {
	// Error creation time (UTC).
	CreationTimeUTC *time.Time

	// Value indicating whether the health error is customer resolvable.
	CustomerResolvability *HealthErrorCustomerResolvability

	// ID of the entity.
	EntityID *string

	// Category of error.
	ErrorCategory *string

	// Error code.
	ErrorCode *string

	// The health error unique id.
	ErrorID *string

	// Level of error.
	ErrorLevel *string

	// Error message.
	ErrorMessage *string

	// Source of error.
	ErrorSource *string

	// Type of error.
	ErrorType *string

	// Possible causes of error.
	PossibleCauses *string

	// Recommended action to resolve error.
	RecommendedAction *string

	// DRA error message.
	RecoveryProviderErrorMessage *string

	// Summary message of the entity.
	SummaryMessage *string
}

type InputEndpoint struct {
	EndpointName *string
	PrivatePort  *int32
	Protocol     *string
	PublicPort   *int32
}

// Job details.
type Job struct {
	// Resource Location
	Location *string

	// The custom data.
	Properties *JobProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource Name
	Name *string

	// READ-ONLY; Resource Type
	Type *string
}

// JobCollection - Collection of jobs.
type JobCollection struct {
	// The value of next link.
	NextLink *string

	// The list of jobs.
	Value []*Job
}

// JobDetails - Job details based on specific job type.
type JobDetails struct {
	// REQUIRED; Gets the type of job details (see JobDetailsTypes enum for possible values).
	InstanceType *string

	// The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow
	// object details.
	AffectedObjectDetails map[string]*string
}

// GetJobDetails implements the JobDetailsClassification interface for type JobDetails.
func (j *JobDetails) GetJobDetails() *JobDetails { return j }

// JobEntity - This class contains the minimal job details required to navigate to the desired drill down.
type JobEntity struct {
	// The job display name.
	JobFriendlyName *string

	// The job id.
	JobID *string

	// The job name. Enum type ScenarioName.
	JobScenarioName *string

	// The workflow affected object type.
	TargetInstanceType *string

	// The object id.
	TargetObjectID *string

	// The object name.
	TargetObjectName *string
}

// JobErrorDetails - This class contains the error details per object.
type JobErrorDetails struct {
	// The creation time of job error.
	CreationTime *time.Time

	// Error level of error.
	ErrorLevel *string

	// The Provider error details.
	ProviderErrorDetails *ProviderError

	// The Service error details.
	ServiceErrorDetails *ServiceError

	// The Id of the task.
	TaskID *string
}

// JobProperties - Job custom data details.
type JobProperties struct {
	// The activity id.
	ActivityID *string

	// The Allowed action the job.
	AllowedActions []*string

	// The custom job details like test failover job details.
	CustomDetails JobDetailsClassification

	// The end time.
	EndTime *time.Time

	// The errors.
	Errors []*JobErrorDetails

	// The DisplayName.
	FriendlyName *string

	// The ScenarioName.
	ScenarioName *string

	// The start time.
	StartTime *time.Time

	// The status of the Job. It is one of these values - NotStarted, InProgress, Succeeded, Failed, Cancelled, Suspended or Other.
	State *string

	// The description of the state of the Job. For e.g. - For Succeeded state, description can be Completed, PartiallySucceeded,
	// CompletedWithInformation or Skipped.
	StateDescription *string

	// The type of the affected object which is of Microsoft.Azure.SiteRecovery.V20151110.AffectedObjectType class.
	TargetInstanceType *string

	// The affected Object Id.
	TargetObjectID *string

	// The name of the affected object.
	TargetObjectName *string

	// The tasks.
	Tasks []*ASRTask
}

// JobQueryParameter - Query parameter to enumerate jobs.
type JobQueryParameter struct {
	// The type of objects.
	AffectedObjectTypes *string

	// Date time to get jobs upto.
	EndTime *string

	// The Id of the fabric to search jobs under.
	FabricID *string

	// The job Name.
	JobName *string

	// The output type of the jobs.
	JobOutputType *ExportJobOutputSerializationType

	// The states of the job to be filtered can be in.
	JobStatus *string

	// Date time to get jobs from.
	StartTime *string

	// The timezone offset for the location of the request (in minutes).
	TimezoneOffset *float64
}

// JobStatusEventDetails - Model class for event details of a job status event.
type JobStatusEventDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// AffectedObjectType for the event.
	AffectedObjectType *string

	// JobName for the Event.
	JobFriendlyName *string

	// Job arm id for the event.
	JobID *string

	// JobStatus for the Event.
	JobStatus *string
}

// GetEventSpecificDetails implements the EventSpecificDetailsClassification interface for type JobStatusEventDetails.
func (j *JobStatusEventDetails) GetEventSpecificDetails() *EventSpecificDetails {
	return &EventSpecificDetails{
		InstanceType: j.InstanceType,
	}
}

// JobTaskDetails - This class represents a task which is actually a workflow so that one can navigate to its individual drill
// down.
type JobTaskDetails struct {
	// REQUIRED; The type of task details.
	InstanceType *string

	// The job entity.
	JobTask *JobEntity
}

// GetJobTaskDetails implements the JobTaskDetailsClassification interface for type JobTaskDetails.
func (j *JobTaskDetails) GetJobTaskDetails() *JobTaskDetails { return j }

// GetTaskTypeDetails implements the TaskTypeDetailsClassification interface for type JobTaskDetails.
func (j *JobTaskDetails) GetTaskTypeDetails() *TaskTypeDetails {
	return &TaskTypeDetails{
		InstanceType: j.InstanceType,
	}
}

// KeyEncryptionKeyInfo - Key Encryption Key (KEK) information.
type KeyEncryptionKeyInfo struct {
	// The key URL / identifier.
	KeyIdentifier *string

	// The KeyVault resource ARM Id for key.
	KeyVaultResourceArmID *string
}

// LogicalNetwork - Logical network data model.
type LogicalNetwork struct {
	// Resource Location
	Location *string

	// The Logical Network Properties.
	Properties *LogicalNetworkProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource Name
	Name *string

	// READ-ONLY; Resource Type
	Type *string
}

// LogicalNetworkCollection - List of logical networks.
type LogicalNetworkCollection struct {
	// The value of next link.
	NextLink *string

	// The Logical Networks list details.
	Value []*LogicalNetwork
}

// LogicalNetworkProperties - Logical Network Properties.
type LogicalNetworkProperties struct {
	// The Friendly Name.
	FriendlyName *string

	// A value indicating whether logical network definitions are isolated.
	LogicalNetworkDefinitionsStatus *string

	// A value indicating whether logical network is used as private test network by test failover.
	LogicalNetworkUsage *string

	// A value indicating whether Network Virtualization is enabled for the logical network.
	NetworkVirtualizationStatus *string
}

// ManualActionTaskDetails - This class represents the manual action task details.
type ManualActionTaskDetails struct {
	// REQUIRED; The type of task details.
	InstanceType *string

	// The instructions.
	Instructions *string

	// The name.
	Name *string

	// The observation.
	Observation *string
}

// GetTaskTypeDetails implements the TaskTypeDetailsClassification interface for type ManualActionTaskDetails.
func (m *ManualActionTaskDetails) GetTaskTypeDetails() *TaskTypeDetails {
	return &TaskTypeDetails{
		InstanceType: m.InstanceType,
	}
}

// MarsAgentDetails - Mars agent details.
type MarsAgentDetails struct {
	// READ-ONLY; The Mars agent Bios Id.
	BiosID *string

	// READ-ONLY; The fabric object Id.
	FabricObjectID *string

	// READ-ONLY; The Mars agent Fqdn.
	Fqdn *string

	// READ-ONLY; The health of the Mars agent.
	Health *ProtectionHealth

	// READ-ONLY; The health errors.
	HealthErrors []*HealthError

	// READ-ONLY; The Mars agent Id.
	ID *string

	// READ-ONLY; The last heartbeat received from the Mars agent.
	LastHeartbeatUTC *time.Time

	// READ-ONLY; The Mars agent name.
	Name *string

	// READ-ONLY; The version.
	Version *string
}

// MasterTargetServer - Details of a Master Target Server.
type MasterTargetServer struct {
	// Agent expiry date.
	AgentExpiryDate *time.Time

	// The version of the scout component on the server.
	AgentVersion *string

	// Agent version details.
	AgentVersionDetails *VersionDetails

	// The list of data stores in the fabric.
	DataStores []*DataStore

	// Disk count of the master target.
	DiskCount *int32

	// Health errors.
	HealthErrors []*HealthError

	// The server Id.
	ID *string

	// The IP address of the server.
	IPAddress *string

	// The last heartbeat received from the server.
	LastHeartbeat *time.Time

	// MARS agent expiry date.
	MarsAgentExpiryDate *time.Time

	// MARS agent version.
	MarsAgentVersion *string

	// Mars agent version details.
	MarsAgentVersionDetails *VersionDetails

	// The server name.
	Name *string

	// The OS type of the server.
	OSType *string

	// OS Version of the master target.
	OSVersion *string

	// The retention volumes of Master target Server.
	RetentionVolumes []*RetentionVolume

	// Validation errors.
	ValidationErrors []*HealthError

	// Version status.
	VersionStatus *string
}

// MigrateInput - Input for migrate.
type MigrateInput struct {
	// REQUIRED; Migrate input properties.
	Properties *MigrateInputProperties
}

// MigrateInputProperties - Migrate input properties.
type MigrateInputProperties struct {
	// REQUIRED; The provider specific details.
	ProviderSpecificDetails MigrateProviderSpecificInputClassification
}

// MigrateProviderSpecificInput - Migrate provider specific input.
type MigrateProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetMigrateProviderSpecificInput implements the MigrateProviderSpecificInputClassification interface for type MigrateProviderSpecificInput.
func (m *MigrateProviderSpecificInput) GetMigrateProviderSpecificInput() *MigrateProviderSpecificInput {
	return m
}

// MigrationItem - Migration item.
type MigrationItem struct {
	// Resource Location
	Location *string

	// The migration item properties.
	Properties *MigrationItemProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource Name
	Name *string

	// READ-ONLY; Resource Type
	Type *string
}

// MigrationItemCollection - Migration item collection.
type MigrationItemCollection struct {
	// The value of next link.
	NextLink *string

	// The list of migration items.
	Value []*MigrationItem
}

// MigrationItemProperties - Migration item properties.
type MigrationItemProperties struct {
	// The migration provider custom settings.
	ProviderSpecificDetails MigrationProviderSpecificSettingsClassification

	// READ-ONLY; The allowed operations on the migration item based on the current migration state of the item.
	AllowedOperations []*MigrationItemOperation

	// READ-ONLY; The critical past job details.
	CriticalJobHistory []*CriticalJobHistoryDetails

	// READ-ONLY; The current job details.
	CurrentJob *CurrentJobDetails

	// READ-ONLY; The correlation Id for events associated with this migration item.
	EventCorrelationID *string

	// READ-ONLY; The consolidated health.
	Health *ProtectionHealth

	// READ-ONLY; The list of health errors.
	HealthErrors []*HealthError

	// READ-ONLY; The status of the last migration.
	LastMigrationStatus *string

	// READ-ONLY; The last migration time.
	LastMigrationTime *time.Time

	// READ-ONLY; The status of the last test migration.
	LastTestMigrationStatus *string

	// READ-ONLY; The last test migration time.
	LastTestMigrationTime *time.Time

	// READ-ONLY; The on-premise virtual machine name.
	MachineName *string

	// READ-ONLY; The migration status.
	MigrationState *MigrationState

	// READ-ONLY; The migration state description.
	MigrationStateDescription *string

	// READ-ONLY; The name of policy governing this item.
	PolicyFriendlyName *string

	// READ-ONLY; The ARM Id of policy governing this item.
	PolicyID *string

	// READ-ONLY; The recovery services provider ARM Id.
	RecoveryServicesProviderID *string

	// READ-ONLY; The replication status.
	ReplicationStatus *string

	// READ-ONLY; The test migrate state.
	TestMigrateState *TestMigrationState

	// READ-ONLY; The test migrate state description.
	TestMigrateStateDescription *string
}

// MigrationItemsQueryParameter - Query parameter to enumerate migration items.
type MigrationItemsQueryParameter struct {
	// The replication provider type.
	InstanceType *string

	// The source container name filter.
	SourceContainerName *string

	// The source fabric name filter.
	SourceFabricName *string
}

// MigrationProviderSpecificSettings - Migration provider specific settings.
type MigrationProviderSpecificSettings struct {
	// REQUIRED; Gets the instance type.
	InstanceType *string
}

// GetMigrationProviderSpecificSettings implements the MigrationProviderSpecificSettingsClassification interface for type
// MigrationProviderSpecificSettings.
func (m *MigrationProviderSpecificSettings) GetMigrationProviderSpecificSettings() *MigrationProviderSpecificSettings {
	return m
}

// MigrationRecoveryPoint - Recovery point for a migration item.
type MigrationRecoveryPoint struct {
	// Resource Location
	Location *string

	// Recovery point properties.
	Properties *MigrationRecoveryPointProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource Name
	Name *string

	// READ-ONLY; Resource Type
	Type *string
}

// MigrationRecoveryPointCollection - Collection of migration recovery points.
type MigrationRecoveryPointCollection struct {
	// The value of next link.
	NextLink *string

	// The migration recovery point details.
	Value []*MigrationRecoveryPoint
}

// MigrationRecoveryPointProperties - Migration item recovery point properties.
type MigrationRecoveryPointProperties struct {
	// READ-ONLY; The recovery point time.
	RecoveryPointTime *time.Time

	// READ-ONLY; The recovery point type.
	RecoveryPointType *MigrationRecoveryPointType
}

// MobilityServiceUpdate - The Mobility Service update details.
type MobilityServiceUpdate struct {
	// The OS type.
	OSType *string

	// The reboot status of the update - whether it is required or not.
	RebootStatus *string

	// The version of the latest update.
	Version *string
}

// Network model.
type Network struct {
	// Resource Location
	Location *string

	// The Network Properties.
	Properties *NetworkProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource Name
	Name *string

	// READ-ONLY; Resource Type
	Type *string
}

// NetworkCollection - List of networks.
type NetworkCollection struct {
	// The value of next link.
	NextLink *string

	// The Networks list details.
	Value []*Network
}

// NetworkMapping - Network Mapping model. Ideally it should have been possible to inherit this class from prev version in
// InheritedModels as long as there is no difference in structure or method signature. Since there
// were no base Models for certain fields and methods viz NetworkMappingProperties and Load with required return type, the
// class has been introduced in its entirety with references to base models to
// facilitate extensions in subsequent versions.
type NetworkMapping struct {
	// Resource Location
	Location *string

	// The Network Mapping Properties.
	Properties *NetworkMappingProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource Name
	Name *string

	// READ-ONLY; Resource Type
	Type *string
}

// NetworkMappingCollection - List of network mappings. As with NetworkMapping, it should be possible to reuse a prev version
// of this class. It doesn't seem likely this class could be anything more than a slightly bespoke
// collection of NetworkMapping. Hence it makes sense to override Load with Base.NetworkMapping instead of existing CurrentVersion.NetworkMapping.
type NetworkMappingCollection struct {
	// The value of next link.
	NextLink *string

	// The Network Mappings list.
	Value []*NetworkMapping
}

// NetworkMappingFabricSpecificSettings - Network Mapping fabric specific settings.
type NetworkMappingFabricSpecificSettings struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string
}

// GetNetworkMappingFabricSpecificSettings implements the NetworkMappingFabricSpecificSettingsClassification interface for
// type NetworkMappingFabricSpecificSettings.
func (n *NetworkMappingFabricSpecificSettings) GetNetworkMappingFabricSpecificSettings() *NetworkMappingFabricSpecificSettings {
	return n
}

// NetworkMappingProperties - Network Mapping Properties.
type NetworkMappingProperties struct {
	// The fabric specific settings.
	FabricSpecificSettings NetworkMappingFabricSpecificSettingsClassification

	// The primary fabric friendly name.
	PrimaryFabricFriendlyName *string

	// The primary network friendly name.
	PrimaryNetworkFriendlyName *string

	// The primary network id for network mapping.
	PrimaryNetworkID *string

	// The recovery fabric ARM id.
	RecoveryFabricArmID *string

	// The recovery fabric friendly name.
	RecoveryFabricFriendlyName *string

	// The recovery network friendly name.
	RecoveryNetworkFriendlyName *string

	// The recovery network id for network mapping.
	RecoveryNetworkID *string

	// The pairing state for network mapping.
	State *string
}

// NetworkProperties - Network Properties.
type NetworkProperties struct {
	// The Fabric Type.
	FabricType *string

	// The Friendly Name.
	FriendlyName *string

	// The Network Type.
	NetworkType *string

	// The List of subnets.
	Subnets []*Subnet
}

// NewProtectionProfile - New Protection profile input.
type NewProtectionProfile struct {
	// REQUIRED; A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'.
	MultiVMSyncStatus *SetMultiVMSyncStatus

	// REQUIRED; The protection profile input.
	PolicyName *string

	// REQUIRED; The class type.
	ResourceType *string

	// The app consistent snapshot frequency (in minutes).
	AppConsistentFrequencyInMinutes *int32

	// The crash consistent snapshot frequency (in minutes).
	CrashConsistentFrequencyInMinutes *int32

	// The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32
}

// GetProtectionProfileCustomDetails implements the ProtectionProfileCustomDetailsClassification interface for type NewProtectionProfile.
func (n *NewProtectionProfile) GetProtectionProfileCustomDetails() *ProtectionProfileCustomDetails {
	return &ProtectionProfileCustomDetails{
		ResourceType: n.ResourceType,
	}
}

// NewRecoveryVirtualNetwork - Recovery virtual network input to create new virtual network from given source network.
type NewRecoveryVirtualNetwork struct {
	// REQUIRED; The class type.
	ResourceType *string

	// The recovery virtual network name.
	RecoveryVirtualNetworkName *string

	// The name of the resource group to be used to create the recovery virtual network. If absent, target network would be created
	// in the same resource group as target VM.
	RecoveryVirtualNetworkResourceGroupName *string
}

// GetRecoveryVirtualNetworkCustomDetails implements the RecoveryVirtualNetworkCustomDetailsClassification interface for type
// NewRecoveryVirtualNetwork.
func (n *NewRecoveryVirtualNetwork) GetRecoveryVirtualNetworkCustomDetails() *RecoveryVirtualNetworkCustomDetails {
	return &RecoveryVirtualNetworkCustomDetails{
		ResourceType: n.ResourceType,
	}
}

// OSDetails - Disk Details.
type OSDetails struct {
	// The OSEdition.
	OSEdition *string

	// The OS Major Version.
	OSMajorVersion *string

	// The OS Minor Version.
	OSMinorVersion *string

	// VM Disk details.
	OSType *string

	// The OS Version.
	OSVersion *string

	// Product type.
	ProductType *string
}

// OSDiskDetails - Details of the OS Disk.
type OSDiskDetails struct {
	// The type of the OS on the VM.
	OSType *string

	// The id of the disk containing the OS.
	OSVhdID *string

	// The OS disk VHD name.
	VhdName *string
}

// OSUpgradeSupportedVersions - Supported OS upgrade versions.
type OSUpgradeSupportedVersions struct {
	// READ-ONLY; The source OS version name.
	SupportedSourceOsVersion *string

	// READ-ONLY; The target OS version names.
	SupportedTargetOsVersions []*string
}

// OSVersionWrapper - Wrapper model for OSVersion to include version and service pack info.
type OSVersionWrapper struct {
	// The service pack.
	ServicePack *string

	// The version.
	Version *string
}

// OperationsDiscovery - Operations discovery class.
type OperationsDiscovery struct {
	// Object type.
	Display *Display

	// Name of the API. The name of the operation being performed on this particular object. It should match the action name that
	// appears in RBAC / the event service. Examples of operations include: *
	// Microsoft.Compute/virtualMachine/capture/action * Microsoft.Compute/virtualMachine/restart/action * Microsoft.Compute/virtualMachine/write
	// * Microsoft.Compute/virtualMachine/read *
	// Microsoft.Compute/virtualMachine/delete Each action should include, in order: (1) Resource Provider Namespace (2) Type
	// hierarchy for which the action applies (e.g. server/databases for a SQL Azure
	// database) (3) Read, Write, Action or Delete indicating which type applies. If it is a PUT/PATCH on a collection or named
	// value, Write should be used. If it is a GET, Read should be used. If it is a
	// DELETE, Delete should be used. If it is a POST, Action should be used. As a note: all resource providers would need to
	// include the "{Resource Provider Namespace}/register/action" operation in their
	// response. This API is used to register for their service, and should include details about the operation (e.g. a localized
	// name for the resource provider + any special considerations like PII
	// release).
	Name *string

	// Origin. The intended executor of the operation; governs the display of the operation in the RBAC UX and the audit logs
	// UX. Default value is "user,system".
	Origin *string

	// Properties. Reserved for future use.
	Properties any
}

// OperationsDiscoveryCollection - Collection of ClientDiscovery details.
type OperationsDiscoveryCollection struct {
	// The value of next link.
	NextLink *string

	// The ClientDiscovery details.
	Value []*OperationsDiscovery
}

// PauseReplicationInput - Pause replication input.
type PauseReplicationInput struct {
	// REQUIRED; Pause replication input properties.
	Properties *PauseReplicationInputProperties
}

// PauseReplicationInputProperties - Pause replication input properties.
type PauseReplicationInputProperties struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// PlannedFailoverInput - Input definition for planned failover.
type PlannedFailoverInput struct {
	// Planned failover input properties.
	Properties *PlannedFailoverInputProperties
}

// PlannedFailoverInputProperties - Input definition for planned failover input properties.
type PlannedFailoverInputProperties struct {
	// Failover direction.
	FailoverDirection *string

	// Provider specific settings.
	ProviderSpecificDetails PlannedFailoverProviderSpecificFailoverInputClassification
}

// PlannedFailoverProviderSpecificFailoverInput - Provider specific failover input.
type PlannedFailoverProviderSpecificFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetPlannedFailoverProviderSpecificFailoverInput implements the PlannedFailoverProviderSpecificFailoverInputClassification
// interface for type PlannedFailoverProviderSpecificFailoverInput.
func (p *PlannedFailoverProviderSpecificFailoverInput) GetPlannedFailoverProviderSpecificFailoverInput() *PlannedFailoverProviderSpecificFailoverInput {
	return p
}

// Policy - Protection profile details.
type Policy struct {
	// Resource Location
	Location *string

	// The custom data.
	Properties *PolicyProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource Name
	Name *string

	// READ-ONLY; Resource Type
	Type *string
}

// PolicyCollection - Protection Profile Collection details.
type PolicyCollection struct {
	// The value of next link.
	NextLink *string

	// The policy details.
	Value []*Policy
}

// PolicyProperties - Protection profile custom data details.
type PolicyProperties struct {
	// The FriendlyName.
	FriendlyName *string

	// The ReplicationChannelSetting.
	ProviderSpecificDetails PolicyProviderSpecificDetailsClassification
}

// PolicyProviderSpecificDetails - Base class for Provider specific details for policies.
type PolicyProviderSpecificDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string
}

// GetPolicyProviderSpecificDetails implements the PolicyProviderSpecificDetailsClassification interface for type PolicyProviderSpecificDetails.
func (p *PolicyProviderSpecificDetails) GetPolicyProviderSpecificDetails() *PolicyProviderSpecificDetails {
	return p
}

// PolicyProviderSpecificInput - Base class for provider specific input.
type PolicyProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetPolicyProviderSpecificInput implements the PolicyProviderSpecificInputClassification interface for type PolicyProviderSpecificInput.
func (p *PolicyProviderSpecificInput) GetPolicyProviderSpecificInput() *PolicyProviderSpecificInput {
	return p
}

// ProcessServer - Details of the Process Server.
type ProcessServer struct {
	// Agent expiry date.
	AgentExpiryDate *time.Time

	// The version of the scout component on the server.
	AgentVersion *string

	// The agent version details.
	AgentVersionDetails *VersionDetails

	// The available memory.
	AvailableMemoryInBytes *int64

	// The available space.
	AvailableSpaceInBytes *int64

	// The percentage of the CPU load.
	CPULoad *string

	// The CPU load status.
	CPULoadStatus *string

	// The Process Server's friendly name.
	FriendlyName *string

	// Health errors.
	HealthErrors []*HealthError

	// The agent generated Id.
	HostID *string

	// The Process Server Id.
	ID *string

	// The IP address of the server.
	IPAddress *string

	// The last heartbeat received from the server.
	LastHeartbeat *time.Time

	// The servers configured with this PS.
	MachineCount *string

	// The memory usage status.
	MemoryUsageStatus *string

	// The list of the mobility service updates available on the Process Server.
	MobilityServiceUpdates []*MobilityServiceUpdate

	// The OS type of the server.
	OSType *string

	// OS Version of the process server. Note: This will get populated if user has CS version greater than 9.12.0.0.
	OSVersion *string

	// The PS service status.
	PsServiceStatus *string

	// The number of replication pairs configured in this PS.
	ReplicationPairCount *string

	// The PS SSL cert expiry date.
	SSLCertExpiryDate *time.Time

	// CS SSL cert expiry date.
	SSLCertExpiryRemainingDays *int32

	// The space usage status.
	SpaceUsageStatus *string

	// The percentage of the system load.
	SystemLoad *string

	// The system load status.
	SystemLoadStatus *string

	// The total memory.
	TotalMemoryInBytes *int64

	// The total space.
	TotalSpaceInBytes *int64

	// Version status.
	VersionStatus *string

	// READ-ONLY; The health of Process Server.
	Health *ProtectionHealth

	// READ-ONLY; The MARS communication status.
	MarsCommunicationStatus *string

	// READ-ONLY; The MARS registration status.
	MarsRegistrationStatus *string

	// READ-ONLY; The process server stats refresh time.
	PsStatsRefreshTime *time.Time

	// READ-ONLY; The throughput in bytes.
	ThroughputInBytes *int64

	// READ-ONLY; The throughput in MBps.
	ThroughputInMBps *int64

	// READ-ONLY; The throughput status.
	ThroughputStatus *string

	// READ-ONLY; The uploading pending data in bytes.
	ThroughputUploadPendingDataInBytes *int64
}

// ProcessServerDetails - Process server details.
type ProcessServerDetails struct {
	// READ-ONLY; The available memory.
	AvailableMemoryInBytes *int64

	// READ-ONLY; The available disk space.
	AvailableSpaceInBytes *int64

	// READ-ONLY; The process server Bios Id.
	BiosID *string

	// READ-ONLY; The disk usage status.
	DiskUsageStatus *RcmComponentStatus

	// READ-ONLY; The fabric object Id.
	FabricObjectID *string

	// READ-ONLY; The process server Fqdn.
	Fqdn *string

	// READ-ONLY; The free disk space percentage.
	FreeSpacePercentage *float64

	// READ-ONLY; The health of the process server.
	Health *ProtectionHealth

	// READ-ONLY; The health errors.
	HealthErrors []*HealthError

	// READ-ONLY; The historic health of the process server based on the health in last 24 hours.
	HistoricHealth *ProtectionHealth

	// READ-ONLY; The process server Id.
	ID *string

	// READ-ONLY; The list of IP addresses for communicating with the RCM component.
	IPAddresses []*string

	// READ-ONLY; The last heartbeat received from the process server.
	LastHeartbeatUTC *time.Time

	// READ-ONLY; The memory usage percentage.
	MemoryUsagePercentage *float64

	// READ-ONLY; The memory usage status.
	MemoryUsageStatus *RcmComponentStatus

	// READ-ONLY; The process server name.
	Name *string

	// READ-ONLY; The processor usage percentage.
	ProcessorUsagePercentage *float64

	// READ-ONLY; The processor usage status.
	ProcessorUsageStatus *RcmComponentStatus

	// READ-ONLY; The protected item count.
	ProtectedItemCount *int32

	// READ-ONLY; The system load.
	SystemLoad *int64

	// READ-ONLY; The system load status.
	SystemLoadStatus *RcmComponentStatus

	// READ-ONLY; The throughput in bytes.
	ThroughputInBytes *int64

	// READ-ONLY; The throughput status.
	ThroughputStatus *RcmComponentStatus

	// READ-ONLY; The uploading pending data in bytes.
	ThroughputUploadPendingDataInBytes *int64

	// READ-ONLY; The total memory.
	TotalMemoryInBytes *int64

	// READ-ONLY; The total disk space.
	TotalSpaceInBytes *int64

	// READ-ONLY; The used memory.
	UsedMemoryInBytes *int64

	// READ-ONLY; The used disk space.
	UsedSpaceInBytes *int64

	// READ-ONLY; The version.
	Version *string
}

// ProtectableItem - Replication protected item.
type ProtectableItem struct {
	// Resource Location
	Location *string

	// The custom data.
	Properties *ProtectableItemProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource Name
	Name *string

	// READ-ONLY; Resource Type
	Type *string
}

// ProtectableItemCollection - Protectable item collection.
type ProtectableItemCollection struct {
	// The value of next link.
	NextLink *string

	// The Protectable item details.
	Value []*ProtectableItem
}

// ProtectableItemProperties - Replication protected item custom data details.
type ProtectableItemProperties struct {
	// The Replication provider custom settings.
	CustomDetails ConfigurationSettingsClassification

	// The name.
	FriendlyName *string

	// The Current protection readiness errors.
	ProtectionReadinessErrors []*string

	// The protection status.
	ProtectionStatus *string

	// The recovery provider ARM Id.
	RecoveryServicesProviderID *string

	// The ARM resource of protected items.
	ReplicationProtectedItemID *string

	// The list of replication providers supported for the protectable item.
	SupportedReplicationProviders []*string
}

// ProtectableItemQueryParameter - Query parameter to enumerate Protectable items.
type ProtectableItemQueryParameter struct {
	// State of the Protectable item query filter.
	State *string
}

// ProtectedItemsQueryParameter - Query parameter to enumerate protected items.
type ProtectedItemsQueryParameter struct {
	// The fabric object Id filter.
	FabricObjectID *string

	// The replication provider type.
	InstanceType *string

	// Whether Multi VM group is auto created or specified by user.
	MultiVMGroupCreateOption *MultiVMGroupCreateOption

	// The process server Id filter.
	ProcessServerID *string

	// The recovery plan filter.
	RecoveryPlanName *string

	// The source fabric location filter.
	SourceFabricLocation *string

	// The source fabric name filter.
	SourceFabricName *string

	// The vCenter name filter.
	VCenterName *string
}

// ProtectionContainer - Protection container details.
type ProtectionContainer struct {
	// Resource Location
	Location *string

	// The custom data.
	Properties *ProtectionContainerProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource Name
	Name *string

	// READ-ONLY; Resource Type
	Type *string
}

// ProtectionContainerCollection - Protection Container collection.
type ProtectionContainerCollection struct {
	// The value of next link.
	NextLink *string

	// The Protection Container details.
	Value []*ProtectionContainer
}

// ProtectionContainerFabricSpecificDetails - Base class for fabric specific details of container.
type ProtectionContainerFabricSpecificDetails struct {
	// READ-ONLY; Gets the class type. Overridden in derived classes.
	InstanceType *string
}

// ProtectionContainerMapping - Protection container mapping object.
type ProtectionContainerMapping struct {
	// Resource Location
	Location *string

	// The custom data.
	Properties *ProtectionContainerMappingProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource Name
	Name *string

	// READ-ONLY; Resource Type
	Type *string
}

// ProtectionContainerMappingCollection - Protection container mapping collection class.
type ProtectionContainerMappingCollection struct {
	// Link to fetch rest of the data.
	NextLink *string

	// List of container mappings.
	Value []*ProtectionContainerMapping
}

// ProtectionContainerMappingProperties - Protection container mapping properties.
type ProtectionContainerMappingProperties struct {
	// Health of pairing.
	Health *string

	// Health error.
	HealthErrorDetails []*HealthError

	// Friendly name of replication policy.
	PolicyFriendlyName *string

	// Policy ARM Id.
	PolicyID *string

	// Provider specific provider details.
	ProviderSpecificDetails ProtectionContainerMappingProviderSpecificDetailsClassification

	// Friendly name of source fabric.
	SourceFabricFriendlyName *string

	// Friendly name of source protection container.
	SourceProtectionContainerFriendlyName *string

	// Association Status.
	State *string

	// Friendly name of target fabric.
	TargetFabricFriendlyName *string

	// Friendly name of paired container.
	TargetProtectionContainerFriendlyName *string

	// Paired protection container ARM ID.
	TargetProtectionContainerID *string
}

// ProtectionContainerMappingProviderSpecificDetails - Container mapping provider specific details.
type ProtectionContainerMappingProviderSpecificDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string
}

// GetProtectionContainerMappingProviderSpecificDetails implements the ProtectionContainerMappingProviderSpecificDetailsClassification
// interface for type ProtectionContainerMappingProviderSpecificDetails.
func (p *ProtectionContainerMappingProviderSpecificDetails) GetProtectionContainerMappingProviderSpecificDetails() *ProtectionContainerMappingProviderSpecificDetails {
	return p
}

// ProtectionContainerProperties - Protection profile custom data details.
type ProtectionContainerProperties struct {
	// Fabric friendly name.
	FabricFriendlyName *string

	// Fabric specific details.
	FabricSpecificDetails *ProtectionContainerFabricSpecificDetails

	// The fabric type.
	FabricType *string

	// The name.
	FriendlyName *string

	// The pairing status of this cloud.
	PairingStatus *string

	// Number of protected PEs.
	ProtectedItemCount *int32

	// The role of this cloud.
	Role *string
}

// ProtectionProfileCustomDetails - Protection Profile custom input.
type ProtectionProfileCustomDetails struct {
	// REQUIRED; The class type.
	ResourceType *string
}

// GetProtectionProfileCustomDetails implements the ProtectionProfileCustomDetailsClassification interface for type ProtectionProfileCustomDetails.
func (p *ProtectionProfileCustomDetails) GetProtectionProfileCustomDetails() *ProtectionProfileCustomDetails {
	return p
}

// ProviderError - This class contains the error details per object.
type ProviderError struct {
	// The Error code.
	ErrorCode *int32

	// The Provider error Id.
	ErrorID *string

	// The Error message.
	ErrorMessage *string

	// The possible causes for the error.
	PossibleCauses *string

	// The recommended action to resolve the error.
	RecommendedAction *string
}

// ProviderSpecificRecoveryPointDetails - Replication provider specific recovery point details.
type ProviderSpecificRecoveryPointDetails struct {
	// REQUIRED; Gets the provider type.
	InstanceType *string
}

// GetProviderSpecificRecoveryPointDetails implements the ProviderSpecificRecoveryPointDetailsClassification interface for
// type ProviderSpecificRecoveryPointDetails.
func (p *ProviderSpecificRecoveryPointDetails) GetProviderSpecificRecoveryPointDetails() *ProviderSpecificRecoveryPointDetails {
	return p
}

// PushInstallerDetails - Push installer details.
type PushInstallerDetails struct {
	// READ-ONLY; The push installer Bios Id.
	BiosID *string

	// READ-ONLY; The fabric object Id.
	FabricObjectID *string

	// READ-ONLY; The push installer Fqdn.
	Fqdn *string

	// READ-ONLY; The health of the push installer.
	Health *ProtectionHealth

	// READ-ONLY; The health errors.
	HealthErrors []*HealthError

	// READ-ONLY; The push installer Id.
	ID *string

	// READ-ONLY; The last heartbeat received from the push installer.
	LastHeartbeatUTC *time.Time

	// READ-ONLY; The push installer name.
	Name *string

	// READ-ONLY; The version.
	Version *string
}

// RcmProxyDetails - RCM proxy details.
type RcmProxyDetails struct {
	// READ-ONLY; The RCM proxy Bios Id.
	BiosID *string

	// READ-ONLY; The client authentication type.
	ClientAuthenticationType *string

	// READ-ONLY; The fabric object Id.
	FabricObjectID *string

	// READ-ONLY; The RCM proxy Fqdn.
	Fqdn *string

	// READ-ONLY; The health of the RCM proxy.
	Health *ProtectionHealth

	// READ-ONLY; The health errors.
	HealthErrors []*HealthError

	// READ-ONLY; The RCM proxy Id.
	ID *string

	// READ-ONLY; The last heartbeat received from the RCM proxy.
	LastHeartbeatUTC *time.Time

	// READ-ONLY; The RCM proxy name.
	Name *string

	// READ-ONLY; The version.
	Version *string
}

// RecoveryAvailabilitySetCustomDetails - Recovery Availability Set custom input.
type RecoveryAvailabilitySetCustomDetails struct {
	// REQUIRED; The class type.
	ResourceType *string
}

// GetRecoveryAvailabilitySetCustomDetails implements the RecoveryAvailabilitySetCustomDetailsClassification interface for
// type RecoveryAvailabilitySetCustomDetails.
func (r *RecoveryAvailabilitySetCustomDetails) GetRecoveryAvailabilitySetCustomDetails() *RecoveryAvailabilitySetCustomDetails {
	return r
}

// RecoveryPlan - Recovery plan details.
type RecoveryPlan struct {
	// Resource Location
	Location *string

	// The custom details.
	Properties *RecoveryPlanProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource Name
	Name *string

	// READ-ONLY; Resource Type
	Type *string
}

// RecoveryPlanA2ADetails - Recovery plan A2A specific details.
type RecoveryPlanA2ADetails struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string

	// The primary extended location.
	PrimaryExtendedLocation *ExtendedLocation

	// The primary zone.
	PrimaryZone *string

	// The recovery extended location.
	RecoveryExtendedLocation *ExtendedLocation

	// The recovery zone.
	RecoveryZone *string
}

// GetRecoveryPlanProviderSpecificDetails implements the RecoveryPlanProviderSpecificDetailsClassification interface for type
// RecoveryPlanA2ADetails.
func (r *RecoveryPlanA2ADetails) GetRecoveryPlanProviderSpecificDetails() *RecoveryPlanProviderSpecificDetails {
	return &RecoveryPlanProviderSpecificDetails{
		InstanceType: r.InstanceType,
	}
}

// RecoveryPlanA2AFailoverInput - Recovery plan A2A failover input.
type RecoveryPlanA2AFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// REQUIRED; The recovery point type.
	RecoveryPointType *A2ARpRecoveryPointType

	// A value indicating whether to use recovery cloud service for TFO or not.
	CloudServiceCreationOption *string

	// A value indicating whether multi VM sync enabled VMs should use multi VM sync points for failover.
	MultiVMSyncPointOption *MultiVMSyncPointOption
}

// GetRecoveryPlanProviderSpecificFailoverInput implements the RecoveryPlanProviderSpecificFailoverInputClassification interface
// for type RecoveryPlanA2AFailoverInput.
func (r *RecoveryPlanA2AFailoverInput) GetRecoveryPlanProviderSpecificFailoverInput() *RecoveryPlanProviderSpecificFailoverInput {
	return &RecoveryPlanProviderSpecificFailoverInput{
		InstanceType: r.InstanceType,
	}
}

// RecoveryPlanA2AInput - Recovery plan A2A input.
type RecoveryPlanA2AInput struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string

	// The primary extended location.
	PrimaryExtendedLocation *ExtendedLocation

	// The primary zone.
	PrimaryZone *string

	// The recovery extended location.
	RecoveryExtendedLocation *ExtendedLocation

	// The recovery zone.
	RecoveryZone *string
}

// GetRecoveryPlanProviderSpecificInput implements the RecoveryPlanProviderSpecificInputClassification interface for type
// RecoveryPlanA2AInput.
func (r *RecoveryPlanA2AInput) GetRecoveryPlanProviderSpecificInput() *RecoveryPlanProviderSpecificInput {
	return &RecoveryPlanProviderSpecificInput{
		InstanceType: r.InstanceType,
	}
}

// RecoveryPlanAction - Recovery plan action details.
type RecoveryPlanAction struct {
	// REQUIRED; The action name.
	ActionName *string

	// REQUIRED; The custom details.
	CustomDetails RecoveryPlanActionDetailsClassification

	// REQUIRED; The list of failover directions.
	FailoverDirections []*PossibleOperationsDirections

	// REQUIRED; The list of failover types.
	FailoverTypes []*ReplicationProtectedItemOperation
}

// RecoveryPlanActionDetails - Recovery plan action custom details.
type RecoveryPlanActionDetails struct {
	// REQUIRED; Gets the type of action details (see RecoveryPlanActionDetailsTypes enum for possible values).
	InstanceType *string
}

// GetRecoveryPlanActionDetails implements the RecoveryPlanActionDetailsClassification interface for type RecoveryPlanActionDetails.
func (r *RecoveryPlanActionDetails) GetRecoveryPlanActionDetails() *RecoveryPlanActionDetails {
	return r
}

// RecoveryPlanAutomationRunbookActionDetails - Recovery plan Automation runbook action details.
type RecoveryPlanAutomationRunbookActionDetails struct {
	// REQUIRED; The fabric location.
	FabricLocation *RecoveryPlanActionLocation

	// REQUIRED; Gets the type of action details (see RecoveryPlanActionDetailsTypes enum for possible values).
	InstanceType *string

	// The runbook ARM Id.
	RunbookID *string

	// The runbook timeout.
	Timeout *string
}

// GetRecoveryPlanActionDetails implements the RecoveryPlanActionDetailsClassification interface for type RecoveryPlanAutomationRunbookActionDetails.
func (r *RecoveryPlanAutomationRunbookActionDetails) GetRecoveryPlanActionDetails() *RecoveryPlanActionDetails {
	return &RecoveryPlanActionDetails{
		InstanceType: r.InstanceType,
	}
}

// RecoveryPlanCollection - Recovery plan collection details.
type RecoveryPlanCollection struct {
	// The value of next link.
	NextLink *string

	// The list of recovery plans.
	Value []*RecoveryPlan
}

// RecoveryPlanGroup - Recovery plan group details.
type RecoveryPlanGroup struct {
	// REQUIRED; The group type.
	GroupType *RecoveryPlanGroupType

	// The end group actions.
	EndGroupActions []*RecoveryPlanAction

	// The list of protected items.
	ReplicationProtectedItems []*RecoveryPlanProtectedItem

	// The start group actions.
	StartGroupActions []*RecoveryPlanAction
}

// RecoveryPlanGroupTaskDetails - This class represents the recovery plan group task.
type RecoveryPlanGroupTaskDetails struct {
	// REQUIRED; The type of task details.
	InstanceType *string

	// The child tasks.
	ChildTasks []*ASRTask

	// The group identifier.
	GroupID *string

	// The name.
	Name *string

	// The group type.
	RpGroupType *string
}

// GetGroupTaskDetails implements the GroupTaskDetailsClassification interface for type RecoveryPlanGroupTaskDetails.
func (r *RecoveryPlanGroupTaskDetails) GetGroupTaskDetails() *GroupTaskDetails {
	return &GroupTaskDetails{
		ChildTasks:   r.ChildTasks,
		InstanceType: r.InstanceType,
	}
}

// GetRecoveryPlanGroupTaskDetails implements the RecoveryPlanGroupTaskDetailsClassification interface for type RecoveryPlanGroupTaskDetails.
func (r *RecoveryPlanGroupTaskDetails) GetRecoveryPlanGroupTaskDetails() *RecoveryPlanGroupTaskDetails {
	return r
}

// RecoveryPlanHyperVReplicaAzureFailbackInput - Recovery plan HVR Azure failback input.
type RecoveryPlanHyperVReplicaAzureFailbackInput struct {
	// REQUIRED; The data sync option.
	DataSyncOption *DataSyncStatus

	// REQUIRED; The class type.
	InstanceType *string

	// REQUIRED; The ALR option.
	RecoveryVMCreationOption *AlternateLocationRecoveryOption
}

// GetRecoveryPlanProviderSpecificFailoverInput implements the RecoveryPlanProviderSpecificFailoverInputClassification interface
// for type RecoveryPlanHyperVReplicaAzureFailbackInput.
func (r *RecoveryPlanHyperVReplicaAzureFailbackInput) GetRecoveryPlanProviderSpecificFailoverInput() *RecoveryPlanProviderSpecificFailoverInput {
	return &RecoveryPlanProviderSpecificFailoverInput{
		InstanceType: r.InstanceType,
	}
}

// RecoveryPlanHyperVReplicaAzureFailoverInput - Recovery plan HVR Azure failover input.
type RecoveryPlanHyperVReplicaAzureFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// The primary KEK certificate PFX.
	PrimaryKekCertificatePfx *string

	// The recovery point type.
	RecoveryPointType *HyperVReplicaAzureRpRecoveryPointType

	// The secondary KEK certificate PFX.
	SecondaryKekCertificatePfx *string
}

// GetRecoveryPlanProviderSpecificFailoverInput implements the RecoveryPlanProviderSpecificFailoverInputClassification interface
// for type RecoveryPlanHyperVReplicaAzureFailoverInput.
func (r *RecoveryPlanHyperVReplicaAzureFailoverInput) GetRecoveryPlanProviderSpecificFailoverInput() *RecoveryPlanProviderSpecificFailoverInput {
	return &RecoveryPlanProviderSpecificFailoverInput{
		InstanceType: r.InstanceType,
	}
}

// RecoveryPlanInMageAzureV2FailoverInput - Recovery plan InMageAzureV2 failover input.
type RecoveryPlanInMageAzureV2FailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// REQUIRED; The recovery point type.
	RecoveryPointType *InMageV2RpRecoveryPointType

	// A value indicating whether multi VM sync enabled VMs should use multi VM sync points for failover.
	UseMultiVMSyncPoint *string
}

// GetRecoveryPlanProviderSpecificFailoverInput implements the RecoveryPlanProviderSpecificFailoverInputClassification interface
// for type RecoveryPlanInMageAzureV2FailoverInput.
func (r *RecoveryPlanInMageAzureV2FailoverInput) GetRecoveryPlanProviderSpecificFailoverInput() *RecoveryPlanProviderSpecificFailoverInput {
	return &RecoveryPlanProviderSpecificFailoverInput{
		InstanceType: r.InstanceType,
	}
}

// RecoveryPlanInMageFailoverInput - Recovery plan InMage failover input.
type RecoveryPlanInMageFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// REQUIRED; The recovery point type.
	RecoveryPointType *RpInMageRecoveryPointType
}

// GetRecoveryPlanProviderSpecificFailoverInput implements the RecoveryPlanProviderSpecificFailoverInputClassification interface
// for type RecoveryPlanInMageFailoverInput.
func (r *RecoveryPlanInMageFailoverInput) GetRecoveryPlanProviderSpecificFailoverInput() *RecoveryPlanProviderSpecificFailoverInput {
	return &RecoveryPlanProviderSpecificFailoverInput{
		InstanceType: r.InstanceType,
	}
}

// RecoveryPlanInMageRcmFailbackFailoverInput - Recovery plan InMageRcmFailback failover input.
type RecoveryPlanInMageRcmFailbackFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// REQUIRED; The recovery point type.
	RecoveryPointType *InMageRcmFailbackRecoveryPointType

	// A value indicating whether multi VM sync enabled VMs should use multi VM sync points for failover.
	UseMultiVMSyncPoint *string
}

// GetRecoveryPlanProviderSpecificFailoverInput implements the RecoveryPlanProviderSpecificFailoverInputClassification interface
// for type RecoveryPlanInMageRcmFailbackFailoverInput.
func (r *RecoveryPlanInMageRcmFailbackFailoverInput) GetRecoveryPlanProviderSpecificFailoverInput() *RecoveryPlanProviderSpecificFailoverInput {
	return &RecoveryPlanProviderSpecificFailoverInput{
		InstanceType: r.InstanceType,
	}
}

// RecoveryPlanInMageRcmFailoverInput - Recovery plan InMageRcm failover input.
type RecoveryPlanInMageRcmFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// REQUIRED; The recovery point type.
	RecoveryPointType *RecoveryPlanPointType

	// A value indicating whether multi VM sync enabled VMs should use multi VM sync points for failover.
	UseMultiVMSyncPoint *string
}

// GetRecoveryPlanProviderSpecificFailoverInput implements the RecoveryPlanProviderSpecificFailoverInputClassification interface
// for type RecoveryPlanInMageRcmFailoverInput.
func (r *RecoveryPlanInMageRcmFailoverInput) GetRecoveryPlanProviderSpecificFailoverInput() *RecoveryPlanProviderSpecificFailoverInput {
	return &RecoveryPlanProviderSpecificFailoverInput{
		InstanceType: r.InstanceType,
	}
}

// RecoveryPlanManualActionDetails - Recovery plan manual action details.
type RecoveryPlanManualActionDetails struct {
	// REQUIRED; Gets the type of action details (see RecoveryPlanActionDetailsTypes enum for possible values).
	InstanceType *string

	// The manual action description.
	Description *string
}

// GetRecoveryPlanActionDetails implements the RecoveryPlanActionDetailsClassification interface for type RecoveryPlanManualActionDetails.
func (r *RecoveryPlanManualActionDetails) GetRecoveryPlanActionDetails() *RecoveryPlanActionDetails {
	return &RecoveryPlanActionDetails{
		InstanceType: r.InstanceType,
	}
}

// RecoveryPlanPlannedFailoverInput - Recovery plan planned failover input.
type RecoveryPlanPlannedFailoverInput struct {
	// REQUIRED; The recovery plan planned failover input properties.
	Properties *RecoveryPlanPlannedFailoverInputProperties
}

// RecoveryPlanPlannedFailoverInputProperties - Recovery plan planned failover input properties.
type RecoveryPlanPlannedFailoverInputProperties struct {
	// REQUIRED; The failover direction.
	FailoverDirection *PossibleOperationsDirections

	// The provider specific properties.
	ProviderSpecificDetails []RecoveryPlanProviderSpecificFailoverInputClassification
}

// RecoveryPlanProperties - Recovery plan properties.
type RecoveryPlanProperties struct {
	// The list of allowed operations.
	AllowedOperations []*string

	// The current scenario details.
	CurrentScenario *CurrentScenarioDetails

	// The recovery plan status.
	CurrentScenarioStatus *string

	// The recovery plan status description.
	CurrentScenarioStatusDescription *string

	// The failover deployment model.
	FailoverDeploymentModel *string

	// The friendly name.
	FriendlyName *string

	// The recovery plan groups.
	Groups []*RecoveryPlanGroup

	// The start time of the last planned failover.
	LastPlannedFailoverTime *time.Time

	// The start time of the last test failover.
	LastTestFailoverTime *time.Time

	// The start time of the last unplanned failover.
	LastUnplannedFailoverTime *time.Time

	// The primary fabric friendly name.
	PrimaryFabricFriendlyName *string

	// The primary fabric Id.
	PrimaryFabricID *string

	// The provider id and provider specific details.
	ProviderSpecificDetails []RecoveryPlanProviderSpecificDetailsClassification

	// The recovery fabric friendly name.
	RecoveryFabricFriendlyName *string

	// The recovery fabric Id.
	RecoveryFabricID *string

	// The list of replication providers.
	ReplicationProviders []*string
}

// RecoveryPlanProtectedItem - Recovery plan protected item.
type RecoveryPlanProtectedItem struct {
	// The ARM Id of the recovery plan protected item.
	ID *string

	// The virtual machine Id.
	VirtualMachineID *string
}

// RecoveryPlanProviderSpecificDetails - Recovery plan provider specific details.
type RecoveryPlanProviderSpecificDetails struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string
}

// GetRecoveryPlanProviderSpecificDetails implements the RecoveryPlanProviderSpecificDetailsClassification interface for type
// RecoveryPlanProviderSpecificDetails.
func (r *RecoveryPlanProviderSpecificDetails) GetRecoveryPlanProviderSpecificDetails() *RecoveryPlanProviderSpecificDetails {
	return r
}

// RecoveryPlanProviderSpecificFailoverInput - Recovery plan provider specific failover input.
type RecoveryPlanProviderSpecificFailoverInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetRecoveryPlanProviderSpecificFailoverInput implements the RecoveryPlanProviderSpecificFailoverInputClassification interface
// for type RecoveryPlanProviderSpecificFailoverInput.
func (r *RecoveryPlanProviderSpecificFailoverInput) GetRecoveryPlanProviderSpecificFailoverInput() *RecoveryPlanProviderSpecificFailoverInput {
	return r
}

// RecoveryPlanProviderSpecificInput - Recovery plan provider specific input base class.
type RecoveryPlanProviderSpecificInput struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string
}

// GetRecoveryPlanProviderSpecificInput implements the RecoveryPlanProviderSpecificInputClassification interface for type
// RecoveryPlanProviderSpecificInput.
func (r *RecoveryPlanProviderSpecificInput) GetRecoveryPlanProviderSpecificInput() *RecoveryPlanProviderSpecificInput {
	return r
}

// RecoveryPlanScriptActionDetails - Recovery plan script action details.
type RecoveryPlanScriptActionDetails struct {
	// REQUIRED; The fabric location.
	FabricLocation *RecoveryPlanActionLocation

	// REQUIRED; Gets the type of action details (see RecoveryPlanActionDetailsTypes enum for possible values).
	InstanceType *string

	// REQUIRED; The script path.
	Path *string

	// The script timeout.
	Timeout *string
}

// GetRecoveryPlanActionDetails implements the RecoveryPlanActionDetailsClassification interface for type RecoveryPlanScriptActionDetails.
func (r *RecoveryPlanScriptActionDetails) GetRecoveryPlanActionDetails() *RecoveryPlanActionDetails {
	return &RecoveryPlanActionDetails{
		InstanceType: r.InstanceType,
	}
}

// RecoveryPlanShutdownGroupTaskDetails - This class represents the recovery plan shutdown group task details.
type RecoveryPlanShutdownGroupTaskDetails struct {
	// REQUIRED; The type of task details.
	InstanceType *string

	// The child tasks.
	ChildTasks []*ASRTask

	// The group identifier.
	GroupID *string

	// The name.
	Name *string

	// The group type.
	RpGroupType *string
}

// GetGroupTaskDetails implements the GroupTaskDetailsClassification interface for type RecoveryPlanShutdownGroupTaskDetails.
func (r *RecoveryPlanShutdownGroupTaskDetails) GetGroupTaskDetails() *GroupTaskDetails {
	return &GroupTaskDetails{
		ChildTasks:   r.ChildTasks,
		InstanceType: r.InstanceType,
	}
}

// GetRecoveryPlanGroupTaskDetails implements the RecoveryPlanGroupTaskDetailsClassification interface for type RecoveryPlanShutdownGroupTaskDetails.
func (r *RecoveryPlanShutdownGroupTaskDetails) GetRecoveryPlanGroupTaskDetails() *RecoveryPlanGroupTaskDetails {
	return &RecoveryPlanGroupTaskDetails{
		ChildTasks:   r.ChildTasks,
		GroupID:      r.GroupID,
		InstanceType: r.InstanceType,
		Name:         r.Name,
		RpGroupType:  r.RpGroupType,
	}
}

// RecoveryPlanTestFailoverCleanupInput - Recovery plan test failover cleanup input.
type RecoveryPlanTestFailoverCleanupInput struct {
	// REQUIRED; The recovery plan test failover cleanup input properties.
	Properties *RecoveryPlanTestFailoverCleanupInputProperties
}

// RecoveryPlanTestFailoverCleanupInputProperties - Recovery plan test failover cleanup input properties.
type RecoveryPlanTestFailoverCleanupInputProperties struct {
	// The test failover cleanup comments.
	Comments *string
}

// RecoveryPlanTestFailoverInput - Recovery plan test failover input.
type RecoveryPlanTestFailoverInput struct {
	// REQUIRED; The recovery plan test failover input properties.
	Properties *RecoveryPlanTestFailoverInputProperties
}

// RecoveryPlanTestFailoverInputProperties - Recovery plan test failover input properties.
type RecoveryPlanTestFailoverInputProperties struct {
	// REQUIRED; The failover direction.
	FailoverDirection *PossibleOperationsDirections

	// REQUIRED; The network type to be used for test failover.
	NetworkType *string

	// The Id of the network to be used for test failover.
	NetworkID *string

	// The provider specific properties.
	ProviderSpecificDetails []RecoveryPlanProviderSpecificFailoverInputClassification
}

// RecoveryPlanUnplannedFailoverInput - Recovery plan unplanned failover input.
type RecoveryPlanUnplannedFailoverInput struct {
	// REQUIRED; The recovery plan unplanned failover input properties.
	Properties *RecoveryPlanUnplannedFailoverInputProperties
}

// RecoveryPlanUnplannedFailoverInputProperties - Recovery plan unplanned failover input properties.
type RecoveryPlanUnplannedFailoverInputProperties struct {
	// REQUIRED; The failover direction.
	FailoverDirection *PossibleOperationsDirections

	// REQUIRED; A value indicating whether source site operations are required.
	SourceSiteOperations *SourceSiteOperations

	// The provider specific properties.
	ProviderSpecificDetails []RecoveryPlanProviderSpecificFailoverInputClassification
}

// RecoveryPoint - Recovery point.
type RecoveryPoint struct {
	// Resource Location
	Location *string

	// The recovery point properties.
	Properties *RecoveryPointProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource Name
	Name *string

	// READ-ONLY; Resource Type
	Type *string
}

// RecoveryPointCollection - Collection of recovery point details.
type RecoveryPointCollection struct {
	// The value of next link.
	NextLink *string

	// The recovery point details.
	Value []*RecoveryPoint
}

// RecoveryPointProperties - Recovery point properties.
type RecoveryPointProperties struct {
	// The provider specific details for the recovery point.
	ProviderSpecificDetails ProviderSpecificRecoveryPointDetailsClassification

	// The recovery point time.
	RecoveryPointTime *time.Time

	// The recovery point type: ApplicationConsistent, CrashConsistent.
	RecoveryPointType *string
}

// RecoveryProximityPlacementGroupCustomDetails - Recovery Proximity placement group custom input.
type RecoveryProximityPlacementGroupCustomDetails struct {
	// REQUIRED; The class type.
	ResourceType *string
}

// GetRecoveryProximityPlacementGroupCustomDetails implements the RecoveryProximityPlacementGroupCustomDetailsClassification
// interface for type RecoveryProximityPlacementGroupCustomDetails.
func (r *RecoveryProximityPlacementGroupCustomDetails) GetRecoveryProximityPlacementGroupCustomDetails() *RecoveryProximityPlacementGroupCustomDetails {
	return r
}

// RecoveryResourceGroupCustomDetails - Recovery Resource Group custom input.
type RecoveryResourceGroupCustomDetails struct {
	// REQUIRED; The class type.
	ResourceType *string
}

// GetRecoveryResourceGroupCustomDetails implements the RecoveryResourceGroupCustomDetailsClassification interface for type
// RecoveryResourceGroupCustomDetails.
func (r *RecoveryResourceGroupCustomDetails) GetRecoveryResourceGroupCustomDetails() *RecoveryResourceGroupCustomDetails {
	return r
}

// RecoveryServicesProvider - Provider details.
type RecoveryServicesProvider struct {
	// Resource Location
	Location *string

	// Provider properties.
	Properties *RecoveryServicesProviderProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource Name
	Name *string

	// READ-ONLY; Resource Type
	Type *string
}

// RecoveryServicesProviderCollection - Collection of providers.
type RecoveryServicesProviderCollection struct {
	// The value of next link.
	NextLink *string

	// The Servers details.
	Value []*RecoveryServicesProvider
}

// RecoveryServicesProviderProperties - Recovery services provider properties.
type RecoveryServicesProviderProperties struct {
	// The scenarios allowed on this provider.
	AllowedScenarios []*string

	// The authentication identity details.
	AuthenticationIdentityDetails *IdentityProviderDetails

	// The Bios Id.
	BiosID *string

	// A value indicating whether DRA is responsive.
	ConnectionStatus *string

	// The data plane authentication identity details.
	DataPlaneAuthenticationIdentityDetails *IdentityProviderDetails

	// The DRA Id.
	DraIdentifier *string

	// The fabric friendly name.
	FabricFriendlyName *string

	// Type of the site.
	FabricType *string

	// Friendly name of the DRA.
	FriendlyName *string

	// The recovery services provider health error details.
	HealthErrorDetails []*HealthError

	// Time when last heartbeat was sent by the DRA.
	LastHeartBeat *time.Time

	// The machine Id.
	MachineID *string

	// The machine name.
	MachineName *string

	// Number of protected VMs currently managed by the DRA.
	ProtectedItemCount *int32

	// The provider version.
	ProviderVersion *string

	// The provider version details.
	ProviderVersionDetails *VersionDetails

	// Expiry date of the version.
	ProviderVersionExpiryDate *time.Time

	// DRA version status.
	ProviderVersionState *string

	// The resource access identity details.
	ResourceAccessIdentityDetails *IdentityProviderDetails

	// The fabric provider.
	ServerVersion *string
}

// RecoveryVirtualNetworkCustomDetails - Recovery Virtual network custom input.
type RecoveryVirtualNetworkCustomDetails struct {
	// REQUIRED; The class type.
	ResourceType *string
}

// GetRecoveryVirtualNetworkCustomDetails implements the RecoveryVirtualNetworkCustomDetailsClassification interface for type
// RecoveryVirtualNetworkCustomDetails.
func (r *RecoveryVirtualNetworkCustomDetails) GetRecoveryVirtualNetworkCustomDetails() *RecoveryVirtualNetworkCustomDetails {
	return r
}

// RemoveDisksInput - Input for remove disk(s) operation.
type RemoveDisksInput struct {
	// Remove disk input properties.
	Properties *RemoveDisksInputProperties
}

// RemoveDisksInputProperties - Remove Disk input properties.
type RemoveDisksInputProperties struct {
	// The ReplicationProviderInput. For HyperVReplicaAzure provider, it will be AzureEnableProtectionInput object. For San provider,
	// it will be SanEnableProtectionInput object. For HyperVReplicaAzure
	// provider, it can be null.
	ProviderSpecificDetails RemoveDisksProviderSpecificInputClassification
}

// RemoveDisksProviderSpecificInput - Remove Disk provider specific input.
type RemoveDisksProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetRemoveDisksProviderSpecificInput implements the RemoveDisksProviderSpecificInputClassification interface for type RemoveDisksProviderSpecificInput.
func (r *RemoveDisksProviderSpecificInput) GetRemoveDisksProviderSpecificInput() *RemoveDisksProviderSpecificInput {
	return r
}

// RemoveProtectionContainerMappingInput - Container unpairing input.
type RemoveProtectionContainerMappingInput struct {
	// Configure protection input properties.
	Properties *RemoveProtectionContainerMappingInputProperties
}

// RemoveProtectionContainerMappingInputProperties - Unpairing input properties.
type RemoveProtectionContainerMappingInputProperties struct {
	// Provider specific input for unpairing.
	ProviderSpecificInput *ReplicationProviderContainerUnmappingInput
}

// RenewCertificateInput - Certificate renewal input.
type RenewCertificateInput struct {
	// Renew certificate input properties.
	Properties *RenewCertificateInputProperties
}

// RenewCertificateInputProperties - Renew Certificate input properties.
type RenewCertificateInputProperties struct {
	// Renew certificate type.
	RenewCertificateType *string
}

// ReplicationAgentDetails - Replication agent details.
type ReplicationAgentDetails struct {
	// READ-ONLY; The replication agent Bios Id.
	BiosID *string

	// READ-ONLY; The fabric object Id.
	FabricObjectID *string

	// READ-ONLY; The replication agent Fqdn.
	Fqdn *string

	// READ-ONLY; The health of the replication agent.
	Health *ProtectionHealth

	// READ-ONLY; The health errors.
	HealthErrors []*HealthError

	// READ-ONLY; The replication agent Id.
	ID *string

	// READ-ONLY; The last heartbeat received from the replication agent.
	LastHeartbeatUTC *time.Time

	// READ-ONLY; The replication agent name.
	Name *string

	// READ-ONLY; The version.
	Version *string
}

// ReplicationAppliance - Replication appliance definition.
type ReplicationAppliance struct {
	// Appliance related data.
	Properties *ReplicationApplianceProperties
}

// ReplicationApplianceProperties - Replication appliance properties.
type ReplicationApplianceProperties struct {
	// Provider specific settings.
	ProviderSpecificDetails ApplianceSpecificDetailsClassification
}

// ReplicationEligibilityResults - Replication eligibility results response model.
type ReplicationEligibilityResults struct {
	// READ-ONLY; Gets Unique ARM identifier for this object.
	ID *string

	// READ-ONLY; Gets the name of this object.
	Name *string

	// READ-ONLY; Gets properties model for replication eligibility results API.
	Properties *ReplicationEligibilityResultsProperties

	// READ-ONLY; Gets the object type.
	Type *string
}

// ReplicationEligibilityResultsCollection - Replication eligibility results collection response model.
type ReplicationEligibilityResultsCollection struct {
	// The replication eligibility results details.
	Value []*ReplicationEligibilityResults
}

// ReplicationEligibilityResultsErrorInfo - Error model that can be exposed to the user.
type ReplicationEligibilityResultsErrorInfo struct {
	// The error code.
	Code *string

	// The error message.
	Message *string

	// The possible causes.
	PossibleCauses *string

	// The recommended action.
	RecommendedAction *string

	// READ-ONLY; The error status.
	Status *string
}

// ReplicationEligibilityResultsProperties - Properties model for replication eligibility results API.
type ReplicationEligibilityResultsProperties struct {
	// The error details.
	Errors []*ReplicationEligibilityResultsErrorInfo

	// READ-ONLY; The client request Id.
	ClientRequestID *string
}

// ReplicationGroupDetails - Replication group details. This will be used in case of San.
type ReplicationGroupDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string
}

// GetConfigurationSettings implements the ConfigurationSettingsClassification interface for type ReplicationGroupDetails.
func (r *ReplicationGroupDetails) GetConfigurationSettings() *ConfigurationSettings {
	return &ConfigurationSettings{
		InstanceType: r.InstanceType,
	}
}

// ReplicationProtectedItem - Replication protected item.
type ReplicationProtectedItem struct {
	// Resource Location
	Location *string

	// The custom data.
	Properties *ReplicationProtectedItemProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource Name
	Name *string

	// READ-ONLY; Resource Type
	Type *string
}

// ReplicationProtectedItemCollection - Replication protected item collection.
type ReplicationProtectedItemCollection struct {
	// The value of next link.
	NextLink *string

	// The Replication protected item details.
	Value []*ReplicationProtectedItem
}

// ReplicationProtectedItemProperties - Replication protected item custom data details.
type ReplicationProtectedItemProperties struct {
	// The Current active location of the PE.
	ActiveLocation *string

	// The allowed operations on the Replication protected item.
	AllowedOperations []*string

	// The current scenario.
	CurrentScenario *CurrentScenarioDetails

	// The correlation Id for events associated with this protected item.
	EventCorrelationID *string

	// The consolidated failover health for the VM.
	FailoverHealth *string

	// The recovery point ARM Id to which the Vm was failed over.
	FailoverRecoveryPointID *string

	// The name.
	FriendlyName *string

	// List of health errors.
	HealthErrors []*HealthError

	// The Last successful failover time.
	LastSuccessfulFailoverTime *time.Time

	// The Last successful test failover time.
	LastSuccessfulTestFailoverTime *time.Time

	// The name of Policy governing this PE.
	PolicyFriendlyName *string

	// The ID of Policy governing this PE.
	PolicyID *string

	// The friendly name of the primary fabric.
	PrimaryFabricFriendlyName *string

	// The fabric provider of the primary fabric.
	PrimaryFabricProvider *string

	// The name of primary protection container friendly name.
	PrimaryProtectionContainerFriendlyName *string

	// The protected item ARM Id.
	ProtectableItemID *string

	// The type of protected item type.
	ProtectedItemType *string

	// The protection status.
	ProtectionState *string

	// The protection state description.
	ProtectionStateDescription *string

	// The Replication provider custom settings.
	ProviderSpecificDetails ReplicationProviderSpecificSettingsClassification

	// The recovery container Id.
	RecoveryContainerID *string

	// The friendly name of recovery fabric.
	RecoveryFabricFriendlyName *string

	// The Arm Id of recovery fabric.
	RecoveryFabricID *string

	// The name of recovery container friendly name.
	RecoveryProtectionContainerFriendlyName *string

	// The recovery provider ARM Id.
	RecoveryServicesProviderID *string

	// The consolidated protection health for the VM taking any issues with SRS as well as all the replication units associated
	// with the VM's replication group into account. This is a string representation
	// of the ProtectionHealth enumeration.
	ReplicationHealth *string

	// The switch provider state.
	SwitchProviderState *string

	// The switch provider state description.
	SwitchProviderStateDescription *string

	// The Test failover state.
	TestFailoverState *string

	// The Test failover state description.
	TestFailoverStateDescription *string
}

// ReplicationProtectionIntent - Replication protection intent.
type ReplicationProtectionIntent struct {
	// Resource Location
	Location *string

	// The custom data.
	Properties *ReplicationProtectionIntentProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource Name
	Name *string

	// READ-ONLY; Resource Type
	Type *string
}

// ReplicationProtectionIntentCollection - Replication protection intent objects collection.
type ReplicationProtectionIntentCollection struct {
	// The value of next link.
	NextLink *string

	// The Replication protection intent details.
	Value []*ReplicationProtectionIntent
}

// ReplicationProtectionIntentProperties - Replication protection intent custom data details.
type ReplicationProtectionIntentProperties struct {
	// The name.
	FriendlyName *string

	// The Replication provider custom settings.
	ProviderSpecificDetails ReplicationProtectionIntentProviderSpecificSettingsClassification

	// READ-ONLY; The creation time in UTC.
	CreationTimeUTC *string

	// READ-ONLY; A value indicating whether the intent object is active.
	IsActive *bool

	// READ-ONLY; The job Id.
	JobID *string

	// READ-ONLY; The job state.
	JobState *string
}

// ReplicationProtectionIntentProviderSpecificSettings - Replication provider specific settings.
type ReplicationProtectionIntentProviderSpecificSettings struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string
}

// GetReplicationProtectionIntentProviderSpecificSettings implements the ReplicationProtectionIntentProviderSpecificSettingsClassification
// interface for type ReplicationProtectionIntentProviderSpecificSettings.
func (r *ReplicationProtectionIntentProviderSpecificSettings) GetReplicationProtectionIntentProviderSpecificSettings() *ReplicationProtectionIntentProviderSpecificSettings {
	return r
}

// ReplicationProviderContainerUnmappingInput - Provider specific input for unpairing operations.
type ReplicationProviderContainerUnmappingInput struct {
	// The class type.
	InstanceType *string
}

// ReplicationProviderSpecificContainerCreationInput - Provider specific input for container creation operation.
type ReplicationProviderSpecificContainerCreationInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetReplicationProviderSpecificContainerCreationInput implements the ReplicationProviderSpecificContainerCreationInputClassification
// interface for type ReplicationProviderSpecificContainerCreationInput.
func (r *ReplicationProviderSpecificContainerCreationInput) GetReplicationProviderSpecificContainerCreationInput() *ReplicationProviderSpecificContainerCreationInput {
	return r
}

// ReplicationProviderSpecificContainerMappingInput - Provider specific input for pairing operations.
type ReplicationProviderSpecificContainerMappingInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetReplicationProviderSpecificContainerMappingInput implements the ReplicationProviderSpecificContainerMappingInputClassification
// interface for type ReplicationProviderSpecificContainerMappingInput.
func (r *ReplicationProviderSpecificContainerMappingInput) GetReplicationProviderSpecificContainerMappingInput() *ReplicationProviderSpecificContainerMappingInput {
	return r
}

// ReplicationProviderSpecificSettings - Replication provider specific settings.
type ReplicationProviderSpecificSettings struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string
}

// GetReplicationProviderSpecificSettings implements the ReplicationProviderSpecificSettingsClassification interface for type
// ReplicationProviderSpecificSettings.
func (r *ReplicationProviderSpecificSettings) GetReplicationProviderSpecificSettings() *ReplicationProviderSpecificSettings {
	return r
}

// ReplicationProviderSpecificUpdateContainerMappingInput - Provider specific input for update pairing operations.
type ReplicationProviderSpecificUpdateContainerMappingInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetReplicationProviderSpecificUpdateContainerMappingInput implements the ReplicationProviderSpecificUpdateContainerMappingInputClassification
// interface for type ReplicationProviderSpecificUpdateContainerMappingInput.
func (r *ReplicationProviderSpecificUpdateContainerMappingInput) GetReplicationProviderSpecificUpdateContainerMappingInput() *ReplicationProviderSpecificUpdateContainerMappingInput {
	return r
}

// ReprotectAgentDetails - Reprotect agent details.
type ReprotectAgentDetails struct {
	// READ-ONLY; The list of accessible datastores fetched from discovery.
	AccessibleDatastores []*string

	// READ-ONLY; The reprotect agent Bios Id.
	BiosID *string

	// READ-ONLY; The fabric object Id.
	FabricObjectID *string

	// READ-ONLY; The reprotect agent Fqdn.
	Fqdn *string

	// READ-ONLY; The health of the reprotect agent.
	Health *ProtectionHealth

	// READ-ONLY; The health errors.
	HealthErrors []*HealthError

	// READ-ONLY; The reprotect agent Id.
	ID *string

	// READ-ONLY; The last time when SDS information discovered in SRS.
	LastDiscoveryInUTC *time.Time

	// READ-ONLY; The last heartbeat received from the reprotect agent.
	LastHeartbeatUTC *time.Time

	// READ-ONLY; The reprotect agent name.
	Name *string

	// READ-ONLY; The protected item count.
	ProtectedItemCount *int32

	// READ-ONLY; The Vcenter Id.
	VcenterID *string

	// READ-ONLY; The version.
	Version *string
}

// ResolveHealthError - Resolve health errors input properties.
type ResolveHealthError struct {
	// Health error id.
	HealthErrorID *string
}

// ResolveHealthInput - Resolve health input.
type ResolveHealthInput struct {
	// Disable resolve health input properties.
	Properties *ResolveHealthInputProperties
}

// ResolveHealthInputProperties - Resolve health input properties.
type ResolveHealthInputProperties struct {
	// Health errors.
	HealthErrors []*ResolveHealthError
}

// Resource - Azure resource.
type Resource struct {
	// Resource Location
	Location *string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource Name
	Name *string

	// READ-ONLY; Resource Type
	Type *string
}

// ResourceHealthSummary - Base class to define the health summary of the resources contained under an Arm resource.
type ResourceHealthSummary struct {
	// The categorized resource counts.
	CategorizedResourceCounts map[string]*int32

	// The list of summary of health errors across the resources under the container.
	Issues []*HealthErrorSummary

	// The count of total resources under the container.
	ResourceCount *int32
}

// ResumeJobParams - Resume job params.
type ResumeJobParams struct {
	// Resume job properties.
	Properties *ResumeJobParamsProperties
}

// ResumeJobParamsProperties - Resume job properties.
type ResumeJobParamsProperties struct {
	// Resume job comments.
	Comments *string
}

// ResumeReplicationInput - Resume replication input.
type ResumeReplicationInput struct {
	// REQUIRED; Resume replication input properties.
	Properties *ResumeReplicationInputProperties
}

// ResumeReplicationInputProperties - Resume replication input properties.
type ResumeReplicationInputProperties struct {
	// REQUIRED; The provider specific input for resume replication.
	ProviderSpecificDetails ResumeReplicationProviderSpecificInputClassification
}

// ResumeReplicationProviderSpecificInput - Resume replication provider specific input.
type ResumeReplicationProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetResumeReplicationProviderSpecificInput implements the ResumeReplicationProviderSpecificInputClassification interface
// for type ResumeReplicationProviderSpecificInput.
func (r *ResumeReplicationProviderSpecificInput) GetResumeReplicationProviderSpecificInput() *ResumeReplicationProviderSpecificInput {
	return r
}

// ResyncInput - Resync input.
type ResyncInput struct {
	// REQUIRED; Resync input properties.
	Properties *ResyncInputProperties
}

// ResyncInputProperties - Resync input properties.
type ResyncInputProperties struct {
	// REQUIRED; The provider specific details.
	ProviderSpecificDetails ResyncProviderSpecificInputClassification
}

// ResyncProviderSpecificInput - Resync provider specific input.
type ResyncProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetResyncProviderSpecificInput implements the ResyncProviderSpecificInputClassification interface for type ResyncProviderSpecificInput.
func (r *ResyncProviderSpecificInput) GetResyncProviderSpecificInput() *ResyncProviderSpecificInput {
	return r
}

// RetentionVolume - The retention details of the MT.
type RetentionVolume struct {
	// The volume capacity.
	CapacityInBytes *int64

	// The free space available in this volume.
	FreeSpaceInBytes *int64

	// The threshold percentage.
	ThresholdPercentage *int32

	// The volume name.
	VolumeName *string
}

// ReverseReplicationInput - Reverse replication input.
type ReverseReplicationInput struct {
	// Reverse replication properties.
	Properties *ReverseReplicationInputProperties
}

// ReverseReplicationInputProperties - Reverse replication input properties.
type ReverseReplicationInputProperties struct {
	// Failover direction.
	FailoverDirection *string

	// Provider specific reverse replication input.
	ProviderSpecificDetails ReverseReplicationProviderSpecificInputClassification
}

// ReverseReplicationProviderSpecificInput - Provider specific reverse replication input.
type ReverseReplicationProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetReverseReplicationProviderSpecificInput implements the ReverseReplicationProviderSpecificInputClassification interface
// for type ReverseReplicationProviderSpecificInput.
func (r *ReverseReplicationProviderSpecificInput) GetReverseReplicationProviderSpecificInput() *ReverseReplicationProviderSpecificInput {
	return r
}

// RoleAssignment - Azure role assignment details.
type RoleAssignment struct {
	// The ARM Id of the role assignment.
	ID *string

	// The name of the role assignment.
	Name *string

	// Principal Id.
	PrincipalID *string

	// Role definition id.
	RoleDefinitionID *string

	// Role assignment scope.
	Scope *string
}

// RunAsAccount - CS Accounts Details.
type RunAsAccount struct {
	// The CS RunAs account Id.
	AccountID *string

	// The CS RunAs account name.
	AccountName *string
}

// ScriptActionTaskDetails - This class represents the script action task details.
type ScriptActionTaskDetails struct {
	// REQUIRED; The type of task details.
	InstanceType *string

	// A value indicating whether it is a primary side script or not.
	IsPrimarySideScript *bool

	// The name.
	Name *string

	// The output.
	Output *string

	// The path.
	Path *string
}

// GetTaskTypeDetails implements the TaskTypeDetailsClassification interface for type ScriptActionTaskDetails.
func (s *ScriptActionTaskDetails) GetTaskTypeDetails() *TaskTypeDetails {
	return &TaskTypeDetails{
		InstanceType: s.InstanceType,
	}
}

// ServiceError - ASR error model.
type ServiceError struct {
	// Activity Id.
	ActivityID *string

	// Error code.
	Code *string

	// Error message.
	Message *string

	// Possible causes of error.
	PossibleCauses *string

	// Recommended action to resolve error.
	RecommendedAction *string
}

// StorageAccountCustomDetails - Storage account custom input.
type StorageAccountCustomDetails struct {
	// REQUIRED; The class type.
	ResourceType *string
}

// GetStorageAccountCustomDetails implements the StorageAccountCustomDetailsClassification interface for type StorageAccountCustomDetails.
func (s *StorageAccountCustomDetails) GetStorageAccountCustomDetails() *StorageAccountCustomDetails {
	return s
}

// StorageClassification - Storage object definition.
type StorageClassification struct {
	// Resource Location
	Location *string

	// Properties of the storage object.
	Properties *StorageClassificationProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource Name
	Name *string

	// READ-ONLY; Resource Type
	Type *string
}

// StorageClassificationCollection - Collection of storage details.
type StorageClassificationCollection struct {
	// The value of next link.
	NextLink *string

	// The storage details.
	Value []*StorageClassification
}

// StorageClassificationMapping - Storage mapping object.
type StorageClassificationMapping struct {
	// Resource Location
	Location *string

	// Properties of the storage mapping object.
	Properties *StorageClassificationMappingProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource Name
	Name *string

	// READ-ONLY; Resource Type
	Type *string
}

// StorageClassificationMappingCollection - Collection of storage mapping details.
type StorageClassificationMappingCollection struct {
	// The value of next link.
	NextLink *string

	// The storage details.
	Value []*StorageClassificationMapping
}

// StorageClassificationMappingInput - Storage mapping input.
type StorageClassificationMappingInput struct {
	// Storage mapping input properties.
	Properties *StorageMappingInputProperties
}

// StorageClassificationMappingProperties - Storage mapping properties.
type StorageClassificationMappingProperties struct {
	// Target storage object Id.
	TargetStorageClassificationID *string
}

// StorageClassificationProperties - Storage object properties.
type StorageClassificationProperties struct {
	// Friendly name of the Storage classification.
	FriendlyName *string
}

// StorageMappingInputProperties - Storage mapping input properties.
type StorageMappingInputProperties struct {
	// The ID of the storage object.
	TargetStorageClassificationID *string
}

// Subnets of the network.
type Subnet struct {
	// The list of addresses for the subnet.
	AddressList []*string

	// The subnet friendly name.
	FriendlyName *string

	// The subnet name.
	Name *string
}

// SupportedOSDetails - Supported operating system details.
type SupportedOSDetails struct {
	// The name.
	OSName *string

	// The type.
	OSType *string

	// The list of version for operating system.
	OSVersions []*OSVersionWrapper
}

// SupportedOSProperties - Supported operating systems properties.
type SupportedOSProperties struct {
	// The supported operating systems property list.
	SupportedOsList []*SupportedOSProperty
}

// SupportedOSProperty - Supported operating systems property.
type SupportedOSProperty struct {
	// The replication provider type.
	InstanceType *string

	// The list of supported operating systems.
	SupportedOs []*SupportedOSDetails
}

// SupportedOperatingSystems - Supported operating systems.
type SupportedOperatingSystems struct {
	// Resource Location
	Location *string

	// The supported operating systems properties.
	Properties *SupportedOSProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource Name
	Name *string

	// READ-ONLY; Resource Type
	Type *string
}

// SwitchProtectionInput - Switch protection input.
type SwitchProtectionInput struct {
	// Switch protection properties.
	Properties *SwitchProtectionInputProperties
}

// SwitchProtectionInputProperties - Switch protection input properties.
type SwitchProtectionInputProperties struct {
	// Provider specific switch protection input.
	ProviderSpecificDetails SwitchProtectionProviderSpecificInputClassification

	// The unique replication protected item name.
	ReplicationProtectedItemName *string
}

// SwitchProtectionJobDetails - This class represents details for switch protection job.
type SwitchProtectionJobDetails struct {
	// REQUIRED; Gets the type of job details (see JobDetailsTypes enum for possible values).
	InstanceType *string

	// The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow
	// object details.
	AffectedObjectDetails map[string]*string

	// ARM Id of the new replication protected item.
	NewReplicationProtectedItemID *string
}

// GetJobDetails implements the JobDetailsClassification interface for type SwitchProtectionJobDetails.
func (s *SwitchProtectionJobDetails) GetJobDetails() *JobDetails {
	return &JobDetails{
		AffectedObjectDetails: s.AffectedObjectDetails,
		InstanceType:          s.InstanceType,
	}
}

// SwitchProtectionProviderSpecificInput - Provider specific switch protection input.
type SwitchProtectionProviderSpecificInput struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string
}

// GetSwitchProtectionProviderSpecificInput implements the SwitchProtectionProviderSpecificInputClassification interface for
// type SwitchProtectionProviderSpecificInput.
func (s *SwitchProtectionProviderSpecificInput) GetSwitchProtectionProviderSpecificInput() *SwitchProtectionProviderSpecificInput {
	return s
}

// SwitchProviderInput - Input definition for switch provider.
type SwitchProviderInput struct {
	// Switch provider input properties.
	Properties *SwitchProviderInputProperties
}

// SwitchProviderInputProperties - Input definition for switch provider input properties.
type SwitchProviderInputProperties struct {
	// Provider specific settings.
	ProviderSpecificDetails SwitchProviderSpecificInputClassification

	// Target provider type.
	TargetInstanceType *string
}

// SwitchProviderSpecificInput - Provider specific switch provider input.
type SwitchProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetSwitchProviderSpecificInput implements the SwitchProviderSpecificInputClassification interface for type SwitchProviderSpecificInput.
func (s *SwitchProviderSpecificInput) GetSwitchProviderSpecificInput() *SwitchProviderSpecificInput {
	return s
}

// TargetComputeSize - Represents applicable recovery vm sizes.
type TargetComputeSize struct {
	// The Id.
	ID *string

	// The name.
	Name *string

	// The custom data.
	Properties *TargetComputeSizeProperties

	// The Type of the object.
	Type *string
}

// TargetComputeSizeCollection - Target compute size collection.
type TargetComputeSizeCollection struct {
	// The value of next link.
	NextLink *string

	// The list of target compute sizes.
	Value []*TargetComputeSize
}

// TargetComputeSizeProperties - Represents applicable recovery vm sizes properties.
type TargetComputeSizeProperties struct {
	// The maximum cpu cores count supported by target compute size.
	CPUCoresCount *int32

	// The reasons why the target compute size is not applicable for the protected item.
	Errors []*ComputeSizeErrorDetails

	// Target compute size display name.
	FriendlyName *string

	// The value indicating whether the target compute size supports high Iops.
	HighIopsSupported *string

	// The supported HyperV Generations.
	HyperVGenerations []*string

	// The maximum data disks count supported by target compute size.
	MaxDataDiskCount *int32

	// The maximum Nics count supported by target compute size.
	MaxNicsCount *int32

	// The maximum memory in GB supported by target compute size.
	MemoryInGB *float64

	// Target compute size name.
	Name *string

	// READ-ONLY; The Available vCPUs supported by target compute size.
	VCPUsAvailable *int32
}

// TaskTypeDetails - Task details based on specific task type.
type TaskTypeDetails struct {
	// REQUIRED; The type of task details.
	InstanceType *string
}

// GetTaskTypeDetails implements the TaskTypeDetailsClassification interface for type TaskTypeDetails.
func (t *TaskTypeDetails) GetTaskTypeDetails() *TaskTypeDetails { return t }

// TestFailoverCleanupInput - Input definition for test failover cleanup.
type TestFailoverCleanupInput struct {
	// REQUIRED; Test failover cleanup input properties.
	Properties *TestFailoverCleanupInputProperties
}

// TestFailoverCleanupInputProperties - Input definition for test failover cleanup input properties.
type TestFailoverCleanupInputProperties struct {
	// Test failover cleanup comments.
	Comments *string
}

// TestFailoverInput - Input definition for test failover.
type TestFailoverInput struct {
	// REQUIRED; Test failover input properties.
	Properties *TestFailoverInputProperties
}

// TestFailoverInputProperties - Input definition for test failover input properties.
type TestFailoverInputProperties struct {
	// Test failover direction.
	FailoverDirection *string

	// The id of the network to be used for test failover.
	NetworkID *string

	// Network type to be used for test failover.
	NetworkType *string

	// Provider specific settings.
	ProviderSpecificDetails TestFailoverProviderSpecificInputClassification
}

// TestFailoverJobDetails - This class represents the details for a test failover job.
type TestFailoverJobDetails struct {
	// REQUIRED; Gets the type of job details (see JobDetailsTypes enum for possible values).
	InstanceType *string

	// The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow
	// object details.
	AffectedObjectDetails map[string]*string

	// The test failover comments.
	Comments *string

	// The test network friendly name.
	NetworkFriendlyName *string

	// The test network name.
	NetworkName *string

	// The test network type (see TestFailoverInput enum for possible values).
	NetworkType *string

	// The test VM details.
	ProtectedItemDetails []*FailoverReplicationProtectedItemDetails

	// The test failover status.
	TestFailoverStatus *string
}

// GetJobDetails implements the JobDetailsClassification interface for type TestFailoverJobDetails.
func (t *TestFailoverJobDetails) GetJobDetails() *JobDetails {
	return &JobDetails{
		AffectedObjectDetails: t.AffectedObjectDetails,
		InstanceType:          t.InstanceType,
	}
}

// TestFailoverProviderSpecificInput - Provider specific test failover input.
type TestFailoverProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetTestFailoverProviderSpecificInput implements the TestFailoverProviderSpecificInputClassification interface for type
// TestFailoverProviderSpecificInput.
func (t *TestFailoverProviderSpecificInput) GetTestFailoverProviderSpecificInput() *TestFailoverProviderSpecificInput {
	return t
}

// TestMigrateCleanupInput - Input for test migrate cleanup.
type TestMigrateCleanupInput struct {
	// REQUIRED; Test migrate cleanup input properties.
	Properties *TestMigrateCleanupInputProperties
}

// TestMigrateCleanupInputProperties - Test migrate cleanup input properties.
type TestMigrateCleanupInputProperties struct {
	// Test migrate cleanup comments.
	Comments *string
}

// TestMigrateInput - Input for test migrate.
type TestMigrateInput struct {
	// REQUIRED; Test migrate input properties.
	Properties *TestMigrateInputProperties
}

// TestMigrateInputProperties - Test migrate input properties.
type TestMigrateInputProperties struct {
	// REQUIRED; The provider specific details.
	ProviderSpecificDetails TestMigrateProviderSpecificInputClassification
}

// TestMigrateProviderSpecificInput - Test migrate provider specific input.
type TestMigrateProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetTestMigrateProviderSpecificInput implements the TestMigrateProviderSpecificInputClassification interface for type TestMigrateProviderSpecificInput.
func (t *TestMigrateProviderSpecificInput) GetTestMigrateProviderSpecificInput() *TestMigrateProviderSpecificInput {
	return t
}

// UnplannedFailoverInput - Input definition for unplanned failover.
type UnplannedFailoverInput struct {
	// REQUIRED; Unplanned failover input properties.
	Properties *UnplannedFailoverInputProperties
}

// UnplannedFailoverInputProperties - Input definition for unplanned failover input properties.
type UnplannedFailoverInputProperties struct {
	// Failover direction.
	FailoverDirection *string

	// Provider specific settings.
	ProviderSpecificDetails UnplannedFailoverProviderSpecificInputClassification

	// Source site operations status.
	SourceSiteOperations *string
}

// UnplannedFailoverProviderSpecificInput - Provider specific unplanned failover input.
type UnplannedFailoverProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetUnplannedFailoverProviderSpecificInput implements the UnplannedFailoverProviderSpecificInputClassification interface
// for type UnplannedFailoverProviderSpecificInput.
func (u *UnplannedFailoverProviderSpecificInput) GetUnplannedFailoverProviderSpecificInput() *UnplannedFailoverProviderSpecificInput {
	return u
}

// UpdateApplianceForReplicationProtectedItemInput - Update appliance for replication protected item input.
type UpdateApplianceForReplicationProtectedItemInput struct {
	// REQUIRED; Update appliance replication protected item properties.
	Properties *UpdateApplianceForReplicationProtectedItemInputProperties
}

// UpdateApplianceForReplicationProtectedItemInputProperties - Update appliance for protected item input properties.
type UpdateApplianceForReplicationProtectedItemInputProperties struct {
	// REQUIRED; The provider specific input to update replication protected item.
	ProviderSpecificDetails UpdateApplianceForReplicationProtectedItemProviderSpecificInputClassification

	// REQUIRED; The target appliance Id.
	TargetApplianceID *string
}

// UpdateApplianceForReplicationProtectedItemProviderSpecificInput - Update replication protected item provider specific input.
type UpdateApplianceForReplicationProtectedItemProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetUpdateApplianceForReplicationProtectedItemProviderSpecificInput implements the UpdateApplianceForReplicationProtectedItemProviderSpecificInputClassification
// interface for type UpdateApplianceForReplicationProtectedItemProviderSpecificInput.
func (u *UpdateApplianceForReplicationProtectedItemProviderSpecificInput) GetUpdateApplianceForReplicationProtectedItemProviderSpecificInput() *UpdateApplianceForReplicationProtectedItemProviderSpecificInput {
	return u
}

// UpdateDiskInput - Disk input for update.
type UpdateDiskInput struct {
	// REQUIRED; The disk Id.
	DiskID *string

	// The target disk name.
	TargetDiskName *string
}

// UpdateMigrationItemInput - Update migration item input.
type UpdateMigrationItemInput struct {
	// Update migration item input properties.
	Properties *UpdateMigrationItemInputProperties
}

// UpdateMigrationItemInputProperties - Update migration item input properties.
type UpdateMigrationItemInputProperties struct {
	// REQUIRED; The provider specific input to update migration item.
	ProviderSpecificDetails UpdateMigrationItemProviderSpecificInputClassification
}

// UpdateMigrationItemProviderSpecificInput - Update migration item provider specific input.
type UpdateMigrationItemProviderSpecificInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetUpdateMigrationItemProviderSpecificInput implements the UpdateMigrationItemProviderSpecificInputClassification interface
// for type UpdateMigrationItemProviderSpecificInput.
func (u *UpdateMigrationItemProviderSpecificInput) GetUpdateMigrationItemProviderSpecificInput() *UpdateMigrationItemProviderSpecificInput {
	return u
}

// UpdateMobilityServiceRequest - Request to update the mobility service on a protected item.
type UpdateMobilityServiceRequest struct {
	// The properties of the update mobility service request.
	Properties *UpdateMobilityServiceRequestProperties
}

// UpdateMobilityServiceRequestProperties - The properties of an update mobility service request.
type UpdateMobilityServiceRequestProperties struct {
	// The CS run as account Id.
	RunAsAccountID *string
}

// UpdateNetworkMappingInput - Update network mapping input.
type UpdateNetworkMappingInput struct {
	// The input properties needed to update network mapping.
	Properties *UpdateNetworkMappingInputProperties
}

// UpdateNetworkMappingInputProperties - Common input details for network mapping operation.
type UpdateNetworkMappingInputProperties struct {
	// Fabrics specific input network Id.
	FabricSpecificDetails FabricSpecificUpdateNetworkMappingInputClassification

	// Recovery fabric name.
	RecoveryFabricName *string

	// Recovery network Id.
	RecoveryNetworkID *string
}

// UpdatePolicyInput - Update policy input.
type UpdatePolicyInput struct {
	// The ReplicationProviderSettings.
	Properties *UpdatePolicyInputProperties
}

// UpdatePolicyInputProperties - Policy update properties.
type UpdatePolicyInputProperties struct {
	// The ReplicationProviderSettings.
	ReplicationProviderSettings PolicyProviderSpecificInputClassification
}

// UpdateProtectionContainerMappingInput - Container pairing update input.
type UpdateProtectionContainerMappingInput struct {
	// Update protection container mapping input properties.
	Properties *UpdateProtectionContainerMappingInputProperties
}

// UpdateProtectionContainerMappingInputProperties - Container pairing update input.
type UpdateProtectionContainerMappingInputProperties struct {
	// Provider specific input for updating protection container mapping.
	ProviderSpecificInput ReplicationProviderSpecificUpdateContainerMappingInputClassification
}

// UpdateRecoveryPlanInput - Update recovery plan input class.
type UpdateRecoveryPlanInput struct {
	// Recovery plan update properties.
	Properties *UpdateRecoveryPlanInputProperties
}

// UpdateRecoveryPlanInputProperties - Recovery plan update properties.
type UpdateRecoveryPlanInputProperties struct {
	// The recovery plan groups.
	Groups []*RecoveryPlanGroup
}

// UpdateReplicationProtectedItemInput - Update replication protected item input.
type UpdateReplicationProtectedItemInput struct {
	// Update replication protected item properties.
	Properties *UpdateReplicationProtectedItemInputProperties
}

// UpdateReplicationProtectedItemInputProperties - Update protected item input properties.
type UpdateReplicationProtectedItemInputProperties struct {
	// The selected option to enable RDP\SSH on target vm after failover. String value of SrsDataContract.EnableRDPOnTargetOption
	// enum.
	EnableRdpOnTargetOption *string

	// License type.
	LicenseType *LicenseType

	// The provider specific input to update replication protected item.
	ProviderSpecificDetails UpdateReplicationProtectedItemProviderInputClassification

	// The target availability set Id.
	RecoveryAvailabilitySetID *string

	// Target Azure VM name given by the user.
	RecoveryAzureVMName *string

	// Target Azure VM size.
	RecoveryAzureVMSize *string

	// Target Azure Network Id.
	SelectedRecoveryAzureNetworkID *string

	// The selected source nic Id which will be used as the primary nic during failover.
	SelectedSourceNicID *string

	// The Azure Network Id for test failover.
	SelectedTfoAzureNetworkID *string

	// The list of VM nic details.
	VMNics []*VMNicInputDetails
}

// UpdateReplicationProtectedItemProviderInput - Update replication protected item provider specific input.
type UpdateReplicationProtectedItemProviderInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetUpdateReplicationProtectedItemProviderInput implements the UpdateReplicationProtectedItemProviderInputClassification
// interface for type UpdateReplicationProtectedItemProviderInput.
func (u *UpdateReplicationProtectedItemProviderInput) GetUpdateReplicationProtectedItemProviderInput() *UpdateReplicationProtectedItemProviderInput {
	return u
}

// UpdateVCenterRequest - Input required to update vCenter.
type UpdateVCenterRequest struct {
	// The update VCenter Request Properties.
	Properties *UpdateVCenterRequestProperties
}

// UpdateVCenterRequestProperties - The properties of an update vCenter request.
type UpdateVCenterRequestProperties struct {
	// The friendly name of the vCenter.
	FriendlyName *string

	// The IP address of the vCenter to be discovered.
	IPAddress *string

	// The port number for discovery.
	Port *string

	// The process server Id from where the update can be orchestrated.
	ProcessServerID *string

	// The CS account Id which has privileges to update the vCenter.
	RunAsAccountID *string
}

// VCenter - vCenter definition.
type VCenter struct {
	// Resource Location
	Location *string

	// VCenter related data.
	Properties *VCenterProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource Name
	Name *string

	// READ-ONLY; Resource Type
	Type *string
}

// VCenterCollection - Collection of vCenter details.
type VCenterCollection struct {
	// The value of next link.
	NextLink *string

	// The vCenter details.
	Value []*VCenter
}

// VCenterProperties - vCenter properties.
type VCenterProperties struct {
	// The VCenter discovery status.
	DiscoveryStatus *string

	// The ARM resource name of the fabric containing this VCenter.
	FabricArmResourceName *string

	// Friendly name of the vCenter.
	FriendlyName *string

	// The health errors for this VCenter.
	HealthErrors []*HealthError

	// The IP address of the vCenter.
	IPAddress *string

	// The infrastructure Id of vCenter.
	InfrastructureID *string

	// VCenter internal ID.
	InternalID *string

	// The time when the last heartbeat was received by vCenter.
	LastHeartbeat *time.Time

	// The port number for discovery.
	Port *string

	// The process server Id.
	ProcessServerID *string

	// The account Id which has privileges to discover the vCenter.
	RunAsAccountID *string
}

// VMNicDetails - Hyper V VM network details.
type VMNicDetails struct {
	// A value indicating whether the NIC has accelerated networking enabled.
	EnableAcceleratedNetworkingOnRecovery *bool

	// Whether the TFO NIC has accelerated networking enabled.
	EnableAcceleratedNetworkingOnTfo *bool

	// The IP configurations of the NIC.
	IPConfigs []*IPConfigDetails

	// The nic Id.
	NicID *string

	// The id of the NSG associated with the NIC.
	RecoveryNetworkSecurityGroupID *string

	// The name of the NIC to be used when creating target NICs.
	RecoveryNicName *string

	// The resource group of the NIC to be used when creating target NICs.
	RecoveryNicResourceGroupName *string

	// Recovery VM network Id.
	RecoveryVMNetworkID *string

	// The replica nic Id.
	ReplicaNicID *string

	// A value indicating whether an existing NIC is allowed to be reused during failover subject to availability.
	ReuseExistingNic *bool

	// Selection type for failover.
	SelectionType *string

	// The source nic ARM Id.
	SourceNicArmID *string

	// Target NIC name.
	TargetNicName *string

	// The NSG to be used by NIC during test failover.
	TfoNetworkSecurityGroupID *string

	// The name of the NIC to be used when creating target NICs in TFO.
	TfoRecoveryNicName *string

	// The resource group of the NIC to be used when creating target NICs in TFO.
	TfoRecoveryNicResourceGroupName *string

	// A value indicating whether an existing NIC is allowed to be reused during test failover subject to availability.
	TfoReuseExistingNic *bool

	// The network to be used by NIC during test failover.
	TfoVMNetworkID *string

	// VM network name.
	VMNetworkName *string
}

// VMNicInputDetails - Hyper V VM network input details.
type VMNicInputDetails struct {
	// Whether the NIC has accelerated networking enabled.
	EnableAcceleratedNetworkingOnRecovery *bool

	// Whether the test NIC has accelerated networking enabled.
	EnableAcceleratedNetworkingOnTfo *bool

	// The IP configurations to be used by NIC during test failover and failover.
	IPConfigs []*IPConfigInputDetails

	// The nic Id.
	NicID *string

	// The id of the NSG associated with the NIC.
	RecoveryNetworkSecurityGroupID *string

	// The name of the NIC to be used when creating target NICs.
	RecoveryNicName *string

	// The resource group of the NIC to be used when creating target NICs.
	RecoveryNicResourceGroupName *string

	// A value indicating whether an existing NIC is allowed to be reused during failover subject to availability.
	ReuseExistingNic *bool

	// Selection type for failover.
	SelectionType *string

	// Target NIC name.
	TargetNicName *string

	// The NSG to be used by NIC during test failover.
	TfoNetworkSecurityGroupID *string

	// The name of the NIC to be used when creating target NICs in TFO.
	TfoNicName *string

	// The resource group of the NIC to be used when creating target NICs in TFO.
	TfoNicResourceGroupName *string

	// A value indicating whether an existing NIC is allowed to be reused during test failover subject to availability.
	TfoReuseExistingNic *bool
}

// VMNicUpdatesTaskDetails - This class represents the vm NicUpdates task details.
type VMNicUpdatesTaskDetails struct {
	// REQUIRED; The type of task details.
	InstanceType *string

	// Name of the Nic.
	Name *string

	// Nic Id.
	NicID *string

	// Virtual machine Id.
	VMID *string
}

// GetTaskTypeDetails implements the TaskTypeDetailsClassification interface for type VMNicUpdatesTaskDetails.
func (v *VMNicUpdatesTaskDetails) GetTaskTypeDetails() *TaskTypeDetails {
	return &TaskTypeDetails{
		InstanceType: v.InstanceType,
	}
}

// VMwareCbtContainerCreationInput - VMwareCbt container creation input.
type VMwareCbtContainerCreationInput struct {
	// REQUIRED; The class type.
	InstanceType *string
}

// GetReplicationProviderSpecificContainerCreationInput implements the ReplicationProviderSpecificContainerCreationInputClassification
// interface for type VMwareCbtContainerCreationInput.
func (v *VMwareCbtContainerCreationInput) GetReplicationProviderSpecificContainerCreationInput() *ReplicationProviderSpecificContainerCreationInput {
	return &ReplicationProviderSpecificContainerCreationInput{
		InstanceType: v.InstanceType,
	}
}

// VMwareCbtContainerMappingInput - VMwareCbt container mapping input.
type VMwareCbtContainerMappingInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// REQUIRED; The storage account ARM Id.
	StorageAccountID *string

	// REQUIRED; The target location.
	TargetLocation *string

	// The target key vault ARM Id.
	KeyVaultID *string

	// The target key vault URL.
	KeyVaultURI *string

	// The secret name of the service bus connection string.
	ServiceBusConnectionStringSecretName *string

	// The secret name of the storage account.
	StorageAccountSasSecretName *string
}

// GetReplicationProviderSpecificContainerMappingInput implements the ReplicationProviderSpecificContainerMappingInputClassification
// interface for type VMwareCbtContainerMappingInput.
func (v *VMwareCbtContainerMappingInput) GetReplicationProviderSpecificContainerMappingInput() *ReplicationProviderSpecificContainerMappingInput {
	return &ReplicationProviderSpecificContainerMappingInput{
		InstanceType: v.InstanceType,
	}
}

// VMwareCbtDiskInput - VMwareCbt disk input.
type VMwareCbtDiskInput struct {
	// REQUIRED; The disk Id.
	DiskID *string

	// REQUIRED; A value indicating whether the disk is the OS disk.
	IsOSDisk *string

	// REQUIRED; The log storage account ARM Id.
	LogStorageAccountID *string

	// REQUIRED; The key vault secret name of the log storage account.
	LogStorageAccountSasSecretName *string

	// The DiskEncryptionSet ARM Id.
	DiskEncryptionSetID *string

	// The disk type.
	DiskType *DiskAccountType
}

// VMwareCbtEnableMigrationInput - VMwareCbt specific enable migration input.
type VMwareCbtEnableMigrationInput struct {
	// REQUIRED; The data mover run as account Id.
	DataMoverRunAsAccountID *string

	// REQUIRED; The disks to include list.
	DisksToInclude []*VMwareCbtDiskInput

	// REQUIRED; The class type.
	InstanceType *string

	// REQUIRED; The snapshot run as account Id.
	SnapshotRunAsAccountID *string

	// REQUIRED; The target network ARM Id.
	TargetNetworkID *string

	// REQUIRED; The target resource group ARM Id.
	TargetResourceGroupID *string

	// REQUIRED; The ARM Id of the VM discovered in VMware.
	VmwareMachineID *string

	// The confidential VM key vault Id for ADE installation.
	ConfidentialVMKeyVaultID *string

	// License type.
	LicenseType *LicenseType

	// A value indicating whether auto resync is to be done.
	PerformAutoResync *string

	// A value indicating whether bulk SQL RP registration to be done.
	PerformSQLBulkRegistration *string

	// The SQL Server license type.
	SQLServerLicenseType *SQLServerLicenseType

	// The tags for the seed disks.
	SeedDiskTags map[string]*string

	// The target availability set ARM Id.
	TargetAvailabilitySetID *string

	// The target availability zone.
	TargetAvailabilityZone *string

	// The target boot diagnostics storage account ARM Id.
	TargetBootDiagnosticsStorageAccountID *string

	// The tags for the target disks.
	TargetDiskTags map[string]*string

	// The tags for the target NICs.
	TargetNicTags map[string]*string

	// The target proximity placement group ARM Id.
	TargetProximityPlacementGroupID *string

	// The target subnet name.
	TargetSubnetName *string

	// The target VM name.
	TargetVMName *string

	// The target VM security profile.
	TargetVMSecurityProfile *VMwareCbtSecurityProfileProperties

	// The target VM size.
	TargetVMSize *string

	// The target VM tags.
	TargetVMTags map[string]*string

	// The selected test network ARM Id.
	TestNetworkID *string

	// The selected test subnet name.
	TestSubnetName *string
}

// GetEnableMigrationProviderSpecificInput implements the EnableMigrationProviderSpecificInputClassification interface for
// type VMwareCbtEnableMigrationInput.
func (v *VMwareCbtEnableMigrationInput) GetEnableMigrationProviderSpecificInput() *EnableMigrationProviderSpecificInput {
	return &EnableMigrationProviderSpecificInput{
		InstanceType: v.InstanceType,
	}
}

// VMwareCbtEventDetails - Event details for VMwareCbt provider.
type VMwareCbtEventDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// READ-ONLY; The migration item name.
	MigrationItemName *string
}

// GetEventProviderSpecificDetails implements the EventProviderSpecificDetailsClassification interface for type VMwareCbtEventDetails.
func (v *VMwareCbtEventDetails) GetEventProviderSpecificDetails() *EventProviderSpecificDetails {
	return &EventProviderSpecificDetails{
		InstanceType: v.InstanceType,
	}
}

// VMwareCbtMigrateInput - VMwareCbt specific migrate input.
type VMwareCbtMigrateInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// REQUIRED; A value indicating whether VM is to be shutdown.
	PerformShutdown *string

	// A value indicating the inplace OS Upgrade version.
	OSUpgradeVersion *string
}

// GetMigrateProviderSpecificInput implements the MigrateProviderSpecificInputClassification interface for type VMwareCbtMigrateInput.
func (v *VMwareCbtMigrateInput) GetMigrateProviderSpecificInput() *MigrateProviderSpecificInput {
	return &MigrateProviderSpecificInput{
		InstanceType: v.InstanceType,
	}
}

// VMwareCbtMigrationDetails - VMwareCbt provider specific settings.
type VMwareCbtMigrationDetails struct {
	// REQUIRED; Gets the instance type.
	InstanceType *string

	// The confidential VM key vault Id for ADE installation.
	ConfidentialVMKeyVaultID *string

	// License Type of the VM to be used.
	LicenseType *string

	// A value indicating whether auto resync is to be done.
	PerformAutoResync *string

	// The list of protected disks.
	ProtectedDisks []*VMwareCbtProtectedDiskDetails

	// The SQL Server license type.
	SQLServerLicenseType *string

	// The tags for the seed disks.
	SeedDiskTags map[string]*string

	// A value indicating the inplace OS Upgrade version.
	SupportedOSVersions []*string

	// The target availability set Id.
	TargetAvailabilitySetID *string

	// The target availability zone.
	TargetAvailabilityZone *string

	// The target boot diagnostics storage account ARM Id.
	TargetBootDiagnosticsStorageAccountID *string

	// The tags for the target disks.
	TargetDiskTags map[string]*string

	// The target network Id.
	TargetNetworkID *string

	// The tags for the target NICs.
	TargetNicTags map[string]*string

	// The target proximity placement group Id.
	TargetProximityPlacementGroupID *string

	// The target resource group Id.
	TargetResourceGroupID *string

	// Target VM name.
	TargetVMName *string

	// The target VM security profile.
	TargetVMSecurityProfile *VMwareCbtSecurityProfileProperties

	// The target VM size.
	TargetVMSize *string

	// The target VM tags.
	TargetVMTags map[string]*string

	// The test network Id.
	TestNetworkID *string

	// The network details.
	VMNics []*VMwareCbtNicDetails

	// READ-ONLY; A value indicating the appliance monitoring details.
	ApplianceMonitoringDetails *ApplianceMonitoringDetails

	// READ-ONLY; The data mover run as account Id.
	DataMoverRunAsAccountID *string

	// READ-ONLY; The delta sync progress percentage.
	DeltaSyncProgressPercentage *int32

	// READ-ONLY; The delta sync retry count.
	DeltaSyncRetryCount *int64

	// READ-ONLY; The firmware type.
	FirmwareType *string

	// READ-ONLY; A value indicating the gateway operation details.
	GatewayOperationDetails *GatewayOperationDetails

	// READ-ONLY; The initial seeding progress percentage.
	InitialSeedingProgressPercentage *int32

	// READ-ONLY; The initial seeding retry count.
	InitialSeedingRetryCount *int64

	// READ-ONLY; A value indicating whether checksum resync cycle is in progress.
	IsCheckSumResyncCycle *string

	// READ-ONLY; The last recovery point Id.
	LastRecoveryPointID *string

	// READ-ONLY; The last recovery point received time.
	LastRecoveryPointReceived *time.Time

	// READ-ONLY; The migration progress percentage.
	MigrationProgressPercentage *int32

	// READ-ONLY; The recovery point Id to which the VM was migrated.
	MigrationRecoveryPointID *string

	// READ-ONLY; The name of the OS on the VM.
	OSName *string

	// READ-ONLY; The type of the OS on the VM.
	OSType *string

	// READ-ONLY; A value indicating the SRS operation name.
	OperationName *string

	// READ-ONLY; The resume progress percentage.
	ResumeProgressPercentage *int32

	// READ-ONLY; The resume retry count.
	ResumeRetryCount *int64

	// READ-ONLY; The resync progress percentage.
	ResyncProgressPercentage *int32

	// READ-ONLY; A value indicating whether resync is required.
	ResyncRequired *string

	// READ-ONLY; The resync retry count.
	ResyncRetryCount *int64

	// READ-ONLY; The resync state.
	ResyncState *ResyncState

	// READ-ONLY; The snapshot run as account Id.
	SnapshotRunAsAccountID *string

	// READ-ONLY; The replication storage account ARM Id. This is applicable only for the blob based replication test hook.
	StorageAccountID *string

	// READ-ONLY; The target generation.
	TargetGeneration *string

	// READ-ONLY; The target location.
	TargetLocation *string

	// READ-ONLY; The ARM Id of the VM discovered in VMware.
	VmwareMachineID *string
}

// GetMigrationProviderSpecificSettings implements the MigrationProviderSpecificSettingsClassification interface for type
// VMwareCbtMigrationDetails.
func (v *VMwareCbtMigrationDetails) GetMigrationProviderSpecificSettings() *MigrationProviderSpecificSettings {
	return &MigrationProviderSpecificSettings{
		InstanceType: v.InstanceType,
	}
}

// VMwareCbtNicDetails - VMwareCbt NIC details.
type VMwareCbtNicDetails struct {
	// A value indicating whether this is the primary NIC.
	IsPrimaryNic *string

	// A value indicating whether this NIC is selected for migration.
	IsSelectedForMigration *string

	// The target IP address.
	TargetIPAddress *string

	// The target IP address type.
	TargetIPAddressType *EthernetAddressType

	// Target NIC name.
	TargetNicName *string

	// Target subnet name.
	TargetSubnetName *string

	// The test IP address.
	TestIPAddress *string

	// The test IP address type.
	TestIPAddressType *EthernetAddressType

	// Source network Id.
	TestNetworkID *string

	// Test subnet name.
	TestSubnetName *string

	// READ-ONLY; The NIC Id.
	NicID *string

	// READ-ONLY; The source IP address.
	SourceIPAddress *string

	// READ-ONLY; The source IP address type.
	SourceIPAddressType *EthernetAddressType

	// READ-ONLY; Source network Id.
	SourceNetworkID *string
}

// VMwareCbtNicInput - VMwareCbt NIC input.
type VMwareCbtNicInput struct {
	// REQUIRED; A value indicating whether this is the primary NIC.
	IsPrimaryNic *string

	// REQUIRED; The NIC Id.
	NicID *string

	// A value indicating whether this NIC is selected for migration.
	IsSelectedForMigration *string

	// Target NIC name.
	TargetNicName *string

	// The static IP address.
	TargetStaticIPAddress *string

	// Target subnet name.
	TargetSubnetName *string

	// The test static IP address.
	TestStaticIPAddress *string

	// The test subnet name.
	TestSubnetName *string
}

// VMwareCbtPolicyCreationInput - VMware Cbt policy creation input.
type VMwareCbtPolicyCreationInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// The app consistent snapshot frequency (in minutes).
	AppConsistentFrequencyInMinutes *int32

	// The crash consistent snapshot frequency (in minutes).
	CrashConsistentFrequencyInMinutes *int32

	// The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistoryInMinutes *int32
}

// GetPolicyProviderSpecificInput implements the PolicyProviderSpecificInputClassification interface for type VMwareCbtPolicyCreationInput.
func (v *VMwareCbtPolicyCreationInput) GetPolicyProviderSpecificInput() *PolicyProviderSpecificInput {
	return &PolicyProviderSpecificInput{
		InstanceType: v.InstanceType,
	}
}

// VMwareCbtProtectedDiskDetails - VMwareCbt protected disk details.
type VMwareCbtProtectedDiskDetails struct {
	// The disk type.
	DiskType *DiskAccountType

	// The name for the target managed disk.
	TargetDiskName *string

	// READ-ONLY; The disk capacity in bytes.
	CapacityInBytes *int64

	// READ-ONLY; The DiskEncryptionSet ARM Id.
	DiskEncryptionSetID *string

	// READ-ONLY; The disk id.
	DiskID *string

	// READ-ONLY; The disk name.
	DiskName *string

	// READ-ONLY; The disk path.
	DiskPath *string

	// READ-ONLY; A value indicating the gateway operation details.
	GatewayOperationDetails *GatewayOperationDetails

	// READ-ONLY; A value indicating whether the disk is the OS disk.
	IsOSDisk *string

	// READ-ONLY; The log storage account ARM Id.
	LogStorageAccountID *string

	// READ-ONLY; The key vault secret name of the log storage account.
	LogStorageAccountSasSecretName *string

	// READ-ONLY; The uri of the seed blob.
	SeedBlobURI *string

	// READ-ONLY; The ARM Id of the seed managed disk.
	SeedManagedDiskID *string

	// READ-ONLY; The uri of the target blob.
	TargetBlobURI *string

	// READ-ONLY; The ARM Id of the target managed disk.
	TargetManagedDiskID *string
}

// VMwareCbtProtectionContainerMappingDetails - VMwareCbt provider specific container mapping details.
type VMwareCbtProtectionContainerMappingDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// The SKUs to be excluded.
	ExcludedSKUs []*string

	// READ-ONLY; The target key vault ARM Id.
	KeyVaultID *string

	// READ-ONLY; The target key vault URI.
	KeyVaultURI *string

	// READ-ONLY; The role size to NIC count map.
	RoleSizeToNicCountMap map[string]*int32

	// READ-ONLY; The secret name of the service bus connection string.
	ServiceBusConnectionStringSecretName *string

	// READ-ONLY; The storage account ARM Id.
	StorageAccountID *string

	// READ-ONLY; The secret name of the storage account.
	StorageAccountSasSecretName *string

	// READ-ONLY; The target location.
	TargetLocation *string
}

// GetProtectionContainerMappingProviderSpecificDetails implements the ProtectionContainerMappingProviderSpecificDetailsClassification
// interface for type VMwareCbtProtectionContainerMappingDetails.
func (v *VMwareCbtProtectionContainerMappingDetails) GetProtectionContainerMappingProviderSpecificDetails() *ProtectionContainerMappingProviderSpecificDetails {
	return &ProtectionContainerMappingProviderSpecificDetails{
		InstanceType: v.InstanceType,
	}
}

// VMwareCbtResumeReplicationInput - VMwareCbt specific resume replication input.
type VMwareCbtResumeReplicationInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// A value indicating whether Migration resources to be deleted.
	DeleteMigrationResources *string
}

// GetResumeReplicationProviderSpecificInput implements the ResumeReplicationProviderSpecificInputClassification interface
// for type VMwareCbtResumeReplicationInput.
func (v *VMwareCbtResumeReplicationInput) GetResumeReplicationProviderSpecificInput() *ResumeReplicationProviderSpecificInput {
	return &ResumeReplicationProviderSpecificInput{
		InstanceType: v.InstanceType,
	}
}

// VMwareCbtResyncInput - VMwareCbt specific resync input.
type VMwareCbtResyncInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// REQUIRED; A value indicating whether CBT is to be reset.
	SkipCbtReset *string
}

// GetResyncProviderSpecificInput implements the ResyncProviderSpecificInputClassification interface for type VMwareCbtResyncInput.
func (v *VMwareCbtResyncInput) GetResyncProviderSpecificInput() *ResyncProviderSpecificInput {
	return &ResyncProviderSpecificInput{
		InstanceType: v.InstanceType,
	}
}

// VMwareCbtSecurityProfileProperties - VMwareCbt security profile input.
type VMwareCbtSecurityProfileProperties struct {
	// A value indicating whether confidential compute encryption to be enabled.
	IsTargetVMConfidentialEncryptionEnabled *string

	// A value indicating whether integrity monitoring to be enabled.
	IsTargetVMIntegrityMonitoringEnabled *string

	// A value indicating whether secure boot to be enabled.
	IsTargetVMSecureBootEnabled *string

	// A value indicating whether trusted platform module to be enabled.
	IsTargetVMTpmEnabled *string

	// The target VM security type.
	TargetVMSecurityType *SecurityType
}

// VMwareCbtTestMigrateInput - VMwareCbt specific test migrate input.
type VMwareCbtTestMigrateInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// REQUIRED; The test network Id.
	NetworkID *string

	// REQUIRED; The recovery point Id.
	RecoveryPointID *string

	// A value indicating the inplace OS Upgrade version.
	OSUpgradeVersion *string

	// The list of NIC details.
	VMNics []*VMwareCbtNicInput
}

// GetTestMigrateProviderSpecificInput implements the TestMigrateProviderSpecificInputClassification interface for type VMwareCbtTestMigrateInput.
func (v *VMwareCbtTestMigrateInput) GetTestMigrateProviderSpecificInput() *TestMigrateProviderSpecificInput {
	return &TestMigrateProviderSpecificInput{
		InstanceType: v.InstanceType,
	}
}

// VMwareCbtUpdateDiskInput - VMwareCbt disk input for update.
type VMwareCbtUpdateDiskInput struct {
	// REQUIRED; The disk Id.
	DiskID *string

	// A value indicating whether the disk is the OS disk.
	IsOSDisk *string

	// The target disk name.
	TargetDiskName *string
}

// VMwareCbtUpdateMigrationItemInput - VMwareCbt specific update migration item input.
type VMwareCbtUpdateMigrationItemInput struct {
	// REQUIRED; The class type.
	InstanceType *string

	// The license type.
	LicenseType *LicenseType

	// A value indicating whether auto resync is to be done.
	PerformAutoResync *string

	// The SQL Server license type.
	SQLServerLicenseType *SQLServerLicenseType

	// The target availability set ARM Id.
	TargetAvailabilitySetID *string

	// The target availability zone.
	TargetAvailabilityZone *string

	// The target boot diagnostics storage account ARM Id.
	TargetBootDiagnosticsStorageAccountID *string

	// The tags for the target disks.
	TargetDiskTags map[string]*string

	// The target network ARM Id.
	TargetNetworkID *string

	// The tags for the target NICs.
	TargetNicTags map[string]*string

	// The target proximity placement group ARM Id.
	TargetProximityPlacementGroupID *string

	// The target resource group ARM Id.
	TargetResourceGroupID *string

	// The target VM name.
	TargetVMName *string

	// The target VM size.
	TargetVMSize *string

	// The target VM tags.
	TargetVMTags map[string]*string

	// The test network ARM Id.
	TestNetworkID *string

	// The list of disk update properties.
	VMDisks []*VMwareCbtUpdateDiskInput

	// The list of NIC details.
	VMNics []*VMwareCbtNicInput
}

// GetUpdateMigrationItemProviderSpecificInput implements the UpdateMigrationItemProviderSpecificInputClassification interface
// for type VMwareCbtUpdateMigrationItemInput.
func (v *VMwareCbtUpdateMigrationItemInput) GetUpdateMigrationItemProviderSpecificInput() *UpdateMigrationItemProviderSpecificInput {
	return &UpdateMigrationItemProviderSpecificInput{
		InstanceType: v.InstanceType,
	}
}

// VMwareDetails - Store the fabric details specific to the VMware fabric.
type VMwareDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// The number of source and target servers configured to talk to this CS.
	AgentCount *string

	// Agent expiry date.
	AgentExpiryDate *time.Time

	// The agent Version.
	AgentVersion *string

	// The agent version details.
	AgentVersionDetails *VersionDetails

	// The available memory.
	AvailableMemoryInBytes *int64

	// The available space.
	AvailableSpaceInBytes *int64

	// The percentage of the CPU load.
	CPULoad *string

	// The CPU load status.
	CPULoadStatus *string

	// The CS service status.
	CsServiceStatus *string

	// The database server load.
	DatabaseServerLoad *string

	// The database server load status.
	DatabaseServerLoadStatus *string

	// The host name.
	HostName *string

	// The IP address.
	IPAddress *string

	// The last heartbeat received from CS server.
	LastHeartbeat *time.Time

	// The list of Master Target servers associated with the fabric.
	MasterTargetServers []*MasterTargetServer

	// The memory usage status.
	MemoryUsageStatus *string

	// The number of process servers.
	ProcessServerCount *string

	// The list of Process Servers associated with the fabric.
	ProcessServers []*ProcessServer

	// The number of protected servers.
	ProtectedServers *string

	// PS template version.
	PsTemplateVersion *string

	// The number of replication pairs configured in this CS.
	ReplicationPairCount *string

	// The list of run as accounts created on the server.
	RunAsAccounts []*RunAsAccount

	// CS SSL cert expiry date.
	SSLCertExpiryDate *time.Time

	// CS SSL cert expiry date.
	SSLCertExpiryRemainingDays *int32

	// The space usage status.
	SpaceUsageStatus *string

	// The switch provider blocking error information.
	SwitchProviderBlockingErrorDetails []*InMageFabricSwitchProviderBlockingErrorDetails

	// The percentage of the system load.
	SystemLoad *string

	// The system load status.
	SystemLoadStatus *string

	// The total memory.
	TotalMemoryInBytes *int64

	// The total space.
	TotalSpaceInBytes *int64

	// Version status.
	VersionStatus *string

	// The web load.
	WebLoad *string

	// The web load status.
	WebLoadStatus *string
}

// GetFabricSpecificDetails implements the FabricSpecificDetailsClassification interface for type VMwareDetails.
func (v *VMwareDetails) GetFabricSpecificDetails() *FabricSpecificDetails {
	return &FabricSpecificDetails{
		InstanceType: v.InstanceType,
	}
}

// VMwareV2FabricCreationInput - VMwareV2 fabric provider specific settings.
type VMwareV2FabricCreationInput struct {
	// REQUIRED; Gets the class type.
	InstanceType *string

	// REQUIRED; The ARM Id of the migration solution.
	MigrationSolutionID *string

	// The ARM Id of the physical site.
	PhysicalSiteID *string

	// The ARM Id of the VMware site.
	VmwareSiteID *string
}

// GetFabricSpecificCreationInput implements the FabricSpecificCreationInputClassification interface for type VMwareV2FabricCreationInput.
func (v *VMwareV2FabricCreationInput) GetFabricSpecificCreationInput() *FabricSpecificCreationInput {
	return &FabricSpecificCreationInput{
		InstanceType: v.InstanceType,
	}
}

// VMwareV2FabricSpecificDetails - VMwareV2 fabric specific details.
type VMwareV2FabricSpecificDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// READ-ONLY; The Migration solution ARM Id.
	MigrationSolutionID *string

	// READ-ONLY; The ARM Id of the physical site.
	PhysicalSiteID *string

	// READ-ONLY; The list of process servers.
	ProcessServers []*ProcessServerDetails

	// READ-ONLY; The service container Id.
	ServiceContainerID *string

	// READ-ONLY; The service endpoint.
	ServiceEndpoint *string

	// READ-ONLY; The service resource Id.
	ServiceResourceID *string

	// READ-ONLY; The ARM Id of the VMware site.
	VmwareSiteID *string
}

// GetFabricSpecificDetails implements the FabricSpecificDetailsClassification interface for type VMwareV2FabricSpecificDetails.
func (v *VMwareV2FabricSpecificDetails) GetFabricSpecificDetails() *FabricSpecificDetails {
	return &FabricSpecificDetails{
		InstanceType: v.InstanceType,
	}
}

// VMwareVirtualMachineDetails - VMware provider specific settings.
type VMwareVirtualMachineDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// The ID generated by the InMage agent after it gets installed on guest. This is the ID to be used during InMage CreateProtection.
	AgentGeneratedID *string

	// The value indicating if InMage scout agent is installed on guest.
	AgentInstalled *string

	// The agent version.
	AgentVersion *string

	// A value indicating the discovery type of the machine. Value can be vCenter or physical.
	DiscoveryType *string

	// The disk details.
	DiskDetails []*InMageDiskDetails

	// The IP address.
	IPAddress *string

	// The OsType installed on VM.
	OSType *string

	// The value indicating whether VM is powered on.
	PoweredOn *string

	// The VCenter infrastructure Id.
	VCenterInfrastructureID *string

	// The validation errors.
	ValidationErrors []*HealthError
}

// GetConfigurationSettings implements the ConfigurationSettingsClassification interface for type VMwareVirtualMachineDetails.
func (v *VMwareVirtualMachineDetails) GetConfigurationSettings() *ConfigurationSettings {
	return &ConfigurationSettings{
		InstanceType: v.InstanceType,
	}
}

// VaultHealthDetails - Vault health details definition.
type VaultHealthDetails struct {
	// Resource Location
	Location *string

	// The vault health related data.
	Properties *VaultHealthProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource Name
	Name *string

	// READ-ONLY; Resource Type
	Type *string
}

// VaultHealthProperties - class to define the health summary of the Vault.
type VaultHealthProperties struct {
	// The list of the health detail of the containers in the vault.
	ContainersHealth *ResourceHealthSummary

	// The list of the health detail of the fabrics in the vault.
	FabricsHealth *ResourceHealthSummary

	// The list of the health detail of the protected items in the vault.
	ProtectedItemsHealth *ResourceHealthSummary

	// The list of errors on the vault.
	VaultErrors []*HealthError
}

// VaultSetting - Vault setting.
type VaultSetting struct {
	// Resource Location
	Location *string

	// The vault setting properties.
	Properties *VaultSettingProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource Name
	Name *string

	// READ-ONLY; Resource Type
	Type *string
}

// VaultSettingCollection - Vault setting collection.
type VaultSettingCollection struct {
	// The value of next link.
	NextLink *string

	// The list of vault setting.
	Value []*VaultSetting
}

// VaultSettingCreationInput - Input to create vault setting.
type VaultSettingCreationInput struct {
	// REQUIRED; Vault setting creation input properties.
	Properties *VaultSettingCreationInputProperties
}

// VaultSettingCreationInputProperties - Input to create vault setting.
type VaultSettingCreationInputProperties struct {
	// The migration solution Id.
	MigrationSolutionID *string

	// VMware to Azure provider type.
	VmwareToAzureProviderType *string
}

// VaultSettingProperties - Vault setting properties.
type VaultSettingProperties struct {
	// The migration solution ARM Id.
	MigrationSolutionID *string

	// VMware to Azure provider type.
	VmwareToAzureProviderType *string
}

// VersionDetails - Version related details.
type VersionDetails struct {
	// Version expiry date.
	ExpiryDate *time.Time

	// A value indicating whether security update required.
	Status *AgentVersionStatus

	// The agent version.
	Version *string
}

// VirtualMachineTaskDetails - This class represents the virtual machine task details.
type VirtualMachineTaskDetails struct {
	// REQUIRED; The type of task details.
	InstanceType *string

	// The job entity.
	JobTask *JobEntity

	// The skipped reason.
	SkippedReason *string

	// The skipped reason string.
	SkippedReasonString *string
}

// GetJobTaskDetails implements the JobTaskDetailsClassification interface for type VirtualMachineTaskDetails.
func (v *VirtualMachineTaskDetails) GetJobTaskDetails() *JobTaskDetails {
	return &JobTaskDetails{
		InstanceType: v.InstanceType,
		JobTask:      v.JobTask,
	}
}

// GetTaskTypeDetails implements the TaskTypeDetailsClassification interface for type VirtualMachineTaskDetails.
func (v *VirtualMachineTaskDetails) GetTaskTypeDetails() *TaskTypeDetails {
	return &TaskTypeDetails{
		InstanceType: v.InstanceType,
	}
}

// VmmDetails - VMM fabric specific details.
type VmmDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string
}

// GetFabricSpecificDetails implements the FabricSpecificDetailsClassification interface for type VmmDetails.
func (v *VmmDetails) GetFabricSpecificDetails() *FabricSpecificDetails {
	return &FabricSpecificDetails{
		InstanceType: v.InstanceType,
	}
}

// VmmToAzureCreateNetworkMappingInput - Create network mappings input properties/behavior specific to Vmm to Azure Network
// mapping.
type VmmToAzureCreateNetworkMappingInput struct {
	// REQUIRED; The instance type.
	InstanceType *string
}

// GetFabricSpecificCreateNetworkMappingInput implements the FabricSpecificCreateNetworkMappingInputClassification interface
// for type VmmToAzureCreateNetworkMappingInput.
func (v *VmmToAzureCreateNetworkMappingInput) GetFabricSpecificCreateNetworkMappingInput() *FabricSpecificCreateNetworkMappingInput {
	return &FabricSpecificCreateNetworkMappingInput{
		InstanceType: v.InstanceType,
	}
}

// VmmToAzureNetworkMappingSettings - E2A Network Mapping fabric specific settings.
type VmmToAzureNetworkMappingSettings struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string
}

// GetNetworkMappingFabricSpecificSettings implements the NetworkMappingFabricSpecificSettingsClassification interface for
// type VmmToAzureNetworkMappingSettings.
func (v *VmmToAzureNetworkMappingSettings) GetNetworkMappingFabricSpecificSettings() *NetworkMappingFabricSpecificSettings {
	return &NetworkMappingFabricSpecificSettings{
		InstanceType: v.InstanceType,
	}
}

// VmmToAzureUpdateNetworkMappingInput - Update network mappings input properties/behavior specific to vmm to azure.
type VmmToAzureUpdateNetworkMappingInput struct {
	// REQUIRED; The instance type.
	InstanceType *string
}

// GetFabricSpecificUpdateNetworkMappingInput implements the FabricSpecificUpdateNetworkMappingInputClassification interface
// for type VmmToAzureUpdateNetworkMappingInput.
func (v *VmmToAzureUpdateNetworkMappingInput) GetFabricSpecificUpdateNetworkMappingInput() *FabricSpecificUpdateNetworkMappingInput {
	return &FabricSpecificUpdateNetworkMappingInput{
		InstanceType: v.InstanceType,
	}
}

// VmmToVmmCreateNetworkMappingInput - Create network mappings input properties/behavior specific to vmm to vmm Network mapping.
type VmmToVmmCreateNetworkMappingInput struct {
	// REQUIRED; The instance type.
	InstanceType *string
}

// GetFabricSpecificCreateNetworkMappingInput implements the FabricSpecificCreateNetworkMappingInputClassification interface
// for type VmmToVmmCreateNetworkMappingInput.
func (v *VmmToVmmCreateNetworkMappingInput) GetFabricSpecificCreateNetworkMappingInput() *FabricSpecificCreateNetworkMappingInput {
	return &FabricSpecificCreateNetworkMappingInput{
		InstanceType: v.InstanceType,
	}
}

// VmmToVmmNetworkMappingSettings - E2E Network Mapping fabric specific settings.
type VmmToVmmNetworkMappingSettings struct {
	// REQUIRED; Gets the Instance type.
	InstanceType *string
}

// GetNetworkMappingFabricSpecificSettings implements the NetworkMappingFabricSpecificSettingsClassification interface for
// type VmmToVmmNetworkMappingSettings.
func (v *VmmToVmmNetworkMappingSettings) GetNetworkMappingFabricSpecificSettings() *NetworkMappingFabricSpecificSettings {
	return &NetworkMappingFabricSpecificSettings{
		InstanceType: v.InstanceType,
	}
}

// VmmToVmmUpdateNetworkMappingInput - Update network mappings input properties/behavior specific to vmm to vmm.
type VmmToVmmUpdateNetworkMappingInput struct {
	// REQUIRED; The instance type.
	InstanceType *string
}

// GetFabricSpecificUpdateNetworkMappingInput implements the FabricSpecificUpdateNetworkMappingInputClassification interface
// for type VmmToVmmUpdateNetworkMappingInput.
func (v *VmmToVmmUpdateNetworkMappingInput) GetFabricSpecificUpdateNetworkMappingInput() *FabricSpecificUpdateNetworkMappingInput {
	return &FabricSpecificUpdateNetworkMappingInput{
		InstanceType: v.InstanceType,
	}
}

// VmmVirtualMachineDetails - VMM fabric provider specific VM settings.
type VmmVirtualMachineDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// The Last successful failover time.
	DiskDetails []*DiskDetails

	// The id of the object in fabric.
	Generation *string

	// A value indicating whether the VM has a fibre channel adapter attached. String value of SrsDataContract.PresenceStatus
	// enum.
	HasFibreChannelAdapter *PresenceStatus

	// A value indicating whether the VM has a physical disk attached. String value of SrsDataContract.PresenceStatus enum.
	HasPhysicalDisk *PresenceStatus

	// A value indicating whether the VM has a shared VHD attached. String value of SrsDataContract.PresenceStatus enum.
	HasSharedVhd *PresenceStatus

	// The Id of the hyper-v host in fabric.
	HyperVHostID *string

	// The Last replication time.
	OSDetails *OSDetails

	// The source id of the object.
	SourceItemID *string
}

// GetConfigurationSettings implements the ConfigurationSettingsClassification interface for type VmmVirtualMachineDetails.
func (v *VmmVirtualMachineDetails) GetConfigurationSettings() *ConfigurationSettings {
	return &ConfigurationSettings{
		InstanceType: v.InstanceType,
	}
}

// GetHyperVVirtualMachineDetails implements the HyperVVirtualMachineDetailsClassification interface for type VmmVirtualMachineDetails.
func (v *VmmVirtualMachineDetails) GetHyperVVirtualMachineDetails() *HyperVVirtualMachineDetails {
	return &HyperVVirtualMachineDetails{
		DiskDetails:            v.DiskDetails,
		Generation:             v.Generation,
		HasFibreChannelAdapter: v.HasFibreChannelAdapter,
		HasPhysicalDisk:        v.HasPhysicalDisk,
		HasSharedVhd:           v.HasSharedVhd,
		HyperVHostID:           v.HyperVHostID,
		InstanceType:           v.InstanceType,
		OSDetails:              v.OSDetails,
		SourceItemID:           v.SourceItemID,
	}
}

// VmwareCbtPolicyDetails - VMware Cbt specific policy details.
type VmwareCbtPolicyDetails struct {
	// REQUIRED; Gets the class type. Overridden in derived classes.
	InstanceType *string

	// The app consistent snapshot frequency in minutes.
	AppConsistentFrequencyInMinutes *int32

	// The crash consistent snapshot frequency in minutes.
	CrashConsistentFrequencyInMinutes *int32

	// The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistoryInMinutes *int32
}

// GetPolicyProviderSpecificDetails implements the PolicyProviderSpecificDetailsClassification interface for type VmwareCbtPolicyDetails.
func (v *VmwareCbtPolicyDetails) GetPolicyProviderSpecificDetails() *PolicyProviderSpecificDetails {
	return &PolicyProviderSpecificDetails{
		InstanceType: v.InstanceType,
	}
}
