# My wonderful world of macOS [![Thanks](https://img.shields.io/badge/Say%20Thanks-💗-ff69b4.svg)](https://www.patreon.com/nikitavoloboev)
> A list of applications, alfred workflows and various tools that make my macOS experience even more amazing

<img src="https://i.imgur.com/oeOFeY6.jpg" width="600" alt="img">

> [Wallpaper link](https://orig00.deviantart.net/4cc8/f/2016/342/d/d/7_p_m__by_aenami-dar0gav.png)

## Contents
- [Applications](#applications)
- [Browser](#browser)
- [Command Line Apps](#command-line-apps)
- [Alfred Workflows](#alfred-workflows)
- [My wonderful world of iOS](#my-wonderful-world-of-ios-)
- [Similar Setups](#similar-setups)
- [Related](#related)
- [Contributing](#contributing)

## Applications
I use a lot of applications on my mac. Here is a list of the ones that I love and use the most in my day to day life, sorted by their importance. I also share my dotfiles [here](https://github.com/nikitavoloboev/dotfiles).

### 1. [Alfred](https://www.alfredapp.com/)
- This is by far my favourite application that I have. It saved me a lot of time in my life.
<img src="https://i.imgur.com/kbw0yCF.png" width="600" alt="img">

- It has a really great [community](http://www.alfredforum.com/) and very powerful [workflows](https://github.com/learn-anything/alfred-workflows) that you can use.
- I [wrote an article](https://medium.com/@NikitaVoloboev/writing-alfred-workflows-in-go-2a44f62dc432) on how anyone can start developing workflows of their own using Go language.

### 2. [Karabiner](https://pqrs.org/osx/karabiner/)
- One of the applications I cannot live without, allows me to bind any key that I want. I go over how I use the app in detail [here](https://wiki.nikitavoloboev.xyz/macOS/apps/karabiner/karabiner.html).
- Karabiner is the only reason I cannot upgrade my mac to Sierra as [Karabiner Elements](https://github.com/tekezo/Karabiner-Elements) still does not have the features I need.
- I map all the custom keybindings I made as a [mind map](https://my.mindnode.com/mR7ds52Ls21umnbD27SfCD4SmwwrvxxGwvSyy7yW#603.1,-2191.4,3). Below is a small glimpse of that map.

<img src="https://i.imgur.com/CyTXfKk.png" width="600" alt="img">

### 3. [Keyboard Maestro](https://www.keyboardmaestro.com/main/)
- A staggeringly powerful mac automation tool that I am only beginning to scratch the surface of.
- Has a [wonderful community](https://forum.keyboardmaestro.com/) that is happy to help with whatever you are trying to achieve.
- I [share all the macros I use with the app](km).

### 4. [VS Code](https://github.com/Microsoft/vscode)
- My favourite editor that I use to write code in. Most notably I really like its [Vim](https://github.com/VSCodeVim/Vim) and [Go](https://github.com/Microsoft/vscode-go) plugins.
- My config for it can be found [here](https://github.com/nikitavoloboev/dotfiles/blob/master/vscode/settings.json).
- I also really love using [Ayu One Dark](https://marketplace.visualstudio.com/items?itemName=faceair.ayu-one-dark) theme with [Fira Code](https://github.com/tonsky/FiraCode) font. Here is how it looks:

<img src="https://i.imgur.com/q44Or5z.png" width="500" alt="img">

### 5. [iTerm](https://www.iterm2.com/)
- I [moved completely to using the command line](https://wiki.nikitavoloboev.xyz/macOS/apps/iterm.html) for all my development needs, this is probably the best terminal emulator out there that exists, have it assigned to [w + j](https://wiki.nikitavoloboev.xyz/macOS/apps/karabiner/sticky-keys.html) and can open it on demand at any time that I want.
- [Here](https://gist.github.com/nikitavoloboev/3fbe13ce427132d0297f411b62f49034) are all the [homebrew](http://brew.sh/index.html) packages I like and use.
- I also really love using [this workflow](https://github.com/isometry/alfred-tty) to quickly switch between iTerm tabs.
<img src="http://i.imgur.com/RNLb5wj.png" width="500" alt="img">

### 6. [2Do](http://www.2doapp.com/mac)
- I love GTD methodology, this application is phenomenal with [helping me organise my tasks and things I want to do and achieve](https://wiki.nikitavoloboev.xyz/macOS/apps/2do.html).
<img src="https://i.imgur.com/0BQF2a1.png" width="150">

- And it has global quick add with a hotkey.
<img src="https://i.imgur.com/UPdjh6N.png" width="400" alt="img">

- Together with lists, priorities, powerful search and a lot more.

### 7. [MindNode](https://mindnode.com)
- An application which allowed me to create all of the maps for [Learn Anything](https://learn-anything.xyz/).
<img src="https://raw.githubusercontent.com/learn-anything/learn-anything/master/media/header.png" width="700" alt="img">

- It is an incredible joy to make mind maps in this app and I use it to visualize everything.
	- [My notes, my projects, my plans, my thoughts](https://medium.com/@NikitaVoloboev/mind-map-everything-d27670f70739#.p7w44kr44).
- I also try to completely bridge the gap between [my mind maps](https://wiki.nikitavoloboev.xyz/meta/my-mind.html) and my mind with [this alfred workflow](https://github.com/nikitavoloboev/alfred-my-mind).
- I wrote more about how I use this app [here](https://wiki.nikitavoloboev.xyz/macOS/apps/mindnode.html).

### 8. [Dash](https://kapeli.com/dash)
- Very powerful API documentation browser that allows you to download any docset that you might want to use, search for any method, class or anything that you need very quickly, comes with the amazing [Alfred Worfklow](https://www.alfredapp.com/blog/productivity/dash-quicker-api-documentation-search/) to simplify the process of searching for the right things.
<img src="http://i.imgur.com/tBEkKtL.png" width="500" alt="img">

- I also use [this workflow](https://github.com/nikitavoloboev/small-workflows/tree/master/dash-profile-switch) I made to quickly switch between Dash profiles.

### 9. [SnippetsLab](https://www.renfei.org/snippets-lab/)
- A very powerful code snippet manager that I have intergrated very heaviliy in my workflow, with [recent addition](https://www.renfei.org/snippets-lab/press-release/whats-new/osx-1.6.html) of its own alfred workflow, retrieving the snippets that you need it staggeringly fast.
<img src="https://i.imgur.com/Js74VmA.png" width="500" alt="img">

- I share my entire library of snippets you can import yourself [here](snippetslab).
- I use it as my [own personal programmer's notepad](https://wiki.nikitavoloboev.xyz/macOS/apps/snippetslab.html) with code and lots and lots of comments.
<img src="https://i.imgur.com/cDmCSyE.png" width="500" alt="img">

### 10. [1Password](https://1password.com)
- My password manager of choice, recently started to generate all of my passwords with it and keep everything in a secured and encrypted vault kept secure by my one master password.
- No longer need to remember passwords and I now have a unique password for every website that I am signed up on whilist activating two factor authentication wherever possible.

### 11. [Timing 2](https://timingapp.com/whats-new)
- I moved completely to Timing 2 from Toggl for both passive and active tracking.
- The fact that I can combine active and passive tracking together is quite powerful and allows me to be more aware of where I spend my time.
<img src="https://i.imgur.com/SzXbdc3.png" width="500" alt="img">

### 12. [Day One](http://dayoneapp.com/)
- Probably the best journal writing application there is, use it every day to write my [Day Evaluations](https://medium.com/@NikitaVoloboev/day-evaluations-5706f31c9c5e#.5o9j8n48l).
<img src="http://i.imgur.com/V82Em5D.png" width="300" alt="img">

- As well as [many other small little tidbits of text](https://wiki.nikitavoloboev.xyz/macOS/apps/day-one.html) with thoughts, plans and experiences that I have had.
- It also has really awesome integration with [IFTTT](https://ifttt.com/day_one) which I use to automatically log all my tweets and Insgragram posts.
- If you don't journal, I really suggest you to start, it really is a very powerful mind cleanser and acts as a wonderful history record of your life.

### 13. [Ulysses](http://www.ulyssesapp.com/)
- All your writing in one place is the motto and the underlying design of the app.
- It has very powerful search:
<img src="http://i.imgur.com/Aa17RCQ.png" width="500" alt="img">

- Freedom of structure, great themes and export to markdown / PDF.
- I use it to manage writing and managing my [personal wiki](https://wiki.nikitavoloboev.xyz) as well as writing my [Medium artciles](https://wiki.nikitavoloboev.xyz/sharing/my-articles.html) that I can then publish in one click from Ulysses.
- I write a bit more about how I use the app [here](https://wiki.nikitavoloboev.xyz/macOS/apps/ulysses.html).

### 14. [Typinator](http://www.ergonis.com/products/typinator/)
- I use the app to [fully automate writing repetetive text](https://medium.com/@NikitaVoloboev/write-once-never-write-again-c2fa1f6c4e8).
- I share the Typinator sets I made with the app [here](./typinator) and describe the app in more detail [here](https://wiki.nikitavoloboev.xyz/macOS/apps/typinator.html).

### 15. [Pixave](http://www.littlehj.com/)
- I always wanted to organise the mess that my media files were, moving all of my photographs, gifs that I have saved over the years to one place that is easily searchable and is again just a joy to use was very valuable for me.
- Probably the best application there exists for storing and organising all of your photographic media content.
- I write about the app in more detail [here](https://wiki.nikitavoloboev.xyz/macOS/apps/pixave.html) and I share most of my library on [Imgur](http://nikivii.imgur.com/) and [Instagram](https://www.instagram.com/niikivi). Here is how my library looks like:
<img src="https://i.imgur.com/MjGFvSb.jpg" width="500" alt="img">

### 16. [BetterTouchTool](https://www.boastr.net/)
- Another amazing application that I use to create [custom trackpad gestures](https://medium.com/@NikitaVoloboev/take-control-of-your-touchpad-on-macos-45c581f542e0#.7n1ye6vze).
- I love scrolling through my tabs in Safari with three finger swipes left and right as well as opening and closing tabs with swiping up and down respectively.
- [Here](./btt) are all the different gestures I have setup to use with the app that you can view and download.

### 17. [PDF Expert](https://pdfexpert.com/)
- I read a lot of PDFs like books, uni assignments and the like.
- This app is a huge upgrade over Preview app that I used before.
- Multiple tabs, sepia mode, very nice annotation tools, great search, performance.

### 18. [Airmail](http://airmailapp.com/)
- By far the most well designed and feature rich mail application that I have used so far, really love all of its simple design, support for multiple accounts and a multitude of nice shortcuts that you can use.

### 19. [Spotify](https://www.spotify.com/us/)
- Found a [lot of great music](https://wiki.nikitavoloboev.xyz/music/music-plays.html) with this application and the phenomenal [Alfred Workflow](http://alfred-spotify-mini-player.com/) makes using the application an absolute joy.
- Quickly finding artists, songs I want to listen, instantly adding the song playing to my 'likes' playlist or any other playlist I want, seeing what other songs the artist has and more.
<img src="https://i.imgur.com/UgRLB92.png" width="500" alt="img">

### 20. [Fantastical](https://flexibits.com/fantastical)
- Just a straight up best application there is for organising and creating events in your life.
- Global quick add with a hotkey, natural language input and its great design is what made me switch from an already great Calendar app which comes natively with macOS.
	- I also added some of my own [text expansions](https://medium.com/@NikitaVoloboev/fantastical-natural-input-text-expansions-3ea8cf7ccac3#.pv5937ncr) to help with natural text input.
- I wrote more on how I use the app [here](https://wiki.nikitavoloboev.xyz/macOS/apps/fantastical.html).

### 20. [Contexts](https://contexts.co)
- Allows me to fuzzy search through all the currenly active windows that I have.
<img src="https://i.imgur.com/KNuimJv.png" width="500" alt="img">

- As well as making jumping to the right window I need effortless as I often may have many VS Code instances with different projects.

### 21. [Dictionary](http://www.wikiwand.com/en/Dictionary_(software))
- Comes natively with macOS and I started to love using it for exploring and searching through Wikipedia.
- It is incredibly fast to make the searches and it also gives quick autosuggestions for any query I type that I can then select with up and down arrows.
<img src="http://i.imgur.com/BPOmjkZ.png" width="400" alt="img">

### 22. [Bartender](https://www.macbartender.com/)
- A great utility app that allows you to customise and hide the contents of your menu bar, really does improve the aesthetics of your OS but also is quite beneficial for me as I customised it to have the most important information that I need to show in it.
<img src="http://i.imgur.com/2SEANOJ.png" width="500" alt="img">

- I can then activate Bartender and start searching for the menu bar item I need all from the keyboard.

### 23. [Ship](https://www.realartists.com/index.html)
- A really awesome native app that lets me manage my GitHub issues.
- Can schedule certain issues as 'Up Next' and complete them one by one.
<img src="https://i.imgur.com/OhfqPTu.png" width="500" alt="img">

### 24. [Textual](https://www.codeux.com/textual/)
- Recently started to grow a big liking of various cool IRC channels that exist out there, this app is a really wonderful client for all things IRC.
- I created my own Night Blue theme based on Telegram that you can view and download [here](textual).
- It also has an awesome channel search feature that I use a lot.
<img src="http://i.imgur.com/jwVCcMb.png" width="500" alt="img">

#### 25. [Focus](https://heyfocus.com)
- I have hckrnews, reddit, twitter on the black list and have a schedule where I can only use these websites two times in my day, 30 minutes in the morning and 30 minutes in the evening, this acts as my own version of [information diet](https://medium.com/@NikitaVoloboev/news-d6bcaaf40121). Really does make a difference and helps me focus on what I need to be working on.
<img src="http://i.imgur.com/cnVvp3m.png" width="500" alt="img">

#### 26. [Tweetbot](http://tapbots.com/tweetbot/mac/)
- Twitter and tweetbot are blocked for me for the majority of the day due to them being a big cause of distraction but the times I do use Twitter, it would be done through this wonderful client that features a timeline without advertisements and one that is synced with the iOS app.

#### 27. [YNAB](https://www.youneedabudget.com/)
- Use it to track and overview all of my finances, the most important part of this app is the [ideology](http://classic.youneedabudget.com/method) behind it. The whole app is built around this methodology and I really recommend you take a look at it even if you are not planning to use the app, I find it really freeing and powerful.

#### 28. [Reeder](http://reederapp.com/mac/)
- Wasn't a big user of RSS but with me finding a lot of great blogs out there, I needed a place to keep myself updated on the great content that they will be posting.
- Reeder is the best RSS reeder out there that I found.

#### 30. [Transmit](https://www.panic.com/transmit/)
- I often use this app to quickly send files from my local file system to the cloud (either S3 or dropbox) and get a shareable link I can send to people.
- I use [this alfred workflow](https://www.dropbox.com/s/6y1lwy7lq9njdv6/Transmit.alfredworkflow?dl=1) to quickly open the cloud storage I need.
<img src="http://i.imgur.com/RkkcdvA.png" width="400" alt="img">

#### 31. [Transmission](https://www.transmissionbt.com/)
- A torrent client that I use, very minimal in its UI but is very powerful and has all the features that I need without the bloat that [uTorrent](http://www.utorrent.com/intl/en/) and other clients have.
- Have all my torrents downloaded into their specific folders.
- I also want to set up a seedbox with my raspberry pie in the future as I have a bad tendency of not seeding the torrents that I downloaded.

#### 32. [Sketch](https://www.sketchapp.com/)
- Not very fond of subscription based business models but this app is probably the de facto standard in doing any kind of design work on Mac.

#### 33. [Pixelmator](http://www.pixelmator.com/mac/)
- Probably the best image editor out there on Mac, is packed with very powerful features and is very simple in its UI.

#### 34. [Flux](https://justgetflux.com)
- A simple utility that makes the screen have nice and warm non blue light emitting colour in the evening.
	- As of macOS Sierra, you can use the [built-in feature](https://support.apple.com/en-us/HT207513) by Apple instead.

#### 35. [Dropzone](https://aptonic.com)
- A quick utility that pops up when I drag some file into it or open it with a hotkey, use it to upload images to [Imgur](http://imgur.com), dropping files into a preset number of folders that I made quickly as well as going to them in an instant) (a great little utility).
<img src="https://i.imgur.com/UTqei1d.png" width="300" alt="img">

#### 36. [Popclip](https://pilotmoon.com/popclip/)
- Another great utility I cannot live without, brings up a quick menu whenever some text is selected on which I can do a number of quick actions, like searching on DuckDuckGo, Youtube, Dictionary, Reddit, Images or it can translate text selected, copy it or say it aloud, here is how it looks for me:
<img src="https://i.imgur.com/jmNmrmx.png" width="400" alt="img">

#### 37. [Next Meeting](https://itunes.apple.com/us/app/next-meeting-menu-bar-app/id1017470484?mt=12)
- A great menu bar tool that shows me how much time is left until the next event in my calendar.
- It has been quite a big addition to my workflow as I know can quickly know how much time is left until my next class or some other event starts.

#### 38. [Marked](http://marked2app.com)
- If I ever need to preview a readme or any other markdown file that I wrote or just want to read, this app is the best application for that I found.
	- it also features live updating and quite a lot of very powerful customisation features.

#### 40. [DaisyDisk](https://daisydiskapp.com)
- A great tool to quickly get a visual glance over what is taking up your disk space and where).

#### 41. [Gemini](http://macpaw.com/gemini)
- A great little utility to find duplicate files in the system. Didn't get much use of it so far but it may be quite useful on occasions where I do want to clean up my system from useless files and junk.

#### 42. [MonthlyCal](https://itunes.apple.com/us/app/monthlycal-colorful-monthly/id935250717?mt=12)
- A really great visual representation of my month in form of a notification center widget that allows me to see any day I want at a glance as well as what day of month it is and how many events I have in this week.
<img src="https://i.imgur.com/8sXe5aK.png" width="300" alt="img">

#### 43. [iStat Menus](https://bjango.com/mac/istatmenus/)
- Great system monitoring tools of which I use CPU and storage tracking, I find it very valuable to know if my CPU is being abused by some application and if so by which.

#### 44. [Annotate](https://itunes.apple.com/us/app/annotate-capture-screenshot/id918207447?mt=12)
- Best annotation tool I found to exist. After you make a screenshot, it allows for quick edits (arrows, adding some text, blurring parts of the image) as well as ability to quickly save it or drag it to upload to Imgur to share quickly and send the link to anyone I want.

#### 45. [BeardedSpice](https://github.com/beardedspice/beardedspice)
- Enhance play/pause as well as previous/next playback keys to not only work in iTunes and Spotify but work for [Soundcloud](https://soundcloud.com/stream), [Youtube](https://www.youtube.com) and many other services.

#### 46. [Little Snitch](https://www.obdev.at/products/littlesnitch/index.html)
- An amazing networking tool that gives you a clear picture of what connections are incoming to your computer and what are outgoing.
- Takes a bit of time to set it up correctly and is quite an insightful experience first turning it on and having it notify every couple of seconds that some app is trying to send data to some server and whether you want to allow that.
- This is essential if you want to take control of what information gets sent out from your computer and what connections have right to connect to your data.

#### 47. [Texpad](https://www.texpadapp.com/osx)
- Had to write some LaTeX files for some of my university assignments and in search of a great editor for writing LaTeX I found this and have really enjoyed using it for that task.
- Has phenomenal suggestions, a great UI interface and live previewing the LaTeX code that you write.).

#### 48. [Slack](https://slack.com)
- Find it to be quite a slow application, given the fact that it is essentially a chrome web application wrapped up with [electron](http://electron.atom.io), it is not much surprise but still it does have some really great features for working and communicating within a team.

#### 49. [Telegram](https://desktop.telegram.org/)
- Really dislike Whatsapp and I quite like Telegram.
- It has a very clean interface, a native client for macOS and stickers, privacy is questionable as data is still being sent through Telegram servers but it is still a great chat application).

#### 50. [Anki](http://ankisrs.net)
- Still not fully utilising the full power of [spaced repetition learning](http://www.wikiwand.com/en/Spaced_repetition) but it was one of my goals this year to really start to use this to my advantage. Essentially all this software does is provide you the means to write your own digital flashcards that you can then test yourself on. It also has a lot of [amazing addons](https://ankiweb.net/shared/addons/) that you can get to add more functionality to the app.

#### 51. [ImageOptim](https://imageoptim.com/mac)
- Quickly remove all the unneeded metadata from the image as well as compress images without losing any visual quality and saving a lot of bandwidth when uploading these images on your website or blog.

#### 52. [Dragand](http://dragand.watch)
- Quickly get subtitles that I want by dragging the file with the movie/series I want to watch to the app.

#### 53. [GIF Brewery](http://gifbrewery.com)
- Allows me to create some great GIFs from video clips as well as converting the entire video clip into a GIF if need be.

#### 54. [Noizio](http://noiz.io/)
- Rain, whale noises, coffee shop noises right from my menu bar, when I am tired of listening to music and just want to focus.

#### 55. [Sip](https://sipapp.io/)
- A really great colour picker that is quite often getting updated.

#### 56. [Paw](https://paw.cloud)
- A really great tool for working with API's, only recently started to use it but the features it has are really handy and the design is intuitive and great.

#### 58. [IINA](https://github.com/lhc70000/iina)
- Open source alternative to VLC built specifically for macOS.
- It is based on [mpv](https://github.com/mpv-player/mpv) and has a more modern and native look than VLC.

#### 59. [Hammerspoon](http://www.hammerspoon.org)
- Really powerul automation engine, wanted to use it for window management at first but found BetterTouchTool to be more performant.
- Right now I use it show the task I am currenly working on in a little window in the middle of the screen for a brief moment:
<img src="https://i.imgur.com/UXqwr5a.png" width="300" alt="img">

- My config for it can be seen [here](https://github.com/nikitavoloboev/dotfiles/blob/master/hammerspoon/init.lua).

#### 60. [Kap](https://github.com/wulkano/kap)
- An open source screen recorder I use to record GIFs.
- Has keyboard support so I can quickly start and end recording of the GIF in one hotkey.

#### 61. [PodcastMenu](https://github.com/insidegui/PodcastMenu)
- Allows you to listen and control playback of podcasts from [Overcast](https://overcast.fm) right from your menu bar.

#### 62. [TotalSpaces2](https://totalspaces.binaryage.com/)
- Allows me to completely remove the animation of switching between spaces/full screen apps.
- Now I [run most applications as full screen](http://i.imgur.com/I8JkIi3.png) and switch between them with [Karabiner](https://github.com/tekezo/Karabiner-Elements).

#### 63. [Default Folder X](http://stclairsoft.com/DefaultFolderX/)
- Neat little utility I mostly use to [quickly go to various folders](http://i.imgur.com/UOrHiRq.png) from file save windows.

#### 64. [Hazel](https://www.noodlesoft.com)
- Use it to fully automate my filing process and automatically commit changes in my [Web Searches](https://github.com/nikitavoloboev/alfred-web-searches) repo.
- I use prefixes for everything, bookmarks, notes, Ulysses entries and even files.
	- This allows me to write some great rules for my Downloads folder that will file the files where I want them to be.
	- Here is one example of such rule:
<img src="http://i.imgur.com/7oiSYV3.png" width="500" alt="img">

#### 65. [BitBar](https://github.com/matryer/bitbar)
- Can display various things in your menu bar.
- I use it to show my current task I am working on with a simple bitbar plugin that echoes what I put there.
- Which I then can [display it with HammerSpoon](https://github.com/nikitavoloboev/dotfiles/blob/master/hammerspoon/init.lua#L57) briefly on my screen to remind myself of what I need to be doing.
- I also use it to show a [list of brew services](https://getbitbar.com/plugins/Dev/Homebrew/brew-services.10m.rb) running on my system.

## Browser
My browser of choice is [Safari](http://www.apple.com/safari/). Chrome just kills the battery and Safari is really well optimised for macOS plus I have tried both and I really do find Safari a lot more 'snappier' to use. One powerful plus that chrome does have over safari is the amount of chrome extensions that you can get. Fortunately the ones most needed for me do exist on Safari.

I keep a list of my favourite Safari extensions and why I love them in a GitHub repository [here](https://github.com/learn-anything/safari-extensions). Feel free to contribute to it if you wish.

I do however use Chrome for web devolopment due to its superior Chrome Dev tools. [Here](https://github.com/learn-anything/chrome-extensions) you can find the chrome extensions I like and use for that.

## Command Line Apps
[Homebrew](https://brew.sh) is a really wonderful and user friendly package manager for macOS.

[Here](https://gist.github.com/nikitavoloboev/3fbe13ce427132d0297f411b62f49034) are all the packages I use from it.

And here are some more command line tools I use and love:
- [thefuck](https://github.com/nvbn/thefuck) - Corrects your previous console command.
- [ccat](https://github.com/jingweno/ccat) - [cat](http://www.linfo.org/cat.html) command with colours.
- [coreutils](https://www.topbug.net/blog/2013/04/14/install-and-use-gnu-command-line-tools-in-mac-os-x/) - Various useful GNU utils that don’t come with macOS.
- [ripgrep](https://github.com/BurntSushi/ripgrep) - Search text for patterns really fast.
- [m-cli](https://github.com/rgcr/m-cli) - Useful utils for macOS.
- [mas](https://github.com/mas-cli/mas) - CLI for mac app store.
- [youtube-dl](https://github.com/rg3/youtube-dl) - Download videos from youtube and other video sites.
- [tmux](https://github.com/tmux/tmux) - Terminal multiplexer.
- [pandoc](https://github.com/jgm/pandoc) - Universal markup converter.
- [trash](https://github.com/sindresorhus/trash) - Move files and folders to the trash.
- [vtop](https://github.com/MrRio/vtop) - Graphical activity monitor.
- [curl](https://github.com/curl/curl) - Transfer data, supports various protocols.
- [howdoi](https://github.com/gleitz/howdoi) - Instant coding answers.
- [asciinema](https://github.com/asciinema/asciinema) - Terminal session recorder.
- [tldr](https://github.com/tldr-pages/tldr) - Simplified and community-driven man pages.
- [imgcat](https://github.com/eddieantonio/imgcat) - Like [cat](http://www.linfo.org/cat.html) but for images.
- [screenfetch](https://github.com/KittyKatt/screenFetch) - Fetches system/theme information in terminal.
- [hugo](https://github.com/gohugoio/hugo) - Fast and flexible static site generator.
- [coala](https://github.com/coala/coala) - Linting and fixing of code.
- [reflex](https://github.com/cespare/reflex) - Run a command when files change.
- [create-react-app](https://github.com/facebookincubator/create-react-app) - Create React apps with no build configuration.
- [now](https://github.com/zeit/now-cli) - Realtime global deployments served over HTTP/2.
- [yarn](https://github.com/yarnpkg/yarn) - Fast, reliable, and secure dependency management.
- [iStats](https://github.com/Chris911/iStats) - System stats from the command-line.
- [alfred](https://github.com/jason0x43/go-alfred#installation) - Symlinks your go project to alfred directory and builds your workflow.
- [license up](https://github.com/nikitavoloboev/license-up) - Create a license quickly for your project.
- [fzf](https://github.com/junegunn/fzf) - Command-line fuzzy finder.
- [exa](https://github.com/ogham/exa) - Replacement for ls written in rust.

## [Alfred Workflows](https://github.com/learn-anything/alfred-workflows)
I find [Alfred](https://www.alfredapp.com) with its ability to create custom workflows for it to bring me the most value.

I keep a list of my favourite workflows and why I love them in a GitHub repository [here](https://github.com/learn-anything/alfred-workflows). Feel free to contribute to it if you wish.

## Desktop Screenshot
> Using [Screenfetch](https://github.com/KittyKatt/screenFetch)

![](https://i.imgur.com/1X3soFt.jpg)

## Launchpad

![](https://i.imgur.com/8Wd8vyw.png)

## [My wonderful world of iOS 📱](https://github.com/nikitavoloboev/my-ios)
If you found this interesting, I also have [similar repository](https://github.com/nikitavoloboev/my-ios) going over what applications I use on iOS as well as how and why I use them.

<a align="center" href="https://github.com/nikitavoloboev/my-ios">
    <img width="200" heigth="400" src="https://i.imgur.com/C5XHDDr.jpg"></a>

<a align="center" href="https://github.com/nikitavoloboev/my-ios">
    <img width="200" heigth="400" src="https://i.imgur.com/vSaLuSi.jpg"></a>

## Similar Setups
Here you can find more setups by other people that you can take ideas and inspiration from.
- [Works for me](https://works-for-me.github.io/) - Collection of developer toolkits.
- [Use This Interviews](https://usesthis.com) - What do people use to get stuff done?

## Related
- [Awesome mac](https://github.com/jaywcjlove/awesome-mac)

## Contributing
[Suggestions](https://github.com/nikitavoloboev/my-mac-os/issues) and pull requests are highly encouraged!

If you shared a similiar personal setup to this, be it for Windows, Linux or anything else, you can add it in [Similar Setups](#similar-setups) section.

I love finding new awesome tools and apps. If you have a favourite tool or app that you think I missed, please [say it](https://github.com/nikitavoloboev/my-mac-os/issues/new).

## Thank you 💜
You can support what I do on [Patreon](https://www.patreon.com/nikitavoloboev) or look into [other projects](https://nikitavoloboev.xyz/projects) I shared.

## License
MIT © [Nikita Voloboev](https://www.nikitavoloboev.xyz)