// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/spanner/v1/spanner.proto

package spannerpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The relative priority for requests. Note that priority is not applicable
// for [BeginTransaction][google.spanner.v1.Spanner.BeginTransaction].
//
// The priority acts as a hint to the Cloud Spanner scheduler and does not
// guarantee priority or order of execution. For example:
//
//   - Some parts of a write operation always execute at `PRIORITY_HIGH`,
//     regardless of the specified priority. This may cause you to see an
//     increase in high priority workload even when executing a low priority
//     request. This can also potentially cause a priority inversion where a
//     lower priority request will be fulfilled ahead of a higher priority
//     request.
//   - If a transaction contains multiple operations with different priorities,
//     Cloud Spanner does not guarantee to process the higher priority
//     operations first. There may be other constraints to satisfy, such as
//     order of operations.
type RequestOptions_Priority int32

const (
	// `PRIORITY_UNSPECIFIED` is equivalent to `PRIORITY_HIGH`.
	RequestOptions_PRIORITY_UNSPECIFIED RequestOptions_Priority = 0
	// This specifies that the request is low priority.
	RequestOptions_PRIORITY_LOW RequestOptions_Priority = 1
	// This specifies that the request is medium priority.
	RequestOptions_PRIORITY_MEDIUM RequestOptions_Priority = 2
	// This specifies that the request is high priority.
	RequestOptions_PRIORITY_HIGH RequestOptions_Priority = 3
)

// Enum value maps for RequestOptions_Priority.
var (
	RequestOptions_Priority_name = map[int32]string{
		0: "PRIORITY_UNSPECIFIED",
		1: "PRIORITY_LOW",
		2: "PRIORITY_MEDIUM",
		3: "PRIORITY_HIGH",
	}
	RequestOptions_Priority_value = map[string]int32{
		"PRIORITY_UNSPECIFIED": 0,
		"PRIORITY_LOW":         1,
		"PRIORITY_MEDIUM":      2,
		"PRIORITY_HIGH":        3,
	}
)

func (x RequestOptions_Priority) Enum() *RequestOptions_Priority {
	p := new(RequestOptions_Priority)
	*p = x
	return p
}

func (x RequestOptions_Priority) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RequestOptions_Priority) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_v1_spanner_proto_enumTypes[0].Descriptor()
}

func (RequestOptions_Priority) Type() protoreflect.EnumType {
	return &file_google_spanner_v1_spanner_proto_enumTypes[0]
}

func (x RequestOptions_Priority) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RequestOptions_Priority.Descriptor instead.
func (RequestOptions_Priority) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{8, 0}
}

// Indicates the type of replica.
type DirectedReadOptions_ReplicaSelection_Type int32

const (
	// Not specified.
	DirectedReadOptions_ReplicaSelection_TYPE_UNSPECIFIED DirectedReadOptions_ReplicaSelection_Type = 0
	// Read-write replicas support both reads and writes.
	DirectedReadOptions_ReplicaSelection_READ_WRITE DirectedReadOptions_ReplicaSelection_Type = 1
	// Read-only replicas only support reads (not writes).
	DirectedReadOptions_ReplicaSelection_READ_ONLY DirectedReadOptions_ReplicaSelection_Type = 2
)

// Enum value maps for DirectedReadOptions_ReplicaSelection_Type.
var (
	DirectedReadOptions_ReplicaSelection_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "READ_WRITE",
		2: "READ_ONLY",
	}
	DirectedReadOptions_ReplicaSelection_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"READ_WRITE":       1,
		"READ_ONLY":        2,
	}
)

func (x DirectedReadOptions_ReplicaSelection_Type) Enum() *DirectedReadOptions_ReplicaSelection_Type {
	p := new(DirectedReadOptions_ReplicaSelection_Type)
	*p = x
	return p
}

func (x DirectedReadOptions_ReplicaSelection_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DirectedReadOptions_ReplicaSelection_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_v1_spanner_proto_enumTypes[1].Descriptor()
}

func (DirectedReadOptions_ReplicaSelection_Type) Type() protoreflect.EnumType {
	return &file_google_spanner_v1_spanner_proto_enumTypes[1]
}

func (x DirectedReadOptions_ReplicaSelection_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DirectedReadOptions_ReplicaSelection_Type.Descriptor instead.
func (DirectedReadOptions_ReplicaSelection_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{9, 0, 0}
}

// Mode in which the statement must be processed.
type ExecuteSqlRequest_QueryMode int32

const (
	// The default mode. Only the statement results are returned.
	ExecuteSqlRequest_NORMAL ExecuteSqlRequest_QueryMode = 0
	// This mode returns only the query plan, without any results or
	// execution statistics information.
	ExecuteSqlRequest_PLAN ExecuteSqlRequest_QueryMode = 1
	// This mode returns both the query plan and the execution statistics along
	// with the results.
	ExecuteSqlRequest_PROFILE ExecuteSqlRequest_QueryMode = 2
)

// Enum value maps for ExecuteSqlRequest_QueryMode.
var (
	ExecuteSqlRequest_QueryMode_name = map[int32]string{
		0: "NORMAL",
		1: "PLAN",
		2: "PROFILE",
	}
	ExecuteSqlRequest_QueryMode_value = map[string]int32{
		"NORMAL":  0,
		"PLAN":    1,
		"PROFILE": 2,
	}
)

func (x ExecuteSqlRequest_QueryMode) Enum() *ExecuteSqlRequest_QueryMode {
	p := new(ExecuteSqlRequest_QueryMode)
	*p = x
	return p
}

func (x ExecuteSqlRequest_QueryMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExecuteSqlRequest_QueryMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_v1_spanner_proto_enumTypes[2].Descriptor()
}

func (ExecuteSqlRequest_QueryMode) Type() protoreflect.EnumType {
	return &file_google_spanner_v1_spanner_proto_enumTypes[2]
}

func (x ExecuteSqlRequest_QueryMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExecuteSqlRequest_QueryMode.Descriptor instead.
func (ExecuteSqlRequest_QueryMode) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{10, 0}
}

// An option to control the order in which rows are returned from a read.
type ReadRequest_OrderBy int32

const (
	// Default value.
	//
	// ORDER_BY_UNSPECIFIED is equivalent to ORDER_BY_PRIMARY_KEY.
	ReadRequest_ORDER_BY_UNSPECIFIED ReadRequest_OrderBy = 0
	// Read rows are returned in primary key order.
	//
	// In the event that this option is used in conjunction with the
	// `partition_token` field, the API will return an `INVALID_ARGUMENT` error.
	ReadRequest_ORDER_BY_PRIMARY_KEY ReadRequest_OrderBy = 1
	// Read rows are returned in any order.
	ReadRequest_ORDER_BY_NO_ORDER ReadRequest_OrderBy = 2
)

// Enum value maps for ReadRequest_OrderBy.
var (
	ReadRequest_OrderBy_name = map[int32]string{
		0: "ORDER_BY_UNSPECIFIED",
		1: "ORDER_BY_PRIMARY_KEY",
		2: "ORDER_BY_NO_ORDER",
	}
	ReadRequest_OrderBy_value = map[string]int32{
		"ORDER_BY_UNSPECIFIED": 0,
		"ORDER_BY_PRIMARY_KEY": 1,
		"ORDER_BY_NO_ORDER":    2,
	}
)

func (x ReadRequest_OrderBy) Enum() *ReadRequest_OrderBy {
	p := new(ReadRequest_OrderBy)
	*p = x
	return p
}

func (x ReadRequest_OrderBy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReadRequest_OrderBy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_v1_spanner_proto_enumTypes[3].Descriptor()
}

func (ReadRequest_OrderBy) Type() protoreflect.EnumType {
	return &file_google_spanner_v1_spanner_proto_enumTypes[3]
}

func (x ReadRequest_OrderBy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReadRequest_OrderBy.Descriptor instead.
func (ReadRequest_OrderBy) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{18, 0}
}

// A lock hint mechanism for reads done within a transaction.
type ReadRequest_LockHint int32

const (
	// Default value.
	//
	// LOCK_HINT_UNSPECIFIED is equivalent to LOCK_HINT_SHARED.
	ReadRequest_LOCK_HINT_UNSPECIFIED ReadRequest_LockHint = 0
	// Acquire shared locks.
	//
	// By default when you perform a read as part of a read-write transaction,
	// Spanner acquires shared read locks, which allows other reads to still
	// access the data until your transaction is ready to commit. When your
	// transaction is committing and writes are being applied, the transaction
	// attempts to upgrade to an exclusive lock for any data you are writing.
	// For more information about locks, see [Lock
	// modes](https://cloud.google.com/spanner/docs/introspection/lock-statistics#explain-lock-modes).
	ReadRequest_LOCK_HINT_SHARED ReadRequest_LockHint = 1
	// Acquire exclusive locks.
	//
	// Requesting exclusive locks is beneficial if you observe high write
	// contention, which means you notice that multiple transactions are
	// concurrently trying to read and write to the same data, resulting in a
	// large number of aborts. This problem occurs when two transactions
	// initially acquire shared locks and then both try to upgrade to exclusive
	// locks at the same time. In this situation both transactions are waiting
	// for the other to give up their lock, resulting in a deadlocked situation.
	// Spanner is able to detect this occurring and force one of the
	// transactions to abort. However, this is a slow and expensive operation
	// and results in lower performance. In this case it makes sense to acquire
	// exclusive locks at the start of the transaction because then when
	// multiple transactions try to act on the same data, they automatically get
	// serialized. Each transaction waits its turn to acquire the lock and
	// avoids getting into deadlock situations.
	//
	// Because the exclusive lock hint is just a hint, it should not be
	// considered equivalent to a mutex. In other words, you should not use
	// Spanner exclusive locks as a mutual exclusion mechanism for the execution
	// of code outside of Spanner.
	//
	// **Note:** Request exclusive locks judiciously because they block others
	// from reading that data for the entire transaction, rather than just when
	// the writes are being performed. Unless you observe high write contention,
	// you should use the default of shared read locks so you don't prematurely
	// block other clients from reading the data that you're writing to.
	ReadRequest_LOCK_HINT_EXCLUSIVE ReadRequest_LockHint = 2
)

// Enum value maps for ReadRequest_LockHint.
var (
	ReadRequest_LockHint_name = map[int32]string{
		0: "LOCK_HINT_UNSPECIFIED",
		1: "LOCK_HINT_SHARED",
		2: "LOCK_HINT_EXCLUSIVE",
	}
	ReadRequest_LockHint_value = map[string]int32{
		"LOCK_HINT_UNSPECIFIED": 0,
		"LOCK_HINT_SHARED":      1,
		"LOCK_HINT_EXCLUSIVE":   2,
	}
)

func (x ReadRequest_LockHint) Enum() *ReadRequest_LockHint {
	p := new(ReadRequest_LockHint)
	*p = x
	return p
}

func (x ReadRequest_LockHint) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReadRequest_LockHint) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_v1_spanner_proto_enumTypes[4].Descriptor()
}

func (ReadRequest_LockHint) Type() protoreflect.EnumType {
	return &file_google_spanner_v1_spanner_proto_enumTypes[4]
}

func (x ReadRequest_LockHint) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReadRequest_LockHint.Descriptor instead.
func (ReadRequest_LockHint) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{18, 1}
}

// The request for [CreateSession][google.spanner.v1.Spanner.CreateSession].
type CreateSessionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The database in which the new session is created.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// Required. The session to create.
	Session *Session `protobuf:"bytes,2,opt,name=session,proto3" json:"session,omitempty"`
}

func (x *CreateSessionRequest) Reset() {
	*x = CreateSessionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSessionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSessionRequest) ProtoMessage() {}

func (x *CreateSessionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSessionRequest.ProtoReflect.Descriptor instead.
func (*CreateSessionRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{0}
}

func (x *CreateSessionRequest) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *CreateSessionRequest) GetSession() *Session {
	if x != nil {
		return x.Session
	}
	return nil
}

// The request for
// [BatchCreateSessions][google.spanner.v1.Spanner.BatchCreateSessions].
type BatchCreateSessionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The database in which the new sessions are created.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// Parameters to be applied to each created session.
	SessionTemplate *Session `protobuf:"bytes,2,opt,name=session_template,json=sessionTemplate,proto3" json:"session_template,omitempty"`
	// Required. The number of sessions to be created in this batch call.
	// The API may return fewer than the requested number of sessions. If a
	// specific number of sessions are desired, the client can make additional
	// calls to BatchCreateSessions (adjusting
	// [session_count][google.spanner.v1.BatchCreateSessionsRequest.session_count]
	// as necessary).
	SessionCount int32 `protobuf:"varint,3,opt,name=session_count,json=sessionCount,proto3" json:"session_count,omitempty"`
}

func (x *BatchCreateSessionsRequest) Reset() {
	*x = BatchCreateSessionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateSessionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateSessionsRequest) ProtoMessage() {}

func (x *BatchCreateSessionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateSessionsRequest.ProtoReflect.Descriptor instead.
func (*BatchCreateSessionsRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{1}
}

func (x *BatchCreateSessionsRequest) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *BatchCreateSessionsRequest) GetSessionTemplate() *Session {
	if x != nil {
		return x.SessionTemplate
	}
	return nil
}

func (x *BatchCreateSessionsRequest) GetSessionCount() int32 {
	if x != nil {
		return x.SessionCount
	}
	return 0
}

// The response for
// [BatchCreateSessions][google.spanner.v1.Spanner.BatchCreateSessions].
type BatchCreateSessionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The freshly created sessions.
	Session []*Session `protobuf:"bytes,1,rep,name=session,proto3" json:"session,omitempty"`
}

func (x *BatchCreateSessionsResponse) Reset() {
	*x = BatchCreateSessionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateSessionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateSessionsResponse) ProtoMessage() {}

func (x *BatchCreateSessionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateSessionsResponse.ProtoReflect.Descriptor instead.
func (*BatchCreateSessionsResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{2}
}

func (x *BatchCreateSessionsResponse) GetSession() []*Session {
	if x != nil {
		return x.Session
	}
	return nil
}

// A session in the Cloud Spanner API.
type Session struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the session. This is always system-assigned.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The labels for the session.
	//
	//   - Label keys must be between 1 and 63 characters long and must conform to
	//     the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
	//   - Label values must be between 0 and 63 characters long and must conform
	//     to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
	//   - No more than 64 labels can be associated with a given session.
	//
	// See https://goo.gl/xmQnxf for more information on and examples of labels.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The timestamp when the session is created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The approximate timestamp when the session is last used. It is
	// typically earlier than the actual last use time.
	ApproximateLastUseTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=approximate_last_use_time,json=approximateLastUseTime,proto3" json:"approximate_last_use_time,omitempty"`
	// The database role which created this session.
	CreatorRole string `protobuf:"bytes,5,opt,name=creator_role,json=creatorRole,proto3" json:"creator_role,omitempty"`
	// Optional. If true, specifies a multiplexed session. A multiplexed session
	// may be used for multiple, concurrent read-only operations but can not be
	// used for read-write transactions, partitioned reads, or partitioned
	// queries. Multiplexed sessions can be created via
	// [CreateSession][google.spanner.v1.Spanner.CreateSession] but not via
	// [BatchCreateSessions][google.spanner.v1.Spanner.BatchCreateSessions].
	// Multiplexed sessions may not be deleted nor listed.
	Multiplexed bool `protobuf:"varint,6,opt,name=multiplexed,proto3" json:"multiplexed,omitempty"`
}

func (x *Session) Reset() {
	*x = Session{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Session) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Session) ProtoMessage() {}

func (x *Session) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Session.ProtoReflect.Descriptor instead.
func (*Session) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{3}
}

func (x *Session) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Session) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Session) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Session) GetApproximateLastUseTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ApproximateLastUseTime
	}
	return nil
}

func (x *Session) GetCreatorRole() string {
	if x != nil {
		return x.CreatorRole
	}
	return ""
}

func (x *Session) GetMultiplexed() bool {
	if x != nil {
		return x.Multiplexed
	}
	return false
}

// The request for [GetSession][google.spanner.v1.Spanner.GetSession].
type GetSessionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the session to retrieve.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSessionRequest) Reset() {
	*x = GetSessionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSessionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSessionRequest) ProtoMessage() {}

func (x *GetSessionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSessionRequest.ProtoReflect.Descriptor instead.
func (*GetSessionRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{4}
}

func (x *GetSessionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for [ListSessions][google.spanner.v1.Spanner.ListSessions].
type ListSessionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The database in which to list sessions.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// Number of sessions to be returned in the response. If 0 or less, defaults
	// to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If non-empty, `page_token` should contain a
	// [next_page_token][google.spanner.v1.ListSessionsResponse.next_page_token]
	// from a previous
	// [ListSessionsResponse][google.spanner.v1.ListSessionsResponse].
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// An expression for filtering the results of the request. Filter rules are
	// case insensitive. The fields eligible for filtering are:
	//
	//   - `labels.key` where key is the name of a label
	//
	// Some examples of using filters are:
	//
	//   - `labels.env:*` --> The session has the label "env".
	//   - `labels.env:dev` --> The session has the label "env" and the value of
	//     the label contains the string "dev".
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListSessionsRequest) Reset() {
	*x = ListSessionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSessionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSessionsRequest) ProtoMessage() {}

func (x *ListSessionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSessionsRequest.ProtoReflect.Descriptor instead.
func (*ListSessionsRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{5}
}

func (x *ListSessionsRequest) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *ListSessionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSessionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSessionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// The response for [ListSessions][google.spanner.v1.Spanner.ListSessions].
type ListSessionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of requested sessions.
	Sessions []*Session `protobuf:"bytes,1,rep,name=sessions,proto3" json:"sessions,omitempty"`
	// `next_page_token` can be sent in a subsequent
	// [ListSessions][google.spanner.v1.Spanner.ListSessions] call to fetch more
	// of the matching sessions.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSessionsResponse) Reset() {
	*x = ListSessionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSessionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSessionsResponse) ProtoMessage() {}

func (x *ListSessionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSessionsResponse.ProtoReflect.Descriptor instead.
func (*ListSessionsResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{6}
}

func (x *ListSessionsResponse) GetSessions() []*Session {
	if x != nil {
		return x.Sessions
	}
	return nil
}

func (x *ListSessionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for [DeleteSession][google.spanner.v1.Spanner.DeleteSession].
type DeleteSessionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the session to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSessionRequest) Reset() {
	*x = DeleteSessionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSessionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSessionRequest) ProtoMessage() {}

func (x *DeleteSessionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSessionRequest.ProtoReflect.Descriptor instead.
func (*DeleteSessionRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteSessionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Common request options for various APIs.
type RequestOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Priority for the request.
	Priority RequestOptions_Priority `protobuf:"varint,1,opt,name=priority,proto3,enum=google.spanner.v1.RequestOptions_Priority" json:"priority,omitempty"`
	// A per-request tag which can be applied to queries or reads, used for
	// statistics collection.
	// Both request_tag and transaction_tag can be specified for a read or query
	// that belongs to a transaction.
	// This field is ignored for requests where it's not applicable (e.g.
	// CommitRequest).
	// Legal characters for `request_tag` values are all printable characters
	// (ASCII 32 - 126) and the length of a request_tag is limited to 50
	// characters. Values that exceed this limit are truncated.
	// Any leading underscore (_) characters will be removed from the string.
	RequestTag string `protobuf:"bytes,2,opt,name=request_tag,json=requestTag,proto3" json:"request_tag,omitempty"`
	// A tag used for statistics collection about this transaction.
	// Both request_tag and transaction_tag can be specified for a read or query
	// that belongs to a transaction.
	// The value of transaction_tag should be the same for all requests belonging
	// to the same transaction.
	// If this request doesn't belong to any transaction, transaction_tag will be
	// ignored.
	// Legal characters for `transaction_tag` values are all printable characters
	// (ASCII 32 - 126) and the length of a transaction_tag is limited to 50
	// characters. Values that exceed this limit are truncated.
	// Any leading underscore (_) characters will be removed from the string.
	TransactionTag string `protobuf:"bytes,3,opt,name=transaction_tag,json=transactionTag,proto3" json:"transaction_tag,omitempty"`
}

func (x *RequestOptions) Reset() {
	*x = RequestOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RequestOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RequestOptions) ProtoMessage() {}

func (x *RequestOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RequestOptions.ProtoReflect.Descriptor instead.
func (*RequestOptions) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{8}
}

func (x *RequestOptions) GetPriority() RequestOptions_Priority {
	if x != nil {
		return x.Priority
	}
	return RequestOptions_PRIORITY_UNSPECIFIED
}

func (x *RequestOptions) GetRequestTag() string {
	if x != nil {
		return x.RequestTag
	}
	return ""
}

func (x *RequestOptions) GetTransactionTag() string {
	if x != nil {
		return x.TransactionTag
	}
	return ""
}

// The DirectedReadOptions can be used to indicate which replicas or regions
// should be used for non-transactional reads or queries.
//
// DirectedReadOptions may only be specified for a read-only transaction,
// otherwise the API will return an `INVALID_ARGUMENT` error.
type DirectedReadOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. At most one of either include_replicas or exclude_replicas
	// should be present in the message.
	//
	// Types that are assignable to Replicas:
	//
	//	*DirectedReadOptions_IncludeReplicas_
	//	*DirectedReadOptions_ExcludeReplicas_
	Replicas isDirectedReadOptions_Replicas `protobuf_oneof:"replicas"`
}

func (x *DirectedReadOptions) Reset() {
	*x = DirectedReadOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DirectedReadOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DirectedReadOptions) ProtoMessage() {}

func (x *DirectedReadOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DirectedReadOptions.ProtoReflect.Descriptor instead.
func (*DirectedReadOptions) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{9}
}

func (m *DirectedReadOptions) GetReplicas() isDirectedReadOptions_Replicas {
	if m != nil {
		return m.Replicas
	}
	return nil
}

func (x *DirectedReadOptions) GetIncludeReplicas() *DirectedReadOptions_IncludeReplicas {
	if x, ok := x.GetReplicas().(*DirectedReadOptions_IncludeReplicas_); ok {
		return x.IncludeReplicas
	}
	return nil
}

func (x *DirectedReadOptions) GetExcludeReplicas() *DirectedReadOptions_ExcludeReplicas {
	if x, ok := x.GetReplicas().(*DirectedReadOptions_ExcludeReplicas_); ok {
		return x.ExcludeReplicas
	}
	return nil
}

type isDirectedReadOptions_Replicas interface {
	isDirectedReadOptions_Replicas()
}

type DirectedReadOptions_IncludeReplicas_ struct {
	// Include_replicas indicates the order of replicas (as they appear in
	// this list) to process the request. If auto_failover_disabled is set to
	// true and all replicas are exhausted without finding a healthy replica,
	// Spanner will wait for a replica in the list to become available, requests
	// may fail due to `DEADLINE_EXCEEDED` errors.
	IncludeReplicas *DirectedReadOptions_IncludeReplicas `protobuf:"bytes,1,opt,name=include_replicas,json=includeReplicas,proto3,oneof"`
}

type DirectedReadOptions_ExcludeReplicas_ struct {
	// Exclude_replicas indicates that specified replicas should be excluded
	// from serving requests. Spanner will not route requests to the replicas
	// in this list.
	ExcludeReplicas *DirectedReadOptions_ExcludeReplicas `protobuf:"bytes,2,opt,name=exclude_replicas,json=excludeReplicas,proto3,oneof"`
}

func (*DirectedReadOptions_IncludeReplicas_) isDirectedReadOptions_Replicas() {}

func (*DirectedReadOptions_ExcludeReplicas_) isDirectedReadOptions_Replicas() {}

// The request for [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] and
// [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql].
type ExecuteSqlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The session in which the SQL query should be performed.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// The transaction to use.
	//
	// For queries, if none is provided, the default is a temporary read-only
	// transaction with strong concurrency.
	//
	// Standard DML statements require a read-write transaction. To protect
	// against replays, single-use transactions are not supported.  The caller
	// must either supply an existing transaction ID or begin a new transaction.
	//
	// Partitioned DML requires an existing Partitioned DML transaction ID.
	Transaction *TransactionSelector `protobuf:"bytes,2,opt,name=transaction,proto3" json:"transaction,omitempty"`
	// Required. The SQL string.
	Sql string `protobuf:"bytes,3,opt,name=sql,proto3" json:"sql,omitempty"`
	// Parameter names and values that bind to placeholders in the SQL string.
	//
	// A parameter placeholder consists of the `@` character followed by the
	// parameter name (for example, `@firstName`). Parameter names must conform
	// to the naming requirements of identifiers as specified at
	// https://cloud.google.com/spanner/docs/lexical#identifiers.
	//
	// Parameters can appear anywhere that a literal value is expected.  The same
	// parameter name can be used more than once, for example:
	//
	// `"WHERE id > @msg_id AND id < @msg_id + 100"`
	//
	// It is an error to execute a SQL statement with unbound parameters.
	Params *structpb.Struct `protobuf:"bytes,4,opt,name=params,proto3" json:"params,omitempty"`
	// It is not always possible for Cloud Spanner to infer the right SQL type
	// from a JSON value.  For example, values of type `BYTES` and values
	// of type `STRING` both appear in
	// [params][google.spanner.v1.ExecuteSqlRequest.params] as JSON strings.
	//
	// In these cases, `param_types` can be used to specify the exact
	// SQL type for some or all of the SQL statement parameters. See the
	// definition of [Type][google.spanner.v1.Type] for more information
	// about SQL types.
	ParamTypes map[string]*Type `protobuf:"bytes,5,rep,name=param_types,json=paramTypes,proto3" json:"param_types,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// If this request is resuming a previously interrupted SQL statement
	// execution, `resume_token` should be copied from the last
	// [PartialResultSet][google.spanner.v1.PartialResultSet] yielded before the
	// interruption. Doing this enables the new SQL statement execution to resume
	// where the last one left off. The rest of the request parameters must
	// exactly match the request that yielded this token.
	ResumeToken []byte `protobuf:"bytes,6,opt,name=resume_token,json=resumeToken,proto3" json:"resume_token,omitempty"`
	// Used to control the amount of debugging information returned in
	// [ResultSetStats][google.spanner.v1.ResultSetStats]. If
	// [partition_token][google.spanner.v1.ExecuteSqlRequest.partition_token] is
	// set, [query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] can only
	// be set to
	// [QueryMode.NORMAL][google.spanner.v1.ExecuteSqlRequest.QueryMode.NORMAL].
	QueryMode ExecuteSqlRequest_QueryMode `protobuf:"varint,7,opt,name=query_mode,json=queryMode,proto3,enum=google.spanner.v1.ExecuteSqlRequest_QueryMode" json:"query_mode,omitempty"`
	// If present, results will be restricted to the specified partition
	// previously created using PartitionQuery().  There must be an exact
	// match for the values of fields common to this message and the
	// PartitionQueryRequest message used to create this partition_token.
	PartitionToken []byte `protobuf:"bytes,8,opt,name=partition_token,json=partitionToken,proto3" json:"partition_token,omitempty"`
	// A per-transaction sequence number used to identify this request. This field
	// makes each request idempotent such that if the request is received multiple
	// times, at most one will succeed.
	//
	// The sequence number must be monotonically increasing within the
	// transaction. If a request arrives for the first time with an out-of-order
	// sequence number, the transaction may be aborted. Replays of previously
	// handled requests will yield the same response as the first execution.
	//
	// Required for DML statements. Ignored for queries.
	Seqno int64 `protobuf:"varint,9,opt,name=seqno,proto3" json:"seqno,omitempty"`
	// Query optimizer configuration to use for the given query.
	QueryOptions *ExecuteSqlRequest_QueryOptions `protobuf:"bytes,10,opt,name=query_options,json=queryOptions,proto3" json:"query_options,omitempty"`
	// Common options for this request.
	RequestOptions *RequestOptions `protobuf:"bytes,11,opt,name=request_options,json=requestOptions,proto3" json:"request_options,omitempty"`
	// Directed read options for this request.
	DirectedReadOptions *DirectedReadOptions `protobuf:"bytes,15,opt,name=directed_read_options,json=directedReadOptions,proto3" json:"directed_read_options,omitempty"`
	// If this is for a partitioned query and this field is set to `true`, the
	// request is executed with Spanner Data Boost independent compute resources.
	//
	// If the field is set to `true` but the request does not set
	// `partition_token`, the API returns an `INVALID_ARGUMENT` error.
	DataBoostEnabled bool `protobuf:"varint,16,opt,name=data_boost_enabled,json=dataBoostEnabled,proto3" json:"data_boost_enabled,omitempty"`
}

func (x *ExecuteSqlRequest) Reset() {
	*x = ExecuteSqlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteSqlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteSqlRequest) ProtoMessage() {}

func (x *ExecuteSqlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteSqlRequest.ProtoReflect.Descriptor instead.
func (*ExecuteSqlRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{10}
}

func (x *ExecuteSqlRequest) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (x *ExecuteSqlRequest) GetTransaction() *TransactionSelector {
	if x != nil {
		return x.Transaction
	}
	return nil
}

func (x *ExecuteSqlRequest) GetSql() string {
	if x != nil {
		return x.Sql
	}
	return ""
}

func (x *ExecuteSqlRequest) GetParams() *structpb.Struct {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *ExecuteSqlRequest) GetParamTypes() map[string]*Type {
	if x != nil {
		return x.ParamTypes
	}
	return nil
}

func (x *ExecuteSqlRequest) GetResumeToken() []byte {
	if x != nil {
		return x.ResumeToken
	}
	return nil
}

func (x *ExecuteSqlRequest) GetQueryMode() ExecuteSqlRequest_QueryMode {
	if x != nil {
		return x.QueryMode
	}
	return ExecuteSqlRequest_NORMAL
}

func (x *ExecuteSqlRequest) GetPartitionToken() []byte {
	if x != nil {
		return x.PartitionToken
	}
	return nil
}

func (x *ExecuteSqlRequest) GetSeqno() int64 {
	if x != nil {
		return x.Seqno
	}
	return 0
}

func (x *ExecuteSqlRequest) GetQueryOptions() *ExecuteSqlRequest_QueryOptions {
	if x != nil {
		return x.QueryOptions
	}
	return nil
}

func (x *ExecuteSqlRequest) GetRequestOptions() *RequestOptions {
	if x != nil {
		return x.RequestOptions
	}
	return nil
}

func (x *ExecuteSqlRequest) GetDirectedReadOptions() *DirectedReadOptions {
	if x != nil {
		return x.DirectedReadOptions
	}
	return nil
}

func (x *ExecuteSqlRequest) GetDataBoostEnabled() bool {
	if x != nil {
		return x.DataBoostEnabled
	}
	return false
}

// The request for [ExecuteBatchDml][google.spanner.v1.Spanner.ExecuteBatchDml].
type ExecuteBatchDmlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The session in which the DML statements should be performed.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Required. The transaction to use. Must be a read-write transaction.
	//
	// To protect against replays, single-use transactions are not supported. The
	// caller must either supply an existing transaction ID or begin a new
	// transaction.
	Transaction *TransactionSelector `protobuf:"bytes,2,opt,name=transaction,proto3" json:"transaction,omitempty"`
	// Required. The list of statements to execute in this batch. Statements are
	// executed serially, such that the effects of statement `i` are visible to
	// statement `i+1`. Each statement must be a DML statement. Execution stops at
	// the first failed statement; the remaining statements are not executed.
	//
	// Callers must provide at least one statement.
	Statements []*ExecuteBatchDmlRequest_Statement `protobuf:"bytes,3,rep,name=statements,proto3" json:"statements,omitempty"`
	// Required. A per-transaction sequence number used to identify this request.
	// This field makes each request idempotent such that if the request is
	// received multiple times, at most one will succeed.
	//
	// The sequence number must be monotonically increasing within the
	// transaction. If a request arrives for the first time with an out-of-order
	// sequence number, the transaction may be aborted. Replays of previously
	// handled requests will yield the same response as the first execution.
	Seqno int64 `protobuf:"varint,4,opt,name=seqno,proto3" json:"seqno,omitempty"`
	// Common options for this request.
	RequestOptions *RequestOptions `protobuf:"bytes,5,opt,name=request_options,json=requestOptions,proto3" json:"request_options,omitempty"`
}

func (x *ExecuteBatchDmlRequest) Reset() {
	*x = ExecuteBatchDmlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteBatchDmlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteBatchDmlRequest) ProtoMessage() {}

func (x *ExecuteBatchDmlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteBatchDmlRequest.ProtoReflect.Descriptor instead.
func (*ExecuteBatchDmlRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{11}
}

func (x *ExecuteBatchDmlRequest) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (x *ExecuteBatchDmlRequest) GetTransaction() *TransactionSelector {
	if x != nil {
		return x.Transaction
	}
	return nil
}

func (x *ExecuteBatchDmlRequest) GetStatements() []*ExecuteBatchDmlRequest_Statement {
	if x != nil {
		return x.Statements
	}
	return nil
}

func (x *ExecuteBatchDmlRequest) GetSeqno() int64 {
	if x != nil {
		return x.Seqno
	}
	return 0
}

func (x *ExecuteBatchDmlRequest) GetRequestOptions() *RequestOptions {
	if x != nil {
		return x.RequestOptions
	}
	return nil
}

// The response for
// [ExecuteBatchDml][google.spanner.v1.Spanner.ExecuteBatchDml]. Contains a list
// of [ResultSet][google.spanner.v1.ResultSet] messages, one for each DML
// statement that has successfully executed, in the same order as the statements
// in the request. If a statement fails, the status in the response body
// identifies the cause of the failure.
//
// To check for DML statements that failed, use the following approach:
//
// 1. Check the status in the response message. The
// [google.rpc.Code][google.rpc.Code] enum
//
//		value `OK` indicates that all statements were executed successfully.
//	 2. If the status was not `OK`, check the number of result sets in the
//	    response. If the response contains `N`
//	    [ResultSet][google.spanner.v1.ResultSet] messages, then statement `N+1` in
//	    the request failed.
//
// Example 1:
//
// * Request: 5 DML statements, all executed successfully.
// * Response: 5 [ResultSet][google.spanner.v1.ResultSet] messages, with the
// status `OK`.
//
// Example 2:
//
// * Request: 5 DML statements. The third statement has a syntax error.
// * Response: 2 [ResultSet][google.spanner.v1.ResultSet] messages, and a syntax
// error (`INVALID_ARGUMENT`)
//
//	status. The number of [ResultSet][google.spanner.v1.ResultSet] messages
//	indicates that the third statement failed, and the fourth and fifth
//	statements were not executed.
type ExecuteBatchDmlResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// One [ResultSet][google.spanner.v1.ResultSet] for each statement in the
	// request that ran successfully, in the same order as the statements in the
	// request. Each [ResultSet][google.spanner.v1.ResultSet] does not contain any
	// rows. The [ResultSetStats][google.spanner.v1.ResultSetStats] in each
	// [ResultSet][google.spanner.v1.ResultSet] contain the number of rows
	// modified by the statement.
	//
	// Only the first [ResultSet][google.spanner.v1.ResultSet] in the response
	// contains valid [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
	ResultSets []*ResultSet `protobuf:"bytes,1,rep,name=result_sets,json=resultSets,proto3" json:"result_sets,omitempty"`
	// If all DML statements are executed successfully, the status is `OK`.
	// Otherwise, the error status of the first failed statement.
	Status *status.Status `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *ExecuteBatchDmlResponse) Reset() {
	*x = ExecuteBatchDmlResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteBatchDmlResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteBatchDmlResponse) ProtoMessage() {}

func (x *ExecuteBatchDmlResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteBatchDmlResponse.ProtoReflect.Descriptor instead.
func (*ExecuteBatchDmlResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{12}
}

func (x *ExecuteBatchDmlResponse) GetResultSets() []*ResultSet {
	if x != nil {
		return x.ResultSets
	}
	return nil
}

func (x *ExecuteBatchDmlResponse) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

// Options for a PartitionQueryRequest and
// PartitionReadRequest.
type PartitionOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// **Note:** This hint is currently ignored by PartitionQuery and
	// PartitionRead requests.
	//
	// The desired data size for each partition generated.  The default for this
	// option is currently 1 GiB.  This is only a hint. The actual size of each
	// partition may be smaller or larger than this size request.
	PartitionSizeBytes int64 `protobuf:"varint,1,opt,name=partition_size_bytes,json=partitionSizeBytes,proto3" json:"partition_size_bytes,omitempty"`
	// **Note:** This hint is currently ignored by PartitionQuery and
	// PartitionRead requests.
	//
	// The desired maximum number of partitions to return.  For example, this may
	// be set to the number of workers available.  The default for this option
	// is currently 10,000. The maximum value is currently 200,000.  This is only
	// a hint.  The actual number of partitions returned may be smaller or larger
	// than this maximum count request.
	MaxPartitions int64 `protobuf:"varint,2,opt,name=max_partitions,json=maxPartitions,proto3" json:"max_partitions,omitempty"`
}

func (x *PartitionOptions) Reset() {
	*x = PartitionOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionOptions) ProtoMessage() {}

func (x *PartitionOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionOptions.ProtoReflect.Descriptor instead.
func (*PartitionOptions) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{13}
}

func (x *PartitionOptions) GetPartitionSizeBytes() int64 {
	if x != nil {
		return x.PartitionSizeBytes
	}
	return 0
}

func (x *PartitionOptions) GetMaxPartitions() int64 {
	if x != nil {
		return x.MaxPartitions
	}
	return 0
}

// The request for [PartitionQuery][google.spanner.v1.Spanner.PartitionQuery]
type PartitionQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The session used to create the partitions.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Read only snapshot transactions are supported, read/write and single use
	// transactions are not.
	Transaction *TransactionSelector `protobuf:"bytes,2,opt,name=transaction,proto3" json:"transaction,omitempty"`
	// Required. The query request to generate partitions for. The request will
	// fail if the query is not root partitionable. For a query to be root
	// partitionable, it needs to satisfy a few conditions. For example, if the
	// query execution plan contains a distributed union operator, then it must be
	// the first operator in the plan. For more information about other
	// conditions, see [Read data in
	// parallel](https://cloud.google.com/spanner/docs/reads#read_data_in_parallel).
	//
	// The query request must not contain DML commands, such as INSERT, UPDATE, or
	// DELETE. Use
	// [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] with a
	// PartitionedDml transaction for large, partition-friendly DML operations.
	Sql string `protobuf:"bytes,3,opt,name=sql,proto3" json:"sql,omitempty"`
	// Parameter names and values that bind to placeholders in the SQL string.
	//
	// A parameter placeholder consists of the `@` character followed by the
	// parameter name (for example, `@firstName`). Parameter names can contain
	// letters, numbers, and underscores.
	//
	// Parameters can appear anywhere that a literal value is expected.  The same
	// parameter name can be used more than once, for example:
	//
	// `"WHERE id > @msg_id AND id < @msg_id + 100"`
	//
	// It is an error to execute a SQL statement with unbound parameters.
	Params *structpb.Struct `protobuf:"bytes,4,opt,name=params,proto3" json:"params,omitempty"`
	// It is not always possible for Cloud Spanner to infer the right SQL type
	// from a JSON value.  For example, values of type `BYTES` and values
	// of type `STRING` both appear in
	// [params][google.spanner.v1.PartitionQueryRequest.params] as JSON strings.
	//
	// In these cases, `param_types` can be used to specify the exact
	// SQL type for some or all of the SQL query parameters. See the
	// definition of [Type][google.spanner.v1.Type] for more information
	// about SQL types.
	ParamTypes map[string]*Type `protobuf:"bytes,5,rep,name=param_types,json=paramTypes,proto3" json:"param_types,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Additional options that affect how many partitions are created.
	PartitionOptions *PartitionOptions `protobuf:"bytes,6,opt,name=partition_options,json=partitionOptions,proto3" json:"partition_options,omitempty"`
}

func (x *PartitionQueryRequest) Reset() {
	*x = PartitionQueryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionQueryRequest) ProtoMessage() {}

func (x *PartitionQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionQueryRequest.ProtoReflect.Descriptor instead.
func (*PartitionQueryRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{14}
}

func (x *PartitionQueryRequest) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (x *PartitionQueryRequest) GetTransaction() *TransactionSelector {
	if x != nil {
		return x.Transaction
	}
	return nil
}

func (x *PartitionQueryRequest) GetSql() string {
	if x != nil {
		return x.Sql
	}
	return ""
}

func (x *PartitionQueryRequest) GetParams() *structpb.Struct {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *PartitionQueryRequest) GetParamTypes() map[string]*Type {
	if x != nil {
		return x.ParamTypes
	}
	return nil
}

func (x *PartitionQueryRequest) GetPartitionOptions() *PartitionOptions {
	if x != nil {
		return x.PartitionOptions
	}
	return nil
}

// The request for [PartitionRead][google.spanner.v1.Spanner.PartitionRead]
type PartitionReadRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The session used to create the partitions.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Read only snapshot transactions are supported, read/write and single use
	// transactions are not.
	Transaction *TransactionSelector `protobuf:"bytes,2,opt,name=transaction,proto3" json:"transaction,omitempty"`
	// Required. The name of the table in the database to be read.
	Table string `protobuf:"bytes,3,opt,name=table,proto3" json:"table,omitempty"`
	// If non-empty, the name of an index on
	// [table][google.spanner.v1.PartitionReadRequest.table]. This index is used
	// instead of the table primary key when interpreting
	// [key_set][google.spanner.v1.PartitionReadRequest.key_set] and sorting
	// result rows. See [key_set][google.spanner.v1.PartitionReadRequest.key_set]
	// for further information.
	Index string `protobuf:"bytes,4,opt,name=index,proto3" json:"index,omitempty"`
	// The columns of [table][google.spanner.v1.PartitionReadRequest.table] to be
	// returned for each row matching this request.
	Columns []string `protobuf:"bytes,5,rep,name=columns,proto3" json:"columns,omitempty"`
	// Required. `key_set` identifies the rows to be yielded. `key_set` names the
	// primary keys of the rows in
	// [table][google.spanner.v1.PartitionReadRequest.table] to be yielded, unless
	// [index][google.spanner.v1.PartitionReadRequest.index] is present. If
	// [index][google.spanner.v1.PartitionReadRequest.index] is present, then
	// [key_set][google.spanner.v1.PartitionReadRequest.key_set] instead names
	// index keys in [index][google.spanner.v1.PartitionReadRequest.index].
	//
	// It is not an error for the `key_set` to name rows that do not
	// exist in the database. Read yields nothing for nonexistent rows.
	KeySet *KeySet `protobuf:"bytes,6,opt,name=key_set,json=keySet,proto3" json:"key_set,omitempty"`
	// Additional options that affect how many partitions are created.
	PartitionOptions *PartitionOptions `protobuf:"bytes,9,opt,name=partition_options,json=partitionOptions,proto3" json:"partition_options,omitempty"`
}

func (x *PartitionReadRequest) Reset() {
	*x = PartitionReadRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionReadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionReadRequest) ProtoMessage() {}

func (x *PartitionReadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionReadRequest.ProtoReflect.Descriptor instead.
func (*PartitionReadRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{15}
}

func (x *PartitionReadRequest) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (x *PartitionReadRequest) GetTransaction() *TransactionSelector {
	if x != nil {
		return x.Transaction
	}
	return nil
}

func (x *PartitionReadRequest) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *PartitionReadRequest) GetIndex() string {
	if x != nil {
		return x.Index
	}
	return ""
}

func (x *PartitionReadRequest) GetColumns() []string {
	if x != nil {
		return x.Columns
	}
	return nil
}

func (x *PartitionReadRequest) GetKeySet() *KeySet {
	if x != nil {
		return x.KeySet
	}
	return nil
}

func (x *PartitionReadRequest) GetPartitionOptions() *PartitionOptions {
	if x != nil {
		return x.PartitionOptions
	}
	return nil
}

// Information returned for each partition returned in a
// PartitionResponse.
type Partition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This token can be passed to Read, StreamingRead, ExecuteSql, or
	// ExecuteStreamingSql requests to restrict the results to those identified by
	// this partition token.
	PartitionToken []byte `protobuf:"bytes,1,opt,name=partition_token,json=partitionToken,proto3" json:"partition_token,omitempty"`
}

func (x *Partition) Reset() {
	*x = Partition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Partition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Partition) ProtoMessage() {}

func (x *Partition) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Partition.ProtoReflect.Descriptor instead.
func (*Partition) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{16}
}

func (x *Partition) GetPartitionToken() []byte {
	if x != nil {
		return x.PartitionToken
	}
	return nil
}

// The response for [PartitionQuery][google.spanner.v1.Spanner.PartitionQuery]
// or [PartitionRead][google.spanner.v1.Spanner.PartitionRead]
type PartitionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Partitions created by this request.
	Partitions []*Partition `protobuf:"bytes,1,rep,name=partitions,proto3" json:"partitions,omitempty"`
	// Transaction created by this request.
	Transaction *Transaction `protobuf:"bytes,2,opt,name=transaction,proto3" json:"transaction,omitempty"`
}

func (x *PartitionResponse) Reset() {
	*x = PartitionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionResponse) ProtoMessage() {}

func (x *PartitionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionResponse.ProtoReflect.Descriptor instead.
func (*PartitionResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{17}
}

func (x *PartitionResponse) GetPartitions() []*Partition {
	if x != nil {
		return x.Partitions
	}
	return nil
}

func (x *PartitionResponse) GetTransaction() *Transaction {
	if x != nil {
		return x.Transaction
	}
	return nil
}

// The request for [Read][google.spanner.v1.Spanner.Read] and
// [StreamingRead][google.spanner.v1.Spanner.StreamingRead].
type ReadRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The session in which the read should be performed.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// The transaction to use. If none is provided, the default is a
	// temporary read-only transaction with strong concurrency.
	Transaction *TransactionSelector `protobuf:"bytes,2,opt,name=transaction,proto3" json:"transaction,omitempty"`
	// Required. The name of the table in the database to be read.
	Table string `protobuf:"bytes,3,opt,name=table,proto3" json:"table,omitempty"`
	// If non-empty, the name of an index on
	// [table][google.spanner.v1.ReadRequest.table]. This index is used instead of
	// the table primary key when interpreting
	// [key_set][google.spanner.v1.ReadRequest.key_set] and sorting result rows.
	// See [key_set][google.spanner.v1.ReadRequest.key_set] for further
	// information.
	Index string `protobuf:"bytes,4,opt,name=index,proto3" json:"index,omitempty"`
	// Required. The columns of [table][google.spanner.v1.ReadRequest.table] to be
	// returned for each row matching this request.
	Columns []string `protobuf:"bytes,5,rep,name=columns,proto3" json:"columns,omitempty"`
	// Required. `key_set` identifies the rows to be yielded. `key_set` names the
	// primary keys of the rows in [table][google.spanner.v1.ReadRequest.table] to
	// be yielded, unless [index][google.spanner.v1.ReadRequest.index] is present.
	// If [index][google.spanner.v1.ReadRequest.index] is present, then
	// [key_set][google.spanner.v1.ReadRequest.key_set] instead names index keys
	// in [index][google.spanner.v1.ReadRequest.index].
	//
	// If the [partition_token][google.spanner.v1.ReadRequest.partition_token]
	// field is empty, rows are yielded in table primary key order (if
	// [index][google.spanner.v1.ReadRequest.index] is empty) or index key order
	// (if [index][google.spanner.v1.ReadRequest.index] is non-empty).  If the
	// [partition_token][google.spanner.v1.ReadRequest.partition_token] field is
	// not empty, rows will be yielded in an unspecified order.
	//
	// It is not an error for the `key_set` to name rows that do not
	// exist in the database. Read yields nothing for nonexistent rows.
	KeySet *KeySet `protobuf:"bytes,6,opt,name=key_set,json=keySet,proto3" json:"key_set,omitempty"`
	// If greater than zero, only the first `limit` rows are yielded. If `limit`
	// is zero, the default is no limit. A limit cannot be specified if
	// `partition_token` is set.
	Limit int64 `protobuf:"varint,8,opt,name=limit,proto3" json:"limit,omitempty"`
	// If this request is resuming a previously interrupted read,
	// `resume_token` should be copied from the last
	// [PartialResultSet][google.spanner.v1.PartialResultSet] yielded before the
	// interruption. Doing this enables the new read to resume where the last read
	// left off. The rest of the request parameters must exactly match the request
	// that yielded this token.
	ResumeToken []byte `protobuf:"bytes,9,opt,name=resume_token,json=resumeToken,proto3" json:"resume_token,omitempty"`
	// If present, results will be restricted to the specified partition
	// previously created using PartitionRead().    There must be an exact
	// match for the values of fields common to this message and the
	// PartitionReadRequest message used to create this partition_token.
	PartitionToken []byte `protobuf:"bytes,10,opt,name=partition_token,json=partitionToken,proto3" json:"partition_token,omitempty"`
	// Common options for this request.
	RequestOptions *RequestOptions `protobuf:"bytes,11,opt,name=request_options,json=requestOptions,proto3" json:"request_options,omitempty"`
	// Directed read options for this request.
	DirectedReadOptions *DirectedReadOptions `protobuf:"bytes,14,opt,name=directed_read_options,json=directedReadOptions,proto3" json:"directed_read_options,omitempty"`
	// If this is for a partitioned read and this field is set to `true`, the
	// request is executed with Spanner Data Boost independent compute resources.
	//
	// If the field is set to `true` but the request does not set
	// `partition_token`, the API returns an `INVALID_ARGUMENT` error.
	DataBoostEnabled bool `protobuf:"varint,15,opt,name=data_boost_enabled,json=dataBoostEnabled,proto3" json:"data_boost_enabled,omitempty"`
	// Optional. Order for the returned rows.
	//
	// By default, Spanner will return result rows in primary key order except for
	// PartitionRead requests. For applications that do not require rows to be
	// returned in primary key (`ORDER_BY_PRIMARY_KEY`) order, setting
	// `ORDER_BY_NO_ORDER` option allows Spanner to optimize row retrieval,
	// resulting in lower latencies in certain cases (e.g. bulk point lookups).
	OrderBy ReadRequest_OrderBy `protobuf:"varint,16,opt,name=order_by,json=orderBy,proto3,enum=google.spanner.v1.ReadRequest_OrderBy" json:"order_by,omitempty"`
	// Optional. Lock Hint for the request, it can only be used with read-write
	// transactions.
	LockHint ReadRequest_LockHint `protobuf:"varint,17,opt,name=lock_hint,json=lockHint,proto3,enum=google.spanner.v1.ReadRequest_LockHint" json:"lock_hint,omitempty"`
}

func (x *ReadRequest) Reset() {
	*x = ReadRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadRequest) ProtoMessage() {}

func (x *ReadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadRequest.ProtoReflect.Descriptor instead.
func (*ReadRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{18}
}

func (x *ReadRequest) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (x *ReadRequest) GetTransaction() *TransactionSelector {
	if x != nil {
		return x.Transaction
	}
	return nil
}

func (x *ReadRequest) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *ReadRequest) GetIndex() string {
	if x != nil {
		return x.Index
	}
	return ""
}

func (x *ReadRequest) GetColumns() []string {
	if x != nil {
		return x.Columns
	}
	return nil
}

func (x *ReadRequest) GetKeySet() *KeySet {
	if x != nil {
		return x.KeySet
	}
	return nil
}

func (x *ReadRequest) GetLimit() int64 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *ReadRequest) GetResumeToken() []byte {
	if x != nil {
		return x.ResumeToken
	}
	return nil
}

func (x *ReadRequest) GetPartitionToken() []byte {
	if x != nil {
		return x.PartitionToken
	}
	return nil
}

func (x *ReadRequest) GetRequestOptions() *RequestOptions {
	if x != nil {
		return x.RequestOptions
	}
	return nil
}

func (x *ReadRequest) GetDirectedReadOptions() *DirectedReadOptions {
	if x != nil {
		return x.DirectedReadOptions
	}
	return nil
}

func (x *ReadRequest) GetDataBoostEnabled() bool {
	if x != nil {
		return x.DataBoostEnabled
	}
	return false
}

func (x *ReadRequest) GetOrderBy() ReadRequest_OrderBy {
	if x != nil {
		return x.OrderBy
	}
	return ReadRequest_ORDER_BY_UNSPECIFIED
}

func (x *ReadRequest) GetLockHint() ReadRequest_LockHint {
	if x != nil {
		return x.LockHint
	}
	return ReadRequest_LOCK_HINT_UNSPECIFIED
}

// The request for
// [BeginTransaction][google.spanner.v1.Spanner.BeginTransaction].
type BeginTransactionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The session in which the transaction runs.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Required. Options for the new transaction.
	Options *TransactionOptions `protobuf:"bytes,2,opt,name=options,proto3" json:"options,omitempty"`
	// Common options for this request.
	// Priority is ignored for this request. Setting the priority in this
	// request_options struct will not do anything. To set the priority for a
	// transaction, set it on the reads and writes that are part of this
	// transaction instead.
	RequestOptions *RequestOptions `protobuf:"bytes,3,opt,name=request_options,json=requestOptions,proto3" json:"request_options,omitempty"`
}

func (x *BeginTransactionRequest) Reset() {
	*x = BeginTransactionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BeginTransactionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BeginTransactionRequest) ProtoMessage() {}

func (x *BeginTransactionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BeginTransactionRequest.ProtoReflect.Descriptor instead.
func (*BeginTransactionRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{19}
}

func (x *BeginTransactionRequest) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (x *BeginTransactionRequest) GetOptions() *TransactionOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *BeginTransactionRequest) GetRequestOptions() *RequestOptions {
	if x != nil {
		return x.RequestOptions
	}
	return nil
}

// The request for [Commit][google.spanner.v1.Spanner.Commit].
type CommitRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The session in which the transaction to be committed is running.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Required. The transaction in which to commit.
	//
	// Types that are assignable to Transaction:
	//
	//	*CommitRequest_TransactionId
	//	*CommitRequest_SingleUseTransaction
	Transaction isCommitRequest_Transaction `protobuf_oneof:"transaction"`
	// The mutations to be executed when this transaction commits. All
	// mutations are applied atomically, in the order they appear in
	// this list.
	Mutations []*Mutation `protobuf:"bytes,4,rep,name=mutations,proto3" json:"mutations,omitempty"`
	// If `true`, then statistics related to the transaction will be included in
	// the [CommitResponse][google.spanner.v1.CommitResponse.commit_stats].
	// Default value is `false`.
	ReturnCommitStats bool `protobuf:"varint,5,opt,name=return_commit_stats,json=returnCommitStats,proto3" json:"return_commit_stats,omitempty"`
	// Optional. The amount of latency this request is willing to incur in order
	// to improve throughput. If this field is not set, Spanner assumes requests
	// are relatively latency sensitive and automatically determines an
	// appropriate delay time. You can specify a batching delay value between 0
	// and 500 ms.
	MaxCommitDelay *durationpb.Duration `protobuf:"bytes,8,opt,name=max_commit_delay,json=maxCommitDelay,proto3" json:"max_commit_delay,omitempty"`
	// Common options for this request.
	RequestOptions *RequestOptions `protobuf:"bytes,6,opt,name=request_options,json=requestOptions,proto3" json:"request_options,omitempty"`
}

func (x *CommitRequest) Reset() {
	*x = CommitRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitRequest) ProtoMessage() {}

func (x *CommitRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitRequest.ProtoReflect.Descriptor instead.
func (*CommitRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{20}
}

func (x *CommitRequest) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (m *CommitRequest) GetTransaction() isCommitRequest_Transaction {
	if m != nil {
		return m.Transaction
	}
	return nil
}

func (x *CommitRequest) GetTransactionId() []byte {
	if x, ok := x.GetTransaction().(*CommitRequest_TransactionId); ok {
		return x.TransactionId
	}
	return nil
}

func (x *CommitRequest) GetSingleUseTransaction() *TransactionOptions {
	if x, ok := x.GetTransaction().(*CommitRequest_SingleUseTransaction); ok {
		return x.SingleUseTransaction
	}
	return nil
}

func (x *CommitRequest) GetMutations() []*Mutation {
	if x != nil {
		return x.Mutations
	}
	return nil
}

func (x *CommitRequest) GetReturnCommitStats() bool {
	if x != nil {
		return x.ReturnCommitStats
	}
	return false
}

func (x *CommitRequest) GetMaxCommitDelay() *durationpb.Duration {
	if x != nil {
		return x.MaxCommitDelay
	}
	return nil
}

func (x *CommitRequest) GetRequestOptions() *RequestOptions {
	if x != nil {
		return x.RequestOptions
	}
	return nil
}

type isCommitRequest_Transaction interface {
	isCommitRequest_Transaction()
}

type CommitRequest_TransactionId struct {
	// Commit a previously-started transaction.
	TransactionId []byte `protobuf:"bytes,2,opt,name=transaction_id,json=transactionId,proto3,oneof"`
}

type CommitRequest_SingleUseTransaction struct {
	// Execute mutations in a temporary transaction. Note that unlike
	// commit of a previously-started transaction, commit with a
	// temporary transaction is non-idempotent. That is, if the
	// `CommitRequest` is sent to Cloud Spanner more than once (for
	// instance, due to retries in the application, or in the
	// transport library), it is possible that the mutations are
	// executed more than once. If this is undesirable, use
	// [BeginTransaction][google.spanner.v1.Spanner.BeginTransaction] and
	// [Commit][google.spanner.v1.Spanner.Commit] instead.
	SingleUseTransaction *TransactionOptions `protobuf:"bytes,3,opt,name=single_use_transaction,json=singleUseTransaction,proto3,oneof"`
}

func (*CommitRequest_TransactionId) isCommitRequest_Transaction() {}

func (*CommitRequest_SingleUseTransaction) isCommitRequest_Transaction() {}

// The request for [Rollback][google.spanner.v1.Spanner.Rollback].
type RollbackRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The session in which the transaction to roll back is running.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Required. The transaction to roll back.
	TransactionId []byte `protobuf:"bytes,2,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
}

func (x *RollbackRequest) Reset() {
	*x = RollbackRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RollbackRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RollbackRequest) ProtoMessage() {}

func (x *RollbackRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RollbackRequest.ProtoReflect.Descriptor instead.
func (*RollbackRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{21}
}

func (x *RollbackRequest) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (x *RollbackRequest) GetTransactionId() []byte {
	if x != nil {
		return x.TransactionId
	}
	return nil
}

// The request for [BatchWrite][google.spanner.v1.Spanner.BatchWrite].
type BatchWriteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The session in which the batch request is to be run.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Common options for this request.
	RequestOptions *RequestOptions `protobuf:"bytes,3,opt,name=request_options,json=requestOptions,proto3" json:"request_options,omitempty"`
	// Required. The groups of mutations to be applied.
	MutationGroups []*BatchWriteRequest_MutationGroup `protobuf:"bytes,4,rep,name=mutation_groups,json=mutationGroups,proto3" json:"mutation_groups,omitempty"`
	// Optional. When `exclude_txn_from_change_streams` is set to `true`:
	//   - Mutations from all transactions in this batch write operation will not
	//     be recorded in change streams with DDL option `allow_txn_exclusion=true`
	//     that are tracking columns modified by these transactions.
	//   - Mutations from all transactions in this batch write operation will be
	//     recorded in change streams with DDL option `allow_txn_exclusion=false or
	//     not set` that are tracking columns modified by these transactions.
	//
	// When `exclude_txn_from_change_streams` is set to `false` or not set,
	// mutations from all transactions in this batch write operation will be
	// recorded in all change streams that are tracking columns modified by these
	// transactions.
	ExcludeTxnFromChangeStreams bool `protobuf:"varint,5,opt,name=exclude_txn_from_change_streams,json=excludeTxnFromChangeStreams,proto3" json:"exclude_txn_from_change_streams,omitempty"`
}

func (x *BatchWriteRequest) Reset() {
	*x = BatchWriteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchWriteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchWriteRequest) ProtoMessage() {}

func (x *BatchWriteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchWriteRequest.ProtoReflect.Descriptor instead.
func (*BatchWriteRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{22}
}

func (x *BatchWriteRequest) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (x *BatchWriteRequest) GetRequestOptions() *RequestOptions {
	if x != nil {
		return x.RequestOptions
	}
	return nil
}

func (x *BatchWriteRequest) GetMutationGroups() []*BatchWriteRequest_MutationGroup {
	if x != nil {
		return x.MutationGroups
	}
	return nil
}

func (x *BatchWriteRequest) GetExcludeTxnFromChangeStreams() bool {
	if x != nil {
		return x.ExcludeTxnFromChangeStreams
	}
	return false
}

// The result of applying a batch of mutations.
type BatchWriteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The mutation groups applied in this batch. The values index into the
	// `mutation_groups` field in the corresponding `BatchWriteRequest`.
	Indexes []int32 `protobuf:"varint,1,rep,packed,name=indexes,proto3" json:"indexes,omitempty"`
	// An `OK` status indicates success. Any other status indicates a failure.
	Status *status.Status `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	// The commit timestamp of the transaction that applied this batch.
	// Present if `status` is `OK`, absent otherwise.
	CommitTimestamp *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=commit_timestamp,json=commitTimestamp,proto3" json:"commit_timestamp,omitempty"`
}

func (x *BatchWriteResponse) Reset() {
	*x = BatchWriteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchWriteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchWriteResponse) ProtoMessage() {}

func (x *BatchWriteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchWriteResponse.ProtoReflect.Descriptor instead.
func (*BatchWriteResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{23}
}

func (x *BatchWriteResponse) GetIndexes() []int32 {
	if x != nil {
		return x.Indexes
	}
	return nil
}

func (x *BatchWriteResponse) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *BatchWriteResponse) GetCommitTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.CommitTimestamp
	}
	return nil
}

// The directed read replica selector.
// Callers must provide one or more of the following fields for replica
// selection:
//
//   - `location` - The location must be one of the regions within the
//     multi-region configuration of your database.
//   - `type` - The type of the replica.
//
// Some examples of using replica_selectors are:
//
//   - `location:us-east1` --> The "us-east1" replica(s) of any available type
//     will be used to process the request.
//   - `type:READ_ONLY`    --> The "READ_ONLY" type replica(s) in nearest
//     available location will be used to process the
//     request.
//   - `location:us-east1 type:READ_ONLY` --> The "READ_ONLY" type replica(s)
//     in location "us-east1" will be used to process
//     the request.
type DirectedReadOptions_ReplicaSelection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The location or region of the serving requests, e.g. "us-east1".
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// The type of replica.
	Type DirectedReadOptions_ReplicaSelection_Type `protobuf:"varint,2,opt,name=type,proto3,enum=google.spanner.v1.DirectedReadOptions_ReplicaSelection_Type" json:"type,omitempty"`
}

func (x *DirectedReadOptions_ReplicaSelection) Reset() {
	*x = DirectedReadOptions_ReplicaSelection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DirectedReadOptions_ReplicaSelection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DirectedReadOptions_ReplicaSelection) ProtoMessage() {}

func (x *DirectedReadOptions_ReplicaSelection) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DirectedReadOptions_ReplicaSelection.ProtoReflect.Descriptor instead.
func (*DirectedReadOptions_ReplicaSelection) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{9, 0}
}

func (x *DirectedReadOptions_ReplicaSelection) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *DirectedReadOptions_ReplicaSelection) GetType() DirectedReadOptions_ReplicaSelection_Type {
	if x != nil {
		return x.Type
	}
	return DirectedReadOptions_ReplicaSelection_TYPE_UNSPECIFIED
}

// An IncludeReplicas contains a repeated set of ReplicaSelection which
// indicates the order in which replicas should be considered.
type DirectedReadOptions_IncludeReplicas struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The directed read replica selector.
	ReplicaSelections []*DirectedReadOptions_ReplicaSelection `protobuf:"bytes,1,rep,name=replica_selections,json=replicaSelections,proto3" json:"replica_selections,omitempty"`
	// If true, Spanner will not route requests to a replica outside the
	// include_replicas list when all of the specified replicas are unavailable
	// or unhealthy. Default value is `false`.
	AutoFailoverDisabled bool `protobuf:"varint,2,opt,name=auto_failover_disabled,json=autoFailoverDisabled,proto3" json:"auto_failover_disabled,omitempty"`
}

func (x *DirectedReadOptions_IncludeReplicas) Reset() {
	*x = DirectedReadOptions_IncludeReplicas{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DirectedReadOptions_IncludeReplicas) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DirectedReadOptions_IncludeReplicas) ProtoMessage() {}

func (x *DirectedReadOptions_IncludeReplicas) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DirectedReadOptions_IncludeReplicas.ProtoReflect.Descriptor instead.
func (*DirectedReadOptions_IncludeReplicas) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{9, 1}
}

func (x *DirectedReadOptions_IncludeReplicas) GetReplicaSelections() []*DirectedReadOptions_ReplicaSelection {
	if x != nil {
		return x.ReplicaSelections
	}
	return nil
}

func (x *DirectedReadOptions_IncludeReplicas) GetAutoFailoverDisabled() bool {
	if x != nil {
		return x.AutoFailoverDisabled
	}
	return false
}

// An ExcludeReplicas contains a repeated set of ReplicaSelection that should
// be excluded from serving requests.
type DirectedReadOptions_ExcludeReplicas struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The directed read replica selector.
	ReplicaSelections []*DirectedReadOptions_ReplicaSelection `protobuf:"bytes,1,rep,name=replica_selections,json=replicaSelections,proto3" json:"replica_selections,omitempty"`
}

func (x *DirectedReadOptions_ExcludeReplicas) Reset() {
	*x = DirectedReadOptions_ExcludeReplicas{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DirectedReadOptions_ExcludeReplicas) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DirectedReadOptions_ExcludeReplicas) ProtoMessage() {}

func (x *DirectedReadOptions_ExcludeReplicas) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DirectedReadOptions_ExcludeReplicas.ProtoReflect.Descriptor instead.
func (*DirectedReadOptions_ExcludeReplicas) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{9, 2}
}

func (x *DirectedReadOptions_ExcludeReplicas) GetReplicaSelections() []*DirectedReadOptions_ReplicaSelection {
	if x != nil {
		return x.ReplicaSelections
	}
	return nil
}

// Query optimizer configuration.
type ExecuteSqlRequest_QueryOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An option to control the selection of optimizer version.
	//
	// This parameter allows individual queries to pick different query
	// optimizer versions.
	//
	// Specifying `latest` as a value instructs Cloud Spanner to use the
	// latest supported query optimizer version. If not specified, Cloud Spanner
	// uses the optimizer version set at the database level options. Any other
	// positive integer (from the list of supported optimizer versions)
	// overrides the default optimizer version for query execution.
	//
	// The list of supported optimizer versions can be queried from
	// SPANNER_SYS.SUPPORTED_OPTIMIZER_VERSIONS.
	//
	// Executing a SQL statement with an invalid optimizer version fails with
	// an `INVALID_ARGUMENT` error.
	//
	// See
	// https://cloud.google.com/spanner/docs/query-optimizer/manage-query-optimizer
	// for more information on managing the query optimizer.
	//
	// The `optimizer_version` statement hint has precedence over this setting.
	OptimizerVersion string `protobuf:"bytes,1,opt,name=optimizer_version,json=optimizerVersion,proto3" json:"optimizer_version,omitempty"`
	// An option to control the selection of optimizer statistics package.
	//
	// This parameter allows individual queries to use a different query
	// optimizer statistics package.
	//
	// Specifying `latest` as a value instructs Cloud Spanner to use the latest
	// generated statistics package. If not specified, Cloud Spanner uses
	// the statistics package set at the database level options, or the latest
	// package if the database option is not set.
	//
	// The statistics package requested by the query has to be exempt from
	// garbage collection. This can be achieved with the following DDL
	// statement:
	//
	// ```
	// ALTER STATISTICS <package_name> SET OPTIONS (allow_gc=false)
	// ```
	//
	// The list of available statistics packages can be queried from
	// `INFORMATION_SCHEMA.SPANNER_STATISTICS`.
	//
	// Executing a SQL statement with an invalid optimizer statistics package
	// or with a statistics package that allows garbage collection fails with
	// an `INVALID_ARGUMENT` error.
	OptimizerStatisticsPackage string `protobuf:"bytes,2,opt,name=optimizer_statistics_package,json=optimizerStatisticsPackage,proto3" json:"optimizer_statistics_package,omitempty"`
}

func (x *ExecuteSqlRequest_QueryOptions) Reset() {
	*x = ExecuteSqlRequest_QueryOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteSqlRequest_QueryOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteSqlRequest_QueryOptions) ProtoMessage() {}

func (x *ExecuteSqlRequest_QueryOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteSqlRequest_QueryOptions.ProtoReflect.Descriptor instead.
func (*ExecuteSqlRequest_QueryOptions) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{10, 0}
}

func (x *ExecuteSqlRequest_QueryOptions) GetOptimizerVersion() string {
	if x != nil {
		return x.OptimizerVersion
	}
	return ""
}

func (x *ExecuteSqlRequest_QueryOptions) GetOptimizerStatisticsPackage() string {
	if x != nil {
		return x.OptimizerStatisticsPackage
	}
	return ""
}

// A single DML statement.
type ExecuteBatchDmlRequest_Statement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The DML string.
	Sql string `protobuf:"bytes,1,opt,name=sql,proto3" json:"sql,omitempty"`
	// Parameter names and values that bind to placeholders in the DML string.
	//
	// A parameter placeholder consists of the `@` character followed by the
	// parameter name (for example, `@firstName`). Parameter names can contain
	// letters, numbers, and underscores.
	//
	// Parameters can appear anywhere that a literal value is expected.  The
	// same parameter name can be used more than once, for example:
	//
	// `"WHERE id > @msg_id AND id < @msg_id + 100"`
	//
	// It is an error to execute a SQL statement with unbound parameters.
	Params *structpb.Struct `protobuf:"bytes,2,opt,name=params,proto3" json:"params,omitempty"`
	// It is not always possible for Cloud Spanner to infer the right SQL type
	// from a JSON value.  For example, values of type `BYTES` and values
	// of type `STRING` both appear in
	// [params][google.spanner.v1.ExecuteBatchDmlRequest.Statement.params] as
	// JSON strings.
	//
	// In these cases, `param_types` can be used to specify the exact
	// SQL type for some or all of the SQL statement parameters. See the
	// definition of [Type][google.spanner.v1.Type] for more information
	// about SQL types.
	ParamTypes map[string]*Type `protobuf:"bytes,3,rep,name=param_types,json=paramTypes,proto3" json:"param_types,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ExecuteBatchDmlRequest_Statement) Reset() {
	*x = ExecuteBatchDmlRequest_Statement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteBatchDmlRequest_Statement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteBatchDmlRequest_Statement) ProtoMessage() {}

func (x *ExecuteBatchDmlRequest_Statement) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteBatchDmlRequest_Statement.ProtoReflect.Descriptor instead.
func (*ExecuteBatchDmlRequest_Statement) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{11, 0}
}

func (x *ExecuteBatchDmlRequest_Statement) GetSql() string {
	if x != nil {
		return x.Sql
	}
	return ""
}

func (x *ExecuteBatchDmlRequest_Statement) GetParams() *structpb.Struct {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *ExecuteBatchDmlRequest_Statement) GetParamTypes() map[string]*Type {
	if x != nil {
		return x.ParamTypes
	}
	return nil
}

// A group of mutations to be committed together. Related mutations should be
// placed in a group. For example, two mutations inserting rows with the same
// primary key prefix in both parent and child tables are related.
type BatchWriteRequest_MutationGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The mutations in this group.
	Mutations []*Mutation `protobuf:"bytes,1,rep,name=mutations,proto3" json:"mutations,omitempty"`
}

func (x *BatchWriteRequest_MutationGroup) Reset() {
	*x = BatchWriteRequest_MutationGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchWriteRequest_MutationGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchWriteRequest_MutationGroup) ProtoMessage() {}

func (x *BatchWriteRequest_MutationGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchWriteRequest_MutationGroup.ProtoReflect.Descriptor instead.
func (*BatchWriteRequest_MutationGroup) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{22, 0}
}

func (x *BatchWriteRequest_MutationGroup) GetMutations() []*Mutation {
	if x != nil {
		return x.Mutations
	}
	return nil
}

var File_google_spanner_v1_spanner_proto protoreflect.FileDescriptor

var file_google_spanner_v1_spanner_proto_rawDesc = []byte{
	0x0a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2f, 0x76, 0x31, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x11, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x1a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x72,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f,
	0x73, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x76,
	0x31, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x96, 0x01, 0x0a,
	0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a,
	0x1f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x39, 0x0a, 0x07, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xd2, 0x01, 0x0a, 0x1a, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52,
	0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x10, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x0f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x12, 0x28, 0x0a, 0x0d, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x53, 0x0a, 0x1b, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x34, 0x0a, 0x07, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0xfb, 0x03, 0x0a, 0x07, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5a, 0x0a, 0x19, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x78,
	0x69, 0x6d, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x61, 0x70, 0x70, 0x72,
	0x6f, 0x78, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x73, 0x74, 0x55, 0x73, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x72, 0x6f,
	0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x6f,
	0x72, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c,
	0x65, 0x78, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x65, 0x78, 0x65, 0x64, 0x1a, 0x39, 0x0a, 0x0b,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x74, 0xea, 0x41, 0x71, 0x0a, 0x1e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x4f, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f,
	0x7b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x7d, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x22, 0x4f, 0x0a,
	0x11, 0x47, 0x65, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xae,
	0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21,
	0x0a, 0x1f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22,
	0x76, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x36, 0x0a, 0x08, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x52, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x82, 0x02, 0x0a, 0x0e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x46,
	0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x52, 0x08, 0x70, 0x72,
	0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x54, 0x61, 0x67, 0x12, 0x27, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x67,
	0x22, 0x5e, 0x0a, 0x08, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x18, 0x0a, 0x14,
	0x50, 0x52, 0x49, 0x4f, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x52, 0x49, 0x4f, 0x52, 0x49,
	0x54, 0x59, 0x5f, 0x4c, 0x4f, 0x57, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x50, 0x52, 0x49, 0x4f,
	0x52, 0x49, 0x54, 0x59, 0x5f, 0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d, 0x10, 0x02, 0x12, 0x11, 0x0a,
	0x0d, 0x50, 0x52, 0x49, 0x4f, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x48, 0x49, 0x47, 0x48, 0x10, 0x03,
	0x22, 0xd8, 0x05, 0x0a, 0x13, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x65, 0x64, 0x52, 0x65, 0x61,
	0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x63, 0x0a, 0x10, 0x69, 0x6e, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x65, 0x64, 0x52,
	0x65, 0x61, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x49, 0x6e, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x48, 0x00, 0x52, 0x0f, 0x69, 0x6e,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x12, 0x63, 0x0a,
	0x10, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x65, 0x64, 0x52, 0x65, 0x61, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x45, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x48,
	0x00, 0x52, 0x0f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x73, 0x1a, 0xbd, 0x01, 0x0a, 0x10, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x53, 0x65,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x65, 0x64, 0x52, 0x65,
	0x61, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x3b, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a,
	0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x57, 0x52, 0x49, 0x54,
	0x45, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x4f, 0x4e, 0x4c, 0x59,
	0x10, 0x02, 0x1a, 0xaf, 0x01, 0x0a, 0x0f, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x52, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x12, 0x66, 0x0a, 0x12, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x65, 0x64, 0x52,
	0x65, 0x61, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x72, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x34,
	0x0a, 0x16, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x5f,
	0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14,
	0x61, 0x75, 0x74, 0x6f, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x44, 0x69, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x1a, 0x79, 0x0a, 0x0f, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x52,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x12, 0x66, 0x0a, 0x12, 0x72, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x52, 0x65, 0x61, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x52, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x72, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42,
	0x0a, 0x0a, 0x08, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x22, 0xa4, 0x08, 0x0a, 0x11,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x53, 0x71, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x40, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x15, 0x0a,
	0x03, 0x73, 0x71, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x03, 0x73, 0x71, 0x6c, 0x12, 0x2f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x55, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x53, 0x71, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x21, 0x0a, 0x0c,
	0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x4d, 0x0a, 0x0a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x53,
	0x71, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4d,
	0x6f, 0x64, 0x65, 0x52, 0x09, 0x71, 0x75, 0x65, 0x72, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x27,
	0x0a, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x65, 0x71, 0x6e, 0x6f,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x73, 0x65, 0x71, 0x6e, 0x6f, 0x12, 0x56, 0x0a,
	0x0d, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65,
	0x53, 0x71, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4a, 0x0a, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x0e, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x5a, 0x0a, 0x15, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x65,
	0x61, 0x64, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x65, 0x64, 0x52, 0x65, 0x61,
	0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x13, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x52, 0x65, 0x61, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2c, 0x0a,
	0x12, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x5f, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x10, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x64, 0x61, 0x74, 0x61, 0x42,
	0x6f, 0x6f, 0x73, 0x74, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x1a, 0x7d, 0x0a, 0x0c, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x6f,
	0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x65,
	0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x1c, 0x6f, 0x70, 0x74, 0x69,
	0x6d, 0x69, 0x7a, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73,
	0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1a,
	0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74,
	0x69, 0x63, 0x73, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x1a, 0x56, 0x0a, 0x0f, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x2d, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x2e, 0x0a, 0x09, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x12,
	0x0a, 0x0a, 0x06, 0x4e, 0x4f, 0x52, 0x4d, 0x41, 0x4c, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x50,
	0x4c, 0x41, 0x4e, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x52, 0x4f, 0x46, 0x49, 0x4c, 0x45,
	0x10, 0x02, 0x22, 0xfe, 0x04, 0x0a, 0x16, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x44, 0x6d, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a,
	0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x4d, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x58,
	0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x44, 0x6d, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x19, 0x0a, 0x05, 0x73, 0x65, 0x71, 0x6e,
	0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x65,
	0x71, 0x6e, 0x6f, 0x12, 0x4a, 0x0a, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x0e, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a,
	0x91, 0x02, 0x0a, 0x09, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x15, 0x0a,
	0x03, 0x73, 0x71, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x03, 0x73, 0x71, 0x6c, 0x12, 0x2f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x64, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x6d, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x73, 0x1a, 0x56, 0x0a, 0x0f, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x2d, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x84, 0x01, 0x0a, 0x17, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x44, 0x6d, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x3d, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x53,
	0x65, 0x74, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x53, 0x65, 0x74, 0x73, 0x12, 0x2a,
	0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x6b, 0x0a, 0x10, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x30,
	0x0a, 0x14, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x12, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x69, 0x7a, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x12, 0x25, 0x0a, 0x0e, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x6d, 0x61, 0x78, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xf0, 0x03, 0x0a, 0x15, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x40, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x15, 0x0a,
	0x03, 0x73, 0x71, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x03, 0x73, 0x71, 0x6c, 0x12, 0x2f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x59, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x12, 0x50, 0x0a, 0x11, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x10, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x1a, 0x56, 0x0a, 0x0f, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2d, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xf8, 0x02, 0x0a, 0x14, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x19, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x37, 0x0a, 0x07, 0x6b, 0x65,
	0x79, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4b, 0x65, 0x79, 0x53, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x6b, 0x65, 0x79,
	0x53, 0x65, 0x74, 0x12, 0x50, 0x0a, 0x11, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x10, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x34, 0x0a, 0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0e, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x93, 0x01, 0x0a, 0x11,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x3c, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x40, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x99, 0x07, 0x0a, 0x0b, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x40, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a,
	0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x1d,
	0x0a, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x37, 0x0a,
	0x07, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x6b, 0x65, 0x79, 0x53, 0x65, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x21, 0x0a, 0x0c,
	0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x27, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x4a, 0x0a, 0x0f, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0e, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5a, 0x0a, 0x15, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x52, 0x65, 0x61, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x13, 0x64, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x52, 0x65, 0x61, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x2c, 0x0a, 0x12, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x5f, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x64, 0x61,
	0x74, 0x61, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x46,
	0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x49, 0x0a, 0x09, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x68,
	0x69, 0x6e, 0x74, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c, 0x6f, 0x63, 0x6b, 0x48, 0x69,
	0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x6b, 0x48, 0x69, 0x6e,
	0x74, 0x22, 0x54, 0x0a, 0x07, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x18, 0x0a, 0x14,
	0x4f, 0x52, 0x44, 0x45, 0x52, 0x5f, 0x42, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x4f, 0x52, 0x44, 0x45, 0x52, 0x5f,
	0x42, 0x59, 0x5f, 0x50, 0x52, 0x49, 0x4d, 0x41, 0x52, 0x59, 0x5f, 0x4b, 0x45, 0x59, 0x10, 0x01,
	0x12, 0x15, 0x0a, 0x11, 0x4f, 0x52, 0x44, 0x45, 0x52, 0x5f, 0x42, 0x59, 0x5f, 0x4e, 0x4f, 0x5f,
	0x4f, 0x52, 0x44, 0x45, 0x52, 0x10, 0x02, 0x22, 0x54, 0x0a, 0x08, 0x4c, 0x6f, 0x63, 0x6b, 0x48,
	0x69, 0x6e, 0x74, 0x12, 0x19, 0x0a, 0x15, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x48, 0x49, 0x4e, 0x54,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14,
	0x0a, 0x10, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x48, 0x49, 0x4e, 0x54, 0x5f, 0x53, 0x48, 0x41, 0x52,
	0x45, 0x44, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x48, 0x49, 0x4e,
	0x54, 0x5f, 0x45, 0x58, 0x43, 0x4c, 0x55, 0x53, 0x49, 0x56, 0x45, 0x10, 0x02, 0x22, 0xed, 0x01,
	0x0a, 0x17, 0x42, 0x65, 0x67, 0x69, 0x6e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x07, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x20, 0x0a, 0x1e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x0a, 0x07, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x4a, 0x0a, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0e, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xe9, 0x03,
	0x0a, 0x0d, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x40, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x27, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0d, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x5d, 0x0a, 0x16, 0x73, 0x69,
	0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x48, 0x00, 0x52, 0x14, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x55, 0x73, 0x65, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x09, 0x6d, 0x75, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x6d, 0x75, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x63,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x11, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x12, 0x48, 0x0a, 0x10, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e,
	0x6d, 0x61, 0x78, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x12, 0x4a,
	0x0a, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0e, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x0d, 0x0a, 0x0b, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7f, 0x0a, 0x0f, 0x52, 0x6f, 0x6c,
	0x6c, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x07,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2a,
	0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x9f, 0x03, 0x0a, 0x11, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x40, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x4a, 0x0a, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0e,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x60,
	0x0a, 0x0f, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4d, 0x75,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0e, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x12, 0x49, 0x0a, 0x1f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x74, 0x78, 0x6e, 0x5f,
	0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1b,
	0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x54, 0x78, 0x6e, 0x46, 0x72, 0x6f, 0x6d, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x1a, 0x4f, 0x0a, 0x0d, 0x4d,
	0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x3e, 0x0a, 0x09,
	0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x09, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xa1, 0x01, 0x0a,
	0x12, 0x42, 0x61, 0x74, 0x63, 0x68, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x05, 0x52, 0x07, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x12, 0x2a, 0x0a,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x45, 0x0a, 0x10, 0x63, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x32, 0x8b, 0x18, 0x0a, 0x07, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x12, 0xa6, 0x01, 0x0a,
	0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x22, 0x50, 0xda, 0x41, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x3a, 0x01, 0x2a, 0x22, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xe0, 0x01, 0x0a, 0x13, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6a, 0xda, 0x41,
	0x16, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2c, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x3a, 0x01, 0x2a,
	0x22, 0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x12, 0x97, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x47, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x12, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xae, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4d, 0xda, 0x41, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x12, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x99, 0x01, 0x0a, 0x0d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x47, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x2a, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xa3, 0x01, 0x0a, 0x0a, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x53, 0x71, 0x6c, 0x12, 0x24,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x53, 0x71, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x53,
	0x65, 0x74, 0x22, 0x51, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x3a, 0x01, 0x2a, 0x22, 0x46, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x65, 0x53, 0x71, 0x6c, 0x12, 0xbe, 0x01, 0x0a, 0x13, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x53, 0x71, 0x6c, 0x12, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x53, 0x71, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x53, 0x65, 0x74, 0x22, 0x5a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x54,
	0x3a, 0x01, 0x2a, 0x22, 0x4f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e,
	0x67, 0x53, 0x71, 0x6c, 0x30, 0x01, 0x12, 0xc0, 0x01, 0x0a, 0x0f, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x6d, 0x6c, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x6d, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x6d, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x56, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x3a, 0x01, 0x2a, 0x22, 0x4b, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x6d, 0x6c, 0x12, 0x91, 0x01, 0x0a, 0x04, 0x52, 0x65,
	0x61, 0x64, 0x12, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x53, 0x65, 0x74,
	0x22, 0x4b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x3a, 0x01, 0x2a, 0x22, 0x40, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x61, 0x64, 0x12, 0xac, 0x01,
	0x0a, 0x0d, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x61, 0x64, 0x12,
	0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x53, 0x65, 0x74, 0x22, 0x54, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x3a, 0x01, 0x2a, 0x22,
	0x49, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x61, 0x64, 0x30, 0x01, 0x12, 0xc9, 0x01, 0x0a,
	0x10, 0x42, 0x65, 0x67, 0x69, 0x6e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x65, 0x67, 0x69, 0x6e, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x69, 0xda,
	0x41, 0x0f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2c, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x51, 0x3a, 0x01, 0x2a, 0x22, 0x4c, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x62, 0x65, 0x67, 0x69, 0x6e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xeb, 0x01, 0x0a, 0x06, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x12, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x9b, 0x01, 0xda, 0x41, 0x20, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2c, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x2c, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0xda, 0x41,
	0x28, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2c, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f,
	0x75, 0x73, 0x65, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2c,
	0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x3a,
	0x01, 0x2a, 0x22, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x12, 0xb0, 0x01, 0x0a, 0x08, 0x52, 0x6f, 0x6c, 0x6c, 0x62,
	0x61, 0x63, 0x6b, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22,
	0x68, 0xda, 0x41, 0x16, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2c, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49,
	0x3a, 0x01, 0x2a, 0x22, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x72, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x12, 0xb7, 0x01, 0x0a, 0x0e, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x55, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x4f, 0x3a, 0x01, 0x2a, 0x22, 0x4a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x12, 0xb4, 0x01, 0x0a, 0x0d, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x61, 0x64, 0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x54, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x3a, 0x01, 0x2a, 0x22,
	0x49, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x64, 0x12, 0xc8, 0x01, 0x0a, 0x0a, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x57, 0x72, 0x69, 0x74, 0x65, 0x12, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6b, 0xda, 0x41, 0x17, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x2c, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x3a, 0x01, 0x2a, 0x22, 0x46, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x57, 0x72,
	0x69, 0x74, 0x65, 0x30, 0x01, 0x1a, 0x77, 0xca, 0x41, 0x16, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x5b, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x42, 0x91,
	0x02, 0xea, 0x41, 0x5f, 0x0a, 0x1f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x3c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x7d, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x42, 0x0c, 0x53, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x35, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x70, 0x62, 0x3b, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x70,
	0x62, 0xaa, 0x02, 0x17, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x17, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x3a, 0x3a,
	0x56, 0x31, 0x50, 0x00, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_spanner_v1_spanner_proto_rawDescOnce sync.Once
	file_google_spanner_v1_spanner_proto_rawDescData = file_google_spanner_v1_spanner_proto_rawDesc
)

func file_google_spanner_v1_spanner_proto_rawDescGZIP() []byte {
	file_google_spanner_v1_spanner_proto_rawDescOnce.Do(func() {
		file_google_spanner_v1_spanner_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_spanner_v1_spanner_proto_rawDescData)
	})
	return file_google_spanner_v1_spanner_proto_rawDescData
}

var file_google_spanner_v1_spanner_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_spanner_v1_spanner_proto_msgTypes = make([]protoimpl.MessageInfo, 34)
var file_google_spanner_v1_spanner_proto_goTypes = []interface{}{
	(RequestOptions_Priority)(0),                   // 0: google.spanner.v1.RequestOptions.Priority
	(DirectedReadOptions_ReplicaSelection_Type)(0), // 1: google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type
	(ExecuteSqlRequest_QueryMode)(0),               // 2: google.spanner.v1.ExecuteSqlRequest.QueryMode
	(ReadRequest_OrderBy)(0),                       // 3: google.spanner.v1.ReadRequest.OrderBy
	(ReadRequest_LockHint)(0),                      // 4: google.spanner.v1.ReadRequest.LockHint
	(*CreateSessionRequest)(nil),                   // 5: google.spanner.v1.CreateSessionRequest
	(*BatchCreateSessionsRequest)(nil),             // 6: google.spanner.v1.BatchCreateSessionsRequest
	(*BatchCreateSessionsResponse)(nil),            // 7: google.spanner.v1.BatchCreateSessionsResponse
	(*Session)(nil),                                // 8: google.spanner.v1.Session
	(*GetSessionRequest)(nil),                      // 9: google.spanner.v1.GetSessionRequest
	(*ListSessionsRequest)(nil),                    // 10: google.spanner.v1.ListSessionsRequest
	(*ListSessionsResponse)(nil),                   // 11: google.spanner.v1.ListSessionsResponse
	(*DeleteSessionRequest)(nil),                   // 12: google.spanner.v1.DeleteSessionRequest
	(*RequestOptions)(nil),                         // 13: google.spanner.v1.RequestOptions
	(*DirectedReadOptions)(nil),                    // 14: google.spanner.v1.DirectedReadOptions
	(*ExecuteSqlRequest)(nil),                      // 15: google.spanner.v1.ExecuteSqlRequest
	(*ExecuteBatchDmlRequest)(nil),                 // 16: google.spanner.v1.ExecuteBatchDmlRequest
	(*ExecuteBatchDmlResponse)(nil),                // 17: google.spanner.v1.ExecuteBatchDmlResponse
	(*PartitionOptions)(nil),                       // 18: google.spanner.v1.PartitionOptions
	(*PartitionQueryRequest)(nil),                  // 19: google.spanner.v1.PartitionQueryRequest
	(*PartitionReadRequest)(nil),                   // 20: google.spanner.v1.PartitionReadRequest
	(*Partition)(nil),                              // 21: google.spanner.v1.Partition
	(*PartitionResponse)(nil),                      // 22: google.spanner.v1.PartitionResponse
	(*ReadRequest)(nil),                            // 23: google.spanner.v1.ReadRequest
	(*BeginTransactionRequest)(nil),                // 24: google.spanner.v1.BeginTransactionRequest
	(*CommitRequest)(nil),                          // 25: google.spanner.v1.CommitRequest
	(*RollbackRequest)(nil),                        // 26: google.spanner.v1.RollbackRequest
	(*BatchWriteRequest)(nil),                      // 27: google.spanner.v1.BatchWriteRequest
	(*BatchWriteResponse)(nil),                     // 28: google.spanner.v1.BatchWriteResponse
	nil,                                            // 29: google.spanner.v1.Session.LabelsEntry
	(*DirectedReadOptions_ReplicaSelection)(nil),   // 30: google.spanner.v1.DirectedReadOptions.ReplicaSelection
	(*DirectedReadOptions_IncludeReplicas)(nil),    // 31: google.spanner.v1.DirectedReadOptions.IncludeReplicas
	(*DirectedReadOptions_ExcludeReplicas)(nil),    // 32: google.spanner.v1.DirectedReadOptions.ExcludeReplicas
	(*ExecuteSqlRequest_QueryOptions)(nil),         // 33: google.spanner.v1.ExecuteSqlRequest.QueryOptions
	nil,                                            // 34: google.spanner.v1.ExecuteSqlRequest.ParamTypesEntry
	(*ExecuteBatchDmlRequest_Statement)(nil),       // 35: google.spanner.v1.ExecuteBatchDmlRequest.Statement
	nil,                                            // 36: google.spanner.v1.ExecuteBatchDmlRequest.Statement.ParamTypesEntry
	nil,                                            // 37: google.spanner.v1.PartitionQueryRequest.ParamTypesEntry
	(*BatchWriteRequest_MutationGroup)(nil),        // 38: google.spanner.v1.BatchWriteRequest.MutationGroup
	(*timestamppb.Timestamp)(nil),                  // 39: google.protobuf.Timestamp
	(*TransactionSelector)(nil),                    // 40: google.spanner.v1.TransactionSelector
	(*structpb.Struct)(nil),                        // 41: google.protobuf.Struct
	(*ResultSet)(nil),                              // 42: google.spanner.v1.ResultSet
	(*status.Status)(nil),                          // 43: google.rpc.Status
	(*KeySet)(nil),                                 // 44: google.spanner.v1.KeySet
	(*Transaction)(nil),                            // 45: google.spanner.v1.Transaction
	(*TransactionOptions)(nil),                     // 46: google.spanner.v1.TransactionOptions
	(*Mutation)(nil),                               // 47: google.spanner.v1.Mutation
	(*durationpb.Duration)(nil),                    // 48: google.protobuf.Duration
	(*Type)(nil),                                   // 49: google.spanner.v1.Type
	(*emptypb.Empty)(nil),                          // 50: google.protobuf.Empty
	(*PartialResultSet)(nil),                       // 51: google.spanner.v1.PartialResultSet
	(*CommitResponse)(nil),                         // 52: google.spanner.v1.CommitResponse
}
var file_google_spanner_v1_spanner_proto_depIdxs = []int32{
	8,  // 0: google.spanner.v1.CreateSessionRequest.session:type_name -> google.spanner.v1.Session
	8,  // 1: google.spanner.v1.BatchCreateSessionsRequest.session_template:type_name -> google.spanner.v1.Session
	8,  // 2: google.spanner.v1.BatchCreateSessionsResponse.session:type_name -> google.spanner.v1.Session
	29, // 3: google.spanner.v1.Session.labels:type_name -> google.spanner.v1.Session.LabelsEntry
	39, // 4: google.spanner.v1.Session.create_time:type_name -> google.protobuf.Timestamp
	39, // 5: google.spanner.v1.Session.approximate_last_use_time:type_name -> google.protobuf.Timestamp
	8,  // 6: google.spanner.v1.ListSessionsResponse.sessions:type_name -> google.spanner.v1.Session
	0,  // 7: google.spanner.v1.RequestOptions.priority:type_name -> google.spanner.v1.RequestOptions.Priority
	31, // 8: google.spanner.v1.DirectedReadOptions.include_replicas:type_name -> google.spanner.v1.DirectedReadOptions.IncludeReplicas
	32, // 9: google.spanner.v1.DirectedReadOptions.exclude_replicas:type_name -> google.spanner.v1.DirectedReadOptions.ExcludeReplicas
	40, // 10: google.spanner.v1.ExecuteSqlRequest.transaction:type_name -> google.spanner.v1.TransactionSelector
	41, // 11: google.spanner.v1.ExecuteSqlRequest.params:type_name -> google.protobuf.Struct
	34, // 12: google.spanner.v1.ExecuteSqlRequest.param_types:type_name -> google.spanner.v1.ExecuteSqlRequest.ParamTypesEntry
	2,  // 13: google.spanner.v1.ExecuteSqlRequest.query_mode:type_name -> google.spanner.v1.ExecuteSqlRequest.QueryMode
	33, // 14: google.spanner.v1.ExecuteSqlRequest.query_options:type_name -> google.spanner.v1.ExecuteSqlRequest.QueryOptions
	13, // 15: google.spanner.v1.ExecuteSqlRequest.request_options:type_name -> google.spanner.v1.RequestOptions
	14, // 16: google.spanner.v1.ExecuteSqlRequest.directed_read_options:type_name -> google.spanner.v1.DirectedReadOptions
	40, // 17: google.spanner.v1.ExecuteBatchDmlRequest.transaction:type_name -> google.spanner.v1.TransactionSelector
	35, // 18: google.spanner.v1.ExecuteBatchDmlRequest.statements:type_name -> google.spanner.v1.ExecuteBatchDmlRequest.Statement
	13, // 19: google.spanner.v1.ExecuteBatchDmlRequest.request_options:type_name -> google.spanner.v1.RequestOptions
	42, // 20: google.spanner.v1.ExecuteBatchDmlResponse.result_sets:type_name -> google.spanner.v1.ResultSet
	43, // 21: google.spanner.v1.ExecuteBatchDmlResponse.status:type_name -> google.rpc.Status
	40, // 22: google.spanner.v1.PartitionQueryRequest.transaction:type_name -> google.spanner.v1.TransactionSelector
	41, // 23: google.spanner.v1.PartitionQueryRequest.params:type_name -> google.protobuf.Struct
	37, // 24: google.spanner.v1.PartitionQueryRequest.param_types:type_name -> google.spanner.v1.PartitionQueryRequest.ParamTypesEntry
	18, // 25: google.spanner.v1.PartitionQueryRequest.partition_options:type_name -> google.spanner.v1.PartitionOptions
	40, // 26: google.spanner.v1.PartitionReadRequest.transaction:type_name -> google.spanner.v1.TransactionSelector
	44, // 27: google.spanner.v1.PartitionReadRequest.key_set:type_name -> google.spanner.v1.KeySet
	18, // 28: google.spanner.v1.PartitionReadRequest.partition_options:type_name -> google.spanner.v1.PartitionOptions
	21, // 29: google.spanner.v1.PartitionResponse.partitions:type_name -> google.spanner.v1.Partition
	45, // 30: google.spanner.v1.PartitionResponse.transaction:type_name -> google.spanner.v1.Transaction
	40, // 31: google.spanner.v1.ReadRequest.transaction:type_name -> google.spanner.v1.TransactionSelector
	44, // 32: google.spanner.v1.ReadRequest.key_set:type_name -> google.spanner.v1.KeySet
	13, // 33: google.spanner.v1.ReadRequest.request_options:type_name -> google.spanner.v1.RequestOptions
	14, // 34: google.spanner.v1.ReadRequest.directed_read_options:type_name -> google.spanner.v1.DirectedReadOptions
	3,  // 35: google.spanner.v1.ReadRequest.order_by:type_name -> google.spanner.v1.ReadRequest.OrderBy
	4,  // 36: google.spanner.v1.ReadRequest.lock_hint:type_name -> google.spanner.v1.ReadRequest.LockHint
	46, // 37: google.spanner.v1.BeginTransactionRequest.options:type_name -> google.spanner.v1.TransactionOptions
	13, // 38: google.spanner.v1.BeginTransactionRequest.request_options:type_name -> google.spanner.v1.RequestOptions
	46, // 39: google.spanner.v1.CommitRequest.single_use_transaction:type_name -> google.spanner.v1.TransactionOptions
	47, // 40: google.spanner.v1.CommitRequest.mutations:type_name -> google.spanner.v1.Mutation
	48, // 41: google.spanner.v1.CommitRequest.max_commit_delay:type_name -> google.protobuf.Duration
	13, // 42: google.spanner.v1.CommitRequest.request_options:type_name -> google.spanner.v1.RequestOptions
	13, // 43: google.spanner.v1.BatchWriteRequest.request_options:type_name -> google.spanner.v1.RequestOptions
	38, // 44: google.spanner.v1.BatchWriteRequest.mutation_groups:type_name -> google.spanner.v1.BatchWriteRequest.MutationGroup
	43, // 45: google.spanner.v1.BatchWriteResponse.status:type_name -> google.rpc.Status
	39, // 46: google.spanner.v1.BatchWriteResponse.commit_timestamp:type_name -> google.protobuf.Timestamp
	1,  // 47: google.spanner.v1.DirectedReadOptions.ReplicaSelection.type:type_name -> google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type
	30, // 48: google.spanner.v1.DirectedReadOptions.IncludeReplicas.replica_selections:type_name -> google.spanner.v1.DirectedReadOptions.ReplicaSelection
	30, // 49: google.spanner.v1.DirectedReadOptions.ExcludeReplicas.replica_selections:type_name -> google.spanner.v1.DirectedReadOptions.ReplicaSelection
	49, // 50: google.spanner.v1.ExecuteSqlRequest.ParamTypesEntry.value:type_name -> google.spanner.v1.Type
	41, // 51: google.spanner.v1.ExecuteBatchDmlRequest.Statement.params:type_name -> google.protobuf.Struct
	36, // 52: google.spanner.v1.ExecuteBatchDmlRequest.Statement.param_types:type_name -> google.spanner.v1.ExecuteBatchDmlRequest.Statement.ParamTypesEntry
	49, // 53: google.spanner.v1.ExecuteBatchDmlRequest.Statement.ParamTypesEntry.value:type_name -> google.spanner.v1.Type
	49, // 54: google.spanner.v1.PartitionQueryRequest.ParamTypesEntry.value:type_name -> google.spanner.v1.Type
	47, // 55: google.spanner.v1.BatchWriteRequest.MutationGroup.mutations:type_name -> google.spanner.v1.Mutation
	5,  // 56: google.spanner.v1.Spanner.CreateSession:input_type -> google.spanner.v1.CreateSessionRequest
	6,  // 57: google.spanner.v1.Spanner.BatchCreateSessions:input_type -> google.spanner.v1.BatchCreateSessionsRequest
	9,  // 58: google.spanner.v1.Spanner.GetSession:input_type -> google.spanner.v1.GetSessionRequest
	10, // 59: google.spanner.v1.Spanner.ListSessions:input_type -> google.spanner.v1.ListSessionsRequest
	12, // 60: google.spanner.v1.Spanner.DeleteSession:input_type -> google.spanner.v1.DeleteSessionRequest
	15, // 61: google.spanner.v1.Spanner.ExecuteSql:input_type -> google.spanner.v1.ExecuteSqlRequest
	15, // 62: google.spanner.v1.Spanner.ExecuteStreamingSql:input_type -> google.spanner.v1.ExecuteSqlRequest
	16, // 63: google.spanner.v1.Spanner.ExecuteBatchDml:input_type -> google.spanner.v1.ExecuteBatchDmlRequest
	23, // 64: google.spanner.v1.Spanner.Read:input_type -> google.spanner.v1.ReadRequest
	23, // 65: google.spanner.v1.Spanner.StreamingRead:input_type -> google.spanner.v1.ReadRequest
	24, // 66: google.spanner.v1.Spanner.BeginTransaction:input_type -> google.spanner.v1.BeginTransactionRequest
	25, // 67: google.spanner.v1.Spanner.Commit:input_type -> google.spanner.v1.CommitRequest
	26, // 68: google.spanner.v1.Spanner.Rollback:input_type -> google.spanner.v1.RollbackRequest
	19, // 69: google.spanner.v1.Spanner.PartitionQuery:input_type -> google.spanner.v1.PartitionQueryRequest
	20, // 70: google.spanner.v1.Spanner.PartitionRead:input_type -> google.spanner.v1.PartitionReadRequest
	27, // 71: google.spanner.v1.Spanner.BatchWrite:input_type -> google.spanner.v1.BatchWriteRequest
	8,  // 72: google.spanner.v1.Spanner.CreateSession:output_type -> google.spanner.v1.Session
	7,  // 73: google.spanner.v1.Spanner.BatchCreateSessions:output_type -> google.spanner.v1.BatchCreateSessionsResponse
	8,  // 74: google.spanner.v1.Spanner.GetSession:output_type -> google.spanner.v1.Session
	11, // 75: google.spanner.v1.Spanner.ListSessions:output_type -> google.spanner.v1.ListSessionsResponse
	50, // 76: google.spanner.v1.Spanner.DeleteSession:output_type -> google.protobuf.Empty
	42, // 77: google.spanner.v1.Spanner.ExecuteSql:output_type -> google.spanner.v1.ResultSet
	51, // 78: google.spanner.v1.Spanner.ExecuteStreamingSql:output_type -> google.spanner.v1.PartialResultSet
	17, // 79: google.spanner.v1.Spanner.ExecuteBatchDml:output_type -> google.spanner.v1.ExecuteBatchDmlResponse
	42, // 80: google.spanner.v1.Spanner.Read:output_type -> google.spanner.v1.ResultSet
	51, // 81: google.spanner.v1.Spanner.StreamingRead:output_type -> google.spanner.v1.PartialResultSet
	45, // 82: google.spanner.v1.Spanner.BeginTransaction:output_type -> google.spanner.v1.Transaction
	52, // 83: google.spanner.v1.Spanner.Commit:output_type -> google.spanner.v1.CommitResponse
	50, // 84: google.spanner.v1.Spanner.Rollback:output_type -> google.protobuf.Empty
	22, // 85: google.spanner.v1.Spanner.PartitionQuery:output_type -> google.spanner.v1.PartitionResponse
	22, // 86: google.spanner.v1.Spanner.PartitionRead:output_type -> google.spanner.v1.PartitionResponse
	28, // 87: google.spanner.v1.Spanner.BatchWrite:output_type -> google.spanner.v1.BatchWriteResponse
	72, // [72:88] is the sub-list for method output_type
	56, // [56:72] is the sub-list for method input_type
	56, // [56:56] is the sub-list for extension type_name
	56, // [56:56] is the sub-list for extension extendee
	0,  // [0:56] is the sub-list for field type_name
}

func init() { file_google_spanner_v1_spanner_proto_init() }
func file_google_spanner_v1_spanner_proto_init() {
	if File_google_spanner_v1_spanner_proto != nil {
		return
	}
	file_google_spanner_v1_commit_response_proto_init()
	file_google_spanner_v1_keys_proto_init()
	file_google_spanner_v1_mutation_proto_init()
	file_google_spanner_v1_result_set_proto_init()
	file_google_spanner_v1_transaction_proto_init()
	file_google_spanner_v1_type_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_spanner_v1_spanner_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSessionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateSessionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateSessionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Session); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSessionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSessionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSessionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSessionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RequestOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DirectedReadOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteSqlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteBatchDmlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteBatchDmlResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionQueryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionReadRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Partition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BeginTransactionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RollbackRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchWriteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchWriteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DirectedReadOptions_ReplicaSelection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DirectedReadOptions_IncludeReplicas); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DirectedReadOptions_ExcludeReplicas); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteSqlRequest_QueryOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteBatchDmlRequest_Statement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchWriteRequest_MutationGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_spanner_v1_spanner_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*DirectedReadOptions_IncludeReplicas_)(nil),
		(*DirectedReadOptions_ExcludeReplicas_)(nil),
	}
	file_google_spanner_v1_spanner_proto_msgTypes[20].OneofWrappers = []interface{}{
		(*CommitRequest_TransactionId)(nil),
		(*CommitRequest_SingleUseTransaction)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_spanner_v1_spanner_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   34,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_spanner_v1_spanner_proto_goTypes,
		DependencyIndexes: file_google_spanner_v1_spanner_proto_depIdxs,
		EnumInfos:         file_google_spanner_v1_spanner_proto_enumTypes,
		MessageInfos:      file_google_spanner_v1_spanner_proto_msgTypes,
	}.Build()
	File_google_spanner_v1_spanner_proto = out.File
	file_google_spanner_v1_spanner_proto_rawDesc = nil
	file_google_spanner_v1_spanner_proto_goTypes = nil
	file_google_spanner_v1_spanner_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SpannerClient is the client API for Spanner service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SpannerClient interface {
	// Creates a new session. A session can be used to perform
	// transactions that read and/or modify data in a Cloud Spanner database.
	// Sessions are meant to be reused for many consecutive
	// transactions.
	//
	// Sessions can only execute one transaction at a time. To execute
	// multiple concurrent read-write/write-only transactions, create
	// multiple sessions. Note that standalone reads and queries use a
	// transaction internally, and count toward the one transaction
	// limit.
	//
	// Active sessions use additional server resources, so it is a good idea to
	// delete idle and unneeded sessions.
	// Aside from explicit deletes, Cloud Spanner may delete sessions for which no
	// operations are sent for more than an hour. If a session is deleted,
	// requests to it return `NOT_FOUND`.
	//
	// Idle sessions can be kept alive by sending a trivial SQL query
	// periodically, e.g., `"SELECT 1"`.
	CreateSession(ctx context.Context, in *CreateSessionRequest, opts ...grpc.CallOption) (*Session, error)
	// Creates multiple new sessions.
	//
	// This API can be used to initialize a session cache on the clients.
	// See https://goo.gl/TgSFN2 for best practices on session cache management.
	BatchCreateSessions(ctx context.Context, in *BatchCreateSessionsRequest, opts ...grpc.CallOption) (*BatchCreateSessionsResponse, error)
	// Gets a session. Returns `NOT_FOUND` if the session does not exist.
	// This is mainly useful for determining whether a session is still
	// alive.
	GetSession(ctx context.Context, in *GetSessionRequest, opts ...grpc.CallOption) (*Session, error)
	// Lists all sessions in a given database.
	ListSessions(ctx context.Context, in *ListSessionsRequest, opts ...grpc.CallOption) (*ListSessionsResponse, error)
	// Ends a session, releasing server resources associated with it. This will
	// asynchronously trigger cancellation of any operations that are running with
	// this session.
	DeleteSession(ctx context.Context, in *DeleteSessionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Executes an SQL statement, returning all results in a single reply. This
	// method cannot be used to return a result set larger than 10 MiB;
	// if the query yields more data than that, the query fails with
	// a `FAILED_PRECONDITION` error.
	//
	// Operations inside read-write transactions might return `ABORTED`. If
	// this occurs, the application should restart the transaction from
	// the beginning. See [Transaction][google.spanner.v1.Transaction] for more
	// details.
	//
	// Larger result sets can be fetched in streaming fashion by calling
	// [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql]
	// instead.
	ExecuteSql(ctx context.Context, in *ExecuteSqlRequest, opts ...grpc.CallOption) (*ResultSet, error)
	// Like [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql], except returns the
	// result set as a stream. Unlike
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql], there is no limit on
	// the size of the returned result set. However, no individual row in the
	// result set can exceed 100 MiB, and no column value can exceed 10 MiB.
	ExecuteStreamingSql(ctx context.Context, in *ExecuteSqlRequest, opts ...grpc.CallOption) (Spanner_ExecuteStreamingSqlClient, error)
	// Executes a batch of SQL DML statements. This method allows many statements
	// to be run with lower latency than submitting them sequentially with
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql].
	//
	// Statements are executed in sequential order. A request can succeed even if
	// a statement fails. The
	// [ExecuteBatchDmlResponse.status][google.spanner.v1.ExecuteBatchDmlResponse.status]
	// field in the response provides information about the statement that failed.
	// Clients must inspect this field to determine whether an error occurred.
	//
	// Execution stops after the first failed statement; the remaining statements
	// are not executed.
	ExecuteBatchDml(ctx context.Context, in *ExecuteBatchDmlRequest, opts ...grpc.CallOption) (*ExecuteBatchDmlResponse, error)
	// Reads rows from the database using key lookups and scans, as a
	// simple key/value style alternative to
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql].  This method cannot be
	// used to return a result set larger than 10 MiB; if the read matches more
	// data than that, the read fails with a `FAILED_PRECONDITION`
	// error.
	//
	// Reads inside read-write transactions might return `ABORTED`. If
	// this occurs, the application should restart the transaction from
	// the beginning. See [Transaction][google.spanner.v1.Transaction] for more
	// details.
	//
	// Larger result sets can be yielded in streaming fashion by calling
	// [StreamingRead][google.spanner.v1.Spanner.StreamingRead] instead.
	Read(ctx context.Context, in *ReadRequest, opts ...grpc.CallOption) (*ResultSet, error)
	// Like [Read][google.spanner.v1.Spanner.Read], except returns the result set
	// as a stream. Unlike [Read][google.spanner.v1.Spanner.Read], there is no
	// limit on the size of the returned result set. However, no individual row in
	// the result set can exceed 100 MiB, and no column value can exceed
	// 10 MiB.
	StreamingRead(ctx context.Context, in *ReadRequest, opts ...grpc.CallOption) (Spanner_StreamingReadClient, error)
	// Begins a new transaction. This step can often be skipped:
	// [Read][google.spanner.v1.Spanner.Read],
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] and
	// [Commit][google.spanner.v1.Spanner.Commit] can begin a new transaction as a
	// side-effect.
	BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*Transaction, error)
	// Commits a transaction. The request includes the mutations to be
	// applied to rows in the database.
	//
	// `Commit` might return an `ABORTED` error. This can occur at any time;
	// commonly, the cause is conflicts with concurrent
	// transactions. However, it can also happen for a variety of other
	// reasons. If `Commit` returns `ABORTED`, the caller should re-attempt
	// the transaction from the beginning, re-using the same session.
	//
	// On very rare occasions, `Commit` might return `UNKNOWN`. This can happen,
	// for example, if the client job experiences a 1+ hour networking failure.
	// At that point, Cloud Spanner has lost track of the transaction outcome and
	// we recommend that you perform another read from the database to see the
	// state of things as they are now.
	Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error)
	// Rolls back a transaction, releasing any locks it holds. It is a good
	// idea to call this for any transaction that includes one or more
	// [Read][google.spanner.v1.Spanner.Read] or
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] requests and ultimately
	// decides not to commit.
	//
	// `Rollback` returns `OK` if it successfully aborts the transaction, the
	// transaction was already aborted, or the transaction is not
	// found. `Rollback` never returns `ABORTED`.
	Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a set of partition tokens that can be used to execute a query
	// operation in parallel.  Each of the returned partition tokens can be used
	// by [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] to
	// specify a subset of the query result to read.  The same session and
	// read-only transaction must be used by the PartitionQueryRequest used to
	// create the partition tokens and the ExecuteSqlRequests that use the
	// partition tokens.
	//
	// Partition tokens become invalid when the session used to create them
	// is deleted, is idle for too long, begins a new transaction, or becomes too
	// old.  When any of these happen, it is not possible to resume the query, and
	// the whole operation must be restarted from the beginning.
	PartitionQuery(ctx context.Context, in *PartitionQueryRequest, opts ...grpc.CallOption) (*PartitionResponse, error)
	// Creates a set of partition tokens that can be used to execute a read
	// operation in parallel.  Each of the returned partition tokens can be used
	// by [StreamingRead][google.spanner.v1.Spanner.StreamingRead] to specify a
	// subset of the read result to read.  The same session and read-only
	// transaction must be used by the PartitionReadRequest used to create the
	// partition tokens and the ReadRequests that use the partition tokens.  There
	// are no ordering guarantees on rows returned among the returned partition
	// tokens, or even within each individual StreamingRead call issued with a
	// partition_token.
	//
	// Partition tokens become invalid when the session used to create them
	// is deleted, is idle for too long, begins a new transaction, or becomes too
	// old.  When any of these happen, it is not possible to resume the read, and
	// the whole operation must be restarted from the beginning.
	PartitionRead(ctx context.Context, in *PartitionReadRequest, opts ...grpc.CallOption) (*PartitionResponse, error)
	// Batches the supplied mutation groups in a collection of efficient
	// transactions. All mutations in a group are committed atomically. However,
	// mutations across groups can be committed non-atomically in an unspecified
	// order and thus, they must be independent of each other. Partial failure is
	// possible, i.e., some groups may have been committed successfully, while
	// some may have failed. The results of individual batches are streamed into
	// the response as the batches are applied.
	//
	// BatchWrite requests are not replay protected, meaning that each mutation
	// group may be applied more than once. Replays of non-idempotent mutations
	// may have undesirable effects. For example, replays of an insert mutation
	// may produce an already exists error or if you use generated or commit
	// timestamp-based keys, it may result in additional rows being added to the
	// mutation's table. We recommend structuring your mutation groups to be
	// idempotent to avoid this issue.
	BatchWrite(ctx context.Context, in *BatchWriteRequest, opts ...grpc.CallOption) (Spanner_BatchWriteClient, error)
}

type spannerClient struct {
	cc grpc.ClientConnInterface
}

func NewSpannerClient(cc grpc.ClientConnInterface) SpannerClient {
	return &spannerClient{cc}
}

func (c *spannerClient) CreateSession(ctx context.Context, in *CreateSessionRequest, opts ...grpc.CallOption) (*Session, error) {
	out := new(Session)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/CreateSession", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) BatchCreateSessions(ctx context.Context, in *BatchCreateSessionsRequest, opts ...grpc.CallOption) (*BatchCreateSessionsResponse, error) {
	out := new(BatchCreateSessionsResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/BatchCreateSessions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) GetSession(ctx context.Context, in *GetSessionRequest, opts ...grpc.CallOption) (*Session, error) {
	out := new(Session)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/GetSession", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) ListSessions(ctx context.Context, in *ListSessionsRequest, opts ...grpc.CallOption) (*ListSessionsResponse, error) {
	out := new(ListSessionsResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/ListSessions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) DeleteSession(ctx context.Context, in *DeleteSessionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/DeleteSession", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) ExecuteSql(ctx context.Context, in *ExecuteSqlRequest, opts ...grpc.CallOption) (*ResultSet, error) {
	out := new(ResultSet)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/ExecuteSql", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) ExecuteStreamingSql(ctx context.Context, in *ExecuteSqlRequest, opts ...grpc.CallOption) (Spanner_ExecuteStreamingSqlClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Spanner_serviceDesc.Streams[0], "/google.spanner.v1.Spanner/ExecuteStreamingSql", opts...)
	if err != nil {
		return nil, err
	}
	x := &spannerExecuteStreamingSqlClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Spanner_ExecuteStreamingSqlClient interface {
	Recv() (*PartialResultSet, error)
	grpc.ClientStream
}

type spannerExecuteStreamingSqlClient struct {
	grpc.ClientStream
}

func (x *spannerExecuteStreamingSqlClient) Recv() (*PartialResultSet, error) {
	m := new(PartialResultSet)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *spannerClient) ExecuteBatchDml(ctx context.Context, in *ExecuteBatchDmlRequest, opts ...grpc.CallOption) (*ExecuteBatchDmlResponse, error) {
	out := new(ExecuteBatchDmlResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/ExecuteBatchDml", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) Read(ctx context.Context, in *ReadRequest, opts ...grpc.CallOption) (*ResultSet, error) {
	out := new(ResultSet)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/Read", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) StreamingRead(ctx context.Context, in *ReadRequest, opts ...grpc.CallOption) (Spanner_StreamingReadClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Spanner_serviceDesc.Streams[1], "/google.spanner.v1.Spanner/StreamingRead", opts...)
	if err != nil {
		return nil, err
	}
	x := &spannerStreamingReadClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Spanner_StreamingReadClient interface {
	Recv() (*PartialResultSet, error)
	grpc.ClientStream
}

type spannerStreamingReadClient struct {
	grpc.ClientStream
}

func (x *spannerStreamingReadClient) Recv() (*PartialResultSet, error) {
	m := new(PartialResultSet)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *spannerClient) BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*Transaction, error) {
	out := new(Transaction)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/BeginTransaction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error) {
	out := new(CommitResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/Commit", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/Rollback", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) PartitionQuery(ctx context.Context, in *PartitionQueryRequest, opts ...grpc.CallOption) (*PartitionResponse, error) {
	out := new(PartitionResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/PartitionQuery", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) PartitionRead(ctx context.Context, in *PartitionReadRequest, opts ...grpc.CallOption) (*PartitionResponse, error) {
	out := new(PartitionResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/PartitionRead", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) BatchWrite(ctx context.Context, in *BatchWriteRequest, opts ...grpc.CallOption) (Spanner_BatchWriteClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Spanner_serviceDesc.Streams[2], "/google.spanner.v1.Spanner/BatchWrite", opts...)
	if err != nil {
		return nil, err
	}
	x := &spannerBatchWriteClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Spanner_BatchWriteClient interface {
	Recv() (*BatchWriteResponse, error)
	grpc.ClientStream
}

type spannerBatchWriteClient struct {
	grpc.ClientStream
}

func (x *spannerBatchWriteClient) Recv() (*BatchWriteResponse, error) {
	m := new(BatchWriteResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// SpannerServer is the server API for Spanner service.
type SpannerServer interface {
	// Creates a new session. A session can be used to perform
	// transactions that read and/or modify data in a Cloud Spanner database.
	// Sessions are meant to be reused for many consecutive
	// transactions.
	//
	// Sessions can only execute one transaction at a time. To execute
	// multiple concurrent read-write/write-only transactions, create
	// multiple sessions. Note that standalone reads and queries use a
	// transaction internally, and count toward the one transaction
	// limit.
	//
	// Active sessions use additional server resources, so it is a good idea to
	// delete idle and unneeded sessions.
	// Aside from explicit deletes, Cloud Spanner may delete sessions for which no
	// operations are sent for more than an hour. If a session is deleted,
	// requests to it return `NOT_FOUND`.
	//
	// Idle sessions can be kept alive by sending a trivial SQL query
	// periodically, e.g., `"SELECT 1"`.
	CreateSession(context.Context, *CreateSessionRequest) (*Session, error)
	// Creates multiple new sessions.
	//
	// This API can be used to initialize a session cache on the clients.
	// See https://goo.gl/TgSFN2 for best practices on session cache management.
	BatchCreateSessions(context.Context, *BatchCreateSessionsRequest) (*BatchCreateSessionsResponse, error)
	// Gets a session. Returns `NOT_FOUND` if the session does not exist.
	// This is mainly useful for determining whether a session is still
	// alive.
	GetSession(context.Context, *GetSessionRequest) (*Session, error)
	// Lists all sessions in a given database.
	ListSessions(context.Context, *ListSessionsRequest) (*ListSessionsResponse, error)
	// Ends a session, releasing server resources associated with it. This will
	// asynchronously trigger cancellation of any operations that are running with
	// this session.
	DeleteSession(context.Context, *DeleteSessionRequest) (*emptypb.Empty, error)
	// Executes an SQL statement, returning all results in a single reply. This
	// method cannot be used to return a result set larger than 10 MiB;
	// if the query yields more data than that, the query fails with
	// a `FAILED_PRECONDITION` error.
	//
	// Operations inside read-write transactions might return `ABORTED`. If
	// this occurs, the application should restart the transaction from
	// the beginning. See [Transaction][google.spanner.v1.Transaction] for more
	// details.
	//
	// Larger result sets can be fetched in streaming fashion by calling
	// [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql]
	// instead.
	ExecuteSql(context.Context, *ExecuteSqlRequest) (*ResultSet, error)
	// Like [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql], except returns the
	// result set as a stream. Unlike
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql], there is no limit on
	// the size of the returned result set. However, no individual row in the
	// result set can exceed 100 MiB, and no column value can exceed 10 MiB.
	ExecuteStreamingSql(*ExecuteSqlRequest, Spanner_ExecuteStreamingSqlServer) error
	// Executes a batch of SQL DML statements. This method allows many statements
	// to be run with lower latency than submitting them sequentially with
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql].
	//
	// Statements are executed in sequential order. A request can succeed even if
	// a statement fails. The
	// [ExecuteBatchDmlResponse.status][google.spanner.v1.ExecuteBatchDmlResponse.status]
	// field in the response provides information about the statement that failed.
	// Clients must inspect this field to determine whether an error occurred.
	//
	// Execution stops after the first failed statement; the remaining statements
	// are not executed.
	ExecuteBatchDml(context.Context, *ExecuteBatchDmlRequest) (*ExecuteBatchDmlResponse, error)
	// Reads rows from the database using key lookups and scans, as a
	// simple key/value style alternative to
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql].  This method cannot be
	// used to return a result set larger than 10 MiB; if the read matches more
	// data than that, the read fails with a `FAILED_PRECONDITION`
	// error.
	//
	// Reads inside read-write transactions might return `ABORTED`. If
	// this occurs, the application should restart the transaction from
	// the beginning. See [Transaction][google.spanner.v1.Transaction] for more
	// details.
	//
	// Larger result sets can be yielded in streaming fashion by calling
	// [StreamingRead][google.spanner.v1.Spanner.StreamingRead] instead.
	Read(context.Context, *ReadRequest) (*ResultSet, error)
	// Like [Read][google.spanner.v1.Spanner.Read], except returns the result set
	// as a stream. Unlike [Read][google.spanner.v1.Spanner.Read], there is no
	// limit on the size of the returned result set. However, no individual row in
	// the result set can exceed 100 MiB, and no column value can exceed
	// 10 MiB.
	StreamingRead(*ReadRequest, Spanner_StreamingReadServer) error
	// Begins a new transaction. This step can often be skipped:
	// [Read][google.spanner.v1.Spanner.Read],
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] and
	// [Commit][google.spanner.v1.Spanner.Commit] can begin a new transaction as a
	// side-effect.
	BeginTransaction(context.Context, *BeginTransactionRequest) (*Transaction, error)
	// Commits a transaction. The request includes the mutations to be
	// applied to rows in the database.
	//
	// `Commit` might return an `ABORTED` error. This can occur at any time;
	// commonly, the cause is conflicts with concurrent
	// transactions. However, it can also happen for a variety of other
	// reasons. If `Commit` returns `ABORTED`, the caller should re-attempt
	// the transaction from the beginning, re-using the same session.
	//
	// On very rare occasions, `Commit` might return `UNKNOWN`. This can happen,
	// for example, if the client job experiences a 1+ hour networking failure.
	// At that point, Cloud Spanner has lost track of the transaction outcome and
	// we recommend that you perform another read from the database to see the
	// state of things as they are now.
	Commit(context.Context, *CommitRequest) (*CommitResponse, error)
	// Rolls back a transaction, releasing any locks it holds. It is a good
	// idea to call this for any transaction that includes one or more
	// [Read][google.spanner.v1.Spanner.Read] or
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] requests and ultimately
	// decides not to commit.
	//
	// `Rollback` returns `OK` if it successfully aborts the transaction, the
	// transaction was already aborted, or the transaction is not
	// found. `Rollback` never returns `ABORTED`.
	Rollback(context.Context, *RollbackRequest) (*emptypb.Empty, error)
	// Creates a set of partition tokens that can be used to execute a query
	// operation in parallel.  Each of the returned partition tokens can be used
	// by [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] to
	// specify a subset of the query result to read.  The same session and
	// read-only transaction must be used by the PartitionQueryRequest used to
	// create the partition tokens and the ExecuteSqlRequests that use the
	// partition tokens.
	//
	// Partition tokens become invalid when the session used to create them
	// is deleted, is idle for too long, begins a new transaction, or becomes too
	// old.  When any of these happen, it is not possible to resume the query, and
	// the whole operation must be restarted from the beginning.
	PartitionQuery(context.Context, *PartitionQueryRequest) (*PartitionResponse, error)
	// Creates a set of partition tokens that can be used to execute a read
	// operation in parallel.  Each of the returned partition tokens can be used
	// by [StreamingRead][google.spanner.v1.Spanner.StreamingRead] to specify a
	// subset of the read result to read.  The same session and read-only
	// transaction must be used by the PartitionReadRequest used to create the
	// partition tokens and the ReadRequests that use the partition tokens.  There
	// are no ordering guarantees on rows returned among the returned partition
	// tokens, or even within each individual StreamingRead call issued with a
	// partition_token.
	//
	// Partition tokens become invalid when the session used to create them
	// is deleted, is idle for too long, begins a new transaction, or becomes too
	// old.  When any of these happen, it is not possible to resume the read, and
	// the whole operation must be restarted from the beginning.
	PartitionRead(context.Context, *PartitionReadRequest) (*PartitionResponse, error)
	// Batches the supplied mutation groups in a collection of efficient
	// transactions. All mutations in a group are committed atomically. However,
	// mutations across groups can be committed non-atomically in an unspecified
	// order and thus, they must be independent of each other. Partial failure is
	// possible, i.e., some groups may have been committed successfully, while
	// some may have failed. The results of individual batches are streamed into
	// the response as the batches are applied.
	//
	// BatchWrite requests are not replay protected, meaning that each mutation
	// group may be applied more than once. Replays of non-idempotent mutations
	// may have undesirable effects. For example, replays of an insert mutation
	// may produce an already exists error or if you use generated or commit
	// timestamp-based keys, it may result in additional rows being added to the
	// mutation's table. We recommend structuring your mutation groups to be
	// idempotent to avoid this issue.
	BatchWrite(*BatchWriteRequest, Spanner_BatchWriteServer) error
}

// UnimplementedSpannerServer can be embedded to have forward compatible implementations.
type UnimplementedSpannerServer struct {
}

func (*UnimplementedSpannerServer) CreateSession(context.Context, *CreateSessionRequest) (*Session, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateSession not implemented")
}
func (*UnimplementedSpannerServer) BatchCreateSessions(context.Context, *BatchCreateSessionsRequest) (*BatchCreateSessionsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchCreateSessions not implemented")
}
func (*UnimplementedSpannerServer) GetSession(context.Context, *GetSessionRequest) (*Session, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetSession not implemented")
}
func (*UnimplementedSpannerServer) ListSessions(context.Context, *ListSessionsRequest) (*ListSessionsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListSessions not implemented")
}
func (*UnimplementedSpannerServer) DeleteSession(context.Context, *DeleteSessionRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteSession not implemented")
}
func (*UnimplementedSpannerServer) ExecuteSql(context.Context, *ExecuteSqlRequest) (*ResultSet, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ExecuteSql not implemented")
}
func (*UnimplementedSpannerServer) ExecuteStreamingSql(*ExecuteSqlRequest, Spanner_ExecuteStreamingSqlServer) error {
	return status1.Errorf(codes.Unimplemented, "method ExecuteStreamingSql not implemented")
}
func (*UnimplementedSpannerServer) ExecuteBatchDml(context.Context, *ExecuteBatchDmlRequest) (*ExecuteBatchDmlResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ExecuteBatchDml not implemented")
}
func (*UnimplementedSpannerServer) Read(context.Context, *ReadRequest) (*ResultSet, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method Read not implemented")
}
func (*UnimplementedSpannerServer) StreamingRead(*ReadRequest, Spanner_StreamingReadServer) error {
	return status1.Errorf(codes.Unimplemented, "method StreamingRead not implemented")
}
func (*UnimplementedSpannerServer) BeginTransaction(context.Context, *BeginTransactionRequest) (*Transaction, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BeginTransaction not implemented")
}
func (*UnimplementedSpannerServer) Commit(context.Context, *CommitRequest) (*CommitResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method Commit not implemented")
}
func (*UnimplementedSpannerServer) Rollback(context.Context, *RollbackRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method Rollback not implemented")
}
func (*UnimplementedSpannerServer) PartitionQuery(context.Context, *PartitionQueryRequest) (*PartitionResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method PartitionQuery not implemented")
}
func (*UnimplementedSpannerServer) PartitionRead(context.Context, *PartitionReadRequest) (*PartitionResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method PartitionRead not implemented")
}
func (*UnimplementedSpannerServer) BatchWrite(*BatchWriteRequest, Spanner_BatchWriteServer) error {
	return status1.Errorf(codes.Unimplemented, "method BatchWrite not implemented")
}

func RegisterSpannerServer(s *grpc.Server, srv SpannerServer) {
	s.RegisterService(&_Spanner_serviceDesc, srv)
}

func _Spanner_CreateSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).CreateSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/CreateSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).CreateSession(ctx, req.(*CreateSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_BatchCreateSessions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateSessionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).BatchCreateSessions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/BatchCreateSessions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).BatchCreateSessions(ctx, req.(*BatchCreateSessionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_GetSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).GetSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/GetSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).GetSession(ctx, req.(*GetSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_ListSessions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSessionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).ListSessions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/ListSessions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).ListSessions(ctx, req.(*ListSessionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_DeleteSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).DeleteSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/DeleteSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).DeleteSession(ctx, req.(*DeleteSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_ExecuteSql_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExecuteSqlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).ExecuteSql(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/ExecuteSql",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).ExecuteSql(ctx, req.(*ExecuteSqlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_ExecuteStreamingSql_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ExecuteSqlRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(SpannerServer).ExecuteStreamingSql(m, &spannerExecuteStreamingSqlServer{stream})
}

type Spanner_ExecuteStreamingSqlServer interface {
	Send(*PartialResultSet) error
	grpc.ServerStream
}

type spannerExecuteStreamingSqlServer struct {
	grpc.ServerStream
}

func (x *spannerExecuteStreamingSqlServer) Send(m *PartialResultSet) error {
	return x.ServerStream.SendMsg(m)
}

func _Spanner_ExecuteBatchDml_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExecuteBatchDmlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).ExecuteBatchDml(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/ExecuteBatchDml",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).ExecuteBatchDml(ctx, req.(*ExecuteBatchDmlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_Read_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).Read(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/Read",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).Read(ctx, req.(*ReadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_StreamingRead_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReadRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(SpannerServer).StreamingRead(m, &spannerStreamingReadServer{stream})
}

type Spanner_StreamingReadServer interface {
	Send(*PartialResultSet) error
	grpc.ServerStream
}

type spannerStreamingReadServer struct {
	grpc.ServerStream
}

func (x *spannerStreamingReadServer) Send(m *PartialResultSet) error {
	return x.ServerStream.SendMsg(m)
}

func _Spanner_BeginTransaction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BeginTransactionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).BeginTransaction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/BeginTransaction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).BeginTransaction(ctx, req.(*BeginTransactionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_Commit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).Commit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/Commit",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).Commit(ctx, req.(*CommitRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_Rollback_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).Rollback(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/Rollback",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).Rollback(ctx, req.(*RollbackRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_PartitionQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PartitionQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).PartitionQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/PartitionQuery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).PartitionQuery(ctx, req.(*PartitionQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_PartitionRead_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PartitionReadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).PartitionRead(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/PartitionRead",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).PartitionRead(ctx, req.(*PartitionReadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_BatchWrite_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(BatchWriteRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(SpannerServer).BatchWrite(m, &spannerBatchWriteServer{stream})
}

type Spanner_BatchWriteServer interface {
	Send(*BatchWriteResponse) error
	grpc.ServerStream
}

type spannerBatchWriteServer struct {
	grpc.ServerStream
}

func (x *spannerBatchWriteServer) Send(m *BatchWriteResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _Spanner_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.spanner.v1.Spanner",
	HandlerType: (*SpannerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSession",
			Handler:    _Spanner_CreateSession_Handler,
		},
		{
			MethodName: "BatchCreateSessions",
			Handler:    _Spanner_BatchCreateSessions_Handler,
		},
		{
			MethodName: "GetSession",
			Handler:    _Spanner_GetSession_Handler,
		},
		{
			MethodName: "ListSessions",
			Handler:    _Spanner_ListSessions_Handler,
		},
		{
			MethodName: "DeleteSession",
			Handler:    _Spanner_DeleteSession_Handler,
		},
		{
			MethodName: "ExecuteSql",
			Handler:    _Spanner_ExecuteSql_Handler,
		},
		{
			MethodName: "ExecuteBatchDml",
			Handler:    _Spanner_ExecuteBatchDml_Handler,
		},
		{
			MethodName: "Read",
			Handler:    _Spanner_Read_Handler,
		},
		{
			MethodName: "BeginTransaction",
			Handler:    _Spanner_BeginTransaction_Handler,
		},
		{
			MethodName: "Commit",
			Handler:    _Spanner_Commit_Handler,
		},
		{
			MethodName: "Rollback",
			Handler:    _Spanner_Rollback_Handler,
		},
		{
			MethodName: "PartitionQuery",
			Handler:    _Spanner_PartitionQuery_Handler,
		},
		{
			MethodName: "PartitionRead",
			Handler:    _Spanner_PartitionRead_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ExecuteStreamingSql",
			Handler:       _Spanner_ExecuteStreamingSql_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "StreamingRead",
			Handler:       _Spanner_StreamingRead_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "BatchWrite",
			Handler:       _Spanner_BatchWrite_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/spanner/v1/spanner.proto",
}
