#include <stdio.h>
# define U(x) ((x)&0377)
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX 200
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin =NULL, *yyout =NULL;
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
/* ----------------------------------------------------------------- 
FILE:	    readcells_lex                               
DESCRIPTION:rules for lexical analyzer in readcell.  This lexical
	    analyzer uses a binary search to reduce the size of 
	    the f.a.  generated by lex.  Thanks to Gary Richey who 
	    showed me the trick.  See chapter 3 of "Introduction
	    to Compiler Construction with UNIX" by Schreiner &
	    Friedman for more details.
CONTENTS:   lex rules -
	    screen()
DATE:	    Aug 07, 1988 - need to add SccsId in comments due to yacc
	    static char SccsId[] = "@(#) readcells.l version 3.9 4/18/91" ;
REVISIONS:  Oct 6, 1988 - fixed sign mistake in INTEGER & FLOAT
	    Feb 12, 1989 - added <> to alphanum to handle DEC case.
	    Mar  7, 1989 - added instance keyword.
	    Apr  4, 1989 - added comments over multiple lines.
	    May  7, 1989 - added layer to keywords.
	    Feb  7, 1990 - added orient keyword.
	    Thu Dec 20 00:00:25 EST 1990 - updated FLOAT def.
	    Dec 21, 1990 - changed NO_CROSS_UNDER to NO_LAYER_CHANGE
	    Mon Jan 21 22:31:24 PST 1991 - added ASCII charset for
		alphanum.
	    Wed Jan 23 14:39:34 PST 1991 - made language context free.
	    Fri Mar 22 20:03:52 CST 1991 - made letter more general.
	    Thu Apr 18 01:42:15 EDT 1991 - made pingroup standard
		with SC and rename stdcell to cluster.
----------------------------------------------------------------- */
#undef   YYLMAX 
#define  YYLMAX 2000       /* comments may be at most 2000 characters */

#define token(x)      x    /* makes it look like regular lex */
#define END(v) (v-1 + sizeof(v) / sizeof( v[0] ) ) /* for table lookup */

static INT screen() ;
static void check_line_count() ;

static int yylook(void);
static int yyback(int *p, int m);

# define YYNEWLINE 10
INT yylex(){
int nstr; extern int yyprevious;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:

		      {
			/* C-style comments over multiple lines */
          		check_line_count(yytext) ;
	              }
break;
case 2:
      { 
		         /* convert to an integer */
		         yylval.ival = atoi( yytext ) ;
	  	         return (INTEGER); 
	              }
break;
case 3:
 {
		         /* convert to an integer */
		         yylval.fval = atof( yytext ) ;
	  	         return (FLOAT); 
		      }
break;
case 4:
 {
		         /* convert to an integer */
		         yylval.fval = atof( yytext ) ;
	  	         return (FLOAT); 
		      }
break;
case 5:
  {  return( screen() ) ; }
break;
case 6:
           {  line_countS++;}
break;
case 7:
             ;
break;
case 8:
              {  return( token(yytext[0]) ) ;}
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */

/* reserved word screener */
/* ----------------------------------------------------------------- 
    The following is table of the reserved words - Table must be in
    alphabetical order for binary search to work properly.
----------------------------------------------------------------- */
static struct rw_table {  /* reserved word table */
    char *rw_name ;      /* pattern */
    INT rw_yylex  ;      /* lex token number */
} rwtable[] = {
    "addequiv",            token(ADDEQUIV),
    "asplb",               token(ASPLB),
    "aspub",               token(ASPUB),
    "at",                  token(AT),
    "cellgroup",           token(CELLGROUP),
    "class",               token(CLASS),
    "cluster",             token(CLUSTER),
    "connect",             token(CONNECT),
    "corners",             token(CORNERS),
    "current",             token(CURRENT),
    "equiv",               token(EQUIV),
    "fixed",               token(FIXED),
    "from",                token(FROM),
    "hardcell",            token(HARDCELL),
    "instance",            token(INSTANCE),
    "keepout",             token(KEEPOUT),
    "layer",               token(LAYER),
    "name",                token(NAME),
    "neighborhood",        token(NEIGHBORHOOD),
    "no_layer_change",     token(NO_LAYER_CHANGE),
    "nonfixed",            token(NONFIXED),
    "nopermute",           token(NOPERMUTE),
    "orient",              token(ORIENT),
    "orientations",        token(ORIENTATIONS),
    "pad",                 token(PAD),
    "padgroup",            token(PADGROUP),
    "permute",             token(PERMUTE),
    "pin",                 token(PIN),
    "pin_group",           token(PINGROUP),
    "power",               token(POWER),
    "restrict",            token(RESTRICT),
    "side",                token(SIDE),
    "sidespace",           token(SIDESPACE),
    "signal",              token(SIGNAL),
    "softcell",            token(SOFTCELL),
    "softpin",             token(SOFTPIN),
    "supergroup",          token(SUPERGROUP),
    "timing",              token(TIMING)
} ;

static INT screen() 
{
    INT c ;
    struct rw_table  *low = rwtable,        /* ptr to beginning */
		     *mid ,  
		     *high = END(rwtable) ;   /* ptr to end */

    /* binary search to look thru table to find pattern match */
    while( low <= high){
	mid = low + (high-low) / 2 ;
	if( (c = strcmp(mid->rw_name, yytext) ) == STRINGEQ){
	    return( mid->rw_yylex ) ; /* return token number */
	} else if( c < 0 ){
	    low = mid + 1 ;
	} else {
	    high = mid - 1 ;
	}
    }
    /* at this point we haven't found a match so we have a string */
    /* save the string by making copy */
    yylval.string = (char *) Ystrclone( yytext ) ;
    return (STRING); 
		
} /* end screen function */

static void check_line_count( s ) 
char *s ;
{
    if( s ){
	if( strlen(s) >= YYLMAX ){
	    sprintf(YmsgG, "comment beginning at line %d ",line_countS+1 );
	    M( ERRMSG, "lex", YmsgG ) ;
	    sprintf(YmsgG,"exceeds maximum allowed length:%d chars.\n", 
		YYLMAX );
	    M( MSG, NULL, YmsgG ) ;
	    setErrorFlag() ;
	}
	for( ;*s;s++ ){
	    if( *s == '\n'){
		line_countS++;
	    }
	}
    }
} /* end check_line_count */
int yyvstop[] ={
0,

7,
0,

7,
0,

8,
0,

7,
8,
0,

6,
0,

5,
8,
0,

5,
8,
0,

3,
5,
8,
0,

5,
8,
0,

2,
8,
0,

7,
0,

5,
0,

3,
5,
0,

2,
5,
0,

5,
0,

3,
5,
0,

2,
0,

5,
0,

5,
0,

5,
0,

5,
0,

5,
0,

4,
5,
0,

5,
0,

5,
0,

1,
5,
0,

1,
0,

5,
0,

1,
5,
0,

1,
0,
0};
# define YYTYPE unsigned char
struct yywork { YYTYPE verify, advance; } yycrank[] ={
0,0,	0,0,	1,3,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,4,	1,5,	
4,11,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,6,	4,11,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	1,6,	
1,7,	9,15,	0,0,	1,8,	
1,9,	1,10,	7,13,	0,0,	
7,14,	7,14,	7,14,	7,14,	
7,14,	7,14,	7,14,	7,14,	
7,14,	7,14,	20,20,	27,33,	
28,34,	32,26,	33,27,	34,27,	
0,0,	0,0,	1,6,	6,12,	
6,12,	6,12,	6,12,	6,12,	
6,12,	6,12,	6,12,	6,12,	
6,12,	6,12,	6,12,	6,12,	
6,12,	6,12,	6,12,	6,12,	
6,12,	6,12,	6,12,	6,12,	
6,12,	6,12,	6,12,	6,12,	
6,12,	6,12,	6,12,	6,12,	
6,12,	6,12,	6,12,	6,12,	
6,12,	6,12,	6,12,	6,12,	
6,12,	6,12,	6,12,	6,12,	
6,12,	6,12,	6,12,	6,12,	
6,12,	6,12,	6,12,	6,12,	
6,12,	6,12,	6,12,	6,12,	
6,12,	6,12,	6,12,	6,12,	
6,12,	6,12,	6,12,	6,12,	
6,12,	6,12,	6,12,	6,12,	
6,12,	6,12,	6,12,	6,12,	
6,12,	6,12,	6,12,	6,12,	
6,12,	6,12,	6,12,	6,12,	
6,12,	6,12,	6,12,	6,12,	
6,12,	6,12,	6,12,	6,12,	
6,12,	6,12,	6,12,	6,12,	
6,12,	6,12,	6,12,	6,12,	
6,12,	8,13,	8,13,	8,13,	
8,13,	8,13,	8,13,	8,13,	
8,13,	8,13,	8,13,	10,16,	
0,0,	10,17,	10,17,	10,17,	
10,17,	10,17,	10,17,	10,17,	
10,17,	10,17,	10,17,	13,13,	
13,13,	13,13,	13,13,	13,13,	
13,13,	13,13,	13,13,	13,13,	
13,13,	14,16,	10,18,	14,14,	
14,14,	14,14,	14,14,	14,14,	
14,14,	14,14,	14,14,	14,14,	
14,14,	15,19,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	15,19,	15,19,	0,0,	
14,18,	0,0,	0,0,	0,0,	
0,0,	0,0,	18,23,	0,0,	
18,23,	0,0,	10,18,	18,24,	
18,24,	18,24,	18,24,	18,24,	
18,24,	18,24,	18,24,	18,24,	
18,24,	15,20,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	15,21,	15,20,	
14,18,	0,0,	15,20,	15,22,	
15,20,	16,16,	16,16,	16,16,	
16,16,	16,16,	16,16,	16,16,	
16,16,	16,16,	16,16,	21,26,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	21,26,	
21,26,	15,20,	16,18,	17,16,	
0,0,	17,17,	17,17,	17,17,	
17,17,	17,17,	17,17,	17,17,	
17,17,	17,17,	17,17,	19,19,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	21,27,	
19,25,	19,19,	17,18,	0,0,	
19,19,	19,19,	19,19,	0,0,	
21,28,	21,27,	16,18,	0,0,	
21,27,	21,29,	21,27,	23,24,	
23,24,	23,24,	23,24,	23,24,	
23,24,	23,24,	23,24,	23,24,	
23,24,	0,0,	0,0,	19,19,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	17,18,	21,27,	
24,24,	24,24,	24,24,	24,24,	
24,24,	24,24,	24,24,	24,24,	
24,24,	24,24,	25,26,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	26,19,	0,0,	25,30,	
25,26,	0,0,	0,0,	25,26,	
25,31,	25,26,	26,25,	26,19,	
30,19,	0,0,	26,19,	26,32,	
26,19,	0,0,	0,0,	0,0,	
0,0,	30,25,	30,19,	0,0,	
0,0,	30,19,	30,35,	30,19,	
0,0,	0,0,	25,26,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	26,19,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
30,19,	0,0,	0,0,	0,0,	
0,0};
struct yysvf yysvec[] ={
0,	0,	0,
yycrank+-1,	0,		yyvstop+1,
yycrank+0,	yysvec+1,	yyvstop+3,
yycrank+0,	0,		yyvstop+5,
yycrank+3,	0,		yyvstop+7,
yycrank+0,	0,		yyvstop+10,
yycrank+38,	0,		yyvstop+12,
yycrank+4,	yysvec+6,	yyvstop+15,
yycrank+117,	yysvec+6,	yyvstop+18,
yycrank+3,	yysvec+6,	yyvstop+22,
yycrank+129,	yysvec+6,	yyvstop+25,
yycrank+0,	yysvec+4,	yyvstop+28,
yycrank+0,	yysvec+6,	yyvstop+30,
yycrank+139,	yysvec+6,	yyvstop+32,
yycrank+151,	yysvec+6,	yyvstop+35,
yycrank+-208,	0,		yyvstop+38,
yycrank+209,	yysvec+6,	yyvstop+40,
yycrank+233,	yysvec+6,	yyvstop+43,
yycrank+183,	yysvec+6,	yyvstop+45,
yycrank+-258,	yysvec+15,	0,	
yycrank+-15,	yysvec+15,	yyvstop+47,
yycrank+-266,	0,		yyvstop+49,
yycrank+0,	yysvec+15,	yyvstop+51,
yycrank+267,	yysvec+6,	yyvstop+53,
yycrank+288,	yysvec+6,	yyvstop+55,
yycrank+-313,	yysvec+21,	0,	
yycrank+-320,	yysvec+15,	0,	
yycrank+-16,	yysvec+15,	yyvstop+58,
yycrank+-17,	yysvec+15,	yyvstop+60,
yycrank+0,	yysvec+6,	yyvstop+62,
yycrank+-331,	yysvec+15,	0,	
yycrank+0,	0,		yyvstop+65,
yycrank+18,	0,		0,	
yycrank+19,	yysvec+6,	yyvstop+67,
yycrank+20,	yysvec+6,	yyvstop+69,
yycrank+0,	yysvec+32,	yyvstop+72,
0,	0,	0};
struct yywork *yytop = yycrank+400;
struct yysvf *yybgin = yysvec+1;
char yymatch[] ={
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,
'!' ,'!' ,'*' ,'+' ,'!' ,'+' ,'.' ,'/' ,
'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,
'0' ,'0' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,
'!' ,'!' ,'!' ,'!' ,'!' ,'E' ,'!' ,'!' ,
'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,
'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,
'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,
'!' ,'!' ,'!' ,'!' ,'!' ,'E' ,'!' ,'!' ,
'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,
'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,
'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
0};
char yyextra[] ={
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
/*	ncform	4.1	83/08/11	*/

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
static int yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
	if (yyin == NULL) yyin = stdin;
	if (yyout == NULL) yyout = stdout;
# ifdef LEXDEBUG
	debug = 0;
# endif
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank){		/* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"unsigned char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (long)yyt > (long)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((long)yyt < (long)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
static int yyback(int *p, int m)
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
int yyinput(){
	if (yyin == NULL) yyin = stdin;
	return(input());
	}
void yyoutput(c)
  int c; {
	if (yyout == NULL) yyout = stdout;
	output(c);
	}
void yyunput(c)
   int c; {
	unput(c);
	}
