#
# This file is part of the GROMACS molecular simulation package.
#
# Copyright (c) 2015,2016,2017,2018,2019, by the GROMACS development team, led by
# Mark Abraham, David van der Spoel, Berk Hess, and Erik Lindahl,
# and including many others, as listed in the AUTHORS file in the
# top-level source directory and at http://www.gromacs.org.
#
# GROMACS is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2.1
# of the License, or (at your option) any later version.
#
# GROMACS is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with GROMACS; if not, see
# http://www.gnu.org/licenses, or write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
#
# If you want to redistribute modifications to GROMACS, please
# consider that scientific software is very special. Version
# control is crucial - bugs must be traceable. We will be happy to
# consider code for inclusion in the official distribution, but
# derived work must not be called official GROMACS. Details are found
# in the README & COPYING files - if they are missing, get the
# official version at http://www.gromacs.org.
#
# To help us fund GROMACS development, we humbly ask that you cite
# the research papers on the package. Check out http://www.gromacs.org.

# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# http://www.sphinx-doc.org/en/master/config

from pkg_resources import get_distribution, DistributionNotFound

# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.autosummary',
    'sphinx.ext.coverage',
    'sphinx.ext.doctest',
    'sphinx.ext.intersphinx',
    'sphinx.ext.mathjax',
    'sphinx.ext.napoleon',
    'sphinx.ext.todo',
    'sphinx.ext.viewcode',
    'sphinxcontrib.plantuml'
]

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'GROMACS scripting and extension API'
copyright = u'2017, M. Eric Irrgang and Peter Kasson; 2019, GROMACS development team'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
try:
    release = str(get_distribution('gmxapi').version)
    version = '.'.join(release.split('.')[:2])
except DistributionNotFound:
    # package is not installed
    pass

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']

# The reST default role (used for this markup: `text`) to use for all
# documents.
default_role = 'any'

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# -- Options for todo extension ----------------------------------------------

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True

# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
# GROMACS uses the 'classic' theme.
html_theme = 'classic'

# The name for this set of Sphinx documents.
# "<project> v<release> documentation" by default.
#
html_title = u'GROMACS External Interfaces'

# A shorter title for the navigation bar.  Default is the same as html_title.
#
html_short_title = u'gmxapi'

# Output file base name for HTML help builder.
htmlhelp_basename = 'gmxapi'

# -- Options for Intersphinx -------------------------------------------------

intersphinx_mapping = {'python': ('https://docs.python.org/3', None)}

# -- Options for autodoc extension -------------------------------------------
# reference https://www.sphinx-doc.org/en/master/usage/extensions/autodoc.html#configuration

# Functions imported from C modules cannot be introspected, and therefore the
# signature for such functions cannot be automatically determined. However, it is
# an often-used convention to put the signature into the first line of the
# function's docstring.
#
# If this boolean value is set to True (which is the default), autodoc will look
# at the first line of the docstring for functions and methods, and if it looks
# like a signature, use the line as the signature and remove it from the docstring
# content.
#
autodoc_docstring_signature = True

# autodoc_mock_imports This value contains a list of modules to be mocked up. This
# is useful when some external dependencies are not met at build time and break
# the building process.
#
# New in version 1.3.
#
autodoc_mock_imports = []

# See http://www.sphinx-doc.org/en/master/usage/extensions/autodoc.html#confval-autoclass_content
autoclass_content = 'both'

# -- Options for Napoleon extension ------------------------------------------
# reference https://www.sphinx-doc.org/en/master/usage/extensions/napoleon.html#configuration

# -- Options for plantuml extension ------------------------------------------

plantuml = '/usr/bin/plantuml'
