# GNU Typist - improved typing tutor program for UNIX systems
# Copyright (C) 1998  Simon Baldwin (simonb@sco.com)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

#------------------------------------------------------------------------------
# Series V
#------------------------------------------------------------------------------
G:_V_MENU
*:_V_NO_MENU

#------------------------------------------------------------------------------
# Lesson V1
#------------------------------------------------------------------------------
*:V1
*:_V_S_V1
B:                            Lesson V1

*:_V_R_L0
T:			Lesson	V1

I:(1)
*:_V_R_L1
D:r r r r frf frf frf u u u u juj juj juj juj
 :frf juj frf juj frf juj frf juj frf juj frf juj

I:(2)
*:_V_R_L2
D:fff jjj fff jjj fff jjj fff jjj fff jjj fff jjj
 :fff jjj fff jjj fff jjj fff jjj fff jjj fff jjj
 :
 :fru fru fru jur jur jur ruj ruj ruj urf urf urf
 :fru fru fru ruf ruf ruf urj urj urj fuj fuj fuj
 :
 :urf urf urf juf juf juf fuj fuj fuj fru fru fru
 :fur fur fur ruf ruf ruf urf urf urf jur jur jur

G:_V_E_V1

#------------------------------------------------------------------------------
# Lesson V2
#------------------------------------------------------------------------------
*:V2
*:_V_S_V2
B:                            Lesson V2

*:_V_R_L3
T:
 :		       (D K E I)

I:(1) Warmup
*:_V_R_L4
D:fff jjj fff jjj fff jjj fff jjj fff jjj fff jjj
 :frf juj frf juj frf juj frf juj frf juj frf juj
 :
 :fur fur fur ruf ruf ruf jur jur jur ruj ruj ruj
 :urj urj urj juf juf juf fuj fuj fuj fur fur fur

I:(2) New Key Control
*:_V_R_L5
D:d d d d ddd ddd ddd ddd k k k k kkk kkk kkk kkk
 :ddd kkk ddd kkk ddd kkk ddd kkk ddd kkk ddd kkk

I:(3)
*:_V_R_L6
D:e e e e ded ded ded ded ded i i i i kik kik kik
 :ded kik ded kik ded kik ded kik ded kik ded kik

I:(4)
*:_V_R_L7
D:did did did ire ire ire rid rid rid eke eke eke
 :rid rid rid eke eke eke ire ire ire did did did
 :
 :kid kid kid fee fee fee red red red fir fir fir
 :red red red fir fir fir fee fee fee kid kid kid

I:(5)
*:_V_R_L8
D:free free free juke juke juke fire fire fire juke
 :fire fire fire juke juke juke free free free juke
 :
 :deer deer deer rude rude rude dire dire dire ride
 :rude rude rude dire dire dire deer deer deer ride

I:(6)
*:_V_R_L9
D:fired fired fired rider rider rider freed freed
 :rider rider rider freed freed freed fired fired
 :
 :did red ire fee rid deer rude fire feed juke rider
 :rid fee ire red did juke fire rude juke deed freed

G:_V_E_V2

#------------------------------------------------------------------------------
# Lesson V3
#------------------------------------------------------------------------------
*:V3
*:_V_S_V3
B:                            Lesson V3

*:_V_R_L10
T:
 :			     (T Y G H)

I:(1) Warmup
*:_V_R_L11
D:fff jjj ddd kkk frf juj ded kik fff jjj ddd kkk
 :frf juj ded kik fur fur kid kid red red ire ire
 :
 :kid kid kid juke juke juke dire dire dire fire
 :rid rid rid rude rude rude ride ride ride feed

*:_V_R_L12
D:
 :did red ire fee rid deer rude fire feed juke rider
 :rid fee ire red did juke fire rude juke deed freed

I:(2) T and Y
*:_V_R_L13
D:t t t t ftf ftf ftf ftf y y y y jyj jyj jyj jyj
 :ftf jyj ftf jyj ftf jyj ftf jyj ftf jyj ftf jyj

I:(3) G and H
*:_V_R_L14
D:g g g g fgf fgf fgf fgf h h h h jhj jhj jhj jhj
 :fgf jhj fgf jhj fgf jhj fgf jhj fgf jhj fgf jhj

I:(4) Word Drill
*:_V_R_L15
D:hit hit hit hit hit hit get get get get get get
 :yet yet yet yet yet yet try try try try try try

I:(5)
*:_V_R_L16
D:the the the try try try get get get yet yet yet
 :try try try the the the yet yet yet get get get
 :
 :key key key jit hit hit tie tie tie kit kit kit
 :tie tie tie kit kit kit key key key hit hit hit

I:(6)
*:_V_R_L17
D:here here here they they they true true true
 :they they they true true true here here here
 :
 :there there there fruit fruit fruit right right right
 :fruit fruit fruit right right right there there there

I:(7)
*:_V_R_L18
D:third third third tired tired tired urged urged urged
 :tired tired tired urged urged urged third third third
 :
 :truth truth truth their their their dried dried dried
 :their their their dried dried dried truth truth truth

I:(8)
*:_V_R_L19
D:did they get the right dried fruit there yet
 :did they get the right dried fruit there yet

G:_V_E_V3

#------------------------------------------------------------------------------
# Lesson V4
#------------------------------------------------------------------------------
*:V4
*:_V_S_V4
B:                            Lesson V4

*:_V_R_L20
T:
 :			(S L W O)

I:(1) Warmup
*:_V_R_L21
D:frf juj ded kik ftf jyj fgf jhj frf juj ded kik
 :ded kik ftf jyj fgf jhj frf juj ded kik ftf jyj

I:(2) S and L
*:_V_R_L22
D:s s s s sss sss sss sss l l l l lll lll lll lll
 :sss lll sss lll sss lll sss lll sss lll sss lll

I:(3) W and O
*:_V_R_L23
D:w w w w sws sws sws sws o o o o lol lol lol lol
 :sws lol sws lol sws lol sws lol sws lol sws lol

I:(4) Words Drill
*:_V_R_L24
D:sow sow sow sow sow sow low low low low low low
 :row row row row row row how how how how how how

I:(5)
*:_V_R_L25
D:is is is so so so of of of do do do go go go to to to
 :go go go to to to do do do of of of so so so is is is
 :
 :too too too low low low set set set wit wit wit wit
 :sit sit sit lit lit lit wit wit wit low low low low

I:(6)
*:_V_R_L26
D:wool wool wool suit suit suit full full full wood wood
 :hole hole hole wool wool wool suit suit suit good good
 :
 :style style style order order order those those
 :loose loose loose style style style order order
 :
 :desire desire desire rulers rulers rulers worker
 :worker worker worker desire desire desire rulers

I:(7)
*:_V_R_L27
D:hold your wrists low while you strike the keys
 :we desire the right goods for our wool suits
 :if you will go with us you will see the fleet
 :we will try to fill your order for the wool suits
 :if we get the right goods we will fill your order

G:_V_E_V4

#------------------------------------------------------------------------------
# Lesson V5
#------------------------------------------------------------------------------
*:V5
*:_V_S_V5
B:                            Lesson V5

*:_V_R_L28
T:
 :		        (A ; Q P)

I:(1) Warmup
*:_V_R_L29
D:frf juj ded kik ftf jyj fgf jhj frf juj ftf jyj fgf jhj
 :ded kik sws lol ded kik sws lol frf juj ftf jyj fgf jhj

I:(2) A and ;
*:_V_R_L30
D:a a a a aaa aaa aaa aaa ; ; ; ; ;;; ;;; ;;; ;;;
 :aaa ;;; aaa ;;; aaa ;;; aaa ;;; aaa ;;; aaa ;;;

I:(3) Q and P
*:_V_R_L31
D:q q q q aqa aqa aqa aqa p p p p ;p; ;p; ;p; ;p;
 :aqa ;p; aqa ;p; aqa ;p; aqa ;p; aqa ;p; aqa ;p;

I:(4) Word Drill
*:_V_R_L32
D:pa; pa; pa; pa; pa; pa; up; up; up; up; up; up;
 :pa; pa; pa; pa; pa; pa; up; up; up; up; up; up;

I:(5)
*:_V_R_L33
D:quay quay quay quay quay quip quip quip quip quip
 :quay quay quay quay quay quip quip quip quip quip

I:(6)
*:_V_R_L34
D:apt apt apt; put put put; sip sip sip; hip hip hip;
 :sip sip sip; hip hip hip; apt apt apt; put put put;
 :
 :quip quip quip; quit quit quit; aqua aqua aqua;
 :aqua aqua aqua; quip quip quip; quit quit quit;
 :
 :paid paid paid; pair pair pair; pass pass pass;
 :pair pair pair; pass pass pass; paid paid paid;

I:(7)
*:_V_R_L35
D:quote quote quote; paper paper paper; quite quite;
 :paper paper paper; quite quite quite; quote quote;
 :
 :prefer prefer prefer; prepay prepay prepay; quires;
 :prepay prepay prepay; prefer prefer prefer; quires;
 :
 :postage postage postage; quarter quarter quarter;
 :poultry poultry poultry; quality quality quality;

I:(8)
*:_V_R_L35A
D:two quires of high quality paper were shipped today;
 :we shall pay you well to prepare the reports for us;
 :we quote a low figure for our high quality paper;
 :we prefer to prepay the postage for the two quires;

G:_V_E_V5

#------------------------------------------------------------------------------
# Lesson V6
#------------------------------------------------------------------------------
*:V6
*:_V_S_V6
B:                            Lesson V6

*:_V_R_L36
T:
 :		    (Shift Keys for Capitalization)

I:(1) Warmup
*:_V_R_L37
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :aqa ;p; sws lol ded kik frf juj ftf jyj fgf jhj
 :
 :he will pay jed squire for the sugar this week;

I:(2) Capital Letter Drill
*:_V_R_L38
D:F F F F F F Fa Fa Fa Fa Fa Fa Fay Fay Fay Fay Fay Fay
 :J J J J J J Ja Ja Ja Ja Ja Ja Jay Jay Jay Jay Jay Jay
 :
 :R R R R R R Ra Ra Ra Ra Ra Ra Ray Ray Ray Ray Ray Ray
 :H H H H H H Ha Ha Ha Ha Ha Ha Hal Hal Hal Hal Hal Hal

I:(3)
*:_V_R_L39
D:Kay Kay Kay; Joe Joe Joe; Alf Alf Alf; Lou Lou Lou;
 :Joe Joe Joe; Kay Kay Kay; Lou Lou Lou; Alf Alf Alf;
 :
 :Dora Dora Dora; Ella Ella Ella; Pete Pete Pete;
 :Sara Sara Sara; Lola Lola Lola; Will Will Will;
 :
 :Garry Garry Garry; Harry Harry Harry; Paula Paula;
 :Harry Harry Harry; Taffy Taffy Taffy; Quail Quail;

I:(4)
*:_V_R_L40
D:Uriah Uriah Uriah; Yetta Yetta Yetta; Ollie Ollie;
 :Yetta Yetta Yetta; Ollie Ollie Ollie; Uriah Uriah;
 :
 :Walter Walter Walter; Esther Esther Esther; Isaiah;
 :Esther Esther Esther; Walter Walter Walter; Isaiah;
 :
 :Arthur Arthur Arthur; Lester Lester Lester; Quezon;
 :Quezon Quezon Quezon; Arthur Arthur Arthur; Philip;

I:(5)
*:_V_R_L41
D:Joseph likes to study; Joseph likes to study art;
 :Esther will write; Esther will write Larry today;
 :Arthur likes; Arthur likes to play the flute;
 :Kate says; Kate says she will stay till Friday;
 :Paul will take Willa to the Park Sherry Theater;

G:_V_E_V6

#------------------------------------------------------------------------------
# Lesson V7
#------------------------------------------------------------------------------
*:V7
*:_V_S_V7
B:                            Lesson V7

*:_V_R_L42
T:
 :		(Shift Lock and :)

I:(1) Warmup
*:_V_R_L43
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :aqa ;p; sws lol ded kik frf juj ftf jyj fgf jhj

I:(2) Shift Lock Drill
*:_V_R_L44
D:It is GOOD WORK; It is GOOD WORK; It is GOOD WORK;
 :It is GOOD WORK; It is GOOD WORK; It is GOOD WORK;

I:(3)
*:_V_R_L45
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :The TITLE of the REPORT is:  HOUSES FOR SALE
 :The TITLE of the REPORT is:  HOUSES FOR SALE
 :
 :aqa ;p; sws lol ded kik frf juj ftf jyj fgf jhj
 :We quote LOW FIGURES for HIGHEST QUALITY paper;
 :We quote LOW FIGURES for HIGHEST QUALITY paper;

I:(4)
*:_V_R_L46
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :The PARK POSTER reads:  KEEP OFF THE GRASS
 :The PARK POSTER reads:  KEEP OFF THE GRASS
 :
 :aqa ;p; sws lol ded kik frf juj ftf jyj fgf jhj
 :Paul quoted the old adage:  THE THRIFTY ARE WISE
 :Paul quoted the old adage:  THE THRIFTY ARE WISE

*:_V_R_L46A
#
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :You should STRIKE ALL THE KEYS with EQUAL POWER;
 :You should STRIKE ALL THE KEYS with EQUAL POWER;

I:(5)
*:_V_R_L47
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :GOOD WORK will lead to a HAPPY LIFE for you;
 :GOOD WORK will lead to a HAPPY LIFE for you;
 :aqa ;p; sws lol ded kik frf juj ftf jyj fgf jhj
 :The DAILY DRILLS will HELP YOU type with EASE;
 :The DAILY DRILLS will HELP YOU type with EASE;

*:_V_R_L47A
#
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :GOOD SALARIES are USUALLY PAID to FAST TYPISTS;
 :GOOD SALARIES are USUALLY PAID to FAST TYPISTS;

G:_V_E_V7

#------------------------------------------------------------------------------
# Lesson V8
#------------------------------------------------------------------------------
*:V8
*:_V_S_V8
B:                            Lesson V8

*:_V_R_L48
T:
 :		  (Introducing the Period)

I:(1) Warmup
*:_V_R_L49
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :aqa ;p; sws lol ded kik frf juj ftf jyj fgf jhj
 :
 :He will pay Jed Squire for the sugar this week;

I:(2) The Period
*:_V_R_L50
D:. . . . . . l.l l.l l.l l.l l.l l.l l.l l.l l.l
 :Hit it lightly.  Hit it lightly.  Hit it lightly.
 :Hit it lightly.  Hit it lightly.  Hit it lightly.

I:(3)
*:_V_R_L51
S:Strike all the keys with pep.  Strike the keys
 :as though they were red hot.  This is just how the
 :fast typist works.
 :
 :Type with thought.  Put forth your greatest efforts.
 :Let these two ideas guide you while you type.
 :
 :You should follow the daily drills as you are told.
 :These drills will show you that it is quite easy
 :to type well.
 :
 :Start your daily work without delay.  Keep at it
 :regularly.  It is steady work that will take you
 :to your goal.

I:(4) Keyboard Review
*:_V_R_L52
D:for fat few fur foe fit fed fee for fat fir few fro;
 :fro few fir fat for fee fig foe fop fit fur fat fad;
 :
 :jug jig jut jar joy jag jaw jar jet jot jog jug joy;
 :joy jug jog jag jaw jot jig jut jar jig jaw jog jet;

I:(5)
*:_V_R_L53
D:rye rut row red rip ray rap rug rig rut rye rug rot;
 :rot rye rut row red rip rat rap rug rig rut rye rug;
 :
 :up us use uses urge ugly usage upper uproar upright;
 :us up use urge uses urge urges udder utters upstart;

G:_V_E_V8

#------------------------------------------------------------------------------
# Lesson V9
#------------------------------------------------------------------------------
*:V9
*:_V_S_V9
B:                            Lesson V9

*:_V_R_L54
T:
 :			(V and M)

I:(1) Warmup
*:_V_R_L55
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :aqa ;p; sws lol ded kik frf juj ftf jyj fgf jhj
 :
 :I will pay Joe Quig for the sugar today.

I:(2) New Keys (V, M)
*:_V_R_L56
D:v v v v fvf fvf fvf fvf m m m m jmj jmj jmj jmj
 :fvf jmj fvf jmj fvf jmj fvf jmj fvf jmj fvf jmj

I:(3)
*:_V_R_L57
D:over over over; gave gave gave; have have have;
 :home home home; seem seem seem; time time time;
 :
 :ever ever ever; more more more; item item item;
 :live live live; vast vast vast; five five five;
 :
 :You must devote more time to your daily work.
 :You should go over every item with more thought.

I:(4) Paragraph Practice
*:_V_R_L58
S:You will surely make good if you give more time to
 :your daily work here.  You must make every effort
 :to make good.
 :
 :You will improve your skill every day if you
 :devote some thought to your work.  You will surely
 :progress if you keep at your work regularly.  Just
 :have faith.
 :
 :Skillful typists make very good salaries.  All
 :types of firms require them.  So try your utmost to
 :develop your skill.

I:(5) Exercises on G, H, T, and Y
*:_V_R_L59
D:go got get gas gag gap gay gig gray greed great;
 :go gig gay gap gas gag get gas gray great greed;
 :
 :her has had his hit hot hut hat hay hag had his;
 :his had hag hay hat hut hot hit his had has her;

*:_V_R_L59A
#
D:to try tip tap two tag too to try tip tap two;
 :to two tap tip try too try to top tap tag try;
 :
 :you yes yet yap yell year yoke your yowl yore;
 :yap yet yes you yore yowl your yoke year yell;

G:_V_E_V9

#------------------------------------------------------------------------------
# Lesson V10
#------------------------------------------------------------------------------
*:V10
*:_V_S_V10
B:                            Lesson V10

*:_V_R_L60
T:
 :			(B and N)

I:(1) Warmup
*:_V_R_L61
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :fgf jhj fvf jmj fgf jhj fvf jmj fgf jhj fvf jmj
 :
 :Paul Quigs will devote more time to his work.

I:(2) New Keys
*:_V_R_L62
D:b b b b fbf fbf fbf fbf n n n n jnj jnj jnj jnj
 :fbf jnj fbf jnj fbf jnj fbf jnj fbf jnj fbf jnj

I:(3) Word Drill
*:_V_R_L63
D:bin bin bin bin bin bin nib nib nib nib nib nib
 :big big big big big big now now now now now now

I:(4)
*:_V_R_L64
D:bun bun bun; nip nip nip; fib fib fib; win win win;
 :fib fib fib; win win win; bun bun bun; nip nip nip;
 :
 :bent bent bent; nine nine nine; vent vent vent;
 :mend mend mend; vine vine vine; blow blow blow;
 :
 :We require more time to turn out a very good job.
 :Be prompt.  Never shirk.  Make promptness a habit.

I:(5) Practice Paragraph
*:_V_R_L65
S:Never put off until tomorrow any job you should
 :finish today.  Try to be prompt at all times.  No one
 :likes to be kept waiting.
 :
 :Keep on working just as diligently as you have
 :been doing up to this point.  You will soon be a
 :master of the keyboard.  You will have a valuable
 :skill that will repay you for your efforts.
 :
 :Remember this:  every boy and girl is able to
 :learn typing.  All they have to do is to put forth
 :their very best efforts.  This means thinking while
 :training every finger to strike the right key.

I:(6) Words with D, E, K, and I
*:_V_R_L66
D:do dot due dye day dew dab den dim dog die dig dry dip
 :do dig dry dip die dog dim dab den dew day dye due dot
 :
 :ebb eke err eve end egg ever even edge earn east evil
 :err eke eve end ebb eel evil east earn edge envy easy

I:(7)
*:_V_R_L67
D:kid kin kit keg key king kind know knee knot knew
 :key keg kid kit kin knew knot knee knob king kind
 :
 :it is in if ire ill ink inn imp idle item isle iron
 :if in is it imp inn ill ire ink item idle iron isle

G:_V_E_V10

#------------------------------------------------------------------------------
# Lesson V11
#------------------------------------------------------------------------------
*:V11
*:_V_S_V11
B:                            Lesson V11

*:_V_R_L68
T:
 :		      (C and Comma)

I:(1) Warmup
*:_V_R_L69
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :fvf jmj fbf jnj fvf jmj fbf jnj fvf jmj fbf jnj
 :
 :The Ben Mavis firm submitted the lowest quotation.

I:(2) New Key Review
*:_V_R_L70
D:c c c c dcd dcd dcd dcd , , , , k,k k,k k,k k,k
 :dcd k,k dcd k,k dcd k,k dcd k,k dcd k,k dcd k,k

I:(3) Word Drill
*:_V_R_L71
D:can, can, can, can, can, cue, cue, cue, cue, cue,
 :can, can, can, can, can, cue, cue, cue, cue, cue,

I:(4)
*:_V_R_L72
D:cash, cash, cash, lack, lack, lack, lace, lace, lace,
 :lack, lack, lack, lace, lace, lace, cash, cash, cash,
 :
 :could, could, could, clerk, clerk, clerk, camp, camp,
 :clerk, clerk, clerk, could, could, could, cane, cane,

I:(5)
*:_V_R_L73
D:If you call before five, the bank will cash your check.
 :Charles Condon, sales manager, was in complete charge.
 :He may, if convenient, have it charged to his account.

I:(6)
*:_V_R_L74
S:Space once after a comma.  Space once after a
 :semicolon.  Space twice after a period that ends a
 :sentence.  Strike each key with the same force.
 :
 :The tabulator is a device which helps you to type faster.
 :It enables you to skip across the page to any point you
 :desire.
 :
 :First, set a tab stop at the point to which you
 :wish the carriage to jump.  Second, move the carriage
 :back to the left margin.  Third, hold the tabulator
 :bar or the tabulator key down until the carriage has
 :stopped.

I:(7)
*:_V_R_L75
D:sub sum see sun set sit sin sip she ship shall shame
 :sit sin sip set sub sum see sod sob slip sweep super
 :
 :won win who why wet was weak wear west well what when
 :was wet why who win won what well wear west when what

I:(8)
*:_V_R_L76
D:lad lid lot let log lie lag lug lip last sate sawn
 :lip lag lug lie log let lot lid lad land lane last
 :
 :own out owl old one oak out oil off over oven open
 :off oil out oak one old owl our own open ours over

G:_V_E_V11

#------------------------------------------------------------------------------
# Lesson V12
#------------------------------------------------------------------------------
*:V12
*:_V_S_V12
B:                            Lesson V12

*:_V_R_L77
T:
 :			(X and .)

I:(1) Warmup
*:_V_R_L78
D:frf juj ftf jyj fgf jhj fvf jmj fbf jnj fvf jmj
 :ded kik sws lol aqa ;p; dcd k,k dcd k,k fvf jmj

I:(2)
*:_V_R_L79
D:touch...learn...above...typing...talent...
 :average...special...that is...You do......
 :You do not

I:(3) Timed Drill:
*:_V_R_L80
S:Touch typing is easy to learn.  You do not need
 :a mind that is above the average.  You do not
 :even need a special talent for typing.

I:(4) New Key Tryout
*:_V_R_L81
D:x x x x sxs sxs sxs sxs . . . . l.l l.l l.l l.l
 :sxs l.l sxs l.l sxs l.l sxs l.l sxs l.l sxs l.l

I:(5) Word Drill
*:_V_R_L82
D:six six six six six six etc. etc. etc. etc. etc.
 :six six six six six six etc. etc. etc. etc. etc.

I:(6)
*:_V_R_L83
D:fixes fixes fixes; mixes mixes mixes; taxes taxes;
 :mixes mixes mixes; fixes fixes fixes; boxes boxes;
 :
 :expert expert expert; expect expect expect; excels;
 :exceed exceed exceed; excuse excuse excuse; excels;
 :
 :Dr. Lux, tax expert, will examine the tax returns.
 :Mr. Cox examined the mixture with extreme care.

I:(7) Practice Paragraph
*:_V_R_L84
S:Mr. Roxbury and Mr. Saxton will examine the six
 :boxes of wax with extreme care.  These boxes were
 :returned by Prof. Maxton of Knoxville College.
 :
 :The Government tax experts were exceedingly
 :careful in examining the current tax receipts.  The
 :amount showed an excess of six million dollars over
 :the previous year.
 :
 :Sixteen boxes of explosives were packed with the
 :most extreme care and shipped by Fox Express Company.
 :These explosives are to be used in secret experiments
 :for the U. S. Government.

I:(8) Drill on A, Q, ;, P
*:_V_R_L85
D:act ant and ask apt any art all age anle acid aged
 :age all art any ask act add axe ant aged able acid
 :
 :quit quip quote quite queer queen quack quaint quorum
 :quip quit quite quote queen queer quail quorum quaint
 :
 :pin pup put; pull palm pant; pint pile push; punch;
 :put pin pup; pant pull palm; push pick pile; paper;

G:_V_E_V12

#------------------------------------------------------------------------------
# Lesson V13
#------------------------------------------------------------------------------
*:V13
*:_V_S_V13
B:                            Lesson V13

*:_V_R_L86
T:
 :			(Z and /)

I:(1) Warmup
*:_V_R_L87
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :fvf jmj fbf jnj dcd k,k sxs l.l dcd k,k sxs l.l

I:(2)
*:_V_R_L88
D:touch...learn...above...typing...talent...average
 :special...lessons...you do...for you...is the
 :do the...of the...in this

I:(3)
*:_V_R_L89
S:Touch typing is easy to learn.  You do not need a
 :mind that is above the average.  You do not even
 :need a special talent for typing.
 :
 :All you need is the will to learn.  The lessons in
 :this book do the rest of the job for you; they
 :make touch typing easy for you to learn.

I:(4) New Key Tryout
*:_V_R_L90
D:z z z z aza aza aza aza / / / / ;/; ;/; ;/; ;/;
 :aza ;/; aza ;/; aza ;/; aza ;/; aza ;/; aza ;/;

I:(5) Word Drill
*:_V_R_L91
D:zip zip zip zip zip c/o c/o c/o c/o c/o c/o
 :zip zip zip zip zip c/o c/o c/o c/o c/o c/o

I:(6)
*:_V_R_L92
S:zest zest zest; lazy lazy lazy; size size size; zeal;
 :zero zero zero; zest zest zest; lazy lazy lazy; zeal;
 :
 :blaze blaze blaze; amaze amaze amaze; zebra zebra;
 :dizzy dizzy dizzy; blaze blaze blaze; amaze amaze;
 :
 :The lazy zebra at the zoo quickly drank the mixture.
 :Ship five dozen boxes of zinc trays by Zale Express.

I:(7)
*:_V_R_L93
S:The slant is controlled by the semicolon finger.
 :It is used in such abbreviations as n/c, which means
 :NO CHARGE; and c/o, which means CARE OF.
 :
 :If you work with zeal and zest, you will soon be a
 :competent typist.  The ability to type well is a
 :very valuable asset.
 :
 :You can develop your typing skill quickly by the proper
 :habits of work.  You should realize that poor work is a
 :mere waste of time.  Try to be exact.
 :
 :Every business firm is dependent on the services of
 :competent typists.  You are now equipping yourself with
 :a skill for which there is a constant demand.

I:(8)
*:_V_R_L94
D:bag big bug bit bud bed bid bun bale bend bank bask
 :but bid bed bun bid big bag bud bask bale band bank
 :
 :not now nut nor note nose none nude noun nine nest
 :now not nor nut nose note nude none nine nest next

I:(9)
*:_V_R_L95
D:vim vet van vex vet vast vote veto vase vine vial
 :van vex vet vim vex vial vine vase veto vote vast
 :
 :man mix mat mad made mail main make mark mask mine
 :mad met mix men mask mark made main male made mint

G:_V_E_V13

#------------------------------------------------------------------------------
# Lesson V14
#------------------------------------------------------------------------------
*:V14
*:_V_S_V14
B:                            Lesson V14

*:_V_R_L96
T:
 :		   (The Question Mark)

I:(1) Warmup
*:_V_R_L97
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :fvf jmj fbf jnj dcd k,k sxs l.l aza ;/; aza ;/;
 :
 :Liza quickly mixed the very big jar of new soap.

I:(2)
*:_V_R_L98
D:touch...learn...above...aside...typing
 :talent...amount...average...special...
 :lessons...definite...is the...of the
 :for you...you do...that is...in this
 :you do not

I:(3)
*:_V_R_L99
S:Touch typing is easy to learn.  You do not need a mind
 :that is above the average.  You do not even need a
 :special talent for typing.
 :
 :All you need is the will to learn.  The lessons in this
 :book do the rest of the job for you; they make touch
 :typing easy for you to learn.
 :
 :Try to set aside each day a definite amount of time for
 :each lesson.

I:(4) New Key Tryout
*:_V_R_L100
D:? ? ? ? ? ? Who?  Who?  Who?  Who?  Who?  Who?
 :? ? ? ? ? ? Why?  Why?  Why?  Why?  Why?  Why?

I:(5)
*:_V_R_L101
D:How much?  How many?  How soon?  How early?  How fast?
 :How many?  How much?  How fast?  How large?  How soon?
 :
 :Where is Max?  Where is Mary?  What is Cora sewing?
 :Where is Sam?  Where is Paul?  What is Zeke fixing?
 :
 :Can Max swim?  Can he dance?  Can he play tennis?
 :Can he dance?  Does he swim?  Do you like tennis?

I:(6)
*:_V_R_L102
D:Did you open the mail?  Did you read the note?
 :Did you read the note?  Did you open the mail?
 :
 :Can Van do the work?  Will he require aid?  Who knows?
 :Can Jim complete it?  Is he quite capable?  Who knows?

I:(7) Practice Paragraph
*:_V_R_L103
S:Do you set aside a definite amount of time each
 :day for practice?  Do you start work promptly?  Can
 :you make the various machine adjustments quickly?
 :
 :Do you keep your fingers curved?  Do you strike each key
 :sharply with the tip of the finger?  Do you keep your eyes
 :on the copy?
 :
 :Do you throw the carriage without looking up?  Do you keep
 :your right hand on the home keys when you throw the carriage?
 :Do you use the paper release to remove your paper?
 :
 :Do you practice the words in which you made errors?  Do you
 :practice them as explained in this book?  Do you follow the
 :instructions exactly as given?

I:(8)
*:_V_R_L104
D:lax vex six tax fix taxed fixing mixing taxing vexing
 :fix tax vex lax six fixed vexing taxing fixing mixing
 :
 :zip zoo zest zeal zinc zero lazy zone zoom zinc zealot
 :zoo zip zoom zone lazy zinc zeal zest zero zone zealot

G:_V_E_V14

#------------------------------------------------------------------------------
# Lesson V15
#------------------------------------------------------------------------------
*:V15
*:_V_S_V15
B:                            Lesson V15

*:_V_R_L105
T:
 :			(1, 4, 5, 6, 7)

I:(1) Warmup
*:_V_R_L106
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :fvf jmj fbf jnj dcd k,k sxs l.l aza ;/; aza ;/;

I:(2)
*:_V_R_L107
D:touch...learn...above...aside...typing
 :talent...amount...follow...easily...become
 :typist...average...special...lessons...definite
 :exactly...quickly...surprised...is the...
 :of the...in the...in this...for you...
 :you will...you will be

I:(3)
*:_V_R_L108
S:Touch typing is easy to learn.  You do not need a
 :mind that is above the average.  You do not even need
 :a special talent for typing.

I:(4)
*:_V_R_L109
S:Touch typing is easy to learn.  You do not need a
 :mind that is above the average.  You do not even need
 :a special talent for typing.
 :
 :All you need is the will to learn.  The lessons in this
 :book do the rest of the job for you; they make touch
 :typing easy for you to learn.
 :
 :Try to set aside each day a definite amount of time for
 :each lesson.  Follow each step in the lesson exactly as
 :given.  You will be surprised how easily and quickly
 :you will become a touch typist.

I:(5) 4 and 7
*:_V_R_L110
D:f4f f4f f4f f4f f4f f4f j7j j7j j7j j7j j7j j7j
 :f4f j7j f4f j7j f4f j7j f4f j7j f4f j7j f4f j7j
 :
 :or 4 or 4 or 4 ru 7 ru 7 ru 7 or 4 ru 7 or 4 ru 7
 :or 4 ru 7 or 4 ru 7 or 4 ru 7 or 4 ru 7 or 4 ru 7

I:(6)
*:_V_R_L111
D:June 1; July 4; April 7; January 4; March 17, 1741
 :July 4; June 1; March 4; October 7; April 14, 1471
 :
 :What is the sum of 11 and 7 and 4 and 1 and 714?
 :What is the sum of 17 and 4 and 7 and 1 and 174?

I:(7)
*:_V_R_L112
D:Florence is 7 years 14 months and 17 days old today.
 :Veronica is 4 years 11 months and 14 days old today.
 :
 :Your order of November 14 was shipped on December 17.
 :Your order of December 11 was shipped on February 14.
 :
 :Policy No. 141174 will expire on Monday, November 14.
 :Policy No. 471714 will expire on Friday, December 17.

I:(8) Practice Paragraph
*:_V_R_L113
S:Henry Clay, American statesman and orator, was
 :born in Hanover County, Virginia, in 1777.
 :
 :On June 14, 1777, John Paul Jones became commander
 :of the American warship, THE RANGER.
 :
 :In April 1777, Lafayette landed at night on the
 :shore of South Carolina to help the colonies.  In
 :July 1777, Congress made Lafayette a general.
 :
 :June 14 is now observed as Flag Day because the
 :flag was adopted by Congress on June 14, 1777.  The
 :house where Betsy Ross, designer of the flag, lived
 :is now preserved as a shrine.

I:(9)
*:_V_R_L114
S:Do not erase.  Do not cross out.  Do not strike
 :one letter over another.  Let your errors stand.
 :Finish every line you start.
 :
 :You correct your typing errors by practicing the
 :words in which you made errors.  You have been doing
 :this in the previous lessons.  Keep right on doing so.
 :That is the best practice for training your fingers
 :to strike the right keys.
 :
 :Try your utmost to turn out attractive work.
 :Take pride in your typing product.

I:(10) 5 and 6
*:_V_R_L115
D:f5f f5f f5f f5f f5f f5f j6j j6j j6j j6j j6j j6j
 :f5f j6j f5f j6j f5f j6j f5f j6j f5f j6j f5f j6j
 :
 :if 5 by 6 if 5 by 6 if 6 by 6 if 5 by 6 if 5 by 6
 :if 5 by 6 if 5 by 6 if 6 by 6 if 5 by 6 if 5 by 6

I:(11)
*:_V_R_L116
D:f4f j7j f5f j6j f4f j7j f5f j6j f4f j7j f5f j6j
 :15 lbs. coffee; 16 doz. eggs; 56 boxes oranges;
 :65 lbs. coffee; 14 doz. eggs; 75 boxes oranges;
 :
 :or 4 ru 7 it 5 my 6 or 4 ru 7 it 5 my 6 147 156
 :The Barton Market is at 516 West 147th Street.
 :The Baxter Market is at 165 East 165th Street.

I:(12)
*:_V_R_L117
D:fr4 ju7 ft5 jy6 f4f j7j f5f j6j f4f j7j f5f j6j
 :Robert Fulton was born in Pennsylvania in 1765.
 :William Penn, English Quaker, was born in 1644.
 :
 :or 4 ru 7 it 5 by 6 or 4 ru 7 it 5 by 6 174 516
 :The sum of 15 and 51 and 65 and 41 and 475 is 647.
 :The sum of 51 and 15 and 56 and 14 and 475 is 611.

I:(13)
*:_V_R_L118
S:On June 15, 1775, George Washington was elected
 :by Congress the Chief Commander of the American forces.
 :He scored a brilliant victory at Trenton on Christmas
 :night, 1776.
 :
 :The Declaration of Independence, a famous state
 :paper, was issued by the American Continental Congress
 :on July 4, 1776.  It was drawn up by Thomas Jefferson.
 :
 :The invasion fleet consisted of 4 battleships, 15 light
 :cruisers, 6 aircraft carriers, 17 troopships, six submarines,
 :and 2 Dr. Strangeloves.  Air protection consisted of 14
 :bombers, 175 fighters, 6 helicopters, and 75 paratroop planes.

G:_V_E_V15

#------------------------------------------------------------------------------
# Lesson V16
#------------------------------------------------------------------------------
*:V16
*:_V_S_V16
B:                            Lesson V16

*:_V_R_L119
T:
 :			(3 and 8)

I:(1) Warmup
*:_V_R_L120
D:f4f j7j f5f j6j f4f j7j f5f j6j f4f j7j f5f j6j
 :417 147 517 157 617 167 617 171 714 471 651 174

I:(2)
*:_V_R_L121
D:never...typing...office...become...getting...
 :acquire...efforts...valuable...personal...
 :possible...business...shorthand...it is...
 :it can...to it...in the...to use...to have
 :if you...from you...why not

I:(3)
*:_V_R_L122
S:Typing is a very valuable skill to acquire.  It is
 :valuable for personal use and as a means of getting
 :an office job.

I:(4)
*:_V_R_L123
S:Typing is a very valuable skill to acquire.  It is
 :valuable for personal use and as a means of getting
 :an office job.  This skill is yours to use; it can
 :never be taken from you.
 :
 :So why not put forth your best efforts to become a
 :good typist?  You can become a good typist if you
 :put your mind to it.  You should also, if possible,
 :learn shorthand.  Typing and shorthand are two very
 :valuable skills to have.
 :
 :These two skills will help you get a good start
 :in the business world.

I:(5) New Key Tryout
*:_V_R_L124
D:d3d k8k d3d k8k d3d k8k d3d k8k d3d k8k d3d k8k
 :131 313 311 181 818 381 381 381 183 138 318 813
 :
 :bid 3 bid 3 bid 3 bid 3 oak 8 oak 8 oak 8 oak 8
 :bid 3 bid 3 bid 3 bid 3 oak 8 oak 8 oak 8 oak 8

I:(6)
*:_V_R_L125
D:d3d k8k d3d k8k d3d k8k d3d k8k 318 813 138 813 381
 :13 lbs. lamb roast; 38 lbs. lamb chops; 8 lbs. bananas;
 :31 lbs. lamb chops; 83 lbs. lamb roast; 3 lbs. peaches;
 :
 :lie 3 dye 3 pie 3 dye 3 Fiji 8 Fiji 8 Fiji 8
 :18 cans grape juice; 138 cans prune juice; 4 lbs. coffee;
 :47 cans prune juice; 143 cans grape juice; 8 lbs. onions;

I:(7)
*:_V_R_L126
D:d3d k8k d3d k8k d3d k8k 183 381 813 318 138 381
 :8 lbs. Swiss Cheese; 13 lbs. Kraft Cheese; 4 lbs. pears;
 :5 lbs. Kraft Cheese; 17 lbs. Swiss Cheese; 6 lbs. beans;
 :
 :pie 3 dye 3 pie 3 dye 3 Fiji 8 Fiji 8 Fiji 8 Fiji 8
 :The sum of 13 and 83 and 153 and 75 and 47 is 371.
 :The sum of 47 and 75 and 153 and 83 and 13 is 371.

I:(8) Practice Paragraph
*:_V_R_L127
S:John Jacob Astor was born in 1763 and died in
 :1848.  He came to America from England in 1784 and
 :set up a prosperous fur trade.  In 1811 he founded
 :the settlement of Astoria near the mouth of the
 :Columbia River.
 :
 :Alexander Graham Bell was born in Scotland on
 :March 3, 1847.  He invented the telephone in 1876.
 :The Bell Telephone Company was organized in 1877.
 :Mr. Bell also invented the gramophone in 1887.
 :
 :John Quincy Adams, sixth President of the
 :United States, was born in Massachusetts on July 11,
 :1767.  In 1817 he was appointed Secretary of State.
 :He died in 1848.
 :
 :Oliver Wendell Holmes, American jurist, was born
 :in Massachusetts on March 8, 1841; graduated from
 :Harvard in 1861; from Harvard Law School in 1866;
 :admitted to the Massachusetts Bar in 1867.

G:_V_E_V16

#------------------------------------------------------------------------------
# Lesson V17
#------------------------------------------------------------------------------
*:V17
*:_V_S_V17
B:                            Lesson V17

*:_V_R_L128
T:
 :			(2 and 9)

I:(1) Warmup
*:_V_R_L129
D:f4f j7j f5f j6j d3d k8k f4f j7j f5f j6j d3d k8k
 :or4 ru7 it5 by6 ie3 ok8 or4 ru7 it5 by6 ie3 ok8
 :
 :The sum of 14 and 16 and 53 and 58 and 174 is 315.

I:(2)
*:_V_R_L130
D:strike...center...finger...spring...though...
 :expert...sharply...release...quickly...develop...
 :letting...squarely...practice...familiar...
 :fingertip...important...technique...releasing...
 :instantly...it is...do it...do this...with the...
 :you get.

I:(3)
*:_V_R_L131
S:Strike each key sharply with the fingertip and squarely
 :in the center.  Strike the key quickly, letting the
 :finger spring back as though the key were red hot.

I:(4)
*:_V_R_L132
S:Strike each key sharply with the fingertip and squarely
 :in the center.  Strike the key quickly, letting the
 :finger spring back as though the key were red hot.

*:_V_R_L133
S:
 :To type fast, it is just as important to release the
 :key quickly as it is to strike it quickly.  Expert
 :typists do this; you too, can do it, with practice.
 :
 :One good way to develop this technique is to practice
 :familiar words and phrases.  Type them over and over
 :again until you get the knack of hitting the keys quickly
 :and releasing the fingers instantly.

I:(5) New Key Tryout
*:_V_R_L134
D:s2s s2s s2s s2s s2s s2s l9l l9l l9l l9l l9l l9l
 :s2s l9l s2s l9l s2s l9l s2s l9l s2s l9l s2s l9l
 :
 :bow 2 bow 2 bow 2 bow 2 two 9 two 9 two 9 two 9
 :bow 2 two 9 bow 2 two 9 bow 2 two 9 bow 2 two 9

I:(6)
*:_V_R_L135
D:s2s l9l s2s l9l s2s l9l s2s l9l s2s l9l s2s l9l s2s l9l
 :12 lbs. coffee; 19 lbs. Cottage Cheese; 9 lbs. peaches;
 :19 lbs. apples; 29 lbs. Cheddar Cheese; 2 lbs. bananas;
 :
 :low 2 fro 9 low 2 fro 9 low 2 fro 9 low 2 fro 9 29 192;
 :9 lbs. Smoked Tongue; 2 lbs. tomatoes; 9 lbs. avocados;
 :2 lbs. Cooked Tongue; 9 lbs. avocados; 2 lbs. tomatoes;

I:(7)
*:_V_R_L136
D:s2s l9l s2s l9l 219 921 192 s2s l9l s2s 191 291 129
 :The sum of 29 and 86 and 33 and 92 and 52 is 292.
 :The sum of 52 and 92 and 86 and 33 and 29 is 292.
 :
 :ow 2 to 9 ow 2 to 9 we 23 ok 98 we 23 ok 98 s2s l9l
 :George Washington was born on February 22, 1732.
 :Horatio Alger was born in 1834 and died in 1899.

I:(8)
*:_V_R_L137
S:Christopher Latham Sholes was the inventor of the first practical
 :typewriter.  He was born in Columbia County, Pennsylvania,
 :February 14, 1819.
 :
 :James Monroe, fifth President of The United States, was born on
 :April 28, 1758.  In 1782 he entered politics.  In 1799 he was appointed
 :Governor of Virginia.  In 1811 he became Secretary of State; in 1814,
 :Secretary of War; in 1816, President of The United States.
 :
 :On September 1, 1939, Germany launched undeclared war on Poland.
 :On September 3, 1939, Great Britain declared war on Germany.  On
 :December 8, 1941, The United States declared war against the Axis.
 :
 :Samuel F. B. Morse, inventor and artist, was born in 1791 and died in
 :1872.  In 1829 he went to Europe for three years.  For 12 years he
 :worked on perfecting the electrical telegraph, which was exhibited at New
 :York University in 1837.

G:_V_E_V17

#------------------------------------------------------------------------------
# Lesson V18
#------------------------------------------------------------------------------
*:V18
*:_V_S_V18
B:                            Lesson V18

*:_V_R_L138
T:
 :		    (0 and the Hyphen)

I:(1) Warmup
*:_V_R_L139
D:f4f j7j f5f j6j d3d k8k s2s l9l f4f j7j f5f j6j
 :s2s l9l d3d k8k f4f j7j f5f j6j f4f j7j f5f j6j
 :
 :The sum of 47 and 65 and 38 and 92 and 16 equals 258.

I:(2)
*:_V_R_L140
D:expert...typing...margin...always...before...
 :permits...others...reached...equipped...machines...
 :carriage...typewriter...approaching...you are...
 :of the...for the...on the...you may...before the

I:(3)
*:_V_R_L141
S:Your typewriter is equipped with a bell which
 :rings to warn you that you are approaching the end
 :of the line

I:(4)
*:_V_R_L142
S:Your typewriter is equipped with a bell which rings
 :to warn you that you are approaching the end of the
 :line.
 :
 :On some machines, the bell rings five spaces before
 :the margin stop is reached; on other machines, it
 :rings when there are six or seven spaces left.
 :
 :The ring of the bell permits you to keep your eyes
 :on the copy.  When you hear the bell, finish the
 :word you are typing and throw the carriage for the
 :next line.
 :
 :Do not look up to watch for the end of the line; you
 :may lose your place in the copy.  Always keep your
 :eyes on the copy like the expert typist.

I:(5) New Key Tryout
*:_V_R_L143
D:;0; ;0; ;0; ;0; ;0; ;0; ;-; ;-; ;-; ;-; ;-; ;-;
 :;0; ;-; ;0; ;-; ;0; ;-; ;0; ;-; ;0; ;-; ;0; ;-;
 :
 :10-room; 10-room; 10-room; 10-room; 10-room;
 :20-room; 20-room; 20-room; 20-room; 20-room;

I:(6)
*:_V_R_L144
D:f4f j7j f5f j6j d3d k8k s2s l9l ;0; ;-; ;0; ;-;
 :one-half; one-fourth; one-eighth; three-quarters;
 :one-half; two-thirds; one-fourth; three-sevenths;
 :
 :f4f j7j f5f j6j d3d k8k s2s l9l ;0; ;-; ;0; ;-;
 :20-room house; 30-room house; 40-room house;
 :50-room house; 60-room house; 70-room house;

I:(7)
*:_V_R_L145
D:f4f j7j f5f j6j d3d k8k s2s l9l ;0; ;-; ;0; ;-;
 :One-fourth may be typewritten like this:  1/4.
 :One-eighth may be typewritten like this:  1/8.
 :
 :f4f j7j f5f j6j d3d k8k s2s l9l ;0; ;-; ;0; ;-;
 :Every expert was once a beginner--with ambition.
 :Every expert was once a beginner--with ambition.

I:(8)
*:_V_R_L146
S:As you have seen in the above sentence practice, the hyphen is used
 :for typing compound words.  Here are a few more examples:  up-to-date,
 :first-class, by-product.
 :
 :The hyphen is used also to divide words between syllables at the end
 :of a line.  When the bell rings, finish the word if it is short--less
 :than six letters.  If the word is longer, divide it at the end of a syllable.
 :
 :The hyphens in the following words show where they could be divided
 :at the end of a line:  after-noon, state-ment, hesi-tate, cer-ti-fi-
 :cate, exami-na-tion.
 :
 :The sum of 10 and 20 and 30 and 40 and 50 and 60 and 70 and 80 and 90
 :and 100 and 105 and 106 and 107 and 108 and 109 and 110 equals 1,195.

I:(9)
*:_V_R_L147
S:Have you seen the new 7-room house at 175 West
 :239th Street?  It is equipped with every up-to-date,
 :labor-saving device for the home.  You may inspect
 :it free of charge any day except Sunday between
 :10 a.m. and 4 p.m.

G:_V_E_V18

#------------------------------------------------------------------------------
# Lesson V19
#------------------------------------------------------------------------------
*:V19
*:_V_S_V19
B:                            Lesson V19

I:(1) Warmup
*:_V_R_L149
D:f4f j7j f5f j6j d3d k8k s2s l9l ;0; ;-; ;0; ;-;
 :s2s l9l ;-; ;=; d3d k8k f4f j7j ;0; ;-; ;0; ;-;
 :
 :Max Zale made a long-distance flight of 2,590 miles.

I:(2)
*:_V_R_L150
D:called...fourth...typing...letter...always...
 :capital...holding...depress...fingers...release...
 :touching...slightly...position...right-hand...of the
 :for the...all the...with the...you have

I:(3)
*:_V_R_L151
S:You type capital letters by holding down a key
 :called the shift key while you strike the letter key.

I:(4)
*:_V_R_L152
S:You type capital letters by holding down a key
 :called the shift key while you strike the letter key.
 :
 :There are two shift keys.  Hold down the left
 :shift key for typing right-hand capitals; hold down
 :the right shift key for typing left-hand capitals.
 :Always use the fourth finger for the shift key.
 :
 :Keep your wrists low but not touching the frame
 :of the machine.  Raise the other fingers slightly as
 :you depress the shift key with the fourth finger.
 :
 :Be sure that you hold the shift key all the way
 :down until you have struck the letter key; then re-
 :lease the shift key and return finger to home base.

I:(5)
*:_V_R_L153
S:Prepare a bill for the following items:  29 lbs. butter
 :@ $0.895; 36 doz. eggs @ $0.695;  28 doz. oranges
 :@ $0.575; 15 bu. potatoes @ $0.795.
 :
 :Our company ordered 15 Ajax Pencil Sharpeners at
 :$0.98; 6 doz. Circular Rubber Erasers at $.43; 24 No.  68
 :Spiral Stenographic Notebooks at $.075.
 :
 :Deliver the following order to Mrs. Beverly
 :Vinson at 390 West 135th Street, New York City:  2 lbs.
 :Temple Oranges at $.135; 3 lbs. Red Circle Coffee at
 :$.91; 2 lbs. Lima Beans at $.29.
 :
 :The Johnston Hardware Company, Toledo, Ohio has
 :ordered the following supplies:  15 Pruning Shears,
 :10-inch, at $.795; 24 Steel Rakes, 14-inch, at $.815;
 :16 Steel Spades, D-Handle, at $.935.

I:(6)
*:_V_R_L154
S:The backspace key is one of the most useful time-
 :saving devices on your typewriter.  You use it to back
 :up a space, to darken a light impression, or to pivot.
 :To pivot means to type a line so that the last letter
 :is at the right margin or other chosen point.
 :
 :For example, if you want a date line to end at the
 :right margin, place the carriage with the printing point
 :indicator at the right margin and backspace once for
 :each stroke in the date line.
 :
 :The most important use of the backspace key is in
 :centering words or lines.

G:_V_E_V19

#------------------------------------------------------------------------------
# Lesson series V jump tables
#------------------------------------------------------------------------------
*:_V_E_V1
Q: Do you want to continue to lesson V2 [Y/N] ? 
N:_V_MENU
G:_V_S_V2
*:_V_E_V2
Q: Do you want to continue to lesson V3 [Y/N] ? 
N:_V_MENU
G:_V_S_V3
*:_V_E_V3
Q: Do you want to continue to lesson V4 [Y/N] ? 
N:_V_MENU
G:_V_S_V4
*:_V_E_V4
Q: Do you want to continue to lesson V5 [Y/N] ? 
N:_V_MENU
G:_V_S_V5
*:_V_E_V5
Q: Do you want to continue to lesson V6 [Y/N] ? 
N:_V_MENU
G:_V_S_V6
*:_V_E_V6
Q: Do you want to continue to lesson V7 [Y/N] ? 
N:_V_MENU
G:_V_S_V7
*:_V_E_V7
Q: Do you want to continue to lesson V8 [Y/N] ? 
N:_V_MENU
G:_V_S_V8
*:_V_E_V8
Q: Do you want to continue to lesson V9 [Y/N] ? 
N:_V_MENU
G:_V_S_V9
*:_V_E_V9
Q: Do you want to continue to lesson V10 [Y/N] ? 
N:_V_MENU
G:_V_S_V10
*:_V_E_V10
Q: Do you want to continue to lesson V11 [Y/N] ? 
N:_V_MENU
G:_V_S_V11
*:_V_E_V11
Q: Do you want to continue to lesson V12 [Y/N] ? 
N:_V_MENU
G:_V_S_V12
*:_V_E_V12
Q: Do you want to continue to lesson V13 [Y/N] ? 
N:_V_MENU
G:_V_S_V13
*:_V_E_V13
Q: Do you want to continue to lesson V14 [Y/N] ? 
N:_V_MENU
G:_V_S_V14
*:_V_E_V14
Q: Do you want to continue to lesson V15 [Y/N] ? 
N:_V_MENU
G:_V_S_V15
*:_V_E_V15
Q: Do you want to continue to lesson V16 [Y/N] ? 
N:_V_MENU
G:_V_S_V16
*:_V_E_V16
Q: Do you want to continue to lesson V17 [Y/N] ? 
N:_V_MENU
G:_V_S_V17
*:_V_E_V17
Q: Do you want to continue to lesson V18 [Y/N] ? 
N:_V_MENU
G:_V_S_V18
*:_V_E_V18
Q: Do you want to continue to lesson V19 [Y/N] ? 
N:_V_MENU
G:_V_S_V19
*:_V_E_V19
G:_V_MENU

#------------------------------------------------------------------------------
# Lesson series V menu
#------------------------------------------------------------------------------
*:_V_MENU
B:                    Yet more QWERTY lessons
M: UP=_EXIT "The V series contains the following 19 lessons"
 :_V_S_V1  "Lesson V1     R F U J"
 :_V_S_V2  "Lesson V2     D K E I"
 :_V_S_V3  "Lesson V3     T Y G H"
 :_V_S_V4  "Lesson V4     S L W O"
 :_V_S_V5  "Lesson V5     A ; Q P"
 :_V_S_V6  "Lesson V6     Shift Keys for Capitalization"
 :_V_S_V7  "Lesson V7     Shift Lock and :"
 :_V_S_V8  "Lesson V8     Introducing the Period"
 :_V_S_V9  "Lesson V9     V and M"
 :_V_S_V10 "Lesson V10    B and N"
 :_V_S_V11 "Lesson V11    C and Comma"
 :_V_S_V12 "Lesson V12    X and ."
 :_V_S_V13 "Lesson V13    Z and /"
 :_V_S_V14 "Lesson V14    The Question Mark"
 :_V_S_V15 "Lesson V15    1, 4, 5, 6, 7"
 :_V_S_V16 "Lesson V16    3 and 8"
 :_V_S_V17 "Lesson V17    2 and 9"
 :_V_S_V18 "Lesson V18    0 and the Hyphen"
 :_V_S_V19 "Lesson V19    Practise"
G:_V_EXIT
*:_V_EXIT
#------------------------------------------------------------------------------
