## Check for options compiler supports.  This file is in public domain.
##
AC_DEFUN([GWY_PROG_CC_OPTION],
[AC_REQUIRE([AC_PROG_CC])dnl
dnl

dnl Check whether C compiler accepts option $2, set GWY_PROG_CC_$1 to either
dnl the option or empty.  On success, $3 is executed, on failure, $4.
dnl
dnl We must pass -Wno-blah as -Wblah because gcc does not fail when we attempt
dnl to switch off unknown warnings.
dnl
dnl We must also add -Werror because clang otherwise never returns non-zero
dnl status anyway.
AC_CACHE_CHECK([whether $CC knows $2],
  [ac_cv_prog_cc_option_$1],
  [GWY_PROG_CC_OPTION_cflags="$CFLAGS"
   positive_flag=$(echo x$2 | sed -e 's/^x-Wno-/x-W/' -e 's/^x//')
   CFLAGS="$CFLAGS -Werror $positive_flag"
   AC_COMPILE_IFELSE([AC_LANG_PROGRAM()],
     [ac_cv_prog_cc_option_$1=yes],
     [ac_cv_prog_cc_option_$1=no])
   CFLAGS="$GWY_PROG_CC_OPTION_cflags"])
if test "x$ac_cv_prog_cc_option_$1" = xyes; then
  GWY_PROG_CC_$1="$2"
  $3
else
  GWY_PROG_CC_$1=
  $4
fi
])

dnl Check if the compiler supports the specified option and add it to CFLAGS.
AC_DEFUN([GWY_CHECK_PROG_CC_OPTION],
[AC_MSG_CHECKING([whether $CC knows $1])
GWY_PROG_CC_OPTION_cflags="$CFLAGS"
CFLAGS="$CFLAGS $1"
AC_COMPILE_IFELSE([AC_LANG_PROGRAM()],
  [AC_MSG_RESULT([yes])
   $2],
  [AC_MSG_RESULT([no])])
CFLAGS="$GWY_PROG_CC_OPTION_cflags"
])

dnl Check which options the compiler supports and add them to GWY_PROG_CC_$1.
dnl
dnl Unfortunately, in order to use GWY_PROG_CC_OPTION with a dummy target
dnl variable we have to get rid of caching by unsetting the cached values
dnl manually. Otherwise it would use the first result for all options.
AC_DEFUN([GWY_PROG_CC_OPTIONS],
[AC_REQUIRE([AC_PROG_CC])dnl
m4_foreach_w([gwy_cc_opt],[$2],
  [unset ac_cv_prog_cc_option_tmp
   GWY_PROG_CC_OPTION([tmp],gwy_cc_opt,[GWY_PROG_CC_$1="$GWY_PROG_CC_$1 $GWY_PROG_CC_tmp"])])
])
