/* Generated by wayland-scanner 1.23.1 */

#ifndef UKUI_SHELL_V1_CLIENT_PROTOCOL_H
#define UKUI_SHELL_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_ukui_shell_v1 The ukui_shell_v1 protocol
 * @section page_ifaces_ukui_shell_v1 Interfaces
 * - @subpage page_iface_ukui_shell_v1 - create ukui shell surfaces and helpers
 * - @subpage page_iface_ukui_surface_v1 - metadata interface
 * - @subpage page_iface_ukui_decoration_v1 - metadata interface
 * @section page_copyright_ukui_shell_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2024 KylinSoft Co., Ltd.
 *
 * SPDX-License-Identifier: MulanPSL-2.0
 *
 * </pre>
 */
struct ukui_decoration_v1;
struct ukui_shell_v1;
struct ukui_surface_v1;
struct wl_seat;
struct wl_surface;

#ifndef UKUI_SHELL_V1_INTERFACE
#define UKUI_SHELL_V1_INTERFACE
/**
 * @page page_iface_ukui_shell_v1 ukui_shell_v1
 * @section page_iface_ukui_shell_v1_desc Description
 *
 * This interface is used by UKUI Wayland shells to communicate with the compositor and
 * can only be bound one time.
 * @section page_iface_ukui_shell_v1_api API
 * See @ref iface_ukui_shell_v1.
 */
/**
 * @defgroup iface_ukui_shell_v1 The ukui_shell_v1 interface
 *
 * This interface is used by UKUI Wayland shells to communicate with the compositor and
 * can only be bound one time.
 */
extern const struct wl_interface ukui_shell_v1_interface;
#endif
#ifndef UKUI_SURFACE_V1_INTERFACE
#define UKUI_SURFACE_V1_INTERFACE
/**
 * @page page_iface_ukui_surface_v1 ukui_surface_v1
 * @section page_iface_ukui_surface_v1_desc Description
 *
 * An interface that may be implemented by a wl_surface, for implementations that provide the
 * shell user interface.
 *
 * It provides requests to set surface roles, assign an output or set the position in output
 * coordinates.
 *
 * On the server side the object is automatically destroyed when the related wl_surface is
 * destroyed. On client side, ukui_surface_v1.destroy() must be called before destroying the
 * wl_surface object.
 * @section page_iface_ukui_surface_v1_api API
 * See @ref iface_ukui_surface_v1.
 */
/**
 * @defgroup iface_ukui_surface_v1 The ukui_surface_v1 interface
 *
 * An interface that may be implemented by a wl_surface, for implementations that provide the
 * shell user interface.
 *
 * It provides requests to set surface roles, assign an output or set the position in output
 * coordinates.
 *
 * On the server side the object is automatically destroyed when the related wl_surface is
 * destroyed. On client side, ukui_surface_v1.destroy() must be called before destroying the
 * wl_surface object.
 */
extern const struct wl_interface ukui_surface_v1_interface;
#endif
#ifndef UKUI_DECORATION_V1_INTERFACE
#define UKUI_DECORATION_V1_INTERFACE
/**
 * @page page_iface_ukui_decoration_v1 ukui_decoration_v1
 * @section page_iface_ukui_decoration_v1_desc Description
 *
 * It provides requests to set surface need to draw corner/shadow/border or not.
 *
 * On the server side the object is automatically destroyed when the related wl_surface is
 * destroyed. On client side, ukui_decoration_v1.destroy() must be called before destroying the
 * wl_surface object.
 * @section page_iface_ukui_decoration_v1_api API
 * See @ref iface_ukui_decoration_v1.
 */
/**
 * @defgroup iface_ukui_decoration_v1 The ukui_decoration_v1 interface
 *
 * It provides requests to set surface need to draw corner/shadow/border or not.
 *
 * On the server side the object is automatically destroyed when the related wl_surface is
 * destroyed. On client side, ukui_decoration_v1.destroy() must be called before destroying the
 * wl_surface object.
 */
extern const struct wl_interface ukui_decoration_v1_interface;
#endif

#ifndef UKUI_SHELL_V1_ERROR_ENUM
#define UKUI_SHELL_V1_ERROR_ENUM
enum ukui_shell_v1_error {
	/**
	 * surface has wl_surface object associated
	 */
	UKUI_SHELL_V1_ERROR_SURFACE_EXISTS = 0,
	/**
	 * decoration has wl_surface object associated
	 */
	UKUI_SHELL_V1_ERROR_DECORATION_EXISTS = 1,
	/**
	 * wl_surface object already mapped
	 */
	UKUI_SHELL_V1_ERROR_MAPPED = 2,
};
#endif /* UKUI_SHELL_V1_ERROR_ENUM */

/**
 * @ingroup iface_ukui_shell_v1
 * @struct ukui_shell_v1_listener
 */
struct ukui_shell_v1_listener {
	/**
	 * send the output name under cursor
	 *
	 * Emitted after bind ukui_shell or receive get_current_output
	 * request.
	 * @param output_name name of current output
	 * @param seat_name seat name of cursor under output
	 */
	void (*current_output)(void *data,
			       struct ukui_shell_v1 *ukui_shell_v1,
			       const char *output_name,
			       const char *seat_name);
	/**
	 * sent all output and seat info completely
	 *
	 * This event is sent after all information have been sent on
	 * binding to the ukui shell object.
	 */
	void (*done)(void *data,
		     struct ukui_shell_v1 *ukui_shell_v1);
};

/**
 * @ingroup iface_ukui_shell_v1
 */
static inline int
ukui_shell_v1_add_listener(struct ukui_shell_v1 *ukui_shell_v1,
			   const struct ukui_shell_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) ukui_shell_v1,
				     (void (**)(void)) listener, data);
}

#define UKUI_SHELL_V1_CREATE_SURFACE 0
#define UKUI_SHELL_V1_GET_CURRENT_OUTPUT 1
#define UKUI_SHELL_V1_CREATE_DECORATION 2

/**
 * @ingroup iface_ukui_shell_v1
 */
#define UKUI_SHELL_V1_CURRENT_OUTPUT_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_shell_v1
 */
#define UKUI_SHELL_V1_DONE_SINCE_VERSION 1

/**
 * @ingroup iface_ukui_shell_v1
 */
#define UKUI_SHELL_V1_CREATE_SURFACE_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_shell_v1
 */
#define UKUI_SHELL_V1_GET_CURRENT_OUTPUT_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_shell_v1
 */
#define UKUI_SHELL_V1_CREATE_DECORATION_SINCE_VERSION 1

/** @ingroup iface_ukui_shell_v1 */
static inline void
ukui_shell_v1_set_user_data(struct ukui_shell_v1 *ukui_shell_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ukui_shell_v1, user_data);
}

/** @ingroup iface_ukui_shell_v1 */
static inline void *
ukui_shell_v1_get_user_data(struct ukui_shell_v1 *ukui_shell_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ukui_shell_v1);
}

static inline uint32_t
ukui_shell_v1_get_version(struct ukui_shell_v1 *ukui_shell_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) ukui_shell_v1);
}

/** @ingroup iface_ukui_shell_v1 */
static inline void
ukui_shell_v1_destroy(struct ukui_shell_v1 *ukui_shell_v1)
{
	wl_proxy_destroy((struct wl_proxy *) ukui_shell_v1);
}

/**
 * @ingroup iface_ukui_shell_v1
 *
 * Create a shell surface for an existing surface.
 *
 * Only one shell surface can be associated with a given surface.
 * This request needs be called before surface map.
 */
static inline struct ukui_surface_v1 *
ukui_shell_v1_create_surface(struct ukui_shell_v1 *ukui_shell_v1, struct wl_surface *surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) ukui_shell_v1,
			 UKUI_SHELL_V1_CREATE_SURFACE, &ukui_surface_v1_interface, wl_proxy_get_version((struct wl_proxy *) ukui_shell_v1), 0, NULL, surface);

	return (struct ukui_surface_v1 *) id;
}

/**
 * @ingroup iface_ukui_shell_v1
 *
 * Request get the output under cursor.
 *
 * Send current_output and done event after this request.
 */
static inline void
ukui_shell_v1_get_current_output(struct ukui_shell_v1 *ukui_shell_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_shell_v1,
			 UKUI_SHELL_V1_GET_CURRENT_OUTPUT, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_shell_v1), 0);
}

/**
 * @ingroup iface_ukui_shell_v1
 *
 * Create a shell decoration for an existing surface.
 *
 * Only one shell decoration can be associated with a given surface.
 * This request needs be called before surface map.
 */
static inline struct ukui_decoration_v1 *
ukui_shell_v1_create_decoration(struct ukui_shell_v1 *ukui_shell_v1, struct wl_surface *surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) ukui_shell_v1,
			 UKUI_SHELL_V1_CREATE_DECORATION, &ukui_decoration_v1_interface, wl_proxy_get_version((struct wl_proxy *) ukui_shell_v1), 0, NULL, surface);

	return (struct ukui_decoration_v1 *) id;
}

#ifndef UKUI_SURFACE_V1_ERROR_ENUM
#define UKUI_SURFACE_V1_ERROR_ENUM
enum ukui_surface_v1_error {
	/**
	 * wl_surface object already mapped
	 */
	UKUI_SURFACE_V1_ERROR_MAPPED = 0,
};
#endif /* UKUI_SURFACE_V1_ERROR_ENUM */

#ifndef UKUI_SURFACE_V1_ROLE_ENUM
#define UKUI_SURFACE_V1_ROLE_ENUM
enum ukui_surface_v1_role {
	UKUI_SURFACE_V1_ROLE_NORMAL = 0,
	UKUI_SURFACE_V1_ROLE_DESKTOP = 1,
	UKUI_SURFACE_V1_ROLE_PANEL = 2,
	UKUI_SURFACE_V1_ROLE_ONSCREENDISPLAY = 3,
	UKUI_SURFACE_V1_ROLE_NOTIFICATION = 4,
	UKUI_SURFACE_V1_ROLE_TOOLTIP = 5,
	UKUI_SURFACE_V1_ROLE_CRITICALNOTIFICATION = 6,
	UKUI_SURFACE_V1_ROLE_APPLETPOPUP = 7,
	UKUI_SURFACE_V1_ROLE_SCREENLOCK = 8,
	UKUI_SURFACE_V1_ROLE_WATERMARK = 9,
	UKUI_SURFACE_V1_ROLE_SYSTEMWINDOW = 10,
	UKUI_SURFACE_V1_ROLE_INPUTPANEL = 11,
	UKUI_SURFACE_V1_ROLE_LOGOUT = 12,
	UKUI_SURFACE_V1_ROLE_SCREENLOCKNOTIFICATION = 13,
	UKUI_SURFACE_V1_ROLE_SWITCHER = 14,
	UKUI_SURFACE_V1_ROLE_AUTHENTICATION = 15,
};
#endif /* UKUI_SURFACE_V1_ROLE_ENUM */

#ifndef UKUI_SURFACE_V1_STATE_ENUM
#define UKUI_SURFACE_V1_STATE_ENUM
enum ukui_surface_v1_state {
	UKUI_SURFACE_V1_STATE_MINIMIZABLE = 0x1,
	UKUI_SURFACE_V1_STATE_MAXIMIZABLE = 0x2,
	UKUI_SURFACE_V1_STATE_CLOSEABLE = 0x4,
	UKUI_SURFACE_V1_STATE_FULLSCREENABLE = 0x8,
	UKUI_SURFACE_V1_STATE_MOVABLE = 0x10,
	UKUI_SURFACE_V1_STATE_RESIZABLE = 0x20,
	UKUI_SURFACE_V1_STATE_FOCUSABLE = 0x40,
	UKUI_SURFACE_V1_STATE_ACTIVATABLE = 0x80,
	UKUI_SURFACE_V1_STATE_KEEP_ABOVE = 0x100,
	UKUI_SURFACE_V1_STATE_KEEP_BELOW = 0x200,
};
#endif /* UKUI_SURFACE_V1_STATE_ENUM */

/**
 * @ingroup iface_ukui_surface_v1
 * @struct ukui_surface_v1_listener
 */
struct ukui_surface_v1_listener {
	/**
	 * informs of a new position for the surface
	 *
	 * This event informs the client that the position of the surface
	 * is about to change.
	 * @param x the horizontal position of the surface
	 * @param y the vertical position of the surface
	 */
	void (*position)(void *data,
			 struct ukui_surface_v1 *ukui_surface_v1,
			 int32_t x,
			 int32_t y);
};

/**
 * @ingroup iface_ukui_surface_v1
 */
static inline int
ukui_surface_v1_add_listener(struct ukui_surface_v1 *ukui_surface_v1,
			     const struct ukui_surface_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) ukui_surface_v1,
				     (void (**)(void)) listener, data);
}

#define UKUI_SURFACE_V1_DESTROY 0
#define UKUI_SURFACE_V1_SET_POSITION 1
#define UKUI_SURFACE_V1_SET_SKIP_TASKBAR 2
#define UKUI_SURFACE_V1_SET_SKIP_SWITCHER 3
#define UKUI_SURFACE_V1_SET_ROLE 4
#define UKUI_SURFACE_V1_SET_STATE 5
#define UKUI_SURFACE_V1_SET_PANEL_AUTO_HIDE 6
#define UKUI_SURFACE_V1_OPEN_UNDER_CURSOR 7
#define UKUI_SURFACE_V1_GRAB_KEYBOARD 8
#define UKUI_SURFACE_V1_SET_ICON 9
#define UKUI_SURFACE_V1_ACTIVATE 10
#define UKUI_SURFACE_V1_SET_STARTUP_GEOMETRY 11
#define UKUI_SURFACE_V1_SHOW_TILE_FLYOUT 12

/**
 * @ingroup iface_ukui_surface_v1
 */
#define UKUI_SURFACE_V1_POSITION_SINCE_VERSION 1

/**
 * @ingroup iface_ukui_surface_v1
 */
#define UKUI_SURFACE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_surface_v1
 */
#define UKUI_SURFACE_V1_SET_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_surface_v1
 */
#define UKUI_SURFACE_V1_SET_SKIP_TASKBAR_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_surface_v1
 */
#define UKUI_SURFACE_V1_SET_SKIP_SWITCHER_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_surface_v1
 */
#define UKUI_SURFACE_V1_SET_ROLE_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_surface_v1
 */
#define UKUI_SURFACE_V1_SET_STATE_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_surface_v1
 */
#define UKUI_SURFACE_V1_SET_PANEL_AUTO_HIDE_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_surface_v1
 */
#define UKUI_SURFACE_V1_OPEN_UNDER_CURSOR_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_surface_v1
 */
#define UKUI_SURFACE_V1_GRAB_KEYBOARD_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_surface_v1
 */
#define UKUI_SURFACE_V1_SET_ICON_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_surface_v1
 */
#define UKUI_SURFACE_V1_ACTIVATE_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_surface_v1
 */
#define UKUI_SURFACE_V1_SET_STARTUP_GEOMETRY_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_surface_v1
 */
#define UKUI_SURFACE_V1_SHOW_TILE_FLYOUT_SINCE_VERSION 1

/** @ingroup iface_ukui_surface_v1 */
static inline void
ukui_surface_v1_set_user_data(struct ukui_surface_v1 *ukui_surface_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ukui_surface_v1, user_data);
}

/** @ingroup iface_ukui_surface_v1 */
static inline void *
ukui_surface_v1_get_user_data(struct ukui_surface_v1 *ukui_surface_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ukui_surface_v1);
}

static inline uint32_t
ukui_surface_v1_get_version(struct ukui_surface_v1 *ukui_surface_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) ukui_surface_v1);
}

/**
 * @ingroup iface_ukui_surface_v1
 *
 * The ukui_surface_v1 interface is removed from the wl_surface object that was turned into a
 * shell surface with the ukui_shell_v1.get_surface request. The shell surface role is lost
 * and wl_surface is unmapped.
 */
static inline void
ukui_surface_v1_destroy(struct ukui_surface_v1 *ukui_surface_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_surface_v1,
			 UKUI_SURFACE_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_surface_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_ukui_surface_v1
 *
 * Move the surface to new coordinates. Coordinates are global.
 */
static inline void
ukui_surface_v1_set_position(struct ukui_surface_v1 *ukui_surface_v1, int32_t x, int32_t y)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_surface_v1,
			 UKUI_SURFACE_V1_SET_POSITION, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_surface_v1), 0, x, y);
}

/**
 * @ingroup iface_ukui_surface_v1
 *
 * Setting this will say the surface prefers to not be listed in the taskbar.
 *
 * This request needs be called before surface map.
 */
static inline void
ukui_surface_v1_set_skip_taskbar(struct ukui_surface_v1 *ukui_surface_v1, uint32_t skip)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_surface_v1,
			 UKUI_SURFACE_V1_SET_SKIP_TASKBAR, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_surface_v1), 0, skip);
}

/**
 * @ingroup iface_ukui_surface_v1
 *
 * Setting this will say the surface prefers to not be listed in the switcher.
 *
 * This request needs be called before surface map.
 */
static inline void
ukui_surface_v1_set_skip_switcher(struct ukui_surface_v1 *ukui_surface_v1, uint32_t skip)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_surface_v1,
			 UKUI_SURFACE_V1_SET_SKIP_SWITCHER, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_surface_v1), 0, skip);
}

/**
 * @ingroup iface_ukui_surface_v1
 *
 * Assign a role to a shell surface.
 *
 * The compositor handles surfaces depending on their role.
 *
 * This request needs be called before surface map.
 */
static inline void
ukui_surface_v1_set_role(struct ukui_surface_v1 *ukui_surface_v1, uint32_t role)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_surface_v1,
			 UKUI_SURFACE_V1_SET_ROLE, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_surface_v1), 0, role);
}

/**
 * @ingroup iface_ukui_surface_v1
 *
 * Set surface state. Can set multiple states at once.
 * Values for state argument are described by ukui_surface.state and can be used
 * together in a bitfield.
 * The flags bitfield describes which flags are supposed to be set, the
 * state bitfield the value for the set flags.
 *
 * The state argument is not a boolean value, but a bitfield, so it is possible to set multiple
 * states at once. Only the states that are set in the flags bitfield will be changed.
 * The keep_above and keep_below can only used for the normal window.
 *
 * For example:
 *
 * If flags was 0x12(movable|maximizable) and state was 0x02(maximizable), the window would be
 * maximizable, but not movable.
 */
static inline void
ukui_surface_v1_set_state(struct ukui_surface_v1 *ukui_surface_v1, uint32_t flags, uint32_t state)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_surface_v1,
			 UKUI_SURFACE_V1_SET_STATE, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_surface_v1), 0, flags, state);
}

/**
 * @ingroup iface_ukui_surface_v1
 *
 * Setting this bit will indicate that the panel area not to be calculate in output usable area.
 */
static inline void
ukui_surface_v1_set_panel_auto_hide(struct ukui_surface_v1 *ukui_surface_v1, uint32_t hide)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_surface_v1,
			 UKUI_SURFACE_V1_SET_PANEL_AUTO_HIDE, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_surface_v1), 0, hide);
}

/**
 * @ingroup iface_ukui_surface_v1
 *
 * Request the initial position of this surface to be under the current cursor position. Has to
 * be called before attaching any buffer to this surface.
 *
 * This request needs be called before surface map.
 */
static inline void
ukui_surface_v1_open_under_cursor(struct ukui_surface_v1 *ukui_surface_v1, int32_t x, int32_t y)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_surface_v1,
			 UKUI_SURFACE_V1_OPEN_UNDER_CURSOR, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_surface_v1), 0, x, y);
}

/**
 * @ingroup iface_ukui_surface_v1
 *
 * This request makes the created surface take an explicit keyboard grab.
 * This keyboard grab will be dismissed when the client destroys the surface.
 * Grab all keyboard when seat is set to null.
 */
static inline void
ukui_surface_v1_grab_keyboard(struct ukui_surface_v1 *ukui_surface_v1, struct wl_seat *seat)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_surface_v1,
			 UKUI_SURFACE_V1_GRAB_KEYBOARD, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_surface_v1), 0, seat);
}

/**
 * @ingroup iface_ukui_surface_v1
 *
 * Setting server decoration icon by icon name.
 * Set icon name to null will use app_id to find icon.
 * This request needs be called before surface map.
 */
static inline void
ukui_surface_v1_set_icon(struct ukui_surface_v1 *ukui_surface_v1, const char *icon_name)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_surface_v1,
			 UKUI_SURFACE_V1_SET_ICON, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_surface_v1), 0, icon_name);
}

/**
 * @ingroup iface_ukui_surface_v1
 *
 * This request makes the created surface to be activated.
 * There is no guarantee the surface will be actually activated, and behaviour
 * may be compositor-dependentption.
 */
static inline void
ukui_surface_v1_activate(struct ukui_surface_v1 *ukui_surface_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_surface_v1,
			 UKUI_SURFACE_V1_ACTIVATE, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_surface_v1), 0);
}

/**
 * @ingroup iface_ukui_surface_v1
 *
 * Sets the startup geometry of the taskbar/desktop entry for this surface.
 * Coordinates are global.
 * One established way of doing this is through the UKUI_SURFACE_STARTUP_GEOMETRY
 * environment variable of a newly launched child process. The child process
 * should unset the environment variable again right after reading it out in
 * order to avoid propagating it to other child processes.
 * This request needs be called before surface map.
 */
static inline void
ukui_surface_v1_set_startup_geometry(struct ukui_surface_v1 *ukui_surface_v1, int32_t x, int32_t y, uint32_t width, uint32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_surface_v1,
			 UKUI_SURFACE_V1_SET_STARTUP_GEOMETRY, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_surface_v1), 0, x, y, width, height);
}

/**
 * @ingroup iface_ukui_surface_v1
 *
 * This request is for showing tile flyout on the client side decoration.
 * The parameters represent a mouse region, tile flyout will autohide when mouse leave
 * the region.
 * Coordinates are relative to the surface.
 * Use default seat when seat is set to null.
 * This request needs be called after surface map.
 */
static inline void
ukui_surface_v1_show_tile_flyout(struct ukui_surface_v1 *ukui_surface_v1, struct wl_seat *seat, int32_t x, int32_t y, uint32_t width, uint32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_surface_v1,
			 UKUI_SURFACE_V1_SHOW_TILE_FLYOUT, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_surface_v1), 0, seat, x, y, width, height);
}

#ifndef UKUI_DECORATION_V1_ERROR_ENUM
#define UKUI_DECORATION_V1_ERROR_ENUM
enum ukui_decoration_v1_error {
	/**
	 * wl_surface object already mapped
	 */
	UKUI_DECORATION_V1_ERROR_MAPPED = 0,
};
#endif /* UKUI_DECORATION_V1_ERROR_ENUM */

#ifndef UKUI_DECORATION_V1_COMPONENTS_ENUM
#define UKUI_DECORATION_V1_COMPONENTS_ENUM
enum ukui_decoration_v1_components {
	UKUI_DECORATION_V1_COMPONENTS_ROUND_CORNER = 0x1,
	UKUI_DECORATION_V1_COMPONENTS_BORDER = 0x2,
	UKUI_DECORATION_V1_COMPONENTS_SHADOW = 0x4,
};
#endif /* UKUI_DECORATION_V1_COMPONENTS_ENUM */

#define UKUI_DECORATION_V1_SET_NO_TITLEBAR 0
#define UKUI_DECORATION_V1_SET_DECORATION_COMPONENTS 1
#define UKUI_DECORATION_V1_DESTROY 2


/**
 * @ingroup iface_ukui_decoration_v1
 */
#define UKUI_DECORATION_V1_SET_NO_TITLEBAR_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_decoration_v1
 */
#define UKUI_DECORATION_V1_SET_DECORATION_COMPONENTS_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_decoration_v1
 */
#define UKUI_DECORATION_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_ukui_decoration_v1 */
static inline void
ukui_decoration_v1_set_user_data(struct ukui_decoration_v1 *ukui_decoration_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ukui_decoration_v1, user_data);
}

/** @ingroup iface_ukui_decoration_v1 */
static inline void *
ukui_decoration_v1_get_user_data(struct ukui_decoration_v1 *ukui_decoration_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ukui_decoration_v1);
}

static inline uint32_t
ukui_decoration_v1_get_version(struct ukui_decoration_v1 *ukui_decoration_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) ukui_decoration_v1);
}

/**
 * @ingroup iface_ukui_decoration_v1
 *
 * Setting this will say the surface prefers not to show titlebar.
 *
 * This request needs be called before surface map.
 */
static inline void
ukui_decoration_v1_set_no_titlebar(struct ukui_decoration_v1 *ukui_decoration_v1, uint32_t no_titlebar)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_decoration_v1,
			 UKUI_DECORATION_V1_SET_NO_TITLEBAR, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_decoration_v1), 0, no_titlebar);
}

/**
 * @ingroup iface_ukui_decoration_v1
 *
 * The flags bitfield describes which components of decoration are supposed to be set and can be set
 * together in a bitfield. Draw decoration will be based on the flags.
 * This flags needs be called before surface map and become immutable when surface is mapped.
 * This request is only for xdg_popup now.
 */
static inline void
ukui_decoration_v1_set_decoration_components(struct ukui_decoration_v1 *ukui_decoration_v1, uint32_t flags)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_decoration_v1,
			 UKUI_DECORATION_V1_SET_DECORATION_COMPONENTS, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_decoration_v1), 0, flags);
}

/**
 * @ingroup iface_ukui_decoration_v1
 */
static inline void
ukui_decoration_v1_destroy(struct ukui_decoration_v1 *ukui_decoration_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_decoration_v1,
			 UKUI_DECORATION_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_decoration_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
