# -*- coding: utf-8 -*-
"""
fichier de configuration pour créole

"""
from os.path import join, isfile, isdir

eoledir = '/usr/share/eole'
LOCALKERNEL_FILE = join(eoledir, 'noyau/local')
REBOOT_FILE = '/var/run/reboot-required'

charset = 'UTF8'

# chemin par defaut des templates, fichier config.eol, etc
configeoldir = '/etc/eole/'
eoleroot = join(eoledir, 'creole')
vareole = '/var/lib/eole'

bareos_restore_root = join(eoledir, 'bareos')
bareos_restore = join(bareos_restore_root, 'restore')

configeol = join(configeoldir, 'config.eol')

# certificats
CERT_DB = '/var/lib/eole/cert_db.txt'
cert_file = '/etc/ssl/certs/eole.crt'
key_file = '/etc/ssl/private/eole.key'
# port du serveur creole_serv
port_rpc = 4333

# chemin du répertoire source des fichiers templates
templatedir = '/var/lib/creole'

dicos_dir = join(eoleroot, 'dicos')
modif_dir = join(eoleroot, 'modif')
distrib_dir = join(eoleroot, 'distrib')
patch_dir = join(eoleroot, 'patch')

# chemin pour les fichiers de données
datadir = '/usr/share/creole'
# chemin pour les modules de fonctions supplémentaires
func_dir = join(datadir,'funcs')

# repertoire du ou des dictionnaires xml creole
eoledirs = [dicos_dir, join(dicos_dir, 'variante'), join(dicos_dir, 'local')]

# extra
eoleextradico = join(eoledir, 'creole/extra')
eoleextraconfig = join(configeoldir, 'extra')
forbiddenextra = ['containers', 'creole']

# repertoire de la dtd
dtddir = datadir
if isfile('data/creole.dtd'):
    dtdfilename = 'data/creole.dtd'
    dtd260filename = 'data/creole260.dtd'
elif isfile('../creole/data/creole.dtd'):
    dtdfilename = '../creole/data/creole.dtd'
    dtd260filename = '../creole/data/creole260.dtd'
else:
    dtdfilename = join(dtddir, 'creole.dtd')
    dtd260filename = join(dtddir, 'creole260.dtd')

# repertoire avec le fichier lock
LOCK_PATH = '/var/lock/eole'
LOCK_SYSTEM_PATH = join(LOCK_PATH, 'eole-system')

# Nom du serveur maitre
VIRTMASTER = 'root'
VIRTROOT = '/var/lib/lxc'
VIRTBASE = 'rootfs'

container_instance_lockfile = '/etc/eole/.container_instance.lock'
containers_default_network = '192.0.2'
gen_conteneurs_needed = '/etc/eole/.gen_conteneurs'

VIRTENABLED_LOCKFILE = '/etc/eole/.VirtEnabled.lock'
VIRTDISABLED_LOCKFILE = '/etc/eole/.VirtDisabled.lock'
INSTANCE_LOCKFILE = '/etc/eole/.instance'
UPGRADE_LOCKFILE = '/etc/eole/.upgrade-auto'
NEED_MAJ_AUTO_LOCKFILE = '/etc/eole/.maj-auto'

SSL_LAST_FILE = '/etc/eole/ssl/lastfile.txt'

FLATTENED_CREOLE_DIR = join(vareole, 'config')
if not isdir(FLATTENED_CREOLE_DIR):
    FLATTENED_CREOLE_DIR = join('/tmp')
