from __future__ import absolute_import, print_function
from .DistUpgradeViewNonInteractive import DistUpgradeViewNonInteractive
z_proc = "UPGRADE"
try:
    from pyeole.ansiprint import print_red
except:
    print_red = print
try:
    # import zephir logger if registered
    from zephir.zephir_conf.zephir_conf import id_serveur
    from zephir.lib_zephir import log as zlog
    import time
except:
    zlog = None

class DistUpgradeViewEOLE(DistUpgradeViewNonInteractive):
    def error(self, summary, msg, extended_msg=None):
        " display an error "
        print_red("Une erreur est survenue : %s %s (%s)" % (summary, msg, extended_msg))
        if zlog is not None:
            zlog(z_proc, -2, "Une erreur est survenue : %s" % summary, str(time.ctime()))
        super(DistUpgradeViewEOLE, self).error(summary, msg, extended_msg)
    def abort(self):
        if zlog is not None:
            zlog(z_proc, 1, "Une erreur fatale est survenue Vous trouverez plus d'informations dans les journaux : /var/log/dist-upgrade/", str(time.ctime()))
        print_red("Une erreur fatale est survenue. Vous trouverez plus d'informations dans les journaux : /var/log/dist-upgrade/")
        super(DistUpgradeViewEOLE, self).abort()
