from os.path import join
import sys
import importlib
from pathlib import Path
from pyeole.log import init_logging
log = init_logging()

def setup_module(module):
    module.HERE = Path(__file__).resolve().parent

    PATH = HERE.parent.joinpath('extra', 'dhcp', 'salt', 'custom.py')
    spec = importlib.util.spec_from_file_location(PATH.stem, PATH)
    module.custom = importlib.util.module_from_spec(spec)
    sys.modules[PATH.stem] = custom
    spec.loader.exec_module(custom)

def setup_function(function):
    custom._force_dirs = ['/usr/share/eole/creole/dicos']
    custom._force_eoleextradico = '/usr/share/eole/creole/extra'
    custom._force_configeol = join(HERE, 'data/generic/config.eol')
    custom._force_eoleextraconfig = join(HERE, 'data/generic/extra')
    custom._reload_config = False


def teardown_function(function):
    custom._force_dirs = None
    custom._force_eoleextradico = None
    custom._force_configeol = None
    custom._force_eoleextraconfig = None
    custom._reload_config = True


def test_subnets_empty():
    custom._force_configeol = join(HERE, 'data/subnets_empty/config.eol')
    custom._force_eoleextraconfig = join(HERE, 'data/subnets_empty/extra')
    assert custom.get_subnets() == {'subnets': []}


def test_subnets_static_range():
    custom._force_configeol = join(HERE, 'data/subnets_static_range/config.eol')
    custom._force_eoleextraconfig = join(HERE, 'data/subnets_static_range/extra')
    expected = {'subnets': [{'ranges': [{'high': u'192.168.0.120', 'restricted': False, 'low': u'192.168.0.110', 'name': 'test', 'static': False}], 'netmask': u'255.255.255.0', 'network': u'192.168.0.0'}]}
    assert custom.get_subnets() == expected


def test_subnets_dynamic_range():
    custom._force_configeol = join(HERE, 'data/generic2/config.eol')
    custom._force_eoleextraconfig = join(HERE, 'data/generic2/extra')
    expected = {'subnets': [{'ranges': [{'high': u'192.168.0.120', 'restricted': True, 'static': False, 'low': u'192.168.0.110', 'name': u'test'}, {'high': u'192.168.0.130', 'restricted': False, 'static': True, 'low': u'192.168.0.121', 'name': u'statique'}], 'netmask': u'255.255.255.0', 'network': u'192.168.0.0'}]}
    assert custom.get_subnets() == expected


def test_subnets_two_subnets():
    custom._force_configeol = join(HERE, 'data/subnets_two_subnets/config.eol')
    custom._force_eoleextraconfig = join(HERE, 'data/subnets_two_subnets/extra')
    expected = {'subnets': [{'ranges': [{'high': u'192.168.0.120', 'restricted': False, 'static': False, 'low': u'192.168.0.110', 'name': u'test'}], 'netmask': u'255.255.255.0', 'network': u'192.168.0.0'}, {'ranges': [{'high': u'192.168.1.30', 'restricted': True, 'static': False, 'low': u'192.168.1.20', 'name': u'test2'}], 'netmask': u'255.255.255.0', 'network': u'192.168.1.0'}]}
    assert custom.get_subnets() == expected


def test_subnets_two_subnets_same_network():
    custom._force_configeol = join(HERE, 'data/subnets_two_subnets_same_network/config.eol')
    custom._force_eoleextraconfig = join(HERE, 'data/subnets_two_subnets_same_network/extra')
    expected = {'subnets': [{'ranges': [{'high': u'192.168.0.120', 'restricted': False, 'static': False, 'low': u'192.168.0.110', 'name': u'test'}, {'high': u'192.168.0.130', 'restricted': True, 'static': False, 'low': u'192.168.0.125', 'name': u'test2'}], 'netmask': u'255.255.255.0', 'network': u'192.168.0.0'}]}
    assert custom.get_subnets() == expected
