<?php
/*--------------------------------------
 Classe : GestCollecParam
----------------------------------------
 Gère une collection de paramètres modifiables dans une page web
 Ces paramètres peuvent être présentés comme des checkbox, des boutons radios, des champs texte, des listes de sélection
---------------------------------------*/
 
define ('TITRE',0);
define ('I_CHECK',1);
define ('I_RADIO',2);
define ('I_TEXT',3);
define ('I_SELECT',4);
define ('SEPAR',5);

class GestCollecParam {
	
	var $tParam,$tNbColSection; //,$tTitre;
	var $idxItem,$idxBloc; //,$idxBloc,;
	
	/* Constructeur */
	function __construct($largeurTab=700) { //gestCollecParam($largeurTab=700) {
		$this->tParam=$this->tNbColSection=array(); 
		$this->idxItem=$this->idxBloc=0; //
		$this->largeurTab=$largeurTab;
	}
	
	public function __destruct () {
	}
	
/*-------------------
	ajoutElem()
	--------------------------------
	Ajoute un élément : titre ou Paramètre ou Séparateur
	--------------------------------
	Remarque : style : style à affecter à l'élément
						 codeComplementBalise : ajout de code dans la balise de l'élément (ex: onClick="alert(1)")
						 autreService : indique si le paramètre est à enregistrer comme global (si ''), ou un autre service (ex : 'parents')
	--------------------------------
	- bouton radio
	$_param=array(val1=>"Afficher les Mots de passe en survolant un icône",val2=>"Afficher les Mots de passe");
	$tParam->ajoutParam(I_RADIO,nomParam,texte,$_param,style,codeComplementBalise,autreService);
	- checkbox
	$tParam->ajoutParam(I_CHECK,nomParam,texte,array(valSiDecoche,valSiCoche),style,codeComplementBalise,autreService);
	- select
	$_param=array(0=>array("2008","année 2008"), 1=>array("2009","année 2009"));
	$tParam->ajoutParam(I_SELECT,nomParam,texte,$_param,style,codeComplementBalise,autreService);
	- input text
	$tParam->ajoutParam(I_TEXT,nomParam,texte,style,codeComplementBalise,autreService);
	- titre
	$tParam->ajoutParam(TITRE,texte,style);
	- séparateur
	$tParam->ajoutParam(SEPAR);
	--------------------*/
	function ajoutElem() {
		$tArgs=func_get_args();
		$nbArgs=func_num_args();
		if ($nbArgs>0) {
			switch ($tArgs[0]) {
				case SEPAR :
					$this->idxBloc++;
					if (isset($tArgs[1])) if ($tArgs[1]!='') $this->tParam[$this->idxItem]['style']=$tArgs[1];
					//echo $this->idxBloc;
				case TITRE :
					$this->tParam[$this->idxItem]['type']=$tArgs[0];
					if (isset($tArgs[1])) $this->tParam[$this->idxItem]['txt']=$tArgs[1];
					if (isset($tArgs[2])) if ($tArgs[2]!='') $this->tParam[$this->idxItem]['style']=$tArgs[2];
					if (isset($tArgs[3])) $this->tParam[$this->idxItem]['complementBalise']=$tArgs[3];
					if (isset($tArgs[4])) $this->tParam[$this->idxItem]['autreService']=$tArgs[4];
					$this->idxItem++;
					break;
				case I_RADIO : //type bouton radio
					$this->tNbColSection[$this->idxBloc]=3;
				case I_SELECT : //type select
				case I_CHECK : //checkbox
					$this->tParam[$this->idxItem]=array('type'=>$tArgs[0],'nomParam'=>$tArgs[1],'txt'=>$tArgs[2],'tVal'=>$tArgs[3]); //,'idxBloc'=>$this->idxBloc);
					if (isset($tArgs[4])) if ($tArgs[4]!='') $this->tParam[$this->idxItem]['style']=$tArgs[4];
					if (isset($tArgs[5])) $this->tParam[$this->idxItem]['complementBalise']=$tArgs[5];
					if (isset($tArgs[6])) $this->tParam[$this->idxItem]['autreService']=$tArgs[6];
					$this->tParam[$this->idxItem]['sauve']=true;
					$this->idxItem++;
					break;
				case I_TEXT :
					$this->tParam[$this->idxItem]=array('type'=>$tArgs[0],'nomParam'=>$tArgs[1],'txt'=>$tArgs[2]); //,'idxBloc'=>$this->idxBloc);
					if (isset($tArgs[3])) if ($tArgs[3]!='') $this->tParam[$this->idxItem]['style']=$tArgs[3];
					if (isset($tArgs[4])) $this->tParam[$this->idxItem]['complementBalise']=$tArgs[4];
					if (isset($tArgs[5])) $this->tParam[$this->idxItem]['autreService']=$tArgs[5];
					$this->tParam[$this->idxItem]['sauve']=true;
					$this->idxItem++;
					break;
				default;
					break;
			}
			if (!isset($this->tNbColSection[$this->idxBloc])) $this->tNbColSection[$this->idxBloc]=2;
		}
	}

	/*------------------------------------------
	 Fonction : fixeValeur
	-------------------------------------
	  fixe la valeur d'un paramètre pour affichage
	-------------------------------------
	 - Entrée : nomParam, valeur
	 - Sortie : 
	---------------------------------------------*/
	function fixeValeur($nomParam,$valeur) {
		foreach ($this->tParam as $_idxP => $_tParam) {
			if ($nomParam==$_tParam['nomParam']) $this->tParam[$_idxP]['val']=$valeur;
		}
	}
	
	/*------------------------------------------
	 Fonction : fixeValeurASauver
	-------------------------------------
	  fixe la valeur d'un paramètre pour l'enregistrement
	-------------------------------------
	 - Entrée : nomParam, valeur
	 - Sortie : 
	---------------------------------------------*/
	function fixeValeurASauver($nomParam,$valeur) {
		foreach ($this->tParam as $_idxP => $_tParam) {
			if ($nomParam==$_tParam['nomParam']) $this->tParam[$_idxP]['valASauver']=$valeur;
		}
	}
	
	/*------------------------------------------
	 Fonction : fixeComplementBalise
	-------------------------------------
	  fixe la valeur d'un complément de balise
	-------------------------------------
	 - Entrée : nomParam, complement
	 - Sortie : 
	---------------------------------------------*/
	function fixeComplementBalise($nomParam,$complement) {
		foreach ($this->tParam as $_idxP => $_tParam) {
			if ($nomParam==$_tParam['nomParam']) $this->tParam[$_idxP]['complementBalise']=$complement;
		}
	}
	
	/*------------------------------------------
	 Fonction : changeValeurASauver
	-------------------------------------
	  change la valeur d'un paramètre pour l'enregistrement en appliquant une fonction
	-------------------------------------
	 - Entrée : nomParam, fonction
	 - Sortie : 
	---------------------------------------------*/
	function changeValeurASauver($nomParam,$fonction) {
		
		foreach ($this->tParam as $_idxP => $_tParam) {
			if ($nomParam==$_tParam['nomParam']) {
				$this->tParam[$_idxP]['valASauver']=call_user_func($fonction,$_POST['_p_'][$_idxP]);
			}
		}
	}
	
	/*------------------------------------------
	 Fonction : getValeur
	-------------------------------------
	  récupère la valeur d'un paramètre posté
	-------------------------------------
	 - Entrée : nomParam, valeur
	 - Sortie : 
	---------------------------------------------*/
	function getValeur($nomParam) {
		foreach ($this->tParam as $_idxP => $_tParam) {
			if ($nomParam==$_tParam['nomParam']) {
				if ($_tParam['type']==I_SELECT) {
					//print_r($_tParam['tVal']);echo "-".$_POST['_p_'][$_idxP].'-_'.$_tParam['tVal'][$_POST['_p_'][$_idxP]][0].'_';
					if (isset($_tParam['tVal'])) return $_tParam['tVal'][$_POST['_p_'][$_idxP]][0];
				} else {
					if (isset($_POST['_p_'][$_idxP])) return $_POST['_p_'][$_idxP];
				}
			}
		}
		return false;
	}
	
	/*------------------------------------------
 Fonction : 
-------------------------------------
 -
-------------------------------------
 - Entrée :
 - Sortie : 
---------------------------------------------*/
	function neSauvePas($nomParam) {
		foreach ($this->tParam as $_idxP => $_tParam) {
			if ($nomParam==$_tParam['nomParam']) $this->tParam[$_idxP]['sauve']=false;
		}
	}
	
	/*------------------------------------------
	 Fonction : sauveParams
	-------------------------------------
	 sauve les paramètres postés
	-------------------------------------
	 - Entrée :
	 - Sortie : 
	---------------------------------------------*/
	function sauveParams() {
//		print_r($this->tParam);
		$retour="";
		foreach ($this->tParam as $_idxP => $_tParam) {
			//echo " $_idxP/$_tParam[type] ";
			if ($_tParam['type']==SEPAR || $_tParam['type']==TITRE || !$_tParam['sauve']) continue;
			if ($_tParam['type']==I_SELECT) { //c'est un select, alors la valeur à enregistrer est à cherche dans tVal
				$laVal=$_tParam['tVal'][$_POST['_p_'][$_idxP]][0];
			} else if ($_tParam['type']==I_CHECK) { //c'est une check box, alors la valeur à enregistrer est à cherche dans tVal
				if (isset($_POST['_p_'][$_idxP])) $laVal=$_tParam['tVal'][1];
				else $laVal=$_tParam['tVal'][0];
			} else { //si c'est un texte ou bouton radio, on regarde si on enregistre la valeur ou une valeur de remplacement
				if (isset($_tParam['valASauver'])) $laVal=$_tParam['valASauver'];
				else $laVal=$_POST['_p_'][$_idxP]; 
			}
			if ($_tParam['nomParam']==$_POST['_h_'][$_idxP]) { //si code de controle ok on enregistre
				if (isset($_tParam['autreService'])) {
					if ($_tParam['autreService']=='') $_pGlobal=true; else $_pGlobal=false;
					//echo '1.ecritParam("'.$_tParam['nomParam'].'", '.$laVal.', "'.$_tParam['autreService'].'", '.$_pGlobal.');'.BRCR;
					ecritParam($_tParam['nomParam'], $laVal);
					$retour="Paramètres enregistrés";
				}
				else {
					//echo '2.ecritParam("'.$_tParam['nomParam'].'", '.$laVal.');'.BRCR;
					ecritParam($_tParam['nomParam'],$laVal);
					$retour="Paramètres enregistrés";
				}
			}	else {
				$retour.='paramètre '.$_tParam['nomParam'].'('.$_tParam['type'].') invalide';
			}
		}
		
		return $retour; 
	}
	
	/*------------------------------------------
	 Fonction : renduTabParam
	-------------------------------------
	  procède à la fabrication du code HTML pour l'affichage du tableau de paramètre
	-------------------------------------
	 - Entrée :
	 - Sortie : chaine contenant le code HTML
	---------------------------------------------*/
	function renduTabParams($style="") {
		$idxBloc=0;
		$premLigApresTitre=true;
		$premLigneBloc=true;
		$idxLig=1;
		$nbElem=count($this->tParam);
		if ($style!='') $leStyle=' style="'.$style.'"';
		$chaine='<table class="p_table" width="'.$this->largeurTab.'" cellspacing="0" cellpadding="2"'.$leStyle.'>'.CR;
		foreach ($this->tParam as $_idxP => $_tParam) {
			switch ($_tParam['type']) {
				case TITRE :
					//if (!$premTitre) $chaine.='</table>'.CR.'<table class="p_table" width="'.$this->largeurTab.'">'.CR;
					//$premTitre=false;
					//$premLigneBloc=true;
					$chaine.='<tr><td colspan="'.$this->tNbColSection[$idxBloc].'" class="p_titre"'.(isset($_tParam['style'])?' style="'.$_tParam['style'].'"':'').'>'.$_tParam['txt'].'</td></tr>'.CR;
					$premLigApresTitre=true;
					break;
				case SEPAR :
					if (!isset($_tParam['hauteur'])) $_tParam['hauteur']=10;
					$chaine.='</table><table'.$leStyle.'><tr><td colspan="'.$this->tNbColSection[$idxBloc].'" class="p_separ"'.(isset($_tParam['style'])?' style="'.$_tParam['style'].'"':'').'>&nbsp;</td></tr></table>'.CR.
										'<table class="p_table" width="'.$this->largeurTab.'" cellspacing="0" cellpadding="2"'.$leStyle.'>'.CR;
					$idxBloc++;
					$premLigneBloc=true;
					$premLigApresTitre=true;
					break;
				case I_CHECK :
					$_check="";
					if (isset($_tParam['val'])) if ($_tParam['val']==$_tParam['tVal'][1]) $_check=" CHECKED";
					$chaine.='<tr class="p_lig'.$idxLig.'"><td colspan="'.($this->tNbColSection[$idxBloc]-1).'" class="p_txtP"'.(($premLigneBloc && $this->tNbColSection[$idxBloc]==2)?' width="60%"':'').'>'.$_tParam['txt'].'</td>'.CR.
										'<td class="p_elem"><input type="checkbox" name="_p_['.$_idxP.']" value="1"'.$_check.(isset($_tParam['style'])?' style="'.$_tParam['style'].'"':'').(isset($_tParam['complementBalise'])?' '.$_tParam['complementBalise']:'').' /><input type="hidden" name="_h_['.$_idxP.']" value="'.$_tParam['nomParam'].'"/></td></tr>'.CR;
					if ($this->tNbColSection[$idxBloc]==2) $premLigneBloc=false;
					$idxLig=3-$idxLig;
					$premLigApresTitre=false;
					break;
				case I_RADIO : //type bouton radio
					$premLig=true;
					$_nbLig=count($_tParam['tVal']);
					$_idxLig=1;
					$_idxL=1;
					$besoinBordBas=false;
					if ($_idxP<($nbElem-1)) //ce n'est pas le dernier
						if ($this->tParam[$_idxP+1]['type']!=TITRE) //le suivant n'est pas un TITRE
						if ($this->tParam[$_idxP+1]['type']!=SEPAR) //le suivant n'est pas un SEPAR
						if ($this->tParam[$_idxP+1]['type']!=I_RADIO) ////le suivant n'est pas un RADIO
						 $besoinBordBas=true; //on a besoin d'une bordure basse
					if (is_array($_tParam['tVal'])) foreach ($_tParam['tVal'] as $_val=>$_txt) {
						$_sel="";
						if (isset($_tParam['val'])) if ($_tParam['val']==$_val) $_sel=" CHECKED";
						$chaine.='<tr class="p_lig'.$idxLig.'">'.($premLig?'<td class="p_txtP p_txtRadio'.($premLigApresTitre?'':' p_b2H').($besoinBordBas?' p_b2B':'').'" rowspan="'.$_nbLig.'"'.($premLigneBloc?' width="50%"':'').'><input type="hidden" name="_h_['.$_idxP.']" value="'.$_tParam['nomParam'].'"/>'.$_tParam['txt'].'</td>':'').CR.
										'<td class="p_txtChoixRadio p_txtChoix'.$_idxLig.(($premLigApresTitre || !$premLig)?'':' p_b2H').(($besoinBordBas && $_idxL==$_nbLig)?' p_b2B':'').'"'.(($premLigneBloc && $premLig)?' width="49%"':'').'>'.$_txt.'</td>'.CR.
										'<td class="p_elem p_txtChoix'.$_idxLig.''.(($premLigApresTitre || !$premLig)?'':' p_b2H').(($besoinBordBas && $_idxL==$_nbLig)?' p_b2B':'').'"><input type="radio" name="_p_['.$_idxP.']" value="'.$_val.'"'.$_sel.(isset($_tParam['style'])?' style="'.$_tParam['style'].'"':'').(isset($_tParam['complementBalise'])?' '.$_tParam['complementBalise']:'').' /></td></tr>'.CR;
						$premLig=false;
						$_idxLig=3-$_idxLig;
						$_idxL++;
					}
					$premLigneBloc=false;
					$idxLig=3-$idxLig;
					$premLigApresTitre=false;
					break;
				case I_SELECT :
					$_listeOption='';
					if (is_array($_tParam['tVal'])) foreach ($_tParam['tVal'] as $_idxS=>$_tOpt) {
						$_sel="";
						if (isset($_tParam['val'])) if ($_tParam['val']==$_tOpt[0]) $_sel=" SELECTED";
						$_listeOption.='<option value="'.$_idxS.'"'.$_sel.'>'.$_tOpt[1].'</option>'.CR;
					}				
					$chaine.='<tr class="p_lig'.$idxLig.'"><td colspan="'.($this->tNbColSection[$idxBloc]-1).'" class="p_txtP"'.(($premLigneBloc && $this->tNbColSection[$idxBloc]==2)?' width="60%"':'').'>'.$_tParam['txt'].'</td>'.CR.
										'<td class="p_elem"><input type="hidden" name="_h_['.$_idxP.']" value="'.$_tParam['nomParam'].'"/><select name="_p_['.$_idxP.']"'.(isset($_tParam['style'])?' style="'.$_tParam['style'].'"':'').(isset($_tParam['complementBalise'])?' '.$_tParam['complementBalise']:'').'>'.CR.
										$_listeOption.CR.
										'</td></tr>'.CR;
					if ($this->tNbColSection[$idxBloc]==2) $premLigneBloc=false;
					$idxLig=3-$idxLig;
					$premLigApresTitre=false;
					break;
				case I_TEXT :
					$chaine.='<tr class="p_lig'.$idxLig.'"><td colspan="'.($this->tNbColSection[$idxBloc]-1).'" class="p_txtP"'.(($premLigneBloc && $this->tNbColSection[$idxBloc]==2)?' width="60%"':'').'>'.$_tParam['txt'].'</td>'.CR.
										'<td class="p_elem"><input type="text" name="_p_['.$_idxP.']" value="'.(isset($_tParam['val'])?db2html(utf8_decode($_tParam['val'])):'').'"'.(isset($_tParam['style'])?' style="'.$_tParam['style'].'"':'').(isset($_tParam['complementBalise'])?' '.$_tParam['complementBalise']:'').' /><input type="hidden" name="_h_['.$_idxP.']" value="'.$_tParam['nomParam'].'"/></td></tr>'.CR;
					if ($this->tNbColSection[$idxBloc]==2) $premLigneBloc=false;
					$idxLig=3-$idxLig;
					$premLigApresTitre=false;
					break;
			}
		}
		$chaine.="</table>".CR;

		return $chaine;
	}

} //fin de la classe

?>