<?php

/*--------------------------------------------------------------------------
	    f_onglets.inc.php
-----------------------------
	auteur : Olivier Hacquard
-----------------------------
	version : V1.1 - 27/02/07
-----------------------------
		Ensemble de fonctions (PHP et JS) permettant la gestion d'onglets dans une page PHP.
		 Le JavaSCript est utilis pour permettre les animations des onglets
		 et notamment le basculement d'un DIV (slectionn par l'onglet)  l'autre 
		 sans recharger la page.
		L'onglet est une image (.gif s'il doit tre en partie transparent) contenant
		 les diffrent tat de l'onglet (slectionn, non slectionn et survol). 
		 La position de ces diffrents tats dans l'image (donne en pixel depuis le 
		   haut de l'image) est  fournir comme paramtre de cration des onglets.
		 La largeur de l'image doit tre au moins gal  l'onglet le plus large + la 
		   taille du bord gauche (arrondi le plus souvent). Et la hauteur de chaque
		   onglet au moins suprieur au plus haut  reprsenter.
-----------------------------------------------
	Mthode :		   
	* dans le HEAD
		1. inclure les script JavaScript dans le HEAD de la page par la ligne 
					<? fonctionOngletJS(); ?>
		
	* n'importe o
		2. dclarer une instance de la classe (n'importe o dans la page) par une ligne du type :
					$fenOnglet=new fenetreOnglets("tousTab", 0, 0, 800, ...);
		
	* dans le BODY
		3. dlimiter les portions de code  mettre dans les onglets en mettant au dbut de ceux ci
				une dclaration d'entte d'onglet : (1 par onglet)
					$fenOnglet->enteteDivOnglet("Mot de passe", 100, $couleurFondOnglets1);
		
		4. Terminer les onglets par l'affichage des onglets eux-mme :
					$fenOnglet->finFenetreOnglets();
		
		5. Si ncessaire, on peut commander le basculement vers un onglet en particulier.
				- soit en indiquant le numro d'onglet ou le titre de l'onglet par la ligne :
						$fenOnglet->selectOnglet($idOnglet)
				- soit en faisant la bascule via une variable transmise directement par l'URL (ex : xxx.php?onglet=2) :
						$fenOnglet->basculeGetOnglet('onglet');   o 'onglet' et le nom de la variable passe dans l'URL
					
----------------------------------------------------------------------------*/

define('CR', "\n");
define('BR', "<br/>");
 
function centreDivOngletSurPage($nomDivRef, $largeurDivACentrer) {
	echo "<script language=\"JavaScript\">
		var divRef=document.getElementById('$nomDivRef');
		if (document.body) var largFen=(document.body.clientWidth); 
		else var largFen=(window.innerWidth);
		if (parseInt(largFen)>$largeurDivACentrer) divRef.style.left=parseInt(largFen/2)+'px';
		else divRef.style.left=parseInt($largeurDivACentrer/2)+'px';
	</script>";
}
 
function fonctionOngletJS($numDivOnglets) {
	//echo "numDivOnglets:".strval($numDivOnglets);
	static $JS_Ok=false; 
	if ($JS_Ok) return;
	$JS_Ok=true;
?>
<script language="JavaScript"  type="text/javascript">
	if (ongletSel === undefined) {
		var ongletSel=new Array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
		
		function swapId(idxOnglets, selNew, posSel, posNonSel, hauteurOnglet, fichierOnglets) {
			//alert('swapId('+idxOnglets+','+selNew+','+posSel+','+posNonSel+','+hauteurOnglet+','+fichierOnglets+')');
			//si c'est l'onglet slectionn on sort
			if (idxOnglets+'_'+selNew==idxOnglets+'_'+ongletSel[idxOnglets]) return;
			
			document.getElementById('tab'+idxOnglets+'_'+selNew).style.display='block';
			if (ongletSel[idxOnglets]!=0) document.getElementById('tab'+idxOnglets+'_'+ongletSel[idxOnglets]).style.display='none';
			
			//on change la position de l'image de fond de l'onglet - partie gauche
			document.getElementById('gauche'+idxOnglets+'_'+selNew).style.backgroundPosition="0% -"+posSel+"px";
			if (ongletSel[idxOnglets]!=0) document.getElementById('gauche'+idxOnglets+'_'+ongletSel[idxOnglets]).style.backgroundPosition="0% -"+posNonSel+"px";
			//on change la position de l'image de fond de l'onglet - partie droite
			document.getElementById('onglet'+idxOnglets+'_'+selNew).style.backgroundPosition="100% -"+posSel+"px";
			if (ongletSel[idxOnglets]!=0) document.getElementById('onglet'+idxOnglets+'_'+ongletSel[idxOnglets]).style.backgroundPosition="100% -"+posNonSel+"px";
	
			//idem avec la ligne sous l'onglet pour continuer du trait de la bordure
			document.getElementById('_gauche'+idxOnglets+'_'+selNew).style.background="url("+fichierOnglets+") no-repeat left top";
			document.getElementById('_gauche'+idxOnglets+'_'+selNew).style.backgroundPosition="0% -"+(posSel+hauteurOnglet-1)+"px";
			if (ongletSel[idxOnglets]!=0) {
				//si on dselction, on limine l'image du fond de la bordure basse
				document.getElementById('_gauche'+idxOnglets+'_'+ongletSel[idxOnglets]).style.backgroundPosition="";
				document.getElementById('_gauche'+idxOnglets+'_'+ongletSel[idxOnglets]).style.background="";
			}
			//on change la position de l'image de fond de l'onglet - partie droite
			document.getElementById('_onglet'+idxOnglets+'_'+selNew).style.background="url("+fichierOnglets+") no-repeat right top";
			document.getElementById('_onglet'+idxOnglets+'_'+selNew).style.backgroundPosition="100% -"+(posSel+hauteurOnglet-1)+"px";
			if (ongletSel[idxOnglets]!=0) {
				//si on dselction, on limine l'image du fond de la bordure basse
				document.getElementById('_onglet'+idxOnglets+'_'+ongletSel[idxOnglets]).style.backgroundPosition="";
				document.getElementById('_onglet'+idxOnglets+'_'+ongletSel[idxOnglets]).style.background="";
			}
			//"100% -"+(posNonSel+hauteurOnglet-1)+"px";
	
		//background:url($fichierOnglets) no-repeat left top;$posFond_G\"";
		//		$styleFond_D="style=\"background:url($fichierOnglets) no-repeat right top;$posFond_D\"";
	
	
			ongletSel[idxOnglets]=selNew;
		}
		
		function montreId(choix, idxOnglets, selNew, posSel, posNonSel, posSurvol) {
			//alert('montreId('+choix+','+idxOnglets+','+selNew+','+posSel+','+posNonSel+','+posSurvol+')');
			if (idxOnglets+'_'+selNew==idxOnglets+'_'+ongletSel[idxOnglets]) return;
			
			if (choix==1) laPos=posSurvol; else laPos=posNonSel;
			//on change la position de l'image de fond de l'onglet - partie gauche
			document.getElementById('gauche'+idxOnglets+'_'+selNew).style.backgroundPosition="0% -"+laPos+"px";
			//on change la position de l'image de fond de l'onglet - partie droite
			document.getElementById('onglet'+idxOnglets+'_'+selNew).style.backgroundPosition="100% -"+laPos+"px";
			
		}
	} else { //dj dfini mais on recharge la page... il faut donc rinitialiser l'onglet
		ongletSel[<?php echo strval($numDivOnglets); ?>]=0;
	}
	
</script>
<?php
} //fin de fonctionOngletJS

function defStyleOnglet() {
return "<!-- dfinition des styles pour les onglets -->
	<style type=\"text/css\">
		<!--
		.styleOngletBlanc {font-family: Verdana, Arial, Helvetica, sans-serif;	font-size:8pt;font-weight:bold;color:#FFFFFF;}
		.styleOngletMarron {font-family: Verdana, Arial, Helvetica, sans-serif;	font-size:8pt;font-weight:bold;color:#404000;}
		-->
	</style>\n";
}


/*---------------------------------------------
  Classe fenetreOnglets
  	fabrique les divs permettant
  	l'utilisation de divs avec des onglets.
---------------------------------------------*/

//styles de couleurs prdfinis

//0->gris
//2->vert pomme
//4->vert d'eau
//6->bleu azur
//40->comme 4 mais avec des onglets qui peuvent faire 40 de haut

$styleOnglet=array(
	0 => array("images/onglets0.gif", "#DBDBDB", "#A5A5A5"),
	2 => array("images/onglets2.gif", "#45F56B", "#1CD44B"),
	4 => array("images/onglets4.gif", "#12EEF1", "#00969F"),
	6 => array("images/onglets6.gif", "#0BBBFF", "#0072AA"),
	640 => array("images/onglets6-40.gif", "#49b2e1", "#0072AA"),
	40 => array("images/onglets4-40.gif", "#12EEF1", "#00969F")
	);

//variables permettant  la classe de fonctionner
$numFenetreOnglets=1;
$tabulEncours=0;

class fenetreOnglets {
	
	var $serieOnglets;
	var $nomConteneur;
	var $numOngletSel;
	var $numTab;
	var $hauteurOnglets, $premEspace, $interOnglet, $fichierOnglets, $largeurBordureOnglet, $posSel, $posNonSel, $posSurvol;
	var $txtEnteteDivFen;
	var $tabOnglets;
	var $divIsEncours;
	var $styleOnglet;
	var $topOnglets;
	var $coulBordure;
	var $numDivOnglets;
	var $alignOnglets;
	
	//constructeur de la classe
	//initialisation des variables
	function fenetreOnglets($nomConteneur, $left, $top, $largeur, $hauteur, $alignement,
			$hauteurOnglets, $premEspace, $interOnglet, $fichierOnglets, $largeurBordureOnglet, $posSel, $posNonSel, $posSurvol, $coulBordure, $styleOnglet="",$serieOnglets=0) {
		
		global $numFenetreOnglets, $tabulEncours;

		//pour tenir compte des ventuels multi onglets qui serait chargs  postriori (en ajax par exemple)
		if ($serieOnglets!=0) $numFenetreOnglets=$serieOnglets;
		
		$this->serieOnglets=$serieOnglets;
		$this->nomConteneur=$nomConteneur;
		$this->numTab=1;
		$this->numOngletSel=1;
		$this->hauteurOnglets=$hauteurOnglets;
		$this->numDivOnglets=$numFenetreOnglets; //$serieOnglets; //$numFenetreOnglets;
		$this->premEspace=$premEspace;
		$this->interOnglet=$interOnglet;
		$this->fichierOnglets=$fichierOnglets;
		$this->largeurBordureOnglet=$largeurBordureOnglet;
		$this->largeur=$largeur;
		$this->posSel=$posSel;
		$this->posNonSel=$posNonSel;
		$this->posSurvol=$posSurvol;
		$this->styleOnglet=$styleOnglet;
		$this->tabOnglets=array();
		$this->divIsEncours=false;
		$this->topOnglets=$top;
		$this->coulBordure=$coulBordure;
		$this->alignOnglets=$alignement;
		$height="";
		if ($hauteur!=0) $height="height:".$hauteur."px;";
//***
		//$this->txtEnteteDivFen="<div id=\"$nomConteneur\" style=\"position:absolute;top:".$top."px;left:".$left."px;width:".$largeur."px;$height\">".CR;
		//prpare l'alignement des onglets
		switch (strtolower($alignement)) {
			case 'c' : //centre
				//$preDiv="<div style=\"position:relative;left:50%;\">".BR;
				$preDiv="<div id=\"refC_$nomConteneur\" style=\"position:relative;margin:0 auto;/*left:100px;*/width:1px\">";
				$alignHoriz="left:".(-intval($largeur/2)+$left)."px";
				break;				
			case 'cp' : //centre page
				$preDiv="<div id=\"divPos$serieOnglet\" style=\"position:relative;left:200px;\">";
			$preDiv.= "\n<script language=\"JavaScript\">
if (document.body) {
	var larg$serieOnglet = (document.body.clientWidth);
} 
else {
	var larg$serieOnglet = (window.innerWidth);
}
document.getElementById('divPos$serieOnglet').style.left=parseInt(larg$serieOnglet/2)+'px';
</script>
";
				$alignHoriz="left:".(-intval($largeur/2)+$left)."px";
				break;
			case 'd' : //droit
				$preDiv="<div style=\"position:relative;left:98%;\">".BR;
				//$preDiv="<div style=\"position:relative;left:98%;\">";
				$alignHoriz="left:-".$largeur."px";
				break;
			case '' :
			case 'g' : //gauche
			default:
				$preDiv="<div style=\"position:relative;left:Opx;\">".BR;
				//$preDiv="<div style=\"position:relative;left:Opx;\">";
				$alignHoriz="left:".$left."px";
				break;
		}
		//$this->txtEnteteDivFen="<div id=\"$nomConteneur\" style=\"position:relative;top:".$top."px;left:".$left."px;width:".$largeur."px;$height>".CR; // style=\"position:relative;\"
		$this->txtEnteteDivFen=$preDiv."<div id=\"$nomConteneur\" style=\"position:relative;top:".$top."px;".$alignHoriz.";width:".$largeur."px;$height\">".CR; // style=\"position:relative;\"
//***
		$numFenetreOnglets++;
	}
	
	// fermeture de la balise DIV pour le conteneur gnral 
	function finFenetreOnglets() {
		global $tabulEncours;
		
		if ($this->divIsEncours) $this->finDivOnglet();
		$this->afficheOnglets($this->tabOnglets, $this->fichierOnglets, $this->largeurBordureOnglet, $this->posSel, $this->posNonSel, $this->posSurvol, 
			$this->premEspace, $this->interOnglet);
		$tabulEncours--;
		echo CR.str_repeat("\t", $tabulEncours)."</div>".CR;
		echo str_repeat("\t", $tabulEncours)."<!-- fin de la fenetre d'onglets \"".str_replace(">", "", $this->nomConteneur)."\"  -->".CR.CR;
		//si centr, dcalage  la vole aprs coup...
		if (strtolower($this->alignOnglets)=="c") ;
			//echo "<script language=\"JavaScript\">var divRef=document.getElementById('refC_".$this->nomConteneur."');demiLarg=parseInt(document.body.scrollWidth/2);divRef.style.left=demiLarg+'px';</script>";
			//alertJS($this->nomConteneur.$this->largeur);
			//centreDivOngletSurPage("refC_".$this->nomConteneur, $this->largeur);
			/*
			echo "			<script language=\"JavaScript\">
				var divRef=document.getElementById('refC_".$this->nomConteneur."');
				if (document.body) var largFen=(document.body.clientWidth); 
				else var largFen=(window.innerWidth);
				if (parseInt(largFen)>".$this->largeur.") divRef.style.left=parseInt(largFen/2)+'px';
				else divRef.style.left=parseInt(".$this->largeur."/2)+'px';
			</script>";
			*/
	}
//document.getElementById('refC_".$this->nomConteneur."').style.left
	// cration de l'entete de la DIV d'un onglet
	function enteteDivOnglet($titre, $largeurOnglet, $couleurFond, $select=false, $fonctionJSsiClick="", $styleSup="") {
		global $tabulEncours, $JS_Ok;
		
		if ($select==="") $select=false;
		//if (!$JS_Ok) 
		//echo "this->numDivOnglets:".$this->numDivOnglets;
		fonctionOngletJS($this->numDivOnglets); //si Fonctions JS pas appeles, on l'appelle...
		
		//ferme automatiquement le div prcdent (si ncessaire) de l'onglet pour en ouvrir un nouveau
		if ($this->divIsEncours) $this->finDivOnglet();
		//si c'est le premier onglet, on rajoute l'entte de la div contenant les onglets 
		if ($this->numTab==1) {
			echo CR.CR."<!-- ============================================================================================ -->".CR;
			echo str_repeat("\t", $tabulEncours)."<!-- Entete de la fenetre d'onglets \"".str_replace(">", "", $this->nomConteneur)."\"  -->".CR;
			echo str_repeat("\t", $tabulEncours).$this->txtEnteteDivFen;
			$tabulEncours++;
		}
		$indexZ=$this->numTab;
		$this->tabOnglets[]=array('titre' => $titre, 'largeur' => $largeurOnglet-(2*$this->largeurBordureOnglet), 'fonctionJS' => $fonctionJSsiClick);
		if ($select) $this->numOngletSel=$this->numTab;
		echo CR.str_repeat("\t", $tabulEncours)."<!-- Onglet \"".str_replace(">", "", $titre)."\"  -->".CR;

//***
/*		echo str_repeat("\t", $tabulEncours)."<div id=\"tab".$this->numDivOnglets."_".$this->numTab.
			"\" style=\"position:absolute;top:".$this->hauteurOnglets."px;width:100%;height:95%;background-color:$couleurFond;".
			"z-index:$indexZ;\">".CR;
*/
		/*
		echo str_repeat("\t", $tabulEncours)."<div id=\"tab".$this->numDivOnglets."_".$this->numTab.
			"\" style=\"position:absolute;top:".$this->hauteurOnglets."px;width:100%;background-color:$couleurFond;".
			"z-index:$indexZ;\">".CR;
		*/
		
		/*
		echo str_repeat("\t", $tabulEncours)."<div id=\"tab".$this->numDivOnglets."_".$this->numTab.
			"\" style=\"position:absolute;top:".$this->hauteurOnglets."px;width:100%;background-color:$couleurFond;".
			"display:none;\">".CR;
		*/
		if ($this->coulBordure!="") $coulBordure="border:1px SOLID ".$this->coulBordure.";";
		
//changement en relative...		
		echo str_repeat("\t", $tabulEncours)."<div id=\"tab".$this->numDivOnglets."_".$this->numTab."\" ".
			"style=\"position:relative;top:".$this->hauteurOnglets."px;width:100%;background-color:$couleurFond;".
			"display:none;$coulBordure;$styleSup\">".CR;
		
//***
		$tabulEncours++;
		$this->numTab++;
		$this->divIsEncours=true;
	}
	
	// fermeture de la balise DIV pour un onglet
	//  facultatif car la DIV est automatiquement ferme  si on rouvre une DIV ou qu'on ferme le conteneur gnral
	function finDivOnglet() {
		global $tabulEncours;
		
		$this->divIsEncours=false;
		$tabulEncours--;
		echo CR.str_repeat("\t", $tabulEncours)."</div>".CR;
		//echo str_repeat("\t", $tabulEncours)."<!-- fin de DIV d'onglet -->".CR;
	}
	
	// cration de la DIV contenant les onglets  cliquer
	function afficheOnglets($tabOnglets, $fichierOnglets, $largeurBordureOnglet, $posSel, $posNonSel, $posSurvol, $premEspace, $interOnglet) {
		global $tabulEncours;
		
		foreach ($tabOnglets as $onglet) {
			$onglets.="|".$onglet['titre'];
		}
		$onglets.="|";
		echo CR.str_repeat("\t", $tabulEncours)."<!-- affichage du DIV des onglets $onglets -->".CR;
		//echo str_repeat("\t", $tabulEncours)."<div  style=\"position:absolute;top:0px;width:100%;height:".($this->hauteurOnglets+1)."px;z-index:20;\">".CR;
		echo str_repeat("\t", $tabulEncours)."<div  style=\"position:absolute;top:0px;left:".$premEspace."px;height:".($this->hauteurOnglets+1)."px;\">".CR;
		//entete tableau
		//echo str_repeat("\t", $tabulEncours+1)."<table align=\"left\" valign=\"center\" cellspacing=0 cellpadding=0 border=0 height=".($this->hauteurOnglets+1).">".CR.
		echo str_repeat("\t", $tabulEncours+1)."<table align=\"left\" valign=\"center\" cellspacing=0 cellpadding=0 border=0 height=".($this->hauteurOnglets+1).">".CR.
			str_repeat("\t", $tabulEncours+2)."<tr>".CR;
		//premier espace
		//echo str_repeat("\t", $tabulEncours+3)."<td width=$premEspace style=\"border-bottom:1px SOLID #01649F;\">&nbsp;</td>".CR;
		$idxOnglet=1;//$this->numTab;
		$nbOnglets=count($tabOnglets);
		//pour chaque onglet
		foreach ($tabOnglets as $onglet) {
			$titre=$onglet['titre'];
			$largOnglet=$onglet['largeur'];
			$fonctionJS=$onglet['fonctionJS'];
			if (substr($fonctionJS,-1,1)!=';') $fonctionJS.=";"; //rajoute un ;  la fin de la commande JS associe  un onglet
			$posFondG="background-position:0% -".$posNonSel."px;";
			$posFondD="background-position:100% -".$posNonSel."px;";
			/*
			$posFond_G="background-position:0% -".($posNonSel + $this->hauteurOnglets -1)."px;";
			$posFond_D="background-position:100% -".($posNonSel + $this->hauteurOnglets -1)."px;";
			$styleFond_G="style=\"background:url($fichierOnglets) no-repeat left top;$posFond_G\"";
			$styleFond_D="style=\"background:url($fichierOnglets) no-repeat right top;$posFond_D\"";
			*/
			
			$largeurOnglet="";
			if ($largOnglet!=0) $largeurOnglet= "width=$largOnglet";
			if ($this->styleOnglet!="") {
				$classOuStyle="style";
				if (strpos($this->styleOnglet, ":")===false) $classOuStyle="class";
				$txtTitre="<span $classOuStyle=\"".$this->styleOnglet."\">$titre</span>";
				}
			else $txtTitre=$titre;
		
			//partie gauche de l'onglet
			echo str_repeat("\t", $tabulEncours+3).
				"<td id=\"gauche".$this->numDivOnglets."_$idxOnglet\" width=$largeurBordureOnglet ".
				"style=\"cursor:pointer;background:url($fichierOnglets) no-repeat left top;$posFondG\" ".
				"onClick=\"swapId(".$this->numDivOnglets.", $idxOnglet, ".$posSel.", ".$posNonSel.", ".$this->hauteurOnglets.", '$fichierOnglets');$fonctionJS\">&nbsp;</td>".CR;
			
			//partie droite de l'onglet
			echo str_repeat("\t", $tabulEncours+3).
				"<td id=\"onglet".$this->numDivOnglets."_$idxOnglet\" align=\"center\" ".
				"onClick=\"swapId(".$this->numDivOnglets.", $idxOnglet, ".$posSel.", ".$posNonSel.", ".$this->hauteurOnglets.", '$fichierOnglets');$fonctionJS\" ".
				"onMouseOver=\"montreId(1, ".$this->numDivOnglets.", $idxOnglet, ".$posSel.", ".$posNonSel.", ".$posSurvol.");\" ".
				"onMouseOut=\"montreId(0, ".$this->numDivOnglets.", $idxOnglet, ".$posSel.", ".$posNonSel.", ".$posSurvol.");\" ".
				"style=\"cursor:pointer;background:url($fichierOnglets) no-repeat right top;".
				"padding:0px ".$largeurBordureOnglet."px 0px 0px;$posFondD\" $largeurOnglet>$txtTitre</td>".CR;
			
			//case inter-onglets (pas pour le dernier onglet)
			if ($idxOnglet < $nbOnglets) echo str_repeat("\t", $tabulEncours+3)."<td width=$interOnglet style=\"\"></td>".CR;//border-bottom:1px SOLID #01649F;
			$idxOnglet++;
		}
		
		//insertion d'une ligne de tableau supplmentaire pour intgrer la ligne du bas pour la bordure basse des onglets
		$idxOnglet=1;//$this->numTab;
		$nbOnglets=count($tabOnglets);
		echo "</tr><tr height=\"1\">".CR;
		foreach ($tabOnglets as $onglet) {
			echo "<td id=\"_gauche".$this->numDivOnglets."_$idxOnglet\" $styleFond_G></td>".CR;
			echo "<td id=\"_onglet".$this->numDivOnglets."_$idxOnglet\" $styleFond_D></td>".CR;
			if ($idxOnglet < $nbOnglets) echo "<td></td>".CR;
			$idxOnglet++;
		}
			
		echo str_repeat("\t", $tabulEncours+2)."</tr>".CR.str_repeat("\t", $tabulEncours+1)."</table>".CR;
		echo str_repeat("\t", $tabulEncours)."</div>".CR;
		//fermeture de la preDiv (pour placement sur alignement)
		echo str_repeat("\t", $tabulEncours)."</div>".CR;
		
		//pour compenser le dcalage perdu de la hauteur de la div des onglets
		//echo str_repeat("\t", $tabulEncours)."<div style=\"height:".($this->hauteurOnglets+$this->topOnglets)."px;\">".$this->topOnglets."</div>".CR;
		echo str_repeat("\t", $tabulEncours)."<div style=\"left:0px;height:".($this->hauteurOnglets+$this->topOnglets)."px;\"></div>".CR;
		echo str_repeat("\t", $tabulEncours)."<script language=\"JavaScript\">swapId(".$this->numDivOnglets.", ".$this->numOngletSel.", ".$this->posSel.", ".$this->posNonSel.", ".$this->hauteurOnglets.", '$fichierOnglets');</script>".CR;
	}
	
	// Slection d'un onglet par son titre ou par sonnumro d'ordre
	//  
	
	function selectOnglet($idOnglet) {
	//$this->tabOnglets[]=array('titre' => $titre, 'largeur' => $largeurOnglet-(2*$this->largeurBordureOnglet));
		$ongletSel="|";
		if (is_numeric($idOnglet)) { //choix par numro d'onglet
			$ongletSel=$idOnglet;
		}
		else foreach ($this->tabOnglets as $idx=> $onglet) { //choix par titre
			if (trim(strtolower($onglet['titre']))==trim(strtolower($idOnglet))) $ongletSel=$idx;
		} 	
		if ($ongletSel!="|") {
			echo "<script language=\"Javascript\">swapId(".$this->numDivOnglets.", ".($ongletSel).", ".$this->posSel.", ".$this->posNonSel.", ".$this->hauteurOnglets.", '".$this->fichierOnglets."');</script>".CR;
		}
	}
	
	//cherche si une variable "$nomVarGet" (onglet par exemple) a t transmise par GET (?onglet=2) 
	//			et si oui, on bascule l'onglet vers le n d'onglet voulu
	function basculeGetOnglet($nomVarGet) {
		if (isset($_GET[$nomVarGet])) $this->selectOnglet($_GET[$nomVarGet]);
	}

	//cherche si une variable "$nomVarGet" (onglet par exemple) a t transmise par GET (?onglet=2) ou par POST 
	//			et si oui, on bascule l'onglet vers le n d'onglet voulu
	function basculeGetouPostOnglet($nomVarGet) {
		$varOnglet="";
		if (!isset($_GET[$nomVarGet])) {
			if (isset($_POST[$nomVarGet])) $varOnglet=$_POST[$nomVarGet];
		}
		else $varOnglet=$_GET[$nomVarGet];
		if ($varOnglet!="") $this->selectOnglet($varOnglet);
	}
	
}	
//----------------- fin de la classe fenetreOnglets -------------------

function divFlottanteOmbre($titre, $contenu, $x, $y, $largeur, $hauteurTitre, $arrondiOnglet, $couleurFond, $couleurLigne, $lOmbreG, 
	$lOmbreD, $hOmbreBasse, $ficImage, $ficImage2) {
	echo "
<div style=\"position:absolute;top:".$y."px; left:".$x."px;width:".$largeur."px;font-family:verdana;\">
	<table cellspacing=\"0\" cellpading=\"0\" border=\"0\">
		<tr height=\"$hauteurTitre\" valign=\"middle\" style=\"font-weight:bold;font-size:9pt;font-family:verdana;background:url('$ficImage') no-repeat left top;background-position:0% 0px;\">
			<td align=\"center\" width=\"".($largeur+$lOmbreG+$lOmbreD-$arrondiOnglet)."\" style=\"padding-left:".($arrondiOnglet+$lOmbreG)."px;\">$titre</td>
			<td width=\"".($arrondiOnglet+$lOmbreD)."\" style=\"background:url('$ficImage') no-repeat right top;background-position:100% 0px;\"></td>
		</tr>
		<tr>
			<td colspan=\"2\" style=\"font-size:8pt;padding:0px;\">
				<table width=\"".$largeur."\" cellspacing=\"0\" cellpading=\"0\" border=\"0\" style=\"padding:0px;\">

					<tr valign=\"middle\" style=\"font-size:8pt;background:url('$ficImage2') repeat-y left top;background-position:0% 0px;\">
						<td width=\"".$lOmbreG."\" style=\"padding:0px;\"></td>
						<td width=\"".($largeur-$lOmbreG-$lOmbreD)."\" style=\"background:url('');background-color:".$couleurFond.";border-left:1px SOLID $couleurLigne;border-bottom:1px SOLID $couleurLigne;border-right:1px SOLID $couleurLigne;\">$contenu</td>
						<td width=\"".$lOmbreD."\" style=\"padding:0px;background:url('$ficImage2') repeat-y right top;background-position:100% 0px;\"></td>
					</tr>

				</table>
			</td>
		</tr>
		<tr height=\"$hOmbreBasse\" bgcolor=\"#C0A0A0\" valign=\"middle\" style=\"background:url('$ficImage') no-repeat left top;background-position:0% -47px;\">
			<td align=\"center\" style=\"padding-left:".$lOmbreG."px;\"></td>
			<td style=\"background:url('$ficImage') no-repeat right top;background-position:100% -47px;\"></td>
		</tr>
	</table>
</div>".CR;
}

function ongletSimple($titre, $largeur, $hauteurTitre, $txtAlign, $styleTxt, $arrondiOnglet, $espaceAvant, $ficImage) {
	return "
	<table cellspacing=\"0\" cellpading=\"0\" border=\"0\">
		<tr height=\"$hauteurTitre\" valign=\"middle\" style=\"font-weight:bold;font-size:9pt;font-family:verdana;\">
			<td style=\"width:".$espaceAvant."px\"></td>
			<td align=\"$txtAlign\" width=\"".($largeur-$arrondiOnglet)."\" style=\"padding-left:".$arrondiOnglet."px;background:url('$ficImage') no-repeat left top;background-position:0% 0px;$styleTxt\">$titre</td>
			<td style=\"width:".$arrondiOnglet."px; background:url('$ficImage') no-repeat right top;background-position:100% 0px;\"></td>
		</tr>
	</table>".CR;
}

?>