# -*- coding: utf-8 -*-
"""module définisant des sources de données externes pour la fédération d'utilisateur
"""
import glob, os
# chaque librairie python du module doit être nommé en <nom_attribut>.py et comporter une classe ExtAttr
# ayant une méthode get(attr_value) qui retourne le dn d'un utilisateur correspondant à la valeur de l'attribut

external_attrs = {}
attrs_dir = os.path.dirname(__file__)
for mod in glob.glob(os.path.join(attrs_dir, '*.py')):
    if not mod.endswith('__init__.py'):
        attr_name = os.path.splitext(os.path.basename(mod))[0]
        execfile(mod)
        external_attrs[attr_name] = ExtAttr(attr_name)
