#-*-coding:utf-8-*-

from os.path import isfile
from os import unlink
from scribe.importation.preferences import Preference, Preferences


class TestPrefs:
    """
        Test du gestionnaire de préférences
    """

    PREFS_FILE = '/tmp/test_prefs.txt'
    args1 = ['p1', 'liste', 'q1', ['a', 'b', 'c'], 'b']
    args2 = ['p2', 'texte', 'q2', '', 'hello']

    def setup_class(self):
        if isfile(self.PREFS_FILE):
            unlink(self.PREFS_FILE)
        p1 = Preference(*self.args1)
        p2 = Preference(*self.args2)
        self.prefs = (p1, p2)

    def test_create_prefs(self):
        p = Preferences(self.prefs, self.PREFS_FILE)
        assert p.get_default('p1') == 'b'
        assert p.get_default('p2') == 'hello'
        p.set_default('p1', 'c')
        p.set_default('p2', 'goodbye')
        p.save()

    def test_read_prefs(self):
        p = Preferences((Preference(*self.args1), Preference(*self.args2)), self.PREFS_FILE)
        assert p.get_default('p1') == 'c'
        assert p.get_default('p2') == 'goodbye'

    def teardown_class(self):
        if isfile(self.PREFS_FILE):
            unlink(self.PREFS_FILE)

