# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2009
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""
    librairie de gestion des comptes 'Autres'
"""
from ldap import MOD_REPLACE
from scribe.eoleuser import User, gen_common_attrs, send_first_mail
from pyeole.ssha import ssha_encode
from scribe.ldapconf import USER_DN, MAIL_DOMAIN, AUTRE_FILTER


class Autre(User):
    """
        classe pour les autres utilistateurs
    """
    _type = 'autres'
    filtre = "(&%s)" % AUTRE_FILTER
    must_args = ['login', 'password', 'nom', 'prenom']
    may_args = dict(mail='restreint',
                    civilite='',
                    date='',
                    entlogin=True,
                    )
    has_samba = False
    has_ftp = False

    def _add_scribe_user(self, login, **args):
        """
            Création "Autre"
        """
        mail = args['mail']
        if '@' not in mail:
            if mail in ['internet', 'restreint']:
                mail = "{0}@{1}".format(login, MAIL_DOMAIN[mail])
                maildir = self.get_maildir(login)
            else:
                mail = ''
                maildir = ''
        else:
            maildir = ''

        # on crée d'abord l'objet 'inetOrgPerson'
        # puis on le met à jour ;)
        user_dn = USER_DN % dict(uid=login, _type=self._type)
        userpassword = ssha_encode(args['password'])
        datas = [(('objectClass', 'inetOrgPerson'))]
        datas.append(('uid', login))
        datas.append(('cn', "%(prenom)s %(nom)s" % args ))
        datas.append(('sn', args['nom']))
        datas.append(('userPassword', userpassword))
        datas.append(('displayName', "%(prenom)s %(nom)s" % args ))
        datas.append(('givenName', args['prenom'] ))
        self.ldap_admin._add(user_dn, datas)
        # le reste
        datas = []
        objectclass = self._get_attr(login, 'objectClass')
        objectclass.extend(['autre', 'ENTPerson'])
        datas.append((MOD_REPLACE, 'objectClass', objectclass))
        datas.extend(gen_common_attrs(login, **args))
        datas.append((MOD_REPLACE, 'sambaLMPassword', 'x' ))
        datas.append((MOD_REPLACE, 'sambaNTPassword', 'x' ))
        if mail != '':
            datas.append((MOD_REPLACE, 'mail', mail))
        if maildir != '':
            datas.append((MOD_REPLACE, 'mailHost', 'localhost'))
            datas.append((MOD_REPLACE, 'mailDir', maildir))
        self.ldap_admin._modify(user_dn, datas)
        if maildir != '':
            send_first_mail(mail)

    def _add_perso(self, login, **args):
        """
            pas de dossier
        """
        pass

    def _update(self, login, **args):
        """
            Mise à niveau compte invité (importation)
        """
        #user_dn = USER_DN % dict(uid=login, _type=self._type)
        #datas = []
        #if not_empty(args, 'mail_acad'):
        #    datas.append((MOD_REPLACE, 'FederationKey',
        #                  args['mail_acad'].lower()))
        #if not_empty(args, 'int_id'):
        #    datas.append((MOD_REPLACE, 'intid', args['int_id'] ))
        #datas.append((MOD_REPLACE, 'LastUpdate', format_current_date()))
        #self.ldap_admin._modify(user_dn, datas)
        self._touch(login)

    def _get_autres(self, attrs=['uid']):
        """
            Renvoie les user 'Autres'
        """
        return self._get_users(filtre=self.filtre, attrs=attrs)

