#-*-coding:utf-8-*-

from scribe.storage import init_store , Eleve, Responsable, Adresse, \
JointureResponsableEleve, Classe, Niveau, Enseignant, EnsClasse, \
JointureClasseEnseignant, Matiere, JointureMatiereEnseignant, \
Administratif, Service, Groupe, JointureGroupeUser

e1 =  {'nom':u'__test__nom',
       'prenom':u'prenom__eleve__',
       'date':u'12/12/1983',
       #'classe':u'classname',
       #'niveau':u'niveau_test',
       'civilite':u'0',
       #'domaine':u'internet',
       'numero':u'1',
       'int_id':u'test',
       }

en1 = dict(int_id = u'1',
    nom = u'ens_nom',
    prenom = u'ens_prenom',
    date = u'01/01/1111',
    )

r1 = dict(int_id = u'r1',
    nom = u'nom',
    prenom = u'prenom',
    civilite = u'1',
    mail = u'resp@yahoo.fr',
    telephone = u'888',
    #tel_portable = u'')
    #tel_pro = u'')
    id_adresse = u'a1',
    #adresse = reference()
    )

a1 = dict(int_id = u'a1',
    adresse = u'rue des boulets',
    code_postal = u'75000',
    ville = u'paris',
    pays = u'france',
    )

r2 = dict(int_id = u'r2',
    nom = u'nom2',
    prenom = u'prenom2',
    civilite = u'0',
    mail = u'resp@free.fr',
    telephone = u'888',
    tel_portable = u'133',
    tel_pro = u'222',
    #id_adresse = u'a1',
    #adresse = reference()
    )

a2 = dict(int_id = u'a2',
    adresse = u'rue de Paris',
    code_postal = u'21000',
    ville = u'dijon',
    pays = u'france',
    )

adm = dict(int_id = u'admin1',
    nom = u'admin',
    prenom = u'prenom',
    date = u'01/01/1111',
#    civilite = text(default=u'')
#    mail = text(default=u'')
#    nom_patronymique = text(default=u'')
#    groupe = reference()
#    login = text(default=u'')
    )

def setup_module(module):
    module.library_store = init_store()


class TestStorage:

    def setup_class(cls):
        # toutes les initialisations ICI
        cls.eleve1 = Eleve(store=library_store, **e1)
        cls.resp1 = Responsable(store=library_store, **r1)
        cls.resp2 = Responsable(store=library_store, **r2)
        cls.add1 = Adresse(store=library_store, **a1)
        cls.add2 = Adresse(store=library_store, **a2)
        cls.niveau = Niveau(store=library_store, nom=u'3eme')
        cls.classe = Classe(store=library_store, nom=u'3e1', niveau=cls.niveau)
        cls.ens = Enseignant(store=library_store, **en1)

    def test_eleve(self):
        assert self.eleve1.prenom == e1['prenom']

    def test_add_parent(self):
        assert self.resp1.nom == r1['nom']

    def test_add_adresse(self):
        assert self.add1.pays == a1['pays']

    def test_affecte_adresse(self):
        resp = library_store.findFirst(Responsable,
            Responsable.id_adresse==self.add1.int_id)
        assert resp == self.resp1
        # initialisation reference
        resp.adresse = self.add1
        assert resp.adresse.ville == a1['ville']
        self.resp2.adresse = self.add2

    def test_jointure_responsable_eleve(self):
        JointureResponsableEleve(store=library_store, eleve=self.eleve1, responsable=self.resp1)
        JointureResponsableEleve(store=library_store, eleve=self.eleve1, responsable=self.resp2)
        assert self.resp1.get_eleves() == [self.eleve1]

    def test_add_groupes(self):
        assert self.classe.niveau.nom == u'3eme'

    def test_affectation(self):
        self.eleve1.classe = self.classe
        self.eleve1.niveau = self.niveau
        assert self.eleve1.classe.nom == u'3e1'
        assert self.niveau.get_eleves() == [self.eleve1]
        assert self.classe.get_eleves() == [self.eleve1]

    def test_add_enseignant(self):
        assert self.ens.nom == en1['nom']

    def test_jointure_ens_classe(self):
        cl = EnsClasse(store=library_store, nom=u'classe1')
        JointureClasseEnseignant(store=library_store, classe=cl, enseignant=self.ens)
        # FIXME : revoir l'API ?
        assert self.ens.get_classes()[0].classe == cl

    def test_jointure_ens_mat(self):
        mat = Matiere(store=library_store, nom=u'mat')
        JointureMatiereEnseignant(store=library_store, matiere=mat, enseignant=self.ens)
        assert self.ens.get_matieres() == [mat]


    def test_add_administratif(self):
        admin = Administratif(store=library_store, **adm)
        grp = Service(store=library_store, nom=u'grp', description=u'descr')
        admin.groupe = grp
        assert admin.groupe.description == u'descr'

    def test_option(self):
        opt = Groupe(store=library_store, nom=u'option', description=u'option')
        assert opt.count_members() == 0
        JointureGroupeUser(store=library_store, groupe=opt, user=self.eleve1)
        JointureGroupeUser(store=library_store, groupe=opt, user=self.ens)
        assert self.eleve1.get_groupes()[0] == opt
        assert self.ens.get_groupes()[0] == opt
        assert opt.count_members() == 2

