%if %%is_defined('activer_accounting')
# declaration variable
activer_accounting=$(CreoleGet activer_accounting)

 %if %%activer_accounting == 'oui'

#!/bin/sh


#####################################################################
## Script d'accounting PSIN
#####################################################################

#########################################
##
## variables globales
##
PROXY_PORTS="80,8080,443,3128"
WEB_PORTS="80,443"
FTP_PORTS="20,21"
LDAP_PORTS="389,636"
POP3_PORTS="110,995"
IMAP_PORTS="143,993"
SMTP_PORTS="25,465"
MCAFEE_EPO="12081"
MCAFEE_PORTS="12443,12445"
SAMBA_PORTS="135,137,138,139,445"
DNS_PORTS="53"
SSH_PORTS="22"
AD_PORTS="135,1024:1124,3268,3269,88,464"
NTP_PORTS="123"
WSUS_PORTS="8530,8531"
ZEPHIR_PORTS="8090,7080,8070"
RADIUS_PORTS="1812,1813"
VISIO_PORTS="1719,1720,1503,3230:3250,1320:1344,10002:10049,5555:5574,2326:2487"

#########################################
#########################################
# déclaration variables des dicos

activer_firewall=$(CreoleGet activer_firewall non)
  %if %%activer_firewall == 'oui'

   %if %%is_defined('serveurs_dns_nationaux_ip')
serveurs_dns_nationaux_ip=$(CreoleGet serveurs_dns_nationaux_ip)
   %end if
   %if %%is_defined('serveurs_ntp_nationaux_ip')
serveurs_ntp_nationaux_ip=$(CreoleGet serveurs_ntp_nationaux_ip)
   %end if
   %if %%is_defined('serveurs_proxies_nationaux_ip')
serveurs_proxies_nationaux_ip=$(CreoleGet serveurs_proxies_nationaux_ip)
   %end if
   %if %%is_defined('serveurs_proxies_pro_ip')
serveurs_proxies_pro_ip=$(CreoleGet serveurs_proxies_pro_ip)
   %end if
   %if %%is_defined('serveurs_ldap_nationaux_ip')
serveurs_ldap_nationaux_ip=$(CreoleGet serveurs_ldap_nationaux_ip)
   %end if
   %if %%is_defined('serveurs_synchro_ldap_nationaux_ip')
serveurs_synchro_ldap_nationaux_ip=$(CreoleGet serveurs_synchro_ldap_nationaux_ip)
   %end if
   %if %%is_defined('serveurs_melanie2_nationaux_ip')
serveurs_melanie2_nationaux_ip=$(CreoleGet serveurs_melanie2_nationaux_ip)
   %end if
   %if %%is_defined('serveurs_eole_nationaux_ip')
serveurs_eole_nationaux_ip=$(CreoleGet serveurs_eole_nationaux_ip)
   %end if
   %if %%is_defined('serveurs_radius_nationaux_ip')
serveurs_radius_nationaux_ip=$(CreoleGet serveurs_radius_nationaux_ip)
   %end if
   %if %%is_defined('serveurs_mcafee_nationaux_ip')
serveurs_mcafee_nationaux_ip=$(CreoleGet serveurs_mcafee_nationaux_ip)
   %end if
   %if %%is_defined('serveurs_clamav_nationaux_ip')
serveurs_clamav_nationaux_ip=$(CreoleGet serveurs_clamav_nationaux_ip)
   %end if
   %if %%is_defined('serveurs_wsus_nationaux_ip')
serveurs_wsus_nationaux_ip=$(CreoleGet serveurs_wsus_nationaux_ip)
   %end if


   %if %%is_defined('seth_dist_serveurs_ip')
seth_dist_serveurs_ip=$(CreoleGet seth_dist_serveurs_ip)
   %end if
   %if %%is_defined('seth_local_serveurs_ip')
seth_local_serveurs_ip=$(CreoleGet seth_local_serveurs_ip)
   %end if
   %if %%is_defined('visio_pack40_ip')
visio_pack40_ip=$(CreoleGet visio_pack40_ip)
   %end if


eth0=$(CreoleGet nom_zone_eth0)
   %if %%is_defined('nom_zone_eth1')
eth1=$(CreoleGet nom_zone_eth1)
   %end if
   %if %%is_defined('nom_zone_eth2')
eth2=$(CreoleGet nom_zone_eth2)
   %end if

#########################################

## suppression de toutes les tables ipset
ipset -X

# serveurs dns
   %if %%is_defined('serveurs_dns_nationaux_ip')
    %if not %%is_empty(%%serveurs_dns_nationaux_ip)
ipset -N dns iphash --hashsize 32 --probes 1
     %for %%dns_iter in %%serveurs_dns_nationaux_ip
ipset -A dns %%dns_iter
     %end for
    %end if
   %end if

# serveurs ntp
   %if %%is_defined('serveurs_ntp_nationaux_ip')
    %if not %%is_empty(%%serveurs_ntp_nationaux_ip)
ipset -N ntp iphash --hashsize 32 --probes 1
     %for %%ntp_iter in %%serveurs_ntp_nationaux_ip
ipset -A ntp %%ntp_iter
     %end for
    %end if
   %end if

# proxies nationaux
   %if %%is_defined('serveurs_proxies_nationaux_ip')
    %if not %%is_empty(%%serveurs_proxies_nationaux_ip)
ipset -N proxies iphash --hashsize 32 --probes 1
     %for %%proxy_iter in %%serveurs_proxies_nationaux_ip
ipset -A proxies %%proxy_iter
     %end for
    %end if
   %end if

# proxies pro
   %if %%is_defined('serveurs_proxies_pro_ip')
    %if not %%is_empty(%%serveurs_proxies_pro_ip)
ipset -N proxiespro iphash --hashsize 32 --probes 1
     %for %%proxypro_iter in %%serveurs_proxies_pro_ip
ipset -A proxiespro %%proxypro_iter
     %end for
    %end if
   %end if

# serveurs LDAP
   %if %%is_defined('serveurs_ldap_nationaux_ip')
    %if not %%is_empty(%%serveurs_ldap_nationaux_ip)
ipset -N ldap iphash --hashsize 32 --probes 1
     %for %%ldap_iter in %%serveurs_ldap_nationaux_ip
ipset -A ldap %%ldap_iter
     %end for
    %end if
   %end if

# serveurs synchro LDAP national
   %if %%is_defined('serveurs_synchro_ldap_nationaux_ip')
    %if not %%is_empty(%%serveurs_synchro_ldap_nationaux_ip)
ipset -N syncldap iphash --hashsize 32 --probes 1
     %for %%syncldap_iter in %%serveurs_synchro_ldap_nationaux_ip
ipset -A syncldap %%syncldap_iter
     %end for
    %end if
   %end if

# serveurs melanie2
   %if %%is_defined('serveurs_melanie2_nationaux_ip')
    %if not %%is_empty(%%serveurs_melanie2_nationaux_ip)
ipset -N melanie2  iphash --hashsize 32 --probes 1
     %for %%melanie2_iter in %%serveurs_melanie2_nationaux_ip
ipset -A melanie2 %%melanie2_iter
     %end for
    %end if
   %end if

# serveurs zephir national
   %if %%is_defined('serveurs_eole_nationaux_ip')
    %if not %%is_empty(%%serveurs_eole_nationaux_ip)
ipset -N zephir iphash --hashsize 32 --probes 1
     %for %%zephir_iter in %%serveurs_eole_nationaux_ip
ipset -A zephir %%zephir_iter
     %end for
    %end if
   %end if

# serveurs radius national
   %if %%is_defined('serveurs_radius_nationaux_ip')
    %if not %%is_empty(%%serveurs_radius_nationaux_ip)
ipset -N radius iphash --hashsize 32 --probes 1
     %for %%radius_iter in %%serveurs_radius_nationaux_ip
ipset -A radius %%radius_iter
     %end for
    %end if
   %end if

## serveurs McAfee
   %if %%is_defined('serveurs_mcafee_nationaux_ip')
    %if not %%is_empty(%%serveurs_mcafee_nationaux_ip)
ipset -N mcafee iphash --hashsize 32 --probes 1
     %for %%mcafee_iter in %%serveurs_mcafee_nationaux_ip
ipset -A mcafee %%mcafee_iter
     %end for
    %end if
   %end if

# serveurs clamav national
   %if %%is_defined('serveurs_clamav_nationaux_ip')
    %if not %%is_empty(%%serveurs_clamav_nationaux_ip)
ipset -N clamav iphash --hashsize 32 --probes 1
     %for %%clamav_iter in %%serveurs_clamav_nationaux_ip
ipset -A clamav %%clamav_iter
     %end for
    %end if
   %end if

# serveurs wsus national
   %if %%is_defined('serveurs_wsus_nationaux_ip')
    %if not %%is_empty(%%serveurs_wsus_nationaux_ip)
ipset -N wsus iphash --hashsize 32 --probes 1
     %for %%wsus_iter in %%serveurs_wsus_nationaux_ip
ipset -A wsus %%wsus_iter
     %end for
    %end if
   %end if

# équipements visio
   %if %%is_defined('visio_pack40_ip')
    %if not %%is_empty(%%visio_pack40_ip)
ipset -N visio iphash --hashsize 32 --probes 1
     %for %%visio_iter in %%visio_pack40_ip
ipset -A visio %%visio_iter
     %end for
    %end if
   %end if

# serveurs seth distants
   %if %%is_defined('seth_dist_serveurs_ip')
    %if not %%is_empty(%%seth_dist_serveurs_ip)
ipset -N sethdist iphash --hashsize 32 --probes 1
     %for %%sethdist_iter in %%seth_dist_serveurs_ip
ipset -A sethdist %%sethdist_iter
     %end for
    %end if
   %end if
# serveurs seth distants (variable SETH)
   %if %%is_defined('ad_servers_ip')
    %if not %%is_empty(%%ad_servers_ip)
ipset -N seth iphash --hashsize 32 --probes 1
     %for %%seth_iter in %%ad_servers_ip
ipset -A seth %%seth_iter
     %end for
    %end if
   %end if

# serveurs seth locaux
   %if %%is_defined('seth_local_serveurs_ip')
    %if not %%is_empty(%%seth_local_serveurs_ip)
ipset -N sethloc iphash --hashsize 32 --probes 1
     %for %%sethloc_iter in %%seth_local_serveurs_ip
ipset -A sethloc %%sethloc_iter
     %end for
    %end if
   %end if


module_type=$(CreoleGet module_type amon)
variante_type=$(CreoleGet variante_type essl)
   %if %%module_type == 'amon'
    %if %%is_defined('type_amon')
    type_amon=$(CreoleGet type_amon 2zones-essl)
    %end if

########################################################################
###              Gestion du traffic par ports                        ###
########################################################################
# Declaration des chaines traversantes 'ports'
/sbin/iptables -N ports_forward_IN
/sbin/iptables -N ports_forward_OUT


###########################################################################
################### Flux Pare-feu #########################################
# Ports pare-feu depuis/vers le Wan
/sbin/iptables -I FORWARD -o $eth0 -m comment --comment "ACC-ports_PF_OUT" -j ports_forward_OUT
/sbin/iptables -I FORWARD -i $eth0 -m comment --comment "ACC-ports_PF_IN" -j ports_forward_IN

#** Protocole DNS **
/sbin/iptables -A ports_forward_IN -p tcp -m multiport --sport $DNS_PORTS -m comment --comment "ACC-ports_PF_in-dns-clients"
/sbin/iptables -A ports_forward_OUT -p tcp -m multiport --dport $DNS_PORTS -m comment --comment "ACC-ports_PF_out-dns-clients"
/sbin/iptables -A ports_forward_IN -p udp -m multiport --sport $DNS_PORTS -m comment --comment "ACC-ports_PF_in-dns-clients"
/sbin/iptables -A ports_forward_OUT -p udp -m multiport --dport $DNS_PORTS -m comment --comment "ACC-ports_PF_out-dns-clients"
#** Protocole NTP **
/sbin/iptables -A ports_forward_IN -p udp -m multiport --sport $NTP_PORTS -m comment --comment "ACC-ports_PF_in-ntp-clients"
/sbin/iptables -A ports_forward_OUT -p udp -m multiport --dport $NTP_PORTS -m comment --comment "ACC-ports_PF_out-ntp-clients"
# ** Protocoles Proxy **
/sbin/iptables -A ports_forward_IN -p tcp -m multiport --sport $PROXY_PORTS -m comment --comment "ACC-ports_PF_in-proxies-http"
/sbin/iptables -A ports_forward_OUT -p tcp -m multiport --dport $PROXY_PORTS -m comment --comment "ACC-ports_PF_out-proxies-http"
# ** Protocoles FTP **
/sbin/iptables -A ports_forward_IN -p tcp -m multiport --sport $FTP_PORTS -m comment --comment "ACC-ports_PF_in-ftp"
/sbin/iptables -A ports_forward_OUT -p tcp -m multiport --dport $FTP_PORTS -m comment --comment "ACC-ports_PF_out-ftp"
# ** Protocoles LDAP **
/sbin/iptables -A ports_forward_IN -p tcp -m multiport --sport $LDAP_PORTS -m comment --comment "ACC-ports_PF_in-ldap(s)"
/sbin/iptables -A ports_forward_OUT -p tcp -m multiport --dport $LDAP_PORTS -m comment --comment "ACC-ports_PF_out-ldap(s)"
# ** Protocoles Messagerie **
/sbin/iptables -A ports_forward_IN -p tcp -m multiport --sport $POP3_PORTS -m comment --comment "ACC-ports_PF_in-melanie2-pop"
/sbin/iptables -A ports_forward_IN -p tcp -m multiport --sport $SMTP_PORTS -m comment --comment "ACC-ports_PF_in-melanie2-smtp"
/sbin/iptables -A ports_forward_IN -p tcp -m multiport --sport $IMAP_PORTS -m comment --comment "ACC-ports_PF_in-melanie2-imap"
/sbin/iptables -A ports_forward_OUT -p tcp -m multiport --dport $POP3_PORTS -m comment --comment "ACC-ports_PF_out-melanie2-pop"
/sbin/iptables -A ports_forward_OUT -p tcp -m multiport --dport $SMTP_PORTS -m comment --comment "ACC-ports_PF_out-melanie2-smtp"
/sbin/iptables -A ports_forward_OUT -p tcp -m multiport --dport $IMAP_PORTS -m comment --comment "ACC-ports_PF_out-melanie2-imap"
# ** Protocoles Zephir **
/sbin/iptables -A ports_forward_IN -p tcp -m multiport --sport $ZEPHIR_PORTS -m comment --comment "ACC-ports_PF_in-zephir"
/sbin/iptables -A ports_forward_OUT -p tcp -m multiport --dport $ZEPHIR_PORTS -m comment --comment "ACC-ports_PF_out-zephir"
# ** Protocoles Radius **
/sbin/iptables -A ports_forward_IN -p udp -m multiport --sport $RADIUS_PORTS -m comment --comment "ACC-ports_PF_in-radius"
/sbin/iptables -A ports_forward_OUT -p udp -m multiport --dport $RADIUS_PORTS -m comment --comment "ACC-ports_PF_out-radius"
# ** Protocoles  McAfee **
/sbin/iptables -A ports_forward_IN -p tcp -m multiport --sport $MCAFEE_PORTS -m comment --comment "ACC-ports_PF_in-mcafee-clients"
/sbin/iptables -A ports_forward_IN -p tcp --sport $MCAFEE_EPO -m comment --comment "ACC-ports_PF_in-mcafee-epo"
/sbin/iptables -A ports_forward_OUT -p tcp -m multiport --dport $MCAFEE_PORTS -m comment --comment "ACC-ports_PF_out-mcafee-clients"
/sbin/iptables -A ports_forward_OUT -p tcp --dport $MCAFEE_EPO -m comment --comment "ACC-ports_PF_out-mcafee-epo"
# ** Protocoles NetBIOS **
/sbin/iptables -A ports_forward_IN -p tcp -m multiport --sport $SAMBA_PORTS -m comment --comment "ACC-ports_PF_in-samba-clients"
/sbin/iptables -A ports_forward_OUT -p tcp -m multiport --dport $SAMBA_PORTS -m comment --comment "ACC-ports_PF_out-samba-clients"
/sbin/iptables -A ports_forward_IN -p udp -m multiport --sport $SAMBA_PORTS -m comment --comment "ACC-ports_PF_in-samba-clients"
/sbin/iptables -A ports_forward_OUT -p udp -m multiport --dport $SAMBA_PORTS -m comment --comment "ACC-ports_PF_out-samba-clients"
# ** Protocoles AD/Samba4 **
/sbin/iptables -A ports_forward_IN -p tcp -m multiport --sport $AD_PORTS -m comment --comment "ACC-ports_PF_in-ad-clients"
/sbin/iptables -A ports_forward_OUT -p tcp -m multiport --dport $AD_PORTS -m comment --comment "ACC-ports_PF_out-ad-clients"
/sbin/iptables -A ports_forward_IN -p udp -m multiport --sport $AD_PORTS -m comment --comment "ACC-ports_PF_in-ad-clients"
/sbin/iptables -A ports_forward_OUT -p udp -m multiport --dport $AD_PORTS -m comment --comment "ACC-ports_PF_out-ad-clients"
# ** Protocoles WSUS **
/sbin/iptables -A ports_forward_IN -p tcp -m multiport --sport $WSUS_PORTS -m comment --comment "ACC-ports_PF_in-wsus-clients"
/sbin/iptables -A ports_forward_OUT -p tcp -m multiport --dport $WSUS_PORTS -m comment --comment "ACC-ports_PF_out-wsus-clients"
# ** Protocoles Visio **
/sbin/iptables -A ports_forward_IN -p tcp -m multiport --sport $VISIO_PORTS -m comment --comment "ACC-ports_PF_in-visio-clients"
/sbin/iptables -A ports_forward_OUT -p tcp -m multiport --dport $VISIO_PORTS -m comment --comment "ACC-ports_PF_out-visio-clients"
/sbin/iptables -A ports_forward_IN -p udp -m multiport --sport $VISIO_PORTS -m comment --comment "ACC-ports_PF_in-visio-clients"
/sbin/iptables -A ports_forward_OUT -p udp -m multiport --dport $VISIO_PORTS -m comment --comment "ACC-ports_PF_out-visio-clients"


########################################################################
###            Gestion du traffic par Serveurs Nationaux             ###
########################################################################
#######################################################
# Declaration des chaines traversantes 'flux'
/sbin/iptables -N flux_forward_IN
/sbin/iptables -N flux_forward_OUT

###########################################################################
################### Flux Pare-feu #########################################
# Flux pare-feu depuis/vers le Wan
/sbin/iptables -I FORWARD -o $eth0 -m comment --comment "ACC-flux_out-morea" -j flux_forward_OUT
/sbin/iptables -I FORWARD -i $eth0 -m comment --comment "ACC-flux_in-morea" -j flux_forward_IN

# Flux serveurs dns nationaux
    %if %%is_defined('serveurs_dns_nationaux_ip')
     %if not %%is_empty(%%serveurs_dns_nationaux_ip)
/sbin/iptables -A flux_forward_OUT -m set --match-set dns dst -m comment --comment "ACC-flux_out-dnsnat"
/sbin/iptables -A flux_forward_IN -m set --match-set dns src -m comment --comment "ACC-flux_in-dnsnat"
     %end if
    %end if
# Flux serveurs ntp nationaux
    %if %%is_defined('serveurs_ntp_nationaux_ip')
     %if not %%is_empty(%%serveurs_ntp_nationaux_ip)
/sbin/iptables -A flux_forward_OUT -m set --match-set ntp dst -m comment --comment "ACC-flux_out-ntpnat"
/sbin/iptables -A flux_forward_IN -m set --match-set ntp src -m comment --comment "ACC-flux_in-ntpnat"
     %end if
    %end if
# Flux serveurs proxies nationaux
    %if %%is_defined('serveurs_proxies_nationaux_ip')
     %if not %%is_empty(%%serveurs_proxies_nationaux_ip)
/sbin/iptables -A flux_forward_OUT -m set --match-set  proxies dst -m comment --comment "ACC-flux_out-proxies"
/sbin/iptables -A flux_forward_IN -m set --match-set  proxies src -m comment --comment "ACC-flux_in-proxies"
     %end if
    %end if
# Flux serveurs LDAP
    %if %%is_defined('serveurs_ldap_nationaux_ip')
     %if not %%is_empty(%%serveurs_ldap_nationaux_ip)
/sbin/iptables -A flux_forward_OUT -m set --match-set ldap dst -m comment --comment "ACC-flux_out-ldap"
/sbin/iptables -A flux_forward_IN -m set --match-set ldap src -m comment --comment "ACC-flux_in-ldap"
    %end if
    %end if
# Flux serveurs synchro LDAP
    %if %%is_defined('serveurs_synchro_ldap_nationaux_ip')
     %if not %%is_empty(%%serveurs_synchro_ldap_nationaux_ip)
/sbin/iptables -A flux_forward_OUT -m set --match-set syncldap dst -m comment --comment "ACC-flux_out-synchro_ldap"
/sbin/iptables -A flux_forward_IN -m set --match-set syncldap src -m comment --comment "ACC-flux_in-synchro_ldap"
     %end if
    %end if
# Flux serveurs messagerie nationaux
    %if %%is_defined('serveurs_melanie2_nationaux_ip')
     %if not %%is_empty(%%serveurs_melanie2_nationaux_ip)
/sbin/iptables -A flux_forward_OUT -m set --match-set melanie2 dst -m comment --comment "ACC-flux_out-melanie2"
/sbin/iptables -A flux_forward_IN -m set --match-set melanie2 src -m comment --comment "ACC-flux_in-melanie2"
     %end if
    %end if
# Flux serveurs Zephir
    %if %%is_defined('serveurs_eole_nationaux_ip')
     %if not %%is_empty(%%serveurs_eole_nationaux_ip)
/sbin/iptables -A flux_forward_OUT -m set --match-set zephir dst -m comment --comment "ACC-flux_out-zephir"
/sbin/iptables -A flux_forward_IN -m set --match-set zephir src -m comment --comment "ACC-flux_in-zephir"
     %end if
    %end if
# Flux serveurs Radius
    %if %%is_defined('serveurs_radius_nationaux_ip')
     %if not %%is_empty(%%serveurs_radius_nationaux_ip)
/sbin/iptables -A flux_forward_OUT -m set --match-set radius dst -m comment --comment "ACC-flux_out-radius"
/sbin/iptables -A flux_forward_IN -m set --match-set radius src -m comment --comment "ACC-flux_in-radius"
     %end if
    %end if
# Flux serveurs McAfee
    %if %%is_defined('serveurs_mcafee_nationaux_ip')
     %if not %%is_empty(%%serveurs_mcafee_nationaux_ip)
/sbin/iptables -A flux_forward_OUT -m set --match-set mcafee dst -m comment --comment "ACC-flux_out-mcafee"
/sbin/iptables -A flux_forward_IN -m set --match-set mcafee src -m comment --comment "ACC-flux_in-mcafee"
     %end if
    %end if
# Flux serveurs wsus nationaux
    %if %%is_defined('serveurs_wsus_nationaux_ip')
     %if not %%is_empty(%%serveurs_wsus_nationaux_ip)
/sbin/iptables -A flux_forward_OUT -m set --match-set wsus dst -m comment --comment "ACC-flux_out-wsus"
/sbin/iptables -A flux_forward_IN -m set --match-set wsus src -m comment --comment "ACC-flux_in-wsus"
     %end if
    %end if
# Flux serveurs ClamAV
    %if %%is_defined('serveurs_clamav_nationaux_ip')
     %if not %%is_empty(%%serveurs_clamav_nationaux_ip)
/sbin/iptables -A flux_forward_OUT -m set --match-set clamav dst -m comment --comment "ACC-flux_out-clamav"
/sbin/iptables -A flux_forward_IN -m set --match-set clamav src -m comment --comment "ACC-flux_in-clamav"
     %end if
    %end if
# Flux serveurs Seth distants
    %if %%is_defined('seth_dist_serveurs_ip')
     %if not %%is_empty(%%seth_dist_serveurs_ip)
/sbin/iptables -A flux_forward_OUT -m set --match-set sethdist dst -m comment --comment "ACC-flux_out-sethdist"
/sbin/iptables -A flux_forward_IN -m set --match-set sethdist src -m comment --comment "ACC-flux_in-sethdist"
     %end if
    %end if
# Flux visio
    %if %%is_defined('visio_pack40_ip')
     %if not %%is_empty(%%visio_pack40_ip)
/sbin/iptables -A flux_forward_OUT -m set --match-set visio src -m comment --comment "ACC-flux_out-visio"
/sbin/iptables -A flux_forward_IN -m set --match-set visio dst -m comment --comment "ACC-flux_in-visio"
     %end if
    %end if

   %elif %%module_type in ('eSBL', 'seth')
########################################################################
###              Gestion du traffic par ports                        ###
########################################################################
# Declaration des chaines internes 'ports'
/sbin/iptables -N ports_IN
/sbin/iptables -N ports_OUT

# Flux globaux entrée/sortie eSBL-Seth
/sbin/iptables -I OUTPUT -o $eth0 -m comment --comment "ACC-ports_out-total" -j ports_OUT
/sbin/iptables -I INPUT -i $eth0 -m comment --comment "ACC-ports_in-total" -j ports_IN

# ** Protocoles Proxy **
/sbin/iptables -A ports_IN -p tcp -m multiport --sport $PROXY_PORTS -m comment --comment "ACC-ports_in-proxies"
/sbin/iptables -A ports_OUT -p tcp -m multiport --dport $PROXY_PORTS -m comment --comment "ACC-ports_out-proxies"
# ** Protocoles WEB **
/sbin/iptables -A ports_IN -p tcp -m multiport --dport $WEB_PORTS -m comment --comment "ACC-ports_in-web"
/sbin/iptables -A ports_OUT -p tcp -m multiport --dport $WEB_PORTS -m comment --comment "ACC-ports_out-web"
# ** Protocoles FTP **
/sbin/iptables -A ports_IN -p tcp -m multiport --dport $FTP_PORTS -m comment --comment "ACC-ports_in-ftp"
/sbin/iptables -A ports_OUT -p tcp -m multiport --dport $FTP_PORTS -m comment --comment "ACC-ports_out-ftp"
#** Protocole DNS **
/sbin/iptables -A ports_IN -p tcp -m multiport --dport $DNS_PORTS -m comment --comment "ACC-ports_in-dns-clients"
/sbin/iptables -A ports_OUT -p tcp -m multiport --dport $DNS_PORTS -m comment --comment "ACC-ports_out-dns-clients"
/sbin/iptables -A ports_IN -p udp -m multiport --dport $DNS_PORTS -m comment --comment "ACC-ports_in-dns-clients"
/sbin/iptables -A ports_OUT -p udp -m multiport --dport $DNS_PORTS -m comment --comment "ACC-ports_out-dns-clients"
#** Protocole SSH **
/sbin/iptables -A ports_IN -p tcp -m multiport --dport $SSH_PORTS -m comment --comment "ACC-ports_in-ssh-clients"
/sbin/iptables -A ports_OUT -p tcp -m multiport --dport $SSH_PORTS -m comment --comment "ACC-ports_out-ssh-clients"
#** Protocole LDAP **
/sbin/iptables -A ports_IN -p tcp -m multiport --sport $LDAP_PORTS -m comment --comment "ACC-ports_in-melanie2-ldap(s)"
/sbin/iptables -A ports_OUT -p tcp -m multiport --dport $LDAP_PORTS -m comment --comment "ACC-ports_out-melanie2-ldap(s)"
# ** Protocoles Melanie2 **
/sbin/iptables -A ports_IN -p tcp -m multiport --sport $POP3_PORTS -m comment --comment "ACC-ports_in-melanie2-pop"
/sbin/iptables -A ports_IN -p tcp -m multiport --sport $SMTP_PORTS -m comment --comment "ACC-ports_in-melanie2-smtp"
/sbin/iptables -A ports_IN -p tcp -m multiport --sport $IMAP_PORTS -m comment --comment "ACC-ports_in-melanie2-imap"
/sbin/iptables -A ports_OUT -p tcp -m multiport --dport $POP3_PORTS -m comment --comment "ACC-ports_out-melanie2-pop"
/sbin/iptables -A ports_OUT -p tcp -m multiport --dport $SMTP_PORTS -m comment --comment "ACC-ports_out-melanie2-smtp"
/sbin/iptables -A ports_OUT -p tcp -m multiport --dport $IMAP_PORTS -m comment --comment "ACC-ports_out-melanie2-imap"
# ** Protocoles  McAfee **
/sbin/iptables -A ports_IN -p tcp -m multiport --sport $MCAFEE_PORTS -m comment --comment "ACC-ports_in-mcafee-clients"
/sbin/iptables -A ports_IN -p tcp --sport $MCAFEE_EPO -m comment --comment "ACC-ports_in-mcafee-epo"
/sbin/iptables -A ports_OUT -p tcp -m multiport --dport $MCAFEE_PORTS -m comment --comment "ACC-ports_out-mcafee-clients"
/sbin/iptables -A ports_OUT -p tcp --dport $MCAFEE_EPO -m comment --comment "ACC-ports_out-mcafee-epo"
# ** Protocoles NetBios **
/sbin/iptables -A ports_IN -p tcp -m multiport --dport $SAMBA_PORTS -m comment --comment "ACC-ports_in-samba-clients"
/sbin/iptables -A ports_OUT -p tcp -m multiport --dport $SAMBA_PORTS -m comment --comment "ACC-ports_out-samba-clients"
/sbin/iptables -A ports_IN -p udp -m multiport --dport $SAMBA_PORTS -m comment --comment "ACC-ports_in-samba-clients"
/sbin/iptables -A ports_OUT -p udp -m multiport --dport $SAMBA_PORTS -m comment --comment "ACC-ports_out-samba-clients"
# ** Protocoles AD/Samba4 **
/sbin/iptables -A ports_IN -p tcp -m multiport --sport $AD_PORTS -m comment --comment "ACC-ports_PF_in-ad-clients"
/sbin/iptables -A ports_OUT -p tcp -m multiport --dport $AD_PORTS -m comment --comment "ACC-ports_PF_out-ad-clients"
/sbin/iptables -A ports_IN -p udp -m multiport --sport $AD_PORTS -m comment --comment "ACC-ports_PF_in-ad-clients"
/sbin/iptables -A ports_OUT -p udp -m multiport --dport $AD_PORTS -m comment --comment "ACC-ports_PF_out-ad-clients"
# ** Protocoles Zephir **
/sbin/iptables -A ports_IN -p tcp -m multiport --sport $ZEPHIR_PORTS -m comment --comment "ACC-ports_PF_in-zephir"
/sbin/iptables -A ports_OUT -p tcp -m multiport --dport $ZEPHIR_PORTS -m comment --comment "ACC-ports_PF_out-zephir"
# ** Protocoles Radius **
/sbin/iptables -A ports_IN -p udp -m multiport --sport $RADIUS_PORTS -m comment --comment "ACC-ports_PF_in-radius"
/sbin/iptables -A ports_OUT -p udp -m multiport --dport $RADIUS_PORTS -m comment --comment "ACC-ports_PF_out-radius"

########################################################################
###            Gestion du traffic par Serveurs Nationaux             ###
########################################################################
#######################################################
# Declaration des chaines internes 'flux'
/sbin/iptables -N flux_IN
/sbin/iptables -N flux_OUT

# Flux depuis/vers serveurs nationaux
/sbin/iptables -I OUTPUT -o $eth0 -m comment --comment "ACC-flux_out-total" -j flux_OUT
/sbin/iptables -I INPUT -i $eth0 -m comment --comment "ACC-flux_in-total" -j flux_IN

# Flux serveurs proxies nationaux
    %if %%is_defined('serveurs_proxies_nationaux_ip')
     %if not %%is_empty(%%serveurs_proxies_nationaux_ip)
/sbin/iptables -A flux_OUT -m set --match-set  proxies dst -m comment --comment "ACC-flux_out-proxies"
/sbin/iptables -A flux_IN -m set --match-set  proxies src -m comment --comment "ACC-flux_in-proxies"
     %end if
    %end if
#Flux serveurs LDAP
    %if %%is_defined('serveurs_ldap_nationaux_ip')
     %if not %%is_empty(%%serveurs_ldap_nationaux_ip)
/sbin/iptables -A flux_OUT -m set --match-set ldap dst -m comment --comment "ACC-flux_out-ldap"
/sbin/iptables -A flux_IN -m set --match-set ldap src -m comment --comment "ACC-flux_in-ldap"
     %end if
    %end if
# Flux serveurs McAfee
    %if %%is_defined('serveurs_mcafee_nationaux_ip')
     %if not %%is_empty(%%serveurs_mcafee_nationaux_ip)
/sbin/iptables -A flux_OUT -m set --match-set mcafee dst -m comment --comment "ACC-flux_out-mcafee"
/sbin/iptables -A flux_IN -m set --match-set mcafee src -m comment --comment "ACC-flux_in-mcafee"
     %end if
    %end if
#Flux serveurs dns nationaux
    %if %%is_defined('serveurs_dns_nationaux_ip')
     %if not %%is_empty(%%serveurs_dns_nationaux_ip)
/sbin/iptables -A flux_OUT -m set --match-set dns dst -m comment --comment "ACC-flux_out-dnsnat"
/sbin/iptables -A flux_IN -m set --match-set dns src -m comment --comment "ACC-flux_in-dnsnat"
     %end if
    %end if
# Flux serveurs ntp nationaux
    %if %%is_defined('serveurs_ntp_nationaux_ip')
     %if not %%is_empty(%%serveurs_ntp_nationaux_ip)
/sbin/iptables -A flux_OUT -m set --match-set ntp dst -m comment --comment "ACC-flux_out-ntpnat"
/sbin/iptables -A flux_IN -m set --match-set ntp src -m comment --comment "ACC-flux_in-ntpnat"
     %end if
    %end if
# Flux serveurs synchro LDAP
    %if %%is_defined('serveurs_synchro_ldap_nationaux_ip')
     %if not %%is_empty(%%serveurs_synchro_ldap_nationaux_ip)
/sbin/iptables -A flux_OUT -m set --match-set syncldap dst -m comment --comment "ACC-flux_out-synchro_ldap"
/sbin/iptables -A flux_IN -m set --match-set syncldap src -m comment --comment "ACC-flux_in-synchro_ldap"
     %end if
    %end if
# Flux serveurs Zephir
    %if %%is_defined('serveurs_eole_nationaux_ip')
     %if not %%is_empty(%%serveurs_eole_nationaux_ip)
/sbin/iptables -A flux_OUT -m set --match-set zephir dst -m comment --comment "ACC-flux_out-zephir"
/sbin/iptables -A flux_IN -m set --match-set zephir src -m comment --comment "ACC-flux_in-zephir"
     %end if
    %end if
# Flux serveurs ClamAV
    %if %%is_defined('serveurs_clamav_nationaux_ip')
     %if not %%is_empty(%%serveurs_clamav_nationaux_ip)
/sbin/iptables -A flux_OUT -m set --match-set clamav dst -m comment --comment "ACC-flux_out-clamav"
/sbin/iptables -A flux_IN -m set --match-set clamav src -m comment --comment "ACC-flux_in-clamav"
     %end if
    %end if
# Flux serveurs Seth distants
    %if %%is_defined('seth_dist_serveurs_ip')
     %if not %%is_empty(%%seth_dist_serveurs_ip)
/sbin/iptables -A flux_OUT -m set --match-set sethdist dst -m comment --comment "ACC-flux_out-sethdist"
/sbin/iptables -A flux_IN -m set --match-set sethdist src -m comment --comment "ACC-flux_in-sethdist"
     %end if
    %end if

   %else
# Module inconnu
   %end if
  %else
# Pare-feu non activé
  %end if
##########################################################################
 %else
# accounting non activé
 %end if

%else
# variable d'accounting absente
%end if
