#!/usr/bin/env python
# -*- coding: UTF-8 -*-
###################################
#
# script basique pour envoyer des
# fichiers sur un groupe de serveurs
#

import xmlrpclib, getpass, sys, os


def selection_serveurs(zephir_proxy):
    """récupération de la liste des serveurs d'un groupe existant
    """
    # récupération des groupes existants
    rc, liste_groupes = zephir_proxy.serveurs.get_groups()
    print "* groupes disponibles *"
    # affichage id et libelle des groupes
    groupes = {}
    for groupe in liste_groupes:
        print groupe[0], " - ", groupe[1]
        # dictionnaire id_groupe -> libelle, liste des serveurs
        groupes[groupe[0]] = (groupe[1], groupe[2])
    print ""
    id_groupe = raw_input('choix du groupe : ')
    try:
        id_groupe = int(id_groupe)
        assert id_groupe in groupes.keys()
    except:
        sys.exit('Erreur, choix non valide')
    # récupération des serveurs de ce groupe
    rc, groupe_serv = zephir_proxy.serveurs.groupe_reload(groupes[id_groupe][1])
    if rc != 1:
        sys.exit('Erreur de récupération des serveurs du groupe')
    return groupe_serv

def envoi_fichier(zephir_proxy, groupe_serv):
    """lit un fichier local et l'ajoute comme fichier personnalisé pour les serveurs demandés
    """
    nom_fichier = "nom_fic"
    base_localpath = "fichiers_zephir"
    # demande du chemin local
    while nom_fichier:
        nom_fichier = raw_input('\n  Chemin du fichier à envoyer (rien pour arrêter) : ')
        if nom_fichier == '':
            # sortie de la boucle
            continue
        if os.path.isfile(nom_fichier):
            # demande du chemin de destination sur le client
            fic_dest = raw_input('\n  Destination du fichier sur le serveur client : ')

            # dictionnaire des fichiers à envoyer sur chaque serveur
            dic_files = {'fichiers_zeph':[]}

            # lecture du contenu du fichier
            contenu = open(nom_fichier).read()
            # on enlève les éventuels retour de ligne 'windows'
            win_new_line = chr(13)+chr(10)
            contenu = contenu.replace(win_new_line,'\n')
            # encodage en base64 pour permettre le passage par xmlrpc
            contenu = xmlrpclib.base64.encodestring(contenu)

            # ajout à la liste des fichiers à envoyer
            dic_files['fichiers_zeph'].append([fic_dest, contenu])
            for serveur in groupe_serv:
                # envoi à un serveur du groupe
                rc, message = zephir_proxy.serveurs.add_files(int(serveur['id']), dic_files)
                # test code de retour
                if rc != 1:
                    print "  !! Erreur lors de l'envoi à zéphir (serveur %s): %s" % (str(serveur['id']), message)
                else:
                    print "  - mis en place pour le serveur %s" % (str(serveur['id']))
        else:
            print "  !! Erreur, fichier non trouvé"

if __name__ == '__main__':
    # programme principal

    # proxy xmlrpc
    user = raw_input("nom de l'utilisateur zephir :")
    pwd = getpass.getpass("mot de passe                :")

    # pour utiliser à distance, remplacer localhost
    # par l'adresse externe de zephir et utiliser https (port 7080)
    protocol = "http"
    adresse_zephir = "127.0.0.1"
    port_zephir = "7081"
    zephir_proxy = xmlrpclib.ServerProxy('%s://%s:%s@%s:%s' % (protocol, user, pwd, adresse_zephir, port_zephir))

    groupe_serv = selection_serveurs(zephir_proxy)
    envoi_fichier(zephir_proxy, groupe_serv)
