/*
 * Decompiled with CFR 0.152.
 */
package org.probatron.officeotron;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.Logger;
import org.probatron.officeotron.Submission;
import org.probatron.officeotron.Utils;
import org.probatron.officeotron.sessionstorage.Store;

public class WebSubmission
extends Submission {
    static Logger logger = Logger.getLogger(WebSubmission.class);
    private HttpServletRequest request;
    private String responseErr;

    public WebSubmission(HttpServletRequest httpServletRequest) {
        this.request = httpServletRequest;
    }

    public int fetchFromClient() throws IOException {
        int n = 200;
        boolean bl = ServletFileUpload.isMultipartContent(this.request);
        if (bl) {
            this.parseMultiPart(this.request);
        } else {
            this.parseDirect(this.request);
        }
        return n;
    }

    public void parseMultiPart(HttpServletRequest httpServletRequest) throws IOException {
        logger.debug("Processing multipart submission");
        ServletFileUpload servletFileUpload = new ServletFileUpload();
        try {
            FileItemIterator fileItemIterator = servletFileUpload.getItemIterator(httpServletRequest);
            while (fileItemIterator.hasNext()) {
                FileItemStream fileItemStream = fileItemIterator.next();
                String string = fileItemStream.getFieldName();
                logger.trace("Got file item named " + string);
                InputStream inputStream = fileItemStream.openStream();
                if (string.equalsIgnoreCase("candidate")) {
                    this.uuid = Store.putZippedResource(inputStream, string);
                    inputStream.close();
                    inputStream = null;
                    System.gc();
                    logger.debug("Persisted candidate item with UUID: " + this.uuid);
                    continue;
                }
                byte[] byArray = Utils.getBytesToEndOfStream(inputStream, true);
                String string2 = new String(byArray);
                logger.debug("Setting option " + string + " = " + string2);
                this.optionMap.put(string, string2);
            }
        }
        catch (FileUploadException fileUploadException) {
            logger.fatal(fileUploadException.getMessage());
            throw new RuntimeException(fileUploadException.getMessage());
        }
    }

    public void parseDirect(HttpServletRequest httpServletRequest) throws IOException {
        logger.debug("Processing direct submission");
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        this.uuid = Store.putZippedResource((InputStream)servletInputStream, null);
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = httpServletRequest.getParameter(string);
            this.optionMap.put(string, string2);
        }
    }

    public String getResponseErr() {
        return this.responseErr;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }
}

