/*
 * Decompiled with CFR 0.152.
 */
package org.probatron.officeotron;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.probatron.officeotron.CommandLineSubmission;
import org.probatron.officeotron.OOXMLSchemaMap;
import org.probatron.officeotron.OOXMLSchemaMapping;
import org.probatron.officeotron.ReportFactory;
import org.probatron.officeotron.StdioValidationReport;
import org.probatron.officeotron.Utils;
import org.probatron.officeotron.ValidationReport;
import org.probatron.officeotron.sessionstorage.Store;
import org.probatron.officeotron.sessionstorage.ValidationSession;

public class Driver {
    static Logger logger = Logger.getLogger(Driver.class);

    private static void replaceBuildinSchema(String string) {
        String string2 = new File(string).getName();
        Set<String> set = OOXMLSchemaMap.getContentTypes();
        for (String string3 : set) {
            OOXMLSchemaMapping oOXMLSchemaMapping = OOXMLSchemaMap.getMappingForContentType(string3);
            String string4 = new File(oOXMLSchemaMapping.getSchemaName()).getName();
            if (string4.isEmpty() || !string4.equals(string2)) continue;
            OOXMLSchemaMap.updateUrlForContentType(oOXMLSchemaMapping.getContentType(), string);
        }
    }

    public static void main(String[] stringArray) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals("--errors-only")) {
                bl = true;
                continue;
            }
            if (stringArray[n].equals("--help")) {
                System.out.println("arguments: [--errors-only] [--schema <schema.xsd>] ]file1 ...");
                return;
            }
            if (stringArray[n].equals("--version")) {
                String string = logger.getClass().getPackage().getImplementationVersion();
                System.out.println(string);
                return;
            }
            if (stringArray[n].equals("--schema") && n + 1 < stringArray.length) {
                Driver.replaceBuildinSchema(stringArray[++n]);
                continue;
            }
            arrayList.add(stringArray[n]);
        }
        n = !bl ? 1 : 0;
        Store.init(System.getProperty("java.io.tmpdir"), false);
        for (String string : arrayList) {
            logger.debug("Validating file " + new File(string).getAbsolutePath());
            CommandLineSubmission commandLineSubmission = new CommandLineSubmission(string);
            ValidationSession validationSession = Utils.autoCreateValidationSession(commandLineSubmission, new ReportFactory(n != 0){
                final /* synthetic */ boolean val$showInfos;
                {
                    this.val$showInfos = bl;
                }

                @Override
                public ValidationReport create() {
                    return new StdioValidationReport(this.val$showInfos);
                }
            });
            validationSession.prepare();
            validationSession.validate();
            validationSession.cleanup();
            try {
                validationSession.getCommentary().streamOut();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    static {
        String string = System.getProperty("property://probatron.org/officeotron-log-level");
        string = string == null ? "ERROR" : string;
        Properties properties = new Properties();
        properties.setProperty("log4j.rootCategory", string + ", A1");
        properties.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        properties.setProperty("log4j.appender.A1.target", "System.err");
        properties.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        properties.setProperty("log4j.appender.A1.layout.ConversionPattern", "%c %p - %m%n");
        PropertyConfigurator.configure(properties);
    }
}

