# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.pass_input_type_algorithm import PassInputTypeAlgorithm


class GhostCellsGenerator(PassInputTypeAlgorithm):
    r"""
    GhostCellsGenerator - Computes ghost cells on CompositeDataSet
    inputs
    
    Superclass: PassInputTypeAlgorithm
    
    This filter computes ghost cells between data sets of same types in a
    `vtkcomposite_data_set`. For example, a `vtkimage_data` inside a
    `vtkcomposite_data_set` will send and receive ghosts only to and from
    other `vtkimage_data`. The backend used to generate the ghosts is
    `DIYghost_utilities::generate_ghosts`.
    
    If the input is a `vtkpartitioned_data_set_collection`, then ghosts are
    computed per partitioned data set. In other words, ghost are not
    computed between 2 `vtkdata_set` belonging to 2 different
    `vtkpartitioned_data_set`, even if they are adjacent.
    
    If `build_if_required` is set to true (which is by default), then the
    filter will compute ghost based on the value being returned by
    `vtkstreaming_demand_driven_pipeline::UPDATE_NUMBER_OF_GHOST_LEVELS()`
    in the downstream streaming pipeline. If not (i.e. `build_if_required`
    is off), then the max between this latter value and
    `number_of_ghost_layers` is being used.
    
    Ghosts points are generated in addition to ghost cells. The same
    point exists across multiple partitions at the interface between
    them. One version of those points is not tagged as ghost, while the
    others are. As a consequence, there are as many non ghost points as
    there would be points if the input partitions were all merged into
    one partition.
    
    If the input is composed of some data sets already owning ghosts,
    those ghosts are removed from the output and are recomputed. Ghosts
    in the input are as if they didn't exist. A ghost cell is to be
    peeled off if it holds the `CELLDUPLICATE` flag in its ghost bit
    mask. Similarly, each generated ghost cells from this filter is
    tagged with `CELLDUPLICATE`, in addition of other tags that could be
    set (`HIDDENCELL` for instance).
    
    If the input is a `vtkunstructured_grid`, if the input `vtkpoint_data`
    has global ids, then the values of those global ids are used instead
    of point position in 3D to connect 2 partitions. If not, point
    position of the outer surface are used to connect them. The precision
    of such connection is done using numeric precision of the input
    coordinates. Points and cells tagged as hidden ghosts are removed
    from the output.
    
    When requesting zero layers of ghost cells, ghost points are still
    generated. In this instance, the filter will produce a ghost cell
    array in the output if and only if the input is a structured data set
    (`vtkimage_data`, `vtkrectilinear_grid`, or `vtkstructured_grid`), and
    has hidden ghosts within its valid extent (extent when duplicate
    ghosts are peeled off).
    
    Points at the interface between 2 partitions are edited depending on
    the ownership of the point after the ghost points are generated. One
    can keep track of which process owns a non-ghost copy of the point if
    an array associating each point with its process id is available in
    the input.
    
    @warning If an input already holds ghosts, the input ghost cells
        should be tagged as
    `CELLDUPLICATE` in order for this filter to work properly.
    
    ote Currently,`vtkimage_data`, `vtkrectilinear_grid`,
    `vtkstructured_grid`, `vtkunstructured_grid` and `vtkpoly_data` are
    implemented.
    
    @warning This warning only applies for `vtkunstructured_grid` and
        `vtkpoly_data` inputs. If
    there are duplicate points in the outer shell of an input partition,
    then this filter cannot decide on how to connect the cells properly
    when generating ghosts. The same phenomenon occurs when the outer
    shell of the partition has 2 points with the same global id. In such
    circumstances, use the `vtkstatic_clean_unstructured_grid` or
    `vtkstatic_clean_poly_data` filter first in order to have a clean input.
    
    @sa DIYGhostUtilities
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGhostCellsGenerator, obj, update, **traits)
    
    build_if_required = tvtk_base.true_bool_trait(desc=\
        r"""
        Specify if the filter must generate the ghost cells only if
        required by the pipeline. If false, ghost cells are computed even
        if they are not required. Default is TRUE.
        """
    )

    def _build_if_required_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBuildIfRequired,
                        self.build_if_required_)

    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        r"""
        
        """
    )

    number_of_ghost_layers = traits.Trait(1, traits.Range(0, 2147483647, enter_set=True, auto_set=False), desc=\
        r"""
        
        """
    )

    def _number_of_ghost_layers_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfGhostLayers,
                        self.number_of_ghost_layers)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        Get the input data object. This method is not recommended for
        use, but lots of old style filters use it.
        """
    )

    def initialize(self):
        """
        initialize(self) -> None
        C++: virtual void initialize()"""
        ret = self._vtk_obj.Initialize()
        return ret
        

    _updateable_traits_ = \
    (('build_if_required', 'GetBuildIfRequired'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('number_of_ghost_layers',
    'GetNumberOfGhostLayers'), ('progress_text', 'GetProgressText'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'build_if_required', 'debug',
    'global_warning_display', 'release_data_flag',
    'number_of_ghost_layers', 'object_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GhostCellsGenerator, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit GhostCellsGenerator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['build_if_required'], [], ['number_of_ghost_layers',
            'object_name']),
            title='Edit GhostCellsGenerator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GhostCellsGenerator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

