# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.scalars_to_colors import ScalarsToColors


class LookupTable(ScalarsToColors):
    r"""
    LookupTable - map scalar values into colors via a lookup table
    
    Superclass: ScalarsToColors
    
    LookupTable is an object that is used by mapper objects to map
    scalar values into RGBA (red-green-blue-alpha) color specification,
    or RGBA into scalar values. The color table can be created by direct
    insertion of color values, or by specifying a hue, saturation, value,
    and alpha range and generating a table.
    
    A special color for NaN values in the data can be specified via
    set_nan_color(). In addition, a color for data values below the lookup
    table range minimum can be specified with set_below_range_color(), and
    that color will be used for values below the range minimum when
    use_below_range_color is on.  Likewise, a color for data values above
    the lookup table range maximum can be specified with
    set_above_range_color(), and it is used when use_above_range_color is on.
    
    This class behaves differently depending on how indexed_lookup is set.
    When true, LookupTable enters a mode for representing categorical
    color maps. By setting indexed_lookup to true, you indicate that the
    annotated values are the only valid values for which entries in the
    color table should be returned. The colors in the lookup Table are
    assigned to annotated values by taking the modulus of their index in
    the list of annotations. indexed_lookup changes the behavior of
    get_index, which in turn changes the way map_scalars_through_table2
    behaves; when indexed_lookup is true, map_scalars_through_table2 will
    search for scalar values in annotated_values and use the resulting
    index to determine the color. If a scalar value is not present in
    annotated_values, then nan_color will be used.
    
    @warning
    You need to explicitly call Build() when constructing the LUT by
    hand.
    
    @sa
    LogLookupTable WindowLevelLookupTable
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkLookupTable, obj, update, **traits)
    
    use_above_range_color = tvtk_base.false_bool_trait(desc=\
        r"""
        Set whether the above range color should be used.
        """
    )

    def _use_above_range_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseAboveRangeColor,
                        self.use_above_range_color_)

    use_below_range_color = tvtk_base.false_bool_trait(desc=\
        r"""
        Set whether the below range color should be used.
        """
    )

    def _use_below_range_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseBelowRangeColor,
                        self.use_below_range_color_)

    ramp = tvtk_base.RevPrefixMap({'s_curve': 1, 'linear': 0, 'sqrt': 2}, default_value='s_curve', desc=\
        r"""
        Set the shape of the table ramp to either S-curve, linear, or
        sqrt. The default is S-curve, which tails off gradually at either
        end.
        
        The equation used for the S-curve is y = (sin((x - 1/2)*pi) +
        1)/2, For an S-curve greyscale ramp, you should set
        number_of_table_values to 402 (which is 256*pi/2) to provide room
        for the tails of the ramp.
        
        The equation for the linear ramp is simply y = x.
        
        The equation for the SQRT is y = sqrt(x).
        """
    )

    def _ramp_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRamp,
                        self.ramp_)

    scale = tvtk_base.RevPrefixMap({'linear': 0, 'log10': 1}, default_value='linear', desc=\
        r"""
        Set the type of scale to use, linear or logarithmic.  The default
        is linear.  If the scale is logarithmic, then the table_range must
        not cross the value zero.
        """
    )

    def _scale_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScale,
                        self.scale_)

    above_range_color = traits.Array(enter_set=True, auto_set=False, shape=(4,), dtype="float", value=(1.0, 1.0, 1.0, 1.0), cols=3, desc=\
        r"""
        Set the color to use when a value above the range is encountered.
        This is an RGBA 4-tuple of doubles in the range [0, 1].
        """
    )

    def _above_range_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAboveRangeColor,
                        self.above_range_color)

    alpha_range = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="float", value=(1.0, 1.0), cols=2, desc=\
        r"""
        Set the range in alpha (using automatic generation). Alpha ranges
        from [0,1].
        """
    )

    def _alpha_range_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAlphaRange,
                        self.alpha_range)

    below_range_color = traits.Array(enter_set=True, auto_set=False, shape=(4,), dtype="float", value=(0.0, 0.0, 0.0, 1.0), cols=3, desc=\
        r"""
        Set the color to use when a value below the range is encountered.
        This is an RGBA 4-tuple of doubles in the range [0, 1].
        """
    )

    def _below_range_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBelowRangeColor,
                        self.below_range_color)

    hue_range = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="float", value=(0.0, 0.66667), cols=2, desc=\
        r"""
        Set the range in hue (using automatic generation). Hue ranges
        between [0,1].
        """
    )

    def _hue_range_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHueRange,
                        self.hue_range)

    nan_color = traits.Array(enter_set=True, auto_set=False, shape=(4,), dtype="float", value=(0.5, 0.0, 0.0, 1.0), cols=3, desc=\
        r"""
        Set the color to use when a NaN (not a number) is encountered. 
        This is an RGBA 4-tuple of doubles in the range [0,1].
        """
    )

    def _nan_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNanColor,
                        self.nan_color)

    number_of_colors = traits.Trait(256, traits.Range(2, 9223372036854775807, enter_set=True, auto_set=False), desc=\
        r"""
        Set the number of colors in the lookup table.  Use
        set_number_of_table_values() instead, it can be used both before and
        after the table has been built whereas set_number_of_colors() has no
        effect after the table has been built.
        """
    )

    def _number_of_colors_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfColors,
                        self.number_of_colors)

    number_of_table_values = traits.Int(256, enter_set=True, auto_set=False, desc=\
        r"""
        Specify the number of values (i.e., colors) in the lookup table.
        """
    )

    def _number_of_table_values_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfTableValues,
                        self.number_of_table_values)

    range = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="float", value=(0.0, 1.0), cols=2, desc=\
        r"""
        
        """
    )

    def _range_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRange,
                        self.range)

    saturation_range = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="float", value=(1.0, 1.0), cols=2, desc=\
        r"""
        Set the range in saturation (using automatic generation).
        Saturation ranges between [0,1].
        """
    )

    def _saturation_range_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSaturationRange,
                        self.saturation_range)

    def _get_table(self):
        return wrap_vtk(self._vtk_obj.GetTable())
    def _set_table(self, arg):
        old_val = self._get_table()
        my_arg = deref_array([arg], [['vtkUnsignedCharArray']])
        self._wrap_call(self._vtk_obj.SetTable,
                        my_arg[0])
        self.trait_property_changed('table', old_val, arg)
    table = traits.Property(_get_table, _set_table, desc=\
        r"""
        
        """
    )

    table_range = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="float", value=(0.0, 1.0), cols=2, desc=\
        r"""
        Set/Get the minimum/maximum scalar values for scalar mapping.
        Scalar values less than minimum range value are clamped to
        minimum range value. Scalar values greater than maximum range
        value are clamped to maximum range value.
        
        * The table_range values are only used when indexed_lookup is
          false.
        """
    )

    def _table_range_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTableRange,
                        self.table_range)

    def get_table_value(self, *args):
        """
        get_table_value(self, indx:int) -> (float, float, float, float)
        C++: double *get_table_value(IdType indx)
        get_table_value(self, indx:int, rgba:[float, float, float, float])
            -> None
        C++: void get_table_value(IdType indx, double rgba[4])
        Return an RGBA color value for the given index into the lookup
        table. Color components are expressed as [0,1] double values.
        """
        ret = self._wrap_call(self._vtk_obj.GetTableValue, *args)
        return ret

    def set_table_value(self, *args):
        """
        set_table_value(self, indx:int, rgba:(float, float, float, float))
            -> None
        C++: virtual void set_table_value(IdType indx,
            const double rgba[4])
        set_table_value(self, indx:int, r:float, g:float, b:float,
            a:float=1.0) -> None
        C++: virtual void set_table_value(IdType indx, double r,
            double g, double b, double a=1.0)
        Directly load color into lookup table. Use [0,1] double values
        for color component specification. Make sure that you've either
        used the Build() method or used set_number_of_table_values() prior to
        using this method.
        """
        ret = self._wrap_call(self._vtk_obj.SetTableValue, *args)
        return ret

    value_range = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="float", value=(1.0, 1.0), cols=2, desc=\
        r"""
        Set the range in value (using automatic generation). Value ranges
        between [0,1].
        """
    )

    def _value_range_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetValueRange,
                        self.value_range)

    def get_color_as_unsigned_chars(self, *args):
        """
        get_color_as_unsigned_chars(colorIn:(float, float, float, float),
            colorOut:[int, int, int, int]) -> None
        C++: static void get_color_as_unsigned_chars(const double colorIn[4],
            unsigned char colorOut[4])
        Given an RGBA[4] color in the [0,1] range, convert it to RGBA[4]
        in the [0,255] range.
        """
        ret = self._wrap_call(self._vtk_obj.GetColorAsUnsignedChars, *args)
        return ret

    def get_index(self, *args):
        """
        get_index(self, v:float) -> int
        C++: virtual IdType get_index(double v)
        Return the table index associated with a particular value.
        Returns -1 if v is NaN.
        
        * Do not use this function when indexed_lookup is true:
        * in that case, the set of values v may take on is exactly the
          integers
        * from 0 to get_number_of_table_values() - 1;
        * and v serves directly as an index into table_values.
        """
        ret = self._wrap_call(self._vtk_obj.GetIndex, *args)
        return ret

    def get_log_range(self, *args):
        """
        get_log_range(range:(float, float), log_range:[float, float])
            -> None
        C++: static void get_log_range(const double range[2],
            double log_range[2])
        Returns the log of range in log_range. There is a little more to
        this than simply taking the log10 of the two range values: we do
        conversion of negative ranges to positive ranges, and conversion
        of zero to a 'very small number'.
        """
        ret = self._wrap_call(self._vtk_obj.GetLogRange, *args)
        return ret

    def _get_nan_color_as_unsigned_chars(self):
        return self._vtk_obj.GetNanColorAsUnsignedChars()
    nan_color_as_unsigned_chars = traits.Property(_get_nan_color_as_unsigned_chars, desc=\
        r"""
        Return the nan_color as a pointer to 4 unsigned chars. This will
        overwrite any data returned by previous calls to map_value.
        """
    )

    def get_pointer(self, *args):
        """
        get_pointer(self, id:int) -> Pointer
        C++: unsigned char *get_pointer(IdType id)
        Get pointer to color table data. Format is array of unsigned char
        R-G-B-A...R-G-B-A.
        """
        ret = self._wrap_call(self._vtk_obj.GetPointer, *args)
        return ret

    def allocate(self, *args):
        """
        allocate(self, sz:int=256, ext:int=256) -> int
        C++: int allocate(int sz=256, int ext=256)
        Allocate a color table of specified size. Note that ext is no
        longer used.
        """
        ret = self._wrap_call(self._vtk_obj.Allocate, *args)
        return ret

    def apply_log_scale(self, *args):
        """
        apply_log_scale(v:float, range:(float, float), log_range:(float,
            float)) -> float
        C++: static double apply_log_scale(double v, const double range[2],
            const double log_range[2])
        Apply log to value, with appropriate constraints.
        """
        ret = self._wrap_call(self._vtk_obj.ApplyLogScale, *args)
        return ret

    def build_special_colors(self):
        """
        build_special_colors(self) -> None
        C++: void build_special_colors()
        Copies the "special" colors into the given table.
        """
        ret = self._vtk_obj.BuildSpecialColors()
        return ret
        

    def force_build(self):
        """
        force_build(self) -> None
        C++: virtual void force_build()
        Force the lookup table to regenerate from hue, saturation, value,
        and alpha min/max values.  Table is built from a linear ramp of
        each value.  force_build() is useful if a lookup table has been
        defined manually (using set_table_value) and then an application
        decides to rebuild the lookup table using the implicit process.
        """
        ret = self._vtk_obj.ForceBuild()
        return ret
        

    def write_pointer(self, *args):
        """
        write_pointer(self, id:int, number:int) -> Pointer
        C++: unsigned char *write_pointer(IdType id, int number)
        Get pointer to data. Useful for direct writes into object. max_id
        is bumped by number (and memory allocated if necessary). Id is
        the location you wish to write into; number is the number of rgba
        values to write.
        
        * \\warning If you modify the table data via the pointer returned
          by this
        * member function, you must call
          LookupTable::BuildSpecialColors()
        * afterwards to ensure that the special colors (below/above range
        and NaN
        * value) are up-to-date.
        """
        ret = self._wrap_call(self._vtk_obj.WritePointer, *args)
        return ret

    _updateable_traits_ = \
    (('use_above_range_color', 'GetUseAboveRangeColor'),
    ('use_below_range_color', 'GetUseBelowRangeColor'), ('indexed_lookup',
    'GetIndexedLookup'), ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('ramp', 'GetRamp'), ('scale',
    'GetScale'), ('vector_mode', 'GetVectorMode'), ('above_range_color',
    'GetAboveRangeColor'), ('alpha_range', 'GetAlphaRange'),
    ('below_range_color', 'GetBelowRangeColor'), ('hue_range',
    'GetHueRange'), ('nan_color', 'GetNanColor'), ('number_of_colors',
    'GetNumberOfColors'), ('number_of_table_values',
    'GetNumberOfTableValues'), ('range', 'GetRange'), ('saturation_range',
    'GetSaturationRange'), ('table_range', 'GetTableRange'),
    ('value_range', 'GetValueRange'), ('alpha', 'GetAlpha'),
    ('vector_component', 'GetVectorComponent'), ('vector_size',
    'GetVectorSize'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'indexed_lookup',
    'use_above_range_color', 'use_below_range_color', 'ramp', 'scale',
    'vector_mode', 'above_range_color', 'alpha', 'alpha_range',
    'below_range_color', 'hue_range', 'nan_color', 'number_of_colors',
    'number_of_table_values', 'object_name', 'range', 'saturation_range',
    'table_range', 'value_range', 'vector_component', 'vector_size'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(LookupTable, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit LookupTable properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['indexed_lookup', 'use_above_range_color',
            'use_below_range_color'], ['ramp', 'scale', 'vector_mode'],
            ['above_range_color', 'alpha', 'alpha_range', 'below_range_color',
            'hue_range', 'nan_color', 'number_of_colors',
            'number_of_table_values', 'object_name', 'range', 'saturation_range',
            'table_range', 'value_range', 'vector_component', 'vector_size']),
            title='Edit LookupTable properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit LookupTable properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

