/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef DRAG_H
#define DRAG_H

extern WidgetClass  dragWidgetClass;

typedef struct _IconRec		 *Icon;
typedef struct _DragClassRec *DragWidgetClass;
typedef struct _DragRec      *DragWidget;


#define XmNiconLargeBitmap     "iconLargeBitmap"
#define XmNiconLargeOpenedBitmap     "iconLargeOpenedBitmap"
#define XmNiconLargeMask       "iconLargeMask"
#define XmNiconSmallBitmap     "iconSmallBitmap"
#define XmNiconSmallOpenedBitmap     "iconSmallOpenedBitmap"
#define XmNiconSmallMask       "iconSmallMask"

#define XmNisFolder       	   "isFolder"
#define XmCIsFolder       	   "IsFolder"

#define XmCParentFolder       	   "ParentFolder"
#define XmNparentFolder       	   "parentFolder"



#define XmNiconForeground "iconForeground"
#define XmNiconBackground "iconBackground"
#define XmNiconHiliteForeground 	  "iconHiliteForeground"
#define XmNiconHiliteBackground 	  "iconHiliteBackground"
#define XmCIconHiliteForeground 	  "IconHiliteForeground"
#define XmCIconHiliteBackground 	  "IconHiliteBackground"

#define XmCIconSmallBitmap     "IconSmallBitmap"
#define XmCIconSmallOpenedBitmap     "IconSmallOpenedBitmap"
#define XmCIconSmallMask       "IconSmallMask"
#define XmCIconLargeBitmap     "IconLargeBitmap"
#define XmCIconLargeOpenedBitmap     "IconLargeOpenedBitmap"
#define XmCIconLargeMask       "IconLargeMask"

#define XmNgrid           "grid"
#define XtNgrid           "grid"
#define XmCgrid           "Grid"

#define XmNautoFolderMove       "autoFolderMove"
#define XtNautoFolderMove       "autoFolderMove"
#define XmNautoMove       "autoMove"
#define XtNautoMove       "autoMove"
#define XmNautoPlace      "autoPlace"
#define XtNautoPlace      "autoPlace"
#define XmNautoSort       "autoSort"
#define XmNautoClean      "autoClean"
#define XtBautoClean      "autoClean"
#define XmCAuto           "Auto"


#define XmNeditNames      "editNames"
#define XmCEditNames      "EditNames"

#define XmNeditTimeout      "editTimeout"
#define XmCEditTimeout      "EditTimeout"

#define XmNselectIcons    "selectIcons"
#define XmCSelectIcons    "SelectIcons"

#define XmNsingleLine     "singleLine"
#define XmCSingleLine     "SingleLine"

#define XmNacceptKeys      "acceptKeys"
#define XmCAcceptKeys      "AcceptKeys"

#define XmNkeyThreshold    "keyThreshold"
#define XmCThreshold       "Threshold"

#define XmNsmallIcons      "smallIcons"
#define XmCsmallIcons      "SmallIcons"

#define XmNshapeMode       "shapeMode"
#define XmCshapeMode       "ShapeMode"

#define XmNsendmsgCallback      "sendmsgCallback"
#define XmNdropCallback         "dropCallback"
#define XmNanswerCallback       "answerCallback"
#define XmNmoveCallback         "moveCallback"
#define XmNkillIconCallback     "killIconCallback"
#define XmNselectCallback       "selectCallback"
#define XmNdblClickCallback     "dblClickCallback"
#define XmNotherDropCallback    "otherDropCallback"
#define XmNfolderMoveCallback   "folderMoveCallback"
#define XmNfolderMoveCallback   "folderMoveCallback"

#define XmNrenameCallback      "renameCallback"
#define XmNrenamableCallback   "renamableCallback"

#define XmNgetFullNameCallback   "getFullNameCallback"

#define XmNflyOverCallback   "flyOverCallback"


#define XmRsortProc			   "sortProc"
#define XmNsortProc			   "sortProc"
#define XmCSortProc			   "SortProc"


/* For xdesigner */

#define XtNdblClickCallback    XmNdblClickCallback
#define XtNanswerCallback      XmNanswerCallback
#define XtNsendmsgCallback     XmNsendmsgCallback
#define XtNdropCallback        XmNdropCallback
#define XtNselectCallback      XmNselectCallback
#define XtNkillIconCallback    XmNkillIconCallback

/* Reason codes */

#define DRAG_SEND        1
#define DRAG_DROP        2
#define DRAG_ANSWER      3
#define DRAG_MOVE        4
#define DRAG_KILL        5
#define DRAG_SELECT      6
#define DRAG_DBL_CLICK   7
#define DRAG_OTHER_DROP  8
#define DRAG_FOLDER_MOVE 9
#define DRAG_RENAME      10
#define DRAG_RENAMABLE   11
#define DRAG_FLY_OVER    12

/* return codes */

#define DROP_OK         0
#define DROP_REFUSED    1
#define DROP_ABORTED    2

/* Shape modes */

#define NO_SHAPE        0
#define RECT_SHAPE1     1
#define RECT_SHAPE2     2
#define FULL_SHAPE      3

/* Used in DragDisplayIcon */

#define DRAG_DISPLAY_NO_EFFECT			0
#define DRAG_DISPLAY_ADD_TO_SELECTION	1 /* The icon is selected as well */
#define DRAG_DISPLAY_SELECT_UNIQUE		2 /* other icons are unselected first */
#define DRAG_DISPLAY_VISUAL_FEEDBACK	4 /* Add some visual feedback */


/* Used in DragSelectIcon */

#define DRAG_ALL_ICONS 		(Icon)(-1)

/* Callback stuff */

typedef struct {

    int         reason;         /* what call back */
    XEvent      *event;         /* event that initiated the drag/drop */

    /* Stuff valid for all callback */

    const char*      icon_class;     /* icon class */
    const char*      icon_name;      /* icon name */

    char      icon_fullName[300];      /* icon full name */

    XtPointer   icon_data;      /* icon data */

	Icon		icon;			/* pointer on icon */

    /* Stuff for drag and drop */

    Boolean     same_window;    /* if drag drop to same window */

    Window      remote_window;    /* ID of target/source window */
    const char*      remote_name;      /* Name of target/source widget */
	Widget      remote_widget;    /* remove widget                */
	Boolean     same_folder_tree; /* The widgets are in the same folder tree */ 


    XtPointer   message;        /* What to send / What was recieved */
    long        msg_length;     /* length of buffer */

    /* Drop only */
    Boolean     accept_it;      /* true is the message is accepted */

    /* Drag only */
    Boolean     send_it;        /* true is the message is to be sent */
    Boolean     delete_it;      /* true if icon must be removed */
	int         icon_no;        /* multi drops: icon number     */
	int         icon_count;     /* multi drops: icon count      */
	int         icon_batch;     /* drop id                      */

    /* Answer callback */
    int         code;           /* return code */


    /* Move & Drop */
	Boolean     move_it;
    int         x,y;            /* where it was dropped */
    Boolean     copy;

    /* Select only */
    Boolean     selected;

    /* In label */
    Boolean     in_label;  /* Select in label*/

    /* Rename */

    const char* new_name;
	Boolean rename_it;


} DragCallbackStruct;




/* Public routines */

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

typedef Boolean (*DragScanProc)(Widget,Icon,XtPointer);
typedef int (*DragSortProc)(Widget,Icon,Icon);


Widget 	CreateDragWidget(Widget parent, const char *name, ArgList al, int ac);
Icon   	DragAddIcon(Widget widget, const char* classe, const char* name, 
			XtPointer data, int x, int y);
Widget 	DragIconToWidget(Icon icon);

Icon 	DragFindIconByData(Widget widget, XtPointer data);
Icon 	DragFindIconByName(Widget widget, const char* classe, const char* name);
Icon 	DragFindIconByNameFolders(Widget widget, const char* classe, const char* name);

void 	DragDisplayIcon(Widget widget, Icon icon, int flags);
void 	DragDeleteIcon(Widget widget, Icon icon);
void 	DragShowIcon(Widget widget, Icon icon, Boolean vis);
void 	DragSetIconColor(Widget widget, Icon icon, Pixel pix);

void 	DragScanIcons(Widget widget, DragScanProc cb, XtPointer data);
void 	DragScanIconsFolders(Widget widget, DragScanProc cb, XtPointer data);

void 	DragDeleteAllIcons(Widget widget);
Pixmap 	DragGetIconPixmap(Widget widget, Icon icon);
Boolean DragAreSmallIconsUsed(Widget widget);
void    DragUseSmallIcons(Widget widget, Boolean);
void    DragToggleSizeIcons(Widget);
void 	DragSortIcons(Widget widget, DragSortProc sort);
int 	DragSortByName(Widget widget, Icon, Icon);
int 	DragSortByClass(Widget widget, Icon, Icon);
void 	DragCleanUpIcons(Widget widget);
Boolean DragIsIconSelected(Widget widget, Icon icon);
void 	DragSelectIcon(Widget widget, Icon icon, Boolean selected,
					Boolean expand);
void 	DragShowLast(Widget widget);
XtPointer DragGetIconData(Widget widget, Icon icon);
void 	DragSetIconData(Widget widget, Icon icon, XtPointer data);
void 	DragOpenIcon(Widget widget, Icon icon, Boolean opened);
void 	DragSetIconName(Widget widget, Icon icon, const char *newname);
const char*	DragGetIconName(Widget widget, Icon icon);
const char*	DragGetIconClass(Widget widget, Icon icon);
Icon 	DragFindIconByPosition(Widget widget, Position x, Position y);
void 	DragSetPositionIcon(Widget widget, Icon icon,  Position x, Position y);
void 	DragFindPositionIcon(Widget widget, Icon icon, 
		Position *x, Position *y);
void 	DragAcceptDropCallback(Widget widget, XtCallbackProc callback, 
		XtPointer closure);
void 	DragAddIconPixmap(Widget widget, Icon icon,const char* name, int dx,int dy);
void    DragEditName(Widget widget, Icon icon);

void    DragBlinkIcon(Widget widget, Icon icon);

Pixmap DragGetPixmap(Widget widget,const char* name);
Pixmap MakeHalfPixmap(Widget widget, Pixmap pixmap);
Pixmap MakeOpenPixmap(Widget widget, Pixmap pixmap);
Pixmap MakeDisabledPixmap(Widget widget,Pixmap pixmap);
Pixmap MakeMaskBitmap(Widget widget, Pixmap pixmap, Pixel white);
Pixmap OverlayPixmaps(Widget widget,Pixmap lower,Pixmap upper,int dx,int dy);
Pixmap CopyBackground(Widget widget,Pixmap pixmap);



void DragSetFontTag(Widget widget, const char *tag);/* tag or XmFONTLIST_DEFAULT_TAG */

void DragSetInfo(Widget widget, const char *info);
const char *DragGetInfo(DragCallbackStruct *cb);

/* Dropping objects */

typedef void (*DragDrawProc)(Widget,XRectangle*,Pixmap,GC,XtPointer);

DragCallbackStruct *DragDropObject(Widget widget, XEvent *ev, 
	Position x, Position y, Dimension width, Dimension height, 
	DragDrawProc draw, XtPointer data);
void DragDropSend(Widget widget,DragCallbackStruct*);

#undef P_
#if defined(__cplusplus) || defined(c_plusplus)
}
#endif
 
#define XtIsDrag(w)	XtIsSubclass(w,dragWidgetClass)

#endif /* DRAG_H */
