/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef OVERVIEWP_H
#define OVERVIEWP_H

#include <Xm/XmP.h>
#include <Xm/PrimitiveP.h>

/* Overview class : no new fileds */

typedef struct _OverviewClassPart{
    int ignore;
} OverviewClassPart;

typedef struct _OverviewClassRec{
    CoreClassPart         core_class;
    XmPrimitiveClassPart  primitive_class;
    OverviewClassPart     overview_class;
} OverviewClassRec;

extern OverviewClassRec overviewClassRec;

typedef struct _OverviewPart {
	int             size;
	int             count;
	int             selected;
	Pixel           pixel;
	XtCallbackList  activate;
	XmFontList      fontlist;
	GC              fontGC;
	GC              gc;
} OverviewPart;

typedef struct _OverviewRec {
    CorePart          core;
    XmPrimitivePart   primitive;
    OverviewPart      overview;
} OverviewRec;

#endif
