/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <iostream>
#include <sstream>
#include <fstream>
#include <cstdio>

#include "MvKeyProfile.h"

//-----------------------------------
// MvKey
//-----------------------------------

MvKey::MvKey() : name_(""), shortName_(""), description_(""), 
		readIntAsString_(true), editable_(true)
{
	
}

MvKey::MvKey(const MvKey& copy)
{
	name_=copy.name();
	shortName_=copy.shortName();
	description_=copy.description();
	metaData_=copy.metaData();
	readIntAsString_=copy.readIntAsString();
	editable_=copy.editable();
}

MvKey* MvKey::clone()
{
	MvKey* cp=new MvKey(*this);
	return cp;
}	

void MvKey::addValue(string value)
{
	value_.push_back(value);
	addToCounter(value);
}

void MvKey::addToCounter(string s)
{
	if(counter_.find(s) != counter_.end())
	{
		counter_[s]=counter_[s]+1;
	}
	else
	{
		counter_[s]=1;
	}
}

void MvKey::setValue(int index,string value)
{
	if(index >= 0 && index < value_.size())
	{
		value_[index]=value;
	}
}

string MvKey::firstValue()
{
	if(value_.size() > 0)
	{
		return value_[0];
	}
	else
	{
		return "N/A";
	}	
}

void MvKey::clearData()
{
	value_.clear();
	counter_.clear();
}

string MvKey::metaData(const string &key)
{
	if(metaData_.count(key) != 0)
	{
		return metaData_[key];
	}
	return string();
}

void MvKey::setMetaData(const string &key,const string &value)
{
	metaData_[key]=value;
}

	
void MvKey::clearMetaData()
{
	metaData_.clear();
}
//-----------------------------------
// MvKeyProfile
//-----------------------------------

MvKeyProfile::MvKeyProfile(const MvKeyProfile& copy)
{
	name_=copy.name_;
	systemProfile_=copy.systemProfile_;
	for(vector<MvKey*>::const_iterator it=copy.begin(); it != copy.end(); it++)
	{
		MvKey *key=(*it)->clone();
		push_back(key);
	}
}

MvKeyProfile::~MvKeyProfile()
{
	clear();
}

MvKeyProfile* MvKeyProfile::clone()
{
	MvKeyProfile* cp=new MvKeyProfile(*this);
	return cp;
}

void MvKeyProfile::clear()
{
	for(vector<MvKey*>::iterator it=begin(); it != end(); it++)
	{
		delete (*it);
	}
}

void MvKeyProfile::addKey(MvKey* key)
{
	push_back(key);
}

MvKey* MvKeyProfile::addKey()
{
	MvKey *key=new MvKey;
	push_back(key);
	return key;
}

void MvKeyProfile::deleteKey(int index)
{
	vector<MvKey*>::iterator it=begin()+index;
	delete (*it);
	erase(it);	
}

void MvKeyProfile::swap(int i, int j)
{
	std::swap(at(i),at(j));
}

void MvKeyProfile::reposition(int indexFrom,int indexTo)
{
	if(indexFrom == indexTo)
		return;

	if(indexFrom > indexTo)
	{
		for(int i=indexFrom; i > indexTo; i--)
		{
			std::swap(at(i),at(i-1));
		}
	}
	else
	{
		for(int i=indexFrom; i < indexTo; i++)
		{
			std::swap(at(i),at(i+1));
		}

	}
}

void MvKeyProfile::reposition(vector<int>& pos)
{
	if(size() != pos.size())
		return;
	
	//Create a copy
	vector<MvKey*> profCopy;
	for(int i=0; i < size(); i++)
		profCopy.push_back(at(i));

	for(int i=0; i < size(); i++)
		(*this)[i]=profCopy[pos[i]];


}


MvKey* MvKeyProfile::key(string keyName) 
{
	for(vector<MvKey*>::iterator it=begin(); it != end(); it++)
	{
		if((*it)->name() == keyName)
		{
			return *it;
		}
	}
	return 0;
}

int MvKeyProfile::valueNum(int index)
{
	if(index >=0 && index < size())
	{
		return at(index)->value().size();
	}
	return 0;
}

void MvKeyProfile::clearKeyData()
{
	for(vector<MvKey*>::iterator it=begin(); it != end(); it++)
	{
		(*it)->clearData();
	}
}		
