/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File IconClass.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef IconClass_H
#define IconClass_H

#include <string>
using std::string;


#ifndef Metview_H
#include "Metview.h"
#endif

#include "Action.h"

class Service;
class IconObject;
class Folder;
class Path;
class Language;




class IconClass;
struct ClassScanner {
	virtual void next(const IconClass&) = 0;
};

class IconClass {
public:

// -- Exceptions
	// None

// -- Contructors

	IconClass(const string&,request*,const IconClass* = 0);
	
// -- Destructor

	virtual ~IconClass(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods
	
	virtual const string& name() const;
	virtual string editor() const;
	virtual string type() const;
	virtual string defaultName() const;
	virtual string helpPage() const;
	virtual string doubleClickMethod() const;
	virtual bool skipDepandancies(const string& action) const;
	virtual Path pixmap() const;
	virtual Path definitionFile() const;
	virtual Path rulesFile() const;
	virtual long expandFlags() const;


	virtual bool isSubClassOf(const IconClass&) const;
	virtual bool canBecome(const IconClass&) const;

	virtual Service* service(const Action&) const;
	virtual void service(const Action&,const IconClass*,Service*) const;
	virtual set<string> can() const;

	virtual IconObject* defaultObject() const;
	virtual IconObject* createOne(Folder*) const;

	virtual Language& language() const;

	virtual int priority() const;

// -- Overridden methods
	// None

// -- Class members

	static const IconClass& find(const string&);
	static void load(request*);
	static void globalService(const string&,Service*);

	static void scan(ClassScanner&);

	static const IconClass& guess(const Path&);

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	IconClass(const IconClass&);
	IconClass& operator=(const IconClass&);

// -- Members

	const IconClass*     super_;
	string               name_;
	request*             request_;
	
	map<Action,Service*> services_;
	set<const IconClass*>      outputs_;

// -- Methods
	// None

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const IconClass& p)
	//	{ p.print(s); return s; }

};

inline void destroy(IconClass**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(IconClass);
//#endif

#endif
