/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef AUTO_PTR_H
#define AUTO_PTR_H


template<class T>
class auto_ptr {
	T* ptr_;
public:
      
// --   Normal Constructor

	auto_ptr(T* ptr = 0) : ptr_(ptr) {}

// --   Destructor
	~auto_ptr()   { delete ptr_; }

// --   Copy Constructor

	auto_ptr(auto_ptr<T>& other) 
		{
		ptr_ = other.ptr_;
		other.ptr_ = 0;
		}

	auto_ptr<T>& operator=(auto_ptr<T>& other) 
		{
			if(this != &other)
			{
				delete ptr_;
				ptr_ = other.ptr_;
				other.ptr_ = 0;
			}
			return *this;
		}

	T* get() const        { return ptr_; }

        T* release()          { T* old = ptr_; ptr_ = 0; return old; }
	T* operator->() const { return ptr_; }
	T& operator*()  const { return *ptr_; }
	
};
#endif
