/* sendfax.c -- execute the actual fax sending program.

   Copyright (C) 1994 Ralph Schleicher  */

/* This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <config.h>
#include <sys/wait.h>
#include <errno.h>
#include <unistd.h>
#include "extern.h"
#include "fax.h"


int spawn_prog PROTO ((char *));


int
DEFUN_VOID (send_fax)
{
  char *to, **cc;

  if (fax_num)
    {
      to = fax_num;
      cc = 0;
    }
  else
    {
      to = (char *) fax (TO);
      cc = (char **) fax (CC);
    }

  if (to)
    spawn_prog (to);
  else
    fprintf (stderr, "%s:%s: warning: Missing FAX number\n",
      prog_name, dvi_name);

  if (cc)
    for (; *cc; ++cc)
      spawn_prog (*cc);

  fax (0);

  return (0);
}


int
DEFUN (spawn_prog, (number),
char *number)
{
  int child, status;

  child = fork ();
  switch (child)
    {
    case 0:
      execlp (fax_prog, fax_prog, number, dvi_name, 0);
    case -1:
      die ("%s:%s: %s\n", prog_name, fax_prog, strerror (errno));
    }

  if (waitpid (child, &status, 0) != child)
    die ("%s:%s: %s\n", prog_name, dvi_name, strerror (errno));

  if (status)
    fprintf (stderr, "%s:%s: warning: `%s' returned status 0x%04x\n",
      prog_name, dvi_name, fax_prog, status);

  return (status >> 8);
}
