#line 2 "parser.yy.c"

#line 4 "parser.yy.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define yy_create_buffer parser__create_buffer
#define yy_delete_buffer parser__delete_buffer
#define yy_flex_debug parser__flex_debug
#define yy_init_buffer parser__init_buffer
#define yy_flush_buffer parser__flush_buffer
#define yy_load_buffer_state parser__load_buffer_state
#define yy_switch_to_buffer parser__switch_to_buffer
#define yyin parser_in
#define yyleng parser_leng
#define yylex parser_lex
#define yylineno parser_lineno
#define yyout parser_out
#define yyrestart parser_restart
#define yytext parser_text
#define yywrap parser_wrap
#define yyalloc parser_alloc
#define yyrealloc parser_realloc
#define yyfree parser_free

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 35
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE parser_restart(parser_in  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

extern int parser_leng;

extern FILE *parser_in, *parser_out;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up parser_text. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up parser_text again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via parser_restart()), so that the user can continue scanning by
	 * just pointing parser_in at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when parser_text is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int parser_leng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow parser_wrap()'s to do buffer switches
 * instead of setting up a fresh parser_in.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void parser_restart (FILE *input_file  );
void parser__switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE parser__create_buffer (FILE *file,int size  );
void parser__delete_buffer (YY_BUFFER_STATE b  );
void parser__flush_buffer (YY_BUFFER_STATE b  );
void parser_push_buffer_state (YY_BUFFER_STATE new_buffer  );
void parser_pop_buffer_state (void );

static void parser_ensure_buffer_stack (void );
static void parser__load_buffer_state (void );
static void parser__init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER parser__flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE parser__scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE parser__scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE parser__scan_bytes (yyconst char *bytes,int len  );

void *parser_alloc (yy_size_t  );
void *parser_realloc (void *,yy_size_t  );
void parser_free (void *  );

#define yy_new_buffer parser__create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        parser_ensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            parser__create_buffer(parser_in,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        parser_ensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            parser__create_buffer(parser_in,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

typedef unsigned char YY_CHAR;

FILE *parser_in = (FILE *) 0, *parser_out = (FILE *) 0;

typedef int yy_state_type;

extern int parser_lineno;

int parser_lineno = 1;

extern char *parser_text;
#define yytext_ptr parser_text

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up parser_text.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	parser_leng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 36
#define YY_END_OF_BUFFER 37
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[148] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,    2,    2,
        0,    0,   37,   35,   24,   23,   35,    3,   35,    7,
       35,   35,   19,   19,   35,   35,   35,   22,   22,   22,
       14,   35,   24,    1,   13,   36,    4,   13,    6,   19,
       19,   16,   16,   16,   15,    2,    8,   13,   29,   33,
       27,    0,    0,   19,   19,   19,    0,   25,   31,   28,
       30,   26,   22,    5,   22,   32,    0,    1,    1,   12,
       10,    9,   19,    0,   16,   16,    2,   11,   34,   20,
       19,   19,   18,   22,   19,    0,   16,    0,   18,   18,
       22,   19,    0,   16,    0,   20,   18,   18,   22,   19,

        0,   16,   22,   19,    0,   16,   22,   19,    0,   16,
       22,   19,    0,   16,   22,    0,   19,    0,   21,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,   17,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    2,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    4,    5,    6,    1,    1,    7,    8,    9,
        1,    1,   10,    1,   11,   12,    1,   13,   14,   14,
       14,   14,   14,   14,   14,   14,   14,    1,    1,   15,
       16,   17,    1,    1,   18,   19,   19,   19,   20,   21,
       22,   22,   22,   22,   22,   23,   22,   22,   22,   22,
       22,   24,   25,   22,   26,   22,   22,   27,   28,   22,
       29,   30,   31,    1,   22,    1,   19,   19,   19,   19,

       32,   19,   22,   22,   22,   22,   22,   33,   22,   22,
       22,   22,   22,   22,   22,   22,   34,   22,   22,   35,
       22,   22,    1,   36,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[37] =
    {   0,
        1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    3,    3,    1,    1,    1,    3,    3,    3,
        3,    4,    4,    4,    4,    4,    4,    4,    1,    1,
        1,    3,    4,    4,    4,    1
    } ;

static yyconst flex_int16_t yy_base[184] =
    {   0,
        0,   35,   35,   39,   40,   43,   61,   45,  262,  261,
       46,   47,  263,  481,  481,  481,  246,  481,  254,  481,
      243,  243,   85,   25,   41,  238,   42,    0,  248,  229,
      481,  210,   60,  243,  481,  481,  481,   34,  481,  108,
       26,  131,  154,  239,  481,    0,  481,   60,  481,  481,
      481,  231,   58,    0,   75,   77,    0,  481,  481,  481,
      481,  481,    0,  481,  220,  481,   61,  238,  236,  481,
      481,  481,  174,    0,  196,    0,    0,  481,  481,   93,
      481,  481,  113,  213,  216,    0,  238,  166,   89,   81,
      214,  258,    0,  280,   89,  169,  481,  481,  207,  300,

        0,  322,  203,  342,    0,  364,  208,  384,    0,  406,
      197,  428,  213,  212,  115,    0,  211,  128,  481,    0,
        0,    0,  210,    0,    0,    0,    0,  209,    0,    0,
        0,    0,  208,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  481,  481,  462,  466,  468,
      472,  476,  215,  210,  209,  208,  202,  201,  200,  199,
      196,  195,  193,  188,  187,  182,  181,  178,  175,  168,
      167,  166,  159,  158,  157,  145,  135,  130,  129,  113,
      102,   88,   75
    } ;

static yyconst flex_int16_t yy_def[184] =
    {   0,
      147,    1,  148,  148,  148,  148,    1,    7,  149,  149,
      148,  148,  147,  147,  147,  147,  147,  147,  147,  147,
      147,  147,  147,   23,  147,  147,  147,  150,  150,  150,
      147,  147,  147,  147,  147,  147,  147,  151,  147,  147,
       40,  147,   42,   43,  147,  152,  147,  151,  147,  147,
      147,  147,  147,   24,  147,  147,  153,  147,  147,  147,
      147,  147,  150,  147,  150,  147,  147,  147,  147,  147,
      147,  147,  147,  154,   43,   43,  152,  147,  147,  147,
      147,  147,  153,  150,  147,  155,   43,  147,  147,  147,
      150,  147,  156,   43,  147,  147,  147,  147,  150,  147,

      157,   43,  150,  147,  158,   43,  150,  147,  159,   43,
      150,  147,  147,   43,  150,  160,  112,  147,  147,  161,
      162,  163,  147,  164,  165,  166,  167,  147,  168,  169,
      170,  171,  147,  172,  173,  174,  175,  176,  177,  178,
      179,  180,  181,  182,  183,  147,    0,  147,  147,  147,
      147,  147,  147,  147,  147,  147,  147,  147,  147,  147,
      147,  147,  147,  147,  147,  147,  147,  147,  147,  147,
      147,  147,  147,  147,  147,  147,  147,  147,  147,  147,
      147,  147,  147
    } ;

static yyconst flex_int16_t yy_nxt[518] =
    {   0,
       14,   15,   16,   17,   18,   14,   19,   20,   14,   14,
       21,   22,   23,   24,   25,   26,   27,   28,   28,   28,
       28,   28,   29,   28,   30,   28,   28,   28,   31,   14,
       14,   28,   28,   28,   28,   32,   33,   36,   71,   37,
       34,   36,   36,   37,   39,   36,   33,   39,   36,   36,
       34,  147,  147,   47,   47,   58,   59,   61,   62,  147,
      147,   67,   67,   72,   38,   68,   68,   78,   38,   38,
       80,   80,   38,   40,   41,   48,   48,  146,   42,   42,
       42,   42,   43,   44,   43,   43,   43,   43,   43,   72,
      145,   45,   42,   43,   43,   43,   53,   54,   54,   82,

       81,   96,   96,   98,  144,   80,   80,   55,   81,   82,
       56,   57,   88,   98,   97,  143,  118,   55,   56,   57,
       73,   73,   97,  119,   88,   74,   74,   74,   74,  118,
       55,  142,  141,   56,   57,   89,  119,  140,   90,   74,
       55,   56,   57,   75,   75,   89,   90,  139,   75,   75,
       75,   75,   76,   76,   76,   76,   76,   76,   76,  138,
      137,  136,   75,   76,   76,   76,   76,   76,  135,  133,
      132,   76,   76,   76,   76,   95,   95,  131,   96,   96,
      130,   96,   96,  128,  127,   76,   85,   85,   88,  126,
      125,   86,   86,   86,   86,  123,   55,  122,  121,   56,

       88,  120,  113,  109,  105,   86,   55,   56,   87,   87,
      101,   93,   86,   87,   87,   87,   87,   83,  134,  129,
      124,  147,  116,  116,  115,  111,  107,   87,   92,   92,
      103,   99,   91,   93,   93,   93,   93,   69,   55,   69,
       84,   56,   79,   64,   69,   66,   65,   93,   55,   56,
       94,   94,   64,   60,   52,   94,   94,   94,   94,   51,
       50,   49,  147,   36,   36,  147,  147,  147,  147,   94,
      100,  100,  147,  147,  147,  101,  101,  101,  101,  147,
       55,  147,  147,   56,  147,  147,  147,  147,  147,  101,
       55,   56,  102,  102,  147,  147,  147,  102,  102,  102,

      102,  147,  147,  147,  147,  147,  147,  147,  147,  147,
      147,  102,  104,  104,  147,  147,  147,  105,  105,  105,
      105,  147,   55,  147,  147,   56,  147,  147,  147,  147,
      147,  105,   55,   56,  106,  106,  147,  147,  147,  106,
      106,  106,  106,  147,  147,  147,  147,  147,  147,  147,
      147,  147,  147,  106,  108,  108,  147,  147,  147,  109,
      109,  109,  109,  147,   55,  147,  147,   56,  147,  147,
      147,  147,  147,  109,   55,   56,  110,  110,  147,  147,
      147,  110,  110,  110,  110,  147,  147,  147,  147,  147,
      147,  147,  147,  147,  147,  110,  112,  112,  147,  147,

      147,  113,  113,  113,  113,  147,   55,  147,  147,   56,
      147,  147,  147,  147,  147,  113,   55,   56,  114,  114,
      147,  147,  147,  114,  114,  114,  114,  147,  147,  147,
      147,  147,  147,  147,  147,  147,  147,  114,  116,  147,
      117,  117,  147,  147,  147,  147,  147,  147,  147,  147,
       55,  147,  147,   56,  147,  147,  147,  147,  147,  147,
       55,   56,   35,   35,   35,   35,   46,   46,   46,   46,
       63,   63,   70,  147,   70,   70,   77,  147,   77,   77,
       13,  147,  147,  147,  147,  147,  147,  147,  147,  147,
      147,  147,  147,  147,  147,  147,  147,  147,  147,  147,

      147,  147,  147,  147,  147,  147,  147,  147,  147,  147,
      147,  147,  147,  147,  147,  147,  147
    } ;

static yyconst flex_int16_t yy_chk[518] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    2,    3,   38,    3,
        2,    4,    5,    4,    5,    6,    8,    6,   11,   12,
        8,   24,   41,   11,   12,   25,   25,   27,   27,   24,
       41,   33,   67,   38,    3,   33,   67,   48,    4,    5,
       53,   53,    6,    7,    7,   11,   12,  183,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,   48,
      182,    7,    7,    7,    7,    7,   23,   23,   23,   56,

       55,   95,   95,   90,  181,   80,   80,   23,   55,   56,
       23,   23,   80,   90,   89,  180,  115,   23,   23,   23,
       40,   40,   89,  115,   80,   40,   40,   40,   40,  118,
       40,  179,  178,   40,   40,   83,  118,  177,   83,   40,
       40,   40,   40,   42,   42,   83,   83,  176,   42,   42,
       42,   42,   42,   42,   42,   42,   42,   42,   42,  175,
      174,  173,   42,   42,   42,   42,   43,   43,  172,  171,
      170,   43,   43,   43,   43,   88,   88,  169,   88,   88,
      168,   96,   96,  167,  166,   43,   73,   73,   96,  165,
      164,   73,   73,   73,   73,  163,   73,  162,  161,   73,

       96,  160,  159,  158,  157,   73,   73,   73,   75,   75,
      156,  155,  154,   75,   75,   75,   75,  153,  133,  128,
      123,  117,  114,  113,  111,  107,  103,   75,   85,   85,
       99,   91,   84,   85,   85,   85,   85,   69,   85,   68,
       65,   85,   52,   44,   34,   32,   30,   85,   85,   85,
       87,   87,   29,   26,   22,   87,   87,   87,   87,   21,
       19,   17,   13,   10,    9,    0,    0,    0,    0,   87,
       92,   92,    0,    0,    0,   92,   92,   92,   92,    0,
       92,    0,    0,   92,    0,    0,    0,    0,    0,   92,
       92,   92,   94,   94,    0,    0,    0,   94,   94,   94,

       94,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,   94,  100,  100,    0,    0,    0,  100,  100,  100,
      100,    0,  100,    0,    0,  100,    0,    0,    0,    0,
        0,  100,  100,  100,  102,  102,    0,    0,    0,  102,
      102,  102,  102,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  102,  104,  104,    0,    0,    0,  104,
      104,  104,  104,    0,  104,    0,    0,  104,    0,    0,
        0,    0,    0,  104,  104,  104,  106,  106,    0,    0,
        0,  106,  106,  106,  106,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  106,  108,  108,    0,    0,

        0,  108,  108,  108,  108,    0,  108,    0,    0,  108,
        0,    0,    0,    0,    0,  108,  108,  108,  110,  110,
        0,    0,    0,  110,  110,  110,  110,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  110,  112,    0,
      112,  112,    0,    0,    0,    0,    0,    0,    0,    0,
      112,    0,    0,  112,    0,    0,    0,    0,    0,    0,
      112,  112,  148,  148,  148,  148,  149,  149,  149,  149,
      150,  150,  151,    0,  151,  151,  152,    0,  152,  152,
      147,  147,  147,  147,  147,  147,  147,  147,  147,  147,
      147,  147,  147,  147,  147,  147,  147,  147,  147,  147,

      147,  147,  147,  147,  147,  147,  147,  147,  147,  147,
      147,  147,  147,  147,  147,  147,  147
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int parser__flex_debug;
int parser__flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *parser_text;
#line 1 "parser.l"
/* -*-C-*-
 * IDL Compiler
 *
 * Copyright 2002 Ove Kaaven
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */
#define YY_NO_INPUT 1





#line 43 "parser.l"

#include "config.h"
#include "wine/port.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>
#include <errno.h>
#include <limits.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#else
#define YY_NO_UNISTD_H
#endif

#include "widl.h"
#include "utils.h"
#include "parser.h"
#include "wine/wpp.h"

#include "parser.tab.h"

static void addcchar(char c);
static char *get_buffered_cstring(void);

static char *cbuffer;
static int cbufidx;
static int cbufalloc = 0;

static int kw_token(const char *kw);
static int attr_token(const char *kw);

#define MAX_IMPORT_DEPTH 10
struct {
  YY_BUFFER_STATE state;
  char *input_name;
  int   line_number;
  char *temp_name;
} import_stack[MAX_IMPORT_DEPTH];
int import_stack_ptr = 0;

/* converts an integer in string form to an unsigned long and prints an error
 * on overflow */
static unsigned int xstrtoul(const char *nptr, char **endptr, int base)
{
#if defined(__MINGW32__) || defined(_MSC_VER)
  unsigned long long val;

  errno = 0;
  val = strtoull (nptr, endptr, base);
  if ((val == ULONG_LONG_MAX && errno == ERANGE) || ((unsigned int)val != val))
    error_loc("integer constant %s is too large\n", nptr);
  return (unsigned int) val;
#else
    unsigned long val;

    errno = 0;
    val = strtoul(nptr, endptr, base);
    if ((val == ULONG_MAX && errno == ERANGE) || ((unsigned int)val != val))
        error_loc("integer constant %s is too large\n", nptr);
    return val;
#endif
}

UUID *parse_uuid(const char *u)
{
  UUID* uuid = xmalloc(sizeof(UUID));
  char b[3];
  /* it would be nice to use UuidFromStringA */
  uuid->Data1 = strtoul(u, NULL, 16);
  uuid->Data2 = strtoul(u+9, NULL, 16);
  uuid->Data3 = strtoul(u+14, NULL, 16);
  b[2] = 0;
  memcpy(b, u+19, 2); uuid->Data4[0] = strtoul(b, NULL, 16);
  memcpy(b, u+21, 2); uuid->Data4[1] = strtoul(b, NULL, 16);
  memcpy(b, u+24, 2); uuid->Data4[2] = strtoul(b, NULL, 16);
  memcpy(b, u+26, 2); uuid->Data4[3] = strtoul(b, NULL, 16);
  memcpy(b, u+28, 2); uuid->Data4[4] = strtoul(b, NULL, 16);
  memcpy(b, u+30, 2); uuid->Data4[5] = strtoul(b, NULL, 16);
  memcpy(b, u+32, 2); uuid->Data4[6] = strtoul(b, NULL, 16);
  memcpy(b, u+34, 2); uuid->Data4[7] = strtoul(b, NULL, 16);
  return uuid;
}

/*
 **************************************************************************
 * The flexer starts here
 **************************************************************************
 */
#line 755 "parser.yy.c"

#define INITIAL 0
#define QUOTE 1
#define WSTRQUOTE 2
#define ATTR 3
#define PP_LINE 4
#define SQUOTE 5

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int parser_lex_destroy (void );

int parser_get_debug (void );

void parser_set_debug (int debug_flag  );

YY_EXTRA_TYPE parser_get_extra (void );

void parser_set_extra (YY_EXTRA_TYPE user_defined  );

FILE *parser_get_in (void );

void parser_set_in  (FILE * in_str  );

FILE *parser_get_out (void );

void parser_set_out  (FILE * out_str  );

int parser_get_leng (void );

char *parser_get_text (void );

int parser_get_lineno (void );

void parser_set_lineno (int line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int parser_wrap (void );
#else
extern int parser_wrap (void );
#endif
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

        static int yy_start_stack_ptr = 0;
        static int yy_start_stack_depth = 0;
        static int *yy_start_stack = NULL;
    
    static void yy_push_state (int new_state );
    
    static void yy_pop_state (void );
    
/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO fwrite( parser_text, parser_leng, 1, parser_out )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( parser_in )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( parser_in ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, parser_in))==0 && ferror(parser_in)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(parser_in); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int parser_lex (void);

#define YY_DECL int parser_lex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after parser_text and parser_leng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	if ( parser_leng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->yy_at_bol = \
				(parser_text[parser_leng - 1] == '\n'); \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
#line 137 "parser.l"

#line 953 "parser.yy.c"

	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! parser_in )
			parser_in = stdin;

		if ( ! parser_out )
			parser_out = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			parser_ensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				parser__create_buffer(parser_in,YY_BUF_SIZE );
		}

		parser__load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of parser_text. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
		yy_current_state += YY_AT_BOL();
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 148 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 147 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 138 "parser.l"
yy_push_state(PP_LINE);
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 139 "parser.l"
{
                            int lineno;
                            char *cptr, *fname;
                            yy_pop_state();
                            lineno = (int)strtol(parser_text, &cptr, 10);
                            if(!lineno)
                                error_loc("Malformed '#...' line-directive; invalid linenumber\n");
                            fname = strchr(cptr, '"');
                            if(!fname)
                                error_loc("Malformed '#...' line-directive; missing filename\n");
                            fname++;
                            cptr = strchr(fname, '"');
                            if(!cptr)
                                error_loc("Malformed '#...' line-directive; missing terminating \"\n");
                            *cptr = '\0';
                            line_number = lineno - 1;  /* We didn't read the newline */
                            input_name = xstrdup(fname);
                        }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 157 "parser.l"
yy_push_state(QUOTE); cbufidx = 0;
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 158 "parser.l"
{
				yy_pop_state();
				parser_lval.str = get_buffered_cstring();
				return aSTRING;
			}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 163 "parser.l"
yy_push_state(WSTRQUOTE); cbufidx = 0;
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 164 "parser.l"
{
				yy_pop_state();
				parser_lval.str = get_buffered_cstring();
				return aWSTRING;
			}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 169 "parser.l"
yy_push_state(SQUOTE); cbufidx = 0;
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 170 "parser.l"
{
				yy_pop_state();
				parser_lval.str = get_buffered_cstring();
				return aSQSTRING;
			}
	YY_BREAK
case 9:
#line 176 "parser.l"
case 10:
YY_RULE_SETUP
#line 176 "parser.l"
addcchar(parser_text[1]);
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 177 "parser.l"
addcchar(parser_text[1]);
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 178 "parser.l"
addcchar('\\'); addcchar(parser_text[1]);
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 179 "parser.l"
addcchar(parser_text[0]);
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 180 "parser.l"
yy_push_state(ATTR); return '[';
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 181 "parser.l"
yy_pop_state(); return ']';
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 182 "parser.l"
return attr_token(parser_text);
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 183 "parser.l"
{
				parser_lval.uuid = parse_uuid(parser_text);
				return aUUID;
			}
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 187 "parser.l"
{
				parser_lval.num = xstrtoul(parser_text, NULL, 0);
				return aHEXNUM;
			}
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 191 "parser.l"
{
				parser_lval.num = xstrtoul(parser_text, NULL, 0);
				return aNUM;
			}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 195 "parser.l"
{
				parser_lval.dbl = strtod(parser_text, NULL);
				return aDOUBLE;
			}
	YY_BREAK
case 21:
*yy_cp = (yy_hold_char); /* undo effects of setting up parser_text */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up parser_text again */
YY_RULE_SETUP
#line 199 "parser.l"
return tSAFEARRAY;
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 200 "parser.l"
return kw_token(parser_text);
	YY_BREAK
case 23:
/* rule 23 can match eol */
YY_RULE_SETUP
#line 201 "parser.l"
line_number++;
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 202 "parser.l"

	YY_BREAK
case 25:
YY_RULE_SETUP
#line 203 "parser.l"
return SHL;
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 204 "parser.l"
return SHR;
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 205 "parser.l"
return MEMBERPTR;
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 206 "parser.l"
return EQUALITY;
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 207 "parser.l"
return INEQUALITY;
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 208 "parser.l"
return GREATEREQUAL;
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 209 "parser.l"
return LESSEQUAL;
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 210 "parser.l"
return LOGICALOR;
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 211 "parser.l"
return LOGICALAND;
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 212 "parser.l"
return ELLIPSIS;
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 213 "parser.l"
return parser_text[0];
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(QUOTE):
case YY_STATE_EOF(WSTRQUOTE):
case YY_STATE_EOF(ATTR):
case YY_STATE_EOF(PP_LINE):
case YY_STATE_EOF(SQUOTE):
#line 214 "parser.l"
{
				if (import_stack_ptr)
					return aEOF;
				else yyterminate();
			}
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 219 "parser.l"
ECHO;
	YY_BREAK
#line 1268 "parser.yy.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed parser_in at a new source and called
			 * parser_lex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = parser_in;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( parser_wrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * parser_text, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of parser_lex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					parser_realloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), (size_t) num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			parser_restart(parser_in  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) ((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) parser_realloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);
	yy_current_state += YY_AT_BOL();

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 148 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 148 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 147);

	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					parser_restart(parser_in );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( parser_wrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve parser_text */
	(yy_hold_char) = *++(yy_c_buf_p);

	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = (c == '\n');

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void parser_restart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        parser_ensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            parser__create_buffer(parser_in,YY_BUF_SIZE );
	}

	parser__init_buffer(YY_CURRENT_BUFFER,input_file );
	parser__load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void parser__switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		parser_pop_buffer_state();
	 *		parser_push_buffer_state(new_buffer);
     */
	parser_ensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	parser__load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (parser_wrap()) processing, but the only time this flag
	 * is looked at is after parser_wrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void parser__load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	parser_in = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE parser__create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) parser_alloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in parser__create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) parser_alloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in parser__create_buffer()" );

	b->yy_is_our_buffer = 1;

	parser__init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with parser__create_buffer()
 * 
 */
    void parser__delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		parser_free((void *) b->yy_ch_buf  );

	parser_free((void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a parser_restart() or at EOF.
 */
    static void parser__init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	parser__flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then parser__init_buffer was _probably_
     * called from parser_restart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void parser__flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		parser__load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void parser_push_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	parser_ensure_buffer_stack();

	/* This block is copied from parser__switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from parser__switch_to_buffer. */
	parser__load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void parser_pop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	parser__delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		parser__load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void parser_ensure_buffer_stack (void)
{
	int num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)parser_alloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in parser_ensure_buffer_stack()" );
								  
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)parser_realloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in parser_ensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE parser__scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) parser_alloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in parser__scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	parser__switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to parser_lex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       parser__scan_bytes() instead.
 */
YY_BUFFER_STATE parser__scan_string (yyconst char * yystr )
{
    
	return parser__scan_bytes(yystr,strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to parser_lex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE parser__scan_bytes  (yyconst char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) parser_alloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in parser__scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = parser__scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in parser__scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

    static void yy_push_state (int  new_state )
{
    	if ( (yy_start_stack_ptr) >= (yy_start_stack_depth) )
		{
		yy_size_t new_size;

		(yy_start_stack_depth) += YY_START_STACK_INCR;
		new_size = (yy_start_stack_depth) * sizeof( int );

		if ( ! (yy_start_stack) )
			(yy_start_stack) = (int *) parser_alloc(new_size  );

		else
			(yy_start_stack) = (int *) parser_realloc((void *) (yy_start_stack),new_size  );

		if ( ! (yy_start_stack) )
			YY_FATAL_ERROR( "out of memory expanding start-condition stack" );
		}

	(yy_start_stack)[(yy_start_stack_ptr)++] = YY_START;

	BEGIN(new_state);
}

    static void yy_pop_state  (void)
{
    	if ( --(yy_start_stack_ptr) < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN((yy_start_stack)[(yy_start_stack_ptr)]);
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up parser_text. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		parser_text[parser_leng] = (yy_hold_char); \
		(yy_c_buf_p) = parser_text + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		parser_leng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int parser_get_lineno  (void)
{
        
    return parser_lineno;
}

/** Get the input stream.
 * 
 */
FILE *parser_get_in  (void)
{
        return parser_in;
}

/** Get the output stream.
 * 
 */
FILE *parser_get_out  (void)
{
        return parser_out;
}

/** Get the length of the current token.
 * 
 */
int parser_get_leng  (void)
{
        return parser_leng;
}

/** Get the current token.
 * 
 */

char *parser_get_text  (void)
{
        return parser_text;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void parser_set_lineno (int  line_number )
{
    
    parser_lineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see parser__switch_to_buffer
 */
void parser_set_in (FILE *  in_str )
{
        parser_in = in_str ;
}

void parser_set_out (FILE *  out_str )
{
        parser_out = out_str ;
}

int parser_get_debug  (void)
{
        return parser__flex_debug;
}

void parser_set_debug (int  bdebug )
{
        parser__flex_debug = bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from parser_lex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

    (yy_start_stack_ptr) = 0;
    (yy_start_stack_depth) = 0;
    (yy_start_stack) =  NULL;

/* Defined in main.c */
#ifdef YY_STDINIT
    parser_in = stdin;
    parser_out = stdout;
#else
    parser_in = (FILE *) 0;
    parser_out = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * parser_lex_init()
     */
    return 0;
}

/* parser_lex_destroy is for both reentrant and non-reentrant scanners. */
int parser_lex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		parser__delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		parser_pop_buffer_state();
	}

	/* Destroy the stack itself. */
	parser_free((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Destroy the start condition stack. */
        parser_free((yy_start_stack)  );
        (yy_start_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * parser_lex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *parser_alloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *parser_realloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void parser_free (void * ptr )
{
	free( (char *) ptr );	/* see parser_realloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 219 "parser.l"



#ifndef parser_wrap
int parser_wrap(void)
{
	return 1;
}
#endif

struct keyword {
	const char *kw;
	int token;
};

/* This table MUST be alphabetically sorted on the kw field */
static const struct keyword keywords[] = {
	{"FALSE",			tFALSE},
	{"NULL",			tNULL},
	{"TRUE",			tTRUE},
	{"__cdecl",			tCDECL},
	{"__fastcall",			tFASTCALL},
	{"__int3264",			tINT3264},
	{"__int64",			tINT64},
	{"__pascal",			tPASCAL},
	{"__stdcall",			tSTDCALL},
	{"_cdecl",			tCDECL},
	{"_fastcall",			tFASTCALL},
	{"_pascal",			tPASCAL},
	{"_stdcall",			tSTDCALL},
	{"boolean",			tBOOLEAN},
	{"byte",			tBYTE},
	{"case",			tCASE},
	{"cdecl",			tCDECL},
	{"char",			tCHAR},
	{"coclass",			tCOCLASS},
	{"const",			tCONST},
	{"cpp_quote",			tCPPQUOTE},
	{"default",			tDEFAULT},
	{"dispinterface",		tDISPINTERFACE},
	{"double",			tDOUBLE},
	{"enum",			tENUM},
	{"error_status_t",		tERRORSTATUST},
	{"extern",			tEXTERN},
	{"float",			tFLOAT},
	{"handle_t",			tHANDLET},
	{"hyper",			tHYPER},
	{"import",			tIMPORT},
	{"importlib",			tIMPORTLIB},
	{"inline",			tINLINE},
	{"int",				tINT},
	{"interface",			tINTERFACE},
	{"library",			tLIBRARY},
	{"long",			tLONG},
	{"methods",			tMETHODS},
	{"module",			tMODULE},
	{"namespace",			tNAMESPACE},
	{"pascal",			tPASCAL},
	{"properties",			tPROPERTIES},
	{"register",			tREGISTER},
	{"short",			tSHORT},
	{"signed",			tSIGNED},
	{"sizeof",			tSIZEOF},
        {"small",			tSMALL},
	{"static",			tSTATIC},
	{"stdcall",			tSTDCALL},
	{"struct",			tSTRUCT},
	{"switch",			tSWITCH},
	{"typedef",			tTYPEDEF},
	{"union",			tUNION},
	{"unsigned",			tUNSIGNED},
	{"void",			tVOID},
	{"wchar_t",			tWCHAR},
};
#define NKEYWORDS (sizeof(keywords)/sizeof(keywords[0]))

/* keywords only recognized in attribute lists
 * This table MUST be alphabetically sorted on the kw field
 */
static const struct keyword attr_keywords[] =
{
        {"aggregatable",                tAGGREGATABLE},
        {"allocate",                    tALLOCATE},
        {"annotation",                  tANNOTATION},
        {"apartment",                   tAPARTMENT},
        {"appobject",                   tAPPOBJECT},
        {"async",                       tASYNC},
        {"async_uuid",                  tASYNCUUID},
        {"auto_handle",                 tAUTOHANDLE},
        {"bindable",                    tBINDABLE},
        {"both",                        tBOTH},
        {"broadcast",                   tBROADCAST},
        {"byte_count",                  tBYTECOUNT},
        {"call_as",                     tCALLAS},
        {"callback",                    tCALLBACK},
        {"code",                        tCODE},
        {"comm_status",                 tCOMMSTATUS},
        {"context_handle",              tCONTEXTHANDLE},
        {"context_handle_noserialize",  tCONTEXTHANDLENOSERIALIZE},
        {"context_handle_serialize",    tCONTEXTHANDLENOSERIALIZE},
        {"control",                     tCONTROL},
        {"decode",                      tDECODE},
        {"defaultbind",                 tDEFAULTBIND},
        {"defaultcollelem",             tDEFAULTCOLLELEM},
        {"defaultvalue",                tDEFAULTVALUE},
        {"defaultvtable",               tDEFAULTVTABLE},
        {"disable_consistency_check",   tDISABLECONSISTENCYCHECK},
        {"displaybind",                 tDISPLAYBIND},
        {"dllname",                     tDLLNAME},
        {"dual",                        tDUAL},
        {"enable_allocate",             tENABLEALLOCATE},
        {"encode",                      tENCODE},
        {"endpoint",                    tENDPOINT},
        {"entry",                       tENTRY},
        {"explicit_handle",             tEXPLICITHANDLE},
        {"fault_status",                tFAULTSTATUS},
        {"force_allocate",              tFORCEALLOCATE},
        {"free",                        tFREE},
        {"handle",                      tHANDLE},
        {"helpcontext",                 tHELPCONTEXT},
        {"helpfile",                    tHELPFILE},
        {"helpstring",                  tHELPSTRING},
        {"helpstringcontext",           tHELPSTRINGCONTEXT},
        {"helpstringdll",               tHELPSTRINGDLL},
        {"hidden",                      tHIDDEN},
        {"id",                          tID},
        {"idempotent",                  tIDEMPOTENT},
        {"ignore",                      tIGNORE},
        {"iid_is",                      tIIDIS},
        {"immediatebind",               tIMMEDIATEBIND},
        {"implicit_handle",             tIMPLICITHANDLE},
        {"in",                          tIN},
        {"in_line",                     tIN_LINE},
        {"input_sync",                  tINPUTSYNC},
        {"lcid",                        tLCID},
        {"length_is",                   tLENGTHIS},
        {"licensed",                    tLICENSED},
        {"local",                       tLOCAL},
        {"maybe",                       tMAYBE},
        {"message",                     tMESSAGE},
        {"neutral",                     tNEUTRAL},
        {"nocode",                      tNOCODE},
        {"nonbrowsable",                tNONBROWSABLE},
        {"noncreatable",                tNONCREATABLE},
        {"nonextensible",               tNONEXTENSIBLE},
        {"notify",                      tNOTIFY},
        {"notify_flag",                 tNOTIFYFLAG},
        {"object",                      tOBJECT},
        {"odl",                         tODL},
        {"oleautomation",               tOLEAUTOMATION},
        {"optimize",                    tOPTIMIZE},
        {"optional",                    tOPTIONAL},
        {"out",                         tOUT},
        {"partial_ignore",              tPARTIALIGNORE},
        {"pointer_default",             tPOINTERDEFAULT},
        {"progid",                      tPROGID},
        {"propget",                     tPROPGET},
        {"propput",                     tPROPPUT},
        {"propputref",                  tPROPPUTREF},
        {"proxy",                       tPROXY},
        {"ptr",                         tPTR},
        {"public",                      tPUBLIC},
        {"range",                       tRANGE},
        {"readonly",                    tREADONLY},
        {"ref",                         tREF},
        {"represent_as",                tREPRESENTAS},
        {"requestedit",                 tREQUESTEDIT},
        {"restricted",                  tRESTRICTED},
        {"retval",                      tRETVAL},
        {"single",                      tSINGLE},
        {"size_is",                     tSIZEIS},
        {"source",                      tSOURCE},
        {"strict_context_handle",       tSTRICTCONTEXTHANDLE},
        {"string",                      tSTRING},
        {"switch_is",                   tSWITCHIS},
        {"switch_type",                 tSWITCHTYPE},
        {"threading",                   tTHREADING},
        {"transmit_as",                 tTRANSMITAS},
        {"uidefault",                   tUIDEFAULT},
        {"unique",                      tUNIQUE},
        {"user_marshal",                tUSERMARSHAL},
        {"usesgetlasterror",            tUSESGETLASTERROR},
        {"uuid",                        tUUID},
        {"v1_enum",                     tV1ENUM},
        {"vararg",                      tVARARG},
        {"version",                     tVERSION},
        {"vi_progid",                   tVIPROGID},
        {"wire_marshal",                tWIREMARSHAL},
};

/* attributes TODO:
    custom
    first_is
    last_is
    max_is
    min_is
*/

#define KWP(p) ((const struct keyword *)(p))

static int kw_cmp_func(const void *s1, const void *s2)
{
	return strcmp(KWP(s1)->kw, KWP(s2)->kw);
}

static int kw_token(const char *kw)
{
	struct keyword key, *kwp;
	key.kw = kw;
	kwp = bsearch(&key, keywords, NKEYWORDS, sizeof(keywords[0]), kw_cmp_func);
	if (kwp && (flag_is_rt || kwp->token != tNAMESPACE)) {
		parser_lval.str = xstrdup(kwp->kw);
		return kwp->token;
	}
	parser_lval.str = xstrdup(kw);
	return is_type(kw) ? aKNOWNTYPE : aIDENTIFIER;
}

static int attr_token(const char *kw)
{
        struct keyword key, *kwp;
        key.kw = kw;
        kwp = bsearch(&key, attr_keywords, sizeof(attr_keywords)/sizeof(attr_keywords[0]),
                      sizeof(attr_keywords[0]), kw_cmp_func);
        if (kwp) {
            parser_lval.str = xstrdup(kwp->kw);
            return kwp->token;
        }
        return kw_token(kw);
}

static void addcchar(char c)
{
	if(cbufidx >= cbufalloc)
	{
		cbufalloc += 1024;
		cbuffer = xrealloc(cbuffer, cbufalloc * sizeof(cbuffer[0]));
		if(cbufalloc > 65536)
			parser_warning("Reallocating string buffer larger than 64kB\n");
	}
	cbuffer[cbufidx++] = c;
}

static char *get_buffered_cstring(void)
{
	addcchar(0);
	return xstrdup(cbuffer);
}

void pop_import(void)
{
	int ptr = import_stack_ptr-1;

	fclose(parser_in);
	parser__delete_buffer(YY_CURRENT_BUFFER );
	parser__switch_to_buffer(import_stack[ptr].state );
	if (temp_name) {
		unlink(temp_name);
		free(temp_name);
	}
	temp_name = import_stack[ptr].temp_name;
	input_name = import_stack[ptr].input_name;
	line_number = import_stack[ptr].line_number;
	import_stack_ptr--;
}

struct imports {
	char *name;
	struct imports *next;
} *first_import;

int do_import(char *fname)
{
	FILE *f;
	char *path, *name;
	struct imports *import;
	int ptr = import_stack_ptr;
	int ret, fd;

	import = first_import;
	while (import && strcmp(import->name, fname))
		import = import->next;
	if (import) return 0; /* already imported */

	import = xmalloc(sizeof(struct imports));
	import->name = xstrdup(fname);
	import->next = first_import;
	first_import = import;

        /* don't search for a file name with a path in the include directories,
         * for compatibility with MIDL */
        if (strchr( fname, '/' ) || strchr( fname, '\\' ))
            path = xstrdup( fname );
        else if (!(path = wpp_find_include( fname, input_name )))
            error_loc("Unable to open include file %s\n", fname);

	import_stack[ptr].temp_name = temp_name;
	import_stack[ptr].input_name = input_name;
	import_stack[ptr].line_number = line_number;
	import_stack_ptr++;
        input_name = path;
        line_number = 1;

        name = xstrdup( "widl.XXXXXX" );
        if((fd = mkstemps( name, 0 )) == -1)
            error("Could not generate a temp name from %s\n", name);

        temp_name = name;
        if (!(f = fdopen(fd, "wt")))
            error("Could not open fd %s for writing\n", name);

        ret = wpp_parse( path, f );
        fclose( f );
        if (ret) exit(1);

	if((f = fopen(temp_name, "r")) == NULL)
		error_loc("Unable to open %s\n", temp_name);

	import_stack[ptr].state = YY_CURRENT_BUFFER;
	parser__switch_to_buffer(parser__create_buffer(f,YY_BUF_SIZE));
	return 1;
}

void abort_import(void)
{
	int ptr;

	for (ptr=0; ptr<import_stack_ptr; ptr++)
		unlink(import_stack[ptr].temp_name);
}

